
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the sltiu instruction of the RISC-V I extension for the sltiu covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",sltiu)

RVTEST_SIGBASE( x12,signature_x12_1)

inst_0:
// rs1 == rd, rs1==x17, rd==x17, imm_val == 0, 
// opcode: sltiu ; op1:x17; dest:x17; op1val:0xe;  immval:0x0
TEST_IMM_OP( sltiu, x17, x17, 0x0, 0xe, 0x0, x12, 0, x20)

inst_1:
// rs1 != rd, rs1==x8, rd==x4, imm_val == (2**(12)-1), rs1_val == 18446744073708503039, rs1_val != imm_val and rs1_val > 0 and imm_val > 0
// opcode: sltiu ; op1:x8; dest:x4; op1val:0xffffffffffefffff;  immval:0xfff
TEST_IMM_OP( sltiu, x4, x8, 0x1, 0xffffffffffefffff, 0xfff, x12, 8, x20)

inst_2:
// rs1==x18, rd==x14, imm_val == 1, rs1_val==0 and imm_val==1, rs1_val == 0
// opcode: sltiu ; op1:x18; dest:x14; op1val:0x0;  immval:0x1
TEST_IMM_OP( sltiu, x14, x18, 0x1, 0x0, 0x1, x12, 16, x20)

inst_3:
// rs1==x25, rd==x23, rs1_val == (2**(xlen)-1), 
// opcode: sltiu ; op1:x25; dest:x23; op1val:0xffffffffffffffff;  immval:0xe
TEST_IMM_OP( sltiu, x23, x25, 0x0, 0xffffffffffffffff, 0xe, x12, 24, x20)

inst_4:
// rs1==x30, rd==x15, rs1_val == 1, imm_val == 2047
// opcode: sltiu ; op1:x30; dest:x15; op1val:0x1;  immval:0x7ff
TEST_IMM_OP( sltiu, x15, x30, 0x1, 0x1, 0x7ff, x12, 32, x20)

inst_5:
// rs1==x9, rd==x21, rs1_val == imm_val and rs1_val > 0 and imm_val > 0, rs1_val==1 and imm_val==1
// opcode: sltiu ; op1:x9; dest:x21; op1val:0x1;  immval:0x1
TEST_IMM_OP( sltiu, x21, x9, 0x0, 0x1, 0x1, x12, 40, x20)

inst_6:
// rs1==x26, rd==x9, imm_val == 2, rs1_val==0 and imm_val==2
// opcode: sltiu ; op1:x26; dest:x9; op1val:0x0;  immval:0x2
TEST_IMM_OP( sltiu, x9, x26, 0x1, 0x0, 0x2, x12, 48, x20)

inst_7:
// rs1==x7, rd==x16, imm_val == 4, rs1_val == 18446744073709535231
// opcode: sltiu ; op1:x7; dest:x16; op1val:0xffffffffffffbfff;  immval:0x4
TEST_IMM_OP( sltiu, x16, x7, 0x0, 0xffffffffffffbfff, 0x4, x12, 56, x20)

inst_8:
// rs1==x19, rd==x7, imm_val == 8, rs1_val == 34359738368
// opcode: sltiu ; op1:x19; dest:x7; op1val:0x800000000;  immval:0x8
TEST_IMM_OP( sltiu, x7, x19, 0x0, 0x800000000, 0x8, x12, 64, x20)

inst_9:
// rs1==x27, rd==x3, imm_val == 16, 
// opcode: sltiu ; op1:x27; dest:x3; op1val:0x0;  immval:0x10
TEST_IMM_OP( sltiu, x3, x27, 0x1, 0x0, 0x10, x12, 72, x20)

inst_10:
// rs1==x28, rd==x26, imm_val == 32, 
// opcode: sltiu ; op1:x28; dest:x26; op1val:0xffffffffffffffff;  immval:0x20
TEST_IMM_OP( sltiu, x26, x28, 0x0, 0xffffffffffffffff, 0x20, x12, 80, x20)

inst_11:
// rs1==x13, rd==x30, imm_val == 64, rs1_val == 12297829382473034410, rs1_val==12297829382473034410 and imm_val==64
// opcode: sltiu ; op1:x13; dest:x30; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x40
TEST_IMM_OP( sltiu, x30, x13, 0x0, 0xaaaaaaaaaaaaaaaa, 0x40, x12, 88, x20)

inst_12:
// rs1==x16, rd==x0, imm_val == 128, rs1_val == 17179869184
// opcode: sltiu ; op1:x16; dest:x0; op1val:0x400000000;  immval:0x80
TEST_IMM_OP( sltiu, x0, x16, 0, 0x400000000, 0x80, x12, 96, x20)

inst_13:
// rs1==x11, rd==x25, imm_val == 256, 
// opcode: sltiu ; op1:x11; dest:x25; op1val:0x400000000;  immval:0x100
TEST_IMM_OP( sltiu, x25, x11, 0x0, 0x400000000, 0x100, x12, 104, x20)

inst_14:
// rs1==x10, rd==x2, imm_val == 512, 
// opcode: sltiu ; op1:x10; dest:x2; op1val:0xffffffffffffbfff;  immval:0x200
TEST_IMM_OP( sltiu, x2, x10, 0x0, 0xffffffffffffbfff, 0x200, x12, 112, x20)

inst_15:
// rs1==x31, rd==x8, imm_val == 1024, rs1_val == 13835058055282163711
// opcode: sltiu ; op1:x31; dest:x8; op1val:0xbfffffffffffffff;  immval:0x400
TEST_IMM_OP( sltiu, x8, x31, 0x0, 0xbfffffffffffffff, 0x400, x12, 120, x20)

inst_16:
// rs1==x0, rd==x1, imm_val == 2048, rs1_val == 18446744073709549567
// opcode: sltiu ; op1:x0; dest:x1; op1val:0x0;  immval:0x800
TEST_IMM_OP( sltiu, x1, x0, 0x1, 0x0, 0x800, x12, 128, x20)

inst_17:
// rs1==x5, rd==x24, imm_val == 4094, 
// opcode: sltiu ; op1:x5; dest:x24; op1val:0x5555555555555556;  immval:0xffe
TEST_IMM_OP( sltiu, x24, x5, 0x1, 0x5555555555555556, 0xffe, x12, 136, x20)

inst_18:
// rs1==x3, rd==x6, imm_val == 4093, rs1_val == 18446744073709551607
// opcode: sltiu ; op1:x3; dest:x6; op1val:0xfffffffffffffff7;  immval:0xffd
TEST_IMM_OP( sltiu, x6, x3, 0x1, 0xfffffffffffffff7, 0xffd, x12, 144, x20)

inst_19:
// rs1==x2, rd==x28, imm_val == 4091, rs1_val == 18446735277616529407
// opcode: sltiu ; op1:x2; dest:x28; op1val:0xfffff7ffffffffff;  immval:0xffb
TEST_IMM_OP( sltiu, x28, x2, 0x1, 0xfffff7ffffffffff, 0xffb, x12, 152, x3)

inst_20:
// rs1==x21, rd==x5, imm_val == 4087, rs1_val == 274877906944
// opcode: sltiu ; op1:x21; dest:x5; op1val:0x4000000000;  immval:0xff7
TEST_IMM_OP( sltiu, x5, x21, 0x1, 0x4000000000, 0xff7, x12, 160, x3)

inst_21:
// rs1==x22, rd==x27, imm_val == 4079, rs1_val == 18446744073709551359
// opcode: sltiu ; op1:x22; dest:x27; op1val:0xfffffffffffffeff;  immval:0xfef
TEST_IMM_OP( sltiu, x27, x22, 0x1, 0xfffffffffffffeff, 0xfef, x12, 168, x3)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_22:
// rs1==x1, rd==x11, imm_val == 4063, rs1_val == 18444492273895866367
// opcode: sltiu ; op1:x1; dest:x11; op1val:0xfff7ffffffffffff;  immval:0xfdf
TEST_IMM_OP( sltiu, x11, x1, 0x1, 0xfff7ffffffffffff, 0xfdf, x2, 0, x3)

inst_23:
// rs1==x15, rd==x18, imm_val == 4031, rs1_val == 18446743523953737727
// opcode: sltiu ; op1:x15; dest:x18; op1val:0xffffff7fffffffff;  immval:0xfbf
TEST_IMM_OP( sltiu, x18, x15, 0x1, 0xffffff7fffffffff, 0xfbf, x2, 8, x3)

inst_24:
// rs1==x29, rd==x20, imm_val == 3967, rs1_val == 18446744073709543423
// opcode: sltiu ; op1:x29; dest:x20; op1val:0xffffffffffffdfff;  immval:0xf7f
TEST_IMM_OP( sltiu, x20, x29, 0x1, 0xffffffffffffdfff, 0xf7f, x2, 16, x3)

inst_25:
// rs1==x4, rd==x29, imm_val == 3839, rs1_val == 18446744073675997183
// opcode: sltiu ; op1:x4; dest:x29; op1val:0xfffffffffdffffff;  immval:0xeff
TEST_IMM_OP( sltiu, x29, x4, 0x1, 0xfffffffffdffffff, 0xeff, x2, 24, x3)

inst_26:
// rs1==x23, rd==x22, imm_val == 3583, rs1_val == 1099511627776
// opcode: sltiu ; op1:x23; dest:x22; op1val:0x10000000000;  immval:0xdff
TEST_IMM_OP( sltiu, x22, x23, 0x1, 0x10000000000, 0xdff, x2, 32, x3)

inst_27:
// rs1==x6, rd==x19, imm_val == 3071, rs1_val == 4611686018427387904
// opcode: sltiu ; op1:x6; dest:x19; op1val:0x4000000000000000;  immval:0xbff
TEST_IMM_OP( sltiu, x19, x6, 0x1, 0x4000000000000000, 0xbff, x2, 40, x3)

inst_28:
// rs1==x14, rd==x12, imm_val == 1365, 
// opcode: sltiu ; op1:x14; dest:x12; op1val:0xffffffffffffbfff;  immval:0x555
TEST_IMM_OP( sltiu, x12, x14, 0x0, 0xffffffffffffbfff, 0x555, x2, 48, x3)

inst_29:
// rs1==x12, rd==x31, imm_val == 2730, rs1_val==4 and imm_val==2730, rs1_val == 4
// opcode: sltiu ; op1:x12; dest:x31; op1val:0x4;  immval:0xaaa
TEST_IMM_OP( sltiu, x31, x12, 0x1, 0x4, 0xaaa, x2, 56, x3)

inst_30:
// rs1==x24, rd==x10, rs1_val == 2, rs1_val==2 and imm_val==62
// opcode: sltiu ; op1:x24; dest:x10; op1val:0x2;  immval:0x3e
TEST_IMM_OP( sltiu, x10, x24, 0x1, 0x2, 0x3e, x2, 64, x3)

inst_31:
// rs1==x20, rd==x13, rs1_val == 8, 
// opcode: sltiu ; op1:x20; dest:x13; op1val:0x8;  immval:0xa
TEST_IMM_OP( sltiu, x13, x20, 0x1, 0x8, 0xa, x2, 72, x3)

inst_32:
// rs1_val == 16, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10;  immval:0xc
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10, 0xc, x2, 80, x3)

inst_33:
// rs1_val == 32, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20;  immval:0xf
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x20, 0xf, x2, 88, x3)

inst_34:
// rs1_val == 64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x40;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x40, 0x1, x2, 96, x3)

inst_35:
// rs1_val == 128, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x80;  immval:0xd
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x80, 0xd, x2, 104, x3)

inst_36:
// rs1_val == 256, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100, 0x3, x2, 112, x3)

inst_37:
// rs1_val == 512, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x200;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x200, 0x3, x2, 120, x3)

inst_38:
// rs1_val == 1024, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x400;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x400, 0x332, x2, 128, x3)

inst_39:
// rs1_val == 2048, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x800;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x800, 0x4, x2, 136, x3)

inst_40:
// rs1_val == 4096, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1000;  immval:0xfbf
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1000, 0xfbf, x2, 144, x3)

inst_41:
// rs1_val == 8192, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2000;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2000, 0x6, x2, 152, x3)

inst_42:
// rs1_val == 16384, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4000;  immval:0xbff
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4000, 0xbff, x2, 160, x3)

inst_43:
// rs1_val == 32768, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8000;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x8000, 0x4, x2, 168, x3)

inst_44:
// rs1_val == 65536, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000, 0x0, x2, 176, x3)

inst_45:
// rs1_val == 131072, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20000;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x20000, 0xaab, x2, 184, x3)

inst_46:
// rs1_val == 262144, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x40000;  immval:0xfff
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x40000, 0xfff, x2, 192, x3)

inst_47:
// rs1_val == 524288, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x80000;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x80000, 0x3, x2, 200, x3)

inst_48:
// rs1_val == 1048576, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000, 0x2c, x2, 208, x3)

inst_49:
// rs1_val == 2097152, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x200000;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x200000, 0x1, x2, 216, x3)

inst_50:
// rs1_val == 4194304, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x400000;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x400000, 0xaab, x2, 224, x3)

inst_51:
// rs1_val == 8388608, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x800000;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x800000, 0x555, x2, 232, x3)

inst_52:
// rs1_val == 16777216, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1000000;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x1000000, 0x2e, x2, 240, x3)

inst_53:
// rs1_val == 33554432, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2000000;  immval:0xffd
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2000000, 0xffd, x2, 248, x3)

inst_54:
// rs1_val == 67108864, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4000000, 0x666, x2, 256, x3)

inst_55:
// rs1_val == 134217728, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x8000000, 0x0, x2, 264, x3)

inst_56:
// rs1_val == 268435456, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x200
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000000, 0x200, x2, 272, x3)

inst_57:
// rs1_val == 536870912, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x20000000, 0x40, x2, 280, x3)

inst_58:
// rs1_val == 1073741824, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x40000000, 0x556, x2, 288, x3)

inst_59:
// rs1_val == 2147483648, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x80000000;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x80000000, 0x6, x2, 296, x3)

inst_60:
// rs1_val == 4294967296, rs1_val==4294967296 and imm_val==64
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x40, x2, 304, x3)

inst_61:
// rs1_val == 8589934592, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x200000000;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x200000000, 0x1, x2, 312, x3)

inst_62:
// rs1_val == 68719476736, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0x7ff
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x1000000000, 0x7ff, x2, 320, x3)

inst_63:
// rs1_val == 137438953472, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2000000000;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2000000000, 0x2, x2, 328, x3)

inst_64:
// rs1_val == 549755813888, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x8000000000, 0x333, x2, 336, x3)

inst_65:
// rs1_val == 2199023255552, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20000000000;  immval:0x200
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x20000000000, 0x200, x2, 344, x3)

inst_66:
// rs1_val == 4398046511104, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x40000000000;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x40000000000, 0x2d, x2, 352, x3)

inst_67:
// rs1_val == 8796093022208, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x80000000000, 0x0, x2, 360, x3)

inst_68:
// rs1_val == 17592186044416, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000000;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100000000000, 0xaaa, x2, 368, x3)

inst_69:
// rs1_val == 35184372088832, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x200000000000, 0x333, x2, 376, x3)

inst_70:
// rs1_val == 70368744177664, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x400000000000, 0xaa9, x2, 384, x3)

inst_71:
// rs1_val == 140737488355328, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x13
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x800000000000, 0x13, x2, 392, x3)

inst_72:
// rs1_val == 281474976710656, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1000000000000, 0xaab, x2, 400, x3)

inst_73:
// rs1_val == 562949953421312, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x100
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2000000000000, 0x100, x2, 408, x3)

inst_74:
// rs1_val == 1125899906842624, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4000000000000, 0x4, x2, 416, x3)

inst_75:
// rs1_val == 2251799813685248, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x8000000000000, 0x2e, x2, 424, x3)

inst_76:
// rs1_val == 4503599627370496, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x10000000000000;  immval:0xd
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x10000000000000, 0xd, x2, 432, x3)

inst_77:
// rs1_val == 9007199254740992, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x20000000000000, 0x1, x2, 440, x3)

inst_78:
// rs1_val == 18014398509481984, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0x9
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x40000000000000, 0x9, x2, 448, x3)

inst_79:
// rs1_val == 36028797018963968, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x80000000000000, 0x2, x2, 456, x3)

inst_80:
// rs1_val == 72057594037927936, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0xb
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000000000, 0xb, x2, 464, x3)

inst_81:
// rs1_val == 144115188075855872, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:0xd
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x200000000000000, 0xd, x2, 472, x3)

inst_82:
// rs1_val == 288230376151711744, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0xffd
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x400000000000000, 0xffd, x2, 480, x3)

inst_83:
// rs1_val == 576460752303423488, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x800000000000000, 0x3f, x2, 488, x3)

inst_84:
// rs1_val == 1152921504606846976, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x11
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x1000000000000000, 0x11, x2, 496, x3)

inst_85:
// rs1_val == 2305843009213693952, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x400
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2000000000000000, 0x400, x2, 504, x3)

inst_86:
// rs1_val == 9223372036854775808, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x8000000000000000;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x8000000000000000, 0x0, x2, 512, x3)

inst_87:
// rs1_val == 18446744073709551614, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffffffe;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffffffffe, 0x6, x2, 520, x3)

inst_88:
// rs1_val == 18446744073709551613, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffffffd;  immval:0xa
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffffffffd, 0xa, x2, 528, x3)

inst_89:
// rs1_val == 18446744073709551611, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffffffb;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffffffffb, 0x1, x2, 536, x3)

inst_90:
// rs1_val == 18446744073709551599, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffffffef;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffffffffef, 0xaa9, x2, 544, x3)

inst_91:
// rs1_val == 18446744073709551583, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffffffdf;  immval:0xff7
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffffffffffffffdf, 0xff7, x2, 552, x3)

inst_92:
// rs1_val == 18446744073709551551, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffffffbf;  immval:0x20
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffffffffbf, 0x20, x2, 560, x3)

inst_93:
// rs1_val == 18446744073709551487, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffffff7f;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffffffff7f, 0x0, x2, 568, x3)

inst_94:
// rs1_val == 18446744073709551103, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffffdff;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffffffdff, 0x0, x2, 576, x3)

inst_95:
// rs1_val == 18446744073709550591, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffffbff;  immval:0xffb
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffffffffffffbff, 0xffb, x2, 584, x3)

inst_96:
// rs1_val == 18446744073709547519, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffffefff;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffffffefff, 0x2, x2, 592, x3)

inst_97:
// rs1_val == 18446744073709518847, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffff7fff;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffffff7fff, 0x5, x2, 600, x3)

inst_98:
// rs1_val == 18446744073709486079, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffeffff;  immval:0xfef
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffffffffffeffff, 0xfef, x2, 608, x3)

inst_99:
// rs1_val == 18446744073709420543, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffdffff;  immval:0xf7f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffffffffffdffff, 0xf7f, x2, 616, x3)

inst_100:
// rs1_val == 18446744073709289471, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffbffff;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffffbffff, 0x4, x2, 624, x3)

inst_101:
// rs1_val == 18446744073709027327, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffff7ffff;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffff7ffff, 0x5, x2, 632, x3)

inst_102:
// rs1_val == 18446744073707454463, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffdfffff;  immval:0xd
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffffdfffff, 0xd, x2, 640, x3)

inst_103:
// rs1_val == 18446744073705357311, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffffbfffff;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffffbfffff, 0x3f, x2, 648, x3)

inst_104:
// rs1_val == 18446744073701163007, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffff7fffff;  immval:0xeff
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffffffffff7fffff, 0xeff, x2, 656, x3)

inst_105:
// rs1_val == 18446744073692774399, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffeffffff;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffeffffff, 0x3, x2, 664, x3)

inst_106:
// rs1_val == 18446744073642442751, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffbffffff;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffffbffffff, 0x555, x2, 672, x3)

inst_107:
// rs1_val == 18446744073575333887, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffff7ffffff;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffff7ffffff, 0x1, x2, 680, x3)

inst_108:
// rs1_val == 18446744073441116159, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffefffffff;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffefffffff, 0x2d, x2, 688, x3)

inst_109:
// rs1_val == 18446744073172680703, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffdfffffff;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffdfffffff, 0x2, x2, 696, x3)

inst_110:
// rs1_val == 18446744072635809791, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffffbfffffff;  immval:0x7
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffffbfffffff, 0x7, x2, 704, x3)

inst_111:
// rs1_val == 18446744071562067967, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff7fffffff;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff7fffffff, 0x2d, x2, 712, x3)

inst_112:
// rs1_val == 18446744069414584319, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffeffffffff;  immval:0x80
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffeffffffff, 0x80, x2, 720, x3)

inst_113:
// rs1_val == 18446744065119617023, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffdffffffff;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffffffdffffffff, 0xaa9, x2, 728, x3)

inst_114:
// rs1_val == 18446744056529682431, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffbffffffff;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffffbffffffff, 0x2c, x2, 736, x3)

inst_115:
// rs1_val == 18446744039349813247, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffff7ffffffff;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffff7ffffffff, 0x40, x2, 744, x3)

inst_116:
// rs1_val == 18446744004990074879, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffefffffffff;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffefffffffff, 0x40, x2, 752, x3)

inst_117:
// rs1_val == 18446743936270598143, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffdfffffffff;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffdfffffffff, 0x0, x2, 760, x3)

inst_118:
// rs1_val == 18446743798831644671, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffbfffffffff;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffbfffffffff, 0x2, x2, 768, x3)

inst_119:
// rs1_val == 18446742974197923839, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffeffffffffff;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffeffffffffff, 0x4, x2, 776, x3)

inst_120:
// rs1_val == 18446741874686296063, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffdffffffffff;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffdffffffffff, 0x3f, x2, 784, x3)

inst_121:
// rs1_val == 18446739675663040511, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffbffffffffff;  immval:0xc
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffffbffffffffff, 0xc, x2, 792, x3)

inst_122:
// rs1_val == 18446726481523507199, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffefffffffffff;  immval:0x20
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffefffffffffff, 0x20, x2, 800, x3)

inst_123:
// rs1_val == 18446708889337462783, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffdfffffffffff;  immval:0xfdf
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffffdfffffffffff, 0xfdf, x2, 808, x3)

inst_124:
// rs1_val == 18446673704965373951, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffbfffffffffff;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffbfffffffffff, 0x2, x2, 816, x3)

inst_125:
// rs1_val == 18446603336221196287, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffff7fffffffffff;  immval:0x800
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffff7fffffffffff, 0x800, x2, 824, x3)

inst_126:
// rs1_val == 18446462598732840959, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffeffffffffffff;  immval:0x12
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffeffffffffffff, 0x12, x2, 832, x3)

inst_127:
// rs1_val == 18446181123756130303, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffdffffffffffff;  immval:0x12
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfffdffffffffffff, 0x12, x2, 840, x3)

inst_128:
// rs1_val == 18445618173802708991, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffbffffffffffff;  immval:0xfdf
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffbffffffffffff, 0xfdf, x2, 848, x3)

inst_129:
// rs1_val == 18442240474082181119, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffefffffffffffff;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffefffffffffffff, 0x333, x2, 856, x3)

inst_130:
// rs1_val == 18437736874454810623, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffdfffffffffffff;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffdfffffffffffff, 0x4, x2, 864, x3)

inst_131:
// rs1_val == 18428729675200069631, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffbfffffffffffff;  immval:0xfff
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffbfffffffffffff, 0xfff, x2, 872, x3)

inst_132:
// rs1_val == 18410715276690587647, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xff7fffffffffffff;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xff7fffffffffffff, 0x2c, x2, 880, x3)

inst_133:
// rs1_val == 18374686479671623679, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfeffffffffffffff;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfeffffffffffffff, 0x6, x2, 888, x3)

inst_134:
// rs1_val == 18302628885633695743, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfdffffffffffffff;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xfdffffffffffffff, 0x555, x2, 896, x3)

inst_135:
// rs1_val == 18158513697557839871, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfbffffffffffffff;  immval:0xeff
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfbffffffffffffff, 0xeff, x2, 904, x3)

inst_136:
// rs1_val == 17870283321406128127, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xf7ffffffffffffff;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xf7ffffffffffffff, 0x332, x2, 912, x3)

inst_137:
// rs1_val == 17293822569102704639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xefffffffffffffff;  immval:0x12
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xefffffffffffffff, 0x12, x2, 920, x3)

inst_138:
// rs1_val == 16140901064495857663, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xdfffffffffffffff;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xdfffffffffffffff, 0x333, x2, 928, x3)

inst_139:
// rs1_val == 9223372036854775807, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x7fffffffffffffff;  immval:0xe
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x7fffffffffffffff, 0xe, x2, 936, x3)

inst_140:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205 and imm_val==3
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x3, x2, 944, x3)

inst_141:
// rs1_val==3 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x3, x2, 952, x3)

inst_142:
// rs1_val==3 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x555, x2, 960, x3)

inst_143:
// rs1_val==3 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0xaaa, x2, 968, x3)

inst_144:
// rs1_val==3 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x5, x2, 976, x3)

inst_145:
// rs1_val==3 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x333, x2, 984, x3)

inst_146:
// rs1_val==3 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x666, x2, 992, x3)

inst_147:
// rs1_val==3 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x2d, x2, 1000, x3)

inst_148:
// rs1_val==3 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x0, x2, 1008, x3)

inst_149:
// rs1_val==3 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x3f, x2, 1016, x3)

inst_150:
// rs1_val==3 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x2, x2, 1024, x3)

inst_151:
// rs1_val==3 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x554, x2, 1032, x3)

inst_152:
// rs1_val==3 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0xaa9, x2, 1040, x3)

inst_153:
// rs1_val==3 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x4, x2, 1048, x3)

inst_154:
// rs1_val==3 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x332, x2, 1056, x3)

inst_155:
// rs1_val==3 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x665, x2, 1064, x3)

inst_156:
// rs1_val==3 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x2c, x2, 1072, x3)

inst_157:
// rs1_val==3 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x3e, x2, 1080, x3)

inst_158:
// rs1_val==3 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x556, x2, 1088, x3)

inst_159:
// rs1_val==3 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0xaab, x2, 1096, x3)

inst_160:
// rs1_val==3 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x6, x2, 1104, x3)

inst_161:
// rs1_val==3 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x334, x2, 1112, x3)

inst_162:
// rs1_val==3 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x667, x2, 1120, x3)

inst_163:
// rs1_val==3 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x2e, x2, 1128, x3)

inst_164:
// rs1_val==3 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3, 0x1, x2, 1136, x3)

inst_165:
// rs1_val==3 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3, 0x40, x2, 1144, x3)

inst_166:
// rs1_val==6148914691236517205 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x555, x2, 1152, x3)

inst_167:
// rs1_val==6148914691236517205 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555555, 0xaaa, x2, 1160, x3)

inst_168:
// rs1_val==6148914691236517205 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x5, x2, 1168, x3)

inst_169:
// rs1_val==6148914691236517205 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x333, x2, 1176, x3)

inst_170:
// rs1_val==6148914691236517205 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x666, x2, 1184, x3)

inst_171:
// rs1_val==6148914691236517205 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x2d, x2, 1192, x3)

inst_172:
// rs1_val==6148914691236517205 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x0, x2, 1200, x3)

inst_173:
// rs1_val==6148914691236517205 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x3f, x2, 1208, x3)

inst_174:
// rs1_val==6148914691236517205 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x2, x2, 1216, x3)

inst_175:
// rs1_val==6148914691236517205 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x554, x2, 1224, x3)

inst_176:
// rs1_val==6148914691236517205 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555555, 0xaa9, x2, 1232, x3)

inst_177:
// rs1_val==6148914691236517205 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x4, x2, 1240, x3)

inst_178:
// rs1_val==6148914691236517205 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x332, x2, 1248, x3)

inst_179:
// rs1_val==6148914691236517205 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x665, x2, 1256, x3)

inst_180:
// rs1_val==6148914691236517205 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x2c, x2, 1264, x3)

inst_181:
// rs1_val==6148914691236517205 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x3e, x2, 1272, x3)

inst_182:
// rs1_val==6148914691236517205 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x556, x2, 1280, x3)

inst_183:
// rs1_val==6148914691236517205 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555555, 0xaab, x2, 1288, x3)

inst_184:
// rs1_val==6148914691236517205 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x6, x2, 1296, x3)

inst_185:
// rs1_val==6148914691236517205 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x334, x2, 1304, x3)

inst_186:
// rs1_val==6148914691236517205 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x667, x2, 1312, x3)

inst_187:
// rs1_val==6148914691236517205 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x2e, x2, 1320, x3)

inst_188:
// rs1_val==6148914691236517205 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x1, x2, 1328, x3)

inst_189:
// rs1_val==6148914691236517205 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555555, 0x40, x2, 1336, x3)

inst_190:
// rs1_val==12297829382473034410 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x3, x2, 1344, x3)

inst_191:
// rs1_val==12297829382473034410 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x555, x2, 1352, x3)

inst_192:
// rs1_val==12297829382473034410 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaaa, 0xaaa, x2, 1360, x3)

inst_193:
// rs1_val==12297829382473034410 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5, x2, 1368, x3)

inst_194:
// rs1_val==12297829382473034410 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x333, x2, 1376, x3)

inst_195:
// rs1_val==12297829382473034410 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x666, x2, 1384, x3)

inst_196:
// rs1_val==12297829382473034410 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x2d, x2, 1392, x3)

inst_197:
// rs1_val==12297829382473034410 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x0, x2, 1400, x3)

inst_198:
// rs1_val==12297829382473034410 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x3f, x2, 1408, x3)

inst_199:
// rs1_val==12297829382473034410 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x2, x2, 1416, x3)

inst_200:
// rs1_val==12297829382473034410 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x554, x2, 1424, x3)

inst_201:
// rs1_val==12297829382473034410 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaaa, 0xaa9, x2, 1432, x3)

inst_202:
// rs1_val==12297829382473034410 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x4, x2, 1440, x3)

inst_203:
// rs1_val==12297829382473034410 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x332, x2, 1448, x3)

inst_204:
// rs1_val==12297829382473034410 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x665, x2, 1456, x3)

inst_205:
// rs1_val==12297829382473034410 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x2c, x2, 1464, x3)

inst_206:
// rs1_val==12297829382473034410 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x3e, x2, 1472, x3)

inst_207:
// rs1_val==12297829382473034410 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x556, x2, 1480, x3)

inst_208:
// rs1_val==12297829382473034410 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaaa, 0xaab, x2, 1488, x3)

inst_209:
// rs1_val==12297829382473034410 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x6, x2, 1496, x3)

inst_210:
// rs1_val==12297829382473034410 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x334, x2, 1504, x3)

inst_211:
// rs1_val==12297829382473034410 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x667, x2, 1512, x3)

inst_212:
// rs1_val==12297829382473034410 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x2e, x2, 1520, x3)

inst_213:
// rs1_val==12297829382473034410 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaaa;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaaa, 0x1, x2, 1528, x3)

inst_214:
// rs1_val==5 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x3, x2, 1536, x3)

inst_215:
// rs1_val==5 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x555, x2, 1544, x3)

inst_216:
// rs1_val==5 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0xaaa, x2, 1552, x3)

inst_217:
// rs1_val==5 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x5, x2, 1560, x3)

inst_218:
// rs1_val==5 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x333, x2, 1568, x3)

inst_219:
// rs1_val==5 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x666, x2, 1576, x3)

inst_220:
// rs1_val==5 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x2d, x2, 1584, x3)

inst_221:
// rs1_val==5 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x0, x2, 1592, x3)

inst_222:
// rs1_val==5 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x3f, x2, 1600, x3)

inst_223:
// rs1_val==5 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x2, x2, 1608, x3)

inst_224:
// rs1_val==5 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x554, x2, 1616, x3)

inst_225:
// rs1_val==5 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0xaa9, x2, 1624, x3)

inst_226:
// rs1_val==5 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x4, x2, 1632, x3)

inst_227:
// rs1_val==5 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x332, x2, 1640, x3)

inst_228:
// rs1_val==5 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x665, x2, 1648, x3)

inst_229:
// rs1_val==5 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x2c, x2, 1656, x3)

inst_230:
// rs1_val==5 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x3e, x2, 1664, x3)

inst_231:
// rs1_val==5 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x556, x2, 1672, x3)

inst_232:
// rs1_val==5 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0xaab, x2, 1680, x3)

inst_233:
// rs1_val==5 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x6, x2, 1688, x3)

inst_234:
// rs1_val==5 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x334, x2, 1696, x3)

inst_235:
// rs1_val==5 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x667, x2, 1704, x3)

inst_236:
// rs1_val==5 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x2e, x2, 1712, x3)

inst_237:
// rs1_val==5 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5, 0x1, x2, 1720, x3)

inst_238:
// rs1_val==5 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5, 0x40, x2, 1728, x3)

inst_239:
// rs1_val==3689348814741910323 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x3, x2, 1736, x3)

inst_240:
// rs1_val==3689348814741910323 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x555, x2, 1744, x3)

inst_241:
// rs1_val==3689348814741910323 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333333, 0xaaa, x2, 1752, x3)

inst_242:
// rs1_val==3689348814741910323 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x5, x2, 1760, x3)

inst_243:
// rs1_val==3689348814741910323 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x333, x2, 1768, x3)

inst_244:
// rs1_val==3689348814741910323 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x666, x2, 1776, x3)

inst_245:
// rs1_val==3689348814741910323 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x2d, x2, 1784, x3)

inst_246:
// rs1_val==3689348814741910323 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x0, x2, 1792, x3)

inst_247:
// rs1_val==3689348814741910323 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x3f, x2, 1800, x3)

inst_248:
// rs1_val==3689348814741910323 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x2, x2, 1808, x3)

inst_249:
// rs1_val==3689348814741910323 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x554, x2, 1816, x3)

inst_250:
// rs1_val==3689348814741910323 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333333, 0xaa9, x2, 1824, x3)

inst_251:
// rs1_val==3689348814741910323 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x4, x2, 1832, x3)

inst_252:
// rs1_val==3689348814741910323 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x332, x2, 1840, x3)

inst_253:
// rs1_val==3689348814741910323 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x665, x2, 1848, x3)

inst_254:
// rs1_val==3689348814741910323 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x2c, x2, 1856, x3)

inst_255:
// rs1_val==3689348814741910323 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x3e, x2, 1864, x3)

inst_256:
// rs1_val==3689348814741910323 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x556, x2, 1872, x3)

inst_257:
// rs1_val==3689348814741910323 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333333, 0xaab, x2, 1880, x3)

inst_258:
// rs1_val==3689348814741910323 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x6, x2, 1888, x3)

inst_259:
// rs1_val==3689348814741910323 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x334, x2, 1896, x3)

inst_260:
// rs1_val==3689348814741910323 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x667, x2, 1904, x3)

inst_261:
// rs1_val==3689348814741910323 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x2e, x2, 1912, x3)

inst_262:
// rs1_val==3689348814741910323 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x1, x2, 1920, x3)

inst_263:
// rs1_val==3689348814741910323 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333333, 0x40, x2, 1928, x3)

inst_264:
// rs1_val==7378697629483820646 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x3, x2, 1936, x3)

inst_265:
// rs1_val==7378697629483820646 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x555, x2, 1944, x3)

inst_266:
// rs1_val==7378697629483820646 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666666, 0xaaa, x2, 1952, x3)

inst_267:
// rs1_val==7378697629483820646 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x5, x2, 1960, x3)

inst_268:
// rs1_val==7378697629483820646 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x333, x2, 1968, x3)

inst_269:
// rs1_val==7378697629483820646 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x666, x2, 1976, x3)

inst_270:
// rs1_val==7378697629483820646 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x2d, x2, 1984, x3)

inst_271:
// rs1_val==7378697629483820646 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x0, x2, 1992, x3)

inst_272:
// rs1_val==7378697629483820646 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x3f, x2, 2000, x3)

inst_273:
// rs1_val==7378697629483820646 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x2, x2, 2008, x3)

inst_274:
// rs1_val==7378697629483820646 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x554, x2, 2016, x3)

inst_275:
// rs1_val==7378697629483820646 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666666, 0xaa9, x2, 2024, x3)

inst_276:
// rs1_val==7378697629483820646 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x4, x2, 2032, x3)

inst_277:
// rs1_val==7378697629483820646 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x332, x2, 2040, x3)
RVTEST_SIGBASE( x2,signature_x2_1)

inst_278:
// rs1_val==7378697629483820646 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x665, x2, 0, x3)

inst_279:
// rs1_val==7378697629483820646 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x2c, x2, 8, x3)

inst_280:
// rs1_val==7378697629483820646 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x3e, x2, 16, x3)

inst_281:
// rs1_val==7378697629483820646 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x556, x2, 24, x3)

inst_282:
// rs1_val==7378697629483820646 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666666, 0xaab, x2, 32, x3)

inst_283:
// rs1_val==7378697629483820646 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x6, x2, 40, x3)

inst_284:
// rs1_val==7378697629483820646 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x334, x2, 48, x3)

inst_285:
// rs1_val==7378697629483820646 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x667, x2, 56, x3)

inst_286:
// rs1_val==7378697629483820646 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x2e, x2, 64, x3)

inst_287:
// rs1_val==7378697629483820646 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x1, x2, 72, x3)

inst_288:
// rs1_val==7378697629483820646 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666666, 0x40, x2, 80, x3)

inst_289:
// rs1_val==3037000499 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x3, x2, 88, x3)

inst_290:
// rs1_val==3037000499 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x555, x2, 96, x3)

inst_291:
// rs1_val==3037000499 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f333, 0xaaa, x2, 104, x3)

inst_292:
// rs1_val==3037000499 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x5, x2, 112, x3)

inst_293:
// rs1_val==3037000499 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x333, x2, 120, x3)

inst_294:
// rs1_val==3037000499 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x666, x2, 128, x3)

inst_295:
// rs1_val==3037000499 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x2d, x2, 136, x3)

inst_296:
// rs1_val==3037000499 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x0, x2, 144, x3)

inst_297:
// rs1_val==3037000499 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x3f, x2, 152, x3)

inst_298:
// rs1_val==3037000499 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x2, x2, 160, x3)

inst_299:
// rs1_val==3037000499 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x554, x2, 168, x3)

inst_300:
// rs1_val==3037000499 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f333, 0xaa9, x2, 176, x3)

inst_301:
// rs1_val==3037000499 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x4, x2, 184, x3)

inst_302:
// rs1_val==3037000499 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x332, x2, 192, x3)

inst_303:
// rs1_val==3037000499 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x665, x2, 200, x3)

inst_304:
// rs1_val==3037000499 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x2c, x2, 208, x3)

inst_305:
// rs1_val==3037000499 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x3e, x2, 216, x3)

inst_306:
// rs1_val==3037000499 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x556, x2, 224, x3)

inst_307:
// rs1_val==3037000499 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f333, 0xaab, x2, 232, x3)

inst_308:
// rs1_val==3037000499 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x6, x2, 240, x3)

inst_309:
// rs1_val==3037000499 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x334, x2, 248, x3)

inst_310:
// rs1_val==3037000499 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x667, x2, 256, x3)

inst_311:
// rs1_val==3037000499 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x2e, x2, 264, x3)

inst_312:
// rs1_val==3037000499 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x1, x2, 272, x3)

inst_313:
// rs1_val==3037000499 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f333, 0x40, x2, 280, x3)

inst_314:
// rs1_val==0 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x3, x2, 288, x3)

inst_315:
// rs1_val==0 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x555, x2, 296, x3)

inst_316:
// rs1_val==0 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0xaaa, x2, 304, x3)

inst_317:
// rs1_val==0 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x5, x2, 312, x3)

inst_318:
// rs1_val==0 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x333, x2, 320, x3)

inst_319:
// rs1_val==0 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x666, x2, 328, x3)

inst_320:
// rs1_val==0 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x2d, x2, 336, x3)

inst_321:
// rs1_val==0 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x0, 0x0, x2, 344, x3)

inst_322:
// rs1_val==0 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x3f, x2, 352, x3)

inst_323:
// rs1_val==0 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x554, x2, 360, x3)

inst_324:
// rs1_val==0 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0xaa9, x2, 368, x3)

inst_325:
// rs1_val==0 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x4, x2, 376, x3)

inst_326:
// rs1_val==0 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x332, x2, 384, x3)

inst_327:
// rs1_val==0 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x665, x2, 392, x3)

inst_328:
// rs1_val==0 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x2c, x2, 400, x3)

inst_329:
// rs1_val==0 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x3e, x2, 408, x3)

inst_330:
// rs1_val==0 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x556, x2, 416, x3)

inst_331:
// rs1_val==0 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0xaab, x2, 424, x3)

inst_332:
// rs1_val==0 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x6, x2, 432, x3)

inst_333:
// rs1_val==0 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x334, x2, 440, x3)

inst_334:
// rs1_val==0 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x667, x2, 448, x3)

inst_335:
// rs1_val==0 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x2e, x2, 456, x3)

inst_336:
// rs1_val==0 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x0;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x0, 0x40, x2, 464, x3)

inst_337:
// rs1_val==4294967296 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x3, x2, 472, x3)

inst_338:
// rs1_val==4294967296 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x555, x2, 480, x3)

inst_339:
// rs1_val==4294967296 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100000000, 0xaaa, x2, 488, x3)

inst_340:
// rs1_val==4294967296 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x5, x2, 496, x3)

inst_341:
// rs1_val==4294967296 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x333, x2, 504, x3)

inst_342:
// rs1_val==4294967296 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x666, x2, 512, x3)

inst_343:
// rs1_val==4294967296 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x2d, x2, 520, x3)

inst_344:
// rs1_val==4294967296 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x0, x2, 528, x3)

inst_345:
// rs1_val==4294967296 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x3f, x2, 536, x3)

inst_346:
// rs1_val==4294967296 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x2, x2, 544, x3)

inst_347:
// rs1_val==4294967296 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x554, x2, 552, x3)

inst_348:
// rs1_val==4294967296 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100000000, 0xaa9, x2, 560, x3)

inst_349:
// rs1_val==4294967296 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x4, x2, 568, x3)

inst_350:
// rs1_val==4294967296 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x332, x2, 576, x3)

inst_351:
// rs1_val==4294967296 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x665, x2, 584, x3)

inst_352:
// rs1_val==4294967296 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x2c, x2, 592, x3)

inst_353:
// rs1_val==4294967296 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x3e, x2, 600, x3)

inst_354:
// rs1_val==4294967296 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x556, x2, 608, x3)

inst_355:
// rs1_val==4294967296 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100000000, 0xaab, x2, 616, x3)

inst_356:
// rs1_val==4294967296 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x6, x2, 624, x3)

inst_357:
// rs1_val==4294967296 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x334, x2, 632, x3)

inst_358:
// rs1_val==4294967296 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x667, x2, 640, x3)

inst_359:
// rs1_val==4294967296 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x2e, x2, 648, x3)

inst_360:
// rs1_val==4294967296 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000000, 0x1, x2, 656, x3)

inst_361:
// rs1_val==2 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x3, x2, 664, x3)

inst_362:
// rs1_val==2 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x555, x2, 672, x3)

inst_363:
// rs1_val==2 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0xaaa, x2, 680, x3)

inst_364:
// rs1_val==2 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x5, x2, 688, x3)

inst_365:
// rs1_val==2 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x333, x2, 696, x3)

inst_366:
// rs1_val==2 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x666, x2, 704, x3)

inst_367:
// rs1_val==2 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x2d, x2, 712, x3)

inst_368:
// rs1_val==2 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2, 0x0, x2, 720, x3)

inst_369:
// rs1_val==2 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x3f, x2, 728, x3)

inst_370:
// rs1_val==2 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2, 0x2, x2, 736, x3)

inst_371:
// rs1_val==2 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x554, x2, 744, x3)

inst_372:
// rs1_val==2 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0xaa9, x2, 752, x3)

inst_373:
// rs1_val==2 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x4, x2, 760, x3)

inst_374:
// rs1_val==2 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x332, x2, 768, x3)

inst_375:
// rs1_val==2 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x665, x2, 776, x3)

inst_376:
// rs1_val==2 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x2c, x2, 784, x3)

inst_377:
// rs1_val==2 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x556, x2, 792, x3)

inst_378:
// rs1_val==2 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0xaab, x2, 800, x3)

inst_379:
// rs1_val==2 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x6, x2, 808, x3)

inst_380:
// rs1_val==2 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x334, x2, 816, x3)

inst_381:
// rs1_val==2 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x667, x2, 824, x3)

inst_382:
// rs1_val==2 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x2e, x2, 832, x3)

inst_383:
// rs1_val==2 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x2, 0x1, x2, 840, x3)

inst_384:
// rs1_val==2 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x2;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x2, 0x40, x2, 848, x3)

inst_385:
// rs1_val==6148914691236517204 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x3, x2, 856, x3)

inst_386:
// rs1_val==6148914691236517204 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x555, x2, 864, x3)

inst_387:
// rs1_val==6148914691236517204 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555554, 0xaaa, x2, 872, x3)

inst_388:
// rs1_val==6148914691236517204 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x5, x2, 880, x3)

inst_389:
// rs1_val==6148914691236517204 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x333, x2, 888, x3)

inst_390:
// rs1_val==6148914691236517204 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x666, x2, 896, x3)

inst_391:
// rs1_val==6148914691236517204 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x2d, x2, 904, x3)

inst_392:
// rs1_val==6148914691236517204 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x0, x2, 912, x3)

inst_393:
// rs1_val==6148914691236517204 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x3f, x2, 920, x3)

inst_394:
// rs1_val==6148914691236517204 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x2, x2, 928, x3)

inst_395:
// rs1_val==6148914691236517204 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x554, x2, 936, x3)

inst_396:
// rs1_val==6148914691236517204 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555554, 0xaa9, x2, 944, x3)

inst_397:
// rs1_val==6148914691236517204 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x4, x2, 952, x3)

inst_398:
// rs1_val==6148914691236517204 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x332, x2, 960, x3)

inst_399:
// rs1_val==6148914691236517204 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x665, x2, 968, x3)

inst_400:
// rs1_val==6148914691236517204 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x2c, x2, 976, x3)

inst_401:
// rs1_val==6148914691236517204 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x3e, x2, 984, x3)

inst_402:
// rs1_val==6148914691236517204 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x556, x2, 992, x3)

inst_403:
// rs1_val==6148914691236517204 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555554, 0xaab, x2, 1000, x3)

inst_404:
// rs1_val==6148914691236517204 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x6, x2, 1008, x3)

inst_405:
// rs1_val==6148914691236517204 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x334, x2, 1016, x3)

inst_406:
// rs1_val==6148914691236517204 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x667, x2, 1024, x3)

inst_407:
// rs1_val==6148914691236517204 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x2e, x2, 1032, x3)

inst_408:
// rs1_val==6148914691236517204 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x1, x2, 1040, x3)

inst_409:
// rs1_val==6148914691236517204 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555554, 0x40, x2, 1048, x3)

inst_410:
// rs1_val==12297829382473034409 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3, x2, 1056, x3)

inst_411:
// rs1_val==12297829382473034409 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x555, x2, 1064, x3)

inst_412:
// rs1_val==12297829382473034409 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaa9, 0xaaa, x2, 1072, x3)

inst_413:
// rs1_val==12297829382473034409 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x5, x2, 1080, x3)

inst_414:
// rs1_val==12297829382473034409 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x333, x2, 1088, x3)

inst_415:
// rs1_val==12297829382473034409 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x666, x2, 1096, x3)

inst_416:
// rs1_val==12297829382473034409 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x2d, x2, 1104, x3)

inst_417:
// rs1_val==12297829382473034409 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x0, x2, 1112, x3)

inst_418:
// rs1_val==12297829382473034409 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3f, x2, 1120, x3)

inst_419:
// rs1_val==12297829382473034409 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x2, x2, 1128, x3)

inst_420:
// rs1_val==12297829382473034409 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x554, x2, 1136, x3)

inst_421:
// rs1_val==12297829382473034409 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaa9, 0xaa9, x2, 1144, x3)

inst_422:
// rs1_val==12297829382473034409 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x4, x2, 1152, x3)

inst_423:
// rs1_val==12297829382473034409 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x332, x2, 1160, x3)

inst_424:
// rs1_val==12297829382473034409 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x665, x2, 1168, x3)

inst_425:
// rs1_val==12297829382473034409 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x2c, x2, 1176, x3)

inst_426:
// rs1_val==12297829382473034409 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3e, x2, 1184, x3)

inst_427:
// rs1_val==12297829382473034409 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x556, x2, 1192, x3)

inst_428:
// rs1_val==12297829382473034409 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaa9, 0xaab, x2, 1200, x3)

inst_429:
// rs1_val==12297829382473034409 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x6, x2, 1208, x3)

inst_430:
// rs1_val==12297829382473034409 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x334, x2, 1216, x3)

inst_431:
// rs1_val==12297829382473034409 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x667, x2, 1224, x3)

inst_432:
// rs1_val==12297829382473034409 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x2e, x2, 1232, x3)

inst_433:
// rs1_val==12297829382473034409 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x1, x2, 1240, x3)

inst_434:
// rs1_val==12297829382473034409 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaa9;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaa9, 0x40, x2, 1248, x3)

inst_435:
// rs1_val==4 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x3, x2, 1256, x3)

inst_436:
// rs1_val==4 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x555, x2, 1264, x3)

inst_437:
// rs1_val==4 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x5, x2, 1272, x3)

inst_438:
// rs1_val==4 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x333, x2, 1280, x3)

inst_439:
// rs1_val==4 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x666, x2, 1288, x3)

inst_440:
// rs1_val==4 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x2d, x2, 1296, x3)

inst_441:
// rs1_val==4 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x0, x2, 1304, x3)

inst_442:
// rs1_val==4 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x3f, x2, 1312, x3)

inst_443:
// rs1_val==4 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x2, x2, 1320, x3)

inst_444:
// rs1_val==4 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x554, x2, 1328, x3)

inst_445:
// rs1_val==4 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0xaa9, x2, 1336, x3)

inst_446:
// rs1_val==4 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x4, x2, 1344, x3)

inst_447:
// rs1_val==4 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x332, x2, 1352, x3)

inst_448:
// rs1_val==4 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x665, x2, 1360, x3)

inst_449:
// rs1_val==4 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x2c, x2, 1368, x3)

inst_450:
// rs1_val==4 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x3e, x2, 1376, x3)

inst_451:
// rs1_val==4 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x556, x2, 1384, x3)

inst_452:
// rs1_val==4 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0xaab, x2, 1392, x3)

inst_453:
// rs1_val==4 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x6, x2, 1400, x3)

inst_454:
// rs1_val==4 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x334, x2, 1408, x3)

inst_455:
// rs1_val==4 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x667, x2, 1416, x3)

inst_456:
// rs1_val==4 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x2e, x2, 1424, x3)

inst_457:
// rs1_val==4 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x4, 0x1, x2, 1432, x3)

inst_458:
// rs1_val==4 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x4;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x4, 0x40, x2, 1440, x3)

inst_459:
// rs1_val==3689348814741910322 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x3, x2, 1448, x3)

inst_460:
// rs1_val==3689348814741910322 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x555, x2, 1456, x3)

inst_461:
// rs1_val==3689348814741910322 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333332, 0xaaa, x2, 1464, x3)

inst_462:
// rs1_val==3689348814741910322 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x5, x2, 1472, x3)

inst_463:
// rs1_val==3689348814741910322 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x333, x2, 1480, x3)

inst_464:
// rs1_val==3689348814741910322 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x666, x2, 1488, x3)

inst_465:
// rs1_val==3689348814741910322 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x2d, x2, 1496, x3)

inst_466:
// rs1_val==3689348814741910322 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x0, x2, 1504, x3)

inst_467:
// rs1_val==3689348814741910322 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x3f, x2, 1512, x3)

inst_468:
// rs1_val==3689348814741910322 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x2, x2, 1520, x3)

inst_469:
// rs1_val==3689348814741910322 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x554, x2, 1528, x3)

inst_470:
// rs1_val==3689348814741910322 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333332, 0xaa9, x2, 1536, x3)

inst_471:
// rs1_val==3689348814741910322 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x4, x2, 1544, x3)

inst_472:
// rs1_val==3689348814741910322 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x332, x2, 1552, x3)

inst_473:
// rs1_val==3689348814741910322 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x665, x2, 1560, x3)

inst_474:
// rs1_val==3689348814741910322 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x2c, x2, 1568, x3)

inst_475:
// rs1_val==3689348814741910322 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x3e, x2, 1576, x3)

inst_476:
// rs1_val==3689348814741910322 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x556, x2, 1584, x3)

inst_477:
// rs1_val==3689348814741910322 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333332, 0xaab, x2, 1592, x3)

inst_478:
// rs1_val==3689348814741910322 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x6, x2, 1600, x3)

inst_479:
// rs1_val==3689348814741910322 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x334, x2, 1608, x3)

inst_480:
// rs1_val==3689348814741910322 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x667, x2, 1616, x3)

inst_481:
// rs1_val==3689348814741910322 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x2e, x2, 1624, x3)

inst_482:
// rs1_val==3689348814741910322 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x1, x2, 1632, x3)

inst_483:
// rs1_val==3689348814741910322 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333332, 0x40, x2, 1640, x3)

inst_484:
// rs1_val==7378697629483820645 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x3, x2, 1648, x3)

inst_485:
// rs1_val==7378697629483820645 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x555, x2, 1656, x3)

inst_486:
// rs1_val==7378697629483820645 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666665, 0xaaa, x2, 1664, x3)

inst_487:
// rs1_val==7378697629483820645 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x5, x2, 1672, x3)

inst_488:
// rs1_val==7378697629483820645 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x333, x2, 1680, x3)

inst_489:
// rs1_val==7378697629483820645 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x666, x2, 1688, x3)

inst_490:
// rs1_val==7378697629483820645 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x2d, x2, 1696, x3)

inst_491:
// rs1_val==7378697629483820645 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x0, x2, 1704, x3)

inst_492:
// rs1_val==7378697629483820645 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x3f, x2, 1712, x3)

inst_493:
// rs1_val==7378697629483820645 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x2, x2, 1720, x3)

inst_494:
// rs1_val==7378697629483820645 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x554, x2, 1728, x3)

inst_495:
// rs1_val==7378697629483820645 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666665, 0xaa9, x2, 1736, x3)

inst_496:
// rs1_val==7378697629483820645 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x4, x2, 1744, x3)

inst_497:
// rs1_val==7378697629483820645 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x332, x2, 1752, x3)

inst_498:
// rs1_val==7378697629483820645 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x665, x2, 1760, x3)

inst_499:
// rs1_val==7378697629483820645 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x2c, x2, 1768, x3)

inst_500:
// rs1_val==7378697629483820645 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x3e, x2, 1776, x3)

inst_501:
// rs1_val==7378697629483820645 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x556, x2, 1784, x3)

inst_502:
// rs1_val==7378697629483820645 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666665, 0xaab, x2, 1792, x3)

inst_503:
// rs1_val==7378697629483820645 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x6, x2, 1800, x3)

inst_504:
// rs1_val==7378697629483820645 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x334, x2, 1808, x3)

inst_505:
// rs1_val==7378697629483820645 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x667, x2, 1816, x3)

inst_506:
// rs1_val==7378697629483820645 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x2e, x2, 1824, x3)

inst_507:
// rs1_val==7378697629483820645 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x1, x2, 1832, x3)

inst_508:
// rs1_val==7378697629483820645 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666665, 0x40, x2, 1840, x3)

inst_509:
// rs1_val==3037000498 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x3, x2, 1848, x3)

inst_510:
// rs1_val==3037000498 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x555, x2, 1856, x3)

inst_511:
// rs1_val==3037000498 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f332, 0xaaa, x2, 1864, x3)

inst_512:
// rs1_val==3037000498 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x5, x2, 1872, x3)

inst_513:
// rs1_val==3037000498 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x333, x2, 1880, x3)

inst_514:
// rs1_val==3037000498 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x666, x2, 1888, x3)

inst_515:
// rs1_val==3037000498 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x2d, x2, 1896, x3)

inst_516:
// rs1_val==3037000498 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x0, x2, 1904, x3)

inst_517:
// rs1_val==3037000498 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x3f, x2, 1912, x3)

inst_518:
// rs1_val==3037000498 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x2, x2, 1920, x3)

inst_519:
// rs1_val==3037000498 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x554, x2, 1928, x3)

inst_520:
// rs1_val==3037000498 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f332, 0xaa9, x2, 1936, x3)

inst_521:
// rs1_val==3037000498 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x4, x2, 1944, x3)

inst_522:
// rs1_val==3037000498 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x332, x2, 1952, x3)

inst_523:
// rs1_val==3037000498 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x665, x2, 1960, x3)

inst_524:
// rs1_val==3037000498 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x2c, x2, 1968, x3)

inst_525:
// rs1_val==3037000498 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x3e, x2, 1976, x3)

inst_526:
// rs1_val==3037000498 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x556, x2, 1984, x3)

inst_527:
// rs1_val==3037000498 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f332, 0xaab, x2, 1992, x3)

inst_528:
// rs1_val==3037000498 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x6, x2, 2000, x3)

inst_529:
// rs1_val==3037000498 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x334, x2, 2008, x3)

inst_530:
// rs1_val==3037000498 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x667, x2, 2016, x3)

inst_531:
// rs1_val==3037000498 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x2e, x2, 2024, x3)

inst_532:
// rs1_val==3037000498 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x1, x2, 2032, x3)

inst_533:
// rs1_val==3037000498 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f332, 0x40, x2, 2040, x3)
RVTEST_SIGBASE( x2,signature_x2_2)

inst_534:
// rs1_val==4294967295 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x3, x2, 0, x3)

inst_535:
// rs1_val==4294967295 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x555, x2, 8, x3)

inst_536:
// rs1_val==4294967295 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffffffff, 0xaaa, x2, 16, x3)

inst_537:
// rs1_val==4294967295 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x5, x2, 24, x3)

inst_538:
// rs1_val==4294967295 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x333, x2, 32, x3)

inst_539:
// rs1_val==4294967295 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x666, x2, 40, x3)

inst_540:
// rs1_val==4294967295 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x2d, x2, 48, x3)

inst_541:
// rs1_val==4294967295 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x0, x2, 56, x3)

inst_542:
// rs1_val==4294967295 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x3f, x2, 64, x3)

inst_543:
// rs1_val==4294967295 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x2, x2, 72, x3)

inst_544:
// rs1_val==4294967295 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x554, x2, 80, x3)

inst_545:
// rs1_val==4294967295 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffffffff, 0xaa9, x2, 88, x3)

inst_546:
// rs1_val==4294967295 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x4, x2, 96, x3)

inst_547:
// rs1_val==4294967295 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x332, x2, 104, x3)

inst_548:
// rs1_val==4294967295 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x665, x2, 112, x3)

inst_549:
// rs1_val==4294967295 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x2c, x2, 120, x3)

inst_550:
// rs1_val==4294967295 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x3e, x2, 128, x3)

inst_551:
// rs1_val==4294967295 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x556, x2, 136, x3)

inst_552:
// rs1_val==4294967295 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xffffffff, 0xaab, x2, 144, x3)

inst_553:
// rs1_val==4294967295 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x6, x2, 152, x3)

inst_554:
// rs1_val==4294967295 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x334, x2, 160, x3)

inst_555:
// rs1_val==4294967295 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x667, x2, 168, x3)

inst_556:
// rs1_val==4294967295 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x2e, x2, 176, x3)

inst_557:
// rs1_val==4294967295 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x1, x2, 184, x3)

inst_558:
// rs1_val==4294967295 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xffffffff;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xffffffff, 0x40, x2, 192, x3)

inst_559:
// rs1_val==6148914691236517206 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x3, x2, 200, x3)

inst_560:
// rs1_val==6148914691236517206 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x555, x2, 208, x3)

inst_561:
// rs1_val==6148914691236517206 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555556, 0xaaa, x2, 216, x3)

inst_562:
// rs1_val==6148914691236517206 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x5, x2, 224, x3)

inst_563:
// rs1_val==6148914691236517206 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x333, x2, 232, x3)

inst_564:
// rs1_val==6148914691236517206 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x666, x2, 240, x3)

inst_565:
// rs1_val==6148914691236517206 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x2d, x2, 248, x3)

inst_566:
// rs1_val==6148914691236517206 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x0, x2, 256, x3)

inst_567:
// rs1_val==6148914691236517206 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x3f, x2, 264, x3)

inst_568:
// rs1_val==6148914691236517206 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x2, x2, 272, x3)

inst_569:
// rs1_val==6148914691236517206 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x554, x2, 280, x3)

inst_570:
// rs1_val==6148914691236517206 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555556, 0xaa9, x2, 288, x3)

inst_571:
// rs1_val==6148914691236517206 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x4, x2, 296, x3)

inst_572:
// rs1_val==6148914691236517206 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x332, x2, 304, x3)

inst_573:
// rs1_val==6148914691236517206 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x665, x2, 312, x3)

inst_574:
// rs1_val==6148914691236517206 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x2c, x2, 320, x3)

inst_575:
// rs1_val==6148914691236517206 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x3e, x2, 328, x3)

inst_576:
// rs1_val==6148914691236517206 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x556, x2, 336, x3)

inst_577:
// rs1_val==6148914691236517206 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x5555555555555556, 0xaab, x2, 344, x3)

inst_578:
// rs1_val==6148914691236517206 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x6, x2, 352, x3)

inst_579:
// rs1_val==6148914691236517206 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x334, x2, 360, x3)

inst_580:
// rs1_val==6148914691236517206 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x667, x2, 368, x3)

inst_581:
// rs1_val==6148914691236517206 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x2e, x2, 376, x3)

inst_582:
// rs1_val==6148914691236517206 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x1, x2, 384, x3)

inst_583:
// rs1_val==6148914691236517206 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x5555555555555556, 0x40, x2, 392, x3)

inst_584:
// rs1_val==12297829382473034411 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x3, x2, 400, x3)

inst_585:
// rs1_val==12297829382473034411 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x555, x2, 408, x3)

inst_586:
// rs1_val==12297829382473034411 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaab, 0xaaa, x2, 416, x3)

inst_587:
// rs1_val==12297829382473034411 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x5, x2, 424, x3)

inst_588:
// rs1_val==12297829382473034411 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x333, x2, 432, x3)

inst_589:
// rs1_val==12297829382473034411 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x666, x2, 440, x3)

inst_590:
// rs1_val==12297829382473034411 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x2d, x2, 448, x3)

inst_591:
// rs1_val==12297829382473034411 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x0, x2, 456, x3)

inst_592:
// rs1_val==12297829382473034411 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x3f, x2, 464, x3)

inst_593:
// rs1_val==12297829382473034411 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x2, x2, 472, x3)

inst_594:
// rs1_val==12297829382473034411 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x554, x2, 480, x3)

inst_595:
// rs1_val==12297829382473034411 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaab, 0xaa9, x2, 488, x3)

inst_596:
// rs1_val==12297829382473034411 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x4, x2, 496, x3)

inst_597:
// rs1_val==12297829382473034411 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x332, x2, 504, x3)

inst_598:
// rs1_val==12297829382473034411 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x665, x2, 512, x3)

inst_599:
// rs1_val==12297829382473034411 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x2c, x2, 520, x3)

inst_600:
// rs1_val==12297829382473034411 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x3e, x2, 528, x3)

inst_601:
// rs1_val==12297829382473034411 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x556, x2, 536, x3)

inst_602:
// rs1_val==12297829382473034411 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xaaaaaaaaaaaaaaab, 0xaab, x2, 544, x3)

inst_603:
// rs1_val==12297829382473034411 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x6, x2, 552, x3)

inst_604:
// rs1_val==12297829382473034411 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x334, x2, 560, x3)

inst_605:
// rs1_val==12297829382473034411 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x667, x2, 568, x3)

inst_606:
// rs1_val==12297829382473034411 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x2e, x2, 576, x3)

inst_607:
// rs1_val==12297829382473034411 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x1, x2, 584, x3)

inst_608:
// rs1_val==12297829382473034411 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xaaaaaaaaaaaaaaab;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xaaaaaaaaaaaaaaab, 0x40, x2, 592, x3)

inst_609:
// rs1_val==6 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x3, x2, 600, x3)

inst_610:
// rs1_val==6 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x555, x2, 608, x3)

inst_611:
// rs1_val==6 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0xaaa, x2, 616, x3)

inst_612:
// rs1_val==6 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x5, x2, 624, x3)

inst_613:
// rs1_val==6 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x333, x2, 632, x3)

inst_614:
// rs1_val==6 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x666, x2, 640, x3)

inst_615:
// rs1_val==6 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x2d, x2, 648, x3)

inst_616:
// rs1_val==6 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x0, x2, 656, x3)

inst_617:
// rs1_val==6 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x3f, x2, 664, x3)

inst_618:
// rs1_val==6 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x2, x2, 672, x3)

inst_619:
// rs1_val==6 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x554, x2, 680, x3)

inst_620:
// rs1_val==6 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0xaa9, x2, 688, x3)

inst_621:
// rs1_val==6 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x4, x2, 696, x3)

inst_622:
// rs1_val==6 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x332, x2, 704, x3)

inst_623:
// rs1_val==6 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x665, x2, 712, x3)

inst_624:
// rs1_val==6 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x2c, x2, 720, x3)

inst_625:
// rs1_val==6 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x3e, x2, 728, x3)

inst_626:
// rs1_val==6 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x556, x2, 736, x3)

inst_627:
// rs1_val==6 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0xaab, x2, 744, x3)

inst_628:
// rs1_val==6 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x6, x2, 752, x3)

inst_629:
// rs1_val==6 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x334, x2, 760, x3)

inst_630:
// rs1_val==6 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x667, x2, 768, x3)

inst_631:
// rs1_val==4294967297 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x2d, x2, 776, x3)

inst_632:
// rs1_val==4294967297 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x0, x2, 784, x3)

inst_633:
// rs1_val==4294967297 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x3f, x2, 792, x3)

inst_634:
// rs1_val==4294967297 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x2, x2, 800, x3)

inst_635:
// rs1_val==4294967297 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x554, x2, 808, x3)

inst_636:
// rs1_val==4294967297 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100000001, 0xaa9, x2, 816, x3)

inst_637:
// rs1_val==4294967297 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x4, x2, 824, x3)

inst_638:
// rs1_val==4294967297 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x332, x2, 832, x3)

inst_639:
// rs1_val==4294967297 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x665, x2, 840, x3)

inst_640:
// rs1_val==4294967297 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x2c, x2, 848, x3)

inst_641:
// rs1_val==4294967297 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x3e, x2, 856, x3)

inst_642:
// rs1_val==4294967297 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x556, x2, 864, x3)

inst_643:
// rs1_val==4294967297 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100000001, 0xaab, x2, 872, x3)

inst_644:
// rs1_val==4294967297 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x6, x2, 880, x3)

inst_645:
// rs1_val==4294967297 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x334, x2, 888, x3)

inst_646:
// rs1_val==4294967297 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x667, x2, 896, x3)

inst_647:
// rs1_val==4294967297 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x2e, x2, 904, x3)

inst_648:
// rs1_val==4294967297 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x1, x2, 912, x3)

inst_649:
// rs1_val==4294967297 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x40, x2, 920, x3)

inst_650:
// rs1_val==6 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x2e, x2, 928, x3)

inst_651:
// rs1_val==6 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6, 0x1, x2, 936, x3)

inst_652:
// rs1_val==6 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6, 0x40, x2, 944, x3)

inst_653:
// rs1_val==3689348814741910324 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x3, x2, 952, x3)

inst_654:
// rs1_val==3689348814741910324 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x555, x2, 960, x3)

inst_655:
// rs1_val==3689348814741910324 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333334, 0xaaa, x2, 968, x3)

inst_656:
// rs1_val==3689348814741910324 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x5, x2, 976, x3)

inst_657:
// rs1_val==3689348814741910324 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x333, x2, 984, x3)

inst_658:
// rs1_val==3689348814741910324 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x666, x2, 992, x3)

inst_659:
// rs1_val==3689348814741910324 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x2d, x2, 1000, x3)

inst_660:
// rs1_val==3689348814741910324 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x0, x2, 1008, x3)

inst_661:
// rs1_val==3689348814741910324 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x3f, x2, 1016, x3)

inst_662:
// rs1_val==3689348814741910324 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x2, x2, 1024, x3)

inst_663:
// rs1_val==3689348814741910324 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x554, x2, 1032, x3)

inst_664:
// rs1_val==3689348814741910324 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333334, 0xaa9, x2, 1040, x3)

inst_665:
// rs1_val==3689348814741910324 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x4, x2, 1048, x3)

inst_666:
// rs1_val==3689348814741910324 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x332, x2, 1056, x3)

inst_667:
// rs1_val==3689348814741910324 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x665, x2, 1064, x3)

inst_668:
// rs1_val==3689348814741910324 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x2c, x2, 1072, x3)

inst_669:
// rs1_val==3689348814741910324 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x3e, x2, 1080, x3)

inst_670:
// rs1_val==3689348814741910324 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x556, x2, 1088, x3)

inst_671:
// rs1_val==3689348814741910324 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x3333333333333334, 0xaab, x2, 1096, x3)

inst_672:
// rs1_val==3689348814741910324 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x6, x2, 1104, x3)

inst_673:
// rs1_val==3689348814741910324 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x334, x2, 1112, x3)

inst_674:
// rs1_val==3689348814741910324 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x667, x2, 1120, x3)

inst_675:
// rs1_val==3689348814741910324 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x2e, x2, 1128, x3)

inst_676:
// rs1_val==3689348814741910324 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x1, x2, 1136, x3)

inst_677:
// rs1_val==3689348814741910324 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x3333333333333334, 0x40, x2, 1144, x3)

inst_678:
// rs1_val==7378697629483820647 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x3, x2, 1152, x3)

inst_679:
// rs1_val==7378697629483820647 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x555, x2, 1160, x3)

inst_680:
// rs1_val==7378697629483820647 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666667, 0xaaa, x2, 1168, x3)

inst_681:
// rs1_val==7378697629483820647 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x5, x2, 1176, x3)

inst_682:
// rs1_val==7378697629483820647 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x333, x2, 1184, x3)

inst_683:
// rs1_val==7378697629483820647 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x666, x2, 1192, x3)

inst_684:
// rs1_val==7378697629483820647 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x2d, x2, 1200, x3)

inst_685:
// rs1_val==7378697629483820647 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x0, x2, 1208, x3)

inst_686:
// rs1_val==7378697629483820647 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x3f, x2, 1216, x3)

inst_687:
// rs1_val==7378697629483820647 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x2, x2, 1224, x3)

inst_688:
// rs1_val==7378697629483820647 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x554, x2, 1232, x3)

inst_689:
// rs1_val==7378697629483820647 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666667, 0xaa9, x2, 1240, x3)

inst_690:
// rs1_val==7378697629483820647 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x4, x2, 1248, x3)

inst_691:
// rs1_val==7378697629483820647 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x332, x2, 1256, x3)

inst_692:
// rs1_val==7378697629483820647 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x665, x2, 1264, x3)

inst_693:
// rs1_val==7378697629483820647 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x2c, x2, 1272, x3)

inst_694:
// rs1_val==7378697629483820647 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x3e, x2, 1280, x3)

inst_695:
// rs1_val==7378697629483820647 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x556, x2, 1288, x3)

inst_696:
// rs1_val==7378697629483820647 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x6666666666666667, 0xaab, x2, 1296, x3)

inst_697:
// rs1_val==7378697629483820647 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x6, x2, 1304, x3)

inst_698:
// rs1_val==7378697629483820647 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x334, x2, 1312, x3)

inst_699:
// rs1_val==7378697629483820647 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x667, x2, 1320, x3)

inst_700:
// rs1_val==7378697629483820647 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x2e, x2, 1328, x3)

inst_701:
// rs1_val==7378697629483820647 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x1, x2, 1336, x3)

inst_702:
// rs1_val==7378697629483820647 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x6666666666666667, 0x40, x2, 1344, x3)

inst_703:
// rs1_val==3037000500 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x3, x2, 1352, x3)

inst_704:
// rs1_val==3037000500 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x555, x2, 1360, x3)

inst_705:
// rs1_val==3037000500 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f334, 0xaaa, x2, 1368, x3)

inst_706:
// rs1_val==3037000500 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x5, x2, 1376, x3)

inst_707:
// rs1_val==3037000500 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x333, x2, 1384, x3)

inst_708:
// rs1_val==3037000500 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x666, x2, 1392, x3)

inst_709:
// rs1_val==3037000500 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x2d, x2, 1400, x3)

inst_710:
// rs1_val==3037000500 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x0, x2, 1408, x3)

inst_711:
// rs1_val==3037000500 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x3f, x2, 1416, x3)

inst_712:
// rs1_val==3037000500 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x2, x2, 1424, x3)

inst_713:
// rs1_val==3037000500 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x554, x2, 1432, x3)

inst_714:
// rs1_val==3037000500 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f334, 0xaa9, x2, 1440, x3)

inst_715:
// rs1_val==3037000500 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x4, x2, 1448, x3)

inst_716:
// rs1_val==3037000500 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x332, x2, 1456, x3)

inst_717:
// rs1_val==3037000500 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x665, x2, 1464, x3)

inst_718:
// rs1_val==3037000500 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x2c, x2, 1472, x3)

inst_719:
// rs1_val==3037000500 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x3e, x2, 1480, x3)

inst_720:
// rs1_val==3037000500 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x556, x2, 1488, x3)

inst_721:
// rs1_val==3037000500 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xb504f334, 0xaab, x2, 1496, x3)

inst_722:
// rs1_val==3037000500 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x6, x2, 1504, x3)

inst_723:
// rs1_val==3037000500 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x334, x2, 1512, x3)

inst_724:
// rs1_val==3037000500 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x667, x2, 1520, x3)

inst_725:
// rs1_val==3037000500 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x2e, x2, 1528, x3)

inst_726:
// rs1_val==3037000500 and imm_val==1, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x1
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x1, x2, 1536, x3)

inst_727:
// rs1_val==3037000500 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0xb504f334, 0x40, x2, 1544, x3)

inst_728:
// rs1_val==1 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x3, x2, 1552, x3)

inst_729:
// rs1_val==1 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x555, x2, 1560, x3)

inst_730:
// rs1_val==1 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0xaaa, x2, 1568, x3)

inst_731:
// rs1_val==1 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x5, x2, 1576, x3)

inst_732:
// rs1_val==1 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x333, x2, 1584, x3)

inst_733:
// rs1_val==1 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x666, x2, 1592, x3)

inst_734:
// rs1_val==1 and imm_val==45, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2d
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2d, x2, 1600, x3)

inst_735:
// rs1_val==1 and imm_val==0, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x0
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x1, 0x0, x2, 1608, x3)

inst_736:
// rs1_val==1 and imm_val==63, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x3f
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x3f, x2, 1616, x3)

inst_737:
// rs1_val==1 and imm_val==2, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2, x2, 1624, x3)

inst_738:
// rs1_val==1 and imm_val==1364, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x554
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x554, x2, 1632, x3)

inst_739:
// rs1_val==1 and imm_val==2729, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0xaa9
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0xaa9, x2, 1640, x3)

inst_740:
// rs1_val==1 and imm_val==4, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x4
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x4, x2, 1648, x3)

inst_741:
// rs1_val==1 and imm_val==818, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x332
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x332, x2, 1656, x3)

inst_742:
// rs1_val==1 and imm_val==1637, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x665
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x665, x2, 1664, x3)

inst_743:
// rs1_val==1 and imm_val==44, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2c
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2c, x2, 1672, x3)

inst_744:
// rs1_val==1 and imm_val==62, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x3e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x3e, x2, 1680, x3)

inst_745:
// rs1_val==1 and imm_val==1366, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x556
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x556, x2, 1688, x3)

inst_746:
// rs1_val==1 and imm_val==2731, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0xaab
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0xaab, x2, 1696, x3)

inst_747:
// rs1_val==1 and imm_val==6, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x6
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x6, x2, 1704, x3)

inst_748:
// rs1_val==1 and imm_val==820, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x334
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x334, x2, 1712, x3)

inst_749:
// rs1_val==1 and imm_val==1639, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x667
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x667, x2, 1720, x3)

inst_750:
// rs1_val==1 and imm_val==46, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x2e
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x2e, x2, 1728, x3)

inst_751:
// rs1_val==1 and imm_val==64, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x1;  immval:0x40
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x1, 0x40, x2, 1736, x3)

inst_752:
// rs1_val==4294967297 and imm_val==3, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x3
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x3, x2, 1744, x3)

inst_753:
// rs1_val==4294967297 and imm_val==1365, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x555
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x555, x2, 1752, x3)

inst_754:
// rs1_val==4294967297 and imm_val==2730, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0xaaa
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0x100000001, 0xaaa, x2, 1760, x3)

inst_755:
// rs1_val==4294967297 and imm_val==5, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x5
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x5, x2, 1768, x3)

inst_756:
// rs1_val==4294967297 and imm_val==819, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x333
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x333, x2, 1776, x3)

inst_757:
// rs1_val==4294967297 and imm_val==1638, 
// opcode: sltiu ; op1:x10; dest:x11; op1val:0x100000001;  immval:0x666
TEST_IMM_OP( sltiu, x11, x10, 0x0, 0x100000001, 0x666, x2, 1784, x3)

inst_758:
// imm_val == 2048, rs1_val == 18446744073709549567
// opcode: sltiu ; op1:x10; dest:x11; op1val:0xfffffffffffff7ff;  immval:0x800
TEST_IMM_OP( sltiu, x11, x10, 0x1, 0xfffffffffffff7ff, 0x800, x2, 1792, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x12_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x12_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x2_2:
    .fill 225*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
