
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the sltu instruction of the RISC-V I extension for the sltu covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",sltu)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1 == rs2 != rd, rs1==x16, rs2==x16, rd==x4, rs1_val > 0 and rs2_val > 0, rs1_val == 2048, rs1_val != rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 16
// opcode: sltu ; op1:x16; op2:x16; dest:x4; op1val:0x800;  op2val:0x800
TEST_RR_OP(sltu, x4, x16, x16, 0x0, 0x800, 0x800, x1, 0, x19)

inst_1:
// rs2 == rd != rs1, rs1==x11, rs2==x29, rd==x29, rs1_val == rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 18014398509481984, rs1_val == 18014398509481984
// opcode: sltu ; op1:x11; op2:x29; dest:x29; op1val:0x40000000000000;  op2val:0x40000000000000
TEST_RR_OP(sltu, x29, x11, x29, 0x0, 0x40000000000000, 0x40000000000000, x1, 8, x19)

inst_2:
// rs1 == rs2 == rd, rs1==x12, rs2==x12, rd==x12, rs2_val == 0, rs1_val == 2305843009213693952
// opcode: sltu ; op1:x12; op2:x12; dest:x12; op1val:0x2000000000000000;  op2val:0x2000000000000000
TEST_RR_OP(sltu, x12, x12, x12, 0x0, 0x2000000000000000, 0x2000000000000000, x1, 16, x19)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x31, rs2==x7, rd==x15, rs2_val == (2**(xlen)-1), 
// opcode: sltu ; op1:x31; op2:x7; dest:x15; op1val:0x6;  op2val:0xffffffffffffffff
TEST_RR_OP(sltu, x15, x31, x7, 0x1, 0x6, 0xffffffffffffffff, x1, 24, x19)

inst_4:
// rs1 == rd != rs2, rs1==x26, rs2==x17, rd==x26, rs2_val == 1, rs1_val==6148914691236517204 and rs2_val==1
// opcode: sltu ; op1:x26; op2:x17; dest:x26; op1val:0x5555555555555554;  op2val:0x1
TEST_RR_OP(sltu, x26, x26, x17, 0x0, 0x5555555555555554, 0x1, x1, 32, x19)

inst_5:
// rs1==x29, rs2==x18, rd==x24, rs1_val == 0, rs1_val==0 and rs2_val==1
// opcode: sltu ; op1:x29; op2:x18; dest:x24; op1val:0x0;  op2val:0x1
TEST_RR_OP(sltu, x24, x29, x18, 0x1, 0x0, 0x1, x1, 40, x19)

inst_6:
// rs1==x14, rs2==x22, rd==x25, rs1_val == (2**(xlen)-1), rs2_val == 72057594037927936
// opcode: sltu ; op1:x14; op2:x22; dest:x25; op1val:0xffffffffffffffff;  op2val:0x100000000000000
TEST_RR_OP(sltu, x25, x14, x22, 0x0, 0xffffffffffffffff, 0x100000000000000, x1, 48, x19)

inst_7:
// rs1==x0, rs2==x20, rd==x23, rs1_val == 1, rs2_val == 18446742974197923839
// opcode: sltu ; op1:x0; op2:x20; dest:x23; op1val:0x0;  op2val:0xfffffeffffffffff
TEST_RR_OP(sltu, x23, x0, x20, 0x1, 0x0, 0xfffffeffffffffff, x1, 56, x19)

inst_8:
// rs1==x10, rs2==x5, rd==x0, rs2_val == 2, rs1_val == 1152921504606846976
// opcode: sltu ; op1:x10; op2:x5; dest:x0; op1val:0x1000000000000000;  op2val:0x2
TEST_RR_OP(sltu, x0, x10, x5, 0, 0x1000000000000000, 0x2, x1, 64, x19)

inst_9:
// rs1==x18, rs2==x14, rd==x16, rs2_val == 4, rs1_val == 18446181123756130303
// opcode: sltu ; op1:x18; op2:x14; dest:x16; op1val:0xfffdffffffffffff;  op2val:0x4
TEST_RR_OP(sltu, x16, x18, x14, 0x0, 0xfffdffffffffffff, 0x4, x1, 72, x19)

inst_10:
// rs1==x9, rs2==x24, rd==x8, rs2_val == 8, 
// opcode: sltu ; op1:x9; op2:x24; dest:x8; op1val:0x6666666666666665;  op2val:0x8
TEST_RR_OP(sltu, x8, x9, x24, 0x0, 0x6666666666666665, 0x8, x1, 80, x19)

inst_11:
// rs1==x22, rs2==x9, rd==x31, rs2_val == 32, rs1_val == 36028797018963968
// opcode: sltu ; op1:x22; op2:x9; dest:x31; op1val:0x80000000000000;  op2val:0x20
TEST_RR_OP(sltu, x31, x22, x9, 0x0, 0x80000000000000, 0x20, x1, 88, x19)

inst_12:
// rs1==x21, rs2==x13, rd==x2, rs2_val == 64, rs1_val == 18446744073709551359
// opcode: sltu ; op1:x21; op2:x13; dest:x2; op1val:0xfffffffffffffeff;  op2val:0x40
TEST_RR_OP(sltu, x2, x21, x13, 0x0, 0xfffffffffffffeff, 0x40, x1, 96, x19)

inst_13:
// rs1==x25, rs2==x30, rd==x5, rs2_val == 128, rs1_val == 18446739675663040511
// opcode: sltu ; op1:x25; op2:x30; dest:x5; op1val:0xfffffbffffffffff;  op2val:0x80
TEST_RR_OP(sltu, x5, x25, x30, 0x0, 0xfffffbffffffffff, 0x80, x1, 104, x19)

inst_14:
// rs1==x24, rs2==x4, rd==x11, rs2_val == 256, rs1_val == 144115188075855872
// opcode: sltu ; op1:x24; op2:x4; dest:x11; op1val:0x200000000000000;  op2val:0x100
TEST_RR_OP(sltu, x11, x24, x4, 0x0, 0x200000000000000, 0x100, x1, 112, x19)

inst_15:
// rs1==x13, rs2==x10, rd==x27, rs2_val == 512, rs1_val == 17179869184
// opcode: sltu ; op1:x13; op2:x10; dest:x27; op1val:0x400000000;  op2val:0x200
TEST_RR_OP(sltu, x27, x13, x10, 0x0, 0x400000000, 0x200, x1, 120, x19)

inst_16:
// rs1==x15, rs2==x6, rd==x3, rs2_val == 1024, 
// opcode: sltu ; op1:x15; op2:x6; dest:x3; op1val:0xfffffffffffffeff;  op2val:0x400
TEST_RR_OP(sltu, x3, x15, x6, 0x0, 0xfffffffffffffeff, 0x400, x1, 128, x19)
RVTEST_SIGBASE( x16,signature_x16_0)

inst_17:
// rs1==x17, rs2==x27, rd==x10, rs2_val == 2048, 
// opcode: sltu ; op1:x17; op2:x27; dest:x10; op1val:0xfffdffffffffffff;  op2val:0x800
TEST_RR_OP(sltu, x10, x17, x27, 0x0, 0xfffdffffffffffff, 0x800, x16, 0, x12)

inst_18:
// rs1==x2, rs2==x28, rd==x1, rs2_val == 4096, rs1_val == 8388608
// opcode: sltu ; op1:x2; op2:x28; dest:x1; op1val:0x800000;  op2val:0x1000
TEST_RR_OP(sltu, x1, x2, x28, 0x0, 0x800000, 0x1000, x16, 8, x12)

inst_19:
// rs1==x1, rs2==x26, rd==x28, rs2_val == 8192, rs1_val == 18446744073575333887
// opcode: sltu ; op1:x1; op2:x26; dest:x28; op1val:0xfffffffff7ffffff;  op2val:0x2000
TEST_RR_OP(sltu, x28, x1, x26, 0x0, 0xfffffffff7ffffff, 0x2000, x16, 16, x12)

inst_20:
// rs1==x8, rs2==x23, rd==x14, rs2_val == 16384, 
// opcode: sltu ; op1:x8; op2:x23; dest:x14; op1val:0x2000000000000000;  op2val:0x4000
TEST_RR_OP(sltu, x14, x8, x23, 0x0, 0x2000000000000000, 0x4000, x16, 24, x12)

inst_21:
// rs1==x19, rs2==x2, rd==x20, rs2_val == 32768, rs1_val == 6148914691236517205
// opcode: sltu ; op1:x19; op2:x2; dest:x20; op1val:0x5555555555555555;  op2val:0x8000
TEST_RR_OP(sltu, x20, x19, x2, 0x0, 0x5555555555555555, 0x8000, x16, 32, x12)

inst_22:
// rs1==x30, rs2==x21, rd==x9, rs2_val == 65536, rs1_val == 1024
// opcode: sltu ; op1:x30; op2:x21; dest:x9; op1val:0x400;  op2val:0x10000
TEST_RR_OP(sltu, x9, x30, x21, 0x1, 0x400, 0x10000, x16, 40, x12)

inst_23:
// rs1==x6, rs2==x0, rd==x21, rs2_val == 131072, rs1_val == 2097152
// opcode: sltu ; op1:x6; op2:x0; dest:x21; op1val:0x200000;  op2val:0x0
TEST_RR_OP(sltu, x21, x6, x0, 0x0, 0x200000, 0x0, x16, 48, x12)

inst_24:
// rs1==x27, rs2==x11, rd==x7, rs2_val == 262144, rs1_val == 9007199254740992
// opcode: sltu ; op1:x27; op2:x11; dest:x7; op1val:0x20000000000000;  op2val:0x40000
TEST_RR_OP(sltu, x7, x27, x11, 0x0, 0x20000000000000, 0x40000, x16, 56, x12)

inst_25:
// rs1==x20, rs2==x3, rd==x17, rs2_val == 524288, rs1_val == 268435456
// opcode: sltu ; op1:x20; op2:x3; dest:x17; op1val:0x10000000;  op2val:0x80000
TEST_RR_OP(sltu, x17, x20, x3, 0x0, 0x10000000, 0x80000, x16, 64, x12)

inst_26:
// rs1==x23, rs2==x31, rd==x22, rs2_val == 1048576, rs1_val == 18428729675200069631
// opcode: sltu ; op1:x23; op2:x31; dest:x22; op1val:0xffbfffffffffffff;  op2val:0x100000
TEST_RR_OP(sltu, x22, x23, x31, 0x0, 0xffbfffffffffffff, 0x100000, x16, 72, x12)

inst_27:
// rs1==x28, rs2==x25, rd==x18, rs2_val == 2097152, rs1_val == 33554432
// opcode: sltu ; op1:x28; op2:x25; dest:x18; op1val:0x2000000;  op2val:0x200000
TEST_RR_OP(sltu, x18, x28, x25, 0x0, 0x2000000, 0x200000, x16, 80, x12)

inst_28:
// rs1==x5, rs2==x19, rd==x13, rs2_val == 4194304, rs1_val == 12297829382473034410
// opcode: sltu ; op1:x5; op2:x19; dest:x13; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x400000
TEST_RR_OP(sltu, x13, x5, x19, 0x0, 0xaaaaaaaaaaaaaaaa, 0x400000, x16, 88, x12)

inst_29:
// rs1==x7, rs2==x1, rd==x19, rs2_val == 8388608, 
// opcode: sltu ; op1:x7; op2:x1; dest:x19; op1val:0x0;  op2val:0x800000
TEST_RR_OP(sltu, x19, x7, x1, 0x1, 0x0, 0x800000, x16, 96, x12)

inst_30:
// rs1==x3, rs2==x15, rd==x30, rs2_val == 16777216, 
// opcode: sltu ; op1:x3; op2:x15; dest:x30; op1val:0x13;  op2val:0x1000000
TEST_RR_OP(sltu, x30, x3, x15, 0x1, 0x13, 0x1000000, x16, 104, x12)

inst_31:
// rs1==x4, rs2==x8, rd==x6, rs2_val == 33554432, 
// opcode: sltu ; op1:x4; op2:x8; dest:x6; op1val:0x11;  op2val:0x2000000
TEST_RR_OP(sltu, x6, x4, x8, 0x1, 0x11, 0x2000000, x16, 112, x12)

inst_32:
// rs2_val == 67108864, rs1_val == 18445618173802708991
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffbffffffffffff;  op2val:0x4000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffbffffffffffff, 0x4000000, x16, 120, x2)
RVTEST_SIGBASE( x1,signature_x1_2)

inst_33:
// rs2_val == 134217728, rs1_val == 18446744073705357311
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffbfffff;  op2val:0x8000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffbfffff, 0x8000000, x1, 0, x2)

inst_34:
// rs2_val == 268435456, rs1_val == 18446743798831644671
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffbfffffffff;  op2val:0x10000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffbfffffffff, 0x10000000, x1, 8, x2)

inst_35:
// rs2_val == 536870912, rs1_val == 17293822569102704639
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xefffffffffffffff;  op2val:0x20000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xefffffffffffffff, 0x20000000, x1, 16, x2)

inst_36:
// rs2_val == 1073741824, rs1_val == 18446744073709551487
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffff7f;  op2val:0x40000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffff7f, 0x40000000, x1, 24, x2)

inst_37:
// rs2_val == 2147483648, rs1_val == 18446744073642442751
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffbffffff;  op2val:0x80000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffbffffff, 0x80000000, x1, 32, x2)

inst_38:
// rs2_val == 4294967296, rs1_val == 18446744073709551613
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffd;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffffd, 0x100000000, x1, 40, x2)

inst_39:
// rs2_val == 8589934592, rs1_val == 18446744073709289471
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffbffff;  op2val:0x200000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffbffff, 0x200000000, x1, 48, x2)

inst_40:
// rs2_val == 17179869184, rs1_val == 18446744073675997183
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffdffffff;  op2val:0x400000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffdffffff, 0x400000000, x1, 56, x2)

inst_41:
// rs2_val == 34359738368, rs1_val == 9223372036854775807
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:0x800000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x7fffffffffffffff, 0x800000000, x1, 64, x2)

inst_42:
// rs2_val == 68719476736, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0x1000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x800, 0x1000000000, x1, 72, x2)

inst_43:
// rs2_val == 137438953472, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x2000000000, x1, 80, x2)

inst_44:
// rs2_val == 274877906944, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x7;  op2val:0x4000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x7, 0x4000000000, x1, 88, x2)

inst_45:
// rs2_val == 549755813888, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x8000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x8000000000, x1, 96, x2)

inst_46:
// rs2_val == 1099511627776, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x10000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x10000000000, x1, 104, x2)

inst_47:
// rs2_val == 2199023255552, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x20000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x20000000000, x1, 112, x2)

inst_48:
// rs2_val == 4398046511104, rs1_val == 18437736874454810623
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffdfffffffffffff;  op2val:0x40000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffdfffffffffffff, 0x40000000000, x1, 120, x2)

inst_49:
// rs2_val == 8796093022208, rs1_val == 2199023255552
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0x80000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x20000000000, 0x80000000000, x1, 128, x2)

inst_50:
// rs2_val == 17592186044416, rs1_val == 576460752303423488
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0x100000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x800000000000000, 0x100000000000, x1, 136, x2)

inst_51:
// rs2_val == 35184372088832, rs1_val == 18446744073709551599
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffef;  op2val:0x200000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffffef, 0x200000000000, x1, 144, x2)

inst_52:
// rs2_val == 70368744177664, rs1_val == 32
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:0x400000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x20, 0x400000000000, x1, 152, x2)

inst_53:
// rs2_val == 140737488355328, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x800000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x800000000000, x1, 160, x2)

inst_54:
// rs2_val == 281474976710656, rs1_val == 18446673704965373951
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffbfffffffffff;  op2val:0x1000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffbfffffffffff, 0x1000000000000, x1, 168, x2)

inst_55:
// rs2_val == 562949953421312, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffd;  op2val:0x2000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffffd, 0x2000000000000, x1, 176, x2)

inst_56:
// rs2_val == 1125899906842624, rs1_val == 16140901064495857663
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xdfffffffffffffff;  op2val:0x4000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xdfffffffffffffff, 0x4000000000000, x1, 184, x2)

inst_57:
// rs2_val == 2251799813685248, rs1_val == 1048576
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0x8000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000, 0x8000000000000, x1, 192, x2)

inst_58:
// rs2_val == 4503599627370496, rs1_val == 18446744073709551103
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffdff;  op2val:0x10000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffdff, 0x10000000000000, x1, 200, x2)

inst_59:
// rs2_val == 9007199254740992, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x20000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x20000000000000, x1, 208, x2)

inst_60:
// rs2_val == 36028797018963968, rs1_val == 288230376151711744
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0x80000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x400000000000000, 0x80000000000000, x1, 216, x2)

inst_61:
// rs2_val == 144115188075855872, rs1_val == 18446744073709547519
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffefff;  op2val:0x200000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffefff, 0x200000000000000, x1, 224, x2)

inst_62:
// rs2_val == 288230376151711744, rs1_val == 18374686479671623679
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfeffffffffffffff;  op2val:0x400000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfeffffffffffffff, 0x400000000000000, x1, 232, x2)

inst_63:
// rs2_val == 576460752303423488, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xa;  op2val:0x800000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xa, 0x800000000000000, x1, 240, x2)

inst_64:
// rs2_val == 1152921504606846976, rs1_val == 18446743523953737727
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffff7fffffffff;  op2val:0x1000000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffff7fffffffff, 0x1000000000000000, x1, 248, x2)

inst_65:
// rs2_val == 2305843009213693952, rs1_val == 18446744073692774399
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffeffffff;  op2val:0x2000000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffeffffff, 0x2000000000000000, x1, 256, x2)

inst_66:
// rs2_val == 4611686018427387904, rs1_val == 4611686018427387904
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0x4000000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x4000000000000000, 0x4000000000000000, x1, 264, x2)

inst_67:
// rs2_val == 9223372036854775808, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfeffffffffffffff;  op2val:0x8000000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfeffffffffffffff, 0x8000000000000000, x1, 272, x2)

inst_68:
// rs2_val == 18446744073709551614, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xfffffffffffffffe
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xfffffffffffffffe, x1, 280, x2)

inst_69:
// rs2_val == 18446744073709551613, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xfffffffffffffffd
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0xfffffffffffffffd, x1, 288, x2)

inst_70:
// rs2_val == 18446744073709551611, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xfffffffffffffffb
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0xfffffffffffffffb, x1, 296, x2)

inst_71:
// rs2_val == 18446744073709551607, rs1_val == 32768
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0xfffffffffffffff7
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x8000, 0xfffffffffffffff7, x1, 304, x2)

inst_72:
// rs2_val == 18446744073709551599, rs1_val == 262144
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0xffffffffffffffef
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x40000, 0xffffffffffffffef, x1, 312, x2)

inst_73:
// rs2_val == 18446744073709551583, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xffffffffffffffdf
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xffffffffffffffdf, x1, 320, x2)

inst_74:
// rs2_val == 18446744073709551551, rs1_val == 2
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xffffffffffffffbf
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xffffffffffffffbf, x1, 328, x2)

inst_75:
// rs2_val == 18446744073709551487, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffeff;  op2val:0xffffffffffffff7f
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xfffffffffffffeff, 0xffffffffffffff7f, x1, 336, x2)

inst_76:
// rs2_val == 18446744073709551359, rs1_val == 4
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xfffffffffffffeff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xfffffffffffffeff, x1, 344, x2)

inst_77:
// rs2_val == 18446744073709551103, rs1_val == 274877906944
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0xfffffffffffffdff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4000000000, 0xfffffffffffffdff, x1, 352, x2)

inst_78:
// rs2_val == 18446744073709550591, rs1_val == 67108864
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0xfffffffffffffbff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4000000, 0xfffffffffffffbff, x1, 360, x2)

inst_79:
// rs2_val == 18446744073709549567, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xfffffffffffff7ff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xfffffffffffff7ff, x1, 368, x2)

inst_80:
// rs2_val == 18446744073709547519, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0xffffffffffffefff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x400000000000000, 0xffffffffffffefff, x1, 376, x2)

inst_81:
// rs2_val == 18446744073709543423, rs1_val == 549755813888
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0xffffffffffffdfff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x8000000000, 0xffffffffffffdfff, x1, 384, x2)

inst_82:
// rs2_val == 18446744073709535231, rs1_val == 18446742974197923839
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffeffffffffff;  op2val:0xffffffffffffbfff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xfffffeffffffffff, 0xffffffffffffbfff, x1, 392, x2)

inst_83:
// rs2_val == 18446744073709518847, rs1_val == 18446744073709550591
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffbff;  op2val:0xffffffffffff7fff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffbff, 0xffffffffffff7fff, x1, 400, x2)

inst_84:
// rs2_val == 18446744073709486079, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0xfffffffffffeffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x20000000000000, 0xfffffffffffeffff, x1, 408, x2)

inst_85:
// rs2_val == 18446744073709420543, rs1_val == 18446744073709543423
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffdfff;  op2val:0xfffffffffffdffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffdfff, 0xfffffffffffdffff, x1, 416, x2)

inst_86:
// rs2_val == 18446744073709289471, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0xfffffffffffbffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2000000, 0xfffffffffffbffff, x1, 424, x2)

inst_87:
// rs2_val == 18446744073709027327, rs1_val == 65536
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:0xfffffffffff7ffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x10000, 0xfffffffffff7ffff, x1, 432, x2)

inst_88:
// rs2_val == 18446744073708503039, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffdffffffffffff;  op2val:0xffffffffffefffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xfffdffffffffffff, 0xffffffffffefffff, x1, 440, x2)

inst_89:
// rs2_val == 18446744073707454463, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xffffffffffdfffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0xffffffffffdfffff, x1, 448, x2)

inst_90:
// rs2_val == 18446744073705357311, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0xffffffffffbfffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4000000000000000, 0xffffffffffbfffff, x1, 456, x2)

inst_91:
// rs2_val == 18446744073701163007, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffdff;  op2val:0xffffffffff7fffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffdff, 0xffffffffff7fffff, x1, 464, x2)

inst_92:
// rs2_val == 18446744073692774399, rs1_val == 18446741874686296063
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffdffffffffff;  op2val:0xfffffffffeffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xfffffdffffffffff, 0xfffffffffeffffff, x1, 472, x2)

inst_93:
// rs2_val == 18446744073675997183, rs1_val == 18446744073709535231
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffbfff;  op2val:0xfffffffffdffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffbfff, 0xfffffffffdffffff, x1, 480, x2)

inst_94:
// rs2_val == 18446744073642442751, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0xfffffffffbffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x40000000000000, 0xfffffffffbffffff, x1, 488, x2)

inst_95:
// rs2_val == 18446744073575333887, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffbfffffffffff;  op2val:0xfffffffff7ffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffbfffffffffff, 0xfffffffff7ffffff, x1, 496, x2)

inst_96:
// rs2_val == 18446744073441116159, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0xffffffffefffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x400000000000000, 0xffffffffefffffff, x1, 504, x2)

inst_97:
// rs2_val == 18446744073172680703, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:0xffffffffdfffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2000000000000000, 0xffffffffdfffffff, x1, 512, x2)

inst_98:
// rs2_val == 18446744072635809791, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xffffffffbfffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666665, 0xffffffffbfffffff, x1, 520, x2)

inst_99:
// rs2_val == 18446744071562067967, rs1_val == 8192
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0xffffffff7fffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2000, 0xffffffff7fffffff, x1, 528, x2)

inst_100:
// rs2_val == 18446744069414584319, rs1_val == 17870283321406128127
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xf7ffffffffffffff;  op2val:0xfffffffeffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xf7ffffffffffffff, 0xfffffffeffffffff, x1, 536, x2)

inst_101:
// rs2_val == 18446744065119617023, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x12;  op2val:0xfffffffdffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x12, 0xfffffffdffffffff, x1, 544, x2)

inst_102:
// rs2_val == 18446744056529682431, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xfffffffbffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0xfffffffbffffffff, x1, 552, x2)

inst_103:
// rs2_val == 18446744039349813247, rs1_val == 16384
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:0xfffffff7ffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4000, 0xfffffff7ffffffff, x1, 560, x2)

inst_104:
// rs2_val == 18446744004990074879, rs1_val == 18410715276690587647
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xff7fffffffffffff;  op2val:0xffffffefffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xff7fffffffffffff, 0xffffffefffffffff, x1, 568, x2)

inst_105:
// rs2_val == 18446743936270598143, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xffffffdfffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0xffffffdfffffffff, x1, 576, x2)

inst_106:
// rs2_val == 18446743798831644671, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffffffbfffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xffffffbfffffffff, x1, 584, x2)

inst_107:
// rs2_val == 18446743523953737727, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffffff7fffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xffffff7fffffffff, x1, 592, x2)

inst_108:
// rs2_val == 18446741874686296063, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xfffffdffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0xfffffdffffffffff, x1, 600, x2)

inst_109:
// rs2_val == 18446739675663040511, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xfffffbffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666666, 0xfffffbffffffffff, x1, 608, x2)

inst_110:
// rs2_val == 18446735277616529407, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xfffff7ffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0xfffff7ffffffffff, x1, 616, x2)

inst_111:
// rs2_val == 18446726481523507199, rs1_val == 524288
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0xffffefffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x80000, 0xffffefffffffffff, x1, 624, x2)

inst_112:
// rs2_val == 18446708889337462783, rs1_val == 18446744073709551583
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffdf;  op2val:0xffffdfffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffffdf, 0xffffdfffffffffff, x1, 632, x2)

inst_113:
// rs2_val == 18446673704965373951, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0xffffbfffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x8000, 0xffffbfffffffffff, x1, 640, x2)

inst_114:
// rs2_val == 18446603336221196287, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xff7fffffffffffff;  op2val:0xffff7fffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xff7fffffffffffff, 0xffff7fffffffffff, x1, 648, x2)

inst_115:
// rs2_val == 18446462598732840959, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffdfff;  op2val:0xfffeffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffdfff, 0xfffeffffffffffff, x1, 656, x2)

inst_116:
// rs2_val == 18446181123756130303, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x11;  op2val:0xfffdffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x11, 0xfffdffffffffffff, x1, 664, x2)

inst_117:
// rs2_val == 18445618173802708991, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffbfffffffff;  op2val:0xfffbffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffbfffffffff, 0xfffbffffffffffff, x1, 672, x2)

inst_118:
// rs2_val == 18444492273895866367, rs1_val == 18446744056529682431
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffbffffffff;  op2val:0xfff7ffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffbffffffff, 0xfff7ffffffffffff, x1, 680, x2)

inst_119:
// rs2_val == 18442240474082181119, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xffefffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0xffefffffffffffff, x1, 688, x2)

inst_120:
// rs2_val == 18437736874454810623, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xffdfffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555556, 0xffdfffffffffffff, x1, 696, x2)

inst_121:
// rs2_val == 18428729675200069631, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xc;  op2val:0xffbfffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xc, 0xffbfffffffffffff, x1, 704, x2)

inst_122:
// rs2_val == 18410715276690587647, rs1_val == 18302628885633695743
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfdffffffffffffff;  op2val:0xff7fffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xfdffffffffffffff, 0xff7fffffffffffff, x1, 712, x2)

inst_123:
// rs2_val == 18374686479671623679, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffdfff;  op2val:0xfeffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffdfff, 0xfeffffffffffffff, x1, 720, x2)

inst_124:
// rs2_val == 18302628885633695743, rs1_val == 18446744073709551607
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffff7;  op2val:0xfdffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffff7, 0xfdffffffffffffff, x1, 728, x2)

inst_125:
// rs2_val == 18158513697557839871, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0xfbffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4000000000, 0xfbffffffffffffff, x1, 736, x2)

inst_126:
// rs2_val == 17870283321406128127, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0xf7ffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x8000000000, 0xf7ffffffffffffff, x1, 744, x2)

inst_127:
// rs2_val == 17293822569102704639, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xd;  op2val:0xefffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xd, 0xefffffffffffffff, x1, 752, x2)

inst_128:
// rs2_val == 16140901064495857663, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0xdfffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x800, 0xdfffffffffffffff, x1, 760, x2)

inst_129:
// rs2_val == 13835058055282163711, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0xbfffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x40000, 0xbfffffffffffffff, x1, 768, x2)

inst_130:
// rs2_val == 9223372036854775807, rs1_val == 18446744073709518847
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffff7fff;  op2val:0x7fffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffff7fff, 0x7fffffffffffffff, x1, 776, x2)

inst_131:
// rs2_val == 6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffdfff;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffffdfff, 0x5555555555555555, x1, 784, x2)

inst_132:
// rs2_val == 12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffdff;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffdff, 0xaaaaaaaaaaaaaaaa, x1, 792, x2)

inst_133:
// rs1_val == 8, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:0x400000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x8, 0x400000000000, x1, 800, x2)

inst_134:
// rs1_val == 16, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x10, 0x3333333333333333, x1, 808, x2)

inst_135:
// rs1_val == 64, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0x8000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x40, 0x8000000000000, x1, 816, x2)

inst_136:
// rs1_val == 128, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0xffffffffffbfffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x80, 0xffffffffffbfffff, x1, 824, x2)

inst_137:
// rs1_val == 256, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:0x20000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100, 0x20000000, x1, 832, x2)

inst_138:
// rs1_val == 512, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:0x1000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x200, 0x1000000000000, x1, 840, x2)

inst_139:
// rs1_val == 4096, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0xf7ffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1000, 0xf7ffffffffffffff, x1, 848, x2)

inst_140:
// rs1_val == 131072, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0xffffffefffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x20000, 0xffffffefffffffff, x1, 856, x2)

inst_141:
// rs1_val == 4194304, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x40000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x400000, 0x40000, x1, 864, x2)

inst_142:
// rs1_val == 16777216, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0xffffffffffffefff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1000000, 0xffffffffffffefff, x1, 872, x2)

inst_143:
// rs1_val == 134217728, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0xffffffffffffffef
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x8000000, 0xffffffffffffffef, x1, 880, x2)

inst_144:
// rs1_val == 536870912, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x20000000, 0xaaaaaaaaaaaaaaaa, x1, 888, x2)

inst_145:
// rs1_val == 1073741824, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x40000000, 0x4, x1, 896, x2)

inst_146:
// rs1_val == 2147483648, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0x20000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x80000000, 0x20000000, x1, 904, x2)

inst_147:
// rs1_val == 4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x800000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x800000000, x1, 912, x2)

inst_148:
// rs1_val == 8589934592, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0xfffffeffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x200000000, 0xfffffeffffffffff, x1, 920, x2)

inst_149:
// rs1_val == 34359738368, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x1000000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x800000000, 0x1000000000000000, x1, 928, x2)

inst_150:
// rs1_val == 68719476736, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0xd
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x1000000000, 0xd, x1, 936, x2)

inst_151:
// rs1_val == 137438953472, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0xffffffffffbfffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2000000000, 0xffffffffffbfffff, x1, 944, x2)

inst_152:
// rs1_val == 1099511627776, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0x2000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x10000000000, 0x2000000, x1, 952, x2)

inst_153:
// rs1_val == 4398046511104, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0x100000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x40000000000, 0x100000, x1, 960, x2)

inst_154:
// rs1_val == 8796093022208, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x80000000000, 0x3333333333333332, x1, 968, x2)

inst_155:
// rs1_val == 17592186044416, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x800
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000000, 0x800, x1, 976, x2)

inst_156:
// rs1_val == 35184372088832, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x1000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x200000000000, 0x1000000000, x1, 984, x2)

inst_157:
// rs1_val == 70368744177664, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x100000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x400000000000, 0x100000000000, x1, 992, x2)

inst_158:
// rs1_val == 140737488355328, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x800
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x800000000000, 0x800, x1, 1000, x2)

inst_159:
// rs1_val == 281474976710656, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0xfffeffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1000000000000, 0xfffeffffffffffff, x1, 1008, x2)

inst_160:
// rs1_val == 562949953421312, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0xf
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x2000000000000, 0xf, x1, 1016, x2)

inst_161:
// rs1_val == 1125899906842624, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0x200000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4000000000000, 0x200000000000000, x1, 1024, x2)

inst_162:
// rs1_val == 2251799813685248, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0x100000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x8000000000000, 0x100000, x1, 1032, x2)

inst_163:
// rs1_val == 4503599627370496, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0xfffffffffffffdff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x10000000000000, 0xfffffffffffffdff, x1, 1040, x2)

inst_164:
// rs1_val == 72057594037927936, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0xfffffdffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000000000, 0xfffffdffffffffff, x1, 1048, x2)

inst_165:
// rs1_val == 9223372036854775808, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000000;  op2val:0x8000000000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x8000000000000000, 0x8000000000000000, x1, 1056, x2)

inst_166:
// rs1_val == 18446744073709551614, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffe;  op2val:0x200000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffffe, 0x200000000, x1, 1064, x2)

inst_167:
// rs1_val == 18446744073709551611, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffb;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffffffb, 0x6, x1, 1072, x2)

inst_168:
// rs1_val == 18446744073709551551, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffbf;  op2val:0xfffffffffffffffd
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffffffffffbf, 0xfffffffffffffffd, x1, 1080, x2)

inst_169:
// rs1_val == 18446744073709549567, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffff7ff;  op2val:0xffff7fffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffff7ff, 0xffff7fffffffffff, x1, 1088, x2)

inst_170:
// rs1_val == 18446744073709486079, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffeffff;  op2val:0xfdffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffeffff, 0xfdffffffffffffff, x1, 1096, x2)

inst_171:
// rs1_val == 18446744073709420543, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffdffff;  op2val:0x9
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffffdffff, 0x9, x1, 1104, x2)

inst_172:
// rs1_val == 18446744073709027327, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffff7ffff;  op2val:0x100000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffffff7ffff, 0x100000, x1, 1112, x2)

inst_173:
// rs1_val == 18446744073708503039, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffefffff;  op2val:0x100
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffefffff, 0x100, x1, 1120, x2)

inst_174:
// rs1_val == 18446744073707454463, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffdfffff;  op2val:0x10000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffffdfffff, 0x10000000000, x1, 1128, x2)

inst_175:
// rs1_val == 18446744073701163007, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffff7fffff;  op2val:0xfffdffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffff7fffff, 0xfffdffffffffffff, x1, 1136, x2)

inst_176:
// rs1_val == 18446744073441116159, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffefffffff;  op2val:0xfeffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffefffffff, 0xfeffffffffffffff, x1, 1144, x2)

inst_177:
// rs1_val == 18446744073172680703, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffdfffffff;  op2val:0x200000000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffffdfffffff, 0x200000000000, x1, 1152, x2)

inst_178:
// rs1_val == 18446744072635809791, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffbfffffff;  op2val:0xffffffffffefffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffffbfffffff, 0xffffffffffefffff, x1, 1160, x2)

inst_179:
// rs1_val == 18446744071562067967, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff7fffffff;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff7fffffff, 0x4, x1, 1168, x2)

inst_180:
// rs1_val == 18446744069414584319, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffeffffffff;  op2val:0x10
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffeffffffff, 0x10, x1, 1176, x2)

inst_181:
// rs1_val == 18446744065119617023, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffdffffffff;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffffdffffffff, 0x6, x1, 1184, x2)

inst_182:
// rs1_val == 18446744039349813247, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffff7ffffffff;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffffff7ffffffff, 0x6666666666666665, x1, 1192, x2)

inst_183:
// rs1_val == 18446744004990074879, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffefffffffff;  op2val:0x20000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffefffffffff, 0x20000000, x1, 1200, x2)

inst_184:
// rs1_val == 18446743936270598143, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffdfffffffff;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffdfffffffff, 0xaaaaaaaaaaaaaaa9, x1, 1208, x2)

inst_185:
// rs1_val == 18446735277616529407, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffff7ffffffffff;  op2val:0xff7fffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffff7ffffffffff, 0xff7fffffffffffff, x1, 1216, x2)

inst_186:
// rs1_val == 18446726481523507199, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffefffffffffff;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffefffffffffff, 0x2, x1, 1224, x2)

inst_187:
// rs1_val == 18446708889337462783, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffdfffffffffff;  op2val:0x200
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffdfffffffffff, 0x200, x1, 1232, x2)

inst_188:
// rs1_val == 18446603336221196287, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffff7fffffffffff;  op2val:0x7
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffff7fffffffffff, 0x7, x1, 1240, x2)

inst_189:
// rs1_val == 18446462598732840959, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfffeffffffffffff;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfffeffffffffffff, 0xb504f332, x1, 1248, x2)

inst_190:
// rs1_val == 18444492273895866367, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfff7ffffffffffff;  op2val:0xfffffffeffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xfff7ffffffffffff, 0xfffffffeffffffff, x1, 1256, x2)

inst_191:
// rs1_val == 18442240474082181119, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffefffffffffffff;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffefffffffffffff, 0x2, x1, 1264, x2)

inst_192:
// rs1_val == 18158513697557839871, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xfbffffffffffffff;  op2val:0xf7ffffffffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xfbffffffffffffff, 0xf7ffffffffffffff, x1, 1272, x2)

inst_193:
// rs1_val == 13835058055282163711, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xbfffffffffffffff;  op2val:0xfffffffffffffeff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xbfffffffffffffff, 0xfffffffffffffeff, x1, 1280, x2)

inst_194:
// rs1_val==3 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3, 0x3, x1, 1288, x2)

inst_195:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x5555555555555555, x1, 1296, x2)

inst_196:
// rs1_val==3 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0xaaaaaaaaaaaaaaaa, x1, 1304, x2)

inst_197:
// rs1_val==3 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x5, x1, 1312, x2)

inst_198:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x3333333333333333, x1, 1320, x2)

inst_199:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x6666666666666666, x1, 1328, x2)

inst_200:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0xb504f333, x1, 1336, x2)

inst_201:
// rs1_val==3 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3, 0x0, x1, 1344, x2)

inst_202:
// rs1_val==3 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x100000000, x1, 1352, x2)

inst_203:
// rs1_val==3 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3, 0x2, x1, 1360, x2)

inst_204:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x5555555555555554, x1, 1368, x2)

inst_205:
// rs1_val==3 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0xaaaaaaaaaaaaaaa9, x1, 1376, x2)

inst_206:
// rs1_val==3 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x4, x1, 1384, x2)

inst_207:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x3333333333333332, x1, 1392, x2)

inst_208:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x6666666666666665, x1, 1400, x2)

inst_209:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0xb504f332, x1, 1408, x2)

inst_210:
// rs1_val==3 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0xffffffff, x1, 1416, x2)

inst_211:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x5555555555555556, x1, 1424, x2)

inst_212:
// rs1_val==3 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0xaaaaaaaaaaaaaaab, x1, 1432, x2)

inst_213:
// rs1_val==3 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x6, x1, 1440, x2)

inst_214:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x3333333333333334, x1, 1448, x2)

inst_215:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x6666666666666667, x1, 1456, x2)

inst_216:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0xb504f334, x1, 1464, x2)

inst_217:
// rs1_val==3 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3, 0x1, x1, 1472, x2)

inst_218:
// rs1_val==3 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3, 0x100000001, x1, 1480, x2)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x3, x1, 1488, x2)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555555, x1, 1496, x2)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555555, 0xaaaaaaaaaaaaaaaa, x1, 1504, x2)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x5, x1, 1512, x2)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x3333333333333333, x1, 1520, x2)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555555, 0x6666666666666666, x1, 1528, x2)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0xb504f333, x1, 1536, x2)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x0, x1, 1544, x2)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x100000000, x1, 1552, x2)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x2, x1, 1560, x2)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555554, x1, 1568, x2)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555555, 0xaaaaaaaaaaaaaaa9, x1, 1576, x2)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x4, x1, 1584, x2)

inst_232:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x3333333333333332, x1, 1592, x2)

inst_233:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555555, 0x6666666666666665, x1, 1600, x2)

inst_234:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0xb504f332, x1, 1608, x2)

inst_235:
// rs1_val==6148914691236517205 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0xffffffff, x1, 1616, x2)

inst_236:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555556, x1, 1624, x2)

inst_237:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555555, 0xaaaaaaaaaaaaaaab, x1, 1632, x2)

inst_238:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x6, x1, 1640, x2)

inst_239:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x3333333333333334, x1, 1648, x2)

inst_240:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555555, 0x6666666666666667, x1, 1656, x2)

inst_241:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0xb504f334, x1, 1664, x2)

inst_242:
// rs1_val==6148914691236517205 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x1, x1, 1672, x2)

inst_243:
// rs1_val==6148914691236517205 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555555, 0x100000001, x1, 1680, x2)

inst_244:
// rs1_val==12297829382473034410 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x3, x1, 1688, x2)

inst_245:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5555555555555555, x1, 1696, x2)

inst_246:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, x1, 1704, x2)

inst_247:
// rs1_val==12297829382473034410 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5, x1, 1712, x2)

inst_248:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x3333333333333333, x1, 1720, x2)

inst_249:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x6666666666666666, x1, 1728, x2)

inst_250:
// rs1_val==12297829382473034410 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xb504f333, x1, 1736, x2)

inst_251:
// rs1_val==12297829382473034410 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x0, x1, 1744, x2)

inst_252:
// rs1_val==12297829382473034410 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x100000000, x1, 1752, x2)

inst_253:
// rs1_val==12297829382473034410 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x2, x1, 1760, x2)

inst_254:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5555555555555554, x1, 1768, x2)

inst_255:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaa9, x1, 1776, x2)

inst_256:
// rs1_val==12297829382473034410 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x4, x1, 1784, x2)

inst_257:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x3333333333333332, x1, 1792, x2)

inst_258:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x6666666666666665, x1, 1800, x2)

inst_259:
// rs1_val==12297829382473034410 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xb504f332, x1, 1808, x2)

inst_260:
// rs1_val==12297829382473034410 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xffffffff, x1, 1816, x2)

inst_261:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5555555555555556, x1, 1824, x2)

inst_262:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaab, x1, 1832, x2)

inst_263:
// rs1_val==12297829382473034410 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x6, x1, 1840, x2)

inst_264:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x3333333333333334, x1, 1848, x2)

inst_265:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x6666666666666667, x1, 1856, x2)

inst_266:
// rs1_val==12297829382473034410 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xb504f334, x1, 1864, x2)

inst_267:
// rs1_val==12297829382473034410 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x1, x1, 1872, x2)

inst_268:
// rs1_val==12297829382473034410 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x100000001, x1, 1880, x2)

inst_269:
// rs1_val==5 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5, 0x3, x1, 1888, x2)

inst_270:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x5555555555555555, x1, 1896, x2)

inst_271:
// rs1_val==5 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xaaaaaaaaaaaaaaaa, x1, 1904, x2)

inst_272:
// rs1_val==5 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5, 0x5, x1, 1912, x2)

inst_273:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x3333333333333333, x1, 1920, x2)

inst_274:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x6666666666666666, x1, 1928, x2)

inst_275:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xb504f333, x1, 1936, x2)

inst_276:
// rs1_val==5 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5, 0x0, x1, 1944, x2)

inst_277:
// rs1_val==5 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x100000000, x1, 1952, x2)

inst_278:
// rs1_val==5 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5, 0x2, x1, 1960, x2)

inst_279:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x5555555555555554, x1, 1968, x2)

inst_280:
// rs1_val==5 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xaaaaaaaaaaaaaaa9, x1, 1976, x2)

inst_281:
// rs1_val==5 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5, 0x4, x1, 1984, x2)

inst_282:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x3333333333333332, x1, 1992, x2)

inst_283:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x6666666666666665, x1, 2000, x2)

inst_284:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xb504f332, x1, 2008, x2)

inst_285:
// rs1_val==5 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xffffffff, x1, 2016, x2)

inst_286:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x5555555555555556, x1, 2024, x2)

inst_287:
// rs1_val==5 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xaaaaaaaaaaaaaaab, x1, 2032, x2)

inst_288:
// rs1_val==5 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x6, x1, 2040, x2)
RVTEST_SIGBASE( x1,signature_x1_3)

inst_289:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x3333333333333334, x1, 0, x2)

inst_290:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x6666666666666667, x1, 8, x2)

inst_291:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0xb504f334, x1, 16, x2)

inst_292:
// rs1_val==5 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5, 0x1, x1, 24, x2)

inst_293:
// rs1_val==5 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5, 0x100000001, x1, 32, x2)

inst_294:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x3, x1, 40, x2)

inst_295:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0x5555555555555555, x1, 48, x2)

inst_296:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0xaaaaaaaaaaaaaaaa, x1, 56, x2)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x5, x1, 64, x2)

inst_298:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333333, x1, 72, x2)

inst_299:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0x6666666666666666, x1, 80, x2)

inst_300:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f333, x1, 88, x2)

inst_301:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x0, x1, 96, x2)

inst_302:
// rs1_val==3689348814741910323 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x100000000, x1, 104, x2)

inst_303:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x2, x1, 112, x2)

inst_304:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0x5555555555555554, x1, 120, x2)

inst_305:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0xaaaaaaaaaaaaaaa9, x1, 128, x2)

inst_306:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x4, x1, 136, x2)

inst_307:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333332, x1, 144, x2)

inst_308:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0x6666666666666665, x1, 152, x2)

inst_309:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f332, x1, 160, x2)

inst_310:
// rs1_val==3689348814741910323 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0xffffffff, x1, 168, x2)

inst_311:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0x5555555555555556, x1, 176, x2)

inst_312:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0xaaaaaaaaaaaaaaab, x1, 184, x2)

inst_313:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x6, x1, 192, x2)

inst_314:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333334, x1, 200, x2)

inst_315:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333333, 0x6666666666666667, x1, 208, x2)

inst_316:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f334, x1, 216, x2)

inst_317:
// rs1_val==3689348814741910323 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x1, x1, 224, x2)

inst_318:
// rs1_val==3689348814741910323 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333333, 0x100000001, x1, 232, x2)

inst_319:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x3, x1, 240, x2)

inst_320:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x5555555555555555, x1, 248, x2)

inst_321:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666666, 0xaaaaaaaaaaaaaaaa, x1, 256, x2)

inst_322:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x5, x1, 264, x2)

inst_323:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333333, x1, 272, x2)

inst_324:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666666, x1, 280, x2)

inst_325:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0xb504f333, x1, 288, x2)

inst_326:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x0, x1, 296, x2)

inst_327:
// rs1_val==7378697629483820646 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x100000000, x1, 304, x2)

inst_328:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x2, x1, 312, x2)

inst_329:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x5555555555555554, x1, 320, x2)

inst_330:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666666, 0xaaaaaaaaaaaaaaa9, x1, 328, x2)

inst_331:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x4, x1, 336, x2)

inst_332:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333332, x1, 344, x2)

inst_333:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666665, x1, 352, x2)

inst_334:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0xb504f332, x1, 360, x2)

inst_335:
// rs1_val==7378697629483820646 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0xffffffff, x1, 368, x2)

inst_336:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x5555555555555556, x1, 376, x2)

inst_337:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666666, 0xaaaaaaaaaaaaaaab, x1, 384, x2)

inst_338:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x6, x1, 392, x2)

inst_339:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333334, x1, 400, x2)

inst_340:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666667, x1, 408, x2)

inst_341:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0xb504f334, x1, 416, x2)

inst_342:
// rs1_val==7378697629483820646 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x1, x1, 424, x2)

inst_343:
// rs1_val==7378697629483820646 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666666, 0x100000001, x1, 432, x2)

inst_344:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0x3, x1, 440, x2)

inst_345:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x5555555555555555, x1, 448, x2)

inst_346:
// rs1_val==3037000499 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0xaaaaaaaaaaaaaaaa, x1, 456, x2)

inst_347:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0x5, x1, 464, x2)

inst_348:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x3333333333333333, x1, 472, x2)

inst_349:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x6666666666666666, x1, 480, x2)

inst_350:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0xb504f333, x1, 488, x2)

inst_351:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0x0, x1, 496, x2)

inst_352:
// rs1_val==3037000499 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x100000000, x1, 504, x2)

inst_353:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0x2, x1, 512, x2)

inst_354:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x5555555555555554, x1, 520, x2)

inst_355:
// rs1_val==3037000499 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0xaaaaaaaaaaaaaaa9, x1, 528, x2)

inst_356:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0x4, x1, 536, x2)

inst_357:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x3333333333333332, x1, 544, x2)

inst_358:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x6666666666666665, x1, 552, x2)

inst_359:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0xb504f332, x1, 560, x2)

inst_360:
// rs1_val==3037000499 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0xffffffff, x1, 568, x2)

inst_361:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x5555555555555556, x1, 576, x2)

inst_362:
// rs1_val==3037000499 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0xaaaaaaaaaaaaaaab, x1, 584, x2)

inst_363:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0x6, x1, 592, x2)

inst_364:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x3333333333333334, x1, 600, x2)

inst_365:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x6666666666666667, x1, 608, x2)

inst_366:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0xb504f334, x1, 616, x2)

inst_367:
// rs1_val==3037000499 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f333, 0x1, x1, 624, x2)

inst_368:
// rs1_val==3037000499 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f333, 0x100000001, x1, 632, x2)

inst_369:
// rs1_val==0 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x3, x1, 640, x2)

inst_370:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x5555555555555555, x1, 648, x2)

inst_371:
// rs1_val==0 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0xaaaaaaaaaaaaaaaa, x1, 656, x2)

inst_372:
// rs1_val==0 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x5, x1, 664, x2)

inst_373:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x3333333333333333, x1, 672, x2)

inst_374:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x6666666666666666, x1, 680, x2)

inst_375:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0xb504f333, x1, 688, x2)

inst_376:
// rs1_val==0 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x0, 0x0, x1, 696, x2)

inst_377:
// rs1_val==0 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x100000000, x1, 704, x2)

inst_378:
// rs1_val==0 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x2, x1, 712, x2)

inst_379:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x5555555555555554, x1, 720, x2)

inst_380:
// rs1_val==0 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0xaaaaaaaaaaaaaaa9, x1, 728, x2)

inst_381:
// rs1_val==0 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x4, x1, 736, x2)

inst_382:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x3333333333333332, x1, 744, x2)

inst_383:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x6666666666666665, x1, 752, x2)

inst_384:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0xb504f332, x1, 760, x2)

inst_385:
// rs1_val==0 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0xffffffff, x1, 768, x2)

inst_386:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x5555555555555556, x1, 776, x2)

inst_387:
// rs1_val==0 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0xaaaaaaaaaaaaaaab, x1, 784, x2)

inst_388:
// rs1_val==0 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x6, x1, 792, x2)

inst_389:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x3333333333333334, x1, 800, x2)

inst_390:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x6666666666666667, x1, 808, x2)

inst_391:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0xb504f334, x1, 816, x2)

inst_392:
// rs1_val==0 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x0, 0x100000001, x1, 824, x2)

inst_393:
// rs1_val==4294967296 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x3, x1, 832, x2)

inst_394:
// rs1_val==4294967296 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x5555555555555555, x1, 840, x2)

inst_395:
// rs1_val==4294967296 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0xaaaaaaaaaaaaaaaa, x1, 848, x2)

inst_396:
// rs1_val==4294967296 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x5, x1, 856, x2)

inst_397:
// rs1_val==4294967296 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x3333333333333333, x1, 864, x2)

inst_398:
// rs1_val==4294967296 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x6666666666666666, x1, 872, x2)

inst_399:
// rs1_val==4294967296 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0xb504f333, x1, 880, x2)

inst_400:
// rs1_val==4294967296 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x0, x1, 888, x2)

inst_401:
// rs1_val==4294967296 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x100000000, x1, 896, x2)

inst_402:
// rs1_val==4294967296 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x2, x1, 904, x2)

inst_403:
// rs1_val==4294967296 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x5555555555555554, x1, 912, x2)

inst_404:
// rs1_val==4294967296 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0xaaaaaaaaaaaaaaa9, x1, 920, x2)

inst_405:
// rs1_val==4294967296 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x4, x1, 928, x2)

inst_406:
// rs1_val==4294967296 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x3333333333333332, x1, 936, x2)

inst_407:
// rs1_val==4294967296 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x6666666666666665, x1, 944, x2)

inst_408:
// rs1_val==4294967296 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0xb504f332, x1, 952, x2)

inst_409:
// rs1_val==4294967296 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0xffffffff, x1, 960, x2)

inst_410:
// rs1_val==4294967296 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x5555555555555556, x1, 968, x2)

inst_411:
// rs1_val==4294967296 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0xaaaaaaaaaaaaaaab, x1, 976, x2)

inst_412:
// rs1_val==4294967296 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x6, x1, 984, x2)

inst_413:
// rs1_val==4294967296 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x3333333333333334, x1, 992, x2)

inst_414:
// rs1_val==4294967296 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x6666666666666667, x1, 1000, x2)

inst_415:
// rs1_val==4294967296 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0xb504f334, x1, 1008, x2)

inst_416:
// rs1_val==4294967296 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000000, 0x1, x1, 1016, x2)

inst_417:
// rs1_val==4294967296 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000000, 0x100000001, x1, 1024, x2)

inst_418:
// rs1_val==2 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x3, x1, 1032, x2)

inst_419:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x5555555555555555, x1, 1040, x2)

inst_420:
// rs1_val==2 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xaaaaaaaaaaaaaaaa, x1, 1048, x2)

inst_421:
// rs1_val==2 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x5, x1, 1056, x2)

inst_422:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x3333333333333333, x1, 1064, x2)

inst_423:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x6666666666666666, x1, 1072, x2)

inst_424:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xb504f333, x1, 1080, x2)

inst_425:
// rs1_val==2 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x2, 0x0, x1, 1088, x2)

inst_426:
// rs1_val==2 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x100000000, x1, 1096, x2)

inst_427:
// rs1_val==2 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x2, 0x2, x1, 1104, x2)

inst_428:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x5555555555555554, x1, 1112, x2)

inst_429:
// rs1_val==2 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xaaaaaaaaaaaaaaa9, x1, 1120, x2)

inst_430:
// rs1_val==2 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x4, x1, 1128, x2)

inst_431:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x3333333333333332, x1, 1136, x2)

inst_432:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x6666666666666665, x1, 1144, x2)

inst_433:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xb504f332, x1, 1152, x2)

inst_434:
// rs1_val==2 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xffffffff, x1, 1160, x2)

inst_435:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x5555555555555556, x1, 1168, x2)

inst_436:
// rs1_val==2 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xaaaaaaaaaaaaaaab, x1, 1176, x2)

inst_437:
// rs1_val==2 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x6, x1, 1184, x2)

inst_438:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x3333333333333334, x1, 1192, x2)

inst_439:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x6666666666666667, x1, 1200, x2)

inst_440:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0xb504f334, x1, 1208, x2)

inst_441:
// rs1_val==2 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x2, 0x1, x1, 1216, x2)

inst_442:
// rs1_val==2 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x2, 0x100000001, x1, 1224, x2)

inst_443:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x3, x1, 1232, x2)

inst_444:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0x5555555555555555, x1, 1240, x2)

inst_445:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0xaaaaaaaaaaaaaaaa, x1, 1248, x2)

inst_446:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x5, x1, 1256, x2)

inst_447:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x3333333333333333, x1, 1264, x2)

inst_448:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0x6666666666666666, x1, 1272, x2)

inst_449:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0xb504f333, x1, 1280, x2)

inst_450:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x0, x1, 1288, x2)

inst_451:
// rs1_val==6148914691236517204 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x100000000, x1, 1296, x2)

inst_452:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x2, x1, 1304, x2)

inst_453:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555554, x1, 1312, x2)

inst_454:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0xaaaaaaaaaaaaaaa9, x1, 1320, x2)

inst_455:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x4, x1, 1328, x2)

inst_456:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x3333333333333332, x1, 1336, x2)

inst_457:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0x6666666666666665, x1, 1344, x2)

inst_458:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0xb504f332, x1, 1352, x2)

inst_459:
// rs1_val==6148914691236517204 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0xffffffff, x1, 1360, x2)

inst_460:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0x5555555555555556, x1, 1368, x2)

inst_461:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0xaaaaaaaaaaaaaaab, x1, 1376, x2)

inst_462:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x6, x1, 1384, x2)

inst_463:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x3333333333333334, x1, 1392, x2)

inst_464:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555554, 0x6666666666666667, x1, 1400, x2)

inst_465:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0xb504f334, x1, 1408, x2)

inst_466:
// rs1_val==6148914691236517204 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555554, 0x100000001, x1, 1416, x2)

inst_467:
// rs1_val==12297829382473034409 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3, x1, 1424, x2)

inst_468:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x5555555555555555, x1, 1432, x2)

inst_469:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaaa, x1, 1440, x2)

inst_470:
// rs1_val==12297829382473034409 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x5, x1, 1448, x2)

inst_471:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3333333333333333, x1, 1456, x2)

inst_472:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x6666666666666666, x1, 1464, x2)

inst_473:
// rs1_val==12297829382473034409 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0xb504f333, x1, 1472, x2)

inst_474:
// rs1_val==12297829382473034409 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x0, x1, 1480, x2)

inst_475:
// rs1_val==12297829382473034409 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x100000000, x1, 1488, x2)

inst_476:
// rs1_val==12297829382473034409 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x2, x1, 1496, x2)

inst_477:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x5555555555555554, x1, 1504, x2)

inst_478:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, x1, 1512, x2)

inst_479:
// rs1_val==12297829382473034409 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x4, x1, 1520, x2)

inst_480:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3333333333333332, x1, 1528, x2)

inst_481:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x6666666666666665, x1, 1536, x2)

inst_482:
// rs1_val==12297829382473034409 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0xb504f332, x1, 1544, x2)

inst_483:
// rs1_val==12297829382473034409 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0xffffffff, x1, 1552, x2)

inst_484:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x5555555555555556, x1, 1560, x2)

inst_485:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaab, x1, 1568, x2)

inst_486:
// rs1_val==12297829382473034409 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x6, x1, 1576, x2)

inst_487:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3333333333333334, x1, 1584, x2)

inst_488:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x6666666666666667, x1, 1592, x2)

inst_489:
// rs1_val==12297829382473034409 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0xb504f334, x1, 1600, x2)

inst_490:
// rs1_val==12297829382473034409 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x1, x1, 1608, x2)

inst_491:
// rs1_val==12297829382473034409 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x100000001, x1, 1616, x2)

inst_492:
// rs1_val==4 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x4, 0x3, x1, 1624, x2)

inst_493:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x5555555555555555, x1, 1632, x2)

inst_494:
// rs1_val==4 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xaaaaaaaaaaaaaaaa, x1, 1640, x2)

inst_495:
// rs1_val==4 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x5, x1, 1648, x2)

inst_496:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x3333333333333333, x1, 1656, x2)

inst_497:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x6666666666666666, x1, 1664, x2)

inst_498:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xb504f333, x1, 1672, x2)

inst_499:
// rs1_val==4 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x4, 0x0, x1, 1680, x2)

inst_500:
// rs1_val==4 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x100000000, x1, 1688, x2)

inst_501:
// rs1_val==4 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x4, 0x2, x1, 1696, x2)

inst_502:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x5555555555555554, x1, 1704, x2)

inst_503:
// rs1_val==4 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xaaaaaaaaaaaaaaa9, x1, 1712, x2)

inst_504:
// rs1_val==4 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x4, 0x4, x1, 1720, x2)

inst_505:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x3333333333333332, x1, 1728, x2)

inst_506:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x6666666666666665, x1, 1736, x2)

inst_507:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xb504f332, x1, 1744, x2)

inst_508:
// rs1_val==4 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xffffffff, x1, 1752, x2)

inst_509:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x5555555555555556, x1, 1760, x2)

inst_510:
// rs1_val==4 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xaaaaaaaaaaaaaaab, x1, 1768, x2)

inst_511:
// rs1_val==4 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x6, x1, 1776, x2)

inst_512:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x3333333333333334, x1, 1784, x2)

inst_513:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x6666666666666667, x1, 1792, x2)

inst_514:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0xb504f334, x1, 1800, x2)

inst_515:
// rs1_val==4 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x4, 0x1, x1, 1808, x2)

inst_516:
// rs1_val==4 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x4, 0x100000001, x1, 1816, x2)

inst_517:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x3, x1, 1824, x2)

inst_518:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x5555555555555555, x1, 1832, x2)

inst_519:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0xaaaaaaaaaaaaaaaa, x1, 1840, x2)

inst_520:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x5, x1, 1848, x2)

inst_521:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x3333333333333333, x1, 1856, x2)

inst_522:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x6666666666666666, x1, 1864, x2)

inst_523:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f333, x1, 1872, x2)

inst_524:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x0, x1, 1880, x2)

inst_525:
// rs1_val==3689348814741910322 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x100000000, x1, 1888, x2)

inst_526:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x2, x1, 1896, x2)

inst_527:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x5555555555555554, x1, 1904, x2)

inst_528:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0xaaaaaaaaaaaaaaa9, x1, 1912, x2)

inst_529:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x4, x1, 1920, x2)

inst_530:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333332, x1, 1928, x2)

inst_531:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x6666666666666665, x1, 1936, x2)

inst_532:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f332, x1, 1944, x2)

inst_533:
// rs1_val==3689348814741910322 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0xffffffff, x1, 1952, x2)

inst_534:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x5555555555555556, x1, 1960, x2)

inst_535:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0xaaaaaaaaaaaaaaab, x1, 1968, x2)

inst_536:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x6, x1, 1976, x2)

inst_537:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x3333333333333334, x1, 1984, x2)

inst_538:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333332, 0x6666666666666667, x1, 1992, x2)

inst_539:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f334, x1, 2000, x2)

inst_540:
// rs1_val==3689348814741910322 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x1, x1, 2008, x2)

inst_541:
// rs1_val==3689348814741910322 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333332, 0x100000001, x1, 2016, x2)

inst_542:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x3, x1, 2024, x2)

inst_543:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x5555555555555555, x1, 2032, x2)

inst_544:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666665, 0xaaaaaaaaaaaaaaaa, x1, 2040, x2)
RVTEST_SIGBASE( x1,signature_x1_4)

inst_545:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x5, x1, 0, x2)

inst_546:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x3333333333333333, x1, 8, x2)

inst_547:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666665, 0x6666666666666666, x1, 16, x2)

inst_548:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0xb504f333, x1, 24, x2)

inst_549:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x0, x1, 32, x2)

inst_550:
// rs1_val==7378697629483820645 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x100000000, x1, 40, x2)

inst_551:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x2, x1, 48, x2)

inst_552:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x5555555555555554, x1, 56, x2)

inst_553:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666665, 0xaaaaaaaaaaaaaaa9, x1, 64, x2)

inst_554:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x4, x1, 72, x2)

inst_555:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x3333333333333332, x1, 80, x2)

inst_556:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666665, x1, 88, x2)

inst_557:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0xb504f332, x1, 96, x2)

inst_558:
// rs1_val==7378697629483820645 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0xffffffff, x1, 104, x2)

inst_559:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x5555555555555556, x1, 112, x2)

inst_560:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666665, 0xaaaaaaaaaaaaaaab, x1, 120, x2)

inst_561:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x6, x1, 128, x2)

inst_562:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x3333333333333334, x1, 136, x2)

inst_563:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666665, 0x6666666666666667, x1, 144, x2)

inst_564:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0xb504f334, x1, 152, x2)

inst_565:
// rs1_val==7378697629483820645 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x1, x1, 160, x2)

inst_566:
// rs1_val==7378697629483820645 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666665, 0x100000001, x1, 168, x2)

inst_567:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0x3, x1, 176, x2)

inst_568:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x5555555555555555, x1, 184, x2)

inst_569:
// rs1_val==3037000498 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0xaaaaaaaaaaaaaaaa, x1, 192, x2)

inst_570:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0x5, x1, 200, x2)

inst_571:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x3333333333333333, x1, 208, x2)

inst_572:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x6666666666666666, x1, 216, x2)

inst_573:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0xb504f333, x1, 224, x2)

inst_574:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0x0, x1, 232, x2)

inst_575:
// rs1_val==3037000498 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x100000000, x1, 240, x2)

inst_576:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0x2, x1, 248, x2)

inst_577:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x5555555555555554, x1, 256, x2)

inst_578:
// rs1_val==3037000498 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0xaaaaaaaaaaaaaaa9, x1, 264, x2)

inst_579:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0x4, x1, 272, x2)

inst_580:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x3333333333333332, x1, 280, x2)

inst_581:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x6666666666666665, x1, 288, x2)

inst_582:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0xb504f332, x1, 296, x2)

inst_583:
// rs1_val==3037000498 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0xffffffff, x1, 304, x2)

inst_584:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x5555555555555556, x1, 312, x2)

inst_585:
// rs1_val==3037000498 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0xaaaaaaaaaaaaaaab, x1, 320, x2)

inst_586:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0x6, x1, 328, x2)

inst_587:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x3333333333333334, x1, 336, x2)

inst_588:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x6666666666666667, x1, 344, x2)

inst_589:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0xb504f334, x1, 352, x2)

inst_590:
// rs1_val==3037000498 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f332, 0x1, x1, 360, x2)

inst_591:
// rs1_val==3037000498 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f332, 0x100000001, x1, 368, x2)

inst_592:
// rs1_val==4294967295 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0x3, x1, 376, x2)

inst_593:
// rs1_val==4294967295 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x5555555555555555, x1, 384, x2)

inst_594:
// rs1_val==4294967295 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0xaaaaaaaaaaaaaaaa, x1, 392, x2)

inst_595:
// rs1_val==4294967295 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0x5, x1, 400, x2)

inst_596:
// rs1_val==4294967295 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x3333333333333333, x1, 408, x2)

inst_597:
// rs1_val==4294967295 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x6666666666666666, x1, 416, x2)

inst_598:
// rs1_val==4294967295 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0xb504f333, x1, 424, x2)

inst_599:
// rs1_val==4294967295 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0x0, x1, 432, x2)

inst_600:
// rs1_val==4294967295 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x100000000, x1, 440, x2)

inst_601:
// rs1_val==4294967295 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0x2, x1, 448, x2)

inst_602:
// rs1_val==4294967295 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x5555555555555554, x1, 456, x2)

inst_603:
// rs1_val==4294967295 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0xaaaaaaaaaaaaaaa9, x1, 464, x2)

inst_604:
// rs1_val==4294967295 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0x4, x1, 472, x2)

inst_605:
// rs1_val==4294967295 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x3333333333333332, x1, 480, x2)

inst_606:
// rs1_val==4294967295 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x6666666666666665, x1, 488, x2)

inst_607:
// rs1_val==4294967295 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0xb504f332, x1, 496, x2)

inst_608:
// rs1_val==4294967295 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0xffffffff, x1, 504, x2)

inst_609:
// rs1_val==4294967295 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x5555555555555556, x1, 512, x2)

inst_610:
// rs1_val==4294967295 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0xaaaaaaaaaaaaaaab, x1, 520, x2)

inst_611:
// rs1_val==4294967295 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0x6, x1, 528, x2)

inst_612:
// rs1_val==4294967295 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x3333333333333334, x1, 536, x2)

inst_613:
// rs1_val==4294967295 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x6666666666666667, x1, 544, x2)

inst_614:
// rs1_val==4294967295 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0xb504f334, x1, 552, x2)

inst_615:
// rs1_val==4294967295 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xffffffff, 0x1, x1, 560, x2)

inst_616:
// rs1_val==4294967295 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xffffffff, 0x100000001, x1, 568, x2)

inst_617:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x3, x1, 576, x2)

inst_618:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555555, x1, 584, x2)

inst_619:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555556, 0xaaaaaaaaaaaaaaaa, x1, 592, x2)

inst_620:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x5, x1, 600, x2)

inst_621:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x3333333333333333, x1, 608, x2)

inst_622:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555556, 0x6666666666666666, x1, 616, x2)

inst_623:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0xb504f333, x1, 624, x2)

inst_624:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x0, x1, 632, x2)

inst_625:
// rs1_val==6148914691236517206 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x100000000, x1, 640, x2)

inst_626:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x2, x1, 648, x2)

inst_627:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555554, x1, 656, x2)

inst_628:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555556, 0xaaaaaaaaaaaaaaa9, x1, 664, x2)

inst_629:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x4, x1, 672, x2)

inst_630:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x3333333333333332, x1, 680, x2)

inst_631:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555556, 0x6666666666666665, x1, 688, x2)

inst_632:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0xb504f332, x1, 696, x2)

inst_633:
// rs1_val==6148914691236517206 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0xffffffff, x1, 704, x2)

inst_634:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555556, x1, 712, x2)

inst_635:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555556, 0xaaaaaaaaaaaaaaab, x1, 720, x2)

inst_636:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x6, x1, 728, x2)

inst_637:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x3333333333333334, x1, 736, x2)

inst_638:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x5555555555555556, 0x6666666666666667, x1, 744, x2)

inst_639:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0xb504f334, x1, 752, x2)

inst_640:
// rs1_val==6148914691236517206 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x1, x1, 760, x2)

inst_641:
// rs1_val==6148914691236517206 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x5555555555555556, 0x100000001, x1, 768, x2)

inst_642:
// rs1_val==12297829382473034411 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x3, x1, 776, x2)

inst_643:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x5555555555555555, x1, 784, x2)

inst_644:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaaa, x1, 792, x2)

inst_645:
// rs1_val==12297829382473034411 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x5, x1, 800, x2)

inst_646:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x3333333333333333, x1, 808, x2)

inst_647:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x6666666666666666, x1, 816, x2)

inst_648:
// rs1_val==12297829382473034411 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xb504f333, x1, 824, x2)

inst_649:
// rs1_val==12297829382473034411 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x0, x1, 832, x2)

inst_650:
// rs1_val==12297829382473034411 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x100000000, x1, 840, x2)

inst_651:
// rs1_val==12297829382473034411 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x2, x1, 848, x2)

inst_652:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x5555555555555554, x1, 856, x2)

inst_653:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaa9, x1, 864, x2)

inst_654:
// rs1_val==12297829382473034411 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x4, x1, 872, x2)

inst_655:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x3333333333333332, x1, 880, x2)

inst_656:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x6666666666666665, x1, 888, x2)

inst_657:
// rs1_val==12297829382473034411 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xb504f332, x1, 896, x2)

inst_658:
// rs1_val==12297829382473034411 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xffffffff, x1, 904, x2)

inst_659:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x5555555555555556, x1, 912, x2)

inst_660:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaab, x1, 920, x2)

inst_661:
// rs1_val==12297829382473034411 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x6, x1, 928, x2)

inst_662:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x3333333333333334, x1, 936, x2)

inst_663:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x6666666666666667, x1, 944, x2)

inst_664:
// rs1_val==12297829382473034411 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xb504f334, x1, 952, x2)

inst_665:
// rs1_val==12297829382473034411 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x1, x1, 960, x2)

inst_666:
// rs1_val==12297829382473034411 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x100000001, x1, 968, x2)

inst_667:
// rs1_val==6 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6, 0x3, x1, 976, x2)

inst_668:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x5555555555555555, x1, 984, x2)

inst_669:
// rs1_val==6 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0xaaaaaaaaaaaaaaaa, x1, 992, x2)

inst_670:
// rs1_val==6 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6, 0x5, x1, 1000, x2)

inst_671:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x3333333333333333, x1, 1008, x2)

inst_672:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x6666666666666666, x1, 1016, x2)

inst_673:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0xb504f333, x1, 1024, x2)

inst_674:
// rs1_val==6 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6, 0x0, x1, 1032, x2)

inst_675:
// rs1_val==6 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x100000000, x1, 1040, x2)

inst_676:
// rs1_val==6 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6, 0x2, x1, 1048, x2)

inst_677:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x5555555555555554, x1, 1056, x2)

inst_678:
// rs1_val==6 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0xaaaaaaaaaaaaaaa9, x1, 1064, x2)

inst_679:
// rs1_val==6 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6, 0x4, x1, 1072, x2)

inst_680:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x3333333333333332, x1, 1080, x2)

inst_681:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x6666666666666665, x1, 1088, x2)

inst_682:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0xb504f332, x1, 1096, x2)

inst_683:
// rs1_val==6 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0xffffffff, x1, 1104, x2)

inst_684:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x5555555555555556, x1, 1112, x2)

inst_685:
// rs1_val==6 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0xaaaaaaaaaaaaaaab, x1, 1120, x2)

inst_686:
// rs1_val==6 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6, 0x6, x1, 1128, x2)

inst_687:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x3333333333333334, x1, 1136, x2)

inst_688:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x6666666666666667, x1, 1144, x2)

inst_689:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0xb504f334, x1, 1152, x2)

inst_690:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0x5555555555555555, x1, 1160, x2)

inst_691:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0xaaaaaaaaaaaaaaaa, x1, 1168, x2)

inst_692:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x5, x1, 1176, x2)

inst_693:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333333, x1, 1184, x2)

inst_694:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0x6666666666666666, x1, 1192, x2)

inst_695:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f333, x1, 1200, x2)

inst_696:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x0, x1, 1208, x2)

inst_697:
// rs1_val==3689348814741910324 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x100000000, x1, 1216, x2)

inst_698:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x2, x1, 1224, x2)

inst_699:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0x5555555555555554, x1, 1232, x2)

inst_700:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0xaaaaaaaaaaaaaaa9, x1, 1240, x2)

inst_701:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x4, x1, 1248, x2)

inst_702:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333332, x1, 1256, x2)

inst_703:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0x6666666666666665, x1, 1264, x2)

inst_704:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f332, x1, 1272, x2)

inst_705:
// rs1_val==3689348814741910324 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0xffffffff, x1, 1280, x2)

inst_706:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0x5555555555555556, x1, 1288, x2)

inst_707:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0xaaaaaaaaaaaaaaab, x1, 1296, x2)

inst_708:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x6, x1, 1304, x2)

inst_709:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333334, x1, 1312, x2)

inst_710:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x3333333333333334, 0x6666666666666667, x1, 1320, x2)

inst_711:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f334, x1, 1328, x2)

inst_712:
// rs1_val==3689348814741910324 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x1, x1, 1336, x2)

inst_713:
// rs1_val==3689348814741910324 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x100000001, x1, 1344, x2)

inst_714:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x3, x1, 1352, x2)

inst_715:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x5555555555555555, x1, 1360, x2)

inst_716:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666667, 0xaaaaaaaaaaaaaaaa, x1, 1368, x2)

inst_717:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x5, x1, 1376, x2)

inst_718:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x3333333333333333, x1, 1384, x2)

inst_719:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666666, x1, 1392, x2)

inst_720:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0xb504f333, x1, 1400, x2)

inst_721:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x0, x1, 1408, x2)

inst_722:
// rs1_val==7378697629483820647 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x100000000, x1, 1416, x2)

inst_723:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x2, x1, 1424, x2)

inst_724:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x5555555555555554, x1, 1432, x2)

inst_725:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666667, 0xaaaaaaaaaaaaaaa9, x1, 1440, x2)

inst_726:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x4, x1, 1448, x2)

inst_727:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x3333333333333332, x1, 1456, x2)

inst_728:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666665, x1, 1464, x2)

inst_729:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0xb504f332, x1, 1472, x2)

inst_730:
// rs1_val==7378697629483820647 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0xffffffff, x1, 1480, x2)

inst_731:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x5555555555555556, x1, 1488, x2)

inst_732:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6666666666666667, 0xaaaaaaaaaaaaaaab, x1, 1496, x2)

inst_733:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x6, x1, 1504, x2)

inst_734:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x3333333333333334, x1, 1512, x2)

inst_735:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666667, x1, 1520, x2)

inst_736:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0xb504f334, x1, 1528, x2)

inst_737:
// rs1_val==7378697629483820647 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x1, x1, 1536, x2)

inst_738:
// rs1_val==7378697629483820647 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6666666666666667, 0x100000001, x1, 1544, x2)

inst_739:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0x3, x1, 1552, x2)

inst_740:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x5555555555555555, x1, 1560, x2)

inst_741:
// rs1_val==3037000500 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0xaaaaaaaaaaaaaaaa, x1, 1568, x2)

inst_742:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0x5, x1, 1576, x2)

inst_743:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x3333333333333333, x1, 1584, x2)

inst_744:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x6666666666666666, x1, 1592, x2)

inst_745:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0xb504f333, x1, 1600, x2)

inst_746:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0x0, x1, 1608, x2)

inst_747:
// rs1_val==3037000500 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x100000000, x1, 1616, x2)

inst_748:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0x2, x1, 1624, x2)

inst_749:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x5555555555555554, x1, 1632, x2)

inst_750:
// rs1_val==3037000500 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0xaaaaaaaaaaaaaaa9, x1, 1640, x2)

inst_751:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0x4, x1, 1648, x2)

inst_752:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x3333333333333332, x1, 1656, x2)

inst_753:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x6666666666666665, x1, 1664, x2)

inst_754:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0xb504f332, x1, 1672, x2)

inst_755:
// rs1_val==3037000500 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0xffffffff, x1, 1680, x2)

inst_756:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x5555555555555556, x1, 1688, x2)

inst_757:
// rs1_val==3037000500 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0xaaaaaaaaaaaaaaab, x1, 1696, x2)

inst_758:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0x6, x1, 1704, x2)

inst_759:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x3333333333333334, x1, 1712, x2)

inst_760:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x6666666666666667, x1, 1720, x2)

inst_761:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0xb504f334, x1, 1728, x2)

inst_762:
// rs1_val==3037000500 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0xb504f334, 0x1, x1, 1736, x2)

inst_763:
// rs1_val==3037000500 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0xb504f334, 0x100000001, x1, 1744, x2)

inst_764:
// rs1_val==1 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x3, x1, 1752, x2)

inst_765:
// rs1_val==1 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x5555555555555555, x1, 1760, x2)

inst_766:
// rs1_val==1 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaaa, x1, 1768, x2)

inst_767:
// rs1_val==1 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x5, x1, 1776, x2)

inst_768:
// rs1_val==1 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x3333333333333333, x1, 1784, x2)

inst_769:
// rs1_val==1 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x6666666666666666, x1, 1792, x2)

inst_770:
// rs1_val==1 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xb504f333, x1, 1800, x2)

inst_771:
// rs1_val==1 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x1, 0x0, x1, 1808, x2)

inst_772:
// rs1_val==1 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x100000000, x1, 1816, x2)

inst_773:
// rs1_val==1 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x2, x1, 1824, x2)

inst_774:
// rs1_val==1 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x5555555555555554, x1, 1832, x2)

inst_775:
// rs1_val==1 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaa9, x1, 1840, x2)

inst_776:
// rs1_val==1 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x4, x1, 1848, x2)

inst_777:
// rs1_val==1 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x3333333333333332, x1, 1856, x2)

inst_778:
// rs1_val==1 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x6666666666666665, x1, 1864, x2)

inst_779:
// rs1_val==1 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xb504f332, x1, 1872, x2)

inst_780:
// rs1_val==1 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xffffffff, x1, 1880, x2)

inst_781:
// rs1_val==1 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x5555555555555556, x1, 1888, x2)

inst_782:
// rs1_val==1 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaab, x1, 1896, x2)

inst_783:
// rs1_val==1 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x6, x1, 1904, x2)

inst_784:
// rs1_val==1 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x3333333333333334, x1, 1912, x2)

inst_785:
// rs1_val==1 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x6666666666666667, x1, 1920, x2)

inst_786:
// rs1_val==1 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0xb504f334, x1, 1928, x2)

inst_787:
// rs1_val==1 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x1, 0x1, x1, 1936, x2)

inst_788:
// rs1_val==1 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x1, 0x100000001, x1, 1944, x2)

inst_789:
// rs1_val==4294967297 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x3, x1, 1952, x2)

inst_790:
// rs1_val==4294967297 and rs2_val==6148914691236517205, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555555
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x5555555555555555, x1, 1960, x2)

inst_791:
// rs1_val==4294967297 and rs2_val==12297829382473034410, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0xaaaaaaaaaaaaaaaa, x1, 1968, x2)

inst_792:
// rs1_val==4294967297 and rs2_val==5, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x5, x1, 1976, x2)

inst_793:
// rs1_val==4294967297 and rs2_val==3689348814741910323, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333333
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x3333333333333333, x1, 1984, x2)

inst_794:
// rs1_val==4294967297 and rs2_val==7378697629483820646, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666666
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x6666666666666666, x1, 1992, x2)

inst_795:
// rs1_val==4294967297 and rs2_val==3037000499, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f333
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0xb504f333, x1, 2000, x2)

inst_796:
// rs1_val==4294967297 and rs2_val==0, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x0
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x0, x1, 2008, x2)

inst_797:
// rs1_val==4294967297 and rs2_val==4294967296, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x100000000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x100000000, x1, 2016, x2)

inst_798:
// rs1_val==4294967297 and rs2_val==2, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x2, x1, 2024, x2)

inst_799:
// rs1_val==4294967297 and rs2_val==6148914691236517204, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555554
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x5555555555555554, x1, 2032, x2)

inst_800:
// rs1_val==4294967297 and rs2_val==12297829382473034409, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0xaaaaaaaaaaaaaaa9, x1, 2040, x2)
RVTEST_SIGBASE( x1,signature_x1_5)

inst_801:
// rs1_val==4294967297 and rs2_val==4, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x4
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x4, x1, 0, x2)

inst_802:
// rs1_val==4294967297 and rs2_val==3689348814741910322, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333332
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x3333333333333332, x1, 8, x2)

inst_803:
// rs1_val==4294967297 and rs2_val==7378697629483820645, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666665
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x6666666666666665, x1, 16, x2)

inst_804:
// rs1_val==4294967297 and rs2_val==3037000498, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f332
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0xb504f332, x1, 24, x2)

inst_805:
// rs1_val==4294967297 and rs2_val==4294967295, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xffffffff
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0xffffffff, x1, 32, x2)

inst_806:
// rs1_val==4294967297 and rs2_val==6148914691236517206, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555556
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x5555555555555556, x1, 40, x2)

inst_807:
// rs1_val==4294967297 and rs2_val==12297829382473034411, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0xaaaaaaaaaaaaaaab, x1, 48, x2)

inst_808:
// rs1_val==4294967297 and rs2_val==6, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x6, x1, 56, x2)

inst_809:
// rs1_val==4294967297 and rs2_val==3689348814741910324, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333334
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x3333333333333334, x1, 64, x2)

inst_810:
// rs1_val==4294967297 and rs2_val==7378697629483820647, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666667
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x100000001, 0x6666666666666667, x1, 72, x2)

inst_811:
// rs1_val==4294967297 and rs2_val==3037000500, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f334
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0xb504f334, x1, 80, x2)

inst_812:
// rs1_val==4294967297 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x1, x1, 88, x2)

inst_813:
// rs1_val==4294967297 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x100000001, 0x100000001, x1, 96, x2)

inst_814:
// rs1_val==6 and rs2_val==1, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x1
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x6, 0x1, x1, 104, x2)

inst_815:
// rs1_val==6 and rs2_val==4294967297, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x100000001
TEST_RR_OP(sltu, x12, x10, x11, 0x1, 0x6, 0x100000001, x1, 112, x2)

inst_816:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x3333333333333334, 0x3, x1, 120, x2)

inst_817:
// rs2_val == 2, rs1_val == 1152921504606846976
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x2
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x1000000000000000, 0x2, x1, 128, x2)

inst_818:
// rs2_val == 131072, rs1_val == 2097152
// opcode: sltu ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0x20000
TEST_RR_OP(sltu, x12, x10, x11, 0x0, 0x200000, 0x20000, x1, 136, x2)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 17*(XLEN/32),4,0xdeadbeef


signature_x16_0:
    .fill 16*(XLEN/32),4,0xdeadbeef


signature_x1_2:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_3:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_4:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_5:
    .fill 18*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
