
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the sra instruction of the RISC-V i extension for the sra covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64i")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",sra)

RVTEST_SIGBASE( x9,signature_x9_1)

inst_0:
// rs1 == rs2 != rd, rs1==x23, rs2==x23, rd==x7, rs1_val < 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == -34359738369
// opcode: sra ; op1:x23; op2:x23; dest:x7; op1val:-0x800000001;  op2val:-0x800000001
TEST_RR_OP(sra, x7, x23, x23, -0x1, -0x800000001, -0x800000001, x9, 0, x10)

inst_1:
// rs2 == rd != rs1, rs1==x15, rs2==x3, rd==x3, rs1_val > 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == 4294967296
// opcode: sra ; op1:x15; op2:x3; dest:x3; op1val:0x100000000;  op2val:0x3
TEST_RR_OP(sra, x3, x15, x3, 0x20000000, 0x100000000, 0x3, x9, 8, x10)

inst_2:
// rs1 == rs2 == rd, rs1==x4, rs2==x4, rd==x4, rs1_val < 0 and rs2_val == 0, rs1_val == -4294967297
// opcode: sra ; op1:x4; op2:x4; dest:x4; op1val:-0x100000001;  op2val:-0x100000001
TEST_RR_OP(sra, x4, x4, x4, -0x1, -0x100000001, -0x100000001, x9, 16, x10)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x27, rs2==x24, rd==x30, rs1_val > 0 and rs2_val == 0, rs1_val==3689348814741910323
// opcode: sra ; op1:x27; op2:x24; dest:x30; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(sra, x30, x27, x24, 0x3333333333333333, 0x3333333333333333, 0x0, x9, 24, x10)

inst_4:
// rs1 == rd != rs2, rs1==x20, rs2==x18, rd==x20, rs1_val == rs2_val and rs2_val > 0 and rs2_val < xlen, rs1_val == 1 and rs2_val >= 0 and rs2_val < xlen, rs1_val == 1, rs2_val == 1
// opcode: sra ; op1:x20; op2:x18; dest:x20; op1val:0x1;  op2val:0x1
TEST_RR_OP(sra, x20, x20, x18, 0x0, 0x1, 0x1, x9, 32, x10)

inst_5:
// rs1==x2, rs2==x15, rd==x24, rs1_val == (-2**(xlen-1)) and rs2_val >= 0 and rs2_val < xlen, rs1_val == -9223372036854775808, rs2_val == 2
// opcode: sra ; op1:x2; op2:x15; dest:x24; op1val:-0x8000000000000000;  op2val:0x2
TEST_RR_OP(sra, x24, x2, x15, -0x2000000000000000, -0x8000000000000000, 0x2, x9, 40, x10)

inst_6:
// rs1==x13, rs2==x8, rd==x26, rs1_val == 0 and rs2_val >= 0 and rs2_val < xlen, rs1_val==0
// opcode: sra ; op1:x13; op2:x8; dest:x26; op1val:0x0;  op2val:0xe
TEST_RR_OP(sra, x26, x13, x8, 0x0, 0x0, 0xe, x9, 48, x10)

inst_7:
// rs1==x14, rs2==x0, rd==x28, rs1_val == (2**(xlen-1)-1) and rs2_val >= 0 and rs2_val < xlen, rs1_val == 9223372036854775807
// opcode: sra ; op1:x14; op2:x0; dest:x28; op1val:0x7fffffffffffffff;  op2val:0x0
TEST_RR_OP(sra, x28, x14, x0, 0x7fffffffffffffff, 0x7fffffffffffffff, 0x0, x9, 56, x10)

inst_8:
// rs1==x25, rs2==x22, rd==x6, rs1_val == 2, rs1_val==2
// opcode: sra ; op1:x25; op2:x22; dest:x6; op1val:0x2;  op2val:0xa
TEST_RR_OP(sra, x6, x25, x22, 0x0, 0x2, 0xa, x9, 64, x10)

inst_9:
// rs1==x29, rs2==x12, rd==x18, rs1_val == 4, rs1_val==4
// opcode: sra ; op1:x29; op2:x12; dest:x18; op1val:0x4;  op2val:0x7
TEST_RR_OP(sra, x18, x29, x12, 0x0, 0x4, 0x7, x9, 72, x10)

inst_10:
// rs1==x3, rs2==x28, rd==x11, rs1_val == 8, 
// opcode: sra ; op1:x3; op2:x28; dest:x11; op1val:0x8;  op2val:0xa
TEST_RR_OP(sra, x11, x3, x28, 0x0, 0x8, 0xa, x9, 80, x10)

inst_11:
// rs1==x0, rs2==x16, rd==x8, rs1_val == 16, 
// opcode: sra ; op1:x0; op2:x16; dest:x8; op1val:0x0;  op2val:0x6
TEST_RR_OP(sra, x8, x0, x16, 0x0, 0x0, 0x6, x9, 88, x10)

inst_12:
// rs1==x24, rs2==x5, rd==x12, rs1_val == 32, 
// opcode: sra ; op1:x24; op2:x5; dest:x12; op1val:0x20;  op2val:0x1
TEST_RR_OP(sra, x12, x24, x5, 0x10, 0x20, 0x1, x9, 96, x10)

inst_13:
// rs1==x31, rs2==x21, rd==x2, rs1_val == 64, rs2_val == 8
// opcode: sra ; op1:x31; op2:x21; dest:x2; op1val:0x40;  op2val:0x8
TEST_RR_OP(sra, x2, x31, x21, 0x0, 0x40, 0x8, x9, 104, x10)

inst_14:
// rs1==x8, rs2==x1, rd==x21, rs1_val == 128, 
// opcode: sra ; op1:x8; op2:x1; dest:x21; op1val:0x80;  op2val:0xe
TEST_RR_OP(sra, x21, x8, x1, 0x0, 0x80, 0xe, x9, 112, x10)

inst_15:
// rs1==x1, rs2==x30, rd==x14, rs1_val == 256, 
// opcode: sra ; op1:x1; op2:x30; dest:x14; op1val:0x100;  op2val:0x3
TEST_RR_OP(sra, x14, x1, x30, 0x20, 0x100, 0x3, x9, 120, x4)

inst_16:
// rs1==x16, rs2==x10, rd==x0, rs1_val == 512, 
// opcode: sra ; op1:x16; op2:x10; dest:x0; op1val:0x200;  op2val:0xb
TEST_RR_OP(sra, x0, x16, x10, 0, 0x200, 0xb, x9, 128, x4)
RVTEST_SIGBASE( x3,signature_x3_0)

inst_17:
// rs1==x26, rs2==x29, rd==x10, rs1_val == 1024, 
// opcode: sra ; op1:x26; op2:x29; dest:x10; op1val:0x400;  op2val:0xe
TEST_RR_OP(sra, x10, x26, x29, 0x0, 0x400, 0xe, x3, 0, x4)

inst_18:
// rs1==x9, rs2==x27, rd==x31, rs1_val == 2048, rs2_val == 42
// opcode: sra ; op1:x9; op2:x27; dest:x31; op1val:0x800;  op2val:0x2a
TEST_RR_OP(sra, x31, x9, x27, 0x0, 0x800, 0x2a, x3, 8, x4)

inst_19:
// rs1==x22, rs2==x19, rd==x1, rs1_val == 4096, rs2_val == 4
// opcode: sra ; op1:x22; op2:x19; dest:x1; op1val:0x1000;  op2val:0x4
TEST_RR_OP(sra, x1, x22, x19, 0x100, 0x1000, 0x4, x3, 16, x4)

inst_20:
// rs1==x17, rs2==x13, rd==x9, rs1_val == 8192, 
// opcode: sra ; op1:x17; op2:x13; dest:x9; op1val:0x2000;  op2val:0x9
TEST_RR_OP(sra, x9, x17, x13, 0x10, 0x2000, 0x9, x3, 24, x4)

inst_21:
// rs1==x18, rs2==x7, rd==x13, rs1_val == 16384, rs2_val == 31
// opcode: sra ; op1:x18; op2:x7; dest:x13; op1val:0x4000;  op2val:0x1f
TEST_RR_OP(sra, x13, x18, x7, 0x0, 0x4000, 0x1f, x3, 32, x4)

inst_22:
// rs1==x7, rs2==x31, rd==x19, rs1_val == 32768, 
// opcode: sra ; op1:x7; op2:x31; dest:x19; op1val:0x8000;  op2val:0x9
TEST_RR_OP(sra, x19, x7, x31, 0x40, 0x8000, 0x9, x3, 40, x4)

inst_23:
// rs1==x21, rs2==x26, rd==x23, rs1_val == 65536, 
// opcode: sra ; op1:x21; op2:x26; dest:x23; op1val:0x10000;  op2val:0x3
TEST_RR_OP(sra, x23, x21, x26, 0x2000, 0x10000, 0x3, x3, 48, x4)

inst_24:
// rs1==x10, rs2==x11, rd==x29, rs1_val == 131072, 
// opcode: sra ; op1:x10; op2:x11; dest:x29; op1val:0x20000;  op2val:0x3
TEST_RR_OP(sra, x29, x10, x11, 0x4000, 0x20000, 0x3, x3, 56, x4)

inst_25:
// rs1==x19, rs2==x2, rd==x27, rs1_val == 262144, 
// opcode: sra ; op1:x19; op2:x2; dest:x27; op1val:0x40000;  op2val:0x8
TEST_RR_OP(sra, x27, x19, x2, 0x400, 0x40000, 0x8, x3, 64, x4)

inst_26:
// rs1==x12, rs2==x6, rd==x17, rs1_val == 524288, 
// opcode: sra ; op1:x12; op2:x6; dest:x17; op1val:0x80000;  op2val:0x7
TEST_RR_OP(sra, x17, x12, x6, 0x1000, 0x80000, 0x7, x3, 72, x4)

inst_27:
// rs1==x5, rs2==x14, rd==x22, rs1_val == 1048576, rs2_val == 32
// opcode: sra ; op1:x5; op2:x14; dest:x22; op1val:0x100000;  op2val:0x20
TEST_RR_OP(sra, x22, x5, x14, 0x0, 0x100000, 0x20, x3, 80, x4)

inst_28:
// rs1==x6, rs2==x9, rd==x16, rs1_val == 2097152, 
// opcode: sra ; op1:x6; op2:x9; dest:x16; op1val:0x200000;  op2val:0x4
TEST_RR_OP(sra, x16, x6, x9, 0x20000, 0x200000, 0x4, x3, 88, x4)

inst_29:
// rs1==x30, rs2==x25, rd==x5, rs1_val == 4194304, 
// opcode: sra ; op1:x30; op2:x25; dest:x5; op1val:0x400000;  op2val:0x2a
TEST_RR_OP(sra, x5, x30, x25, 0x0, 0x400000, 0x2a, x3, 96, x4)

inst_30:
// rs1==x28, rs2==x20, rd==x15, rs1_val == 8388608, rs2_val == 21
// opcode: sra ; op1:x28; op2:x20; dest:x15; op1val:0x800000;  op2val:0x15
TEST_RR_OP(sra, x15, x28, x20, 0x4, 0x800000, 0x15, x3, 104, x4)

inst_31:
// rs1==x11, rs2==x17, rd==x25, rs1_val == 16777216, 
// opcode: sra ; op1:x11; op2:x17; dest:x25; op1val:0x1000000;  op2val:0x15
TEST_RR_OP(sra, x25, x11, x17, 0x8, 0x1000000, 0x15, x3, 112, x1)

inst_32:
// rs1_val == 33554432, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x1f
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x2000000, 0x1f, x3, 120, x1)

inst_33:
// rs1_val == 67108864, rs2_val == 16
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x10
TEST_RR_OP(sra, x12, x10, x11, 0x400, 0x4000000, 0x10, x3, 128, x1)

inst_34:
// rs1_val == 134217728, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x2
TEST_RR_OP(sra, x12, x10, x11, 0x2000000, 0x8000000, 0x2, x3, 136, x1)

inst_35:
// rs1_val == 268435456, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0xd
TEST_RR_OP(sra, x12, x10, x11, 0x8000, 0x10000000, 0xd, x3, 144, x1)

inst_36:
// rs1_val == 536870912, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x3
TEST_RR_OP(sra, x12, x10, x11, 0x4000000, 0x20000000, 0x3, x3, 152, x1)

inst_37:
// rs1_val == 1073741824, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, 0x40000, 0x40000000, 0xc, x3, 160, x1)

inst_38:
// rs1_val == 2147483648, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0xb
TEST_RR_OP(sra, x12, x10, x11, 0x100000, 0x80000000, 0xb, x3, 168, x1)

inst_39:
// rs1_val == 8589934592, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0xa
TEST_RR_OP(sra, x12, x10, x11, 0x800000, 0x200000000, 0xa, x3, 176, x1)

inst_40:
// rs1_val == 17179869184, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, 0x100000, 0x400000000, 0xe, x3, 184, x1)

inst_41:
// rs1_val == 34359738368, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0xf
TEST_RR_OP(sra, x12, x10, x11, 0x100000, 0x800000000, 0xf, x3, 192, x1)

inst_42:
// rs1_val == 68719476736, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0x20
TEST_RR_OP(sra, x12, x10, x11, 0x10, 0x1000000000, 0x20, x3, 200, x1)

inst_43:
// rs1_val == 137438953472, rs2_val == 47
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0x2f
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x2000000000, 0x2f, x3, 208, x1)

inst_44:
// rs1_val == 274877906944, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0x2a
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x4000000000, 0x2a, x3, 216, x1)

inst_45:
// rs1_val == 549755813888, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0x10
TEST_RR_OP(sra, x12, x10, x11, 0x800000, 0x8000000000, 0x10, x3, 224, x1)

inst_46:
// rs1_val == 1099511627776, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, 0x10000000, 0x10000000000, 0xc, x3, 232, x1)

inst_47:
// rs1_val == 2199023255552, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0x2a
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x20000000000, 0x2a, x3, 240, x1)

inst_48:
// rs1_val == 4398046511104, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0x5
TEST_RR_OP(sra, x12, x10, x11, 0x2000000000, 0x40000000000, 0x5, x3, 248, x1)

inst_49:
// rs1_val == 8796093022208, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x8
TEST_RR_OP(sra, x12, x10, x11, 0x800000000, 0x80000000000, 0x8, x3, 256, x1)

inst_50:
// rs1_val == 17592186044416, rs2_val == 55
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x37
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x100000000000, 0x37, x3, 264, x1)

inst_51:
// rs1_val == 35184372088832, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x37
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x200000000000, 0x37, x3, 272, x1)

inst_52:
// rs1_val == 70368744177664, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, 0x400000000, 0x400000000000, 0xc, x3, 280, x1)

inst_53:
// rs1_val == 140737488355328, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x2a
TEST_RR_OP(sra, x12, x10, x11, 0x20, 0x800000000000, 0x2a, x3, 288, x1)

inst_54:
// rs1_val == 281474976710656, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0x2a
TEST_RR_OP(sra, x12, x10, x11, 0x40, 0x1000000000000, 0x2a, x3, 296, x1)

inst_55:
// rs1_val == 562949953421312, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, 0x800000000, 0x2000000000000, 0xe, x3, 304, x1)

inst_56:
// rs1_val == 1125899906842624, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, 0x4000000000, 0x4000000000000, 0xc, x3, 312, x1)

inst_57:
// rs1_val == 2251799813685248, rs2_val == 61
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0x3d
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x8000000000000, 0x3d, x3, 320, x1)

inst_58:
// rs1_val == 4503599627370496, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, 0x10000000000, 0x10000000000000, 0xc, x3, 328, x1)

inst_59:
// rs1_val == 9007199254740992, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, 0x8000000000, 0x20000000000000, 0xe, x3, 336, x1)

inst_60:
// rs1_val == 18014398509481984, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0x3d
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x40000000000000, 0x3d, x3, 344, x1)

inst_61:
// rs1_val == 36028797018963968, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0x15
TEST_RR_OP(sra, x12, x10, x11, 0x400000000, 0x80000000000000, 0x15, x3, 352, x1)

inst_62:
// rs1_val == 72057594037927936, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0x4
TEST_RR_OP(sra, x12, x10, x11, 0x10000000000000, 0x100000000000000, 0x4, x3, 360, x1)

inst_63:
// rs1_val == 144115188075855872, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:0x1
TEST_RR_OP(sra, x12, x10, x11, 0x100000000000000, 0x200000000000000, 0x1, x3, 368, x1)

inst_64:
// rs1_val == 288230376151711744, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0x3d
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x400000000000000, 0x3d, x3, 376, x1)

inst_65:
// rs1_val == 576460752303423488, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0x3
TEST_RR_OP(sra, x12, x10, x11, 0x100000000000000, 0x800000000000000, 0x3, x3, 384, x1)

inst_66:
// rs1_val == 1152921504606846976, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x10
TEST_RR_OP(sra, x12, x10, x11, 0x100000000000, 0x1000000000000000, 0x10, x3, 392, x1)

inst_67:
// rs1_val == 2305843009213693952, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:0x2f
TEST_RR_OP(sra, x12, x10, x11, 0x4000, 0x2000000000000000, 0x2f, x3, 400, x1)

inst_68:
// rs1_val == 4611686018427387904, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0x12
TEST_RR_OP(sra, x12, x10, x11, 0x100000000000, 0x4000000000000000, 0x12, x3, 408, x1)

inst_69:
// rs1_val == -2, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:0x3d
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x2, 0x3d, x3, 416, x1)

inst_70:
// rs1_val == -3, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0x10
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x3, 0x10, x3, 424, x1)

inst_71:
// rs1_val == -5, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:0x15
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x5, 0x15, x3, 432, x1)

inst_72:
// rs1_val == -9, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0x2
TEST_RR_OP(sra, x12, x10, x11, -0x3, -0x9, 0x2, x3, 440, x1)

inst_73:
// rs1_val == -17, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:0xa
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x11, 0xa, x3, 448, x1)

inst_74:
// rs1_val == -33, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x20
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x21, 0x20, x3, 456, x1)

inst_75:
// rs1_val == -65, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:0x0
TEST_RR_OP(sra, x12, x10, x11, -0x41, -0x41, 0x0, x3, 464, x1)

inst_76:
// rs1_val == -129, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0x2, -0x81, 0x7, x3, 472, x1)

inst_77:
// rs1_val == -257, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0x3, -0x101, 0x7, x3, 480, x1)

inst_78:
// rs1_val == -513, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x3f
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x201, 0x3f, x3, 488, x1)

inst_79:
// rs1_val == -1025, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0x37
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x401, 0x37, x3, 496, x1)

inst_80:
// rs1_val == -2049, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x8
TEST_RR_OP(sra, x12, x10, x11, -0x9, -0x801, 0x8, x3, 504, x1)

inst_81:
// rs1_val == -4097, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:0x8
TEST_RR_OP(sra, x12, x10, x11, -0x11, -0x1001, 0x8, x3, 512, x1)

inst_82:
// rs1_val == -8193, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0x41, -0x2001, 0x7, x3, 520, x1)

inst_83:
// rs1_val == -16385, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0x3
TEST_RR_OP(sra, x12, x10, x11, -0x801, -0x4001, 0x3, x3, 528, x1)

inst_84:
// rs1_val == -32769, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, -0x9, -0x8001, 0xc, x3, 536, x1)

inst_85:
// rs1_val == -65537, rs2_val == 62
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0x3e
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x10001, 0x3e, x3, 544, x1)

inst_86:
// rs1_val == -131073, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x20
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x20001, 0x20, x3, 552, x1)

inst_87:
// rs1_val == -262145, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, -0x41, -0x40001, 0xc, x3, 560, x1)

inst_88:
// rs1_val == -36028797018963969, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:0x6
TEST_RR_OP(sra, x12, x10, x11, -0x2000000000001, -0x80000000000001, 0x6, x3, 568, x1)

inst_89:
// rs1_val == -72057594037927937, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000000001;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, -0x40000000001, -0x100000000000001, 0xe, x3, 576, x1)

inst_90:
// rs1_val == -144115188075855873, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:0x5
TEST_RR_OP(sra, x12, x10, x11, -0x10000000000001, -0x200000000000001, 0x5, x3, 584, x1)

inst_91:
// rs1_val == -288230376151711745, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:0x2
TEST_RR_OP(sra, x12, x10, x11, -0x100000000000001, -0x400000000000001, 0x2, x3, 592, x1)

inst_92:
// rs1_val == -576460752303423489, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0x10000000000001, -0x800000000000001, 0x7, x3, 600, x1)

inst_93:
// rs1_val == -1152921504606846977, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:0x4
TEST_RR_OP(sra, x12, x10, x11, -0x100000000000001, -0x1000000000000001, 0x4, x3, 608, x1)

inst_94:
// rs1_val == -2305843009213693953, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000000001;  op2val:0x3
TEST_RR_OP(sra, x12, x10, x11, -0x400000000000001, -0x2000000000000001, 0x3, x3, 616, x1)

inst_95:
// rs1_val == -4611686018427387905, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:0x1
TEST_RR_OP(sra, x12, x10, x11, -0x2000000000000001, -0x4000000000000001, 0x1, x3, 624, x1)

inst_96:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x9
TEST_RR_OP(sra, x12, x10, x11, 0x2aaaaaaaaaaaaa, 0x5555555555555555, 0x9, x3, 632, x1)

inst_97:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0xaaaaaaaaaaaaab, -0x5555555555555556, 0x7, x3, 640, x1)

inst_98:
// rs1_val==3, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x1
TEST_RR_OP(sra, x12, x10, x11, 0x1, 0x3, 0x1, x3, 648, x1)

inst_99:
// rs1_val==5, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x20
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x5, 0x20, x3, 656, x1)

inst_100:
// rs1_val==7378697629483820646, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, 0x6666666666666, 0x6666666666666666, 0xc, x3, 664, x1)

inst_101:
// rs1_val==-3037000499, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb
TEST_RR_OP(sra, x12, x10, x11, -0x16a09f, -0xb504f333, 0xb, x3, 672, x1)

inst_102:
// rs1_val==3037000499, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x1f
TEST_RR_OP(sra, x12, x10, x11, 0x1, 0xb504f333, 0x1f, x3, 680, x1)

inst_103:
// rs1_val==6148914691236517204, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x37
TEST_RR_OP(sra, x12, x10, x11, 0xaa, 0x5555555555555554, 0x37, x3, 688, x1)

inst_104:
// rs1_val==3689348814741910322, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x20
TEST_RR_OP(sra, x12, x10, x11, 0x33333333, 0x3333333333333332, 0x20, x3, 696, x1)

inst_105:
// rs1_val==7378697629483820645, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x9
TEST_RR_OP(sra, x12, x10, x11, 0x33333333333333, 0x6666666666666665, 0x9, x3, 704, x1)

inst_106:
// rs1_val==3037000498, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x15
TEST_RR_OP(sra, x12, x10, x11, 0x5a8, 0xb504f332, 0x15, x3, 712, x1)

inst_107:
// rs1_val==6148914691236517206, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, 0x1555555555555, 0x5555555555555556, 0xe, x3, 720, x1)

inst_108:
// rs1_val==-6148914691236517205, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, -0x1555555555556, -0x5555555555555555, 0xe, x3, 728, x1)

inst_109:
// rs1_val==6, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3e
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x6, 0x3e, x3, 736, x1)

inst_110:
// rs1_val==3689348814741910324, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x12
TEST_RR_OP(sra, x12, x10, x11, 0xccccccccccc, 0x3333333333333334, 0x12, x3, 744, x1)

inst_111:
// rs1_val==7378697629483820647, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, 0x1999999999999, 0x6666666666666667, 0xe, x3, 752, x1)

inst_112:
// rs1_val==-3037000498, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x11
TEST_RR_OP(sra, x12, x10, x11, -0x5a83, -0xb504f332, 0x11, x3, 760, x1)

inst_113:
// rs1_val==3037000500, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2a
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0xb504f334, 0x2a, x3, 768, x1)

inst_114:
// rs2_val == 59, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:0x3b
TEST_RR_OP(sra, x12, x10, x11, -0x2, -0x800000000000001, 0x3b, x3, 776, x1)

inst_115:
// rs1_val == -524289, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x20
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x80001, 0x20, x3, 784, x1)

inst_116:
// rs1_val == -1048577, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x11
TEST_RR_OP(sra, x12, x10, x11, -0x9, -0x100001, 0x11, x3, 792, x1)

inst_117:
// rs1_val == -2097153, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:0x5
TEST_RR_OP(sra, x12, x10, x11, -0x10001, -0x200001, 0x5, x3, 800, x1)

inst_118:
// rs1_val == -4194305, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0x20
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x400001, 0x20, x3, 808, x1)

inst_119:
// rs1_val == -8388609, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, -0x801, -0x800001, 0xc, x3, 816, x1)

inst_120:
// rs1_val == -16777217, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0xa
TEST_RR_OP(sra, x12, x10, x11, -0x4001, -0x1000001, 0xa, x3, 824, x1)

inst_121:
// rs1_val == -33554433, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0xc
TEST_RR_OP(sra, x12, x10, x11, -0x2001, -0x2000001, 0xc, x3, 832, x1)

inst_122:
// rs1_val == -67108865, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:0x3
TEST_RR_OP(sra, x12, x10, x11, -0x800001, -0x4000001, 0x3, x3, 840, x1)

inst_123:
// rs1_val == -134217729, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:0x3d
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x8000001, 0x3d, x3, 848, x1)

inst_124:
// rs1_val == -268435457, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0x11
TEST_RR_OP(sra, x12, x10, x11, -0x801, -0x10000001, 0x11, x3, 856, x1)

inst_125:
// rs1_val == -536870913, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x2f
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x20000001, 0x2f, x3, 864, x1)

inst_126:
// rs1_val == -1073741825, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0x9
TEST_RR_OP(sra, x12, x10, x11, -0x200001, -0x40000001, 0x9, x3, 872, x1)

inst_127:
// rs1_val == -2147483649, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:0xd
TEST_RR_OP(sra, x12, x10, x11, -0x40001, -0x80000001, 0xd, x3, 880, x1)

inst_128:
// rs1_val == -8589934593, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0xa
TEST_RR_OP(sra, x12, x10, x11, -0x800001, -0x200000001, 0xa, x3, 888, x1)

inst_129:
// rs1_val == -17179869185, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x400000001;  op2val:0x3b
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x400000001, 0x3b, x3, 896, x1)

inst_130:
// rs1_val == -68719476737, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, -0x400001, -0x1000000001, 0xe, x3, 904, x1)

inst_131:
// rs1_val == -137438953473, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:0x2f
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x2000000001, 0x2f, x3, 912, x1)

inst_132:
// rs1_val == -274877906945, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0xa
TEST_RR_OP(sra, x12, x10, x11, -0x10000001, -0x4000000001, 0xa, x3, 920, x1)

inst_133:
// rs1_val == -549755813889, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x37
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x8000000001, 0x37, x3, 928, x1)

inst_134:
// rs1_val == -1099511627777, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:0x9
TEST_RR_OP(sra, x12, x10, x11, -0x80000001, -0x10000000001, 0x9, x3, 936, x1)

inst_135:
// rs1_val == -2199023255553, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:0xd
TEST_RR_OP(sra, x12, x10, x11, -0x10000001, -0x20000000001, 0xd, x3, 944, x1)

inst_136:
// rs1_val == -4398046511105, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:0x1f
TEST_RR_OP(sra, x12, x10, x11, -0x801, -0x40000000001, 0x1f, x3, 952, x1)

inst_137:
// rs1_val == -8796093022209, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:0x12
TEST_RR_OP(sra, x12, x10, x11, -0x2000001, -0x80000000001, 0x12, x3, 960, x1)

inst_138:
// rs1_val == -17592186044417, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0x2000000001, -0x100000000001, 0x7, x3, 968, x1)

inst_139:
// rs1_val == -35184372088833, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:0x1
TEST_RR_OP(sra, x12, x10, x11, -0x100000000001, -0x200000000001, 0x1, x3, 976, x1)

inst_140:
// rs1_val == -70368744177665, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:0xf
TEST_RR_OP(sra, x12, x10, x11, -0x80000001, -0x400000000001, 0xf, x3, 984, x1)

inst_141:
// rs1_val == -140737488355329, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0xb
TEST_RR_OP(sra, x12, x10, x11, -0x1000000001, -0x800000000001, 0xb, x3, 992, x1)

inst_142:
// rs1_val == -281474976710657, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:0x3
TEST_RR_OP(sra, x12, x10, x11, -0x200000000001, -0x1000000000001, 0x3, x3, 1000, x1)

inst_143:
// rs1_val == -562949953421313, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:0x3f
TEST_RR_OP(sra, x12, x10, x11, -0x1, -0x2000000000001, 0x3f, x3, 1008, x1)

inst_144:
// rs1_val == -1125899906842625, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0x80000000001, -0x4000000000001, 0x7, x3, 1016, x1)

inst_145:
// rs1_val == -2251799813685249, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000001;  op2val:0x1
TEST_RR_OP(sra, x12, x10, x11, -0x4000000000001, -0x8000000000001, 0x1, x3, 1024, x1)

inst_146:
// rs1_val == -4503599627370497, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0xf
TEST_RR_OP(sra, x12, x10, x11, -0x2000000001, -0x10000000000001, 0xf, x3, 1032, x1)

inst_147:
// rs1_val == -9007199254740993, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000000001;  op2val:0xa
TEST_RR_OP(sra, x12, x10, x11, -0x80000000001, -0x20000000000001, 0xa, x3, 1040, x1)

inst_148:
// rs1_val == -18014398509481985, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:0xe
TEST_RR_OP(sra, x12, x10, x11, -0x10000000001, -0x40000000000001, 0xe, x3, 1048, x1)

inst_149:
// rs1_val < 0 and rs2_val > 0 and rs2_val < xlen, rs1_val == -34359738369
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x800000001;  op2val:0x7
TEST_RR_OP(sra, x12, x10, x11, -0x10000001, -0x800000001, 0x7, x3, 1056, x1)

inst_150:
// rs1_val < 0 and rs2_val == 0, rs1_val == -4294967297
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:0x0
TEST_RR_OP(sra, x12, x10, x11, -0x100000001, -0x100000001, 0x0, x3, 1064, x1)

inst_151:
// rs1_val == (2**(xlen-1)-1) and rs2_val >= 0 and rs2_val < xlen, rs1_val == 9223372036854775807
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:0x3
TEST_RR_OP(sra, x12, x10, x11, 0xfffffffffffffff, 0x7fffffffffffffff, 0x3, x3, 1072, x1)

inst_152:
// rs1_val == 16, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x6
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x10, 0x6, x3, 1080, x1)

inst_153:
// rs1_val == 512, 
// opcode: sra ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:0xb
TEST_RR_OP(sra, x12, x10, x11, 0x0, 0x200, 0xb, x3, 1088, x1)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x9_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x9_1:
    .fill 17*(XLEN/32),4,0xdeadbeef


signature_x3_0:
    .fill 137*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
