
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the srai instruction of the RISC-V I extension for the srai covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",srai)

RVTEST_SIGBASE( x7,signature_x7_1)

inst_0:
// rs1 == rd, rs1==x13, rd==x13, rs1_val < 0 and imm_val > 0 and imm_val < xlen, rs1_val == -288230376151711745
// opcode: srai ; op1:x13; dest:x13; op1val:-0x400000000000001;  immval:0x6
TEST_IMM_OP( srai, x13, x13, -0x10000000000001, -0x400000000000001, 0x6, x7, 0, x9)

inst_1:
// rs1 != rd, rs1==x6, rd==x2, rs1_val > 0 and imm_val > 0 and imm_val < xlen, rs1_val==4, rs1_val == 4
// opcode: srai ; op1:x6; dest:x2; op1val:0x4;  immval:0xc
TEST_IMM_OP( srai, x2, x6, 0x0, 0x4, 0xc, x7, 8, x9)

inst_2:
// rs1==x15, rd==x28, rs1_val < 0 and imm_val == 0, 
// opcode: srai ; op1:x15; dest:x28; op1val:-0xa;  immval:0x0
TEST_IMM_OP( srai, x28, x15, -0xa, -0xa, 0x0, x7, 16, x9)

inst_3:
// rs1==x18, rd==x30, rs1_val > 0 and imm_val == 0, 
// opcode: srai ; op1:x18; dest:x30; op1val:0x9;  immval:0x0
TEST_IMM_OP( srai, x30, x18, 0x9, 0x9, 0x0, x7, 24, x9)

inst_4:
// rs1==x30, rd==x29, rs1_val < 0 and imm_val == (xlen-1), rs1_val == -33554433
// opcode: srai ; op1:x30; dest:x29; op1val:-0x2000001;  immval:0x3f
TEST_IMM_OP( srai, x29, x30, -0x1, -0x2000001, 0x3f, x7, 32, x9)

inst_5:
// rs1==x27, rd==x15, rs1_val > 0 and imm_val == (xlen-1), rs1_val == 65536
// opcode: srai ; op1:x27; dest:x15; op1val:0x10000;  immval:0x3f
TEST_IMM_OP( srai, x15, x27, 0x0, 0x10000, 0x3f, x7, 40, x9)

inst_6:
// rs1==x23, rd==x14, rs1_val == imm_val and imm_val > 0 and imm_val < xlen, rs1_val == 1 and imm_val >= 0 and imm_val < xlen, rs1_val == 1, imm_val == 1
// opcode: srai ; op1:x23; dest:x14; op1val:0x1;  immval:0x1
TEST_IMM_OP( srai, x14, x23, 0x0, 0x1, 0x1, x7, 48, x9)

inst_7:
// rs1==x29, rd==x27, rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < xlen, imm_val == 32, rs1_val == -9223372036854775808
// opcode: srai ; op1:x29; dest:x27; op1val:-0x8000000000000000;  immval:0x20
TEST_IMM_OP( srai, x27, x29, -0x80000000, -0x8000000000000000, 0x20, x7, 56, x9)

inst_8:
// rs1==x31, rd==x22, rs1_val == 0 and imm_val >= 0 and imm_val < xlen, rs1_val==0
// opcode: srai ; op1:x31; dest:x22; op1val:0x0;  immval:0x7
TEST_IMM_OP( srai, x22, x31, 0x0, 0x0, 0x7, x7, 64, x9)

inst_9:
// rs1==x4, rd==x16, rs1_val == (2**(xlen-1)-1) and imm_val >= 0 and imm_val < xlen, rs1_val == 9223372036854775807
// opcode: srai ; op1:x4; dest:x16; op1val:0x7fffffffffffffff;  immval:0xc
TEST_IMM_OP( srai, x16, x4, 0x7ffffffffffff, 0x7fffffffffffffff, 0xc, x7, 72, x9)

inst_10:
// rs1==x24, rd==x21, rs1_val == 2, rs1_val==2
// opcode: srai ; op1:x24; dest:x21; op1val:0x2;  immval:0x11
TEST_IMM_OP( srai, x21, x24, 0x0, 0x2, 0x11, x7, 80, x9)

inst_11:
// rs1==x20, rd==x0, rs1_val == 8, imm_val == 42
// opcode: srai ; op1:x20; dest:x0; op1val:0x8;  immval:0x2a
TEST_IMM_OP( srai, x0, x20, 0, 0x8, 0x2a, x7, 88, x9)

inst_12:
// rs1==x28, rd==x19, rs1_val == 16, imm_val == 31
// opcode: srai ; op1:x28; dest:x19; op1val:0x10;  immval:0x1f
TEST_IMM_OP( srai, x19, x28, 0x0, 0x10, 0x1f, x7, 96, x9)

inst_13:
// rs1==x8, rd==x18, rs1_val == 32, 
// opcode: srai ; op1:x8; dest:x18; op1val:0x20;  immval:0x3
TEST_IMM_OP( srai, x18, x8, 0x4, 0x20, 0x3, x7, 104, x9)

inst_14:
// rs1==x3, rd==x26, rs1_val == 64, 
// opcode: srai ; op1:x3; dest:x26; op1val:0x40;  immval:0xb
TEST_IMM_OP( srai, x26, x3, 0x0, 0x40, 0xb, x7, 112, x9)

inst_15:
// rs1==x1, rd==x23, rs1_val == 128, 
// opcode: srai ; op1:x1; dest:x23; op1val:0x80;  immval:0x12
TEST_IMM_OP( srai, x23, x1, 0x0, 0x80, 0x12, x7, 120, x9)

inst_16:
// rs1==x0, rd==x20, rs1_val == 256, 
// opcode: srai ; op1:x0; dest:x20; op1val:0x0;  immval:0x12
TEST_IMM_OP( srai, x20, x0, 0x0, 0x0, 0x12, x7, 128, x9)

inst_17:
// rs1==x10, rd==x8, rs1_val == 512, imm_val == 21
// opcode: srai ; op1:x10; dest:x8; op1val:0x200;  immval:0x15
TEST_IMM_OP( srai, x8, x10, 0x0, 0x200, 0x15, x7, 136, x9)

inst_18:
// rs1==x5, rd==x6, rs1_val == 1024, 
// opcode: srai ; op1:x5; dest:x6; op1val:0x400;  immval:0x0
TEST_IMM_OP( srai, x6, x5, 0x400, 0x400, 0x0, x7, 144, x9)

inst_19:
// rs1==x12, rd==x10, rs1_val == 2048, imm_val == 2
// opcode: srai ; op1:x12; dest:x10; op1val:0x800;  immval:0x2
TEST_IMM_OP( srai, x10, x12, 0x200, 0x800, 0x2, x7, 152, x9)

inst_20:
// rs1==x21, rd==x1, rs1_val == 4096, imm_val == 4
// opcode: srai ; op1:x21; dest:x1; op1val:0x1000;  immval:0x4
TEST_IMM_OP( srai, x1, x21, 0x100, 0x1000, 0x4, x7, 160, x9)

inst_21:
// rs1==x11, rd==x5, rs1_val == 8192, 
// opcode: srai ; op1:x11; dest:x5; op1val:0x2000;  immval:0x11
TEST_IMM_OP( srai, x5, x11, 0x0, 0x2000, 0x11, x7, 168, x9)

inst_22:
// rs1==x2, rd==x17, rs1_val == 16384, 
// opcode: srai ; op1:x2; dest:x17; op1val:0x4000;  immval:0xf
TEST_IMM_OP( srai, x17, x2, 0x0, 0x4000, 0xf, x7, 176, x5)
RVTEST_SIGBASE( x1,signature_x1_0)

inst_23:
// rs1==x25, rd==x4, rs1_val == 32768, 
// opcode: srai ; op1:x25; dest:x4; op1val:0x8000;  immval:0xb
TEST_IMM_OP( srai, x4, x25, 0x10, 0x8000, 0xb, x1, 0, x5)

inst_24:
// rs1==x19, rd==x9, rs1_val == 131072, 
// opcode: srai ; op1:x19; dest:x9; op1val:0x20000;  immval:0x7
TEST_IMM_OP( srai, x9, x19, 0x400, 0x20000, 0x7, x1, 8, x5)

inst_25:
// rs1==x7, rd==x12, rs1_val == 262144, 
// opcode: srai ; op1:x7; dest:x12; op1val:0x40000;  immval:0x6
TEST_IMM_OP( srai, x12, x7, 0x1000, 0x40000, 0x6, x1, 16, x5)

inst_26:
// rs1==x16, rd==x11, rs1_val == 524288, 
// opcode: srai ; op1:x16; dest:x11; op1val:0x80000;  immval:0x13
TEST_IMM_OP( srai, x11, x16, 0x1, 0x80000, 0x13, x1, 24, x5)

inst_27:
// rs1==x14, rd==x3, rs1_val == 1048576, 
// opcode: srai ; op1:x14; dest:x3; op1val:0x100000;  immval:0x12
TEST_IMM_OP( srai, x3, x14, 0x4, 0x100000, 0x12, x1, 32, x5)

inst_28:
// rs1==x9, rd==x31, rs1_val == 2097152, 
// opcode: srai ; op1:x9; dest:x31; op1val:0x200000;  immval:0xa
TEST_IMM_OP( srai, x31, x9, 0x800, 0x200000, 0xa, x1, 40, x5)

inst_29:
// rs1==x26, rd==x7, rs1_val == 4194304, 
// opcode: srai ; op1:x26; dest:x7; op1val:0x400000;  immval:0xa
TEST_IMM_OP( srai, x7, x26, 0x1000, 0x400000, 0xa, x1, 48, x5)

inst_30:
// rs1==x22, rd==x25, rs1_val == 8388608, 
// opcode: srai ; op1:x22; dest:x25; op1val:0x800000;  immval:0xd
TEST_IMM_OP( srai, x25, x22, 0x400, 0x800000, 0xd, x1, 56, x5)

inst_31:
// rs1==x17, rd==x24, rs1_val == 16777216, 
// opcode: srai ; op1:x17; dest:x24; op1val:0x1000000;  immval:0x5
TEST_IMM_OP( srai, x24, x17, 0x80000, 0x1000000, 0x5, x1, 64, x5)

inst_32:
// rs1_val == 33554432, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x9
TEST_IMM_OP( srai, x11, x10, 0x10000, 0x2000000, 0x9, x1, 72, x5)

inst_33:
// rs1_val == 67108864, imm_val == 16
// opcode: srai ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x10
TEST_IMM_OP( srai, x11, x10, 0x400, 0x4000000, 0x10, x1, 80, x5)

inst_34:
// rs1_val == 134217728, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x8000000;  immval:0xd
TEST_IMM_OP( srai, x11, x10, 0x4000, 0x8000000, 0xd, x1, 88, x5)

inst_35:
// rs1_val == 268435456, imm_val == 59
// opcode: srai ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x3b
TEST_IMM_OP( srai, x11, x10, 0x0, 0x10000000, 0x3b, x1, 96, x5)

inst_36:
// rs1_val == 536870912, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x9
TEST_IMM_OP( srai, x11, x10, 0x100000, 0x20000000, 0x9, x1, 104, x5)

inst_37:
// rs1_val == 1073741824, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x40000000;  immval:0xe
TEST_IMM_OP( srai, x11, x10, 0x10000, 0x40000000, 0xe, x1, 112, x5)

inst_38:
// rs1_val == 2147483648, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x80000000;  immval:0x20
TEST_IMM_OP( srai, x11, x10, 0x0, 0x80000000, 0x20, x1, 120, x5)

inst_39:
// rs1_val == 4294967296, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x1f
TEST_IMM_OP( srai, x11, x10, 0x2, 0x100000000, 0x1f, x1, 128, x5)

inst_40:
// rs1_val == 8589934592, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x200000000;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x800000, 0x200000000, 0xa, x1, 136, x5)

inst_41:
// rs1_val == 17179869184, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x400000000;  immval:0x9
TEST_IMM_OP( srai, x11, x10, 0x2000000, 0x400000000, 0x9, x1, 144, x5)

inst_42:
// rs1_val == 34359738368, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x800000000;  immval:0xf
TEST_IMM_OP( srai, x11, x10, 0x100000, 0x800000000, 0xf, x1, 152, x5)

inst_43:
// rs1_val == 68719476736, imm_val == 62
// opcode: srai ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0x3e
TEST_IMM_OP( srai, x11, x10, 0x0, 0x1000000000, 0x3e, x1, 160, x5)

inst_44:
// rs1_val == 137438953472, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x2000000000;  immval:0x2
TEST_IMM_OP( srai, x11, x10, 0x800000000, 0x2000000000, 0x2, x1, 168, x5)

inst_45:
// rs1_val == 274877906944, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x4000000000;  immval:0x1f
TEST_IMM_OP( srai, x11, x10, 0x80, 0x4000000000, 0x1f, x1, 176, x5)

inst_46:
// rs1_val == 549755813888, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x3
TEST_IMM_OP( srai, x11, x10, 0x1000000000, 0x8000000000, 0x3, x1, 184, x5)

inst_47:
// rs1_val == 1099511627776, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x10000000000;  immval:0x4
TEST_IMM_OP( srai, x11, x10, 0x1000000000, 0x10000000000, 0x4, x1, 192, x5)

inst_48:
// rs1_val == 2199023255552, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x20000000000;  immval:0xe
TEST_IMM_OP( srai, x11, x10, 0x8000000, 0x20000000000, 0xe, x1, 200, x5)

inst_49:
// rs1_val == 4398046511104, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x40000000000;  immval:0x4
TEST_IMM_OP( srai, x11, x10, 0x4000000000, 0x40000000000, 0x4, x1, 208, x5)

inst_50:
// rs1_val == 8796093022208, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x5
TEST_IMM_OP( srai, x11, x10, 0x4000000000, 0x80000000000, 0x5, x1, 216, x5)

inst_51:
// rs1_val == 17592186044416, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x100000000000;  immval:0xf
TEST_IMM_OP( srai, x11, x10, 0x20000000, 0x100000000000, 0xf, x1, 224, x5)

inst_52:
// rs1_val == 35184372088832, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x4
TEST_IMM_OP( srai, x11, x10, 0x20000000000, 0x200000000000, 0x4, x1, 232, x5)

inst_53:
// rs1_val == 70368744177664, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x1000000000, 0x400000000000, 0xa, x1, 240, x5)

inst_54:
// rs1_val == 140737488355328, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x2a
TEST_IMM_OP( srai, x11, x10, 0x20, 0x800000000000, 0x2a, x1, 248, x5)

inst_55:
// rs1_val == 281474976710656, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x4000000000, 0x1000000000000, 0xa, x1, 256, x5)

inst_56:
// rs1_val == 562949953421312, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x3f
TEST_IMM_OP( srai, x11, x10, 0x0, 0x2000000000000, 0x3f, x1, 264, x5)

inst_57:
// rs1_val == 1125899906842624, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x3
TEST_IMM_OP( srai, x11, x10, 0x800000000000, 0x4000000000000, 0x3, x1, 272, x5)

inst_58:
// rs1_val == 2251799813685248, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x4
TEST_IMM_OP( srai, x11, x10, 0x800000000000, 0x8000000000000, 0x4, x1, 280, x5)

inst_59:
// rs1_val == 4503599627370496, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x10000000000000;  immval:0xf
TEST_IMM_OP( srai, x11, x10, 0x2000000000, 0x10000000000000, 0xf, x1, 288, x5)

inst_60:
// rs1_val == 9007199254740992, imm_val == 61
// opcode: srai ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0x3d
TEST_IMM_OP( srai, x11, x10, 0x0, 0x20000000000000, 0x3d, x1, 296, x5)

inst_61:
// rs1_val == 18014398509481984, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0xe
TEST_IMM_OP( srai, x11, x10, 0x10000000000, 0x40000000000000, 0xe, x1, 304, x5)

inst_62:
// rs1_val == 36028797018963968, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x200000000000, 0x80000000000000, 0xa, x1, 312, x5)

inst_63:
// rs1_val == 72057594037927936, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x400000000000, 0x100000000000000, 0xa, x1, 320, x5)

inst_64:
// rs1_val == 144115188075855872, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:0x2a
TEST_IMM_OP( srai, x11, x10, 0x8000, 0x200000000000000, 0x2a, x1, 328, x5)

inst_65:
// rs1_val == 288230376151711744, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0x4
TEST_IMM_OP( srai, x11, x10, 0x40000000000000, 0x400000000000000, 0x4, x1, 336, x5)

inst_66:
// rs1_val == 576460752303423488, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0xb
TEST_IMM_OP( srai, x11, x10, 0x1000000000000, 0x800000000000000, 0xb, x1, 344, x5)

inst_67:
// rs1_val == 1152921504606846976, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x3b
TEST_IMM_OP( srai, x11, x10, 0x2, 0x1000000000000000, 0x3b, x1, 352, x5)

inst_68:
// rs1_val == 2305843009213693952, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x3f
TEST_IMM_OP( srai, x11, x10, 0x0, 0x2000000000000000, 0x3f, x1, 360, x5)

inst_69:
// rs1_val == 4611686018427387904, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0x9
TEST_IMM_OP( srai, x11, x10, 0x20000000000000, 0x4000000000000000, 0x9, x1, 368, x5)

inst_70:
// rs1_val == -2, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2;  immval:0x15
TEST_IMM_OP( srai, x11, x10, -0x1, -0x2, 0x15, x1, 376, x5)

inst_71:
// rs1_val == -3, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x3;  immval:0x2
TEST_IMM_OP( srai, x11, x10, -0x1, -0x3, 0x2, x1, 384, x5)

inst_72:
// rs1_val == -5, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x5;  immval:0x3d
TEST_IMM_OP( srai, x11, x10, -0x1, -0x5, 0x3d, x1, 392, x5)

inst_73:
// rs1_val == -9, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x9;  immval:0xd
TEST_IMM_OP( srai, x11, x10, -0x1, -0x9, 0xd, x1, 400, x5)

inst_74:
// rs1_val == -17, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x11;  immval:0x3f
TEST_IMM_OP( srai, x11, x10, -0x1, -0x11, 0x3f, x1, 408, x5)

inst_75:
// rs1_val == -33, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x21;  immval:0x7
TEST_IMM_OP( srai, x11, x10, -0x1, -0x21, 0x7, x1, 416, x5)

inst_76:
// rs1_val == -65, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x41;  immval:0xe
TEST_IMM_OP( srai, x11, x10, -0x1, -0x41, 0xe, x1, 424, x5)

inst_77:
// rs1_val == -129, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x81;  immval:0x6
TEST_IMM_OP( srai, x11, x10, -0x3, -0x81, 0x6, x1, 432, x5)

inst_78:
// rs1_val == -257, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x101;  immval:0xc
TEST_IMM_OP( srai, x11, x10, -0x1, -0x101, 0xc, x1, 440, x5)

inst_79:
// rs1_val == -513, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x201;  immval:0x3
TEST_IMM_OP( srai, x11, x10, -0x41, -0x201, 0x3, x1, 448, x5)

inst_80:
// rs1_val == -1025, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x401;  immval:0xf
TEST_IMM_OP( srai, x11, x10, -0x1, -0x401, 0xf, x1, 456, x5)

inst_81:
// rs1_val == -2049, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x801;  immval:0x9
TEST_IMM_OP( srai, x11, x10, -0x5, -0x801, 0x9, x1, 464, x5)

inst_82:
// rs1_val == -4097, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x3f
TEST_IMM_OP( srai, x11, x10, -0x1, -0x1001, 0x3f, x1, 472, x5)

inst_83:
// rs1_val == -8193, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2001;  immval:0x9
TEST_IMM_OP( srai, x11, x10, -0x11, -0x2001, 0x9, x1, 480, x5)

inst_84:
// rs1_val == -16385, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x3
TEST_IMM_OP( srai, x11, x10, -0x801, -0x4001, 0x3, x1, 488, x5)

inst_85:
// rs1_val == -32769, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x10
TEST_IMM_OP( srai, x11, x10, -0x1, -0x8001, 0x10, x1, 496, x5)

inst_86:
// rs1_val == -65537, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x10001;  immval:0x15
TEST_IMM_OP( srai, x11, x10, -0x1, -0x10001, 0x15, x1, 504, x5)

inst_87:
// rs1_val == -131073, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x5
TEST_IMM_OP( srai, x11, x10, -0x1001, -0x20001, 0x5, x1, 512, x5)

inst_88:
// rs1_val == -262145, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x1
TEST_IMM_OP( srai, x11, x10, -0x20001, -0x40001, 0x1, x1, 520, x5)

inst_89:
// rs1_val == -524289, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x80001;  immval:0x3f
TEST_IMM_OP( srai, x11, x10, -0x1, -0x80001, 0x3f, x1, 528, x5)

inst_90:
// rs1_val == -1048577, imm_val == 55
// opcode: srai ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x37
TEST_IMM_OP( srai, x11, x10, -0x1, -0x100001, 0x37, x1, 536, x5)

inst_91:
// rs1_val == -2097153, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x200001;  immval:0x7
TEST_IMM_OP( srai, x11, x10, -0x4001, -0x200001, 0x7, x1, 544, x5)

inst_92:
// rs1_val == -9007199254740993, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:0x15
TEST_IMM_OP( srai, x11, x10, -0x100000001, -0x20000000000001, 0x15, x1, 552, x5)

inst_93:
// rs1_val == -18014398509481985, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x40000000000001;  immval:0x13
TEST_IMM_OP( srai, x11, x10, -0x800000001, -0x40000000000001, 0x13, x1, 560, x5)

inst_94:
// rs1_val == -36028797018963969, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x80000000000001;  immval:0x15
TEST_IMM_OP( srai, x11, x10, -0x400000001, -0x80000000000001, 0x15, x1, 568, x5)

inst_95:
// rs1_val == -72057594037927937, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0x1f
TEST_IMM_OP( srai, x11, x10, -0x2000001, -0x100000000000001, 0x1f, x1, 576, x5)

inst_96:
// rs1_val == -144115188075855873, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:0x3b
TEST_IMM_OP( srai, x11, x10, -0x1, -0x200000000000001, 0x3b, x1, 584, x5)

inst_97:
// rs1_val == -576460752303423489, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:0x1f
TEST_IMM_OP( srai, x11, x10, -0x10000001, -0x800000000000001, 0x1f, x1, 592, x5)

inst_98:
// rs1_val == -1152921504606846977, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:0x1
TEST_IMM_OP( srai, x11, x10, -0x800000000000001, -0x1000000000000001, 0x1, x1, 600, x5)

inst_99:
// rs1_val == -2305843009213693953, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0x20
TEST_IMM_OP( srai, x11, x10, -0x20000001, -0x2000000000000001, 0x20, x1, 608, x5)

inst_100:
// rs1_val == -4611686018427387905, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:0x13
TEST_IMM_OP( srai, x11, x10, -0x80000000001, -0x4000000000000001, 0x13, x1, 616, x5)

inst_101:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: srai ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x12
TEST_IMM_OP( srai, x11, x10, 0x155555555555, 0x5555555555555555, 0x12, x1, 624, x5)

inst_102:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode: srai ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x1f
TEST_IMM_OP( srai, x11, x10, -0xaaaaaaab, -0x5555555555555556, 0x1f, x1, 632, x5)

inst_103:
// rs1_val==3, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x3;  immval:0x2a
TEST_IMM_OP( srai, x11, x10, 0x0, 0x3, 0x2a, x1, 640, x5)

inst_104:
// rs1_val==5, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x5;  immval:0x3e
TEST_IMM_OP( srai, x11, x10, 0x0, 0x5, 0x3e, x1, 648, x5)

inst_105:
// rs1_val==3689348814741910323, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x4
TEST_IMM_OP( srai, x11, x10, 0x333333333333333, 0x3333333333333333, 0x4, x1, 656, x5)

inst_106:
// rs1_val==7378697629483820646, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2
TEST_IMM_OP( srai, x11, x10, 0x1999999999999999, 0x6666666666666666, 0x2, x1, 664, x5)

inst_107:
// rs1_val==-3037000499, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0xb
TEST_IMM_OP( srai, x11, x10, -0x16a09f, -0xb504f333, 0xb, x1, 672, x5)

inst_108:
// rs1_val==3037000499, 
// opcode: srai ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x12
TEST_IMM_OP( srai, x11, x10, 0x2d41, 0xb504f333, 0x12, x1, 680, x5)

inst_109:
// rs1_val==6148914691236517204, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0xc
TEST_IMM_OP( srai, x11, x10, 0x5555555555555, 0x5555555555555554, 0xc, x1, 688, x5)

inst_110:
// rs1_val==3689348814741910322, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x13
TEST_IMM_OP( srai, x11, x10, 0x66666666666, 0x3333333333333332, 0x13, x1, 696, x5)

inst_111:
// rs1_val==7378697629483820645, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x1
TEST_IMM_OP( srai, x11, x10, 0x3333333333333332, 0x6666666666666665, 0x1, x1, 704, x5)

inst_112:
// rs1_val==3037000498, 
// opcode: srai ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x2d413c, 0xb504f332, 0xa, x1, 712, x5)

inst_113:
// rs1_val==6148914691236517206, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0xc
TEST_IMM_OP( srai, x11, x10, 0x5555555555555, 0x5555555555555556, 0xc, x1, 720, x5)

inst_114:
// rs1_val==-6148914691236517205, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x3
TEST_IMM_OP( srai, x11, x10, -0xaaaaaaaaaaaaaab, -0x5555555555555555, 0x3, x1, 728, x5)

inst_115:
// rs1_val==6, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x6;  immval:0x15
TEST_IMM_OP( srai, x11, x10, 0x0, 0x6, 0x15, x1, 736, x5)

inst_116:
// rs1_val==3689348814741910324, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0xf
TEST_IMM_OP( srai, x11, x10, 0x666666666666, 0x3333333333333334, 0xf, x1, 744, x5)

inst_117:
// rs1_val==7378697629483820647, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0xa
TEST_IMM_OP( srai, x11, x10, 0x19999999999999, 0x6666666666666667, 0xa, x1, 752, x5)

inst_118:
// rs1_val==-3037000498, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0xb
TEST_IMM_OP( srai, x11, x10, -0x16a09f, -0xb504f332, 0xb, x1, 760, x5)

inst_119:
// rs1_val==3037000500, imm_val == 8
// opcode: srai ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x8
TEST_IMM_OP( srai, x11, x10, 0xb504f3, 0xb504f334, 0x8, x1, 768, x5)

inst_120:
// imm_val == 47, rs1_val == -35184372088833
// opcode: srai ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:0x2f
TEST_IMM_OP( srai, x11, x10, -0x1, -0x200000000001, 0x2f, x1, 776, x5)

inst_121:
// rs1_val == -4194305, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x2a
TEST_IMM_OP( srai, x11, x10, -0x1, -0x400001, 0x2a, x1, 784, x5)

inst_122:
// rs1_val == -8388609, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x800001;  immval:0xd
TEST_IMM_OP( srai, x11, x10, -0x401, -0x800001, 0xd, x1, 792, x5)

inst_123:
// rs1_val == -16777217, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0x1
TEST_IMM_OP( srai, x11, x10, -0x800001, -0x1000001, 0x1, x1, 800, x5)

inst_124:
// rs1_val == -67108865, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0xc
TEST_IMM_OP( srai, x11, x10, -0x4001, -0x4000001, 0xc, x1, 808, x5)

inst_125:
// rs1_val == -134217729, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0x7
TEST_IMM_OP( srai, x11, x10, -0x100001, -0x8000001, 0x7, x1, 816, x5)

inst_126:
// rs1_val == -268435457, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0x4
TEST_IMM_OP( srai, x11, x10, -0x1000001, -0x10000001, 0x4, x1, 824, x5)

inst_127:
// rs1_val == -536870913, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0x3b
TEST_IMM_OP( srai, x11, x10, -0x1, -0x20000001, 0x3b, x1, 832, x5)

inst_128:
// rs1_val == -1073741825, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x20
TEST_IMM_OP( srai, x11, x10, -0x1, -0x40000001, 0x20, x1, 840, x5)

inst_129:
// rs1_val == -2147483649, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x80000001;  immval:0x9
TEST_IMM_OP( srai, x11, x10, -0x400001, -0x80000001, 0x9, x1, 848, x5)

inst_130:
// rs1_val == -4294967297, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x100000001;  immval:0x4
TEST_IMM_OP( srai, x11, x10, -0x10000001, -0x100000001, 0x4, x1, 856, x5)

inst_131:
// rs1_val == -8589934593, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x200000001;  immval:0xc
TEST_IMM_OP( srai, x11, x10, -0x200001, -0x200000001, 0xc, x1, 864, x5)

inst_132:
// rs1_val == -17179869185, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x400000001;  immval:0x2f
TEST_IMM_OP( srai, x11, x10, -0x1, -0x400000001, 0x2f, x1, 872, x5)

inst_133:
// rs1_val == -34359738369, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x11
TEST_IMM_OP( srai, x11, x10, -0x40001, -0x800000001, 0x11, x1, 880, x5)

inst_134:
// rs1_val == -68719476737, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:0xf
TEST_IMM_OP( srai, x11, x10, -0x200001, -0x1000000001, 0xf, x1, 888, x5)

inst_135:
// rs1_val == -137438953473, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0x13
TEST_IMM_OP( srai, x11, x10, -0x40001, -0x2000000001, 0x13, x1, 896, x5)

inst_136:
// rs1_val == -274877906945, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x3
TEST_IMM_OP( srai, x11, x10, -0x800000001, -0x4000000001, 0x3, x1, 904, x5)

inst_137:
// rs1_val == -549755813889, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:0xe
TEST_IMM_OP( srai, x11, x10, -0x2000001, -0x8000000001, 0xe, x1, 912, x5)

inst_138:
// rs1_val == -1099511627777, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0x1
TEST_IMM_OP( srai, x11, x10, -0x8000000001, -0x10000000001, 0x1, x1, 920, x5)

inst_139:
// rs1_val == -2199023255553, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:0x5
TEST_IMM_OP( srai, x11, x10, -0x1000000001, -0x20000000001, 0x5, x1, 928, x5)

inst_140:
// rs1_val == -4398046511105, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x40000000001;  immval:0x8
TEST_IMM_OP( srai, x11, x10, -0x400000001, -0x40000000001, 0x8, x1, 936, x5)

inst_141:
// rs1_val == -8796093022209, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x80000000001;  immval:0x6
TEST_IMM_OP( srai, x11, x10, -0x2000000001, -0x80000000001, 0x6, x1, 944, x5)

inst_142:
// rs1_val == -17592186044417, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:0x9
TEST_IMM_OP( srai, x11, x10, -0x800000001, -0x100000000001, 0x9, x1, 952, x5)

inst_143:
// rs1_val == -70368744177665, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:0x8
TEST_IMM_OP( srai, x11, x10, -0x4000000001, -0x400000000001, 0x8, x1, 960, x5)

inst_144:
// rs1_val == -140737488355329, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:0x2
TEST_IMM_OP( srai, x11, x10, -0x200000000001, -0x800000000001, 0x2, x1, 968, x5)

inst_145:
// rs1_val == -281474976710657, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x1000000000001;  immval:0x1f
TEST_IMM_OP( srai, x11, x10, -0x20001, -0x1000000000001, 0x1f, x1, 976, x5)

inst_146:
// rs1_val == -562949953421313, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:0x3b
TEST_IMM_OP( srai, x11, x10, -0x1, -0x2000000000001, 0x3b, x1, 984, x5)

inst_147:
// rs1_val == -1125899906842625, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:0x37
TEST_IMM_OP( srai, x11, x10, -0x1, -0x4000000000001, 0x37, x1, 992, x5)

inst_148:
// rs1_val == -2251799813685249, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:0x3
TEST_IMM_OP( srai, x11, x10, -0x1000000000001, -0x8000000000001, 0x3, x1, 1000, x5)

inst_149:
// rs1_val == -4503599627370497, 
// opcode: srai ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:0x13
TEST_IMM_OP( srai, x11, x10, -0x200000001, -0x10000000000001, 0x13, x1, 1008, x5)

inst_150:
// rs1_val == 8, imm_val == 42
// opcode: srai ; op1:x10; dest:x11; op1val:0x8;  immval:0x2a
TEST_IMM_OP( srai, x11, x10, 0x0, 0x8, 0x2a, x1, 1016, x5)

inst_151:
// rs1_val == 256, 
// opcode: srai ; op1:x10; dest:x11; op1val:0x100;  immval:0x12
TEST_IMM_OP( srai, x11, x10, 0x0, 0x100, 0x12, x1, 1024, x5)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x7_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x7_1:
    .fill 23*(XLEN/32),4,0xdeadbeef


signature_x1_0:
    .fill 129*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
