
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the srli instruction of the RISC-V I extension for the srli covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",srli)

RVTEST_SIGBASE( x16,signature_x16_1)

inst_0:
// rs1 == rd, rs1==x26, rd==x26, rs1_val < 0 and imm_val > 0 and imm_val < xlen, imm_val == 8
// opcode: srli ; op1:x26; dest:x26; op1val:-0x1;  immval:0x8
TEST_IMM_OP( srli, x26, x26, 0xffffffffffffff, -0x1, 0x8, x16, 0, x20)

inst_1:
// rs1 != rd, rs1==x25, rd==x0, rs1_val > 0 and imm_val > 0 and imm_val < xlen, rs1_val==3037000499
// opcode: srli ; op1:x25; dest:x0; op1val:0xb504f333;  immval:0xe
TEST_IMM_OP( srli, x0, x25, 0, 0xb504f333, 0xe, x16, 8, x20)

inst_2:
// rs1==x21, rd==x6, rs1_val < 0 and imm_val == 0, rs1_val == -137438953473
// opcode: srli ; op1:x21; dest:x6; op1val:-0x2000000001;  immval:0x0
TEST_IMM_OP( srli, x6, x21, 0xffffffdfffffffff, -0x2000000001, 0x0, x16, 16, x20)

inst_3:
// rs1==x17, rd==x5, rs1_val > 0 and imm_val == 0, rs1_val==7378697629483820646
// opcode: srli ; op1:x17; dest:x5; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( srli, x5, x17, 0x6666666666666666, 0x6666666666666666, 0x0, x16, 24, x20)

inst_4:
// rs1==x30, rd==x24, rs1_val < 0 and imm_val == (xlen-1), 
// opcode: srli ; op1:x30; dest:x24; op1val:-0x8;  immval:0x3f
TEST_IMM_OP( srli, x24, x30, 0x1, -0x8, 0x3f, x16, 32, x20)

inst_5:
// rs1==x4, rd==x1, rs1_val > 0 and imm_val == (xlen-1), rs1_val == 2251799813685248
// opcode: srli ; op1:x4; dest:x1; op1val:0x8000000000000;  immval:0x3f
TEST_IMM_OP( srli, x1, x4, 0x0, 0x8000000000000, 0x3f, x16, 40, x20)

inst_6:
// rs1==x9, rd==x13, rs1_val == imm_val and imm_val > 0 and imm_val < xlen, rs1_val==3
// opcode: srli ; op1:x9; dest:x13; op1val:0x3;  immval:0x3
TEST_IMM_OP( srli, x13, x9, 0x0, 0x3, 0x3, x16, 48, x20)

inst_7:
// rs1==x2, rd==x3, rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < xlen, rs1_val == -9223372036854775808
// opcode: srli ; op1:x2; dest:x3; op1val:-0x8000000000000000;  immval:0x9
TEST_IMM_OP( srli, x3, x2, 0x40000000000000, -0x8000000000000000, 0x9, x16, 56, x20)

inst_8:
// rs1==x8, rd==x10, rs1_val == 0 and imm_val >= 0 and imm_val < xlen, rs1_val==0
// opcode: srli ; op1:x8; dest:x10; op1val:0x0;  immval:0x3
TEST_IMM_OP( srli, x10, x8, 0x0, 0x0, 0x3, x16, 64, x20)

inst_9:
// rs1==x6, rd==x23, rs1_val == (2**(xlen-1)-1) and imm_val >= 0 and imm_val < xlen, rs1_val == 9223372036854775807
// opcode: srli ; op1:x6; dest:x23; op1val:0x7fffffffffffffff;  immval:0xb
TEST_IMM_OP( srli, x23, x6, 0xfffffffffffff, 0x7fffffffffffffff, 0xb, x16, 72, x20)

inst_10:
// rs1==x12, rd==x28, rs1_val == 1 and imm_val >= 0 and imm_val < xlen, rs1_val == 1, imm_val == 21
// opcode: srli ; op1:x12; dest:x28; op1val:0x1;  immval:0x15
TEST_IMM_OP( srli, x28, x12, 0x0, 0x1, 0x15, x16, 80, x20)

inst_11:
// rs1==x15, rd==x7, rs1_val == 2, imm_val == 59, rs1_val==2
// opcode: srli ; op1:x15; dest:x7; op1val:0x2;  immval:0x3b
TEST_IMM_OP( srli, x7, x15, 0x0, 0x2, 0x3b, x16, 88, x20)

inst_12:
// rs1==x11, rd==x15, rs1_val == 4, rs1_val==4
// opcode: srli ; op1:x11; dest:x15; op1val:0x4;  immval:0x3f
TEST_IMM_OP( srli, x15, x11, 0x0, 0x4, 0x3f, x16, 96, x20)

inst_13:
// rs1==x19, rd==x9, rs1_val == 8, 
// opcode: srli ; op1:x19; dest:x9; op1val:0x8;  immval:0x8
TEST_IMM_OP( srli, x9, x19, 0x0, 0x8, 0x8, x16, 104, x20)

inst_14:
// rs1==x28, rd==x25, rs1_val == 16, 
// opcode: srli ; op1:x28; dest:x25; op1val:0x10;  immval:0x7
TEST_IMM_OP( srli, x25, x28, 0x0, 0x10, 0x7, x16, 112, x20)

inst_15:
// rs1==x27, rd==x31, rs1_val == 32, 
// opcode: srli ; op1:x27; dest:x31; op1val:0x20;  immval:0x11
TEST_IMM_OP( srli, x31, x27, 0x0, 0x20, 0x11, x16, 120, x20)

inst_16:
// rs1==x14, rd==x21, rs1_val == 64, imm_val == 1
// opcode: srli ; op1:x14; dest:x21; op1val:0x40;  immval:0x1
TEST_IMM_OP( srli, x21, x14, 0x20, 0x40, 0x1, x16, 128, x20)

inst_17:
// rs1==x3, rd==x30, rs1_val == 128, 
// opcode: srli ; op1:x3; dest:x30; op1val:0x80;  immval:0x5
TEST_IMM_OP( srli, x30, x3, 0x4, 0x80, 0x5, x16, 136, x20)

inst_18:
// rs1==x18, rd==x8, rs1_val == 256, 
// opcode: srli ; op1:x18; dest:x8; op1val:0x100;  immval:0x8
TEST_IMM_OP( srli, x8, x18, 0x1, 0x100, 0x8, x16, 144, x20)

inst_19:
// rs1==x31, rd==x17, rs1_val == 512, imm_val == 47
// opcode: srli ; op1:x31; dest:x17; op1val:0x200;  immval:0x2f
TEST_IMM_OP( srli, x17, x31, 0x0, 0x200, 0x2f, x16, 152, x6)

inst_20:
// rs1==x7, rd==x18, rs1_val == 1024, 
// opcode: srli ; op1:x7; dest:x18; op1val:0x400;  immval:0x13
TEST_IMM_OP( srli, x18, x7, 0x0, 0x400, 0x13, x16, 160, x6)

inst_21:
// rs1==x29, rd==x4, rs1_val == 2048, 
// opcode: srli ; op1:x29; dest:x4; op1val:0x800;  immval:0x13
TEST_IMM_OP( srli, x4, x29, 0x0, 0x800, 0x13, x16, 168, x6)
RVTEST_SIGBASE( x3,signature_x3_0)

inst_22:
// rs1==x20, rd==x19, rs1_val == 4096, 
// opcode: srli ; op1:x20; dest:x19; op1val:0x1000;  immval:0xc
TEST_IMM_OP( srli, x19, x20, 0x1, 0x1000, 0xc, x3, 0, x6)

inst_23:
// rs1==x5, rd==x16, rs1_val == 8192, 
// opcode: srli ; op1:x5; dest:x16; op1val:0x2000;  immval:0x1
TEST_IMM_OP( srli, x16, x5, 0x1000, 0x2000, 0x1, x3, 8, x6)

inst_24:
// rs1==x1, rd==x14, rs1_val == 16384, 
// opcode: srli ; op1:x1; dest:x14; op1val:0x4000;  immval:0x8
TEST_IMM_OP( srli, x14, x1, 0x40, 0x4000, 0x8, x3, 16, x6)

inst_25:
// rs1==x10, rd==x2, rs1_val == 32768, 
// opcode: srli ; op1:x10; dest:x2; op1val:0x8000;  immval:0x6
TEST_IMM_OP( srli, x2, x10, 0x200, 0x8000, 0x6, x3, 24, x6)

inst_26:
// rs1==x16, rd==x20, rs1_val == 65536, 
// opcode: srli ; op1:x16; dest:x20; op1val:0x10000;  immval:0x2f
TEST_IMM_OP( srli, x20, x16, 0x0, 0x10000, 0x2f, x3, 32, x6)

inst_27:
// rs1==x13, rd==x27, rs1_val == 131072, 
// opcode: srli ; op1:x13; dest:x27; op1val:0x20000;  immval:0xf
TEST_IMM_OP( srli, x27, x13, 0x4, 0x20000, 0xf, x3, 40, x6)

inst_28:
// rs1==x0, rd==x29, rs1_val == 262144, 
// opcode: srli ; op1:x0; dest:x29; op1val:0x0;  immval:0x7
TEST_IMM_OP( srli, x29, x0, 0x0, 0x0, 0x7, x3, 48, x6)

inst_29:
// rs1==x24, rd==x11, rs1_val == 524288, imm_val == 42
// opcode: srli ; op1:x24; dest:x11; op1val:0x80000;  immval:0x2a
TEST_IMM_OP( srli, x11, x24, 0x0, 0x80000, 0x2a, x3, 56, x6)

inst_30:
// rs1==x23, rd==x22, rs1_val == 1048576, imm_val == 32
// opcode: srli ; op1:x23; dest:x22; op1val:0x100000;  immval:0x20
TEST_IMM_OP( srli, x22, x23, 0x0, 0x100000, 0x20, x3, 64, x6)

inst_31:
// rs1==x22, rd==x12, rs1_val == 2097152, 
// opcode: srli ; op1:x22; dest:x12; op1val:0x200000;  immval:0x1
TEST_IMM_OP( srli, x12, x22, 0x100000, 0x200000, 0x1, x3, 72, x6)

inst_32:
// rs1_val == 4194304, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x400000;  immval:0x6
TEST_IMM_OP( srli, x11, x10, 0x10000, 0x400000, 0x6, x3, 80, x6)

inst_33:
// rs1_val == 8388608, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x800000;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x400, 0x800000, 0xd, x3, 88, x6)

inst_34:
// rs1_val == 16777216, imm_val == 31
// opcode: srli ; op1:x10; dest:x11; op1val:0x1000000;  immval:0x1f
TEST_IMM_OP( srli, x11, x10, 0x0, 0x1000000, 0x1f, x3, 96, x6)

inst_35:
// rs1_val == 33554432, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x2000000;  immval:0xb
TEST_IMM_OP( srli, x11, x10, 0x4000, 0x2000000, 0xb, x3, 104, x6)

inst_36:
// rs1_val == 67108864, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x1f
TEST_IMM_OP( srli, x11, x10, 0x0, 0x4000000, 0x1f, x3, 112, x6)

inst_37:
// rs1_val == 134217728, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x200, 0x8000000, 0x12, x3, 120, x6)

inst_38:
// rs1_val == 268435456, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0x10000000, 0x10000000, 0x0, x3, 128, x6)

inst_39:
// rs1_val == 536870912, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x2a
TEST_IMM_OP( srli, x11, x10, 0x0, 0x20000000, 0x2a, x3, 136, x6)

inst_40:
// rs1_val == 1073741824, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x200, 0x40000000, 0x15, x3, 144, x6)

inst_41:
// rs1_val == 2147483648, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x80000000;  immval:0xa
TEST_IMM_OP( srli, x11, x10, 0x200000, 0x80000000, 0xa, x3, 152, x6)

inst_42:
// rs1_val == 4294967296, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x13
TEST_IMM_OP( srli, x11, x10, 0x2000, 0x100000000, 0x13, x3, 160, x6)

inst_43:
// rs1_val == 8589934592, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x200000000;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x8000, 0x200000000, 0x12, x3, 168, x6)

inst_44:
// rs1_val == 17179869184, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x400000000;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0x400000000, 0x400000000, 0x0, x3, 176, x6)

inst_45:
// rs1_val == 34359738368, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x800000000;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x100000000, 0x800000000, 0x3, x3, 184, x6)

inst_46:
// rs1_val == 68719476736, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x800000, 0x1000000000, 0xd, x3, 192, x6)

inst_47:
// rs1_val == 137438953472, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x2000000000;  immval:0x1f
TEST_IMM_OP( srli, x11, x10, 0x40, 0x2000000000, 0x1f, x3, 200, x6)

inst_48:
// rs1_val == 274877906944, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x4000000000;  immval:0x3b
TEST_IMM_OP( srli, x11, x10, 0x0, 0x4000000000, 0x3b, x3, 208, x6)

inst_49:
// rs1_val == 549755813888, imm_val == 4
// opcode: srli ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x4
TEST_IMM_OP( srli, x11, x10, 0x800000000, 0x8000000000, 0x4, x3, 216, x6)

inst_50:
// rs1_val == 1099511627776, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x10000000000;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x80000, 0x10000000000, 0x15, x3, 224, x6)

inst_51:
// rs1_val == 2199023255552, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x20000000000;  immval:0x13
TEST_IMM_OP( srli, x11, x10, 0x400000, 0x20000000000, 0x13, x3, 232, x6)

inst_52:
// rs1_val == 4398046511104, imm_val == 61
// opcode: srli ; op1:x10; dest:x11; op1val:0x40000000000;  immval:0x3d
TEST_IMM_OP( srli, x11, x10, 0x0, 0x40000000000, 0x3d, x3, 240, x6)

inst_53:
// rs1_val == 8796093022208, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x2a
TEST_IMM_OP( srli, x11, x10, 0x2, 0x80000000000, 0x2a, x3, 248, x6)

inst_54:
// rs1_val == 17592186044416, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x100000000000;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0x100000000000, 0x100000000000, 0x0, x3, 256, x6)

inst_55:
// rs1_val == 35184372088832, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x100000000000, 0x200000000000, 0x1, x3, 264, x6)

inst_56:
// rs1_val == 70368744177664, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0xb
TEST_IMM_OP( srli, x11, x10, 0x800000000, 0x400000000000, 0xb, x3, 272, x6)

inst_57:
// rs1_val == 140737488355328, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x3d
TEST_IMM_OP( srli, x11, x10, 0x0, 0x800000000000, 0x3d, x3, 280, x6)

inst_58:
// rs1_val == 281474976710656, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0x2a
TEST_IMM_OP( srli, x11, x10, 0x40, 0x1000000000000, 0x2a, x3, 288, x6)

inst_59:
// rs1_val == 562949953421312, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x8
TEST_IMM_OP( srli, x11, x10, 0x20000000000, 0x2000000000000, 0x8, x3, 296, x6)

inst_60:
// rs1_val == 1125899906842624, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x20
TEST_IMM_OP( srli, x11, x10, 0x40000, 0x4000000000000, 0x20, x3, 304, x6)

inst_61:
// rs1_val == 4503599627370496, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x10000000000000;  immval:0x2a
TEST_IMM_OP( srli, x11, x10, 0x400, 0x10000000000000, 0x2a, x3, 312, x6)

inst_62:
// rs1_val == 9007199254740992, imm_val == 62
// opcode: srli ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0x3e
TEST_IMM_OP( srli, x11, x10, 0x0, 0x20000000000000, 0x3e, x3, 320, x6)

inst_63:
// rs1_val == 18014398509481984, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x20000000000, 0x40000000000000, 0xd, x3, 328, x6)

inst_64:
// rs1_val == 36028797018963968, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x2000000000, 0x80000000000000, 0x12, x3, 336, x6)

inst_65:
// rs1_val == 72057594037927936, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x4000000000, 0x100000000000000, 0x12, x3, 344, x6)

inst_66:
// rs1_val == 144115188075855872, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x100000000000, 0x200000000000000, 0xd, x3, 352, x6)

inst_67:
// rs1_val == 288230376151711744, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0x6
TEST_IMM_OP( srli, x11, x10, 0x10000000000000, 0x400000000000000, 0x6, x3, 360, x6)

inst_68:
// rs1_val == 576460752303423488, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0x20
TEST_IMM_OP( srli, x11, x10, 0x8000000, 0x800000000000000, 0x20, x3, 368, x6)

inst_69:
// rs1_val == 1152921504606846976, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x200000000000000, 0x1000000000000000, 0x3, x3, 376, x6)

inst_70:
// rs1_val == 2305843009213693952, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x400000000000000, 0x2000000000000000, 0x3, x3, 384, x6)

inst_71:
// rs1_val == 4611686018427387904, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0xf
TEST_IMM_OP( srli, x11, x10, 0x800000000000, 0x4000000000000000, 0xf, x3, 392, x6)

inst_72:
// rs1_val == -2, imm_val == 16
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2;  immval:0x10
TEST_IMM_OP( srli, x11, x10, 0xffffffffffff, -0x2, 0x10, x3, 400, x6)

inst_73:
// rs1_val == -3, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x3;  immval:0x3d
TEST_IMM_OP( srli, x11, x10, 0x7, -0x3, 0x3d, x3, 408, x6)

inst_74:
// rs1_val == -5, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x5;  immval:0x3f
TEST_IMM_OP( srli, x11, x10, 0x1, -0x5, 0x3f, x3, 416, x6)

inst_75:
// rs1_val == -9, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x9;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x1ffffffffffffffe, -0x9, 0x3, x3, 424, x6)

inst_76:
// rs1_val == -17, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x11;  immval:0xc
TEST_IMM_OP( srli, x11, x10, 0xfffffffffffff, -0x11, 0xc, x3, 432, x6)

inst_77:
// rs1_val == -33, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x21;  immval:0x6
TEST_IMM_OP( srli, x11, x10, 0x3ffffffffffffff, -0x21, 0x6, x3, 440, x6)

inst_78:
// rs1_val == -65, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x41;  immval:0x5
TEST_IMM_OP( srli, x11, x10, 0x7fffffffffffffd, -0x41, 0x5, x3, 448, x6)

inst_79:
// rs1_val == -129, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x81;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x7ffffffffffff, -0x81, 0xd, x3, 456, x6)

inst_80:
// rs1_val == -257, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x101;  immval:0x3e
TEST_IMM_OP( srli, x11, x10, 0x3, -0x101, 0x3e, x3, 464, x6)

inst_81:
// rs1_val == -513, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x201;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x7ffffffffffff, -0x201, 0xd, x3, 472, x6)

inst_82:
// rs1_val == -1025, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x401;  immval:0x9
TEST_IMM_OP( srli, x11, x10, 0x7ffffffffffffd, -0x401, 0x9, x3, 480, x6)

inst_83:
// rs1_val == -2049, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x801;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x3ffffffffffff, -0x801, 0xe, x3, 488, x6)

inst_84:
// rs1_val == -4097, imm_val == 55
// opcode: srli ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x37
TEST_IMM_OP( srli, x11, x10, 0x1ff, -0x1001, 0x37, x3, 496, x6)

inst_85:
// rs1_val == -8193, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2001;  immval:0x6
TEST_IMM_OP( srli, x11, x10, 0x3ffffffffffff7f, -0x2001, 0x6, x3, 504, x6)

inst_86:
// rs1_val == -16385, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3fffffffffff, -0x4001, 0x12, x3, 512, x6)

inst_87:
// rs1_val == -32769, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0xffffffffffff7fff, -0x8001, 0x0, x3, 520, x6)

inst_88:
// rs1_val == -65537, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x10001;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x3fffffffffffb, -0x10001, 0xe, x3, 528, x6)

inst_89:
// rs1_val == -131073, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x1f
TEST_IMM_OP( srli, x11, x10, 0x1ffffffff, -0x20001, 0x1f, x3, 536, x6)

inst_90:
// rs1_val == -9007199254740993, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3ff7ffffffff, -0x20000000000001, 0x12, x3, 544, x6)

inst_91:
// rs1_val == -18014398509481985, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x40000000000001;  immval:0x1f
TEST_IMM_OP( srli, x11, x10, 0x1ff7fffff, -0x40000000000001, 0x1f, x3, 552, x6)

inst_92:
// rs1_val == -36028797018963969, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x80000000000001;  immval:0x3b
TEST_IMM_OP( srli, x11, x10, 0x1f, -0x80000000000001, 0x3b, x3, 560, x6)

inst_93:
// rs1_val == -72057594037927937, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0x3
TEST_IMM_OP( srli, x11, x10, 0x1fdfffffffffffff, -0x100000000000001, 0x3, x3, 568, x6)

inst_94:
// rs1_val == -144115188075855873, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3f7fffffffff, -0x200000000000001, 0x12, x3, 576, x6)

inst_95:
// rs1_val == -288230376151711745, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x400000000000001;  immval:0x8
TEST_IMM_OP( srli, x11, x10, 0xfbffffffffffff, -0x400000000000001, 0x8, x3, 584, x6)

inst_96:
// rs1_val == -576460752303423489, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3dffffffffff, -0x800000000000001, 0x12, x3, 592, x6)

inst_97:
// rs1_val == -1152921504606846977, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:0xb
TEST_IMM_OP( srli, x11, x10, 0x1dffffffffffff, -0x1000000000000001, 0xb, x3, 600, x6)

inst_98:
// rs1_val == -2305843009213693953, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0xc
TEST_IMM_OP( srli, x11, x10, 0xdffffffffffff, -0x2000000000000001, 0xc, x3, 608, x6)

inst_99:
// rs1_val == -4611686018427387905, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x2fffffffffff, -0x4000000000000001, 0x12, x3, 616, x6)

inst_100:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: srli ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x9
TEST_IMM_OP( srli, x11, x10, 0x2aaaaaaaaaaaaa, 0x5555555555555555, 0x9, x3, 624, x6)

inst_101:
// rs1_val == -6148914691236517206, rs1_val==-6148914691236517206
// opcode: srli ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x5555555555555555, -0x5555555555555556, 0x1, x3, 632, x6)

inst_102:
// rs1_val==5, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x5;  immval:0x13
TEST_IMM_OP( srli, x11, x10, 0x0, 0x5, 0x13, x3, 640, x6)

inst_103:
// rs1_val==3689348814741910323, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x20
TEST_IMM_OP( srli, x11, x10, 0x33333333, 0x3333333333333333, 0x20, x3, 648, x6)

inst_104:
// rs1_val==-3037000499, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x5
TEST_IMM_OP( srli, x11, x10, 0x7fffffffa57d866, -0xb504f333, 0x5, x3, 656, x6)

inst_105:
// rs1_val==6148914691236517204, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x2aaaaaaaaaaaaaaa, 0x5555555555555554, 0x1, x3, 664, x6)

inst_106:
// rs1_val==3689348814741910322, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x7
TEST_IMM_OP( srli, x11, x10, 0x66666666666666, 0x3333333333333332, 0x7, x3, 672, x6)

inst_107:
// rs1_val==7378697629483820645, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2f
TEST_IMM_OP( srli, x11, x10, 0xcccc, 0x6666666666666665, 0x2f, x3, 680, x6)

inst_108:
// rs1_val==3037000498, 
// opcode: srli ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x5a8, 0xb504f332, 0x15, x3, 688, x6)

inst_109:
// rs1_val==6148914691236517206, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0xb
TEST_IMM_OP( srli, x11, x10, 0xaaaaaaaaaaaaa, 0x5555555555555556, 0xb, x3, 696, x6)

inst_110:
// rs1_val==-6148914691236517205, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0xa
TEST_IMM_OP( srli, x11, x10, 0x2aaaaaaaaaaaaa, -0x5555555555555555, 0xa, x3, 704, x6)

inst_111:
// rs1_val==6, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x6;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x0, 0x6, 0xd, x3, 712, x6)

inst_112:
// rs1_val==3689348814741910324, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0xcccccccccccc, 0x3333333333333334, 0xe, x3, 720, x6)

inst_113:
// rs1_val==7378697629483820647, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x0, x3, 728, x6)

inst_114:
// rs1_val==-3037000498, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x3e
TEST_IMM_OP( srli, x11, x10, 0x3, -0xb504f332, 0x3e, x3, 736, x6)

inst_115:
// rs1_val==3037000500, 
// opcode: srli ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x20
TEST_IMM_OP( srli, x11, x10, 0x0, 0xb504f334, 0x20, x3, 744, x6)

inst_116:
// imm_val == 2, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0x2
TEST_IMM_OP( srli, x11, x10, 0x10000000000000, 0x40000000000000, 0x2, x3, 752, x6)

inst_117:
// rs1_val == -262145, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x2
TEST_IMM_OP( srli, x11, x10, 0x3ffffffffffeffff, -0x40001, 0x2, x3, 760, x6)

inst_118:
// rs1_val == -524289, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x80001;  immval:0x37
TEST_IMM_OP( srli, x11, x10, 0x1ff, -0x80001, 0x37, x3, 768, x6)

inst_119:
// rs1_val == -1048577, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x37
TEST_IMM_OP( srli, x11, x10, 0x1ff, -0x100001, 0x37, x3, 776, x6)

inst_120:
// rs1_val == -2097153, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x200001;  immval:0x3e
TEST_IMM_OP( srli, x11, x10, 0x3, -0x200001, 0x3e, x3, 784, x6)

inst_121:
// rs1_val == -4194305, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x3b
TEST_IMM_OP( srli, x11, x10, 0x1f, -0x400001, 0x3b, x3, 792, x6)

inst_122:
// rs1_val == -8388609, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x800001;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x7fffffffffb, -0x800001, 0x15, x3, 800, x6)

inst_123:
// rs1_val == -16777217, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x1000001;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x7fffffffff7fffff, -0x1000001, 0x1, x3, 808, x6)

inst_124:
// rs1_val == -33554433, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3fffffffff7f, -0x2000001, 0x12, x3, 816, x6)

inst_125:
// rs1_val == -67108865, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0xa
TEST_IMM_OP( srli, x11, x10, 0x3ffffffffeffff, -0x4000001, 0xa, x3, 824, x6)

inst_126:
// rs1_val == -134217729, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0x20
TEST_IMM_OP( srli, x11, x10, 0xffffffff, -0x8000001, 0x20, x3, 832, x6)

inst_127:
// rs1_val == -268435457, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0xc
TEST_IMM_OP( srli, x11, x10, 0xffffffffeffff, -0x10000001, 0xc, x3, 840, x6)

inst_128:
// rs1_val == -536870913, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x3ffffffff7fff, -0x20000001, 0xe, x3, 848, x6)

inst_129:
// rs1_val == -1073741825, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0x37
TEST_IMM_OP( srli, x11, x10, 0x1ff, -0x40000001, 0x37, x3, 856, x6)

inst_130:
// rs1_val == -2147483649, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x80000001;  immval:0x1
TEST_IMM_OP( srli, x11, x10, 0x7fffffffbfffffff, -0x80000001, 0x1, x3, 864, x6)

inst_131:
// rs1_val == -4294967297, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x100000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3fffffffbfff, -0x100000001, 0x12, x3, 872, x6)

inst_132:
// rs1_val == -8589934593, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x200000001;  immval:0x11
TEST_IMM_OP( srli, x11, x10, 0x7ffffffeffff, -0x200000001, 0x11, x3, 880, x6)

inst_133:
// rs1_val == -17179869185, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x400000001;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x3ffffffefffff, -0x400000001, 0xe, x3, 888, x6)

inst_134:
// rs1_val == -34359738369, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x0
TEST_IMM_OP( srli, x11, x10, 0xfffffff7ffffffff, -0x800000001, 0x0, x3, 896, x6)

inst_135:
// rs1_val == -68719476737, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:0x2
TEST_IMM_OP( srli, x11, x10, 0x3ffffffbffffffff, -0x1000000001, 0x2, x3, 904, x6)

inst_136:
// rs1_val == -274877906945, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x20
TEST_IMM_OP( srli, x11, x10, 0xffffffbf, -0x4000000001, 0x20, x3, 912, x6)

inst_137:
// rs1_val == -549755813889, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:0xa
TEST_IMM_OP( srli, x11, x10, 0x3fffffdfffffff, -0x8000000001, 0xa, x3, 920, x6)

inst_138:
// rs1_val == -1099511627777, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x7fffff7ffffff, -0x10000000001, 0xd, x3, 928, x6)

inst_139:
// rs1_val == -2199023255553, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:0x8
TEST_IMM_OP( srli, x11, x10, 0xfffffdffffffff, -0x20000000001, 0x8, x3, 936, x6)

inst_140:
// rs1_val == -4398046511105, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x40000000001;  immval:0xb
TEST_IMM_OP( srli, x11, x10, 0x1fffff7fffffff, -0x40000000001, 0xb, x3, 944, x6)

inst_141:
// rs1_val == -8796093022209, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x80000000001;  immval:0x6
TEST_IMM_OP( srli, x11, x10, 0x3ffffdfffffffff, -0x80000000001, 0x6, x3, 952, x6)

inst_142:
// rs1_val == -17592186044417, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:0x12
TEST_IMM_OP( srli, x11, x10, 0x3ffffbffffff, -0x100000000001, 0x12, x3, 960, x6)

inst_143:
// rs1_val == -35184372088833, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:0x3d
TEST_IMM_OP( srli, x11, x10, 0x7, -0x200000000001, 0x3d, x3, 968, x6)

inst_144:
// rs1_val == -70368744177665, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:0x2a
TEST_IMM_OP( srli, x11, x10, 0x3fffef, -0x400000000001, 0x2a, x3, 976, x6)

inst_145:
// rs1_val == -140737488355329, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x7fffbffffff, -0x800000000001, 0x15, x3, 984, x6)

inst_146:
// rs1_val == -281474976710657, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x1000000000001;  immval:0x7
TEST_IMM_OP( srli, x11, x10, 0x1fffdffffffffff, -0x1000000000001, 0x7, x3, 992, x6)

inst_147:
// rs1_val == -562949953421313, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:0x3d
TEST_IMM_OP( srli, x11, x10, 0x7, -0x2000000000001, 0x3d, x3, 1000, x6)

inst_148:
// rs1_val == -1125899906842625, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:0x5
TEST_IMM_OP( srli, x11, x10, 0x7ffdfffffffffff, -0x4000000000001, 0x5, x3, 1008, x6)

inst_149:
// rs1_val == -2251799813685249, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:0xd
TEST_IMM_OP( srli, x11, x10, 0x7ffbfffffffff, -0x8000000000001, 0xd, x3, 1016, x6)

inst_150:
// rs1_val == -4503599627370497, 
// opcode: srli ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:0x15
TEST_IMM_OP( srli, x11, x10, 0x7ff7fffffff, -0x10000000000001, 0x15, x3, 1024, x6)

inst_151:
// rs1_val > 0 and imm_val > 0 and imm_val < xlen, rs1_val==3037000499
// opcode: srli ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0xe
TEST_IMM_OP( srli, x11, x10, 0x2d413, 0xb504f333, 0xe, x3, 1032, x6)

inst_152:
// rs1_val == 262144, 
// opcode: srli ; op1:x10; dest:x11; op1val:0x40000;  immval:0x7
TEST_IMM_OP( srli, x11, x10, 0x800, 0x40000, 0x7, x3, 1040, x6)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x16_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x16_1:
    .fill 22*(XLEN/32),4,0xdeadbeef


signature_x3_0:
    .fill 131*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
