
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the srliw instruction of the RISC-V I extension for the srliw covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*RV64.*I.*);def TEST_CASE_1=True;",srliw)

RVTEST_SIGBASE( x12,signature_x12_1)

inst_0:
// rs1 == rd, rs1==x21, rd==x21, rs1_val < 0 and imm_val > 0 and imm_val < 32, imm_val == 15, rs1_val == -68719476737
// opcode: srliw ; op1:x21; dest:x21; op1val:-0x1000000001;  immval:0xf
TEST_IMM_OP( srliw, x21, x21, 0x1ffff, -0x1000000001, 0xf, x12, 0, x14)

inst_1:
// rs1 != rd, rs1==x22, rd==x3, rs1_val > 0 and imm_val > 0 and imm_val < 32, rs1_val==7378697629483820646, imm_val == 8
// opcode: srliw ; op1:x22; dest:x3; op1val:0x6666666666666666;  immval:0x8
TEST_IMM_OP( srliw, x3, x22, 0x666666, 0x6666666666666666, 0x8, x12, 8, x14)

inst_2:
// rs1==x11, rd==x4, rs1_val < 0 and imm_val == 0, rs1_val == -16777217
// opcode: srliw ; op1:x11; dest:x4; op1val:-0x1000001;  immval:0x0
TEST_IMM_OP( srliw, x4, x11, -0x1000001, -0x1000001, 0x0, x12, 16, x14)

inst_3:
// rs1==x7, rd==x23, rs1_val > 0 and imm_val == 0, 
// opcode: srliw ; op1:x7; dest:x23; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( srliw, x23, x7, 0x66666666, 0x6666666666666666, 0x0, x12, 24, x14)

inst_4:
// rs1==x31, rd==x17, rs1_val < 0 and imm_val == 31, rs1_val == -36028797018963969
// opcode: srliw ; op1:x31; dest:x17; op1val:-0x80000000000001;  immval:0x1f
TEST_IMM_OP( srliw, x17, x31, 0x1, -0x80000000000001, 0x1f, x12, 32, x14)

inst_5:
// rs1==x10, rd==x28, rs1_val > 0 and imm_val == 31, rs1_val == 1099511627776
// opcode: srliw ; op1:x10; dest:x28; op1val:0x10000000000;  immval:0x1f
TEST_IMM_OP( srliw, x28, x10, 0x0, 0x10000000000, 0x1f, x12, 40, x14)

inst_6:
// rs1==x24, rd==x9, rs1_val == imm_val and imm_val > 0 and imm_val < 32, 
// opcode: srliw ; op1:x24; dest:x9; op1val:0x9;  immval:0x9
TEST_IMM_OP( srliw, x9, x24, 0x0, 0x9, 0x9, x12, 48, x14)

inst_7:
// rs1==x20, rd==x0, rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < 32, imm_val == 27, rs1_val == -9223372036854775808
// opcode: srliw ; op1:x20; dest:x0; op1val:-0x8000000000000000;  immval:0x1b
TEST_IMM_OP( srliw, x0, x20, 0, -0x8000000000000000, 0x1b, x12, 56, x14)

inst_8:
// rs1==x15, rd==x8, rs1_val == 0 and imm_val >= 0 and imm_val < 32, imm_val == 1, rs1_val==0
// opcode: srliw ; op1:x15; dest:x8; op1val:0x0;  immval:0x1
TEST_IMM_OP( srliw, x8, x15, 0x0, 0x0, 0x1, x12, 64, x14)

inst_9:
// rs1==x28, rd==x20, rs1_val == (2**(xlen-1)-1) and imm_val >= 0 and imm_val < 32, rs1_val == 9223372036854775807
// opcode: srliw ; op1:x28; dest:x20; op1val:0x7fffffffffffffff;  immval:0xb
TEST_IMM_OP( srliw, x20, x28, 0x1fffff, 0x7fffffffffffffff, 0xb, x12, 72, x14)

inst_10:
// rs1==x23, rd==x19, rs1_val == 1 and imm_val >= 0 and imm_val < 32, rs1_val == 1, imm_val == 10
// opcode: srliw ; op1:x23; dest:x19; op1val:0x1;  immval:0xa
TEST_IMM_OP( srliw, x19, x23, 0x0, 0x1, 0xa, x12, 80, x14)

inst_11:
// rs1==x13, rd==x15, rs1_val == 2, rs1_val==2
// opcode: srliw ; op1:x13; dest:x15; op1val:0x2;  immval:0x11
TEST_IMM_OP( srliw, x15, x13, 0x0, 0x2, 0x11, x12, 88, x14)

inst_12:
// rs1==x8, rd==x16, rs1_val == 4, rs1_val==4
// opcode: srliw ; op1:x8; dest:x16; op1val:0x4;  immval:0x12
TEST_IMM_OP( srliw, x16, x8, 0x0, 0x4, 0x12, x12, 96, x14)

inst_13:
// rs1==x4, rd==x26, rs1_val == 8, 
// opcode: srliw ; op1:x4; dest:x26; op1val:0x8;  immval:0x12
TEST_IMM_OP( srliw, x26, x4, 0x0, 0x8, 0x12, x12, 104, x14)

inst_14:
// rs1==x2, rd==x29, rs1_val == 16, 
// opcode: srliw ; op1:x2; dest:x29; op1val:0x10;  immval:0x11
TEST_IMM_OP( srliw, x29, x2, 0x0, 0x10, 0x11, x12, 112, x14)

inst_15:
// rs1==x5, rd==x27, rs1_val == 32, 
// opcode: srliw ; op1:x5; dest:x27; op1val:0x20;  immval:0x6
TEST_IMM_OP( srliw, x27, x5, 0x0, 0x20, 0x6, x12, 120, x14)

inst_16:
// rs1==x3, rd==x13, rs1_val == 64, 
// opcode: srliw ; op1:x3; dest:x13; op1val:0x40;  immval:0xc
TEST_IMM_OP( srliw, x13, x3, 0x0, 0x40, 0xc, x12, 128, x14)

inst_17:
// rs1==x9, rd==x31, rs1_val == 128, 
// opcode: srliw ; op1:x9; dest:x31; op1val:0x80;  immval:0x12
TEST_IMM_OP( srliw, x31, x9, 0x0, 0x80, 0x12, x12, 136, x14)

inst_18:
// rs1==x6, rd==x1, rs1_val == 256, 
// opcode: srliw ; op1:x6; dest:x1; op1val:0x100;  immval:0x5
TEST_IMM_OP( srliw, x1, x6, 0x8, 0x100, 0x5, x12, 144, x14)

inst_19:
// rs1==x19, rd==x25, rs1_val == 512, 
// opcode: srliw ; op1:x19; dest:x25; op1val:0x200;  immval:0x1b
TEST_IMM_OP( srliw, x25, x19, 0x0, 0x200, 0x1b, x12, 152, x14)

inst_20:
// rs1==x18, rd==x2, rs1_val == 1024, 
// opcode: srliw ; op1:x18; dest:x2; op1val:0x400;  immval:0x9
TEST_IMM_OP( srliw, x2, x18, 0x2, 0x400, 0x9, x12, 160, x3)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_21:
// rs1==x14, rd==x7, rs1_val == 2048, 
// opcode: srliw ; op1:x14; dest:x7; op1val:0x800;  immval:0x1
TEST_IMM_OP( srliw, x7, x14, 0x400, 0x800, 0x1, x2, 0, x3)

inst_22:
// rs1==x30, rd==x22, rs1_val == 4096, 
// opcode: srliw ; op1:x30; dest:x22; op1val:0x1000;  immval:0xf
TEST_IMM_OP( srliw, x22, x30, 0x0, 0x1000, 0xf, x2, 8, x3)

inst_23:
// rs1==x26, rd==x24, rs1_val == 8192, 
// opcode: srliw ; op1:x26; dest:x24; op1val:0x2000;  immval:0x13
TEST_IMM_OP( srliw, x24, x26, 0x0, 0x2000, 0x13, x2, 16, x3)

inst_24:
// rs1==x27, rd==x18, rs1_val == 16384, imm_val == 23
// opcode: srliw ; op1:x27; dest:x18; op1val:0x4000;  immval:0x17
TEST_IMM_OP( srliw, x18, x27, 0x0, 0x4000, 0x17, x2, 24, x3)

inst_25:
// rs1==x12, rd==x14, rs1_val == 32768, 
// opcode: srliw ; op1:x12; dest:x14; op1val:0x8000;  immval:0xc
TEST_IMM_OP( srliw, x14, x12, 0x8, 0x8000, 0xc, x2, 32, x3)

inst_26:
// rs1==x17, rd==x30, rs1_val == 65536, 
// opcode: srliw ; op1:x17; dest:x30; op1val:0x10000;  immval:0x3
TEST_IMM_OP( srliw, x30, x17, 0x2000, 0x10000, 0x3, x2, 40, x3)

inst_27:
// rs1==x16, rd==x12, rs1_val == 131072, 
// opcode: srliw ; op1:x16; dest:x12; op1val:0x20000;  immval:0x5
TEST_IMM_OP( srliw, x12, x16, 0x1000, 0x20000, 0x5, x2, 48, x3)

inst_28:
// rs1==x29, rd==x6, rs1_val == 262144, imm_val == 29
// opcode: srliw ; op1:x29; dest:x6; op1val:0x40000;  immval:0x1d
TEST_IMM_OP( srliw, x6, x29, 0x0, 0x40000, 0x1d, x2, 56, x3)

inst_29:
// rs1==x0, rd==x10, rs1_val == 524288, 
// opcode: srliw ; op1:x0; dest:x10; op1val:0x0;  immval:0x1
TEST_IMM_OP( srliw, x10, x0, 0x0, 0x0, 0x1, x2, 64, x3)

inst_30:
// rs1==x25, rd==x11, rs1_val == 1048576, 
// opcode: srliw ; op1:x25; dest:x11; op1val:0x100000;  immval:0x6
TEST_IMM_OP( srliw, x11, x25, 0x4000, 0x100000, 0x6, x2, 72, x3)

inst_31:
// rs1==x1, rd==x5, rs1_val == 2097152, 
// opcode: srliw ; op1:x1; dest:x5; op1val:0x200000;  immval:0x6
TEST_IMM_OP( srliw, x5, x1, 0x8000, 0x200000, 0x6, x2, 80, x3)

inst_32:
// rs1_val == 4194304, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x400000;  immval:0x7
TEST_IMM_OP( srliw, x11, x10, 0x8000, 0x400000, 0x7, x2, 88, x3)

inst_33:
// rs1_val == 8388608, imm_val == 21
// opcode: srliw ; op1:x10; dest:x11; op1val:0x800000;  immval:0x15
TEST_IMM_OP( srliw, x11, x10, 0x4, 0x800000, 0x15, x2, 96, x3)

inst_34:
// rs1_val == 16777216, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x1000000;  immval:0xa
TEST_IMM_OP( srliw, x11, x10, 0x4000, 0x1000000, 0xa, x2, 104, x3)

inst_35:
// rs1_val == 33554432, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x2000000;  immval:0xa
TEST_IMM_OP( srliw, x11, x10, 0x8000, 0x2000000, 0xa, x2, 112, x3)

inst_36:
// rs1_val == 67108864, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x4000000;  immval:0x0
TEST_IMM_OP( srliw, x11, x10, 0x4000000, 0x4000000, 0x0, x2, 120, x3)

inst_37:
// rs1_val == 134217728, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x15
TEST_IMM_OP( srliw, x11, x10, 0x40, 0x8000000, 0x15, x2, 128, x3)

inst_38:
// rs1_val == 268435456, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x10000000;  immval:0x15
TEST_IMM_OP( srliw, x11, x10, 0x80, 0x10000000, 0x15, x2, 136, x3)

inst_39:
// rs1_val == 536870912, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x8
TEST_IMM_OP( srliw, x11, x10, 0x200000, 0x20000000, 0x8, x2, 144, x3)

inst_40:
// rs1_val == 1073741824, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x40000000;  immval:0x9
TEST_IMM_OP( srliw, x11, x10, 0x200000, 0x40000000, 0x9, x2, 152, x3)

inst_41:
// rs1_val == 2147483648, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x80000000;  immval:0xf
TEST_IMM_OP( srliw, x11, x10, 0x10000, 0x80000000, 0xf, x2, 160, x3)

inst_42:
// rs1_val == 4294967296, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x100000000;  immval:0x11
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x100000000, 0x11, x2, 168, x3)

inst_43:
// rs1_val == 8589934592, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x200000000;  immval:0xa
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x200000000, 0xa, x2, 176, x3)

inst_44:
// rs1_val == 17179869184, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x400000000;  immval:0x6
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x400000000, 0x6, x2, 184, x3)

inst_45:
// rs1_val == 34359738368, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x800000000;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x800000000, 0x1f, x2, 192, x3)

inst_46:
// rs1_val == 68719476736, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0x8
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x1000000000, 0x8, x2, 200, x3)

inst_47:
// rs1_val == 137438953472, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x2000000000;  immval:0x9
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x2000000000, 0x9, x2, 208, x3)

inst_48:
// rs1_val == 274877906944, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x4000000000;  immval:0x3
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x4000000000, 0x3, x2, 216, x3)

inst_49:
// rs1_val == 549755813888, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x15
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x8000000000, 0x15, x2, 224, x3)

inst_50:
// rs1_val == 2199023255552, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x20000000000;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x20000000000, 0x1f, x2, 232, x3)

inst_51:
// rs1_val == 4398046511104, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x40000000000;  immval:0x7
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x40000000000, 0x7, x2, 240, x3)

inst_52:
// rs1_val == 8796093022208, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x80000000000, 0x1, x2, 248, x3)

inst_53:
// rs1_val == 17592186044416, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x100000000000;  immval:0x8
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x100000000000, 0x8, x2, 256, x3)

inst_54:
// rs1_val == 35184372088832, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x6
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x200000000000, 0x6, x2, 264, x3)

inst_55:
// rs1_val == 70368744177664, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0xf
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x400000000000, 0xf, x2, 272, x3)

inst_56:
// rs1_val == 140737488355328, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x800000000000;  immval:0x11
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x800000000000, 0x11, x2, 280, x3)

inst_57:
// rs1_val == 281474976710656, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0x15
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x1000000000000, 0x15, x2, 288, x3)

inst_58:
// rs1_val == 562949953421312, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x11
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x2000000000000, 0x11, x2, 296, x3)

inst_59:
// rs1_val == 1125899906842624, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:0x11
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x4000000000000, 0x11, x2, 304, x3)

inst_60:
// rs1_val == 2251799813685248, imm_val == 16
// opcode: srliw ; op1:x10; dest:x11; op1val:0x8000000000000;  immval:0x10
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x8000000000000, 0x10, x2, 312, x3)

inst_61:
// rs1_val == 4503599627370496, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x10000000000000;  immval:0x11
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x10000000000000, 0x11, x2, 320, x3)

inst_62:
// rs1_val == 9007199254740992, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0x15
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x20000000000000, 0x15, x2, 328, x3)

inst_63:
// rs1_val == 18014398509481984, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x40000000000000, 0x1, x2, 336, x3)

inst_64:
// rs1_val == 36028797018963968, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x80000000000000, 0x1f, x2, 344, x3)

inst_65:
// rs1_val == 72057594037927936, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0x13
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x100000000000000, 0x13, x2, 352, x3)

inst_66:
// rs1_val == 144115188075855872, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x200000000000000, 0x1f, x2, 360, x3)

inst_67:
// rs1_val == 288230376151711744, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:0xf
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x400000000000000, 0xf, x2, 368, x3)

inst_68:
// rs1_val == 576460752303423488, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x800000000000000, 0x1, x2, 376, x3)

inst_69:
// rs1_val == 1152921504606846976, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x1000000000000000, 0x12, x2, 384, x3)

inst_70:
// rs1_val == 2305843009213693952, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x2000000000000000;  immval:0x10
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x2000000000000000, 0x10, x2, 392, x3)

inst_71:
// rs1_val == 4611686018427387904, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0x3
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x4000000000000000, 0x3, x2, 400, x3)

inst_72:
// rs1_val == -2, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x2;  immval:0x7
TEST_IMM_OP( srliw, x11, x10, 0x1ffffff, -0x2, 0x7, x2, 408, x3)

inst_73:
// rs1_val == -3, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x3;  immval:0x0
TEST_IMM_OP( srliw, x11, x10, -0x3, -0x3, 0x0, x2, 416, x3)

inst_74:
// rs1_val == -5, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x5;  immval:0xa
TEST_IMM_OP( srliw, x11, x10, 0x3fffff, -0x5, 0xa, x2, 424, x3)

inst_75:
// rs1_val == -9, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x9;  immval:0xa
TEST_IMM_OP( srliw, x11, x10, 0x3fffff, -0x9, 0xa, x2, 432, x3)

inst_76:
// rs1_val == -17, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x11;  immval:0x7
TEST_IMM_OP( srliw, x11, x10, 0x1ffffff, -0x11, 0x7, x2, 440, x3)

inst_77:
// rs1_val == -33, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x21;  immval:0xc
TEST_IMM_OP( srliw, x11, x10, 0xfffff, -0x21, 0xc, x2, 448, x3)

inst_78:
// rs1_val == -65, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x41;  immval:0x11
TEST_IMM_OP( srliw, x11, x10, 0x7fff, -0x41, 0x11, x2, 456, x3)

inst_79:
// rs1_val == -129, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x81;  immval:0x5
TEST_IMM_OP( srliw, x11, x10, 0x7fffffb, -0x81, 0x5, x2, 464, x3)

inst_80:
// rs1_val == -257, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x101;  immval:0x1b
TEST_IMM_OP( srliw, x11, x10, 0x1f, -0x101, 0x1b, x2, 472, x3)

inst_81:
// rs1_val == -513, imm_val == 2
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x201;  immval:0x2
TEST_IMM_OP( srliw, x11, x10, 0x3fffff7f, -0x201, 0x2, x2, 480, x3)

inst_82:
// rs1_val == -1025, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x401;  immval:0xd
TEST_IMM_OP( srliw, x11, x10, 0x7ffff, -0x401, 0xd, x2, 488, x3)

inst_83:
// rs1_val == -2049, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x801;  immval:0x1d
TEST_IMM_OP( srliw, x11, x10, 0x7, -0x801, 0x1d, x2, 496, x3)

inst_84:
// rs1_val == -4097, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x1001;  immval:0x1b
TEST_IMM_OP( srliw, x11, x10, 0x1f, -0x1001, 0x1b, x2, 504, x3)

inst_85:
// rs1_val == -8193, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x2001;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x3fff, -0x2001, 0x12, x2, 512, x3)

inst_86:
// rs1_val == -16385, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x7
TEST_IMM_OP( srliw, x11, x10, 0x1ffff7f, -0x4001, 0x7, x2, 520, x3)

inst_87:
// rs1_val == -32769, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x3fff, -0x8001, 0x12, x2, 528, x3)

inst_88:
// rs1_val == -65537, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x10001;  immval:0xe
TEST_IMM_OP( srliw, x11, x10, 0x3fffb, -0x10001, 0xe, x2, 536, x3)

inst_89:
// rs1_val == -131073, imm_val == 30
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x1e
TEST_IMM_OP( srliw, x11, x10, 0x3, -0x20001, 0x1e, x2, 544, x3)

inst_90:
// rs1_val == -262145, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x5
TEST_IMM_OP( srliw, x11, x10, 0x7ffdfff, -0x40001, 0x5, x2, 552, x3)

inst_91:
// rs1_val == -9007199254740993, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x1, -0x20000000000001, 0x1f, x2, 560, x3)

inst_92:
// rs1_val == -18014398509481985, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x40000000000001;  immval:0x3
TEST_IMM_OP( srliw, x11, x10, 0x1fffffff, -0x40000000000001, 0x3, x2, 568, x3)

inst_93:
// rs1_val == -72057594037927937, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0x6
TEST_IMM_OP( srliw, x11, x10, 0x3ffffff, -0x100000000000001, 0x6, x2, 576, x3)

inst_94:
// rs1_val == -144115188075855873, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x7fffffff, -0x200000000000001, 0x1, x2, 584, x3)

inst_95:
// rs1_val == -288230376151711745, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x400000000000001;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x3fff, -0x400000000000001, 0x12, x2, 592, x3)

inst_96:
// rs1_val == -576460752303423489, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:0x9
TEST_IMM_OP( srliw, x11, x10, 0x7fffff, -0x800000000000001, 0x9, x2, 600, x3)

inst_97:
// rs1_val == -1152921504606846977, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:0x1b
TEST_IMM_OP( srliw, x11, x10, 0x1f, -0x1000000000000001, 0x1b, x2, 608, x3)

inst_98:
// rs1_val == -2305843009213693953, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0x5
TEST_IMM_OP( srliw, x11, x10, 0x7ffffff, -0x2000000000000001, 0x5, x2, 616, x3)

inst_99:
// rs1_val == -4611686018427387905, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x1, -0x4000000000000001, 0x1f, x2, 624, x3)

inst_100:
// rs1_val == 6148914691236517205, rs1_val==6148914691236517205
// opcode: srliw ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0xf
TEST_IMM_OP( srliw, x11, x10, 0xaaaa, 0x5555555555555555, 0xf, x2, 632, x3)

inst_101:
// rs1_val == -6148914691236517206, imm_val == 4, rs1_val==-6148914691236517206
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x4
TEST_IMM_OP( srliw, x11, x10, 0xaaaaaaa, -0x5555555555555556, 0x4, x2, 640, x3)

inst_102:
// rs1_val==3, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x3;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x1, 0x3, 0x1, x2, 648, x3)

inst_103:
// rs1_val==5, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x5;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x5, 0x12, x2, 656, x3)

inst_104:
// rs1_val==3689348814741910323, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x3333333333333333, 0x1f, x2, 664, x3)

inst_105:
// rs1_val==-3037000499, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x6
TEST_IMM_OP( srliw, x11, x10, 0x12bec33, -0xb504f333, 0x6, x2, 672, x3)

inst_106:
// rs1_val==3037000499, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x5a827999, 0xb504f333, 0x1, x2, 680, x3)

inst_107:
// rs1_val==6148914691236517204, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x1d
TEST_IMM_OP( srliw, x11, x10, 0x2, 0x5555555555555554, 0x1d, x2, 688, x3)

inst_108:
// rs1_val==3689348814741910322, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0xd
TEST_IMM_OP( srliw, x11, x10, 0x19999, 0x3333333333333332, 0xd, x2, 696, x3)

inst_109:
// rs1_val==7378697629483820645, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x33333332, 0x6666666666666665, 0x1, x2, 704, x3)

inst_110:
// rs1_val==3037000498, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2
TEST_IMM_OP( srliw, x11, x10, 0x2d413ccc, 0xb504f332, 0x2, x2, 712, x3)

inst_111:
// rs1_val==6148914691236517206, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x7
TEST_IMM_OP( srliw, x11, x10, 0xaaaaaa, 0x5555555555555556, 0x7, x2, 720, x3)

inst_112:
// rs1_val==-6148914691236517205, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x9
TEST_IMM_OP( srliw, x11, x10, 0x555555, -0x5555555555555555, 0x9, x2, 728, x3)

inst_113:
// rs1_val==6, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x6;  immval:0xd
TEST_IMM_OP( srliw, x11, x10, 0x0, 0x6, 0xd, x2, 736, x3)

inst_114:
// rs1_val==3689348814741910324, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0xf
TEST_IMM_OP( srliw, x11, x10, 0x6666, 0x3333333333333334, 0xf, x2, 744, x3)

inst_115:
// rs1_val==7378697629483820647, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0xb
TEST_IMM_OP( srliw, x11, x10, 0xccccc, 0x6666666666666667, 0xb, x2, 752, x3)

inst_116:
// rs1_val==-3037000498, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x4
TEST_IMM_OP( srliw, x11, x10, 0x4afb0cc, -0xb504f332, 0x4, x2, 760, x3)

inst_117:
// rs1_val==3037000500, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x1d
TEST_IMM_OP( srliw, x11, x10, 0x5, 0xb504f334, 0x1d, x2, 768, x3)

inst_118:
// rs1_val == -524289, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x80001;  immval:0xe
TEST_IMM_OP( srliw, x11, x10, 0x3ffdf, -0x80001, 0xe, x2, 776, x3)

inst_119:
// rs1_val == -1048577, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x100001;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x3ffb, -0x100001, 0x12, x2, 784, x3)

inst_120:
// rs1_val == -2097153, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x200001;  immval:0xb
TEST_IMM_OP( srliw, x11, x10, 0x1ffbff, -0x200001, 0xb, x2, 792, x3)

inst_121:
// rs1_val == -4194305, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x1d
TEST_IMM_OP( srliw, x11, x10, 0x7, -0x400001, 0x1d, x2, 800, x3)

inst_122:
// rs1_val == -8388609, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x800001;  immval:0x2
TEST_IMM_OP( srliw, x11, x10, 0x3fdfffff, -0x800001, 0x2, x2, 808, x3)

inst_123:
// rs1_val == -33554433, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x2000001;  immval:0x8
TEST_IMM_OP( srliw, x11, x10, 0xfdffff, -0x2000001, 0x8, x2, 816, x3)

inst_124:
// rs1_val == -67108865, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x4000001;  immval:0x13
TEST_IMM_OP( srliw, x11, x10, 0x1f7f, -0x4000001, 0x13, x2, 824, x3)

inst_125:
// rs1_val == -134217729, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x8000001;  immval:0xa
TEST_IMM_OP( srliw, x11, x10, 0x3dffff, -0x8000001, 0xa, x2, 832, x3)

inst_126:
// rs1_val == -268435457, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0xf
TEST_IMM_OP( srliw, x11, x10, 0x1dfff, -0x10000001, 0xf, x2, 840, x3)

inst_127:
// rs1_val == -536870913, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x20000001;  immval:0x13
TEST_IMM_OP( srliw, x11, x10, 0x1bff, -0x20000001, 0x13, x2, 848, x3)

inst_128:
// rs1_val == -1073741825, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x40000001;  immval:0xb
TEST_IMM_OP( srliw, x11, x10, 0x17ffff, -0x40000001, 0xb, x2, 856, x3)

inst_129:
// rs1_val == -2147483649, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x80000001;  immval:0x17
TEST_IMM_OP( srliw, x11, x10, 0xff, -0x80000001, 0x17, x2, 864, x3)

inst_130:
// rs1_val == -4294967297, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x100000001;  immval:0x9
TEST_IMM_OP( srliw, x11, x10, 0x7fffff, -0x100000001, 0x9, x2, 872, x3)

inst_131:
// rs1_val == -8589934593, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x200000001;  immval:0x2
TEST_IMM_OP( srliw, x11, x10, 0x3fffffff, -0x200000001, 0x2, x2, 880, x3)

inst_132:
// rs1_val == -17179869185, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x400000001;  immval:0x4
TEST_IMM_OP( srliw, x11, x10, 0xfffffff, -0x400000001, 0x4, x2, 888, x3)

inst_133:
// rs1_val == -34359738369, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x800000001;  immval:0x11
TEST_IMM_OP( srliw, x11, x10, 0x7fff, -0x800000001, 0x11, x2, 896, x3)

inst_134:
// rs1_val == -137438953473, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0x1b
TEST_IMM_OP( srliw, x11, x10, 0x1f, -0x2000000001, 0x1b, x2, 904, x3)

inst_135:
// rs1_val == -274877906945, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x13
TEST_IMM_OP( srliw, x11, x10, 0x1fff, -0x4000000001, 0x13, x2, 912, x3)

inst_136:
// rs1_val == -549755813889, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:0x0
TEST_IMM_OP( srliw, x11, x10, -0x1, -0x8000000001, 0x0, x2, 920, x3)

inst_137:
// rs1_val == -1099511627777, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0x6
TEST_IMM_OP( srliw, x11, x10, 0x3ffffff, -0x10000000001, 0x6, x2, 928, x3)

inst_138:
// rs1_val == -2199023255553, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:0x8
TEST_IMM_OP( srliw, x11, x10, 0xffffff, -0x20000000001, 0x8, x2, 936, x3)

inst_139:
// rs1_val == -4398046511105, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x40000000001;  immval:0x1f
TEST_IMM_OP( srliw, x11, x10, 0x1, -0x40000000001, 0x1f, x2, 944, x3)

inst_140:
// rs1_val == -8796093022209, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x80000000001;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x3fff, -0x80000000001, 0x12, x2, 952, x3)

inst_141:
// rs1_val == -17592186044417, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:0x1d
TEST_IMM_OP( srliw, x11, x10, 0x7, -0x100000000001, 0x1d, x2, 960, x3)

inst_142:
// rs1_val == -35184372088833, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:0x12
TEST_IMM_OP( srliw, x11, x10, 0x3fff, -0x200000000001, 0x12, x2, 968, x3)

inst_143:
// rs1_val == -70368744177665, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x400000000001;  immval:0x0
TEST_IMM_OP( srliw, x11, x10, -0x1, -0x400000000001, 0x0, x2, 976, x3)

inst_144:
// rs1_val == -140737488355329, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:0xf
TEST_IMM_OP( srliw, x11, x10, 0x1ffff, -0x800000000001, 0xf, x2, 984, x3)

inst_145:
// rs1_val == -281474976710657, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x1000000000001;  immval:0x3
TEST_IMM_OP( srliw, x11, x10, 0x1fffffff, -0x1000000000001, 0x3, x2, 992, x3)

inst_146:
// rs1_val == -562949953421313, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:0x2
TEST_IMM_OP( srliw, x11, x10, 0x3fffffff, -0x2000000000001, 0x2, x2, 1000, x3)

inst_147:
// rs1_val == -1125899906842625, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:0xb
TEST_IMM_OP( srliw, x11, x10, 0x1fffff, -0x4000000000001, 0xb, x2, 1008, x3)

inst_148:
// rs1_val == -2251799813685249, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x8000000000001;  immval:0xb
TEST_IMM_OP( srliw, x11, x10, 0x1fffff, -0x8000000000001, 0xb, x2, 1016, x3)

inst_149:
// rs1_val == -4503599627370497, 
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:0x13
TEST_IMM_OP( srliw, x11, x10, 0x1fff, -0x10000000000001, 0x13, x2, 1024, x3)

inst_150:
// rs1_val == (-2**(xlen-1)) and imm_val >= 0 and imm_val < 32, imm_val == 27, rs1_val == -9223372036854775808
// opcode: srliw ; op1:x10; dest:x11; op1val:-0x8000000000000000;  immval:0x1b
TEST_IMM_OP( srliw, x11, x10, 0x0, -0x8000000000000000, 0x1b, x2, 1032, x3)

inst_151:
// rs1_val == 524288, 
// opcode: srliw ; op1:x10; dest:x11; op1val:0x80000;  immval:0x1
TEST_IMM_OP( srliw, x11, x10, 0x40000, 0x80000, 0x1, x2, 1040, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x12_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x12_1:
    .fill 21*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 131*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
