
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the xor instruction of the RISC-V I extension for the xor covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",xor)

RVTEST_SIGBASE( x9,signature_x9_1)

inst_0:
// rs1 == rs2 != rd, rs1==x19, rs2==x19, rd==x12, rs1_val > 0 and rs2_val > 0, rs2_val == 576460752303423488, rs1_val == 18014398509481984, rs1_val != rs2_val
// opcode: xor ; op1:x19; op2:x19; dest:x12; op1val:0x40000000000000;  op2val:0x40000000000000
TEST_RR_OP(xor, x12, x19, x19, 0x0, 0x40000000000000, 0x40000000000000, x9, 0, x5)

inst_1:
// rs2 == rd != rs1, rs1==x28, rs2==x2, rd==x2, rs1_val > 0 and rs2_val < 0, rs2_val == -2199023255553
// opcode: xor ; op1:x28; op2:x2; dest:x2; op1val:0x5;  op2val:-0x20000000001
TEST_RR_OP(xor, x2, x28, x2, 0xfffffdfffffffffa, 0x5, -0x20000000001, x9, 8, x5)

inst_2:
// rs1 == rs2 == rd, rs1==x31, rs2==x31, rd==x31, rs1_val < 0 and rs2_val < 0, rs1_val == -17179869185, rs2_val == -1025
// opcode: xor ; op1:x31; op2:x31; dest:x31; op1val:-0x400000001;  op2val:-0x400000001
TEST_RR_OP(xor, x31, x31, x31, 0x0, -0x400000001, -0x400000001, x9, 16, x5)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x11, rs2==x25, rd==x10, rs1_val < 0 and rs2_val > 0, rs1_val == -1048577, rs2_val == 36028797018963968
// opcode: xor ; op1:x11; op2:x25; dest:x10; op1val:-0x100001;  op2val:0x80000000000000
TEST_RR_OP(xor, x10, x11, x25, 0xff7fffffffefffff, -0x100001, 0x80000000000000, x9, 24, x5)

inst_4:
// rs1 == rd != rs2, rs1==x17, rs2==x20, rd==x17, rs1_val == rs2_val, rs2_val == 134217728, rs1_val == 134217728
// opcode: xor ; op1:x17; op2:x20; dest:x17; op1val:0x8000000;  op2val:0x8000000
TEST_RR_OP(xor, x17, x17, x20, 0x0, 0x8000000, 0x8000000, x9, 32, x5)

inst_5:
// rs1==x24, rs2==x22, rd==x3, rs2_val == (-2**(xlen-1)), rs2_val == -9223372036854775808
// opcode: xor ; op1:x24; op2:x22; dest:x3; op1val:0x5;  op2val:-0x8000000000000000
TEST_RR_OP(xor, x3, x24, x22, 0x8000000000000005, 0x5, -0x8000000000000000, x9, 40, x5)

inst_6:
// rs1==x8, rs2==x3, rd==x22, rs2_val == 0, rs1_val==2 and rs2_val==0, rs1_val == 2
// opcode: xor ; op1:x8; op2:x3; dest:x22; op1val:0x2;  op2val:0x0
TEST_RR_OP(xor, x22, x8, x3, 0x2, 0x2, 0x0, x9, 48, x5)

inst_7:
// rs1==x10, rs2==x14, rd==x24, rs2_val == (2**(xlen-1)-1), rs2_val == 9223372036854775807, rs1_val == -72057594037927937
// opcode: xor ; op1:x10; op2:x14; dest:x24; op1val:-0x100000000000001;  op2val:0x7fffffffffffffff
TEST_RR_OP(xor, x24, x10, x14, 0x8100000000000000, -0x100000000000001, 0x7fffffffffffffff, x9, 56, x5)

inst_8:
// rs1==x2, rs2==x4, rd==x15, rs2_val == 1, rs1_val == -281474976710657
// opcode: xor ; op1:x2; op2:x4; dest:x15; op1val:-0x1000000000001;  op2val:0x1
TEST_RR_OP(xor, x15, x2, x4, 0xfffefffffffffffe, -0x1000000000001, 0x1, x9, 64, x5)

inst_9:
// rs1==x21, rs2==x29, rd==x23, rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808, rs2_val == 4
// opcode: xor ; op1:x21; op2:x29; dest:x23; op1val:-0x8000000000000000;  op2val:0x4
TEST_RR_OP(xor, x23, x21, x29, 0x8000000000000004, -0x8000000000000000, 0x4, x9, 72, x5)

inst_10:
// rs1==x0, rs2==x7, rd==x11, rs1_val == 0, rs2_val == -16385
// opcode: xor ; op1:x0; op2:x7; dest:x11; op1val:0x0;  op2val:-0x4001
TEST_RR_OP(xor, x11, x0, x7, 0xffffffffffffbfff, 0x0, -0x4001, x9, 80, x5)

inst_11:
// rs1==x18, rs2==x16, rd==x0, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807
// opcode: xor ; op1:x18; op2:x16; dest:x0; op1val:0x7fffffffffffffff;  op2val:0x7
TEST_RR_OP(xor, x0, x18, x16, 0, 0x7fffffffffffffff, 0x7, x9, 88, x5)

inst_12:
// rs1==x25, rs2==x27, rd==x14, rs1_val == 1, rs2_val == 8388608
// opcode: xor ; op1:x25; op2:x27; dest:x14; op1val:0x1;  op2val:0x800000
TEST_RR_OP(xor, x14, x25, x27, 0x800001, 0x1, 0x800000, x9, 96, x5)

inst_13:
// rs1==x30, rs2==x23, rd==x29, rs2_val == 2, rs1_val == 137438953472
// opcode: xor ; op1:x30; op2:x23; dest:x29; op1val:0x2000000000;  op2val:0x2
TEST_RR_OP(xor, x29, x30, x23, 0x2000000002, 0x2000000000, 0x2, x9, 104, x5)

inst_14:
// rs1==x6, rs2==x1, rd==x28, rs2_val == 8, 
// opcode: xor ; op1:x6; op2:x1; dest:x28; op1val:0x6;  op2val:0x8
TEST_RR_OP(xor, x28, x6, x1, 0xe, 0x6, 0x8, x9, 112, x5)

inst_15:
// rs1==x12, rs2==x5, rd==x19, rs2_val == 16, rs1_val == 1125899906842624
// opcode: xor ; op1:x12; op2:x5; dest:x19; op1val:0x4000000000000;  op2val:0x10
TEST_RR_OP(xor, x19, x12, x5, 0x4000000000010, 0x4000000000000, 0x10, x9, 120, x11)
RVTEST_SIGBASE( x2,signature_x2_0)

inst_16:
// rs1==x20, rs2==x8, rd==x1, rs2_val == 32, rs1_val == -5
// opcode: xor ; op1:x20; op2:x8; dest:x1; op1val:-0x5;  op2val:0x20
TEST_RR_OP(xor, x1, x20, x8, 0xffffffffffffffdb, -0x5, 0x20, x2, 0, x11)

inst_17:
// rs1==x1, rs2==x17, rd==x13, rs2_val == 64, rs1_val == 274877906944
// opcode: xor ; op1:x1; op2:x17; dest:x13; op1val:0x4000000000;  op2val:0x40
TEST_RR_OP(xor, x13, x1, x17, 0x4000000040, 0x4000000000, 0x40, x2, 8, x11)

inst_18:
// rs1==x7, rs2==x28, rd==x21, rs2_val == 128, rs1_val == -16777217
// opcode: xor ; op1:x7; op2:x28; dest:x21; op1val:-0x1000001;  op2val:0x80
TEST_RR_OP(xor, x21, x7, x28, 0xfffffffffeffff7f, -0x1000001, 0x80, x2, 16, x11)

inst_19:
// rs1==x14, rs2==x9, rd==x7, rs2_val == 256, rs1_val == -36028797018963969
// opcode: xor ; op1:x14; op2:x9; dest:x7; op1val:-0x80000000000001;  op2val:0x100
TEST_RR_OP(xor, x7, x14, x9, 0xff7ffffffffffeff, -0x80000000000001, 0x100, x2, 24, x11)

inst_20:
// rs1==x4, rs2==x21, rd==x25, rs2_val == 512, 
// opcode: xor ; op1:x4; op2:x21; dest:x25; op1val:0x4000000000;  op2val:0x200
TEST_RR_OP(xor, x25, x4, x21, 0x4000000200, 0x4000000000, 0x200, x2, 32, x11)

inst_21:
// rs1==x22, rs2==x0, rd==x5, rs2_val == 1024, rs1_val == 524288
// opcode: xor ; op1:x22; op2:x0; dest:x5; op1val:0x80000;  op2val:0x0
TEST_RR_OP(xor, x5, x22, x0, 0x80000, 0x80000, 0x0, x2, 40, x11)

inst_22:
// rs1==x5, rs2==x30, rd==x4, rs2_val == 2048, rs1_val == 512
// opcode: xor ; op1:x5; op2:x30; dest:x4; op1val:0x200;  op2val:0x800
TEST_RR_OP(xor, x4, x5, x30, 0xa00, 0x200, 0x800, x2, 48, x11)

inst_23:
// rs1==x16, rs2==x15, rd==x30, rs2_val == 4096, 
// opcode: xor ; op1:x16; op2:x15; dest:x30; op1val:0x7;  op2val:0x1000
TEST_RR_OP(xor, x30, x16, x15, 0x1007, 0x7, 0x1000, x2, 56, x11)

inst_24:
// rs1==x13, rs2==x12, rd==x16, rs2_val == 8192, rs1_val == 268435456
// opcode: xor ; op1:x13; op2:x12; dest:x16; op1val:0x10000000;  op2val:0x2000
TEST_RR_OP(xor, x16, x13, x12, 0x10002000, 0x10000000, 0x2000, x2, 64, x11)

inst_25:
// rs1==x15, rs2==x10, rd==x9, rs2_val == 16384, 
// opcode: xor ; op1:x15; op2:x10; dest:x9; op1val:-0x8;  op2val:0x4000
TEST_RR_OP(xor, x9, x15, x10, 0xffffffffffffbff8, -0x8, 0x4000, x2, 72, x11)

inst_26:
// rs1==x29, rs2==x6, rd==x18, rs2_val == 32768, rs1_val == 16777216
// opcode: xor ; op1:x29; op2:x6; dest:x18; op1val:0x1000000;  op2val:0x8000
TEST_RR_OP(xor, x18, x29, x6, 0x1008000, 0x1000000, 0x8000, x2, 80, x11)

inst_27:
// rs1==x27, rs2==x24, rd==x6, rs2_val == 65536, 
// opcode: xor ; op1:x27; op2:x24; dest:x6; op1val:0x6;  op2val:0x10000
TEST_RR_OP(xor, x6, x27, x24, 0x10006, 0x6, 0x10000, x2, 88, x11)

inst_28:
// rs1==x3, rs2==x26, rd==x8, rs2_val == 131072, 
// opcode: xor ; op1:x3; op2:x26; dest:x8; op1val:0x6666666666666665;  op2val:0x20000
TEST_RR_OP(xor, x8, x3, x26, 0x6666666666646665, 0x6666666666666665, 0x20000, x2, 96, x11)

inst_29:
// rs1==x26, rs2==x18, rd==x27, rs2_val == 262144, rs1_val == -67108865
// opcode: xor ; op1:x26; op2:x18; dest:x27; op1val:-0x4000001;  op2val:0x40000
TEST_RR_OP(xor, x27, x26, x18, 0xfffffffffbfbffff, -0x4000001, 0x40000, x2, 104, x3)

inst_30:
// rs1==x9, rs2==x11, rd==x26, rs2_val == 524288, rs1_val == -131073
// opcode: xor ; op1:x9; op2:x11; dest:x26; op1val:-0x20001;  op2val:0x80000
TEST_RR_OP(xor, x26, x9, x11, 0xfffffffffff5ffff, -0x20001, 0x80000, x2, 112, x3)

inst_31:
// rs1==x23, rs2==x13, rd==x20, rs2_val == 1048576, rs1_val == -2097153
// opcode: xor ; op1:x23; op2:x13; dest:x20; op1val:-0x200001;  op2val:0x100000
TEST_RR_OP(xor, x20, x23, x13, 0xffffffffffcfffff, -0x200001, 0x100000, x2, 120, x3)
RVTEST_SIGBASE( x1,signature_x1_0)

inst_32:
// rs2_val == 2097152, rs1_val == 1152921504606846976
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x200000
TEST_RR_OP(xor, x12, x10, x11, 0x1000000000200000, 0x1000000000000000, 0x200000, x1, 0, x3)

inst_33:
// rs2_val == 4194304, rs1_val == -4398046511105
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:0x400000
TEST_RR_OP(xor, x12, x10, x11, 0xfffffbffffbfffff, -0x40000000001, 0x400000, x1, 8, x3)

inst_34:
// rs2_val == 16777216, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x1000000
TEST_RR_OP(xor, x12, x10, x11, 0x1000000, 0x0, 0x1000000, x1, 16, x3)

inst_35:
// rs2_val == 33554432, rs1_val == 4096
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x2000000
TEST_RR_OP(xor, x12, x10, x11, 0x2001000, 0x1000, 0x2000000, x1, 24, x3)

inst_36:
// rs2_val == 67108864, rs1_val == 72057594037927936
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0x4000000
TEST_RR_OP(xor, x12, x10, x11, 0x100000004000000, 0x100000000000000, 0x4000000, x1, 32, x3)

inst_37:
// rs2_val == 268435456, rs1_val == 33554432
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0x10000000
TEST_RR_OP(xor, x12, x10, x11, 0x12000000, 0x2000000, 0x10000000, x1, 40, x3)

inst_38:
// rs2_val == 536870912, rs1_val == -8193
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x20000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffdfffdfff, -0x2001, 0x20000000, x1, 48, x3)

inst_39:
// rs2_val == 1073741824, rs1_val == 34359738368
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x40000000
TEST_RR_OP(xor, x12, x10, x11, 0x840000000, 0x800000000, 0x40000000, x1, 56, x3)

inst_40:
// rs2_val == 2147483648, rs1_val == -549755813889
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x80000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffff7f7fffffff, -0x8000000001, 0x80000000, x1, 64, x3)

inst_41:
// rs2_val == 4294967296, rs1_val == 288230376151711744
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0x100000000
TEST_RR_OP(xor, x12, x10, x11, 0x400000100000000, 0x400000000000000, 0x100000000, x1, 72, x3)

inst_42:
// rs2_val == 8589934592, rs1_val == 32
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:0x200000000
TEST_RR_OP(xor, x12, x10, x11, 0x200000020, 0x20, 0x200000000, x1, 80, x3)

inst_43:
// rs2_val == 17179869184, rs1_val == -513
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x400000000
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffbfffffdff, -0x201, 0x400000000, x1, 88, x3)

inst_44:
// rs2_val == 34359738368, rs1_val == -274877906945
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0x800000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffb7ffffffff, -0x4000000001, 0x800000000, x1, 96, x3)

inst_45:
// rs2_val == 68719476736, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0x1000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffafffffffff, -0x4000000001, 0x1000000000, x1, 104, x3)

inst_46:
// rs2_val == 137438953472, rs1_val == -65
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:0x2000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffdfffffffbf, -0x41, 0x2000000000, x1, 112, x3)

inst_47:
// rs2_val == 274877906944, rs1_val == -137438953473
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:0x4000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffff9fffffffff, -0x2000000001, 0x4000000000, x1, 120, x3)

inst_48:
// rs2_val == 549755813888, rs1_val == -33
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x8000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffff7fffffffdf, -0x21, 0x8000000000, x1, 128, x3)

inst_49:
// rs2_val == 1099511627776, rs1_val == -17592186044417
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:0x10000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffeeffffffffff, -0x100000000001, 0x10000000000, x1, 136, x3)

inst_50:
// rs2_val == 2199023255552, rs1_val == 131072
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0x20000000000
TEST_RR_OP(xor, x12, x10, x11, 0x20000020000, 0x20000, 0x20000000000, x1, 144, x3)

inst_51:
// rs2_val == 4398046511104, rs1_val == 8192
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0x40000000000
TEST_RR_OP(xor, x12, x10, x11, 0x40000002000, 0x2000, 0x40000000000, x1, 152, x3)

inst_52:
// rs2_val == 8796093022208, rs1_val == 281474976710656
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0x80000000000
TEST_RR_OP(xor, x12, x10, x11, 0x1080000000000, 0x1000000000000, 0x80000000000, x1, 160, x3)

inst_53:
// rs2_val == 17592186044416, rs1_val == -129
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x100000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffefffffffff7f, -0x81, 0x100000000000, x1, 168, x3)

inst_54:
// rs2_val == 35184372088832, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x200000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffdfffffffff7f, -0x81, 0x200000000000, x1, 176, x3)

inst_55:
// rs2_val == 70368744177664, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x400000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffbfffffffdfff, -0x2001, 0x400000000000, x1, 184, x3)

inst_56:
// rs2_val == 140737488355328, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x800000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffff7fffffefffff, -0x100001, 0x800000000000, x1, 192, x3)

inst_57:
// rs2_val == 281474976710656, rs1_val == -4294967297
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:0x1000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xfffefffeffffffff, -0x100000001, 0x1000000000000, x1, 200, x3)

inst_58:
// rs2_val == 562949953421312, rs1_val == 256
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:0x2000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x2000000000100, 0x100, 0x2000000000000, x1, 208, x3)

inst_59:
// rs2_val == 1125899906842624, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x4000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xfffbffff4afb0ccd, -0xb504f333, 0x4000000000000, x1, 216, x3)

inst_60:
// rs2_val == 2251799813685248, rs1_val == -4194305
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0x8000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xfff7ffffffbfffff, -0x400001, 0x8000000000000, x1, 224, x3)

inst_61:
// rs2_val == 4503599627370496, rs1_val == 4
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x10000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x10000000000004, 0x4, 0x10000000000000, x1, 232, x3)

inst_62:
// rs2_val == 9007199254740992, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0x20000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x20002000000000, 0x2000000000, 0x20000000000000, x1, 240, x3)

inst_63:
// rs2_val == 18014398509481984, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x40000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x5515555555555554, 0x5555555555555554, 0x40000000000000, x1, 248, x3)

inst_64:
// rs2_val == 72057594037927936, rs1_val == -1073741825
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:0x100000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xfeffffffbfffffff, -0x40000001, 0x100000000000000, x1, 256, x3)

inst_65:
// rs2_val == 144115188075855872, rs1_val == -2
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:0x200000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xfdfffffffffffffe, -0x2, 0x200000000000000, x1, 264, x3)

inst_66:
// rs2_val == 288230376151711744, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x400000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x400000000000004, 0x4, 0x400000000000000, x1, 272, x3)

inst_67:
// rs2_val == 1152921504606846976, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x1000000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x1000000000000003, 0x3, 0x1000000000000000, x1, 280, x3)

inst_68:
// rs2_val == 2305843009213693952, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x2000000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xdfffffff4afb0ccd, -0xb504f333, 0x2000000000000000, x1, 288, x3)

inst_69:
// rs2_val == 4611686018427387904, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x4000000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xbfffffffffffffdf, -0x21, 0x4000000000000000, x1, 296, x3)

inst_70:
// rs2_val == -2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:-0x2
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffdfe, 0x200, -0x2, x1, 304, x3)

inst_71:
// rs2_val == -3, rs1_val == 6148914691236517205
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x3
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, 0x5555555555555555, -0x3, x1, 312, x3)

inst_72:
// rs2_val == -5, rs1_val == -68719476737
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:-0x5
TEST_RR_OP(xor, x12, x10, x11, 0x1000000004, -0x1000000001, -0x5, x1, 320, x3)

inst_73:
// rs2_val == -9, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x9
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffff3, 0x4, -0x9, x1, 328, x3)

inst_74:
// rs2_val == -17, rs1_val == 144115188075855872
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:-0x11
TEST_RR_OP(xor, x12, x10, x11, 0xfdffffffffffffef, 0x200000000000000, -0x11, x1, 336, x3)

inst_75:
// rs2_val == -33, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:-0x21
TEST_RR_OP(xor, x12, x10, x11, 0x1000000000020, -0x1000000000001, -0x21, x1, 344, x3)

inst_76:
// rs2_val == -65, rs1_val == 9007199254740992
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:-0x41
TEST_RR_OP(xor, x12, x10, x11, 0xffdfffffffffffbf, 0x20000000000000, -0x41, x1, 352, x3)

inst_77:
// rs2_val == -129, rs1_val == -6148914691236517206
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x81
TEST_RR_OP(xor, x12, x10, x11, 0x55555555555555d5, -0x5555555555555556, -0x81, x1, 360, x3)

inst_78:
// rs2_val == -257, rs1_val == 1073741824
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:-0x101
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffbffffeff, 0x40000000, -0x101, x1, 368, x3)

inst_79:
// rs2_val == -513, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x201
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaa8aa, 0x5555555555555555, -0x201, x1, 376, x3)

inst_80:
// rs2_val == -2049, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x801
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffff7fb, 0x4, -0x801, x1, 384, x3)

inst_81:
// rs2_val == -4097, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x1001
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555554554, -0x5555555555555555, -0x1001, x1, 392, x3)

inst_82:
// rs2_val == -8193, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x2001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffdffd, 0x2, -0x2001, x1, 400, x3)

inst_83:
// rs2_val == -32769, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x8001
TEST_RR_OP(xor, x12, x10, x11, 0x555555555555d555, -0x5555555555555556, -0x8001, x1, 408, x3)

inst_84:
// rs2_val == -65537, rs1_val == 4611686018427387904
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:-0x10001
TEST_RR_OP(xor, x12, x10, x11, 0xbffffffffffeffff, 0x4000000000000000, -0x10001, x1, 416, x3)

inst_85:
// rs2_val == -131073, rs1_val == 2097152
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:-0x20001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffddffff, 0x200000, -0x20001, x1, 424, x3)

inst_86:
// rs2_val == -262145, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:-0x40001
TEST_RR_OP(xor, x12, x10, x11, 0x440000, -0x400001, -0x40001, x1, 432, x3)

inst_87:
// rs2_val == -524289, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x80001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4af30ccc, 0xb504f333, -0x80001, x1, 440, x3)

inst_88:
// rs2_val == -1048577, rs1_val == -18014398509481985
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:-0x100001
TEST_RR_OP(xor, x12, x10, x11, 0x40000000100000, -0x40000000000001, -0x100001, x1, 448, x3)

inst_89:
// rs2_val == -2097153, rs1_val == -536870913
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:-0x200001
TEST_RR_OP(xor, x12, x10, x11, 0x20200000, -0x20000001, -0x200001, x1, 456, x3)

inst_90:
// rs2_val == -4194305, rs1_val == 549755813888
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:-0x400001
TEST_RR_OP(xor, x12, x10, x11, 0xffffff7fffbfffff, 0x8000000000, -0x400001, x1, 464, x3)

inst_91:
// rs2_val == -8388609, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:-0x800001
TEST_RR_OP(xor, x12, x10, x11, 0x40800000, -0x40000001, -0x800001, x1, 472, x3)

inst_92:
// rs2_val == -16777217, rs1_val == 4294967296
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:-0x1000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffefeffffff, 0x100000000, -0x1000001, x1, 480, x3)

inst_93:
// rs2_val == -33554433, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:-0x2000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffdfffffe, 0x1, -0x2000001, x1, 488, x3)

inst_94:
// rs2_val == -67108865, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x4000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffbfffffc, 0x3, -0x4000001, x1, 496, x3)

inst_95:
// rs2_val == -134217729, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x8000001
TEST_RR_OP(xor, x12, x10, x11, 0xbd04f332, -0xb504f333, -0x8000001, x1, 504, x3)

inst_96:
// rs2_val == -268435457, rs1_val == 140737488355328
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:-0x10000001
TEST_RR_OP(xor, x12, x10, x11, 0xffff7fffefffffff, 0x800000000000, -0x10000001, x1, 512, x3)

inst_97:
// rs2_val == -536870913, rs1_val == 32768
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:-0x20000001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffdfff7fff, 0x8000, -0x20000001, x1, 520, x3)

inst_98:
// rs2_val == -1073741825, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:-0x40000001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffbff7ffff, 0x80000, -0x40000001, x1, 528, x3)

inst_99:
// rs2_val == -2147483649, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x80000001
TEST_RR_OP(xor, x12, x10, x11, 0x55555555d5555555, -0x5555555555555556, -0x80000001, x1, 536, x3)

inst_100:
// rs2_val == -4294967297, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:-0x100000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffefffeffffffff, 0x1000000000000, -0x100000001, x1, 544, x3)

inst_101:
// rs2_val == -8589934593, rs1_val == 8589934592
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:-0x200000001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, 0x200000000, -0x200000001, x1, 552, x3)

inst_102:
// rs2_val == -17179869185, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:-0x400000001
TEST_RR_OP(xor, x12, x10, x11, 0x8400000000, -0x8000000001, -0x400000001, x1, 560, x3)

inst_103:
// rs2_val == -34359738369, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000000000;  op2val:-0x800000001
TEST_RR_OP(xor, x12, x10, x11, 0x7ffffff7ffffffff, -0x8000000000000000, -0x800000001, x1, 568, x3)

inst_104:
// rs2_val == -68719476737, rs1_val == -144115188075855873
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:-0x1000000001
TEST_RR_OP(xor, x12, x10, x11, 0x200001000000000, -0x200000000000001, -0x1000000001, x1, 576, x3)

inst_105:
// rs2_val == -137438953473, rs1_val == 8
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:-0x2000000001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffdffffffff7, 0x8, -0x2000000001, x1, 584, x3)

inst_106:
// rs2_val == -274877906945, rs1_val == -32769
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:-0x4000000001
TEST_RR_OP(xor, x12, x10, x11, 0x4000008000, -0x8001, -0x4000000001, x1, 592, x3)

inst_107:
// rs2_val == -549755813889, rs1_val == -16385
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:-0x8000000001
TEST_RR_OP(xor, x12, x10, x11, 0x8000004000, -0x4001, -0x8000000001, x1, 600, x3)

inst_108:
// rs2_val == -1099511627777, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000000000;  op2val:-0x10000000001
TEST_RR_OP(xor, x12, x10, x11, 0x7ffffeffffffffff, -0x8000000000000000, -0x10000000001, x1, 608, x3)

inst_109:
// rs2_val == -4398046511105, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:-0x40000000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffffbfffdffffff, 0x2000000, -0x40000000001, x1, 616, x3)

inst_110:
// rs2_val == -8796093022209, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x80000000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffff7fffffffffc, 0x3, -0x80000000001, x1, 624, x3)

inst_111:
// rs2_val == -17592186044417, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:-0x100000000001
TEST_RR_OP(xor, x12, x10, x11, 0x200100000000000, -0x200000000000001, -0x100000000001, x1, 632, x3)

inst_112:
// rs2_val == -35184372088833, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x200000000001
TEST_RR_OP(xor, x12, x10, x11, 0xffffdfffffffffff, 0x0, -0x200000000001, x1, 640, x3)

inst_113:
// rs2_val == -70368744177665, rs1_val == -257
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x101;  op2val:-0x400000000001
TEST_RR_OP(xor, x12, x10, x11, 0x400000000100, -0x101, -0x400000000001, x1, 648, x3)

inst_114:
// rs2_val == -140737488355329, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x800000000001
TEST_RR_OP(xor, x12, x10, x11, 0xcccc4ccccccccccb, 0x3333333333333334, -0x800000000001, x1, 656, x3)

inst_115:
// rs2_val == -281474976710657, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:-0x1000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffefffffffdffff, 0x20000, -0x1000000000001, x1, 664, x3)

inst_116:
// rs2_val == -562949953421313, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:-0x2000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x2040000000000, -0x40000000001, -0x2000000000001, x1, 672, x3)

inst_117:
// rs2_val == -1125899906842625, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:-0x4000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x4000000000200, -0x201, -0x4000000000001, x1, 680, x3)

inst_118:
// rs2_val == -2251799813685249, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x8000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xaaa2aaaaaaaaaaaa, 0x5555555555555555, -0x8000000000001, x1, 688, x3)

inst_119:
// rs2_val == -4503599627370497, rs1_val == 2199023255552
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:-0x10000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xffeffdffffffffff, 0x20000000000, -0x10000000000001, x1, 696, x3)

inst_120:
// rs2_val == -9007199254740993, rs1_val == 262144
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:-0x20000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xffdffffffffbffff, 0x40000, -0x20000000000001, x1, 704, x3)

inst_121:
// rs2_val == -18014398509481985, rs1_val == -2049
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:-0x40000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x40000000000800, -0x801, -0x40000000000001, x1, 712, x3)

inst_122:
// rs2_val == -36028797018963969, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:-0x80000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xff7ffffffffffffe, 0x1, -0x80000000000001, x1, 720, x3)

inst_123:
// rs2_val == -72057594037927937, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:-0x100000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x100000040000000, -0x40000001, -0x100000000000001, x1, 728, x3)

inst_124:
// rs2_val == -144115188075855873, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x7;  op2val:-0x200000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x200000000000006, -0x7, -0x200000000000001, x1, 736, x3)

inst_125:
// rs2_val == -288230376151711745, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x400000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xfbfffffffffffffb, 0x4, -0x400000000000001, x1, 744, x3)

inst_126:
// rs2_val == -576460752303423489, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x6;  op2val:-0x800000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x800000000000005, -0x6, -0x800000000000001, x1, 752, x3)

inst_127:
// rs2_val == -1152921504606846977, rs1_val == 36028797018963968
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:-0x1000000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xef7fffffffffffff, 0x80000000000000, -0x1000000000000001, x1, 760, x3)

inst_128:
// rs2_val == -2305843009213693953, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:-0x2000000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x2000001000000000, -0x1000000001, -0x2000000000000001, x1, 768, x3)

inst_129:
// rs2_val == -4611686018427387905, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x4000000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x40000000b504f332, -0xb504f333, -0x4000000000000001, x1, 776, x3)

inst_130:
// rs2_val == 6148914691236517205, rs1_val==3 and rs2_val==6148914691236517205
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x3, 0x5555555555555555, x1, 784, x3)

inst_131:
// rs2_val == -6148914691236517206, rs1_val==4 and rs2_val==-6148914691236517206
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaae, 0x4, -0x5555555555555556, x1, 792, x3)

inst_132:
// rs1_val == 16, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x100000000
TEST_RR_OP(xor, x12, x10, x11, 0x100000010, 0x10, 0x100000000, x1, 800, x3)

inst_133:
// rs1_val == 64, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0x7
TEST_RR_OP(xor, x12, x10, x11, 0x47, 0x40, 0x7, x1, 808, x3)

inst_134:
// rs1_val == 128, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:-0x200000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffdffffff7f, 0x80, -0x200000001, x1, 816, x3)

inst_135:
// rs1_val == 1024, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:0x40000
TEST_RR_OP(xor, x12, x10, x11, 0x40400, 0x400, 0x40000, x1, 824, x3)

inst_136:
// rs1_val == 2048, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333b34, 0x800, 0x3333333333333334, x1, 832, x3)

inst_137:
// rs1_val == 16384, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0x40001
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffbbfff, 0x4000, -0x40001, x1, 840, x3)

inst_138:
// rs1_val == 65536, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:-0x8001
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffe7fff, 0x10000, -0x8001, x1, 848, x3)

inst_139:
// rs1_val == 1048576, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:-0x401
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffeffbff, 0x100000, -0x401, x1, 856, x3)

inst_140:
// rs1_val == 4194304, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:-0x1000000000001
TEST_RR_OP(xor, x12, x10, x11, 0xfffeffffffbfffff, 0x400000, -0x1000000000001, x1, 864, x3)

inst_141:
// rs1_val == 8388608, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:-0x2001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffff7fdfff, 0x800000, -0x2001, x1, 872, x3)

inst_142:
// rs1_val == 67108864, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x800000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x800000004000000, 0x4000000, 0x800000000000000, x1, 880, x3)

inst_143:
// rs1_val == 536870912, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x5555555575555555, 0x20000000, 0x5555555555555555, x1, 888, x3)

inst_144:
// rs1_val == 2147483648, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0x40000
TEST_RR_OP(xor, x12, x10, x11, 0x80040000, 0x80000000, 0x40000, x1, 896, x3)

inst_145:
// rs1_val == 17179869184, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:-0x41
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffbffffffbf, 0x400000000, -0x41, x1, 904, x3)

inst_146:
// rs1_val == 68719476736, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffef4afb0ccd, 0x1000000000, -0xb504f333, x1, 912, x3)

inst_147:
// rs1_val == 1099511627776, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0x100000000000
TEST_RR_OP(xor, x12, x10, x11, 0x110000000000, 0x10000000000, 0x100000000000, x1, 920, x3)

inst_148:
// rs1_val == 4398046511104, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0x10000000
TEST_RR_OP(xor, x12, x10, x11, 0x40010000000, 0x40000000000, 0x10000000, x1, 928, x3)

inst_149:
// rs1_val == 8796093022208, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x20000000000
TEST_RR_OP(xor, x12, x10, x11, 0xa0000000000, 0x80000000000, 0x20000000000, x1, 936, x3)

inst_150:
// rs1_val == 17592186044416, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:-0x400001
TEST_RR_OP(xor, x12, x10, x11, 0xffffefffffbfffff, 0x100000000000, -0x400001, x1, 944, x3)

inst_151:
// rs1_val == 35184372088832, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:-0x40000001
TEST_RR_OP(xor, x12, x10, x11, 0xffffdfffbfffffff, 0x200000000000, -0x40000001, x1, 952, x3)

inst_152:
// rs1_val == 70368744177664, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x20000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x20400000000000, 0x400000000000, 0x20000000000000, x1, 960, x3)

inst_153:
// rs1_val == 562949953421312, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0x4000000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x4002000000000000, 0x2000000000000, 0x4000000000000000, x1, 968, x3)

inst_154:
// rs1_val == 2251799813685248, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0x80000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x88000000000000, 0x8000000000000, 0x80000000000000, x1, 976, x3)

inst_155:
// rs1_val == 4503599627370496, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0x200000000000
TEST_RR_OP(xor, x12, x10, x11, 0x10200000000000, 0x10000000000000, 0x200000000000, x1, 984, x3)

inst_156:
// rs1_val == 576460752303423488, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:-0x40001
TEST_RR_OP(xor, x12, x10, x11, 0xf7fffffffffbffff, 0x800000000000000, -0x40001, x1, 992, x3)

inst_157:
// rs1_val == 2305843009213693952, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:0x8000
TEST_RR_OP(xor, x12, x10, x11, 0x2000000000008000, 0x2000000000000000, 0x8000, x1, 1000, x3)

inst_158:
// rs1_val == -3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:0x10
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffed, -0x3, 0x10, x1, 1008, x3)

inst_159:
// rs1_val == -9, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:-0x1000001
TEST_RR_OP(xor, x12, x10, x11, 0x1000008, -0x9, -0x1000001, x1, 1016, x3)

inst_160:
// rs1_val == -17, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:0x100000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffefffef, -0x11, 0x100000, x1, 1024, x3)

inst_161:
// rs1_val == -1025, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0x4000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffbffffffbff, -0x401, 0x4000000000, x1, 1032, x3)

inst_162:
// rs1_val == -4097, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffeffb, -0x1001, 0x4, x1, 1040, x3)

inst_163:
// rs1_val == -65537, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afa0ccd, -0x10001, 0xb504f332, x1, 1048, x3)

inst_164:
// rs1_val == -262145, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0x1
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffbfffe, -0x40001, 0x1, x1, 1056, x3)

inst_165:
// rs1_val == -524289, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x2000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xfffdfffffff7ffff, -0x80001, 0x2000000000000, x1, 1064, x3)

inst_166:
// rs1_val == -8388609, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x200000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffff5fffff, -0x800001, 0x200000, x1, 1072, x3)

inst_167:
// rs1_val == -33554433, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0x20000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffdffffffdffffff, -0x2000001, 0x20000000000000, x1, 1080, x3)

inst_168:
// rs1_val == -134217729, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:0x800000000
TEST_RR_OP(xor, x12, x10, x11, 0xfffffff7f7ffffff, -0x8000001, 0x800000000, x1, 1088, x3)

inst_169:
// rs1_val == -268435457, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:0x7fffffffffffffff
TEST_RR_OP(xor, x12, x10, x11, 0x8000000010000000, -0x10000001, 0x7fffffffffffffff, x1, 1096, x3)

inst_170:
// rs1_val == -2147483649, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:0x8000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff7fff7fff, -0x80000001, 0x8000, x1, 1104, x3)

inst_171:
// rs1_val == -8589934593, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:-0x4000000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x3ffffffdffffffff, -0x200000001, -0x4000000000000000, x1, 1112, x3)

inst_172:
// rs1_val == -34359738369, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x800000001;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xfffffff7ffffffff, -0x800000001, 0x0, x1, 1120, x3)

inst_173:
// rs1_val == -1099511627777, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:-0x8000000001
TEST_RR_OP(xor, x12, x10, x11, 0x18000000000, -0x10000000001, -0x8000000001, x1, 1128, x3)

inst_174:
// rs1_val == -2199023255553, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:0x40
TEST_RR_OP(xor, x12, x10, x11, 0xfffffdffffffffbf, -0x20000000001, 0x40, x1, 1136, x3)

inst_175:
// rs1_val == -8796093022209, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x800b504f332, -0x80000000001, -0xb504f333, x1, 1144, x3)

inst_176:
// rs1_val == -35184372088833, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:-0x80000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x80200000000000, -0x200000000001, -0x80000000000001, x1, 1152, x3)

inst_177:
// rs1_val == -70368744177665, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaeaaaaaaaaaab, -0x400000000001, 0x5555555555555554, x1, 1160, x3)

inst_178:
// rs1_val == -140737488355329, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x999919999999999a, -0x800000000001, 0x6666666666666665, x1, 1168, x3)

inst_179:
// rs1_val == -562949953421313, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:0x2000000000000
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, -0x2000000000001, 0x2000000000000, x1, 1176, x3)

inst_180:
// rs1_val == -1125899906842625, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:-0x401
TEST_RR_OP(xor, x12, x10, x11, 0x4000000000400, -0x4000000000001, -0x401, x1, 1184, x3)

inst_181:
// rs1_val == -2251799813685249, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000001;  op2val:0x800000000000
TEST_RR_OP(xor, x12, x10, x11, 0xfff77fffffffffff, -0x8000000000001, 0x800000000000, x1, 1192, x3)

inst_182:
// rs1_val == -4503599627370497, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xffefffffffffffff, -0x10000000000001, 0x0, x1, 1200, x3)

inst_183:
// rs1_val == -9007199254740993, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000000001;  op2val:-0x80001
TEST_RR_OP(xor, x12, x10, x11, 0x20000000080000, -0x20000000000001, -0x80001, x1, 1208, x3)

inst_184:
// rs1_val == -288230376151711745, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:-0x2000000000001
TEST_RR_OP(xor, x12, x10, x11, 0x402000000000000, -0x400000000000001, -0x2000000000001, x1, 1216, x3)

inst_185:
// rs1_val == -576460752303423489, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:-0x20001
TEST_RR_OP(xor, x12, x10, x11, 0x800000000020000, -0x800000000000001, -0x20001, x1, 1224, x3)

inst_186:
// rs1_val == -1152921504606846977, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xefffffffffffffff, -0x1000000000000001, 0x0, x1, 1232, x3)

inst_187:
// rs1_val == -2305843009213693953, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000000001;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0xeccccccccccccccb, -0x2000000000000001, 0x3333333333333334, x1, 1240, x3)

inst_188:
// rs1_val == -4611686018427387905, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:0x20
TEST_RR_OP(xor, x12, x10, x11, 0xbfffffffffffffdf, -0x4000000000000001, 0x20, x1, 1248, x3)

inst_189:
// rs1_val==3 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x3, 0x3, x1, 1256, x3)

inst_190:
// rs1_val==3 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x3, -0x5555555555555556, x1, 1264, x3)

inst_191:
// rs1_val==3 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x3, 0x5, x1, 1272, x3)

inst_192:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x3, 0x3333333333333333, x1, 1280, x3)

inst_193:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x3, 0x6666666666666666, x1, 1288, x3)

inst_194:
// rs1_val==3 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cce, 0x3, -0xb504f333, x1, 1296, x3)

inst_195:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xb504f330, 0x3, 0xb504f333, x1, 1304, x3)

inst_196:
// rs1_val==3 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x3, 0x2, x1, 1312, x3)

inst_197:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555557, 0x3, 0x5555555555555554, x1, 1320, x3)

inst_198:
// rs1_val==3 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x3, 0x0, x1, 1328, x3)

inst_199:
// rs1_val==3 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0x3, 0x4, x1, 1336, x3)

inst_200:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x3, 0x3333333333333332, x1, 1344, x3)

inst_201:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x3, 0x6666666666666665, x1, 1352, x3)

inst_202:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xb504f331, 0x3, 0xb504f332, x1, 1360, x3)

inst_203:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x3, 0x5555555555555556, x1, 1368, x3)

inst_204:
// rs1_val==3 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, 0x3, -0x5555555555555555, x1, 1376, x3)

inst_205:
// rs1_val==3 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x5, 0x3, 0x6, x1, 1384, x3)

inst_206:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333337, 0x3, 0x3333333333333334, x1, 1392, x3)

inst_207:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666664, 0x3, 0x6666666666666667, x1, 1400, x3)

inst_208:
// rs1_val==3 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccd, 0x3, -0xb504f332, x1, 1408, x3)

inst_209:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xb504f337, 0x3, 0xb504f334, x1, 1416, x3)

inst_210:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x5555555555555555, 0x3, x1, 1424, x3)

inst_211:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555555, x1, 1432, x3)

inst_212:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, 0x5555555555555555, -0x5555555555555556, x1, 1440, x3)

inst_213:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555550, 0x5555555555555555, 0x5, x1, 1448, x3)

inst_214:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x5555555555555555, 0x3333333333333333, x1, 1456, x3)

inst_215:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x5555555555555555, 0x6666666666666666, x1, 1464, x3)

inst_216:
// rs1_val==6148914691236517205 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, 0x5555555555555555, -0xb504f333, x1, 1472, x3)

inst_217:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a666, 0x5555555555555555, 0xb504f333, x1, 1480, x3)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555557, 0x5555555555555555, 0x2, x1, 1488, x3)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555554, x1, 1496, x3)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x0, x1, 1504, x3)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555551, 0x5555555555555555, 0x4, x1, 1512, x3)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x5555555555555555, 0x3333333333333332, x1, 1520, x3)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x5555555555555555, 0x6666666666666665, x1, 1528, x3)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a667, 0x5555555555555555, 0xb504f332, x1, 1536, x3)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x5555555555555555, 0x5555555555555556, x1, 1544, x3)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffe, 0x5555555555555555, -0x5555555555555555, x1, 1552, x3)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555553, 0x5555555555555555, 0x6, x1, 1560, x3)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666661, 0x5555555555555555, 0x3333333333333334, x1, 1568, x3)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x5555555555555555, 0x6666666666666667, x1, 1576, x3)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599b, 0x5555555555555555, -0xb504f332, x1, 1584, x3)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a661, 0x5555555555555555, 0xb504f334, x1, 1592, x3)

inst_232:
// rs1_val==-6148914691236517206 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, -0x5555555555555556, 0x3, x1, 1600, x3)

inst_233:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, -0x5555555555555556, 0x5555555555555555, x1, 1608, x3)

inst_234:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x0, -0x5555555555555556, -0x5555555555555556, x1, 1616, x3)

inst_235:
// rs1_val==-6148914691236517206 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, -0x5555555555555556, 0x5, x1, 1624, x3)

inst_236:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999999, -0x5555555555555556, 0x3333333333333333, x1, 1632, x3)

inst_237:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccc, -0x5555555555555556, 0x6666666666666666, x1, 1640, x3)

inst_238:
// rs1_val==-6148914691236517206 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a667, -0x5555555555555556, -0xb504f333, x1, 1648, x3)

inst_239:
// rs1_val==-6148914691236517206 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5999, -0x5555555555555556, 0xb504f333, x1, 1656, x3)

inst_240:
// rs1_val==-6148914691236517206 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, -0x5555555555555556, 0x2, x1, 1664, x3)

inst_241:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffe, -0x5555555555555556, 0x5555555555555554, x1, 1672, x3)

inst_242:
// rs1_val==-6148914691236517206 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, 0x0, x1, 1680, x3)

inst_243:
// rs1_val==-6148914691236517206 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x4, x1, 1688, x3)

inst_244:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999998, -0x5555555555555556, 0x3333333333333332, x1, 1696, x3)

inst_245:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccf, -0x5555555555555556, 0x6666666666666665, x1, 1704, x3)

inst_246:
// rs1_val==-6148914691236517206 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, -0x5555555555555556, 0xb504f332, x1, 1712, x3)

inst_247:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffc, -0x5555555555555556, 0x5555555555555556, x1, 1720, x3)

inst_248:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x1, -0x5555555555555556, -0x5555555555555555, x1, 1728, x3)

inst_249:
// rs1_val==-6148914691236517206 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaac, -0x5555555555555556, 0x6, x1, 1736, x3)

inst_250:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x999999999999999e, -0x5555555555555556, 0x3333333333333334, x1, 1744, x3)

inst_251:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccd, -0x5555555555555556, 0x6666666666666667, x1, 1752, x3)

inst_252:
// rs1_val==-6148914691236517206 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a664, -0x5555555555555556, -0xb504f332, x1, 1760, x3)

inst_253:
// rs1_val==-6148914691236517206 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599e, -0x5555555555555556, 0xb504f334, x1, 1768, x3)

inst_254:
// rs1_val==5 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x5, 0x3, x1, 1776, x3)

inst_255:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555550, 0x5, 0x5555555555555555, x1, 1784, x3)

inst_256:
// rs1_val==5 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, 0x5, -0x5555555555555556, x1, 1792, x3)

inst_257:
// rs1_val==5 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x5, 0x5, x1, 1800, x3)

inst_258:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333336, 0x5, 0x3333333333333333, x1, 1808, x3)

inst_259:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666663, 0x5, 0x6666666666666666, x1, 1816, x3)

inst_260:
// rs1_val==5 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cc8, 0x5, -0xb504f333, x1, 1824, x3)

inst_261:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xb504f336, 0x5, 0xb504f333, x1, 1832, x3)

inst_262:
// rs1_val==5 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0x5, 0x2, x1, 1840, x3)

inst_263:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555551, 0x5, 0x5555555555555554, x1, 1848, x3)

inst_264:
// rs1_val==5 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x5, 0x5, 0x0, x1, 1856, x3)

inst_265:
// rs1_val==5 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x5, 0x4, x1, 1864, x3)

inst_266:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333337, 0x5, 0x3333333333333332, x1, 1872, x3)

inst_267:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666660, 0x5, 0x6666666666666665, x1, 1880, x3)

inst_268:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xb504f337, 0x5, 0xb504f332, x1, 1888, x3)

inst_269:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555553, 0x5, 0x5555555555555556, x1, 1896, x3)

inst_270:
// rs1_val==5 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaae, 0x5, -0x5555555555555555, x1, 1904, x3)

inst_271:
// rs1_val==5 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x5, 0x6, x1, 1912, x3)

inst_272:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x5, 0x3333333333333334, x1, 1920, x3)

inst_273:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666662, 0x5, 0x6666666666666667, x1, 1928, x3)

inst_274:
// rs1_val==5 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccb, 0x5, -0xb504f332, x1, 1936, x3)

inst_275:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xb504f331, 0x5, 0xb504f334, x1, 1944, x3)

inst_276:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x3333333333333333, 0x3, x1, 1952, x3)

inst_277:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x3333333333333333, 0x5555555555555555, x1, 1960, x3)

inst_278:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999999, 0x3333333333333333, -0x5555555555555556, x1, 1968, x3)

inst_279:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333336, 0x3333333333333333, 0x5, x1, 1976, x3)

inst_280:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333333, x1, 1984, x3)

inst_281:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x3333333333333333, 0x6666666666666666, x1, 1992, x3)

inst_282:
// rs1_val==3689348814741910323 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffe, 0x3333333333333333, -0xb504f333, x1, 2000, x3)

inst_283:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c000, 0x3333333333333333, 0xb504f333, x1, 2008, x3)

inst_284:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x3333333333333333, 0x2, x1, 2016, x3)

inst_285:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x3333333333333333, 0x5555555555555554, x1, 2024, x3)

inst_286:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x0, x1, 2032, x3)

inst_287:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333337, 0x3333333333333333, 0x4, x1, 2040, x3)
RVTEST_SIGBASE( x1,signature_x1_1)

inst_288:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333332, x1, 0, x3)

inst_289:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x3333333333333333, 0x6666666666666665, x1, 8, x3)

inst_290:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c001, 0x3333333333333333, 0xb504f332, x1, 16, x3)

inst_291:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x3333333333333333, 0x5555555555555556, x1, 24, x3)

inst_292:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999998, 0x3333333333333333, -0x5555555555555555, x1, 32, x3)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333335, 0x3333333333333333, 0x6, x1, 40, x3)

inst_294:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0x3333333333333333, 0x3333333333333334, x1, 48, x3)

inst_295:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x3333333333333333, 0x6666666666666667, x1, 56, x3)

inst_296:
// rs1_val==3689348814741910323 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffd, 0x3333333333333333, -0xb504f332, x1, 64, x3)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c007, 0x3333333333333333, 0xb504f334, x1, 72, x3)

inst_298:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x6666666666666666, 0x3, x1, 80, x3)

inst_299:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x6666666666666666, 0x5555555555555555, x1, 88, x3)

inst_300:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccc, 0x6666666666666666, -0x5555555555555556, x1, 96, x3)

inst_301:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666663, 0x6666666666666666, 0x5, x1, 104, x3)

inst_302:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x6666666666666666, 0x3333333333333333, x1, 112, x3)

inst_303:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666666, x1, 120, x3)

inst_304:
// rs1_val==7378697629483820646 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aab, 0x6666666666666666, -0xb504f333, x1, 128, x3)

inst_305:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629555, 0x6666666666666666, 0xb504f333, x1, 136, x3)

inst_306:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666664, 0x6666666666666666, 0x2, x1, 144, x3)

inst_307:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x6666666666666666, 0x5555555555555554, x1, 152, x3)

inst_308:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0x0, x1, 160, x3)

inst_309:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666662, 0x6666666666666666, 0x4, x1, 168, x3)

inst_310:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x6666666666666666, 0x3333333333333332, x1, 176, x3)

inst_311:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x6666666666666666, 0x6666666666666665, x1, 184, x3)

inst_312:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629554, 0x6666666666666666, 0xb504f332, x1, 192, x3)

inst_313:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x6666666666666666, 0x5555555555555556, x1, 200, x3)

inst_314:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccd, 0x6666666666666666, -0x5555555555555555, x1, 208, x3)

inst_315:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666660, 0x6666666666666666, 0x6, x1, 216, x3)

inst_316:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555552, 0x6666666666666666, 0x3333333333333334, x1, 224, x3)

inst_317:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666667, x1, 232, x3)

inst_318:
// rs1_val==7378697629483820646 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aa8, 0x6666666666666666, -0xb504f332, x1, 240, x3)

inst_319:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629552, 0x6666666666666666, 0xb504f334, x1, 248, x3)

inst_320:
// rs1_val==-3037000499 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cce, -0xb504f333, 0x3, x1, 256, x3)

inst_321:
// rs1_val==-3037000499 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, -0xb504f333, 0x5555555555555555, x1, 264, x3)

inst_322:
// rs1_val==-3037000499 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a667, -0xb504f333, -0x5555555555555556, x1, 272, x3)

inst_323:
// rs1_val==-3037000499 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cc8, -0xb504f333, 0x5, x1, 280, x3)

inst_324:
// rs1_val==-3037000499 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffe, -0xb504f333, 0x3333333333333333, x1, 288, x3)

inst_325:
// rs1_val==-3037000499 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aab, -0xb504f333, 0x6666666666666666, x1, 296, x3)

inst_326:
// rs1_val==-3037000499 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x0, -0xb504f333, -0xb504f333, x1, 304, x3)

inst_327:
// rs1_val==-3037000499 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffe, -0xb504f333, 0xb504f333, x1, 312, x3)

inst_328:
// rs1_val==-3037000499 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccf, -0xb504f333, 0x2, x1, 320, x3)

inst_329:
// rs1_val==-3037000499 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5999, -0xb504f333, 0x5555555555555554, x1, 328, x3)

inst_330:
// rs1_val==-3037000499 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccd, -0xb504f333, 0x0, x1, 336, x3)

inst_331:
// rs1_val==-3037000499 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cc9, -0xb504f333, 0x4, x1, 344, x3)

inst_332:
// rs1_val==-3037000499 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83fff, -0xb504f333, 0x3333333333333332, x1, 352, x3)

inst_333:
// rs1_val==-3037000499 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aa8, -0xb504f333, 0x6666666666666665, x1, 360, x3)

inst_334:
// rs1_val==-3037000499 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, -0xb504f333, 0xb504f332, x1, 368, x3)

inst_335:
// rs1_val==-3037000499 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599b, -0xb504f333, 0x5555555555555556, x1, 376, x3)

inst_336:
// rs1_val==-3037000499 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a666, -0xb504f333, -0x5555555555555555, x1, 384, x3)

inst_337:
// rs1_val==-3037000499 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccb, -0xb504f333, 0x6, x1, 392, x3)

inst_338:
// rs1_val==-3037000499 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ff9, -0xb504f333, 0x3333333333333334, x1, 400, x3)

inst_339:
// rs1_val==-3037000499 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aaa, -0xb504f333, 0x6666666666666667, x1, 408, x3)

inst_340:
// rs1_val==-3037000499 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x3, -0xb504f333, -0xb504f332, x1, 416, x3)

inst_341:
// rs1_val==-3037000499 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffff9, -0xb504f333, 0xb504f334, x1, 424, x3)

inst_342:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0xb504f330, 0xb504f333, 0x3, x1, 432, x3)

inst_343:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a666, 0xb504f333, 0x5555555555555555, x1, 440, x3)

inst_344:
// rs1_val==3037000499 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5999, 0xb504f333, -0x5555555555555556, x1, 448, x3)

inst_345:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0xb504f336, 0xb504f333, 0x5, x1, 456, x3)

inst_346:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c000, 0xb504f333, 0x3333333333333333, x1, 464, x3)

inst_347:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629555, 0xb504f333, 0x6666666666666666, x1, 472, x3)

inst_348:
// rs1_val==3037000499 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffe, 0xb504f333, -0xb504f333, x1, 480, x3)

inst_349:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0xb504f333, 0xb504f333, x1, 488, x3)

inst_350:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0xb504f331, 0xb504f333, 0x2, x1, 496, x3)

inst_351:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a667, 0xb504f333, 0x5555555555555554, x1, 504, x3)

inst_352:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xb504f333, 0xb504f333, 0x0, x1, 512, x3)

inst_353:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xb504f337, 0xb504f333, 0x4, x1, 520, x3)

inst_354:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c001, 0xb504f333, 0x3333333333333332, x1, 528, x3)

inst_355:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629556, 0xb504f333, 0x6666666666666665, x1, 536, x3)

inst_356:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0xb504f333, 0xb504f332, x1, 544, x3)

inst_357:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a665, 0xb504f333, 0x5555555555555556, x1, 552, x3)

inst_358:
// rs1_val==3037000499 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, 0xb504f333, -0x5555555555555555, x1, 560, x3)

inst_359:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0xb504f335, 0xb504f333, 0x6, x1, 568, x3)

inst_360:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c007, 0xb504f333, 0x3333333333333334, x1, 576, x3)

inst_361:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629554, 0xb504f333, 0x6666666666666667, x1, 584, x3)

inst_362:
// rs1_val==3037000499 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffd, 0xb504f333, -0xb504f332, x1, 592, x3)

inst_363:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0xb504f333, 0xb504f334, x1, 600, x3)

inst_364:
// rs1_val==2 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x2, 0x3, x1, 608, x3)

inst_365:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555557, 0x2, 0x5555555555555555, x1, 616, x3)

inst_366:
// rs1_val==2 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, 0x2, -0x5555555555555556, x1, 624, x3)

inst_367:
// rs1_val==2 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0x2, 0x5, x1, 632, x3)

inst_368:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x2, 0x3333333333333333, x1, 640, x3)

inst_369:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666664, 0x2, 0x6666666666666666, x1, 648, x3)

inst_370:
// rs1_val==2 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccf, 0x2, -0xb504f333, x1, 656, x3)

inst_371:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xb504f331, 0x2, 0xb504f333, x1, 664, x3)

inst_372:
// rs1_val==2 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x2, 0x2, x1, 672, x3)

inst_373:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x2, 0x5555555555555554, x1, 680, x3)

inst_374:
// rs1_val==2 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x2, 0x4, x1, 688, x3)

inst_375:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x2, 0x3333333333333332, x1, 696, x3)

inst_376:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x2, 0x6666666666666665, x1, 704, x3)

inst_377:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xb504f330, 0x2, 0xb504f332, x1, 712, x3)

inst_378:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x2, 0x5555555555555556, x1, 720, x3)

inst_379:
// rs1_val==2 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0x2, -0x5555555555555555, x1, 728, x3)

inst_380:
// rs1_val==2 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x4, 0x2, 0x6, x1, 736, x3)

inst_381:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333336, 0x2, 0x3333333333333334, x1, 744, x3)

inst_382:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x2, 0x6666666666666667, x1, 752, x3)

inst_383:
// rs1_val==2 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccc, 0x2, -0xb504f332, x1, 760, x3)

inst_384:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xb504f336, 0x2, 0xb504f334, x1, 768, x3)

inst_385:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555557, 0x5555555555555554, 0x3, x1, 776, x3)

inst_386:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x5555555555555554, 0x5555555555555555, x1, 784, x3)

inst_387:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffe, 0x5555555555555554, -0x5555555555555556, x1, 792, x3)

inst_388:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555551, 0x5555555555555554, 0x5, x1, 800, x3)

inst_389:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x5555555555555554, 0x3333333333333333, x1, 808, x3)

inst_390:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x5555555555555554, 0x6666666666666666, x1, 816, x3)

inst_391:
// rs1_val==6148914691236517204 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5999, 0x5555555555555554, -0xb504f333, x1, 824, x3)

inst_392:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a667, 0x5555555555555554, 0xb504f333, x1, 832, x3)

inst_393:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x5555555555555554, 0x2, x1, 840, x3)

inst_394:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555554, x1, 848, x3)

inst_395:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x0, x1, 856, x3)

inst_396:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555550, 0x5555555555555554, 0x4, x1, 864, x3)

inst_397:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x5555555555555554, 0x3333333333333332, x1, 872, x3)

inst_398:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x5555555555555554, 0x6666666666666665, x1, 880, x3)

inst_399:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a666, 0x5555555555555554, 0xb504f332, x1, 888, x3)

inst_400:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x2, 0x5555555555555554, 0x5555555555555556, x1, 896, x3)

inst_401:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, 0x5555555555555554, -0x5555555555555555, x1, 904, x3)

inst_402:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555552, 0x5555555555555554, 0x6, x1, 912, x3)

inst_403:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666660, 0x5555555555555554, 0x3333333333333334, x1, 920, x3)

inst_404:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x5555555555555554, 0x6666666666666667, x1, 928, x3)

inst_405:
// rs1_val==6148914691236517204 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599a, 0x5555555555555554, -0xb504f332, x1, 936, x3)

inst_406:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a660, 0x5555555555555554, 0xb504f334, x1, 944, x3)

inst_407:
// rs1_val==0 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x0, 0x3, x1, 952, x3)

inst_408:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x0, 0x5555555555555555, x1, 960, x3)

inst_409:
// rs1_val==0 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0x0, -0x5555555555555556, x1, 968, x3)

inst_410:
// rs1_val==0 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x5, 0x0, 0x5, x1, 976, x3)

inst_411:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x0, 0x3333333333333333, x1, 984, x3)

inst_412:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x0, 0x6666666666666666, x1, 992, x3)

inst_413:
// rs1_val==0 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccd, 0x0, -0xb504f333, x1, 1000, x3)

inst_414:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xb504f333, 0x0, 0xb504f333, x1, 1008, x3)

inst_415:
// rs1_val==0 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cce, 0x0, -0xb504f332, x1, 1016, x3)

inst_416:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xb504f334, 0x0, 0xb504f334, x1, 1024, x3)

inst_417:
// rs1_val==4 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0x4, 0x3, x1, 1032, x3)

inst_418:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555551, 0x4, 0x5555555555555555, x1, 1040, x3)

inst_419:
// rs1_val==4 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x4, 0x5, x1, 1048, x3)

inst_420:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333337, 0x4, 0x3333333333333333, x1, 1056, x3)

inst_421:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666662, 0x4, 0x6666666666666666, x1, 1064, x3)

inst_422:
// rs1_val==4 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cc9, 0x4, -0xb504f333, x1, 1072, x3)

inst_423:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xb504f337, 0x4, 0xb504f333, x1, 1080, x3)

inst_424:
// rs1_val==4 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x4, 0x2, x1, 1088, x3)

inst_425:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555550, 0x4, 0x5555555555555554, x1, 1096, x3)

inst_426:
// rs1_val==4 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x4, 0x4, 0x0, x1, 1104, x3)

inst_427:
// rs1_val==4 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x4, 0x4, x1, 1112, x3)

inst_428:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333336, 0x4, 0x3333333333333332, x1, 1120, x3)

inst_429:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666661, 0x4, 0x6666666666666665, x1, 1128, x3)

inst_430:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xb504f336, 0x4, 0xb504f332, x1, 1136, x3)

inst_431:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555552, 0x4, 0x5555555555555556, x1, 1144, x3)

inst_432:
// rs1_val==4 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, 0x4, -0x5555555555555555, x1, 1152, x3)

inst_433:
// rs1_val==4 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x2, 0x4, 0x6, x1, 1160, x3)

inst_434:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x4, 0x3333333333333334, x1, 1168, x3)

inst_435:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666663, 0x4, 0x6666666666666667, x1, 1176, x3)

inst_436:
// rs1_val==4 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cca, 0x4, -0xb504f332, x1, 1184, x3)

inst_437:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xb504f330, 0x4, 0xb504f334, x1, 1192, x3)

inst_438:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x3333333333333332, 0x3, x1, 1200, x3)

inst_439:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x3333333333333332, 0x5555555555555555, x1, 1208, x3)

inst_440:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999998, 0x3333333333333332, -0x5555555555555556, x1, 1216, x3)

inst_441:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333337, 0x3333333333333332, 0x5, x1, 1224, x3)

inst_442:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x3333333333333332, 0x3333333333333333, x1, 1232, x3)

inst_443:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x3333333333333332, 0x6666666666666666, x1, 1240, x3)

inst_444:
// rs1_val==3689348814741910322 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83fff, 0x3333333333333332, -0xb504f333, x1, 1248, x3)

inst_445:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c001, 0x3333333333333332, 0xb504f333, x1, 1256, x3)

inst_446:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x3333333333333332, 0x2, x1, 1264, x3)

inst_447:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x3333333333333332, 0x5555555555555554, x1, 1272, x3)

inst_448:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x0, x1, 1280, x3)

inst_449:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333336, 0x3333333333333332, 0x4, x1, 1288, x3)

inst_450:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333332, x1, 1296, x3)

inst_451:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555557, 0x3333333333333332, 0x6666666666666665, x1, 1304, x3)

inst_452:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c000, 0x3333333333333332, 0xb504f332, x1, 1312, x3)

inst_453:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666664, 0x3333333333333332, 0x5555555555555556, x1, 1320, x3)

inst_454:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999999, 0x3333333333333332, -0x5555555555555555, x1, 1328, x3)

inst_455:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333334, 0x3333333333333332, 0x6, x1, 1336, x3)

inst_456:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x3333333333333332, 0x3333333333333334, x1, 1344, x3)

inst_457:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x3333333333333332, 0x6666666666666667, x1, 1352, x3)

inst_458:
// rs1_val==3689348814741910322 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffc, 0x3333333333333332, -0xb504f332, x1, 1360, x3)

inst_459:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c006, 0x3333333333333332, 0xb504f334, x1, 1368, x3)

inst_460:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666666, 0x6666666666666665, 0x3, x1, 1376, x3)

inst_461:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x6666666666666665, 0x5555555555555555, x1, 1384, x3)

inst_462:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccf, 0x6666666666666665, -0x5555555555555556, x1, 1392, x3)

inst_463:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666660, 0x6666666666666665, 0x5, x1, 1400, x3)

inst_464:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x6666666666666665, 0x3333333333333333, x1, 1408, x3)

inst_465:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x6666666666666665, 0x6666666666666666, x1, 1416, x3)

inst_466:
// rs1_val==7378697629483820645 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aa8, 0x6666666666666665, -0xb504f333, x1, 1424, x3)

inst_467:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629556, 0x6666666666666665, 0xb504f333, x1, 1432, x3)

inst_468:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x6666666666666665, 0x2, x1, 1440, x3)

inst_469:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x6666666666666665, 0x5555555555555554, x1, 1448, x3)

inst_470:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0x0, x1, 1456, x3)

inst_471:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666661, 0x6666666666666665, 0x4, x1, 1464, x3)

inst_472:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555557, 0x6666666666666665, 0x3333333333333332, x1, 1472, x3)

inst_473:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666665, x1, 1480, x3)

inst_474:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629557, 0x6666666666666665, 0xb504f332, x1, 1488, x3)

inst_475:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x6666666666666665, 0x5555555555555556, x1, 1496, x3)

inst_476:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xccccccccccccccce, 0x6666666666666665, -0x5555555555555555, x1, 1504, x3)

inst_477:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666663, 0x6666666666666665, 0x6, x1, 1512, x3)

inst_478:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555551, 0x6666666666666665, 0x3333333333333334, x1, 1520, x3)

inst_479:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x2, 0x6666666666666665, 0x6666666666666667, x1, 1528, x3)

inst_480:
// rs1_val==7378697629483820645 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aab, 0x6666666666666665, -0xb504f332, x1, 1536, x3)

inst_481:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629551, 0x6666666666666665, 0xb504f334, x1, 1544, x3)

inst_482:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0xb504f331, 0xb504f332, 0x3, x1, 1552, x3)

inst_483:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a667, 0xb504f332, 0x5555555555555555, x1, 1560, x3)

inst_484:
// rs1_val==3037000498 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, 0xb504f332, -0x5555555555555556, x1, 1568, x3)

inst_485:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0xb504f337, 0xb504f332, 0x5, x1, 1576, x3)

inst_486:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c001, 0xb504f332, 0x3333333333333333, x1, 1584, x3)

inst_487:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629554, 0xb504f332, 0x6666666666666666, x1, 1592, x3)

inst_488:
// rs1_val==3037000498 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, 0xb504f332, -0xb504f333, x1, 1600, x3)

inst_489:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0xb504f332, 0xb504f333, x1, 1608, x3)

inst_490:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0xb504f330, 0xb504f332, 0x2, x1, 1616, x3)

inst_491:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a666, 0xb504f332, 0x5555555555555554, x1, 1624, x3)

inst_492:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xb504f332, 0xb504f332, 0x0, x1, 1632, x3)

inst_493:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xb504f336, 0xb504f332, 0x4, x1, 1640, x3)

inst_494:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c000, 0xb504f332, 0x3333333333333332, x1, 1648, x3)

inst_495:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629557, 0xb504f332, 0x6666666666666665, x1, 1656, x3)

inst_496:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0xb504f332, 0xb504f332, x1, 1664, x3)

inst_497:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a664, 0xb504f332, 0x5555555555555556, x1, 1672, x3)

inst_498:
// rs1_val==3037000498 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5999, 0xb504f332, -0x5555555555555555, x1, 1680, x3)

inst_499:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0xb504f334, 0xb504f332, 0x6, x1, 1688, x3)

inst_500:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c006, 0xb504f332, 0x3333333333333334, x1, 1696, x3)

inst_501:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629555, 0xb504f332, 0x6666666666666667, x1, 1704, x3)

inst_502:
// rs1_val==3037000498 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffc, 0xb504f332, -0xb504f332, x1, 1712, x3)

inst_503:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0xb504f332, 0xb504f334, x1, 1720, x3)

inst_504:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x5555555555555556, 0x3, x1, 1728, x3)

inst_505:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x5555555555555556, 0x5555555555555555, x1, 1736, x3)

inst_506:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffc, 0x5555555555555556, -0x5555555555555556, x1, 1744, x3)

inst_507:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555553, 0x5555555555555556, 0x5, x1, 1752, x3)

inst_508:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x5555555555555556, 0x3333333333333333, x1, 1760, x3)

inst_509:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x5555555555555556, 0x6666666666666666, x1, 1768, x3)

inst_510:
// rs1_val==6148914691236517206 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599b, 0x5555555555555556, -0xb504f333, x1, 1776, x3)

inst_511:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a665, 0x5555555555555556, 0xb504f333, x1, 1784, x3)

inst_512:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x5555555555555556, 0x2, x1, 1792, x3)

inst_513:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x2, 0x5555555555555556, 0x5555555555555554, x1, 1800, x3)

inst_514:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x0, x1, 1808, x3)

inst_515:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555552, 0x5555555555555556, 0x4, x1, 1816, x3)

inst_516:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666664, 0x5555555555555556, 0x3333333333333332, x1, 1824, x3)

inst_517:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x5555555555555556, 0x6666666666666665, x1, 1832, x3)

inst_518:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a664, 0x5555555555555556, 0xb504f332, x1, 1840, x3)

inst_519:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555556, x1, 1848, x3)

inst_520:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffd, 0x5555555555555556, -0x5555555555555555, x1, 1856, x3)

inst_521:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555550, 0x5555555555555556, 0x6, x1, 1864, x3)

inst_522:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666662, 0x5555555555555556, 0x3333333333333334, x1, 1872, x3)

inst_523:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x5555555555555556, 0x6666666666666667, x1, 1880, x3)

inst_524:
// rs1_val==6148914691236517206 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, 0x5555555555555556, -0xb504f332, x1, 1888, x3)

inst_525:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a662, 0x5555555555555556, 0xb504f334, x1, 1896, x3)

inst_526:
// rs1_val==-6148914691236517205 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa8, -0x5555555555555555, 0x3, x1, 1904, x3)

inst_527:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffe, -0x5555555555555555, 0x5555555555555555, x1, 1912, x3)

inst_528:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x1, -0x5555555555555555, -0x5555555555555556, x1, 1920, x3)

inst_529:
// rs1_val==-6148914691236517205 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaae, -0x5555555555555555, 0x5, x1, 1928, x3)

inst_530:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999998, -0x5555555555555555, 0x3333333333333333, x1, 1936, x3)

inst_531:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccd, -0x5555555555555555, 0x6666666666666666, x1, 1944, x3)

inst_532:
// rs1_val==-6148914691236517205 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a666, -0x5555555555555555, -0xb504f333, x1, 1952, x3)

inst_533:
// rs1_val==-6148914691236517205 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, -0x5555555555555555, 0xb504f333, x1, 1960, x3)

inst_534:
// rs1_val==-6148914691236517205 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, -0x5555555555555555, 0x2, x1, 1968, x3)

inst_535:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffffff, -0x5555555555555555, 0x5555555555555554, x1, 1976, x3)

inst_536:
// rs1_val==-6148914691236517205 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x0, x1, 1984, x3)

inst_537:
// rs1_val==-6148914691236517205 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x4, x1, 1992, x3)

inst_538:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x9999999999999999, -0x5555555555555555, 0x3333333333333332, x1, 2000, x3)

inst_539:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0xccccccccccccccce, -0x5555555555555555, 0x6666666666666665, x1, 2008, x3)

inst_540:
// rs1_val==-6148914691236517205 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5999, -0x5555555555555555, 0xb504f332, x1, 2016, x3)

inst_541:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffd, -0x5555555555555555, 0x5555555555555556, x1, 2024, x3)

inst_542:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x0, -0x5555555555555555, -0x5555555555555555, x1, 2032, x3)

inst_543:
// rs1_val==-6148914691236517205 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaad, -0x5555555555555555, 0x6, x1, 2040, x3)
RVTEST_SIGBASE( x1,signature_x1_2)

inst_544:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x999999999999999f, -0x5555555555555555, 0x3333333333333334, x1, 0, x3)

inst_545:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccc, -0x5555555555555555, 0x6666666666666667, x1, 8, x3)

inst_546:
// rs1_val==-6148914691236517205 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a665, -0x5555555555555555, -0xb504f332, x1, 16, x3)

inst_547:
// rs1_val==-6148914691236517205 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599f, -0x5555555555555555, 0xb504f334, x1, 24, x3)

inst_548:
// rs1_val==6 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x5, 0x6, 0x3, x1, 32, x3)

inst_549:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555553, 0x6, 0x5555555555555555, x1, 40, x3)

inst_550:
// rs1_val==6 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaac, 0x6, -0x5555555555555556, x1, 48, x3)

inst_551:
// rs1_val==6 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x3, 0x6, 0x5, x1, 56, x3)

inst_552:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333335, 0x6, 0x3333333333333333, x1, 64, x3)

inst_553:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666660, 0x6, 0x6666666666666666, x1, 72, x3)

inst_554:
// rs1_val==6 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccb, 0x6, -0xb504f333, x1, 80, x3)

inst_555:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xb504f335, 0x6, 0xb504f333, x1, 88, x3)

inst_556:
// rs1_val==6 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x4, 0x6, 0x2, x1, 96, x3)

inst_557:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555552, 0x6, 0x5555555555555554, x1, 104, x3)

inst_558:
// rs1_val==6 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x6, 0x0, x1, 112, x3)

inst_559:
// rs1_val==6 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x2, 0x6, 0x4, x1, 120, x3)

inst_560:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333334, 0x6, 0x3333333333333332, x1, 128, x3)

inst_561:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666663, 0x6, 0x6666666666666665, x1, 136, x3)

inst_562:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xb504f334, 0x6, 0xb504f332, x1, 144, x3)

inst_563:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555550, 0x6, 0x5555555555555556, x1, 152, x3)

inst_564:
// rs1_val==6 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaad, 0x6, -0x5555555555555555, x1, 160, x3)

inst_565:
// rs1_val==6 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x6, 0x6, x1, 168, x3)

inst_566:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x6, 0x3333333333333334, x1, 176, x3)

inst_567:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666661, 0x6, 0x6666666666666667, x1, 184, x3)

inst_568:
// rs1_val==6 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cc8, 0x6, -0xb504f332, x1, 192, x3)

inst_569:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xb504f332, 0x6, 0xb504f334, x1, 200, x3)

inst_570:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333337, 0x3333333333333334, 0x3, x1, 208, x3)

inst_571:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666661, 0x3333333333333334, 0x5555555555555555, x1, 216, x3)

inst_572:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x999999999999999e, 0x3333333333333334, -0x5555555555555556, x1, 224, x3)

inst_573:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x3333333333333334, 0x5, x1, 232, x3)

inst_574:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0x3333333333333334, 0x3333333333333333, x1, 240, x3)

inst_575:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555552, 0x3333333333333334, 0x6666666666666666, x1, 248, x3)

inst_576:
// rs1_val==3689348814741910324 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ff9, 0x3333333333333334, -0xb504f333, x1, 256, x3)

inst_577:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c007, 0x3333333333333334, 0xb504f333, x1, 264, x3)

inst_578:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333336, 0x3333333333333334, 0x2, x1, 272, x3)

inst_579:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666660, 0x3333333333333334, 0x5555555555555554, x1, 280, x3)

inst_580:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x0, x1, 288, x3)

inst_581:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333330, 0x3333333333333334, 0x4, x1, 296, x3)

inst_582:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x3333333333333334, 0x3333333333333332, x1, 304, x3)

inst_583:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555551, 0x3333333333333334, 0x6666666666666665, x1, 312, x3)

inst_584:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c006, 0x3333333333333334, 0xb504f332, x1, 320, x3)

inst_585:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666662, 0x3333333333333334, 0x5555555555555556, x1, 328, x3)

inst_586:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x999999999999999f, 0x3333333333333334, -0x5555555555555555, x1, 336, x3)

inst_587:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x3333333333333334, 0x6, x1, 344, x3)

inst_588:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333334, x1, 352, x3)

inst_589:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555553, 0x3333333333333334, 0x6666666666666667, x1, 360, x3)

inst_590:
// rs1_val==3689348814741910324 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffa, 0x3333333333333334, -0xb504f332, x1, 368, x3)

inst_591:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c000, 0x3333333333333334, 0xb504f334, x1, 376, x3)

inst_592:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666664, 0x6666666666666667, 0x3, x1, 384, x3)

inst_593:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x6666666666666667, 0x5555555555555555, x1, 392, x3)

inst_594:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccd, 0x6666666666666667, -0x5555555555555556, x1, 400, x3)

inst_595:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666662, 0x6666666666666667, 0x5, x1, 408, x3)

inst_596:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x6666666666666667, 0x3333333333333333, x1, 416, x3)

inst_597:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x1, 0x6666666666666667, 0x6666666666666666, x1, 424, x3)

inst_598:
// rs1_val==7378697629483820647 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aaa, 0x6666666666666667, -0xb504f333, x1, 432, x3)

inst_599:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629554, 0x6666666666666667, 0xb504f333, x1, 440, x3)

inst_600:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x6666666666666667, 0x2, x1, 448, x3)

inst_601:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333333, 0x6666666666666667, 0x5555555555555554, x1, 456, x3)

inst_602:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x6666666666666667, 0x0, x1, 464, x3)

inst_603:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666663, 0x6666666666666667, 0x4, x1, 472, x3)

inst_604:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555555, 0x6666666666666667, 0x3333333333333332, x1, 480, x3)

inst_605:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x2, 0x6666666666666667, 0x6666666666666665, x1, 488, x3)

inst_606:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629555, 0x6666666666666667, 0xb504f332, x1, 496, x3)

inst_607:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333331, 0x6666666666666667, 0x5555555555555556, x1, 504, x3)

inst_608:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccccccccccc, 0x6666666666666667, -0x5555555555555555, x1, 512, x3)

inst_609:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666661, 0x6666666666666667, 0x6, x1, 520, x3)

inst_610:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555553, 0x6666666666666667, 0x3333333333333334, x1, 528, x3)

inst_611:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666667, x1, 536, x3)

inst_612:
// rs1_val==7378697629483820647 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aa9, 0x6666666666666667, -0xb504f332, x1, 544, x3)

inst_613:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629553, 0x6666666666666667, 0xb504f334, x1, 552, x3)

inst_614:
// rs1_val==-3037000498 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccd, -0xb504f332, 0x3, x1, 560, x3)

inst_615:
// rs1_val==-3037000498 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599b, -0xb504f332, 0x5555555555555555, x1, 568, x3)

inst_616:
// rs1_val==-3037000498 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a664, -0xb504f332, -0x5555555555555556, x1, 576, x3)

inst_617:
// rs1_val==-3037000498 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccb, -0xb504f332, 0x5, x1, 584, x3)

inst_618:
// rs1_val==-3037000498 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffd, -0xb504f332, 0x3333333333333333, x1, 592, x3)

inst_619:
// rs1_val==-3037000498 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aa8, -0xb504f332, 0x6666666666666666, x1, 600, x3)

inst_620:
// rs1_val==-3037000498 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x3, -0xb504f332, -0xb504f333, x1, 608, x3)

inst_621:
// rs1_val==-3037000498 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffd, -0xb504f332, 0xb504f333, x1, 616, x3)

inst_622:
// rs1_val==-3037000498 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0ccc, -0xb504f332, 0x2, x1, 624, x3)

inst_623:
// rs1_val==-3037000498 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599a, -0xb504f332, 0x5555555555555554, x1, 632, x3)

inst_624:
// rs1_val==-3037000498 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cce, -0xb504f332, 0x0, x1, 640, x3)

inst_625:
// rs1_val==-3037000498 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cca, -0xb504f332, 0x4, x1, 648, x3)

inst_626:
// rs1_val==-3037000498 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffc, -0xb504f332, 0x3333333333333332, x1, 656, x3)

inst_627:
// rs1_val==-3037000498 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aab, -0xb504f332, 0x6666666666666665, x1, 664, x3)

inst_628:
// rs1_val==-3037000498 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffc, -0xb504f332, 0xb504f332, x1, 672, x3)

inst_629:
// rs1_val==-3037000498 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae5998, -0xb504f332, 0x5555555555555556, x1, 680, x3)

inst_630:
// rs1_val==-3037000498 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a665, -0xb504f332, -0x5555555555555555, x1, 688, x3)

inst_631:
// rs1_val==-3037000498 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0xffffffff4afb0cc8, -0xb504f332, 0x6, x1, 696, x3)

inst_632:
// rs1_val==-3037000498 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0xcccccccc79c83ffa, -0xb504f332, 0x3333333333333334, x1, 704, x3)

inst_633:
// rs1_val==-3037000498 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x999999992c9d6aa9, -0xb504f332, 0x6666666666666667, x1, 712, x3)

inst_634:
// rs1_val==-3037000498 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x0, -0xb504f332, -0xb504f332, x1, 720, x3)

inst_635:
// rs1_val==-3037000498 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffa, -0xb504f332, 0xb504f334, x1, 728, x3)

inst_636:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(xor, x12, x10, x11, 0xb504f337, 0xb504f334, 0x3, x1, 736, x3)

inst_637:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a661, 0xb504f334, 0x5555555555555555, x1, 744, x3)

inst_638:
// rs1_val==3037000500 and rs2_val==-6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599e, 0xb504f334, -0x5555555555555556, x1, 752, x3)

inst_639:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(xor, x12, x10, x11, 0xb504f331, 0xb504f334, 0x5, x1, 760, x3)

inst_640:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c007, 0xb504f334, 0x3333333333333333, x1, 768, x3)

inst_641:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629552, 0xb504f334, 0x6666666666666666, x1, 776, x3)

inst_642:
// rs1_val==3037000500 and rs2_val==-3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffff9, 0xb504f334, -0xb504f333, x1, 784, x3)

inst_643:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(xor, x12, x10, x11, 0x7, 0xb504f334, 0xb504f333, x1, 792, x3)

inst_644:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0xb504f336, 0xb504f334, 0x2, x1, 800, x3)

inst_645:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a660, 0xb504f334, 0x5555555555555554, x1, 808, x3)

inst_646:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0xb504f334, 0xb504f334, 0x0, x1, 816, x3)

inst_647:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0xb504f330, 0xb504f334, 0x4, x1, 824, x3)

inst_648:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c006, 0xb504f334, 0x3333333333333332, x1, 832, x3)

inst_649:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629551, 0xb504f334, 0x6666666666666665, x1, 840, x3)

inst_650:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0xb504f334, 0xb504f332, x1, 848, x3)

inst_651:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x55555555e051a662, 0xb504f334, 0x5555555555555556, x1, 856, x3)

inst_652:
// rs1_val==3037000500 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaa1fae599f, 0xb504f334, -0x5555555555555555, x1, 864, x3)

inst_653:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0xb504f332, 0xb504f334, 0x6, x1, 872, x3)

inst_654:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x333333338637c000, 0xb504f334, 0x3333333333333334, x1, 880, x3)

inst_655:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x66666666d3629553, 0xb504f334, 0x6666666666666667, x1, 888, x3)

inst_656:
// rs1_val==3037000500 and rs2_val==-3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xfffffffffffffffa, 0xb504f334, -0xb504f332, x1, 896, x3)

inst_657:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0xb504f334, 0xb504f334, x1, 904, x3)

inst_658:
// rs1_val==0 and rs2_val==2, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(xor, x12, x10, x11, 0x2, 0x0, 0x2, x1, 912, x3)

inst_659:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555554, 0x0, 0x5555555555555554, x1, 920, x3)

inst_660:
// rs1_val==0 and rs2_val==0, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(xor, x12, x10, x11, 0x0, 0x0, 0x0, x1, 928, x3)

inst_661:
// rs1_val==0 and rs2_val==4, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(xor, x12, x10, x11, 0x4, 0x0, 0x4, x1, 936, x3)

inst_662:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333332, 0x0, 0x3333333333333332, x1, 944, x3)

inst_663:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666665, 0x0, 0x6666666666666665, x1, 952, x3)

inst_664:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(xor, x12, x10, x11, 0xb504f332, 0x0, 0xb504f332, x1, 960, x3)

inst_665:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(xor, x12, x10, x11, 0x5555555555555556, 0x0, 0x5555555555555556, x1, 968, x3)

inst_666:
// rs1_val==0 and rs2_val==-6148914691236517205, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555555
TEST_RR_OP(xor, x12, x10, x11, 0xaaaaaaaaaaaaaaab, 0x0, -0x5555555555555555, x1, 976, x3)

inst_667:
// rs1_val==0 and rs2_val==6, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(xor, x12, x10, x11, 0x6, 0x0, 0x6, x1, 984, x3)

inst_668:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(xor, x12, x10, x11, 0x3333333333333334, 0x0, 0x3333333333333334, x1, 992, x3)

inst_669:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(xor, x12, x10, x11, 0x6666666666666667, 0x0, 0x6666666666666667, x1, 1000, x3)

inst_670:
// rs1_val > 0 and rs2_val > 0, rs2_val == 576460752303423488, rs1_val == 18014398509481984, rs1_val != rs2_val
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0x800000000000000
TEST_RR_OP(xor, x12, x10, x11, 0x840000000000000, 0x40000000000000, 0x800000000000000, x1, 1008, x3)

inst_671:
// rs1_val < 0 and rs2_val < 0, rs1_val == -17179869185, rs2_val == -1025
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:-0x400000001;  op2val:-0x401
TEST_RR_OP(xor, x12, x10, x11, 0x400000400, -0x400000001, -0x401, x1, 1016, x3)

inst_672:
// rs1_val == 0, rs2_val == -16385
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x4001
TEST_RR_OP(xor, x12, x10, x11, 0xffffffffffffbfff, 0x0, -0x4001, x1, 1024, x3)

inst_673:
// rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:0x7
TEST_RR_OP(xor, x12, x10, x11, 0x7ffffffffffffff8, 0x7fffffffffffffff, 0x7, x1, 1032, x3)

inst_674:
// rs2_val == 1024, rs1_val == 524288
// opcode: xor ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0x400
TEST_RR_OP(xor, x12, x10, x11, 0x80400, 0x80000, 0x400, x1, 1040, x3)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x9_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x9_1:
    .fill 16*(XLEN/32),4,0xdeadbeef


signature_x2_0:
    .fill 16*(XLEN/32),4,0xdeadbeef


signature_x1_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x1_2:
    .fill 131*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
