
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 03:45:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64i.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the xori instruction of the RISC-V I extension for the xori covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64I")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*);def TEST_CASE_1=True;",xori)

RVTEST_SIGBASE( x2,signature_x2_1)

inst_0:
// rs1 == rd, rs1==x9, rd==x9, imm_val == (-2**(12-1)), imm_val == -2048, rs1_val != imm_val, rs1_val == 4, rs1_val > 0 and imm_val < 0
// opcode: xori ; op1:x9; dest:x9; op1val:0x4;  immval:-0x800
TEST_IMM_OP( xori, x9, x9, 0xfffffffffffff804, 0x4, -0x800, x2, 0, x3)

inst_1:
// rs1 != rd, rs1==x25, rd==x19, imm_val == 0, rs1_val == -134217729
// opcode: xori ; op1:x25; dest:x19; op1val:-0x8000001;  immval:0x0
TEST_IMM_OP( xori, x19, x25, 0xfffffffff7ffffff, -0x8000001, 0x0, x2, 8, x3)

inst_2:
// rs1==x13, rd==x12, imm_val == (2**(12-1)-1), rs1_val > 0 and imm_val > 0, imm_val == 2047
// opcode: xori ; op1:x13; dest:x12; op1val:0x3;  immval:0x7ff
TEST_IMM_OP( xori, x12, x13, 0x7fc, 0x3, 0x7ff, x2, 16, x3)

inst_3:
// rs1==x16, rd==x13, imm_val == 1, rs1_val < 0 and imm_val > 0
// opcode: xori ; op1:x16; dest:x13; op1val:-0x5555555555555555;  immval:0x1
TEST_IMM_OP( xori, x13, x16, 0xaaaaaaaaaaaaaaaa, -0x5555555555555555, 0x1, x2, 24, x3)

inst_4:
// rs1==x4, rd==x14, rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808, imm_val == -9, rs1_val < 0 and imm_val < 0
// opcode: xori ; op1:x4; dest:x14; op1val:-0x8000000000000000;  immval:-0x9
TEST_IMM_OP( xori, x14, x4, 0x7ffffffffffffff7, -0x8000000000000000, -0x9, x2, 32, x3)

inst_5:
// rs1==x29, rd==x23, rs1_val == 0, rs1_val == imm_val, rs1_val==0 and imm_val==0
// opcode: xori ; op1:x29; dest:x23; op1val:0x0;  immval:0x0
TEST_IMM_OP( xori, x23, x29, 0x0, 0x0, 0x0, x2, 40, x3)

inst_6:
// rs1==x28, rd==x21, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807, imm_val == 2
// opcode: xori ; op1:x28; dest:x21; op1val:0x7fffffffffffffff;  immval:0x2
TEST_IMM_OP( xori, x21, x28, 0x7ffffffffffffffd, 0x7fffffffffffffff, 0x2, x2, 48, x3)

inst_7:
// rs1==x22, rd==x4, rs1_val == 1, 
// opcode: xori ; op1:x22; dest:x4; op1val:0x1;  immval:0x666
TEST_IMM_OP( xori, x4, x22, 0x667, 0x1, 0x666, x2, 56, x3)

inst_8:
// rs1==x11, rd==x31, imm_val == 4, rs1_val == 32768
// opcode: xori ; op1:x11; dest:x31; op1val:0x8000;  immval:0x4
TEST_IMM_OP( xori, x31, x11, 0x8004, 0x8000, 0x4, x2, 64, x3)

inst_9:
// rs1==x17, rd==x6, imm_val == 8, rs1_val == -257
// opcode: xori ; op1:x17; dest:x6; op1val:-0x101;  immval:0x8
TEST_IMM_OP( xori, x6, x17, 0xfffffffffffffef7, -0x101, 0x8, x2, 72, x3)

inst_10:
// rs1==x12, rd==x15, imm_val == 16, 
// opcode: xori ; op1:x12; dest:x15; op1val:-0xa;  immval:0x10
TEST_IMM_OP( xori, x15, x12, 0xffffffffffffffe6, -0xa, 0x10, x2, 80, x3)

inst_11:
// rs1==x27, rd==x22, imm_val == 32, rs1_val == -4398046511105
// opcode: xori ; op1:x27; dest:x22; op1val:-0x40000000001;  immval:0x20
TEST_IMM_OP( xori, x22, x27, 0xfffffbffffffffdf, -0x40000000001, 0x20, x2, 88, x3)

inst_12:
// rs1==x18, rd==x1, imm_val == 64, rs1_val == 1073741824
// opcode: xori ; op1:x18; dest:x1; op1val:0x40000000;  immval:0x40
TEST_IMM_OP( xori, x1, x18, 0x40000040, 0x40000000, 0x40, x2, 96, x3)

inst_13:
// rs1==x7, rd==x26, imm_val == 128, rs1_val == -2049
// opcode: xori ; op1:x7; dest:x26; op1val:-0x801;  immval:0x80
TEST_IMM_OP( xori, x26, x7, 0xfffffffffffff77f, -0x801, 0x80, x2, 104, x3)

inst_14:
// rs1==x30, rd==x20, imm_val == 256, rs1_val == -70368744177665
// opcode: xori ; op1:x30; dest:x20; op1val:-0x400000000001;  immval:0x100
TEST_IMM_OP( xori, x20, x30, 0xffffbffffffffeff, -0x400000000001, 0x100, x2, 112, x3)

inst_15:
// rs1==x6, rd==x11, imm_val == 512, rs1_val == 34359738368
// opcode: xori ; op1:x6; dest:x11; op1val:0x800000000;  immval:0x200
TEST_IMM_OP( xori, x11, x6, 0x800000200, 0x800000000, 0x200, x2, 120, x3)

inst_16:
// rs1==x10, rd==x29, imm_val == 1024, 
// opcode: xori ; op1:x10; dest:x29; op1val:-0xb504f332;  immval:0x400
TEST_IMM_OP( xori, x29, x10, 0xffffffff4afb08ce, -0xb504f332, 0x400, x2, 128, x3)

inst_17:
// rs1==x21, rd==x10, imm_val == -2, rs1_val == -67108865
// opcode: xori ; op1:x21; dest:x10; op1val:-0x4000001;  immval:-0x2
TEST_IMM_OP( xori, x10, x21, 0x4000001, -0x4000001, -0x2, x2, 136, x3)

inst_18:
// rs1==x24, rd==x28, imm_val == -3, rs1_val == 2251799813685248
// opcode: xori ; op1:x24; dest:x28; op1val:0x8000000000000;  immval:-0x3
TEST_IMM_OP( xori, x28, x24, 0xfff7fffffffffffd, 0x8000000000000, -0x3, x2, 144, x3)

inst_19:
// rs1==x5, rd==x27, imm_val == -5, rs1_val == -2
// opcode: xori ; op1:x5; dest:x27; op1val:-0x2;  immval:-0x5
TEST_IMM_OP( xori, x27, x5, 0x5, -0x2, -0x5, x2, 152, x6)
RVTEST_SIGBASE( x4,signature_x4_0)

inst_20:
// rs1==x1, rd==x16, imm_val == -17, 
// opcode: xori ; op1:x1; dest:x16; op1val:0x5;  immval:-0x11
TEST_IMM_OP( xori, x16, x1, 0xffffffffffffffea, 0x5, -0x11, x4, 0, x6)

inst_21:
// rs1==x19, rd==x17, imm_val == -33, 
// opcode: xori ; op1:x19; dest:x17; op1val:-0x400000000001;  immval:-0x21
TEST_IMM_OP( xori, x17, x19, 0x400000000020, -0x400000000001, -0x21, x4, 8, x6)

inst_22:
// rs1==x0, rd==x5, imm_val == -65, rs1_val == -8589934593
// opcode: xori ; op1:x0; dest:x5; op1val:0x0;  immval:-0x41
TEST_IMM_OP( xori, x5, x0, 0xffffffffffffffbf, 0x0, -0x41, x4, 16, x6)

inst_23:
// rs1==x3, rd==x25, imm_val == -129, rs1_val == 2305843009213693952
// opcode: xori ; op1:x3; dest:x25; op1val:0x2000000000000000;  immval:-0x81
TEST_IMM_OP( xori, x25, x3, 0xdfffffffffffff7f, 0x2000000000000000, -0x81, x4, 24, x6)

inst_24:
// rs1==x31, rd==x8, imm_val == -257, rs1_val == -2147483649
// opcode: xori ; op1:x31; dest:x8; op1val:-0x80000001;  immval:-0x101
TEST_IMM_OP( xori, x8, x31, 0x80000100, -0x80000001, -0x101, x4, 32, x6)

inst_25:
// rs1==x14, rd==x24, imm_val == -513, 
// opcode: xori ; op1:x14; dest:x24; op1val:0x3333333333333334;  immval:-0x201
TEST_IMM_OP( xori, x24, x14, 0xcccccccccccccecb, 0x3333333333333334, -0x201, x4, 40, x6)

inst_26:
// rs1==x2, rd==x18, imm_val == -1025, rs1_val == -2251799813685249
// opcode: xori ; op1:x2; dest:x18; op1val:-0x8000000000001;  immval:-0x401
TEST_IMM_OP( xori, x18, x2, 0x8000000000400, -0x8000000000001, -0x401, x4, 48, x6)

inst_27:
// rs1==x8, rd==x30, imm_val == 1365, 
// opcode: xori ; op1:x8; dest:x30; op1val:-0x400000000001;  immval:0x555
TEST_IMM_OP( xori, x30, x8, 0xffffbffffffffaaa, -0x400000000001, 0x555, x4, 56, x6)

inst_28:
// rs1==x15, rd==x3, imm_val == -1366, rs1_val == 17179869184
// opcode: xori ; op1:x15; dest:x3; op1val:0x400000000;  immval:-0x556
TEST_IMM_OP( xori, x3, x15, 0xfffffffbfffffaaa, 0x400000000, -0x556, x4, 64, x6)

inst_29:
// rs1==x20, rd==x2, rs1_val == 2, 
// opcode: xori ; op1:x20; dest:x2; op1val:0x2;  immval:-0x201
TEST_IMM_OP( xori, x2, x20, 0xfffffffffffffdfd, 0x2, -0x201, x4, 72, x6)

inst_30:
// rs1==x26, rd==x0, rs1_val == 8, 
// opcode: xori ; op1:x26; dest:x0; op1val:0x8;  immval:0x1
TEST_IMM_OP( xori, x0, x26, 0, 0x8, 0x1, x4, 80, x6)

inst_31:
// rs1==x23, rd==x7, rs1_val == 16, 
// opcode: xori ; op1:x23; dest:x7; op1val:0x10;  immval:-0x41
TEST_IMM_OP( xori, x7, x23, 0xffffffffffffffaf, 0x10, -0x41, x4, 88, x6)

inst_32:
// rs1_val == 32, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x20;  immval:-0x81
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffff5f, 0x20, -0x81, x4, 96, x6)

inst_33:
// rs1_val == 64, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x40;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x626, 0x40, 0x666, x4, 104, x6)

inst_34:
// rs1_val == 128, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x80;  immval:-0x400
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffc80, 0x80, -0x400, x4, 112, x6)

inst_35:
// rs1_val == 256, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x100;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x102, 0x100, 0x2, x4, 120, x6)

inst_36:
// rs1_val == 512, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x200;  immval:-0x9
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffdf7, 0x200, -0x9, x4, 128, x6)

inst_37:
// rs1_val == 1024, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x400;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x266, 0x400, 0x666, x4, 136, x6)

inst_38:
// rs1_val == 2048, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x800;  immval:0x40
TEST_IMM_OP( xori, x11, x10, 0x840, 0x800, 0x40, x4, 144, x6)

inst_39:
// rs1_val == 4096, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x1000;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x1555, 0x1000, 0x555, x4, 152, x6)

inst_40:
// rs1_val == 8192, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2000;  immval:-0xa
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffdff6, 0x2000, -0xa, x4, 160, x6)

inst_41:
// rs1_val == 16384, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4000;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x4556, 0x4000, 0x556, x4, 168, x6)

inst_42:
// rs1_val == 65536, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x10000;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x1002c, 0x10000, 0x2c, x4, 176, x6)

inst_43:
// rs1_val == 131072, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x20000;  immval:-0x2
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffdfffe, 0x20000, -0x2, x4, 184, x6)

inst_44:
// rs1_val == 262144, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x40000;  immval:0x7
TEST_IMM_OP( xori, x11, x10, 0x40007, 0x40000, 0x7, x4, 192, x6)

inst_45:
// rs1_val == 524288, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x80000;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x80334, 0x80000, 0x334, x4, 200, x6)

inst_46:
// rs1_val == 1048576, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x100000;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x100004, 0x100000, 0x4, x4, 208, x6)

inst_47:
// rs1_val == 2097152, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x200000;  immval:-0x5
TEST_IMM_OP( xori, x11, x10, 0xffffffffffdffffb, 0x200000, -0x5, x4, 216, x6)

inst_48:
// rs1_val == 4194304, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x400000;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x400000, 0x400000, 0x0, x4, 224, x6)

inst_49:
// rs1_val == 8388608, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x800000;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x800334, 0x800000, 0x334, x4, 232, x6)

inst_50:
// rs1_val == 16777216, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x1000000;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x1000004, 0x1000000, 0x4, x4, 240, x6)

inst_51:
// rs1_val == 33554432, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2000000;  immval:0x10
TEST_IMM_OP( xori, x11, x10, 0x2000010, 0x2000000, 0x10, x4, 248, x6)

inst_52:
// rs1_val == 67108864, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4000000;  immval:-0x401
TEST_IMM_OP( xori, x11, x10, 0xfffffffffbfffbff, 0x4000000, -0x401, x4, 256, x6)

inst_53:
// rs1_val == 134217728, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x8000000;  immval:0x9
TEST_IMM_OP( xori, x11, x10, 0x8000009, 0x8000000, 0x9, x4, 264, x6)

inst_54:
// rs1_val == 268435456, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x10000000;  immval:-0x201
TEST_IMM_OP( xori, x11, x10, 0xffffffffeffffdff, 0x10000000, -0x201, x4, 272, x6)

inst_55:
// rs1_val == 536870912, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x20000000;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x20000555, 0x20000000, 0x555, x4, 280, x6)

inst_56:
// rs1_val == 2147483648, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x80000000;  immval:-0x41
TEST_IMM_OP( xori, x11, x10, 0xffffffff7fffffbf, 0x80000000, -0x41, x4, 288, x6)

inst_57:
// rs1_val == 4294967296, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x100000000;  immval:-0x201
TEST_IMM_OP( xori, x11, x10, 0xfffffffefffffdff, 0x100000000, -0x201, x4, 296, x6)

inst_58:
// rs1_val == 8589934592, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x200000000;  immval:-0x81
TEST_IMM_OP( xori, x11, x10, 0xfffffffdffffff7f, 0x200000000, -0x81, x4, 304, x6)

inst_59:
// rs1_val == 68719476736, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x1000000000;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x1000000004, 0x1000000000, 0x4, x4, 312, x6)

inst_60:
// rs1_val == 137438953472, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2000000000;  immval:0x8
TEST_IMM_OP( xori, x11, x10, 0x2000000008, 0x2000000000, 0x8, x4, 320, x6)

inst_61:
// rs1_val == 274877906944, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4000000000;  immval:-0x41
TEST_IMM_OP( xori, x11, x10, 0xffffffbfffffffbf, 0x4000000000, -0x41, x4, 328, x6)

inst_62:
// rs1_val == 549755813888, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x8000000000;  immval:0x40
TEST_IMM_OP( xori, x11, x10, 0x8000000040, 0x8000000000, 0x40, x4, 336, x6)

inst_63:
// rs1_val == 1099511627776, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x10000000000;  immval:0x10
TEST_IMM_OP( xori, x11, x10, 0x10000000010, 0x10000000000, 0x10, x4, 344, x6)

inst_64:
// rs1_val == 2199023255552, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x20000000000;  immval:0x400
TEST_IMM_OP( xori, x11, x10, 0x20000000400, 0x20000000000, 0x400, x4, 352, x6)

inst_65:
// rs1_val == 4398046511104, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x40000000000;  immval:0x7
TEST_IMM_OP( xori, x11, x10, 0x40000000007, 0x40000000000, 0x7, x4, 360, x6)

inst_66:
// rs1_val == 8796093022208, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x80000000000;  immval:0x1
TEST_IMM_OP( xori, x11, x10, 0x80000000001, 0x80000000000, 0x1, x4, 368, x6)

inst_67:
// rs1_val == 17592186044416, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x100000000000;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x10000000002e, 0x100000000000, 0x2e, x4, 376, x6)

inst_68:
// rs1_val == 35184372088832, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x200000000000;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x200000000004, 0x200000000000, 0x4, x4, 384, x6)

inst_69:
// rs1_val == 70368744177664, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x400000000000;  immval:0x200
TEST_IMM_OP( xori, x11, x10, 0x400000000200, 0x400000000000, 0x200, x4, 392, x6)

inst_70:
// rs1_val == 140737488355328, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x800000000000;  immval:-0x1
TEST_IMM_OP( xori, x11, x10, 0xffff7fffffffffff, 0x800000000000, -0x1, x4, 400, x6)

inst_71:
// rs1_val == 281474976710656, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x1000000000000;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x1000000000000, 0x1000000000000, 0x0, x4, 408, x6)

inst_72:
// rs1_val == 562949953421312, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2000000000000;  immval:0x7
TEST_IMM_OP( xori, x11, x10, 0x2000000000007, 0x2000000000000, 0x7, x4, 416, x6)

inst_73:
// rs1_val == 1125899906842624, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4000000000000;  immval:-0x3
TEST_IMM_OP( xori, x11, x10, 0xfffbfffffffffffd, 0x4000000000000, -0x3, x4, 424, x6)

inst_74:
// rs1_val == 4503599627370496, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x10000000000000;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x10000000000000, 0x10000000000000, 0x0, x4, 432, x6)

inst_75:
// rs1_val == 9007199254740992, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x20000000000000;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x20000000000006, 0x20000000000000, 0x6, x4, 440, x6)

inst_76:
// rs1_val == 18014398509481984, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x40000000000000;  immval:0x9
TEST_IMM_OP( xori, x11, x10, 0x40000000000009, 0x40000000000000, 0x9, x4, 448, x6)

inst_77:
// rs1_val == 36028797018963968, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x80000000000000;  immval:0x10
TEST_IMM_OP( xori, x11, x10, 0x80000000000010, 0x80000000000000, 0x10, x4, 456, x6)

inst_78:
// rs1_val == 72057594037927936, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x100000000000000;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x100000000000555, 0x100000000000000, 0x555, x4, 464, x6)

inst_79:
// rs1_val == 144115188075855872, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x200000000000000;  immval:-0x3
TEST_IMM_OP( xori, x11, x10, 0xfdfffffffffffffd, 0x200000000000000, -0x3, x4, 472, x6)

inst_80:
// rs1_val == 288230376151711744, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x400000000000000;  immval:-0x41
TEST_IMM_OP( xori, x11, x10, 0xfbffffffffffffbf, 0x400000000000000, -0x41, x4, 480, x6)

inst_81:
// rs1_val == 576460752303423488, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x800000000000000;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x800000000000000, 0x800000000000000, 0x0, x4, 488, x6)

inst_82:
// rs1_val == 1152921504606846976, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x1000000000000000;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x1000000000000002, 0x1000000000000000, 0x2, x4, 496, x6)

inst_83:
// rs1_val == 4611686018427387904, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4000000000000000;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x4000000000000333, 0x4000000000000000, 0x333, x4, 504, x6)

inst_84:
// rs1_val == -3, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x3;  immval:0x8
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffff5, -0x3, 0x8, x4, 512, x6)

inst_85:
// rs1_val == -5, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffff9, -0x5, 0x2, x4, 520, x6)

inst_86:
// rs1_val == -9, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x9;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffff4, -0x9, 0x3, x4, 528, x6)

inst_87:
// rs1_val == -17, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x11;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffc2, -0x11, 0x2d, x4, 536, x6)

inst_88:
// rs1_val == -33, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x21;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffff3, -0x21, 0x2c, x4, 544, x6)

inst_89:
// rs1_val == -65, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x41;  immval:-0x6
TEST_IMM_OP( xori, x11, x10, 0x45, -0x41, -0x6, x4, 552, x6)

inst_90:
// rs1_val == -129, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x81;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffff7c, -0x81, 0x3, x4, 560, x6)

inst_91:
// rs1_val == -513, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x201;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffdff, -0x201, 0x0, x4, 568, x6)

inst_92:
// rs1_val == -1025, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x401;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffea9, -0x401, 0x556, x4, 576, x6)

inst_93:
// rs1_val == -4097, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x1001;  immval:-0x5
TEST_IMM_OP( xori, x11, x10, 0x1004, -0x1001, -0x5, x4, 584, x6)

inst_94:
// rs1_val == -8193, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x2001;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x202b, -0x2001, -0x2c, x4, 592, x6)

inst_95:
// rs1_val == -16385, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x4001;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffbaa9, -0x4001, 0x556, x4, 600, x6)

inst_96:
// rs1_val == -32769, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x8001;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xffffffffffff7ffa, -0x8001, 0x5, x4, 608, x6)

inst_97:
// rs1_val == -65537, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x10001;  immval:0x8
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffefff7, -0x10001, 0x8, x4, 616, x6)

inst_98:
// rs1_val == -131073, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x20001;  immval:0x200
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffdfdff, -0x20001, 0x200, x4, 624, x6)

inst_99:
// rs1_val == -262145, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x40001;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffbfaab, -0x40001, 0x554, x4, 632, x6)

inst_100:
// rs1_val == -524289, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x80001;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xfffffffffff7fffd, -0x80001, 0x2, x4, 640, x6)

inst_101:
// rs1_val == -1048577, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x100001;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0x100554, -0x100001, -0x555, x4, 648, x6)

inst_102:
// rs1_val == -2097153, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x200001;  immval:-0x11
TEST_IMM_OP( xori, x11, x10, 0x200010, -0x200001, -0x11, x4, 656, x6)

inst_103:
// rs1_val == -4194305, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x400001;  immval:0x40
TEST_IMM_OP( xori, x11, x10, 0xffffffffffbfffbf, -0x400001, 0x40, x4, 664, x6)

inst_104:
// rs1_val == -8388609, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x800001;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xffffffffff7ffffc, -0x800001, 0x3, x4, 672, x6)

inst_105:
// rs1_val == -16777217, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x1000001;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x100002b, -0x1000001, -0x2c, x4, 680, x6)

inst_106:
// rs1_val == -33554433, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x2000001;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x200002b, -0x2000001, -0x2c, x4, 688, x6)

inst_107:
// rs1_val == -268435457, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x10000001;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xffffffffeffffaa9, -0x10000001, 0x556, x4, 696, x6)

inst_108:
// rs1_val == -536870913, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x20000001;  immval:-0x41
TEST_IMM_OP( xori, x11, x10, 0x20000040, -0x20000001, -0x41, x4, 704, x6)

inst_109:
// rs1_val == -1073741825, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x40000001;  immval:-0x4
TEST_IMM_OP( xori, x11, x10, 0x40000003, -0x40000001, -0x4, x4, 712, x6)

inst_110:
// rs1_val == -4294967297, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x100000001;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xfffffffefffffccd, -0x100000001, 0x332, x4, 720, x6)

inst_111:
// rs1_val == -17179869185, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x400000001;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0x400000555, -0x400000001, -0x556, x4, 728, x6)

inst_112:
// rs1_val == -34359738369, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x800000001;  immval:-0x6
TEST_IMM_OP( xori, x11, x10, 0x800000005, -0x800000001, -0x6, x4, 736, x6)

inst_113:
// rs1_val == -68719476737, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x1000000001;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x100000002b, -0x1000000001, -0x2c, x4, 744, x6)

inst_114:
// rs1_val == -137438953473, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x2000000001;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xffffffdffffffaaa, -0x2000000001, 0x555, x4, 752, x6)

inst_115:
// rs1_val == -274877906945, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x4000000001;  immval:0x100
TEST_IMM_OP( xori, x11, x10, 0xffffffbffffffeff, -0x4000000001, 0x100, x4, 760, x6)

inst_116:
// rs1_val == -549755813889, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x8000000001;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffff7fffffffd3, -0x8000000001, 0x2c, x4, 768, x6)

inst_117:
// rs1_val == -1099511627777, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x10000000001;  immval:0x80
TEST_IMM_OP( xori, x11, x10, 0xfffffeffffffff7f, -0x10000000001, 0x80, x4, 776, x6)

inst_118:
// rs1_val == -2199023255553, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x20000000001;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xfffffdffffffffff, -0x20000000001, 0x0, x4, 784, x6)

inst_119:
// rs1_val == -8796093022209, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x80000000001;  immval:0x1
TEST_IMM_OP( xori, x11, x10, 0xfffff7fffffffffe, -0x80000000001, 0x1, x4, 792, x6)

inst_120:
// rs1_val == -17592186044417, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x100000000001;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xffffeffffffffff9, -0x100000000001, 0x6, x4, 800, x6)

inst_121:
// rs1_val == -35184372088833, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x200000000001;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xffffdffffffffffd, -0x200000000001, 0x2, x4, 808, x6)

inst_122:
// rs1_val == -140737488355329, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x800000000001;  immval:-0x800
TEST_IMM_OP( xori, x11, x10, 0x8000000007ff, -0x800000000001, -0x800, x4, 816, x6)

inst_123:
// rs1_val == -281474976710657, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x1000000000001;  immval:0x20
TEST_IMM_OP( xori, x11, x10, 0xfffeffffffffffdf, -0x1000000000001, 0x20, x4, 824, x6)

inst_124:
// rs1_val == -562949953421313, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x2000000000001;  immval:0x40
TEST_IMM_OP( xori, x11, x10, 0xfffdffffffffffbf, -0x2000000000001, 0x40, x4, 832, x6)

inst_125:
// rs1_val == -1125899906842625, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x4000000000001;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xfffbffffffffffff, -0x4000000000001, 0x0, x4, 840, x6)

inst_126:
// rs1_val == -4503599627370497, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x10000000000001;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xffeffffffffffff9, -0x10000000000001, 0x6, x4, 848, x6)

inst_127:
// rs1_val == -9007199254740993, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x20000000000001;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xffdffffffffffffb, -0x20000000000001, 0x4, x4, 856, x6)

inst_128:
// rs1_val == -18014398509481985, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x40000000000001;  immval:0x200
TEST_IMM_OP( xori, x11, x10, 0xffbffffffffffdff, -0x40000000000001, 0x200, x4, 864, x6)

inst_129:
// rs1_val == -36028797018963969, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x80000000000001;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xff7fffffffffffff, -0x80000000000001, 0x0, x4, 872, x6)

inst_130:
// rs1_val == -72057594037927937, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x100000000000001;  immval:0x7ff
TEST_IMM_OP( xori, x11, x10, 0xfefffffffffff800, -0x100000000000001, 0x7ff, x4, 880, x6)

inst_131:
// rs1_val == -144115188075855873, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x200000000000001;  immval:-0x41
TEST_IMM_OP( xori, x11, x10, 0x200000000000040, -0x200000000000001, -0x41, x4, 888, x6)

inst_132:
// rs1_val == -288230376151711745, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x400000000000001;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xfbfffffffffffffb, -0x400000000000001, 0x4, x4, 896, x6)

inst_133:
// rs1_val == -576460752303423489, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x800000000000001;  immval:-0xa
TEST_IMM_OP( xori, x11, x10, 0x800000000000009, -0x800000000000001, -0xa, x4, 904, x6)

inst_134:
// rs1_val == -1152921504606846977, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x1000000000000001;  immval:-0x21
TEST_IMM_OP( xori, x11, x10, 0x1000000000000020, -0x1000000000000001, -0x21, x4, 912, x6)

inst_135:
// rs1_val == -2305843009213693953, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x2000000000000001;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xdffffffffffffaab, -0x2000000000000001, 0x554, x4, 920, x6)

inst_136:
// rs1_val == -4611686018427387905, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x4000000000000001;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xbfffffffffffffff, -0x4000000000000001, 0x0, x4, 928, x6)

inst_137:
// rs1_val == 6148914691236517205, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x7
TEST_IMM_OP( xori, x11, x10, 0x5555555555555552, 0x5555555555555555, 0x7, x4, 936, x6)

inst_138:
// rs1_val == -6148914691236517206, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x21
TEST_IMM_OP( xori, x11, x10, 0x5555555555555575, -0x5555555555555556, -0x21, x4, 944, x6)

inst_139:
// rs1_val==3 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x0, 0x3, 0x3, x4, 952, x6)

inst_140:
// rs1_val==3 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x556, 0x3, 0x555, x4, 960, x6)

inst_141:
// rs1_val==3 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaa9, 0x3, -0x556, x4, 968, x6)

inst_142:
// rs1_val==3 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x6, 0x3, 0x5, x4, 976, x6)

inst_143:
// rs1_val==3 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x330, 0x3, 0x333, x4, 984, x6)

inst_144:
// rs1_val==3 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x665, 0x3, 0x666, x4, 992, x6)

inst_145:
// rs1_val==3 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd0, 0x3, -0x2d, x4, 1000, x6)

inst_146:
// rs1_val==3 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x2e, 0x3, 0x2d, x4, 1008, x6)

inst_147:
// rs1_val==3 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x1, 0x3, 0x2, x4, 1016, x6)

inst_148:
// rs1_val==3 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x557, 0x3, 0x554, x4, 1024, x6)

inst_149:
// rs1_val==3 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x3, 0x3, 0x0, x4, 1032, x6)

inst_150:
// rs1_val==3 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x7, 0x3, 0x4, x4, 1040, x6)

inst_151:
// rs1_val==3 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x331, 0x3, 0x332, x4, 1048, x6)

inst_152:
// rs1_val==3 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x666, 0x3, 0x665, x4, 1056, x6)

inst_153:
// rs1_val==3 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x2f, 0x3, 0x2c, x4, 1064, x6)

inst_154:
// rs1_val==3 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x555, 0x3, 0x556, x4, 1072, x6)

inst_155:
// rs1_val==3 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaa8, 0x3, -0x555, x4, 1080, x6)

inst_156:
// rs1_val==3 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x5, 0x3, 0x6, x4, 1088, x6)

inst_157:
// rs1_val==3 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x337, 0x3, 0x334, x4, 1096, x6)

inst_158:
// rs1_val==3 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x664, 0x3, 0x667, x4, 1104, x6)

inst_159:
// rs1_val==3 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd7, 0x3, -0x2c, x4, 1112, x6)

inst_160:
// rs1_val==3 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x2d, 0x3, 0x2e, x4, 1120, x6)

inst_161:
// rs1_val==6148914691236517205 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x5555555555555556, 0x5555555555555555, 0x3, x4, 1128, x6)

inst_162:
// rs1_val==6148914691236517205 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x5555555555555000, 0x5555555555555555, 0x555, x4, 1136, x6)

inst_163:
// rs1_val==6148914691236517205 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaafff, 0x5555555555555555, -0x556, x4, 1144, x6)

inst_164:
// rs1_val==6148914691236517205 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x5555555555555550, 0x5555555555555555, 0x5, x4, 1152, x6)

inst_165:
// rs1_val==6148914691236517205 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x5555555555555666, 0x5555555555555555, 0x333, x4, 1160, x6)

inst_166:
// rs1_val==6148914691236517205 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x5555555555555333, 0x5555555555555555, 0x666, x4, 1168, x6)

inst_167:
// rs1_val==6148914691236517205 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa86, 0x5555555555555555, -0x2d, x4, 1176, x6)

inst_168:
// rs1_val==6148914691236517205 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x5555555555555578, 0x5555555555555555, 0x2d, x4, 1184, x6)

inst_169:
// rs1_val==6148914691236517205 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x5555555555555557, 0x5555555555555555, 0x2, x4, 1192, x6)

inst_170:
// rs1_val==6148914691236517205 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x5555555555555001, 0x5555555555555555, 0x554, x4, 1200, x6)

inst_171:
// rs1_val==6148914691236517205 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x5555555555555555, 0x5555555555555555, 0x0, x4, 1208, x6)

inst_172:
// rs1_val==6148914691236517205 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x5555555555555551, 0x5555555555555555, 0x4, x4, 1216, x6)

inst_173:
// rs1_val==6148914691236517205 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x5555555555555667, 0x5555555555555555, 0x332, x4, 1224, x6)

inst_174:
// rs1_val==6148914691236517205 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x5555555555555330, 0x5555555555555555, 0x665, x4, 1232, x6)

inst_175:
// rs1_val==6148914691236517205 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x5555555555555579, 0x5555555555555555, 0x2c, x4, 1240, x6)

inst_176:
// rs1_val==6148914691236517205 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x5555555555555003, 0x5555555555555555, 0x556, x4, 1248, x6)

inst_177:
// rs1_val==6148914691236517205 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffe, 0x5555555555555555, -0x555, x4, 1256, x6)

inst_178:
// rs1_val==6148914691236517205 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x5555555555555553, 0x5555555555555555, 0x6, x4, 1264, x6)

inst_179:
// rs1_val==6148914691236517205 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x5555555555555661, 0x5555555555555555, 0x334, x4, 1272, x6)

inst_180:
// rs1_val==6148914691236517205 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x5555555555555332, 0x5555555555555555, 0x667, x4, 1280, x6)

inst_181:
// rs1_val==6148914691236517205 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa81, 0x5555555555555555, -0x2c, x4, 1288, x6)

inst_182:
// rs1_val==6148914691236517205 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555555;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x555555555555557b, 0x5555555555555555, 0x2e, x4, 1296, x6)

inst_183:
// rs1_val==-6148914691236517206 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaa9, -0x5555555555555556, 0x3, x4, 1304, x6)

inst_184:
// rs1_val==-6148914691236517206 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555556, 0x555, x4, 1312, x6)

inst_185:
// rs1_val==-6148914691236517206 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0x5555555555555000, -0x5555555555555556, -0x556, x4, 1320, x6)

inst_186:
// rs1_val==-6148914691236517206 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555556, 0x5, x4, 1328, x6)

inst_187:
// rs1_val==-6148914691236517206 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaa999, -0x5555555555555556, 0x333, x4, 1336, x6)

inst_188:
// rs1_val==-6148914691236517206 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaccc, -0x5555555555555556, 0x666, x4, 1344, x6)

inst_189:
// rs1_val==-6148914691236517206 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0x5555555555555579, -0x5555555555555556, -0x2d, x4, 1352, x6)

inst_190:
// rs1_val==-6148914691236517206 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa87, -0x5555555555555556, 0x2d, x4, 1360, x6)

inst_191:
// rs1_val==-6148914691236517206 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaa8, -0x5555555555555556, 0x2, x4, 1368, x6)

inst_192:
// rs1_val==-6148914691236517206 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffe, -0x5555555555555556, 0x554, x4, 1376, x6)

inst_193:
// rs1_val==-6148914691236517206 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaaa, -0x5555555555555556, 0x0, x4, 1384, x6)

inst_194:
// rs1_val==-6148914691236517206 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555556, 0x4, x4, 1392, x6)

inst_195:
// rs1_val==-6148914691236517206 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaa998, -0x5555555555555556, 0x332, x4, 1400, x6)

inst_196:
// rs1_val==-6148914691236517206 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaccf, -0x5555555555555556, 0x665, x4, 1408, x6)

inst_197:
// rs1_val==-6148914691236517206 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa86, -0x5555555555555556, 0x2c, x4, 1416, x6)

inst_198:
// rs1_val==-6148914691236517206 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffc, -0x5555555555555556, 0x556, x4, 1424, x6)

inst_199:
// rs1_val==-6148914691236517206 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0x5555555555555001, -0x5555555555555556, -0x555, x4, 1432, x6)

inst_200:
// rs1_val==-6148914691236517206 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaac, -0x5555555555555556, 0x6, x4, 1440, x6)

inst_201:
// rs1_val==-6148914691236517206 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaa99e, -0x5555555555555556, 0x334, x4, 1448, x6)

inst_202:
// rs1_val==-6148914691236517206 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaccd, -0x5555555555555556, 0x667, x4, 1456, x6)

inst_203:
// rs1_val==-6148914691236517206 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x555555555555557e, -0x5555555555555556, -0x2c, x4, 1464, x6)

inst_204:
// rs1_val==-6148914691236517206 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555556;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa84, -0x5555555555555556, 0x2e, x4, 1472, x6)

inst_205:
// rs1_val==5 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x6, 0x5, 0x3, x4, 1480, x6)

inst_206:
// rs1_val==5 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x550, 0x5, 0x555, x4, 1488, x6)

inst_207:
// rs1_val==5 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaaf, 0x5, -0x556, x4, 1496, x6)

inst_208:
// rs1_val==5 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x0, 0x5, 0x5, x4, 1504, x6)

inst_209:
// rs1_val==5 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x336, 0x5, 0x333, x4, 1512, x6)

inst_210:
// rs1_val==5 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x663, 0x5, 0x666, x4, 1520, x6)

inst_211:
// rs1_val==5 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd6, 0x5, -0x2d, x4, 1528, x6)

inst_212:
// rs1_val==5 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x28, 0x5, 0x2d, x4, 1536, x6)

inst_213:
// rs1_val==5 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x7, 0x5, 0x2, x4, 1544, x6)

inst_214:
// rs1_val==5 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x551, 0x5, 0x554, x4, 1552, x6)

inst_215:
// rs1_val==5 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x5, 0x5, 0x0, x4, 1560, x6)

inst_216:
// rs1_val==5 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x1, 0x5, 0x4, x4, 1568, x6)

inst_217:
// rs1_val==5 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x337, 0x5, 0x332, x4, 1576, x6)

inst_218:
// rs1_val==5 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x660, 0x5, 0x665, x4, 1584, x6)

inst_219:
// rs1_val==5 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x29, 0x5, 0x2c, x4, 1592, x6)

inst_220:
// rs1_val==5 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x553, 0x5, 0x556, x4, 1600, x6)

inst_221:
// rs1_val==5 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaae, 0x5, -0x555, x4, 1608, x6)

inst_222:
// rs1_val==5 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x3, 0x5, 0x6, x4, 1616, x6)

inst_223:
// rs1_val==5 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x331, 0x5, 0x334, x4, 1624, x6)

inst_224:
// rs1_val==5 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x662, 0x5, 0x667, x4, 1632, x6)

inst_225:
// rs1_val==5 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd1, 0x5, -0x2c, x4, 1640, x6)

inst_226:
// rs1_val==5 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x2b, 0x5, 0x2e, x4, 1648, x6)

inst_227:
// rs1_val==3689348814741910323 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x3333333333333330, 0x3333333333333333, 0x3, x4, 1656, x6)

inst_228:
// rs1_val==3689348814741910323 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x3333333333333666, 0x3333333333333333, 0x555, x4, 1664, x6)

inst_229:
// rs1_val==3689348814741910323 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xccccccccccccc999, 0x3333333333333333, -0x556, x4, 1672, x6)

inst_230:
// rs1_val==3689348814741910323 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x3333333333333336, 0x3333333333333333, 0x5, x4, 1680, x6)

inst_231:
// rs1_val==3689348814741910323 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x3333333333333000, 0x3333333333333333, 0x333, x4, 1688, x6)

inst_232:
// rs1_val==3689348814741910323 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x3333333333333555, 0x3333333333333333, 0x666, x4, 1696, x6)

inst_233:
// rs1_val==3689348814741910323 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xcccccccccccccce0, 0x3333333333333333, -0x2d, x4, 1704, x6)

inst_234:
// rs1_val==3689348814741910323 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x333333333333331e, 0x3333333333333333, 0x2d, x4, 1712, x6)

inst_235:
// rs1_val==3689348814741910323 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x3333333333333331, 0x3333333333333333, 0x2, x4, 1720, x6)

inst_236:
// rs1_val==3689348814741910323 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x3333333333333667, 0x3333333333333333, 0x554, x4, 1728, x6)

inst_237:
// rs1_val==3689348814741910323 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x3333333333333333, 0x3333333333333333, 0x0, x4, 1736, x6)

inst_238:
// rs1_val==3689348814741910323 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x3333333333333337, 0x3333333333333333, 0x4, x4, 1744, x6)

inst_239:
// rs1_val==3689348814741910323 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x3333333333333001, 0x3333333333333333, 0x332, x4, 1752, x6)

inst_240:
// rs1_val==3689348814741910323 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x3333333333333556, 0x3333333333333333, 0x665, x4, 1760, x6)

inst_241:
// rs1_val==3689348814741910323 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x333333333333331f, 0x3333333333333333, 0x2c, x4, 1768, x6)

inst_242:
// rs1_val==3689348814741910323 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x3333333333333665, 0x3333333333333333, 0x556, x4, 1776, x6)

inst_243:
// rs1_val==3689348814741910323 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xccccccccccccc998, 0x3333333333333333, -0x555, x4, 1784, x6)

inst_244:
// rs1_val==3689348814741910323 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x3333333333333335, 0x3333333333333333, 0x6, x4, 1792, x6)

inst_245:
// rs1_val==3689348814741910323 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x3333333333333007, 0x3333333333333333, 0x334, x4, 1800, x6)

inst_246:
// rs1_val==3689348814741910323 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x3333333333333554, 0x3333333333333333, 0x667, x4, 1808, x6)

inst_247:
// rs1_val==3689348814741910323 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xcccccccccccccce7, 0x3333333333333333, -0x2c, x4, 1816, x6)

inst_248:
// rs1_val==3689348814741910323 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333333;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x333333333333331d, 0x3333333333333333, 0x2e, x4, 1824, x6)

inst_249:
// rs1_val==7378697629483820646 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x6666666666666665, 0x6666666666666666, 0x3, x4, 1832, x6)

inst_250:
// rs1_val==7378697629483820646 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x6666666666666333, 0x6666666666666666, 0x555, x4, 1840, x6)

inst_251:
// rs1_val==7378697629483820646 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0x9999999999999ccc, 0x6666666666666666, -0x556, x4, 1848, x6)

inst_252:
// rs1_val==7378697629483820646 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x6666666666666663, 0x6666666666666666, 0x5, x4, 1856, x6)

inst_253:
// rs1_val==7378697629483820646 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x6666666666666555, 0x6666666666666666, 0x333, x4, 1864, x6)

inst_254:
// rs1_val==7378697629483820646 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x6666666666666000, 0x6666666666666666, 0x666, x4, 1872, x6)

inst_255:
// rs1_val==7378697629483820646 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0x99999999999999b5, 0x6666666666666666, -0x2d, x4, 1880, x6)

inst_256:
// rs1_val==7378697629483820646 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x666666666666664b, 0x6666666666666666, 0x2d, x4, 1888, x6)

inst_257:
// rs1_val==7378697629483820646 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x6666666666666664, 0x6666666666666666, 0x2, x4, 1896, x6)

inst_258:
// rs1_val==7378697629483820646 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x6666666666666332, 0x6666666666666666, 0x554, x4, 1904, x6)

inst_259:
// rs1_val==7378697629483820646 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x6666666666666666, 0x6666666666666666, 0x0, x4, 1912, x6)

inst_260:
// rs1_val==7378697629483820646 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x6666666666666662, 0x6666666666666666, 0x4, x4, 1920, x6)

inst_261:
// rs1_val==7378697629483820646 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x6666666666666554, 0x6666666666666666, 0x332, x4, 1928, x6)

inst_262:
// rs1_val==7378697629483820646 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x6666666666666003, 0x6666666666666666, 0x665, x4, 1936, x6)

inst_263:
// rs1_val==7378697629483820646 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x666666666666664a, 0x6666666666666666, 0x2c, x4, 1944, x6)

inst_264:
// rs1_val==7378697629483820646 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x6666666666666330, 0x6666666666666666, 0x556, x4, 1952, x6)

inst_265:
// rs1_val==7378697629483820646 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0x9999999999999ccd, 0x6666666666666666, -0x555, x4, 1960, x6)

inst_266:
// rs1_val==7378697629483820646 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x6666666666666660, 0x6666666666666666, 0x6, x4, 1968, x6)

inst_267:
// rs1_val==7378697629483820646 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x6666666666666552, 0x6666666666666666, 0x334, x4, 1976, x6)

inst_268:
// rs1_val==7378697629483820646 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x6666666666666001, 0x6666666666666666, 0x667, x4, 1984, x6)

inst_269:
// rs1_val==7378697629483820646 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x99999999999999b2, 0x6666666666666666, -0x2c, x4, 1992, x6)

inst_270:
// rs1_val==7378697629483820646 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666666;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x6666666666666648, 0x6666666666666666, 0x2e, x4, 2000, x6)

inst_271:
// rs1_val==-3037000499 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0cce, -0xb504f333, 0x3, x4, 2008, x6)

inst_272:
// rs1_val==-3037000499 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0998, -0xb504f333, 0x555, x4, 2016, x6)

inst_273:
// rs1_val==-3037000499 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xb504f667, -0xb504f333, -0x556, x4, 2024, x6)

inst_274:
// rs1_val==-3037000499 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0cc8, -0xb504f333, 0x5, x4, 2032, x6)

inst_275:
// rs1_val==-3037000499 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ffe, -0xb504f333, 0x333, x4, 2040, x6)
RVTEST_SIGBASE( x4,signature_x4_1)

inst_276:
// rs1_val==-3037000499 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0aab, -0xb504f333, 0x666, x4, 0, x6)

inst_277:
// rs1_val==-3037000499 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xb504f31e, -0xb504f333, -0x2d, x4, 8, x6)

inst_278:
// rs1_val==-3037000499 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce0, -0xb504f333, 0x2d, x4, 16, x6)

inst_279:
// rs1_val==-3037000499 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ccf, -0xb504f333, 0x2, x4, 24, x6)

inst_280:
// rs1_val==-3037000499 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0999, -0xb504f333, 0x554, x4, 32, x6)

inst_281:
// rs1_val==-3037000499 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ccd, -0xb504f333, 0x0, x4, 40, x6)

inst_282:
// rs1_val==-3037000499 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0cc9, -0xb504f333, 0x4, x4, 48, x6)

inst_283:
// rs1_val==-3037000499 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0fff, -0xb504f333, 0x332, x4, 56, x6)

inst_284:
// rs1_val==-3037000499 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0aa8, -0xb504f333, 0x665, x4, 64, x6)

inst_285:
// rs1_val==-3037000499 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce1, -0xb504f333, 0x2c, x4, 72, x6)

inst_286:
// rs1_val==-3037000499 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb099b, -0xb504f333, 0x556, x4, 80, x6)

inst_287:
// rs1_val==-3037000499 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xb504f666, -0xb504f333, -0x555, x4, 88, x6)

inst_288:
// rs1_val==-3037000499 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ccb, -0xb504f333, 0x6, x4, 96, x6)

inst_289:
// rs1_val==-3037000499 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ff9, -0xb504f333, 0x334, x4, 104, x6)

inst_290:
// rs1_val==-3037000499 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0aaa, -0xb504f333, 0x667, x4, 112, x6)

inst_291:
// rs1_val==-3037000499 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xb504f319, -0xb504f333, -0x2c, x4, 120, x6)

inst_292:
// rs1_val==-3037000499 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f333;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce3, -0xb504f333, 0x2e, x4, 128, x6)

inst_293:
// rs1_val==3037000499 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xb504f330, 0xb504f333, 0x3, x4, 136, x6)

inst_294:
// rs1_val==3037000499 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xb504f666, 0xb504f333, 0x555, x4, 144, x6)

inst_295:
// rs1_val==3037000499 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0999, 0xb504f333, -0x556, x4, 152, x6)

inst_296:
// rs1_val==3037000499 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xb504f336, 0xb504f333, 0x5, x4, 160, x6)

inst_297:
// rs1_val==3037000499 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0xb504f000, 0xb504f333, 0x333, x4, 168, x6)

inst_298:
// rs1_val==3037000499 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0xb504f555, 0xb504f333, 0x666, x4, 176, x6)

inst_299:
// rs1_val==3037000499 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce0, 0xb504f333, -0x2d, x4, 184, x6)

inst_300:
// rs1_val==3037000499 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xb504f31e, 0xb504f333, 0x2d, x4, 192, x6)

inst_301:
// rs1_val==3037000499 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xb504f331, 0xb504f333, 0x2, x4, 200, x6)

inst_302:
// rs1_val==3037000499 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xb504f667, 0xb504f333, 0x554, x4, 208, x6)

inst_303:
// rs1_val==3037000499 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xb504f333, 0xb504f333, 0x0, x4, 216, x6)

inst_304:
// rs1_val==3037000499 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xb504f337, 0xb504f333, 0x4, x4, 224, x6)

inst_305:
// rs1_val==3037000499 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xb504f001, 0xb504f333, 0x332, x4, 232, x6)

inst_306:
// rs1_val==3037000499 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0xb504f556, 0xb504f333, 0x665, x4, 240, x6)

inst_307:
// rs1_val==3037000499 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xb504f31f, 0xb504f333, 0x2c, x4, 248, x6)

inst_308:
// rs1_val==3037000499 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xb504f665, 0xb504f333, 0x556, x4, 256, x6)

inst_309:
// rs1_val==3037000499 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0998, 0xb504f333, -0x555, x4, 264, x6)

inst_310:
// rs1_val==3037000499 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xb504f335, 0xb504f333, 0x6, x4, 272, x6)

inst_311:
// rs1_val==3037000499 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0xb504f007, 0xb504f333, 0x334, x4, 280, x6)

inst_312:
// rs1_val==3037000499 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0xb504f554, 0xb504f333, 0x667, x4, 288, x6)

inst_313:
// rs1_val==3037000499 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce7, 0xb504f333, -0x2c, x4, 296, x6)

inst_314:
// rs1_val==3037000499 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f333;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0xb504f31d, 0xb504f333, 0x2e, x4, 304, x6)

inst_315:
// rs1_val==2 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x1, 0x2, 0x3, x4, 312, x6)

inst_316:
// rs1_val==2 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x557, 0x2, 0x555, x4, 320, x6)

inst_317:
// rs1_val==2 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaa8, 0x2, -0x556, x4, 328, x6)

inst_318:
// rs1_val==2 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x7, 0x2, 0x5, x4, 336, x6)

inst_319:
// rs1_val==2 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x331, 0x2, 0x333, x4, 344, x6)

inst_320:
// rs1_val==2 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x664, 0x2, 0x666, x4, 352, x6)

inst_321:
// rs1_val==2 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd1, 0x2, -0x2d, x4, 360, x6)

inst_322:
// rs1_val==2 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x2f, 0x2, 0x2d, x4, 368, x6)

inst_323:
// rs1_val==2 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x0, 0x2, 0x2, x4, 376, x6)

inst_324:
// rs1_val==2 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x556, 0x2, 0x554, x4, 384, x6)

inst_325:
// rs1_val==2 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x2, 0x2, 0x0, x4, 392, x6)

inst_326:
// rs1_val==2 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x6, 0x2, 0x4, x4, 400, x6)

inst_327:
// rs1_val==2 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x330, 0x2, 0x332, x4, 408, x6)

inst_328:
// rs1_val==2 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x667, 0x2, 0x665, x4, 416, x6)

inst_329:
// rs1_val==2 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x2e, 0x2, 0x2c, x4, 424, x6)

inst_330:
// rs1_val==2 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x554, 0x2, 0x556, x4, 432, x6)

inst_331:
// rs1_val==2 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaa9, 0x2, -0x555, x4, 440, x6)

inst_332:
// rs1_val==2 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x4, 0x2, 0x6, x4, 448, x6)

inst_333:
// rs1_val==2 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x336, 0x2, 0x334, x4, 456, x6)

inst_334:
// rs1_val==2 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x665, 0x2, 0x667, x4, 464, x6)

inst_335:
// rs1_val==2 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd6, 0x2, -0x2c, x4, 472, x6)

inst_336:
// rs1_val==2 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x2;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x2c, 0x2, 0x2e, x4, 480, x6)

inst_337:
// rs1_val==6148914691236517204 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x5555555555555557, 0x5555555555555554, 0x3, x4, 488, x6)

inst_338:
// rs1_val==6148914691236517204 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x5555555555555001, 0x5555555555555554, 0x555, x4, 496, x6)

inst_339:
// rs1_val==6148914691236517204 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffe, 0x5555555555555554, -0x556, x4, 504, x6)

inst_340:
// rs1_val==6148914691236517204 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x5555555555555551, 0x5555555555555554, 0x5, x4, 512, x6)

inst_341:
// rs1_val==6148914691236517204 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x5555555555555667, 0x5555555555555554, 0x333, x4, 520, x6)

inst_342:
// rs1_val==6148914691236517204 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x5555555555555332, 0x5555555555555554, 0x666, x4, 528, x6)

inst_343:
// rs1_val==6148914691236517204 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa87, 0x5555555555555554, -0x2d, x4, 536, x6)

inst_344:
// rs1_val==6148914691236517204 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x5555555555555579, 0x5555555555555554, 0x2d, x4, 544, x6)

inst_345:
// rs1_val==6148914691236517204 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x5555555555555556, 0x5555555555555554, 0x2, x4, 552, x6)

inst_346:
// rs1_val==6148914691236517204 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x5555555555555000, 0x5555555555555554, 0x554, x4, 560, x6)

inst_347:
// rs1_val==6148914691236517204 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x5555555555555554, 0x5555555555555554, 0x0, x4, 568, x6)

inst_348:
// rs1_val==6148914691236517204 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x5555555555555550, 0x5555555555555554, 0x4, x4, 576, x6)

inst_349:
// rs1_val==6148914691236517204 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x5555555555555666, 0x5555555555555554, 0x332, x4, 584, x6)

inst_350:
// rs1_val==6148914691236517204 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x5555555555555331, 0x5555555555555554, 0x665, x4, 592, x6)

inst_351:
// rs1_val==6148914691236517204 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x5555555555555578, 0x5555555555555554, 0x2c, x4, 600, x6)

inst_352:
// rs1_val==6148914691236517204 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x5555555555555002, 0x5555555555555554, 0x556, x4, 608, x6)

inst_353:
// rs1_val==6148914691236517204 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaafff, 0x5555555555555554, -0x555, x4, 616, x6)

inst_354:
// rs1_val==6148914691236517204 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x5555555555555552, 0x5555555555555554, 0x6, x4, 624, x6)

inst_355:
// rs1_val==6148914691236517204 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x5555555555555660, 0x5555555555555554, 0x334, x4, 632, x6)

inst_356:
// rs1_val==6148914691236517204 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x5555555555555333, 0x5555555555555554, 0x667, x4, 640, x6)

inst_357:
// rs1_val==6148914691236517204 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa80, 0x5555555555555554, -0x2c, x4, 648, x6)

inst_358:
// rs1_val==6148914691236517204 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555554;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x555555555555557a, 0x5555555555555554, 0x2e, x4, 656, x6)

inst_359:
// rs1_val==0 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x3, 0x0, 0x3, x4, 664, x6)

inst_360:
// rs1_val==0 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x555, 0x0, 0x555, x4, 672, x6)

inst_361:
// rs1_val==0 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaaa, 0x0, -0x556, x4, 680, x6)

inst_362:
// rs1_val==0 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x5, 0x0, 0x5, x4, 688, x6)

inst_363:
// rs1_val==0 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x333, 0x0, 0x333, x4, 696, x6)

inst_364:
// rs1_val==0 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x666, 0x0, 0x666, x4, 704, x6)

inst_365:
// rs1_val==0 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd3, 0x0, -0x2d, x4, 712, x6)

inst_366:
// rs1_val==0 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x2d, 0x0, 0x2d, x4, 720, x6)

inst_367:
// rs1_val==6148914691236517206 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x555555555555557a, 0x5555555555555556, 0x2c, x4, 728, x6)

inst_368:
// rs1_val==6148914691236517206 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x5555555555555000, 0x5555555555555556, 0x556, x4, 736, x6)

inst_369:
// rs1_val==6148914691236517206 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffd, 0x5555555555555556, -0x555, x4, 744, x6)

inst_370:
// rs1_val==6148914691236517206 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x5555555555555550, 0x5555555555555556, 0x6, x4, 752, x6)

inst_371:
// rs1_val==6148914691236517206 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x5555555555555662, 0x5555555555555556, 0x334, x4, 760, x6)

inst_372:
// rs1_val==6148914691236517206 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x5555555555555331, 0x5555555555555556, 0x667, x4, 768, x6)

inst_373:
// rs1_val==6148914691236517206 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa82, 0x5555555555555556, -0x2c, x4, 776, x6)

inst_374:
// rs1_val==6148914691236517206 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x5555555555555578, 0x5555555555555556, 0x2e, x4, 784, x6)

inst_375:
// rs1_val==-6148914691236517205 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaa8, -0x5555555555555555, 0x3, x4, 792, x6)

inst_376:
// rs1_val==-6148914691236517205 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffe, -0x5555555555555555, 0x555, x4, 800, x6)

inst_377:
// rs1_val==-6148914691236517205 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0x5555555555555001, -0x5555555555555555, -0x556, x4, 808, x6)

inst_378:
// rs1_val==-6148914691236517205 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaae, -0x5555555555555555, 0x5, x4, 816, x6)

inst_379:
// rs1_val==-6148914691236517205 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaa998, -0x5555555555555555, 0x333, x4, 824, x6)

inst_380:
// rs1_val==-6148914691236517205 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaccd, -0x5555555555555555, 0x666, x4, 832, x6)

inst_381:
// rs1_val==-6148914691236517205 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0x5555555555555578, -0x5555555555555555, -0x2d, x4, 840, x6)

inst_382:
// rs1_val==-6148914691236517205 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa86, -0x5555555555555555, 0x2d, x4, 848, x6)

inst_383:
// rs1_val==-6148914691236517205 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaa9, -0x5555555555555555, 0x2, x4, 856, x6)

inst_384:
// rs1_val==-6148914691236517205 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaafff, -0x5555555555555555, 0x554, x4, 864, x6)

inst_385:
// rs1_val==-6148914691236517205 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaab, -0x5555555555555555, 0x0, x4, 872, x6)

inst_386:
// rs1_val==-6148914691236517205 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaaf, -0x5555555555555555, 0x4, x4, 880, x6)

inst_387:
// rs1_val==-6148914691236517205 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaa999, -0x5555555555555555, 0x332, x4, 888, x6)

inst_388:
// rs1_val==-6148914691236517205 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaacce, -0x5555555555555555, 0x665, x4, 896, x6)

inst_389:
// rs1_val==-6148914691236517205 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa87, -0x5555555555555555, 0x2c, x4, 904, x6)

inst_390:
// rs1_val==-6148914691236517205 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffd, -0x5555555555555555, 0x556, x4, 912, x6)

inst_391:
// rs1_val==-6148914691236517205 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0x5555555555555000, -0x5555555555555555, -0x555, x4, 920, x6)

inst_392:
// rs1_val==-6148914691236517205 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaaad, -0x5555555555555555, 0x6, x4, 928, x6)

inst_393:
// rs1_val==-6148914691236517205 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaa99f, -0x5555555555555555, 0x334, x4, 936, x6)

inst_394:
// rs1_val==-6148914691236517205 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaccc, -0x5555555555555555, 0x667, x4, 944, x6)

inst_395:
// rs1_val==-6148914691236517205 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x555555555555557f, -0x5555555555555555, -0x2c, x4, 952, x6)

inst_396:
// rs1_val==-6148914691236517205 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0x5555555555555555;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa85, -0x5555555555555555, 0x2e, x4, 960, x6)

inst_397:
// rs1_val==6 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x5, 0x6, 0x3, x4, 968, x6)

inst_398:
// rs1_val==6 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x553, 0x6, 0x555, x4, 976, x6)

inst_399:
// rs1_val==6 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaac, 0x6, -0x556, x4, 984, x6)

inst_400:
// rs1_val==6 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x3, 0x6, 0x5, x4, 992, x6)

inst_401:
// rs1_val==6 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x335, 0x6, 0x333, x4, 1000, x6)

inst_402:
// rs1_val==6 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x660, 0x6, 0x666, x4, 1008, x6)

inst_403:
// rs1_val==6 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd5, 0x6, -0x2d, x4, 1016, x6)

inst_404:
// rs1_val==6 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x2b, 0x6, 0x2d, x4, 1024, x6)

inst_405:
// rs1_val==6 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x4, 0x6, 0x2, x4, 1032, x6)

inst_406:
// rs1_val==6 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x552, 0x6, 0x554, x4, 1040, x6)

inst_407:
// rs1_val==6 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x6, 0x6, 0x0, x4, 1048, x6)

inst_408:
// rs1_val==6 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x2, 0x6, 0x4, x4, 1056, x6)

inst_409:
// rs1_val==6 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x334, 0x6, 0x332, x4, 1064, x6)

inst_410:
// rs1_val==6 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x663, 0x6, 0x665, x4, 1072, x6)

inst_411:
// rs1_val==6 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x2a, 0x6, 0x2c, x4, 1080, x6)

inst_412:
// rs1_val==6 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x550, 0x6, 0x556, x4, 1088, x6)

inst_413:
// rs1_val==6 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaad, 0x6, -0x555, x4, 1096, x6)

inst_414:
// rs1_val==6 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x0, 0x6, 0x6, x4, 1104, x6)

inst_415:
// rs1_val==6 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x332, 0x6, 0x334, x4, 1112, x6)

inst_416:
// rs1_val==6 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x661, 0x6, 0x667, x4, 1120, x6)

inst_417:
// rs1_val==6 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd2, 0x6, -0x2c, x4, 1128, x6)

inst_418:
// rs1_val==6 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x28, 0x6, 0x2e, x4, 1136, x6)

inst_419:
// rs1_val==3689348814741910324 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x3333333333333337, 0x3333333333333334, 0x3, x4, 1144, x6)

inst_420:
// rs1_val==3689348814741910324 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x3333333333333661, 0x3333333333333334, 0x555, x4, 1152, x6)

inst_421:
// rs1_val==3689348814741910324 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xccccccccccccc99e, 0x3333333333333334, -0x556, x4, 1160, x6)

inst_422:
// rs1_val==3689348814741910324 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x3333333333333331, 0x3333333333333334, 0x5, x4, 1168, x6)

inst_423:
// rs1_val==3689348814741910324 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x3333333333333007, 0x3333333333333334, 0x333, x4, 1176, x6)

inst_424:
// rs1_val==3689348814741910324 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x3333333333333552, 0x3333333333333334, 0x666, x4, 1184, x6)

inst_425:
// rs1_val==3689348814741910324 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xcccccccccccccce7, 0x3333333333333334, -0x2d, x4, 1192, x6)

inst_426:
// rs1_val==3689348814741910324 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x3333333333333319, 0x3333333333333334, 0x2d, x4, 1200, x6)

inst_427:
// rs1_val==3689348814741910324 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x3333333333333336, 0x3333333333333334, 0x2, x4, 1208, x6)

inst_428:
// rs1_val==3689348814741910324 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x3333333333333660, 0x3333333333333334, 0x554, x4, 1216, x6)

inst_429:
// rs1_val==3689348814741910324 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x3333333333333334, 0x3333333333333334, 0x0, x4, 1224, x6)

inst_430:
// rs1_val==3689348814741910324 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x3333333333333330, 0x3333333333333334, 0x4, x4, 1232, x6)

inst_431:
// rs1_val==3689348814741910324 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x3333333333333006, 0x3333333333333334, 0x332, x4, 1240, x6)

inst_432:
// rs1_val==3689348814741910324 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x3333333333333551, 0x3333333333333334, 0x665, x4, 1248, x6)

inst_433:
// rs1_val==3689348814741910324 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x3333333333333318, 0x3333333333333334, 0x2c, x4, 1256, x6)

inst_434:
// rs1_val==3689348814741910324 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x3333333333333662, 0x3333333333333334, 0x556, x4, 1264, x6)

inst_435:
// rs1_val==3689348814741910324 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xccccccccccccc99f, 0x3333333333333334, -0x555, x4, 1272, x6)

inst_436:
// rs1_val==3689348814741910324 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x3333333333333332, 0x3333333333333334, 0x6, x4, 1280, x6)

inst_437:
// rs1_val==3689348814741910324 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x3333333333333000, 0x3333333333333334, 0x334, x4, 1288, x6)

inst_438:
// rs1_val==3689348814741910324 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x3333333333333553, 0x3333333333333334, 0x667, x4, 1296, x6)

inst_439:
// rs1_val==3689348814741910324 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xcccccccccccccce0, 0x3333333333333334, -0x2c, x4, 1304, x6)

inst_440:
// rs1_val==3689348814741910324 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333334;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x333333333333331a, 0x3333333333333334, 0x2e, x4, 1312, x6)

inst_441:
// rs1_val==7378697629483820647 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x6666666666666664, 0x6666666666666667, 0x3, x4, 1320, x6)

inst_442:
// rs1_val==7378697629483820647 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x6666666666666332, 0x6666666666666667, 0x555, x4, 1328, x6)

inst_443:
// rs1_val==7378697629483820647 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0x9999999999999ccd, 0x6666666666666667, -0x556, x4, 1336, x6)

inst_444:
// rs1_val==7378697629483820647 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x6666666666666662, 0x6666666666666667, 0x5, x4, 1344, x6)

inst_445:
// rs1_val==7378697629483820647 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x6666666666666554, 0x6666666666666667, 0x333, x4, 1352, x6)

inst_446:
// rs1_val==7378697629483820647 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x6666666666666001, 0x6666666666666667, 0x666, x4, 1360, x6)

inst_447:
// rs1_val==7378697629483820647 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0x99999999999999b4, 0x6666666666666667, -0x2d, x4, 1368, x6)

inst_448:
// rs1_val==7378697629483820647 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x666666666666664a, 0x6666666666666667, 0x2d, x4, 1376, x6)

inst_449:
// rs1_val==7378697629483820647 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x6666666666666665, 0x6666666666666667, 0x2, x4, 1384, x6)

inst_450:
// rs1_val==7378697629483820647 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x6666666666666333, 0x6666666666666667, 0x554, x4, 1392, x6)

inst_451:
// rs1_val==7378697629483820647 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x6666666666666667, 0x6666666666666667, 0x0, x4, 1400, x6)

inst_452:
// rs1_val==7378697629483820647 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x6666666666666663, 0x6666666666666667, 0x4, x4, 1408, x6)

inst_453:
// rs1_val==7378697629483820647 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x6666666666666555, 0x6666666666666667, 0x332, x4, 1416, x6)

inst_454:
// rs1_val==7378697629483820647 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x6666666666666002, 0x6666666666666667, 0x665, x4, 1424, x6)

inst_455:
// rs1_val==7378697629483820647 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x666666666666664b, 0x6666666666666667, 0x2c, x4, 1432, x6)

inst_456:
// rs1_val==7378697629483820647 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x6666666666666331, 0x6666666666666667, 0x556, x4, 1440, x6)

inst_457:
// rs1_val==7378697629483820647 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0x9999999999999ccc, 0x6666666666666667, -0x555, x4, 1448, x6)

inst_458:
// rs1_val==7378697629483820647 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x6666666666666661, 0x6666666666666667, 0x6, x4, 1456, x6)

inst_459:
// rs1_val==7378697629483820647 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x6666666666666553, 0x6666666666666667, 0x334, x4, 1464, x6)

inst_460:
// rs1_val==7378697629483820647 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x6666666666666000, 0x6666666666666667, 0x667, x4, 1472, x6)

inst_461:
// rs1_val==7378697629483820647 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x99999999999999b3, 0x6666666666666667, -0x2c, x4, 1480, x6)

inst_462:
// rs1_val==7378697629483820647 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666667;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x6666666666666649, 0x6666666666666667, 0x2e, x4, 1488, x6)

inst_463:
// rs1_val==-3037000498 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ccd, -0xb504f332, 0x3, x4, 1496, x6)

inst_464:
// rs1_val==-3037000498 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb099b, -0xb504f332, 0x555, x4, 1504, x6)

inst_465:
// rs1_val==-3037000498 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xb504f664, -0xb504f332, -0x556, x4, 1512, x6)

inst_466:
// rs1_val==-3037000498 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ccb, -0xb504f332, 0x5, x4, 1520, x6)

inst_467:
// rs1_val==-3037000498 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ffd, -0xb504f332, 0x333, x4, 1528, x6)

inst_468:
// rs1_val==-3037000498 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0aa8, -0xb504f332, 0x666, x4, 1536, x6)

inst_469:
// rs1_val==-3037000498 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xb504f31d, -0xb504f332, -0x2d, x4, 1544, x6)

inst_470:
// rs1_val==-3037000498 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce3, -0xb504f332, 0x2d, x4, 1552, x6)

inst_471:
// rs1_val==-3037000498 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ccc, -0xb504f332, 0x2, x4, 1560, x6)

inst_472:
// rs1_val==-3037000498 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb099a, -0xb504f332, 0x554, x4, 1568, x6)

inst_473:
// rs1_val==-3037000498 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0cce, -0xb504f332, 0x0, x4, 1576, x6)

inst_474:
// rs1_val==-3037000498 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0cca, -0xb504f332, 0x4, x4, 1584, x6)

inst_475:
// rs1_val==-3037000498 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ffc, -0xb504f332, 0x332, x4, 1592, x6)

inst_476:
// rs1_val==-3037000498 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0aab, -0xb504f332, 0x665, x4, 1600, x6)

inst_477:
// rs1_val==-3037000498 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce2, -0xb504f332, 0x2c, x4, 1608, x6)

inst_478:
// rs1_val==-3037000498 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0998, -0xb504f332, 0x556, x4, 1616, x6)

inst_479:
// rs1_val==-3037000498 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xb504f665, -0xb504f332, -0x555, x4, 1624, x6)

inst_480:
// rs1_val==-3037000498 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0cc8, -0xb504f332, 0x6, x4, 1632, x6)

inst_481:
// rs1_val==-3037000498 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ffa, -0xb504f332, 0x334, x4, 1640, x6)

inst_482:
// rs1_val==-3037000498 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0aa9, -0xb504f332, 0x667, x4, 1648, x6)

inst_483:
// rs1_val==-3037000498 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xb504f31a, -0xb504f332, -0x2c, x4, 1656, x6)

inst_484:
// rs1_val==-3037000498 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:-0xb504f332;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce0, -0xb504f332, 0x2e, x4, 1664, x6)

inst_485:
// rs1_val==3037000500 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xb504f337, 0xb504f334, 0x3, x4, 1672, x6)

inst_486:
// rs1_val==3037000500 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xb504f661, 0xb504f334, 0x555, x4, 1680, x6)

inst_487:
// rs1_val==3037000500 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb099e, 0xb504f334, -0x556, x4, 1688, x6)

inst_488:
// rs1_val==3037000500 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xb504f331, 0xb504f334, 0x5, x4, 1696, x6)

inst_489:
// rs1_val==3037000500 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0xb504f007, 0xb504f334, 0x333, x4, 1704, x6)

inst_490:
// rs1_val==3037000500 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0xb504f552, 0xb504f334, 0x666, x4, 1712, x6)

inst_491:
// rs1_val==3037000500 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce7, 0xb504f334, -0x2d, x4, 1720, x6)

inst_492:
// rs1_val==3037000500 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xb504f319, 0xb504f334, 0x2d, x4, 1728, x6)

inst_493:
// rs1_val==3037000500 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xb504f336, 0xb504f334, 0x2, x4, 1736, x6)

inst_494:
// rs1_val==3037000500 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xb504f660, 0xb504f334, 0x554, x4, 1744, x6)

inst_495:
// rs1_val==3037000500 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xb504f334, 0xb504f334, 0x0, x4, 1752, x6)

inst_496:
// rs1_val==3037000500 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xb504f330, 0xb504f334, 0x4, x4, 1760, x6)

inst_497:
// rs1_val==3037000500 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xb504f006, 0xb504f334, 0x332, x4, 1768, x6)

inst_498:
// rs1_val==3037000500 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0xb504f551, 0xb504f334, 0x665, x4, 1776, x6)

inst_499:
// rs1_val==3037000500 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xb504f318, 0xb504f334, 0x2c, x4, 1784, x6)

inst_500:
// rs1_val==3037000500 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xb504f662, 0xb504f334, 0x556, x4, 1792, x6)

inst_501:
// rs1_val==3037000500 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb099f, 0xb504f334, -0x555, x4, 1800, x6)

inst_502:
// rs1_val==3037000500 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xb504f332, 0xb504f334, 0x6, x4, 1808, x6)

inst_503:
// rs1_val==3037000500 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0xb504f000, 0xb504f334, 0x334, x4, 1816, x6)

inst_504:
// rs1_val==3037000500 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0xb504f553, 0xb504f334, 0x667, x4, 1824, x6)

inst_505:
// rs1_val==3037000500 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce0, 0xb504f334, -0x2c, x4, 1832, x6)

inst_506:
// rs1_val==3037000500 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f334;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0xb504f31a, 0xb504f334, 0x2e, x4, 1840, x6)

inst_507:
// rs1_val==0 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x2, 0x0, 0x2, x4, 1848, x6)

inst_508:
// rs1_val==0 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x554, 0x0, 0x554, x4, 1856, x6)

inst_509:
// rs1_val==0 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x4, 0x0, 0x4, x4, 1864, x6)

inst_510:
// rs1_val==0 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x332, 0x0, 0x332, x4, 1872, x6)

inst_511:
// rs1_val==0 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x665, 0x0, 0x665, x4, 1880, x6)

inst_512:
// rs1_val==0 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x2c, 0x0, 0x2c, x4, 1888, x6)

inst_513:
// rs1_val==0 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x556, 0x0, 0x556, x4, 1896, x6)

inst_514:
// rs1_val==0 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaab, 0x0, -0x555, x4, 1904, x6)

inst_515:
// rs1_val==0 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x6, 0x0, 0x6, x4, 1912, x6)

inst_516:
// rs1_val==0 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x334, 0x0, 0x334, x4, 1920, x6)

inst_517:
// rs1_val==0 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x667, 0x0, 0x667, x4, 1928, x6)

inst_518:
// rs1_val==0 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd4, 0x0, -0x2c, x4, 1936, x6)

inst_519:
// rs1_val==0 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x0;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x2e, 0x0, 0x2e, x4, 1944, x6)

inst_520:
// rs1_val==4 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x7, 0x4, 0x3, x4, 1952, x6)

inst_521:
// rs1_val==4 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x551, 0x4, 0x555, x4, 1960, x6)

inst_522:
// rs1_val==4 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaae, 0x4, -0x556, x4, 1968, x6)

inst_523:
// rs1_val==4 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x1, 0x4, 0x5, x4, 1976, x6)

inst_524:
// rs1_val==4 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x337, 0x4, 0x333, x4, 1984, x6)

inst_525:
// rs1_val==4 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x662, 0x4, 0x666, x4, 1992, x6)

inst_526:
// rs1_val==4 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd7, 0x4, -0x2d, x4, 2000, x6)

inst_527:
// rs1_val==4 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x29, 0x4, 0x2d, x4, 2008, x6)

inst_528:
// rs1_val==4 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x6, 0x4, 0x2, x4, 2016, x6)

inst_529:
// rs1_val==4 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x550, 0x4, 0x554, x4, 2024, x6)

inst_530:
// rs1_val==4 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x4, 0x4, 0x0, x4, 2032, x6)

inst_531:
// rs1_val==4 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x0, 0x4, 0x4, x4, 2040, x6)
RVTEST_SIGBASE( x4,signature_x4_2)

inst_532:
// rs1_val==4 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x336, 0x4, 0x332, x4, 0, x6)

inst_533:
// rs1_val==4 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x661, 0x4, 0x665, x4, 8, x6)

inst_534:
// rs1_val==4 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x28, 0x4, 0x2c, x4, 16, x6)

inst_535:
// rs1_val==4 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x552, 0x4, 0x556, x4, 24, x6)

inst_536:
// rs1_val==4 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xfffffffffffffaaf, 0x4, -0x555, x4, 32, x6)

inst_537:
// rs1_val==4 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x2, 0x4, 0x6, x4, 40, x6)

inst_538:
// rs1_val==4 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x330, 0x4, 0x334, x4, 48, x6)

inst_539:
// rs1_val==4 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x663, 0x4, 0x667, x4, 56, x6)

inst_540:
// rs1_val==4 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffffffffffd0, 0x4, -0x2c, x4, 64, x6)

inst_541:
// rs1_val==4 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x4;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x2a, 0x4, 0x2e, x4, 72, x6)

inst_542:
// rs1_val==3689348814741910322 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x3333333333333331, 0x3333333333333332, 0x3, x4, 80, x6)

inst_543:
// rs1_val==3689348814741910322 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x3333333333333667, 0x3333333333333332, 0x555, x4, 88, x6)

inst_544:
// rs1_val==3689348814741910322 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xccccccccccccc998, 0x3333333333333332, -0x556, x4, 96, x6)

inst_545:
// rs1_val==3689348814741910322 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x3333333333333337, 0x3333333333333332, 0x5, x4, 104, x6)

inst_546:
// rs1_val==3689348814741910322 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x3333333333333001, 0x3333333333333332, 0x333, x4, 112, x6)

inst_547:
// rs1_val==3689348814741910322 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x3333333333333554, 0x3333333333333332, 0x666, x4, 120, x6)

inst_548:
// rs1_val==3689348814741910322 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xcccccccccccccce1, 0x3333333333333332, -0x2d, x4, 128, x6)

inst_549:
// rs1_val==3689348814741910322 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x333333333333331f, 0x3333333333333332, 0x2d, x4, 136, x6)

inst_550:
// rs1_val==3689348814741910322 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x3333333333333330, 0x3333333333333332, 0x2, x4, 144, x6)

inst_551:
// rs1_val==3689348814741910322 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x3333333333333666, 0x3333333333333332, 0x554, x4, 152, x6)

inst_552:
// rs1_val==3689348814741910322 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x3333333333333332, 0x3333333333333332, 0x0, x4, 160, x6)

inst_553:
// rs1_val==3689348814741910322 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x3333333333333336, 0x3333333333333332, 0x4, x4, 168, x6)

inst_554:
// rs1_val==3689348814741910322 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x3333333333333000, 0x3333333333333332, 0x332, x4, 176, x6)

inst_555:
// rs1_val==3689348814741910322 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x3333333333333557, 0x3333333333333332, 0x665, x4, 184, x6)

inst_556:
// rs1_val==3689348814741910322 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x333333333333331e, 0x3333333333333332, 0x2c, x4, 192, x6)

inst_557:
// rs1_val==3689348814741910322 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x3333333333333664, 0x3333333333333332, 0x556, x4, 200, x6)

inst_558:
// rs1_val==3689348814741910322 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xccccccccccccc999, 0x3333333333333332, -0x555, x4, 208, x6)

inst_559:
// rs1_val==3689348814741910322 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x3333333333333334, 0x3333333333333332, 0x6, x4, 216, x6)

inst_560:
// rs1_val==3689348814741910322 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x3333333333333006, 0x3333333333333332, 0x334, x4, 224, x6)

inst_561:
// rs1_val==3689348814741910322 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x3333333333333555, 0x3333333333333332, 0x667, x4, 232, x6)

inst_562:
// rs1_val==3689348814741910322 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xcccccccccccccce6, 0x3333333333333332, -0x2c, x4, 240, x6)

inst_563:
// rs1_val==3689348814741910322 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x3333333333333332;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x333333333333331c, 0x3333333333333332, 0x2e, x4, 248, x6)

inst_564:
// rs1_val==7378697629483820645 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x6666666666666666, 0x6666666666666665, 0x3, x4, 256, x6)

inst_565:
// rs1_val==7378697629483820645 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x6666666666666330, 0x6666666666666665, 0x555, x4, 264, x6)

inst_566:
// rs1_val==7378697629483820645 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0x9999999999999ccf, 0x6666666666666665, -0x556, x4, 272, x6)

inst_567:
// rs1_val==7378697629483820645 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x6666666666666660, 0x6666666666666665, 0x5, x4, 280, x6)

inst_568:
// rs1_val==7378697629483820645 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x6666666666666556, 0x6666666666666665, 0x333, x4, 288, x6)

inst_569:
// rs1_val==7378697629483820645 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x6666666666666003, 0x6666666666666665, 0x666, x4, 296, x6)

inst_570:
// rs1_val==7378697629483820645 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0x99999999999999b6, 0x6666666666666665, -0x2d, x4, 304, x6)

inst_571:
// rs1_val==7378697629483820645 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x6666666666666648, 0x6666666666666665, 0x2d, x4, 312, x6)

inst_572:
// rs1_val==7378697629483820645 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x6666666666666667, 0x6666666666666665, 0x2, x4, 320, x6)

inst_573:
// rs1_val==7378697629483820645 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x6666666666666331, 0x6666666666666665, 0x554, x4, 328, x6)

inst_574:
// rs1_val==7378697629483820645 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x6666666666666665, 0x6666666666666665, 0x0, x4, 336, x6)

inst_575:
// rs1_val==7378697629483820645 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x6666666666666661, 0x6666666666666665, 0x4, x4, 344, x6)

inst_576:
// rs1_val==7378697629483820645 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x6666666666666557, 0x6666666666666665, 0x332, x4, 352, x6)

inst_577:
// rs1_val==7378697629483820645 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x6666666666666000, 0x6666666666666665, 0x665, x4, 360, x6)

inst_578:
// rs1_val==7378697629483820645 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0x6666666666666649, 0x6666666666666665, 0x2c, x4, 368, x6)

inst_579:
// rs1_val==7378697629483820645 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0x6666666666666333, 0x6666666666666665, 0x556, x4, 376, x6)

inst_580:
// rs1_val==7378697629483820645 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0x9999999999999cce, 0x6666666666666665, -0x555, x4, 384, x6)

inst_581:
// rs1_val==7378697629483820645 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0x6666666666666663, 0x6666666666666665, 0x6, x4, 392, x6)

inst_582:
// rs1_val==7378697629483820645 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0x6666666666666551, 0x6666666666666665, 0x334, x4, 400, x6)

inst_583:
// rs1_val==7378697629483820645 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0x6666666666666002, 0x6666666666666665, 0x667, x4, 408, x6)

inst_584:
// rs1_val==7378697629483820645 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0x99999999999999b1, 0x6666666666666665, -0x2c, x4, 416, x6)

inst_585:
// rs1_val==7378697629483820645 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x6666666666666665;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0x666666666666664b, 0x6666666666666665, 0x2e, x4, 424, x6)

inst_586:
// rs1_val==3037000498 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0xb504f331, 0xb504f332, 0x3, x4, 432, x6)

inst_587:
// rs1_val==3037000498 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0xb504f667, 0xb504f332, 0x555, x4, 440, x6)

inst_588:
// rs1_val==3037000498 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0998, 0xb504f332, -0x556, x4, 448, x6)

inst_589:
// rs1_val==3037000498 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0xb504f337, 0xb504f332, 0x5, x4, 456, x6)

inst_590:
// rs1_val==3037000498 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0xb504f001, 0xb504f332, 0x333, x4, 464, x6)

inst_591:
// rs1_val==3037000498 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0xb504f554, 0xb504f332, 0x666, x4, 472, x6)

inst_592:
// rs1_val==3037000498 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce1, 0xb504f332, -0x2d, x4, 480, x6)

inst_593:
// rs1_val==3037000498 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0xb504f31f, 0xb504f332, 0x2d, x4, 488, x6)

inst_594:
// rs1_val==3037000498 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0xb504f330, 0xb504f332, 0x2, x4, 496, x6)

inst_595:
// rs1_val==3037000498 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0xb504f666, 0xb504f332, 0x554, x4, 504, x6)

inst_596:
// rs1_val==3037000498 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0xb504f332, 0xb504f332, 0x0, x4, 512, x6)

inst_597:
// rs1_val==3037000498 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0xb504f336, 0xb504f332, 0x4, x4, 520, x6)

inst_598:
// rs1_val==3037000498 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0xb504f000, 0xb504f332, 0x332, x4, 528, x6)

inst_599:
// rs1_val==3037000498 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0xb504f557, 0xb504f332, 0x665, x4, 536, x6)

inst_600:
// rs1_val==3037000498 and imm_val==44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2c
TEST_IMM_OP( xori, x11, x10, 0xb504f31e, 0xb504f332, 0x2c, x4, 544, x6)

inst_601:
// rs1_val==3037000498 and imm_val==1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x556
TEST_IMM_OP( xori, x11, x10, 0xb504f664, 0xb504f332, 0x556, x4, 552, x6)

inst_602:
// rs1_val==3037000498 and imm_val==-1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x555
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0999, 0xb504f332, -0x555, x4, 560, x6)

inst_603:
// rs1_val==3037000498 and imm_val==6, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x6
TEST_IMM_OP( xori, x11, x10, 0xb504f334, 0xb504f332, 0x6, x4, 568, x6)

inst_604:
// rs1_val==3037000498 and imm_val==820, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x334
TEST_IMM_OP( xori, x11, x10, 0xb504f006, 0xb504f332, 0x334, x4, 576, x6)

inst_605:
// rs1_val==3037000498 and imm_val==1639, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x667
TEST_IMM_OP( xori, x11, x10, 0xb504f555, 0xb504f332, 0x667, x4, 584, x6)

inst_606:
// rs1_val==3037000498 and imm_val==-44, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:-0x2c
TEST_IMM_OP( xori, x11, x10, 0xffffffff4afb0ce6, 0xb504f332, -0x2c, x4, 592, x6)

inst_607:
// rs1_val==3037000498 and imm_val==46, 
// opcode: xori ; op1:x10; dest:x11; op1val:0xb504f332;  immval:0x2e
TEST_IMM_OP( xori, x11, x10, 0xb504f31c, 0xb504f332, 0x2e, x4, 600, x6)

inst_608:
// rs1_val==6148914691236517206 and imm_val==3, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x3
TEST_IMM_OP( xori, x11, x10, 0x5555555555555555, 0x5555555555555556, 0x3, x4, 608, x6)

inst_609:
// rs1_val==6148914691236517206 and imm_val==1365, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x555
TEST_IMM_OP( xori, x11, x10, 0x5555555555555003, 0x5555555555555556, 0x555, x4, 616, x6)

inst_610:
// rs1_val==6148914691236517206 and imm_val==-1366, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x556
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaffc, 0x5555555555555556, -0x556, x4, 624, x6)

inst_611:
// rs1_val==6148914691236517206 and imm_val==5, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x5
TEST_IMM_OP( xori, x11, x10, 0x5555555555555553, 0x5555555555555556, 0x5, x4, 632, x6)

inst_612:
// rs1_val==6148914691236517206 and imm_val==819, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x333
TEST_IMM_OP( xori, x11, x10, 0x5555555555555665, 0x5555555555555556, 0x333, x4, 640, x6)

inst_613:
// rs1_val==6148914691236517206 and imm_val==1638, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x666
TEST_IMM_OP( xori, x11, x10, 0x5555555555555330, 0x5555555555555556, 0x666, x4, 648, x6)

inst_614:
// rs1_val==6148914691236517206 and imm_val==-45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:-0x2d
TEST_IMM_OP( xori, x11, x10, 0xaaaaaaaaaaaaaa85, 0x5555555555555556, -0x2d, x4, 656, x6)

inst_615:
// rs1_val==6148914691236517206 and imm_val==45, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2d
TEST_IMM_OP( xori, x11, x10, 0x555555555555557b, 0x5555555555555556, 0x2d, x4, 664, x6)

inst_616:
// rs1_val==6148914691236517206 and imm_val==2, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x2
TEST_IMM_OP( xori, x11, x10, 0x5555555555555554, 0x5555555555555556, 0x2, x4, 672, x6)

inst_617:
// rs1_val==6148914691236517206 and imm_val==1364, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x554
TEST_IMM_OP( xori, x11, x10, 0x5555555555555002, 0x5555555555555556, 0x554, x4, 680, x6)

inst_618:
// rs1_val==6148914691236517206 and imm_val==0, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x0
TEST_IMM_OP( xori, x11, x10, 0x5555555555555556, 0x5555555555555556, 0x0, x4, 688, x6)

inst_619:
// rs1_val==6148914691236517206 and imm_val==4, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x4
TEST_IMM_OP( xori, x11, x10, 0x5555555555555552, 0x5555555555555556, 0x4, x4, 696, x6)

inst_620:
// rs1_val==6148914691236517206 and imm_val==818, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x332
TEST_IMM_OP( xori, x11, x10, 0x5555555555555664, 0x5555555555555556, 0x332, x4, 704, x6)

inst_621:
// rs1_val==6148914691236517206 and imm_val==1637, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x5555555555555556;  immval:0x665
TEST_IMM_OP( xori, x11, x10, 0x5555555555555333, 0x5555555555555556, 0x665, x4, 712, x6)

inst_622:
// imm_val == -65, rs1_val == -8589934593
// opcode: xori ; op1:x10; dest:x11; op1val:-0x200000001;  immval:-0x41
TEST_IMM_OP( xori, x11, x10, 0x200000040, -0x200000001, -0x41, x4, 720, x6)

inst_623:
// rs1_val == 8, 
// opcode: xori ; op1:x10; dest:x11; op1val:0x8;  immval:0x1
TEST_IMM_OP( xori, x11, x10, 0x9, 0x8, 0x1, x4, 728, x6)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x2_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x2_1:
    .fill 20*(XLEN/32),4,0xdeadbeef


signature_x4_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_2:
    .fill 92*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
