
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 18:36:29 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64im.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the divw instruction of the RISC-V M extension for the divw covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IM")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*RV64.*I.*M.*);def TEST_CASE_1=True;",divw)

RVTEST_SIGBASE( x5,signature_x5_1)

inst_0:
// rs1 == rd != rs2, rs1==x20, rs2==x1, rd==x20, rs1_val > 0 and rs2_val > 0, rs1_val == 72057594037927936, rs1_val != rs2_val, rs2_val == 2
// opcode: divw ; op1:x20; op2:x1; dest:x20; op1val:0x100000000000000;  op2val:0x2
TEST_RR_OP(divw, x20, x20, x1, 0x0, 0x100000000000000, 0x2, x5, 0, x2)

inst_1:
// rs1 == rs2 == rd, rs1==x27, rs2==x27, rd==x27, rs1_val > 0 and rs2_val < 0, rs2_val == -134217729
// opcode: divw ; op1:x27; op2:x27; dest:x27; op1val:0x6;  op2val:0x6
TEST_RR_OP(divw, x27, x27, x27, 0x1, 0x6, 0x6, x5, 8, x2)

inst_2:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x13, rs2==x18, rd==x19, rs1_val < 0 and rs2_val < 0, rs1_val == -36028797018963969, rs2_val == -5
// opcode: divw ; op1:x13; op2:x18; dest:x19; op1val:-0x80000000000001;  op2val:-0x5
TEST_RR_OP(divw, x19, x13, x18, 0x0, -0x80000000000001, -0x5, x5, 16, x2)

inst_3:
// rs1 == rs2 != rd, rs1==x21, rs2==x21, rd==x17, rs1_val < 0 and rs2_val > 0, rs1_val == -137438953473, rs2_val == 17179869184
// opcode: divw ; op1:x21; op2:x21; dest:x17; op1val:-0x2000000001;  op2val:-0x2000000001
TEST_RR_OP(divw, x17, x21, x21, 0x1, -0x2000000001, -0x2000000001, x5, 24, x2)

inst_4:
// rs2 == rd != rs1, rs1==x4, rs2==x24, rd==x24, rs1_val == rs2_val, rs2_val == -9007199254740993, rs1_val == -9007199254740993
// opcode: divw ; op1:x4; op2:x24; dest:x24; op1val:-0x20000000000001;  op2val:-0x20000000000001
TEST_RR_OP(divw, x24, x4, x24, 0x1, -0x20000000000001, -0x20000000000001, x5, 32, x2)

inst_5:
// rs1==x31, rs2==x3, rd==x26, rs2_val == (-2**(xlen-1)), rs2_val == -9223372036854775808
// opcode: divw ; op1:x31; op2:x3; dest:x26; op1val:-0x80000000000001;  op2val:-0x8000000000000000
TEST_RR_OP(divw, x26, x31, x3, 0xFFFFFFFFFFFFFFFF, -0x80000000000001, -0x8000000000000000, x5, 40, x2)

inst_6:
// rs1==x11, rs2==x15, rd==x3, rs2_val == 0, rs1_val == -72057594037927937
// opcode: divw ; op1:x11; op2:x15; dest:x3; op1val:-0x100000000000001;  op2val:0x0
TEST_RR_OP(divw, x3, x11, x15, 0xFFFFFFFFFFFFFFFF, -0x100000000000001, 0x0, x5, 48, x2)

inst_7:
// rs1==x17, rs2==x28, rd==x15, rs2_val == (2**(xlen-1)-1), rs1_val == 18014398509481984, rs2_val == 9223372036854775807
// opcode: divw ; op1:x17; op2:x28; dest:x15; op1val:0x40000000000000;  op2val:0x7fffffffffffffff
TEST_RR_OP(divw, x15, x17, x28, 0x0, 0x40000000000000, 0x7fffffffffffffff, x5, 56, x2)

inst_8:
// rs1==x30, rs2==x31, rd==x6, rs2_val == 1, rs1_val == 274877906944
// opcode: divw ; op1:x30; op2:x31; dest:x6; op1val:0x4000000000;  op2val:0x1
TEST_RR_OP(divw, x6, x30, x31, 0x0, 0x4000000000, 0x1, x5, 64, x2)

inst_9:
// rs1==x6, rs2==x9, rd==x23, rs1_val == (-2**(xlen-1)), rs2_val == 4503599627370496, rs1_val == -9223372036854775808
// opcode: divw ; op1:x6; op2:x9; dest:x23; op1val:-0x8000000000000000;  op2val:0x10000000000000
TEST_RR_OP(divw, x23, x6, x9, 0xFFFFFFFFFFFFFFFF, -0x8000000000000000, 0x10000000000000, x5, 72, x2)

inst_10:
// rs1==x28, rs2==x12, rd==x25, rs1_val == 0, rs1_val==0 and rs2_val==6
// opcode: divw ; op1:x28; op2:x12; dest:x25; op1val:0x0;  op2val:0x6
TEST_RR_OP(divw, x25, x28, x12, 0x0, 0x0, 0x6, x5, 80, x2)

inst_11:
// rs1==x25, rs2==x8, rd==x16, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807, rs2_val == 1024
// opcode: divw ; op1:x25; op2:x8; dest:x16; op1val:0x7fffffffffffffff;  op2val:0x400
TEST_RR_OP(divw, x16, x25, x8, 0x0, 0x7fffffffffffffff, 0x400, x5, 88, x2)

inst_12:
// rs1==x16, rs2==x22, rd==x14, rs1_val == 1, rs2_val == 562949953421312
// opcode: divw ; op1:x16; op2:x22; dest:x14; op1val:0x1;  op2val:0x2000000000000
TEST_RR_OP(divw, x14, x16, x22, 0xFFFFFFFFFFFFFFFF, 0x1, 0x2000000000000, x5, 96, x2)

inst_13:
// rs1==x8, rs2==x14, rd==x1, rs2_val == 4, rs1_val == -17179869185
// opcode: divw ; op1:x8; op2:x14; dest:x1; op1val:-0x400000001;  op2val:0x4
TEST_RR_OP(divw, x1, x8, x14, 0x0, -0x400000001, 0x4, x5, 104, x2)

inst_14:
// rs1==x14, rs2==x17, rd==x8, rs2_val == 8, 
// opcode: divw ; op1:x14; op2:x17; dest:x8; op1val:0x1;  op2val:0x8
TEST_RR_OP(divw, x8, x14, x17, 0x0, 0x1, 0x8, x5, 112, x2)

inst_15:
// rs1==x7, rs2==x6, rd==x9, rs2_val == 16, 
// opcode: divw ; op1:x7; op2:x6; dest:x9; op1val:-0xa;  op2val:0x10
TEST_RR_OP(divw, x9, x7, x6, 0x0, -0xa, 0x10, x5, 120, x2)

inst_16:
// rs1==x0, rs2==x26, rd==x7, rs2_val == 32, rs1_val == -32769
// opcode: divw ; op1:x0; op2:x26; dest:x7; op1val:0x0;  op2val:0x20
TEST_RR_OP(divw, x7, x0, x26, 0x0, 0x0, 0x20, x5, 128, x6)

inst_17:
// rs1==x22, rs2==x4, rd==x18, rs2_val == 64, rs1_val == -536870913
// opcode: divw ; op1:x22; op2:x4; dest:x18; op1val:-0x20000001;  op2val:0x40
TEST_RR_OP(divw, x18, x22, x4, -0x800000, -0x20000001, 0x40, x5, 136, x6)

inst_18:
// rs1==x19, rs2==x20, rd==x4, rs2_val == 128, rs1_val == -288230376151711745
// opcode: divw ; op1:x19; op2:x20; dest:x4; op1val:-0x400000000000001;  op2val:0x80
TEST_RR_OP(divw, x4, x19, x20, 0x0, -0x400000000000001, 0x80, x5, 144, x6)

inst_19:
// rs1==x10, rs2==x2, rd==x21, rs2_val == 256, rs1_val == -2305843009213693953
// opcode: divw ; op1:x10; op2:x2; dest:x21; op1val:-0x2000000000000001;  op2val:0x100
TEST_RR_OP(divw, x21, x10, x2, 0x0, -0x2000000000000001, 0x100, x5, 152, x6)
RVTEST_SIGBASE( x4,signature_x4_0)

inst_20:
// rs1==x29, rs2==x13, rd==x31, rs2_val == 512, rs1_val == 2199023255552
// opcode: divw ; op1:x29; op2:x13; dest:x31; op1val:0x20000000000;  op2val:0x200
TEST_RR_OP(divw, x31, x29, x13, 0x0, 0x20000000000, 0x200, x4, 0, x6)

inst_21:
// rs1==x12, rs2==x5, rd==x30, rs2_val == 2048, rs1_val == -257
// opcode: divw ; op1:x12; op2:x5; dest:x30; op1val:-0x101;  op2val:0x800
TEST_RR_OP(divw, x30, x12, x5, 0x0, -0x101, 0x800, x4, 8, x6)

inst_22:
// rs1==x26, rs2==x19, rd==x0, rs2_val == 4096, rs1_val == -8589934593
// opcode: divw ; op1:x26; op2:x19; dest:x0; op1val:-0x200000001;  op2val:0x1000
TEST_RR_OP(divw, x0, x26, x19, 0, -0x200000001, 0x1000, x4, 16, x6)

inst_23:
// rs1==x24, rs2==x16, rd==x10, rs2_val == 8192, rs1_val == 1048576
// opcode: divw ; op1:x24; op2:x16; dest:x10; op1val:0x100000;  op2val:0x2000
TEST_RR_OP(divw, x10, x24, x16, 0x80, 0x100000, 0x2000, x4, 24, x6)

inst_24:
// rs1==x1, rs2==x0, rd==x12, rs2_val == 16384, rs1_val == 268435456
// opcode: divw ; op1:x1; op2:x0; dest:x12; op1val:0x10000000;  op2val:0x0
TEST_RR_OP(divw, x12, x1, x0, 0xFFFFFFFFFFFFFFFF, 0x10000000, 0x0, x4, 32, x6)

inst_25:
// rs1==x23, rs2==x11, rd==x2, rs2_val == 32768, 
// opcode: divw ; op1:x23; op2:x11; dest:x2; op1val:-0x4;  op2val:0x8000
TEST_RR_OP(divw, x2, x23, x11, 0x0, -0x4, 0x8000, x4, 40, x6)

inst_26:
// rs1==x5, rs2==x10, rd==x22, rs2_val == 65536, rs1_val == 36028797018963968
// opcode: divw ; op1:x5; op2:x10; dest:x22; op1val:0x80000000000000;  op2val:0x10000
TEST_RR_OP(divw, x22, x5, x10, 0x0, 0x80000000000000, 0x10000, x4, 48, x6)

inst_27:
// rs1==x18, rs2==x30, rd==x29, rs2_val == 131072, rs1_val == 17179869184
// opcode: divw ; op1:x18; op2:x30; dest:x29; op1val:0x400000000;  op2val:0x20000
TEST_RR_OP(divw, x29, x18, x30, 0x0, 0x400000000, 0x20000, x4, 56, x6)

inst_28:
// rs1==x3, rs2==x25, rd==x28, rs2_val == 262144, rs1_val == 8
// opcode: divw ; op1:x3; op2:x25; dest:x28; op1val:0x8;  op2val:0x40000
TEST_RR_OP(divw, x28, x3, x25, 0x0, 0x8, 0x40000, x4, 64, x6)

inst_29:
// rs1==x2, rs2==x7, rd==x11, rs2_val == 524288, rs1_val == -4194305
// opcode: divw ; op1:x2; op2:x7; dest:x11; op1val:-0x400001;  op2val:0x80000
TEST_RR_OP(divw, x11, x2, x7, -0x8, -0x400001, 0x80000, x4, 72, x6)

inst_30:
// rs1==x9, rs2==x29, rd==x5, rs2_val == 1048576, rs1_val == 4503599627370496
// opcode: divw ; op1:x9; op2:x29; dest:x5; op1val:0x10000000000000;  op2val:0x100000
TEST_RR_OP(divw, x5, x9, x29, 0x0, 0x10000000000000, 0x100000, x4, 80, x6)

inst_31:
// rs1==x15, rs2==x23, rd==x13, rs2_val == 2097152, rs1_val == 2
// opcode: divw ; op1:x15; op2:x23; dest:x13; op1val:0x2;  op2val:0x200000
TEST_RR_OP(divw, x13, x15, x23, 0x0, 0x2, 0x200000, x4, 88, x6)

inst_32:
// rs2_val == 4194304, rs1_val == -5
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:0x400000
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5, 0x400000, x4, 96, x6)

inst_33:
// rs2_val == 8388608, rs1_val == 16777216
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x800000
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x1000000, 0x800000, x4, 104, x6)

inst_34:
// rs2_val == 16777216, rs1_val == 65536
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:0x1000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x10000, 0x1000000, x4, 112, x6)

inst_35:
// rs2_val == 33554432, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0x2000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4000000000, 0x2000000, x4, 120, x6)

inst_36:
// rs2_val == 67108864, rs1_val == 134217728
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x4000000
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x8000000, 0x4000000, x4, 128, x6)

inst_37:
// rs2_val == 134217728, rs1_val == -562949953421313
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:0x8000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x2000000000001, 0x8000000, x4, 136, x6)

inst_38:
// rs2_val == 268435456, rs1_val == 524288
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0x10000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x80000, 0x10000000, x4, 144, x6)

inst_39:
// rs2_val == 536870912, rs1_val == -34359738369
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000001;  op2val:0x20000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x800000001, 0x20000000, x4, 152, x6)

inst_40:
// rs2_val == 1073741824, rs1_val == 576460752303423488
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0x40000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x800000000000000, 0x40000000, x4, 160, x6)

inst_41:
// rs2_val == 2147483648, rs1_val == -144115188075855873
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:0x80000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x200000000000001, 0x80000000, x4, 168, x6)

inst_42:
// rs2_val == 4294967296, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0x100000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x800000000000000, 0x100000000, x4, 176, x6)

inst_43:
// rs2_val == 8589934592, rs1_val == 8796093022208
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x200000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x80000000000, 0x200000000, x4, 184, x6)

inst_44:
// rs2_val == 34359738368, rs1_val == -17
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:0x800000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x11, 0x800000000, x4, 192, x6)

inst_45:
// rs2_val == 68719476736, rs1_val == -16777217
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x1000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x1000001, 0x1000000000, x4, 200, x6)

inst_46:
// rs2_val == 137438953472, rs1_val == -140737488355329
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0x2000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x800000000001, 0x2000000000, x4, 208, x6)

inst_47:
// rs2_val == 274877906944, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xa;  op2val:0x4000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0xa, 0x4000000000, x4, 216, x6)

inst_48:
// rs2_val == 549755813888, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x8000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x3, 0x8000000000, x4, 224, x6)

inst_49:
// rs2_val == 1099511627776, rs1_val == 262144
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0x10000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x40000, 0x10000000000, x4, 232, x6)

inst_50:
// rs2_val == 2199023255552, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:0x20000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x10000, 0x20000000000, x4, 240, x6)

inst_51:
// rs2_val == 4398046511104, rs1_val == -513
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x40000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x201, 0x40000000000, x4, 248, x6)

inst_52:
// rs2_val == 8796093022208, rs1_val == -68719476737
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:0x80000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x1000000001, 0x80000000000, x4, 256, x6)

inst_53:
// rs2_val == 17592186044416, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0x100000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x800000000001, 0x100000000000, x4, 264, x6)

inst_54:
// rs2_val == 35184372088832, rs1_val == -6148914691236517206
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x200000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x5555555555555556, 0x200000000000, x4, 272, x6)

inst_55:
// rs2_val == 70368744177664, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0x400000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x800000000001, 0x400000000000, x4, 280, x6)

inst_56:
// rs2_val == 140737488355328, rs1_val == -33554433
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:0x800000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x2000001, 0x800000000000, x4, 288, x6)

inst_57:
// rs2_val == 281474976710656, rs1_val == 144115188075855872
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:0x1000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x200000000000000, 0x1000000000000, x4, 296, x6)

inst_58:
// rs2_val == 1125899906842624, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000000;  op2val:0x4000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x4000000000000000, 0x4000000000000, x4, 304, x6)

inst_59:
// rs2_val == 2251799813685248, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:0x8000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x400000000000001, 0x8000000000000, x4, 312, x6)

inst_60:
// rs2_val == 9007199254740992, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:0x20000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x8, 0x20000000000000, x4, 320, x6)

inst_61:
// rs2_val == 18014398509481984, rs1_val == 8192
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0x40000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x2000, 0x40000000000000, x4, 328, x6)

inst_62:
// rs2_val == 36028797018963968, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:0x80000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x1000001, 0x80000000000000, x4, 336, x6)

inst_63:
// rs2_val == 72057594037927936, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:0x100000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x400000000000001, 0x100000000000000, x4, 344, x6)

inst_64:
// rs2_val == 144115188075855872, rs1_val == -8388609
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x200000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x800001, 0x200000000000000, x4, 352, x6)

inst_65:
// rs2_val == 288230376151711744, rs1_val == -524289
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x400000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x80001, 0x400000000000000, x4, 360, x6)

inst_66:
// rs2_val == 576460752303423488, rs1_val == 4194304
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x800000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x400000, 0x800000000000000, x4, 368, x6)

inst_67:
// rs2_val == 1152921504606846976, rs1_val == 2097152
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0x1000000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x200000, 0x1000000000000000, x4, 376, x6)

inst_68:
// rs2_val == 2305843009213693952, rs1_val == -129
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:0x2000000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x81, 0x2000000000000000, x4, 384, x6)

inst_69:
// rs2_val == 4611686018427387904, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0x4000000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x2000, 0x4000000000000000, x4, 392, x6)

inst_70:
// rs2_val == -2, rs1_val == -18014398509481985
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:-0x2
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x40000000000001, -0x2, x4, 400, x6)

inst_71:
// rs2_val == -3, rs1_val == 16384
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0x3
TEST_RR_OP(divw, x12, x10, x11, -0x1555, 0x4000, -0x3, x4, 408, x6)

inst_72:
// rs2_val == -9, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:-0x9
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x200000000000001, -0x9, x4, 416, x6)

inst_73:
// rs2_val == -17, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x11
TEST_RR_OP(divw, x12, x10, x11, -0x3030302, 0x3333333333333332, -0x11, x4, 424, x6)

inst_74:
// rs2_val == -33, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000000000;  op2val:-0x21
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x8000000000000000, -0x21, x4, 432, x6)

inst_75:
// rs2_val == -65, rs1_val == 32
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:-0x41
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x20, -0x41, x4, 440, x6)

inst_76:
// rs2_val == -129, rs1_val == 281474976710656
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:-0x81
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x1000000000000, -0x81, x4, 448, x6)

inst_77:
// rs2_val == -257, rs1_val == 8388608
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:-0x101
TEST_RR_OP(divw, x12, x10, x11, -0x7f80, 0x800000, -0x101, x4, 456, x6)

inst_78:
// rs2_val == -513, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:-0x201
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x400000000, -0x201, x4, 464, x6)

inst_79:
// rs2_val == -1025, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x7;  op2val:-0x401
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x7, -0x401, x4, 472, x6)

inst_80:
// rs2_val == -2049, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0x801
TEST_RR_OP(divw, x12, x10, x11, -0x7, 0x4000, -0x801, x4, 480, x6)

inst_81:
// rs2_val == -4097, rs1_val == 128
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:-0x1001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x80, -0x1001, x4, 488, x6)

inst_82:
// rs2_val == -8193, rs1_val == -17592186044417
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:-0x2001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x100000000001, -0x2001, x4, 496, x6)

inst_83:
// rs2_val == -16385, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000000001;  op2val:-0x4001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x100000000000001, -0x4001, x4, 504, x6)

inst_84:
// rs2_val == -32769, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x8001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0x8001, x4, 512, x6)

inst_85:
// rs2_val == -65537, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:-0x10001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x200000000000001, -0x10001, x4, 520, x6)

inst_86:
// rs2_val == -131073, rs1_val == -35184372088833
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:-0x20001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x200000000001, -0x20001, x4, 528, x6)

inst_87:
// rs2_val == -262145, rs1_val == -4294967297
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:-0x40001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x100000001, -0x40001, x4, 536, x6)

inst_88:
// rs2_val == -524289, rs1_val == 1024
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:-0x80001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x400, -0x80001, x4, 544, x6)

inst_89:
// rs2_val == -1048577, rs1_val == 140737488355328
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:-0x100001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x800000000000, -0x100001, x4, 552, x6)

inst_90:
// rs2_val == -2097153, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x200001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0x200001, x4, 560, x6)

inst_91:
// rs2_val == -4194305, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:-0x400001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x80000000000001, -0x400001, x4, 568, x6)

inst_92:
// rs2_val == -8388609, rs1_val == 4611686018427387904
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:-0x800001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4000000000000000, -0x800001, x4, 576, x6)

inst_93:
// rs2_val == -16777217, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:-0x1000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x1000000, -0x1000001, x4, 584, x6)

inst_94:
// rs2_val == -33554433, rs1_val == -1073741825
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:-0x2000001
TEST_RR_OP(divw, x12, x10, x11, 0x1f, -0x40000001, -0x2000001, x4, 592, x6)

inst_95:
// rs2_val == -67108865, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8;  op2val:-0x4000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x8, -0x4000001, x4, 600, x6)

inst_96:
// rs2_val == -268435457, rs1_val == -8796093022209
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:-0x10000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x80000000001, -0x10000001, x4, 608, x6)

inst_97:
// rs2_val == -536870913, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:-0x20000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5, -0x20000001, x4, 616, x6)

inst_98:
// rs2_val == -1073741825, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:-0x40000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x20000000000, -0x40000001, x4, 624, x6)

inst_99:
// rs2_val == -2147483649, rs1_val == -2049
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:-0x80000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x801, -0x80000001, x4, 632, x6)

inst_100:
// rs2_val == -4294967297, rs1_val == 512
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:-0x100000001
TEST_RR_OP(divw, x12, x10, x11, -0x200, 0x200, -0x100000001, x4, 640, x6)

inst_101:
// rs2_val == -8589934593, rs1_val == -67108865
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:-0x200000001
TEST_RR_OP(divw, x12, x10, x11, 0x4000001, -0x4000001, -0x200000001, x4, 648, x6)

inst_102:
// rs2_val == -17179869185, rs1_val == -4398046511105
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:-0x400000001
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x40000000001, -0x400000001, x4, 656, x6)

inst_103:
// rs2_val == -34359738369, rs1_val == 131072
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:-0x800000001
TEST_RR_OP(divw, x12, x10, x11, -0x20000, 0x20000, -0x800000001, x4, 664, x6)

inst_104:
// rs2_val == -68719476737, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x1000000001
TEST_RR_OP(divw, x12, x10, x11, -0x4afb0cce, -0xb504f332, -0x1000000001, x4, 672, x6)

inst_105:
// rs2_val == -137438953473, rs1_val == -549755813889
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:-0x2000000001
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x8000000001, -0x2000000001, x4, 680, x6)

inst_106:
// rs2_val == -274877906945, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x4000000001
TEST_RR_OP(divw, x12, x10, x11, 0x55555555, -0x5555555555555555, -0x4000000001, x4, 688, x6)

inst_107:
// rs2_val == -549755813889, rs1_val == 6148914691236517205
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x8000000001
TEST_RR_OP(divw, x12, x10, x11, -0x55555555, 0x5555555555555555, -0x8000000001, x4, 696, x6)

inst_108:
// rs2_val == -1099511627777, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:-0x10000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4000000000000000, -0x10000000001, x4, 704, x6)

inst_109:
// rs2_val == -2199023255553, rs1_val == 562949953421312
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:-0x20000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2000000000000, -0x20000000001, x4, 712, x6)

inst_110:
// rs2_val == -4398046511105, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:-0x40000000001
TEST_RR_OP(divw, x12, x10, x11, 0x1000001, -0x1000001, -0x40000000001, x4, 720, x6)

inst_111:
// rs2_val == -8796093022209, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:-0x80000000001
TEST_RR_OP(divw, x12, x10, x11, 0x800001, -0x800001, -0x80000000001, x4, 728, x6)

inst_112:
// rs2_val == -17592186044417, rs1_val == -2097153
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:-0x100000000001
TEST_RR_OP(divw, x12, x10, x11, 0x200001, -0x200001, -0x100000000001, x4, 736, x6)

inst_113:
// rs2_val == -35184372088833, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8;  op2val:-0x200000000001
TEST_RR_OP(divw, x12, x10, x11, 0x8, -0x8, -0x200000000001, x4, 744, x6)

inst_114:
// rs2_val == -70368744177665, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:-0x400000000001
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x100000001, -0x400000000001, x4, 752, x6)

inst_115:
// rs2_val == -140737488355329, rs1_val == 137438953472
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:-0x800000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2000000000, -0x800000000001, x4, 760, x6)

inst_116:
// rs2_val == -281474976710657, rs1_val == -2
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:-0x1000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x2, -0x2, -0x1000000000001, x4, 768, x6)

inst_117:
// rs2_val == -562949953421313, rs1_val == -1125899906842625
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:-0x2000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x4000000000001, -0x2000000000001, x4, 776, x6)

inst_118:
// rs2_val == -1125899906842625, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x4000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0x4000000000001, x4, 784, x6)

inst_119:
// rs2_val == -2251799813685249, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x81;  op2val:-0x8000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x81, -0x81, -0x8000000000001, x4, 792, x6)

inst_120:
// rs2_val == -4503599627370497, rs1_val == 4
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x10000000000001
TEST_RR_OP(divw, x12, x10, x11, -0x4, 0x4, -0x10000000000001, x4, 800, x6)

inst_121:
// rs2_val == -18014398509481985, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x40000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0x40000000000001, x4, 808, x6)

inst_122:
// rs2_val == -36028797018963969, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x80000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x4afb0cce, 0xb504f332, -0x80000000000001, x4, 816, x6)

inst_123:
// rs2_val == -72057594037927937, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:-0x100000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x4000001, -0x4000001, -0x100000000000001, x4, 824, x6)

inst_124:
// rs2_val == -144115188075855873, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:-0x200000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x40000000001, -0x200000000000001, x4, 832, x6)

inst_125:
// rs2_val == -288230376151711745, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:-0x400000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x400001, -0x400001, -0x400000000000001, x4, 840, x6)

inst_126:
// rs2_val == -576460752303423489, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:-0x800000000000001
TEST_RR_OP(divw, x12, x10, x11, -0x100000, 0x100000, -0x800000000000001, x4, 848, x6)

inst_127:
// rs2_val == -1152921504606846977, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000000000;  op2val:-0x1000000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x8000000000000000, -0x1000000000000001, x4, 856, x6)

inst_128:
// rs2_val == -2305843009213693953, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:-0x2000000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x800000000000000, -0x2000000000000001, x4, 864, x6)

inst_129:
// rs2_val == -4611686018427387905, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:-0x4000000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x201, -0x201, -0x4000000000000001, x4, 872, x6)

inst_130:
// rs2_val == 6148914691236517205, rs1_val==6 and rs2_val==6148914691236517205
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x5555555555555555, x4, 880, x6)

inst_131:
// rs2_val == -6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x400, -0x5555555555555556, x4, 888, x6)

inst_132:
// rs1_val == 16, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x7fffffffffffffff
TEST_RR_OP(divw, x12, x10, x11, -0x10, 0x10, 0x7fffffffffffffff, x4, 896, x6)

inst_133:
// rs1_val == 64, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0x100
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x40, 0x100, x4, 904, x6)

inst_134:
// rs1_val == 256, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:0x20000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x100, 0x20000, x4, 912, x6)

inst_135:
// rs1_val == 2048, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0x2000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x800, 0x2000000000, x4, 920, x6)

inst_136:
// rs1_val == 4096, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x200000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x1000, 0x200000, x4, 928, x6)

inst_137:
// rs1_val == 32768, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0x400000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x8000, 0x400000000, x4, 936, x6)

inst_138:
// rs1_val == 33554432, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:-0x100000000001
TEST_RR_OP(divw, x12, x10, x11, -0x2000000, 0x2000000, -0x100000000001, x4, 944, x6)

inst_139:
// rs1_val == 67108864, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:-0x11
TEST_RR_OP(divw, x12, x10, x11, -0x3c3c3c, 0x4000000, -0x11, x4, 952, x6)

inst_140:
// rs1_val == 536870912, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x40000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x20000000, 0x40000000, x4, 960, x6)

inst_141:
// rs1_val == 1073741824, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:-0x5
TEST_RR_OP(divw, x12, x10, x11, -0xccccccc, 0x40000000, -0x5, x4, 968, x6)

inst_142:
// rs1_val == 2147483648, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, -0x40000000, 0x80000000, 0x2, x4, 976, x6)

inst_143:
// rs1_val == 4294967296, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:-0x8000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x100000000, -0x8000000000001, x4, 984, x6)

inst_144:
// rs1_val == 8589934592, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0x1000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x200000000, 0x1000000, x4, 992, x6)

inst_145:
// rs1_val == 34359738368, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x800000000, 0x6666666666666667, x4, 1000, x6)

inst_146:
// rs1_val == 68719476736, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0x1000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x1000000000, 0x1000000000, x4, 1008, x6)

inst_147:
// rs1_val == 549755813888, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x8000000000, 0x0, x4, 1016, x6)

inst_148:
// rs1_val == 1099511627776, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:-0x800000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x10000000000, -0x800000000000001, x4, 1024, x6)

inst_149:
// rs1_val == 4398046511104, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:-0x100000000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x40000000000, -0x100000000001, x4, 1032, x6)

inst_150:
// rs1_val == 17592186044416, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x200000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x100000000000, 0x200000000000, x4, 1040, x6)

inst_151:
// rs1_val == 35184372088832, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x200000000000, 0x5555555555555556, x4, 1048, x6)

inst_152:
// rs1_val == 70368744177664, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x40000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x400000000000, 0x40000000000, x4, 1056, x6)

inst_153:
// rs1_val == 1125899906842624, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0x4000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x4000000000000, 0x4000000000000, x4, 1064, x6)

inst_154:
// rs1_val == 2251799813685248, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0x8000
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x8000000000000, 0x8000, x4, 1072, x6)

inst_155:
// rs1_val == 9007199254740992, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0x80000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x20000000000000, 0x80000000000, x4, 1080, x6)

inst_156:
// rs1_val == 288230376151711744, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:-0x2001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x400000000000000, -0x2001, x4, 1088, x6)

inst_157:
// rs1_val == 1152921504606846976, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x1000000000000000, -0xb504f333, x4, 1096, x6)

inst_158:
// rs1_val == 2305843009213693952, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:-0x800000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2000000000000000, -0x800000001, x4, 1104, x6)

inst_159:
// rs1_val == -3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:-0x80000000001
TEST_RR_OP(divw, x12, x10, x11, 0x3, -0x3, -0x80000000001, x4, 1112, x6)

inst_160:
// rs1_val == -9, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:-0x80000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x9, -0x80000001, x4, 1120, x6)

inst_161:
// rs1_val == -33, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:-0x40001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x21, -0x40001, x4, 1128, x6)

inst_162:
// rs1_val == -65, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:0x2000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x41, 0x2000000000, x4, 1136, x6)

inst_163:
// rs1_val == -1025, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:-0x4000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x401, -0x401, -0x4000000000001, x4, 1144, x6)

inst_164:
// rs1_val == -4097, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:-0x8
TEST_RR_OP(divw, x12, x10, x11, 0x200, -0x1001, -0x8, x4, 1152, x6)

inst_165:
// rs1_val == -8193, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x2001, 0x5555555555555556, x4, 1160, x6)

inst_166:
// rs1_val == -16385, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:0x9
TEST_RR_OP(divw, x12, x10, x11, -0x71c, -0x4001, 0x9, x4, 1168, x6)

inst_167:
// rs1_val == -65537, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:-0x21
TEST_RR_OP(divw, x12, x10, x11, 0x7c1, -0x10001, -0x21, x4, 1176, x6)

inst_168:
// rs1_val == -131073, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:-0x80000000001
TEST_RR_OP(divw, x12, x10, x11, 0x20001, -0x20001, -0x80000000001, x4, 1184, x6)

inst_169:
// rs1_val == -262145, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0x40000000
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x40001, 0x40000000, x4, 1192, x6)

inst_170:
// rs1_val == -1048577, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:-0x10000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x100001, -0x10000001, x4, 1200, x6)

inst_171:
// rs1_val == -134217729, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000001;  op2val:-0x40000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x8000001, -0x40000001, x4, 1208, x6)

inst_172:
// rs1_val == -268435457, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000001;  op2val:-0x800000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x10000001, -0x10000001, -0x800000000000001, x4, 1216, x6)

inst_173:
// rs1_val == -2147483649, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:0x800000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x80000001, 0x800000000, x4, 1224, x6)

inst_174:
// rs1_val == -274877906945, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x4000000001, 0x6, x4, 1232, x6)

inst_175:
// rs1_val == -1099511627777, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:0x4000
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x10000000001, 0x4000, x4, 1240, x6)

inst_176:
// rs1_val == -2199023255553, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:0x80000000000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x20000000001, 0x80000000000000, x4, 1248, x6)

inst_177:
// rs1_val == -70368744177665, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:-0x6
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x400000000001, -0x6, x4, 1256, x6)

inst_178:
// rs1_val == -281474976710657, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:-0x20000000000001
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x1000000000001, -0x20000000000001, x4, 1264, x6)

inst_179:
// rs1_val == -2251799813685249, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000000001;  op2val:-0x20000000001
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x8000000000001, -0x20000000001, x4, 1272, x6)

inst_180:
// rs1_val == -4503599627370497, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x7
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x10000000000001, 0x7, x4, 1280, x6)

inst_181:
// rs1_val == -576460752303423489, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:-0x1
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x800000000000001, -0x1, x4, 1288, x6)

inst_182:
// rs1_val == -1152921504606846977, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x1000000000000001, 0x2, x4, 1296, x6)

inst_183:
// rs1_val == -4611686018427387905, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:-0x10000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x4000000000000001, -0x10000001, x4, 1304, x6)

inst_184:
// rs1_val==3 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3, 0x3, x4, 1312, x6)

inst_185:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x5555555555555555, x4, 1320, x6)

inst_186:
// rs1_val==3 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, -0x5555555555555556, x4, 1328, x6)

inst_187:
// rs1_val==3 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x5, x4, 1336, x6)

inst_188:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x3333333333333333, x4, 1344, x6)

inst_189:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x6666666666666666, x4, 1352, x6)

inst_190:
// rs1_val==3 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, -0xb504f333, x4, 1360, x6)

inst_191:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0xb504f333, x4, 1368, x6)

inst_192:
// rs1_val==3 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3, 0x2, x4, 1376, x6)

inst_193:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x5555555555555554, x4, 1384, x6)

inst_194:
// rs1_val==3 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x3, 0x0, x4, 1392, x6)

inst_195:
// rs1_val==3 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x4, x4, 1400, x6)

inst_196:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x3333333333333332, x4, 1408, x6)

inst_197:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x6666666666666665, x4, 1416, x6)

inst_198:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0xb504f332, x4, 1424, x6)

inst_199:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x5555555555555556, x4, 1432, x6)

inst_200:
// rs1_val==3 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, -0x5555555555555555, x4, 1440, x6)

inst_201:
// rs1_val==3 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x6, x4, 1448, x6)

inst_202:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x3333333333333334, x4, 1456, x6)

inst_203:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0x6666666666666667, x4, 1464, x6)

inst_204:
// rs1_val==3 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, -0xb504f332, x4, 1472, x6)

inst_205:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3, 0xb504f334, x4, 1480, x6)

inst_206:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x1c71c71c, 0x5555555555555555, 0x3, x4, 1488, x6)

inst_207:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555555, x4, 1496, x6)

inst_208:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555555, -0x5555555555555556, x4, 1504, x6)

inst_209:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x11111111, 0x5555555555555555, 0x5, x4, 1512, x6)

inst_210:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555555, 0x3333333333333333, x4, 1520, x6)

inst_211:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555555, 0x6666666666666666, x4, 1528, x6)

inst_212:
// rs1_val==6148914691236517205 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555555, -0xb504f333, x4, 1536, x6)

inst_213:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555555, 0xb504f333, x4, 1544, x6)

inst_214:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x2aaaaaaa, 0x5555555555555555, 0x2, x4, 1552, x6)

inst_215:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555554, x4, 1560, x6)

inst_216:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x5555555555555555, 0x0, x4, 1568, x6)

inst_217:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x15555555, 0x5555555555555555, 0x4, x4, 1576, x6)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555555, 0x3333333333333332, x4, 1584, x6)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555555, 0x6666666666666665, x4, 1592, x6)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555555, 0xb504f332, x4, 1600, x6)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555556, x4, 1608, x6)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555555, -0x5555555555555555, x4, 1616, x6)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0xe38e38e, 0x5555555555555555, 0x6, x4, 1624, x6)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555555, 0x3333333333333334, x4, 1632, x6)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555555, 0x6666666666666667, x4, 1640, x6)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555555, -0xb504f332, x4, 1648, x6)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555555, 0xb504f334, x4, 1656, x6)

inst_228:
// rs1_val==-6148914691236517206 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, -0x1c71c71c, -0x5555555555555556, 0x3, x4, 1664, x6)

inst_229:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, 0x5555555555555555, x4, 1672, x6)

inst_230:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555556, -0x5555555555555556, x4, 1680, x6)

inst_231:
// rs1_val==-6148914691236517206 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, -0x11111111, -0x5555555555555556, 0x5, x4, 1688, x6)

inst_232:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, 0x3333333333333333, x4, 1696, x6)

inst_233:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555556, 0x6666666666666666, x4, 1704, x6)

inst_234:
// rs1_val==-6148914691236517206 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, -0xb504f333, x4, 1712, x6)

inst_235:
// rs1_val==-6148914691236517206 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555556, 0xb504f333, x4, 1720, x6)

inst_236:
// rs1_val==-6148914691236517206 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, -0x2aaaaaab, -0x5555555555555556, 0x2, x4, 1728, x6)

inst_237:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, 0x5555555555555554, x4, 1736, x6)

inst_238:
// rs1_val==-6148914691236517206 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x5555555555555556, 0x0, x4, 1744, x6)

inst_239:
// rs1_val==-6148914691236517206 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, -0x15555555, -0x5555555555555556, 0x4, x4, 1752, x6)

inst_240:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, 0x3333333333333332, x4, 1760, x6)

inst_241:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555556, 0x6666666666666665, x4, 1768, x6)

inst_242:
// rs1_val==-6148914691236517206 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555556, 0xb504f332, x4, 1776, x6)

inst_243:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, 0x5555555555555556, x4, 1784, x6)

inst_244:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555556, -0x5555555555555555, x4, 1792, x6)

inst_245:
// rs1_val==-6148914691236517206 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, -0xe38e38e, -0x5555555555555556, 0x6, x4, 1800, x6)

inst_246:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, 0x3333333333333334, x4, 1808, x6)

inst_247:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555556, 0x6666666666666667, x4, 1816, x6)

inst_248:
// rs1_val==-6148914691236517206 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555556, -0xb504f332, x4, 1824, x6)

inst_249:
// rs1_val==-6148914691236517206 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555556, 0xb504f334, x4, 1832, x6)

inst_250:
// rs1_val==5 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5, 0x3, x4, 1840, x6)

inst_251:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x5555555555555555, x4, 1848, x6)

inst_252:
// rs1_val==5 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, -0x5555555555555556, x4, 1856, x6)

inst_253:
// rs1_val==5 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5, 0x5, x4, 1864, x6)

inst_254:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x3333333333333333, x4, 1872, x6)

inst_255:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x6666666666666666, x4, 1880, x6)

inst_256:
// rs1_val==5 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, -0xb504f333, x4, 1888, x6)

inst_257:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0xb504f333, x4, 1896, x6)

inst_258:
// rs1_val==5 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x5, 0x2, x4, 1904, x6)

inst_259:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x5555555555555554, x4, 1912, x6)

inst_260:
// rs1_val==5 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x5, 0x0, x4, 1920, x6)

inst_261:
// rs1_val==5 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5, 0x4, x4, 1928, x6)

inst_262:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x3333333333333332, x4, 1936, x6)

inst_263:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x6666666666666665, x4, 1944, x6)

inst_264:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0xb504f332, x4, 1952, x6)

inst_265:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x5555555555555556, x4, 1960, x6)

inst_266:
// rs1_val==5 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, -0x5555555555555555, x4, 1968, x6)

inst_267:
// rs1_val==5 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x6, x4, 1976, x6)

inst_268:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x3333333333333334, x4, 1984, x6)

inst_269:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0x6666666666666667, x4, 1992, x6)

inst_270:
// rs1_val==5 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, -0xb504f332, x4, 2000, x6)

inst_271:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5, 0xb504f334, x4, 2008, x6)

inst_272:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x11111111, 0x3333333333333333, 0x3, x4, 2016, x6)

inst_273:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0x5555555555555555, x4, 2024, x6)

inst_274:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, -0x5555555555555556, x4, 2032, x6)

inst_275:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0xa3d70a3, 0x3333333333333333, 0x5, x4, 2040, x6)
RVTEST_SIGBASE( x4,signature_x4_1)

inst_276:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333333, x4, 0, x6)

inst_277:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0x6666666666666666, x4, 8, x6)

inst_278:
// rs1_val==3689348814741910323 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, -0xb504f333, x4, 16, x6)

inst_279:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f333, x4, 24, x6)

inst_280:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x19999999, 0x3333333333333333, 0x2, x4, 32, x6)

inst_281:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0x5555555555555554, x4, 40, x6)

inst_282:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x3333333333333333, 0x0, x4, 48, x6)

inst_283:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0xccccccc, 0x3333333333333333, 0x4, x4, 56, x6)

inst_284:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333332, x4, 64, x6)

inst_285:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0x6666666666666665, x4, 72, x6)

inst_286:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f332, x4, 80, x6)

inst_287:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0x5555555555555556, x4, 88, x6)

inst_288:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, -0x5555555555555555, x4, 96, x6)

inst_289:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x8888888, 0x3333333333333333, 0x6, x4, 104, x6)

inst_290:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333334, x4, 112, x6)

inst_291:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0x6666666666666667, x4, 120, x6)

inst_292:
// rs1_val==3689348814741910323 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, -0xb504f332, x4, 128, x6)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333333, 0xb504f334, x4, 136, x6)

inst_294:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x22222222, 0x6666666666666666, 0x3, x4, 144, x6)

inst_295:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, 0x5555555555555555, x4, 152, x6)

inst_296:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666666, -0x5555555555555556, x4, 160, x6)

inst_297:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x147ae147, 0x6666666666666666, 0x5, x4, 168, x6)

inst_298:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x6666666666666666, 0x3333333333333333, x4, 176, x6)

inst_299:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666666, x4, 184, x6)

inst_300:
// rs1_val==7378697629483820646 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, -0xb504f333, x4, 192, x6)

inst_301:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666666, 0xb504f333, x4, 200, x6)

inst_302:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x33333333, 0x6666666666666666, 0x2, x4, 208, x6)

inst_303:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, 0x5555555555555554, x4, 216, x6)

inst_304:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x6666666666666666, 0x0, x4, 224, x6)

inst_305:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x19999999, 0x6666666666666666, 0x4, x4, 232, x6)

inst_306:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x6666666666666666, 0x3333333333333332, x4, 240, x6)

inst_307:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666665, x4, 248, x6)

inst_308:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666666, 0xb504f332, x4, 256, x6)

inst_309:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, 0x5555555555555556, x4, 264, x6)

inst_310:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666666, -0x5555555555555555, x4, 272, x6)

inst_311:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x11111111, 0x6666666666666666, 0x6, x4, 280, x6)

inst_312:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, 0x3333333333333334, x4, 288, x6)

inst_313:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666667, x4, 296, x6)

inst_314:
// rs1_val==7378697629483820646 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666666, -0xb504f332, x4, 304, x6)

inst_315:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666666, 0xb504f334, x4, 312, x6)

inst_316:
// rs1_val==-3037000499 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x18fe5999, -0xb504f333, 0x3, x4, 320, x6)

inst_317:
// rs1_val==-3037000499 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, 0x5555555555555555, x4, 328, x6)

inst_318:
// rs1_val==-3037000499 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, -0x5555555555555556, x4, 336, x6)

inst_319:
// rs1_val==-3037000499 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0xeff028f, -0xb504f333, 0x5, x4, 344, x6)

inst_320:
// rs1_val==-3037000499 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f333, 0x3333333333333333, x4, 352, x6)

inst_321:
// rs1_val==-3037000499 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, 0x6666666666666666, x4, 360, x6)

inst_322:
// rs1_val==-3037000499 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f333, -0xb504f333, x4, 368, x6)

inst_323:
// rs1_val==-3037000499 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0xb504f333, 0xb504f333, x4, 376, x6)

inst_324:
// rs1_val==-3037000499 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x257d8666, -0xb504f333, 0x2, x4, 384, x6)

inst_325:
// rs1_val==-3037000499 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, 0x5555555555555554, x4, 392, x6)

inst_326:
// rs1_val==-3037000499 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0xb504f333, 0x0, x4, 400, x6)

inst_327:
// rs1_val==-3037000499 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x12bec333, -0xb504f333, 0x4, x4, 408, x6)

inst_328:
// rs1_val==-3037000499 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f333, 0x3333333333333332, x4, 416, x6)

inst_329:
// rs1_val==-3037000499 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, 0x6666666666666665, x4, 424, x6)

inst_330:
// rs1_val==-3037000499 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, 0xb504f332, x4, 432, x6)

inst_331:
// rs1_val==-3037000499 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, 0x5555555555555556, x4, 440, x6)

inst_332:
// rs1_val==-3037000499 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, -0x5555555555555555, x4, 448, x6)

inst_333:
// rs1_val==-3037000499 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0xc7f2ccc, -0xb504f333, 0x6, x4, 456, x6)

inst_334:
// rs1_val==-3037000499 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f333, 0x3333333333333334, x4, 464, x6)

inst_335:
// rs1_val==-3037000499 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, 0x6666666666666667, x4, 472, x6)

inst_336:
// rs1_val==-3037000499 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f333, -0xb504f332, x4, 480, x6)

inst_337:
// rs1_val==-3037000499 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0xb504f333, 0xb504f334, x4, 488, x6)

inst_338:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, -0x18fe5999, 0xb504f333, 0x3, x4, 496, x6)

inst_339:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, 0x5555555555555555, x4, 504, x6)

inst_340:
// rs1_val==3037000499 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, -0x5555555555555556, x4, 512, x6)

inst_341:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, -0xeff028f, 0xb504f333, 0x5, x4, 520, x6)

inst_342:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f333, 0x3333333333333333, x4, 528, x6)

inst_343:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, 0x6666666666666666, x4, 536, x6)

inst_344:
// rs1_val==3037000499 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f333, -0xb504f333, x4, 544, x6)

inst_345:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0xb504f333, 0xb504f333, x4, 552, x6)

inst_346:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, -0x257d8666, 0xb504f333, 0x2, x4, 560, x6)

inst_347:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, 0x5555555555555554, x4, 568, x6)

inst_348:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0xb504f333, 0x0, x4, 576, x6)

inst_349:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, -0x12bec333, 0xb504f333, 0x4, x4, 584, x6)

inst_350:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f333, 0x3333333333333332, x4, 592, x6)

inst_351:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, 0x6666666666666665, x4, 600, x6)

inst_352:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, 0xb504f332, x4, 608, x6)

inst_353:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, 0x5555555555555556, x4, 616, x6)

inst_354:
// rs1_val==3037000499 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, -0x5555555555555555, x4, 624, x6)

inst_355:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, -0xc7f2ccc, 0xb504f333, 0x6, x4, 632, x6)

inst_356:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f333, 0x3333333333333334, x4, 640, x6)

inst_357:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, 0x6666666666666667, x4, 648, x6)

inst_358:
// rs1_val==3037000499 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f333, -0xb504f332, x4, 656, x6)

inst_359:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0xb504f333, 0xb504f334, x4, 664, x6)

inst_360:
// rs1_val==2 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x3, x4, 672, x6)

inst_361:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x5555555555555555, x4, 680, x6)

inst_362:
// rs1_val==2 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, -0x5555555555555556, x4, 688, x6)

inst_363:
// rs1_val==2 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x5, x4, 696, x6)

inst_364:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x3333333333333333, x4, 704, x6)

inst_365:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x6666666666666666, x4, 712, x6)

inst_366:
// rs1_val==2 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, -0xb504f333, x4, 720, x6)

inst_367:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0xb504f333, x4, 728, x6)

inst_368:
// rs1_val==2 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x2, 0x2, x4, 736, x6)

inst_369:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x5555555555555554, x4, 744, x6)

inst_370:
// rs1_val==2 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x2, 0x0, x4, 752, x6)

inst_371:
// rs1_val==2 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x4, x4, 760, x6)

inst_372:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x3333333333333332, x4, 768, x6)

inst_373:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x6666666666666665, x4, 776, x6)

inst_374:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0xb504f332, x4, 784, x6)

inst_375:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x5555555555555556, x4, 792, x6)

inst_376:
// rs1_val==2 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, -0x5555555555555555, x4, 800, x6)

inst_377:
// rs1_val==2 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x6, x4, 808, x6)

inst_378:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x3333333333333334, x4, 816, x6)

inst_379:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0x6666666666666667, x4, 824, x6)

inst_380:
// rs1_val==2 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, -0xb504f332, x4, 832, x6)

inst_381:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x2, 0xb504f334, x4, 840, x6)

inst_382:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x1c71c71c, 0x5555555555555554, 0x3, x4, 848, x6)

inst_383:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555555, x4, 856, x6)

inst_384:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555554, -0x5555555555555556, x4, 864, x6)

inst_385:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x11111110, 0x5555555555555554, 0x5, x4, 872, x6)

inst_386:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555554, 0x3333333333333333, x4, 880, x6)

inst_387:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555554, 0x6666666666666666, x4, 888, x6)

inst_388:
// rs1_val==6148914691236517204 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555554, -0xb504f333, x4, 896, x6)

inst_389:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555554, 0xb504f333, x4, 904, x6)

inst_390:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x2aaaaaaa, 0x5555555555555554, 0x2, x4, 912, x6)

inst_391:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555554, 0x5555555555555554, x4, 920, x6)

inst_392:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x5555555555555554, 0x0, x4, 928, x6)

inst_393:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x15555555, 0x5555555555555554, 0x4, x4, 936, x6)

inst_394:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555554, 0x3333333333333332, x4, 944, x6)

inst_395:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555554, 0x6666666666666665, x4, 952, x6)

inst_396:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555554, 0xb504f332, x4, 960, x6)

inst_397:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555556, x4, 968, x6)

inst_398:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555554, -0x5555555555555555, x4, 976, x6)

inst_399:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0xe38e38e, 0x5555555555555554, 0x6, x4, 984, x6)

inst_400:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555554, 0x3333333333333334, x4, 992, x6)

inst_401:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555554, 0x6666666666666667, x4, 1000, x6)

inst_402:
// rs1_val==6148914691236517204 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555554, -0xb504f332, x4, 1008, x6)

inst_403:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555554, 0xb504f334, x4, 1016, x6)

inst_404:
// rs1_val==0 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x3, x4, 1024, x6)

inst_405:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x5555555555555555, x4, 1032, x6)

inst_406:
// rs1_val==0 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0x5555555555555556, x4, 1040, x6)

inst_407:
// rs1_val==0 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x5, x4, 1048, x6)

inst_408:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x3333333333333333, x4, 1056, x6)

inst_409:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x6666666666666666, x4, 1064, x6)

inst_410:
// rs1_val==0 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0xb504f333, x4, 1072, x6)

inst_411:
// rs1_val==0 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0xb504f332, x4, 1080, x6)

inst_412:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0xb504f334, x4, 1088, x6)

inst_413:
// rs1_val==4 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x4, 0x3, x4, 1096, x6)

inst_414:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x5555555555555555, x4, 1104, x6)

inst_415:
// rs1_val==4 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, -0x5555555555555556, x4, 1112, x6)

inst_416:
// rs1_val==4 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x5, x4, 1120, x6)

inst_417:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x3333333333333333, x4, 1128, x6)

inst_418:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x6666666666666666, x4, 1136, x6)

inst_419:
// rs1_val==4 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, -0xb504f333, x4, 1144, x6)

inst_420:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0xb504f333, x4, 1152, x6)

inst_421:
// rs1_val==4 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x4, 0x2, x4, 1160, x6)

inst_422:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x5555555555555554, x4, 1168, x6)

inst_423:
// rs1_val==4 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x4, 0x0, x4, 1176, x6)

inst_424:
// rs1_val==4 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x4, 0x4, x4, 1184, x6)

inst_425:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x3333333333333332, x4, 1192, x6)

inst_426:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x6666666666666665, x4, 1200, x6)

inst_427:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0xb504f332, x4, 1208, x6)

inst_428:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x5555555555555556, x4, 1216, x6)

inst_429:
// rs1_val==4 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, -0x5555555555555555, x4, 1224, x6)

inst_430:
// rs1_val==4 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x6, x4, 1232, x6)

inst_431:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x3333333333333334, x4, 1240, x6)

inst_432:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0x6666666666666667, x4, 1248, x6)

inst_433:
// rs1_val==4 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, -0xb504f332, x4, 1256, x6)

inst_434:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x4, 0xb504f334, x4, 1264, x6)

inst_435:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x11111110, 0x3333333333333332, 0x3, x4, 1272, x6)

inst_436:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x5555555555555555, x4, 1280, x6)

inst_437:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, -0x5555555555555556, x4, 1288, x6)

inst_438:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0xa3d70a3, 0x3333333333333332, 0x5, x4, 1296, x6)

inst_439:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333333, x4, 1304, x6)

inst_440:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x6666666666666666, x4, 1312, x6)

inst_441:
// rs1_val==3689348814741910322 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, -0xb504f333, x4, 1320, x6)

inst_442:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f333, x4, 1328, x6)

inst_443:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x19999999, 0x3333333333333332, 0x2, x4, 1336, x6)

inst_444:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x5555555555555554, x4, 1344, x6)

inst_445:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x3333333333333332, 0x0, x4, 1352, x6)

inst_446:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0xccccccc, 0x3333333333333332, 0x4, x4, 1360, x6)

inst_447:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3333333333333332, 0x3333333333333332, x4, 1368, x6)

inst_448:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x6666666666666665, x4, 1376, x6)

inst_449:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f332, x4, 1384, x6)

inst_450:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x5555555555555556, x4, 1392, x6)

inst_451:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, -0x5555555555555555, x4, 1400, x6)

inst_452:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x8888888, 0x3333333333333332, 0x6, x4, 1408, x6)

inst_453:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333334, x4, 1416, x6)

inst_454:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0x6666666666666667, x4, 1424, x6)

inst_455:
// rs1_val==3689348814741910322 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, -0xb504f332, x4, 1432, x6)

inst_456:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333332, 0xb504f334, x4, 1440, x6)

inst_457:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x22222221, 0x6666666666666665, 0x3, x4, 1448, x6)

inst_458:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, 0x5555555555555555, x4, 1456, x6)

inst_459:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666665, -0x5555555555555556, x4, 1464, x6)

inst_460:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x147ae147, 0x6666666666666665, 0x5, x4, 1472, x6)

inst_461:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, 0x3333333333333333, x4, 1480, x6)

inst_462:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666666, x4, 1488, x6)

inst_463:
// rs1_val==7378697629483820645 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, -0xb504f333, x4, 1496, x6)

inst_464:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666665, 0xb504f333, x4, 1504, x6)

inst_465:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x33333332, 0x6666666666666665, 0x2, x4, 1512, x6)

inst_466:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, 0x5555555555555554, x4, 1520, x6)

inst_467:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x6666666666666665, 0x0, x4, 1528, x6)

inst_468:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x19999999, 0x6666666666666665, 0x4, x4, 1536, x6)

inst_469:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x6666666666666665, 0x3333333333333332, x4, 1544, x6)

inst_470:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, 0x6666666666666665, x4, 1552, x6)

inst_471:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666665, 0xb504f332, x4, 1560, x6)

inst_472:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, 0x5555555555555556, x4, 1568, x6)

inst_473:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666665, -0x5555555555555555, x4, 1576, x6)

inst_474:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x11111110, 0x6666666666666665, 0x6, x4, 1584, x6)

inst_475:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, 0x3333333333333334, x4, 1592, x6)

inst_476:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666667, x4, 1600, x6)

inst_477:
// rs1_val==7378697629483820645 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666665, -0xb504f332, x4, 1608, x6)

inst_478:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666665, 0xb504f334, x4, 1616, x6)

inst_479:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, -0x18fe599a, 0xb504f332, 0x3, x4, 1624, x6)

inst_480:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, 0x5555555555555555, x4, 1632, x6)

inst_481:
// rs1_val==3037000498 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, -0x5555555555555556, x4, 1640, x6)

inst_482:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, -0xeff028f, 0xb504f332, 0x5, x4, 1648, x6)

inst_483:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f332, 0x3333333333333333, x4, 1656, x6)

inst_484:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, 0x6666666666666666, x4, 1664, x6)

inst_485:
// rs1_val==3037000498 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f332, -0xb504f333, x4, 1672, x6)

inst_486:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0xb504f332, 0xb504f333, x4, 1680, x6)

inst_487:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, -0x257d8667, 0xb504f332, 0x2, x4, 1688, x6)

inst_488:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, 0x5555555555555554, x4, 1696, x6)

inst_489:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0xb504f332, 0x0, x4, 1704, x6)

inst_490:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, -0x12bec333, 0xb504f332, 0x4, x4, 1712, x6)

inst_491:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f332, 0x3333333333333332, x4, 1720, x6)

inst_492:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, 0x6666666666666665, x4, 1728, x6)

inst_493:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0xb504f332, 0xb504f332, x4, 1736, x6)

inst_494:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, 0x5555555555555556, x4, 1744, x6)

inst_495:
// rs1_val==3037000498 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, -0x5555555555555555, x4, 1752, x6)

inst_496:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, -0xc7f2ccd, 0xb504f332, 0x6, x4, 1760, x6)

inst_497:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f332, 0x3333333333333334, x4, 1768, x6)

inst_498:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f332, 0x6666666666666667, x4, 1776, x6)

inst_499:
// rs1_val==3037000498 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f332, -0xb504f332, x4, 1784, x6)

inst_500:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0xb504f332, 0xb504f334, x4, 1792, x6)

inst_501:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x1c71c71c, 0x5555555555555556, 0x3, x4, 1800, x6)

inst_502:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, 0x5555555555555555, x4, 1808, x6)

inst_503:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555556, -0x5555555555555556, x4, 1816, x6)

inst_504:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x11111111, 0x5555555555555556, 0x5, x4, 1824, x6)

inst_505:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, 0x3333333333333333, x4, 1832, x6)

inst_506:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555556, 0x6666666666666666, x4, 1840, x6)

inst_507:
// rs1_val==6148914691236517206 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, -0xb504f333, x4, 1848, x6)

inst_508:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555556, 0xb504f333, x4, 1856, x6)

inst_509:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x2aaaaaab, 0x5555555555555556, 0x2, x4, 1864, x6)

inst_510:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, 0x5555555555555554, x4, 1872, x6)

inst_511:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x5555555555555556, 0x0, x4, 1880, x6)

inst_512:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x15555555, 0x5555555555555556, 0x4, x4, 1888, x6)

inst_513:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, 0x3333333333333332, x4, 1896, x6)

inst_514:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555556, 0x6666666666666665, x4, 1904, x6)

inst_515:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555556, 0xb504f332, x4, 1912, x6)

inst_516:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, 0x5555555555555556, x4, 1920, x6)

inst_517:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555556, -0x5555555555555555, x4, 1928, x6)

inst_518:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0xe38e38e, 0x5555555555555556, 0x6, x4, 1936, x6)

inst_519:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, 0x3333333333333334, x4, 1944, x6)

inst_520:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x5555555555555556, 0x6666666666666667, x4, 1952, x6)

inst_521:
// rs1_val==6148914691236517206 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x5555555555555556, -0xb504f332, x4, 1960, x6)

inst_522:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x5555555555555556, 0xb504f334, x4, 1968, x6)

inst_523:
// rs1_val==-6148914691236517205 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, -0x1c71c71c, -0x5555555555555555, 0x3, x4, 1976, x6)

inst_524:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555555, 0x5555555555555555, x4, 1984, x6)

inst_525:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555555, -0x5555555555555556, x4, 1992, x6)

inst_526:
// rs1_val==-6148914691236517205 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, -0x11111111, -0x5555555555555555, 0x5, x4, 2000, x6)

inst_527:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555555, 0x3333333333333333, x4, 2008, x6)

inst_528:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555555, 0x6666666666666666, x4, 2016, x6)

inst_529:
// rs1_val==-6148914691236517205 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555555, -0xb504f333, x4, 2024, x6)

inst_530:
// rs1_val==-6148914691236517205 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555555, 0xb504f333, x4, 2032, x6)

inst_531:
// rs1_val==-6148914691236517205 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, -0x2aaaaaaa, -0x5555555555555555, 0x2, x4, 2040, x6)
RVTEST_SIGBASE( x4,signature_x4_2)

inst_532:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555555, 0x5555555555555554, x4, 0, x6)

inst_533:
// rs1_val==-6148914691236517205 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x5555555555555555, 0x0, x4, 8, x6)

inst_534:
// rs1_val==-6148914691236517205 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, -0x15555555, -0x5555555555555555, 0x4, x4, 16, x6)

inst_535:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555555, 0x3333333333333332, x4, 24, x6)

inst_536:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555555, 0x6666666666666665, x4, 32, x6)

inst_537:
// rs1_val==-6148914691236517205 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555555, 0xb504f332, x4, 40, x6)

inst_538:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555555, 0x5555555555555556, x4, 48, x6)

inst_539:
// rs1_val==0 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x4, x4, 56, x6)

inst_540:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555555, -0x5555555555555555, x4, 64, x6)

inst_541:
// rs1_val==-6148914691236517205 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, -0xe38e38e, -0x5555555555555555, 0x6, x4, 72, x6)

inst_542:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555555, 0x3333333333333334, x4, 80, x6)

inst_543:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x5555555555555555, 0x6666666666666667, x4, 88, x6)

inst_544:
// rs1_val==-6148914691236517205 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0x5555555555555555, -0xb504f332, x4, 96, x6)

inst_545:
// rs1_val==-6148914691236517205 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0x5555555555555555, 0xb504f334, x4, 104, x6)

inst_546:
// rs1_val==6 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x6, 0x3, x4, 112, x6)

inst_547:
// rs1_val==6 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, -0x5555555555555556, x4, 120, x6)

inst_548:
// rs1_val==6 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6, 0x5, x4, 128, x6)

inst_549:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x3333333333333333, x4, 136, x6)

inst_550:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x6666666666666666, x4, 144, x6)

inst_551:
// rs1_val==6 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, -0xb504f333, x4, 152, x6)

inst_552:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0xb504f333, x4, 160, x6)

inst_553:
// rs1_val==6 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x3, 0x6, 0x2, x4, 168, x6)

inst_554:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x5555555555555554, x4, 176, x6)

inst_555:
// rs1_val==6 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x6, 0x0, x4, 184, x6)

inst_556:
// rs1_val==6 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6, 0x4, x4, 192, x6)

inst_557:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x3333333333333332, x4, 200, x6)

inst_558:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x6666666666666665, x4, 208, x6)

inst_559:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0xb504f332, x4, 216, x6)

inst_560:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x5555555555555556, x4, 224, x6)

inst_561:
// rs1_val==6 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, -0x5555555555555555, x4, 232, x6)

inst_562:
// rs1_val==6 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6, 0x6, x4, 240, x6)

inst_563:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x3333333333333334, x4, 248, x6)

inst_564:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0x6666666666666667, x4, 256, x6)

inst_565:
// rs1_val==6 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, -0xb504f332, x4, 264, x6)

inst_566:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, 0xb504f334, x4, 272, x6)

inst_567:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x11111111, 0x3333333333333334, 0x3, x4, 280, x6)

inst_568:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0x5555555555555555, x4, 288, x6)

inst_569:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, -0x5555555555555556, x4, 296, x6)

inst_570:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0xa3d70a4, 0x3333333333333334, 0x5, x4, 304, x6)

inst_571:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3333333333333334, 0x3333333333333333, x4, 312, x6)

inst_572:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0x6666666666666666, x4, 320, x6)

inst_573:
// rs1_val==3689348814741910324 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, -0xb504f333, x4, 328, x6)

inst_574:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f333, x4, 336, x6)

inst_575:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x1999999a, 0x3333333333333334, 0x2, x4, 344, x6)

inst_576:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0x5555555555555554, x4, 352, x6)

inst_577:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x3333333333333334, 0x0, x4, 360, x6)

inst_578:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0xccccccd, 0x3333333333333334, 0x4, x4, 368, x6)

inst_579:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3333333333333334, 0x3333333333333332, x4, 376, x6)

inst_580:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0x6666666666666665, x4, 384, x6)

inst_581:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f332, x4, 392, x6)

inst_582:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0x5555555555555556, x4, 400, x6)

inst_583:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, -0x5555555555555555, x4, 408, x6)

inst_584:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x8888888, 0x3333333333333334, 0x6, x4, 416, x6)

inst_585:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x3333333333333334, 0x3333333333333334, x4, 424, x6)

inst_586:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0x6666666666666667, x4, 432, x6)

inst_587:
// rs1_val==3689348814741910324 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, -0xb504f332, x4, 440, x6)

inst_588:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x3333333333333334, 0xb504f334, x4, 448, x6)

inst_589:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x22222222, 0x6666666666666667, 0x3, x4, 456, x6)

inst_590:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, 0x5555555555555555, x4, 464, x6)

inst_591:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666667, -0x5555555555555556, x4, 472, x6)

inst_592:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0x147ae147, 0x6666666666666667, 0x5, x4, 480, x6)

inst_593:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x6666666666666667, 0x3333333333333333, x4, 488, x6)

inst_594:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, 0x6666666666666666, x4, 496, x6)

inst_595:
// rs1_val==7378697629483820647 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, -0xb504f333, x4, 504, x6)

inst_596:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666667, 0xb504f333, x4, 512, x6)

inst_597:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x33333333, 0x6666666666666667, 0x2, x4, 520, x6)

inst_598:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, 0x5555555555555554, x4, 528, x6)

inst_599:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x6666666666666667, 0x0, x4, 536, x6)

inst_600:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x19999999, 0x6666666666666667, 0x4, x4, 544, x6)

inst_601:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x2, 0x6666666666666667, 0x3333333333333332, x4, 552, x6)

inst_602:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, 0x6666666666666665, x4, 560, x6)

inst_603:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666667, 0xb504f332, x4, 568, x6)

inst_604:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, 0x5555555555555556, x4, 576, x6)

inst_605:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666667, -0x5555555555555555, x4, 584, x6)

inst_606:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0x11111111, 0x6666666666666667, 0x6, x4, 592, x6)

inst_607:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, 0x3333333333333334, x4, 600, x6)

inst_608:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, 0x6666666666666667, x4, 608, x6)

inst_609:
// rs1_val==7378697629483820647 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0x6666666666666667, -0xb504f332, x4, 616, x6)

inst_610:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0x6666666666666667, 0xb504f334, x4, 624, x6)

inst_611:
// rs1_val==-3037000498 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, 0x18fe599a, -0xb504f332, 0x3, x4, 632, x6)

inst_612:
// rs1_val==-3037000498 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, 0x5555555555555555, x4, 640, x6)

inst_613:
// rs1_val==-3037000498 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, -0x5555555555555556, x4, 648, x6)

inst_614:
// rs1_val==-3037000498 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, 0xeff028f, -0xb504f332, 0x5, x4, 656, x6)

inst_615:
// rs1_val==-3037000498 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f332, 0x3333333333333333, x4, 664, x6)

inst_616:
// rs1_val==-3037000498 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, 0x6666666666666666, x4, 672, x6)

inst_617:
// rs1_val==-3037000498 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f332, -0xb504f333, x4, 680, x6)

inst_618:
// rs1_val==-3037000498 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0xb504f332, 0xb504f333, x4, 688, x6)

inst_619:
// rs1_val==-3037000498 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x257d8667, -0xb504f332, 0x2, x4, 696, x6)

inst_620:
// rs1_val==-3037000498 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, 0x5555555555555554, x4, 704, x6)

inst_621:
// rs1_val==-3037000498 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0xb504f332, 0x0, x4, 712, x6)

inst_622:
// rs1_val==-3037000498 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, 0x12bec333, -0xb504f332, 0x4, x4, 720, x6)

inst_623:
// rs1_val==-3037000498 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f332, 0x3333333333333332, x4, 728, x6)

inst_624:
// rs1_val==-3037000498 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, 0x6666666666666665, x4, 736, x6)

inst_625:
// rs1_val==-3037000498 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0xb504f332, 0xb504f332, x4, 744, x6)

inst_626:
// rs1_val==-3037000498 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, 0x5555555555555556, x4, 752, x6)

inst_627:
// rs1_val==-3037000498 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, -0x5555555555555555, x4, 760, x6)

inst_628:
// rs1_val==-3037000498 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, 0xc7f2ccd, -0xb504f332, 0x6, x4, 768, x6)

inst_629:
// rs1_val==-3037000498 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f332, 0x3333333333333334, x4, 776, x6)

inst_630:
// rs1_val==-3037000498 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0xb504f332, 0x6666666666666667, x4, 784, x6)

inst_631:
// rs1_val==-3037000498 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x1, -0xb504f332, -0xb504f332, x4, 792, x6)

inst_632:
// rs1_val==-3037000498 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, -0x1, -0xb504f332, 0xb504f334, x4, 800, x6)

inst_633:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(divw, x12, x10, x11, -0x18fe5999, 0xb504f334, 0x3, x4, 808, x6)

inst_634:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0x5555555555555555, x4, 816, x6)

inst_635:
// rs1_val==3037000500 and rs2_val==-6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, -0x5555555555555556, x4, 824, x6)

inst_636:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(divw, x12, x10, x11, -0xeff028f, 0xb504f334, 0x5, x4, 832, x6)

inst_637:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f334, 0x3333333333333333, x4, 840, x6)

inst_638:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0x6666666666666666, x4, 848, x6)

inst_639:
// rs1_val==3037000500 and rs2_val==-3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, -0xb504f333, x4, 856, x6)

inst_640:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0xb504f333, x4, 864, x6)

inst_641:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, -0x257d8666, 0xb504f334, 0x2, x4, 872, x6)

inst_642:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0x5555555555555554, x4, 880, x6)

inst_643:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0xb504f334, 0x0, x4, 888, x6)

inst_644:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(divw, x12, x10, x11, -0x12bec333, 0xb504f334, 0x4, x4, 896, x6)

inst_645:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f334, 0x3333333333333332, x4, 904, x6)

inst_646:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0x6666666666666665, x4, 912, x6)

inst_647:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0xb504f332, x4, 920, x6)

inst_648:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0x5555555555555556, x4, 928, x6)

inst_649:
// rs1_val==3037000500 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, -0x5555555555555555, x4, 936, x6)

inst_650:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(divw, x12, x10, x11, -0xc7f2ccc, 0xb504f334, 0x6, x4, 944, x6)

inst_651:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, -0x1, 0xb504f334, 0x3333333333333334, x4, 952, x6)

inst_652:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, 0x6666666666666667, x4, 960, x6)

inst_653:
// rs1_val==3037000500 and rs2_val==-3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0xb504f334, -0xb504f332, x4, 968, x6)

inst_654:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(divw, x12, x10, x11, 0x1, 0xb504f334, 0xb504f334, x4, 976, x6)

inst_655:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0xb504f333, x4, 984, x6)

inst_656:
// rs1_val==0 and rs2_val==2, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x2, x4, 992, x6)

inst_657:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x5555555555555554, x4, 1000, x6)

inst_658:
// rs1_val==0 and rs2_val==0, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, 0x0, 0x0, x4, 1008, x6)

inst_659:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x3333333333333332, x4, 1016, x6)

inst_660:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x6666666666666665, x4, 1024, x6)

inst_661:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0xb504f332, x4, 1032, x6)

inst_662:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x5555555555555556, x4, 1040, x6)

inst_663:
// rs1_val==0 and rs2_val==-6148914691236517205, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555555
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, -0x5555555555555555, x4, 1048, x6)

inst_664:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x3333333333333334, x4, 1056, x6)

inst_665:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x0, 0x6666666666666667, x4, 1064, x6)

inst_666:
// rs1_val > 0 and rs2_val < 0, rs2_val == -134217729
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x8000001
TEST_RR_OP(divw, x12, x10, x11, 0x0, 0x6, -0x8000001, x4, 1072, x6)

inst_667:
// rs1_val < 0 and rs2_val > 0, rs1_val == -137438953473, rs2_val == 17179869184
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:0x400000000
TEST_RR_OP(divw, x12, x10, x11, 0xFFFFFFFFFFFFFFFF, -0x2000000001, 0x400000000, x4, 1080, x6)

inst_668:
// rs2_val == 32, rs1_val == -32769
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0x20
TEST_RR_OP(divw, x12, x10, x11, -0x400, -0x8001, 0x20, x4, 1088, x6)

inst_669:
// rs2_val == 4096, rs1_val == -8589934593
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0x1000
TEST_RR_OP(divw, x12, x10, x11, 0x0, -0x200000001, 0x1000, x4, 1096, x6)

inst_670:
// rs2_val == 16384, rs1_val == 268435456
// opcode: divw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0x4000
TEST_RR_OP(divw, x12, x10, x11, 0x4000, 0x10000000, 0x4000, x4, 1104, x6)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x5_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x5_1:
    .fill 20*(XLEN/32),4,0xdeadbeef


signature_x4_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_2:
    .fill 139*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
