
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 18:15:17 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64im.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the remu instruction of the RISC-V M extension for the remu covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IM")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*I.*M.*);def TEST_CASE_1=True;",remu)

RVTEST_SIGBASE( x4,signature_x4_1)

inst_0:
// rs2 == rd != rs1, rs1==x12, rs2==x27, rd==x27, rs1_val > 0 and rs2_val > 0, rs1_val == 6148914691236517205, rs1_val != rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 18446708889337462783
// opcode: remu ; op1:x12; op2:x27; dest:x27; op1val:0x5555555555555555;  op2val:0xffffdfffffffffff
TEST_RR_OP(remu, x27, x12, x27, 0x5555555555555555, 0x5555555555555555, 0xffffdfffffffffff, x4, 0, x18)

inst_1:
// rs1 == rs2 == rd, rs1==x11, rs2==x11, rd==x11, rs1_val == rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 18446743936270598143, rs1_val == 18446743936270598143
// opcode: remu ; op1:x11; op2:x11; dest:x11; op1val:0xffffffdfffffffff;  op2val:0xffffffdfffffffff
TEST_RR_OP(remu, x11, x11, x11, 0x0, 0xffffffdfffffffff, 0xffffffdfffffffff, x4, 8, x18)

inst_2:
// rs1 == rd != rs2, rs1==x5, rs2==x8, rd==x5, rs2_val == 0, rs1_val == 18446744073709549567
// opcode: remu ; op1:x5; op2:x8; dest:x5; op1val:0xfffffffffffff7ff;  op2val:0x0
TEST_RR_OP(remu, x5, x5, x8, 0xfffffffffffff7ff, 0xfffffffffffff7ff, 0x0, x4, 16, x18)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x19, rs2==x31, rd==x14, rs2_val == (2**(xlen)-1), rs1_val == 12297829382473034410
// opcode: remu ; op1:x19; op2:x31; dest:x14; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xffffffffffffffff
TEST_RR_OP(remu, x14, x19, x31, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, 0xffffffffffffffff, x4, 24, x18)

inst_4:
// rs1 == rs2 != rd, rs1==x14, rs2==x14, rd==x17, rs2_val == 1, rs1_val == 18446708889337462783
// opcode: remu ; op1:x14; op2:x14; dest:x17; op1val:0xffffdfffffffffff;  op2val:0xffffdfffffffffff
TEST_RR_OP(remu, x17, x14, x14, 0x0, 0xffffdfffffffffff, 0xffffdfffffffffff, x4, 32, x18)

inst_5:
// rs1==x26, rs2==x1, rd==x15, rs1_val == 0, rs2_val == 68719476736
// opcode: remu ; op1:x26; op2:x1; dest:x15; op1val:0x0;  op2val:0x1000000000
TEST_RR_OP(remu, x15, x26, x1, 0x0, 0x0, 0x1000000000, x4, 40, x18)

inst_6:
// rs1==x24, rs2==x3, rd==x13, rs1_val == (2**(xlen)-1), rs2_val == 65536
// opcode: remu ; op1:x24; op2:x3; dest:x13; op1val:0xffffffffffffffff;  op2val:0x10000
TEST_RR_OP(remu, x13, x24, x3, 0xffff, 0xffffffffffffffff, 0x10000, x4, 48, x18)

inst_7:
// rs1==x10, rs2==x29, rd==x0, rs1_val == 1, rs2_val == 8192
// opcode: remu ; op1:x10; op2:x29; dest:x0; op1val:0x1;  op2val:0x2000
TEST_RR_OP(remu, x0, x10, x29, 0, 0x1, 0x2000, x4, 56, x18)

inst_8:
// rs1==x25, rs2==x16, rd==x23, rs2_val == 2, rs1_val==7378697629483820646 and rs2_val==2
// opcode: remu ; op1:x25; op2:x16; dest:x23; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(remu, x23, x25, x16, 0x0, 0x6666666666666666, 0x2, x4, 64, x18)

inst_9:
// rs1==x27, rs2==x2, rd==x6, rs2_val == 4, rs1_val == 16
// opcode: remu ; op1:x27; op2:x2; dest:x6; op1val:0x10;  op2val:0x4
TEST_RR_OP(remu, x6, x27, x2, 0x0, 0x10, 0x4, x4, 72, x18)

inst_10:
// rs1==x0, rs2==x7, rd==x10, rs2_val == 8, rs1_val == 262144
// opcode: remu ; op1:x0; op2:x7; dest:x10; op1val:0x0;  op2val:0x8
TEST_RR_OP(remu, x10, x0, x7, 0x0, 0x0, 0x8, x4, 80, x18)

inst_11:
// rs1==x21, rs2==x6, rd==x29, rs2_val == 16, rs1_val == 18446726481523507199
// opcode: remu ; op1:x21; op2:x6; dest:x29; op1val:0xffffefffffffffff;  op2val:0x10
TEST_RR_OP(remu, x29, x21, x6, 0xf, 0xffffefffffffffff, 0x10, x4, 88, x18)

inst_12:
// rs1==x15, rs2==x9, rd==x7, rs2_val == 32, rs1_val == 65536
// opcode: remu ; op1:x15; op2:x9; dest:x7; op1val:0x10000;  op2val:0x20
TEST_RR_OP(remu, x7, x15, x9, 0x0, 0x10000, 0x20, x4, 96, x18)

inst_13:
// rs1==x17, rs2==x15, rd==x25, rs2_val == 64, rs1_val == 1073741824
// opcode: remu ; op1:x17; op2:x15; dest:x25; op1val:0x40000000;  op2val:0x40
TEST_RR_OP(remu, x25, x17, x15, 0x0, 0x40000000, 0x40, x4, 104, x18)

inst_14:
// rs1==x7, rs2==x22, rd==x20, rs2_val == 128, rs1_val == 4194304
// opcode: remu ; op1:x7; op2:x22; dest:x20; op1val:0x400000;  op2val:0x80
TEST_RR_OP(remu, x20, x7, x22, 0x0, 0x400000, 0x80, x4, 112, x18)

inst_15:
// rs1==x2, rs2==x19, rd==x30, rs2_val == 256, 
// opcode: remu ; op1:x2; op2:x19; dest:x30; op1val:0x6;  op2val:0x100
TEST_RR_OP(remu, x30, x2, x19, 0x6, 0x6, 0x100, x4, 120, x14)
RVTEST_SIGBASE( x7,signature_x7_0)

inst_16:
// rs1==x8, rs2==x13, rd==x4, rs2_val == 512, 
// opcode: remu ; op1:x8; op2:x13; dest:x4; op1val:0x1;  op2val:0x200
TEST_RR_OP(remu, x4, x8, x13, 0x1, 0x1, 0x200, x7, 0, x14)

inst_17:
// rs1==x28, rs2==x5, rd==x9, rs2_val == 1024, rs1_val == 281474976710656
// opcode: remu ; op1:x28; op2:x5; dest:x9; op1val:0x1000000000000;  op2val:0x400
TEST_RR_OP(remu, x9, x28, x5, 0x0, 0x1000000000000, 0x400, x7, 8, x14)

inst_18:
// rs1==x30, rs2==x21, rd==x28, rs2_val == 2048, 
// opcode: remu ; op1:x30; op2:x21; dest:x28; op1val:0x5555555555555555;  op2val:0x800
TEST_RR_OP(remu, x28, x30, x21, 0x555, 0x5555555555555555, 0x800, x7, 16, x14)

inst_19:
// rs1==x18, rs2==x12, rd==x21, rs2_val == 4096, rs1_val == 17592186044416
// opcode: remu ; op1:x18; op2:x12; dest:x21; op1val:0x100000000000;  op2val:0x1000
TEST_RR_OP(remu, x21, x18, x12, 0x0, 0x100000000000, 0x1000, x7, 24, x14)

inst_20:
// rs1==x13, rs2==x4, rd==x26, rs2_val == 16384, rs1_val == 1152921504606846976
// opcode: remu ; op1:x13; op2:x4; dest:x26; op1val:0x1000000000000000;  op2val:0x4000
TEST_RR_OP(remu, x26, x13, x4, 0x0, 0x1000000000000000, 0x4000, x7, 32, x14)

inst_21:
// rs1==x3, rs2==x17, rd==x16, rs2_val == 32768, rs1_val == 18410715276690587647
// opcode: remu ; op1:x3; op2:x17; dest:x16; op1val:0xff7fffffffffffff;  op2val:0x8000
TEST_RR_OP(remu, x16, x3, x17, 0x7fff, 0xff7fffffffffffff, 0x8000, x7, 40, x14)

inst_22:
// rs1==x9, rs2==x30, rd==x31, rs2_val == 131072, rs1_val == 2097152
// opcode: remu ; op1:x9; op2:x30; dest:x31; op1val:0x200000;  op2val:0x20000
TEST_RR_OP(remu, x31, x9, x30, 0x0, 0x200000, 0x20000, x7, 48, x14)

inst_23:
// rs1==x31, rs2==x28, rd==x22, rs2_val == 262144, 
// opcode: remu ; op1:x31; op2:x28; dest:x22; op1val:0x10;  op2val:0x40000
TEST_RR_OP(remu, x22, x31, x28, 0x10, 0x10, 0x40000, x7, 56, x14)

inst_24:
// rs1==x16, rs2==x20, rd==x12, rs2_val == 524288, rs1_val == 4
// opcode: remu ; op1:x16; op2:x20; dest:x12; op1val:0x4;  op2val:0x80000
TEST_RR_OP(remu, x12, x16, x20, 0x4, 0x4, 0x80000, x7, 64, x14)

inst_25:
// rs1==x4, rs2==x25, rd==x8, rs2_val == 1048576, 
// opcode: remu ; op1:x4; op2:x25; dest:x8; op1val:0xffffffffffffffff;  op2val:0x100000
TEST_RR_OP(remu, x8, x4, x25, 0xfffff, 0xffffffffffffffff, 0x100000, x7, 72, x14)

inst_26:
// rs1==x22, rs2==x24, rd==x19, rs2_val == 2097152, rs1_val == 4294967296
// opcode: remu ; op1:x22; op2:x24; dest:x19; op1val:0x100000000;  op2val:0x200000
TEST_RR_OP(remu, x19, x22, x24, 0x0, 0x100000000, 0x200000, x7, 80, x14)

inst_27:
// rs1==x1, rs2==x10, rd==x24, rs2_val == 4194304, rs1_val == 32
// opcode: remu ; op1:x1; op2:x10; dest:x24; op1val:0x20;  op2val:0x400000
TEST_RR_OP(remu, x24, x1, x10, 0x20, 0x20, 0x400000, x7, 88, x14)

inst_28:
// rs1==x6, rs2==x26, rd==x2, rs2_val == 8388608, 
// opcode: remu ; op1:x6; op2:x26; dest:x2; op1val:0xb504f332;  op2val:0x800000
TEST_RR_OP(remu, x2, x6, x26, 0x4f332, 0xb504f332, 0x800000, x7, 96, x14)

inst_29:
// rs1==x23, rs2==x0, rd==x1, rs2_val == 16777216, rs1_val == 18446744073709551599
// opcode: remu ; op1:x23; op2:x0; dest:x1; op1val:0xffffffffffffffef;  op2val:0x0
TEST_RR_OP(remu, x1, x23, x0, 0xffffffffffffffef, 0xffffffffffffffef, 0x0, x7, 104, x14)

inst_30:
// rs1==x29, rs2==x23, rd==x18, rs2_val == 33554432, rs1_val == 2
// opcode: remu ; op1:x29; op2:x23; dest:x18; op1val:0x2;  op2val:0x2000000
TEST_RR_OP(remu, x18, x29, x23, 0x2, 0x2, 0x2000000, x7, 112, x14)

inst_31:
// rs1==x20, rs2==x18, rd==x3, rs2_val == 67108864, rs1_val == 18446744073709486079
// opcode: remu ; op1:x20; op2:x18; dest:x3; op1val:0xfffffffffffeffff;  op2val:0x4000000
TEST_RR_OP(remu, x3, x20, x18, 0x3feffff, 0xfffffffffffeffff, 0x4000000, x7, 120, x14)

inst_32:
// rs2_val == 134217728, rs1_val == 18446743798831644671
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffbfffffffff;  op2val:0x8000000
TEST_RR_OP(remu, x12, x10, x11, 0x7ffffff, 0xffffffbfffffffff, 0x8000000, x7, 128, x14)

inst_33:
// rs2_val == 268435456, rs1_val == 536870912
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x10000000
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x20000000, 0x10000000, x7, 136, x1)

inst_34:
// rs2_val == 536870912, rs1_val == 18446744073642442751
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffbffffff;  op2val:0x20000000
TEST_RR_OP(remu, x12, x10, x11, 0x1bffffff, 0xfffffffffbffffff, 0x20000000, x7, 144, x1)

inst_35:
// rs2_val == 1073741824, rs1_val == 16777216
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x40000000
TEST_RR_OP(remu, x12, x10, x11, 0x1000000, 0x1000000, 0x40000000, x7, 152, x1)

inst_36:
// rs2_val == 2147483648, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x80000000
TEST_RR_OP(remu, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x80000000, x7, 160, x1)

inst_37:
// rs2_val == 4294967296, rs1_val == 18446744039349813247
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffff7ffffffff;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xfffffff7ffffffff, 0x100000000, x7, 168, x1)

inst_38:
// rs2_val == 8589934592, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x200000000
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x200000000, x7, 176, x1)

inst_39:
// rs2_val == 17179869184, rs1_val == 18446603336221196287
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffff7fffffffffff;  op2val:0x400000000
TEST_RR_OP(remu, x12, x10, x11, 0x3ffffffff, 0xffff7fffffffffff, 0x400000000, x7, 184, x1)

inst_40:
// rs2_val == 34359738368, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x800000000
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x800000000, x7, 192, x1)

inst_41:
// rs2_val == 137438953472, rs1_val == 17870283321406128127
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xf7ffffffffffffff;  op2val:0x2000000000
TEST_RR_OP(remu, x12, x10, x11, 0x1fffffffff, 0xf7ffffffffffffff, 0x2000000000, x7, 200, x1)

inst_42:
// rs2_val == 274877906944, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x4000000000
TEST_RR_OP(remu, x12, x10, x11, 0x2aaaaaaaaa, 0xaaaaaaaaaaaaaaaa, 0x4000000000, x7, 208, x1)

inst_43:
// rs2_val == 549755813888, rs1_val == 18428729675200069631
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffbfffffffffffff;  op2val:0x8000000000
TEST_RR_OP(remu, x12, x10, x11, 0x7fffffffff, 0xffbfffffffffffff, 0x8000000000, x7, 216, x1)

inst_44:
// rs2_val == 1099511627776, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x10000000000
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x10000000000, x7, 224, x1)

inst_45:
// rs2_val == 2199023255552, rs1_val == 9223372036854775808
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000000;  op2val:0x20000000000
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x8000000000000000, 0x20000000000, x7, 232, x1)

inst_46:
// rs2_val == 4398046511104, rs1_val == 18446744073709551551
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffbf;  op2val:0x40000000000
TEST_RR_OP(remu, x12, x10, x11, 0x3ffffffffbf, 0xffffffffffffffbf, 0x40000000000, x7, 240, x1)

inst_47:
// rs2_val == 8796093022208, rs1_val == 67108864
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x80000000000
TEST_RR_OP(remu, x12, x10, x11, 0x4000000, 0x4000000, 0x80000000000, x7, 248, x1)

inst_48:
// rs2_val == 17592186044416, rs1_val == 18446744073708503039
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffefffff;  op2val:0x100000000000
TEST_RR_OP(remu, x12, x10, x11, 0xfffffefffff, 0xffffffffffefffff, 0x100000000000, x7, 256, x1)

inst_49:
// rs2_val == 35184372088832, rs1_val == 8388608
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:0x200000000000
TEST_RR_OP(remu, x12, x10, x11, 0x800000, 0x800000, 0x200000000000, x7, 264, x1)

inst_50:
// rs2_val == 70368744177664, rs1_val == 9223372036854775807
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:0x400000000000
TEST_RR_OP(remu, x12, x10, x11, 0x3fffffffffff, 0x7fffffffffffffff, 0x400000000000, x7, 272, x1)

inst_51:
// rs2_val == 140737488355328, rs1_val == 18446744073709027327
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffff7ffff;  op2val:0x800000000000
TEST_RR_OP(remu, x12, x10, x11, 0x7ffffff7ffff, 0xfffffffffff7ffff, 0x800000000000, x7, 280, x1)

inst_52:
// rs2_val == 281474976710656, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x9;  op2val:0x1000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x9, 0x9, 0x1000000000000, x7, 288, x1)

inst_53:
// rs2_val == 562949953421312, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x1555555555555, 0x5555555555555555, 0x2000000000000, x7, 296, x1)

inst_54:
// rs2_val == 1125899906842624, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x4000000000000, x7, 304, x1)

inst_55:
// rs2_val == 2251799813685248, rs1_val == 68719476736
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0x8000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x1000000000, 0x1000000000, 0x8000000000000, x7, 312, x1)

inst_56:
// rs2_val == 4503599627370496, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffbfffffffff;  op2val:0x10000000000000
TEST_RR_OP(remu, x12, x10, x11, 0xfffbfffffffff, 0xffffffbfffffffff, 0x10000000000000, x7, 320, x1)

inst_57:
// rs2_val == 9007199254740992, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x20000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x20000000000000, x7, 328, x1)

inst_58:
// rs2_val == 18014398509481984, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x9;  op2val:0x40000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x9, 0x9, 0x40000000000000, x7, 336, x1)

inst_59:
// rs2_val == 36028797018963968, rs1_val == 18444492273895866367
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfff7ffffffffffff;  op2val:0x80000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x77ffffffffffff, 0xfff7ffffffffffff, 0x80000000000000, x7, 344, x1)

inst_60:
// rs2_val == 72057594037927936, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x100000000000000, x7, 352, x1)

inst_61:
// rs2_val == 144115188075855872, rs1_val == 1048576
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0x200000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x100000, 0x100000, 0x200000000000000, x7, 360, x1)

inst_62:
// rs2_val == 288230376151711744, rs1_val == 18446744073709535231
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffbfff;  op2val:0x400000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x3ffffffffffbfff, 0xffffffffffffbfff, 0x400000000000000, x7, 368, x1)

inst_63:
// rs2_val == 576460752303423488, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0x800000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x20000000, 0x20000000, 0x800000000000000, x7, 376, x1)

inst_64:
// rs2_val == 1152921504606846976, rs1_val == 256
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:0x1000000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x100, 0x100, 0x1000000000000000, x7, 384, x1)

inst_65:
// rs2_val == 2305843009213693952, rs1_val == 18446744073172680703
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffdfffffff;  op2val:0x2000000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x1fffffffdfffffff, 0xffffffffdfffffff, 0x2000000000000000, x7, 392, x1)

inst_66:
// rs2_val == 4611686018427387904, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x4000000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x100000000000, 0x100000000000, 0x4000000000000000, x7, 400, x1)

inst_67:
// rs2_val == 9223372036854775808, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x8000000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x400000, 0x400000, 0x8000000000000000, x7, 408, x1)

inst_68:
// rs2_val == 18446744073709551614, rs1_val == 137438953472
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0xfffffffffffffffe
TEST_RR_OP(remu, x12, x10, x11, 0x2000000000, 0x2000000000, 0xfffffffffffffffe, x7, 416, x1)

inst_69:
// rs2_val == 18446744073709551613, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xfffffffffffffffd
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666667, 0x6666666666666667, 0xfffffffffffffffd, x7, 424, x1)

inst_70:
// rs2_val == 18446744073709551611, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xfffffffffffffffb
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0xfffffffffffffffb, x7, 432, x1)

inst_71:
// rs2_val == 18446744073709551607, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffbfff;  op2val:0xfffffffffffffff7
TEST_RR_OP(remu, x12, x10, x11, 0xffffffffffffbfff, 0xffffffffffffbfff, 0xfffffffffffffff7, x7, 440, x1)

inst_72:
// rs2_val == 18446744073709551599, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xffffffffffffffef
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0xffffffffffffffef, x7, 448, x1)

inst_73:
// rs2_val == 18446744073709551583, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0xffffffffffffffdf
TEST_RR_OP(remu, x12, x10, x11, 0x100000, 0x100000, 0xffffffffffffffdf, x7, 456, x1)

inst_74:
// rs2_val == 18446744073709551551, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xffffffffffffffbf
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0xffffffffffffffbf, x7, 464, x1)

inst_75:
// rs2_val == 18446744073709551487, rs1_val == 18446739675663040511
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffbffffffffff;  op2val:0xffffffffffffff7f
TEST_RR_OP(remu, x12, x10, x11, 0xfffffbffffffffff, 0xfffffbffffffffff, 0xffffffffffffff7f, x7, 472, x1)

inst_76:
// rs2_val == 18446744073709551359, rs1_val == 524288
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0xfffffffffffffeff
TEST_RR_OP(remu, x12, x10, x11, 0x80000, 0x80000, 0xfffffffffffffeff, x7, 480, x1)

inst_77:
// rs2_val == 18446744073709551103, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffefffffffffff;  op2val:0xfffffffffffffdff
TEST_RR_OP(remu, x12, x10, x11, 0xffffefffffffffff, 0xffffefffffffffff, 0xfffffffffffffdff, x7, 488, x1)

inst_78:
// rs2_val == 18446744073709550591, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffef;  op2val:0xfffffffffffffbff
TEST_RR_OP(remu, x12, x10, x11, 0x3f0, 0xffffffffffffffef, 0xfffffffffffffbff, x7, 496, x1)

inst_79:
// rs2_val == 18446744073709549567, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xfffffffffffff7ff
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, 0xfffffffffffff7ff, x7, 504, x1)

inst_80:
// rs2_val == 18446744073709547519, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xffffffffffffefff
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xffffffffffffefff, x7, 512, x1)

inst_81:
// rs2_val == 18446744073709543423, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x9;  op2val:0xffffffffffffdfff
TEST_RR_OP(remu, x12, x10, x11, 0x9, 0x9, 0xffffffffffffdfff, x7, 520, x1)

inst_82:
// rs2_val == 18446744073709535231, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x12;  op2val:0xffffffffffffbfff
TEST_RR_OP(remu, x12, x10, x11, 0x12, 0x12, 0xffffffffffffbfff, x7, 528, x1)

inst_83:
// rs2_val == 18446744073709518847, rs1_val == 33554432
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:0xffffffffffff7fff
TEST_RR_OP(remu, x12, x10, x11, 0x2000000, 0x2000000, 0xffffffffffff7fff, x7, 536, x1)

inst_84:
// rs2_val == 18446744073709486079, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xe;  op2val:0xfffffffffffeffff
TEST_RR_OP(remu, x12, x10, x11, 0xe, 0xe, 0xfffffffffffeffff, x7, 544, x1)

inst_85:
// rs2_val == 18446744073709420543, rs1_val == 18014398509481984
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0xfffffffffffdffff
TEST_RR_OP(remu, x12, x10, x11, 0x40000000000000, 0x40000000000000, 0xfffffffffffdffff, x7, 552, x1)

inst_86:
// rs2_val == 18446744073709289471, rs1_val == 18446744004990074879
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffefffffffff;  op2val:0xfffffffffffbffff
TEST_RR_OP(remu, x12, x10, x11, 0xffffffefffffffff, 0xffffffefffffffff, 0xfffffffffffbffff, x7, 560, x1)

inst_87:
// rs2_val == 18446744073709027327, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xfffffffffff7ffff
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xfffffffffff7ffff, x7, 568, x1)

inst_88:
// rs2_val == 18446744073708503039, rs1_val == 64
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0xffffffffffefffff
TEST_RR_OP(remu, x12, x10, x11, 0x40, 0x40, 0xffffffffffefffff, x7, 576, x1)

inst_89:
// rs2_val == 18446744073707454463, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffff7ffff;  op2val:0xffffffffffdfffff
TEST_RR_OP(remu, x12, x10, x11, 0x180000, 0xfffffffffff7ffff, 0xffffffffffdfffff, x7, 584, x1)

inst_90:
// rs2_val == 18446744073705357311, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xffffffffffbfffff
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, 0xffffffffffbfffff, x7, 592, x1)

inst_91:
// rs2_val == 18446744073701163007, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xffffffffff7fffff
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0xffffffffff7fffff, x7, 600, x1)

inst_92:
// rs2_val == 18446744073692774399, rs1_val == 1125899906842624
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0xfffffffffeffffff
TEST_RR_OP(remu, x12, x10, x11, 0x4000000000000, 0x4000000000000, 0xfffffffffeffffff, x7, 608, x1)

inst_93:
// rs2_val == 18446744073675997183, rs1_val == 18446744065119617023
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffdffffffff;  op2val:0xfffffffffdffffff
TEST_RR_OP(remu, x12, x10, x11, 0xfffffffdffffffff, 0xfffffffdffffffff, 0xfffffffffdffffff, x7, 616, x1)

inst_94:
// rs2_val == 18446744073642442751, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xfffffffffbffffff
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xfffffffffbffffff, x7, 624, x1)

inst_95:
// rs2_val == 18446744073575333887, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0xfffffffff7ffffff
TEST_RR_OP(remu, x12, x10, x11, 0x100000000000, 0x100000000000, 0xfffffffff7ffffff, x7, 632, x1)

inst_96:
// rs2_val == 18446744073441116159, rs1_val == 18446744073709550591
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffbff;  op2val:0xffffffffefffffff
TEST_RR_OP(remu, x12, x10, x11, 0xffffc00, 0xfffffffffffffbff, 0xffffffffefffffff, x7, 640, x1)

inst_97:
// rs2_val == 18446744073172680703, rs1_val == 18446462598732840959
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffeffffffffffff;  op2val:0xffffffffdfffffff
TEST_RR_OP(remu, x12, x10, x11, 0xfffeffffffffffff, 0xfffeffffffffffff, 0xffffffffdfffffff, x7, 648, x1)

inst_98:
// rs2_val == 18446744072635809791, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xffffffffbfffffff
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0xffffffffbfffffff, x7, 656, x1)

inst_99:
// rs2_val == 18446744071562067967, rs1_val == 18302628885633695743
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfdffffffffffffff;  op2val:0xffffffff7fffffff
TEST_RR_OP(remu, x12, x10, x11, 0xfdffffffffffffff, 0xfdffffffffffffff, 0xffffffff7fffffff, x7, 664, x1)

inst_100:
// rs2_val == 18446744069414584319, rs1_val == 18446744073707454463
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffdfffff;  op2val:0xfffffffeffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xffe00000, 0xffffffffffdfffff, 0xfffffffeffffffff, x7, 672, x1)

inst_101:
// rs2_val == 18446744065119617023, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xfffffffdffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xfffffffdffffffff, x7, 680, x1)

inst_102:
// rs2_val == 18446744056529682431, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfff7ffffffffffff;  op2val:0xfffffffbffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xfff7ffffffffffff, 0xfff7ffffffffffff, 0xfffffffbffffffff, x7, 688, x1)

inst_103:
// rs2_val == 18446744039349813247, rs1_val == 576460752303423488
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0xfffffff7ffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x800000000000000, 0x800000000000000, 0xfffffff7ffffffff, x7, 696, x1)

inst_104:
// rs2_val == 18446744004990074879, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0xffffffefffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x4000000, 0x4000000, 0xffffffefffffffff, x7, 704, x1)

inst_105:
// rs2_val == 18446743798831644671, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffbffffff;  op2val:0xffffffbfffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3ffc000000, 0xfffffffffbffffff, 0xffffffbfffffffff, x7, 712, x1)

inst_106:
// rs2_val == 18446743523953737727, rs1_val == 1099511627776
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0xffffff7fffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x10000000000, 0x10000000000, 0xffffff7fffffffff, x7, 720, x1)

inst_107:
// rs2_val == 18446742974197923839, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xfffffeffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0xfffffeffffffffff, x7, 728, x1)

inst_108:
// rs2_val == 18446741874686296063, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0xfffffdffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1000000000000000, 0x1000000000000000, 0xfffffdffffffffff, x7, 736, x1)

inst_109:
// rs2_val == 18446739675663040511, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffdfffffffff;  op2val:0xfffffbffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3e000000000, 0xffffffdfffffffff, 0xfffffbffffffffff, x7, 744, x1)

inst_110:
// rs2_val == 18446735277616529407, rs1_val == 32768
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0xfffff7ffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x8000, 0x8000, 0xfffff7ffffffffff, x7, 752, x1)

inst_111:
// rs2_val == 18446726481523507199, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0xffffefffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x80000, 0x80000, 0xffffefffffffffff, x7, 760, x1)

inst_112:
// rs2_val == 18446673704965373951, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xa;  op2val:0xffffbfffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xa, 0xa, 0xffffbfffffffffff, x7, 768, x1)

inst_113:
// rs2_val == 18446603336221196287, rs1_val == 4398046511104
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0xffff7fffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x40000000000, 0x40000000000, 0xffff7fffffffffff, x7, 776, x1)

inst_114:
// rs2_val == 18446462598732840959, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xf;  op2val:0xfffeffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xf, 0xf, 0xfffeffffffffffff, x7, 784, x1)

inst_115:
// rs2_val == 18446181123756130303, rs1_val == 268435456
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0xfffdffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x10000000, 0x10000000, 0xfffdffffffffffff, x7, 792, x1)

inst_116:
// rs2_val == 18445618173802708991, rs1_val == 18446744073709551487
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffff7f;  op2val:0xfffbffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3ffffffffff80, 0xffffffffffffff7f, 0xfffbffffffffffff, x7, 800, x1)

inst_117:
// rs2_val == 18444492273895866367, rs1_val == 18445618173802708991
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffbffffffffffff;  op2val:0xfff7ffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x4000000000000, 0xfffbffffffffffff, 0xfff7ffffffffffff, x7, 808, x1)

inst_118:
// rs2_val == 18442240474082181119, rs1_val == 8796093022208
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0xffefffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x80000000000, 0x80000000000, 0xffefffffffffffff, x7, 816, x1)

inst_119:
// rs2_val == 18437736874454810623, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0xffdfffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x10000000, 0x10000000, 0xffdfffffffffffff, x7, 824, x1)

inst_120:
// rs2_val == 18428729675200069631, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xff7fffffffffffff;  op2val:0xffbfffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xff7fffffffffffff, 0xff7fffffffffffff, 0xffbfffffffffffff, x7, 832, x1)

inst_121:
// rs2_val == 18410715276690587647, rs1_val == 8192
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:0xff7fffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x2000, 0x2000, 0xff7fffffffffffff, x7, 840, x1)

inst_122:
// rs2_val == 18374686479671623679, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0xfeffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x40, 0x40, 0xfeffffffffffffff, x7, 848, x1)

inst_123:
// rs2_val == 18302628885633695743, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xfdffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0xfdffffffffffffff, x7, 856, x1)

inst_124:
// rs2_val == 18158513697557839871, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0xfbffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1000000, 0x1000000, 0xfbffffffffffffff, x7, 864, x1)

inst_125:
// rs2_val == 17870283321406128127, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffbfffffffffffff;  op2val:0xf7ffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x7c0000000000000, 0xffbfffffffffffff, 0xf7ffffffffffffff, x7, 872, x1)

inst_126:
// rs2_val == 17293822569102704639, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xefffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0xefffffffffffffff, x7, 880, x1)

inst_127:
// rs2_val == 16140901064495857663, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0xdfffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x20000000, 0x20000000, 0xdfffffffffffffff, x7, 888, x1)

inst_128:
// rs2_val == 13835058055282163711, rs1_val == 18446181123756130303
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffdffffffffffff;  op2val:0xbfffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3ffe000000000000, 0xfffdffffffffffff, 0xbfffffffffffffff, x7, 896, x1)

inst_129:
// rs2_val == 9223372036854775807, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x7fffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x7fffffffffffffff, x7, 904, x1)

inst_130:
// rs2_val == 6148914691236517205, rs1_val == 18446742974197923839
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffeffffffffff;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x5555545555555555, 0xfffffeffffffffff, 0x5555555555555555, x7, 912, x1)

inst_131:
// rs2_val == 12297829382473034410, rs1_val == 274877906944
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x4000000000, 0x4000000000, 0xaaaaaaaaaaaaaaaa, x7, 920, x1)

inst_132:
// rs1_val == 8, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x8, 0x6, x7, 928, x1)

inst_133:
// rs1_val == 128, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0x10000000000
TEST_RR_OP(remu, x12, x10, x11, 0x80, 0x80, 0x10000000000, x7, 936, x1)

inst_134:
// rs1_val == 512, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:0xfffffffbffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x200, 0x200, 0xfffffffbffffffff, x7, 944, x1)

inst_135:
// rs1_val == 1024, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:0xa
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x400, 0xa, x7, 952, x1)

inst_136:
// rs1_val == 2048, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0xffffffffffdfffff
TEST_RR_OP(remu, x12, x10, x11, 0x800, 0x800, 0xffffffffffdfffff, x7, 960, x1)

inst_137:
// rs1_val == 4096, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x9
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1000, 0x9, x7, 968, x1)

inst_138:
// rs1_val == 16384, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:0xffffffffffffff7f
TEST_RR_OP(remu, x12, x10, x11, 0x4000, 0x4000, 0xffffffffffffff7f, x7, 976, x1)

inst_139:
// rs1_val == 131072, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0x1000000000
TEST_RR_OP(remu, x12, x10, x11, 0x20000, 0x20000, 0x1000000000, x7, 984, x1)

inst_140:
// rs1_val == 134217728, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0xefffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x8000000, 0x8000000, 0xefffffffffffffff, x7, 992, x1)

inst_141:
// rs1_val == 2147483648, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0xfffffffeffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x80000000, 0x80000000, 0xfffffffeffffffff, x7, 1000, x1)

inst_142:
// rs1_val == 8589934592, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:0x10000000000
TEST_RR_OP(remu, x12, x10, x11, 0x200000000, 0x200000000, 0x10000000000, x7, 1008, x1)

inst_143:
// rs1_val == 17179869184, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:0xfffffffeffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x400000000, 0x400000000, 0xfffffffeffffffff, x7, 1016, x1)

inst_144:
// rs1_val == 34359738368, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x800000000, 0x1, x7, 1024, x1)

inst_145:
// rs1_val == 549755813888, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0xfffffffeffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x8000000000, 0x8000000000, 0xfffffffeffffffff, x7, 1032, x1)

inst_146:
// rs1_val == 2199023255552, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0xfff7ffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x20000000000, 0x20000000000, 0xfff7ffffffffffff, x7, 1040, x1)

inst_147:
// rs1_val == 35184372088832, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0xffefffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x200000000000, 0x200000000000, 0xffefffffffffffff, x7, 1048, x1)

inst_148:
// rs1_val == 70368744177664, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x400000000000, 0x400000000000, 0x6666666666666665, x7, 1056, x1)

inst_149:
// rs1_val == 140737488355328, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x8000000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x800000000000, 0x800000000000, 0x8000000000000000, x7, 1064, x1)

inst_150:
// rs1_val == 562949953421312, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0x9
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2000000000000, 0x9, x7, 1072, x1)

inst_151:
// rs1_val == 2251799813685248, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0xffffffffffff7fff
TEST_RR_OP(remu, x12, x10, x11, 0x8000000000000, 0x8000000000000, 0xffffffffffff7fff, x7, 1080, x1)

inst_152:
// rs1_val == 4503599627370496, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0xfeffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x10000000000000, 0x10000000000000, 0xfeffffffffffffff, x7, 1088, x1)

inst_153:
// rs1_val == 9007199254740992, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0xfffbffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x20000000000000, 0x20000000000000, 0xfffbffffffffffff, x7, 1096, x1)

inst_154:
// rs1_val == 36028797018963968, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0xfffff7ffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x80000000000000, 0x80000000000000, 0xfffff7ffffffffff, x7, 1104, x1)

inst_155:
// rs1_val == 72057594037927936, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0xffefffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x100000000000000, 0x100000000000000, 0xffefffffffffffff, x7, 1112, x1)

inst_156:
// rs1_val == 144115188075855872, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:0x1000
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x200000000000000, 0x1000, x7, 1120, x1)

inst_157:
// rs1_val == 288230376151711744, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0xfff7ffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x400000000000000, 0x400000000000000, 0xfff7ffffffffffff, x7, 1128, x1)

inst_158:
// rs1_val == 2305843009213693952, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x2000000000000000, 0x2000000000000000, 0x5555555555555556, x7, 1136, x1)

inst_159:
// rs1_val == 4611686018427387904, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0xfffffffffffff7ff
TEST_RR_OP(remu, x12, x10, x11, 0x4000000000000000, 0x4000000000000000, 0xfffffffffffff7ff, x7, 1144, x1)

inst_160:
// rs1_val == 18446744073709551614, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffe;  op2val:0x10
TEST_RR_OP(remu, x12, x10, x11, 0xe, 0xfffffffffffffffe, 0x10, x7, 1152, x1)

inst_161:
// rs1_val == 18446744073709551613, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffd;  op2val:0x80
TEST_RR_OP(remu, x12, x10, x11, 0x7d, 0xfffffffffffffffd, 0x80, x7, 1160, x1)

inst_162:
// rs1_val == 18446744073709551611, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffb;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x555555555555554f, 0xfffffffffffffffb, 0x5555555555555556, x7, 1168, x1)

inst_163:
// rs1_val == 18446744073709551607, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffff7;  op2val:0xe
TEST_RR_OP(remu, x12, x10, x11, 0x7, 0xfffffffffffffff7, 0xe, x7, 1176, x1)

inst_164:
// rs1_val == 18446744073709551583, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffdf;  op2val:0x20000000000
TEST_RR_OP(remu, x12, x10, x11, 0x1ffffffffdf, 0xffffffffffffffdf, 0x20000000000, x7, 1184, x1)

inst_165:
// rs1_val == 18446744073709551359, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffeff;  op2val:0xfffffffffff7ffff
TEST_RR_OP(remu, x12, x10, x11, 0x7ff00, 0xfffffffffffffeff, 0xfffffffffff7ffff, x7, 1192, x1)

inst_166:
// rs1_val == 18446744073709551103, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffdff;  op2val:0xffffffffffefffff
TEST_RR_OP(remu, x12, x10, x11, 0xffe00, 0xfffffffffffffdff, 0xffffffffffefffff, x7, 1200, x1)

inst_167:
// rs1_val == 18446744073709547519, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffefff;  op2val:0x400
TEST_RR_OP(remu, x12, x10, x11, 0x3ff, 0xffffffffffffefff, 0x400, x7, 1208, x1)

inst_168:
// rs1_val == 18446744073709543423, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffdfff;  op2val:0xffffffffffbfffff
TEST_RR_OP(remu, x12, x10, x11, 0x3fe000, 0xffffffffffffdfff, 0xffffffffffbfffff, x7, 1216, x1)

inst_169:
// rs1_val == 18446744073709518847, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffff7fff;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x333333333332b331, 0xffffffffffff7fff, 0x6666666666666667, x7, 1224, x1)

inst_170:
// rs1_val == 18446744073709420543, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffdffff;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xfffffffffffdffff, 0x5, x7, 1232, x1)

inst_171:
// rs1_val == 18446744073709289471, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffbffff;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555515555, 0xfffffffffffbffff, 0x5555555555555555, x7, 1240, x1)

inst_172:
// rs1_val == 18446744073705357311, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffbfffff;  op2val:0xfffffffffffff7ff
TEST_RR_OP(remu, x12, x10, x11, 0xffffffffffbfffff, 0xffffffffffbfffff, 0xfffffffffffff7ff, x7, 1248, x1)

inst_173:
// rs1_val == 18446744073701163007, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffff7fffff;  op2val:0xffefffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xfffffff800000, 0xffffffffff7fffff, 0xffefffffffffffff, x7, 1256, x1)

inst_174:
// rs1_val == 18446744073692774399, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffeffffff;  op2val:0xffffffffdfffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1f000000, 0xfffffffffeffffff, 0xffffffffdfffffff, x7, 1264, x1)

inst_175:
// rs1_val == 18446744073675997183, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffdffffff;  op2val:0x4000000000
TEST_RR_OP(remu, x12, x10, x11, 0x3ffdffffff, 0xfffffffffdffffff, 0x4000000000, x7, 1272, x1)

inst_176:
// rs1_val == 18446744073575333887, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffff7ffffff;  op2val:0x4000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x3fffff7ffffff, 0xfffffffff7ffffff, 0x4000000000000, x7, 1280, x1)

inst_177:
// rs1_val == 18446744073441116159, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffefffffff;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x5555555545555554, 0xffffffffefffffff, 0xaaaaaaaaaaaaaaab, x7, 1288, x1)

inst_178:
// rs1_val == 18446744072635809791, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffbfffffff;  op2val:0xfffdffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1ffffc0000000, 0xffffffffbfffffff, 0xfffdffffffffffff, x7, 1296, x1)

inst_179:
// rs1_val == 18446744071562067967, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff7fffffff;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xffffffff7fffffff, 0x2, x7, 1304, x1)

inst_180:
// rs1_val == 18446744069414584319, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffeffffffff;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x58b26147, 0xfffffffeffffffff, 0xb504f334, x7, 1312, x1)

inst_181:
// rs1_val == 18446744056529682431, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffbffffffff;  op2val:0xb
TEST_RR_OP(remu, x12, x10, x11, 0xa, 0xfffffffbffffffff, 0xb, x7, 1320, x1)

inst_182:
// rs1_val == 18446743523953737727, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffff7fffffffff;  op2val:0xfffffbffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x38000000000, 0xffffff7fffffffff, 0xfffffbffffffffff, x7, 1328, x1)

inst_183:
// rs1_val == 18446741874686296063, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffffdffffffffff;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xfffffdffffffffff, 0x5, x7, 1336, x1)

inst_184:
// rs1_val == 18446735277616529407, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfffff7ffffffffff;  op2val:0x8000000
TEST_RR_OP(remu, x12, x10, x11, 0x7ffffff, 0xfffff7ffffffffff, 0x8000000, x7, 1344, x1)

inst_185:
// rs1_val == 18446673704965373951, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffbfffffffffff;  op2val:0x8
TEST_RR_OP(remu, x12, x10, x11, 0x7, 0xffffbfffffffffff, 0x8, x7, 1352, x1)

inst_186:
// rs1_val == 18442240474082181119, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffefffffffffffff;  op2val:0xffbfffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x30000000000000, 0xffefffffffffffff, 0xffbfffffffffffff, x7, 1360, x1)

inst_187:
// rs1_val == 18437736874454810623, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffdfffffffffffff;  op2val:0x8000000000000
TEST_RR_OP(remu, x12, x10, x11, 0x7ffffffffffff, 0xffdfffffffffffff, 0x8000000000000, x7, 1368, x1)

inst_188:
// rs1_val == 18374686479671623679, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfeffffffffffffff;  op2val:0x400000000
TEST_RR_OP(remu, x12, x10, x11, 0x3ffffffff, 0xfeffffffffffffff, 0x400000000, x7, 1376, x1)

inst_189:
// rs1_val == 18158513697557839871, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xfbffffffffffffff;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x5155555555555556, 0xfbffffffffffffff, 0xaaaaaaaaaaaaaaa9, x7, 1384, x1)

inst_190:
// rs1_val == 17293822569102704639, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xefffffffffffffff;  op2val:0xdfffffffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1000000000000000, 0xefffffffffffffff, 0xdfffffffffffffff, x7, 1392, x1)

inst_191:
// rs1_val == 16140901064495857663, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xdfffffffffffffff;  op2val:0x4000
TEST_RR_OP(remu, x12, x10, x11, 0x3fff, 0xdfffffffffffffff, 0x4000, x7, 1400, x1)

inst_192:
// rs1_val == 13835058055282163711, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xbfffffffffffffff;  op2val:0xfffffdffffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xbfffffffffffffff, 0xbfffffffffffffff, 0xfffffdffffffffff, x7, 1408, x1)

inst_193:
// rs1_val==3 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3, 0x3, x7, 1416, x1)

inst_194:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x5555555555555555, x7, 1424, x1)

inst_195:
// rs1_val==3 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xaaaaaaaaaaaaaaaa, x7, 1432, x1)

inst_196:
// rs1_val==3 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x5, x7, 1440, x1)

inst_197:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x3333333333333333, x7, 1448, x1)

inst_198:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x6666666666666666, x7, 1456, x1)

inst_199:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xb504f333, x7, 1464, x1)

inst_200:
// rs1_val==3 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x0, x7, 1472, x1)

inst_201:
// rs1_val==3 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x100000000, x7, 1480, x1)

inst_202:
// rs1_val==3 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x3, 0x2, x7, 1488, x1)

inst_203:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x5555555555555554, x7, 1496, x1)

inst_204:
// rs1_val==3 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xaaaaaaaaaaaaaaa9, x7, 1504, x1)

inst_205:
// rs1_val==3 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x4, x7, 1512, x1)

inst_206:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x3333333333333332, x7, 1520, x1)

inst_207:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x6666666666666665, x7, 1528, x1)

inst_208:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xb504f332, x7, 1536, x1)

inst_209:
// rs1_val==3 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xffffffff, x7, 1544, x1)

inst_210:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x5555555555555556, x7, 1552, x1)

inst_211:
// rs1_val==3 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xaaaaaaaaaaaaaaab, x7, 1560, x1)

inst_212:
// rs1_val==3 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x6, x7, 1568, x1)

inst_213:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x3333333333333334, x7, 1576, x1)

inst_214:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x6666666666666667, x7, 1584, x1)

inst_215:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0xb504f334, x7, 1592, x1)

inst_216:
// rs1_val==3 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3, 0x1, x7, 1600, x1)

inst_217:
// rs1_val==3 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3, 0x100000001, x7, 1608, x1)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x5555555555555555, 0x3, x7, 1616, x1)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555555, x7, 1624, x1)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0xaaaaaaaaaaaaaaaa, x7, 1632, x1)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555555, 0x5, x7, 1640, x1)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222222, 0x5555555555555555, 0x3333333333333333, x7, 1648, x1)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x6666666666666666, x7, 1656, x1)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x72e6206d, 0x5555555555555555, 0xb504f333, x7, 1664, x1)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x0, x7, 1672, x1)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x100000000, x7, 1680, x1)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5555555555555555, 0x2, x7, 1688, x1)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555554, x7, 1696, x1)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0xaaaaaaaaaaaaaaa9, x7, 1704, x1)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5555555555555555, 0x4, x7, 1712, x1)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222223, 0x5555555555555555, 0x3333333333333332, x7, 1720, x1)

inst_232:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x6666666666666665, x7, 1728, x1)

inst_233:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x368f24b3, 0x5555555555555555, 0xb504f332, x7, 1736, x1)

inst_234:
// rs1_val==6148914691236517205 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaa, 0x5555555555555555, 0xffffffff, x7, 1744, x1)

inst_235:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x5555555555555556, x7, 1752, x1)

inst_236:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0xaaaaaaaaaaaaaaab, x7, 1760, x1)

inst_237:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5555555555555555, 0x6, x7, 1768, x1)

inst_238:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222221, 0x5555555555555555, 0x3333333333333334, x7, 1776, x1)

inst_239:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0x5555555555555555, 0x6666666666666667, x7, 1784, x1)

inst_240:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xaf3d1c29, 0x5555555555555555, 0xb504f334, x7, 1792, x1)

inst_241:
// rs1_val==6148914691236517205 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555555, 0x1, x7, 1800, x1)

inst_242:
// rs1_val==6148914691236517205 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555555, 0x100000001, x7, 1808, x1)

inst_243:
// rs1_val==12297829382473034410 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaaa, 0x3, x7, 1816, x1)

inst_244:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5555555555555555, x7, 1824, x1)

inst_245:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, x7, 1832, x1)

inst_246:
// rs1_val==12297829382473034410 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5, x7, 1840, x1)

inst_247:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111111, 0xaaaaaaaaaaaaaaaa, 0x3333333333333333, x7, 1848, x1)

inst_248:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444444, 0xaaaaaaaaaaaaaaaa, 0x6666666666666666, x7, 1856, x1)

inst_249:
// rs1_val==12297829382473034410 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x30c74da7, 0xaaaaaaaaaaaaaaaa, 0xb504f333, x7, 1864, x1)

inst_250:
// rs1_val==12297829382473034410 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, 0x0, x7, 1872, x1)

inst_251:
// rs1_val==12297829382473034410 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaa, 0xaaaaaaaaaaaaaaaa, 0x100000000, x7, 1880, x1)

inst_252:
// rs1_val==12297829382473034410 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x2, x7, 1888, x1)

inst_253:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaaa, 0x5555555555555554, x7, 1896, x1)

inst_254:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaa9, x7, 1904, x1)

inst_255:
// rs1_val==12297829382473034410 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaaa, 0x4, x7, 1912, x1)

inst_256:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111114, 0xaaaaaaaaaaaaaaaa, 0x3333333333333332, x7, 1920, x1)

inst_257:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444445, 0xaaaaaaaaaaaaaaaa, 0x6666666666666665, x7, 1928, x1)

inst_258:
// rs1_val==12297829382473034410 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x6d1e4966, 0xaaaaaaaaaaaaaaaa, 0xb504f332, x7, 1936, x1)

inst_259:
// rs1_val==12297829382473034410 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x55555555, 0xaaaaaaaaaaaaaaaa, 0xffffffff, x7, 1944, x1)

inst_260:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0xaaaaaaaaaaaaaaaa, 0x5555555555555556, x7, 1952, x1)

inst_261:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaab, x7, 1960, x1)

inst_262:
// rs1_val==12297829382473034410 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0xaaaaaaaaaaaaaaaa, 0x6, x7, 1968, x1)

inst_263:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x111111111111110e, 0xaaaaaaaaaaaaaaaa, 0x3333333333333334, x7, 1976, x1)

inst_264:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444443, 0xaaaaaaaaaaaaaaaa, 0x6666666666666667, x7, 1984, x1)

inst_265:
// rs1_val==12297829382473034410 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xa975451e, 0xaaaaaaaaaaaaaaaa, 0xb504f334, x7, 1992, x1)

inst_266:
// rs1_val==12297829382473034410 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x1, x7, 2000, x1)

inst_267:
// rs1_val==12297829382473034410 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x100000001, x7, 2008, x1)

inst_268:
// rs1_val==5 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x5, 0x3, x7, 2016, x1)

inst_269:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x5555555555555555, x7, 2024, x1)

inst_270:
// rs1_val==5 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xaaaaaaaaaaaaaaaa, x7, 2032, x1)

inst_271:
// rs1_val==5 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5, 0x5, x7, 2040, x1)
RVTEST_SIGBASE( x7,signature_x7_1)

inst_272:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x3333333333333333, x7, 0, x1)

inst_273:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x6666666666666666, x7, 8, x1)

inst_274:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xb504f333, x7, 16, x1)

inst_275:
// rs1_val==5 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x0, x7, 24, x1)

inst_276:
// rs1_val==5 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x100000000, x7, 32, x1)

inst_277:
// rs1_val==5 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5, 0x2, x7, 40, x1)

inst_278:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x5555555555555554, x7, 48, x1)

inst_279:
// rs1_val==5 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xaaaaaaaaaaaaaaa9, x7, 56, x1)

inst_280:
// rs1_val==5 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5, 0x4, x7, 64, x1)

inst_281:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x3333333333333332, x7, 72, x1)

inst_282:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x6666666666666665, x7, 80, x1)

inst_283:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xb504f332, x7, 88, x1)

inst_284:
// rs1_val==5 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xffffffff, x7, 96, x1)

inst_285:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x5555555555555556, x7, 104, x1)

inst_286:
// rs1_val==5 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xaaaaaaaaaaaaaaab, x7, 112, x1)

inst_287:
// rs1_val==5 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x6, x7, 120, x1)

inst_288:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x3333333333333334, x7, 128, x1)

inst_289:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x6666666666666667, x7, 136, x1)

inst_290:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0xb504f334, x7, 144, x1)

inst_291:
// rs1_val==5 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5, 0x1, x7, 152, x1)

inst_292:
// rs1_val==5 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x5, 0x100000001, x7, 160, x1)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333333, 0x3, x7, 168, x1)

inst_294:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x5555555555555555, x7, 176, x1)

inst_295:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0xaaaaaaaaaaaaaaaa, x7, 184, x1)

inst_296:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3333333333333333, 0x5, x7, 192, x1)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333333, x7, 200, x1)

inst_298:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x6666666666666666, x7, 208, x1)

inst_299:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x44f079db, 0x3333333333333333, 0xb504f333, x7, 216, x1)

inst_300:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x0, x7, 224, x1)

inst_301:
// rs1_val==3689348814741910323 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x100000000, x7, 232, x1)

inst_302:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x3333333333333333, 0x2, x7, 240, x1)

inst_303:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x5555555555555554, x7, 248, x1)

inst_304:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0xaaaaaaaaaaaaaaa9, x7, 256, x1)

inst_305:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3333333333333333, 0x4, x7, 264, x1)

inst_306:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333332, x7, 272, x1)

inst_307:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x6666666666666665, x7, 280, x1)

inst_308:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x8d58db23, 0x3333333333333333, 0xb504f332, x7, 288, x1)

inst_309:
// rs1_val==3689348814741910323 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x66666666, 0x3333333333333333, 0xffffffff, x7, 296, x1)

inst_310:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x5555555555555556, x7, 304, x1)

inst_311:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0xaaaaaaaaaaaaaaab, x7, 312, x1)

inst_312:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x3333333333333333, 0x6, x7, 320, x1)

inst_313:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x3333333333333334, x7, 328, x1)

inst_314:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x3333333333333333, 0x6666666666666667, x7, 336, x1)

inst_315:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xb18d0bc7, 0x3333333333333333, 0xb504f334, x7, 344, x1)

inst_316:
// rs1_val==3689348814741910323 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333333, 0x1, x7, 352, x1)

inst_317:
// rs1_val==3689348814741910323 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333333, 0x100000001, x7, 360, x1)

inst_318:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666666, 0x3, x7, 368, x1)

inst_319:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111111, 0x6666666666666666, 0x5555555555555555, x7, 376, x1)

inst_320:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0xaaaaaaaaaaaaaaaa, x7, 384, x1)

inst_321:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666666, 0x5, x7, 392, x1)

inst_322:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333333, x7, 400, x1)

inst_323:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666666, x7, 408, x1)

inst_324:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x89e0f3b6, 0x6666666666666666, 0xb504f333, x7, 416, x1)

inst_325:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0x0, x7, 424, x1)

inst_326:
// rs1_val==7378697629483820646 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x66666666, 0x6666666666666666, 0x100000000, x7, 432, x1)

inst_327:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111112, 0x6666666666666666, 0x5555555555555554, x7, 440, x1)

inst_328:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0xaaaaaaaaaaaaaaa9, x7, 448, x1)

inst_329:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x6666666666666666, 0x4, x7, 456, x1)

inst_330:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x6666666666666666, 0x3333333333333332, x7, 464, x1)

inst_331:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666665, x7, 472, x1)

inst_332:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x65acc314, 0x6666666666666666, 0xb504f332, x7, 480, x1)

inst_333:
// rs1_val==7378697629483820646 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xcccccccc, 0x6666666666666666, 0xffffffff, x7, 488, x1)

inst_334:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111110, 0x6666666666666666, 0x5555555555555556, x7, 496, x1)

inst_335:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0xaaaaaaaaaaaaaaab, x7, 504, x1)

inst_336:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666666, 0x6, x7, 512, x1)

inst_337:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x6666666666666666, 0x3333333333333334, x7, 520, x1)

inst_338:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666666, 0x6666666666666666, 0x6666666666666667, x7, 528, x1)

inst_339:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xae15245a, 0x6666666666666666, 0xb504f334, x7, 536, x1)

inst_340:
// rs1_val==7378697629483820646 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666666, 0x1, x7, 544, x1)

inst_341:
// rs1_val==7378697629483820646 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666666, 0x100000001, x7, 552, x1)

inst_342:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0xb504f333, 0x3, x7, 560, x1)

inst_343:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x5555555555555555, x7, 568, x1)

inst_344:
// rs1_val==3037000499 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0xaaaaaaaaaaaaaaaa, x7, 576, x1)

inst_345:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0xb504f333, 0x5, x7, 584, x1)

inst_346:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x3333333333333333, x7, 592, x1)

inst_347:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x6666666666666666, x7, 600, x1)

inst_348:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f333, 0xb504f333, x7, 608, x1)

inst_349:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x0, x7, 616, x1)

inst_350:
// rs1_val==3037000499 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x100000000, x7, 624, x1)

inst_351:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xb504f333, 0x2, x7, 632, x1)

inst_352:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x5555555555555554, x7, 640, x1)

inst_353:
// rs1_val==3037000499 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0xaaaaaaaaaaaaaaa9, x7, 648, x1)

inst_354:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xb504f333, 0x4, x7, 656, x1)

inst_355:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x3333333333333332, x7, 664, x1)

inst_356:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x6666666666666665, x7, 672, x1)

inst_357:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xb504f333, 0xb504f332, x7, 680, x1)

inst_358:
// rs1_val==3037000499 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0xffffffff, x7, 688, x1)

inst_359:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x5555555555555556, x7, 696, x1)

inst_360:
// rs1_val==3037000499 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0xaaaaaaaaaaaaaaab, x7, 704, x1)

inst_361:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0xb504f333, 0x6, x7, 712, x1)

inst_362:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x3333333333333334, x7, 720, x1)

inst_363:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x6666666666666667, x7, 728, x1)

inst_364:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0xb504f334, x7, 736, x1)

inst_365:
// rs1_val==3037000499 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f333, 0x1, x7, 744, x1)

inst_366:
// rs1_val==3037000499 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0xb504f333, 0xb504f333, 0x100000001, x7, 752, x1)

inst_367:
// rs1_val==0 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x3, x7, 760, x1)

inst_368:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x5555555555555555, x7, 768, x1)

inst_369:
// rs1_val==0 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xaaaaaaaaaaaaaaaa, x7, 776, x1)

inst_370:
// rs1_val==0 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x5, x7, 784, x1)

inst_371:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x3333333333333333, x7, 792, x1)

inst_372:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x6666666666666666, x7, 800, x1)

inst_373:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xb504f333, x7, 808, x1)

inst_374:
// rs1_val==0 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x0, x7, 816, x1)

inst_375:
// rs1_val==0 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x100000000, x7, 824, x1)

inst_376:
// rs1_val==0 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x2, x7, 832, x1)

inst_377:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x5555555555555554, x7, 840, x1)

inst_378:
// rs1_val==0 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xaaaaaaaaaaaaaaa9, x7, 848, x1)

inst_379:
// rs1_val==0 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x4, x7, 856, x1)

inst_380:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x3333333333333332, x7, 864, x1)

inst_381:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x6666666666666665, x7, 872, x1)

inst_382:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xb504f332, x7, 880, x1)

inst_383:
// rs1_val==0 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xffffffff, x7, 888, x1)

inst_384:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x5555555555555556, x7, 896, x1)

inst_385:
// rs1_val==0 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xaaaaaaaaaaaaaaab, x7, 904, x1)

inst_386:
// rs1_val==0 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x6, x7, 912, x1)

inst_387:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x3333333333333334, x7, 920, x1)

inst_388:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x6666666666666667, x7, 928, x1)

inst_389:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0xb504f334, x7, 936, x1)

inst_390:
// rs1_val==0 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x1, x7, 944, x1)

inst_391:
// rs1_val==0 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x0, 0x100000001, x7, 952, x1)

inst_392:
// rs1_val==4294967296 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x100000000, 0x3, x7, 960, x1)

inst_393:
// rs1_val==4294967296 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x5555555555555555, x7, 968, x1)

inst_394:
// rs1_val==4294967296 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0xaaaaaaaaaaaaaaaa, x7, 976, x1)

inst_395:
// rs1_val==4294967296 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x100000000, 0x5, x7, 984, x1)

inst_396:
// rs1_val==4294967296 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x3333333333333333, x7, 992, x1)

inst_397:
// rs1_val==4294967296 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x6666666666666666, x7, 1000, x1)

inst_398:
// rs1_val==4294967296 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0ccd, 0x100000000, 0xb504f333, x7, 1008, x1)

inst_399:
// rs1_val==4294967296 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x0, x7, 1016, x1)

inst_400:
// rs1_val==4294967296 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x100000000, 0x100000000, x7, 1024, x1)

inst_401:
// rs1_val==4294967296 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x100000000, 0x2, x7, 1032, x1)

inst_402:
// rs1_val==4294967296 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x5555555555555554, x7, 1040, x1)

inst_403:
// rs1_val==4294967296 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0xaaaaaaaaaaaaaaa9, x7, 1048, x1)

inst_404:
// rs1_val==4294967296 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x100000000, 0x4, x7, 1056, x1)

inst_405:
// rs1_val==4294967296 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x3333333333333332, x7, 1064, x1)

inst_406:
// rs1_val==4294967296 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x6666666666666665, x7, 1072, x1)

inst_407:
// rs1_val==4294967296 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0cce, 0x100000000, 0xb504f332, x7, 1080, x1)

inst_408:
// rs1_val==4294967296 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x100000000, 0xffffffff, x7, 1088, x1)

inst_409:
// rs1_val==4294967296 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x5555555555555556, x7, 1096, x1)

inst_410:
// rs1_val==4294967296 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0xaaaaaaaaaaaaaaab, x7, 1104, x1)

inst_411:
// rs1_val==4294967296 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x100000000, 0x6, x7, 1112, x1)

inst_412:
// rs1_val==4294967296 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x3333333333333334, x7, 1120, x1)

inst_413:
// rs1_val==4294967296 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x6666666666666667, x7, 1128, x1)

inst_414:
// rs1_val==4294967296 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0ccc, 0x100000000, 0xb504f334, x7, 1136, x1)

inst_415:
// rs1_val==4294967296 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x100000000, 0x1, x7, 1144, x1)

inst_416:
// rs1_val==4294967296 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x100000000, 0x100000001, x7, 1152, x1)

inst_417:
// rs1_val==2 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x3, x7, 1160, x1)

inst_418:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x5555555555555555, x7, 1168, x1)

inst_419:
// rs1_val==2 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0xaaaaaaaaaaaaaaaa, x7, 1176, x1)

inst_420:
// rs1_val==2 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x5, x7, 1184, x1)

inst_421:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x3333333333333333, x7, 1192, x1)

inst_422:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x6666666666666666, x7, 1200, x1)

inst_423:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0xb504f333, x7, 1208, x1)

inst_424:
// rs1_val==2 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x0, x7, 1216, x1)

inst_425:
// rs1_val==2 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x100000000, x7, 1224, x1)

inst_426:
// rs1_val==2 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x2, 0x2, x7, 1232, x1)

inst_427:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x5555555555555554, x7, 1240, x1)

inst_428:
// rs1_val==2 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0xaaaaaaaaaaaaaaa9, x7, 1248, x1)

inst_429:
// rs1_val==2 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x4, x7, 1256, x1)

inst_430:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x3333333333333332, x7, 1264, x1)

inst_431:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x6666666666666665, x7, 1272, x1)

inst_432:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0xb504f332, x7, 1280, x1)

inst_433:
// rs1_val==2 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0xffffffff, x7, 1288, x1)

inst_434:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x5555555555555556, x7, 1296, x1)

inst_435:
// rs1_val==2 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0xaaaaaaaaaaaaaaab, x7, 1304, x1)

inst_436:
// rs1_val==2 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x6, x7, 1312, x1)

inst_437:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x3333333333333334, x7, 1320, x1)

inst_438:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x6666666666666667, x7, 1328, x1)

inst_439:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0xb504f334, x7, 1336, x1)

inst_440:
// rs1_val==2 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x2, 0x1, x7, 1344, x1)

inst_441:
// rs1_val==2 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x2, 0x100000001, x7, 1352, x1)

inst_442:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5555555555555554, 0x3, x7, 1360, x1)

inst_443:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x5555555555555555, x7, 1368, x1)

inst_444:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0xaaaaaaaaaaaaaaaa, x7, 1376, x1)

inst_445:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x5555555555555554, 0x5, x7, 1384, x1)

inst_446:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222221, 0x5555555555555554, 0x3333333333333333, x7, 1392, x1)

inst_447:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x6666666666666666, x7, 1400, x1)

inst_448:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x72e6206c, 0x5555555555555554, 0xb504f333, x7, 1408, x1)

inst_449:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x0, x7, 1416, x1)

inst_450:
// rs1_val==6148914691236517204 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x100000000, x7, 1424, x1)

inst_451:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555554, 0x2, x7, 1432, x1)

inst_452:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555554, x7, 1440, x1)

inst_453:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0xaaaaaaaaaaaaaaa9, x7, 1448, x1)

inst_454:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555554, 0x4, x7, 1456, x1)

inst_455:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222222, 0x5555555555555554, 0x3333333333333332, x7, 1464, x1)

inst_456:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x6666666666666665, x7, 1472, x1)

inst_457:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x368f24b2, 0x5555555555555554, 0xb504f332, x7, 1480, x1)

inst_458:
// rs1_val==6148914691236517204 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaa9, 0x5555555555555554, 0xffffffff, x7, 1488, x1)

inst_459:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x5555555555555556, x7, 1496, x1)

inst_460:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0xaaaaaaaaaaaaaaab, x7, 1504, x1)

inst_461:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x5555555555555554, 0x6, x7, 1512, x1)

inst_462:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222220, 0x5555555555555554, 0x3333333333333334, x7, 1520, x1)

inst_463:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0x5555555555555554, 0x6666666666666667, x7, 1528, x1)

inst_464:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xaf3d1c28, 0x5555555555555554, 0xb504f334, x7, 1536, x1)

inst_465:
// rs1_val==6148914691236517204 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555554, 0x1, x7, 1544, x1)

inst_466:
// rs1_val==6148914691236517204 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x5555555555555554, 0x100000001, x7, 1552, x1)

inst_467:
// rs1_val==12297829382473034409 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x3, x7, 1560, x1)

inst_468:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555554, 0xaaaaaaaaaaaaaaa9, 0x5555555555555555, x7, 1568, x1)

inst_469:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaaa, x7, 1576, x1)

inst_470:
// rs1_val==12297829382473034409 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0xaaaaaaaaaaaaaaa9, 0x5, x7, 1584, x1)

inst_471:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111110, 0xaaaaaaaaaaaaaaa9, 0x3333333333333333, x7, 1592, x1)

inst_472:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444443, 0xaaaaaaaaaaaaaaa9, 0x6666666666666666, x7, 1600, x1)

inst_473:
// rs1_val==12297829382473034409 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x30c74da6, 0xaaaaaaaaaaaaaaa9, 0xb504f333, x7, 1608, x1)

inst_474:
// rs1_val==12297829382473034409 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, 0x0, x7, 1616, x1)

inst_475:
// rs1_val==12297829382473034409 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaa9, 0xaaaaaaaaaaaaaaa9, 0x100000000, x7, 1624, x1)

inst_476:
// rs1_val==12297829382473034409 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x2, x7, 1632, x1)

inst_477:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x5555555555555554, x7, 1640, x1)

inst_478:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, x7, 1648, x1)

inst_479:
// rs1_val==12297829382473034409 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x4, x7, 1656, x1)

inst_480:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111113, 0xaaaaaaaaaaaaaaa9, 0x3333333333333332, x7, 1664, x1)

inst_481:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444444, 0xaaaaaaaaaaaaaaa9, 0x6666666666666665, x7, 1672, x1)

inst_482:
// rs1_val==12297829382473034409 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x6d1e4965, 0xaaaaaaaaaaaaaaa9, 0xb504f332, x7, 1680, x1)

inst_483:
// rs1_val==12297829382473034409 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x55555554, 0xaaaaaaaaaaaaaaa9, 0xffffffff, x7, 1688, x1)

inst_484:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555553, 0xaaaaaaaaaaaaaaa9, 0x5555555555555556, x7, 1696, x1)

inst_485:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaab, x7, 1704, x1)

inst_486:
// rs1_val==12297829382473034409 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xaaaaaaaaaaaaaaa9, 0x6, x7, 1712, x1)

inst_487:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x111111111111110d, 0xaaaaaaaaaaaaaaa9, 0x3333333333333334, x7, 1720, x1)

inst_488:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444442, 0xaaaaaaaaaaaaaaa9, 0x6666666666666667, x7, 1728, x1)

inst_489:
// rs1_val==12297829382473034409 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xa975451d, 0xaaaaaaaaaaaaaaa9, 0xb504f334, x7, 1736, x1)

inst_490:
// rs1_val==12297829382473034409 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x1, x7, 1744, x1)

inst_491:
// rs1_val==12297829382473034409 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0xaaaaaaaaaaaaaaa9, 0x100000001, x7, 1752, x1)

inst_492:
// rs1_val==4 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x4, 0x3, x7, 1760, x1)

inst_493:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x5555555555555555, x7, 1768, x1)

inst_494:
// rs1_val==4 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0xaaaaaaaaaaaaaaaa, x7, 1776, x1)

inst_495:
// rs1_val==4 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x5, x7, 1784, x1)

inst_496:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x3333333333333333, x7, 1792, x1)

inst_497:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x6666666666666666, x7, 1800, x1)

inst_498:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0xb504f333, x7, 1808, x1)

inst_499:
// rs1_val==4 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x0, x7, 1816, x1)

inst_500:
// rs1_val==4 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x100000000, x7, 1824, x1)

inst_501:
// rs1_val==4 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x4, 0x2, x7, 1832, x1)

inst_502:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x5555555555555554, x7, 1840, x1)

inst_503:
// rs1_val==4 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0xaaaaaaaaaaaaaaa9, x7, 1848, x1)

inst_504:
// rs1_val==4 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x4, 0x4, x7, 1856, x1)

inst_505:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x3333333333333332, x7, 1864, x1)

inst_506:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x6666666666666665, x7, 1872, x1)

inst_507:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0xb504f332, x7, 1880, x1)

inst_508:
// rs1_val==4 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0xffffffff, x7, 1888, x1)

inst_509:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x5555555555555556, x7, 1896, x1)

inst_510:
// rs1_val==4 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0xaaaaaaaaaaaaaaab, x7, 1904, x1)

inst_511:
// rs1_val==4 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x6, x7, 1912, x1)

inst_512:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x3333333333333334, x7, 1920, x1)

inst_513:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x6666666666666667, x7, 1928, x1)

inst_514:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0xb504f334, x7, 1936, x1)

inst_515:
// rs1_val==4 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x4, 0x1, x7, 1944, x1)

inst_516:
// rs1_val==4 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x4, 0x100000001, x7, 1952, x1)

inst_517:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x3333333333333332, 0x3, x7, 1960, x1)

inst_518:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x5555555555555555, x7, 1968, x1)

inst_519:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0xaaaaaaaaaaaaaaaa, x7, 1976, x1)

inst_520:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x3333333333333332, 0x5, x7, 1984, x1)

inst_521:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x3333333333333333, x7, 1992, x1)

inst_522:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x6666666666666666, x7, 2000, x1)

inst_523:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x44f079da, 0x3333333333333332, 0xb504f333, x7, 2008, x1)

inst_524:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x0, x7, 2016, x1)

inst_525:
// rs1_val==3689348814741910322 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x100000000, x7, 2024, x1)

inst_526:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333332, 0x2, x7, 2032, x1)

inst_527:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x5555555555555554, x7, 2040, x1)
RVTEST_SIGBASE( x7,signature_x7_2)

inst_528:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0xaaaaaaaaaaaaaaa9, x7, 0, x1)

inst_529:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x3333333333333332, 0x4, x7, 8, x1)

inst_530:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333332, x7, 16, x1)

inst_531:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x6666666666666665, x7, 24, x1)

inst_532:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x8d58db22, 0x3333333333333332, 0xb504f332, x7, 32, x1)

inst_533:
// rs1_val==3689348814741910322 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x66666665, 0x3333333333333332, 0xffffffff, x7, 40, x1)

inst_534:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x5555555555555556, x7, 48, x1)

inst_535:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0xaaaaaaaaaaaaaaab, x7, 56, x1)

inst_536:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x3333333333333332, 0x6, x7, 64, x1)

inst_537:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x3333333333333334, x7, 72, x1)

inst_538:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x3333333333333332, 0x6666666666666667, x7, 80, x1)

inst_539:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xb18d0bc6, 0x3333333333333332, 0xb504f334, x7, 88, x1)

inst_540:
// rs1_val==3689348814741910322 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333332, 0x1, x7, 96, x1)

inst_541:
// rs1_val==3689348814741910322 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x3333333333333332, 0x100000001, x7, 104, x1)

inst_542:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x6666666666666665, 0x3, x7, 112, x1)

inst_543:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111110, 0x6666666666666665, 0x5555555555555555, x7, 120, x1)

inst_544:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0xaaaaaaaaaaaaaaaa, x7, 128, x1)

inst_545:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666665, 0x5, x7, 136, x1)

inst_546:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333332, 0x6666666666666665, 0x3333333333333333, x7, 144, x1)

inst_547:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0x6666666666666666, x7, 152, x1)

inst_548:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x89e0f3b5, 0x6666666666666665, 0xb504f333, x7, 160, x1)

inst_549:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0x0, x7, 168, x1)

inst_550:
// rs1_val==7378697629483820645 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x100000000, x7, 176, x1)

inst_551:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666665, 0x2, x7, 184, x1)

inst_552:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111111, 0x6666666666666665, 0x5555555555555554, x7, 192, x1)

inst_553:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0xaaaaaaaaaaaaaaa9, x7, 200, x1)

inst_554:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666665, 0x4, x7, 208, x1)

inst_555:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666665, 0x3333333333333332, x7, 216, x1)

inst_556:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666665, x7, 224, x1)

inst_557:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x65acc313, 0x6666666666666665, 0xb504f332, x7, 232, x1)

inst_558:
// rs1_val==7378697629483820645 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xcccccccb, 0x6666666666666665, 0xffffffff, x7, 240, x1)

inst_559:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x111111111111110f, 0x6666666666666665, 0x5555555555555556, x7, 248, x1)

inst_560:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0xaaaaaaaaaaaaaaab, x7, 256, x1)

inst_561:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x6666666666666665, 0x6, x7, 264, x1)

inst_562:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333331, 0x6666666666666665, 0x3333333333333334, x7, 272, x1)

inst_563:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666665, 0x6666666666666665, 0x6666666666666667, x7, 280, x1)

inst_564:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xae152459, 0x6666666666666665, 0xb504f334, x7, 288, x1)

inst_565:
// rs1_val==7378697629483820645 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666665, 0x1, x7, 296, x1)

inst_566:
// rs1_val==7378697629483820645 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x100000000, 0x6666666666666665, 0x100000001, x7, 304, x1)

inst_567:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xb504f332, 0x3, x7, 312, x1)

inst_568:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x5555555555555555, x7, 320, x1)

inst_569:
// rs1_val==3037000498 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0xaaaaaaaaaaaaaaaa, x7, 328, x1)

inst_570:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xb504f332, 0x5, x7, 336, x1)

inst_571:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x3333333333333333, x7, 344, x1)

inst_572:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x6666666666666666, x7, 352, x1)

inst_573:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0xb504f333, x7, 360, x1)

inst_574:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x0, x7, 368, x1)

inst_575:
// rs1_val==3037000498 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x100000000, x7, 376, x1)

inst_576:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f332, 0x2, x7, 384, x1)

inst_577:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x5555555555555554, x7, 392, x1)

inst_578:
// rs1_val==3037000498 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0xaaaaaaaaaaaaaaa9, x7, 400, x1)

inst_579:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0xb504f332, 0x4, x7, 408, x1)

inst_580:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x3333333333333332, x7, 416, x1)

inst_581:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x6666666666666665, x7, 424, x1)

inst_582:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f332, 0xb504f332, x7, 432, x1)

inst_583:
// rs1_val==3037000498 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0xffffffff, x7, 440, x1)

inst_584:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x5555555555555556, x7, 448, x1)

inst_585:
// rs1_val==3037000498 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0xaaaaaaaaaaaaaaab, x7, 456, x1)

inst_586:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0xb504f332, 0x6, x7, 464, x1)

inst_587:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x3333333333333334, x7, 472, x1)

inst_588:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x6666666666666667, x7, 480, x1)

inst_589:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0xb504f334, x7, 488, x1)

inst_590:
// rs1_val==3037000498 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f332, 0x1, x7, 496, x1)

inst_591:
// rs1_val==3037000498 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0xb504f332, 0xb504f332, 0x100000001, x7, 504, x1)

inst_592:
// rs1_val==4294967295 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xffffffff, 0x3, x7, 512, x1)

inst_593:
// rs1_val==4294967295 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x5555555555555555, x7, 520, x1)

inst_594:
// rs1_val==4294967295 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0xaaaaaaaaaaaaaaaa, x7, 528, x1)

inst_595:
// rs1_val==4294967295 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xffffffff, 0x5, x7, 536, x1)

inst_596:
// rs1_val==4294967295 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x3333333333333333, x7, 544, x1)

inst_597:
// rs1_val==4294967295 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x6666666666666666, x7, 552, x1)

inst_598:
// rs1_val==4294967295 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0ccc, 0xffffffff, 0xb504f333, x7, 560, x1)

inst_599:
// rs1_val==4294967295 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x0, x7, 568, x1)

inst_600:
// rs1_val==4294967295 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x100000000, x7, 576, x1)

inst_601:
// rs1_val==4294967295 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xffffffff, 0x2, x7, 584, x1)

inst_602:
// rs1_val==4294967295 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x5555555555555554, x7, 592, x1)

inst_603:
// rs1_val==4294967295 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0xaaaaaaaaaaaaaaa9, x7, 600, x1)

inst_604:
// rs1_val==4294967295 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xffffffff, 0x4, x7, 608, x1)

inst_605:
// rs1_val==4294967295 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x3333333333333332, x7, 616, x1)

inst_606:
// rs1_val==4294967295 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x6666666666666665, x7, 624, x1)

inst_607:
// rs1_val==4294967295 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0ccd, 0xffffffff, 0xb504f332, x7, 632, x1)

inst_608:
// rs1_val==4294967295 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xffffffff, 0xffffffff, x7, 640, x1)

inst_609:
// rs1_val==4294967295 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x5555555555555556, x7, 648, x1)

inst_610:
// rs1_val==4294967295 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0xaaaaaaaaaaaaaaab, x7, 656, x1)

inst_611:
// rs1_val==4294967295 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xffffffff, 0x6, x7, 664, x1)

inst_612:
// rs1_val==4294967295 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x3333333333333334, x7, 672, x1)

inst_613:
// rs1_val==4294967295 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x6666666666666667, x7, 680, x1)

inst_614:
// rs1_val==4294967295 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0ccb, 0xffffffff, 0xb504f334, x7, 688, x1)

inst_615:
// rs1_val==4294967295 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xffffffff, 0x1, x7, 696, x1)

inst_616:
// rs1_val==4294967295 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0xffffffff, 0xffffffff, 0x100000001, x7, 704, x1)

inst_617:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555556, 0x3, x7, 712, x1)

inst_618:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5555555555555556, 0x5555555555555555, x7, 720, x1)

inst_619:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0xaaaaaaaaaaaaaaaa, x7, 728, x1)

inst_620:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5555555555555556, 0x5, x7, 736, x1)

inst_621:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222223, 0x5555555555555556, 0x3333333333333333, x7, 744, x1)

inst_622:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x6666666666666666, x7, 752, x1)

inst_623:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x72e6206e, 0x5555555555555556, 0xb504f333, x7, 760, x1)

inst_624:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x0, x7, 768, x1)

inst_625:
// rs1_val==6148914691236517206 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x100000000, x7, 776, x1)

inst_626:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555556, 0x2, x7, 784, x1)

inst_627:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x5555555555555556, 0x5555555555555554, x7, 792, x1)

inst_628:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0xaaaaaaaaaaaaaaa9, x7, 800, x1)

inst_629:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x5555555555555556, 0x4, x7, 808, x1)

inst_630:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222224, 0x5555555555555556, 0x3333333333333332, x7, 816, x1)

inst_631:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x6666666666666665, x7, 824, x1)

inst_632:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x368f24b4, 0x5555555555555556, 0xb504f332, x7, 832, x1)

inst_633:
// rs1_val==6148914691236517206 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaab, 0x5555555555555556, 0xffffffff, x7, 840, x1)

inst_634:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555556, x7, 848, x1)

inst_635:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0xaaaaaaaaaaaaaaab, x7, 856, x1)

inst_636:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555556, 0x6, x7, 864, x1)

inst_637:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x2222222222222222, 0x5555555555555556, 0x3333333333333334, x7, 872, x1)

inst_638:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555556, 0x5555555555555556, 0x6666666666666667, x7, 880, x1)

inst_639:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xaf3d1c2a, 0x5555555555555556, 0xb504f334, x7, 888, x1)

inst_640:
// rs1_val==6148914691236517206 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x5555555555555556, 0x1, x7, 896, x1)

inst_641:
// rs1_val==6148914691236517206 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x5555555555555556, 0x100000001, x7, 904, x1)

inst_642:
// rs1_val==12297829382473034411 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaab, 0x3, x7, 912, x1)

inst_643:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x5555555555555555, x7, 920, x1)

inst_644:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaaa, x7, 928, x1)

inst_645:
// rs1_val==12297829382473034411 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x5, x7, 936, x1)

inst_646:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111112, 0xaaaaaaaaaaaaaaab, 0x3333333333333333, x7, 944, x1)

inst_647:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444445, 0xaaaaaaaaaaaaaaab, 0x6666666666666666, x7, 952, x1)

inst_648:
// rs1_val==12297829382473034411 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x30c74da8, 0xaaaaaaaaaaaaaaab, 0xb504f333, x7, 960, x1)

inst_649:
// rs1_val==12297829382473034411 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaab, 0x0, x7, 968, x1)

inst_650:
// rs1_val==12297829382473034411 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xaaaaaaab, 0xaaaaaaaaaaaaaaab, 0x100000000, x7, 976, x1)

inst_651:
// rs1_val==12297829382473034411 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x2, x7, 984, x1)

inst_652:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xaaaaaaaaaaaaaaab, 0x5555555555555554, x7, 992, x1)

inst_653:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaa9, x7, 1000, x1)

inst_654:
// rs1_val==12297829382473034411 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0xaaaaaaaaaaaaaaab, 0x4, x7, 1008, x1)

inst_655:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111115, 0xaaaaaaaaaaaaaaab, 0x3333333333333332, x7, 1016, x1)

inst_656:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444446, 0xaaaaaaaaaaaaaaab, 0x6666666666666665, x7, 1024, x1)

inst_657:
// rs1_val==12297829382473034411 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x6d1e4967, 0xaaaaaaaaaaaaaaab, 0xb504f332, x7, 1032, x1)

inst_658:
// rs1_val==12297829382473034411 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x55555556, 0xaaaaaaaaaaaaaaab, 0xffffffff, x7, 1040, x1)

inst_659:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x5555555555555555, 0xaaaaaaaaaaaaaaab, 0x5555555555555556, x7, 1048, x1)

inst_660:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaab, x7, 1056, x1)

inst_661:
// rs1_val==12297829382473034411 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0xaaaaaaaaaaaaaaab, 0x6, x7, 1064, x1)

inst_662:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x111111111111110f, 0xaaaaaaaaaaaaaaab, 0x3333333333333334, x7, 1072, x1)

inst_663:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x4444444444444444, 0xaaaaaaaaaaaaaaab, 0x6666666666666667, x7, 1080, x1)

inst_664:
// rs1_val==12297829382473034411 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xa975451f, 0xaaaaaaaaaaaaaaab, 0xb504f334, x7, 1088, x1)

inst_665:
// rs1_val==12297829382473034411 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x1, x7, 1096, x1)

inst_666:
// rs1_val==12297829382473034411 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x100000001, x7, 1104, x1)

inst_667:
// rs1_val==6 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6, 0x3, x7, 1112, x1)

inst_668:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x5555555555555555, x7, 1120, x1)

inst_669:
// rs1_val==6 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0xaaaaaaaaaaaaaaaa, x7, 1128, x1)

inst_670:
// rs1_val==6 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6, 0x5, x7, 1136, x1)

inst_671:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x3333333333333333, x7, 1144, x1)

inst_672:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x6666666666666666, x7, 1152, x1)

inst_673:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0xb504f333, x7, 1160, x1)

inst_674:
// rs1_val==6 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x0, x7, 1168, x1)

inst_675:
// rs1_val==6 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x100000000, x7, 1176, x1)

inst_676:
// rs1_val==6 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6, 0x2, x7, 1184, x1)

inst_677:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x5555555555555554, x7, 1192, x1)

inst_678:
// rs1_val==6 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0xaaaaaaaaaaaaaaa9, x7, 1200, x1)

inst_679:
// rs1_val==6 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x6, 0x4, x7, 1208, x1)

inst_680:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x3333333333333332, x7, 1216, x1)

inst_681:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x6666666666666665, x7, 1224, x1)

inst_682:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0xb504f332, x7, 1232, x1)

inst_683:
// rs1_val==6 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0xffffffff, x7, 1240, x1)

inst_684:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x5555555555555556, x7, 1248, x1)

inst_685:
// rs1_val==6 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0xaaaaaaaaaaaaaaab, x7, 1256, x1)

inst_686:
// rs1_val==6 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6, 0x6, x7, 1264, x1)

inst_687:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x3333333333333334, x7, 1272, x1)

inst_688:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x6666666666666667, x7, 1280, x1)

inst_689:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0xb504f334, x7, 1288, x1)

inst_690:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x5555555555555555, x7, 1296, x1)

inst_691:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0xaaaaaaaaaaaaaaaa, x7, 1304, x1)

inst_692:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x3333333333333334, 0x5, x7, 1312, x1)

inst_693:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x3333333333333334, 0x3333333333333333, x7, 1320, x1)

inst_694:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x6666666666666666, x7, 1328, x1)

inst_695:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x44f079dc, 0x3333333333333334, 0xb504f333, x7, 1336, x1)

inst_696:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x0, x7, 1344, x1)

inst_697:
// rs1_val==3689348814741910324 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x100000000, x7, 1352, x1)

inst_698:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333334, 0x2, x7, 1360, x1)

inst_699:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x5555555555555554, x7, 1368, x1)

inst_700:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0xaaaaaaaaaaaaaaa9, x7, 1376, x1)

inst_701:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333334, 0x4, x7, 1384, x1)

inst_702:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x3333333333333334, 0x3333333333333332, x7, 1392, x1)

inst_703:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x6666666666666665, x7, 1400, x1)

inst_704:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x8d58db24, 0x3333333333333334, 0xb504f332, x7, 1408, x1)

inst_705:
// rs1_val==3689348814741910324 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x66666667, 0x3333333333333334, 0xffffffff, x7, 1416, x1)

inst_706:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x5555555555555556, x7, 1424, x1)

inst_707:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0xaaaaaaaaaaaaaaab, x7, 1432, x1)

inst_708:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x4, 0x3333333333333334, 0x6, x7, 1440, x1)

inst_709:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333334, x7, 1448, x1)

inst_710:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333334, 0x3333333333333334, 0x6666666666666667, x7, 1456, x1)

inst_711:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xb18d0bc8, 0x3333333333333334, 0xb504f334, x7, 1464, x1)

inst_712:
// rs1_val==3689348814741910324 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x3333333333333334, 0x1, x7, 1472, x1)

inst_713:
// rs1_val==3689348814741910324 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x3333333333333334, 0x100000001, x7, 1480, x1)

inst_714:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666667, 0x3, x7, 1488, x1)

inst_715:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111112, 0x6666666666666667, 0x5555555555555555, x7, 1496, x1)

inst_716:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666667, 0x6666666666666667, 0xaaaaaaaaaaaaaaaa, x7, 1504, x1)

inst_717:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x6666666666666667, 0x5, x7, 1512, x1)

inst_718:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666667, 0x3333333333333333, x7, 1520, x1)

inst_719:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666667, 0x6666666666666666, x7, 1528, x1)

inst_720:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x89e0f3b7, 0x6666666666666667, 0xb504f333, x7, 1536, x1)

inst_721:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666667, 0x6666666666666667, 0x0, x7, 1544, x1)

inst_722:
// rs1_val==7378697629483820647 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x66666667, 0x6666666666666667, 0x100000000, x7, 1552, x1)

inst_723:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666667, 0x2, x7, 1560, x1)

inst_724:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111113, 0x6666666666666667, 0x5555555555555554, x7, 1568, x1)

inst_725:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666667, 0x6666666666666667, 0xaaaaaaaaaaaaaaa9, x7, 1576, x1)

inst_726:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x6666666666666667, 0x4, x7, 1584, x1)

inst_727:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x3, 0x6666666666666667, 0x3333333333333332, x7, 1592, x1)

inst_728:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x6666666666666667, 0x6666666666666665, x7, 1600, x1)

inst_729:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x65acc315, 0x6666666666666667, 0xb504f332, x7, 1608, x1)

inst_730:
// rs1_val==7378697629483820647 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xcccccccd, 0x6666666666666667, 0xffffffff, x7, 1616, x1)

inst_731:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x1111111111111111, 0x6666666666666667, 0x5555555555555556, x7, 1624, x1)

inst_732:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x6666666666666667, 0x6666666666666667, 0xaaaaaaaaaaaaaaab, x7, 1632, x1)

inst_733:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666667, 0x6, x7, 1640, x1)

inst_734:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x3333333333333333, 0x6666666666666667, 0x3333333333333334, x7, 1648, x1)

inst_735:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666667, x7, 1656, x1)

inst_736:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0xae15245b, 0x6666666666666667, 0xb504f334, x7, 1664, x1)

inst_737:
// rs1_val==7378697629483820647 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6666666666666667, 0x1, x7, 1672, x1)

inst_738:
// rs1_val==7378697629483820647 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x6666666666666667, 0x100000001, x7, 1680, x1)

inst_739:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f334, 0x3, x7, 1688, x1)

inst_740:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x5555555555555555, x7, 1696, x1)

inst_741:
// rs1_val==3037000500 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0xaaaaaaaaaaaaaaaa, x7, 1704, x1)

inst_742:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f334, 0x5, x7, 1712, x1)

inst_743:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x3333333333333333, x7, 1720, x1)

inst_744:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x6666666666666666, x7, 1728, x1)

inst_745:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0xb504f334, 0xb504f333, x7, 1736, x1)

inst_746:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x0, x7, 1744, x1)

inst_747:
// rs1_val==3037000500 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x100000000, x7, 1752, x1)

inst_748:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f334, 0x2, x7, 1760, x1)

inst_749:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x5555555555555554, x7, 1768, x1)

inst_750:
// rs1_val==3037000500 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0xaaaaaaaaaaaaaaa9, x7, 1776, x1)

inst_751:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f334, 0x4, x7, 1784, x1)

inst_752:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x3333333333333332, x7, 1792, x1)

inst_753:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x6666666666666665, x7, 1800, x1)

inst_754:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0xb504f334, 0xb504f332, x7, 1808, x1)

inst_755:
// rs1_val==3037000500 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0xffffffff, x7, 1816, x1)

inst_756:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x5555555555555556, x7, 1824, x1)

inst_757:
// rs1_val==3037000500 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0xaaaaaaaaaaaaaaab, x7, 1832, x1)

inst_758:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f334, 0x6, x7, 1840, x1)

inst_759:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x3333333333333334, x7, 1848, x1)

inst_760:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x6666666666666667, x7, 1856, x1)

inst_761:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f334, 0xb504f334, x7, 1864, x1)

inst_762:
// rs1_val==3037000500 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xb504f334, 0x1, x7, 1872, x1)

inst_763:
// rs1_val==3037000500 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0xb504f334, 0xb504f334, 0x100000001, x7, 1880, x1)

inst_764:
// rs1_val==1 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x3, x7, 1888, x1)

inst_765:
// rs1_val==1 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x5555555555555555, x7, 1896, x1)

inst_766:
// rs1_val==1 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaaa, x7, 1904, x1)

inst_767:
// rs1_val==1 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x5, x7, 1912, x1)

inst_768:
// rs1_val==1 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x3333333333333333, x7, 1920, x1)

inst_769:
// rs1_val==1 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x6666666666666666, x7, 1928, x1)

inst_770:
// rs1_val==1 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xb504f333, x7, 1936, x1)

inst_771:
// rs1_val==1 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x0, x7, 1944, x1)

inst_772:
// rs1_val==1 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x100000000, x7, 1952, x1)

inst_773:
// rs1_val==1 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x2, x7, 1960, x1)

inst_774:
// rs1_val==1 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x5555555555555554, x7, 1968, x1)

inst_775:
// rs1_val==1 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaa9, x7, 1976, x1)

inst_776:
// rs1_val==1 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x4, x7, 1984, x1)

inst_777:
// rs1_val==1 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x3333333333333332, x7, 1992, x1)

inst_778:
// rs1_val==1 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x6666666666666665, x7, 2000, x1)

inst_779:
// rs1_val==1 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xb504f332, x7, 2008, x1)

inst_780:
// rs1_val==1 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xffffffff, x7, 2016, x1)

inst_781:
// rs1_val==1 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x5555555555555556, x7, 2024, x1)

inst_782:
// rs1_val==1 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaab, x7, 2032, x1)

inst_783:
// rs1_val==1 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x6, x7, 2040, x1)
RVTEST_SIGBASE( x7,signature_x7_3)

inst_784:
// rs1_val==1 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x3333333333333334, x7, 0, x1)

inst_785:
// rs1_val==1 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x6666666666666667, x7, 8, x1)

inst_786:
// rs1_val==1 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0xb504f334, x7, 16, x1)

inst_787:
// rs1_val==1 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x1, 0x1, x7, 24, x1)

inst_788:
// rs1_val==1 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x100000001, x7, 32, x1)

inst_789:
// rs1_val==4294967297 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x100000001, 0x3, x7, 40, x1)

inst_790:
// rs1_val==4294967297 and rs2_val==6148914691236517205, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555555
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x5555555555555555, x7, 48, x1)

inst_791:
// rs1_val==4294967297 and rs2_val==12297829382473034410, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0xaaaaaaaaaaaaaaaa, x7, 56, x1)

inst_792:
// rs1_val==4294967297 and rs2_val==5, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x100000001, 0x5, x7, 64, x1)

inst_793:
// rs1_val==4294967297 and rs2_val==3689348814741910323, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333333
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x3333333333333333, x7, 72, x1)

inst_794:
// rs1_val==4294967297 and rs2_val==7378697629483820646, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666666
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x6666666666666666, x7, 80, x1)

inst_795:
// rs1_val==4294967297 and rs2_val==3037000499, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f333
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0cce, 0x100000001, 0xb504f333, x7, 88, x1)

inst_796:
// rs1_val==4294967297 and rs2_val==0, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x0
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x0, x7, 96, x1)

inst_797:
// rs1_val==4294967297 and rs2_val==4294967296, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x100000000
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x100000001, 0x100000000, x7, 104, x1)

inst_798:
// rs1_val==4294967297 and rs2_val==2, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x2
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x100000001, 0x2, x7, 112, x1)

inst_799:
// rs1_val==4294967297 and rs2_val==6148914691236517204, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555554
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x5555555555555554, x7, 120, x1)

inst_800:
// rs1_val==4294967297 and rs2_val==12297829382473034409, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0xaaaaaaaaaaaaaaa9, x7, 128, x1)

inst_801:
// rs1_val==4294967297 and rs2_val==4, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x4
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x100000001, 0x4, x7, 136, x1)

inst_802:
// rs1_val==4294967297 and rs2_val==3689348814741910322, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333332
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x3333333333333332, x7, 144, x1)

inst_803:
// rs1_val==4294967297 and rs2_val==7378697629483820645, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666665
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x6666666666666665, x7, 152, x1)

inst_804:
// rs1_val==4294967297 and rs2_val==3037000498, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f332
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0ccf, 0x100000001, 0xb504f332, x7, 160, x1)

inst_805:
// rs1_val==4294967297 and rs2_val==4294967295, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x2, 0x100000001, 0xffffffff, x7, 168, x1)

inst_806:
// rs1_val==4294967297 and rs2_val==6148914691236517206, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555556
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x5555555555555556, x7, 176, x1)

inst_807:
// rs1_val==4294967297 and rs2_val==12297829382473034411, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0xaaaaaaaaaaaaaaab, x7, 184, x1)

inst_808:
// rs1_val==4294967297 and rs2_val==6, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6
TEST_RR_OP(remu, x12, x10, x11, 0x5, 0x100000001, 0x6, x7, 192, x1)

inst_809:
// rs1_val==4294967297 and rs2_val==3689348814741910324, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333334
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x3333333333333334, x7, 200, x1)

inst_810:
// rs1_val==4294967297 and rs2_val==7378697629483820647, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666667
TEST_RR_OP(remu, x12, x10, x11, 0x100000001, 0x100000001, 0x6666666666666667, x7, 208, x1)

inst_811:
// rs1_val==4294967297 and rs2_val==3037000500, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f334
TEST_RR_OP(remu, x12, x10, x11, 0x4afb0ccd, 0x100000001, 0xb504f334, x7, 216, x1)

inst_812:
// rs1_val==4294967297 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x100000001, 0x1, x7, 224, x1)

inst_813:
// rs1_val==4294967297 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x100000001, 0x100000001, x7, 232, x1)

inst_814:
// rs1_val==6 and rs2_val==1, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x6, 0x1, x7, 240, x1)

inst_815:
// rs1_val==6 and rs2_val==4294967297, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x100000001
TEST_RR_OP(remu, x12, x10, x11, 0x6, 0x6, 0x100000001, x7, 248, x1)

inst_816:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x3333333333333334, 0x3, x7, 256, x1)

inst_817:
// rs1_val == rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 18446743936270598143, rs1_val == 18446743936270598143
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffdfffffffff;  op2val:0xffffffdfffffffff
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xffffffdfffffffff, 0xffffffdfffffffff, x7, 264, x1)

inst_818:
// rs2_val == 1, rs1_val == 18446708889337462783
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffdfffffffffff;  op2val:0x1
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0xffffdfffffffffff, 0x1, x7, 272, x1)

inst_819:
// rs1_val == 1, rs2_val == 8192
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x2000
TEST_RR_OP(remu, x12, x10, x11, 0x1, 0x1, 0x2000, x7, 280, x1)

inst_820:
// rs2_val == 8, rs1_val == 262144
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0x8
TEST_RR_OP(remu, x12, x10, x11, 0x0, 0x40000, 0x8, x7, 288, x1)

inst_821:
// rs2_val == 16777216, rs1_val == 18446744073709551599
// opcode: remu ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffef;  op2val:0x1000000
TEST_RR_OP(remu, x12, x10, x11, 0xffffef, 0xffffffffffffffef, 0x1000000, x7, 296, x1)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x4_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 16*(XLEN/32),4,0xdeadbeef


signature_x7_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x7_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x7_2:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x7_3:
    .fill 38*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
