
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Wed Dec 16 18:36:29 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64im.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the remuw instruction of the RISC-V M extension for the remuw covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IM")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*RV64.*I.*M.*);def TEST_CASE_1=True;",remuw)

RVTEST_SIGBASE( x1,signature_x1_1)

inst_0:
// rs1 == rd != rs2, rs1==x7, rs2==x9, rd==x7, rs1_val > 0 and rs2_val > 0, rs1_val == 128, rs1_val != rs2_val and rs1_val > 0 and rs2_val > 0
// opcode: remuw ; op1:x7; op2:x9; dest:x7; op1val:0x80;  op2val:0x6
TEST_RR_OP(remuw, x7, x7, x9, 0x2, 0x80, 0x6, x1, 0, x22)

inst_1:
// rs1 == rs2 == rd, rs1==x19, rs2==x19, rd==x19, rs1_val == rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 12297829382473034410, rs1_val == 12297829382473034410, rs1_val==12297829382473034410 and rs2_val==12297829382473034410
// opcode: remuw ; op1:x19; op2:x19; dest:x19; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x19, x19, x19, 0x0, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, x1, 8, x22)

inst_2:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x14, rs2==x0, rd==x21, rs2_val == 0, rs1_val == (2**(xlen)-1)
// opcode: remuw ; op1:x14; op2:x0; dest:x21; op1val:0xffffffffffffffff;  op2val:0x0
TEST_RR_OP(remuw, x21, x14, x0, -0x1, 0xffffffffffffffff, 0x0, x1, 16, x22)

inst_3:
// rs1 == rs2 != rd, rs1==x4, rs2==x4, rd==x14, rs2_val == (2**(xlen)-1), rs1_val == 18445618173802708991
// opcode: remuw ; op1:x4; op2:x4; dest:x14; op1val:0xfffbffffffffffff;  op2val:0xfffbffffffffffff
TEST_RR_OP(remuw, x14, x4, x4, 0x0, 0xfffbffffffffffff, 0xfffbffffffffffff, x1, 24, x22)

inst_4:
// rs2 == rd != rs1, rs1==x20, rs2==x15, rd==x15, rs2_val == 1, rs1_val == 1048576
// opcode: remuw ; op1:x20; op2:x15; dest:x15; op1val:0x100000;  op2val:0x1
TEST_RR_OP(remuw, x15, x20, x15, 0x0, 0x100000, 0x1, x1, 32, x22)

inst_5:
// rs1==x15, rs2==x20, rd==x27, rs1_val == 0, rs1_val==0 and rs2_val==3
// opcode: remuw ; op1:x15; op2:x20; dest:x27; op1val:0x0;  op2val:0x3
TEST_RR_OP(remuw, x27, x15, x20, 0x0, 0x0, 0x3, x1, 40, x22)

inst_6:
// rs1==x30, rs2==x31, rd==x24, rs1_val == 1, rs2_val == 8388608
// opcode: remuw ; op1:x30; op2:x31; dest:x24; op1val:0x1;  op2val:0x800000
TEST_RR_OP(remuw, x24, x30, x31, 0x1, 0x1, 0x800000, x1, 48, x22)

inst_7:
// rs1==x2, rs2==x14, rd==x16, rs2_val == 2, rs1_val==1 and rs2_val==2
// opcode: remuw ; op1:x2; op2:x14; dest:x16; op1val:0x1;  op2val:0x2
TEST_RR_OP(remuw, x16, x2, x14, 0x1, 0x1, 0x2, x1, 56, x22)

inst_8:
// rs1==x29, rs2==x26, rd==x11, rs2_val == 4, rs1_val == 4294967296, rs1_val==4294967296 and rs2_val==4
// opcode: remuw ; op1:x29; op2:x26; dest:x11; op1val:0x100000000;  op2val:0x4
TEST_RR_OP(remuw, x11, x29, x26, 0x0, 0x100000000, 0x4, x1, 64, x22)

inst_9:
// rs1==x25, rs2==x21, rd==x26, rs2_val == 8, 
// opcode: remuw ; op1:x25; op2:x21; dest:x26; op1val:0x6666666666666667;  op2val:0x8
TEST_RR_OP(remuw, x26, x25, x21, 0x7, 0x6666666666666667, 0x8, x1, 72, x22)

inst_10:
// rs1==x3, rs2==x6, rd==x17, rs2_val == 16, rs1_val == 18446603336221196287
// opcode: remuw ; op1:x3; op2:x6; dest:x17; op1val:0xffff7fffffffffff;  op2val:0x10
TEST_RR_OP(remuw, x17, x3, x6, 0xf, 0xffff7fffffffffff, 0x10, x1, 80, x22)

inst_11:
// rs1==x16, rs2==x11, rd==x9, rs2_val == 32, rs1_val == 18446744073707454463
// opcode: remuw ; op1:x16; op2:x11; dest:x9; op1val:0xffffffffffdfffff;  op2val:0x20
TEST_RR_OP(remuw, x9, x16, x11, 0x1f, 0xffffffffffdfffff, 0x20, x1, 88, x22)

inst_12:
// rs1==x9, rs2==x28, rd==x4, rs2_val == 64, rs1_val == 18446744004990074879
// opcode: remuw ; op1:x9; op2:x28; dest:x4; op1val:0xffffffefffffffff;  op2val:0x40
TEST_RR_OP(remuw, x4, x9, x28, 0x3f, 0xffffffefffffffff, 0x40, x1, 96, x22)

inst_13:
// rs1==x0, rs2==x18, rd==x25, rs2_val == 128, rs1_val == 6148914691236517205
// opcode: remuw ; op1:x0; op2:x18; dest:x25; op1val:0x0;  op2val:0x80
TEST_RR_OP(remuw, x25, x0, x18, 0x0, 0x0, 0x80, x1, 104, x22)

inst_14:
// rs1==x8, rs2==x16, rd==x13, rs2_val == 256, rs1_val == 2305843009213693952
// opcode: remuw ; op1:x8; op2:x16; dest:x13; op1val:0x2000000000000000;  op2val:0x100
TEST_RR_OP(remuw, x13, x8, x16, 0x0, 0x2000000000000000, 0x100, x1, 112, x22)

inst_15:
// rs1==x17, rs2==x29, rd==x3, rs2_val == 512, rs1_val == 17179869184
// opcode: remuw ; op1:x17; op2:x29; dest:x3; op1val:0x400000000;  op2val:0x200
TEST_RR_OP(remuw, x3, x17, x29, 0x0, 0x400000000, 0x200, x1, 120, x22)

inst_16:
// rs1==x21, rs2==x7, rd==x12, rs2_val == 1024, 
// opcode: remuw ; op1:x21; op2:x7; dest:x12; op1val:0xfffbffffffffffff;  op2val:0x400
TEST_RR_OP(remuw, x12, x21, x7, 0x3ff, 0xfffbffffffffffff, 0x400, x1, 128, x22)

inst_17:
// rs1==x5, rs2==x30, rd==x10, rs2_val == 2048, rs1_val == 18446744073705357311
// opcode: remuw ; op1:x5; op2:x30; dest:x10; op1val:0xffffffffffbfffff;  op2val:0x800
TEST_RR_OP(remuw, x10, x5, x30, 0x7ff, 0xffffffffffbfffff, 0x800, x1, 136, x22)
RVTEST_SIGBASE( x4,signature_x4_0)

inst_18:
// rs1==x10, rs2==x5, rd==x29, rs2_val == 4096, rs1_val == 9007199254740992
// opcode: remuw ; op1:x10; op2:x5; dest:x29; op1val:0x20000000000000;  op2val:0x1000
TEST_RR_OP(remuw, x29, x10, x5, 0x0, 0x20000000000000, 0x1000, x4, 0, x7)

inst_19:
// rs1==x12, rs2==x27, rd==x30, rs2_val == 8192, rs1_val == 33554432
// opcode: remuw ; op1:x12; op2:x27; dest:x30; op1val:0x2000000;  op2val:0x2000
TEST_RR_OP(remuw, x30, x12, x27, 0x0, 0x2000000, 0x2000, x4, 8, x7)

inst_20:
// rs1==x24, rs2==x17, rd==x6, rs2_val == 16384, rs1_val == 18446744073709551614
// opcode: remuw ; op1:x24; op2:x17; dest:x6; op1val:0xfffffffffffffffe;  op2val:0x4000
TEST_RR_OP(remuw, x6, x24, x17, 0x3ffe, 0xfffffffffffffffe, 0x4000, x4, 16, x7)

inst_21:
// rs1==x23, rs2==x3, rd==x0, rs2_val == 32768, rs1_val == 562949953421312
// opcode: remuw ; op1:x23; op2:x3; dest:x0; op1val:0x2000000000000;  op2val:0x8000
TEST_RR_OP(remuw, x0, x23, x3, 0, 0x2000000000000, 0x8000, x4, 24, x7)

inst_22:
// rs1==x31, rs2==x13, rd==x20, rs2_val == 65536, rs1_val == 18446744073172680703
// opcode: remuw ; op1:x31; op2:x13; dest:x20; op1val:0xffffffffdfffffff;  op2val:0x10000
TEST_RR_OP(remuw, x20, x31, x13, 0xffff, 0xffffffffdfffffff, 0x10000, x4, 32, x7)

inst_23:
// rs1==x1, rs2==x23, rd==x8, rs2_val == 131072, 
// opcode: remuw ; op1:x1; op2:x23; dest:x8; op1val:0x100000000;  op2val:0x20000
TEST_RR_OP(remuw, x8, x1, x23, 0x0, 0x100000000, 0x20000, x4, 40, x7)

inst_24:
// rs1==x28, rs2==x25, rd==x5, rs2_val == 262144, 
// opcode: remuw ; op1:x28; op2:x25; dest:x5; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x40000
TEST_RR_OP(remuw, x5, x28, x25, 0x2aaab, 0xaaaaaaaaaaaaaaab, 0x40000, x4, 48, x7)

inst_25:
// rs1==x6, rs2==x12, rd==x28, rs2_val == 524288, rs1_val == 13835058055282163711
// opcode: remuw ; op1:x6; op2:x12; dest:x28; op1val:0xbfffffffffffffff;  op2val:0x80000
TEST_RR_OP(remuw, x28, x6, x12, 0x7ffff, 0xbfffffffffffffff, 0x80000, x4, 56, x7)

inst_26:
// rs1==x22, rs2==x8, rd==x18, rs2_val == 1048576, rs1_val == 8589934592
// opcode: remuw ; op1:x22; op2:x8; dest:x18; op1val:0x200000000;  op2val:0x100000
TEST_RR_OP(remuw, x18, x22, x8, 0x0, 0x200000000, 0x100000, x4, 64, x7)

inst_27:
// rs1==x11, rs2==x22, rd==x1, rs2_val == 2097152, rs1_val == 18446462598732840959
// opcode: remuw ; op1:x11; op2:x22; dest:x1; op1val:0xfffeffffffffffff;  op2val:0x200000
TEST_RR_OP(remuw, x1, x11, x22, 0x1fffff, 0xfffeffffffffffff, 0x200000, x4, 72, x7)

inst_28:
// rs1==x26, rs2==x1, rd==x22, rs2_val == 4194304, rs1_val == 72057594037927936
// opcode: remuw ; op1:x26; op2:x1; dest:x22; op1val:0x100000000000000;  op2val:0x400000
TEST_RR_OP(remuw, x22, x26, x1, 0x0, 0x100000000000000, 0x400000, x4, 80, x7)

inst_29:
// rs1==x13, rs2==x2, rd==x31, rs2_val == 16777216, rs1_val == 36028797018963968
// opcode: remuw ; op1:x13; op2:x2; dest:x31; op1val:0x80000000000000;  op2val:0x1000000
TEST_RR_OP(remuw, x31, x13, x2, 0x0, 0x80000000000000, 0x1000000, x4, 88, x7)

inst_30:
// rs1==x27, rs2==x10, rd==x23, rs2_val == 33554432, rs1_val == 17293822569102704639
// opcode: remuw ; op1:x27; op2:x10; dest:x23; op1val:0xefffffffffffffff;  op2val:0x2000000
TEST_RR_OP(remuw, x23, x27, x10, 0x1ffffff, 0xefffffffffffffff, 0x2000000, x4, 96, x7)

inst_31:
// rs1==x18, rs2==x24, rd==x2, rs2_val == 67108864, rs1_val == 8192
// opcode: remuw ; op1:x18; op2:x24; dest:x2; op1val:0x2000;  op2val:0x4000000
TEST_RR_OP(remuw, x2, x18, x24, 0x2000, 0x2000, 0x4000000, x4, 104, x7)

inst_32:
// rs2_val == 134217728, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x8000000
TEST_RR_OP(remuw, x12, x10, x11, 0x5555556, 0x5555555555555556, 0x8000000, x4, 112, x7)

inst_33:
// rs2_val == 268435456, rs1_val == 18446744073709551613
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffd;  op2val:0x10000000
TEST_RR_OP(remuw, x12, x10, x11, 0xffffffd, 0xfffffffffffffffd, 0x10000000, x4, 120, x7)

inst_34:
// rs2_val == 536870912, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0x20000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x2000000000000, 0x20000000, x4, 128, x7)

inst_35:
// rs2_val == 1073741824, rs1_val == 2048
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:0x40000000
TEST_RR_OP(remuw, x12, x10, x11, 0x800, 0x800, 0x40000000, x4, 136, x7)

inst_36:
// rs2_val == 2147483648, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x80000000
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x80000000, x4, 144, x7)

inst_37:
// rs2_val == 4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x100000, 0x100000, 0x100000000, x4, 152, x7)

inst_38:
// rs2_val == 8589934592, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x200000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x200000000, x4, 160, x7)

inst_39:
// rs2_val == 17179869184, rs1_val == 16
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x400000000
TEST_RR_OP(remuw, x12, x10, x11, 0x10, 0x10, 0x400000000, x4, 168, x7)

inst_40:
// rs2_val == 34359738368, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x800000000
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x800000000, x4, 176, x7)

inst_41:
// rs2_val == 68719476736, rs1_val == 34359738368
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x1000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x800000000, 0x1000000000, x4, 184, x7)

inst_42:
// rs2_val == 137438953472, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x2000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0x2000000000, x4, 192, x7)

inst_43:
// rs2_val == 274877906944, rs1_val == 18446744073709551103
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffdff;  op2val:0x4000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x201, 0xfffffffffffffdff, 0x4000000000, x4, 200, x7)

inst_44:
// rs2_val == 549755813888, rs1_val == 68719476736
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0x8000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x1000000000, 0x8000000000, x4, 208, x7)

inst_45:
// rs2_val == 1099511627776, rs1_val == 18437736874454810623
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffdfffffffffffff;  op2val:0x10000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffdfffffffffffff, 0x10000000000, x4, 216, x7)

inst_46:
// rs2_val == 2199023255552, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x20000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x20000000000, x4, 224, x7)

inst_47:
// rs2_val == 4398046511104, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0x40000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x80000000000000, 0x40000000000, x4, 232, x7)

inst_48:
// rs2_val == 8796093022208, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xf;  op2val:0x80000000000
TEST_RR_OP(remuw, x12, x10, x11, 0xf, 0xf, 0x80000000000, x4, 240, x7)

inst_49:
// rs2_val == 17592186044416, rs1_val == 18158513697557839871
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfbffffffffffffff;  op2val:0x100000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xfbffffffffffffff, 0x100000000000, x4, 248, x7)

inst_50:
// rs2_val == 35184372088832, rs1_val == 4503599627370496
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0x200000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x10000000000000, 0x200000000000, x4, 256, x7)

inst_51:
// rs2_val == 70368744177664, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x400000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x400000000000, x4, 264, x7)

inst_52:
// rs2_val == 140737488355328, rs1_val == 18446744073709551551
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffbf;  op2val:0x800000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x41, 0xffffffffffffffbf, 0x800000000000, x4, 272, x7)

inst_53:
// rs2_val == 281474976710656, rs1_val == 2
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x1000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x1000000000000, x4, 280, x7)

inst_54:
// rs2_val == 562949953421312, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x12;  op2val:0x2000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x12, 0x12, 0x2000000000000, x4, 288, x7)

inst_55:
// rs2_val == 1125899906842624, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0x4000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x80, 0x80, 0x4000000000000, x4, 296, x7)

inst_56:
// rs2_val == 2251799813685248, rs1_val == 18302628885633695743
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfdffffffffffffff;  op2val:0x8000000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xfdffffffffffffff, 0x8000000000000, x4, 304, x7)

inst_57:
// rs2_val == 4503599627370496, rs1_val == 18446708889337462783
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffdfffffffffff;  op2val:0x10000000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffffdfffffffffff, 0x10000000000000, x4, 312, x7)

inst_58:
// rs2_val == 9007199254740992, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffff;  op2val:0x20000000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffffffffffffffff, 0x20000000000000, x4, 320, x7)

inst_59:
// rs2_val == 18014398509481984, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x40000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0x40000000000000, x4, 328, x7)

inst_60:
// rs2_val == 36028797018963968, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x80000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x80000000000000, x4, 336, x7)

inst_61:
// rs2_val == 72057594037927936, rs1_val == 35184372088832
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x100000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x200000000000, 0x100000000000000, x4, 344, x7)

inst_62:
// rs2_val == 144115188075855872, rs1_val == 1152921504606846976
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x200000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x1000000000000000, 0x200000000000000, x4, 352, x7)

inst_63:
// rs2_val == 288230376151711744, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb;  op2val:0x400000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0xb, 0xb, 0x400000000000000, x4, 360, x7)

inst_64:
// rs2_val == 576460752303423488, rs1_val == 2199023255552
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:0x800000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x20000000000, 0x800000000000000, x4, 368, x7)

inst_65:
// rs2_val == 1152921504606846976, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x1000000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x200000000000, 0x1000000000000000, x4, 376, x7)

inst_66:
// rs2_val == 2305843009213693952, rs1_val == 4398046511104
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0x2000000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x40000000000, 0x2000000000000000, x4, 384, x7)

inst_67:
// rs2_val == 4611686018427387904, rs1_val == 18428729675200069631
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffbfffffffffffff;  op2val:0x4000000000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffbfffffffffffff, 0x4000000000000000, x4, 392, x7)

inst_68:
// rs2_val == 9223372036854775808, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffbfffffffffffff;  op2val:0x8000000000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffbfffffffffffff, 0x8000000000000000, x4, 400, x7)

inst_69:
// rs2_val == 18446744073709551614, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xfffffffffffffffe
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xfffffffffffffffe, x4, 408, x7)

inst_70:
// rs2_val == 18446744073709551613, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xfffffffffffffffd
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xfffffffffffffffd, x4, 416, x7)

inst_71:
// rs2_val == 18446744073709551611, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xfffffffffffffffb
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xfffffffffffffffb, x4, 424, x7)

inst_72:
// rs2_val == 18446744073709551607, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xfffffffffffffff7
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0xfffffffffffffff7, x4, 432, x7)

inst_73:
// rs2_val == 18446744073709551599, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0xffffffffffffffef
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000000000, 0xffffffffffffffef, x4, 440, x7)

inst_74:
// rs2_val == 18446744073709551583, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xffffffffffffffdf
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xffffffffffffffdf, x4, 448, x7)

inst_75:
// rs2_val == 18446744073709551551, rs1_val == 18446181123756130303
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffdffffffffffff;  op2val:0xffffffffffffffbf
TEST_RR_OP(remuw, x12, x10, x11, 0x40, 0xfffdffffffffffff, 0xffffffffffffffbf, x4, 456, x7)

inst_76:
// rs2_val == 18446744073709551487, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xffffffffffffff7f
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xffffffffffffff7f, x4, 464, x7)

inst_77:
// rs2_val == 18446744073709551359, rs1_val == 18446744073709543423
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffdfff;  op2val:0xfffffffffffffeff
TEST_RR_OP(remuw, x12, x10, x11, -0x2001, 0xffffffffffffdfff, 0xfffffffffffffeff, x4, 472, x7)

inst_78:
// rs2_val == 18446744073709551103, rs1_val == 144115188075855872
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:0xfffffffffffffdff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x200000000000000, 0xfffffffffffffdff, x4, 480, x7)

inst_79:
// rs2_val == 18446744073709550591, rs1_val == 524288
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:0xfffffffffffffbff
TEST_RR_OP(remuw, x12, x10, x11, 0x80000, 0x80000, 0xfffffffffffffbff, x4, 488, x7)

inst_80:
// rs2_val == 18446744073709549567, rs1_val == 18446743936270598143
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffdfffffffff;  op2val:0xfffffffffffff7ff
TEST_RR_OP(remuw, x12, x10, x11, 0x800, 0xffffffdfffffffff, 0xfffffffffffff7ff, x4, 496, x7)

inst_81:
// rs2_val == 18446744073709547519, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xffffffffffffefff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xffffffffffffefff, x4, 504, x7)

inst_82:
// rs2_val == 18446744073709543423, rs1_val == 512
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:0xffffffffffffdfff
TEST_RR_OP(remuw, x12, x10, x11, 0x200, 0x200, 0xffffffffffffdfff, x4, 512, x7)

inst_83:
// rs2_val == 18446744073709535231, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xffffffffffffbfff
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0xffffffffffffbfff, x4, 520, x7)

inst_84:
// rs2_val == 18446744073709518847, rs1_val == 18446744073709551583
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffdf;  op2val:0xffffffffffff7fff
TEST_RR_OP(remuw, x12, x10, x11, 0x7fe0, 0xffffffffffffffdf, 0xffffffffffff7fff, x4, 528, x7)

inst_85:
// rs2_val == 18446744073709486079, rs1_val == 268435456
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:0xfffffffffffeffff
TEST_RR_OP(remuw, x12, x10, x11, 0x10000000, 0x10000000, 0xfffffffffffeffff, x4, 536, x7)

inst_86:
// rs2_val == 18446744073709420543, rs1_val == 18446744073709289471
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffbffff;  op2val:0xfffffffffffdffff
TEST_RR_OP(remuw, x12, x10, x11, -0x40001, 0xfffffffffffbffff, 0xfffffffffffdffff, x4, 544, x7)

inst_87:
// rs2_val == 18446744073709289471, rs1_val == 70368744177664
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0xfffffffffffbffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x400000000000, 0xfffffffffffbffff, x4, 552, x7)

inst_88:
// rs2_val == 18446744073709027327, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xfffffffffff7ffff
TEST_RR_OP(remuw, x12, x10, x11, 0x80000, 0xffffffff, 0xfffffffffff7ffff, x4, 560, x7)

inst_89:
// rs2_val == 18446744073708503039, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xffffffffffefffff
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xffffffffffefffff, x4, 568, x7)

inst_90:
// rs2_val == 18446744073707454463, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0xffffffffffdfffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x40000000000, 0xffffffffffdfffff, x4, 576, x7)

inst_91:
// rs2_val == 18446744073705357311, rs1_val == 64
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x40;  op2val:0xffffffffffbfffff
TEST_RR_OP(remuw, x12, x10, x11, 0x40, 0x40, 0xffffffffffbfffff, x4, 584, x7)

inst_92:
// rs2_val == 18446744073701163007, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xffffffffff7fffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xffffffffff7fffff, x4, 592, x7)

inst_93:
// rs2_val == 18446744073692774399, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x11;  op2val:0xfffffffffeffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x11, 0x11, 0xfffffffffeffffff, x4, 600, x7)

inst_94:
// rs2_val == 18446744073675997183, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffdff;  op2val:0xfffffffffdffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x1fffe00, 0xfffffffffffffdff, 0xfffffffffdffffff, x4, 608, x7)

inst_95:
// rs2_val == 18446744073642442751, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xfffffffffbffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x55555555, 0xaaaaaaaaaaaaaaab, 0xfffffffffbffffff, x4, 616, x7)

inst_96:
// rs2_val == 18446744073575333887, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xfffffffff7ffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xfffffffff7ffffff, x4, 624, x7)

inst_97:
// rs2_val == 18446744073441116159, rs1_val == 1099511627776
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0xffffffffefffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x10000000000, 0xffffffffefffffff, x4, 632, x7)

inst_98:
// rs2_val == 18446744073172680703, rs1_val == 18374686479671623679
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfeffffffffffffff;  op2val:0xffffffffdfffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x20000000, 0xfeffffffffffffff, 0xffffffffdfffffff, x4, 640, x7)

inst_99:
// rs2_val == 18446744072635809791, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x7;  op2val:0xffffffffbfffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x7, 0x7, 0xffffffffbfffffff, x4, 648, x7)

inst_100:
// rs2_val == 18446744071562067967, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xffffffff7fffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xffffffff7fffffff, x4, 656, x7)

inst_101:
// rs2_val == 18446744069414584319, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xfffffffeffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xfffffffeffffffff, x4, 664, x7)

inst_102:
// rs2_val == 18446744065119617023, rs1_val == 18446744071562067967
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff7fffffff;  op2val:0xfffffffdffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x7fffffff, 0xffffffff7fffffff, 0xfffffffdffffffff, x4, 672, x7)

inst_103:
// rs2_val == 18446744056529682431, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xfffffffbffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xfffffffbffffffff, x4, 680, x7)

inst_104:
// rs2_val == 18446744039349813247, rs1_val == 4611686018427387904
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:0xfffffff7ffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x4000000000000000, 0xfffffff7ffffffff, x4, 688, x7)

inst_105:
// rs2_val == 18446744004990074879, rs1_val == 16384
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:0xffffffefffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x4000, 0x4000, 0xffffffefffffffff, x4, 696, x7)

inst_106:
// rs2_val == 18446743936270598143, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffbfffffffffffff;  op2val:0xffffffdfffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffbfffffffffffff, 0xffffffdfffffffff, x4, 704, x7)

inst_107:
// rs2_val == 18446743798831644671, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0xffffffbfffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x10000000000, 0xffffffbfffffffff, x4, 712, x7)

inst_108:
// rs2_val == 18446743523953737727, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffdfff;  op2val:0xffffff7fffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x2001, 0xffffffffffffdfff, 0xffffff7fffffffff, x4, 720, x7)

inst_109:
// rs2_val == 18446742974197923839, rs1_val == 9223372036854775808
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000000;  op2val:0xfffffeffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x8000000000000000, 0xfffffeffffffffff, x4, 728, x7)

inst_110:
// rs2_val == 18446741874686296063, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:0xfffffdffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x80, 0x80, 0xfffffdffffffffff, x4, 736, x7)

inst_111:
// rs2_val == 18446739675663040511, rs1_val == 8
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:0xfffffbffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x8, 0x8, 0xfffffbffffffffff, x4, 744, x7)

inst_112:
// rs2_val == 18446735277616529407, rs1_val == 18446744073709518847
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffff7fff;  op2val:0xfffff7ffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x8001, 0xffffffffffff7fff, 0xfffff7ffffffffff, x4, 752, x7)

inst_113:
// rs2_val == 18446726481523507199, rs1_val == 18446744073709551359
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffeff;  op2val:0xffffefffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x101, 0xfffffffffffffeff, 0xffffefffffffffff, x4, 760, x7)

inst_114:
// rs2_val == 18446708889337462783, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0xffffdfffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000000000, 0xffffdfffffffffff, x4, 768, x7)

inst_115:
// rs2_val == 18446673704965373951, rs1_val == 281474976710656
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000;  op2val:0xffffbfffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x1000000000000, 0xffffbfffffffffff, x4, 776, x7)

inst_116:
// rs2_val == 18446603336221196287, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xffff7fffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xffff7fffffffffff, x4, 784, x7)

inst_117:
// rs2_val == 18446462598732840959, rs1_val == 18446744073709549567
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffff7ff;  op2val:0xfffeffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x801, 0xfffffffffffff7ff, 0xfffeffffffffffff, x4, 792, x7)

inst_118:
// rs2_val == 18446181123756130303, rs1_val == 18446744073441116159
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffefffffff;  op2val:0xfffdffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x10000001, 0xffffffffefffffff, 0xfffdffffffffffff, x4, 800, x7)

inst_119:
// rs2_val == 18445618173802708991, rs1_val == 9223372036854775807
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:0xfffbffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x7fffffffffffffff, 0xfffbffffffffffff, x4, 808, x7)

inst_120:
// rs2_val == 18444492273895866367, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xfff7ffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xfff7ffffffffffff, x4, 816, x7)

inst_121:
// rs2_val == 18442240474082181119, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x12;  op2val:0xffefffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x12, 0x12, 0xffefffffffffffff, x4, 824, x7)

inst_122:
// rs2_val == 18437736874454810623, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xffdfffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xffdfffffffffffff, x4, 832, x7)

inst_123:
// rs2_val == 18428729675200069631, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0xffbfffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x200000000000, 0xffbfffffffffffff, x4, 840, x7)

inst_124:
// rs2_val == 18410715276690587647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffdf;  op2val:0xff7fffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x21, 0xffffffffffffffdf, 0xff7fffffffffffff, x4, 848, x7)

inst_125:
// rs2_val == 18374686479671623679, rs1_val == 18446743798831644671
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffbfffffffff;  op2val:0xfeffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffbfffffffff, 0xfeffffffffffffff, x4, 856, x7)

inst_126:
// rs2_val == 18302628885633695743, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000000;  op2val:0xfdffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x20000000000000, 0xfdffffffffffffff, x4, 864, x7)

inst_127:
// rs2_val == 18158513697557839871, rs1_val == 18446741874686296063
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffdffffffffff;  op2val:0xfbffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xfffffdffffffffff, 0xfbffffffffffffff, x4, 872, x7)

inst_128:
// rs2_val == 17870283321406128127, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0xf7ffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x1000000000, 0xf7ffffffffffffff, x4, 880, x7)

inst_129:
// rs2_val == 17293822569102704639, rs1_val == 18446744073709027327
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffff7ffff;  op2val:0xefffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x80001, 0xfffffffffff7ffff, 0xefffffffffffffff, x4, 888, x7)

inst_130:
// rs2_val == 16140901064495857663, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffff7ff;  op2val:0xdfffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x801, 0xfffffffffffff7ff, 0xdfffffffffffffff, x4, 896, x7)

inst_131:
// rs2_val == 13835058055282163711, rs1_val == 2251799813685248
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:0xbfffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x8000000000000, 0xbfffffffffffffff, x4, 904, x7)

inst_132:
// rs2_val == 9223372036854775807, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:0x7fffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x1000000000, 0x7fffffffffffffff, x4, 912, x7)

inst_133:
// rs2_val == 6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x40000000000, 0x5555555555555555, x4, 920, x7)

inst_134:
// rs1_val == 4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffffbfffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xffffbfffffffffff, x4, 928, x7)

inst_135:
// rs1_val == 32, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:0x1000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x20, 0x20, 0x1000000000000, x4, 936, x7)

inst_136:
// rs1_val == 256, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:0x11
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100, 0x11, x4, 944, x7)

inst_137:
// rs1_val == 1024, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:0x20000
TEST_RR_OP(remuw, x12, x10, x11, 0x400, 0x400, 0x20000, x4, 952, x7)

inst_138:
// rs1_val == 4096, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0xffffffffffffff7f
TEST_RR_OP(remuw, x12, x10, x11, 0x1000, 0x1000, 0xffffffffffffff7f, x4, 960, x7)

inst_139:
// rs1_val == 32768, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0x400
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x8000, 0x400, x4, 968, x7)

inst_140:
// rs1_val == 65536, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:0x100000
TEST_RR_OP(remuw, x12, x10, x11, 0x10000, 0x10000, 0x100000, x4, 976, x7)

inst_141:
// rs1_val == 131072, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0x8000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x20000, 0x20000, 0x8000000000, x4, 984, x7)

inst_142:
// rs1_val == 262144, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:0xffffffbfffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x40000, 0x40000, 0xffffffbfffffffff, x4, 992, x7)

inst_143:
// rs1_val == 2097152, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0xfffffffffbffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x200000, 0x200000, 0xfffffffffbffffff, x4, 1000, x7)

inst_144:
// rs1_val == 4194304, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x400000, 0x6, x4, 1008, x7)

inst_145:
// rs1_val == 8388608, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:0xffffffffffffbfff
TEST_RR_OP(remuw, x12, x10, x11, 0x800000, 0x800000, 0xffffffffffffbfff, x4, 1016, x7)

inst_146:
// rs1_val == 16777216, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x8000000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x1000000, 0x1000000, 0x8000000000000000, x4, 1024, x7)

inst_147:
// rs1_val == 67108864, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x4000000, 0x4000000, 0xaaaaaaaaaaaaaaaa, x4, 1032, x7)

inst_148:
// rs1_val == 134217728, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0xbfffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x8000000, 0x8000000, 0xbfffffffffffffff, x4, 1040, x7)

inst_149:
// rs1_val == 536870912, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:0xfffffffffffbffff
TEST_RR_OP(remuw, x12, x10, x11, 0x20000000, 0x20000000, 0xfffffffffffbffff, x4, 1048, x7)

inst_150:
// rs1_val == 1073741824, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:0xffffffffffffefff
TEST_RR_OP(remuw, x12, x10, x11, 0x40000000, 0x40000000, 0xffffffffffffefff, x4, 1056, x7)

inst_151:
// rs1_val == 2147483648, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:0xfff7ffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x80000000, 0x80000000, 0xfff7ffffffffffff, x4, 1064, x7)

inst_152:
// rs1_val == 137438953472, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0x80000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x2000000000, 0x80000000000000, x4, 1072, x7)

inst_153:
// rs1_val == 274877906944, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000;  op2val:0xfff7ffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x4000000000, 0xfff7ffffffffffff, x4, 1080, x7)

inst_154:
// rs1_val == 549755813888, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:0x8000000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x8000000000, 0x8000000000000000, x4, 1088, x7)

inst_155:
// rs1_val == 8796093022208, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0xd
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x80000000000, 0xd, x4, 1096, x7)

inst_156:
// rs1_val == 17592186044416, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x8000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000000, 0x8000000000, x4, 1104, x7)

inst_157:
// rs1_val == 140737488355328, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x20000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x800000000000, 0x20000000, x4, 1112, x7)

inst_158:
// rs1_val == 1125899906842624, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:0x80000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x4000000000000, 0x80000000000, x4, 1120, x7)

inst_159:
// rs1_val == 18014398509481984, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:0x40000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x40000000000000, 0x40000000000000, x4, 1128, x7)

inst_160:
// rs1_val == 288230376151711744, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0x80000000000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x400000000000000, 0x80000000000000, x4, 1136, x7)

inst_161:
// rs1_val == 576460752303423488, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:0xfffffdffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x800000000000000, 0xfffffdffffffffff, x4, 1144, x7)

inst_162:
// rs1_val == 18446744073709551611, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffffb;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0xfffffffffffffffb, 0x6, x4, 1152, x7)

inst_163:
// rs1_val == 18446744073709551607, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffff7;  op2val:0x10000000
TEST_RR_OP(remuw, x12, x10, x11, 0xffffff7, 0xfffffffffffffff7, 0x10000000, x4, 1160, x7)

inst_164:
// rs1_val == 18446744073709551599, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffffef;  op2val:0xffffffffffefffff
TEST_RR_OP(remuw, x12, x10, x11, 0xffff0, 0xffffffffffffffef, 0xffffffffffefffff, x4, 1168, x7)

inst_165:
// rs1_val == 18446744073709551487, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffff7f;  op2val:0xfffffbffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x81, 0xffffffffffffff7f, 0xfffffbffffffffff, x4, 1176, x7)

inst_166:
// rs1_val == 18446744073709550591, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffffbff;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0xfffffffffffffbff, 0x6, x4, 1184, x7)

inst_167:
// rs1_val == 18446744073709547519, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffefff;  op2val:0xffffffffff7fffff
TEST_RR_OP(remuw, x12, x10, x11, 0x7ff000, 0xffffffffffffefff, 0xffffffffff7fffff, x4, 1192, x7)

inst_168:
// rs1_val == 18446744073709535231, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffffbfff;  op2val:0x80000
TEST_RR_OP(remuw, x12, x10, x11, 0x7bfff, 0xffffffffffffbfff, 0x80000, x4, 1200, x7)

inst_169:
// rs1_val == 18446744073709486079, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffeffff;  op2val:0x200000
TEST_RR_OP(remuw, x12, x10, x11, 0x1effff, 0xfffffffffffeffff, 0x200000, x4, 1208, x7)

inst_170:
// rs1_val == 18446744073709420543, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffffdffff;  op2val:0xfffffffffffff7ff
TEST_RR_OP(remuw, x12, x10, x11, -0x20001, 0xfffffffffffdffff, 0xfffffffffffff7ff, x4, 1216, x7)

inst_171:
// rs1_val == 18446744073708503039, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffffefffff;  op2val:0xffffffffffbfffff
TEST_RR_OP(remuw, x12, x10, x11, 0x300000, 0xffffffffffefffff, 0xffffffffffbfffff, x4, 1224, x7)

inst_172:
// rs1_val == 18446744073701163007, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffff7fffff;  op2val:0x400000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x800001, 0xffffffffff7fffff, 0x400000000000, x4, 1232, x7)

inst_173:
// rs1_val == 18446744073692774399, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffeffffff;  op2val:0xfffffffbffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x1000001, 0xfffffffffeffffff, 0xfffffffbffffffff, x4, 1240, x7)

inst_174:
// rs1_val == 18446744073675997183, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffdffffff;  op2val:0xfffffffffffdffff
TEST_RR_OP(remuw, x12, x10, x11, -0x2000001, 0xfffffffffdffffff, 0xfffffffffffdffff, x4, 1248, x7)

inst_175:
// rs1_val == 18446744073642442751, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffffbffffff;  op2val:0x4000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x4000001, 0xfffffffffbffffff, 0x4000000000, x4, 1256, x7)

inst_176:
// rs1_val == 18446744073575333887, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffff7ffffff;  op2val:0xfffffffffeffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x8000001, 0xfffffffff7ffffff, 0xfffffffffeffffff, x4, 1264, x7)

inst_177:
// rs1_val == 18446744072635809791, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffffbfffffff;  op2val:0xffefffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x40000001, 0xffffffffbfffffff, 0xffefffffffffffff, x4, 1272, x7)

inst_178:
// rs1_val == 18446744069414584319, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffeffffffff;  op2val:0x100000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xfffffffeffffffff, 0x100000000000, x4, 1280, x7)

inst_179:
// rs1_val == 18446744065119617023, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffdffffffff;  op2val:0x40000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xfffffffdffffffff, 0x40000000000, x4, 1288, x7)

inst_180:
// rs1_val == 18446744056529682431, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffffbffffffff;  op2val:0xf
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xfffffffbffffffff, 0xf, x4, 1296, x7)

inst_181:
// rs1_val == 18446744039349813247, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffff7ffffffff;  op2val:0x4000
TEST_RR_OP(remuw, x12, x10, x11, 0x3fff, 0xfffffff7ffffffff, 0x4000, x4, 1304, x7)

inst_182:
// rs1_val == 18446743523953737727, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffff7fffffffff;  op2val:0x80000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffffff7fffffffff, 0x80000000000, x4, 1312, x7)

inst_183:
// rs1_val == 18446742974197923839, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffeffffffffff;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xfffffeffffffffff, 0x2, x4, 1320, x7)

inst_184:
// rs1_val == 18446739675663040511, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffffbffffffffff;  op2val:0xffffffffffff7fff
TEST_RR_OP(remuw, x12, x10, x11, 0x8000, 0xfffffbffffffffff, 0xffffffffffff7fff, x4, 1328, x7)

inst_185:
// rs1_val == 18446735277616529407, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffff7ffffffffff;  op2val:0xfeffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xfffff7ffffffffff, 0xfeffffffffffffff, x4, 1336, x7)

inst_186:
// rs1_val == 18446726481523507199, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffefffffffffff;  op2val:0x200000000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffffefffffffffff, 0x200000000000000, x4, 1344, x7)

inst_187:
// rs1_val == 18446673704965373951, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffbfffffffffff;  op2val:0x4000000
TEST_RR_OP(remuw, x12, x10, x11, 0x3ffffff, 0xffffbfffffffffff, 0x4000000, x4, 1352, x7)

inst_188:
// rs1_val == 18444492273895866367, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfff7ffffffffffff;  op2val:0xffffffffffffbfff
TEST_RR_OP(remuw, x12, x10, x11, 0x4000, 0xfff7ffffffffffff, 0xffffffffffffbfff, x4, 1360, x7)

inst_189:
// rs1_val == 18442240474082181119, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffefffffffffffff;  op2val:0x200
TEST_RR_OP(remuw, x12, x10, x11, 0x1ff, 0xffefffffffffffff, 0x200, x4, 1368, x7)

inst_190:
// rs1_val == 18410715276690587647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xff7fffffffffffff;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xff7fffffffffffff, 0x3, x4, 1376, x7)

inst_191:
// rs1_val == 17870283321406128127, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xf7ffffffffffffff;  op2val:0xfbffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xf7ffffffffffffff, 0xfbffffffffffffff, x4, 1384, x7)

inst_192:
// rs1_val == 16140901064495857663, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xdfffffffffffffff;  op2val:0x40000000000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xdfffffffffffffff, 0x40000000000000, x4, 1392, x7)

inst_193:
// rs1_val==3 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3, 0x3, x4, 1400, x7)

inst_194:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x5555555555555555, x4, 1408, x7)

inst_195:
// rs1_val==3 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xaaaaaaaaaaaaaaaa, x4, 1416, x7)

inst_196:
// rs1_val==3 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x5, x4, 1424, x7)

inst_197:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x3333333333333333, x4, 1432, x7)

inst_198:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x6666666666666666, x4, 1440, x7)

inst_199:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xb504f333, x4, 1448, x7)

inst_200:
// rs1_val==3 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x0, x4, 1456, x7)

inst_201:
// rs1_val==3 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x100000000, x4, 1464, x7)

inst_202:
// rs1_val==3 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x3, 0x2, x4, 1472, x7)

inst_203:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x5555555555555554, x4, 1480, x7)

inst_204:
// rs1_val==3 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xaaaaaaaaaaaaaaa9, x4, 1488, x7)

inst_205:
// rs1_val==3 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x4, x4, 1496, x7)

inst_206:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x3333333333333332, x4, 1504, x7)

inst_207:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x6666666666666665, x4, 1512, x7)

inst_208:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xb504f332, x4, 1520, x7)

inst_209:
// rs1_val==3 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xffffffff, x4, 1528, x7)

inst_210:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x5555555555555556, x4, 1536, x7)

inst_211:
// rs1_val==3 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xaaaaaaaaaaaaaaab, x4, 1544, x7)

inst_212:
// rs1_val==3 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x6, x4, 1552, x7)

inst_213:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x3333333333333334, x4, 1560, x7)

inst_214:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0x6666666666666667, x4, 1568, x7)

inst_215:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3, 0xb504f334, x4, 1576, x7)

inst_216:
// rs1_val==3 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3, 0x1, x4, 1584, x7)

inst_217:
// rs1_val==3 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3, 0x100000001, x4, 1592, x7)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5555555555555555, 0x3, x4, 1600, x7)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555555, x4, 1608, x7)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0xaaaaaaaaaaaaaaaa, x4, 1616, x7)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555555, 0x5, x4, 1624, x7)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x22222222, 0x5555555555555555, 0x3333333333333333, x4, 1632, x7)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x6666666666666666, x4, 1640, x7)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0xb504f333, x4, 1648, x7)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x0, x4, 1656, x7)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x100000000, x4, 1664, x7)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5555555555555555, 0x2, x4, 1672, x7)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555554, x4, 1680, x7)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0xaaaaaaaaaaaaaaa9, x4, 1688, x7)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5555555555555555, 0x4, x4, 1696, x7)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x22222223, 0x5555555555555555, 0x3333333333333332, x4, 1704, x7)

inst_232:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x6666666666666665, x4, 1712, x7)

inst_233:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0xb504f332, x4, 1720, x7)

inst_234:
// rs1_val==6148914691236517205 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0xffffffff, x4, 1728, x7)

inst_235:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x5555555555555556, x4, 1736, x7)

inst_236:
// rs1_val==6148914691236517205 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0xaaaaaaaaaaaaaaab, x4, 1744, x7)

inst_237:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5555555555555555, 0x6, x4, 1752, x7)

inst_238:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x22222221, 0x5555555555555555, 0x3333333333333334, x4, 1760, x7)

inst_239:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x6666666666666667, x4, 1768, x7)

inst_240:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0xb504f334, x4, 1776, x7)

inst_241:
// rs1_val==6148914691236517205 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555555, 0x1, x4, 1784, x7)

inst_242:
// rs1_val==6148914691236517205 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555555, 0x100000001, x4, 1792, x7)

inst_243:
// rs1_val==12297829382473034410 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaaa, 0x3, x4, 1800, x7)

inst_244:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5555555555555555, x4, 1808, x7)

inst_245:
// rs1_val==12297829382473034410 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x5, x4, 1816, x7)

inst_246:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x11111111, 0xaaaaaaaaaaaaaaaa, 0x3333333333333333, x4, 1824, x7)

inst_247:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x44444444, 0xaaaaaaaaaaaaaaaa, 0x6666666666666666, x4, 1832, x7)

inst_248:
// rs1_val==12297829382473034410 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0xb504f333, x4, 1840, x7)

inst_249:
// rs1_val==12297829382473034410 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0x0, x4, 1848, x7)

inst_250:
// rs1_val==12297829382473034410 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0x100000000, x4, 1856, x7)

inst_251:
// rs1_val==12297829382473034410 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x2, x4, 1864, x7)

inst_252:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaaa, 0x5555555555555554, x4, 1872, x7)

inst_253:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaa9, x4, 1880, x7)

inst_254:
// rs1_val==12297829382473034410 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaaa, 0x4, x4, 1888, x7)

inst_255:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x11111114, 0xaaaaaaaaaaaaaaaa, 0x3333333333333332, x4, 1896, x7)

inst_256:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x44444445, 0xaaaaaaaaaaaaaaaa, 0x6666666666666665, x4, 1904, x7)

inst_257:
// rs1_val==12297829382473034410 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0xb504f332, x4, 1912, x7)

inst_258:
// rs1_val==12297829382473034410 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0xffffffff, x4, 1920, x7)

inst_259:
// rs1_val==12297829382473034410 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0xaaaaaaaaaaaaaaaa, 0x5555555555555556, x4, 1928, x7)

inst_260:
// rs1_val==12297829382473034410 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaab, x4, 1936, x7)

inst_261:
// rs1_val==12297829382473034410 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaaa, 0x6, x4, 1944, x7)

inst_262:
// rs1_val==12297829382473034410 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1111110e, 0xaaaaaaaaaaaaaaaa, 0x3333333333333334, x4, 1952, x7)

inst_263:
// rs1_val==12297829382473034410 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x44444443, 0xaaaaaaaaaaaaaaaa, 0x6666666666666667, x4, 1960, x7)

inst_264:
// rs1_val==12297829382473034410 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, -0x55555556, 0xaaaaaaaaaaaaaaaa, 0xb504f334, x4, 1968, x7)

inst_265:
// rs1_val==12297829382473034410 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x1, x4, 1976, x7)

inst_266:
// rs1_val==12297829382473034410 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0x100000001, x4, 1984, x7)

inst_267:
// rs1_val==5 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x5, 0x3, x4, 1992, x7)

inst_268:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x5555555555555555, x4, 2000, x7)

inst_269:
// rs1_val==5 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xaaaaaaaaaaaaaaaa, x4, 2008, x7)

inst_270:
// rs1_val==5 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5, 0x5, x4, 2016, x7)

inst_271:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x3333333333333333, x4, 2024, x7)

inst_272:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x6666666666666666, x4, 2032, x7)

inst_273:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xb504f333, x4, 2040, x7)
RVTEST_SIGBASE( x4,signature_x4_1)

inst_274:
// rs1_val==5 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x0, x4, 0, x7)

inst_275:
// rs1_val==5 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x100000000, x4, 8, x7)

inst_276:
// rs1_val==5 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5, 0x2, x4, 16, x7)

inst_277:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x5555555555555554, x4, 24, x7)

inst_278:
// rs1_val==5 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xaaaaaaaaaaaaaaa9, x4, 32, x7)

inst_279:
// rs1_val==5 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5, 0x4, x4, 40, x7)

inst_280:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x3333333333333332, x4, 48, x7)

inst_281:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x6666666666666665, x4, 56, x7)

inst_282:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xb504f332, x4, 64, x7)

inst_283:
// rs1_val==5 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xffffffff, x4, 72, x7)

inst_284:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x5555555555555556, x4, 80, x7)

inst_285:
// rs1_val==5 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xaaaaaaaaaaaaaaab, x4, 88, x7)

inst_286:
// rs1_val==5 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x6, x4, 96, x7)

inst_287:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x3333333333333334, x4, 104, x7)

inst_288:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0x6666666666666667, x4, 112, x7)

inst_289:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x5, 0xb504f334, x4, 120, x7)

inst_290:
// rs1_val==5 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5, 0x1, x4, 128, x7)

inst_291:
// rs1_val==5 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5, 0x100000001, x4, 136, x7)

inst_292:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333333, 0x3, x4, 144, x7)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x5555555555555555, x4, 152, x7)

inst_294:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xaaaaaaaaaaaaaaaa, x4, 160, x7)

inst_295:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x3333333333333333, 0x5, x4, 168, x7)

inst_296:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333333, x4, 176, x7)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x6666666666666666, x4, 184, x7)

inst_298:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xb504f333, x4, 192, x7)

inst_299:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x0, x4, 200, x7)

inst_300:
// rs1_val==3689348814741910323 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x100000000, x4, 208, x7)

inst_301:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x3333333333333333, 0x2, x4, 216, x7)

inst_302:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x5555555555555554, x4, 224, x7)

inst_303:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xaaaaaaaaaaaaaaa9, x4, 232, x7)

inst_304:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3333333333333333, 0x4, x4, 240, x7)

inst_305:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333332, x4, 248, x7)

inst_306:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x6666666666666665, x4, 256, x7)

inst_307:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xb504f332, x4, 264, x7)

inst_308:
// rs1_val==3689348814741910323 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xffffffff, x4, 272, x7)

inst_309:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x5555555555555556, x4, 280, x7)

inst_310:
// rs1_val==3689348814741910323 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xaaaaaaaaaaaaaaab, x4, 288, x7)

inst_311:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3333333333333333, 0x6, x4, 296, x7)

inst_312:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x3333333333333334, x4, 304, x7)

inst_313:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x6666666666666667, x4, 312, x7)

inst_314:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xb504f334, x4, 320, x7)

inst_315:
// rs1_val==3689348814741910323 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333333, 0x1, x4, 328, x7)

inst_316:
// rs1_val==3689348814741910323 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333333, 0x100000001, x4, 336, x7)

inst_317:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666666, 0x3, x4, 344, x7)

inst_318:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x11111111, 0x6666666666666666, 0x5555555555555555, x4, 352, x7)

inst_319:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xaaaaaaaaaaaaaaaa, x4, 360, x7)

inst_320:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x6666666666666666, 0x5, x4, 368, x7)

inst_321:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333333, x4, 376, x7)

inst_322:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666666, x4, 384, x7)

inst_323:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xb504f333, x4, 392, x7)

inst_324:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0x0, x4, 400, x7)

inst_325:
// rs1_val==7378697629483820646 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0x100000000, x4, 408, x7)

inst_326:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666666, 0x2, x4, 416, x7)

inst_327:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x11111112, 0x6666666666666666, 0x5555555555555554, x4, 424, x7)

inst_328:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xaaaaaaaaaaaaaaa9, x4, 432, x7)

inst_329:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x6666666666666666, 0x4, x4, 440, x7)

inst_330:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x6666666666666666, 0x3333333333333332, x4, 448, x7)

inst_331:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666665, x4, 456, x7)

inst_332:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xb504f332, x4, 464, x7)

inst_333:
// rs1_val==7378697629483820646 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xffffffff, x4, 472, x7)

inst_334:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x11111110, 0x6666666666666666, 0x5555555555555556, x4, 480, x7)

inst_335:
// rs1_val==7378697629483820646 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xaaaaaaaaaaaaaaab, x4, 488, x7)

inst_336:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666666, 0x6, x4, 496, x7)

inst_337:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x6666666666666666, 0x3333333333333334, x4, 504, x7)

inst_338:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0x6666666666666667, x4, 512, x7)

inst_339:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0xb504f334, x4, 520, x7)

inst_340:
// rs1_val==7378697629483820646 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666666, 0x1, x4, 528, x7)

inst_341:
// rs1_val==7378697629483820646 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666666, 0x100000001, x4, 536, x7)

inst_342:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xb504f333, 0x3, x4, 544, x7)

inst_343:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4889, 0xb504f333, 0x5555555555555555, x4, 552, x7)

inst_344:
// rs1_val==3037000499 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4889, 0xb504f333, 0xaaaaaaaaaaaaaaaa, x4, 560, x7)

inst_345:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0xb504f333, 0x5, x4, 568, x7)

inst_346:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b599a, 0xb504f333, 0x3333333333333333, x4, 576, x7)

inst_347:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8ccd, 0xb504f333, 0x6666666666666666, x4, 584, x7)

inst_348:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f333, 0xb504f333, x4, 592, x7)

inst_349:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x0, x4, 600, x7)

inst_350:
// rs1_val==3037000499 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x100000000, x4, 608, x7)

inst_351:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xb504f333, 0x2, x4, 616, x7)

inst_352:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a488b, 0xb504f333, 0x5555555555555554, x4, 624, x7)

inst_353:
// rs1_val==3037000499 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a488a, 0xb504f333, 0xaaaaaaaaaaaaaaa9, x4, 632, x7)

inst_354:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xb504f333, 0x4, x4, 640, x7)

inst_355:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b599d, 0xb504f333, 0x3333333333333332, x4, 648, x7)

inst_356:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8cce, 0xb504f333, 0x6666666666666665, x4, 656, x7)

inst_357:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xb504f333, 0xb504f332, x4, 664, x7)

inst_358:
// rs1_val==3037000499 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0xffffffff, x4, 672, x7)

inst_359:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4887, 0xb504f333, 0x5555555555555556, x4, 680, x7)

inst_360:
// rs1_val==3037000499 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4888, 0xb504f333, 0xaaaaaaaaaaaaaaab, x4, 688, x7)

inst_361:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0xb504f333, 0x6, x4, 696, x7)

inst_362:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b5997, 0xb504f333, 0x3333333333333334, x4, 704, x7)

inst_363:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8ccc, 0xb504f333, 0x6666666666666667, x4, 712, x7)

inst_364:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0xb504f334, x4, 720, x7)

inst_365:
// rs1_val==3037000499 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f333, 0x1, x4, 728, x7)

inst_366:
// rs1_val==3037000499 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f333, 0x100000001, x4, 736, x7)

inst_367:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x5555555555555555, x4, 744, x7)

inst_368:
// rs1_val==0 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xaaaaaaaaaaaaaaaa, x4, 752, x7)

inst_369:
// rs1_val==0 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x5, x4, 760, x7)

inst_370:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x3333333333333333, x4, 768, x7)

inst_371:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x6666666666666666, x4, 776, x7)

inst_372:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xb504f333, x4, 784, x7)

inst_373:
// rs1_val==0 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x0, x4, 792, x7)

inst_374:
// rs1_val==0 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x100000000, x4, 800, x7)

inst_375:
// rs1_val==0 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x2, x4, 808, x7)

inst_376:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x5555555555555554, x4, 816, x7)

inst_377:
// rs1_val==0 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xaaaaaaaaaaaaaaa9, x4, 824, x7)

inst_378:
// rs1_val==0 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x4, x4, 832, x7)

inst_379:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x3333333333333332, x4, 840, x7)

inst_380:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x6666666666666665, x4, 848, x7)

inst_381:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xb504f332, x4, 856, x7)

inst_382:
// rs1_val==0 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xffffffff, x4, 864, x7)

inst_383:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x5555555555555556, x4, 872, x7)

inst_384:
// rs1_val==0 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xaaaaaaaaaaaaaaab, x4, 880, x7)

inst_385:
// rs1_val==0 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x6, x4, 888, x7)

inst_386:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x3333333333333334, x4, 896, x7)

inst_387:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x6666666666666667, x4, 904, x7)

inst_388:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0xb504f334, x4, 912, x7)

inst_389:
// rs1_val==0 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x1, x4, 920, x7)

inst_390:
// rs1_val==0 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x0, 0x100000001, x4, 928, x7)

inst_391:
// rs1_val==4294967296 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x3, x4, 936, x7)

inst_392:
// rs1_val==4294967296 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x5555555555555555, x4, 944, x7)

inst_393:
// rs1_val==4294967296 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xaaaaaaaaaaaaaaaa, x4, 952, x7)

inst_394:
// rs1_val==4294967296 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x5, x4, 960, x7)

inst_395:
// rs1_val==4294967296 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x3333333333333333, x4, 968, x7)

inst_396:
// rs1_val==4294967296 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x6666666666666666, x4, 976, x7)

inst_397:
// rs1_val==4294967296 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xb504f333, x4, 984, x7)

inst_398:
// rs1_val==4294967296 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x0, x4, 992, x7)

inst_399:
// rs1_val==4294967296 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x100000000, x4, 1000, x7)

inst_400:
// rs1_val==4294967296 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x2, x4, 1008, x7)

inst_401:
// rs1_val==4294967296 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x5555555555555554, x4, 1016, x7)

inst_402:
// rs1_val==4294967296 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xaaaaaaaaaaaaaaa9, x4, 1024, x7)

inst_403:
// rs1_val==4294967296 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x3333333333333332, x4, 1032, x7)

inst_404:
// rs1_val==4294967296 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x6666666666666665, x4, 1040, x7)

inst_405:
// rs1_val==4294967296 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xb504f332, x4, 1048, x7)

inst_406:
// rs1_val==4294967296 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xffffffff, x4, 1056, x7)

inst_407:
// rs1_val==4294967296 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x5555555555555556, x4, 1064, x7)

inst_408:
// rs1_val==4294967296 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xaaaaaaaaaaaaaaab, x4, 1072, x7)

inst_409:
// rs1_val==4294967296 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x6, x4, 1080, x7)

inst_410:
// rs1_val==4294967296 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x3333333333333334, x4, 1088, x7)

inst_411:
// rs1_val==4294967296 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x6666666666666667, x4, 1096, x7)

inst_412:
// rs1_val==4294967296 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0xb504f334, x4, 1104, x7)

inst_413:
// rs1_val==4294967296 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x1, x4, 1112, x7)

inst_414:
// rs1_val==4294967296 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000000, 0x100000001, x4, 1120, x7)

inst_415:
// rs1_val==2 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x3, x4, 1128, x7)

inst_416:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x5555555555555555, x4, 1136, x7)

inst_417:
// rs1_val==2 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xaaaaaaaaaaaaaaaa, x4, 1144, x7)

inst_418:
// rs1_val==2 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x5, x4, 1152, x7)

inst_419:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x3333333333333333, x4, 1160, x7)

inst_420:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x6666666666666666, x4, 1168, x7)

inst_421:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xb504f333, x4, 1176, x7)

inst_422:
// rs1_val==2 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x0, x4, 1184, x7)

inst_423:
// rs1_val==2 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x100000000, x4, 1192, x7)

inst_424:
// rs1_val==2 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x2, 0x2, x4, 1200, x7)

inst_425:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x5555555555555554, x4, 1208, x7)

inst_426:
// rs1_val==2 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xaaaaaaaaaaaaaaa9, x4, 1216, x7)

inst_427:
// rs1_val==2 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x4, x4, 1224, x7)

inst_428:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x3333333333333332, x4, 1232, x7)

inst_429:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x6666666666666665, x4, 1240, x7)

inst_430:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xb504f332, x4, 1248, x7)

inst_431:
// rs1_val==2 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xffffffff, x4, 1256, x7)

inst_432:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x5555555555555556, x4, 1264, x7)

inst_433:
// rs1_val==2 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xaaaaaaaaaaaaaaab, x4, 1272, x7)

inst_434:
// rs1_val==2 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x6, x4, 1280, x7)

inst_435:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x3333333333333334, x4, 1288, x7)

inst_436:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0x6666666666666667, x4, 1296, x7)

inst_437:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x2, 0xb504f334, x4, 1304, x7)

inst_438:
// rs1_val==2 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x2, 0x1, x4, 1312, x7)

inst_439:
// rs1_val==2 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x2, 0x100000001, x4, 1320, x7)

inst_440:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555554, 0x3, x4, 1328, x7)

inst_441:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x5555555555555555, x4, 1336, x7)

inst_442:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xaaaaaaaaaaaaaaaa, x4, 1344, x7)

inst_443:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x5555555555555554, 0x5, x4, 1352, x7)

inst_444:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x22222221, 0x5555555555555554, 0x3333333333333333, x4, 1360, x7)

inst_445:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x6666666666666666, x4, 1368, x7)

inst_446:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xb504f333, x4, 1376, x7)

inst_447:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x0, x4, 1384, x7)

inst_448:
// rs1_val==6148914691236517204 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x100000000, x4, 1392, x7)

inst_449:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555554, 0x2, x4, 1400, x7)

inst_450:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555554, x4, 1408, x7)

inst_451:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xaaaaaaaaaaaaaaa9, x4, 1416, x7)

inst_452:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555554, 0x4, x4, 1424, x7)

inst_453:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x22222222, 0x5555555555555554, 0x3333333333333332, x4, 1432, x7)

inst_454:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x6666666666666665, x4, 1440, x7)

inst_455:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xb504f332, x4, 1448, x7)

inst_456:
// rs1_val==6148914691236517204 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xffffffff, x4, 1456, x7)

inst_457:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x5555555555555556, x4, 1464, x7)

inst_458:
// rs1_val==6148914691236517204 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xaaaaaaaaaaaaaaab, x4, 1472, x7)

inst_459:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555554, 0x6, x4, 1480, x7)

inst_460:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x22222220, 0x5555555555555554, 0x3333333333333334, x4, 1488, x7)

inst_461:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x6666666666666667, x4, 1496, x7)

inst_462:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0xb504f334, x4, 1504, x7)

inst_463:
// rs1_val==6148914691236517204 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555554, 0x1, x4, 1512, x7)

inst_464:
// rs1_val==6148914691236517204 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555554, 0x100000001, x4, 1520, x7)

inst_465:
// rs1_val==12297829382473034409 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x3, x4, 1528, x7)

inst_466:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0xaaaaaaaaaaaaaaa9, 0x5555555555555555, x4, 1536, x7)

inst_467:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaaa, x4, 1544, x7)

inst_468:
// rs1_val==12297829382473034409 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0xaaaaaaaaaaaaaaa9, 0x5, x4, 1552, x7)

inst_469:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x11111110, 0xaaaaaaaaaaaaaaa9, 0x3333333333333333, x4, 1560, x7)

inst_470:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x44444443, 0xaaaaaaaaaaaaaaa9, 0x6666666666666666, x4, 1568, x7)

inst_471:
// rs1_val==12297829382473034409 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0xb504f333, x4, 1576, x7)

inst_472:
// rs1_val==12297829382473034409 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0x0, x4, 1584, x7)

inst_473:
// rs1_val==12297829382473034409 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0x100000000, x4, 1592, x7)

inst_474:
// rs1_val==12297829382473034409 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x2, x4, 1600, x7)

inst_475:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x5555555555555554, x4, 1608, x7)

inst_476:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaa9, x4, 1616, x7)

inst_477:
// rs1_val==12297829382473034409 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x4, x4, 1624, x7)

inst_478:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x11111113, 0xaaaaaaaaaaaaaaa9, 0x3333333333333332, x4, 1632, x7)

inst_479:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x44444444, 0xaaaaaaaaaaaaaaa9, 0x6666666666666665, x4, 1640, x7)

inst_480:
// rs1_val==12297829382473034409 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0xb504f332, x4, 1648, x7)

inst_481:
// rs1_val==12297829382473034409 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0xffffffff, x4, 1656, x7)

inst_482:
// rs1_val==12297829382473034409 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x55555553, 0xaaaaaaaaaaaaaaa9, 0x5555555555555556, x4, 1664, x7)

inst_483:
// rs1_val==12297829382473034409 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0xaaaaaaaaaaaaaaab, x4, 1672, x7)

inst_484:
// rs1_val==12297829382473034409 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaa9, 0x6, x4, 1680, x7)

inst_485:
// rs1_val==12297829382473034409 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1111110d, 0xaaaaaaaaaaaaaaa9, 0x3333333333333334, x4, 1688, x7)

inst_486:
// rs1_val==12297829382473034409 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x44444442, 0xaaaaaaaaaaaaaaa9, 0x6666666666666667, x4, 1696, x7)

inst_487:
// rs1_val==12297829382473034409 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, -0x55555557, 0xaaaaaaaaaaaaaaa9, 0xb504f334, x4, 1704, x7)

inst_488:
// rs1_val==12297829382473034409 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x1, x4, 1712, x7)

inst_489:
// rs1_val==12297829382473034409 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaa9;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaa9, 0x100000001, x4, 1720, x7)

inst_490:
// rs1_val==4 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x4, 0x3, x4, 1728, x7)

inst_491:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x5555555555555555, x4, 1736, x7)

inst_492:
// rs1_val==4 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xaaaaaaaaaaaaaaaa, x4, 1744, x7)

inst_493:
// rs1_val==4 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x5, x4, 1752, x7)

inst_494:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x3333333333333333, x4, 1760, x7)

inst_495:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x6666666666666666, x4, 1768, x7)

inst_496:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xb504f333, x4, 1776, x7)

inst_497:
// rs1_val==4 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x0, x4, 1784, x7)

inst_498:
// rs1_val==4 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x100000000, x4, 1792, x7)

inst_499:
// rs1_val==4 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x4, 0x2, x4, 1800, x7)

inst_500:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x5555555555555554, x4, 1808, x7)

inst_501:
// rs1_val==4 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xaaaaaaaaaaaaaaa9, x4, 1816, x7)

inst_502:
// rs1_val==4 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x4, 0x4, x4, 1824, x7)

inst_503:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x3333333333333332, x4, 1832, x7)

inst_504:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x6666666666666665, x4, 1840, x7)

inst_505:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xb504f332, x4, 1848, x7)

inst_506:
// rs1_val==4 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xffffffff, x4, 1856, x7)

inst_507:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x5555555555555556, x4, 1864, x7)

inst_508:
// rs1_val==4 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xaaaaaaaaaaaaaaab, x4, 1872, x7)

inst_509:
// rs1_val==4 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x6, x4, 1880, x7)

inst_510:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x3333333333333334, x4, 1888, x7)

inst_511:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0x6666666666666667, x4, 1896, x7)

inst_512:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x4, 0xb504f334, x4, 1904, x7)

inst_513:
// rs1_val==4 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x4, 0x1, x4, 1912, x7)

inst_514:
// rs1_val==4 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x4, 0x100000001, x4, 1920, x7)

inst_515:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x3333333333333332, 0x3, x4, 1928, x7)

inst_516:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x5555555555555555, x4, 1936, x7)

inst_517:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xaaaaaaaaaaaaaaaa, x4, 1944, x7)

inst_518:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x3333333333333332, 0x5, x4, 1952, x7)

inst_519:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x3333333333333333, x4, 1960, x7)

inst_520:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x6666666666666666, x4, 1968, x7)

inst_521:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xb504f333, x4, 1976, x7)

inst_522:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x0, x4, 1984, x7)

inst_523:
// rs1_val==3689348814741910322 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x100000000, x4, 1992, x7)

inst_524:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333332, 0x2, x4, 2000, x7)

inst_525:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x5555555555555554, x4, 2008, x7)

inst_526:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xaaaaaaaaaaaaaaa9, x4, 2016, x7)

inst_527:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x3333333333333332, 0x4, x4, 2024, x7)

inst_528:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333332, x4, 2032, x7)

inst_529:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x6666666666666665, x4, 2040, x7)
RVTEST_SIGBASE( x4,signature_x4_2)

inst_530:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xb504f332, x4, 0, x7)

inst_531:
// rs1_val==3689348814741910322 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xffffffff, x4, 8, x7)

inst_532:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x5555555555555556, x4, 16, x7)

inst_533:
// rs1_val==3689348814741910322 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xaaaaaaaaaaaaaaab, x4, 24, x7)

inst_534:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x3333333333333332, 0x6, x4, 32, x7)

inst_535:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x3333333333333334, x4, 40, x7)

inst_536:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x6666666666666667, x4, 48, x7)

inst_537:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xb504f334, x4, 56, x7)

inst_538:
// rs1_val==3689348814741910322 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333332, 0x1, x4, 64, x7)

inst_539:
// rs1_val==3689348814741910322 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333332, 0x100000001, x4, 72, x7)

inst_540:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x6666666666666665, 0x3, x4, 80, x7)

inst_541:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x11111110, 0x6666666666666665, 0x5555555555555555, x4, 88, x7)

inst_542:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0xaaaaaaaaaaaaaaaa, x4, 96, x7)

inst_543:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x6666666666666665, 0x5, x4, 104, x7)

inst_544:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x33333332, 0x6666666666666665, 0x3333333333333333, x4, 112, x7)

inst_545:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x6666666666666666, x4, 120, x7)

inst_546:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0xb504f333, x4, 128, x7)

inst_547:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x0, x4, 136, x7)

inst_548:
// rs1_val==7378697629483820645 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x100000000, x4, 144, x7)

inst_549:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666665, 0x2, x4, 152, x7)

inst_550:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x11111111, 0x6666666666666665, 0x5555555555555554, x4, 160, x7)

inst_551:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0xaaaaaaaaaaaaaaa9, x4, 168, x7)

inst_552:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666665, 0x4, x4, 176, x7)

inst_553:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666665, 0x3333333333333332, x4, 184, x7)

inst_554:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666665, x4, 192, x7)

inst_555:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0xb504f332, x4, 200, x7)

inst_556:
// rs1_val==7378697629483820645 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0xffffffff, x4, 208, x7)

inst_557:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x1111110f, 0x6666666666666665, 0x5555555555555556, x4, 216, x7)

inst_558:
// rs1_val==7378697629483820645 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0xaaaaaaaaaaaaaaab, x4, 224, x7)

inst_559:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0x6666666666666665, 0x6, x4, 232, x7)

inst_560:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333331, 0x6666666666666665, 0x3333333333333334, x4, 240, x7)

inst_561:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x6666666666666667, x4, 248, x7)

inst_562:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0xb504f334, x4, 256, x7)

inst_563:
// rs1_val==7378697629483820645 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666665, 0x1, x4, 264, x7)

inst_564:
// rs1_val==7378697629483820645 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666665, 0x100000001, x4, 272, x7)

inst_565:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xb504f332, 0x3, x4, 280, x7)

inst_566:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4888, 0xb504f332, 0x5555555555555555, x4, 288, x7)

inst_567:
// rs1_val==3037000498 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4888, 0xb504f332, 0xaaaaaaaaaaaaaaaa, x4, 296, x7)

inst_568:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xb504f332, 0x5, x4, 304, x7)

inst_569:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b5999, 0xb504f332, 0x3333333333333333, x4, 312, x7)

inst_570:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8ccc, 0xb504f332, 0x6666666666666666, x4, 320, x7)

inst_571:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0xb504f333, x4, 328, x7)

inst_572:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x0, x4, 336, x7)

inst_573:
// rs1_val==3037000498 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x100000000, x4, 344, x7)

inst_574:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f332, 0x2, x4, 352, x7)

inst_575:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a488a, 0xb504f332, 0x5555555555555554, x4, 360, x7)

inst_576:
// rs1_val==3037000498 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4889, 0xb504f332, 0xaaaaaaaaaaaaaaa9, x4, 368, x7)

inst_577:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xb504f332, 0x4, x4, 376, x7)

inst_578:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b599c, 0xb504f332, 0x3333333333333332, x4, 384, x7)

inst_579:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8ccd, 0xb504f332, 0x6666666666666665, x4, 392, x7)

inst_580:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f332, 0xb504f332, x4, 400, x7)

inst_581:
// rs1_val==3037000498 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0xffffffff, x4, 408, x7)

inst_582:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4886, 0xb504f332, 0x5555555555555556, x4, 416, x7)

inst_583:
// rs1_val==3037000498 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4887, 0xb504f332, 0xaaaaaaaaaaaaaaab, x4, 424, x7)

inst_584:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0xb504f332, 0x6, x4, 432, x7)

inst_585:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b5996, 0xb504f332, 0x3333333333333334, x4, 440, x7)

inst_586:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8ccb, 0xb504f332, 0x6666666666666667, x4, 448, x7)

inst_587:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0xb504f334, x4, 456, x7)

inst_588:
// rs1_val==3037000498 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f332, 0x1, x4, 464, x7)

inst_589:
// rs1_val==3037000498 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f332, 0x100000001, x4, 472, x7)

inst_590:
// rs1_val==4294967295 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffff, 0x3, x4, 480, x7)

inst_591:
// rs1_val==4294967295 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffff, 0x5555555555555555, x4, 488, x7)

inst_592:
// rs1_val==4294967295 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0xffffffff, 0xaaaaaaaaaaaaaaaa, x4, 496, x7)

inst_593:
// rs1_val==4294967295 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffff, 0x5, x4, 504, x7)

inst_594:
// rs1_val==4294967295 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffff, 0x3333333333333333, x4, 512, x7)

inst_595:
// rs1_val==4294967295 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0xffffffff, 0x6666666666666666, x4, 520, x7)

inst_596:
// rs1_val==4294967295 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x4afb0ccc, 0xffffffff, 0xb504f333, x4, 528, x7)

inst_597:
// rs1_val==4294967295 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffffffff, 0x0, x4, 536, x7)

inst_598:
// rs1_val==4294967295 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, -0x1, 0xffffffff, 0x100000000, x4, 544, x7)

inst_599:
// rs1_val==4294967295 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xffffffff, 0x2, x4, 552, x7)

inst_600:
// rs1_val==4294967295 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xffffffff, 0x5555555555555554, x4, 560, x7)

inst_601:
// rs1_val==4294967295 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0xffffffff, 0xaaaaaaaaaaaaaaa9, x4, 568, x7)

inst_602:
// rs1_val==4294967295 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xffffffff, 0x4, x4, 576, x7)

inst_603:
// rs1_val==4294967295 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x5, 0xffffffff, 0x3333333333333332, x4, 584, x7)

inst_604:
// rs1_val==4294967295 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x33333335, 0xffffffff, 0x6666666666666665, x4, 592, x7)

inst_605:
// rs1_val==4294967295 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x4afb0ccd, 0xffffffff, 0xb504f332, x4, 600, x7)

inst_606:
// rs1_val==4294967295 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffff, 0xffffffff, x4, 608, x7)

inst_607:
// rs1_val==4294967295 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x55555553, 0xffffffff, 0x5555555555555556, x4, 616, x7)

inst_608:
// rs1_val==4294967295 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x55555554, 0xffffffff, 0xaaaaaaaaaaaaaaab, x4, 624, x7)

inst_609:
// rs1_val==4294967295 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xffffffff, 0x6, x4, 632, x7)

inst_610:
// rs1_val==4294967295 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x3333332f, 0xffffffff, 0x3333333333333334, x4, 640, x7)

inst_611:
// rs1_val==4294967295 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x33333331, 0xffffffff, 0x6666666666666667, x4, 648, x7)

inst_612:
// rs1_val==4294967295 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x4afb0ccb, 0xffffffff, 0xb504f334, x4, 656, x7)

inst_613:
// rs1_val==4294967295 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffff, 0x1, x4, 664, x7)

inst_614:
// rs1_val==4294967295 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xffffffff;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xffffffff, 0x100000001, x4, 672, x7)

inst_615:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x5555555555555556, 0x3, x4, 680, x7)

inst_616:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5555555555555556, 0x5555555555555555, x4, 688, x7)

inst_617:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xaaaaaaaaaaaaaaaa, x4, 696, x7)

inst_618:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x5555555555555556, 0x5, x4, 704, x7)

inst_619:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x22222223, 0x5555555555555556, 0x3333333333333333, x4, 712, x7)

inst_620:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x6666666666666666, x4, 720, x7)

inst_621:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xb504f333, x4, 728, x7)

inst_622:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x0, x4, 736, x7)

inst_623:
// rs1_val==6148914691236517206 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x100000000, x4, 744, x7)

inst_624:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555556, 0x2, x4, 752, x7)

inst_625:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x5555555555555556, 0x5555555555555554, x4, 760, x7)

inst_626:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xaaaaaaaaaaaaaaa9, x4, 768, x7)

inst_627:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x5555555555555556, 0x4, x4, 776, x7)

inst_628:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x22222224, 0x5555555555555556, 0x3333333333333332, x4, 784, x7)

inst_629:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x6666666666666665, x4, 792, x7)

inst_630:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xb504f332, x4, 800, x7)

inst_631:
// rs1_val==6148914691236517206 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xffffffff, x4, 808, x7)

inst_632:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555556, x4, 816, x7)

inst_633:
// rs1_val==6148914691236517206 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xaaaaaaaaaaaaaaab, x4, 824, x7)

inst_634:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x5555555555555556, 0x6, x4, 832, x7)

inst_635:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x22222222, 0x5555555555555556, 0x3333333333333334, x4, 840, x7)

inst_636:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x6666666666666667, x4, 848, x7)

inst_637:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0xb504f334, x4, 856, x7)

inst_638:
// rs1_val==6148914691236517206 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555556, 0x1, x4, 864, x7)

inst_639:
// rs1_val==6148914691236517206 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x5555555555555556, 0x100000001, x4, 872, x7)

inst_640:
// rs1_val==12297829382473034411 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x3, x4, 880, x7)

inst_641:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x5555555555555555, x4, 888, x7)

inst_642:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaaa, x4, 896, x7)

inst_643:
// rs1_val==12297829382473034411 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x5, x4, 904, x7)

inst_644:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x11111112, 0xaaaaaaaaaaaaaaab, 0x3333333333333333, x4, 912, x7)

inst_645:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x44444445, 0xaaaaaaaaaaaaaaab, 0x6666666666666666, x4, 920, x7)

inst_646:
// rs1_val==12297829382473034411 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, -0x55555555, 0xaaaaaaaaaaaaaaab, 0xb504f333, x4, 928, x7)

inst_647:
// rs1_val==12297829382473034411 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, -0x55555555, 0xaaaaaaaaaaaaaaab, 0x0, x4, 936, x7)

inst_648:
// rs1_val==12297829382473034411 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, -0x55555555, 0xaaaaaaaaaaaaaaab, 0x100000000, x4, 944, x7)

inst_649:
// rs1_val==12297829382473034411 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xaaaaaaaaaaaaaaab, 0x2, x4, 952, x7)

inst_650:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xaaaaaaaaaaaaaaab, 0x5555555555555554, x4, 960, x7)

inst_651:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaa9, x4, 968, x7)

inst_652:
// rs1_val==12297829382473034411 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xaaaaaaaaaaaaaaab, 0x4, x4, 976, x7)

inst_653:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x11111115, 0xaaaaaaaaaaaaaaab, 0x3333333333333332, x4, 984, x7)

inst_654:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x44444446, 0xaaaaaaaaaaaaaaab, 0x6666666666666665, x4, 992, x7)

inst_655:
// rs1_val==12297829382473034411 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, -0x55555555, 0xaaaaaaaaaaaaaaab, 0xb504f332, x4, 1000, x7)

inst_656:
// rs1_val==12297829382473034411 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x55555555, 0xaaaaaaaaaaaaaaab, 0xffffffff, x4, 1008, x7)

inst_657:
// rs1_val==12297829382473034411 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x55555555, 0xaaaaaaaaaaaaaaab, 0x5555555555555556, x4, 1016, x7)

inst_658:
// rs1_val==12297829382473034411 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0xaaaaaaaaaaaaaaab, x4, 1024, x7)

inst_659:
// rs1_val==12297829382473034411 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0xaaaaaaaaaaaaaaab, 0x6, x4, 1032, x7)

inst_660:
// rs1_val==12297829382473034411 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1111110f, 0xaaaaaaaaaaaaaaab, 0x3333333333333334, x4, 1040, x7)

inst_661:
// rs1_val==12297829382473034411 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x44444444, 0xaaaaaaaaaaaaaaab, 0x6666666666666667, x4, 1048, x7)

inst_662:
// rs1_val==12297829382473034411 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, -0x55555555, 0xaaaaaaaaaaaaaaab, 0xb504f334, x4, 1056, x7)

inst_663:
// rs1_val==12297829382473034411 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x1, x4, 1064, x7)

inst_664:
// rs1_val==12297829382473034411 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaab;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaab, 0x100000001, x4, 1072, x7)

inst_665:
// rs1_val==6 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6, 0x3, x4, 1080, x7)

inst_666:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x5555555555555555, x4, 1088, x7)

inst_667:
// rs1_val==6 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0xaaaaaaaaaaaaaaaa, x4, 1096, x7)

inst_668:
// rs1_val==6 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6, 0x5, x4, 1104, x7)

inst_669:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x3333333333333333, x4, 1112, x7)

inst_670:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x6666666666666666, x4, 1120, x7)

inst_671:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0xb504f333, x4, 1128, x7)

inst_672:
// rs1_val==6 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x0, x4, 1136, x7)

inst_673:
// rs1_val==6 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x100000000, x4, 1144, x7)

inst_674:
// rs1_val==6 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6, 0x2, x4, 1152, x7)

inst_675:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x5555555555555554, x4, 1160, x7)

inst_676:
// rs1_val==6 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0xaaaaaaaaaaaaaaa9, x4, 1168, x7)

inst_677:
// rs1_val==6 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x6, 0x4, x4, 1176, x7)

inst_678:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x3333333333333332, x4, 1184, x7)

inst_679:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x6666666666666665, x4, 1192, x7)

inst_680:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0xb504f332, x4, 1200, x7)

inst_681:
// rs1_val==6 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0xffffffff, x4, 1208, x7)

inst_682:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x5555555555555556, x4, 1216, x7)

inst_683:
// rs1_val==6 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0xaaaaaaaaaaaaaaab, x4, 1224, x7)

inst_684:
// rs1_val==6 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6, 0x6, x4, 1232, x7)

inst_685:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x3333333333333334, x4, 1240, x7)

inst_686:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0x6666666666666667, x4, 1248, x7)

inst_687:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x5555555555555555, x4, 1256, x7)

inst_688:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xaaaaaaaaaaaaaaaa, x4, 1264, x7)

inst_689:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333334, 0x5, x4, 1272, x7)

inst_690:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x3333333333333334, 0x3333333333333333, x4, 1280, x7)

inst_691:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x6666666666666666, x4, 1288, x7)

inst_692:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xb504f333, x4, 1296, x7)

inst_693:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x0, x4, 1304, x7)

inst_694:
// rs1_val==3689348814741910324 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x100000000, x4, 1312, x7)

inst_695:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333334, 0x2, x4, 1320, x7)

inst_696:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x5555555555555554, x4, 1328, x7)

inst_697:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xaaaaaaaaaaaaaaa9, x4, 1336, x7)

inst_698:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333334, 0x4, x4, 1344, x7)

inst_699:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x3333333333333334, 0x3333333333333332, x4, 1352, x7)

inst_700:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x6666666666666665, x4, 1360, x7)

inst_701:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xb504f332, x4, 1368, x7)

inst_702:
// rs1_val==3689348814741910324 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xffffffff, x4, 1376, x7)

inst_703:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x5555555555555556, x4, 1384, x7)

inst_704:
// rs1_val==3689348814741910324 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xaaaaaaaaaaaaaaab, x4, 1392, x7)

inst_705:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x3333333333333334, 0x6, x4, 1400, x7)

inst_706:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333334, x4, 1408, x7)

inst_707:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x6666666666666667, x4, 1416, x7)

inst_708:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xb504f334, x4, 1424, x7)

inst_709:
// rs1_val==3689348814741910324 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333334, 0x1, x4, 1432, x7)

inst_710:
// rs1_val==3689348814741910324 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x3333333333333334, 0x100000001, x4, 1440, x7)

inst_711:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666667, 0x3, x4, 1448, x7)

inst_712:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x11111112, 0x6666666666666667, 0x5555555555555555, x4, 1456, x7)

inst_713:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0xaaaaaaaaaaaaaaaa, x4, 1464, x7)

inst_714:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x4, 0x6666666666666667, 0x5, x4, 1472, x7)

inst_715:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666667, 0x3333333333333333, x4, 1480, x7)

inst_716:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666667, 0x6666666666666666, x4, 1488, x7)

inst_717:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0xb504f333, x4, 1496, x7)

inst_718:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0x0, x4, 1504, x7)

inst_719:
// rs1_val==7378697629483820647 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0x100000000, x4, 1512, x7)

inst_720:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666667, 0x2, x4, 1520, x7)

inst_721:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x11111113, 0x6666666666666667, 0x5555555555555554, x4, 1528, x7)

inst_722:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0xaaaaaaaaaaaaaaa9, x4, 1536, x7)

inst_723:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x6666666666666667, 0x4, x4, 1544, x7)

inst_724:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x3, 0x6666666666666667, 0x3333333333333332, x4, 1552, x7)

inst_725:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0x6666666666666667, 0x6666666666666665, x4, 1560, x7)

inst_726:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0xb504f332, x4, 1568, x7)

inst_727:
// rs1_val==7378697629483820647 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0xffffffff, x4, 1576, x7)

inst_728:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x11111111, 0x6666666666666667, 0x5555555555555556, x4, 1584, x7)

inst_729:
// rs1_val==7378697629483820647 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0xaaaaaaaaaaaaaaab, x4, 1592, x7)

inst_730:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x6666666666666667, 0x6, x4, 1600, x7)

inst_731:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x33333333, 0x6666666666666667, 0x3333333333333334, x4, 1608, x7)

inst_732:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666667, x4, 1616, x7)

inst_733:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0xb504f334, x4, 1624, x7)

inst_734:
// rs1_val==7378697629483820647 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666667, 0x1, x4, 1632, x7)

inst_735:
// rs1_val==7378697629483820647 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6666666666666667, 0x100000001, x4, 1640, x7)

inst_736:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0x3, x4, 1648, x7)

inst_737:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a488a, 0xb504f334, 0x5555555555555555, x4, 1656, x7)

inst_738:
// rs1_val==3037000500 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a488a, 0xb504f334, 0xaaaaaaaaaaaaaaaa, x4, 1664, x7)

inst_739:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0x5, x4, 1672, x7)

inst_740:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b599b, 0xb504f334, 0x3333333333333333, x4, 1680, x7)

inst_741:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8cce, 0xb504f334, 0x6666666666666666, x4, 1688, x7)

inst_742:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0xb504f334, 0xb504f333, x4, 1696, x7)

inst_743:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x0, x4, 1704, x7)

inst_744:
// rs1_val==3037000500 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x100000000, x4, 1712, x7)

inst_745:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0x2, x4, 1720, x7)

inst_746:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a488c, 0xb504f334, 0x5555555555555554, x4, 1728, x7)

inst_747:
// rs1_val==3037000500 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a488b, 0xb504f334, 0xaaaaaaaaaaaaaaa9, x4, 1736, x7)

inst_748:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0x4, x4, 1744, x7)

inst_749:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b599e, 0xb504f334, 0x3333333333333332, x4, 1752, x7)

inst_750:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8ccf, 0xb504f334, 0x6666666666666665, x4, 1760, x7)

inst_751:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x2, 0xb504f334, 0xb504f332, x4, 1768, x7)

inst_752:
// rs1_val==3037000500 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0xffffffff, x4, 1776, x7)

inst_753:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4888, 0xb504f334, 0x5555555555555556, x4, 1784, x7)

inst_754:
// rs1_val==3037000500 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0xa5a4889, 0xb504f334, 0xaaaaaaaaaaaaaaab, x4, 1792, x7)

inst_755:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0x6, x4, 1800, x7)

inst_756:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1b6b5998, 0xb504f334, 0x3333333333333334, x4, 1808, x7)

inst_757:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x4e9e8ccd, 0xb504f334, 0x6666666666666667, x4, 1816, x7)

inst_758:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0xb504f334, x4, 1824, x7)

inst_759:
// rs1_val==3037000500 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0x1, x4, 1832, x7)

inst_760:
// rs1_val==3037000500 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xb504f334, 0x100000001, x4, 1840, x7)

inst_761:
// rs1_val==1 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x3, x4, 1848, x7)

inst_762:
// rs1_val==1 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x5555555555555555, x4, 1856, x7)

inst_763:
// rs1_val==1 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaaa, x4, 1864, x7)

inst_764:
// rs1_val==1 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x5, x4, 1872, x7)

inst_765:
// rs1_val==1 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x3333333333333333, x4, 1880, x7)

inst_766:
// rs1_val==1 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x6666666666666666, x4, 1888, x7)

inst_767:
// rs1_val==1 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xb504f333, x4, 1896, x7)

inst_768:
// rs1_val==1 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x0, x4, 1904, x7)

inst_769:
// rs1_val==1 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x100000000, x4, 1912, x7)

inst_770:
// rs1_val==1 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x5555555555555554, x4, 1920, x7)

inst_771:
// rs1_val==1 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaa9, x4, 1928, x7)

inst_772:
// rs1_val==1 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x4, x4, 1936, x7)

inst_773:
// rs1_val==1 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x3333333333333332, x4, 1944, x7)

inst_774:
// rs1_val==1 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x6666666666666665, x4, 1952, x7)

inst_775:
// rs1_val==1 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xb504f332, x4, 1960, x7)

inst_776:
// rs1_val==1 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xffffffff, x4, 1968, x7)

inst_777:
// rs1_val==1 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x5555555555555556, x4, 1976, x7)

inst_778:
// rs1_val==1 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xaaaaaaaaaaaaaaab, x4, 1984, x7)

inst_779:
// rs1_val==1 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x6, x4, 1992, x7)

inst_780:
// rs1_val==1 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x3333333333333334, x4, 2000, x7)

inst_781:
// rs1_val==1 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0x6666666666666667, x4, 2008, x7)

inst_782:
// rs1_val==1 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x1, 0xb504f334, x4, 2016, x7)

inst_783:
// rs1_val==1 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x1, 0x1, x4, 2024, x7)

inst_784:
// rs1_val==1 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x1, 0x100000001, x4, 2032, x7)

inst_785:
// rs1_val==4294967297 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x3, x4, 2040, x7)
RVTEST_SIGBASE( x4,signature_x4_3)

inst_786:
// rs1_val==4294967297 and rs2_val==6148914691236517205, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555555
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x5555555555555555, x4, 0, x7)

inst_787:
// rs1_val==4294967297 and rs2_val==12297829382473034410, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0xaaaaaaaaaaaaaaaa, x4, 8, x7)

inst_788:
// rs1_val==4294967297 and rs2_val==5, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x5, x4, 16, x7)

inst_789:
// rs1_val==4294967297 and rs2_val==3689348814741910323, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333333
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x3333333333333333, x4, 24, x7)

inst_790:
// rs1_val==4294967297 and rs2_val==7378697629483820646, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666666
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x6666666666666666, x4, 32, x7)

inst_791:
// rs1_val==4294967297 and rs2_val==3037000499, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f333
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0xb504f333, x4, 40, x7)

inst_792:
// rs1_val==4294967297 and rs2_val==0, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x0
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x0, x4, 48, x7)

inst_793:
// rs1_val==4294967297 and rs2_val==4294967296, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x100000000
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x100000000, x4, 56, x7)

inst_794:
// rs1_val==4294967297 and rs2_val==2, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x2
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x2, x4, 64, x7)

inst_795:
// rs1_val==4294967297 and rs2_val==6148914691236517204, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555554
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x5555555555555554, x4, 72, x7)

inst_796:
// rs1_val==4294967297 and rs2_val==12297829382473034409, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaa9
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0xaaaaaaaaaaaaaaa9, x4, 80, x7)

inst_797:
// rs1_val==4294967297 and rs2_val==4, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x4
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x4, x4, 88, x7)

inst_798:
// rs1_val==4294967297 and rs2_val==3689348814741910322, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333332
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x3333333333333332, x4, 96, x7)

inst_799:
// rs1_val==4294967297 and rs2_val==7378697629483820645, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666665
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x6666666666666665, x4, 104, x7)

inst_800:
// rs1_val==4294967297 and rs2_val==3037000498, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f332
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0xb504f332, x4, 112, x7)

inst_801:
// rs1_val==4294967297 and rs2_val==4294967295, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0xffffffff, x4, 120, x7)

inst_802:
// rs1_val==4294967297 and rs2_val==6148914691236517206, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x5555555555555556
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x5555555555555556, x4, 128, x7)

inst_803:
// rs1_val==4294967297 and rs2_val==12297829382473034411, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xaaaaaaaaaaaaaaab
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0xaaaaaaaaaaaaaaab, x4, 136, x7)

inst_804:
// rs1_val==4294967297 and rs2_val==6, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x6, x4, 144, x7)

inst_805:
// rs1_val==4294967297 and rs2_val==3689348814741910324, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x3333333333333334
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x3333333333333334, x4, 152, x7)

inst_806:
// rs1_val==4294967297 and rs2_val==7378697629483820647, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x6666666666666667
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0x6666666666666667, x4, 160, x7)

inst_807:
// rs1_val==4294967297 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x100000001, 0xb504f334, x4, 168, x7)

inst_808:
// rs1_val==4294967297 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000001, 0x1, x4, 176, x7)

inst_809:
// rs1_val==4294967297 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x100000001;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x100000001, 0x100000001, x4, 184, x7)

inst_810:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(remuw, x12, x10, x11, 0x6, 0x6, 0xb504f334, x4, 192, x7)

inst_811:
// rs1_val==6 and rs2_val==1, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x1
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6, 0x1, x4, 200, x7)

inst_812:
// rs1_val==6 and rs2_val==4294967297, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x100000001
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x6, 0x100000001, x4, 208, x7)

inst_813:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(remuw, x12, x10, x11, 0x1, 0x3333333333333334, 0x3, x4, 216, x7)

inst_814:
// rs1_val == rs2_val and rs1_val > 0 and rs2_val > 0, rs2_val == 12297829382473034410, rs1_val == 12297829382473034410, rs1_val==12297829382473034410 and rs2_val==12297829382473034410
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xaaaaaaaaaaaaaaaa;  op2val:0xaaaaaaaaaaaaaaaa
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa, x4, 224, x7)

inst_815:
// rs2_val == (2**(xlen)-1), rs1_val == 18445618173802708991
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0xfffbffffffffffff;  op2val:0xffffffffffffffff
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0xfffbffffffffffff, 0xffffffffffffffff, x4, 232, x7)

inst_816:
// rs2_val == 128, rs1_val == 6148914691236517205
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x80
TEST_RR_OP(remuw, x12, x10, x11, 0x55, 0x5555555555555555, 0x80, x4, 240, x7)

inst_817:
// rs2_val == 32768, rs1_val == 562949953421312
// opcode: remuw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000;  op2val:0x8000
TEST_RR_OP(remuw, x12, x10, x11, 0x0, 0x2000000000000, 0x8000, x4, 248, x7)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x1_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x1_1:
    .fill 18*(XLEN/32),4,0xdeadbeef


signature_x4_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_2:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x4_3:
    .fill 32*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
