
// -----------
// This file was generated by riscv_ctg (https://gitlab.com/incoresemi/riscv-compliance/riscv_ctg)
// version   : 0.4.1
// timestamp : Thu Dec 17 03:25:43 2020 GMT
// usage     : riscv_ctg \
//                  -- cgf ('/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/dataset.cgf', '/scratch/git-repo/incoresemi/riscv-compliance/riscv_ctg/sample_cgfs/rv64im.cgf') \
//                  -- xlen 64 \
// -----------
//
// -----------
// Copyright (c) 2020. RISC-V International. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause
// -----------
//
// This assembly file tests the remw instruction of the RISC-V M extension for the remw covergroup.
// 
#include "model_test.h"
#include "arch_test.h"
RVTEST_ISA("RV64IM")

.section .text.init
.globl rvtest_entry_point
rvtest_entry_point:
RVMODEL_BOOT
RVTEST_CODE_BEGIN

#ifdef TEST_CASE_1

RVTEST_CASE(0,"//check ISA:=regex(.*64.*);check ISA:=regex(.*RV64.*I.*M.*);def TEST_CASE_1=True;",remw)

RVTEST_SIGBASE( x10,signature_x10_1)

inst_0:
// rs1 == rs2 == rd, rs1==x22, rs2==x22, rd==x22, rs1_val > 0 and rs2_val > 0, rs1_val == 8, rs1_val != rs2_val
// opcode: remw ; op1:x22; op2:x22; dest:x22; op1val:0x8;  op2val:0x8
TEST_RR_OP(remw, x22, x22, x22, 0x0, 0x8, 0x8, x10, 0, x23)

inst_1:
// rs2 == rd != rs1, rs1==x25, rs2==x30, rd==x30, rs1_val > 0 and rs2_val < 0, rs2_val == -4398046511105
// opcode: remw ; op1:x25; op2:x30; dest:x30; op1val:0x6666666666666667;  op2val:-0x40000000001
TEST_RR_OP(remw, x30, x25, x30, 0x0, 0x6666666666666667, -0x40000000001, x10, 8, x23)

inst_2:
// rs1 == rs2 != rd, rs1==x8, rs2==x8, rd==x12, rs1_val < 0 and rs2_val < 0, rs1_val == -562949953421313
// opcode: remw ; op1:x8; op2:x8; dest:x12; op1val:-0x2000000000001;  op2val:-0x2000000000001
TEST_RR_OP(remw, x12, x8, x8, 0x0, -0x2000000000001, -0x2000000000001, x10, 16, x23)

inst_3:
// rs1 != rs2  and rs1 != rd and rs2 != rd, rs1==x1, rs2==x19, rd==x17, rs1_val < 0 and rs2_val > 0, rs1_val==-3037000498 and rs2_val==4, rs2_val == 4
// opcode: remw ; op1:x1; op2:x19; dest:x17; op1val:-0xb504f332;  op2val:0x4
TEST_RR_OP(remw, x17, x1, x19, 0x2, -0xb504f332, 0x4, x10, 24, x23)

inst_4:
// rs1 == rd != rs2, rs1==x9, rs2==x6, rd==x9, rs1_val == rs2_val, rs2_val == 562949953421312, rs1_val == 562949953421312
// opcode: remw ; op1:x9; op2:x6; dest:x9; op1val:0x2000000000000;  op2val:0x2000000000000
TEST_RR_OP(remw, x9, x9, x6, 0x0, 0x2000000000000, 0x2000000000000, x10, 32, x23)

inst_5:
// rs1==x3, rs2==x12, rd==x7, rs2_val == (-2**(xlen-1)), rs1_val == -4097, rs2_val == -9223372036854775808
// opcode: remw ; op1:x3; op2:x12; dest:x7; op1val:-0x1001;  op2val:-0x8000000000000000
TEST_RR_OP(remw, x7, x3, x12, -0x1001, -0x1001, -0x8000000000000000, x10, 40, x23)

inst_6:
// rs1==x11, rs2==x24, rd==x16, rs2_val == 0, rs1_val == 2251799813685248
// opcode: remw ; op1:x11; op2:x24; dest:x16; op1val:0x8000000000000;  op2val:0x0
TEST_RR_OP(remw, x16, x11, x24, 0x0, 0x8000000000000, 0x0, x10, 48, x23)

inst_7:
// rs1==x5, rs2==x29, rd==x6, rs2_val == (2**(xlen-1)-1), rs1_val == 4096, rs2_val == 9223372036854775807
// opcode: remw ; op1:x5; op2:x29; dest:x6; op1val:0x1000;  op2val:0x7fffffffffffffff
TEST_RR_OP(remw, x6, x5, x29, 0x0, 0x1000, 0x7fffffffffffffff, x10, 56, x23)

inst_8:
// rs1==x17, rs2==x4, rd==x26, rs2_val == 1, rs1_val == -288230376151711745
// opcode: remw ; op1:x17; op2:x4; dest:x26; op1val:-0x400000000000001;  op2val:0x1
TEST_RR_OP(remw, x26, x17, x4, 0x0, -0x400000000000001, 0x1, x10, 64, x23)

inst_9:
// rs1==x4, rs2==x20, rd==x21, rs1_val == (-2**(xlen-1)), rs1_val == -9223372036854775808
// opcode: remw ; op1:x4; op2:x20; dest:x21; op1val:-0x8000000000000000;  op2val:0x5
TEST_RR_OP(remw, x21, x4, x20, 0x0, -0x8000000000000000, 0x5, x10, 72, x23)

inst_10:
// rs1==x21, rs2==x13, rd==x19, rs1_val == 0, rs1_val==0 and rs2_val==-3037000498
// opcode: remw ; op1:x21; op2:x13; dest:x19; op1val:0x0;  op2val:-0xb504f332
TEST_RR_OP(remw, x19, x21, x13, 0x0, 0x0, -0xb504f332, x10, 80, x23)

inst_11:
// rs1==x15, rs2==x14, rd==x11, rs1_val == (2**(xlen-1)-1), rs1_val == 9223372036854775807, rs2_val == 288230376151711744
// opcode: remw ; op1:x15; op2:x14; dest:x11; op1val:0x7fffffffffffffff;  op2val:0x400000000000000
TEST_RR_OP(remw, x11, x15, x14, -0x1, 0x7fffffffffffffff, 0x400000000000000, x10, 88, x23)

inst_12:
// rs1==x0, rs2==x21, rd==x8, rs1_val == 1, rs2_val == 4398046511104
// opcode: remw ; op1:x0; op2:x21; dest:x8; op1val:0x0;  op2val:0x40000000000
TEST_RR_OP(remw, x8, x0, x21, 0x0, 0x0, 0x40000000000, x10, 96, x23)

inst_13:
// rs1==x6, rs2==x18, rd==x29, rs2_val == 2, rs1_val == -134217729
// opcode: remw ; op1:x6; op2:x18; dest:x29; op1val:-0x8000001;  op2val:0x2
TEST_RR_OP(remw, x29, x6, x18, -0x1, -0x8000001, 0x2, x10, 104, x23)

inst_14:
// rs1==x19, rs2==x1, rd==x18, rs2_val == 8, 
// opcode: remw ; op1:x19; op2:x1; dest:x18; op1val:0x0;  op2val:0x8
TEST_RR_OP(remw, x18, x19, x1, 0x0, 0x0, 0x8, x10, 112, x23)

inst_15:
// rs1==x2, rs2==x31, rd==x25, rs2_val == 16, rs1_val == 9007199254740992
// opcode: remw ; op1:x2; op2:x31; dest:x25; op1val:0x20000000000000;  op2val:0x10
TEST_RR_OP(remw, x25, x2, x31, 0x0, 0x20000000000000, 0x10, x10, 120, x23)

inst_16:
// rs1==x30, rs2==x26, rd==x23, rs2_val == 32, rs1_val == -9
// opcode: remw ; op1:x30; op2:x26; dest:x23; op1val:-0x9;  op2val:0x20
TEST_RR_OP(remw, x23, x30, x26, -0x9, -0x9, 0x20, x10, 128, x8)
RVTEST_SIGBASE( x6,signature_x6_0)

inst_17:
// rs1==x14, rs2==x27, rd==x3, rs2_val == 64, rs1_val == 64
// opcode: remw ; op1:x14; op2:x27; dest:x3; op1val:0x40;  op2val:0x40
TEST_RR_OP(remw, x3, x14, x27, 0x0, 0x40, 0x40, x6, 0, x8)

inst_18:
// rs1==x16, rs2==x5, rd==x20, rs2_val == 128, 
// opcode: remw ; op1:x16; op2:x5; dest:x20; op1val:0x3;  op2val:0x80
TEST_RR_OP(remw, x20, x16, x5, 0x3, 0x3, 0x80, x6, 8, x8)

inst_19:
// rs1==x27, rs2==x11, rd==x5, rs2_val == 256, rs1_val == 274877906944
// opcode: remw ; op1:x27; op2:x11; dest:x5; op1val:0x4000000000;  op2val:0x100
TEST_RR_OP(remw, x5, x27, x11, 0x0, 0x4000000000, 0x100, x6, 16, x8)

inst_20:
// rs1==x13, rs2==x7, rd==x1, rs2_val == 512, rs1_val == 4503599627370496
// opcode: remw ; op1:x13; op2:x7; dest:x1; op1val:0x10000000000000;  op2val:0x200
TEST_RR_OP(remw, x1, x13, x7, 0x0, 0x10000000000000, 0x200, x6, 24, x8)

inst_21:
// rs1==x20, rs2==x9, rd==x0, rs2_val == 1024, rs1_val == -281474976710657
// opcode: remw ; op1:x20; op2:x9; dest:x0; op1val:-0x1000000000001;  op2val:0x400
TEST_RR_OP(remw, x0, x20, x9, 0, -0x1000000000001, 0x400, x6, 32, x8)

inst_22:
// rs1==x23, rs2==x10, rd==x27, rs2_val == 2048, rs1_val == -257
// opcode: remw ; op1:x23; op2:x10; dest:x27; op1val:-0x101;  op2val:0x800
TEST_RR_OP(remw, x27, x23, x10, -0x101, -0x101, 0x800, x6, 40, x8)

inst_23:
// rs1==x29, rs2==x3, rd==x14, rs2_val == 4096, rs1_val == 4
// opcode: remw ; op1:x29; op2:x3; dest:x14; op1val:0x4;  op2val:0x1000
TEST_RR_OP(remw, x14, x29, x3, 0x4, 0x4, 0x1000, x6, 48, x8)

inst_24:
// rs1==x18, rs2==x17, rd==x31, rs2_val == 8192, rs1_val == -2251799813685249
// opcode: remw ; op1:x18; op2:x17; dest:x31; op1val:-0x8000000000001;  op2val:0x2000
TEST_RR_OP(remw, x31, x18, x17, -0x1, -0x8000000000001, 0x2000, x6, 56, x8)

inst_25:
// rs1==x7, rs2==x28, rd==x13, rs2_val == 16384, rs1_val == -129
// opcode: remw ; op1:x7; op2:x28; dest:x13; op1val:-0x81;  op2val:0x4000
TEST_RR_OP(remw, x13, x7, x28, -0x81, -0x81, 0x4000, x6, 64, x8)

inst_26:
// rs1==x12, rs2==x0, rd==x15, rs2_val == 32768, rs1_val == -536870913
// opcode: remw ; op1:x12; op2:x0; dest:x15; op1val:-0x20000001;  op2val:0x0
TEST_RR_OP(remw, x15, x12, x0, -0x20000001, -0x20000001, 0x0, x6, 72, x8)

inst_27:
// rs1==x24, rs2==x16, rd==x28, rs2_val == 65536, 
// opcode: remw ; op1:x24; op2:x16; dest:x28; op1val:0x5;  op2val:0x10000
TEST_RR_OP(remw, x28, x24, x16, 0x5, 0x5, 0x10000, x6, 80, x8)

inst_28:
// rs1==x31, rs2==x23, rd==x10, rs2_val == 131072, rs1_val == 2
// opcode: remw ; op1:x31; op2:x23; dest:x10; op1val:0x2;  op2val:0x20000
TEST_RR_OP(remw, x10, x31, x23, 0x2, 0x2, 0x20000, x6, 88, x8)

inst_29:
// rs1==x28, rs2==x2, rd==x24, rs2_val == 262144, rs1_val == -268435457
// opcode: remw ; op1:x28; op2:x2; dest:x24; op1val:-0x10000001;  op2val:0x40000
TEST_RR_OP(remw, x24, x28, x2, -0x1, -0x10000001, 0x40000, x6, 96, x8)

inst_30:
// rs1==x26, rs2==x25, rd==x4, rs2_val == 524288, 
// opcode: remw ; op1:x26; op2:x25; dest:x4; op1val:-0x10000001;  op2val:0x80000
TEST_RR_OP(remw, x4, x26, x25, -0x1, -0x10000001, 0x80000, x6, 104, x8)

inst_31:
// rs1==x10, rs2==x15, rd==x2, rs2_val == 1048576, rs1_val == 281474976710656
// opcode: remw ; op1:x10; op2:x15; dest:x2; op1val:0x1000000000000;  op2val:0x100000
TEST_RR_OP(remw, x2, x10, x15, 0x0, 0x1000000000000, 0x100000, x6, 112, x8)

inst_32:
// rs2_val == 2097152, rs1_val == 6148914691236517205
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x200000
TEST_RR_OP(remw, x12, x10, x11, 0x155555, 0x5555555555555555, 0x200000, x6, 120, x8)

inst_33:
// rs2_val == 4194304, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x9;  op2val:0x400000
TEST_RR_OP(remw, x12, x10, x11, -0x9, -0x9, 0x400000, x6, 128, x8)

inst_34:
// rs2_val == 8388608, rs1_val == -131073
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x20001;  op2val:0x800000
TEST_RR_OP(remw, x12, x10, x11, -0x20001, -0x20001, 0x800000, x6, 136, x8)

inst_35:
// rs2_val == 16777216, rs1_val == -524289
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:0x1000000
TEST_RR_OP(remw, x12, x10, x11, -0x80001, -0x80001, 0x1000000, x6, 144, x8)

inst_36:
// rs2_val == 33554432, rs1_val == -1025
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x401;  op2val:0x2000000
TEST_RR_OP(remw, x12, x10, x11, -0x401, -0x401, 0x2000000, x6, 152, x8)

inst_37:
// rs2_val == 67108864, rs1_val == 17179869184
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:0x4000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x400000000, 0x4000000, x6, 160, x8)

inst_38:
// rs2_val == 134217728, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x1000;  op2val:0x8000000
TEST_RR_OP(remw, x12, x10, x11, 0x1000, 0x1000, 0x8000000, x6, 168, x8)

inst_39:
// rs2_val == 268435456, rs1_val == 8796093022208
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000;  op2val:0x10000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x80000000000, 0x10000000, x6, 176, x8)

inst_40:
// rs2_val == 536870912, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x20000000
TEST_RR_OP(remw, x12, x10, x11, 0xafb0cce, -0xb504f332, 0x20000000, x6, 184, x8)

inst_41:
// rs2_val == 1073741824, rs1_val == 36028797018963968
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:0x40000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x80000000000000, 0x40000000, x6, 192, x8)

inst_42:
// rs2_val == 2147483648, rs1_val == -549755813889
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x80000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x8000000001, 0x80000000, x6, 200, x8)

inst_43:
// rs2_val == 4294967296, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:0x100000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x10000000000000, 0x100000000, x6, 208, x8)

inst_44:
// rs2_val == 8589934592, rs1_val == -262145
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x40001;  op2val:0x200000000
TEST_RR_OP(remw, x12, x10, x11, -0x40001, -0x40001, 0x200000000, x6, 216, x8)

inst_45:
// rs2_val == 17179869184, rs1_val == -8589934593
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000001;  op2val:0x400000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x200000001, 0x400000000, x6, 224, x8)

inst_46:
// rs2_val == 34359738368, rs1_val == 35184372088832
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000;  op2val:0x800000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x200000000000, 0x800000000, x6, 232, x8)

inst_47:
// rs2_val == 68719476736, rs1_val == -4503599627370497
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:0x1000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x10000000000001, 0x1000000000, x6, 240, x8)

inst_48:
// rs2_val == 137438953472, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000000;  op2val:0x2000000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x4000000000000000, 0x2000000000, x6, 248, x8)

inst_49:
// rs2_val == 274877906944, rs1_val == -137438953473
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000001;  op2val:0x4000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x2000000001, 0x4000000000, x6, 256, x8)

inst_50:
// rs2_val == 549755813888, rs1_val == 1099511627776
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000;  op2val:0x8000000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x10000000000, 0x8000000000, x6, 264, x8)

inst_51:
// rs2_val == 1099511627776, rs1_val == -6148914691236517206
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x10000000000
TEST_RR_OP(remw, x12, x10, x11, -0x55555556, -0x5555555555555556, 0x10000000000, x6, 272, x8)

inst_52:
// rs2_val == 2199023255552, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x20000000000
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x20000000000, x6, 280, x8)

inst_53:
// rs2_val == 8796093022208, rs1_val == 256
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x100;  op2val:0x80000000000
TEST_RR_OP(remw, x12, x10, x11, 0x100, 0x100, 0x80000000000, x6, 288, x8)

inst_54:
// rs2_val == 17592186044416, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x8000000001;  op2val:0x100000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x8000000001, 0x100000000000, x6, 296, x8)

inst_55:
// rs2_val == 35184372088832, rs1_val == -4398046511105
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000001;  op2val:0x200000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x40000000001, 0x200000000000, x6, 304, x8)

inst_56:
// rs2_val == 70368744177664, rs1_val == 1024
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x400;  op2val:0x400000000000
TEST_RR_OP(remw, x12, x10, x11, 0x400, 0x400, 0x400000000000, x6, 312, x8)

inst_57:
// rs2_val == 140737488355328, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x7fffffffffffffff;  op2val:0x800000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0x7fffffffffffffff, 0x800000000000, x6, 320, x8)

inst_58:
// rs2_val == 281474976710656, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x1000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x55555556, -0x5555555555555556, 0x1000000000000, x6, 328, x8)

inst_59:
// rs2_val == 1125899906842624, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x4000000000000
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x4000000000000, x6, 336, x8)

inst_60:
// rs2_val == 2251799813685248, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x9;  op2val:0x8000000000000
TEST_RR_OP(remw, x12, x10, x11, 0x9, 0x9, 0x8000000000000, x6, 344, x8)

inst_61:
// rs2_val == 4503599627370496, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x10000000000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x10000000000000, x6, 352, x8)

inst_62:
// rs2_val == 9007199254740992, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x6;  op2val:0x20000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x6, -0x6, 0x20000000000000, x6, 360, x8)

inst_63:
// rs2_val == 18014398509481984, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x40000000000000
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x40000000000000, x6, 368, x8)

inst_64:
// rs2_val == 36028797018963968, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x1;  op2val:0x80000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x1, 0x80000000000000, x6, 376, x8)

inst_65:
// rs2_val == 72057594037927936, rs1_val == -4611686018427387905
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000000001;  op2val:0x100000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x4000000000000001, 0x100000000000000, x6, 384, x8)

inst_66:
// rs2_val == 144115188075855872, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x200000000000000
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x200000000000000, x6, 392, x8)

inst_67:
// rs2_val == 576460752303423488, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000001;  op2val:0x800000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x1000000000001, 0x800000000000000, x6, 400, x8)

inst_68:
// rs2_val == 1152921504606846976, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x1000000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x1000000000000000, x6, 408, x8)

inst_69:
// rs2_val == 2305843009213693952, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x1001;  op2val:0x2000000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1001, -0x1001, 0x2000000000000000, x6, 416, x8)

inst_70:
// rs2_val == 4611686018427387904, rs1_val == -2049
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x801;  op2val:0x4000000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x801, -0x801, 0x4000000000000000, x6, 424, x8)

inst_71:
// rs2_val == -2, rs1_val == -33554433
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:-0x2
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x2000001, -0x2, x6, 432, x8)

inst_72:
// rs2_val == -3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:-0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x2000001, -0x3, x6, 440, x8)

inst_73:
// rs2_val == -5, rs1_val == 512
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x200;  op2val:-0x5
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x200, -0x5, x6, 448, x8)

inst_74:
// rs2_val == -9, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000000001;  op2val:-0x9
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x400000000000001, -0x9, x6, 456, x8)

inst_75:
// rs2_val == -17, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x80001;  op2val:-0x11
TEST_RR_OP(remw, x12, x10, x11, -0x9, -0x80001, -0x11, x6, 464, x8)

inst_76:
// rs2_val == -33, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x21
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, -0x21, x6, 472, x8)

inst_77:
// rs2_val == -65, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x41
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, -0x41, x6, 480, x8)

inst_78:
// rs2_val == -129, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x7;  op2val:-0x81
TEST_RR_OP(remw, x12, x10, x11, 0x7, 0x7, -0x81, x6, 488, x8)

inst_79:
// rs2_val == -257, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000000001;  op2val:-0x101
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x10000000000001, -0x101, x6, 496, x8)

inst_80:
// rs2_val == -513, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x201
TEST_RR_OP(remw, x12, x10, x11, 0x1fd, -0xb504f333, -0x201, x6, 504, x8)

inst_81:
// rs2_val == -1025, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000;  op2val:-0x401
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x400000000, -0x401, x6, 512, x8)

inst_82:
// rs2_val == -2049, rs1_val == -16777217
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000001;  op2val:-0x801
TEST_RR_OP(remw, x12, x10, x11, -0x5, -0x1000001, -0x801, x6, 520, x8)

inst_83:
// rs2_val == -4097, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4;  op2val:-0x1001
TEST_RR_OP(remw, x12, x10, x11, -0x4, -0x4, -0x1001, x6, 528, x8)

inst_84:
// rs2_val == -8193, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x2001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, -0x2001, x6, 536, x8)

inst_85:
// rs2_val == -16385, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x4001
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x5555555555555556, -0x4001, x6, 544, x8)

inst_86:
// rs2_val == -32769, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:-0x8001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x80000000000000, -0x8001, x6, 552, x8)

inst_87:
// rs2_val == -65537, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000001;  op2val:-0x10001
TEST_RR_OP(remw, x12, x10, x11, -0xfe02, -0x2000001, -0x10001, x6, 560, x8)

inst_88:
// rs2_val == -131073, rs1_val == -2097153
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x200001;  op2val:-0x20001
TEST_RR_OP(remw, x12, x10, x11, -0x1fff2, -0x200001, -0x20001, x6, 568, x8)

inst_89:
// rs2_val == -262145, rs1_val == 1073741824
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:-0x40001
TEST_RR_OP(remw, x12, x10, x11, 0x3f001, 0x40000000, -0x40001, x6, 576, x8)

inst_90:
// rs2_val == -524289, rs1_val == 2147483648
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000;  op2val:-0x80001
TEST_RR_OP(remw, x12, x10, x11, -0x7f001, 0x80000000, -0x80001, x6, 584, x8)

inst_91:
// rs2_val == -1048577, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x7;  op2val:-0x100001
TEST_RR_OP(remw, x12, x10, x11, -0x7, -0x7, -0x100001, x6, 592, x8)

inst_92:
// rs2_val == -2097153, rs1_val == 68719476736
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:-0x200001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x1000000000, -0x200001, x6, 600, x8)

inst_93:
// rs2_val == -4194305, rs1_val == 128
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x80;  op2val:-0x400001
TEST_RR_OP(remw, x12, x10, x11, 0x80, 0x80, -0x400001, x6, 608, x8)

inst_94:
// rs2_val == -8388609, rs1_val == -2305843009213693953
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000000001;  op2val:-0x800001
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x2000000000000001, -0x800001, x6, 616, x8)

inst_95:
// rs2_val == -16777217, rs1_val == 4611686018427387904
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000000;  op2val:-0x1000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x4000000000000000, -0x1000001, x6, 624, x8)

inst_96:
// rs2_val == -33554433, rs1_val == -1073741825
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000001;  op2val:-0x2000001
TEST_RR_OP(remw, x12, x10, x11, -0x1ffffe2, -0x40000001, -0x2000001, x6, 632, x8)

inst_97:
// rs2_val == -67108865, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x4000001
TEST_RR_OP(remw, x12, x10, x11, 0x2fb0cbc, -0xb504f332, -0x4000001, x6, 640, x8)

inst_98:
// rs2_val == -134217729, rs1_val == 33554432
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000;  op2val:-0x8000001
TEST_RR_OP(remw, x12, x10, x11, 0x2000000, 0x2000000, -0x8000001, x6, 648, x8)

inst_99:
// rs2_val == -268435457, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x10000001
TEST_RR_OP(remw, x12, x10, x11, -0x5555551, -0x5555555555555556, -0x10000001, x6, 656, x8)

inst_100:
// rs2_val == -536870913, rs1_val == -4294967297
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000001;  op2val:-0x20000001
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x100000001, -0x20000001, x6, 664, x8)

inst_101:
// rs2_val == -1073741825, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:-0x40000001
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x1, -0x40000001, x6, 672, x8)

inst_102:
// rs2_val == -2147483649, rs1_val == -8796093022209
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:-0x80000001
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x80000000001, -0x80000001, x6, 680, x8)

inst_103:
// rs2_val == -4294967297, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:-0x100000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x80000000001, -0x100000001, x6, 688, x8)

inst_104:
// rs2_val == -8589934593, rs1_val == 536870912
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000;  op2val:-0x200000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x20000000, -0x200000001, x6, 696, x8)

inst_105:
// rs2_val == -17179869185, rs1_val == 2048
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:-0x400000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x800, -0x400000001, x6, 704, x8)

inst_106:
// rs2_val == -34359738369, rs1_val == 8589934592
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000;  op2val:-0x800000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x200000000, -0x800000001, x6, 712, x8)

inst_107:
// rs2_val == -68719476737, rs1_val == 4294967296
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000;  op2val:-0x1000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x100000000, -0x1000000001, x6, 720, x8)

inst_108:
// rs2_val == -137438953473, rs1_val == -3
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x3;  op2val:-0x2000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x3, -0x2000000001, x6, 728, x8)

inst_109:
// rs2_val == -274877906945, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x4000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, -0x4000000001, x6, 736, x8)

inst_110:
// rs2_val == -549755813889, rs1_val == 8192
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2000;  op2val:-0x8000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x2000, -0x8000000001, x6, 744, x8)

inst_111:
// rs2_val == -1099511627777, rs1_val == 2305843009213693952
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000000000;  op2val:-0x10000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x2000000000000000, -0x10000000001, x6, 752, x8)

inst_112:
// rs2_val == -2199023255553, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x80000000000000;  op2val:-0x20000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x80000000000000, -0x20000000001, x6, 760, x8)

inst_113:
// rs2_val == -8796093022209, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x80000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666667, -0x80000000001, x6, 768, x8)

inst_114:
// rs2_val == -17592186044417, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x6;  op2val:-0x100000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x6, -0x100000000001, x6, 776, x8)

inst_115:
// rs2_val == -35184372088833, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x200000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555556, -0x200000000001, x6, 784, x8)

inst_116:
// rs2_val == -70368744177665, rs1_val == 144115188075855872
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x200000000000000;  op2val:-0x400000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x200000000000000, -0x400000000001, x6, 792, x8)

inst_117:
// rs2_val == -140737488355329, rs1_val == 262144
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x40000;  op2val:-0x800000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x40000, -0x800000000001, x6, 800, x8)

inst_118:
// rs2_val == -281474976710657, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000;  op2val:-0x1000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x1000000000, -0x1000000000001, x6, 808, x8)

inst_119:
// rs2_val == -562949953421313, rs1_val == 576460752303423488
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000000;  op2val:-0x2000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x800000000000000, -0x2000000000001, x6, 816, x8)

inst_120:
// rs2_val == -1125899906842625, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x4000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x2, -0x4000000000001, x6, 824, x8)

inst_121:
// rs2_val == -2251799813685249, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000000000;  op2val:-0x8000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x10000000000000, -0x8000000000001, x6, 832, x8)

inst_122:
// rs2_val == -4503599627370497, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000;  op2val:-0x10000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x40000000, -0x10000000000001, x6, 840, x8)

inst_123:
// rs2_val == -9007199254740993, rs1_val == 549755813888
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000;  op2val:-0x20000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x8000000000, -0x20000000000001, x6, 848, x8)

inst_124:
// rs2_val == -18014398509481985, rs1_val == -72057594037927937
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000000001;  op2val:-0x40000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x100000000000001, -0x40000000000001, x6, 856, x8)

inst_125:
// rs2_val == -36028797018963969, rs1_val == 524288
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x80000;  op2val:-0x80000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x80000, -0x80000000000001, x6, 864, x8)

inst_126:
// rs2_val == -72057594037927937, rs1_val == -18014398509481985
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x40000000000001;  op2val:-0x100000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x40000000000001, -0x100000000000001, x6, 872, x8)

inst_127:
// rs2_val == -144115188075855873, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x800;  op2val:-0x200000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x800, -0x200000000000001, x6, 880, x8)

inst_128:
// rs2_val == -288230376151711745, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x400000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555555, -0x400000000000001, x6, 888, x8)

inst_129:
// rs2_val == -576460752303423489, rs1_val == -16385
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4001;  op2val:-0x800000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x4001, -0x800000000000001, x6, 896, x8)

inst_130:
// rs2_val == -1152921504606846977, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000000000;  op2val:-0x1000000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x8000000000000, -0x1000000000000001, x6, 904, x8)

inst_131:
// rs2_val == -2305843009213693953, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4;  op2val:-0x2000000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x4, -0x2000000000000001, x6, 912, x8)

inst_132:
// rs2_val == -4611686018427387905, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x4000000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666665, -0x4000000000000001, x6, 920, x8)

inst_133:
// rs2_val == 6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000001;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x80000000001, 0x5555555555555555, x6, 928, x8)

inst_134:
// rs2_val == -6148914691236517206, rs1_val==4 and rs2_val==-6148914691236517206
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, -0x5555555555555556, x6, 936, x8)

inst_135:
// rs1_val == 16, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x10;  op2val:0x1000000
TEST_RR_OP(remw, x12, x10, x11, 0x10, 0x10, 0x1000000, x6, 944, x8)

inst_136:
// rs1_val == 32, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x20;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x20, 0x3, x6, 952, x8)

inst_137:
// rs1_val == 16384, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4000;  op2val:-0x2001
TEST_RR_OP(remw, x12, x10, x11, 0x1fff, 0x4000, -0x2001, x6, 960, x8)

inst_138:
// rs1_val == 32768, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x8000;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x8000, 0x8000, 0x0, x6, 968, x8)

inst_139:
// rs1_val == 65536, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x10000;  op2val:-0x200001
TEST_RR_OP(remw, x12, x10, x11, 0x10000, 0x10000, -0x200001, x6, 976, x8)

inst_140:
// rs1_val == 131072, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x20000;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x20000, 0x20000, 0x3333333333333332, x6, 984, x8)

inst_141:
// rs1_val == 1048576, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x100000;  op2val:-0x800001
TEST_RR_OP(remw, x12, x10, x11, 0x100000, 0x100000, -0x800001, x6, 992, x8)

inst_142:
// rs1_val == 2097152, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x200000;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x200000, 0x200000, 0x0, x6, 1000, x8)

inst_143:
// rs1_val == 4194304, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x400000;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x400000, 0x400000, 0xb504f332, x6, 1008, x8)

inst_144:
// rs1_val == 8388608, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x800000;  op2val:-0x800001
TEST_RR_OP(remw, x12, x10, x11, 0x800000, 0x800000, -0x800001, x6, 1016, x8)

inst_145:
// rs1_val == 16777216, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x1000000, 0x6, x6, 1024, x8)

inst_146:
// rs1_val == 67108864, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000;  op2val:0x20000000000
TEST_RR_OP(remw, x12, x10, x11, 0x4000000, 0x4000000, 0x20000000000, x6, 1032, x8)

inst_147:
// rs1_val == 134217728, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x8000000;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x8000000, 0x8000000, 0x0, x6, 1040, x8)

inst_148:
// rs1_val == 268435456, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x10000000;  op2val:-0x400000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x10000000, -0x400000000001, x6, 1048, x8)

inst_149:
// rs1_val == 34359738368, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000;  op2val:0x400
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x800000000, 0x400, x6, 1056, x8)

inst_150:
// rs1_val == 137438953472, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2000000000;  op2val:0x1
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x2000000000, 0x1, x6, 1064, x8)

inst_151:
// rs1_val == 2199023255552, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x20000000000;  op2val:-0x400000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x20000000000, -0x400000001, x6, 1072, x8)

inst_152:
// rs1_val == 4398046511104, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000;  op2val:-0x4000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x40000000000, -0x4000000001, x6, 1080, x8)

inst_153:
// rs1_val == 17592186044416, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000;  op2val:0x800
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x100000000000, 0x800, x6, 1088, x8)

inst_154:
// rs1_val == 70368744177664, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000;  op2val:0x10
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x400000000000, 0x10, x6, 1096, x8)

inst_155:
// rs1_val == 140737488355328, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x800000000000;  op2val:0x20000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x800000000000, 0x20000, x6, 1104, x8)

inst_156:
// rs1_val == 1125899906842624, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4000000000000;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x4000000000000, -0xb504f333, x6, 1112, x8)

inst_157:
// rs1_val == 18014398509481984, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x40000000000000;  op2val:-0xa
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x40000000000000, -0xa, x6, 1120, x8)

inst_158:
// rs1_val == 72057594037927936, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x100000000000000;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x100000000000000, 0x6666666666666666, x6, 1128, x8)

inst_159:
// rs1_val == 288230376151711744, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x400000000000000;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x400000000000000, 0x0, x6, 1136, x8)

inst_160:
// rs1_val == 1152921504606846976, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x1000000000000000;  op2val:0x10000000000
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x1000000000000000, 0x10000000000, x6, 1144, x8)

inst_161:
// rs1_val == -2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2;  op2val:-0x4000001
TEST_RR_OP(remw, x12, x10, x11, -0x2, -0x2, -0x4000001, x6, 1152, x8)

inst_162:
// rs1_val == -5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x5, -0x5, -0x5555555555555555, x6, 1160, x8)

inst_163:
// rs1_val == -17, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x11;  op2val:-0x1000000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x11, -0x1000000000000001, x6, 1168, x8)

inst_164:
// rs1_val == -33, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x21;  op2val:0x400000
TEST_RR_OP(remw, x12, x10, x11, -0x21, -0x21, 0x400000, x6, 1176, x8)

inst_165:
// rs1_val == -65, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x41;  op2val:-0x40001
TEST_RR_OP(remw, x12, x10, x11, -0x41, -0x41, -0x40001, x6, 1184, x8)

inst_166:
// rs1_val == -513, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x201;  op2val:0x8000
TEST_RR_OP(remw, x12, x10, x11, -0x201, -0x201, 0x8000, x6, 1192, x8)

inst_167:
// rs1_val == -8193, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2001;  op2val:0x40
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x2001, 0x40, x6, 1200, x8)

inst_168:
// rs1_val == -32769, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x8001;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, -0x4, -0x8001, 0x5, x6, 1208, x8)

inst_169:
// rs1_val == -65537, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x10001;  op2val:0x200000000000000
TEST_RR_OP(remw, x12, x10, x11, -0x10001, -0x10001, 0x200000000000000, x6, 1216, x8)

inst_170:
// rs1_val == -1048577, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x100001;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, -0x100001, -0x100001, 0x3333333333333332, x6, 1224, x8)

inst_171:
// rs1_val == -4194305, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x400001;  op2val:0x400000000000
TEST_RR_OP(remw, x12, x10, x11, -0x400001, -0x400001, 0x400000000000, x6, 1232, x8)

inst_172:
// rs1_val == -8388609, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x800001;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x800001, 0x4, x6, 1240, x8)

inst_173:
// rs1_val == -67108865, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000001;  op2val:-0x1000001
TEST_RR_OP(remw, x12, x10, x11, -0xfffffe, -0x4000001, -0x1000001, x6, 1248, x8)

inst_174:
// rs1_val == -2147483649, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000001;  op2val:-0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, -0x80000001, -0x2, x6, 1256, x8)

inst_175:
// rs1_val == -17179869185, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000001;  op2val:-0x800000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x400000001, -0x800000000001, x6, 1264, x8)

inst_176:
// rs1_val == -34359738369, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000001;  op2val:-0x1000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x800000001, -0x1000000000001, x6, 1272, x8)

inst_177:
// rs1_val == -68719476737, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000001;  op2val:0x9
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x1000000001, 0x9, x6, 1280, x8)

inst_178:
// rs1_val == -274877906945, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000001;  op2val:0x8
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x4000000001, 0x8, x6, 1288, x8)

inst_179:
// rs1_val == -1099511627777, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x10000000001;  op2val:-0x800000000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x10000000001, -0x800000000000001, x6, 1296, x8)

inst_180:
// rs1_val == -2199023255553, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000001;  op2val:-0x1000001
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x20000000001, -0x1000001, x6, 1304, x8)

inst_181:
// rs1_val == -17592186044417, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x100000000001;  op2val:-0xa
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x100000000001, -0xa, x6, 1312, x8)

inst_182:
// rs1_val == -35184372088833, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000001;  op2val:-0x400000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x200000000001, -0x400000000001, x6, 1320, x8)

inst_183:
// rs1_val == -70368744177665, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x400000000001;  op2val:-0x1
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x400000000001, -0x1, x6, 1328, x8)

inst_184:
// rs1_val == -140737488355329, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000001;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x800000000001, 0x5555555555555556, x6, 1336, x8)

inst_185:
// rs1_val == -1125899906842625, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x4000000000001;  op2val:0x1000000000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x4000000000001, 0x1000000000, x6, 1344, x8)

inst_186:
// rs1_val == -9007199254740993, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x20000000000001;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x20000000000001, -0xb504f332, x6, 1352, x8)

inst_187:
// rs1_val == -36028797018963969, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x80000000000001;  op2val:-0x80000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x80000000000001, -0x80000000001, x6, 1360, x8)

inst_188:
// rs1_val == -144115188075855873, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x200000000000001;  op2val:-0x801
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x200000000000001, -0x801, x6, 1368, x8)

inst_189:
// rs1_val == -576460752303423489, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x800000000000001;  op2val:0x20
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x800000000000001, 0x20, x6, 1376, x8)

inst_190:
// rs1_val == -1152921504606846977, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x1000000000000001;  op2val:-0x800000000001
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x1000000000000001, -0x800000000001, x6, 1384, x8)

inst_191:
// rs1_val==3 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3, 0x3, x6, 1392, x8)

inst_192:
// rs1_val==3 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x5555555555555555, x6, 1400, x8)

inst_193:
// rs1_val==3 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, -0x5555555555555556, x6, 1408, x8)

inst_194:
// rs1_val==3 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x5, x6, 1416, x8)

inst_195:
// rs1_val==3 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x3333333333333333, x6, 1424, x8)

inst_196:
// rs1_val==3 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x6666666666666666, x6, 1432, x8)

inst_197:
// rs1_val==3 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, -0xb504f333, x6, 1440, x8)

inst_198:
// rs1_val==3 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0xb504f333, x6, 1448, x8)

inst_199:
// rs1_val==3 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x3, 0x2, x6, 1456, x8)

inst_200:
// rs1_val==3 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x5555555555555554, x6, 1464, x8)

inst_201:
// rs1_val==3 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x0, x6, 1472, x8)

inst_202:
// rs1_val==3 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x4, x6, 1480, x8)

inst_203:
// rs1_val==3 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x3333333333333332, x6, 1488, x8)

inst_204:
// rs1_val==3 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x6666666666666665, x6, 1496, x8)

inst_205:
// rs1_val==3 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0xb504f332, x6, 1504, x8)

inst_206:
// rs1_val==3 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x5555555555555556, x6, 1512, x8)

inst_207:
// rs1_val==3 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, -0x5555555555555555, x6, 1520, x8)

inst_208:
// rs1_val==3 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x6, x6, 1528, x8)

inst_209:
// rs1_val==3 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x3333333333333334, x6, 1536, x8)

inst_210:
// rs1_val==3 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0x6666666666666667, x6, 1544, x8)

inst_211:
// rs1_val==3 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, -0xb504f332, x6, 1552, x8)

inst_212:
// rs1_val==3 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3, 0xb504f334, x6, 1560, x8)

inst_213:
// rs1_val==6148914691236517205 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555555, 0x3, x6, 1568, x8)

inst_214:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555555, 0x5555555555555555, x6, 1576, x8)

inst_215:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x55555555, 0x5555555555555555, -0x5555555555555556, x6, 1584, x8)

inst_216:
// rs1_val==6148914691236517205 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555555, 0x5, x6, 1592, x8)

inst_217:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x22222222, 0x5555555555555555, 0x3333333333333333, x6, 1600, x8)

inst_218:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x6666666666666666, x6, 1608, x8)

inst_219:
// rs1_val==6148914691236517205 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4888, 0x5555555555555555, -0xb504f333, x6, 1616, x8)

inst_220:
// rs1_val==6148914691236517205 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4888, 0x5555555555555555, 0xb504f333, x6, 1624, x8)

inst_221:
// rs1_val==6148914691236517205 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555555, 0x2, x6, 1632, x8)

inst_222:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555555, 0x5555555555555554, x6, 1640, x8)

inst_223:
// rs1_val==6148914691236517205 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x0, x6, 1648, x8)

inst_224:
// rs1_val==6148914691236517205 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555555, 0x4, x6, 1656, x8)

inst_225:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x22222223, 0x5555555555555555, 0x3333333333333332, x6, 1664, x8)

inst_226:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x6666666666666665, x6, 1672, x8)

inst_227:
// rs1_val==6148914691236517205 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4887, 0x5555555555555555, 0xb504f332, x6, 1680, x8)

inst_228:
// rs1_val==6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x5555555555555556, x6, 1688, x8)

inst_229:
// rs1_val==6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555555, -0x5555555555555555, x6, 1696, x8)

inst_230:
// rs1_val==6148914691236517205 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555555, 0x6, x6, 1704, x8)

inst_231:
// rs1_val==6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x22222221, 0x5555555555555555, 0x3333333333333334, x6, 1712, x8)

inst_232:
// rs1_val==6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x55555555, 0x5555555555555555, 0x6666666666666667, x6, 1720, x8)

inst_233:
// rs1_val==6148914691236517205 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4887, 0x5555555555555555, -0xb504f332, x6, 1728, x8)

inst_234:
// rs1_val==6148914691236517205 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4889, 0x5555555555555555, 0xb504f334, x6, 1736, x8)

inst_235:
// rs1_val==-6148914691236517206 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, -0x2, -0x5555555555555556, 0x3, x6, 1744, x8)

inst_236:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555556, 0x5555555555555555, x6, 1752, x8)

inst_237:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x5555555555555556, -0x5555555555555556, x6, 1760, x8)

inst_238:
// rs1_val==-6148914691236517206 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555556, 0x5, x6, 1768, x8)

inst_239:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, -0x22222223, -0x5555555555555556, 0x3333333333333333, x6, 1776, x8)

inst_240:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, -0x55555556, -0x5555555555555556, 0x6666666666666666, x6, 1784, x8)

inst_241:
// rs1_val==-6148914691236517206 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4889, -0x5555555555555556, -0xb504f333, x6, 1792, x8)

inst_242:
// rs1_val==-6148914691236517206 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4889, -0x5555555555555556, 0xb504f333, x6, 1800, x8)

inst_243:
// rs1_val==-6148914691236517206 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x5555555555555556, 0x2, x6, 1808, x8)

inst_244:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, -0x2, -0x5555555555555556, 0x5555555555555554, x6, 1816, x8)

inst_245:
// rs1_val==-6148914691236517206 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, -0x55555556, -0x5555555555555556, 0x0, x6, 1824, x8)

inst_246:
// rs1_val==-6148914691236517206 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, -0x2, -0x5555555555555556, 0x4, x6, 1832, x8)

inst_247:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, -0x22222224, -0x5555555555555556, 0x3333333333333332, x6, 1840, x8)

inst_248:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, -0x55555556, -0x5555555555555556, 0x6666666666666665, x6, 1848, x8)

inst_249:
// rs1_val==-6148914691236517206 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4888, -0x5555555555555556, 0xb504f332, x6, 1856, x8)

inst_250:
// rs1_val==-6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x5555555555555556, 0x5555555555555556, x6, 1864, x8)

inst_251:
// rs1_val==-6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555556, -0x5555555555555555, x6, 1872, x8)

inst_252:
// rs1_val==-6148914691236517206 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, -0x2, -0x5555555555555556, 0x6, x6, 1880, x8)

inst_253:
// rs1_val==-6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, -0x22222222, -0x5555555555555556, 0x3333333333333334, x6, 1888, x8)

inst_254:
// rs1_val==-6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, -0x55555556, -0x5555555555555556, 0x6666666666666667, x6, 1896, x8)

inst_255:
// rs1_val==-6148914691236517206 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4888, -0x5555555555555556, -0xb504f332, x6, 1904, x8)

inst_256:
// rs1_val==-6148914691236517206 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, -0xa5a488a, -0x5555555555555556, 0xb504f334, x6, 1912, x8)

inst_257:
// rs1_val==5 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x5, 0x3, x6, 1920, x8)

inst_258:
// rs1_val==5 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x5555555555555555, x6, 1928, x8)

inst_259:
// rs1_val==5 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, -0x5555555555555556, x6, 1936, x8)

inst_260:
// rs1_val==5 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5, 0x5, x6, 1944, x8)

inst_261:
// rs1_val==5 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x3333333333333333, x6, 1952, x8)

inst_262:
// rs1_val==5 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x6666666666666666, x6, 1960, x8)

inst_263:
// rs1_val==5 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, -0xb504f333, x6, 1968, x8)

inst_264:
// rs1_val==5 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0xb504f333, x6, 1976, x8)

inst_265:
// rs1_val==5 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5, 0x2, x6, 1984, x8)

inst_266:
// rs1_val==5 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x5555555555555554, x6, 1992, x8)

inst_267:
// rs1_val==5 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x0, x6, 2000, x8)

inst_268:
// rs1_val==5 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5, 0x4, x6, 2008, x8)

inst_269:
// rs1_val==5 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x3333333333333332, x6, 2016, x8)

inst_270:
// rs1_val==5 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x6666666666666665, x6, 2024, x8)

inst_271:
// rs1_val==5 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0xb504f332, x6, 2032, x8)

inst_272:
// rs1_val==5 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x5555555555555556, x6, 2040, x8)
RVTEST_SIGBASE( x6,signature_x6_1)

inst_273:
// rs1_val==5 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, -0x5555555555555555, x6, 0, x8)

inst_274:
// rs1_val==5 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x6, x6, 8, x8)

inst_275:
// rs1_val==5 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x3333333333333334, x6, 16, x8)

inst_276:
// rs1_val==5 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0x6666666666666667, x6, 24, x8)

inst_277:
// rs1_val==5 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, -0xb504f332, x6, 32, x8)

inst_278:
// rs1_val==5 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x5, 0xb504f334, x6, 40, x8)

inst_279:
// rs1_val==3689348814741910323 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333333, 0x3, x6, 48, x8)

inst_280:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x5555555555555555, x6, 56, x8)

inst_281:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, -0x5555555555555556, x6, 64, x8)

inst_282:
// rs1_val==3689348814741910323 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x3333333333333333, 0x5, x6, 72, x8)

inst_283:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333333, 0x3333333333333333, x6, 80, x8)

inst_284:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x6666666666666666, x6, 88, x8)

inst_285:
// rs1_val==3689348814741910323 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, -0xb504f333, x6, 96, x8)

inst_286:
// rs1_val==3689348814741910323 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xb504f333, x6, 104, x8)

inst_287:
// rs1_val==3689348814741910323 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x3333333333333333, 0x2, x6, 112, x8)

inst_288:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x5555555555555554, x6, 120, x8)

inst_289:
// rs1_val==3689348814741910323 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x0, x6, 128, x8)

inst_290:
// rs1_val==3689348814741910323 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3333333333333333, 0x4, x6, 136, x8)

inst_291:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x3333333333333333, 0x3333333333333332, x6, 144, x8)

inst_292:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x6666666666666665, x6, 152, x8)

inst_293:
// rs1_val==3689348814741910323 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xb504f332, x6, 160, x8)

inst_294:
// rs1_val==3689348814741910323 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x5555555555555556, x6, 168, x8)

inst_295:
// rs1_val==3689348814741910323 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, -0x5555555555555555, x6, 176, x8)

inst_296:
// rs1_val==3689348814741910323 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3333333333333333, 0x6, x6, 184, x8)

inst_297:
// rs1_val==3689348814741910323 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x3333333333333334, x6, 192, x8)

inst_298:
// rs1_val==3689348814741910323 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0x6666666666666667, x6, 200, x8)

inst_299:
// rs1_val==3689348814741910323 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, -0xb504f332, x6, 208, x8)

inst_300:
// rs1_val==3689348814741910323 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333333;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x3333333333333333, 0xb504f334, x6, 216, x8)

inst_301:
// rs1_val==7378697629483820646 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666666, 0x3, x6, 224, x8)

inst_302:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x11111111, 0x6666666666666666, 0x5555555555555555, x6, 232, x8)

inst_303:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x11111110, 0x6666666666666666, -0x5555555555555556, x6, 240, x8)

inst_304:
// rs1_val==7378697629483820646 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x6666666666666666, 0x5, x6, 248, x8)

inst_305:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666666, 0x3333333333333333, x6, 256, x8)

inst_306:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666666, 0x6666666666666666, x6, 264, x8)

inst_307:
// rs1_val==7378697629483820646 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5999, 0x6666666666666666, -0xb504f333, x6, 272, x8)

inst_308:
// rs1_val==7378697629483820646 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5999, 0x6666666666666666, 0xb504f333, x6, 280, x8)

inst_309:
// rs1_val==7378697629483820646 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666666, 0x2, x6, 288, x8)

inst_310:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x11111112, 0x6666666666666666, 0x5555555555555554, x6, 296, x8)

inst_311:
// rs1_val==7378697629483820646 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0x0, x6, 304, x8)

inst_312:
// rs1_val==7378697629483820646 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x6666666666666666, 0x4, x6, 312, x8)

inst_313:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x6666666666666666, 0x3333333333333332, x6, 320, x8)

inst_314:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666666, 0x6666666666666665, x6, 328, x8)

inst_315:
// rs1_val==7378697629483820646 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5998, 0x6666666666666666, 0xb504f332, x6, 336, x8)

inst_316:
// rs1_val==7378697629483820646 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x11111110, 0x6666666666666666, 0x5555555555555556, x6, 344, x8)

inst_317:
// rs1_val==7378697629483820646 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x11111111, 0x6666666666666666, -0x5555555555555555, x6, 352, x8)

inst_318:
// rs1_val==7378697629483820646 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666666, 0x6, x6, 360, x8)

inst_319:
// rs1_val==7378697629483820646 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x6666666666666666, 0x3333333333333334, x6, 368, x8)

inst_320:
// rs1_val==7378697629483820646 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x66666666, 0x6666666666666666, 0x6666666666666667, x6, 376, x8)

inst_321:
// rs1_val==7378697629483820646 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5998, 0x6666666666666666, -0xb504f332, x6, 384, x8)

inst_322:
// rs1_val==7378697629483820646 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666666;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b599a, 0x6666666666666666, 0xb504f334, x6, 392, x8)

inst_323:
// rs1_val==-3037000499 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x2, -0xb504f333, 0x3, x6, 400, x8)

inst_324:
// rs1_val==-3037000499 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x5555555555555555, x6, 408, x8)

inst_325:
// rs1_val==-3037000499 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, -0x5555555555555556, x6, 416, x8)

inst_326:
// rs1_val==-3037000499 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x2, -0xb504f333, 0x5, x6, 424, x8)

inst_327:
// rs1_val==-3037000499 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x17c7d99a, -0xb504f333, 0x3333333333333333, x6, 432, x8)

inst_328:
// rs1_val==-3037000499 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x6666666666666666, x6, 440, x8)

inst_329:
// rs1_val==-3037000499 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0xb504f333, -0xb504f333, x6, 448, x8)

inst_330:
// rs1_val==-3037000499 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0xb504f333, 0xb504f333, x6, 456, x8)

inst_331:
// rs1_val==-3037000499 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, -0xb504f333, 0x2, x6, 464, x8)

inst_332:
// rs1_val==-3037000499 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x5555555555555554, x6, 472, x8)

inst_333:
// rs1_val==-3037000499 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x0, x6, 480, x8)

inst_334:
// rs1_val==-3037000499 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x1, -0xb504f333, 0x4, x6, 488, x8)

inst_335:
// rs1_val==-3037000499 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x17c7d99b, -0xb504f333, 0x3333333333333332, x6, 496, x8)

inst_336:
// rs1_val==-3037000499 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x6666666666666665, x6, 504, x8)

inst_337:
// rs1_val==-3037000499 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0xb504f332, x6, 512, x8)

inst_338:
// rs1_val==-3037000499 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x5555555555555556, x6, 520, x8)

inst_339:
// rs1_val==-3037000499 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, -0x5555555555555555, x6, 528, x8)

inst_340:
// rs1_val==-3037000499 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x5, -0xb504f333, 0x6, x6, 536, x8)

inst_341:
// rs1_val==-3037000499 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x17c7d999, -0xb504f333, 0x3333333333333334, x6, 544, x8)

inst_342:
// rs1_val==-3037000499 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, 0x6666666666666667, x6, 552, x8)

inst_343:
// rs1_val==-3037000499 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0ccd, -0xb504f333, -0xb504f332, x6, 560, x8)

inst_344:
// rs1_val==-3037000499 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f333;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x1, -0xb504f333, 0xb504f334, x6, 568, x8)

inst_345:
// rs1_val==3037000499 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, -0x2, 0xb504f333, 0x3, x6, 576, x8)

inst_346:
// rs1_val==3037000499 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x5555555555555555, x6, 584, x8)

inst_347:
// rs1_val==3037000499 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, -0x5555555555555556, x6, 592, x8)

inst_348:
// rs1_val==3037000499 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, -0x2, 0xb504f333, 0x5, x6, 600, x8)

inst_349:
// rs1_val==3037000499 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d99a, 0xb504f333, 0x3333333333333333, x6, 608, x8)

inst_350:
// rs1_val==3037000499 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x6666666666666666, x6, 616, x8)

inst_351:
// rs1_val==3037000499 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f333, -0xb504f333, x6, 624, x8)

inst_352:
// rs1_val==3037000499 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f333, 0xb504f333, x6, 632, x8)

inst_353:
// rs1_val==3037000499 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0xb504f333, 0x2, x6, 640, x8)

inst_354:
// rs1_val==3037000499 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x5555555555555554, x6, 648, x8)

inst_355:
// rs1_val==3037000499 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x0, x6, 656, x8)

inst_356:
// rs1_val==3037000499 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0xb504f333, 0x4, x6, 664, x8)

inst_357:
// rs1_val==3037000499 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d99b, 0xb504f333, 0x3333333333333332, x6, 672, x8)

inst_358:
// rs1_val==3037000499 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x6666666666666665, x6, 680, x8)

inst_359:
// rs1_val==3037000499 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0xb504f332, x6, 688, x8)

inst_360:
// rs1_val==3037000499 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x5555555555555556, x6, 696, x8)

inst_361:
// rs1_val==3037000499 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, -0x5555555555555555, x6, 704, x8)

inst_362:
// rs1_val==3037000499 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, -0x5, 0xb504f333, 0x6, x6, 712, x8)

inst_363:
// rs1_val==3037000499 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d999, 0xb504f333, 0x3333333333333334, x6, 720, x8)

inst_364:
// rs1_val==3037000499 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, 0x6666666666666667, x6, 728, x8)

inst_365:
// rs1_val==3037000499 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccd, 0xb504f333, -0xb504f332, x6, 736, x8)

inst_366:
// rs1_val==3037000499 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f333;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0xb504f333, 0xb504f334, x6, 744, x8)

inst_367:
// rs1_val==2 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x3, x6, 752, x8)

inst_368:
// rs1_val==2 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x5555555555555555, x6, 760, x8)

inst_369:
// rs1_val==2 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, -0x5555555555555556, x6, 768, x8)

inst_370:
// rs1_val==2 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x5, x6, 776, x8)

inst_371:
// rs1_val==2 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x3333333333333333, x6, 784, x8)

inst_372:
// rs1_val==2 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x6666666666666666, x6, 792, x8)

inst_373:
// rs1_val==2 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, -0xb504f333, x6, 800, x8)

inst_374:
// rs1_val==2 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0xb504f333, x6, 808, x8)

inst_375:
// rs1_val==2 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x2, 0x2, x6, 816, x8)

inst_376:
// rs1_val==2 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x5555555555555554, x6, 824, x8)

inst_377:
// rs1_val==2 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x0, x6, 832, x8)

inst_378:
// rs1_val==2 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x4, x6, 840, x8)

inst_379:
// rs1_val==2 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x3333333333333332, x6, 848, x8)

inst_380:
// rs1_val==2 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x6666666666666665, x6, 856, x8)

inst_381:
// rs1_val==2 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0xb504f332, x6, 864, x8)

inst_382:
// rs1_val==2 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x5555555555555556, x6, 872, x8)

inst_383:
// rs1_val==2 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, -0x5555555555555555, x6, 880, x8)

inst_384:
// rs1_val==2 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x6, x6, 888, x8)

inst_385:
// rs1_val==2 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x3333333333333334, x6, 896, x8)

inst_386:
// rs1_val==2 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0x6666666666666667, x6, 904, x8)

inst_387:
// rs1_val==2 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, -0xb504f332, x6, 912, x8)

inst_388:
// rs1_val==2 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x2;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x2, 0xb504f334, x6, 920, x8)

inst_389:
// rs1_val==6148914691236517204 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555554, 0x3, x6, 928, x8)

inst_390:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x5555555555555555, x6, 936, x8)

inst_391:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, -0x5555555555555556, x6, 944, x8)

inst_392:
// rs1_val==6148914691236517204 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x5555555555555554, 0x5, x6, 952, x8)

inst_393:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x22222221, 0x5555555555555554, 0x3333333333333333, x6, 960, x8)

inst_394:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x6666666666666666, x6, 968, x8)

inst_395:
// rs1_val==6148914691236517204 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4887, 0x5555555555555554, -0xb504f333, x6, 976, x8)

inst_396:
// rs1_val==6148914691236517204 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4887, 0x5555555555555554, 0xb504f333, x6, 984, x8)

inst_397:
// rs1_val==6148914691236517204 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555554, 0x2, x6, 992, x8)

inst_398:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555554, 0x5555555555555554, x6, 1000, x8)

inst_399:
// rs1_val==6148914691236517204 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x0, x6, 1008, x8)

inst_400:
// rs1_val==6148914691236517204 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555554, 0x4, x6, 1016, x8)

inst_401:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x22222222, 0x5555555555555554, 0x3333333333333332, x6, 1024, x8)

inst_402:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x6666666666666665, x6, 1032, x8)

inst_403:
// rs1_val==6148914691236517204 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4886, 0x5555555555555554, 0xb504f332, x6, 1040, x8)

inst_404:
// rs1_val==6148914691236517204 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x5555555555555556, x6, 1048, x8)

inst_405:
// rs1_val==6148914691236517204 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, -0x5555555555555555, x6, 1056, x8)

inst_406:
// rs1_val==6148914691236517204 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555554, 0x6, x6, 1064, x8)

inst_407:
// rs1_val==6148914691236517204 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x22222220, 0x5555555555555554, 0x3333333333333334, x6, 1072, x8)

inst_408:
// rs1_val==6148914691236517204 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x55555554, 0x5555555555555554, 0x6666666666666667, x6, 1080, x8)

inst_409:
// rs1_val==6148914691236517204 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4886, 0x5555555555555554, -0xb504f332, x6, 1088, x8)

inst_410:
// rs1_val==6148914691236517204 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555554;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4888, 0x5555555555555554, 0xb504f334, x6, 1096, x8)

inst_411:
// rs1_val==0 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x3, x6, 1104, x8)

inst_412:
// rs1_val==0 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x5555555555555555, x6, 1112, x8)

inst_413:
// rs1_val==0 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, -0x5555555555555556, x6, 1120, x8)

inst_414:
// rs1_val==0 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x5, x6, 1128, x8)

inst_415:
// rs1_val==0 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x3333333333333333, x6, 1136, x8)

inst_416:
// rs1_val==0 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x6666666666666666, x6, 1144, x8)

inst_417:
// rs1_val==0 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0xb504f334, x6, 1152, x8)

inst_418:
// rs1_val==4 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x4, 0x3, x6, 1160, x8)

inst_419:
// rs1_val==4 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x5555555555555555, x6, 1168, x8)

inst_420:
// rs1_val==4 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x5, x6, 1176, x8)

inst_421:
// rs1_val==4 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x3333333333333333, x6, 1184, x8)

inst_422:
// rs1_val==4 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x6666666666666666, x6, 1192, x8)

inst_423:
// rs1_val==4 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, -0xb504f333, x6, 1200, x8)

inst_424:
// rs1_val==4 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0xb504f333, x6, 1208, x8)

inst_425:
// rs1_val==4 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x4, 0x2, x6, 1216, x8)

inst_426:
// rs1_val==4 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x5555555555555554, x6, 1224, x8)

inst_427:
// rs1_val==4 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x0, x6, 1232, x8)

inst_428:
// rs1_val==4 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x4, 0x4, x6, 1240, x8)

inst_429:
// rs1_val==4 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x3333333333333332, x6, 1248, x8)

inst_430:
// rs1_val==4 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x6666666666666665, x6, 1256, x8)

inst_431:
// rs1_val==4 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0xb504f332, x6, 1264, x8)

inst_432:
// rs1_val==4 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x5555555555555556, x6, 1272, x8)

inst_433:
// rs1_val==4 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, -0x5555555555555555, x6, 1280, x8)

inst_434:
// rs1_val==4 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x6, x6, 1288, x8)

inst_435:
// rs1_val==4 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x3333333333333334, x6, 1296, x8)

inst_436:
// rs1_val==4 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0x6666666666666667, x6, 1304, x8)

inst_437:
// rs1_val==4 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, -0xb504f332, x6, 1312, x8)

inst_438:
// rs1_val==4 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x4;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x4, 0xb504f334, x6, 1320, x8)

inst_439:
// rs1_val==3689348814741910322 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x3333333333333332, 0x3, x6, 1328, x8)

inst_440:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x5555555555555555, x6, 1336, x8)

inst_441:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, -0x5555555555555556, x6, 1344, x8)

inst_442:
// rs1_val==3689348814741910322 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x3333333333333332, 0x5, x6, 1352, x8)

inst_443:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x3333333333333333, x6, 1360, x8)

inst_444:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x6666666666666666, x6, 1368, x8)

inst_445:
// rs1_val==3689348814741910322 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, -0xb504f333, x6, 1376, x8)

inst_446:
// rs1_val==3689348814741910322 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xb504f333, x6, 1384, x8)

inst_447:
// rs1_val==3689348814741910322 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333332, 0x2, x6, 1392, x8)

inst_448:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x5555555555555554, x6, 1400, x8)

inst_449:
// rs1_val==3689348814741910322 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x0, x6, 1408, x8)

inst_450:
// rs1_val==3689348814741910322 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x3333333333333332, 0x4, x6, 1416, x8)

inst_451:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333332, 0x3333333333333332, x6, 1424, x8)

inst_452:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x6666666666666665, x6, 1432, x8)

inst_453:
// rs1_val==3689348814741910322 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xb504f332, x6, 1440, x8)

inst_454:
// rs1_val==3689348814741910322 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x5555555555555556, x6, 1448, x8)

inst_455:
// rs1_val==3689348814741910322 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, -0x5555555555555555, x6, 1456, x8)

inst_456:
// rs1_val==3689348814741910322 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x3333333333333332, 0x6, x6, 1464, x8)

inst_457:
// rs1_val==3689348814741910322 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x3333333333333334, x6, 1472, x8)

inst_458:
// rs1_val==3689348814741910322 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0x6666666666666667, x6, 1480, x8)

inst_459:
// rs1_val==3689348814741910322 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, -0xb504f332, x6, 1488, x8)

inst_460:
// rs1_val==3689348814741910322 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333332;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x3333333333333332, 0xb504f334, x6, 1496, x8)

inst_461:
// rs1_val==7378697629483820645 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x6666666666666665, 0x3, x6, 1504, x8)

inst_462:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x11111110, 0x6666666666666665, 0x5555555555555555, x6, 1512, x8)

inst_463:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x1111110f, 0x6666666666666665, -0x5555555555555556, x6, 1520, x8)

inst_464:
// rs1_val==7378697629483820645 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x6666666666666665, 0x5, x6, 1528, x8)

inst_465:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x33333332, 0x6666666666666665, 0x3333333333333333, x6, 1536, x8)

inst_466:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x6666666666666666, x6, 1544, x8)

inst_467:
// rs1_val==7378697629483820645 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5998, 0x6666666666666665, -0xb504f333, x6, 1552, x8)

inst_468:
// rs1_val==7378697629483820645 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5998, 0x6666666666666665, 0xb504f333, x6, 1560, x8)

inst_469:
// rs1_val==7378697629483820645 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666665, 0x2, x6, 1568, x8)

inst_470:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x11111111, 0x6666666666666665, 0x5555555555555554, x6, 1576, x8)

inst_471:
// rs1_val==7378697629483820645 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x0, x6, 1584, x8)

inst_472:
// rs1_val==7378697629483820645 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666665, 0x4, x6, 1592, x8)

inst_473:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666665, 0x3333333333333332, x6, 1600, x8)

inst_474:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666665, 0x6666666666666665, x6, 1608, x8)

inst_475:
// rs1_val==7378697629483820645 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5997, 0x6666666666666665, 0xb504f332, x6, 1616, x8)

inst_476:
// rs1_val==7378697629483820645 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x1111110f, 0x6666666666666665, 0x5555555555555556, x6, 1624, x8)

inst_477:
// rs1_val==7378697629483820645 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x11111110, 0x6666666666666665, -0x5555555555555555, x6, 1632, x8)

inst_478:
// rs1_val==7378697629483820645 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x5, 0x6666666666666665, 0x6, x6, 1640, x8)

inst_479:
// rs1_val==7378697629483820645 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x33333331, 0x6666666666666665, 0x3333333333333334, x6, 1648, x8)

inst_480:
// rs1_val==7378697629483820645 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x66666665, 0x6666666666666665, 0x6666666666666667, x6, 1656, x8)

inst_481:
// rs1_val==7378697629483820645 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5997, 0x6666666666666665, -0xb504f332, x6, 1664, x8)

inst_482:
// rs1_val==7378697629483820645 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666665;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5999, 0x6666666666666665, 0xb504f334, x6, 1672, x8)

inst_483:
// rs1_val==3037000498 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f332, 0x3, x6, 1680, x8)

inst_484:
// rs1_val==3037000498 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x5555555555555555, x6, 1688, x8)

inst_485:
// rs1_val==3037000498 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, -0x5555555555555556, x6, 1696, x8)

inst_486:
// rs1_val==3037000498 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, -0x3, 0xb504f332, 0x5, x6, 1704, x8)

inst_487:
// rs1_val==3037000498 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d99b, 0xb504f332, 0x3333333333333333, x6, 1712, x8)

inst_488:
// rs1_val==3037000498 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x6666666666666666, x6, 1720, x8)

inst_489:
// rs1_val==3037000498 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0xb504f332, -0xb504f333, x6, 1728, x8)

inst_490:
// rs1_val==3037000498 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0xb504f332, 0xb504f333, x6, 1736, x8)

inst_491:
// rs1_val==3037000498 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f332, 0x2, x6, 1744, x8)

inst_492:
// rs1_val==3037000498 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x5555555555555554, x6, 1752, x8)

inst_493:
// rs1_val==3037000498 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x0, x6, 1760, x8)

inst_494:
// rs1_val==3037000498 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, -0x2, 0xb504f332, 0x4, x6, 1768, x8)

inst_495:
// rs1_val==3037000498 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d99c, 0xb504f332, 0x3333333333333332, x6, 1776, x8)

inst_496:
// rs1_val==3037000498 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x6666666666666665, x6, 1784, x8)

inst_497:
// rs1_val==3037000498 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f332, 0xb504f332, x6, 1792, x8)

inst_498:
// rs1_val==3037000498 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x5555555555555556, x6, 1800, x8)

inst_499:
// rs1_val==3037000498 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, -0x5555555555555555, x6, 1808, x8)

inst_500:
// rs1_val==3037000498 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f332, 0x6, x6, 1816, x8)

inst_501:
// rs1_val==3037000498 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d99a, 0xb504f332, 0x3333333333333334, x6, 1824, x8)

inst_502:
// rs1_val==3037000498 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0cce, 0xb504f332, 0x6666666666666667, x6, 1832, x8)

inst_503:
// rs1_val==3037000498 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f332, -0xb504f332, x6, 1840, x8)

inst_504:
// rs1_val==3037000498 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f332;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, -0x2, 0xb504f332, 0xb504f334, x6, 1848, x8)

inst_505:
// rs1_val==6148914691236517206 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x5555555555555556, 0x3, x6, 1856, x8)

inst_506:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555556, 0x5555555555555555, x6, 1864, x8)

inst_507:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555556, -0x5555555555555556, x6, 1872, x8)

inst_508:
// rs1_val==6148914691236517206 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555556, 0x5, x6, 1880, x8)

inst_509:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x22222223, 0x5555555555555556, 0x3333333333333333, x6, 1888, x8)

inst_510:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x6666666666666666, x6, 1896, x8)

inst_511:
// rs1_val==6148914691236517206 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4889, 0x5555555555555556, -0xb504f333, x6, 1904, x8)

inst_512:
// rs1_val==6148914691236517206 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4889, 0x5555555555555556, 0xb504f333, x6, 1912, x8)

inst_513:
// rs1_val==6148914691236517206 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555556, 0x2, x6, 1920, x8)

inst_514:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x5555555555555556, 0x5555555555555554, x6, 1928, x8)

inst_515:
// rs1_val==6148914691236517206 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x0, x6, 1936, x8)

inst_516:
// rs1_val==6148914691236517206 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x5555555555555556, 0x4, x6, 1944, x8)

inst_517:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x22222224, 0x5555555555555556, 0x3333333333333332, x6, 1952, x8)

inst_518:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x6666666666666665, x6, 1960, x8)

inst_519:
// rs1_val==6148914691236517206 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4888, 0x5555555555555556, 0xb504f332, x6, 1968, x8)

inst_520:
// rs1_val==6148914691236517206 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x5555555555555556, 0x5555555555555556, x6, 1976, x8)

inst_521:
// rs1_val==6148914691236517206 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x5555555555555556, -0x5555555555555555, x6, 1984, x8)

inst_522:
// rs1_val==6148914691236517206 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x5555555555555556, 0x6, x6, 1992, x8)

inst_523:
// rs1_val==6148914691236517206 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x22222222, 0x5555555555555556, 0x3333333333333334, x6, 2000, x8)

inst_524:
// rs1_val==6148914691236517206 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x55555556, 0x5555555555555556, 0x6666666666666667, x6, 2008, x8)

inst_525:
// rs1_val==6148914691236517206 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0xa5a4888, 0x5555555555555556, -0xb504f332, x6, 2016, x8)

inst_526:
// rs1_val==6148914691236517206 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x5555555555555556;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0xa5a488a, 0x5555555555555556, 0xb504f334, x6, 2024, x8)

inst_527:
// rs1_val==-6148914691236517205 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555555, 0x3, x6, 2032, x8)

inst_528:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x5555555555555555, 0x5555555555555555, x6, 2040, x8)
RVTEST_SIGBASE( x6,signature_x6_2)

inst_529:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x55555555, -0x5555555555555555, -0x5555555555555556, x6, 0, x8)

inst_530:
// rs1_val==-6148914691236517205 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x5555555555555555, 0x5, x6, 8, x8)

inst_531:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, -0x22222222, -0x5555555555555555, 0x3333333333333333, x6, 16, x8)

inst_532:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, -0x55555555, -0x5555555555555555, 0x6666666666666666, x6, 24, x8)

inst_533:
// rs1_val==-6148914691236517205 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4888, -0x5555555555555555, -0xb504f333, x6, 32, x8)

inst_534:
// rs1_val==-6148914691236517205 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4888, -0x5555555555555555, 0xb504f333, x6, 40, x8)

inst_535:
// rs1_val==-6148914691236517205 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555555, 0x2, x6, 48, x8)

inst_536:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555555, 0x5555555555555554, x6, 56, x8)

inst_537:
// rs1_val==-6148914691236517205 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, -0x55555555, -0x5555555555555555, 0x0, x6, 64, x8)

inst_538:
// rs1_val==-6148914691236517205 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555555, 0x4, x6, 72, x8)

inst_539:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, -0x22222223, -0x5555555555555555, 0x3333333333333332, x6, 80, x8)

inst_540:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, -0x55555555, -0x5555555555555555, 0x6666666666666665, x6, 88, x8)

inst_541:
// rs1_val==-6148914691236517205 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4887, -0x5555555555555555, 0xb504f332, x6, 96, x8)

inst_542:
// rs1_val==-6148914691236517205 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x55555555, -0x5555555555555555, 0x5555555555555556, x6, 104, x8)

inst_543:
// rs1_val==-6148914691236517205 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0x5555555555555555, -0x5555555555555555, x6, 112, x8)

inst_544:
// rs1_val==-6148914691236517205 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x5555555555555555, 0x6, x6, 120, x8)

inst_545:
// rs1_val==0 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x3333333333333332, x6, 128, x8)

inst_546:
// rs1_val==0 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x6666666666666665, x6, 136, x8)

inst_547:
// rs1_val==-6148914691236517205 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, -0x22222221, -0x5555555555555555, 0x3333333333333334, x6, 144, x8)

inst_548:
// rs1_val==-6148914691236517205 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, -0x55555555, -0x5555555555555555, 0x6666666666666667, x6, 152, x8)

inst_549:
// rs1_val==-6148914691236517205 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4887, -0x5555555555555555, -0xb504f332, x6, 160, x8)

inst_550:
// rs1_val==-6148914691236517205 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x5555555555555555;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, -0xa5a4889, -0x5555555555555555, 0xb504f334, x6, 168, x8)

inst_551:
// rs1_val==6 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6, 0x3, x6, 176, x8)

inst_552:
// rs1_val==6 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x5555555555555555, x6, 184, x8)

inst_553:
// rs1_val==6 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, -0x5555555555555556, x6, 192, x8)

inst_554:
// rs1_val==6 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6, 0x5, x6, 200, x8)

inst_555:
// rs1_val==6 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x3333333333333333, x6, 208, x8)

inst_556:
// rs1_val==6 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x6666666666666666, x6, 216, x8)

inst_557:
// rs1_val==6 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, -0xb504f333, x6, 224, x8)

inst_558:
// rs1_val==6 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0xb504f333, x6, 232, x8)

inst_559:
// rs1_val==6 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6, 0x2, x6, 240, x8)

inst_560:
// rs1_val==6 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x5555555555555554, x6, 248, x8)

inst_561:
// rs1_val==6 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x0, x6, 256, x8)

inst_562:
// rs1_val==6 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x6, 0x4, x6, 264, x8)

inst_563:
// rs1_val==6 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x3333333333333332, x6, 272, x8)

inst_564:
// rs1_val==6 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x6666666666666665, x6, 280, x8)

inst_565:
// rs1_val==6 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0xb504f332, x6, 288, x8)

inst_566:
// rs1_val==6 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x5555555555555556, x6, 296, x8)

inst_567:
// rs1_val==6 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, -0x5555555555555555, x6, 304, x8)

inst_568:
// rs1_val==6 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6, 0x6, x6, 312, x8)

inst_569:
// rs1_val==6 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x3333333333333334, x6, 320, x8)

inst_570:
// rs1_val==6 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0x6666666666666667, x6, 328, x8)

inst_571:
// rs1_val==6 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, -0xb504f332, x6, 336, x8)

inst_572:
// rs1_val==6 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x6, 0x6, 0xb504f334, x6, 344, x8)

inst_573:
// rs1_val==3689348814741910324 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x3333333333333334, 0x3, x6, 352, x8)

inst_574:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x5555555555555555, x6, 360, x8)

inst_575:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, -0x5555555555555556, x6, 368, x8)

inst_576:
// rs1_val==3689348814741910324 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333334, 0x5, x6, 376, x8)

inst_577:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x3333333333333334, 0x3333333333333333, x6, 384, x8)

inst_578:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x6666666666666666, x6, 392, x8)

inst_579:
// rs1_val==3689348814741910324 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, -0xb504f333, x6, 400, x8)

inst_580:
// rs1_val==3689348814741910324 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xb504f333, x6, 408, x8)

inst_581:
// rs1_val==3689348814741910324 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333334, 0x2, x6, 416, x8)

inst_582:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x5555555555555554, x6, 424, x8)

inst_583:
// rs1_val==3689348814741910324 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x0, x6, 432, x8)

inst_584:
// rs1_val==3689348814741910324 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333334, 0x4, x6, 440, x8)

inst_585:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x3333333333333334, 0x3333333333333332, x6, 448, x8)

inst_586:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x6666666666666665, x6, 456, x8)

inst_587:
// rs1_val==3689348814741910324 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xb504f332, x6, 464, x8)

inst_588:
// rs1_val==3689348814741910324 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x5555555555555556, x6, 472, x8)

inst_589:
// rs1_val==3689348814741910324 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, -0x5555555555555555, x6, 480, x8)

inst_590:
// rs1_val==3689348814741910324 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x3333333333333334, 0x6, x6, 488, x8)

inst_591:
// rs1_val==3689348814741910324 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x3333333333333334, 0x3333333333333334, x6, 496, x8)

inst_592:
// rs1_val==3689348814741910324 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0x6666666666666667, x6, 504, x8)

inst_593:
// rs1_val==3689348814741910324 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, -0xb504f332, x6, 512, x8)

inst_594:
// rs1_val==3689348814741910324 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x3333333333333334;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x33333334, 0x3333333333333334, 0xb504f334, x6, 520, x8)

inst_595:
// rs1_val==7378697629483820647 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666667, 0x3, x6, 528, x8)

inst_596:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x11111112, 0x6666666666666667, 0x5555555555555555, x6, 536, x8)

inst_597:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x11111111, 0x6666666666666667, -0x5555555555555556, x6, 544, x8)

inst_598:
// rs1_val==7378697629483820647 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x4, 0x6666666666666667, 0x5, x6, 552, x8)

inst_599:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666667, 0x3333333333333333, x6, 560, x8)

inst_600:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666667, 0x6666666666666666, x6, 568, x8)

inst_601:
// rs1_val==7378697629483820647 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b599a, 0x6666666666666667, -0xb504f333, x6, 576, x8)

inst_602:
// rs1_val==7378697629483820647 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b599a, 0x6666666666666667, 0xb504f333, x6, 584, x8)

inst_603:
// rs1_val==7378697629483820647 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666667, 0x2, x6, 592, x8)

inst_604:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x11111113, 0x6666666666666667, 0x5555555555555554, x6, 600, x8)

inst_605:
// rs1_val==7378697629483820647 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x66666667, 0x6666666666666667, 0x0, x6, 608, x8)

inst_606:
// rs1_val==7378697629483820647 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x6666666666666667, 0x4, x6, 616, x8)

inst_607:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x3, 0x6666666666666667, 0x3333333333333332, x6, 624, x8)

inst_608:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x2, 0x6666666666666667, 0x6666666666666665, x6, 632, x8)

inst_609:
// rs1_val==7378697629483820647 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5999, 0x6666666666666667, 0xb504f332, x6, 640, x8)

inst_610:
// rs1_val==7378697629483820647 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x11111111, 0x6666666666666667, 0x5555555555555556, x6, 648, x8)

inst_611:
// rs1_val==7378697629483820647 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x11111112, 0x6666666666666667, -0x5555555555555555, x6, 656, x8)

inst_612:
// rs1_val==7378697629483820647 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x6666666666666667, 0x6, x6, 664, x8)

inst_613:
// rs1_val==7378697629483820647 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x33333333, 0x6666666666666667, 0x3333333333333334, x6, 672, x8)

inst_614:
// rs1_val==7378697629483820647 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x6666666666666667, 0x6666666666666667, x6, 680, x8)

inst_615:
// rs1_val==7378697629483820647 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b5999, 0x6666666666666667, -0xb504f332, x6, 688, x8)

inst_616:
// rs1_val==7378697629483820647 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x6666666666666667;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x1b6b599b, 0x6666666666666667, 0xb504f334, x6, 696, x8)

inst_617:
// rs1_val==-3037000498 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0xb504f332, 0x3, x6, 704, x8)

inst_618:
// rs1_val==-3037000498 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, 0x5555555555555555, x6, 712, x8)

inst_619:
// rs1_val==-3037000498 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, -0x5555555555555556, x6, 720, x8)

inst_620:
// rs1_val==-3037000498 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, 0x3, -0xb504f332, 0x5, x6, 728, x8)

inst_621:
// rs1_val==-3037000498 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, 0x17c7d99b, -0xb504f332, 0x3333333333333333, x6, 736, x8)

inst_622:
// rs1_val==-3037000498 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, 0x6666666666666666, x6, 744, x8)

inst_623:
// rs1_val==-3037000498 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1, -0xb504f332, -0xb504f333, x6, 752, x8)

inst_624:
// rs1_val==-3037000498 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x1, -0xb504f332, 0xb504f333, x6, 760, x8)

inst_625:
// rs1_val==-3037000498 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0xb504f332, 0x2, x6, 768, x8)

inst_626:
// rs1_val==-3037000498 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, 0x5555555555555554, x6, 776, x8)

inst_627:
// rs1_val==-3037000498 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, 0x0, x6, 784, x8)

inst_628:
// rs1_val==-3037000498 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, 0x17c7d99c, -0xb504f332, 0x3333333333333332, x6, 792, x8)

inst_629:
// rs1_val==-3037000498 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, 0x6666666666666665, x6, 800, x8)

inst_630:
// rs1_val==-3037000498 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0xb504f332, 0xb504f332, x6, 808, x8)

inst_631:
// rs1_val==-3037000498 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, 0x5555555555555556, x6, 816, x8)

inst_632:
// rs1_val==-3037000498 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, -0x5555555555555555, x6, 824, x8)

inst_633:
// rs1_val==-3037000498 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0xb504f332, 0x6, x6, 832, x8)

inst_634:
// rs1_val==-3037000498 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x17c7d99a, -0xb504f332, 0x3333333333333334, x6, 840, x8)

inst_635:
// rs1_val==-3037000498 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x4afb0cce, -0xb504f332, 0x6666666666666667, x6, 848, x8)

inst_636:
// rs1_val==-3037000498 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x0, -0xb504f332, -0xb504f332, x6, 856, x8)

inst_637:
// rs1_val==-3037000498 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0xb504f332;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x2, -0xb504f332, 0xb504f334, x6, 864, x8)

inst_638:
// rs1_val==3037000500 and rs2_val==3, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0xb504f334, 0x3, x6, 872, x8)

inst_639:
// rs1_val==3037000500 and rs2_val==6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x5555555555555555, x6, 880, x8)

inst_640:
// rs1_val==3037000500 and rs2_val==-6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, -0x5555555555555556, x6, 888, x8)

inst_641:
// rs1_val==3037000500 and rs2_val==5, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5
TEST_RR_OP(remw, x12, x10, x11, -0x1, 0xb504f334, 0x5, x6, 896, x8)

inst_642:
// rs1_val==3037000500 and rs2_val==3689348814741910323, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333333
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d999, 0xb504f334, 0x3333333333333333, x6, 904, x8)

inst_643:
// rs1_val==3037000500 and rs2_val==7378697629483820646, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666666
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x6666666666666666, x6, 912, x8)

inst_644:
// rs1_val==3037000500 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, -0xb504f333, x6, 920, x8)

inst_645:
// rs1_val==3037000500 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0xb504f333, x6, 928, x8)

inst_646:
// rs1_val==3037000500 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f334, 0x2, x6, 936, x8)

inst_647:
// rs1_val==3037000500 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x5555555555555554, x6, 944, x8)

inst_648:
// rs1_val==3037000500 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x0, x6, 952, x8)

inst_649:
// rs1_val==3037000500 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f334, 0x4, x6, 960, x8)

inst_650:
// rs1_val==3037000500 and rs2_val==3689348814741910322, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333332
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d99a, 0xb504f334, 0x3333333333333332, x6, 968, x8)

inst_651:
// rs1_val==3037000500 and rs2_val==7378697629483820645, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666665
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x6666666666666665, x6, 976, x8)

inst_652:
// rs1_val==3037000500 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0xb504f332, x6, 984, x8)

inst_653:
// rs1_val==3037000500 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x5555555555555556, x6, 992, x8)

inst_654:
// rs1_val==3037000500 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, -0x5555555555555555, x6, 1000, x8)

inst_655:
// rs1_val==3037000500 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, -0x4, 0xb504f334, 0x6, x6, 1008, x8)

inst_656:
// rs1_val==3037000500 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, -0x17c7d998, 0xb504f334, 0x3333333333333334, x6, 1016, x8)

inst_657:
// rs1_val==3037000500 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, 0x6666666666666667, x6, 1024, x8)

inst_658:
// rs1_val==3037000500 and rs2_val==-3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:-0xb504f332
TEST_RR_OP(remw, x12, x10, x11, -0x4afb0ccc, 0xb504f334, -0xb504f332, x6, 1032, x8)

inst_659:
// rs1_val==0 and rs2_val==-3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, -0xb504f333, x6, 1040, x8)

inst_660:
// rs1_val==3037000500 and rs2_val==3037000500, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0xb504f334;  op2val:0xb504f334
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0xb504f334, 0xb504f334, x6, 1048, x8)

inst_661:
// rs1_val==0 and rs2_val==3037000499, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f333
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0xb504f333, x6, 1056, x8)

inst_662:
// rs1_val==0 and rs2_val==2, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x2
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x2, x6, 1064, x8)

inst_663:
// rs1_val==0 and rs2_val==6148914691236517204, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555554
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x5555555555555554, x6, 1072, x8)

inst_664:
// rs1_val==0 and rs2_val==0, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x0
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x0, x6, 1080, x8)

inst_665:
// rs1_val==0 and rs2_val==4, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x4
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x4, x6, 1088, x8)

inst_666:
// rs1_val==0 and rs2_val==3037000498, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0xb504f332
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0xb504f332, x6, 1096, x8)

inst_667:
// rs1_val==0 and rs2_val==6148914691236517206, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x5555555555555556
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x5555555555555556, x6, 1104, x8)

inst_668:
// rs1_val==0 and rs2_val==-6148914691236517205, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:-0x5555555555555555
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, -0x5555555555555555, x6, 1112, x8)

inst_669:
// rs1_val==0 and rs2_val==6, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x6, x6, 1120, x8)

inst_670:
// rs1_val==0 and rs2_val==3689348814741910324, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x3333333333333334
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x3333333333333334, x6, 1128, x8)

inst_671:
// rs1_val==0 and rs2_val==7378697629483820647, 
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x0;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x0, 0x0, 0x6666666666666667, x6, 1136, x8)

inst_672:
// rs1_val > 0 and rs2_val > 0, rs1_val == 8, rs1_val != rs2_val
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x8;  op2val:0x6666666666666667
TEST_RR_OP(remw, x12, x10, x11, 0x8, 0x8, 0x6666666666666667, x6, 1144, x8)

inst_673:
// rs1_val < 0 and rs2_val < 0, rs1_val == -562949953421313
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x2000000000001;  op2val:-0x4
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x2000000000001, -0x4, x6, 1152, x8)

inst_674:
// rs1_val == 1, rs2_val == 4398046511104
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:0x1;  op2val:0x40000000000
TEST_RR_OP(remw, x12, x10, x11, 0x1, 0x1, 0x40000000000, x6, 1160, x8)

inst_675:
// rs2_val == 32768, rs1_val == -536870913
// opcode: remw ; op1:x10; op2:x11; dest:x12; op1val:-0x20000001;  op2val:0x8000
TEST_RR_OP(remw, x12, x10, x11, -0x1, -0x20000001, 0x8000, x6, 1168, x8)
#endif


RVTEST_CODE_END
RVMODEL_HALT

RVTEST_DATA_BEGIN
.align 4
rvtest_data:
.word 0xbabecafe
RVTEST_DATA_END

RVMODEL_DATA_BEGIN


signature_x10_0:
    .fill 0*(XLEN/32),4,0xdeadbeef


signature_x10_1:
    .fill 17*(XLEN/32),4,0xdeadbeef


signature_x6_0:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x6_1:
    .fill 256*(XLEN/32),4,0xdeadbeef


signature_x6_2:
    .fill 147*(XLEN/32),4,0xdeadbeef

#ifdef rvtest_mtrap_routine

mtrap_sigptr:
    .fill 64*(XLEN/32),4,0xdeadbeef

#endif

#ifdef rvtest_gpr_save

gpr_save:
    .fill 32*(XLEN/32),4,0xdeadbeef

#endif

RVMODEL_DATA_END
