# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchAccessPoliciesArgs', 'SwitchAccessPolicies']

@pulumi.input_type
class SwitchAccessPoliciesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 access_policy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 access_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dot1x: Optional[pulumi.Input['SwitchAccessPoliciesDot1xArgs']] = None,
                 guest_port_bouncing: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 host_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 increase_access_speed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input['SwitchAccessPoliciesRadiusArgs']] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]]] = None,
                 radius_coa_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 voice_vlan_clients: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SwitchAccessPolicies resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.str] access_policy_number: accessPolicyNumber path parameter. Access policy number
        :param pulumi.Input[_builtins.str] access_policy_type: Access Type of the policy. Automatically 'Hybrid authentication' when hostMode is 'Multi-Domain'.
        :param pulumi.Input['SwitchAccessPoliciesDot1xArgs'] dot1x: 802.1x Settings
        :param pulumi.Input[_builtins.bool] guest_port_bouncing: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.int] guest_vlan_id: ID for the guest VLAN allow unauthorized devices access to limited network resources
        :param pulumi.Input[_builtins.str] host_mode: Choose the Host Mode for the access policy.
        :param pulumi.Input[_builtins.bool] increase_access_speed: Enabling this option will make switches execute 802.1X and MAC-bypass authentication simultaneously so that clients authenticate faster. Only required when accessPolicyType is 'Hybrid Authentication.
        :param pulumi.Input[_builtins.str] name: Name of the access policy
        :param pulumi.Input['SwitchAccessPoliciesRadiusArgs'] radius: Object for RADIUS Settings
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Enable to send start, interim-update and stop messages to a configured RADIUS accounting server for tracking connected clients
        :param pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]] radius_accounting_servers: List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_coa_support_enabled: Change of authentication for RADIUS re-authentication and disconnection
        :param pulumi.Input[_builtins.str] radius_group_attribute: Acceptable values are *""* for None, or *"11"* for Group Policies ACL
        :param pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]] radius_servers: List of RADIUS servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.bool] url_redirect_walled_garden_enabled: Enable to restrict access for clients to a response_objectific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] url_redirect_walled_garden_ranges: IP address ranges, in CIDR notation, to restrict access for clients to a specific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[_builtins.bool] voice_vlan_clients: CDP/LLDP capable voice clients will be able to use this VLAN. Automatically true when hostMode is 'Multi-Domain'.
        """
        pulumi.set(__self__, "network_id", network_id)
        if access_policy_number is not None:
            pulumi.set(__self__, "access_policy_number", access_policy_number)
        if access_policy_type is not None:
            pulumi.set(__self__, "access_policy_type", access_policy_type)
        if dot1x is not None:
            pulumi.set(__self__, "dot1x", dot1x)
        if guest_port_bouncing is not None:
            pulumi.set(__self__, "guest_port_bouncing", guest_port_bouncing)
        if guest_vlan_id is not None:
            pulumi.set(__self__, "guest_vlan_id", guest_vlan_id)
        if host_mode is not None:
            pulumi.set(__self__, "host_mode", host_mode)
        if increase_access_speed is not None:
            pulumi.set(__self__, "increase_access_speed", increase_access_speed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius is not None:
            pulumi.set(__self__, "radius", radius)
        if radius_accounting_enabled is not None:
            pulumi.set(__self__, "radius_accounting_enabled", radius_accounting_enabled)
        if radius_accounting_servers is not None:
            pulumi.set(__self__, "radius_accounting_servers", radius_accounting_servers)
        if radius_coa_support_enabled is not None:
            pulumi.set(__self__, "radius_coa_support_enabled", radius_coa_support_enabled)
        if radius_group_attribute is not None:
            pulumi.set(__self__, "radius_group_attribute", radius_group_attribute)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if radius_testing_enabled is not None:
            pulumi.set(__self__, "radius_testing_enabled", radius_testing_enabled)
        if url_redirect_walled_garden_enabled is not None:
            pulumi.set(__self__, "url_redirect_walled_garden_enabled", url_redirect_walled_garden_enabled)
        if url_redirect_walled_garden_ranges is not None:
            pulumi.set(__self__, "url_redirect_walled_garden_ranges", url_redirect_walled_garden_ranges)
        if voice_vlan_clients is not None:
            pulumi.set(__self__, "voice_vlan_clients", voice_vlan_clients)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        accessPolicyNumber path parameter. Access policy number
        """
        return pulumi.get(self, "access_policy_number")

    @access_policy_number.setter
    def access_policy_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_number", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access Type of the policy. Automatically 'Hybrid authentication' when hostMode is 'Multi-Domain'.
        """
        return pulumi.get(self, "access_policy_type")

    @access_policy_type.setter
    def access_policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_type", value)

    @_builtins.property
    @pulumi.getter
    def dot1x(self) -> Optional[pulumi.Input['SwitchAccessPoliciesDot1xArgs']]:
        """
        802.1x Settings
        """
        return pulumi.get(self, "dot1x")

    @dot1x.setter
    def dot1x(self, value: Optional[pulumi.Input['SwitchAccessPoliciesDot1xArgs']]):
        pulumi.set(self, "dot1x", value)

    @_builtins.property
    @pulumi.getter(name="guestPortBouncing")
    def guest_port_bouncing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        """
        return pulumi.get(self, "guest_port_bouncing")

    @guest_port_bouncing.setter
    def guest_port_bouncing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "guest_port_bouncing", value)

    @_builtins.property
    @pulumi.getter(name="guestVlanId")
    def guest_vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID for the guest VLAN allow unauthorized devices access to limited network resources
        """
        return pulumi.get(self, "guest_vlan_id")

    @guest_vlan_id.setter
    def guest_vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "guest_vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="hostMode")
    def host_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Choose the Host Mode for the access policy.
        """
        return pulumi.get(self, "host_mode")

    @host_mode.setter
    def host_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_mode", value)

    @_builtins.property
    @pulumi.getter(name="increaseAccessSpeed")
    def increase_access_speed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabling this option will make switches execute 802.1X and MAC-bypass authentication simultaneously so that clients authenticate faster. Only required when accessPolicyType is 'Hybrid Authentication.
        """
        return pulumi.get(self, "increase_access_speed")

    @increase_access_speed.setter
    def increase_access_speed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "increase_access_speed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the access policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def radius(self) -> Optional[pulumi.Input['SwitchAccessPoliciesRadiusArgs']]:
        """
        Object for RADIUS Settings
        """
        return pulumi.get(self, "radius")

    @radius.setter
    def radius(self, value: Optional[pulumi.Input['SwitchAccessPoliciesRadiusArgs']]):
        pulumi.set(self, "radius", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingEnabled")
    def radius_accounting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to send start, interim-update and stop messages to a configured RADIUS accounting server for tracking connected clients
        """
        return pulumi.get(self, "radius_accounting_enabled")

    @radius_accounting_enabled.setter
    def radius_accounting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_accounting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServers")
    def radius_accounting_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]]]:
        """
        List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_accounting_servers")

    @radius_accounting_servers.setter
    def radius_accounting_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]]]):
        pulumi.set(self, "radius_accounting_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusCoaSupportEnabled")
    def radius_coa_support_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Change of authentication for RADIUS re-authentication and disconnection
        """
        return pulumi.get(self, "radius_coa_support_enabled")

    @radius_coa_support_enabled.setter
    def radius_coa_support_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_coa_support_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusGroupAttribute")
    def radius_group_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Acceptable values are *""* for None, or *"11"* for Group Policies ACL
        """
        return pulumi.get(self, "radius_group_attribute")

    @radius_group_attribute.setter
    def radius_group_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_group_attribute", value)

    @_builtins.property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]]]:
        """
        List of RADIUS servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_servers")

    @radius_servers.setter
    def radius_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]]]):
        pulumi.set(self, "radius_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusTestingEnabled")
    def radius_testing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        """
        return pulumi.get(self, "radius_testing_enabled")

    @radius_testing_enabled.setter
    def radius_testing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_testing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="urlRedirectWalledGardenEnabled")
    def url_redirect_walled_garden_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to restrict access for clients to a response_objectific set of IP addresses or hostnames prior to authentication
        """
        return pulumi.get(self, "url_redirect_walled_garden_enabled")

    @url_redirect_walled_garden_enabled.setter
    def url_redirect_walled_garden_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "url_redirect_walled_garden_enabled", value)

    @_builtins.property
    @pulumi.getter(name="urlRedirectWalledGardenRanges")
    def url_redirect_walled_garden_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IP address ranges, in CIDR notation, to restrict access for clients to a specific set of IP addresses or hostnames prior to authentication
        """
        return pulumi.get(self, "url_redirect_walled_garden_ranges")

    @url_redirect_walled_garden_ranges.setter
    def url_redirect_walled_garden_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "url_redirect_walled_garden_ranges", value)

    @_builtins.property
    @pulumi.getter(name="voiceVlanClients")
    def voice_vlan_clients(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        CDP/LLDP capable voice clients will be able to use this VLAN. Automatically true when hostMode is 'Multi-Domain'.
        """
        return pulumi.get(self, "voice_vlan_clients")

    @voice_vlan_clients.setter
    def voice_vlan_clients(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "voice_vlan_clients", value)


@pulumi.input_type
class _SwitchAccessPoliciesState:
    def __init__(__self__, *,
                 access_policy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 access_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 counts: Optional[pulumi.Input['SwitchAccessPoliciesCountsArgs']] = None,
                 dot1x: Optional[pulumi.Input['SwitchAccessPoliciesDot1xArgs']] = None,
                 guest_port_bouncing: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 host_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 increase_access_speed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input['SwitchAccessPoliciesRadiusArgs']] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]]] = None,
                 radius_accounting_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServersResponseArgs']]]] = None,
                 radius_coa_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]]] = None,
                 radius_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServersResponseArgs']]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 voice_vlan_clients: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SwitchAccessPolicies resources.
        :param pulumi.Input[_builtins.str] access_policy_number: accessPolicyNumber path parameter. Access policy number
        :param pulumi.Input[_builtins.str] access_policy_type: Access Type of the policy. Automatically 'Hybrid authentication' when hostMode is 'Multi-Domain'.
        :param pulumi.Input['SwitchAccessPoliciesCountsArgs'] counts: Counts associated with the access policy
        :param pulumi.Input['SwitchAccessPoliciesDot1xArgs'] dot1x: 802.1x Settings
        :param pulumi.Input[_builtins.bool] guest_port_bouncing: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.int] guest_vlan_id: ID for the guest VLAN allow unauthorized devices access to limited network resources
        :param pulumi.Input[_builtins.str] host_mode: Choose the Host Mode for the access policy.
        :param pulumi.Input[_builtins.bool] increase_access_speed: Enabling this option will make switches execute 802.1X and MAC-bypass authentication simultaneously so that clients authenticate faster. Only required when accessPolicyType is 'Hybrid Authentication.
        :param pulumi.Input[_builtins.str] name: Name of the access policy
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['SwitchAccessPoliciesRadiusArgs'] radius: Object for RADIUS Settings
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Enable to send start, interim-update and stop messages to a configured RADIUS accounting server for tracking connected clients
        :param pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]] radius_accounting_servers: List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServersResponseArgs']]] radius_accounting_servers_responses: List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_coa_support_enabled: Change of authentication for RADIUS re-authentication and disconnection
        :param pulumi.Input[_builtins.str] radius_group_attribute: Acceptable values are *""* for None, or *"11"* for Group Policies ACL
        :param pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]] radius_servers: List of RADIUS servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServersResponseArgs']]] radius_servers_responses: List of RADIUS servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.bool] url_redirect_walled_garden_enabled: Enable to restrict access for clients to a response_objectific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] url_redirect_walled_garden_ranges: IP address ranges, in CIDR notation, to restrict access for clients to a specific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[_builtins.bool] voice_vlan_clients: CDP/LLDP capable voice clients will be able to use this VLAN. Automatically true when hostMode is 'Multi-Domain'.
        """
        if access_policy_number is not None:
            pulumi.set(__self__, "access_policy_number", access_policy_number)
        if access_policy_type is not None:
            pulumi.set(__self__, "access_policy_type", access_policy_type)
        if counts is not None:
            pulumi.set(__self__, "counts", counts)
        if dot1x is not None:
            pulumi.set(__self__, "dot1x", dot1x)
        if guest_port_bouncing is not None:
            pulumi.set(__self__, "guest_port_bouncing", guest_port_bouncing)
        if guest_vlan_id is not None:
            pulumi.set(__self__, "guest_vlan_id", guest_vlan_id)
        if host_mode is not None:
            pulumi.set(__self__, "host_mode", host_mode)
        if increase_access_speed is not None:
            pulumi.set(__self__, "increase_access_speed", increase_access_speed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if radius is not None:
            pulumi.set(__self__, "radius", radius)
        if radius_accounting_enabled is not None:
            pulumi.set(__self__, "radius_accounting_enabled", radius_accounting_enabled)
        if radius_accounting_servers is not None:
            pulumi.set(__self__, "radius_accounting_servers", radius_accounting_servers)
        if radius_accounting_servers_responses is not None:
            pulumi.set(__self__, "radius_accounting_servers_responses", radius_accounting_servers_responses)
        if radius_coa_support_enabled is not None:
            pulumi.set(__self__, "radius_coa_support_enabled", radius_coa_support_enabled)
        if radius_group_attribute is not None:
            pulumi.set(__self__, "radius_group_attribute", radius_group_attribute)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if radius_servers_responses is not None:
            pulumi.set(__self__, "radius_servers_responses", radius_servers_responses)
        if radius_testing_enabled is not None:
            pulumi.set(__self__, "radius_testing_enabled", radius_testing_enabled)
        if url_redirect_walled_garden_enabled is not None:
            pulumi.set(__self__, "url_redirect_walled_garden_enabled", url_redirect_walled_garden_enabled)
        if url_redirect_walled_garden_ranges is not None:
            pulumi.set(__self__, "url_redirect_walled_garden_ranges", url_redirect_walled_garden_ranges)
        if voice_vlan_clients is not None:
            pulumi.set(__self__, "voice_vlan_clients", voice_vlan_clients)

    @_builtins.property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        accessPolicyNumber path parameter. Access policy number
        """
        return pulumi.get(self, "access_policy_number")

    @access_policy_number.setter
    def access_policy_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_number", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access Type of the policy. Automatically 'Hybrid authentication' when hostMode is 'Multi-Domain'.
        """
        return pulumi.get(self, "access_policy_type")

    @access_policy_type.setter
    def access_policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_type", value)

    @_builtins.property
    @pulumi.getter
    def counts(self) -> Optional[pulumi.Input['SwitchAccessPoliciesCountsArgs']]:
        """
        Counts associated with the access policy
        """
        return pulumi.get(self, "counts")

    @counts.setter
    def counts(self, value: Optional[pulumi.Input['SwitchAccessPoliciesCountsArgs']]):
        pulumi.set(self, "counts", value)

    @_builtins.property
    @pulumi.getter
    def dot1x(self) -> Optional[pulumi.Input['SwitchAccessPoliciesDot1xArgs']]:
        """
        802.1x Settings
        """
        return pulumi.get(self, "dot1x")

    @dot1x.setter
    def dot1x(self, value: Optional[pulumi.Input['SwitchAccessPoliciesDot1xArgs']]):
        pulumi.set(self, "dot1x", value)

    @_builtins.property
    @pulumi.getter(name="guestPortBouncing")
    def guest_port_bouncing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        """
        return pulumi.get(self, "guest_port_bouncing")

    @guest_port_bouncing.setter
    def guest_port_bouncing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "guest_port_bouncing", value)

    @_builtins.property
    @pulumi.getter(name="guestVlanId")
    def guest_vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID for the guest VLAN allow unauthorized devices access to limited network resources
        """
        return pulumi.get(self, "guest_vlan_id")

    @guest_vlan_id.setter
    def guest_vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "guest_vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="hostMode")
    def host_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Choose the Host Mode for the access policy.
        """
        return pulumi.get(self, "host_mode")

    @host_mode.setter
    def host_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_mode", value)

    @_builtins.property
    @pulumi.getter(name="increaseAccessSpeed")
    def increase_access_speed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabling this option will make switches execute 802.1X and MAC-bypass authentication simultaneously so that clients authenticate faster. Only required when accessPolicyType is 'Hybrid Authentication.
        """
        return pulumi.get(self, "increase_access_speed")

    @increase_access_speed.setter
    def increase_access_speed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "increase_access_speed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the access policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def radius(self) -> Optional[pulumi.Input['SwitchAccessPoliciesRadiusArgs']]:
        """
        Object for RADIUS Settings
        """
        return pulumi.get(self, "radius")

    @radius.setter
    def radius(self, value: Optional[pulumi.Input['SwitchAccessPoliciesRadiusArgs']]):
        pulumi.set(self, "radius", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingEnabled")
    def radius_accounting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to send start, interim-update and stop messages to a configured RADIUS accounting server for tracking connected clients
        """
        return pulumi.get(self, "radius_accounting_enabled")

    @radius_accounting_enabled.setter
    def radius_accounting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_accounting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServers")
    def radius_accounting_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]]]:
        """
        List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_accounting_servers")

    @radius_accounting_servers.setter
    def radius_accounting_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServerArgs']]]]):
        pulumi.set(self, "radius_accounting_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServersResponses")
    def radius_accounting_servers_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServersResponseArgs']]]]:
        """
        List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_accounting_servers_responses")

    @radius_accounting_servers_responses.setter
    def radius_accounting_servers_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusAccountingServersResponseArgs']]]]):
        pulumi.set(self, "radius_accounting_servers_responses", value)

    @_builtins.property
    @pulumi.getter(name="radiusCoaSupportEnabled")
    def radius_coa_support_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Change of authentication for RADIUS re-authentication and disconnection
        """
        return pulumi.get(self, "radius_coa_support_enabled")

    @radius_coa_support_enabled.setter
    def radius_coa_support_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_coa_support_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusGroupAttribute")
    def radius_group_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Acceptable values are *""* for None, or *"11"* for Group Policies ACL
        """
        return pulumi.get(self, "radius_group_attribute")

    @radius_group_attribute.setter
    def radius_group_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_group_attribute", value)

    @_builtins.property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]]]:
        """
        List of RADIUS servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_servers")

    @radius_servers.setter
    def radius_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServerArgs']]]]):
        pulumi.set(self, "radius_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusServersResponses")
    def radius_servers_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServersResponseArgs']]]]:
        """
        List of RADIUS servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_servers_responses")

    @radius_servers_responses.setter
    def radius_servers_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchAccessPoliciesRadiusServersResponseArgs']]]]):
        pulumi.set(self, "radius_servers_responses", value)

    @_builtins.property
    @pulumi.getter(name="radiusTestingEnabled")
    def radius_testing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        """
        return pulumi.get(self, "radius_testing_enabled")

    @radius_testing_enabled.setter
    def radius_testing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_testing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="urlRedirectWalledGardenEnabled")
    def url_redirect_walled_garden_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to restrict access for clients to a response_objectific set of IP addresses or hostnames prior to authentication
        """
        return pulumi.get(self, "url_redirect_walled_garden_enabled")

    @url_redirect_walled_garden_enabled.setter
    def url_redirect_walled_garden_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "url_redirect_walled_garden_enabled", value)

    @_builtins.property
    @pulumi.getter(name="urlRedirectWalledGardenRanges")
    def url_redirect_walled_garden_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IP address ranges, in CIDR notation, to restrict access for clients to a specific set of IP addresses or hostnames prior to authentication
        """
        return pulumi.get(self, "url_redirect_walled_garden_ranges")

    @url_redirect_walled_garden_ranges.setter
    def url_redirect_walled_garden_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "url_redirect_walled_garden_ranges", value)

    @_builtins.property
    @pulumi.getter(name="voiceVlanClients")
    def voice_vlan_clients(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        CDP/LLDP capable voice clients will be able to use this VLAN. Automatically true when hostMode is 'Multi-Domain'.
        """
        return pulumi.get(self, "voice_vlan_clients")

    @voice_vlan_clients.setter
    def voice_vlan_clients(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "voice_vlan_clients", value)


@pulumi.type_token("meraki:networks/switchAccessPolicies:SwitchAccessPolicies")
class SwitchAccessPolicies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 access_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dot1x: Optional[pulumi.Input[Union['SwitchAccessPoliciesDot1xArgs', 'SwitchAccessPoliciesDot1xArgsDict']]] = None,
                 guest_port_bouncing: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 host_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 increase_access_speed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input[Union['SwitchAccessPoliciesRadiusArgs', 'SwitchAccessPoliciesRadiusArgsDict']]] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusAccountingServerArgs', 'SwitchAccessPoliciesRadiusAccountingServerArgsDict']]]]] = None,
                 radius_coa_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusServerArgs', 'SwitchAccessPoliciesRadiusServerArgsDict']]]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 voice_vlan_clients: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchAccessPolicies:SwitchAccessPolicies example "access_policy_number,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy_number: accessPolicyNumber path parameter. Access policy number
        :param pulumi.Input[_builtins.str] access_policy_type: Access Type of the policy. Automatically 'Hybrid authentication' when hostMode is 'Multi-Domain'.
        :param pulumi.Input[Union['SwitchAccessPoliciesDot1xArgs', 'SwitchAccessPoliciesDot1xArgsDict']] dot1x: 802.1x Settings
        :param pulumi.Input[_builtins.bool] guest_port_bouncing: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.int] guest_vlan_id: ID for the guest VLAN allow unauthorized devices access to limited network resources
        :param pulumi.Input[_builtins.str] host_mode: Choose the Host Mode for the access policy.
        :param pulumi.Input[_builtins.bool] increase_access_speed: Enabling this option will make switches execute 802.1X and MAC-bypass authentication simultaneously so that clients authenticate faster. Only required when accessPolicyType is 'Hybrid Authentication.
        :param pulumi.Input[_builtins.str] name: Name of the access policy
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['SwitchAccessPoliciesRadiusArgs', 'SwitchAccessPoliciesRadiusArgsDict']] radius: Object for RADIUS Settings
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Enable to send start, interim-update and stop messages to a configured RADIUS accounting server for tracking connected clients
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusAccountingServerArgs', 'SwitchAccessPoliciesRadiusAccountingServerArgsDict']]]] radius_accounting_servers: List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_coa_support_enabled: Change of authentication for RADIUS re-authentication and disconnection
        :param pulumi.Input[_builtins.str] radius_group_attribute: Acceptable values are *""* for None, or *"11"* for Group Policies ACL
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusServerArgs', 'SwitchAccessPoliciesRadiusServerArgsDict']]]] radius_servers: List of RADIUS servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.bool] url_redirect_walled_garden_enabled: Enable to restrict access for clients to a response_objectific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] url_redirect_walled_garden_ranges: IP address ranges, in CIDR notation, to restrict access for clients to a specific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[_builtins.bool] voice_vlan_clients: CDP/LLDP capable voice clients will be able to use this VLAN. Automatically true when hostMode is 'Multi-Domain'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchAccessPoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchAccessPolicies:SwitchAccessPolicies example "access_policy_number,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchAccessPoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchAccessPoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_number: Optional[pulumi.Input[_builtins.str]] = None,
                 access_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dot1x: Optional[pulumi.Input[Union['SwitchAccessPoliciesDot1xArgs', 'SwitchAccessPoliciesDot1xArgsDict']]] = None,
                 guest_port_bouncing: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 host_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 increase_access_speed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input[Union['SwitchAccessPoliciesRadiusArgs', 'SwitchAccessPoliciesRadiusArgsDict']]] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusAccountingServerArgs', 'SwitchAccessPoliciesRadiusAccountingServerArgsDict']]]]] = None,
                 radius_coa_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusServerArgs', 'SwitchAccessPoliciesRadiusServerArgsDict']]]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url_redirect_walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 voice_vlan_clients: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchAccessPoliciesArgs.__new__(SwitchAccessPoliciesArgs)

            __props__.__dict__["access_policy_number"] = access_policy_number
            __props__.__dict__["access_policy_type"] = access_policy_type
            __props__.__dict__["dot1x"] = dot1x
            __props__.__dict__["guest_port_bouncing"] = guest_port_bouncing
            __props__.__dict__["guest_vlan_id"] = guest_vlan_id
            __props__.__dict__["host_mode"] = host_mode
            __props__.__dict__["increase_access_speed"] = increase_access_speed
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["radius"] = radius
            __props__.__dict__["radius_accounting_enabled"] = radius_accounting_enabled
            __props__.__dict__["radius_accounting_servers"] = radius_accounting_servers
            __props__.__dict__["radius_coa_support_enabled"] = radius_coa_support_enabled
            __props__.__dict__["radius_group_attribute"] = radius_group_attribute
            __props__.__dict__["radius_servers"] = radius_servers
            __props__.__dict__["radius_testing_enabled"] = radius_testing_enabled
            __props__.__dict__["url_redirect_walled_garden_enabled"] = url_redirect_walled_garden_enabled
            __props__.__dict__["url_redirect_walled_garden_ranges"] = url_redirect_walled_garden_ranges
            __props__.__dict__["voice_vlan_clients"] = voice_vlan_clients
            __props__.__dict__["counts"] = None
            __props__.__dict__["radius_accounting_servers_responses"] = None
            __props__.__dict__["radius_servers_responses"] = None
        super(SwitchAccessPolicies, __self__).__init__(
            'meraki:networks/switchAccessPolicies:SwitchAccessPolicies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_number: Optional[pulumi.Input[_builtins.str]] = None,
            access_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            counts: Optional[pulumi.Input[Union['SwitchAccessPoliciesCountsArgs', 'SwitchAccessPoliciesCountsArgsDict']]] = None,
            dot1x: Optional[pulumi.Input[Union['SwitchAccessPoliciesDot1xArgs', 'SwitchAccessPoliciesDot1xArgsDict']]] = None,
            guest_port_bouncing: Optional[pulumi.Input[_builtins.bool]] = None,
            guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
            host_mode: Optional[pulumi.Input[_builtins.str]] = None,
            increase_access_speed: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            radius: Optional[pulumi.Input[Union['SwitchAccessPoliciesRadiusArgs', 'SwitchAccessPoliciesRadiusArgsDict']]] = None,
            radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusAccountingServerArgs', 'SwitchAccessPoliciesRadiusAccountingServerArgsDict']]]]] = None,
            radius_accounting_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusAccountingServersResponseArgs', 'SwitchAccessPoliciesRadiusAccountingServersResponseArgsDict']]]]] = None,
            radius_coa_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusServerArgs', 'SwitchAccessPoliciesRadiusServerArgsDict']]]]] = None,
            radius_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusServersResponseArgs', 'SwitchAccessPoliciesRadiusServersResponseArgsDict']]]]] = None,
            radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            url_redirect_walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            url_redirect_walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            voice_vlan_clients: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SwitchAccessPolicies':
        """
        Get an existing SwitchAccessPolicies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy_number: accessPolicyNumber path parameter. Access policy number
        :param pulumi.Input[_builtins.str] access_policy_type: Access Type of the policy. Automatically 'Hybrid authentication' when hostMode is 'Multi-Domain'.
        :param pulumi.Input[Union['SwitchAccessPoliciesCountsArgs', 'SwitchAccessPoliciesCountsArgsDict']] counts: Counts associated with the access policy
        :param pulumi.Input[Union['SwitchAccessPoliciesDot1xArgs', 'SwitchAccessPoliciesDot1xArgsDict']] dot1x: 802.1x Settings
        :param pulumi.Input[_builtins.bool] guest_port_bouncing: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.int] guest_vlan_id: ID for the guest VLAN allow unauthorized devices access to limited network resources
        :param pulumi.Input[_builtins.str] host_mode: Choose the Host Mode for the access policy.
        :param pulumi.Input[_builtins.bool] increase_access_speed: Enabling this option will make switches execute 802.1X and MAC-bypass authentication simultaneously so that clients authenticate faster. Only required when accessPolicyType is 'Hybrid Authentication.
        :param pulumi.Input[_builtins.str] name: Name of the access policy
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['SwitchAccessPoliciesRadiusArgs', 'SwitchAccessPoliciesRadiusArgsDict']] radius: Object for RADIUS Settings
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Enable to send start, interim-update and stop messages to a configured RADIUS accounting server for tracking connected clients
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusAccountingServerArgs', 'SwitchAccessPoliciesRadiusAccountingServerArgsDict']]]] radius_accounting_servers: List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusAccountingServersResponseArgs', 'SwitchAccessPoliciesRadiusAccountingServersResponseArgsDict']]]] radius_accounting_servers_responses: List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_coa_support_enabled: Change of authentication for RADIUS re-authentication and disconnection
        :param pulumi.Input[_builtins.str] radius_group_attribute: Acceptable values are *""* for None, or *"11"* for Group Policies ACL
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusServerArgs', 'SwitchAccessPoliciesRadiusServerArgsDict']]]] radius_servers: List of RADIUS servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchAccessPoliciesRadiusServersResponseArgs', 'SwitchAccessPoliciesRadiusServersResponseArgsDict']]]] radius_servers_responses: List of RADIUS servers to require connecting devices to authenticate against before granting network access
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        :param pulumi.Input[_builtins.bool] url_redirect_walled_garden_enabled: Enable to restrict access for clients to a response_objectific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] url_redirect_walled_garden_ranges: IP address ranges, in CIDR notation, to restrict access for clients to a specific set of IP addresses or hostnames prior to authentication
        :param pulumi.Input[_builtins.bool] voice_vlan_clients: CDP/LLDP capable voice clients will be able to use this VLAN. Automatically true when hostMode is 'Multi-Domain'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchAccessPoliciesState.__new__(_SwitchAccessPoliciesState)

        __props__.__dict__["access_policy_number"] = access_policy_number
        __props__.__dict__["access_policy_type"] = access_policy_type
        __props__.__dict__["counts"] = counts
        __props__.__dict__["dot1x"] = dot1x
        __props__.__dict__["guest_port_bouncing"] = guest_port_bouncing
        __props__.__dict__["guest_vlan_id"] = guest_vlan_id
        __props__.__dict__["host_mode"] = host_mode
        __props__.__dict__["increase_access_speed"] = increase_access_speed
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["radius"] = radius
        __props__.__dict__["radius_accounting_enabled"] = radius_accounting_enabled
        __props__.__dict__["radius_accounting_servers"] = radius_accounting_servers
        __props__.__dict__["radius_accounting_servers_responses"] = radius_accounting_servers_responses
        __props__.__dict__["radius_coa_support_enabled"] = radius_coa_support_enabled
        __props__.__dict__["radius_group_attribute"] = radius_group_attribute
        __props__.__dict__["radius_servers"] = radius_servers
        __props__.__dict__["radius_servers_responses"] = radius_servers_responses
        __props__.__dict__["radius_testing_enabled"] = radius_testing_enabled
        __props__.__dict__["url_redirect_walled_garden_enabled"] = url_redirect_walled_garden_enabled
        __props__.__dict__["url_redirect_walled_garden_ranges"] = url_redirect_walled_garden_ranges
        __props__.__dict__["voice_vlan_clients"] = voice_vlan_clients
        return SwitchAccessPolicies(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> pulumi.Output[_builtins.str]:
        """
        accessPolicyNumber path parameter. Access policy number
        """
        return pulumi.get(self, "access_policy_number")

    @_builtins.property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> pulumi.Output[_builtins.str]:
        """
        Access Type of the policy. Automatically 'Hybrid authentication' when hostMode is 'Multi-Domain'.
        """
        return pulumi.get(self, "access_policy_type")

    @_builtins.property
    @pulumi.getter
    def counts(self) -> pulumi.Output['outputs.SwitchAccessPoliciesCounts']:
        """
        Counts associated with the access policy
        """
        return pulumi.get(self, "counts")

    @_builtins.property
    @pulumi.getter
    def dot1x(self) -> pulumi.Output['outputs.SwitchAccessPoliciesDot1x']:
        """
        802.1x Settings
        """
        return pulumi.get(self, "dot1x")

    @_builtins.property
    @pulumi.getter(name="guestPortBouncing")
    def guest_port_bouncing(self) -> pulumi.Output[_builtins.bool]:
        """
        If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        """
        return pulumi.get(self, "guest_port_bouncing")

    @_builtins.property
    @pulumi.getter(name="guestVlanId")
    def guest_vlan_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        ID for the guest VLAN allow unauthorized devices access to limited network resources
        """
        return pulumi.get(self, "guest_vlan_id")

    @_builtins.property
    @pulumi.getter(name="hostMode")
    def host_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Choose the Host Mode for the access policy.
        """
        return pulumi.get(self, "host_mode")

    @_builtins.property
    @pulumi.getter(name="increaseAccessSpeed")
    def increase_access_speed(self) -> pulumi.Output[_builtins.bool]:
        """
        Enabling this option will make switches execute 802.1X and MAC-bypass authentication simultaneously so that clients authenticate faster. Only required when accessPolicyType is 'Hybrid Authentication.
        """
        return pulumi.get(self, "increase_access_speed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the access policy
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def radius(self) -> pulumi.Output['outputs.SwitchAccessPoliciesRadius']:
        """
        Object for RADIUS Settings
        """
        return pulumi.get(self, "radius")

    @_builtins.property
    @pulumi.getter(name="radiusAccountingEnabled")
    def radius_accounting_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable to send start, interim-update and stop messages to a configured RADIUS accounting server for tracking connected clients
        """
        return pulumi.get(self, "radius_accounting_enabled")

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServers")
    def radius_accounting_servers(self) -> pulumi.Output[Optional[Sequence['outputs.SwitchAccessPoliciesRadiusAccountingServer']]]:
        """
        List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_accounting_servers")

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServersResponses")
    def radius_accounting_servers_responses(self) -> pulumi.Output[Sequence['outputs.SwitchAccessPoliciesRadiusAccountingServersResponse']]:
        """
        List of RADIUS accounting servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_accounting_servers_responses")

    @_builtins.property
    @pulumi.getter(name="radiusCoaSupportEnabled")
    def radius_coa_support_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Change of authentication for RADIUS re-authentication and disconnection
        """
        return pulumi.get(self, "radius_coa_support_enabled")

    @_builtins.property
    @pulumi.getter(name="radiusGroupAttribute")
    def radius_group_attribute(self) -> pulumi.Output[_builtins.str]:
        """
        Acceptable values are *""* for None, or *"11"* for Group Policies ACL
        """
        return pulumi.get(self, "radius_group_attribute")

    @_builtins.property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> pulumi.Output[Optional[Sequence['outputs.SwitchAccessPoliciesRadiusServer']]]:
        """
        List of RADIUS servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_servers")

    @_builtins.property
    @pulumi.getter(name="radiusServersResponses")
    def radius_servers_responses(self) -> pulumi.Output[Sequence['outputs.SwitchAccessPoliciesRadiusServersResponse']]:
        """
        List of RADIUS servers to require connecting devices to authenticate against before granting network access
        """
        return pulumi.get(self, "radius_servers_responses")

    @_builtins.property
    @pulumi.getter(name="radiusTestingEnabled")
    def radius_testing_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If enabled, Meraki devices will periodically send access-request messages to these RADIUS servers
        """
        return pulumi.get(self, "radius_testing_enabled")

    @_builtins.property
    @pulumi.getter(name="urlRedirectWalledGardenEnabled")
    def url_redirect_walled_garden_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable to restrict access for clients to a response_objectific set of IP addresses or hostnames prior to authentication
        """
        return pulumi.get(self, "url_redirect_walled_garden_enabled")

    @_builtins.property
    @pulumi.getter(name="urlRedirectWalledGardenRanges")
    def url_redirect_walled_garden_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        IP address ranges, in CIDR notation, to restrict access for clients to a specific set of IP addresses or hostnames prior to authentication
        """
        return pulumi.get(self, "url_redirect_walled_garden_ranges")

    @_builtins.property
    @pulumi.getter(name="voiceVlanClients")
    def voice_vlan_clients(self) -> pulumi.Output[_builtins.bool]:
        """
        CDP/LLDP capable voice clients will be able to use this VLAN. Automatically true when hostMode is 'Multi-Domain'.
        """
        return pulumi.get(self, "voice_vlan_clients")

