# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDevicesItemResult',
    'GetDevicesItemDetailResult',
    'GetNetworksItemResult',
    'GetOrganizationsItemResult',
    'GetOrganizationsItemApiResult',
    'GetOrganizationsItemCloudResult',
    'GetOrganizationsItemCloudRegionResult',
    'GetOrganizationsItemLicensingResult',
    'GetOrganizationsItemManagementResult',
    'GetOrganizationsItemManagementDetailResult',
]

@pulumi.output_type
class GetDevicesItemResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 details: Sequence['outputs.GetDevicesItemDetailResult'],
                 firmware: _builtins.str,
                 imei: _builtins.float,
                 lan_ip: _builtins.str,
                 lat: _builtins.float,
                 lng: _builtins.float,
                 mac: _builtins.str,
                 model: _builtins.str,
                 name: _builtins.str,
                 network_id: _builtins.str,
                 notes: _builtins.str,
                 product_type: _builtins.str,
                 serial: _builtins.str,
                 tags: Sequence[_builtins.str]):
        """
        :param _builtins.str address: Physical address of the device
        :param Sequence['GetDevicesItemDetailArgs'] details: Additional device information
        :param _builtins.str firmware: Firmware version of the device
        :param _builtins.float imei: IMEI of the device, if applicable
        :param _builtins.str lan_ip: LAN IP address of the device
        :param _builtins.float lat: Latitude of the device
        :param _builtins.float lng: Longitude of the device
        :param _builtins.str mac: MAC address of the device
        :param _builtins.str model: Model of the device
        :param _builtins.str name: Name of the device
        :param _builtins.str network_id: ID of the network the device belongs to
        :param _builtins.str notes: Notes for the device, limited to 255 characters
        :param _builtins.str product_type: Product type of the device
        :param _builtins.str serial: Serial number of the device
        :param Sequence[_builtins.str] tags: List of tags assigned to the device
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "firmware", firmware)
        pulumi.set(__self__, "imei", imei)
        pulumi.set(__self__, "lan_ip", lan_ip)
        pulumi.set(__self__, "lat", lat)
        pulumi.set(__self__, "lng", lng)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "notes", notes)
        pulumi.set(__self__, "product_type", product_type)
        pulumi.set(__self__, "serial", serial)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Physical address of the device
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetDevicesItemDetailResult']:
        """
        Additional device information
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def firmware(self) -> _builtins.str:
        """
        Firmware version of the device
        """
        return pulumi.get(self, "firmware")

    @_builtins.property
    @pulumi.getter
    def imei(self) -> _builtins.float:
        """
        IMEI of the device, if applicable
        """
        return pulumi.get(self, "imei")

    @_builtins.property
    @pulumi.getter(name="lanIp")
    def lan_ip(self) -> _builtins.str:
        """
        LAN IP address of the device
        """
        return pulumi.get(self, "lan_ip")

    @_builtins.property
    @pulumi.getter
    def lat(self) -> _builtins.float:
        """
        Latitude of the device
        """
        return pulumi.get(self, "lat")

    @_builtins.property
    @pulumi.getter
    def lng(self) -> _builtins.float:
        """
        Longitude of the device
        """
        return pulumi.get(self, "lng")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> _builtins.str:
        """
        MAC address of the device
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter
    def model(self) -> _builtins.str:
        """
        Model of the device
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the device
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        ID of the network the device belongs to
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> _builtins.str:
        """
        Notes for the device, limited to 255 characters
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> _builtins.str:
        """
        Product type of the device
        """
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> _builtins.str:
        """
        Serial number of the device
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags assigned to the device
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDevicesItemDetailResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Additional property name
        :param _builtins.str value: Additional property value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Additional property name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Additional property value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNetworksItemResult(dict):
    def __init__(__self__, *,
                 enrollment_string: _builtins.str,
                 id: _builtins.str,
                 is_bound_to_config_template: _builtins.bool,
                 name: _builtins.str,
                 notes: _builtins.str,
                 organization_id: _builtins.str,
                 product_types: Sequence[_builtins.str],
                 tags: Sequence[_builtins.str],
                 time_zone: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str enrollment_string: Enrollment string for the network
        :param _builtins.str id: Network ID
        :param _builtins.bool is_bound_to_config_template: If the network is bound to a config template
        :param _builtins.str name: Network name
        :param _builtins.str notes: Notes for the network
        :param _builtins.str organization_id: Organization ID
        :param Sequence[_builtins.str] product_types: List of the product types that the network supports
        :param Sequence[_builtins.str] tags: Network tags
        :param _builtins.str time_zone: Timezone of the network
        :param _builtins.str url: URL to the network Dashboard UI
        """
        pulumi.set(__self__, "enrollment_string", enrollment_string)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_bound_to_config_template", is_bound_to_config_template)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notes", notes)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "product_types", product_types)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="enrollmentString")
    def enrollment_string(self) -> _builtins.str:
        """
        Enrollment string for the network
        """
        return pulumi.get(self, "enrollment_string")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Network ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isBoundToConfigTemplate")
    def is_bound_to_config_template(self) -> _builtins.bool:
        """
        If the network is bound to a config template
        """
        return pulumi.get(self, "is_bound_to_config_template")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Network name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> _builtins.str:
        """
        Notes for the network
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Sequence[_builtins.str]:
        """
        List of the product types that the network supports
        """
        return pulumi.get(self, "product_types")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Network tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        Timezone of the network
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL to the network Dashboard UI
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetOrganizationsItemResult(dict):
    def __init__(__self__, *,
                 api: 'outputs.GetOrganizationsItemApiResult',
                 cloud: 'outputs.GetOrganizationsItemCloudResult',
                 id: _builtins.str,
                 licensing: 'outputs.GetOrganizationsItemLicensingResult',
                 management: 'outputs.GetOrganizationsItemManagementResult',
                 name: _builtins.str,
                 url: _builtins.str):
        """
        :param 'GetOrganizationsItemApiArgs' api: API related settings
        :param 'GetOrganizationsItemCloudArgs' cloud: Data for this organization
        :param _builtins.str id: Organization ID
        :param 'GetOrganizationsItemLicensingArgs' licensing: Licensing related settings
        :param 'GetOrganizationsItemManagementArgs' management: Information about the organization's management system
        :param _builtins.str name: Organization name
        :param _builtins.str url: Organization URL
        """
        pulumi.set(__self__, "api", api)
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "licensing", licensing)
        pulumi.set(__self__, "management", management)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def api(self) -> 'outputs.GetOrganizationsItemApiResult':
        """
        API related settings
        """
        return pulumi.get(self, "api")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> 'outputs.GetOrganizationsItemCloudResult':
        """
        Data for this organization
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Organization ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def licensing(self) -> 'outputs.GetOrganizationsItemLicensingResult':
        """
        Licensing related settings
        """
        return pulumi.get(self, "licensing")

    @_builtins.property
    @pulumi.getter
    def management(self) -> 'outputs.GetOrganizationsItemManagementResult':
        """
        Information about the organization's management system
        """
        return pulumi.get(self, "management")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Organization name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Organization URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetOrganizationsItemApiResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Enable API access
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable API access
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetOrganizationsItemCloudResult(dict):
    def __init__(__self__, *,
                 region: 'outputs.GetOrganizationsItemCloudRegionResult'):
        """
        :param 'GetOrganizationsItemCloudRegionArgs' region: Region info
        """
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def region(self) -> 'outputs.GetOrganizationsItemCloudRegionResult':
        """
        Region info
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetOrganizationsItemCloudRegionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Name of region
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of region
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetOrganizationsItemLicensingResult(dict):
    def __init__(__self__, *,
                 model: _builtins.str):
        """
        :param _builtins.str model: Organization licensing model. Can be 'co-term', 'per-device', or 'subscription'.
        """
        pulumi.set(__self__, "model", model)

    @_builtins.property
    @pulumi.getter
    def model(self) -> _builtins.str:
        """
        Organization licensing model. Can be 'co-term', 'per-device', or 'subscription'.
        """
        return pulumi.get(self, "model")


@pulumi.output_type
class GetOrganizationsItemManagementResult(dict):
    def __init__(__self__, *,
                 details: Sequence['outputs.GetOrganizationsItemManagementDetailResult']):
        """
        :param Sequence['GetOrganizationsItemManagementDetailArgs'] details: Details related to organization management, possibly empty. Details may be named 'MSP ID', 'IP restriction mode for API', or 'IP restriction mode for dashboard', if the organization admin has configured any.
        """
        pulumi.set(__self__, "details", details)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetOrganizationsItemManagementDetailResult']:
        """
        Details related to organization management, possibly empty. Details may be named 'MSP ID', 'IP restriction mode for API', or 'IP restriction mode for dashboard', if the organization admin has configured any.
        """
        return pulumi.get(self, "details")


@pulumi.output_type
class GetOrganizationsItemManagementDetailResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of management data
        :param _builtins.str value: Value of management data
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of management data
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of management data
        """
        return pulumi.get(self, "value")


