# collibra-catalog_cloud_ingestions_100
<p>The Catalog Cloud Ingestions API offers functionality related to the catalog product.<br/> It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product. </p>

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import collibra_catalog_cloud_ingestions 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import collibra_catalog_cloud_ingestions
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import collibra_catalog_cloud_ingestions
from collibra_catalog_cloud_ingestions.rest import ApiException
from pprint import pprint
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
body = collibra_catalog_cloud_ingestions.AddCrawlerRequest() # AddCrawlerRequest |  (optional)

try:
    # Add a crawler
    api_response = api_instance.add_crawler(file_system_type, asset_id, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->add_crawler: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
body = collibra_catalog_cloud_ingestions.AddFileSystemScheduleRequest() # AddFileSystemScheduleRequest |  (optional)

try:
    # Add a synchronization schedule
    api_response = api_instance.add_schedule(file_system_type, asset_id, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->add_schedule: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
body = 'body_example' # str |  (optional)

try:
    # Add a capability
    api_instance.attach_capability(file_system_type, asset_id, body=body)
except ApiException as e:
    print("Exception when calling ADLSApi->attach_capability: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Schedule canceling of cloud synchronization
    api_instance.cancel(file_system_type, asset_id)
except ApiException as e:
    print("Exception when calling ADLSApi->cancel: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
body = collibra_catalog_cloud_ingestions.RemoveCrawlerRequest() # RemoveCrawlerRequest |  (optional)

try:
    # Delete a crawler
    api_instance.delete_crawler(file_system_type, asset_id, body=body)
except ApiException as e:
    print("Exception when calling ADLSApi->delete_crawler: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Delete a synchronization schedule
    api_instance.delete_schedule(file_system_type, asset_id)
except ApiException as e:
    print("Exception when calling ADLSApi->delete_schedule: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Remove a capability
    api_instance.detach_capability(file_system_type, asset_id)
except ApiException as e:
    print("Exception when calling ADLSApi->detach_capability: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
capability_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str |  (optional)

try:
    # Find filesystem assets that have the given Edge capability attached
    api_response = api_instance.find_filesystem_asset_ids_for_capability(capability_id=capability_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->find_filesystem_asset_ids_for_capability: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve a capability
    api_response = api_instance.get_attached_capability_id(file_system_type, asset_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->get_attached_capability_id: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # List crawlers
    api_response = api_instance.get_crawlers(file_system_type, asset_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->get_crawlers: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve a synchronization schedule
    api_response = api_instance.get_schedule(file_system_type, asset_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->get_schedule: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Synchronize a file system
    api_response = api_instance.synchronize_file_system(file_system_type, asset_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->synchronize_file_system: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
body = collibra_catalog_cloud_ingestions.UpdateCrawlerRequest() # UpdateCrawlerRequest |  (optional)

try:
    # Update a crawler
    api_response = api_instance.update_crawler(file_system_type, asset_id, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->update_crawler: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = collibra_catalog_cloud_ingestions.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = collibra_catalog_cloud_ingestions.ADLSApi(collibra_catalog_cloud_ingestions.ApiClient(configuration))
file_system_type = 'file_system_type_example' # str | 
asset_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
body = collibra_catalog_cloud_ingestions.ChangeFileSystemScheduleRequest() # ChangeFileSystemScheduleRequest |  (optional)

try:
    # Update a synchronization schedule
    api_response = api_instance.update_schedule(file_system_type, asset_id, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ADLSApi->update_schedule: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */rest/catalog/1.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ADLSApi* | [**add_crawler**](docs/ADLSApi.md#add_crawler) | **POST** /filesystem/{fileSystemType}/{assetId}/crawlers | Add a crawler
*ADLSApi* | [**add_schedule**](docs/ADLSApi.md#add_schedule) | **POST** /filesystem/{fileSystemType}/{assetId}/schedule | Add a synchronization schedule
*ADLSApi* | [**attach_capability**](docs/ADLSApi.md#attach_capability) | **PUT** /filesystem/{fileSystemType}/{assetId}/capability | Add a capability
*ADLSApi* | [**cancel**](docs/ADLSApi.md#cancel) | **DELETE** /filesystem/{fileSystemType}/{assetId}/synchronize | Schedule canceling of cloud synchronization
*ADLSApi* | [**delete_crawler**](docs/ADLSApi.md#delete_crawler) | **DELETE** /filesystem/{fileSystemType}/{assetId}/crawlers | Delete a crawler
*ADLSApi* | [**delete_schedule**](docs/ADLSApi.md#delete_schedule) | **DELETE** /filesystem/{fileSystemType}/{assetId}/schedule | Delete a synchronization schedule
*ADLSApi* | [**detach_capability**](docs/ADLSApi.md#detach_capability) | **DELETE** /filesystem/{fileSystemType}/{assetId}/capability | Remove a capability
*ADLSApi* | [**find_filesystem_asset_ids_for_capability**](docs/ADLSApi.md#find_filesystem_asset_ids_for_capability) | **GET** /filesystem | Find filesystem assets that have the given Edge capability attached
*ADLSApi* | [**get_attached_capability_id**](docs/ADLSApi.md#get_attached_capability_id) | **GET** /filesystem/{fileSystemType}/{assetId}/capability | Retrieve a capability
*ADLSApi* | [**get_crawlers**](docs/ADLSApi.md#get_crawlers) | **GET** /filesystem/{fileSystemType}/{assetId}/crawlers | List crawlers
*ADLSApi* | [**get_schedule**](docs/ADLSApi.md#get_schedule) | **GET** /filesystem/{fileSystemType}/{assetId}/schedule | Retrieve a synchronization schedule
*ADLSApi* | [**synchronize_file_system**](docs/ADLSApi.md#synchronize_file_system) | **POST** /filesystem/{fileSystemType}/{assetId}/synchronize | Synchronize a file system
*ADLSApi* | [**update_crawler**](docs/ADLSApi.md#update_crawler) | **PUT** /filesystem/{fileSystemType}/{assetId}/crawlers | Update a crawler
*ADLSApi* | [**update_schedule**](docs/ADLSApi.md#update_schedule) | **PUT** /filesystem/{fileSystemType}/{assetId}/schedule | Update a synchronization schedule
*GCSApi* | [**add_crawler**](docs/GCSApi.md#add_crawler) | **POST** /filesystem/{fileSystemType}/{assetId}/crawlers | Add a crawler
*GCSApi* | [**add_schedule**](docs/GCSApi.md#add_schedule) | **POST** /filesystem/{fileSystemType}/{assetId}/schedule | Add a synchronization schedule
*GCSApi* | [**attach_capability**](docs/GCSApi.md#attach_capability) | **PUT** /filesystem/{fileSystemType}/{assetId}/capability | Add a capability
*GCSApi* | [**cancel**](docs/GCSApi.md#cancel) | **DELETE** /filesystem/{fileSystemType}/{assetId}/synchronize | Schedule canceling of cloud synchronization
*GCSApi* | [**delete_crawler**](docs/GCSApi.md#delete_crawler) | **DELETE** /filesystem/{fileSystemType}/{assetId}/crawlers | Delete a crawler
*GCSApi* | [**delete_schedule**](docs/GCSApi.md#delete_schedule) | **DELETE** /filesystem/{fileSystemType}/{assetId}/schedule | Delete a synchronization schedule
*GCSApi* | [**detach_capability**](docs/GCSApi.md#detach_capability) | **DELETE** /filesystem/{fileSystemType}/{assetId}/capability | Remove a capability
*GCSApi* | [**find_filesystem_asset_ids_for_capability**](docs/GCSApi.md#find_filesystem_asset_ids_for_capability) | **GET** /filesystem | Find filesystem assets that have the given Edge capability attached
*GCSApi* | [**get_attached_capability_id**](docs/GCSApi.md#get_attached_capability_id) | **GET** /filesystem/{fileSystemType}/{assetId}/capability | Retrieve a capability
*GCSApi* | [**get_crawlers**](docs/GCSApi.md#get_crawlers) | **GET** /filesystem/{fileSystemType}/{assetId}/crawlers | List crawlers
*GCSApi* | [**get_schedule**](docs/GCSApi.md#get_schedule) | **GET** /filesystem/{fileSystemType}/{assetId}/schedule | Retrieve a synchronization schedule
*GCSApi* | [**synchronize_file_system**](docs/GCSApi.md#synchronize_file_system) | **POST** /filesystem/{fileSystemType}/{assetId}/synchronize | Synchronize a file system
*GCSApi* | [**update_crawler**](docs/GCSApi.md#update_crawler) | **PUT** /filesystem/{fileSystemType}/{assetId}/crawlers | Update a crawler
*GCSApi* | [**update_schedule**](docs/GCSApi.md#update_schedule) | **PUT** /filesystem/{fileSystemType}/{assetId}/schedule | Update a synchronization schedule
*GENERICApi* | [**add_generic_schedule**](docs/GENERICApi.md#add_generic_schedule) | **POST** /genericIntegration/{ingestibleId}/schedule | Add a schedule
*GENERICApi* | [**cancel_capability_job**](docs/GENERICApi.md#cancel_capability_job) | **DELETE** /genericIntegration/{ingestibleId}/cancel | Cancel a synchronization
*GENERICApi* | [**delete_config**](docs/GENERICApi.md#delete_config) | **DELETE** /genericIntegration/{ingestibleId}/configuration | Delete a generic configuration
*GENERICApi* | [**delete_generic_schedule**](docs/GENERICApi.md#delete_generic_schedule) | **DELETE** /genericIntegration/{ingestibleId}/schedule | Delete a schedule
*GENERICApi* | [**get_config**](docs/GENERICApi.md#get_config) | **GET** /genericIntegration/{ingestibleId}/configuration | Retrieve a generic configuration
*GENERICApi* | [**get_generic_schedule**](docs/GENERICApi.md#get_generic_schedule) | **GET** /genericIntegration/{ingestibleId}/schedule | Retrieve a schedule
*GENERICApi* | [**get_schema**](docs/GENERICApi.md#get_schema) | **GET** /genericIntegration/{ingestibleId}/configuration/schema | Retrieve data schema as part of generic configuration
*GENERICApi* | [**save_config**](docs/GENERICApi.md#save_config) | **PUT** /genericIntegration/{ingestibleId}/configuration | Create or update a generic configuration
*GENERICApi* | [**start_capability_job**](docs/GENERICApi.md#start_capability_job) | **POST** /genericIntegration/{ingestibleId}/run | Starts capability on Edge.
*GENERICApi* | [**update_generic_schedule**](docs/GENERICApi.md#update_generic_schedule) | **PUT** /genericIntegration/{ingestibleId}/schedule | Update a schedule
*POWERBIApi* | [**cancel**](docs/POWERBIApi.md#cancel) | **DELETE** /filesystem/{fileSystemType}/{assetId}/synchronize | Schedule canceling of cloud synchronization
*POWERBIApi* | [**synchronize_file_system**](docs/POWERBIApi.md#synchronize_file_system) | **POST** /filesystem/{fileSystemType}/{assetId}/synchronize | Synchronize a file system
*S3Api* | [**add_crawler**](docs/S3Api.md#add_crawler) | **POST** /filesystem/{fileSystemType}/{assetId}/crawlers | Add a crawler
*S3Api* | [**add_schedule**](docs/S3Api.md#add_schedule) | **POST** /filesystem/{fileSystemType}/{assetId}/schedule | Add a synchronization schedule
*S3Api* | [**attach_capability**](docs/S3Api.md#attach_capability) | **PUT** /filesystem/{fileSystemType}/{assetId}/capability | Add a capability
*S3Api* | [**cancel**](docs/S3Api.md#cancel) | **DELETE** /filesystem/{fileSystemType}/{assetId}/synchronize | Schedule canceling of cloud synchronization
*S3Api* | [**change_crawler_custom_classifiers**](docs/S3Api.md#change_crawler_custom_classifiers) | **PATCH** /filesystem/s3/{assetId}/crawlers/{crawlerId} | Set the custom classifiers.
*S3Api* | [**delete_crawler**](docs/S3Api.md#delete_crawler) | **DELETE** /filesystem/{fileSystemType}/{assetId}/crawlers | Delete a crawler
*S3Api* | [**delete_schedule**](docs/S3Api.md#delete_schedule) | **DELETE** /filesystem/{fileSystemType}/{assetId}/schedule | Delete a synchronization schedule
*S3Api* | [**detach_capability**](docs/S3Api.md#detach_capability) | **DELETE** /filesystem/{fileSystemType}/{assetId}/capability | Remove a capability
*S3Api* | [**find_filesystem_asset_ids_for_capability**](docs/S3Api.md#find_filesystem_asset_ids_for_capability) | **GET** /filesystem | Find filesystem assets that have the given Edge capability attached
*S3Api* | [**get_attached_capability_id**](docs/S3Api.md#get_attached_capability_id) | **GET** /filesystem/{fileSystemType}/{assetId}/capability | Retrieve a capability
*S3Api* | [**get_crawler_custom_classifiers**](docs/S3Api.md#get_crawler_custom_classifiers) | **GET** /filesystem/s3/{assetId}/crawlers/{crawlerId} | Get the custom classifiers.
*S3Api* | [**get_crawlers**](docs/S3Api.md#get_crawlers) | **GET** /filesystem/{fileSystemType}/{assetId}/crawlers | List crawlers
*S3Api* | [**get_schedule**](docs/S3Api.md#get_schedule) | **GET** /filesystem/{fileSystemType}/{assetId}/schedule | Retrieve a synchronization schedule
*S3Api* | [**synchronize_file_system**](docs/S3Api.md#synchronize_file_system) | **POST** /filesystem/{fileSystemType}/{assetId}/synchronize | Synchronize a file system
*S3Api* | [**synchronize_s3_file_system**](docs/S3Api.md#synchronize_s3_file_system) | **POST** /filesystem/s3/{assetId}/synchronize/jobserver | Asynchronously synchronizes an S3 File System.
*S3Api* | [**update_crawler**](docs/S3Api.md#update_crawler) | **PUT** /filesystem/{fileSystemType}/{assetId}/crawlers | Update a crawler
*S3Api* | [**update_schedule**](docs/S3Api.md#update_schedule) | **PUT** /filesystem/{fileSystemType}/{assetId}/schedule | Update a synchronization schedule
*TABLEAUApi* | [**attach_capability**](docs/TABLEAUApi.md#attach_capability) | **PUT** /filesystem/{fileSystemType}/{assetId}/capability | Add a capability
*TABLEAUApi* | [**cancel**](docs/TABLEAUApi.md#cancel) | **DELETE** /filesystem/{fileSystemType}/{assetId}/synchronize | Schedule canceling of cloud synchronization
*TABLEAUApi* | [**detach_capability**](docs/TABLEAUApi.md#detach_capability) | **DELETE** /filesystem/{fileSystemType}/{assetId}/capability | Remove a capability
*TABLEAUApi* | [**find_filesystem_asset_ids_for_capability**](docs/TABLEAUApi.md#find_filesystem_asset_ids_for_capability) | **GET** /filesystem | Find filesystem assets that have the given Edge capability attached
*TABLEAUApi* | [**get_attached_capability_id**](docs/TABLEAUApi.md#get_attached_capability_id) | **GET** /filesystem/{fileSystemType}/{assetId}/capability | Retrieve a capability
*TABLEAUApi* | [**synchronize_file_system**](docs/TABLEAUApi.md#synchronize_file_system) | **POST** /filesystem/{fileSystemType}/{assetId}/synchronize | Synchronize a file system

## Documentation For Models

 - [AddCrawlerRequest](docs/AddCrawlerRequest.md)
 - [AddFileSystemScheduleRequest](docs/AddFileSystemScheduleRequest.md)
 - [AddGenericScheduleRequest](docs/AddGenericScheduleRequest.md)
 - [ChangeFileSystemScheduleRequest](docs/ChangeFileSystemScheduleRequest.md)
 - [ChangeGenericScheduleRequest](docs/ChangeGenericScheduleRequest.md)
 - [Crawler](docs/Crawler.md)
 - [CrawlerIncludePath](docs/CrawlerIncludePath.md)
 - [CrawlerIncludePathRequest](docs/CrawlerIncludePathRequest.md)
 - [GenericConfiguration](docs/GenericConfiguration.md)
 - [Job](docs/Job.md)
 - [RemoveCrawlerRequest](docs/RemoveCrawlerRequest.md)
 - [SaveGenericConfigRequest](docs/SaveGenericConfigRequest.md)
 - [Schedule](docs/Schedule.md)
 - [UpdateCrawlerCustomClassifiersRequest](docs/UpdateCrawlerCustomClassifiersRequest.md)
 - [UpdateCrawlerRequest](docs/UpdateCrawlerRequest.md)

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author


