# coding: utf-8

"""
    Collibra Catalog Cloud Ingestions API

    <p>The Catalog Cloud Ingestions API offers functionality related to the catalog product.<br/> It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product. </p>  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_catalog_cloud_ingestions.api_client import ApiClient


class GCSApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_crawler(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a crawler  # noqa: E501

        Adds a new crawler definition to the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_crawler(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param AddCrawlerRequest body:
        :return: Crawler
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_crawler_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_crawler_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def add_crawler_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a crawler  # noqa: E501

        Adds a new crawler definition to the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_crawler_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param AddCrawlerRequest body:
        :return: Crawler
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_crawler" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `add_crawler`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_crawler`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/crawlers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Crawler',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_schedule(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a synchronization schedule  # noqa: E501

        Adds a synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_schedule(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param AddFileSystemScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def add_schedule_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a synchronization schedule  # noqa: E501

        Adds a synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_schedule_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param AddFileSystemScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `add_schedule`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `add_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/schedule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def attach_capability(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a capability  # noqa: E501

        Adds a capability to the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_capability(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param str body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.attach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.attach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def attach_capability_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a capability  # noqa: E501

        Adds a capability to the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_capability_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param str body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attach_capability" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `attach_capability`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `attach_capability`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/capability', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Schedule canceling of cloud synchronization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def cancel_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Schedule canceling of cloud synchronization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `cancel`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `cancel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/synchronize', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_crawler(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Delete a crawler  # noqa: E501

        Deletes a crawler definition from the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_crawler(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param RemoveCrawlerRequest body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_crawler_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_crawler_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def delete_crawler_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Delete a crawler  # noqa: E501

        Deletes a crawler definition from the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_crawler_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param RemoveCrawlerRequest body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_crawler" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `delete_crawler`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `delete_crawler`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/crawlers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_schedule(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Delete a synchronization schedule  # noqa: E501

        Deletes a synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_schedule(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def delete_schedule_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Delete a synchronization schedule  # noqa: E501

        Deletes a synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_schedule_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `delete_schedule`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `delete_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/schedule', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def detach_capability(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Remove a capability  # noqa: E501

        Removes a capability from the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detach_capability(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.detach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.detach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def detach_capability_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Remove a capability  # noqa: E501

        Removes a capability from the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detach_capability_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method detach_capability" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `detach_capability`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `detach_capability`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/capability', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_filesystem_asset_ids_for_capability(self, **kwargs):  # noqa: E501
        """Find filesystem assets that have the given Edge capability attached  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_filesystem_asset_ids_for_capability(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str capability_id:
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_filesystem_asset_ids_for_capability_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_filesystem_asset_ids_for_capability_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_filesystem_asset_ids_for_capability_with_http_info(self, **kwargs):  # noqa: E501
        """Find filesystem assets that have the given Edge capability attached  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_filesystem_asset_ids_for_capability_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str capability_id:
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['capability_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_filesystem_asset_ids_for_capability" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'capability_id' in params:
            query_params.append(('capabilityId', params['capability_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_attached_capability_id(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Retrieve a capability  # noqa: E501

        Returns the capability of the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attached_capability_id(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_attached_capability_id_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_attached_capability_id_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def get_attached_capability_id_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Retrieve a capability  # noqa: E501

        Returns the capability of the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attached_capability_id_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attached_capability_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `get_attached_capability_id`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_attached_capability_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/capability', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawlers(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """List crawlers  # noqa: E501

        Returns a list of crawlers that are defined for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawlers(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: list[Crawler]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawlers_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawlers_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def get_crawlers_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """List crawlers  # noqa: E501

        Returns a list of crawlers that are defined for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawlers_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: list[Crawler]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawlers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `get_crawlers`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_crawlers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/crawlers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Crawler]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_schedule(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Retrieve a synchronization schedule  # noqa: E501

        Returns the synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedule(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def get_schedule_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Retrieve a synchronization schedule  # noqa: E501

        Returns the synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schedule_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `get_schedule`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/schedule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def synchronize_file_system(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Synchronize a file system  # noqa: E501

        Starts an asynchronous Edge synchronization job for the file system or capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.synchronize_file_system(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.synchronize_file_system_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.synchronize_file_system_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def synchronize_file_system_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Synchronize a file system  # noqa: E501

        Starts an asynchronous Edge synchronization job for the file system or capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.synchronize_file_system_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method synchronize_file_system" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `synchronize_file_system`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `synchronize_file_system`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/synchronize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_crawler(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Update a crawler  # noqa: E501

        Updates a crawler definition for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crawler(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param UpdateCrawlerRequest body:
        :return: Crawler
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_crawler_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_crawler_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def update_crawler_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Update a crawler  # noqa: E501

        Updates a crawler definition for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_crawler_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param UpdateCrawlerRequest body:
        :return: Crawler
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_crawler" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `update_crawler`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `update_crawler`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/crawlers', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Crawler',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_schedule(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Update a synchronization schedule  # noqa: E501

        Updates a synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_schedule(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param ChangeFileSystemScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_schedule_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def update_schedule_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Update a synchronization schedule  # noqa: E501

        Updates a synchronization schedule for the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_schedule_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param ChangeFileSystemScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `update_schedule`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `update_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/schedule', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
