# coding: utf-8

"""
    Collibra Catalog Cloud Ingestions API

    <p>The Catalog Cloud Ingestions API offers functionality related to the catalog product.<br/> It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product. </p>  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_catalog_cloud_ingestions.api_client import ApiClient


class GENERICApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_generic_schedule(self, ingestible_id, **kwargs):  # noqa: E501
        """Add a schedule  # noqa: E501

        Adds a schedule for the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_generic_schedule(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :param AddGenericScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def add_generic_schedule_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Add a schedule  # noqa: E501

        Adds a schedule for the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_generic_schedule_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :param AddGenericScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_generic_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `add_generic_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/schedule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_capability_job(self, ingestible_id, **kwargs):  # noqa: E501
        """Cancel a synchronization  # noqa: E501

        Cancel the synchronization of the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_capability_job(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_capability_job_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_capability_job_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def cancel_capability_job_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Cancel a synchronization  # noqa: E501

        Cancel the synchronization of the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_capability_job_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_capability_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `cancel_capability_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/cancel', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_config(self, ingestible_id, **kwargs):  # noqa: E501
        """Delete a generic configuration  # noqa: E501

        Deletes a generic configuration from the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_config(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: GenericConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_config_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_config_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def delete_config_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Delete a generic configuration  # noqa: E501

        Deletes a generic configuration from the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_config_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: GenericConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `delete_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/configuration', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericConfiguration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_generic_schedule(self, ingestible_id, **kwargs):  # noqa: E501
        """Delete a schedule  # noqa: E501

        Deletes the schedule from the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_generic_schedule(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def delete_generic_schedule_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Delete a schedule  # noqa: E501

        Deletes the schedule from the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_generic_schedule_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_generic_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `delete_generic_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/schedule', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config(self, ingestible_id, **kwargs):  # noqa: E501
        """Retrieve a generic configuration  # noqa: E501

        Returns the generic configuration for the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: GenericConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_config_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def get_config_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Retrieve a generic configuration  # noqa: E501

        Returns the generic configuration for the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: GenericConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `get_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/configuration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericConfiguration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_generic_schedule(self, ingestible_id, **kwargs):  # noqa: E501
        """Retrieve a schedule  # noqa: E501

        Returns the schedule for the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_generic_schedule(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def get_generic_schedule_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Retrieve a schedule  # noqa: E501

        Returns the schedule for the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_generic_schedule_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_generic_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `get_generic_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/schedule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_schema(self, ingestible_id, **kwargs):  # noqa: E501
        """Retrieve data schema as part of generic configuration  # noqa: E501

        Returns data schema for the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schema(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_schema_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_schema_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def get_schema_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Retrieve data schema as part of generic configuration  # noqa: E501

        Returns data schema for the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schema_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schema" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `get_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/configuration/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_config(self, body, ingestible_id, **kwargs):  # noqa: E501
        """Create or update a generic configuration  # noqa: E501

        Creates or updates a generic configuration for the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_config(body, ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SaveGenericConfigRequest body: Generic configuration to save. (required)
        :param str ingestible_id: (required)
        :return: GenericConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_config_with_http_info(body, ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.save_config_with_http_info(body, ingestible_id, **kwargs)  # noqa: E501
            return data

    def save_config_with_http_info(self, body, ingestible_id, **kwargs):  # noqa: E501
        """Create or update a generic configuration  # noqa: E501

        Creates or updates a generic configuration for the integration instance with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_config_with_http_info(body, ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SaveGenericConfigRequest body: Generic configuration to save. (required)
        :param str ingestible_id: (required)
        :return: GenericConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_config`")  # noqa: E501
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `save_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/configuration', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericConfiguration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_capability_job(self, ingestible_id, **kwargs):  # noqa: E501
        """Starts capability on Edge.  # noqa: E501

        Starts an Edge based capability job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_capability_job(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_capability_job_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.start_capability_job_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def start_capability_job_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Starts capability on Edge.  # noqa: E501

        Starts an Edge based capability job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_capability_job_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_capability_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `start_capability_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/run', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_generic_schedule(self, ingestible_id, **kwargs):  # noqa: E501
        """Update a schedule  # noqa: E501

        Updates the schedule for the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_generic_schedule(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :param ChangeGenericScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_generic_schedule_with_http_info(ingestible_id, **kwargs)  # noqa: E501
            return data

    def update_generic_schedule_with_http_info(self, ingestible_id, **kwargs):  # noqa: E501
        """Update a schedule  # noqa: E501

        Updates the schedule for the generic Edge capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_generic_schedule_with_http_info(ingestible_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ingestible_id: (required)
        :param ChangeGenericScheduleRequest body:
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ingestible_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_generic_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ingestible_id' is set
        if ('ingestible_id' not in params or
                params['ingestible_id'] is None):
            raise ValueError("Missing the required parameter `ingestible_id` when calling `update_generic_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ingestible_id' in params:
            path_params['ingestibleId'] = params['ingestible_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/genericIntegration/{ingestibleId}/schedule', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Schedule',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
