# coding: utf-8

"""
    Collibra Catalog Cloud Ingestions API

    <p>The Catalog Cloud Ingestions API offers functionality related to the catalog product.<br/> It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product. </p>  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_catalog_cloud_ingestions.api_client import ApiClient


class TABLEAUApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def attach_capability(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a capability  # noqa: E501

        Adds a capability to the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_capability(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param str body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.attach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.attach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def attach_capability_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Add a capability  # noqa: E501

        Adds a capability to the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_capability_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :param str body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attach_capability" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `attach_capability`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `attach_capability`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/capability', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Schedule canceling of cloud synchronization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def cancel_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Schedule canceling of cloud synchronization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `cancel`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `cancel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/synchronize', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def detach_capability(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Remove a capability  # noqa: E501

        Removes a capability from the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detach_capability(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.detach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.detach_capability_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def detach_capability_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Remove a capability  # noqa: E501

        Removes a capability from the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detach_capability_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method detach_capability" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `detach_capability`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `detach_capability`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/capability', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_filesystem_asset_ids_for_capability(self, **kwargs):  # noqa: E501
        """Find filesystem assets that have the given Edge capability attached  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_filesystem_asset_ids_for_capability(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str capability_id:
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_filesystem_asset_ids_for_capability_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_filesystem_asset_ids_for_capability_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_filesystem_asset_ids_for_capability_with_http_info(self, **kwargs):  # noqa: E501
        """Find filesystem assets that have the given Edge capability attached  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_filesystem_asset_ids_for_capability_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str capability_id:
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['capability_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_filesystem_asset_ids_for_capability" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'capability_id' in params:
            query_params.append(('capabilityId', params['capability_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_attached_capability_id(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Retrieve a capability  # noqa: E501

        Returns the capability of the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attached_capability_id(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_attached_capability_id_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_attached_capability_id_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def get_attached_capability_id_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Retrieve a capability  # noqa: E501

        Returns the capability of the file system with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attached_capability_id_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attached_capability_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `get_attached_capability_id`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_attached_capability_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/capability', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def synchronize_file_system(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Synchronize a file system  # noqa: E501

        Starts an asynchronous Edge synchronization job for the file system or capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.synchronize_file_system(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.synchronize_file_system_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.synchronize_file_system_with_http_info(file_system_type, asset_id, **kwargs)  # noqa: E501
            return data

    def synchronize_file_system_with_http_info(self, file_system_type, asset_id, **kwargs):  # noqa: E501
        """Synchronize a file system  # noqa: E501

        Starts an asynchronous Edge synchronization job for the file system or capability with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.synchronize_file_system_with_http_info(file_system_type, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_system_type: (required)
        :param str asset_id: (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_system_type', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method synchronize_file_system" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_system_type' is set
        if ('file_system_type' not in params or
                params['file_system_type'] is None):
            raise ValueError("Missing the required parameter `file_system_type` when calling `synchronize_file_system`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `synchronize_file_system`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_system_type' in params:
            path_params['fileSystemType'] = params['file_system_type']  # noqa: E501
        if 'asset_id' in params:
            path_params['assetId'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/filesystem/{fileSystemType}/{assetId}/synchronize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
