"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mode import Mode
from .terminal_brand import TerminalBrand
from .terminal_model import TerminalModel
from .url import URL, URLTypedDict
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, TypedDict


class EntityTerminalStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The status of the terminal."""

    PENDING = "pending"
    ACTIVE = "active"
    INACTIVE = "inactive"


class EntityTerminalLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityTerminalLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityTerminalTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a terminal object. Will always contain the string `terminal` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this terminal. Example: `term_7MgL4wea46qkRcoTZjWEH`."""
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    description: str
    r"""A short description of the terminal. The description can be used as an identifier for the terminal. Currently, the
    description is set when the terminal is initially configured. It will be visible in the Mollie Dashboard, and it
    may be visible on the device itself depending on the device.
    """
    status: EntityTerminalStatus
    brand: Nullable[TerminalBrand]
    r"""The brand of the terminal."""
    model: Nullable[TerminalModel]
    r"""The model of the terminal. For example for a PAX A920, this field's value will be `A920`."""
    serial_number: Nullable[str]
    r"""The serial number of the terminal. The serial number is provided at terminal creation time."""
    currency: str
    r"""The currency configured on the terminal, in ISO 4217 format. Currently most of our terminals are bound to a
    specific currency, chosen during setup.
    """
    profile_id: str
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    updated_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: EntityTerminalLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityTerminal(BaseModel):
    resource: str
    r"""Indicates the response contains a terminal object. Will always contain the string `terminal` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this terminal. Example: `term_7MgL4wea46qkRcoTZjWEH`."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    description: str
    r"""A short description of the terminal. The description can be used as an identifier for the terminal. Currently, the
    description is set when the terminal is initially configured. It will be visible in the Mollie Dashboard, and it
    may be visible on the device itself depending on the device.
    """

    status: Annotated[EntityTerminalStatus, PlainValidator(validate_open_enum(False))]

    brand: Annotated[Nullable[TerminalBrand], PlainValidator(validate_open_enum(False))]
    r"""The brand of the terminal."""

    model: Annotated[Nullable[TerminalModel], PlainValidator(validate_open_enum(False))]
    r"""The model of the terminal. For example for a PAX A920, this field's value will be `A920`."""

    serial_number: Annotated[Nullable[str], pydantic.Field(alias="serialNumber")]
    r"""The serial number of the terminal. The serial number is provided at terminal creation time."""

    currency: str
    r"""The currency configured on the terminal, in ISO 4217 format. Currently most of our terminals are bound to a
    specific currency, chosen during setup.
    """

    profile_id: Annotated[str, pydantic.Field(alias="profileId")]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[EntityTerminalLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["brand", "model", "serialNumber"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
