# coding: utf-8

"""
    dofusdude

    # Open Ankama Developer Community The all-in-one toolbelt for your next Ankama related project.  ## Versions - [Dofus 2](https://docs.dofusdu.de/dofus2/) - [Dofus 3](https://docs.dofusdu.de/dofus3/)   - v1 [latest] (you are here)   ## Client SDKs - [Javascript](https://github.com/dofusdude/dofusdude-js) `npm i dofusdude-js --save` - [Typescript](https://github.com/dofusdude/dofusdude-ts) `npm i dofusdude-ts --save` - [Go](https://github.com/dofusdude/dodugo) `go get -u github.com/dofusdude/dodugo` - [Python](https://github.com/dofusdude/dofusdude-py) `pip install dofusdude` - [Java](https://github.com/dofusdude/dofusdude-java) Maven with GitHub packages setup  Everything, including this site, is generated out of the [Docs Repo](https://github.com/dofusdude/api-docs). Consider it the Single Source of Truth. If there is a problem with the SDKs, create an issue there.  Your favorite language is missing? Please let me know!  # Main Features - 🥷 **Seamless Auto-Update** load data in the background when a new Dofus version is released and serving it within 10 minutes with atomic data source switching. No downtime and no effects for the user, just always up-to-date.  - ⚡ **Blazingly Fast** all data in-memory, aggressive caching over short time spans, HTTP/2 multiplexing, written in Go, optimized for low latency, hosted on bare metal in 🇩🇪.  - 📨 **Almanax Discord Integration** Use the endpoints as a dev or the official [Web Client](https://discord.dofusdude.com) as a user.  - 🩸 **Dofus 3 Beta** from stable to bleeding edge by replacing /dofus3 with /dofus3beta.  - 🗣️ **Multilingual** supporting _en_, _fr_, _es_, _pt_, _de_.  - 🧠 **Search by Relevance** allowing typos in name and description, handled by language specific text analysis and indexing.  - 🕵️ **Official Sources** generated from actual data from the game.  ... and much more on the Roadmap on my [Discord](https://discord.gg/3EtHskZD8h). 

    The version of the OpenAPI document: 1.0.0
    Contact: stelzo@steado.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from dofusdude.models.game_search import GameSearch
from dofusdude.models.list_item_general import ListItemGeneral

from dofusdude.api_client import ApiClient, RequestSerialized
from dofusdude.api_response import ApiResponse
from dofusdude.rest import RESTResponseType


class GameApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_game_search(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="search query")],
        filter_search_index: Annotated[Optional[List[StrictStr]], Field(description="only results with all specific type")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        fields_item: Annotated[Optional[List[StrictStr]], Field(description="adds fields from the item search to the list entries if the hit is an item. Multiple comma separated values allowed.")] = None,
        filter_type_name_id: Annotated[Optional[List[StrictStr]], Field(description="multi-filter results with the english item type name, including \"mount\" and \"set\" from filter[search_index]. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[GameSearch]:
        """Game Search

        Search in all names and descriptions of all supported types in the game. For the list of supported types see the endpoint /dofus3/meta/search/types.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: search query (required)
        :type query: str
        :param filter_search_index: only results with all specific type
        :type filter_search_index: List[str]
        :param limit: maximum number of returned results
        :type limit: int
        :param fields_item: adds fields from the item search to the list entries if the hit is an item. Multiple comma separated values allowed.
        :type fields_item: List[str]
        :param filter_type_name_id: multi-filter results with the english item type name, including \"mount\" and \"set\" from filter[search_index]. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".
        :type filter_type_name_id: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_game_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_search_index=filter_search_index,
            limit=limit,
            fields_item=fields_item,
            filter_type_name_id=filter_type_name_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GameSearch]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_game_search_with_http_info(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="search query")],
        filter_search_index: Annotated[Optional[List[StrictStr]], Field(description="only results with all specific type")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        fields_item: Annotated[Optional[List[StrictStr]], Field(description="adds fields from the item search to the list entries if the hit is an item. Multiple comma separated values allowed.")] = None,
        filter_type_name_id: Annotated[Optional[List[StrictStr]], Field(description="multi-filter results with the english item type name, including \"mount\" and \"set\" from filter[search_index]. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[GameSearch]]:
        """Game Search

        Search in all names and descriptions of all supported types in the game. For the list of supported types see the endpoint /dofus3/meta/search/types.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: search query (required)
        :type query: str
        :param filter_search_index: only results with all specific type
        :type filter_search_index: List[str]
        :param limit: maximum number of returned results
        :type limit: int
        :param fields_item: adds fields from the item search to the list entries if the hit is an item. Multiple comma separated values allowed.
        :type fields_item: List[str]
        :param filter_type_name_id: multi-filter results with the english item type name, including \"mount\" and \"set\" from filter[search_index]. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".
        :type filter_type_name_id: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_game_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_search_index=filter_search_index,
            limit=limit,
            fields_item=fields_item,
            filter_type_name_id=filter_type_name_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GameSearch]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_game_search_without_preload_content(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="search query")],
        filter_search_index: Annotated[Optional[List[StrictStr]], Field(description="only results with all specific type")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        fields_item: Annotated[Optional[List[StrictStr]], Field(description="adds fields from the item search to the list entries if the hit is an item. Multiple comma separated values allowed.")] = None,
        filter_type_name_id: Annotated[Optional[List[StrictStr]], Field(description="multi-filter results with the english item type name, including \"mount\" and \"set\" from filter[search_index]. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Game Search

        Search in all names and descriptions of all supported types in the game. For the list of supported types see the endpoint /dofus3/meta/search/types.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: search query (required)
        :type query: str
        :param filter_search_index: only results with all specific type
        :type filter_search_index: List[str]
        :param limit: maximum number of returned results
        :type limit: int
        :param fields_item: adds fields from the item search to the list entries if the hit is an item. Multiple comma separated values allowed.
        :type fields_item: List[str]
        :param filter_type_name_id: multi-filter results with the english item type name, including \"mount\" and \"set\" from filter[search_index]. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".
        :type filter_type_name_id: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_game_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_search_index=filter_search_index,
            limit=limit,
            fields_item=fields_item,
            filter_type_name_id=filter_type_name_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[GameSearch]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_game_search_serialize(
        self,
        language,
        game,
        query,
        filter_search_index,
        limit,
        fields_item,
        filter_type_name_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'filter[search_index]': 'csv',
            'fields[item]': 'csv',
            'filter[type.name_id]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if language is not None:
            _path_params['language'] = language
        if game is not None:
            _path_params['game'] = game
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if filter_search_index is not None:
            
            _query_params.append(('filter[search_index]', filter_search_index))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if fields_item is not None:
            
            _query_params.append(('fields[item]', fields_item))
            
        if filter_type_name_id is not None:
            
            _query_params.append(('filter[type.name_id]', filter_type_name_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/{game}/v1/{language}/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_items_all_search(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="case sensitive search query")],
        filter_min_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=0)]], Field(description="only results which level is equal or above this value")] = None,
        filter_max_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=0)]], Field(description="only results which level is equal or below this value")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        filter_type_name_id: Annotated[Optional[List[StrictStr]], Field(description="multi-filter results with the english type name. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ListItemGeneral]:
        """Search All Items

        Search in all names and descriptions of Dofus items (including all subtypes) with a query.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_min_level: only results which level is equal or above this value
        :type filter_min_level: int
        :param filter_max_level: only results which level is equal or below this value
        :type filter_max_level: int
        :param limit: maximum number of returned results
        :type limit: int
        :param filter_type_name_id: multi-filter results with the english type name. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".
        :type filter_type_name_id: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_items_all_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_min_level=filter_min_level,
            filter_max_level=filter_max_level,
            limit=limit,
            filter_type_name_id=filter_type_name_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ListItemGeneral]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_items_all_search_with_http_info(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="case sensitive search query")],
        filter_min_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=0)]], Field(description="only results which level is equal or above this value")] = None,
        filter_max_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=0)]], Field(description="only results which level is equal or below this value")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        filter_type_name_id: Annotated[Optional[List[StrictStr]], Field(description="multi-filter results with the english type name. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ListItemGeneral]]:
        """Search All Items

        Search in all names and descriptions of Dofus items (including all subtypes) with a query.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_min_level: only results which level is equal or above this value
        :type filter_min_level: int
        :param filter_max_level: only results which level is equal or below this value
        :type filter_max_level: int
        :param limit: maximum number of returned results
        :type limit: int
        :param filter_type_name_id: multi-filter results with the english type name. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".
        :type filter_type_name_id: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_items_all_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_min_level=filter_min_level,
            filter_max_level=filter_max_level,
            limit=limit,
            filter_type_name_id=filter_type_name_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ListItemGeneral]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_items_all_search_without_preload_content(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="case sensitive search query")],
        filter_min_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=0)]], Field(description="only results which level is equal or above this value")] = None,
        filter_max_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=0)]], Field(description="only results which level is equal or below this value")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        filter_type_name_id: Annotated[Optional[List[StrictStr]], Field(description="multi-filter results with the english type name. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search All Items

        Search in all names and descriptions of Dofus items (including all subtypes) with a query.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_min_level: only results which level is equal or above this value
        :type filter_min_level: int
        :param filter_max_level: only results which level is equal or below this value
        :type filter_max_level: int
        :param limit: maximum number of returned results
        :type limit: int
        :param filter_type_name_id: multi-filter results with the english type name. Add with \"wood\" or \"+wood\" and exclude with \"-wood\".
        :type filter_type_name_id: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_items_all_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_min_level=filter_min_level,
            filter_max_level=filter_max_level,
            limit=limit,
            filter_type_name_id=filter_type_name_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ListItemGeneral]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_items_all_search_serialize(
        self,
        language,
        game,
        query,
        filter_min_level,
        filter_max_level,
        limit,
        filter_type_name_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'filter[type.name_id]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if language is not None:
            _path_params['language'] = language
        if game is not None:
            _path_params['game'] = game
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if filter_min_level is not None:
            
            _query_params.append(('filter[min_level]', filter_min_level))
            
        if filter_max_level is not None:
            
            _query_params.append(('filter[max_level]', filter_max_level))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if filter_type_name_id is not None:
            
            _query_params.append(('filter[type.name_id]', filter_type_name_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/{game}/v1/{language}/items/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


