# coding: utf-8

"""
    dofusdude

    # Open Ankama Developer Community The all-in-one toolbelt for your next Ankama related project.  ## Versions - [Dofus 2](https://docs.dofusdu.de/dofus2/) - [Dofus 3](https://docs.dofusdu.de/dofus3/)   - v1 [latest] (you are here)   ## Client SDKs - [Javascript](https://github.com/dofusdude/dofusdude-js) `npm i dofusdude-js --save` - [Typescript](https://github.com/dofusdude/dofusdude-ts) `npm i dofusdude-ts --save` - [Go](https://github.com/dofusdude/dodugo) `go get -u github.com/dofusdude/dodugo` - [Python](https://github.com/dofusdude/dofusdude-py) `pip install dofusdude` - [Java](https://github.com/dofusdude/dofusdude-java) Maven with GitHub packages setup  Everything, including this site, is generated out of the [Docs Repo](https://github.com/dofusdude/api-docs). Consider it the Single Source of Truth. If there is a problem with the SDKs, create an issue there.  Your favorite language is missing? Please let me know!  # Main Features - 🥷 **Seamless Auto-Update** load data in the background when a new Dofus version is released and serving it within 10 minutes with atomic data source switching. No downtime and no effects for the user, just always up-to-date.  - ⚡ **Blazingly Fast** all data in-memory, aggressive caching over short time spans, HTTP/2 multiplexing, written in Go, optimized for low latency, hosted on bare metal in 🇩🇪.  - 📨 **Almanax Discord Integration** Use the endpoints as a dev or the official [Web Client](https://discord.dofusdude.com) as a user.  - 🩸 **Dofus 3 Beta** from stable to bleeding edge by replacing /dofus3 with /dofus3beta.  - 🗣️ **Multilingual** supporting _en_, _fr_, _es_, _pt_, _de_.  - 🧠 **Search by Relevance** allowing typos in name and description, handled by language specific text analysis and indexing.  - 🕵️ **Official Sources** generated from actual data from the game.  ... and much more on the Roadmap on my [Discord](https://discord.gg/3EtHskZD8h). 

    The version of the OpenAPI document: 1.0.0
    Contact: stelzo@steado.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from dofusdude.models.equipment_set import EquipmentSet
from dofusdude.models.list_equipment_set import ListEquipmentSet
from dofusdude.models.list_equipment_sets import ListEquipmentSets

from dofusdude.api_client import ApiClient, RequestSerialized
from dofusdude.api_response import ApiResponse
from dofusdude.rest import RESTResponseType


class SetsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_all_sets_list(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        sort_level: Annotated[Optional[StrictStr], Field(description="sort the resulting list by level, default unsorted")] = None,
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        accept_encoding: Annotated[Optional[StrictStr], Field(description="optional compression for saving bandwidth")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got cosmetic items in it.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListEquipmentSets:
        """List All Sets

        Retrieve all sets with one request. This endpoint is just an alias for the a list with disabled pagination (page[size]=-1) and all fields[type] set.  If you want everything unfiltered, delete the other query parameters.  Be careful with testing or (god forbid) using /all in your browser, the returned json is huge and will slow down the browser!  Tip: set the HTTP Header 'Accept-Encoding: gzip' for saving bandwidth. You will need to uncompress it on your end. Example with cURL: ``` curl -sH 'Accept-Encoding: gzip' <api-endpoint> | gunzip - ```

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param sort_level: sort the resulting list by level, default unsorted
        :type sort_level: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param accept_encoding: optional compression for saving bandwidth
        :type accept_encoding: str
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got cosmetic items in it.
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_sets_list_serialize(
            language=language,
            game=game,
            sort_level=sort_level,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            accept_encoding=accept_encoding,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEquipmentSets",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_all_sets_list_with_http_info(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        sort_level: Annotated[Optional[StrictStr], Field(description="sort the resulting list by level, default unsorted")] = None,
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        accept_encoding: Annotated[Optional[StrictStr], Field(description="optional compression for saving bandwidth")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got cosmetic items in it.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListEquipmentSets]:
        """List All Sets

        Retrieve all sets with one request. This endpoint is just an alias for the a list with disabled pagination (page[size]=-1) and all fields[type] set.  If you want everything unfiltered, delete the other query parameters.  Be careful with testing or (god forbid) using /all in your browser, the returned json is huge and will slow down the browser!  Tip: set the HTTP Header 'Accept-Encoding: gzip' for saving bandwidth. You will need to uncompress it on your end. Example with cURL: ``` curl -sH 'Accept-Encoding: gzip' <api-endpoint> | gunzip - ```

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param sort_level: sort the resulting list by level, default unsorted
        :type sort_level: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param accept_encoding: optional compression for saving bandwidth
        :type accept_encoding: str
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got cosmetic items in it.
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_sets_list_serialize(
            language=language,
            game=game,
            sort_level=sort_level,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            accept_encoding=accept_encoding,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEquipmentSets",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_all_sets_list_without_preload_content(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        sort_level: Annotated[Optional[StrictStr], Field(description="sort the resulting list by level, default unsorted")] = None,
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        accept_encoding: Annotated[Optional[StrictStr], Field(description="optional compression for saving bandwidth")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got cosmetic items in it.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Sets

        Retrieve all sets with one request. This endpoint is just an alias for the a list with disabled pagination (page[size]=-1) and all fields[type] set.  If you want everything unfiltered, delete the other query parameters.  Be careful with testing or (god forbid) using /all in your browser, the returned json is huge and will slow down the browser!  Tip: set the HTTP Header 'Accept-Encoding: gzip' for saving bandwidth. You will need to uncompress it on your end. Example with cURL: ``` curl -sH 'Accept-Encoding: gzip' <api-endpoint> | gunzip - ```

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param sort_level: sort the resulting list by level, default unsorted
        :type sort_level: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param accept_encoding: optional compression for saving bandwidth
        :type accept_encoding: str
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got cosmetic items in it.
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_sets_list_serialize(
            language=language,
            game=game,
            sort_level=sort_level,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            accept_encoding=accept_encoding,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEquipmentSets",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_all_sets_list_serialize(
        self,
        language,
        game,
        sort_level,
        filter_min_highest_equipment_level,
        filter_max_highest_equipment_level,
        accept_encoding,
        filter_contains_cosmetics_only,
        filter_contains_cosmetics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if language is not None:
            _path_params['language'] = language
        if game is not None:
            _path_params['game'] = game
        # process the query parameters
        if sort_level is not None:
            
            _query_params.append(('sort[level]', sort_level))
            
        if filter_min_highest_equipment_level is not None:
            
            _query_params.append(('filter[min_highest_equipment_level]', filter_min_highest_equipment_level))
            
        if filter_max_highest_equipment_level is not None:
            
            _query_params.append(('filter[max_highest_equipment_level]', filter_max_highest_equipment_level))
            
        if filter_contains_cosmetics_only is not None:
            
            _query_params.append(('filter[contains_cosmetics_only]', filter_contains_cosmetics_only))
            
        if filter_contains_cosmetics is not None:
            
            _query_params.append(('filter[contains_cosmetics]', filter_contains_cosmetics))
            
        # process the header parameters
        if accept_encoding is not None:
            _header_params['Accept-Encoding'] = accept_encoding
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/{game}/v1/{language}/sets/all',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_sets_list(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        sort_level: Annotated[Optional[StrictStr], Field(description="sort the resulting list by level, default unsorted")] = None,
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=-1)]], Field(description="size of the results from the list. -1 disables pagination and gets all in one response.")] = None,
        page_number: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.")] = None,
        fields_set: Annotated[Optional[List[StrictStr]], Field(description="adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got cosmetic items in it.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListEquipmentSets:
        """List Sets

        Retrieve a list of sets.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param sort_level: sort the resulting list by level, default unsorted
        :type sort_level: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param page_size: size of the results from the list. -1 disables pagination and gets all in one response.
        :type page_size: int
        :param page_number: page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.
        :type page_number: int
        :param fields_set: adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.
        :type fields_set: List[str]
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got cosmetic items in it.
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_list_serialize(
            language=language,
            game=game,
            sort_level=sort_level,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            page_size=page_size,
            page_number=page_number,
            fields_set=fields_set,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEquipmentSets",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_sets_list_with_http_info(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        sort_level: Annotated[Optional[StrictStr], Field(description="sort the resulting list by level, default unsorted")] = None,
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=-1)]], Field(description="size of the results from the list. -1 disables pagination and gets all in one response.")] = None,
        page_number: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.")] = None,
        fields_set: Annotated[Optional[List[StrictStr]], Field(description="adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got cosmetic items in it.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListEquipmentSets]:
        """List Sets

        Retrieve a list of sets.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param sort_level: sort the resulting list by level, default unsorted
        :type sort_level: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param page_size: size of the results from the list. -1 disables pagination and gets all in one response.
        :type page_size: int
        :param page_number: page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.
        :type page_number: int
        :param fields_set: adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.
        :type fields_set: List[str]
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got cosmetic items in it.
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_list_serialize(
            language=language,
            game=game,
            sort_level=sort_level,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            page_size=page_size,
            page_number=page_number,
            fields_set=fields_set,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEquipmentSets",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_sets_list_without_preload_content(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        sort_level: Annotated[Optional[StrictStr], Field(description="sort the resulting list by level, default unsorted")] = None,
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=-1)]], Field(description="size of the results from the list. -1 disables pagination and gets all in one response.")] = None,
        page_number: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.")] = None,
        fields_set: Annotated[Optional[List[StrictStr]], Field(description="adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got cosmetic items in it.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Sets

        Retrieve a list of sets.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param sort_level: sort the resulting list by level, default unsorted
        :type sort_level: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param page_size: size of the results from the list. -1 disables pagination and gets all in one response.
        :type page_size: int
        :param page_number: page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.
        :type page_number: int
        :param fields_set: adds fields from their detail endpoint to the item list entries. Multiple comma separated values allowed.
        :type fields_set: List[str]
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got cosmetic items in it.
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_list_serialize(
            language=language,
            game=game,
            sort_level=sort_level,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            page_size=page_size,
            page_number=page_number,
            fields_set=fields_set,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEquipmentSets",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_sets_list_serialize(
        self,
        language,
        game,
        sort_level,
        filter_min_highest_equipment_level,
        filter_max_highest_equipment_level,
        page_size,
        page_number,
        fields_set,
        filter_contains_cosmetics_only,
        filter_contains_cosmetics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[set]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if language is not None:
            _path_params['language'] = language
        if game is not None:
            _path_params['game'] = game
        # process the query parameters
        if sort_level is not None:
            
            _query_params.append(('sort[level]', sort_level))
            
        if filter_min_highest_equipment_level is not None:
            
            _query_params.append(('filter[min_highest_equipment_level]', filter_min_highest_equipment_level))
            
        if filter_max_highest_equipment_level is not None:
            
            _query_params.append(('filter[max_highest_equipment_level]', filter_max_highest_equipment_level))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if fields_set is not None:
            
            _query_params.append(('fields[set]', fields_set))
            
        if filter_contains_cosmetics_only is not None:
            
            _query_params.append(('filter[contains_cosmetics_only]', filter_contains_cosmetics_only))
            
        if filter_contains_cosmetics is not None:
            
            _query_params.append(('filter[contains_cosmetics]', filter_contains_cosmetics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/{game}/v1/{language}/sets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_sets_search(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="case sensitive search query")],
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got any cosmetic items in it")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ListEquipmentSet]:
        """Search Sets

        Search in all names and descriptions of sets with a query.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param limit: maximum number of returned results
        :type limit: int
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got any cosmetic items in it
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            limit=limit,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ListEquipmentSet]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_sets_search_with_http_info(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="case sensitive search query")],
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got any cosmetic items in it")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ListEquipmentSet]]:
        """Search Sets

        Search in all names and descriptions of sets with a query.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param limit: maximum number of returned results
        :type limit: int
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got any cosmetic items in it
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            limit=limit,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ListEquipmentSet]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_sets_search_without_preload_content(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        query: Annotated[StrictStr, Field(description="case sensitive search query")],
        filter_min_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is above or equal to this value")] = None,
        filter_max_highest_equipment_level: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="only results where the equipment with the highest level is below or equal to this value")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="maximum number of returned results")] = None,
        filter_contains_cosmetics_only: Annotated[Optional[StrictBool], Field(description="filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.")] = None,
        filter_contains_cosmetics: Annotated[Optional[StrictBool], Field(description="filter sets based on if they got any cosmetic items in it")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search Sets

        Search in all names and descriptions of sets with a query.

        :param language: a valid language code (required)
        :type language: str
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param query: case sensitive search query (required)
        :type query: str
        :param filter_min_highest_equipment_level: only results where the equipment with the highest level is above or equal to this value
        :type filter_min_highest_equipment_level: int
        :param filter_max_highest_equipment_level: only results where the equipment with the highest level is below or equal to this value
        :type filter_max_highest_equipment_level: int
        :param limit: maximum number of returned results
        :type limit: int
        :param filter_contains_cosmetics_only: filter sets based on if they only got cosmetic items in it. If true, the item ids are for the cosmetic endpoints instead of equipment.
        :type filter_contains_cosmetics_only: bool
        :param filter_contains_cosmetics: filter sets based on if they got any cosmetic items in it
        :type filter_contains_cosmetics: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_search_serialize(
            language=language,
            game=game,
            query=query,
            filter_min_highest_equipment_level=filter_min_highest_equipment_level,
            filter_max_highest_equipment_level=filter_max_highest_equipment_level,
            limit=limit,
            filter_contains_cosmetics_only=filter_contains_cosmetics_only,
            filter_contains_cosmetics=filter_contains_cosmetics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ListEquipmentSet]",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_sets_search_serialize(
        self,
        language,
        game,
        query,
        filter_min_highest_equipment_level,
        filter_max_highest_equipment_level,
        limit,
        filter_contains_cosmetics_only,
        filter_contains_cosmetics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if language is not None:
            _path_params['language'] = language
        if game is not None:
            _path_params['game'] = game
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if filter_min_highest_equipment_level is not None:
            
            _query_params.append(('filter[min_highest_equipment_level]', filter_min_highest_equipment_level))
            
        if filter_max_highest_equipment_level is not None:
            
            _query_params.append(('filter[max_highest_equipment_level]', filter_max_highest_equipment_level))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if filter_contains_cosmetics_only is not None:
            
            _query_params.append(('filter[contains_cosmetics_only]', filter_contains_cosmetics_only))
            
        if filter_contains_cosmetics is not None:
            
            _query_params.append(('filter[contains_cosmetics]', filter_contains_cosmetics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/{game}/v1/{language}/sets/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_sets_single(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        ankama_id: Annotated[StrictInt, Field(description="identifier")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EquipmentSet:
        """Single Sets

        Retrieve a specific set with id.

        :param language: a valid language code (required)
        :type language: str
        :param ankama_id: identifier (required)
        :type ankama_id: int
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_single_serialize(
            language=language,
            ankama_id=ankama_id,
            game=game,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EquipmentSet",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_sets_single_with_http_info(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        ankama_id: Annotated[StrictInt, Field(description="identifier")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EquipmentSet]:
        """Single Sets

        Retrieve a specific set with id.

        :param language: a valid language code (required)
        :type language: str
        :param ankama_id: identifier (required)
        :type ankama_id: int
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_single_serialize(
            language=language,
            ankama_id=ankama_id,
            game=game,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EquipmentSet",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_sets_single_without_preload_content(
        self,
        language: Annotated[str, Field(min_length=2, strict=True, max_length=2, description="a valid language code")],
        ankama_id: Annotated[StrictInt, Field(description="identifier")],
        game: Annotated[StrictStr, Field(description="game main 'dofus3' or beta channel 'dofus3beta'")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Single Sets

        Retrieve a specific set with id.

        :param language: a valid language code (required)
        :type language: str
        :param ankama_id: identifier (required)
        :type ankama_id: int
        :param game: game main 'dofus3' or beta channel 'dofus3beta' (required)
        :type game: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_sets_single_serialize(
            language=language,
            ankama_id=ankama_id,
            game=game,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EquipmentSet",
            '400': "Error",
            '404': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_sets_single_serialize(
        self,
        language,
        ankama_id,
        game,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if language is not None:
            _path_params['language'] = language
        if ankama_id is not None:
            _path_params['ankama_id'] = ankama_id
        if game is not None:
            _path_params['game'] = game
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/{game}/v1/{language}/sets/{ankama_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


