# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstanceConsoleConnectionsResult',
    'AwaitableGetInstanceConsoleConnectionsResult',
    'get_instance_console_connections',
    'get_instance_console_connections_output',
]

@pulumi.output_type
class GetInstanceConsoleConnectionsResult:
    """
    A collection of values returned by getInstanceConsoleConnections.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, instance_console_connections=None, instance_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_console_connections and not isinstance(instance_console_connections, list):
            raise TypeError("Expected argument 'instance_console_connections' to be a list")
        pulumi.set(__self__, "instance_console_connections", instance_console_connections)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment to contain the console connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstanceConsoleConnectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceConsoleConnections")
    def instance_console_connections(self) -> Sequence['outputs.GetInstanceConsoleConnectionsInstanceConsoleConnectionResult']:
        """
        The list of instance_console_connections.
        """
        return pulumi.get(self, "instance_console_connections")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The OCID of the instance the console connection connects to.
        """
        return pulumi.get(self, "instance_id")


class AwaitableGetInstanceConsoleConnectionsResult(GetInstanceConsoleConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceConsoleConnectionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            instance_console_connections=self.instance_console_connections,
            instance_id=self.instance_id)


def get_instance_console_connections(compartment_id: Optional[str] = None,
                                     filters: Optional[Sequence[pulumi.InputType['GetInstanceConsoleConnectionsFilterArgs']]] = None,
                                     instance_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceConsoleConnectionsResult:
    """
    This data source provides the list of Instance Console Connections in Oracle Cloud Infrastructure Core service.

    Lists the console connections for the specified compartment or instance.

    For more information about instance console connections, see [Troubleshooting Instances Using Instance Console Connections](https://docs.cloud.oracle.com/iaas/Content/Compute/References/serialconsole.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_console_connections = oci.Core.get_instance_console_connections(compartment_id=compartment_id,
        instance_id=test_instance["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str instance_id: The OCID of the instance.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstanceConsoleConnections:getInstanceConsoleConnections', __args__, opts=opts, typ=GetInstanceConsoleConnectionsResult).value

    return AwaitableGetInstanceConsoleConnectionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_console_connections=pulumi.get(__ret__, 'instance_console_connections'),
        instance_id=pulumi.get(__ret__, 'instance_id'))


@_utilities.lift_output_func(get_instance_console_connections)
def get_instance_console_connections_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetInstanceConsoleConnectionsFilterArgs']]]]] = None,
                                            instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceConsoleConnectionsResult]:
    """
    This data source provides the list of Instance Console Connections in Oracle Cloud Infrastructure Core service.

    Lists the console connections for the specified compartment or instance.

    For more information about instance console connections, see [Troubleshooting Instances Using Instance Console Connections](https://docs.cloud.oracle.com/iaas/Content/Compute/References/serialconsole.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_console_connections = oci.Core.get_instance_console_connections(compartment_id=compartment_id,
        instance_id=test_instance["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str instance_id: The OCID of the instance.
    """
    ...
