# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDbNodeConsoleConnectionResult',
    'AwaitableGetDbNodeConsoleConnectionResult',
    'get_db_node_console_connection',
    'get_db_node_console_connection_output',
]

@pulumi.output_type
class GetDbNodeConsoleConnectionResult:
    """
    A collection of values returned by getDbNodeConsoleConnection.
    """
    def __init__(__self__, compartment_id=None, connection_string=None, db_node_id=None, defined_tags=None, fingerprint=None, freeform_tags=None, id=None, lifecycle_details=None, public_key=None, service_host_key_fingerprint=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string and not isinstance(connection_string, str):
            raise TypeError("Expected argument 'connection_string' to be a str")
        pulumi.set(__self__, "connection_string", connection_string)
        if db_node_id and not isinstance(db_node_id, str):
            raise TypeError("Expected argument 'db_node_id' to be a str")
        pulumi.set(__self__, "db_node_id", db_node_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if service_host_key_fingerprint and not isinstance(service_host_key_fingerprint, str):
            raise TypeError("Expected argument 'service_host_key_fingerprint' to be a str")
        pulumi.set(__self__, "service_host_key_fingerprint", service_host_key_fingerprint)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment to contain the console connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The SSH connection string for the console connection.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> str:
        """
        The OCID of the database node.
        """
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        The SSH public key fingerprint for the console connection.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the console connection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="serviceHostKeyFingerprint")
    def service_host_key_fingerprint(self) -> str:
        """
        The SSH public key's fingerprint for the console connection service host.
        """
        return pulumi.get(self, "service_host_key_fingerprint")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the console connection.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbNodeConsoleConnectionResult(GetDbNodeConsoleConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeConsoleConnectionResult(
            compartment_id=self.compartment_id,
            connection_string=self.connection_string,
            db_node_id=self.db_node_id,
            defined_tags=self.defined_tags,
            fingerprint=self.fingerprint,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            public_key=self.public_key,
            service_host_key_fingerprint=self.service_host_key_fingerprint,
            state=self.state)


def get_db_node_console_connection(db_node_id: Optional[str] = None,
                                   id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeConsoleConnectionResult:
    """
    This data source provides details about a specific Db Node Console Connection resource in Oracle Cloud Infrastructure Database service.

    Gets the specified database node console connection's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_connection = oci.Database.get_db_node_console_connection(db_node_id=test_db_node["id"],
        id=db_node_console_connection_id)
    ```


    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str id: The OCID of the console connection.
    """
    __args__ = dict()
    __args__['dbNodeId'] = db_node_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodeConsoleConnection:getDbNodeConsoleConnection', __args__, opts=opts, typ=GetDbNodeConsoleConnectionResult).value

    return AwaitableGetDbNodeConsoleConnectionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_string=pulumi.get(__ret__, 'connection_string'),
        db_node_id=pulumi.get(__ret__, 'db_node_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        public_key=pulumi.get(__ret__, 'public_key'),
        service_host_key_fingerprint=pulumi.get(__ret__, 'service_host_key_fingerprint'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_db_node_console_connection)
def get_db_node_console_connection_output(db_node_id: Optional[pulumi.Input[str]] = None,
                                          id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbNodeConsoleConnectionResult]:
    """
    This data source provides details about a specific Db Node Console Connection resource in Oracle Cloud Infrastructure Database service.

    Gets the specified database node console connection's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_connection = oci.Database.get_db_node_console_connection(db_node_id=test_db_node["id"],
        id=db_node_console_connection_id)
    ```


    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str id: The OCID of the console connection.
    """
    ...
