# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuditPolicyArgs', 'AuditPolicy']

@pulumi.input_type
class AuditPolicyArgs:
    def __init__(__self__, *,
                 audit_policy_id: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 provision_trigger: Optional[pulumi.Input[int]] = None,
                 retrieve_from_target_trigger: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AuditPolicy resource.
        :param pulumi.Input[str] audit_policy_id: Unique audit policy identifier.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the audit policy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[int] provision_trigger: (Updatable) An optional property when incremented triggers Provision. Could be set to any integer value.
        :param pulumi.Input[int] retrieve_from_target_trigger: (Updatable) An optional property when incremented triggers Retrieve From Target. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "audit_policy_id", audit_policy_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if provision_trigger is not None:
            pulumi.set(__self__, "provision_trigger", provision_trigger)
        if retrieve_from_target_trigger is not None:
            pulumi.set(__self__, "retrieve_from_target_trigger", retrieve_from_target_trigger)

    @property
    @pulumi.getter(name="auditPolicyId")
    def audit_policy_id(self) -> pulumi.Input[str]:
        """
        Unique audit policy identifier.
        """
        return pulumi.get(self, "audit_policy_id")

    @audit_policy_id.setter
    def audit_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "audit_policy_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment containing the audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the audit policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="provisionTrigger")
    def provision_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Provision. Could be set to any integer value.
        """
        return pulumi.get(self, "provision_trigger")

    @provision_trigger.setter
    def provision_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provision_trigger", value)

    @property
    @pulumi.getter(name="retrieveFromTargetTrigger")
    def retrieve_from_target_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Retrieve From Target. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retrieve_from_target_trigger")

    @retrieve_from_target_trigger.setter
    def retrieve_from_target_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retrieve_from_target_trigger", value)


@pulumi.input_type
class _AuditPolicyState:
    def __init__(__self__, *,
                 audit_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditConditionArgs']]]] = None,
                 audit_policy_id: Optional[pulumi.Input[str]] = None,
                 audit_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditSpecificationArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_data_safe_service_account_excluded: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 provision_trigger: Optional[pulumi.Input[int]] = None,
                 retrieve_from_target_trigger: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_provisioned: Optional[pulumi.Input[str]] = None,
                 time_last_retrieved: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuditPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditConditionArgs']]] audit_conditions: Lists the audit policy provisioning conditions for the target database.
        :param pulumi.Input[str] audit_policy_id: Unique audit policy identifier.
        :param pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditSpecificationArgs']]] audit_specifications: Represents all available audit policy specifications relevant for the target database. For more details on available audit polcies, refer to [documentation](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/audit-policies.html#GUID-361A9A9A-7C21-4F5A-8945-9B3A0C472827).
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the audit policy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_data_safe_service_account_excluded: Option provided to users at the target to indicate whether the Data Safe service account has to be excluded while provisioning the audit policies.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the audit policy in Data Safe.
        :param pulumi.Input[int] provision_trigger: (Updatable) An optional property when incremented triggers Provision. Could be set to any integer value.
        :param pulumi.Input[int] retrieve_from_target_trigger: (Updatable) An optional property when incremented triggers Retrieve From Target. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the audit policy.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target for which the audit policy is created.
        :param pulumi.Input[str] time_created: The time the the audit policy was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_provisioned: Indicates the last provisioning time of audit policies on the target, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_retrieved: The time when the audit policies was last retrieved from this target, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The last date and time the audit policy was updated, in the format defined by RFC3339.
        """
        if audit_conditions is not None:
            pulumi.set(__self__, "audit_conditions", audit_conditions)
        if audit_policy_id is not None:
            pulumi.set(__self__, "audit_policy_id", audit_policy_id)
        if audit_specifications is not None:
            pulumi.set(__self__, "audit_specifications", audit_specifications)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_data_safe_service_account_excluded is not None:
            pulumi.set(__self__, "is_data_safe_service_account_excluded", is_data_safe_service_account_excluded)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if provision_trigger is not None:
            pulumi.set(__self__, "provision_trigger", provision_trigger)
        if retrieve_from_target_trigger is not None:
            pulumi.set(__self__, "retrieve_from_target_trigger", retrieve_from_target_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_provisioned is not None:
            pulumi.set(__self__, "time_last_provisioned", time_last_provisioned)
        if time_last_retrieved is not None:
            pulumi.set(__self__, "time_last_retrieved", time_last_retrieved)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="auditConditions")
    def audit_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditConditionArgs']]]]:
        """
        Lists the audit policy provisioning conditions for the target database.
        """
        return pulumi.get(self, "audit_conditions")

    @audit_conditions.setter
    def audit_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditConditionArgs']]]]):
        pulumi.set(self, "audit_conditions", value)

    @property
    @pulumi.getter(name="auditPolicyId")
    def audit_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique audit policy identifier.
        """
        return pulumi.get(self, "audit_policy_id")

    @audit_policy_id.setter
    def audit_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_policy_id", value)

    @property
    @pulumi.getter(name="auditSpecifications")
    def audit_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditSpecificationArgs']]]]:
        """
        Represents all available audit policy specifications relevant for the target database. For more details on available audit polcies, refer to [documentation](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/audit-policies.html#GUID-361A9A9A-7C21-4F5A-8945-9B3A0C472827).
        """
        return pulumi.get(self, "audit_specifications")

    @audit_specifications.setter
    def audit_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditPolicyAuditSpecificationArgs']]]]):
        pulumi.set(self, "audit_specifications", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment containing the audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the audit policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDataSafeServiceAccountExcluded")
    def is_data_safe_service_account_excluded(self) -> Optional[pulumi.Input[bool]]:
        """
        Option provided to users at the target to indicate whether the Data Safe service account has to be excluded while provisioning the audit policies.
        """
        return pulumi.get(self, "is_data_safe_service_account_excluded")

    @is_data_safe_service_account_excluded.setter
    def is_data_safe_service_account_excluded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_data_safe_service_account_excluded", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the audit policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="provisionTrigger")
    def provision_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Provision. Could be set to any integer value.
        """
        return pulumi.get(self, "provision_trigger")

    @provision_trigger.setter
    def provision_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provision_trigger", value)

    @property
    @pulumi.getter(name="retrieveFromTargetTrigger")
    def retrieve_from_target_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Retrieve From Target. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retrieve_from_target_trigger")

    @retrieve_from_target_trigger.setter
    def retrieve_from_target_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retrieve_from_target_trigger", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the audit policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target for which the audit policy is created.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastProvisioned")
    def time_last_provisioned(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the last provisioning time of audit policies on the target, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_provisioned")

    @time_last_provisioned.setter
    def time_last_provisioned(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_provisioned", value)

    @property
    @pulumi.getter(name="timeLastRetrieved")
    def time_last_retrieved(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the audit policies was last retrieved from this target, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_retrieved")

    @time_last_retrieved.setter
    def time_last_retrieved(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_retrieved", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last date and time the audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AuditPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_policy_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 provision_trigger: Optional[pulumi.Input[int]] = None,
                 retrieve_from_target_trigger: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the audit policy.

        ## Import

        AuditPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditPolicy:AuditPolicy test_audit_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_policy_id: Unique audit policy identifier.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the audit policy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[int] provision_trigger: (Updatable) An optional property when incremented triggers Provision. Could be set to any integer value.
        :param pulumi.Input[int] retrieve_from_target_trigger: (Updatable) An optional property when incremented triggers Retrieve From Target. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuditPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the audit policy.

        ## Import

        AuditPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditPolicy:AuditPolicy test_audit_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param AuditPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_policy_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 provision_trigger: Optional[pulumi.Input[int]] = None,
                 retrieve_from_target_trigger: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditPolicyArgs.__new__(AuditPolicyArgs)

            if audit_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'audit_policy_id'")
            __props__.__dict__["audit_policy_id"] = audit_policy_id
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["provision_trigger"] = provision_trigger
            __props__.__dict__["retrieve_from_target_trigger"] = retrieve_from_target_trigger
            __props__.__dict__["audit_conditions"] = None
            __props__.__dict__["audit_specifications"] = None
            __props__.__dict__["is_data_safe_service_account_excluded"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_provisioned"] = None
            __props__.__dict__["time_last_retrieved"] = None
            __props__.__dict__["time_updated"] = None
        super(AuditPolicy, __self__).__init__(
            'oci:DataSafe/auditPolicy:AuditPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AuditPolicyAuditConditionArgs']]]]] = None,
            audit_policy_id: Optional[pulumi.Input[str]] = None,
            audit_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AuditPolicyAuditSpecificationArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_data_safe_service_account_excluded: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            provision_trigger: Optional[pulumi.Input[int]] = None,
            retrieve_from_target_trigger: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_provisioned: Optional[pulumi.Input[str]] = None,
            time_last_retrieved: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AuditPolicy':
        """
        Get an existing AuditPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AuditPolicyAuditConditionArgs']]]] audit_conditions: Lists the audit policy provisioning conditions for the target database.
        :param pulumi.Input[str] audit_policy_id: Unique audit policy identifier.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AuditPolicyAuditSpecificationArgs']]]] audit_specifications: Represents all available audit policy specifications relevant for the target database. For more details on available audit polcies, refer to [documentation](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/audit-policies.html#GUID-361A9A9A-7C21-4F5A-8945-9B3A0C472827).
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the audit policy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_data_safe_service_account_excluded: Option provided to users at the target to indicate whether the Data Safe service account has to be excluded while provisioning the audit policies.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the audit policy in Data Safe.
        :param pulumi.Input[int] provision_trigger: (Updatable) An optional property when incremented triggers Provision. Could be set to any integer value.
        :param pulumi.Input[int] retrieve_from_target_trigger: (Updatable) An optional property when incremented triggers Retrieve From Target. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the audit policy.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target for which the audit policy is created.
        :param pulumi.Input[str] time_created: The time the the audit policy was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_provisioned: Indicates the last provisioning time of audit policies on the target, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_retrieved: The time when the audit policies was last retrieved from this target, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The last date and time the audit policy was updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditPolicyState.__new__(_AuditPolicyState)

        __props__.__dict__["audit_conditions"] = audit_conditions
        __props__.__dict__["audit_policy_id"] = audit_policy_id
        __props__.__dict__["audit_specifications"] = audit_specifications
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_data_safe_service_account_excluded"] = is_data_safe_service_account_excluded
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["provision_trigger"] = provision_trigger
        __props__.__dict__["retrieve_from_target_trigger"] = retrieve_from_target_trigger
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_provisioned"] = time_last_provisioned
        __props__.__dict__["time_last_retrieved"] = time_last_retrieved
        __props__.__dict__["time_updated"] = time_updated
        return AuditPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditConditions")
    def audit_conditions(self) -> pulumi.Output[Sequence['outputs.AuditPolicyAuditCondition']]:
        """
        Lists the audit policy provisioning conditions for the target database.
        """
        return pulumi.get(self, "audit_conditions")

    @property
    @pulumi.getter(name="auditPolicyId")
    def audit_policy_id(self) -> pulumi.Output[str]:
        """
        Unique audit policy identifier.
        """
        return pulumi.get(self, "audit_policy_id")

    @property
    @pulumi.getter(name="auditSpecifications")
    def audit_specifications(self) -> pulumi.Output[Sequence['outputs.AuditPolicyAuditSpecification']]:
        """
        Represents all available audit policy specifications relevant for the target database. For more details on available audit polcies, refer to [documentation](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/audit-policies.html#GUID-361A9A9A-7C21-4F5A-8945-9B3A0C472827).
        """
        return pulumi.get(self, "audit_specifications")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment containing the audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the audit policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isDataSafeServiceAccountExcluded")
    def is_data_safe_service_account_excluded(self) -> pulumi.Output[bool]:
        """
        Option provided to users at the target to indicate whether the Data Safe service account has to be excluded while provisioning the audit policies.
        """
        return pulumi.get(self, "is_data_safe_service_account_excluded")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the audit policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="provisionTrigger")
    def provision_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional property when incremented triggers Provision. Could be set to any integer value.
        """
        return pulumi.get(self, "provision_trigger")

    @property
    @pulumi.getter(name="retrieveFromTargetTrigger")
    def retrieve_from_target_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional property when incremented triggers Retrieve From Target. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retrieve_from_target_trigger")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the audit policy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The OCID of the target for which the audit policy is created.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastProvisioned")
    def time_last_provisioned(self) -> pulumi.Output[str]:
        """
        Indicates the last provisioning time of audit policies on the target, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_provisioned")

    @property
    @pulumi.getter(name="timeLastRetrieved")
    def time_last_retrieved(self) -> pulumi.Output[str]:
        """
        The time when the audit policies was last retrieved from this target, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_retrieved")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The last date and time the audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

