# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ActionCreateZoneFromZoneFileExternalDownstreamArgs',
    'ActionCreateZoneFromZoneFileExternalMasterArgs',
    'ActionCreateZoneFromZoneFileNameserverArgs',
    'ActionCreateZoneFromZoneFileZoneTransferServerArgs',
    'ResolverAttachedViewArgs',
    'ResolverEndpointArgs',
    'ResolverRuleArgs',
    'RrsetItemArgs',
    'SteeringPolicyAnswerArgs',
    'SteeringPolicyRuleArgs',
    'SteeringPolicyRuleCaseArgs',
    'SteeringPolicyRuleCaseAnswerDataArgs',
    'SteeringPolicyRuleDefaultAnswerDataArgs',
    'ZoneExternalDownstreamArgs',
    'ZoneExternalMasterArgs',
    'ZoneNameserverArgs',
    'ZoneZoneTransferServerArgs',
    'GetRecordsFilterArgs',
    'GetResolverEndpointsFilterArgs',
    'GetResolversFilterArgs',
    'GetRrsetsFilterArgs',
    'GetSteeringPoliciesFilterArgs',
    'GetSteeringPolicyAttachmentsFilterArgs',
    'GetTsigKeysFilterArgs',
    'GetViewsFilterArgs',
    'GetZonesFilterArgs',
]

@pulumi.input_type
class ActionCreateZoneFromZoneFileExternalDownstreamArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 tsig_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The server's IP address (IPv4 or IPv6).
        :param pulumi.Input[int] port: The server's port.
        :param pulumi.Input[str] tsig_key_id: The OCID of the TSIG key.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tsig_key_id is not None:
            pulumi.set(__self__, "tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The server's port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")

    @tsig_key_id.setter
    def tsig_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tsig_key_id", value)


@pulumi.input_type
class ActionCreateZoneFromZoneFileExternalMasterArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 tsig_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The server's IP address (IPv4 or IPv6).
        :param pulumi.Input[int] port: The server's port.
        :param pulumi.Input[str] tsig_key_id: The OCID of the TSIG key.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tsig_key_id is not None:
            pulumi.set(__self__, "tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The server's port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")

    @tsig_key_id.setter
    def tsig_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tsig_key_id", value)


@pulumi.input_type
class ActionCreateZoneFromZoneFileNameserverArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] hostname: The hostname of the nameserver.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the nameserver.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)


@pulumi.input_type
class ActionCreateZoneFromZoneFileZoneTransferServerArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 is_transfer_destination: Optional[pulumi.Input[bool]] = None,
                 is_transfer_source: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: The server's IP address (IPv4 or IPv6).
        :param pulumi.Input[bool] is_transfer_destination: A Boolean flag indicating whether or not the server is a zone data transfer destination.
        :param pulumi.Input[bool] is_transfer_source: A Boolean flag indicating whether or not the server is a zone data transfer source.
        :param pulumi.Input[int] port: The server's port.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if is_transfer_destination is not None:
            pulumi.set(__self__, "is_transfer_destination", is_transfer_destination)
        if is_transfer_source is not None:
            pulumi.set(__self__, "is_transfer_source", is_transfer_source)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="isTransferDestination")
    def is_transfer_destination(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer destination.
        """
        return pulumi.get(self, "is_transfer_destination")

    @is_transfer_destination.setter
    def is_transfer_destination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transfer_destination", value)

    @property
    @pulumi.getter(name="isTransferSource")
    def is_transfer_source(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer source.
        """
        return pulumi.get(self, "is_transfer_source")

    @is_transfer_source.setter
    def is_transfer_source(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transfer_source", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The server's port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ResolverAttachedViewArgs:
    def __init__(__self__, *,
                 view_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] view_id: (Updatable) The OCID of the view.
        """
        pulumi.set(__self__, "view_id", view_id)

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the view.
        """
        return pulumi.get(self, "view_id")

    @view_id.setter
    def view_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "view_id", value)


@pulumi.input_type
class ResolverEndpointArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 forwarding_address: Optional[pulumi.Input[str]] = None,
                 is_forwarding: Optional[pulumi.Input[bool]] = None,
                 is_listening: Optional[pulumi.Input[bool]] = None,
                 listening_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 self: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the owning compartment.
        :param pulumi.Input[str] endpoint_type: The type of resolver endpoint. VNIC is currently the only supported type.
        :param pulumi.Input[str] forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param pulumi.Input[bool] is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param pulumi.Input[bool] is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param pulumi.Input[str] listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param pulumi.Input[str] name: The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        :param pulumi.Input[str] self: The canonical absolute URL of the resource.
        :param pulumi.Input[str] state: The current state of the resource.
        :param pulumi.Input[str] subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        :param pulumi.Input[str] time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param pulumi.Input[str] time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if forwarding_address is not None:
            pulumi.set(__self__, "forwarding_address", forwarding_address)
        if is_forwarding is not None:
            pulumi.set(__self__, "is_forwarding", is_forwarding)
        if is_listening is not None:
            pulumi.set(__self__, "is_listening", is_listening)
        if listening_address is not None:
            pulumi.set(__self__, "listening_address", listening_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if self is not None:
            pulumi.set(__self__, "self", self)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the owning compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of resolver endpoint. VNIC is currently the only supported type.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        """
        return pulumi.get(self, "forwarding_address")

    @forwarding_address.setter
    def forwarding_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forwarding_address", value)

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        """
        return pulumi.get(self, "is_forwarding")

    @is_forwarding.setter
    def is_forwarding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_forwarding", value)

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for listening.
        """
        return pulumi.get(self, "is_listening")

    @is_listening.setter
    def is_listening(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_listening", value)

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        """
        return pulumi.get(self, "listening_address")

    @listening_address.setter
    def listening_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listening_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def self(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @self.setter
    def self(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.input_type
class ResolverRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 destination_addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 source_endpoint_name: pulumi.Input[str],
                 client_address_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 qname_cover_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] action: (Updatable) The action determines the behavior of the rule. If a query matches a supplied condition, the action will apply. If there are no conditions on the rule, all queries are subject to the specified action.
               * `FORWARD` - Matching requests will be forwarded from the source interface to the destination address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: (Updatable) IP addresses to which queries should be forwarded. Currently limited to a single address.
        :param pulumi.Input[str] source_endpoint_name: (Updatable) Name of an endpoint, that is a sub-resource of the resolver, to use as the forwarding interface. The endpoint must have isForwarding set to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_address_conditions: (Updatable) A list of CIDR blocks. The query must come from a client within one of the blocks in order for the rule action to apply.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] qname_cover_conditions: (Updatable) A list of domain names. The query must be covered by one of the domains in order for the rule action to apply.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination_addresses", destination_addresses)
        pulumi.set(__self__, "source_endpoint_name", source_endpoint_name)
        if client_address_conditions is not None:
            pulumi.set(__self__, "client_address_conditions", client_address_conditions)
        if qname_cover_conditions is not None:
            pulumi.set(__self__, "qname_cover_conditions", qname_cover_conditions)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        (Updatable) The action determines the behavior of the rule. If a query matches a supplied condition, the action will apply. If there are no conditions on the rule, all queries are subject to the specified action.
        * `FORWARD` - Matching requests will be forwarded from the source interface to the destination address.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) IP addresses to which queries should be forwarded. Currently limited to a single address.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="sourceEndpointName")
    def source_endpoint_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of an endpoint, that is a sub-resource of the resolver, to use as the forwarding interface. The endpoint must have isForwarding set to true.
        """
        return pulumi.get(self, "source_endpoint_name")

    @source_endpoint_name.setter
    def source_endpoint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_name", value)

    @property
    @pulumi.getter(name="clientAddressConditions")
    def client_address_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of CIDR blocks. The query must come from a client within one of the blocks in order for the rule action to apply.
        """
        return pulumi.get(self, "client_address_conditions")

    @client_address_conditions.setter
    def client_address_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_address_conditions", value)

    @property
    @pulumi.getter(name="qnameCoverConditions")
    def qname_cover_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of domain names. The query must be covered by one of the domains in order for the rule action to apply.
        """
        return pulumi.get(self, "qname_cover_conditions")

    @qname_cover_conditions.setter
    def qname_cover_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "qname_cover_conditions", value)


@pulumi.input_type
class RrsetItemArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 rdata: pulumi.Input[str],
                 rtype: pulumi.Input[str],
                 ttl: pulumi.Input[int],
                 is_protected: Optional[pulumi.Input[bool]] = None,
                 record_hash: Optional[pulumi.Input[str]] = None,
                 rrset_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: The fully qualified domain name where the record can be located.
        :param pulumi.Input[str] rdata: (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param pulumi.Input[str] rtype: The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        :param pulumi.Input[int] ttl: (Updatable) The Time To Live for the record, in seconds.
        :param pulumi.Input[bool] is_protected: A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        :param pulumi.Input[str] record_hash: A unique identifier for the record within its zone.
        :param pulumi.Input[str] rrset_version: The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "rdata", rdata)
        pulumi.set(__self__, "rtype", rtype)
        pulumi.set(__self__, "ttl", ttl)
        if is_protected is not None:
            pulumi.set(__self__, "is_protected", is_protected)
        if record_hash is not None:
            pulumi.set(__self__, "record_hash", record_hash)
        if rrset_version is not None:
            pulumi.set(__self__, "rrset_version", rrset_version)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The fully qualified domain name where the record can be located.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def rdata(self) -> pulumi.Input[str]:
        """
        (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @rdata.setter
    def rdata(self, value: pulumi.Input[str]):
        pulumi.set(self, "rdata", value)

    @property
    @pulumi.getter
    def rtype(self) -> pulumi.Input[str]:
        """
        The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        """
        return pulumi.get(self, "rtype")

    @rtype.setter
    def rtype(self, value: pulumi.Input[str]):
        pulumi.set(self, "rtype", value)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[int]:
        """
        (Updatable) The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[int]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @is_protected.setter
    def is_protected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_protected", value)

    @property
    @pulumi.getter(name="recordHash")
    def record_hash(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the record within its zone.
        """
        return pulumi.get(self, "record_hash")

    @record_hash.setter
    def record_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_hash", value)

    @property
    @pulumi.getter(name="rrsetVersion")
    def rrset_version(self) -> Optional[pulumi.Input[str]]:
        """
        The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        return pulumi.get(self, "rrset_version")

    @rrset_version.setter
    def rrset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rrset_version", value)


@pulumi.input_type
class SteeringPolicyAnswerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 rdata: pulumi.Input[str],
                 rtype: pulumi.Input[str],
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 pool: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        :param pulumi.Input[str] rdata: The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        :param pulumi.Input[str] rtype: The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        :param pulumi.Input[bool] is_disabled: Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        :param pulumi.Input[str] pool: The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rdata", rdata)
        pulumi.set(__self__, "rtype", rtype)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rdata(self) -> pulumi.Input[str]:
        """
        The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rdata")

    @rdata.setter
    def rdata(self, value: pulumi.Input[str]):
        pulumi.set(self, "rdata", value)

    @property
    @pulumi.getter
    def rtype(self) -> pulumi.Input[str]:
        """
        The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rtype")

    @rtype.setter
    def rtype(self, value: pulumi.Input[str]):
        pulumi.set(self, "rtype", value)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[str]]:
        """
        The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool", value)


@pulumi.input_type
class SteeringPolicyRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input[str],
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseArgs']]]] = None,
                 default_answer_datas: Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleDefaultAnswerDataArgs']]]] = None,
                 default_count: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] rule_type: The type of a rule determines its sorting/filtering behavior.
               * `FILTER` - Filters the list of answers based on their defined boolean data. Answers remain only if their `shouldKeep` value is `true`.
               * `HEALTH` - Removes answers from the list if their `rdata` matches a target in the health check monitor referenced by the steering policy and the target is reported down.
               * `WEIGHTED` - Uses a number between 0 and 255 to determine how often an answer will be served in relation to other answers. Anwers with a higher weight will be served more frequently.
               * `PRIORITY` - Uses a defined rank value of answers to determine which answer to serve, moving those with the lowest values to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
               * `LIMIT` - Filters answers that are too far down the list. Parameter `defaultCount` specifies how many answers to keep. **Example:** If `defaultCount` has a value of `2` and there are five answers left, when the `LIMIT` rule is processed, only the first two answers will remain in the list.
        :param pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseArgs']]] cases: An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        :param pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleDefaultAnswerDataArgs']]] default_answer_datas: Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        :param pulumi.Input[int] default_count: Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        :param pulumi.Input[str] description: A user-defined description of the rule's purpose or behavior.
        """
        pulumi.set(__self__, "rule_type", rule_type)
        if cases is not None:
            pulumi.set(__self__, "cases", cases)
        if default_answer_datas is not None:
            pulumi.set(__self__, "default_answer_datas", default_answer_datas)
        if default_count is not None:
            pulumi.set(__self__, "default_count", default_count)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        The type of a rule determines its sorting/filtering behavior.
        * `FILTER` - Filters the list of answers based on their defined boolean data. Answers remain only if their `shouldKeep` value is `true`.
        * `HEALTH` - Removes answers from the list if their `rdata` matches a target in the health check monitor referenced by the steering policy and the target is reported down.
        * `WEIGHTED` - Uses a number between 0 and 255 to determine how often an answer will be served in relation to other answers. Anwers with a higher weight will be served more frequently.
        * `PRIORITY` - Uses a defined rank value of answers to determine which answer to serve, moving those with the lowest values to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        * `LIMIT` - Filters answers that are too far down the list. Parameter `defaultCount` specifies how many answers to keep. **Example:** If `defaultCount` has a value of `2` and there are five answers left, when the `LIMIT` rule is processed, only the first two answers will remain in the list.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseArgs']]]]:
        """
        An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseArgs']]]]):
        pulumi.set(self, "cases", value)

    @property
    @pulumi.getter(name="defaultAnswerDatas")
    def default_answer_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleDefaultAnswerDataArgs']]]]:
        """
        Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        """
        return pulumi.get(self, "default_answer_datas")

    @default_answer_datas.setter
    def default_answer_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleDefaultAnswerDataArgs']]]]):
        pulumi.set(self, "default_answer_datas", value)

    @property
    @pulumi.getter(name="defaultCount")
    def default_count(self) -> Optional[pulumi.Input[int]]:
        """
        Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        """
        return pulumi.get(self, "default_count")

    @default_count.setter
    def default_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_count", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined description of the rule's purpose or behavior.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class SteeringPolicyRuleCaseArgs:
    def __init__(__self__, *,
                 answer_datas: Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseAnswerDataArgs']]]] = None,
                 case_condition: Optional[pulumi.Input[str]] = None,
                 count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseAnswerDataArgs']]] answer_datas: An array of `SteeringPolicyPriorityAnswerData` objects.
        :param pulumi.Input[str] case_condition: An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        :param pulumi.Input[int] count: The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        if answer_datas is not None:
            pulumi.set(__self__, "answer_datas", answer_datas)
        if case_condition is not None:
            pulumi.set(__self__, "case_condition", case_condition)
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter(name="answerDatas")
    def answer_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseAnswerDataArgs']]]]:
        """
        An array of `SteeringPolicyPriorityAnswerData` objects.
        """
        return pulumi.get(self, "answer_datas")

    @answer_datas.setter
    def answer_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SteeringPolicyRuleCaseAnswerDataArgs']]]]):
        pulumi.set(self, "answer_datas", value)

    @property
    @pulumi.getter(name="caseCondition")
    def case_condition(self) -> Optional[pulumi.Input[str]]:
        """
        An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        """
        return pulumi.get(self, "case_condition")

    @case_condition.setter
    def case_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "case_condition", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)


@pulumi.input_type
class SteeringPolicyRuleCaseAnswerDataArgs:
    def __init__(__self__, *,
                 answer_condition: Optional[pulumi.Input[str]] = None,
                 should_keep: Optional[pulumi.Input[bool]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param pulumi.Input[bool] should_keep: Keeps the answer only if the value is `true`.
        :param pulumi.Input[int] value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        if answer_condition is not None:
            pulumi.set(__self__, "answer_condition", answer_condition)
        if should_keep is not None:
            pulumi.set(__self__, "should_keep", should_keep)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> Optional[pulumi.Input[str]]:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @answer_condition.setter
    def answer_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "answer_condition", value)

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> Optional[pulumi.Input[bool]]:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @should_keep.setter
    def should_keep(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_keep", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SteeringPolicyRuleDefaultAnswerDataArgs:
    def __init__(__self__, *,
                 answer_condition: Optional[pulumi.Input[str]] = None,
                 should_keep: Optional[pulumi.Input[bool]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param pulumi.Input[bool] should_keep: Keeps the answer only if the value is `true`.
        :param pulumi.Input[int] value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        if answer_condition is not None:
            pulumi.set(__self__, "answer_condition", answer_condition)
        if should_keep is not None:
            pulumi.set(__self__, "should_keep", should_keep)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> Optional[pulumi.Input[str]]:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @answer_condition.setter
    def answer_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "answer_condition", value)

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> Optional[pulumi.Input[bool]]:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @should_keep.setter
    def should_keep(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_keep", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ZoneExternalDownstreamArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 tsig_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: (Updatable) The server's IP address (IPv4 or IPv6).
        :param pulumi.Input[int] port: (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        :param pulumi.Input[str] tsig_key_id: (Updatable) The OCID of the TSIG key. A TSIG key is used to secure DNS messages (in this case, zone transfers) between two systems that both have the (shared) secret.
        """
        pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tsig_key_id is not None:
            pulumi.set(__self__, "tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        (Updatable) The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the TSIG key. A TSIG key is used to secure DNS messages (in this case, zone transfers) between two systems that both have the (shared) secret.
        """
        return pulumi.get(self, "tsig_key_id")

    @tsig_key_id.setter
    def tsig_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tsig_key_id", value)


@pulumi.input_type
class ZoneExternalMasterArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 tsig_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: (Updatable) The server's IP address (IPv4 or IPv6).
        :param pulumi.Input[int] port: (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        :param pulumi.Input[str] tsig_key_id: (Updatable) The OCID of the TSIG key.
        """
        pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tsig_key_id is not None:
            pulumi.set(__self__, "tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        (Updatable) The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")

    @tsig_key_id.setter
    def tsig_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tsig_key_id", value)


@pulumi.input_type
class ZoneNameserverArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] hostname: The hostname of the nameserver.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the nameserver.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)


@pulumi.input_type
class ZoneZoneTransferServerArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 is_transfer_destination: Optional[pulumi.Input[bool]] = None,
                 is_transfer_source: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: The server's IP address (IPv4 or IPv6).
        :param pulumi.Input[bool] is_transfer_destination: A Boolean flag indicating whether or not the server is a zone data transfer destination.
        :param pulumi.Input[bool] is_transfer_source: A Boolean flag indicating whether or not the server is a zone data transfer source.
        :param pulumi.Input[int] port: The server's port.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if is_transfer_destination is not None:
            pulumi.set(__self__, "is_transfer_destination", is_transfer_destination)
        if is_transfer_source is not None:
            pulumi.set(__self__, "is_transfer_source", is_transfer_source)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="isTransferDestination")
    def is_transfer_destination(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer destination.
        """
        return pulumi.get(self, "is_transfer_destination")

    @is_transfer_destination.setter
    def is_transfer_destination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transfer_destination", value)

    @property
    @pulumi.getter(name="isTransferSource")
    def is_transfer_source(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer source.
        """
        return pulumi.get(self, "is_transfer_source")

    @is_transfer_source.setter
    def is_transfer_source(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transfer_source", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The server's port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class GetRecordsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetResolverEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of a resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetResolversFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetRrsetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSteeringPoliciesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSteeringPolicyAttachmentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetTsigKeysFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of a resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetViewsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetZonesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


