# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetFleetCryptoAnalysisResultResult',
    'AwaitableGetFleetCryptoAnalysisResultResult',
    'get_fleet_crypto_analysis_result',
    'get_fleet_crypto_analysis_result_output',
]

@pulumi.output_type
class GetFleetCryptoAnalysisResultResult:
    """
    A collection of values returned by getFleetCryptoAnalysisResult.
    """
    def __init__(__self__, aggregation_mode=None, bucket=None, crypto_analysis_result_id=None, crypto_roadmap_version=None, finding_count=None, fleet_id=None, host_name=None, id=None, managed_instance_id=None, namespace=None, non_compliant_finding_count=None, object=None, summarized_event_count=None, time_created=None, time_first_event=None, time_last_event=None, total_event_count=None, work_request_id=None):
        if aggregation_mode and not isinstance(aggregation_mode, str):
            raise TypeError("Expected argument 'aggregation_mode' to be a str")
        pulumi.set(__self__, "aggregation_mode", aggregation_mode)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if crypto_analysis_result_id and not isinstance(crypto_analysis_result_id, str):
            raise TypeError("Expected argument 'crypto_analysis_result_id' to be a str")
        pulumi.set(__self__, "crypto_analysis_result_id", crypto_analysis_result_id)
        if crypto_roadmap_version and not isinstance(crypto_roadmap_version, str):
            raise TypeError("Expected argument 'crypto_roadmap_version' to be a str")
        pulumi.set(__self__, "crypto_roadmap_version", crypto_roadmap_version)
        if finding_count and not isinstance(finding_count, int):
            raise TypeError("Expected argument 'finding_count' to be a int")
        pulumi.set(__self__, "finding_count", finding_count)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if non_compliant_finding_count and not isinstance(non_compliant_finding_count, int):
            raise TypeError("Expected argument 'non_compliant_finding_count' to be a int")
        pulumi.set(__self__, "non_compliant_finding_count", non_compliant_finding_count)
        if object and not isinstance(object, str):
            raise TypeError("Expected argument 'object' to be a str")
        pulumi.set(__self__, "object", object)
        if summarized_event_count and not isinstance(summarized_event_count, int):
            raise TypeError("Expected argument 'summarized_event_count' to be a int")
        pulumi.set(__self__, "summarized_event_count", summarized_event_count)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_first_event and not isinstance(time_first_event, str):
            raise TypeError("Expected argument 'time_first_event' to be a str")
        pulumi.set(__self__, "time_first_event", time_first_event)
        if time_last_event and not isinstance(time_last_event, str):
            raise TypeError("Expected argument 'time_last_event' to be a str")
        pulumi.set(__self__, "time_last_event", time_last_event)
        if total_event_count and not isinstance(total_event_count, int):
            raise TypeError("Expected argument 'total_event_count' to be a int")
        pulumi.set(__self__, "total_event_count", total_event_count)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="aggregationMode")
    def aggregation_mode(self) -> str:
        """
        The result aggregation mode
        """
        return pulumi.get(self, "aggregation_mode")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Object Storage bucket name of this analysis result.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cryptoAnalysisResultId")
    def crypto_analysis_result_id(self) -> str:
        return pulumi.get(self, "crypto_analysis_result_id")

    @property
    @pulumi.getter(name="cryptoRoadmapVersion")
    def crypto_roadmap_version(self) -> str:
        """
        The Crypto Roadmap version used to perform the analysis.
        """
        return pulumi.get(self, "crypto_roadmap_version")

    @property
    @pulumi.getter(name="findingCount")
    def finding_count(self) -> int:
        """
        Total number of findings with the analysis.
        """
        return pulumi.get(self, "finding_count")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        The fleet OCID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The hostname of the managed instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> str:
        """
        The managed instance OCID.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace of this analysis result.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nonCompliantFindingCount")
    def non_compliant_finding_count(self) -> int:
        """
        Total number of non-compliant findings with the analysis. A non-compliant finding means the application won't work properly with the changes introduced by the Crypto Roadmap version used by the analysis.
        """
        return pulumi.get(self, "non_compliant_finding_count")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The Object Storage object name of this analysis result.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="summarizedEventCount")
    def summarized_event_count(self) -> int:
        """
        Total number of summarized events. Summarized events are deduplicated events of interest.
        """
        return pulumi.get(self, "summarized_event_count")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the result is compiled.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFirstEvent")
    def time_first_event(self) -> str:
        """
        Time of the first event in the analysis.
        """
        return pulumi.get(self, "time_first_event")

    @property
    @pulumi.getter(name="timeLastEvent")
    def time_last_event(self) -> str:
        """
        Time of the last event in the analysis.
        """
        return pulumi.get(self, "time_last_event")

    @property
    @pulumi.getter(name="totalEventCount")
    def total_event_count(self) -> int:
        """
        Total number of events in the analysis.
        """
        return pulumi.get(self, "total_event_count")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> str:
        """
        The OCID of the work request to start the analysis.
        """
        return pulumi.get(self, "work_request_id")


class AwaitableGetFleetCryptoAnalysisResultResult(GetFleetCryptoAnalysisResultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetCryptoAnalysisResultResult(
            aggregation_mode=self.aggregation_mode,
            bucket=self.bucket,
            crypto_analysis_result_id=self.crypto_analysis_result_id,
            crypto_roadmap_version=self.crypto_roadmap_version,
            finding_count=self.finding_count,
            fleet_id=self.fleet_id,
            host_name=self.host_name,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            namespace=self.namespace,
            non_compliant_finding_count=self.non_compliant_finding_count,
            object=self.object,
            summarized_event_count=self.summarized_event_count,
            time_created=self.time_created,
            time_first_event=self.time_first_event,
            time_last_event=self.time_last_event,
            total_event_count=self.total_event_count,
            work_request_id=self.work_request_id)


def get_fleet_crypto_analysis_result(crypto_analysis_result_id: Optional[str] = None,
                                     fleet_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetCryptoAnalysisResultResult:
    """
    This data source provides details about a specific Fleet Crypto Analysis Result resource in Oracle Cloud Infrastructure Jms service.

    Retrieve the metadata for the result of a Crypto event analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_crypto_analysis_result = oci.Jms.get_fleet_crypto_analysis_result(crypto_analysis_result_id=test_result["id"],
        fleet_id=test_fleet["id"])
    ```


    :param str crypto_analysis_result_id: The OCID of the analysis result.
    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['cryptoAnalysisResultId'] = crypto_analysis_result_id
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetCryptoAnalysisResult:getFleetCryptoAnalysisResult', __args__, opts=opts, typ=GetFleetCryptoAnalysisResultResult).value

    return AwaitableGetFleetCryptoAnalysisResultResult(
        aggregation_mode=pulumi.get(__ret__, 'aggregation_mode'),
        bucket=pulumi.get(__ret__, 'bucket'),
        crypto_analysis_result_id=pulumi.get(__ret__, 'crypto_analysis_result_id'),
        crypto_roadmap_version=pulumi.get(__ret__, 'crypto_roadmap_version'),
        finding_count=pulumi.get(__ret__, 'finding_count'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        non_compliant_finding_count=pulumi.get(__ret__, 'non_compliant_finding_count'),
        object=pulumi.get(__ret__, 'object'),
        summarized_event_count=pulumi.get(__ret__, 'summarized_event_count'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_first_event=pulumi.get(__ret__, 'time_first_event'),
        time_last_event=pulumi.get(__ret__, 'time_last_event'),
        total_event_count=pulumi.get(__ret__, 'total_event_count'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))


@_utilities.lift_output_func(get_fleet_crypto_analysis_result)
def get_fleet_crypto_analysis_result_output(crypto_analysis_result_id: Optional[pulumi.Input[str]] = None,
                                            fleet_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetCryptoAnalysisResultResult]:
    """
    This data source provides details about a specific Fleet Crypto Analysis Result resource in Oracle Cloud Infrastructure Jms service.

    Retrieve the metadata for the result of a Crypto event analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_crypto_analysis_result = oci.Jms.get_fleet_crypto_analysis_result(crypto_analysis_result_id=test_result["id"],
        fleet_id=test_fleet["id"])
    ```


    :param str crypto_analysis_result_id: The OCID of the analysis result.
    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    ...
