# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetProductLicenseResult',
    'AwaitableGetProductLicenseResult',
    'get_product_license',
    'get_product_license_output',
]

@pulumi.output_type
class GetProductLicenseResult:
    """
    A collection of values returned by getProductLicense.
    """
    def __init__(__self__, active_license_record_count=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, images=None, is_over_subscribed=None, is_unlimited=None, is_vendor_oracle=None, license_unit=None, product_license_id=None, state=None, status=None, status_description=None, system_tags=None, time_created=None, time_updated=None, total_active_license_unit_count=None, total_license_record_count=None, total_license_units_consumed=None, vendor_name=None):
        if active_license_record_count and not isinstance(active_license_record_count, int):
            raise TypeError("Expected argument 'active_license_record_count' to be a int")
        pulumi.set(__self__, "active_license_record_count", active_license_record_count)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if is_over_subscribed and not isinstance(is_over_subscribed, bool):
            raise TypeError("Expected argument 'is_over_subscribed' to be a bool")
        pulumi.set(__self__, "is_over_subscribed", is_over_subscribed)
        if is_unlimited and not isinstance(is_unlimited, bool):
            raise TypeError("Expected argument 'is_unlimited' to be a bool")
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        if is_vendor_oracle and not isinstance(is_vendor_oracle, bool):
            raise TypeError("Expected argument 'is_vendor_oracle' to be a bool")
        pulumi.set(__self__, "is_vendor_oracle", is_vendor_oracle)
        if license_unit and not isinstance(license_unit, str):
            raise TypeError("Expected argument 'license_unit' to be a str")
        pulumi.set(__self__, "license_unit", license_unit)
        if product_license_id and not isinstance(product_license_id, str):
            raise TypeError("Expected argument 'product_license_id' to be a str")
        pulumi.set(__self__, "product_license_id", product_license_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_description and not isinstance(status_description, str):
            raise TypeError("Expected argument 'status_description' to be a str")
        pulumi.set(__self__, "status_description", status_description)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if total_active_license_unit_count and not isinstance(total_active_license_unit_count, int):
            raise TypeError("Expected argument 'total_active_license_unit_count' to be a int")
        pulumi.set(__self__, "total_active_license_unit_count", total_active_license_unit_count)
        if total_license_record_count and not isinstance(total_license_record_count, int):
            raise TypeError("Expected argument 'total_license_record_count' to be a int")
        pulumi.set(__self__, "total_license_record_count", total_license_record_count)
        if total_license_units_consumed and not isinstance(total_license_units_consumed, float):
            raise TypeError("Expected argument 'total_license_units_consumed' to be a float")
        pulumi.set(__self__, "total_license_units_consumed", total_license_units_consumed)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="activeLicenseRecordCount")
    def active_license_record_count(self) -> int:
        """
        The number of active license records associated with the product license.
        """
        return pulumi.get(self, "active_license_record_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the product license is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        License record name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetProductLicenseImageResult']:
        """
        The images associated with the product license.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="isOverSubscribed")
    def is_over_subscribed(self) -> bool:
        """
        Specifies whether or not the product license is oversubscribed.
        """
        return pulumi.get(self, "is_over_subscribed")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> bool:
        """
        Specifies if the license unit count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="isVendorOracle")
    def is_vendor_oracle(self) -> bool:
        """
        Specifies whether the vendor is Oracle or a third party.
        """
        return pulumi.get(self, "is_vendor_oracle")

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> str:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> str:
        return pulumi.get(self, "product_license_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current product license state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current product license status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> str:
        """
        Status description for the current product license status.
        """
        return pulumi.get(self, "status_description")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalActiveLicenseUnitCount")
    def total_active_license_unit_count(self) -> int:
        """
        The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        """
        return pulumi.get(self, "total_active_license_unit_count")

    @property
    @pulumi.getter(name="totalLicenseRecordCount")
    def total_license_record_count(self) -> int:
        """
        The number of license records associated with the product license.
        """
        return pulumi.get(self, "total_license_record_count")

    @property
    @pulumi.getter(name="totalLicenseUnitsConsumed")
    def total_license_units_consumed(self) -> float:
        """
        The number of license units consumed. Updated after each allocation run.
        """
        return pulumi.get(self, "total_license_units_consumed")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> str:
        """
        The vendor of the ProductLicense
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetProductLicenseResult(GetProductLicenseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductLicenseResult(
            active_license_record_count=self.active_license_record_count,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            images=self.images,
            is_over_subscribed=self.is_over_subscribed,
            is_unlimited=self.is_unlimited,
            is_vendor_oracle=self.is_vendor_oracle,
            license_unit=self.license_unit,
            product_license_id=self.product_license_id,
            state=self.state,
            status=self.status,
            status_description=self.status_description,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            total_active_license_unit_count=self.total_active_license_unit_count,
            total_license_record_count=self.total_license_record_count,
            total_license_units_consumed=self.total_license_units_consumed,
            vendor_name=self.vendor_name)


def get_product_license(product_license_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductLicenseResult:
    """
    This data source provides details about a specific Product License resource in Oracle Cloud Infrastructure License Manager service.

    Retrieves product license details by product license ID in a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_license = oci.LicenseManager.get_product_license(product_license_id=test_product_license_oci_license_manager_product_license["id"])
    ```


    :param str product_license_id: Unique product license identifier.
    """
    __args__ = dict()
    __args__['productLicenseId'] = product_license_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LicenseManager/getProductLicense:getProductLicense', __args__, opts=opts, typ=GetProductLicenseResult).value

    return AwaitableGetProductLicenseResult(
        active_license_record_count=pulumi.get(__ret__, 'active_license_record_count'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        images=pulumi.get(__ret__, 'images'),
        is_over_subscribed=pulumi.get(__ret__, 'is_over_subscribed'),
        is_unlimited=pulumi.get(__ret__, 'is_unlimited'),
        is_vendor_oracle=pulumi.get(__ret__, 'is_vendor_oracle'),
        license_unit=pulumi.get(__ret__, 'license_unit'),
        product_license_id=pulumi.get(__ret__, 'product_license_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        status_description=pulumi.get(__ret__, 'status_description'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        total_active_license_unit_count=pulumi.get(__ret__, 'total_active_license_unit_count'),
        total_license_record_count=pulumi.get(__ret__, 'total_license_record_count'),
        total_license_units_consumed=pulumi.get(__ret__, 'total_license_units_consumed'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))


@_utilities.lift_output_func(get_product_license)
def get_product_license_output(product_license_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProductLicenseResult]:
    """
    This data source provides details about a specific Product License resource in Oracle Cloud Infrastructure License Manager service.

    Retrieves product license details by product license ID in a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_license = oci.LicenseManager.get_product_license(product_license_id=test_product_license_oci_license_manager_product_license["id"])
    ```


    :param str product_license_id: Unique product license identifier.
    """
    ...
