# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetScheduledJobsResult',
    'AwaitableGetScheduledJobsResult',
    'get_scheduled_jobs',
    'get_scheduled_jobs_output',
]

@pulumi.output_type
class GetScheduledJobsResult:
    """
    A collection of values returned by getScheduledJobs.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, display_name=None, display_name_contains=None, filters=None, id=None, is_managed_by_autonomous_linux=None, is_restricted=None, lifecycle_stage_id=None, location_not_equal_tos=None, locations=None, managed_compartment_id=None, managed_instance_group_id=None, managed_instance_id=None, operation_type=None, schedule_type=None, scheduled_job_collections=None, state=None, time_end=None, time_start=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_managed_by_autonomous_linux and not isinstance(is_managed_by_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_managed_by_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if is_restricted and not isinstance(is_restricted, bool):
            raise TypeError("Expected argument 'is_restricted' to be a bool")
        pulumi.set(__self__, "is_restricted", is_restricted)
        if lifecycle_stage_id and not isinstance(lifecycle_stage_id, str):
            raise TypeError("Expected argument 'lifecycle_stage_id' to be a str")
        pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if location_not_equal_tos and not isinstance(location_not_equal_tos, list):
            raise TypeError("Expected argument 'location_not_equal_tos' to be a list")
        pulumi.set(__self__, "location_not_equal_tos", location_not_equal_tos)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if managed_compartment_id and not isinstance(managed_compartment_id, str):
            raise TypeError("Expected argument 'managed_compartment_id' to be a str")
        pulumi.set(__self__, "managed_compartment_id", managed_compartment_id)
        if managed_instance_group_id and not isinstance(managed_instance_group_id, str):
            raise TypeError("Expected argument 'managed_instance_group_id' to be a str")
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if operation_type and not isinstance(operation_type, str):
            raise TypeError("Expected argument 'operation_type' to be a str")
        pulumi.set(__self__, "operation_type", operation_type)
        if schedule_type and not isinstance(schedule_type, str):
            raise TypeError("Expected argument 'schedule_type' to be a str")
        pulumi.set(__self__, "schedule_type", schedule_type)
        if scheduled_job_collections and not isinstance(scheduled_job_collections, list):
            raise TypeError("Expected argument 'scheduled_job_collections' to be a list")
        pulumi.set(__self__, "scheduled_job_collections", scheduled_job_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the scheduled job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        User-friendly name for the scheduled job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetScheduledJobsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[bool]:
        """
        Indicates whether this scheduled job is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> Optional[bool]:
        """
        Indicates if the schedule job has restricted update and deletion capabilities. For restricted scheduled jobs,  you can update only the timeNextExecution, recurringRule, and tags.
        """
        return pulumi.get(self, "is_restricted")

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> Optional[str]:
        return pulumi.get(self, "lifecycle_stage_id")

    @property
    @pulumi.getter(name="locationNotEqualTos")
    def location_not_equal_tos(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "location_not_equal_tos")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="managedCompartmentId")
    def managed_compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_compartment_id")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[str]:
        """
        The type of operation this scheduled job performs.
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> Optional[str]:
        """
        The type of scheduling frequency for the job.
        """
        return pulumi.get(self, "schedule_type")

    @property
    @pulumi.getter(name="scheduledJobCollections")
    def scheduled_job_collections(self) -> Sequence['outputs.GetScheduledJobsScheduledJobCollectionResult']:
        """
        The list of scheduled_job_collection.
        """
        return pulumi.get(self, "scheduled_job_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the scheduled job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[str]:
        return pulumi.get(self, "time_start")


class AwaitableGetScheduledJobsResult(GetScheduledJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledJobsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            id=self.id,
            is_managed_by_autonomous_linux=self.is_managed_by_autonomous_linux,
            is_restricted=self.is_restricted,
            lifecycle_stage_id=self.lifecycle_stage_id,
            location_not_equal_tos=self.location_not_equal_tos,
            locations=self.locations,
            managed_compartment_id=self.managed_compartment_id,
            managed_instance_group_id=self.managed_instance_group_id,
            managed_instance_id=self.managed_instance_id,
            operation_type=self.operation_type,
            schedule_type=self.schedule_type,
            scheduled_job_collections=self.scheduled_job_collections,
            state=self.state,
            time_end=self.time_end,
            time_start=self.time_start)


def get_scheduled_jobs(compartment_id: Optional[str] = None,
                       compartment_id_in_subtree: Optional[bool] = None,
                       display_name: Optional[str] = None,
                       display_name_contains: Optional[str] = None,
                       filters: Optional[Sequence[pulumi.InputType['GetScheduledJobsFilterArgs']]] = None,
                       id: Optional[str] = None,
                       is_managed_by_autonomous_linux: Optional[bool] = None,
                       is_restricted: Optional[bool] = None,
                       lifecycle_stage_id: Optional[str] = None,
                       location_not_equal_tos: Optional[Sequence[str]] = None,
                       locations: Optional[Sequence[str]] = None,
                       managed_compartment_id: Optional[str] = None,
                       managed_instance_group_id: Optional[str] = None,
                       managed_instance_id: Optional[str] = None,
                       operation_type: Optional[str] = None,
                       schedule_type: Optional[str] = None,
                       state: Optional[str] = None,
                       time_end: Optional[str] = None,
                       time_start: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledJobsResult:
    """
    This data source provides the list of Scheduled Jobs in Oracle Cloud Infrastructure Os Management Hub service.

    Lists scheduled jobs that match the specified compartment or scheduled job [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_jobs = oci.OsManagementHub.get_scheduled_jobs(compartment_id=compartment_id,
        compartment_id_in_subtree=scheduled_job_compartment_id_in_subtree,
        display_name=scheduled_job_display_name,
        display_name_contains=scheduled_job_display_name_contains,
        id=scheduled_job_id,
        is_managed_by_autonomous_linux=scheduled_job_is_managed_by_autonomous_linux,
        is_restricted=scheduled_job_is_restricted,
        lifecycle_stage_id=test_lifecycle_stage["id"],
        locations=scheduled_job_location,
        location_not_equal_tos=scheduled_job_location_not_equal_to,
        managed_compartment_id=test_compartment["id"],
        managed_instance_group_id=test_managed_instance_group["id"],
        managed_instance_id=test_managed_instance["id"],
        operation_type=scheduled_job_operation_type,
        schedule_type=scheduled_job_schedule_type,
        state=scheduled_job_state,
        time_end=scheduled_job_time_end,
        time_start=scheduled_job_time_start)
    ```


    :param str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param bool compartment_id_in_subtree: Indicates whether to include subcompartments in the returned results. Default is false.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job. A filter to return the specified job.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param bool is_restricted: A filter to return only restricted scheduled jobs.
    :param str lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage. This resource returns resources associated with this lifecycle stage.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str managed_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed compartment. This filter returns resources associated with this compartment.
    :param str managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group. This filter returns resources associated with this group.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance. This filter returns resources associated with this managed instance.
    :param str operation_type: A filter to return only scheduled jobs with the given operation type.
    :param str schedule_type: A filter to return only scheduled jobs of the given scheduling type (one-time or recurring).
    :param str state: A filter to return only scheduled jobs currently in the given state.
    :param str time_end: A filter to return only resources with a date on or before the given value, in ISO 8601 format.  Example: 2017-07-14T02:40:00.000Z
    :param str time_start: A filter to return only resources with a date on or after the given value, in ISO 8601 format.  Example: 2017-07-14T02:40:00.000Z
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isManagedByAutonomousLinux'] = is_managed_by_autonomous_linux
    __args__['isRestricted'] = is_restricted
    __args__['lifecycleStageId'] = lifecycle_stage_id
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['managedCompartmentId'] = managed_compartment_id
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['operationType'] = operation_type
    __args__['scheduleType'] = schedule_type
    __args__['state'] = state
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getScheduledJobs:getScheduledJobs', __args__, opts=opts, typ=GetScheduledJobsResult).value

    return AwaitableGetScheduledJobsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_managed_by_autonomous_linux=pulumi.get(__ret__, 'is_managed_by_autonomous_linux'),
        is_restricted=pulumi.get(__ret__, 'is_restricted'),
        lifecycle_stage_id=pulumi.get(__ret__, 'lifecycle_stage_id'),
        location_not_equal_tos=pulumi.get(__ret__, 'location_not_equal_tos'),
        locations=pulumi.get(__ret__, 'locations'),
        managed_compartment_id=pulumi.get(__ret__, 'managed_compartment_id'),
        managed_instance_group_id=pulumi.get(__ret__, 'managed_instance_group_id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        operation_type=pulumi.get(__ret__, 'operation_type'),
        schedule_type=pulumi.get(__ret__, 'schedule_type'),
        scheduled_job_collections=pulumi.get(__ret__, 'scheduled_job_collections'),
        state=pulumi.get(__ret__, 'state'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_scheduled_jobs)
def get_scheduled_jobs_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                              compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetScheduledJobsFilterArgs']]]]] = None,
                              id: Optional[pulumi.Input[Optional[str]]] = None,
                              is_managed_by_autonomous_linux: Optional[pulumi.Input[Optional[bool]]] = None,
                              is_restricted: Optional[pulumi.Input[Optional[bool]]] = None,
                              lifecycle_stage_id: Optional[pulumi.Input[Optional[str]]] = None,
                              location_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              locations: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              managed_compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                              managed_instance_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                              managed_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                              operation_type: Optional[pulumi.Input[Optional[str]]] = None,
                              schedule_type: Optional[pulumi.Input[Optional[str]]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              time_end: Optional[pulumi.Input[Optional[str]]] = None,
                              time_start: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScheduledJobsResult]:
    """
    This data source provides the list of Scheduled Jobs in Oracle Cloud Infrastructure Os Management Hub service.

    Lists scheduled jobs that match the specified compartment or scheduled job [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_jobs = oci.OsManagementHub.get_scheduled_jobs(compartment_id=compartment_id,
        compartment_id_in_subtree=scheduled_job_compartment_id_in_subtree,
        display_name=scheduled_job_display_name,
        display_name_contains=scheduled_job_display_name_contains,
        id=scheduled_job_id,
        is_managed_by_autonomous_linux=scheduled_job_is_managed_by_autonomous_linux,
        is_restricted=scheduled_job_is_restricted,
        lifecycle_stage_id=test_lifecycle_stage["id"],
        locations=scheduled_job_location,
        location_not_equal_tos=scheduled_job_location_not_equal_to,
        managed_compartment_id=test_compartment["id"],
        managed_instance_group_id=test_managed_instance_group["id"],
        managed_instance_id=test_managed_instance["id"],
        operation_type=scheduled_job_operation_type,
        schedule_type=scheduled_job_schedule_type,
        state=scheduled_job_state,
        time_end=scheduled_job_time_end,
        time_start=scheduled_job_time_start)
    ```


    :param str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param bool compartment_id_in_subtree: Indicates whether to include subcompartments in the returned results. Default is false.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job. A filter to return the specified job.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param bool is_restricted: A filter to return only restricted scheduled jobs.
    :param str lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage. This resource returns resources associated with this lifecycle stage.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str managed_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed compartment. This filter returns resources associated with this compartment.
    :param str managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group. This filter returns resources associated with this group.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance. This filter returns resources associated with this managed instance.
    :param str operation_type: A filter to return only scheduled jobs with the given operation type.
    :param str schedule_type: A filter to return only scheduled jobs of the given scheduling type (one-time or recurring).
    :param str state: A filter to return only scheduled jobs currently in the given state.
    :param str time_end: A filter to return only resources with a date on or before the given value, in ISO 8601 format.  Example: 2017-07-14T02:40:00.000Z
    :param str time_start: A filter to return only resources with a date on or after the given value, in ISO 8601 format.  Example: 2017-07-14T02:40:00.000Z
    """
    ...
