

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_lwk_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_lwk_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_lwk_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("lwk")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 26
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_lwk_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_lwk_checksum_func_is_provably_segwit() != 25275:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_is_blinded() != 34440:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_qr_code_text() != 34918:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_qr_code_uri() != 36127:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_script_pubkey() != 23569:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_address_to_unconfidential() != 28990:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_addressresult_address() != 57079:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_addressresult_index() != 6170:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_amp2_cosign() != 5581:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_amp2_descriptor_from_str() != 752:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_amp2_register() != 53300:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_amp2descriptor_descriptor() != 61502:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_assetamount_amount() != 1080:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_assetamount_asset() != 31724:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_electrumclient_broadcast() != 41537:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_electrumclient_full_scan() != 5919:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_electrumclient_full_scan_to_index() != 64210:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_electrumclient_get_tx() != 11605:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_electrumclient_ping() != 49466:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_esploraclient_broadcast() != 54439:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_esploraclient_full_scan() != 27446:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_esploraclient_full_scan_to_index() != 37814:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_foreignpersister_get() != 54855:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_foreignpersister_push() != 22972:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_asset() != 59545:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_asset_satoshi() != 13924:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_is_confidential() != 28108:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_is_issuance() != 36847:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_is_null() != 41097:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_is_reissuance() != 19752:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_prev_txid() != 29158:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_prev_vout() != 47940:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_token() != 31197:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_issuance_token_satoshi() != 10642:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_lwktestenv_electrum_url() != 55646:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_lwktestenv_generate() != 26765:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_lwktestenv_get_new_address() != 19321:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_lwktestenv_height() != 2430:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_lwktestenv_issue_asset() != 1145:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_lwktestenv_send_to_address() != 56643:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_default_electrum_client() != 57493:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_default_esplora_client() != 7540:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_is_mainnet() != 38901:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_policy_asset() != 61043:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_network_tx_builder() != 62021:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_outpoint_txid() != 59660:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_outpoint_vout() != 56493:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_precision_sats_to_string() != 20274:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_precision_string_to_sats() != 26556:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_combine() != 29157:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_extract_tx() != 24108:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_finalize() != 8805:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_inputs() != 59953:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_pset_unique_id() != 39035:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetbalance_balances() != 30248:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetbalance_fee() != 45919:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetbalance_recipients() != 28110:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetdetails_balance() != 56410:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetdetails_inputs_issuances() != 57319:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetdetails_signatures() != 49463:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetinput_issuance() != 24131:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetinput_issuance_asset() != 63028:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetinput_issuance_token() != 28592:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetinput_previous_script_pubkey() != 29126:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetinput_previous_txid() != 21436:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetinput_previous_vout() != 7375:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetinput_redeem_script() != 44187:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetsignatures_has_signature() != 62742:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_psetsignatures_missing_signature() != 6208:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_recipient_address() != 44409:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_recipient_asset() != 23419:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_recipient_value() != 39598:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_recipient_vout() != 24321:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_script_asm() != 38627:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_script_bytes() != 31898:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_script_is_provably_unspendable() != 33321:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_secretkey_bytes() != 44270:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_secretkey_sign() != 47116:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_signer_keyorigin_xpub() != 15198:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_signer_mnemonic() != 29480:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_signer_sign() != 38559:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_signer_singlesig_desc() != 28847:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_signer_wpkh_slip77_descriptor() != 55215:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_bytes() != 35387:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_fee() != 42284:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_inputs() != 51474:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_outputs() != 59927:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_transaction_txid() != 8927:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_add_burn() != 9804:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_add_external_utxos() != 29722:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_add_lbtc_recipient() != 895:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_add_recipient() != 56700:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_to() != 34381:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_wallet() != 46356:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_fee_rate() != 26118:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_finish() != 3994:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_issue_asset() != 32494:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_liquidex_make() != 47954:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_liquidex_take() != 14367:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_reissue_asset() != 54385:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txbuilder_set_wallet_utxos() != 12661:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txin_outpoint() != 60750:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txout_asset() != 43008:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txout_is_fee() != 30808:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txout_is_partially_blinded() != 10893:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txout_script_pubkey() != 7466:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txout_unblind() != 11168:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txout_unconfidential_address() != 3790:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txout_value() != 6745:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_asset() != 21742:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_asset_bf() != 27606:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_asset_commitment() != 16600:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_is_explicit() != 10268:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_value() != 64117:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_value_bf() != 4095:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txoutsecrets_value_commitment() != 41762:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_txid_bytes() != 15950:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_insecure_validate() != 63611:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_needed_tx() != 61339:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_validate() != 39721:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_update_only_tip() != 55966:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_update_serialize() != 9990:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_validatedliquidexproposal_input() != 49227:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_validatedliquidexproposal_output() != 43380:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_balance() != 44398:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_fee() != 39011:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_height() != 12656:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_inputs() != 3951:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_outputs() != 55588:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_timestamp() != 12633:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_tx() != 23689:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_txid() != 36652:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_type_() != 59416:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettx_unblinded_url() != 45766:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_address() != 55633:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_ext_int() != 60402:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_height() != 50237:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_outpoint() != 58785:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_script_pubkey() != 50610:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_unblinded() != 57421:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wallettxout_wildcard_index() != 49286:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_add_details() != 42615:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_address() != 14903:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_apply_update() != 55233:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_balance() != 6265:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_descriptor() != 25068:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_extract_wallet_utxos() != 43538:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_finalize() != 63816:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_is_segwit() != 18539:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_max_weight_to_satisfy() != 8240:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_pset_details() != 45882:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_transactions() != 35692:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_transactions_paginated() != 32144:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_txos() != 19061:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_unblind_utxos_with() != 51999:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_utxos() != 3120:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wollet_wait_for_tx() != 47828:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wolletdescriptor_derive_blinding_key() != 27121:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wolletdescriptor_is_mainnet() != 62487:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_method_wolletdescriptor_script_pubkey() != 21566:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_address_new() != 52129:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_amp2_new_testnet() != 61837:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_bip_new_bip49() != 34169:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_bip_new_bip84() != 26707:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_bip_new_bip87() != 60988:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_contract_new() != 55905:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_electrumclient_new() != 26281:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_esploraclient_from_builder() != 10195:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_esploraclient_new() != 42490:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_esploraclient_new_waterfalls() != 40758:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_externalutxo_new() != 40531:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_foreignpersisterlink_new() != 13549:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_lwktestenv_new() != 23847:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_mnemonic_from_entropy() != 36360:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_mnemonic_from_random() != 35644:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_mnemonic_new() != 33187:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_mainnet() != 55931:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_regtest() != 26689:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_regtest_default() != 53192:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_network_testnet() != 37103:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_outpoint_new() != 61639:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_precision_new() != 7694:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_pset_new() != 61694:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_script_new() != 43814:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_secretkey_from_bytes() != 14021:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_secretkey_from_wif() != 46565:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_signer_new() != 16701:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_signer_random() != 54097:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_transaction_new() != 3065:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_txbuilder_new() != 56158:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_txid_new() != 63870:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_unvalidatedliquidexproposal_from_pset() != 42031:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_unvalidatedliquidexproposal_new() != 8682:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_update_new() != 35370:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_wollet_new() != 15308:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_wollet_with_custom_persister() != 63220:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_lwk_checksum_constructor_wolletdescriptor_new() != 57700:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UNIFFI_CALLBACK_INTERFACE_FOREIGN_PERSISTER_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_uint64,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_FOREIGN_PERSISTER_METHOD1 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_void_p,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
class _UniffiVTableCallbackInterfaceForeignPersister(ctypes.Structure):
    _fields_ = [
        ("get", _UNIFFI_CALLBACK_INTERFACE_FOREIGN_PERSISTER_METHOD0),
        ("push", _UNIFFI_CALLBACK_INTERFACE_FOREIGN_PERSISTER_METHOD1),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
_UniffiLib.uniffi_lwk_fn_clone_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_address.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_address_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_address_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_address_is_blinded.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_is_blinded.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_text.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_text.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_uri.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_qr_code_uri.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_address_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_address_to_unconfidential.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_to_unconfidential.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_address_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_address_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_addressresult.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_addressresult.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_addressresult.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_addressresult.restype = None
_UniffiLib.uniffi_lwk_fn_method_addressresult_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_addressresult_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_addressresult_index.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_addressresult_index.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_clone_amp2.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_amp2.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_amp2.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_amp2.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_amp2_new_testnet.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_amp2_new_testnet.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_amp2_cosign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_amp2_cosign.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_amp2_descriptor_from_str.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_amp2_descriptor_from_str.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_amp2_register.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_amp2_register.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_amp2descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_amp2descriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_amp2descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_amp2descriptor.restype = None
_UniffiLib.uniffi_lwk_fn_method_amp2descriptor_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_amp2descriptor_descriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_amp2descriptor_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_amp2descriptor_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_assetamount.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_assetamount.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_assetamount.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_assetamount.restype = None
_UniffiLib.uniffi_lwk_fn_method_assetamount_amount.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_assetamount_amount.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_assetamount_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_assetamount_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_bip.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_bip.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_bip.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_bip.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip49.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip49.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip84.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip84.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip87.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip87.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_contract.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_contract.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_contract.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_contract.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_contract_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    _UniffiRustBuffer,
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_contract_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_contract_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_contract_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_electrumclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_electrumclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_electrumclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_electrumclient.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_electrumclient_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_electrumclient_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_electrumclient_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_electrumclient_broadcast.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan_to_index.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan_to_index.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_electrumclient_get_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_electrumclient_get_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_electrumclient_ping.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_electrumclient_ping.restype = None
_UniffiLib.uniffi_lwk_fn_clone_esploraclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_esploraclient.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_esploraclient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_esploraclient.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_from_builder.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_from_builder.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new_waterfalls.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new_waterfalls.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_esploraclient_broadcast.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_esploraclient_broadcast.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan_to_index.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan_to_index.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_externalutxo.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_externalutxo.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_externalutxo.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_externalutxo.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_externalutxo_new.argtypes = (
    ctypes.c_uint32,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_externalutxo_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_foreignpersister.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_foreignpersister.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_foreignpersister.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_foreignpersister.restype = None
_UniffiLib.uniffi_lwk_fn_init_callback_vtable_foreignpersister.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceForeignPersister),
)
_UniffiLib.uniffi_lwk_fn_init_callback_vtable_foreignpersister.restype = None
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_get.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_get.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_push.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_foreignpersister_push.restype = None
_UniffiLib.uniffi_lwk_fn_clone_foreignpersisterlink.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_foreignpersisterlink.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_foreignpersisterlink.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_foreignpersisterlink.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_foreignpersisterlink_new.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_foreignpersisterlink_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_issuance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_issuance.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_issuance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_issuance.restype = None
_UniffiLib.uniffi_lwk_fn_method_issuance_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_issuance_asset_satoshi.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_asset_satoshi.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_issuance_is_confidential.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_is_confidential.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_issuance_is_issuance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_is_issuance.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_issuance_is_null.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_is_null.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_issuance_is_reissuance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_is_reissuance.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_issuance_prev_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_prev_txid.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_issuance_prev_vout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_prev_vout.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_issuance_token.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_token.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_issuance_token_satoshi.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_issuance_token_satoshi.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_lwktestenv.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_lwktestenv.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_lwktestenv.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_lwktestenv.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_lwktestenv_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_lwktestenv_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_electrum_url.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_electrum_url.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_generate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_generate.restype = None
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_get_new_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_get_new_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_height.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_issue_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_issue_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_send_to_address.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_lwktestenv_send_to_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_mnemonic.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_mnemonic.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_from_entropy.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_from_entropy.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_from_random.argtypes = (
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_from_random.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_mnemonic_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_mnemonic_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_network.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_network.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_network.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_network_mainnet.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_mainnet.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest_default.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_regtest_default.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_network_testnet.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_network_testnet.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_default_electrum_client.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_default_electrum_client.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_default_esplora_client.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_default_esplora_client.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_is_mainnet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_is_mainnet.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_network_policy_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_policy_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_network_tx_builder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_tx_builder.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_network_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_network_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_outpoint.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_outpoint.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_outpoint_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_outpoint_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_outpoint_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_outpoint_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_outpoint_vout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_outpoint_vout.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_method_outpoint_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_outpoint_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_precision.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_precision.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_precision.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_precision.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_precision_new.argtypes = (
    ctypes.c_uint8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_precision_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_precision_sats_to_string.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_precision_sats_to_string.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_precision_string_to_sats.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_precision_string_to_sats.restype = ctypes.c_int64
_UniffiLib.uniffi_lwk_fn_clone_pset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_pset.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_pset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_pset.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_pset_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_pset_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_pset_combine.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_combine.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_pset_extract_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_extract_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_pset_finalize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_finalize.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_pset_inputs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_inputs.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_pset_unique_id.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_unique_id.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_pset_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_pset_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_psetbalance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_psetbalance.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_psetbalance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_psetbalance.restype = None
_UniffiLib.uniffi_lwk_fn_method_psetbalance_balances.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetbalance_balances.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_psetbalance_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetbalance_fee.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_psetbalance_recipients.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetbalance_recipients.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_psetdetails.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_psetdetails.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_psetdetails.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_psetdetails.restype = None
_UniffiLib.uniffi_lwk_fn_method_psetdetails_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetdetails_balance.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_psetdetails_inputs_issuances.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetdetails_inputs_issuances.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_psetdetails_signatures.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetdetails_signatures.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_psetinput.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_psetinput.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_psetinput.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_psetinput.restype = None
_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance_token.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance_token.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_script_pubkey.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_vout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_vout.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_method_psetinput_redeem_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetinput_redeem_script.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_psetsignatures.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_psetsignatures.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_psetsignatures.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_psetsignatures.restype = None
_UniffiLib.uniffi_lwk_fn_method_psetsignatures_has_signature.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetsignatures_has_signature.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_psetsignatures_missing_signature.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_psetsignatures_missing_signature.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_recipient.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_recipient.restype = None
_UniffiLib.uniffi_lwk_fn_method_recipient_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_recipient_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_recipient_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_recipient_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_recipient_value.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_recipient_value.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_recipient_vout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_recipient_vout.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_clone_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_script.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_script.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_script.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_script_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_script_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_script_asm.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_script_asm.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_script_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_script_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_script_is_provably_unspendable.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_script_is_provably_unspendable.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_script_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_script_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_secretkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_secretkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_secretkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_secretkey.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_secretkey_from_bytes.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_secretkey_from_bytes.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_secretkey_from_wif.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_secretkey_from_wif.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_secretkey_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_secretkey_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_secretkey_sign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_secretkey_sign.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_signer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_signer.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_signer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_signer.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_signer_new.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_signer_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_signer_random.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_signer_random.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_signer_keyorigin_xpub.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_signer_keyorigin_xpub.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_signer_mnemonic.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_signer_mnemonic.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_signer_sign.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_signer_sign.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_signer_singlesig_desc.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_signer_singlesig_desc.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_signer_wpkh_slip77_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_signer_wpkh_slip77_descriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_transaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_transaction.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_transaction.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_transaction.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_transaction_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_transaction_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_transaction_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_transaction_fee.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_fee.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_transaction_inputs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_inputs.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_transaction_outputs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_outputs.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_transaction_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_transaction_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_transaction_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_txbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txbuilder.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_txbuilder_new.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_txbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_burn.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_burn.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_external_utxos.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_external_utxos.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_lbtc_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_lbtc_recipient.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_recipient.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_recipient.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_to.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_to.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_wallet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_wallet.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_fee_rate.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_fee_rate.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_finish.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_finish.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txbuilder_issue_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_issue_asset.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_liquidex_make.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_liquidex_make.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_liquidex_take.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_liquidex_take.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_reissue_asset.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint64,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_reissue_asset.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_set_wallet_utxos.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_set_wallet_utxos.restype = None
_UniffiLib.uniffi_lwk_fn_method_txbuilder_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txbuilder_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_txin.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txin.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txin.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txin.restype = None
_UniffiLib.uniffi_lwk_fn_method_txin_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txin_outpoint.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_txout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txout.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txout.restype = None
_UniffiLib.uniffi_lwk_fn_method_txout_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txout_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txout_is_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txout_is_fee.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_txout_is_partially_blinded.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txout_is_partially_blinded.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_txout_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txout_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txout_unblind.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txout_unblind.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txout_unconfidential_address.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txout_unconfidential_address.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txout_value.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txout_value.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_txoutsecrets.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txoutsecrets.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txoutsecrets.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txoutsecrets.restype = None
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_bf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_bf.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_commitment.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_commitment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_is_explicit.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_is_explicit.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_bf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_bf.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_commitment.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_commitment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_txid.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_txid_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_txid_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_txid_bytes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txid_bytes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_txid_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_txid_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_unvalidatedliquidexproposal.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_unvalidatedliquidexproposal.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_unvalidatedliquidexproposal.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_unvalidatedliquidexproposal.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_unvalidatedliquidexproposal_from_pset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_unvalidatedliquidexproposal_from_pset.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_unvalidatedliquidexproposal_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_unvalidatedliquidexproposal_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_insecure_validate.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_insecure_validate.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_needed_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_needed_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_validate.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_validate.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_update.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_update.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_update.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_update.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_update_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_update_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_update_only_tip.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_update_only_tip.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_update_serialize.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_update_serialize.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_validatedliquidexproposal.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_validatedliquidexproposal.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_validatedliquidexproposal.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_validatedliquidexproposal.restype = None
_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_input.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_input.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_output.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_output.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_wallettx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wallettx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wallettx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wallettx.restype = None
_UniffiLib.uniffi_lwk_fn_method_wallettx_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_balance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_fee.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_fee.restype = ctypes.c_uint64
_UniffiLib.uniffi_lwk_fn_method_wallettx_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_height.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_inputs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_inputs.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_outputs.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_outputs.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_timestamp.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_timestamp.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettx_txid.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_txid.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettx_type_.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_type_.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettx_unblinded_url.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettx_unblinded_url.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_clone_wallettxout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wallettxout.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wallettxout.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wallettxout.restype = None
_UniffiLib.uniffi_lwk_fn_method_wallettxout_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettxout_ext_int.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_ext_int.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettxout_height.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_height.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wallettxout_outpoint.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_outpoint.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettxout_script_pubkey.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettxout_unblinded.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_unblinded.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wallettxout_wildcard_index.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wallettxout_wildcard_index.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_clone_wollet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wollet.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wollet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wollet.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_wollet_new.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_wollet_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_constructor_wollet_with_custom_persister.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_wollet_with_custom_persister.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_add_details.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_add_details.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_address.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_address.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_apply_update.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_apply_update.restype = None
_UniffiLib.uniffi_lwk_fn_method_wollet_balance.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_balance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_descriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_descriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_extract_wallet_utxos.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_extract_wallet_utxos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_finalize.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_finalize.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_is_segwit.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_is_segwit.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_wollet_max_weight_to_satisfy.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_max_weight_to_satisfy.restype = ctypes.c_uint32
_UniffiLib.uniffi_lwk_fn_method_wollet_pset_details.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_pset_details.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wollet_transactions.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_transactions.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_transactions_paginated.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint32,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_transactions_paginated.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_txos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_txos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_unblind_utxos_with.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_unblind_utxos_with.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_utxos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_utxos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wollet_wait_for_tx.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wollet_wait_for_tx.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_clone_wolletdescriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_clone_wolletdescriptor.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_free_wolletdescriptor.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_free_wolletdescriptor.restype = None
_UniffiLib.uniffi_lwk_fn_constructor_wolletdescriptor_new.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_constructor_wolletdescriptor_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_derive_blinding_key.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_derive_blinding_key.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_is_mainnet.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_is_mainnet.restype = ctypes.c_int8
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_script_pubkey.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_script_pubkey.restype = ctypes.c_void_p
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_uniffi_trait_display.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_uniffi_trait_display.restype = _UniffiRustBuffer
_UniffiLib.uniffi_lwk_fn_func_is_provably_segwit.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_lwk_fn_func_is_provably_segwit.restype = ctypes.c_int8
_UniffiLib.ffi_lwk_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_free.restype = None
_UniffiLib.ffi_lwk_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_u8.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_u8.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_lwk_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_i8.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_i8.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_lwk_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_u16.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_u16.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_lwk_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_i16.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_i16.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_lwk_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_u32.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_u32.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_lwk_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_i32.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_i32.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_lwk_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_u64.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_lwk_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_u64.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_lwk_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_i64.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_lwk_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_i64.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_lwk_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_f32.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_lwk_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_f32.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_lwk_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_f64.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_lwk_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_f64.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_lwk_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_lwk_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_pointer.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_lwk_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_lwk_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_lwk_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_poll_void.restype = None
_UniffiLib.ffi_lwk_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_cancel_void.restype = None
_UniffiLib.ffi_lwk_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_lwk_rust_future_free_void.restype = None
_UniffiLib.ffi_lwk_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_lwk_rust_future_complete_void.restype = None
_UniffiLib.uniffi_lwk_checksum_func_is_provably_segwit.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_func_is_provably_segwit.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_is_blinded.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_is_blinded.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_text.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_text.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_uri.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_qr_code_uri.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_address_to_unconfidential.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_address_to_unconfidential.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_addressresult_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_addressresult_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_addressresult_index.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_addressresult_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_amp2_cosign.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_amp2_cosign.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_amp2_descriptor_from_str.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_amp2_descriptor_from_str.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_amp2_register.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_amp2_register.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_amp2descriptor_descriptor.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_amp2descriptor_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_assetamount_amount.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_assetamount_amount.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_assetamount_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_assetamount_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_broadcast.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_full_scan.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_full_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_full_scan_to_index.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_full_scan_to_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_get_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_get_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_ping.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_electrumclient_ping.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_broadcast.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_broadcast.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_full_scan.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_full_scan.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_full_scan_to_index.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_esploraclient_full_scan_to_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_get.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_get.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_push.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_foreignpersister_push.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_asset_satoshi.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_asset_satoshi.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_confidential.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_confidential.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_issuance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_issuance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_null.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_null.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_reissuance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_is_reissuance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_prev_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_prev_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_prev_vout.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_prev_vout.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_token.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_token.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_issuance_token_satoshi.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_issuance_token_satoshi.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_electrum_url.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_electrum_url.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_generate.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_generate.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_get_new_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_get_new_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_height.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_issue_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_issue_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_send_to_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_lwktestenv_send_to_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_default_electrum_client.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_default_electrum_client.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_default_esplora_client.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_default_esplora_client.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_is_mainnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_is_mainnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_policy_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_policy_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_network_tx_builder.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_network_tx_builder.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_outpoint_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_outpoint_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_outpoint_vout.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_outpoint_vout.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_precision_sats_to_string.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_precision_sats_to_string.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_precision_string_to_sats.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_precision_string_to_sats.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_combine.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_combine.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_extract_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_extract_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_finalize.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_finalize.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_inputs.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_inputs.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_pset_unique_id.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_pset_unique_id.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetbalance_balances.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetbalance_balances.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetbalance_fee.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetbalance_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetbalance_recipients.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetbalance_recipients.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetdetails_balance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetdetails_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetdetails_inputs_issuances.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetdetails_inputs_issuances.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetdetails_signatures.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetdetails_signatures.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetinput_issuance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetinput_issuance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetinput_issuance_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetinput_issuance_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetinput_issuance_token.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetinput_issuance_token.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetinput_previous_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetinput_previous_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetinput_previous_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetinput_previous_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetinput_previous_vout.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetinput_previous_vout.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetinput_redeem_script.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetinput_redeem_script.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetsignatures_has_signature.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetsignatures_has_signature.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_psetsignatures_missing_signature.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_psetsignatures_missing_signature.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_recipient_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_recipient_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_recipient_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_recipient_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_recipient_value.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_recipient_value.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_recipient_vout.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_recipient_vout.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_script_asm.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_script_asm.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_script_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_script_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_script_is_provably_unspendable.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_script_is_provably_unspendable.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_secretkey_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_secretkey_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_secretkey_sign.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_secretkey_sign.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_signer_keyorigin_xpub.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_signer_keyorigin_xpub.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_signer_mnemonic.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_signer_mnemonic.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_signer_sign.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_signer_sign.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_signer_singlesig_desc.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_signer_singlesig_desc.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_signer_wpkh_slip77_descriptor.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_signer_wpkh_slip77_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_fee.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_inputs.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_inputs.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_outputs.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_outputs.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_transaction_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_transaction_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_burn.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_burn.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_external_utxos.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_external_utxos.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_lbtc_recipient.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_lbtc_recipient.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_recipient.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_add_recipient.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_to.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_to.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_wallet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_drain_lbtc_wallet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_fee_rate.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_fee_rate.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_finish.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_finish.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_issue_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_issue_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_liquidex_make.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_liquidex_make.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_liquidex_take.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_liquidex_take.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_reissue_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_reissue_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_set_wallet_utxos.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txbuilder_set_wallet_utxos.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txin_outpoint.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txin_outpoint.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txout_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txout_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txout_is_fee.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txout_is_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txout_is_partially_blinded.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txout_is_partially_blinded.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txout_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txout_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txout_unblind.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txout_unblind.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txout_unconfidential_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txout_unconfidential_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txout_value.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txout_value.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset_bf.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset_bf.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset_commitment.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_asset_commitment.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_is_explicit.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_is_explicit.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value_bf.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value_bf.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value_commitment.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txoutsecrets_value_commitment.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_txid_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_txid_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_insecure_validate.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_insecure_validate.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_needed_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_needed_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_validate.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_unvalidatedliquidexproposal_validate.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_update_only_tip.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_update_only_tip.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_update_serialize.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_update_serialize.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_validatedliquidexproposal_input.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_validatedliquidexproposal_input.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_validatedliquidexproposal_output.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_validatedliquidexproposal_output.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_balance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_fee.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_fee.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_height.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_inputs.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_inputs.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_outputs.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_outputs.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_timestamp.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_timestamp.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_txid.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_txid.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_type_.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_type_.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettx_unblinded_url.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettx_unblinded_url.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_ext_int.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_ext_int.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_height.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_height.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_outpoint.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_outpoint.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_unblinded.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_unblinded.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_wildcard_index.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wallettxout_wildcard_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_add_details.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_add_details.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_address.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_address.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_apply_update.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_apply_update.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_balance.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_balance.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_descriptor.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_descriptor.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_extract_wallet_utxos.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_extract_wallet_utxos.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_finalize.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_finalize.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_is_segwit.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_is_segwit.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_max_weight_to_satisfy.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_max_weight_to_satisfy.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_pset_details.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_pset_details.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_transactions.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_transactions.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_transactions_paginated.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_transactions_paginated.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_txos.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_txos.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_unblind_utxos_with.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_unblind_utxos_with.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_utxos.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_utxos.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wollet_wait_for_tx.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wollet_wait_for_tx.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wolletdescriptor_derive_blinding_key.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wolletdescriptor_derive_blinding_key.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wolletdescriptor_is_mainnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wolletdescriptor_is_mainnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_method_wolletdescriptor_script_pubkey.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_method_wolletdescriptor_script_pubkey.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_address_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_address_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_amp2_new_testnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_amp2_new_testnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_bip_new_bip49.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_bip_new_bip49.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_bip_new_bip84.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_bip_new_bip84.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_bip_new_bip87.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_bip_new_bip87.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_contract_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_contract_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_electrumclient_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_electrumclient_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_from_builder.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_from_builder.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_new_waterfalls.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_esploraclient_new_waterfalls.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_externalutxo_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_externalutxo_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_foreignpersisterlink_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_foreignpersisterlink_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_lwktestenv_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_lwktestenv_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_from_entropy.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_from_entropy.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_from_random.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_from_random.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_mnemonic_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_mainnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_mainnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest_default.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_regtest_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_network_testnet.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_network_testnet.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_outpoint_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_outpoint_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_precision_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_precision_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_pset_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_pset_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_script_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_script_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_secretkey_from_bytes.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_secretkey_from_bytes.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_secretkey_from_wif.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_secretkey_from_wif.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_signer_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_signer_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_signer_random.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_signer_random.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_transaction_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_transaction_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_txbuilder_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_txbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_txid_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_txid_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_unvalidatedliquidexproposal_from_pset.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_unvalidatedliquidexproposal_from_pset.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_unvalidatedliquidexproposal_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_unvalidatedliquidexproposal_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_update_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_update_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_with_custom_persister.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_wollet_with_custom_persister.restype = ctypes.c_uint16
_UniffiLib.uniffi_lwk_checksum_constructor_wolletdescriptor_new.argtypes = (
)
_UniffiLib.uniffi_lwk_checksum_constructor_wolletdescriptor_new.restype = ctypes.c_uint16
_UniffiLib.ffi_lwk_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_lwk_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
_uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt8(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u8"
    VALUE_MIN = 0
    VALUE_MAX = 2**8

    @staticmethod
    def read(buf):
        return buf.read_u8()

    @staticmethod
    def write(value, buf):
        buf.write_u8(value)

class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.read_i64()

    @staticmethod
    def write(value, buf):
        buf.write_i64(value)

class _UniffiConverterFloat(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_float()

    @staticmethod
    def write(value, buf):
        buf.write_float(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()

class _UniffiConverterBytes(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative byte string length")
        return buf.read(size)

    @staticmethod
    def check_lower(value):
        try:
            memoryview(value)
        except TypeError:
            raise TypeError("a bytes-like object is required, not {!r}".format(type(value).__name__))

    @staticmethod
    def write(value, buf):
        buf.write_i32(len(value))
        buf.write(value)



class AddressProtocol(typing.Protocol):
    def is_blinded(self, ):
        raise NotImplementedError
    def qr_code_text(self, ):
        """
        Returns a string of the QR code printable in a terminal environment
        """

        raise NotImplementedError
    def qr_code_uri(self, pixel_per_module: "typing.Optional[int]"):
        """
        Returns a string encoding an image in a uri

        The string can be open in the browser or be used as `src` field in `img` in HTML

        For max efficiency we suggest to pass `None` to `pixel_per_module`, get a very small image
        and use styling to scale up the image in the browser. eg
        `style="image-rendering: pixelated; border: 20px solid white;"`
        """

        raise NotImplementedError
    def script_pubkey(self, ):
        raise NotImplementedError
    def to_unconfidential(self, ):
        raise NotImplementedError


class Address:
    _pointer: ctypes.c_void_p
    def __init__(self, s: "str"):
        """
        Construct an Address object
        """

        _UniffiConverterString.check_lower(s)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_address_new,
        _UniffiConverterString.lower(s))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_address, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_address, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def is_blinded(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_address_is_blinded,self._uniffi_clone_pointer(),)
        )





    def qr_code_text(self, ) -> "str":
        """
        Returns a string of the QR code printable in a terminal environment
        """

        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_address_qr_code_text,self._uniffi_clone_pointer(),)
        )





    def qr_code_uri(self, pixel_per_module: "typing.Optional[int]") -> "str":
        """
        Returns a string encoding an image in a uri

        The string can be open in the browser or be used as `src` field in `img` in HTML

        For max efficiency we suggest to pass `None` to `pixel_per_module`, get a very small image
        and use styling to scale up the image in the browser. eg
        `style="image-rendering: pixelated; border: 20px solid white;"`
        """

        _UniffiConverterOptionalUInt8.check_lower(pixel_per_module)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_address_qr_code_uri,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalUInt8.lower(pixel_per_module))
        )





    def script_pubkey(self, ) -> "Script":
        return _UniffiConverterTypeScript.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_address_script_pubkey,self._uniffi_clone_pointer(),)
        )





    def to_unconfidential(self, ) -> "Address":
        return _UniffiConverterTypeAddress.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_address_to_unconfidential,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_address_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeAddress:

    @staticmethod
    def lift(value: int):
        return Address._make_instance_(value)

    @staticmethod
    def check_lower(value: Address):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AddressProtocol):
        if not isinstance(value, Address):
            raise TypeError("Expected Address instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AddressProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class AddressResultProtocol(typing.Protocol):
    def address(self, ):
        raise NotImplementedError
    def index(self, ):
        raise NotImplementedError


class AddressResult:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_addressresult, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_addressresult, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def address(self, ) -> "Address":
        return _UniffiConverterTypeAddress.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_addressresult_address,self._uniffi_clone_pointer(),)
        )





    def index(self, ) -> "int":
        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_addressresult_index,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeAddressResult:

    @staticmethod
    def lift(value: int):
        return AddressResult._make_instance_(value)

    @staticmethod
    def check_lower(value: AddressResult):
        if not isinstance(value, AddressResult):
            raise TypeError("Expected AddressResult instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AddressResultProtocol):
        if not isinstance(value, AddressResult):
            raise TypeError("Expected AddressResult instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AddressResultProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class Amp2Protocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::amp2::Amp2`]
    """

    def cosign(self, pset: "Pset"):
        """
        Ask the AMP2 server to cosign a PSET
        """

        raise NotImplementedError
    def descriptor_from_str(self, keyorigin_xpub: "str"):
        """
        Create an AMP2 wallet descriptor from the keyorigin xpub of a signer
        """

        raise NotImplementedError
    def register(self, desc: "Amp2Descriptor"):
        """
        Register an AMP2 wallet with the AMP2 server
        """

        raise NotImplementedError


class Amp2:
    """
    Wrapper over [`lwk_wollet::amp2::Amp2`]
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_amp2, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_amp2, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def new_testnet(cls, ):
        """
        Construct an AMP2 context for Liquid Testnet
        """

        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_amp2_new_testnet,)
        return cls._make_instance_(pointer)



    def cosign(self, pset: "Pset") -> "Pset":
        """
        Ask the AMP2 server to cosign a PSET
        """

        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePset.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_amp2_cosign,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )





    def descriptor_from_str(self, keyorigin_xpub: "str") -> "Amp2Descriptor":
        """
        Create an AMP2 wallet descriptor from the keyorigin xpub of a signer
        """

        _UniffiConverterString.check_lower(keyorigin_xpub)
        
        return _UniffiConverterTypeAmp2Descriptor.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_amp2_descriptor_from_str,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(keyorigin_xpub))
        )





    def register(self, desc: "Amp2Descriptor") -> "str":
        """
        Register an AMP2 wallet with the AMP2 server
        """

        _UniffiConverterTypeAmp2Descriptor.check_lower(desc)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_amp2_register,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAmp2Descriptor.lower(desc))
        )






class _UniffiConverterTypeAmp2:

    @staticmethod
    def lift(value: int):
        return Amp2._make_instance_(value)

    @staticmethod
    def check_lower(value: Amp2):
        if not isinstance(value, Amp2):
            raise TypeError("Expected Amp2 instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: Amp2Protocol):
        if not isinstance(value, Amp2):
            raise TypeError("Expected Amp2 instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: Amp2Protocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class Amp2DescriptorProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::amp2::Amp2Descriptor`]
    """

    def descriptor(self, ):
        raise NotImplementedError


class Amp2Descriptor:
    """
    Wrapper over [`lwk_wollet::amp2::Amp2Descriptor`]
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_amp2descriptor, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_amp2descriptor, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def descriptor(self, ) -> "WolletDescriptor":
        return _UniffiConverterTypeWolletDescriptor.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_amp2descriptor_descriptor,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_amp2descriptor_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeAmp2Descriptor:

    @staticmethod
    def lift(value: int):
        return Amp2Descriptor._make_instance_(value)

    @staticmethod
    def check_lower(value: Amp2Descriptor):
        if not isinstance(value, Amp2Descriptor):
            raise TypeError("Expected Amp2Descriptor instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: Amp2DescriptorProtocol):
        if not isinstance(value, Amp2Descriptor):
            raise TypeError("Expected Amp2Descriptor instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: Amp2DescriptorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class AssetAmountProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::AssetAmount`]
    """

    def amount(self, ):
        raise NotImplementedError
    def asset(self, ):
        raise NotImplementedError


class AssetAmount:
    """
    Wrapper over [`lwk_wollet::AssetAmount`]
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_assetamount, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_assetamount, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def amount(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_assetamount_amount,self._uniffi_clone_pointer(),)
        )





    def asset(self, ) -> "AssetId":
        return _UniffiConverterTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_assetamount_asset,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeAssetAmount:

    @staticmethod
    def lift(value: int):
        return AssetAmount._make_instance_(value)

    @staticmethod
    def check_lower(value: AssetAmount):
        if not isinstance(value, AssetAmount):
            raise TypeError("Expected AssetAmount instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AssetAmountProtocol):
        if not isinstance(value, AssetAmount):
            raise TypeError("Expected AssetAmount instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AssetAmountProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class BipProtocol(typing.Protocol):
    """
    wrapper over [`lwk_common::Bip`]
    """

    pass


class Bip:
    """
    wrapper over [`lwk_common::Bip`]
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_bip, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_bip, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def new_bip49(cls, ):
        """
        For P2SH-P2WPKH wallets
        """

        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip49,)
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip84(cls, ):
        """
        For P2WPKH wallets
        """

        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip84,)
        return cls._make_instance_(pointer)


    @classmethod
    def new_bip87(cls, ):
        """
        For multisig wallets
        """

        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_bip_new_bip87,)
        return cls._make_instance_(pointer)




class _UniffiConverterTypeBip:

    @staticmethod
    def lift(value: int):
        return Bip._make_instance_(value)

    @staticmethod
    def check_lower(value: Bip):
        if not isinstance(value, Bip):
            raise TypeError("Expected Bip instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: BipProtocol):
        if not isinstance(value, Bip):
            raise TypeError("Expected Bip instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: BipProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ContractProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::Contract`]
    """

    pass


class Contract:
    """
    Wrapper over [`lwk_wollet::Contract`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, domain: "str",issuer_pubkey: "str",name: "str",precision: "int",ticker: "str",version: "int"):
        """
        Construct a Contract object
        """

        _UniffiConverterString.check_lower(domain)
        
        _UniffiConverterString.check_lower(issuer_pubkey)
        
        _UniffiConverterString.check_lower(name)
        
        _UniffiConverterUInt8.check_lower(precision)
        
        _UniffiConverterString.check_lower(ticker)
        
        _UniffiConverterUInt8.check_lower(version)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_contract_new,
        _UniffiConverterString.lower(domain),
        _UniffiConverterString.lower(issuer_pubkey),
        _UniffiConverterString.lower(name),
        _UniffiConverterUInt8.lower(precision),
        _UniffiConverterString.lower(ticker),
        _UniffiConverterUInt8.lower(version))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_contract, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_contract, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_contract_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeContract:

    @staticmethod
    def lift(value: int):
        return Contract._make_instance_(value)

    @staticmethod
    def check_lower(value: Contract):
        if not isinstance(value, Contract):
            raise TypeError("Expected Contract instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ContractProtocol):
        if not isinstance(value, Contract):
            raise TypeError("Expected Contract instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ContractProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ElectrumClientProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::ElectrumClient`]
    """

    def broadcast(self, tx: "Transaction"):
        raise NotImplementedError
    def full_scan(self, wollet: "Wollet"):
        raise NotImplementedError
    def full_scan_to_index(self, wollet: "Wollet",index: "int"):
        raise NotImplementedError
    def get_tx(self, txid: "Txid"):
        raise NotImplementedError
    def ping(self, ):
        raise NotImplementedError


class ElectrumClient:
    """
    Wrapper over [`lwk_wollet::ElectrumClient`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, electrum_url: "str",tls: "bool",validate_domain: "bool"):
        """
        Construct an Electrum client
        """

        _UniffiConverterString.check_lower(electrum_url)
        
        _UniffiConverterBool.check_lower(tls)
        
        _UniffiConverterBool.check_lower(validate_domain)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_electrumclient_new,
        _UniffiConverterString.lower(electrum_url),
        _UniffiConverterBool.lower(tls),
        _UniffiConverterBool.lower(validate_domain))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_electrumclient, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_electrumclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def broadcast(self, tx: "Transaction") -> "Txid":
        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_electrumclient_broadcast,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )





    def full_scan(self, wollet: "Wollet") -> "typing.Optional[Update]":
        _UniffiConverterTypeWollet.check_lower(wollet)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet))
        )





    def full_scan_to_index(self, wollet: "Wollet",index: "int") -> "typing.Optional[Update]":
        _UniffiConverterTypeWollet.check_lower(wollet)
        
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_electrumclient_full_scan_to_index,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet),
        _UniffiConverterUInt32.lower(index))
        )





    def get_tx(self, txid: "Txid") -> "Transaction":
        _UniffiConverterTypeTxid.check_lower(txid)
        
        return _UniffiConverterTypeTransaction.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_electrumclient_get_tx,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid))
        )





    def ping(self, ) -> None:
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_electrumclient_ping,self._uniffi_clone_pointer(),)







class _UniffiConverterTypeElectrumClient:

    @staticmethod
    def lift(value: int):
        return ElectrumClient._make_instance_(value)

    @staticmethod
    def check_lower(value: ElectrumClient):
        if not isinstance(value, ElectrumClient):
            raise TypeError("Expected ElectrumClient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ElectrumClientProtocol):
        if not isinstance(value, ElectrumClient):
            raise TypeError("Expected ElectrumClient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ElectrumClientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class EsploraClientProtocol(typing.Protocol):
    """
    Wrapper over [`blocking::EsploraClient`]
    """

    def broadcast(self, tx: "Transaction"):
        raise NotImplementedError
    def full_scan(self, wollet: "Wollet"):
        """
        See [`BlockchainBackend::full_scan`]
        """

        raise NotImplementedError
    def full_scan_to_index(self, wollet: "Wollet",index: "int"):
        """
        See [`BlockchainBackend::full_scan_to_index`]
        """

        raise NotImplementedError


class EsploraClient:
    """
    Wrapper over [`blocking::EsploraClient`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, url: "str",network: "Network"):
        """
        Construct an Esplora Client
        """

        _UniffiConverterString.check_lower(url)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new,
        _UniffiConverterString.lower(url),
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_esploraclient, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_esploraclient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_builder(cls, builder: "EsploraClientBuilder"):
        _UniffiConverterTypeEsploraClientBuilder.check_lower(builder)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_from_builder,
        _UniffiConverterTypeEsploraClientBuilder.lower(builder))
        return cls._make_instance_(pointer)


    @classmethod
    def new_waterfalls(cls, url: "str",network: "Network"):
        """
        Construct an Esplora Client using Waterfalls endpoint
        """

        _UniffiConverterString.check_lower(url)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_esploraclient_new_waterfalls,
        _UniffiConverterString.lower(url),
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)



    def broadcast(self, tx: "Transaction") -> "Txid":
        _UniffiConverterTypeTransaction.check_lower(tx)
        
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_esploraclient_broadcast,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(tx))
        )





    def full_scan(self, wollet: "Wollet") -> "typing.Optional[Update]":
        """
        See [`BlockchainBackend::full_scan`]
        """

        _UniffiConverterTypeWollet.check_lower(wollet)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet))
        )





    def full_scan_to_index(self, wollet: "Wollet",index: "int") -> "typing.Optional[Update]":
        """
        See [`BlockchainBackend::full_scan_to_index`]
        """

        _UniffiConverterTypeWollet.check_lower(wollet)
        
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_esploraclient_full_scan_to_index,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet),
        _UniffiConverterUInt32.lower(index))
        )






class _UniffiConverterTypeEsploraClient:

    @staticmethod
    def lift(value: int):
        return EsploraClient._make_instance_(value)

    @staticmethod
    def check_lower(value: EsploraClient):
        if not isinstance(value, EsploraClient):
            raise TypeError("Expected EsploraClient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: EsploraClientProtocol):
        if not isinstance(value, EsploraClient):
            raise TypeError("Expected EsploraClient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: EsploraClientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ExternalUtxoProtocol(typing.Protocol):
    pass


class ExternalUtxo:
    _pointer: ctypes.c_void_p
    def __init__(self, vout: "int",tx: "Transaction",unblinded: "TxOutSecrets",max_weight_to_satisfy: "int",is_segwit: "bool"):
        """
        Construct an ExternalUtxo
        """

        _UniffiConverterUInt32.check_lower(vout)
        
        _UniffiConverterTypeTransaction.check_lower(tx)
        
        _UniffiConverterTypeTxOutSecrets.check_lower(unblinded)
        
        _UniffiConverterUInt32.check_lower(max_weight_to_satisfy)
        
        _UniffiConverterBool.check_lower(is_segwit)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_externalutxo_new,
        _UniffiConverterUInt32.lower(vout),
        _UniffiConverterTypeTransaction.lower(tx),
        _UniffiConverterTypeTxOutSecrets.lower(unblinded),
        _UniffiConverterUInt32.lower(max_weight_to_satisfy),
        _UniffiConverterBool.lower(is_segwit))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_externalutxo, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_externalutxo, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeExternalUtxo:

    @staticmethod
    def lift(value: int):
        return ExternalUtxo._make_instance_(value)

    @staticmethod
    def check_lower(value: ExternalUtxo):
        if not isinstance(value, ExternalUtxo):
            raise TypeError("Expected ExternalUtxo instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ExternalUtxoProtocol):
        if not isinstance(value, ExternalUtxo):
            raise TypeError("Expected ExternalUtxo instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ExternalUtxoProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ForeignPersister(typing.Protocol):
    """
    An exported trait, useful for caller-defined persistence.
    """

    def get(self, index: "int"):
        raise NotImplementedError
    def push(self, update: "Update"):
        raise NotImplementedError


class ForeignPersisterImpl:
    """
    An exported trait, useful for caller-defined persistence.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_foreignpersister, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_foreignpersister, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get(self, index: "int") -> "typing.Optional[Update]":
        _UniffiConverterUInt64.check_lower(index)
        
        return _UniffiConverterOptionalTypeUpdate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_foreignpersister_get,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(index))
        )





    def push(self, update: "Update") -> None:
        _UniffiConverterTypeUpdate.check_lower(update)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_foreignpersister_push,self._uniffi_clone_pointer(),
        _UniffiConverterTypeUpdate.lower(update))




# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
_UNIFFI_IDX_CALLBACK_FREE = 0
# Return codes for callback calls
_UNIFFI_CALLBACK_SUCCESS = 0
_UNIFFI_CALLBACK_ERROR = 1
_UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

class _UniffiCallbackInterfaceFfiConverter:
    _handle_map = _UniffiHandleMap()

    @classmethod
    def lift(cls, handle):
        return cls._handle_map.get(handle)

    @classmethod
    def read(cls, buf):
        handle = buf.read_u64()
        cls.lift(handle)

    @classmethod
    def check_lower(cls, cb):
        pass

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.write_u64(cls.lower(cb))

# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplForeignPersister:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_FOREIGN_PERSISTER_METHOD0
    def get(
            uniffi_handle,
            index,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeForeignPersister._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterUInt64.lift(index), )
            method = uniffi_obj.get
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterOptionalTypeUpdate.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                LwkError,
                _UniffiConverterTypeLwkError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FOREIGN_PERSISTER_METHOD1
    def push(
            uniffi_handle,
            update,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeForeignPersister._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeUpdate.lift(update), )
            method = uniffi_obj.push
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                LwkError,
                _UniffiConverterTypeLwkError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeForeignPersister._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceForeignPersister(
        get,
        push,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_lwk_fn_init_callback_vtable_foreignpersister(ctypes.byref(_uniffi_vtable))



class _UniffiConverterTypeForeignPersister:
    _handle_map = _UniffiHandleMap()

    @staticmethod
    def lift(value: int):
        return ForeignPersisterImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: ForeignPersister):
        pass

    @staticmethod
    def lower(value: ForeignPersister):
        return _UniffiConverterTypeForeignPersister._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ForeignPersister, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ForeignPersisterLinkProtocol(typing.Protocol):
    """
    Implements [`ForeignPersister`]
    """

    pass


class ForeignPersisterLink:
    """
    Implements [`ForeignPersister`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, persister: "ForeignPersister"):
        _UniffiConverterTypeForeignPersister.check_lower(persister)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_foreignpersisterlink_new,
        _UniffiConverterTypeForeignPersister.lower(persister))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_foreignpersisterlink, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_foreignpersisterlink, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeForeignPersisterLink:

    @staticmethod
    def lift(value: int):
        return ForeignPersisterLink._make_instance_(value)

    @staticmethod
    def check_lower(value: ForeignPersisterLink):
        if not isinstance(value, ForeignPersisterLink):
            raise TypeError("Expected ForeignPersisterLink instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ForeignPersisterLinkProtocol):
        if not isinstance(value, ForeignPersisterLink):
            raise TypeError("Expected ForeignPersisterLink instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ForeignPersisterLinkProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class IssuanceProtocol(typing.Protocol):
    def asset(self, ):
        raise NotImplementedError
    def asset_satoshi(self, ):
        raise NotImplementedError
    def is_confidential(self, ):
        raise NotImplementedError
    def is_issuance(self, ):
        raise NotImplementedError
    def is_null(self, ):
        raise NotImplementedError
    def is_reissuance(self, ):
        raise NotImplementedError
    def prev_txid(self, ):
        raise NotImplementedError
    def prev_vout(self, ):
        raise NotImplementedError
    def token(self, ):
        raise NotImplementedError
    def token_satoshi(self, ):
        raise NotImplementedError


class Issuance:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_issuance, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_issuance, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def asset(self, ) -> "typing.Optional[AssetId]":
        return _UniffiConverterOptionalTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_asset,self._uniffi_clone_pointer(),)
        )





    def asset_satoshi(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_asset_satoshi,self._uniffi_clone_pointer(),)
        )





    def is_confidential(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_is_confidential,self._uniffi_clone_pointer(),)
        )





    def is_issuance(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_is_issuance,self._uniffi_clone_pointer(),)
        )





    def is_null(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_is_null,self._uniffi_clone_pointer(),)
        )





    def is_reissuance(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_is_reissuance,self._uniffi_clone_pointer(),)
        )





    def prev_txid(self, ) -> "typing.Optional[Txid]":
        return _UniffiConverterOptionalTypeTxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_prev_txid,self._uniffi_clone_pointer(),)
        )





    def prev_vout(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_prev_vout,self._uniffi_clone_pointer(),)
        )





    def token(self, ) -> "typing.Optional[AssetId]":
        return _UniffiConverterOptionalTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_token,self._uniffi_clone_pointer(),)
        )





    def token_satoshi(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_issuance_token_satoshi,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeIssuance:

    @staticmethod
    def lift(value: int):
        return Issuance._make_instance_(value)

    @staticmethod
    def check_lower(value: Issuance):
        if not isinstance(value, Issuance):
            raise TypeError("Expected Issuance instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: IssuanceProtocol):
        if not isinstance(value, Issuance):
            raise TypeError("Expected Issuance instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: IssuanceProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class LwkTestEnvProtocol(typing.Protocol):
    """
    Represent a test environment with an elements node and an electrum server.
    useful for testing only, wrapper over [`lwk_test_util::TestElectrumServer`]
    """

    def electrum_url(self, ):
        raise NotImplementedError
    def generate(self, blocks: "int"):
        raise NotImplementedError
    def get_new_address(self, ):
        raise NotImplementedError
    def height(self, ):
        raise NotImplementedError
    def issue_asset(self, satoshi: "int"):
        raise NotImplementedError
    def send_to_address(self, address: "Address",satoshi: "int",asset: "typing.Optional[AssetId]"):
        raise NotImplementedError


class LwkTestEnv:
    """
    Represent a test environment with an elements node and an electrum server.
    useful for testing only, wrapper over [`lwk_test_util::TestElectrumServer`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_lwktestenv_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_lwktestenv, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_lwktestenv, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def electrum_url(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_lwktestenv_electrum_url,self._uniffi_clone_pointer(),)
        )





    def generate(self, blocks: "int") -> None:
        _UniffiConverterUInt32.check_lower(blocks)
        
        _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_lwktestenv_generate,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(blocks))






    def get_new_address(self, ) -> "Address":
        return _UniffiConverterTypeAddress.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_lwktestenv_get_new_address,self._uniffi_clone_pointer(),)
        )





    def height(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_lwktestenv_height,self._uniffi_clone_pointer(),)
        )





    def issue_asset(self, satoshi: "int") -> "AssetId":
        _UniffiConverterUInt64.check_lower(satoshi)
        
        return _UniffiConverterTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_lwktestenv_issue_asset,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(satoshi))
        )





    def send_to_address(self, address: "Address",satoshi: "int",asset: "typing.Optional[AssetId]") -> "Txid":
        _UniffiConverterTypeAddress.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(satoshi)
        
        _UniffiConverterOptionalTypeAssetId.check_lower(asset)
        
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_lwktestenv_send_to_address,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address),
        _UniffiConverterUInt64.lower(satoshi),
        _UniffiConverterOptionalTypeAssetId.lower(asset))
        )






class _UniffiConverterTypeLwkTestEnv:

    @staticmethod
    def lift(value: int):
        return LwkTestEnv._make_instance_(value)

    @staticmethod
    def check_lower(value: LwkTestEnv):
        if not isinstance(value, LwkTestEnv):
            raise TypeError("Expected LwkTestEnv instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: LwkTestEnvProtocol):
        if not isinstance(value, LwkTestEnv):
            raise TypeError("Expected LwkTestEnv instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: LwkTestEnvProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class MnemonicProtocol(typing.Protocol):
    """
    Wrapper over [`bip39::Mnemonic`]
    """

    pass


class Mnemonic:
    """
    Wrapper over [`bip39::Mnemonic`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, s: "str"):
        """
        Construct a Mnemonic type
        """

        _UniffiConverterString.check_lower(s)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_new,
        _UniffiConverterString.lower(s))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_mnemonic, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_mnemonic, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_entropy(cls, b: "bytes"):
        """
        Creates a Mnemonic from entropy, at least 16 bytes are needed.
        """

        _UniffiConverterBytes.check_lower(b)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_from_entropy,
        _UniffiConverterBytes.lower(b))
        return cls._make_instance_(pointer)


    @classmethod
    def from_random(cls, word_count: "int"):
        """
        Creates a random Mnemonic of given words (12,15,18,21,24)
        """

        _UniffiConverterUInt8.check_lower(word_count)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_mnemonic_from_random,
        _UniffiConverterUInt8.lower(word_count))
        return cls._make_instance_(pointer)



    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_mnemonic_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeMnemonic:

    @staticmethod
    def lift(value: int):
        return Mnemonic._make_instance_(value)

    @staticmethod
    def check_lower(value: Mnemonic):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: MnemonicProtocol):
        if not isinstance(value, Mnemonic):
            raise TypeError("Expected Mnemonic instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: MnemonicProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class NetworkProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::ElementsNetwork`]
    """

    def default_electrum_client(self, ):
        raise NotImplementedError
    def default_esplora_client(self, ):
        raise NotImplementedError
    def is_mainnet(self, ):
        raise NotImplementedError
    def policy_asset(self, ):
        raise NotImplementedError
    def tx_builder(self, ):
        raise NotImplementedError


class Network:
    """
    Wrapper over [`lwk_wollet::ElementsNetwork`]
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_network, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_network, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def mainnet(cls, ):
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_mainnet,)
        return cls._make_instance_(pointer)


    @classmethod
    def regtest(cls, policy_asset: "AssetId"):
        _UniffiConverterTypeAssetId.check_lower(policy_asset)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_regtest,
        _UniffiConverterTypeAssetId.lower(policy_asset))
        return cls._make_instance_(pointer)


    @classmethod
    def regtest_default(cls, ):
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_regtest_default,)
        return cls._make_instance_(pointer)


    @classmethod
    def testnet(cls, ):
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_network_testnet,)
        return cls._make_instance_(pointer)



    def default_electrum_client(self, ) -> "ElectrumClient":
        return _UniffiConverterTypeElectrumClient.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_network_default_electrum_client,self._uniffi_clone_pointer(),)
        )





    def default_esplora_client(self, ) -> "EsploraClient":
        return _UniffiConverterTypeEsploraClient.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_network_default_esplora_client,self._uniffi_clone_pointer(),)
        )





    def is_mainnet(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_network_is_mainnet,self._uniffi_clone_pointer(),)
        )





    def policy_asset(self, ) -> "AssetId":
        return _UniffiConverterTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_network_policy_asset,self._uniffi_clone_pointer(),)
        )





    def tx_builder(self, ) -> "TxBuilder":
        return _UniffiConverterTypeTxBuilder.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_network_tx_builder,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_network_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeNetwork:

    @staticmethod
    def lift(value: int):
        return Network._make_instance_(value)

    @staticmethod
    def check_lower(value: Network):
        if not isinstance(value, Network):
            raise TypeError("Expected Network instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: NetworkProtocol):
        if not isinstance(value, Network):
            raise TypeError("Expected Network instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: NetworkProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class OutPointProtocol(typing.Protocol):
    def txid(self, ):
        raise NotImplementedError
    def vout(self, ):
        raise NotImplementedError


class OutPoint:
    _pointer: ctypes.c_void_p
    def __init__(self, s: "str"):
        """
        Construct an OutPoint object
        """

        _UniffiConverterString.check_lower(s)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_outpoint_new,
        _UniffiConverterString.lower(s))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_outpoint, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_outpoint, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def txid(self, ) -> "Txid":
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_outpoint_txid,self._uniffi_clone_pointer(),)
        )





    def vout(self, ) -> "int":
        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_outpoint_vout,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_outpoint_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeOutPoint:

    @staticmethod
    def lift(value: int):
        return OutPoint._make_instance_(value)

    @staticmethod
    def check_lower(value: OutPoint):
        if not isinstance(value, OutPoint):
            raise TypeError("Expected OutPoint instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: OutPointProtocol):
        if not isinstance(value, OutPoint):
            raise TypeError("Expected OutPoint instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: OutPointProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PrecisionProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_common::Precision`]
    """

    def sats_to_string(self, sats: "int"):
        """
        See [`lwk_common::Precision::sats_to_string`]
        """

        raise NotImplementedError
    def string_to_sats(self, val: "str"):
        """
        See [`lwk_common::Precision::string_to_sats`]
        """

        raise NotImplementedError


class Precision:
    """
    Wrapper over [`lwk_common::Precision`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, precision: "int"):
        """
        See [`lwk_common::Precision::new`]
        """

        _UniffiConverterUInt8.check_lower(precision)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_precision_new,
        _UniffiConverterUInt8.lower(precision))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_precision, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_precision, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def sats_to_string(self, sats: "int") -> "str":
        """
        See [`lwk_common::Precision::sats_to_string`]
        """

        _UniffiConverterInt64.check_lower(sats)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_precision_sats_to_string,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(sats))
        )





    def string_to_sats(self, val: "str") -> "int":
        """
        See [`lwk_common::Precision::string_to_sats`]
        """

        _UniffiConverterString.check_lower(val)
        
        return _UniffiConverterInt64.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_precision_string_to_sats,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(val))
        )






class _UniffiConverterTypePrecision:

    @staticmethod
    def lift(value: int):
        return Precision._make_instance_(value)

    @staticmethod
    def check_lower(value: Precision):
        if not isinstance(value, Precision):
            raise TypeError("Expected Precision instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PrecisionProtocol):
        if not isinstance(value, Precision):
            raise TypeError("Expected Precision instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PrecisionProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PsetProtocol(typing.Protocol):
    """
    Partially Signed Elements Transaction, wrapper over [`elements::pset::PartiallySignedTransaction`]
    """

    def combine(self, other: "Pset"):
        raise NotImplementedError
    def extract_tx(self, ):
        raise NotImplementedError
    def finalize(self, ):
        """
        Finalize and extract the PSET
        """

        raise NotImplementedError
    def inputs(self, ):
        raise NotImplementedError
    def unique_id(self, ):
        """
        Get the unique id of the PSET as defined by [BIP-370](https://github.com/bitcoin/bips/blob/master/bip-0370.mediawiki#unique-identification)

        The unique id is the txid of the PSET with sequence numbers of inputs set to 0
        """

        raise NotImplementedError


class Pset:
    """
    Partially Signed Elements Transaction, wrapper over [`elements::pset::PartiallySignedTransaction`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, base64: "str"):
        """
        Construct a Watch-Only wallet object
        """

        _UniffiConverterString.check_lower(base64)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_pset_new,
        _UniffiConverterString.lower(base64))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_pset, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_pset, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def combine(self, other: "Pset") -> "Pset":
        _UniffiConverterTypePset.check_lower(other)
        
        return _UniffiConverterTypePset.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_pset_combine,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(other))
        )





    def extract_tx(self, ) -> "Transaction":
        return _UniffiConverterTypeTransaction.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_pset_extract_tx,self._uniffi_clone_pointer(),)
        )





    def finalize(self, ) -> "Transaction":
        """
        Finalize and extract the PSET
        """

        return _UniffiConverterTypeTransaction.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_pset_finalize,self._uniffi_clone_pointer(),)
        )





    def inputs(self, ) -> "typing.List[PsetInput]":
        return _UniffiConverterSequenceTypePsetInput.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_pset_inputs,self._uniffi_clone_pointer(),)
        )





    def unique_id(self, ) -> "Txid":
        """
        Get the unique id of the PSET as defined by [BIP-370](https://github.com/bitcoin/bips/blob/master/bip-0370.mediawiki#unique-identification)

        The unique id is the txid of the PSET with sequence numbers of inputs set to 0
        """

        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_pset_unique_id,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_pset_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypePset:

    @staticmethod
    def lift(value: int):
        return Pset._make_instance_(value)

    @staticmethod
    def check_lower(value: Pset):
        if not isinstance(value, Pset):
            raise TypeError("Expected Pset instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PsetProtocol):
        if not isinstance(value, Pset):
            raise TypeError("Expected Pset instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PsetProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PsetBalanceProtocol(typing.Protocol):
    def balances(self, ):
        raise NotImplementedError
    def fee(self, ):
        raise NotImplementedError
    def recipients(self, ):
        raise NotImplementedError


class PsetBalance:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_psetbalance, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_psetbalance, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def balances(self, ) -> "dict[AssetId, int]":
        return _UniffiConverterMapTypeAssetIdInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetbalance_balances,self._uniffi_clone_pointer(),)
        )





    def fee(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetbalance_fee,self._uniffi_clone_pointer(),)
        )





    def recipients(self, ) -> "typing.List[Recipient]":
        return _UniffiConverterSequenceTypeRecipient.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetbalance_recipients,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypePsetBalance:

    @staticmethod
    def lift(value: int):
        return PsetBalance._make_instance_(value)

    @staticmethod
    def check_lower(value: PsetBalance):
        if not isinstance(value, PsetBalance):
            raise TypeError("Expected PsetBalance instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PsetBalanceProtocol):
        if not isinstance(value, PsetBalance):
            raise TypeError("Expected PsetBalance instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PsetBalanceProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PsetDetailsProtocol(typing.Protocol):
    def balance(self, ):
        raise NotImplementedError
    def inputs_issuances(self, ):
        raise NotImplementedError
    def signatures(self, ):
        raise NotImplementedError


class PsetDetails:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_psetdetails, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_psetdetails, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def balance(self, ) -> "PsetBalance":
        return _UniffiConverterTypePsetBalance.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetdetails_balance,self._uniffi_clone_pointer(),)
        )





    def inputs_issuances(self, ) -> "typing.List[Issuance]":
        return _UniffiConverterSequenceTypeIssuance.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetdetails_inputs_issuances,self._uniffi_clone_pointer(),)
        )





    def signatures(self, ) -> "typing.List[PsetSignatures]":
        return _UniffiConverterSequenceTypePsetSignatures.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetdetails_signatures,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypePsetDetails:

    @staticmethod
    def lift(value: int):
        return PsetDetails._make_instance_(value)

    @staticmethod
    def check_lower(value: PsetDetails):
        if not isinstance(value, PsetDetails):
            raise TypeError("Expected PsetDetails instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PsetDetailsProtocol):
        if not isinstance(value, PsetDetails):
            raise TypeError("Expected PsetDetails instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PsetDetailsProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PsetInputProtocol(typing.Protocol):
    """
    PSET input
    """

    def issuance(self, ):
        """
        If the input has a (re)issuance, the issuance object
        """

        raise NotImplementedError
    def issuance_asset(self, ):
        """
        If the input has an issuance, the asset id
        """

        raise NotImplementedError
    def issuance_token(self, ):
        """
        If the input has an issuance, the token id
        """

        raise NotImplementedError
    def previous_script_pubkey(self, ):
        """
        Prevout scriptpubkey of the input
        """

        raise NotImplementedError
    def previous_txid(self, ):
        """
        Prevout TXID of the input
        """

        raise NotImplementedError
    def previous_vout(self, ):
        """
        Prevout vout of the input
        """

        raise NotImplementedError
    def redeem_script(self, ):
        """
        Redeem script of the input
        """

        raise NotImplementedError


class PsetInput:
    """
    PSET input
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_psetinput, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_psetinput, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def issuance(self, ) -> "typing.Optional[Issuance]":
        """
        If the input has a (re)issuance, the issuance object
        """

        return _UniffiConverterOptionalTypeIssuance.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance,self._uniffi_clone_pointer(),)
        )





    def issuance_asset(self, ) -> "typing.Optional[AssetId]":
        """
        If the input has an issuance, the asset id
        """

        return _UniffiConverterOptionalTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance_asset,self._uniffi_clone_pointer(),)
        )





    def issuance_token(self, ) -> "typing.Optional[AssetId]":
        """
        If the input has an issuance, the token id
        """

        return _UniffiConverterOptionalTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetinput_issuance_token,self._uniffi_clone_pointer(),)
        )





    def previous_script_pubkey(self, ) -> "typing.Optional[Script]":
        """
        Prevout scriptpubkey of the input
        """

        return _UniffiConverterOptionalTypeScript.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_script_pubkey,self._uniffi_clone_pointer(),)
        )





    def previous_txid(self, ) -> "Txid":
        """
        Prevout TXID of the input
        """

        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_txid,self._uniffi_clone_pointer(),)
        )





    def previous_vout(self, ) -> "int":
        """
        Prevout vout of the input
        """

        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetinput_previous_vout,self._uniffi_clone_pointer(),)
        )





    def redeem_script(self, ) -> "typing.Optional[Script]":
        """
        Redeem script of the input
        """

        return _UniffiConverterOptionalTypeScript.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetinput_redeem_script,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypePsetInput:

    @staticmethod
    def lift(value: int):
        return PsetInput._make_instance_(value)

    @staticmethod
    def check_lower(value: PsetInput):
        if not isinstance(value, PsetInput):
            raise TypeError("Expected PsetInput instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PsetInputProtocol):
        if not isinstance(value, PsetInput):
            raise TypeError("Expected PsetInput instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PsetInputProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class PsetSignaturesProtocol(typing.Protocol):
    def has_signature(self, ):
        raise NotImplementedError
    def missing_signature(self, ):
        raise NotImplementedError


class PsetSignatures:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_psetsignatures, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_psetsignatures, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def has_signature(self, ) -> "dict[str, str]":
        return _UniffiConverterMapStringString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetsignatures_has_signature,self._uniffi_clone_pointer(),)
        )





    def missing_signature(self, ) -> "dict[str, str]":
        return _UniffiConverterMapStringString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_psetsignatures_missing_signature,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypePsetSignatures:

    @staticmethod
    def lift(value: int):
        return PsetSignatures._make_instance_(value)

    @staticmethod
    def check_lower(value: PsetSignatures):
        if not isinstance(value, PsetSignatures):
            raise TypeError("Expected PsetSignatures instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: PsetSignaturesProtocol):
        if not isinstance(value, PsetSignatures):
            raise TypeError("Expected PsetSignatures instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: PsetSignaturesProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class RecipientProtocol(typing.Protocol):
    def address(self, ):
        raise NotImplementedError
    def asset(self, ):
        raise NotImplementedError
    def value(self, ):
        raise NotImplementedError
    def vout(self, ):
        raise NotImplementedError


class Recipient:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_recipient, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_recipient, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def address(self, ) -> "typing.Optional[Address]":
        return _UniffiConverterOptionalTypeAddress.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_recipient_address,self._uniffi_clone_pointer(),)
        )





    def asset(self, ) -> "typing.Optional[AssetId]":
        return _UniffiConverterOptionalTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_recipient_asset,self._uniffi_clone_pointer(),)
        )





    def value(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_recipient_value,self._uniffi_clone_pointer(),)
        )





    def vout(self, ) -> "int":
        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_recipient_vout,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeRecipient:

    @staticmethod
    def lift(value: int):
        return Recipient._make_instance_(value)

    @staticmethod
    def check_lower(value: Recipient):
        if not isinstance(value, Recipient):
            raise TypeError("Expected Recipient instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: RecipientProtocol):
        if not isinstance(value, Recipient):
            raise TypeError("Expected Recipient instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: RecipientProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ScriptProtocol(typing.Protocol):
    def asm(self, ):
        raise NotImplementedError
    def bytes(self, ):
        raise NotImplementedError
    def is_provably_unspendable(self, ):
        raise NotImplementedError


class Script:
    _pointer: ctypes.c_void_p
    def __init__(self, hex: "Hex"):
        """
        Construct a Script object
        """

        _UniffiConverterTypeHex.check_lower(hex)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_script_new,
        _UniffiConverterTypeHex.lower(hex))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_script, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_script, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def asm(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_script_asm,self._uniffi_clone_pointer(),)
        )





    def bytes(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_script_bytes,self._uniffi_clone_pointer(),)
        )





    def is_provably_unspendable(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_script_is_provably_unspendable,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_script_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeScript:

    @staticmethod
    def lift(value: int):
        return Script._make_instance_(value)

    @staticmethod
    def check_lower(value: Script):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ScriptProtocol):
        if not isinstance(value, Script):
            raise TypeError("Expected Script instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ScriptProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class SecretKeyProtocol(typing.Protocol):
    """
    A secret key
    """

    def bytes(self, ):
        raise NotImplementedError
    def sign(self, pset: "Pset"):
        """
        Sign the given `pset`
        """

        raise NotImplementedError


class SecretKey:
    """
    A secret key
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_secretkey, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_secretkey, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_bytes(cls, bytes: "bytes"):
        _UniffiConverterBytes.check_lower(bytes)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_secretkey_from_bytes,
        _UniffiConverterBytes.lower(bytes))
        return cls._make_instance_(pointer)


    @classmethod
    def from_wif(cls, wif: "str"):
        _UniffiConverterString.check_lower(wif)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_secretkey_from_wif,
        _UniffiConverterString.lower(wif))
        return cls._make_instance_(pointer)



    def bytes(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_secretkey_bytes,self._uniffi_clone_pointer(),)
        )





    def sign(self, pset: "Pset") -> "Pset":
        """
        Sign the given `pset`
        """

        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePset.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_secretkey_sign,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )






class _UniffiConverterTypeSecretKey:

    @staticmethod
    def lift(value: int):
        return SecretKey._make_instance_(value)

    @staticmethod
    def check_lower(value: SecretKey):
        if not isinstance(value, SecretKey):
            raise TypeError("Expected SecretKey instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: SecretKeyProtocol):
        if not isinstance(value, SecretKey):
            raise TypeError("Expected SecretKey instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: SecretKeyProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class SignerProtocol(typing.Protocol):
    """
    A Software signer, wrapper over [`lwk_signer::SwSigner`]
    """

    def keyorigin_xpub(self, bip: "Bip"):
        raise NotImplementedError
    def mnemonic(self, ):
        raise NotImplementedError
    def sign(self, pset: "Pset"):
        """
        Sign the given `pset`

        Note from an API perspective it would be better to consume the `pset` parameter so it would
        be clear the signed PSET is the returned one, but it's not possible with uniffi bindings
        """

        raise NotImplementedError
    def singlesig_desc(self, script_variant: "Singlesig",blinding_variant: "DescriptorBlindingKey"):
        raise NotImplementedError
    def wpkh_slip77_descriptor(self, ):
        raise NotImplementedError


class Signer:
    """
    A Software signer, wrapper over [`lwk_signer::SwSigner`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, mnemonic: "Mnemonic",network: "Network"):
        """
        Construct a software signer
        """

        _UniffiConverterTypeMnemonic.check_lower(mnemonic)
        
        _UniffiConverterTypeNetwork.check_lower(network)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_signer_new,
        _UniffiConverterTypeMnemonic.lower(mnemonic),
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_signer, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_signer, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def random(cls, network: "Network"):
        """
        Generate a new random software signer
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_signer_random,
        _UniffiConverterTypeNetwork.lower(network))
        return cls._make_instance_(pointer)



    def keyorigin_xpub(self, bip: "Bip") -> "str":
        _UniffiConverterTypeBip.check_lower(bip)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_signer_keyorigin_xpub,self._uniffi_clone_pointer(),
        _UniffiConverterTypeBip.lower(bip))
        )





    def mnemonic(self, ) -> "Mnemonic":
        return _UniffiConverterTypeMnemonic.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_signer_mnemonic,self._uniffi_clone_pointer(),)
        )





    def sign(self, pset: "Pset") -> "Pset":
        """
        Sign the given `pset`

        Note from an API perspective it would be better to consume the `pset` parameter so it would
        be clear the signed PSET is the returned one, but it's not possible with uniffi bindings
        """

        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePset.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_signer_sign,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )





    def singlesig_desc(self, script_variant: "Singlesig",blinding_variant: "DescriptorBlindingKey") -> "WolletDescriptor":
        _UniffiConverterTypeSinglesig.check_lower(script_variant)
        
        _UniffiConverterTypeDescriptorBlindingKey.check_lower(blinding_variant)
        
        return _UniffiConverterTypeWolletDescriptor.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_signer_singlesig_desc,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSinglesig.lower(script_variant),
        _UniffiConverterTypeDescriptorBlindingKey.lower(blinding_variant))
        )





    def wpkh_slip77_descriptor(self, ) -> "WolletDescriptor":
        return _UniffiConverterTypeWolletDescriptor.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_signer_wpkh_slip77_descriptor,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeSigner:

    @staticmethod
    def lift(value: int):
        return Signer._make_instance_(value)

    @staticmethod
    def check_lower(value: Signer):
        if not isinstance(value, Signer):
            raise TypeError("Expected Signer instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: SignerProtocol):
        if not isinstance(value, Signer):
            raise TypeError("Expected Signer instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: SignerProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TransactionProtocol(typing.Protocol):
    def bytes(self, ):
        raise NotImplementedError
    def fee(self, policy_asset: "AssetId"):
        raise NotImplementedError
    def inputs(self, ):
        raise NotImplementedError
    def outputs(self, ):
        raise NotImplementedError
    def txid(self, ):
        raise NotImplementedError


class Transaction:
    _pointer: ctypes.c_void_p
    def __init__(self, hex: "Hex"):
        """
        Construct a Transaction object
        """

        _UniffiConverterTypeHex.check_lower(hex)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_transaction_new,
        _UniffiConverterTypeHex.lower(hex))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_transaction, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_transaction, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def bytes(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_bytes,self._uniffi_clone_pointer(),)
        )





    def fee(self, policy_asset: "AssetId") -> "int":
        _UniffiConverterTypeAssetId.check_lower(policy_asset)
        
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_fee,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAssetId.lower(policy_asset))
        )





    def inputs(self, ) -> "typing.List[TxIn]":
        return _UniffiConverterSequenceTypeTxIn.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_inputs,self._uniffi_clone_pointer(),)
        )





    def outputs(self, ) -> "typing.List[TxOut]":
        return _UniffiConverterSequenceTypeTxOut.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_outputs,self._uniffi_clone_pointer(),)
        )





    def txid(self, ) -> "Txid":
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_txid,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_transaction_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTransaction:

    @staticmethod
    def lift(value: int):
        return Transaction._make_instance_(value)

    @staticmethod
    def check_lower(value: Transaction):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TransactionProtocol):
        if not isinstance(value, Transaction):
            raise TypeError("Expected Transaction instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TransactionProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxBuilderProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::TxBuilder`]
    """

    def add_burn(self, satoshi: "int",asset: "AssetId"):
        """
        Burn satoshi units of the given asset
        """

        raise NotImplementedError
    def add_external_utxos(self, utxos: "typing.List[ExternalUtxo]"):
        """
        Add external utxos, wrapper of [`lwk_wollet::TxBuilder::add_external_utxos()`]
        """

        raise NotImplementedError
    def add_lbtc_recipient(self, address: "Address",satoshi: "int"):
        """
        Add a recipient receiving L-BTC
        """

        raise NotImplementedError
    def add_recipient(self, address: "Address",satoshi: "int",asset: "AssetId"):
        """
        Add a recipient receiving the given asset
        """

        raise NotImplementedError
    def drain_lbtc_to(self, address: "Address"):
        """
        Sets the address to drain excess L-BTC to
        """

        raise NotImplementedError
    def drain_lbtc_wallet(self, ):
        """
        Select all available L-BTC inputs
        """

        raise NotImplementedError
    def fee_rate(self, rate: "typing.Optional[float]"):
        """
        Fee rate in sats/kvb
        Multiply sats/vb value by 1000 i.e. 1.0 sat/byte = 1000.0 sat/kvb
        """

        raise NotImplementedError
    def finish(self, wollet: "Wollet"):
        """
        Build the transaction
        """

        raise NotImplementedError
    def issue_asset(self, asset_sats: "int",asset_receiver: "typing.Optional[Address]",token_sats: "int",token_receiver: "typing.Optional[Address]",contract: "typing.Optional[Contract]"):
        """
        Issue an asset, wrapper of [`lwk_wollet::TxBuilder::issue_asset()`]
        """

        raise NotImplementedError
    def liquidex_make(self, utxo: "OutPoint",address: "Address",amount: "int",asset: "AssetId"):
        raise NotImplementedError
    def liquidex_take(self, proposals: "typing.List[ValidatedLiquidexProposal]"):
        raise NotImplementedError
    def reissue_asset(self, asset_to_reissue: "AssetId",satoshi_to_reissue: "int",asset_receiver: "typing.Optional[Address]",issuance_tx: "typing.Optional[Transaction]"):
        """
        Reissue an asset, wrapper of [`lwk_wollet::TxBuilder::reissue_asset()`]
        """

        raise NotImplementedError
    def set_wallet_utxos(self, utxos: "typing.List[OutPoint]"):
        """
        Manual coin selection, wrapper of [`lwk_wollet::TxBuilder::set_wallet_utxos()`]
        """

        raise NotImplementedError


class TxBuilder:
    """
    Wrapper over [`lwk_wollet::TxBuilder`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, network: "Network"):
        """
        Construct a transaction builder
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_constructor_txbuilder_new,
        _UniffiConverterTypeNetwork.lower(network))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_txbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_txbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def add_burn(self, satoshi: "int",asset: "AssetId") -> None:
        """
        Burn satoshi units of the given asset
        """

        _UniffiConverterUInt64.check_lower(satoshi)
        
        _UniffiConverterTypeAssetId.check_lower(asset)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_burn,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(satoshi),
        _UniffiConverterTypeAssetId.lower(asset))






    def add_external_utxos(self, utxos: "typing.List[ExternalUtxo]") -> None:
        """
        Add external utxos, wrapper of [`lwk_wollet::TxBuilder::add_external_utxos()`]
        """

        _UniffiConverterSequenceTypeExternalUtxo.check_lower(utxos)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_external_utxos,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeExternalUtxo.lower(utxos))






    def add_lbtc_recipient(self, address: "Address",satoshi: "int") -> None:
        """
        Add a recipient receiving L-BTC
        """

        _UniffiConverterTypeAddress.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(satoshi)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_lbtc_recipient,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address),
        _UniffiConverterUInt64.lower(satoshi))






    def add_recipient(self, address: "Address",satoshi: "int",asset: "AssetId") -> None:
        """
        Add a recipient receiving the given asset
        """

        _UniffiConverterTypeAddress.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(satoshi)
        
        _UniffiConverterTypeAssetId.check_lower(asset)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_add_recipient,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address),
        _UniffiConverterUInt64.lower(satoshi),
        _UniffiConverterTypeAssetId.lower(asset))






    def drain_lbtc_to(self, address: "Address") -> None:
        """
        Sets the address to drain excess L-BTC to
        """

        _UniffiConverterTypeAddress.check_lower(address)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_to,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAddress.lower(address))






    def drain_lbtc_wallet(self, ) -> None:
        """
        Select all available L-BTC inputs
        """

        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_drain_lbtc_wallet,self._uniffi_clone_pointer(),)






    def fee_rate(self, rate: "typing.Optional[float]") -> None:
        """
        Fee rate in sats/kvb
        Multiply sats/vb value by 1000 i.e. 1.0 sat/byte = 1000.0 sat/kvb
        """

        _UniffiConverterOptionalFloat.check_lower(rate)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_fee_rate,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalFloat.lower(rate))






    def finish(self, wollet: "Wollet") -> "Pset":
        """
        Build the transaction
        """

        _UniffiConverterTypeWollet.check_lower(wollet)
        
        return _UniffiConverterTypePset.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_finish,self._uniffi_clone_pointer(),
        _UniffiConverterTypeWollet.lower(wollet))
        )





    def issue_asset(self, asset_sats: "int",asset_receiver: "typing.Optional[Address]",token_sats: "int",token_receiver: "typing.Optional[Address]",contract: "typing.Optional[Contract]") -> None:
        """
        Issue an asset, wrapper of [`lwk_wollet::TxBuilder::issue_asset()`]
        """

        _UniffiConverterUInt64.check_lower(asset_sats)
        
        _UniffiConverterOptionalTypeAddress.check_lower(asset_receiver)
        
        _UniffiConverterUInt64.check_lower(token_sats)
        
        _UniffiConverterOptionalTypeAddress.check_lower(token_receiver)
        
        _UniffiConverterOptionalTypeContract.check_lower(contract)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_issue_asset,self._uniffi_clone_pointer(),
        _UniffiConverterUInt64.lower(asset_sats),
        _UniffiConverterOptionalTypeAddress.lower(asset_receiver),
        _UniffiConverterUInt64.lower(token_sats),
        _UniffiConverterOptionalTypeAddress.lower(token_receiver),
        _UniffiConverterOptionalTypeContract.lower(contract))






    def liquidex_make(self, utxo: "OutPoint",address: "Address",amount: "int",asset: "AssetId") -> None:
        _UniffiConverterTypeOutPoint.check_lower(utxo)
        
        _UniffiConverterTypeAddress.check_lower(address)
        
        _UniffiConverterUInt64.check_lower(amount)
        
        _UniffiConverterTypeAssetId.check_lower(asset)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_liquidex_make,self._uniffi_clone_pointer(),
        _UniffiConverterTypeOutPoint.lower(utxo),
        _UniffiConverterTypeAddress.lower(address),
        _UniffiConverterUInt64.lower(amount),
        _UniffiConverterTypeAssetId.lower(asset))






    def liquidex_take(self, proposals: "typing.List[ValidatedLiquidexProposal]") -> None:
        _UniffiConverterSequenceTypeValidatedLiquidexProposal.check_lower(proposals)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_liquidex_take,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeValidatedLiquidexProposal.lower(proposals))






    def reissue_asset(self, asset_to_reissue: "AssetId",satoshi_to_reissue: "int",asset_receiver: "typing.Optional[Address]",issuance_tx: "typing.Optional[Transaction]") -> None:
        """
        Reissue an asset, wrapper of [`lwk_wollet::TxBuilder::reissue_asset()`]
        """

        _UniffiConverterTypeAssetId.check_lower(asset_to_reissue)
        
        _UniffiConverterUInt64.check_lower(satoshi_to_reissue)
        
        _UniffiConverterOptionalTypeAddress.check_lower(asset_receiver)
        
        _UniffiConverterOptionalTypeTransaction.check_lower(issuance_tx)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_reissue_asset,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAssetId.lower(asset_to_reissue),
        _UniffiConverterUInt64.lower(satoshi_to_reissue),
        _UniffiConverterOptionalTypeAddress.lower(asset_receiver),
        _UniffiConverterOptionalTypeTransaction.lower(issuance_tx))






    def set_wallet_utxos(self, utxos: "typing.List[OutPoint]") -> None:
        """
        Manual coin selection, wrapper of [`lwk_wollet::TxBuilder::set_wallet_utxos()`]
        """

        _UniffiConverterSequenceTypeOutPoint.check_lower(utxos)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txbuilder_set_wallet_utxos,self._uniffi_clone_pointer(),
        _UniffiConverterSequenceTypeOutPoint.lower(utxos))






    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txbuilder_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTxBuilder:

    @staticmethod
    def lift(value: int):
        return TxBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: TxBuilder):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxBuilderProtocol):
        if not isinstance(value, TxBuilder):
            raise TypeError("Expected TxBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxInProtocol(typing.Protocol):
    def outpoint(self, ):
        """
        Outpoint
        """

        raise NotImplementedError


class TxIn:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_txin, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_txin, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def outpoint(self, ) -> "OutPoint":
        """
        Outpoint
        """

        return _UniffiConverterTypeOutPoint.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txin_outpoint,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTxIn:

    @staticmethod
    def lift(value: int):
        return TxIn._make_instance_(value)

    @staticmethod
    def check_lower(value: TxIn):
        if not isinstance(value, TxIn):
            raise TypeError("Expected TxIn instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxInProtocol):
        if not isinstance(value, TxIn):
            raise TypeError("Expected TxIn instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxInProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxOutProtocol(typing.Protocol):
    def asset(self, ):
        """
        If explicit returns the asset, if confidential [None]
        """

        raise NotImplementedError
    def is_fee(self, ):
        """
        Whether or not this output is a fee output
        """

        raise NotImplementedError
    def is_partially_blinded(self, ):
        """
        Returns if at least some part of this output are blinded
        """

        raise NotImplementedError
    def script_pubkey(self, ):
        """
        Scriptpubkey
        """

        raise NotImplementedError
    def unblind(self, secret_key: "SecretKey"):
        """
        Unblind the output
        """

        raise NotImplementedError
    def unconfidential_address(self, network: "Network"):
        """
        Unconfidential address
        """

        raise NotImplementedError
    def value(self, ):
        """
        If explicit returns the value, if confidential [None]
        """

        raise NotImplementedError


class TxOut:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_txout, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_txout, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def asset(self, ) -> "typing.Optional[AssetId]":
        """
        If explicit returns the asset, if confidential [None]
        """

        return _UniffiConverterOptionalTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txout_asset,self._uniffi_clone_pointer(),)
        )





    def is_fee(self, ) -> "bool":
        """
        Whether or not this output is a fee output
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txout_is_fee,self._uniffi_clone_pointer(),)
        )





    def is_partially_blinded(self, ) -> "bool":
        """
        Returns if at least some part of this output are blinded
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txout_is_partially_blinded,self._uniffi_clone_pointer(),)
        )





    def script_pubkey(self, ) -> "Script":
        """
        Scriptpubkey
        """

        return _UniffiConverterTypeScript.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txout_script_pubkey,self._uniffi_clone_pointer(),)
        )





    def unblind(self, secret_key: "SecretKey") -> "TxOutSecrets":
        """
        Unblind the output
        """

        _UniffiConverterTypeSecretKey.check_lower(secret_key)
        
        return _UniffiConverterTypeTxOutSecrets.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_txout_unblind,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSecretKey.lower(secret_key))
        )





    def unconfidential_address(self, network: "Network") -> "typing.Optional[Address]":
        """
        Unconfidential address
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        return _UniffiConverterOptionalTypeAddress.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txout_unconfidential_address,self._uniffi_clone_pointer(),
        _UniffiConverterTypeNetwork.lower(network))
        )





    def value(self, ) -> "typing.Optional[int]":
        """
        If explicit returns the value, if confidential [None]
        """

        return _UniffiConverterOptionalUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txout_value,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTxOut:

    @staticmethod
    def lift(value: int):
        return TxOut._make_instance_(value)

    @staticmethod
    def check_lower(value: TxOut):
        if not isinstance(value, TxOut):
            raise TypeError("Expected TxOut instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxOutProtocol):
        if not isinstance(value, TxOut):
            raise TypeError("Expected TxOut instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxOutProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxOutSecretsProtocol(typing.Protocol):
    def asset(self, ):
        raise NotImplementedError
    def asset_bf(self, ):
        raise NotImplementedError
    def asset_commitment(self, ):
        """
        Get the asset commitment

        If the output is explicit, returns the empty string
        """

        raise NotImplementedError
    def is_explicit(self, ):
        raise NotImplementedError
    def value(self, ):
        raise NotImplementedError
    def value_bf(self, ):
        raise NotImplementedError
    def value_commitment(self, ):
        """
        Get the value commitment

        If the output is explicit, returns the empty string
        """

        raise NotImplementedError


class TxOutSecrets:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_txoutsecrets, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_txoutsecrets, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def asset(self, ) -> "AssetId":
        return _UniffiConverterTypeAssetId.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset,self._uniffi_clone_pointer(),)
        )





    def asset_bf(self, ) -> "Hex":
        return _UniffiConverterTypeHex.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_bf,self._uniffi_clone_pointer(),)
        )





    def asset_commitment(self, ) -> "Hex":
        """
        Get the asset commitment

        If the output is explicit, returns the empty string
        """

        return _UniffiConverterTypeHex.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_asset_commitment,self._uniffi_clone_pointer(),)
        )





    def is_explicit(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_is_explicit,self._uniffi_clone_pointer(),)
        )





    def value(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value,self._uniffi_clone_pointer(),)
        )





    def value_bf(self, ) -> "Hex":
        return _UniffiConverterTypeHex.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_bf,self._uniffi_clone_pointer(),)
        )





    def value_commitment(self, ) -> "Hex":
        """
        Get the value commitment

        If the output is explicit, returns the empty string
        """

        return _UniffiConverterTypeHex.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txoutsecrets_value_commitment,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTxOutSecrets:

    @staticmethod
    def lift(value: int):
        return TxOutSecrets._make_instance_(value)

    @staticmethod
    def check_lower(value: TxOutSecrets):
        if not isinstance(value, TxOutSecrets):
            raise TypeError("Expected TxOutSecrets instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxOutSecretsProtocol):
        if not isinstance(value, TxOutSecrets):
            raise TypeError("Expected TxOutSecrets instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxOutSecretsProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class TxidProtocol(typing.Protocol):
    def bytes(self, ):
        raise NotImplementedError


class Txid:
    _pointer: ctypes.c_void_p
    def __init__(self, hex: "Hex"):
        """
        Construct a Txid object
        """

        _UniffiConverterTypeHex.check_lower(hex)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_txid_new,
        _UniffiConverterTypeHex.lower(hex))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_txid, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_txid, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def bytes(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txid_bytes,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_txid_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeTxid:

    @staticmethod
    def lift(value: int):
        return Txid._make_instance_(value)

    @staticmethod
    def check_lower(value: Txid):
        if not isinstance(value, Txid):
            raise TypeError("Expected Txid instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: TxidProtocol):
        if not isinstance(value, Txid):
            raise TypeError("Expected Txid instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: TxidProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class UnvalidatedLiquidexProposalProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::LiquidexProposal<Unvalidated>`]
    """

    def insecure_validate(self, ):
        raise NotImplementedError
    def needed_tx(self, ):
        raise NotImplementedError
    def validate(self, previous_tx: "Transaction"):
        raise NotImplementedError


class UnvalidatedLiquidexProposal:
    """
    Wrapper over [`lwk_wollet::LiquidexProposal<Unvalidated>`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, s: "str"):
        _UniffiConverterString.check_lower(s)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_unvalidatedliquidexproposal_new,
        _UniffiConverterString.lower(s))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_unvalidatedliquidexproposal, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_unvalidatedliquidexproposal, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def from_pset(cls, pset: "Pset"):
        _UniffiConverterTypePset.check_lower(pset)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_unvalidatedliquidexproposal_from_pset,
        _UniffiConverterTypePset.lower(pset))
        return cls._make_instance_(pointer)



    def insecure_validate(self, ) -> "ValidatedLiquidexProposal":
        return _UniffiConverterTypeValidatedLiquidexProposal.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_insecure_validate,self._uniffi_clone_pointer(),)
        )





    def needed_tx(self, ) -> "Txid":
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_needed_tx,self._uniffi_clone_pointer(),)
        )





    def validate(self, previous_tx: "Transaction") -> "ValidatedLiquidexProposal":
        _UniffiConverterTypeTransaction.check_lower(previous_tx)
        
        return _UniffiConverterTypeValidatedLiquidexProposal.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_validate,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTransaction.lower(previous_tx))
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_unvalidatedliquidexproposal_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeUnvalidatedLiquidexProposal:

    @staticmethod
    def lift(value: int):
        return UnvalidatedLiquidexProposal._make_instance_(value)

    @staticmethod
    def check_lower(value: UnvalidatedLiquidexProposal):
        if not isinstance(value, UnvalidatedLiquidexProposal):
            raise TypeError("Expected UnvalidatedLiquidexProposal instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: UnvalidatedLiquidexProposalProtocol):
        if not isinstance(value, UnvalidatedLiquidexProposal):
            raise TypeError("Expected UnvalidatedLiquidexProposal instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: UnvalidatedLiquidexProposalProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class UpdateProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::Update`]
    """

    def only_tip(self, ):
        """
        Whether the update only changes the tip (does not affect transactions)
        """

        raise NotImplementedError
    def serialize(self, ):
        raise NotImplementedError


class Update:
    """
    Wrapper over [`lwk_wollet::Update`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, bytes: "bytes"):
        _UniffiConverterBytes.check_lower(bytes)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_update_new,
        _UniffiConverterBytes.lower(bytes))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_update, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_update, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def only_tip(self, ) -> "bool":
        """
        Whether the update only changes the tip (does not affect transactions)
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_update_only_tip,self._uniffi_clone_pointer(),)
        )





    def serialize(self, ) -> "bytes":
        return _UniffiConverterBytes.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_update_serialize,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeUpdate:

    @staticmethod
    def lift(value: int):
        return Update._make_instance_(value)

    @staticmethod
    def check_lower(value: Update):
        if not isinstance(value, Update):
            raise TypeError("Expected Update instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: UpdateProtocol):
        if not isinstance(value, Update):
            raise TypeError("Expected Update instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: UpdateProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ValidatedLiquidexProposalProtocol(typing.Protocol):
    """
    Wrapper over [`lwk_wollet::LiquidexProposal<Validated>`]
    """

    def input(self, ):
        raise NotImplementedError
    def output(self, ):
        raise NotImplementedError


class ValidatedLiquidexProposal:
    """
    Wrapper over [`lwk_wollet::LiquidexProposal<Validated>`]
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_validatedliquidexproposal, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_validatedliquidexproposal, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def input(self, ) -> "AssetAmount":
        return _UniffiConverterTypeAssetAmount.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_input,self._uniffi_clone_pointer(),)
        )





    def output(self, ) -> "AssetAmount":
        return _UniffiConverterTypeAssetAmount.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_output,self._uniffi_clone_pointer(),)
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_validatedliquidexproposal_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeValidatedLiquidexProposal:

    @staticmethod
    def lift(value: int):
        return ValidatedLiquidexProposal._make_instance_(value)

    @staticmethod
    def check_lower(value: ValidatedLiquidexProposal):
        if not isinstance(value, ValidatedLiquidexProposal):
            raise TypeError("Expected ValidatedLiquidexProposal instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ValidatedLiquidexProposalProtocol):
        if not isinstance(value, ValidatedLiquidexProposal):
            raise TypeError("Expected ValidatedLiquidexProposal instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ValidatedLiquidexProposalProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WalletTxProtocol(typing.Protocol):
    def balance(self, ):
        raise NotImplementedError
    def fee(self, ):
        raise NotImplementedError
    def height(self, ):
        raise NotImplementedError
    def inputs(self, ):
        raise NotImplementedError
    def outputs(self, ):
        raise NotImplementedError
    def timestamp(self, ):
        raise NotImplementedError
    def tx(self, ):
        raise NotImplementedError
    def txid(self, ):
        raise NotImplementedError
    def type(self, ):
        raise NotImplementedError
    def unblinded_url(self, explorer_url: "str"):
        raise NotImplementedError


class WalletTx:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_wallettx, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_wallettx, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def balance(self, ) -> "dict[AssetId, int]":
        return _UniffiConverterMapTypeAssetIdInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_balance,self._uniffi_clone_pointer(),)
        )





    def fee(self, ) -> "int":
        return _UniffiConverterUInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_fee,self._uniffi_clone_pointer(),)
        )





    def height(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_height,self._uniffi_clone_pointer(),)
        )





    def inputs(self, ) -> "typing.List[typing.Optional[WalletTxOut]]":
        return _UniffiConverterSequenceOptionalTypeWalletTxOut.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_inputs,self._uniffi_clone_pointer(),)
        )





    def outputs(self, ) -> "typing.List[typing.Optional[WalletTxOut]]":
        return _UniffiConverterSequenceOptionalTypeWalletTxOut.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_outputs,self._uniffi_clone_pointer(),)
        )





    def timestamp(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_timestamp,self._uniffi_clone_pointer(),)
        )





    def tx(self, ) -> "Transaction":
        return _UniffiConverterTypeTransaction.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_tx,self._uniffi_clone_pointer(),)
        )





    def txid(self, ) -> "Txid":
        return _UniffiConverterTypeTxid.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_txid,self._uniffi_clone_pointer(),)
        )





    def type(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_type_,self._uniffi_clone_pointer(),)
        )





    def unblinded_url(self, explorer_url: "str") -> "str":
        _UniffiConverterString.check_lower(explorer_url)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettx_unblinded_url,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(explorer_url))
        )






class _UniffiConverterTypeWalletTx:

    @staticmethod
    def lift(value: int):
        return WalletTx._make_instance_(value)

    @staticmethod
    def check_lower(value: WalletTx):
        if not isinstance(value, WalletTx):
            raise TypeError("Expected WalletTx instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WalletTxProtocol):
        if not isinstance(value, WalletTx):
            raise TypeError("Expected WalletTx instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WalletTxProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WalletTxOutProtocol(typing.Protocol):
    def address(self, ):
        raise NotImplementedError
    def ext_int(self, ):
        raise NotImplementedError
    def height(self, ):
        raise NotImplementedError
    def outpoint(self, ):
        raise NotImplementedError
    def script_pubkey(self, ):
        raise NotImplementedError
    def unblinded(self, ):
        raise NotImplementedError
    def wildcard_index(self, ):
        raise NotImplementedError


class WalletTxOut:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_wallettxout, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_wallettxout, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def address(self, ) -> "Address":
        return _UniffiConverterTypeAddress.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_address,self._uniffi_clone_pointer(),)
        )





    def ext_int(self, ) -> "Chain":
        return _UniffiConverterTypeChain.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_ext_int,self._uniffi_clone_pointer(),)
        )





    def height(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_height,self._uniffi_clone_pointer(),)
        )





    def outpoint(self, ) -> "OutPoint":
        return _UniffiConverterTypeOutPoint.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_outpoint,self._uniffi_clone_pointer(),)
        )





    def script_pubkey(self, ) -> "Script":
        return _UniffiConverterTypeScript.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_script_pubkey,self._uniffi_clone_pointer(),)
        )





    def unblinded(self, ) -> "TxOutSecrets":
        return _UniffiConverterTypeTxOutSecrets.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_unblinded,self._uniffi_clone_pointer(),)
        )





    def wildcard_index(self, ) -> "int":
        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wallettxout_wildcard_index,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeWalletTxOut:

    @staticmethod
    def lift(value: int):
        return WalletTxOut._make_instance_(value)

    @staticmethod
    def check_lower(value: WalletTxOut):
        if not isinstance(value, WalletTxOut):
            raise TypeError("Expected WalletTxOut instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WalletTxOutProtocol):
        if not isinstance(value, WalletTxOut):
            raise TypeError("Expected WalletTxOut instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WalletTxOutProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WolletProtocol(typing.Protocol):
    """
    A Watch-Only wallet, wrapper over [`lwk_wollet::Wollet`]
    """

    def add_details(self, pset: "Pset"):
        """
        Add wallet details to the PSET
        """

        raise NotImplementedError
    def address(self, index: "typing.Optional[int]"):
        raise NotImplementedError
    def apply_update(self, update: "Update"):
        raise NotImplementedError
    def balance(self, ):
        raise NotImplementedError
    def descriptor(self, ):
        raise NotImplementedError
    def extract_wallet_utxos(self, pset: "Pset"):
        """
        Extract the wallet UTXOs that a PSET is creating
        """

        raise NotImplementedError
    def finalize(self, pset: "Pset"):
        raise NotImplementedError
    def is_segwit(self, ):
        """
        Whether the wallet is segwit
        """

        raise NotImplementedError
    def max_weight_to_satisfy(self, ):
        """
        Max weight to satisfy for inputs belonging to this wallet
        """

        raise NotImplementedError
    def pset_details(self, pset: "Pset"):
        raise NotImplementedError
    def transactions(self, ):
        raise NotImplementedError
    def transactions_paginated(self, offset: "int",limit: "int"):
        raise NotImplementedError
    def txos(self, ):
        """
        Get all the transaction outputs of the wallet, both spent and unspent
        """

        raise NotImplementedError
    def unblind_utxos_with(self, blinding_privkey: "SecretKey"):
        """
        Get the utxo with unspent transaction outputs of the wallet
        Return utxos unblinded with a specific blinding key
        """

        raise NotImplementedError
    def utxos(self, ):
        """
        Get the unspent transaction outputs of the wallet
        """

        raise NotImplementedError
    def wait_for_tx(self, txid: "Txid",client: "ElectrumClient"):
        """
        Note this a test method but we are not feature gating in test because we need it in
        destination language examples
        """

        raise NotImplementedError


class Wollet:
    """
    A Watch-Only wallet, wrapper over [`lwk_wollet::Wollet`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, network: "Network",descriptor: "WolletDescriptor",datadir: "typing.Optional[str]"):
        """
        Construct a Watch-Only wallet object
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        _UniffiConverterTypeWolletDescriptor.check_lower(descriptor)
        
        _UniffiConverterOptionalString.check_lower(datadir)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_wollet_new,
        _UniffiConverterTypeNetwork.lower(network),
        _UniffiConverterTypeWolletDescriptor.lower(descriptor),
        _UniffiConverterOptionalString.lower(datadir))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_wollet, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_wollet, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    @classmethod
    def with_custom_persister(cls, network: "Network",descriptor: "WolletDescriptor",persister: "ForeignPersisterLink"):
        """
        Construct a Watch-Only wallet object with a caller provided persister
        """

        _UniffiConverterTypeNetwork.check_lower(network)
        
        _UniffiConverterTypeWolletDescriptor.check_lower(descriptor)
        
        _UniffiConverterTypeForeignPersisterLink.check_lower(persister)
        
        # Call the (fallible) function before creating any half-baked object instances.
        pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_wollet_with_custom_persister,
        _UniffiConverterTypeNetwork.lower(network),
        _UniffiConverterTypeWolletDescriptor.lower(descriptor),
        _UniffiConverterTypeForeignPersisterLink.lower(persister))
        return cls._make_instance_(pointer)



    def add_details(self, pset: "Pset") -> "Pset":
        """
        Add wallet details to the PSET
        """

        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePset.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_add_details,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )





    def address(self, index: "typing.Optional[int]") -> "AddressResult":
        _UniffiConverterOptionalUInt32.check_lower(index)
        
        return _UniffiConverterTypeAddressResult.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_address,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalUInt32.lower(index))
        )





    def apply_update(self, update: "Update") -> None:
        _UniffiConverterTypeUpdate.check_lower(update)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_apply_update,self._uniffi_clone_pointer(),
        _UniffiConverterTypeUpdate.lower(update))






    def balance(self, ) -> "dict[AssetId, int]":
        return _UniffiConverterMapTypeAssetIdUInt64.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_balance,self._uniffi_clone_pointer(),)
        )





    def descriptor(self, ) -> "WolletDescriptor":
        return _UniffiConverterTypeWolletDescriptor.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_descriptor,self._uniffi_clone_pointer(),)
        )





    def extract_wallet_utxos(self, pset: "Pset") -> "typing.List[ExternalUtxo]":
        """
        Extract the wallet UTXOs that a PSET is creating
        """

        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterSequenceTypeExternalUtxo.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_extract_wallet_utxos,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )





    def finalize(self, pset: "Pset") -> "Pset":
        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePset.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_finalize,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )





    def is_segwit(self, ) -> "bool":
        """
        Whether the wallet is segwit
        """

        return _UniffiConverterBool.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_is_segwit,self._uniffi_clone_pointer(),)
        )





    def max_weight_to_satisfy(self, ) -> "int":
        """
        Max weight to satisfy for inputs belonging to this wallet
        """

        return _UniffiConverterUInt32.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_max_weight_to_satisfy,self._uniffi_clone_pointer(),)
        )





    def pset_details(self, pset: "Pset") -> "PsetDetails":
        _UniffiConverterTypePset.check_lower(pset)
        
        return _UniffiConverterTypePsetDetails.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_pset_details,self._uniffi_clone_pointer(),
        _UniffiConverterTypePset.lower(pset))
        )





    def transactions(self, ) -> "typing.List[WalletTx]":
        return _UniffiConverterSequenceTypeWalletTx.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_transactions,self._uniffi_clone_pointer(),)
        )





    def transactions_paginated(self, offset: "int",limit: "int") -> "typing.List[WalletTx]":
        _UniffiConverterUInt32.check_lower(offset)
        
        _UniffiConverterUInt32.check_lower(limit)
        
        return _UniffiConverterSequenceTypeWalletTx.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_transactions_paginated,self._uniffi_clone_pointer(),
        _UniffiConverterUInt32.lower(offset),
        _UniffiConverterUInt32.lower(limit))
        )





    def txos(self, ) -> "typing.List[WalletTxOut]":
        """
        Get all the transaction outputs of the wallet, both spent and unspent
        """

        return _UniffiConverterSequenceTypeWalletTxOut.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_txos,self._uniffi_clone_pointer(),)
        )





    def unblind_utxos_with(self, blinding_privkey: "SecretKey") -> "typing.List[ExternalUtxo]":
        """
        Get the utxo with unspent transaction outputs of the wallet
        Return utxos unblinded with a specific blinding key
        """

        _UniffiConverterTypeSecretKey.check_lower(blinding_privkey)
        
        return _UniffiConverterSequenceTypeExternalUtxo.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_unblind_utxos_with,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSecretKey.lower(blinding_privkey))
        )





    def utxos(self, ) -> "typing.List[WalletTxOut]":
        """
        Get the unspent transaction outputs of the wallet
        """

        return _UniffiConverterSequenceTypeWalletTxOut.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_utxos,self._uniffi_clone_pointer(),)
        )





    def wait_for_tx(self, txid: "Txid",client: "ElectrumClient") -> "WalletTx":
        """
        Note this a test method but we are not feature gating in test because we need it in
        destination language examples
        """

        _UniffiConverterTypeTxid.check_lower(txid)
        
        _UniffiConverterTypeElectrumClient.check_lower(client)
        
        return _UniffiConverterTypeWalletTx.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wollet_wait_for_tx,self._uniffi_clone_pointer(),
        _UniffiConverterTypeTxid.lower(txid),
        _UniffiConverterTypeElectrumClient.lower(client))
        )






class _UniffiConverterTypeWollet:

    @staticmethod
    def lift(value: int):
        return Wollet._make_instance_(value)

    @staticmethod
    def check_lower(value: Wollet):
        if not isinstance(value, Wollet):
            raise TypeError("Expected Wollet instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WolletProtocol):
        if not isinstance(value, Wollet):
            raise TypeError("Expected Wollet instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WolletProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class WolletDescriptorProtocol(typing.Protocol):
    """
    The output descriptors, wrapper over [`lwk_wollet::WolletDescriptor`]
    """

    def derive_blinding_key(self, script_pubkey: "Script"):
        """
        Derive the private blinding key
        """

        raise NotImplementedError
    def is_mainnet(self, ):
        raise NotImplementedError
    def script_pubkey(self, ext_int: "Chain",index: "int"):
        """
        Derive a scriptpubkey
        """

        raise NotImplementedError


class WolletDescriptor:
    """
    The output descriptors, wrapper over [`lwk_wollet::WolletDescriptor`]
    """

    _pointer: ctypes.c_void_p
    def __init__(self, descriptor: "str"):
        _UniffiConverterString.check_lower(descriptor)
        
        self._pointer = _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_constructor_wolletdescriptor_new,
        _UniffiConverterString.lower(descriptor))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_free_wolletdescriptor, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_clone_wolletdescriptor, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def derive_blinding_key(self, script_pubkey: "Script") -> "typing.Optional[SecretKey]":
        """
        Derive the private blinding key
        """

        _UniffiConverterTypeScript.check_lower(script_pubkey)
        
        return _UniffiConverterOptionalTypeSecretKey.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_derive_blinding_key,self._uniffi_clone_pointer(),
        _UniffiConverterTypeScript.lower(script_pubkey))
        )





    def is_mainnet(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_is_mainnet,self._uniffi_clone_pointer(),)
        )





    def script_pubkey(self, ext_int: "Chain",index: "int") -> "Script":
        """
        Derive a scriptpubkey
        """

        _UniffiConverterTypeChain.check_lower(ext_int)
        
        _UniffiConverterUInt32.check_lower(index)
        
        return _UniffiConverterTypeScript.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLwkError,_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_script_pubkey,self._uniffi_clone_pointer(),
        _UniffiConverterTypeChain.lower(ext_int),
        _UniffiConverterUInt32.lower(index))
        )





    def __str__(self, ) -> "str":
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_method_wolletdescriptor_uniffi_trait_display,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeWolletDescriptor:

    @staticmethod
    def lift(value: int):
        return WolletDescriptor._make_instance_(value)

    @staticmethod
    def check_lower(value: WolletDescriptor):
        if not isinstance(value, WolletDescriptor):
            raise TypeError("Expected WolletDescriptor instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: WolletDescriptorProtocol):
        if not isinstance(value, WolletDescriptor):
            raise TypeError("Expected WolletDescriptor instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: WolletDescriptorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))


class EsploraClientBuilder:
    base_url: "str"
    network: "Network"
    waterfalls: "bool"
    concurrency: "typing.Optional[int]"
    timeout: "typing.Optional[int]"
    def __init__(self, *, base_url: "str", network: "Network", waterfalls: "bool" = _DEFAULT, concurrency: "typing.Optional[int]" = _DEFAULT, timeout: "typing.Optional[int]" = _DEFAULT):
        self.base_url = base_url
        self.network = network
        if waterfalls is _DEFAULT:
            self.waterfalls = False
        else:
            self.waterfalls = waterfalls
        if concurrency is _DEFAULT:
            self.concurrency = None
        else:
            self.concurrency = concurrency
        if timeout is _DEFAULT:
            self.timeout = None
        else:
            self.timeout = timeout

    def __str__(self):
        return "EsploraClientBuilder(base_url={}, network={}, waterfalls={}, concurrency={}, timeout={})".format(self.base_url, self.network, self.waterfalls, self.concurrency, self.timeout)

    def __eq__(self, other):
        if self.base_url != other.base_url:
            return False
        if self.network != other.network:
            return False
        if self.waterfalls != other.waterfalls:
            return False
        if self.concurrency != other.concurrency:
            return False
        if self.timeout != other.timeout:
            return False
        return True

class _UniffiConverterTypeEsploraClientBuilder(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return EsploraClientBuilder(
            base_url=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeNetwork.read(buf),
            waterfalls=_UniffiConverterBool.read(buf),
            concurrency=_UniffiConverterOptionalUInt32.read(buf),
            timeout=_UniffiConverterOptionalUInt8.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.base_url)
        _UniffiConverterTypeNetwork.check_lower(value.network)
        _UniffiConverterBool.check_lower(value.waterfalls)
        _UniffiConverterOptionalUInt32.check_lower(value.concurrency)
        _UniffiConverterOptionalUInt8.check_lower(value.timeout)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.base_url, buf)
        _UniffiConverterTypeNetwork.write(value.network, buf)
        _UniffiConverterBool.write(value.waterfalls, buf)
        _UniffiConverterOptionalUInt32.write(value.concurrency, buf)
        _UniffiConverterOptionalUInt8.write(value.timeout, buf)





class Chain(enum.Enum):
    """
    see [`lwk_wollet::Chain`]
    """

    EXTERNAL = 0
    """
    External address, shown when asked for a payment.
    Wallet having a single descriptor are considered External
    """

    
    INTERNAL = 1
    """
    Internal address, used for the change
    """

    


class _UniffiConverterTypeChain(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Chain.EXTERNAL
        if variant == 2:
            return Chain.INTERNAL
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Chain.EXTERNAL:
            return
        if value == Chain.INTERNAL:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Chain.EXTERNAL:
            buf.write_i32(1)
        if value == Chain.INTERNAL:
            buf.write_i32(2)







class DescriptorBlindingKey(enum.Enum):
    SLIP77 = 0
    
    SLIP77_RAND = 1
    
    ELIP151 = 2
    


class _UniffiConverterTypeDescriptorBlindingKey(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return DescriptorBlindingKey.SLIP77
        if variant == 2:
            return DescriptorBlindingKey.SLIP77_RAND
        if variant == 3:
            return DescriptorBlindingKey.ELIP151
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == DescriptorBlindingKey.SLIP77:
            return
        if value == DescriptorBlindingKey.SLIP77_RAND:
            return
        if value == DescriptorBlindingKey.ELIP151:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == DescriptorBlindingKey.SLIP77:
            buf.write_i32(1)
        if value == DescriptorBlindingKey.SLIP77_RAND:
            buf.write_i32(2)
        if value == DescriptorBlindingKey.ELIP151:
            buf.write_i32(3)




# LwkError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class LwkError(Exception):
    """
    Possible errors emitted
    """

    pass

_UniffiTempLwkError = LwkError

class LwkError:  # type: ignore
    """
    Possible errors emitted
    """

    class Generic(_UniffiTempLwkError):
        def __init__(self, msg):
            super().__init__(", ".join([
                "msg={!r}".format(msg),
            ]))
            self.msg = msg

        def __repr__(self):
            return "LwkError.Generic({})".format(str(self))
    _UniffiTempLwkError.Generic = Generic # type: ignore
    class PoisonError(_UniffiTempLwkError):
        def __init__(self, msg):
            super().__init__(", ".join([
                "msg={!r}".format(msg),
            ]))
            self.msg = msg

        def __repr__(self):
            return "LwkError.PoisonError({})".format(str(self))
    _UniffiTempLwkError.PoisonError = PoisonError # type: ignore

LwkError = _UniffiTempLwkError # type: ignore
del _UniffiTempLwkError


class _UniffiConverterTypeLwkError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LwkError.Generic(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return LwkError.PoisonError(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, LwkError.Generic):
            _UniffiConverterString.check_lower(value.msg)
            return
        if isinstance(value, LwkError.PoisonError):
            _UniffiConverterString.check_lower(value.msg)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, LwkError.Generic):
            buf.write_i32(1)
            _UniffiConverterString.write(value.msg, buf)
        if isinstance(value, LwkError.PoisonError):
            buf.write_i32(2)
            _UniffiConverterString.write(value.msg, buf)





class Singlesig(enum.Enum):
    WPKH = 0
    
    SH_WPKH = 1
    


class _UniffiConverterTypeSinglesig(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Singlesig.WPKH
        if variant == 2:
            return Singlesig.SH_WPKH
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Singlesig.WPKH:
            return
        if value == Singlesig.SH_WPKH:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Singlesig.WPKH:
            buf.write_i32(1)
        if value == Singlesig.SH_WPKH:
            buf.write_i32(2)





class _UniffiConverterOptionalUInt8(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt8.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt8.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt8.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalFloat(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterFloat.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterFloat.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterFloat.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAddress(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAddress.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAddress.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAddress.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeContract(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeContract.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeContract.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeContract.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeIssuance(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeIssuance.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeIssuance.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeIssuance.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeScript(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeScript.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeScript.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeScript.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSecretKey(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSecretKey.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSecretKey.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSecretKey.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTransaction(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTransaction.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTransaction.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTransaction.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeTxid(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeTxid.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeTxid.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeTxid.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeUpdate(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeUpdate.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeUpdate.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeUpdate.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeWalletTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeWalletTxOut.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeWalletTxOut.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeWalletTxOut.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAssetId(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAssetId.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAssetId.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAssetId.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceTypeExternalUtxo(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeExternalUtxo.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeExternalUtxo.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeExternalUtxo.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeIssuance(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeIssuance.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeIssuance.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeIssuance.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeOutPoint(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeOutPoint.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeOutPoint.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeOutPoint.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePsetInput(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePsetInput.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePsetInput.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePsetInput.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePsetSignatures(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePsetSignatures.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePsetSignatures.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePsetSignatures.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRecipient(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRecipient.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRecipient.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRecipient.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTxIn(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTxIn.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTxIn.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTxIn.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeTxOut.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeTxOut.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeTxOut.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeValidatedLiquidexProposal(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeValidatedLiquidexProposal.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeValidatedLiquidexProposal.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeValidatedLiquidexProposal.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeWalletTx(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeWalletTx.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeWalletTx.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeWalletTx.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeWalletTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeWalletTxOut.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeWalletTxOut.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeWalletTxOut.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceOptionalTypeWalletTxOut(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterOptionalTypeWalletTxOut.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterOptionalTypeWalletTxOut.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterOptionalTypeWalletTxOut.read(buf) for i in range(count)
        ]



class _UniffiConverterMapStringString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterString.check_lower(key)
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterString.write(key, buf)
            _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterString.read(buf)
            val = _UniffiConverterString.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapTypeAssetIdUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.check_lower(key)
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.write(key, buf)
            _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeAssetId.read(buf)
            val = _UniffiConverterUInt64.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapTypeAssetIdInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.check_lower(key)
            _UniffiConverterInt64.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeAssetId.write(key, buf)
            _UniffiConverterInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeAssetId.read(buf)
            val = _UniffiConverterInt64.read(buf)
            d[key] = val
        return d


class _UniffiConverterTypeAssetId:
    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value, buf)

    @staticmethod
    def read(buf):
        return _UniffiConverterString.read(buf)

    @staticmethod
    def lift(value):
        return _UniffiConverterString.lift(value)

    @staticmethod
    def check_lower(value):
        return _UniffiConverterString.check_lower(value)

    @staticmethod
    def lower(value):
        return _UniffiConverterString.lower(value)


class _UniffiConverterTypeHex:
    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value, buf)

    @staticmethod
    def read(buf):
        return _UniffiConverterString.read(buf)

    @staticmethod
    def lift(value):
        return _UniffiConverterString.lift(value)

    @staticmethod
    def check_lower(value):
        return _UniffiConverterString.check_lower(value)

    @staticmethod
    def lower(value):
        return _UniffiConverterString.lower(value)
AssetId = str
Hex = str

# Async support

def is_provably_segwit(script_pubkey: "Script",redeem_script: "typing.Optional[Script]") -> "bool":
    _UniffiConverterTypeScript.check_lower(script_pubkey)
    
    _UniffiConverterOptionalTypeScript.check_lower(redeem_script)
    
    return _UniffiConverterBool.lift(_uniffi_rust_call(_UniffiLib.uniffi_lwk_fn_func_is_provably_segwit,
        _UniffiConverterTypeScript.lower(script_pubkey),
        _UniffiConverterOptionalTypeScript.lower(redeem_script)))


__all__ = [
    "InternalError",
    "Chain",
    "DescriptorBlindingKey",
    "LwkError",
    "Singlesig",
    "EsploraClientBuilder",
    "is_provably_segwit",
    "Address",
    "AddressResult",
    "Amp2",
    "Amp2Descriptor",
    "AssetAmount",
    "Bip",
    "Contract",
    "ElectrumClient",
    "EsploraClient",
    "ExternalUtxo",
    "ForeignPersister",
    "ForeignPersisterLink",
    "Issuance",
    "LwkTestEnv",
    "Mnemonic",
    "Network",
    "OutPoint",
    "Precision",
    "Pset",
    "PsetBalance",
    "PsetDetails",
    "PsetInput",
    "PsetSignatures",
    "Recipient",
    "Script",
    "SecretKey",
    "Signer",
    "Transaction",
    "TxBuilder",
    "TxIn",
    "TxOut",
    "TxOutSecrets",
    "Txid",
    "UnvalidatedLiquidexProposal",
    "Update",
    "ValidatedLiquidexProposal",
    "WalletTx",
    "WalletTxOut",
    "Wollet",
    "WolletDescriptor",
]

