from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel

class vtkImageBorderMode(int): ...

VTK_BLACKMAN_HARRIS3:int
VTK_BLACKMAN_HARRIS4:int
VTK_BLACKMAN_NUTTALL3:int
VTK_BLACKMAN_NUTTALL4:int
VTK_BLACKMAN_WINDOW:int
VTK_COSINE_WINDOW:int
VTK_HAMMING_WINDOW:int
VTK_HANN_WINDOW:int
VTK_IMAGE_BLEND_MODE_COMPOUND:int
VTK_IMAGE_BLEND_MODE_NORMAL:int
VTK_IMAGE_BORDER_CLAMP:'vtkImageBorderMode'
VTK_IMAGE_BORDER_MIRROR:'vtkImageBorderMode'
VTK_IMAGE_BORDER_REPEAT:'vtkImageBorderMode'
VTK_IMAGE_BSPLINE_DEGREE_MAX:int
VTK_KAISER_WINDOW:int
VTK_LANCZOS_WINDOW:int
VTK_NUTTALL_WINDOW:int
VTK_RESLICE_CUBIC:int
VTK_RESLICE_LINEAR:int
VTK_RESLICE_NEAREST:int
VTK_SINC_KERNEL_SIZE_MAX:int

class vtkAbstractImageInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    border_mode:'getset_descriptor'
    component_count:'getset_descriptor'
    component_offset:'getset_descriptor'
    direction:'getset_descriptor'
    extent:'getset_descriptor'
    number_of_components:'getset_descriptor'
    origin:'getset_descriptor'
    out_value:'getset_descriptor'
    sliding_window:'getset_descriptor'
    spacing:'getset_descriptor'
    tolerance:'getset_descriptor'
    def CheckBoundsIJK(self, x:Sequence[float]) -> bool: ...
    def ComputeNumberOfComponents(self, inputComponents:int) -> int: ...
    def ComputeSupportSize(self, matrix:Sequence[float], support:MutableSequence[int]) -> None: ...
    def DeepCopy(self, obj:'vtkAbstractImageInterpolator') -> None: ...
    def GetBorderMode(self) -> 'vtkImageBorderMode': ...
    def GetBorderModeAsString(self) -> str: ...
    def GetComponentCount(self) -> int: ...
    def GetComponentOffset(self) -> int: ...
    def GetDirection(self) -> Tuple[float, float, float, float, float, float, float, float, float]: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetOutValue(self) -> float: ...
    def GetSlidingWindow(self) -> bool: ...
    def GetSpacing(self) -> Tuple[float, float, float]: ...
    def GetTolerance(self) -> float: ...
    def Initialize(self, data:'vtkDataObject') -> None: ...
    @overload
    def Interpolate(self, x:float, y:float, z:float, component:int) -> float: ...
    @overload
    def Interpolate(self, point:Sequence[float], value:MutableSequence[float]) -> bool: ...
    def InterpolateIJK(self, point:Sequence[float], value:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsSeparable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractImageInterpolator': ...
    def ReleaseData(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractImageInterpolator': ...
    def SetBorderMode(self, mode:'vtkImageBorderMode') -> None: ...
    def SetBorderModeToClamp(self) -> None: ...
    def SetBorderModeToMirror(self) -> None: ...
    def SetBorderModeToRepeat(self) -> None: ...
    def SetComponentCount(self, count:int) -> None: ...
    def SetComponentOffset(self, offset:int) -> None: ...
    def SetOutValue(self, outValue:float) -> None: ...
    def SetSlidingWindow(self, x:bool) -> None: ...
    def SetTolerance(self, tol:float) -> None: ...
    def SlidingWindowOff(self) -> None: ...
    def SlidingWindowOn(self) -> None: ...
    def Update(self) -> None: ...

class vtkExtractVOI(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    include_boundary:'getset_descriptor'
    sample_rate:'getset_descriptor'
    voi:'getset_descriptor'
    def GetIncludeBoundary(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleRate(self) -> Tuple[int, int, int]: ...
    def GetVOI(self) -> Tuple[int, int, int, int, int, int]: ...
    def IncludeBoundaryOff(self) -> None: ...
    def IncludeBoundaryOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractVOI': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractVOI': ...
    def SetIncludeBoundary(self, _arg:int) -> None: ...
    @overload
    def SetSampleRate(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSampleRate(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetVOI(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetVOI(self, _arg:Sequence[int]) -> None: ...

class vtkImageInterpolator(vtkAbstractImageInterpolator):
    interpolation_mode:'getset_descriptor'
    def ComputeSupportSize(self, matrix:Sequence[float], size:MutableSequence[int]) -> None: ...
    def GetInterpolationMode(self) -> int: ...
    def GetInterpolationModeAsString(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsSeparable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageInterpolator': ...
    def SetInterpolationMode(self, mode:int) -> None: ...
    def SetInterpolationModeToCubic(self) -> None: ...
    def SetInterpolationModeToLinear(self) -> None: ...
    def SetInterpolationModeToNearest(self) -> None: ...

class vtkGenericImageInterpolator(vtkImageInterpolator):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericImageInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericImageInterpolator': ...
    def Update(self) -> None: ...

class vtkImageAppendComponents(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    @overload
    def GetInput(self, num:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageAppendComponents': ...
    def ReplaceNthInputConnection(self, idx:int, input:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageAppendComponents': ...
    @overload
    def SetInputData(self, num:int, input:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, input:'vtkDataObject') -> None: ...

class vtkImageBSplineCoefficients(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    border_mode:'getset_descriptor'
    border_mode_max_value:'getset_descriptor'
    border_mode_min_value:'getset_descriptor'
    bypass:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    spline_degree:'getset_descriptor'
    def BypassOff(self) -> None: ...
    def BypassOn(self) -> None: ...
    def CheckBounds(self, point:Sequence[float]) -> int: ...
    @overload
    def Evaluate(self, point:Sequence[float], value:MutableSequence[float]) -> None: ...
    @overload
    def Evaluate(self, x:float, y:float, z:float) -> float: ...
    @overload
    def Evaluate(self, point:Sequence[float]) -> float: ...
    def GetBorderMode(self) -> 'vtkImageBorderMode': ...
    def GetBorderModeAsString(self) -> str: ...
    def GetBorderModeMaxValue(self) -> 'vtkImageBorderMode': ...
    def GetBorderModeMinValue(self) -> 'vtkImageBorderMode': ...
    def GetBypass(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputScalarType(self) -> int: ...
    def GetOutputScalarTypeAsString(self) -> str: ...
    def GetOutputScalarTypeMaxValue(self) -> int: ...
    def GetOutputScalarTypeMinValue(self) -> int: ...
    def GetSplineDegree(self) -> int: ...
    def GetSplineDegreeMaxValue(self) -> int: ...
    def GetSplineDegreeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageBSplineCoefficients': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageBSplineCoefficients': ...
    def SetBorderMode(self, _arg:'vtkImageBorderMode') -> None: ...
    def SetBorderModeToClamp(self) -> None: ...
    def SetBorderModeToMirror(self) -> None: ...
    def SetBorderModeToRepeat(self) -> None: ...
    def SetBypass(self, _arg:int) -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    def SetOutputScalarTypeToDouble(self) -> None: ...
    def SetOutputScalarTypeToFloat(self) -> None: ...
    def SetSplineDegree(self, _arg:int) -> None: ...

class vtkImageBSplineInternals(object):
    @staticmethod
    def ConvertToInterpolationCoefficients(data:MutableSequence[float], size:int, border:'vtkImageBorderMode', poles:MutableSequence[float], numPoles:int, tol:float) -> None: ...
    @staticmethod
    def GetInterpolationWeights(weights:MutableSequence[float], w:float, degree:int) -> int: ...
    @staticmethod
    def GetPoleValues(poles:MutableSequence[float], numPoles:int, degree:int) -> int: ...
    @staticmethod
    def InterpolatedValue(coeffs:Sequence[float], value:MutableSequence[float], width:int, height:int, slices:int, depth:int, x:float, y:float, z:float, degree:int, border:'vtkImageBorderMode') -> int: ...

class vtkImageBSplineInterpolator(vtkAbstractImageInterpolator):
    spline_degree:'getset_descriptor'
    def ComputeSupportSize(self, matrix:Sequence[float], size:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSplineDegree(self) -> int: ...
    def GetSplineDegreeMaxValue(self) -> int: ...
    def GetSplineDegreeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsSeparable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageBSplineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageBSplineInterpolator': ...
    def SetSplineDegree(self, degree:int) -> None: ...

class vtkImageBlend(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    blend_alpha:'getset_descriptor'
    blend_mode:'getset_descriptor'
    compound_alpha:'getset_descriptor'
    compound_threshold:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    stencil:'getset_descriptor'
    stencil_connection:'getset_descriptor'
    stencil_data:'getset_descriptor'
    def BlendAlphaOff(self) -> None: ...
    def BlendAlphaOn(self) -> None: ...
    def CompoundAlphaOff(self) -> None: ...
    def CompoundAlphaOn(self) -> None: ...
    def GetBlendAlpha(self) -> int: ...
    def GetBlendMode(self) -> int: ...
    def GetBlendModeAsString(self) -> str: ...
    def GetBlendModeMaxValue(self) -> int: ...
    def GetBlendModeMinValue(self) -> int: ...
    def GetCompoundAlpha(self) -> int: ...
    def GetCompoundThreshold(self) -> float: ...
    @overload
    def GetInput(self, num:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputs(self) -> int: ...
    def GetOpacity(self, idx:int) -> float: ...
    def GetStencil(self) -> 'vtkImageStencilData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageBlend': ...
    def ReplaceNthInputConnection(self, idx:int, input:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageBlend': ...
    def SetBlendAlpha(self, _arg:int) -> None: ...
    def SetBlendMode(self, _arg:int) -> None: ...
    def SetBlendModeToCompound(self) -> None: ...
    def SetBlendModeToNormal(self) -> None: ...
    def SetCompoundAlpha(self, _arg:int) -> None: ...
    def SetCompoundThreshold(self, _arg:float) -> None: ...
    @overload
    def SetInputData(self, num:int, input:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, input:'vtkDataObject') -> None: ...
    def SetOpacity(self, idx:int, opacity:float) -> None: ...
    def SetStencilConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetStencilData(self, stencil:'vtkImageStencilData') -> None: ...

class vtkImageCacheFilter(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    cache_size:'getset_descriptor'
    def GetCacheSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageCacheFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageCacheFilter': ...
    def SetCacheSize(self, size:int) -> None: ...

class vtkImageCast(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    clamp_overflow:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    def ClampOverflowOff(self) -> None: ...
    def ClampOverflowOn(self) -> None: ...
    def GetClampOverflow(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputScalarType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageCast': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageCast': ...
    def SetClampOverflow(self, _arg:int) -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    def SetOutputScalarTypeToChar(self) -> None: ...
    def SetOutputScalarTypeToDouble(self) -> None: ...
    def SetOutputScalarTypeToFloat(self) -> None: ...
    def SetOutputScalarTypeToInt(self) -> None: ...
    def SetOutputScalarTypeToLong(self) -> None: ...
    def SetOutputScalarTypeToShort(self) -> None: ...
    def SetOutputScalarTypeToUnsignedChar(self) -> None: ...
    def SetOutputScalarTypeToUnsignedInt(self) -> None: ...
    def SetOutputScalarTypeToUnsignedLong(self) -> None: ...
    def SetOutputScalarTypeToUnsignedShort(self) -> None: ...

class vtkImageChangeInformation(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    center_image:'getset_descriptor'
    extent_translation:'getset_descriptor'
    information_input:'getset_descriptor'
    information_input_data:'getset_descriptor'
    origin_scale:'getset_descriptor'
    origin_translation:'getset_descriptor'
    output_direction:'getset_descriptor'
    output_extent_start:'getset_descriptor'
    output_origin:'getset_descriptor'
    output_spacing:'getset_descriptor'
    spacing_scale:'getset_descriptor'
    def CenterImageOff(self) -> None: ...
    def CenterImageOn(self) -> None: ...
    def GetCenterImage(self) -> int: ...
    def GetExtentTranslation(self) -> Tuple[int, int, int]: ...
    def GetInformationInput(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginScale(self) -> Tuple[float, float, float]: ...
    def GetOriginTranslation(self) -> Tuple[float, float, float]: ...
    def GetOutputDirection(self) -> Tuple[float, float, float, float, float, float, float, float, float]: ...
    def GetOutputExtentStart(self) -> Tuple[int, int, int]: ...
    def GetOutputOrigin(self) -> Tuple[float, float, float]: ...
    def GetOutputSpacing(self) -> Tuple[float, float, float]: ...
    def GetSpacingScale(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageChangeInformation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageChangeInformation': ...
    def SetCenterImage(self, _arg:int) -> None: ...
    @overload
    def SetExtentTranslation(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetExtentTranslation(self, _arg:Sequence[int]) -> None: ...
    def SetInformationInputData(self, __a:'vtkImageData') -> None: ...
    @overload
    def SetOriginScale(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOriginScale(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOriginTranslation(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOriginTranslation(self, _arg:Sequence[float]) -> None: ...
    def SetOutputDirection(self, data:Sequence[float]) -> None: ...
    @overload
    def SetOutputExtentStart(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetOutputExtentStart(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetOutputOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutputOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOutputSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutputSpacing(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSpacingScale(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpacingScale(self, _arg:Sequence[float]) -> None: ...

class vtkImageClip(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    clip_data:'getset_descriptor'
    output_whole_extent:'getset_descriptor'
    def ClipDataOff(self) -> None: ...
    def ClipDataOn(self) -> None: ...
    def GetClipData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutputWholeExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetOutputWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageClip': ...
    def ResetOutputWholeExtent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageClip': ...
    def SetClipData(self, _arg:int) -> None: ...
    @overload
    def SetOutputWholeExtent(self, extent:MutableSequence[int], outInfo:'vtkInformation'=...) -> None: ...
    @overload
    def SetOutputWholeExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...

class vtkImagePadFilter(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    output_number_of_scalar_components:'getset_descriptor'
    output_whole_extent:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputNumberOfScalarComponents(self) -> int: ...
    @overload
    def GetOutputWholeExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetOutputWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImagePadFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImagePadFilter': ...
    def SetOutputNumberOfScalarComponents(self, _arg:int) -> None: ...
    @overload
    def SetOutputWholeExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def SetOutputWholeExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...

class vtkImageConstantPad(vtkImagePadFilter):
    constant:'getset_descriptor'
    def GetConstant(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageConstantPad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageConstantPad': ...
    def SetConstant(self, _arg:float) -> None: ...

class vtkImageDataStreamer(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    extent_translator:'getset_descriptor'
    number_of_stream_divisions:'getset_descriptor'
    def GetExtentTranslator(self) -> 'vtkExtentTranslator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfStreamDivisions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataStreamer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataStreamer': ...
    def SetExtentTranslator(self, __a:'vtkExtentTranslator') -> None: ...
    def SetNumberOfStreamDivisions(self, _arg:int) -> None: ...

class vtkImageIterateFilter(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    iteration:'getset_descriptor'
    def GetIteration(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageIterateFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageIterateFilter': ...

class vtkImageDecomposeFilter(vtkImageIterateFilter):
    dimensionality:'getset_descriptor'
    def GetDimensionality(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDecomposeFilter': ...
    def PermuteExtent(self, extent:MutableSequence[int], min0:int, max0:int, min1:int, max1:int, min2:int, max2:int) -> None: ...
    def PermuteIncrements(self, increments:MutableSequence[int], inc0:int, inc1:int, inc2:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDecomposeFilter': ...
    def SetDimensionality(self, dim:int) -> None: ...

class vtkImageDifference(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    allow_shift:'getset_descriptor'
    average_threshold_factor:'getset_descriptor'
    averaging:'getset_descriptor'
    error:'getset_descriptor'
    image:'getset_descriptor'
    image_connection:'getset_descriptor'
    image_data:'getset_descriptor'
    threshold:'getset_descriptor'
    thresholded_error:'getset_descriptor'
    def AllowShiftOff(self) -> None: ...
    def AllowShiftOn(self) -> None: ...
    def AveragingOff(self) -> None: ...
    def AveragingOn(self) -> None: ...
    def GetAllowShift(self) -> bool: ...
    def GetAverageThresholdFactor(self) -> float: ...
    def GetAveraging(self) -> bool: ...
    @overload
    def GetError(self) -> float: ...
    @overload
    def GetError(self, e:MutableSequence[float]) -> None: ...
    def GetImage(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetThreshold(self) -> int: ...
    @overload
    def GetThresholdedError(self) -> float: ...
    @overload
    def GetThresholdedError(self, e:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDifference': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDifference': ...
    def SetAllowShift(self, _arg:bool) -> None: ...
    def SetAverageThresholdFactor(self, _arg:float) -> None: ...
    def SetAveraging(self, _arg:bool) -> None: ...
    def SetImageConnection(self, output:'vtkAlgorithmOutput') -> None: ...
    def SetImageData(self, image:'vtkDataObject') -> None: ...
    def SetThreshold(self, _arg:int) -> None: ...

class vtkImageExtractComponents(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    components:'getset_descriptor'
    number_of_components:'getset_descriptor'
    def GetComponents(self) -> Tuple[int, int, int]: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageExtractComponents': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageExtractComponents': ...
    @overload
    def SetComponents(self, c1:int) -> None: ...
    @overload
    def SetComponents(self, c1:int, c2:int) -> None: ...
    @overload
    def SetComponents(self, c1:int, c2:int, c3:int) -> None: ...

class vtkImageReslice(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    auto_crop_output:'getset_descriptor'
    background_color:'getset_descriptor'
    background_level:'getset_descriptor'
    border:'getset_descriptor'
    border_thickness:'getset_descriptor'
    generate_stencil_output:'getset_descriptor'
    information_input:'getset_descriptor'
    interpolate:'getset_descriptor'
    interpolation_mode:'getset_descriptor'
    interpolator:'getset_descriptor'
    m_time:'getset_descriptor'
    mirror:'getset_descriptor'
    optimization:'getset_descriptor'
    output_dimensionality:'getset_descriptor'
    output_direction:'getset_descriptor'
    output_extent:'getset_descriptor'
    output_origin:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    output_spacing:'getset_descriptor'
    reslice_axes:'getset_descriptor'
    reslice_axes_direction_cosines:'getset_descriptor'
    reslice_axes_origin:'getset_descriptor'
    reslice_transform:'getset_descriptor'
    scalar_scale:'getset_descriptor'
    scalar_shift:'getset_descriptor'
    slab_mode:'getset_descriptor'
    slab_number_of_slices:'getset_descriptor'
    slab_slice_spacing_fraction:'getset_descriptor'
    slab_trapezoid_integration:'getset_descriptor'
    stencil:'getset_descriptor'
    stencil_data:'getset_descriptor'
    stencil_output:'getset_descriptor'
    stencil_output_port:'getset_descriptor'
    transform_input_sampling:'getset_descriptor'
    wrap:'getset_descriptor'
    def AutoCropOutputOff(self) -> None: ...
    def AutoCropOutputOn(self) -> None: ...
    def BorderOff(self) -> None: ...
    def BorderOn(self) -> None: ...
    def GenerateStencilOutputOff(self) -> None: ...
    def GenerateStencilOutputOn(self) -> None: ...
    def GetAutoCropOutput(self) -> int: ...
    def GetBackgroundColor(self) -> Tuple[float, float, float, float]: ...
    def GetBackgroundLevel(self) -> float: ...
    def GetBorder(self) -> int: ...
    def GetBorderThickness(self) -> float: ...
    def GetGenerateStencilOutput(self) -> int: ...
    def GetInformationInput(self) -> 'vtkImageData': ...
    def GetInterpolate(self) -> int: ...
    def GetInterpolationMode(self) -> int: ...
    def GetInterpolationModeAsString(self) -> str: ...
    def GetInterpolationModeMaxValue(self) -> int: ...
    def GetInterpolationModeMinValue(self) -> int: ...
    def GetInterpolator(self) -> 'vtkAbstractImageInterpolator': ...
    def GetMTime(self) -> int: ...
    def GetMirror(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOptimization(self) -> int: ...
    def GetOutputDimensionality(self) -> int: ...
    def GetOutputDirection(self) -> Tuple[float, float, float]: ...
    def GetOutputExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetOutputOrigin(self) -> Tuple[float, float, float]: ...
    def GetOutputScalarType(self) -> int: ...
    def GetOutputSpacing(self) -> Tuple[float, float, float]: ...
    def GetResliceAxes(self) -> 'vtkMatrix4x4': ...
    @overload
    def GetResliceAxesDirectionCosines(self, x:MutableSequence[float], y:MutableSequence[float], z:MutableSequence[float]) -> None: ...
    @overload
    def GetResliceAxesDirectionCosines(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetResliceAxesDirectionCosines(self) -> Tuple[float, float, float, float, float, float, float, float, float]: ...
    @overload
    def GetResliceAxesOrigin(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetResliceAxesOrigin(self) -> Tuple[float, float, float]: ...
    def GetResliceTransform(self) -> 'vtkAbstractTransform': ...
    def GetScalarScale(self) -> float: ...
    def GetScalarShift(self) -> float: ...
    def GetSlabMode(self) -> int: ...
    def GetSlabModeAsString(self) -> str: ...
    def GetSlabModeMaxValue(self) -> int: ...
    def GetSlabModeMinValue(self) -> int: ...
    def GetSlabNumberOfSlices(self) -> int: ...
    def GetSlabSliceSpacingFraction(self) -> float: ...
    def GetSlabTrapezoidIntegration(self) -> int: ...
    def GetStencil(self) -> 'vtkImageStencilData': ...
    def GetStencilOutput(self) -> 'vtkImageStencilData': ...
    def GetStencilOutputPort(self) -> 'vtkAlgorithmOutput': ...
    def GetTransformInputSampling(self) -> int: ...
    def GetWrap(self) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MirrorOff(self) -> None: ...
    def MirrorOn(self) -> None: ...
    def NewInstance(self) -> 'vtkImageReslice': ...
    def OptimizationOff(self) -> None: ...
    def OptimizationOn(self) -> None: ...
    def ReportReferences(self, __a:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageReslice': ...
    def SetAutoCropOutput(self, _arg:int) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:Sequence[float]) -> None: ...
    def SetBackgroundLevel(self, v:float) -> None: ...
    def SetBorder(self, _arg:int) -> None: ...
    def SetBorderThickness(self, _arg:float) -> None: ...
    def SetGenerateStencilOutput(self, _arg:int) -> None: ...
    def SetInformationInput(self, __a:'vtkImageData') -> None: ...
    def SetInterpolate(self, t:int) -> None: ...
    def SetInterpolationMode(self, _arg:int) -> None: ...
    def SetInterpolationModeToCubic(self) -> None: ...
    def SetInterpolationModeToLinear(self) -> None: ...
    def SetInterpolationModeToNearestNeighbor(self) -> None: ...
    def SetInterpolator(self, sampler:'vtkAbstractImageInterpolator') -> None: ...
    def SetMirror(self, _arg:int) -> None: ...
    def SetOptimization(self, _arg:int) -> None: ...
    def SetOutputDimensionality(self, _arg:int) -> None: ...
    @overload
    def SetOutputDirection(self, xx:float, xy:float, xz:float, yx:float, yy:float, yz:float, zx:float, zy:float, zz:float) -> None: ...
    @overload
    def SetOutputDirection(self, a:Sequence[float]) -> None: ...
    def SetOutputDirectionToDefault(self) -> None: ...
    @overload
    def SetOutputExtent(self, a:int, b:int, c:int, d:int, e:int, f:int) -> None: ...
    @overload
    def SetOutputExtent(self, a:Sequence[int]) -> None: ...
    def SetOutputExtentToDefault(self) -> None: ...
    @overload
    def SetOutputOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOutputOrigin(self, a:Sequence[float]) -> None: ...
    def SetOutputOriginToDefault(self) -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    @overload
    def SetOutputSpacing(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOutputSpacing(self, a:Sequence[float]) -> None: ...
    def SetOutputSpacingToDefault(self) -> None: ...
    def SetResliceAxes(self, __a:'vtkMatrix4x4') -> None: ...
    @overload
    def SetResliceAxesDirectionCosines(self, x0:float, x1:float, x2:float, y0:float, y1:float, y2:float, z0:float, z1:float, z2:float) -> None: ...
    @overload
    def SetResliceAxesDirectionCosines(self, x:Sequence[float], y:Sequence[float], z:Sequence[float]) -> None: ...
    @overload
    def SetResliceAxesDirectionCosines(self, xyz:Sequence[float]) -> None: ...
    @overload
    def SetResliceAxesOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetResliceAxesOrigin(self, xyz:Sequence[float]) -> None: ...
    def SetResliceTransform(self, __a:'vtkAbstractTransform') -> None: ...
    def SetScalarScale(self, _arg:float) -> None: ...
    def SetScalarShift(self, _arg:float) -> None: ...
    def SetSlabMode(self, _arg:int) -> None: ...
    def SetSlabModeToMax(self) -> None: ...
    def SetSlabModeToMean(self) -> None: ...
    def SetSlabModeToMin(self) -> None: ...
    def SetSlabModeToSum(self) -> None: ...
    def SetSlabNumberOfSlices(self, _arg:int) -> None: ...
    def SetSlabSliceSpacingFraction(self, _arg:float) -> None: ...
    def SetSlabTrapezoidIntegration(self, _arg:int) -> None: ...
    def SetStencilData(self, stencil:'vtkImageStencilData') -> None: ...
    def SetStencilOutput(self, stencil:'vtkImageStencilData') -> None: ...
    def SetTransformInputSampling(self, _arg:int) -> None: ...
    def SetWrap(self, _arg:int) -> None: ...
    def SlabTrapezoidIntegrationOff(self) -> None: ...
    def SlabTrapezoidIntegrationOn(self) -> None: ...
    def TransformInputSamplingOff(self) -> None: ...
    def TransformInputSamplingOn(self) -> None: ...
    def WrapOff(self) -> None: ...
    def WrapOn(self) -> None: ...

class vtkImageFlip(vtkImageReslice):
    filtered_axes:'getset_descriptor'
    filtered_axis:'getset_descriptor'
    flip_about_origin:'getset_descriptor'
    preserve_image_extent:'getset_descriptor'
    def FlipAboutOriginOff(self) -> None: ...
    def FlipAboutOriginOn(self) -> None: ...
    def GetFilteredAxes(self) -> int: ...
    def GetFilteredAxis(self) -> int: ...
    def GetFlipAboutOrigin(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPreserveImageExtent(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageFlip': ...
    def PreserveImageExtentOff(self) -> None: ...
    def PreserveImageExtentOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageFlip': ...
    def SetFilteredAxes(self, axis:int) -> None: ...
    def SetFilteredAxis(self, _arg:int) -> None: ...
    def SetFlipAboutOrigin(self, _arg:int) -> None: ...
    def SetPreserveImageExtent(self, _arg:int) -> None: ...

class vtkImageMagnify(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    interpolate:'getset_descriptor'
    magnification_factors:'getset_descriptor'
    def GetInterpolate(self) -> int: ...
    def GetMagnificationFactors(self) -> Tuple[int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMagnify': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMagnify': ...
    def SetInterpolate(self, _arg:int) -> None: ...
    @overload
    def SetMagnificationFactors(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetMagnificationFactors(self, _arg:Sequence[int]) -> None: ...

class vtkImageMapToColors(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    active_component:'getset_descriptor'
    lookup_table:'getset_descriptor'
    m_time:'getset_descriptor'
    na_n_color:'getset_descriptor'
    output_format:'getset_descriptor'
    pass_alpha_to_output:'getset_descriptor'
    def GetActiveComponent(self) -> int: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMTime(self) -> int: ...
    def GetNaNColor(self) -> Tuple[int, int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputFormat(self) -> int: ...
    def GetPassAlphaToOutput(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMapToColors': ...
    def PassAlphaToOutputOff(self) -> None: ...
    def PassAlphaToOutputOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMapToColors': ...
    def SetActiveComponent(self, _arg:int) -> None: ...
    def SetLookupTable(self, __a:'vtkScalarsToColors') -> None: ...
    @overload
    def SetNaNColor(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int) -> None: ...
    @overload
    def SetNaNColor(self, _arg:Sequence[int]) -> None: ...
    def SetOutputFormat(self, _arg:int) -> None: ...
    def SetOutputFormatToLuminance(self) -> None: ...
    def SetOutputFormatToLuminanceAlpha(self) -> None: ...
    def SetOutputFormatToRGB(self) -> None: ...
    def SetOutputFormatToRGBA(self) -> None: ...
    def SetPassAlphaToOutput(self, _arg:int) -> None: ...

class vtkImageMask(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    image_input_data:'getset_descriptor'
    input1_data:'getset_descriptor'
    input2_data:'getset_descriptor'
    mask_alpha:'getset_descriptor'
    mask_input_data:'getset_descriptor'
    masked_output_value:'getset_descriptor'
    masked_output_value_length:'getset_descriptor'
    not_mask:'getset_descriptor'
    def GetMaskAlpha(self) -> float: ...
    def GetMaskAlphaMaxValue(self) -> float: ...
    def GetMaskAlphaMinValue(self) -> float: ...
    def GetMaskedOutputValue(self) -> Pointer: ...
    def GetMaskedOutputValueLength(self) -> int: ...
    def GetNotMask(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMask': ...
    def NotMaskOff(self) -> None: ...
    def NotMaskOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMask': ...
    def SetImageInputData(self, in_:'vtkImageData') -> None: ...
    def SetInput1Data(self, in_:'vtkDataObject') -> None: ...
    def SetInput2Data(self, in_:'vtkDataObject') -> None: ...
    def SetMaskAlpha(self, _arg:float) -> None: ...
    def SetMaskInputData(self, in_:'vtkImageData') -> None: ...
    @overload
    def SetMaskedOutputValue(self, num:int, v:MutableSequence[float]) -> None: ...
    @overload
    def SetMaskedOutputValue(self, v:float) -> None: ...
    @overload
    def SetMaskedOutputValue(self, v1:float, v2:float) -> None: ...
    @overload
    def SetMaskedOutputValue(self, v1:float, v2:float, v3:float) -> None: ...
    def SetNotMask(self, _arg:int) -> None: ...

class vtkImageMirrorPad(vtkImagePadFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMirrorPad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMirrorPad': ...

class vtkImagePermute(vtkImageReslice):
    filtered_axes:'getset_descriptor'
    def GetFilteredAxes(self) -> Tuple[int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImagePermute': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImagePermute': ...
    @overload
    def SetFilteredAxes(self, x:int, y:int, z:int) -> None: ...
    @overload
    def SetFilteredAxes(self, xyz:Sequence[int]) -> None: ...

class vtkImagePointDataIterator(object):
    id:'getset_descriptor'
    index:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, image:'vtkImageData', extent:Sequence[int]=..., stencil:'vtkImageStencilData'=..., algorithm:'vtkAlgorithm'=..., threadId:int=0) -> None: ...
    @overload
    def __init__(self, __a:'vtkImagePointDataIterator') -> None: ...
    def GetId(self) -> int: ...
    @overload
    def GetIndex(self, result:MutableSequence[int]) -> None: ...
    @overload
    def GetIndex(self) -> Tuple[int, int, int]: ...
    @overload
    @staticmethod
    def GetVoidPointer(image:'vtkImageData', i:int=0, pixelIncrement:MutableSequence[int]=...) -> Pointer: ...
    @overload
    @staticmethod
    def GetVoidPointer(array:'vtkDataArray', i:int=0, pixelIncrement:MutableSequence[int]=...) -> Pointer: ...
    def Initialize(self, image:'vtkImageData', extent:Sequence[int]=..., stencil:'vtkImageStencilData'=..., algorithm:'vtkAlgorithm'=..., threadId:int=0) -> None: ...
    def IsAtEnd(self) -> bool: ...
    def IsInStencil(self) -> bool: ...
    def NextSpan(self) -> None: ...
    def SpanEndId(self) -> int: ...

class vtkImagePointIterator(vtkImagePointDataIterator):
    position:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, image:'vtkImageData', extent:Sequence[int]=..., stencil:'vtkImageStencilData'=..., algorithm:'vtkAlgorithm'=..., threadId:int=0) -> None: ...
    @overload
    def __init__(self, __a:'vtkImagePointIterator') -> None: ...
    @overload
    def GetPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPosition(self, x:MutableSequence[float]) -> None: ...
    def Initialize(self, image:'vtkImageData', extent:Sequence[int]=..., stencil:'vtkImageStencilData'=..., algorithm:'vtkAlgorithm'=..., threadId:int=0) -> None: ...
    def IsAtEnd(self) -> bool: ...
    def Next(self) -> None: ...
    def NextSpan(self) -> None: ...

class vtkImageProbeFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    interpolator:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    def GetInterpolator(self) -> 'vtkAbstractImageInterpolator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageProbeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageProbeFilter': ...
    def SetInterpolator(self, interpolator:'vtkAbstractImageInterpolator') -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...

class vtkImageResample(vtkImageReslice):
    dimensionality:'getset_descriptor'
    magnification_factors:'getset_descriptor'
    output_spacing:'getset_descriptor'
    def GetAxisMagnificationFactor(self, axis:int, inInfo:'vtkInformation'=...) -> float: ...
    def GetDimensionality(self) -> int: ...
    def GetMagnificationFactors(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageResample': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageResample': ...
    def SetAxisMagnificationFactor(self, axis:int, factor:float) -> None: ...
    def SetAxisOutputSpacing(self, axis:int, spacing:float) -> None: ...
    def SetDimensionality(self, _arg:int) -> None: ...
    @overload
    def SetMagnificationFactors(self, fx:float, fy:float, fz:float) -> None: ...
    @overload
    def SetMagnificationFactors(self, f:Sequence[float]) -> None: ...
    @overload
    def SetOutputSpacing(self, sx:float, sy:float, sz:float) -> None: ...
    @overload
    def SetOutputSpacing(self, spacing:Sequence[float]) -> None: ...

class vtkImageResize(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    MAGNIFICATION_FACTORS:int
    OUTPUT_DIMENSIONS:int
    OUTPUT_SPACING:int
    border:'getset_descriptor'
    cropping:'getset_descriptor'
    cropping_region:'getset_descriptor'
    interpolate:'getset_descriptor'
    interpolator:'getset_descriptor'
    m_time:'getset_descriptor'
    magnification_factors:'getset_descriptor'
    output_dimensions:'getset_descriptor'
    output_spacing:'getset_descriptor'
    resize_method:'getset_descriptor'
    def BorderOff(self) -> None: ...
    def BorderOn(self) -> None: ...
    def CroppingOff(self) -> None: ...
    def CroppingOn(self) -> None: ...
    def GetBorder(self) -> int: ...
    def GetCropping(self) -> int: ...
    def GetCroppingRegion(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetInterpolate(self) -> int: ...
    def GetInterpolator(self) -> 'vtkAbstractImageInterpolator': ...
    def GetMTime(self) -> int: ...
    def GetMagnificationFactors(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputDimensions(self) -> Tuple[int, int, int]: ...
    def GetOutputSpacing(self) -> Tuple[float, float, float]: ...
    def GetResizeMethod(self) -> int: ...
    def GetResizeMethodAsString(self) -> str: ...
    def GetResizeMethodMaxValue(self) -> int: ...
    def GetResizeMethodMinValue(self) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageResize': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageResize': ...
    def SetBorder(self, _arg:int) -> None: ...
    def SetCropping(self, _arg:int) -> None: ...
    @overload
    def SetCroppingRegion(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetCroppingRegion(self, _arg:Sequence[float]) -> None: ...
    def SetInterpolate(self, _arg:int) -> None: ...
    def SetInterpolator(self, sampler:'vtkAbstractImageInterpolator') -> None: ...
    @overload
    def SetMagnificationFactors(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetMagnificationFactors(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOutputDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetOutputDimensions(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetOutputSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutputSpacing(self, _arg:Sequence[float]) -> None: ...
    def SetResizeMethod(self, _arg:int) -> None: ...
    def SetResizeMethodToMagnificationFactors(self) -> None: ...
    def SetResizeMethodToOutputDimensions(self) -> None: ...
    def SetResizeMethodToOutputSpacing(self) -> None: ...

class vtkImageResliceToColors(vtkImageReslice):
    bypass:'getset_descriptor'
    lookup_table:'getset_descriptor'
    m_time:'getset_descriptor'
    output_format:'getset_descriptor'
    def BypassOff(self) -> None: ...
    def BypassOn(self) -> None: ...
    def GetBypass(self) -> int: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputFormat(self) -> int: ...
    def GetOutputFormatMaxValue(self) -> int: ...
    def GetOutputFormatMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageResliceToColors': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageResliceToColors': ...
    def SetBypass(self, bypass:int) -> None: ...
    def SetLookupTable(self, table:'vtkScalarsToColors') -> None: ...
    def SetOutputFormat(self, _arg:int) -> None: ...
    def SetOutputFormatToLuminance(self) -> None: ...
    def SetOutputFormatToLuminanceAlpha(self) -> None: ...
    def SetOutputFormatToRGB(self) -> None: ...
    def SetOutputFormatToRGBA(self) -> None: ...

class vtkImageSSIM(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    clamp_negative_values:'getset_descriptor'
    image_connection:'getset_descriptor'
    image_data:'getset_descriptor'
    input_range:'getset_descriptor'
    patch_radius:'getset_descriptor'
    def ClampNegativeValuesOff(self) -> None: ...
    def ClampNegativeValuesOn(self) -> None: ...
    @staticmethod
    def ComputeErrorMetrics(scalars:'vtkDoubleArray', tight:float, loose:float) -> None: ...
    def GetClampNegativeValues(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPatchRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageSSIM': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageSSIM': ...
    def SetClampNegativeValues(self, _arg:bool) -> None: ...
    def SetImageConnection(self, output:'vtkAlgorithmOutput') -> None: ...
    def SetImageData(self, image:'vtkDataObject') -> None: ...
    def SetInputRange(self, range:MutableSequence[int]) -> None: ...
    def SetInputToAuto(self) -> None: ...
    def SetInputToGrayscale(self) -> None: ...
    def SetInputToLab(self) -> None: ...
    def SetInputToRGB(self) -> None: ...
    def SetInputToRGBA(self) -> None: ...
    def SetPatchRadius(self, _arg:float) -> None: ...

class vtkImageShiftScale(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    clamp_overflow:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    scale:'getset_descriptor'
    shift:'getset_descriptor'
    def ClampOverflowOff(self) -> None: ...
    def ClampOverflowOn(self) -> None: ...
    def GetClampOverflow(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputScalarType(self) -> int: ...
    def GetScale(self) -> float: ...
    def GetShift(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageShiftScale': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageShiftScale': ...
    def SetClampOverflow(self, _arg:int) -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    def SetOutputScalarTypeToChar(self) -> None: ...
    def SetOutputScalarTypeToDouble(self) -> None: ...
    def SetOutputScalarTypeToFloat(self) -> None: ...
    def SetOutputScalarTypeToInt(self) -> None: ...
    def SetOutputScalarTypeToLong(self) -> None: ...
    def SetOutputScalarTypeToShort(self) -> None: ...
    def SetOutputScalarTypeToUnsignedChar(self) -> None: ...
    def SetOutputScalarTypeToUnsignedInt(self) -> None: ...
    def SetOutputScalarTypeToUnsignedLong(self) -> None: ...
    def SetOutputScalarTypeToUnsignedShort(self) -> None: ...
    def SetScale(self, _arg:float) -> None: ...
    def SetShift(self, _arg:float) -> None: ...

class vtkImageShrink3D(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    averaging:'getset_descriptor'
    maximum:'getset_descriptor'
    mean:'getset_descriptor'
    median:'getset_descriptor'
    minimum:'getset_descriptor'
    shift:'getset_descriptor'
    shrink_factors:'getset_descriptor'
    def AveragingOff(self) -> None: ...
    def AveragingOn(self) -> None: ...
    def GetAveraging(self) -> int: ...
    def GetMaximum(self) -> int: ...
    def GetMean(self) -> int: ...
    def GetMedian(self) -> int: ...
    def GetMinimum(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShift(self) -> Tuple[int, int, int]: ...
    def GetShrinkFactors(self) -> Tuple[int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MaximumOff(self) -> None: ...
    def MaximumOn(self) -> None: ...
    def MeanOff(self) -> None: ...
    def MeanOn(self) -> None: ...
    def MedianOff(self) -> None: ...
    def MedianOn(self) -> None: ...
    def MinimumOff(self) -> None: ...
    def MinimumOn(self) -> None: ...
    def NewInstance(self) -> 'vtkImageShrink3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageShrink3D': ...
    def SetAveraging(self, __a:int) -> None: ...
    def SetMaximum(self, __a:int) -> None: ...
    def SetMean(self, __a:int) -> None: ...
    def SetMedian(self, __a:int) -> None: ...
    def SetMinimum(self, __a:int) -> None: ...
    @overload
    def SetShift(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetShift(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetShrinkFactors(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetShrinkFactors(self, _arg:Sequence[int]) -> None: ...

class vtkImageSincInterpolator(vtkAbstractImageInterpolator):
    antialiasing:'getset_descriptor'
    blur_factors:'getset_descriptor'
    renormalization:'getset_descriptor'
    use_window_parameter:'getset_descriptor'
    window_function:'getset_descriptor'
    window_half_width:'getset_descriptor'
    window_parameter:'getset_descriptor'
    def AntialiasingOff(self) -> None: ...
    def AntialiasingOn(self) -> None: ...
    def ComputeSupportSize(self, matrix:Sequence[float], support:MutableSequence[int]) -> None: ...
    def GetAntialiasing(self) -> int: ...
    @overload
    def GetBlurFactors(self, f:MutableSequence[float]) -> None: ...
    @overload
    def GetBlurFactors(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenormalization(self) -> int: ...
    def GetUseWindowParameter(self) -> int: ...
    def GetWindowFunction(self) -> int: ...
    def GetWindowFunctionAsString(self) -> str: ...
    def GetWindowHalfWidth(self) -> int: ...
    def GetWindowParameter(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    def IsSeparable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageSincInterpolator': ...
    def RenormalizationOff(self) -> None: ...
    def RenormalizationOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageSincInterpolator': ...
    def SetAntialiasing(self, antialiasing:int) -> None: ...
    @overload
    def SetBlurFactors(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetBlurFactors(self, f:Sequence[float]) -> None: ...
    def SetRenormalization(self, renormalization:int) -> None: ...
    def SetUseWindowParameter(self, val:int) -> None: ...
    def SetWindowFunction(self, mode:int) -> None: ...
    def SetWindowFunctionToBlackman(self) -> None: ...
    def SetWindowFunctionToBlackmanHarris3(self) -> None: ...
    def SetWindowFunctionToBlackmanHarris4(self) -> None: ...
    def SetWindowFunctionToBlackmanNuttall3(self) -> None: ...
    def SetWindowFunctionToBlackmanNuttall4(self) -> None: ...
    def SetWindowFunctionToCosine(self) -> None: ...
    def SetWindowFunctionToHamming(self) -> None: ...
    def SetWindowFunctionToHann(self) -> None: ...
    def SetWindowFunctionToKaiser(self) -> None: ...
    def SetWindowFunctionToLanczos(self) -> None: ...
    def SetWindowFunctionToNuttall(self) -> None: ...
    def SetWindowHalfWidth(self, n:int) -> None: ...
    def SetWindowParameter(self, param:float) -> None: ...
    def UseWindowParameterOff(self) -> None: ...
    def UseWindowParameterOn(self) -> None: ...

class vtkImageStencilAlgorithm(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageStencilData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageStencilAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageStencilAlgorithm': ...
    def SetOutput(self, output:'vtkImageStencilData') -> None: ...

class vtkImageStencilData(vtkmodules.vtkCommonDataModel.vtkDataObject):
    data_object_type:'getset_descriptor'
    extent:'getset_descriptor'
    extent_type:'getset_descriptor'
    origin:'getset_descriptor'
    spacing:'getset_descriptor'
    def Add(self, __a:'vtkImageStencilData') -> None: ...
    def AllocateExtents(self) -> None: ...
    def Clip(self, extent:MutableSequence[int]) -> int: ...
    def CopyInformationFromPipeline(self, info:'vtkInformation') -> None: ...
    def CopyInformationToPipeline(self, info:'vtkInformation') -> None: ...
    def DeepCopy(self, o:'vtkDataObject') -> None: ...
    def Fill(self) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkImageStencilData': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkImageStencilData': ...
    def GetDataObjectType(self) -> int: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetExtentType(self) -> int: ...
    def GetNextExtent(self, r1:int, r2:int, xMin:int, xMax:int, yIdx:int, zIdx:int, iter:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetSpacing(self) -> Tuple[float, float, float]: ...
    def Initialize(self) -> None: ...
    def InsertAndMergeExtent(self, r1:int, r2:int, yIdx:int, zIdx:int) -> None: ...
    def InsertNextExtent(self, r1:int, r2:int, yIdx:int, zIdx:int) -> None: ...
    def InternalImageStencilDataCopy(self, s:'vtkImageStencilData') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, xIdx:int, yIdx:int, zIdx:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageStencilData': ...
    def RemoveExtent(self, r1:int, r2:int, yIdx:int, zIdx:int) -> None: ...
    def Replace(self, __a:'vtkImageStencilData') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageStencilData': ...
    @overload
    def SetExtent(self, extent:Sequence[int]) -> None: ...
    @overload
    def SetExtent(self, x1:int, x2:int, y1:int, y2:int, z1:int, z2:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpacing(self, _arg:Sequence[float]) -> None: ...
    def ShallowCopy(self, f:'vtkDataObject') -> None: ...
    def Subtract(self, __a:'vtkImageStencilData') -> None: ...

class vtkImageStencilRaster(object):
    tolerance:'getset_descriptor'
    def __init__(self, wholeExtent:Sequence[int]) -> None: ...
    def FillStencilData(self, data:'vtkImageStencilData', extent:Sequence[int], xj:int=0, yj:int=1) -> None: ...
    def GetTolerance(self) -> float: ...
    def InsertLine(self, pt1:Sequence[float], pt2:Sequence[float]) -> None: ...
    def PrepareForNewData(self, allocateExtent:Sequence[int]=...) -> None: ...
    def SetTolerance(self, tol:float) -> None: ...

class vtkImageStencilSource(vtkImageStencilAlgorithm):
    information_input:'getset_descriptor'
    output_origin:'getset_descriptor'
    output_spacing:'getset_descriptor'
    output_whole_extent:'getset_descriptor'
    def GetInformationInput(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputOrigin(self) -> Tuple[float, float, float]: ...
    def GetOutputSpacing(self) -> Tuple[float, float, float]: ...
    def GetOutputWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageStencilSource': ...
    def ReportReferences(self, __a:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageStencilSource': ...
    def SetInformationInput(self, __a:'vtkImageData') -> None: ...
    @overload
    def SetOutputOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutputOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOutputSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutputSpacing(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOutputWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetOutputWholeExtent(self, _arg:Sequence[int]) -> None: ...

class vtkImageThreshold(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    in_value:'getset_descriptor'
    lower_threshold:'getset_descriptor'
    out_value:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    replace_in:'getset_descriptor'
    replace_out:'getset_descriptor'
    upper_threshold:'getset_descriptor'
    def GetInValue(self) -> float: ...
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutValue(self) -> float: ...
    def GetOutputScalarType(self) -> int: ...
    def GetReplaceIn(self) -> int: ...
    def GetReplaceOut(self) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageThreshold': ...
    def ReplaceInOff(self) -> None: ...
    def ReplaceInOn(self) -> None: ...
    def ReplaceOutOff(self) -> None: ...
    def ReplaceOutOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageThreshold': ...
    def SetInValue(self, val:float) -> None: ...
    def SetOutValue(self, val:float) -> None: ...
    def SetOutputScalarType(self, _arg:int) -> None: ...
    def SetOutputScalarTypeToChar(self) -> None: ...
    def SetOutputScalarTypeToDouble(self) -> None: ...
    def SetOutputScalarTypeToFloat(self) -> None: ...
    def SetOutputScalarTypeToInt(self) -> None: ...
    def SetOutputScalarTypeToLong(self) -> None: ...
    def SetOutputScalarTypeToShort(self) -> None: ...
    def SetOutputScalarTypeToSignedChar(self) -> None: ...
    def SetOutputScalarTypeToUnsignedChar(self) -> None: ...
    def SetOutputScalarTypeToUnsignedInt(self) -> None: ...
    def SetOutputScalarTypeToUnsignedLong(self) -> None: ...
    def SetOutputScalarTypeToUnsignedShort(self) -> None: ...
    def SetReplaceIn(self, _arg:int) -> None: ...
    def SetReplaceOut(self, _arg:int) -> None: ...
    def ThresholdBetween(self, lower:float, upper:float) -> None: ...
    def ThresholdByLower(self, thresh:float) -> None: ...
    def ThresholdByUpper(self, thresh:float) -> None: ...

class vtkImageTranslateExtent(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    translation:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTranslation(self) -> Tuple[int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageTranslateExtent': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageTranslateExtent': ...
    @overload
    def SetTranslation(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetTranslation(self, _arg:Sequence[int]) -> None: ...

class vtkImageWrapPad(vtkImagePadFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageWrapPad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageWrapPad': ...

class vtkRTAnalyticSource(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    center:'getset_descriptor'
    maximum:'getset_descriptor'
    standard_deviation:'getset_descriptor'
    subsample_rate:'getset_descriptor'
    whole_extent:'getset_descriptor'
    x_freq:'getset_descriptor'
    x_mag:'getset_descriptor'
    y_freq:'getset_descriptor'
    y_mag:'getset_descriptor'
    z_freq:'getset_descriptor'
    z_mag:'getset_descriptor'
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetMaximum(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStandardDeviation(self) -> float: ...
    def GetSubsampleRate(self) -> int: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetXFreq(self) -> float: ...
    def GetXMag(self) -> float: ...
    def GetYFreq(self) -> float: ...
    def GetYMag(self) -> float: ...
    def GetZFreq(self) -> float: ...
    def GetZMag(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRTAnalyticSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRTAnalyticSource': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetMaximum(self, _arg:float) -> None: ...
    def SetStandardDeviation(self, _arg:float) -> None: ...
    def SetSubsampleRate(self, _arg:int) -> None: ...
    def SetWholeExtent(self, xMinx:int, xMax:int, yMin:int, yMax:int, zMin:int, zMax:int) -> None: ...
    def SetXFreq(self, _arg:float) -> None: ...
    def SetXMag(self, _arg:float) -> None: ...
    def SetYFreq(self, _arg:float) -> None: ...
    def SetYMag(self, _arg:float) -> None: ...
    def SetZFreq(self, _arg:float) -> None: ...
    def SetZMag(self, _arg:float) -> None: ...

