from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore

class vtkObjectManager(vtkmodules.vtkCommonCore.vtkObject):
    deserializer:'getset_descriptor'
    serializer:'getset_descriptor'
    total_blob_memory_usage:'getset_descriptor'
    total_vtk_data_object_memory_usage:'getset_descriptor'
    def Clear(self) -> None: ...
    def Export(self, filename:str, indentLevel:int=-1, indentChar:str=...) -> None: ...
    def GetAllDependencies(self, identifier:int) -> Tuple[int, int]: ...
    def GetBlob(self, hash:str) -> 'vtkTypeUInt8Array': ...
    def GetBlobHashes(self, ids:Sequence[int]) -> Tuple[str, str]: ...
    def GetDeserializer(self) -> 'vtkDeserializer': ...
    def GetId(self, objectBase:'vtkObjectBase') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetObjectAtId(self, id:int) -> 'vtkObjectBase': ...
    def GetSerializer(self) -> 'vtkSerializer': ...
    def GetState(self, id:int) -> str: ...
    def GetTotalBlobMemoryUsage(self) -> int: ...
    def GetTotalVTKDataObjectMemoryUsage(self) -> int: ...
    def Import(self, stateFileName:str, blobFileName:str) -> None: ...
    def Initialize(self) -> bool: ...
    def InitializeDefaultHandlers(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkObjectManager': ...
    def PruneUnusedBlobs(self) -> None: ...
    @staticmethod
    def ROOT() -> int: ...
    def RegisterBlob(self, hash:str, blob:'vtkTypeUInt8Array') -> bool: ...
    def RegisterObject(self, objectBase:'vtkObjectBase') -> int: ...
    def RegisterState(self, state:str) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkObjectManager': ...
    def UnRegisterBlob(self, hash:str) -> bool: ...
    def UnRegisterObject(self, identifier:int) -> bool: ...
    def UnRegisterState(self, identifier:int) -> bool: ...
    def UpdateObjectFromState(self, state:str) -> None: ...
    def UpdateObjectsFromStates(self) -> None: ...
    def UpdateStateFromObject(self, identifier:int) -> None: ...
    def UpdateStatesFromObjects(self) -> None: ...

