#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Feb  6 12:07:05 2017 by generateDS.py version 2.24b.
#
# Command line options:
#   ('-o', 'spl.py')
#
# Command line arguments:
#   ../SchemasR2b/SPL.xsd
#
# Command line:
#   generateDS.py -o "spl.py" ../SchemasR2b/SPL.xsd
#
# Current working directory (os.getcwd()):
#   dkuhlman-generateds-8f298b77b9d3
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value

def get_all_values(iter):
    return [r.value for r in iter]


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name, pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class PORP_MT050032UV_Author(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='AUT', contextControlCode='OP', realmCode=None, typeId=None, templateId=None, noteText=None, time=None, signatureCode=None, signatureText=None, assignedEntity=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        self.contextControlCode = _cast(None, contextControlCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.noteText = noteText
        self.time = time
        self.signatureCode = signatureCode
        self.signatureText = signatureText
        self.assignedEntity = assignedEntity
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Author)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Author.subclass:
            return PORP_MT050032UV_Author.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Author(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_noteText(self): return self.noteText
    def set_noteText(self, noteText): self.noteText = noteText
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def get_signatureCode(self): return self.signatureCode
    def set_signatureCode(self, signatureCode): self.signatureCode = signatureCode
    def get_signatureText(self): return self.signatureText
    def set_signatureText(self, signatureText): self.signatureText = signatureText
    def get_assignedEntity(self): return self.assignedEntity
    def set_assignedEntity(self, assignedEntity): self.assignedEntity = assignedEntity
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def get_contextControlCode(self): return self.contextControlCode
    def set_contextControlCode(self, contextControlCode): self.contextControlCode = contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ParticipationAuthorOriginator(self, value):
        # Validate type ParticipationAuthorOriginator, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['AUT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ParticipationAuthorOriginator' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationAuthorOriginator_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ParticipationAuthorOriginator_patterns_, ))
    validate_ParticipationAuthorOriginator_patterns_ = [['^[^\\s]+$']]
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['AN', 'AP', 'ON', 'OP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ContextControl' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ContextControl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ContextControl_patterns_, ))
    validate_ContextControl_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.noteText is not None or
            self.time is not None or
            self.signatureCode is not None or
            self.signatureText is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Author', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Author')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Author', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Author'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "AUT" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode != "OP" and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Author', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.noteText is not None:
            self.noteText.export(outfile, level, namespace_, name_='noteText', pretty_print=pretty_print)
        if self.time is not None:
            self.time.export(outfile, level, namespace_, name_='time', pretty_print=pretty_print)
        if self.signatureCode is not None:
            self.signatureCode.export(outfile, level, namespace_, name_='signatureCode', pretty_print=pretty_print)
        if self.signatureText is not None:
            self.signatureText.export(outfile, level, namespace_, name_='signatureText', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            self.assignedEntity.export(outfile, level, namespace_, name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ParticipationAuthorOriginator(self.typeCode)    # validate type ParticipationAuthorOriginator
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'noteText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.noteText = obj_
            obj_.original_tagname_ = 'noteText'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'signatureCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.signatureCode = obj_
            obj_.original_tagname_ = 'signatureCode'
        elif nodeName_ == 'signatureText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.signatureText = obj_
            obj_.original_tagname_ = 'signatureText'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCP_MT030100UV_AssignedEntity2.factory()
            obj_.build(child_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class PORP_MT050032UV_Author


class PORP_MT050032UV_Comment(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='ACT', moodCode='EVN', realmCode=None, typeId=None, templateId=None, text=None, statusCode=None, effectiveTime=None, author=None, subject=None, sequel=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.text = text
        self.statusCode = statusCode
        self.effectiveTime = effectiveTime
        if author is None:
            self.author = []
        else:
            self.author = author
        if subject is None:
            self.subject = []
        else:
            self.subject = subject
        if sequel is None:
            self.sequel = []
        else:
            self.sequel = sequel
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Comment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Comment.subclass:
            return PORP_MT050032UV_Comment.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Comment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_statusCode(self): return self.statusCode
    def set_statusCode(self, statusCode): self.statusCode = statusCode
    def get_effectiveTime(self): return self.effectiveTime
    def set_effectiveTime(self, effectiveTime): self.effectiveTime = effectiveTime
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def get_subject(self): return self.subject
    def set_subject(self, subject): self.subject = subject
    def add_subject(self, value): self.subject.append(value)
    def insert_subject_at(self, index, value): self.subject.insert(index, value)
    def replace_subject_at(self, index, value): self.subject[index] = value
    def get_sequel(self): return self.sequel
    def set_sequel(self, sequel): self.sequel = sequel
    def add_sequel(self, value): self.sequel.append(value)
    def insert_sequel_at(self, index, value): self.sequel.insert(index, value)
    def replace_sequel_at(self, index, value): self.sequel[index] = value
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassRoot(self, value):
        # Validate type ActClassRoot, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ACT', 'COMPOSITION', 'DOC', 'DOCCLIN', 'CDALVLONE', 'CONTAINER', 'CATEGORY', 'DOCBODY', 'DOCSECT', 'TOPIC', 'EXTRACT', 'EHR', 'FOLDER', 'GROUPER', 'CLUSTER', 'ACCM', 'ACCT', 'ACSN', 'ADJUD', 'CACT', 'ACTN', 'INFO', 'STC', 'CNTRCT', 'FCNTRCT', 'COV', 'CONC', 'HCASE', 'OUTBR', 'CONS', 'CONTREG', 'CTTEVENT', 'DISPACT', 'EXPOS', 'AEXPOS', 'TEXPOS', 'INC', 'INFRM', 'INVE', 'LIST', 'MPROT', 'OBS', 'ROIBND', 'ROIOVL', 'LLD', 'PRN', 'RLD', 'SFWL', 'SIT', 'STN', 'SUP', 'RTRD', 'TRD', 'ALRT', 'BATTERY', 'CLNTRL', 'CNOD', 'COND', 'CASE', 'OUTB', 'DGIMG', 'GEN', 'DETPOL', 'EXP', 'LOC', 'PHN', 'POL', 'SEQ', 'SEQVAR', 'INVSTG', 'OBSSER', 'OBSCOR', 'POS', 'POSACC', 'POSCOORD', 'SPCOBS', 'VERIF', 'PCPR', 'ENC', 'POLICY', 'JURISPOL', 'ORGPOL', 'SCOPOL', 'STDPOL', 'PROC', 'SBADM', 'SBEXT', 'SPECCOLLECT', 'REG', 'REV', 'SPCTRT', 'SPLY', 'DIET', 'STORE', 'SUBST', 'TRFR', 'TRNS', 'XACT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassRoot' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassRoot_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassRoot_patterns_, ))
    validate_ActClassRoot_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.author or
            self.subject or
            self.sequel
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Comment', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Comment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Comment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Comment'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ACT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Comment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.text is not None:
            self.text.export(outfile, level, namespace_, name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            self.statusCode.export(outfile, level, namespace_, name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            self.effectiveTime.export(outfile, level, namespace_, name_='effectiveTime', pretty_print=pretty_print)
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
        for subject_ in self.subject:
            subject_.export(outfile, level, namespace_, name_='subject', pretty_print=pretty_print)
        for sequel_ in self.sequel:
            sequel_.export(outfile, level, namespace_, name_='sequel', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassRoot(self.classCode)    # validate type ActClassRoot
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'text':
            obj_ = StrucDoc_Text.factory()
            obj_.build(child_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory()
            obj_.build(child_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'author':
            obj_ = PORP_MT050032UV_Author.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'subject':
            obj_ = PORP_MT050032UV_Subject2.factory()
            obj_.build(child_)
            self.subject.append(obj_)
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'sequel':
            obj_ = PORP_MT050032UV_SequelTo.factory()
            obj_.build(child_)
            self.sequel.append(obj_)
            obj_.original_tagname_ = 'sequel'
# end class PORP_MT050032UV_Comment


class PORP_MT050032UV_Component1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='COMP', contextConductionInd='true', realmCode=None, typeId=None, templateId=None, section=None, observationMedia=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        self.contextConductionInd = _cast(None, contextConductionInd)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.section = section
        self.observationMedia = observationMedia
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Component1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Component1.subclass:
            return PORP_MT050032UV_Component1.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Component1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_section(self): return self.section
    def set_section(self, section): self.section = section
    def get_observationMedia(self): return self.observationMedia
    def set_observationMedia(self, observationMedia): self.observationMedia = observationMedia
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def get_contextConductionInd(self): return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd): self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['COMP', 'CTRLV', 'MBR', 'STEP', 'ARR', 'DEP', 'PART']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^[^\\s]+$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.section is not None or
            self.observationMedia is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Component1', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Component1')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Component1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Component1'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd=%s' % (quote_attrib(self.contextConductionInd), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Component1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.section is not None:
            self.section.export(outfile, level, namespace_, name_='section', pretty_print=pretty_print)
        if self.observationMedia is not None:
            self.observationMedia.export(outfile, level, namespace_, name_='observationMedia', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'section':
            obj_ = PORP_MT050032UV_Section.factory()
            obj_.build(child_)
            self.section = obj_
            obj_.original_tagname_ = 'section'
        elif nodeName_ == 'observationMedia':
            obj_ = PORP_MT050032UV_ObservationMedia.factory()
            obj_.build(child_)
            self.observationMedia = obj_
            obj_.original_tagname_ = 'observationMedia'
# end class PORP_MT050032UV_Component1


class PORP_MT050032UV_Component2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='COMP', contextConductionInd='true', realmCode=None, typeId=None, templateId=None, section=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        self.contextConductionInd = _cast(None, contextConductionInd)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.section = section
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Component2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Component2.subclass:
            return PORP_MT050032UV_Component2.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Component2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_section(self): return self.section
    def set_section(self, section): self.section = section
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def get_contextConductionInd(self): return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd): self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['COMP', 'CTRLV', 'MBR', 'STEP', 'ARR', 'DEP', 'PART']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^[^\\s]+$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.section is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Component2', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Component2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Component2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Component2'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd=%s' % (quote_attrib(self.contextConductionInd), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Component2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.section is not None:
            self.section.export(outfile, level, namespace_, name_='section', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'section':
            obj_ = PORP_MT050032UV_Section.factory()
            obj_.build(child_)
            self.section = obj_
            obj_.original_tagname_ = 'section'
# end class PORP_MT050032UV_Component2


class PORP_MT050032UV_Component3(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='COMP', contextConductionInd='true', realmCode=None, typeId=None, templateId=None, nonXMLBody=None, structuredBody=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        self.contextConductionInd = _cast(None, contextConductionInd)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.nonXMLBody = nonXMLBody
        self.structuredBody = structuredBody
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Component3)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Component3.subclass:
            return PORP_MT050032UV_Component3.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Component3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_nonXMLBody(self): return self.nonXMLBody
    def set_nonXMLBody(self, nonXMLBody): self.nonXMLBody = nonXMLBody
    def get_structuredBody(self): return self.structuredBody
    def set_structuredBody(self, structuredBody): self.structuredBody = structuredBody
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def get_contextConductionInd(self): return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd): self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['COMP', 'CTRLV', 'MBR', 'STEP', 'ARR', 'DEP', 'PART']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^[^\\s]+$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.nonXMLBody is not None or
            self.structuredBody is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Component3', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Component3')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Component3', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Component3'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd=%s' % (quote_attrib(self.contextConductionInd), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Component3', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.nonXMLBody is not None:
            self.nonXMLBody.export(outfile, level, namespace_, name_='nonXMLBody', pretty_print=pretty_print)
        if self.structuredBody is not None:
            self.structuredBody.export(outfile, level, namespace_, name_='structuredBody', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'nonXMLBody':
            obj_ = PORP_MT050032UV_NonXMLBody.factory()
            obj_.build(child_)
            self.nonXMLBody = obj_
            obj_.original_tagname_ = 'nonXMLBody'
        elif nodeName_ == 'structuredBody':
            obj_ = PORP_MT050032UV_StructuredBody.factory()
            obj_.build(child_)
            self.structuredBody = obj_
            obj_.original_tagname_ = 'structuredBody'
# end class PORP_MT050032UV_Component3


class PORP_MT050032UV_Document(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, classCode='DOC', moodCode='EVN', realmCode=None, typeId=None, templateId=None, id=None, code=None, title=None, effectiveTime=None, availabilityTime=None, confidentialityCode=None, languageCode=None, setId=None, versionNumber=None, author=None, verifier=None, legalAuthenticator=None, relatedDocument=None, component=None):
        self.original_tagname_ = None
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.id = id
        self.code = code
        self.title = title
        self.effectiveTime = effectiveTime
        self.availabilityTime = availabilityTime
        self.confidentialityCode = confidentialityCode
        self.languageCode = languageCode
        self.setId = setId
        self.versionNumber = versionNumber
        if author is None:
            self.author = []
        else:
            self.author = author
        if verifier is None:
            self.verifier = []
        else:
            self.verifier = verifier
        if legalAuthenticator is None:
            self.legalAuthenticator = []
        else:
            self.legalAuthenticator = legalAuthenticator
        if relatedDocument is None:
            self.relatedDocument = []
        else:
            self.relatedDocument = relatedDocument
        self.component = component
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Document)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Document.subclass:
            return PORP_MT050032UV_Document.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Document(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_effectiveTime(self): return self.effectiveTime
    def set_effectiveTime(self, effectiveTime): self.effectiveTime = effectiveTime
    def get_availabilityTime(self): return self.availabilityTime
    def set_availabilityTime(self, availabilityTime): self.availabilityTime = availabilityTime
    def get_confidentialityCode(self): return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode): self.confidentialityCode = confidentialityCode
    def get_languageCode(self): return self.languageCode
    def set_languageCode(self, languageCode): self.languageCode = languageCode
    def get_setId(self): return self.setId
    def set_setId(self, setId): self.setId = setId
    def get_versionNumber(self): return self.versionNumber
    def set_versionNumber(self, versionNumber): self.versionNumber = versionNumber
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def get_verifier(self): return self.verifier
    def set_verifier(self, verifier): self.verifier = verifier
    def add_verifier(self, value): self.verifier.append(value)
    def insert_verifier_at(self, index, value): self.verifier.insert(index, value)
    def replace_verifier_at(self, index, value): self.verifier[index] = value
    def get_legalAuthenticator(self): return self.legalAuthenticator
    def set_legalAuthenticator(self, legalAuthenticator): self.legalAuthenticator = legalAuthenticator
    def add_legalAuthenticator(self, value): self.legalAuthenticator.append(value)
    def insert_legalAuthenticator_at(self, index, value): self.legalAuthenticator.insert(index, value)
    def replace_legalAuthenticator_at(self, index, value): self.legalAuthenticator[index] = value
    def get_relatedDocument(self): return self.relatedDocument
    def set_relatedDocument(self, relatedDocument): self.relatedDocument = relatedDocument
    def add_relatedDocument(self, value): self.relatedDocument.append(value)
    def insert_relatedDocument_at(self, index, value): self.relatedDocument.insert(index, value)
    def replace_relatedDocument_at(self, index, value): self.relatedDocument[index] = value
    def get_component(self): return self.component
    def set_component(self, component): self.component = component
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_ActClassDocument(self, value):
        # Validate type ActClassDocument, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DOC', 'DOCCLIN', 'CDALVLONE']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassDocument' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocument_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassDocument_patterns_, ))
    validate_ActClassDocument_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None or
            self.code is not None or
            self.title is not None or
            self.effectiveTime is not None or
            self.availabilityTime is not None or
            self.confidentialityCode is not None or
            self.languageCode is not None or
            self.setId is not None or
            self.versionNumber is not None or
            self.author or
            self.verifier or
            self.legalAuthenticator or
            self.relatedDocument or
            self.component is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Document', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Document')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Document', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Document'):
        if self.classCode != "DOC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Document', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.id is not None:
            self.id.export(outfile, level, namespace_, name_='id', pretty_print=pretty_print)
        if self.code is not None:
            self.code.export(outfile, level, namespace_, name_='code', pretty_print=pretty_print)
        if self.title is not None:
            self.title.export(outfile, level, namespace_, name_='title', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            self.effectiveTime.export(outfile, level, namespace_, name_='effectiveTime', pretty_print=pretty_print)
        if self.availabilityTime is not None:
            self.availabilityTime.export(outfile, level, namespace_, name_='availabilityTime', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            self.confidentialityCode.export(outfile, level, namespace_, name_='confidentialityCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            self.languageCode.export(outfile, level, namespace_, name_='languageCode', pretty_print=pretty_print)
        if self.setId is not None:
            self.setId.export(outfile, level, namespace_, name_='setId', pretty_print=pretty_print)
        if self.versionNumber is not None:
            self.versionNumber.export(outfile, level, namespace_, name_='versionNumber', pretty_print=pretty_print)
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
        for verifier_ in self.verifier:
            verifier_.export(outfile, level, namespace_, name_='verifier', pretty_print=pretty_print)
        for legalAuthenticator_ in self.legalAuthenticator:
            legalAuthenticator_.export(outfile, level, namespace_, name_='legalAuthenticator', pretty_print=pretty_print)
        for relatedDocument_ in self.relatedDocument:
            relatedDocument_.export(outfile, level, namespace_, name_='relatedDocument', pretty_print=pretty_print)
        if self.component is not None:
            self.component.export(outfile, level, namespace_, name_='component', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassDocument(self.classCode)    # validate type ActClassDocument
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory()
            obj_.build(child_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'title':
            obj_ = StrucDoc_Title.factory()
            obj_.build(child_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'effectiveTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'availabilityTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.availabilityTime = obj_
            obj_.original_tagname_ = 'availabilityTime'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'languageCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'setId':
            obj_ = II.factory()
            obj_.build(child_)
            self.setId = obj_
            obj_.original_tagname_ = 'setId'
        elif nodeName_ == 'versionNumber':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.versionNumber = obj_
            obj_.original_tagname_ = 'versionNumber'
        elif nodeName_ == 'author':
            obj_ = PORP_MT050032UV_Author.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'verifier':
            obj_ = PORP_MT050032UV_Verifier.factory()
            obj_.build(child_)
            self.verifier.append(obj_)
            obj_.original_tagname_ = 'verifier'
        elif nodeName_ == 'legalAuthenticator':
            obj_ = PORP_MT050032UV_LegalAuthenticator.factory()
            obj_.build(child_)
            self.legalAuthenticator.append(obj_)
            obj_.original_tagname_ = 'legalAuthenticator'
        elif nodeName_ == 'relatedDocument':
            obj_ = PORP_MT050032UV_RelatedDocument.factory()
            obj_.build(child_)
            self.relatedDocument.append(obj_)
            obj_.original_tagname_ = 'relatedDocument'
        elif nodeName_ == 'component':
            obj_ = PORP_MT050032UV_Component3.factory()
            obj_.build(child_)
            self.component = obj_
            obj_.original_tagname_ = 'component'
# end class PORP_MT050032UV_Document


class PORP_MT050032UV_ExcerptFrom(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='XCRPT', realmCode=None, typeId=None, templateId=None, highlight=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.highlight = highlight
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_ExcerptFrom)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_ExcerptFrom.subclass:
            return PORP_MT050032UV_ExcerptFrom.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_ExcerptFrom(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_highlight(self): return self.highlight
    def set_highlight(self, highlight): self.highlight = highlight
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipExcerpt(self, value):
        # Validate type ActRelationshipExcerpt, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['XCRPT', 'VRXCRPT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipExcerpt' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipExcerpt_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipExcerpt_patterns_, ))
    validate_ActRelationshipExcerpt_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.highlight is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.ExcerptFrom', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.ExcerptFrom')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.ExcerptFrom', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.ExcerptFrom'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "XCRPT" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.ExcerptFrom', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.highlight is not None:
            self.highlight.export(outfile, level, namespace_, name_='highlight', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipExcerpt(self.typeCode)    # validate type ActRelationshipExcerpt
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'highlight':
            obj_ = PORP_MT050032UV_Highlight.factory()
            obj_.build(child_)
            self.highlight = obj_
            obj_.original_tagname_ = 'highlight'
# end class PORP_MT050032UV_ExcerptFrom


class PORP_MT050032UV_Highlight(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='DOCSECT', moodCode='EVN', realmCode=None, typeId=None, templateId=None, text=None, effectiveTime=None, subject=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.text = text
        self.effectiveTime = effectiveTime
        if subject is None:
            self.subject = []
        else:
            self.subject = subject
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Highlight)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Highlight.subclass:
            return PORP_MT050032UV_Highlight.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Highlight(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_effectiveTime(self): return self.effectiveTime
    def set_effectiveTime(self, effectiveTime): self.effectiveTime = effectiveTime
    def get_subject(self): return self.subject
    def set_subject(self, subject): self.subject = subject
    def add_subject(self, value): self.subject.append(value)
    def insert_subject_at(self, index, value): self.subject.insert(index, value)
    def replace_subject_at(self, index, value): self.subject[index] = value
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassDocumentSection(self, value):
        # Validate type ActClassDocumentSection, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DOCSECT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassDocumentSection' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocumentSection_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassDocumentSection_patterns_, ))
    validate_ActClassDocumentSection_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.text is not None or
            self.effectiveTime is not None or
            self.subject
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Highlight', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Highlight')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Highlight', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Highlight'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOCSECT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Highlight', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.text is not None:
            self.text.export(outfile, level, namespace_, name_='text', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            self.effectiveTime.export(outfile, level, namespace_, name_='effectiveTime', pretty_print=pretty_print)
        for subject_ in self.subject:
            subject_.export(outfile, level, namespace_, name_='subject', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassDocumentSection(self.classCode)    # validate type ActClassDocumentSection
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'text':
            obj_ = StrucDoc_Text.factory()
            obj_.build(child_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory()
            obj_.build(child_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'subject':
            obj_ = PORP_MT050032UV_Subject1.factory()
            obj_.build(child_)
            self.subject.append(obj_)
            obj_.original_tagname_ = 'subject'
# end class PORP_MT050032UV_Highlight


class PORP_MT050032UV_LegalAuthenticator(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='LA', realmCode=None, typeId=None, templateId=None, noteText=None, time=None, signatureCode=None, signatureText=None, assignedEntity=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.noteText = noteText
        self.time = time
        self.signatureCode = signatureCode
        self.signatureText = signatureText
        self.assignedEntity = assignedEntity
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_LegalAuthenticator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_LegalAuthenticator.subclass:
            return PORP_MT050032UV_LegalAuthenticator.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_LegalAuthenticator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_noteText(self): return self.noteText
    def set_noteText(self, noteText): self.noteText = noteText
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def get_signatureCode(self): return self.signatureCode
    def set_signatureCode(self, signatureCode): self.signatureCode = signatureCode
    def get_signatureText(self): return self.signatureText
    def set_signatureText(self, signatureText): self.signatureText = signatureText
    def get_assignedEntity(self): return self.assignedEntity
    def set_assignedEntity(self, assignedEntity): self.assignedEntity = assignedEntity
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ParticipationLegalAuthenticator(self, value):
        # Validate type ParticipationLegalAuthenticator, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['LA']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ParticipationLegalAuthenticator' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationLegalAuthenticator_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ParticipationLegalAuthenticator_patterns_, ))
    validate_ParticipationLegalAuthenticator_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.noteText is not None or
            self.time is not None or
            self.signatureCode is not None or
            self.signatureText is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.LegalAuthenticator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.LegalAuthenticator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.LegalAuthenticator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.LegalAuthenticator'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "LA" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.LegalAuthenticator', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.noteText is not None:
            self.noteText.export(outfile, level, namespace_, name_='noteText', pretty_print=pretty_print)
        if self.time is not None:
            self.time.export(outfile, level, namespace_, name_='time', pretty_print=pretty_print)
        if self.signatureCode is not None:
            self.signatureCode.export(outfile, level, namespace_, name_='signatureCode', pretty_print=pretty_print)
        if self.signatureText is not None:
            self.signatureText.export(outfile, level, namespace_, name_='signatureText', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            self.assignedEntity.export(outfile, level, namespace_, name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ParticipationLegalAuthenticator(self.typeCode)    # validate type ParticipationLegalAuthenticator
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'noteText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.noteText = obj_
            obj_.original_tagname_ = 'noteText'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'signatureCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.signatureCode = obj_
            obj_.original_tagname_ = 'signatureCode'
        elif nodeName_ == 'signatureText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.signatureText = obj_
            obj_.original_tagname_ = 'signatureText'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCP_MT030100UV_AssignedEntity2.factory()
            obj_.build(child_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class PORP_MT050032UV_LegalAuthenticator


class PORP_MT050032UV_NonXMLBody(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='DOCBODY', moodCode='EVN', realmCode=None, typeId=None, templateId=None, text=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.text = text
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_NonXMLBody)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_NonXMLBody.subclass:
            return PORP_MT050032UV_NonXMLBody.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_NonXMLBody(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassDocumentBody(self, value):
        # Validate type ActClassDocumentBody, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DOCBODY']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassDocumentBody' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocumentBody_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassDocumentBody_patterns_, ))
    validate_ActClassDocumentBody_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.NonXMLBody', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.NonXMLBody')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.NonXMLBody', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.NonXMLBody'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOCBODY" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.NonXMLBody', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.text is not None:
            self.text.export(outfile, level, namespace_, name_='text', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassDocumentBody(self.classCode)    # validate type ActClassDocumentBody
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'text':
            obj_ = ED.factory()
            obj_.build(child_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class PORP_MT050032UV_NonXMLBody


class PORP_MT050032UV_ObservationMedia(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='OBS', moodCode='EVN', ID=None, realmCode=None, typeId=None, templateId=None, id=None, text=None, value=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        self.ID = _cast(None, ID)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.id = id
        self.text = text
        self.value = value
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_ObservationMedia)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_ObservationMedia.subclass:
            return PORP_MT050032UV_ObservationMedia.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_ObservationMedia(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['OBS', 'ROIBND', 'ROIOVL', 'LLD', 'PRN', 'RLD', 'SFWL', 'SIT', 'STN', 'SUP', 'RTRD', 'TRD', 'ALRT', 'BATTERY', 'CLNTRL', 'CNOD', 'COND', 'CASE', 'OUTB', 'DGIMG', 'GEN', 'DETPOL', 'EXP', 'LOC', 'PHN', 'POL', 'SEQ', 'SEQVAR', 'INVSTG', 'OBSSER', 'OBSCOR', 'POS', 'POSACC', 'POSCOORD', 'SPCOBS', 'VERIF']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassObservation' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassObservation_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassObservation_patterns_, ))
    validate_ActClassObservation_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None or
            self.text is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.ObservationMedia', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.ObservationMedia')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.ObservationMedia', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.ObservationMedia'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "OBS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.ObservationMedia', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.id is not None:
            self.id.export(outfile, level, namespace_, name_='id', pretty_print=pretty_print)
        if self.text is not None:
            self.text.export(outfile, level, namespace_, name_='text', pretty_print=pretty_print)
        if self.value is not None:
            self.value.export(outfile, level, namespace_, name_='value', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory()
            obj_.build(child_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'text':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'value':
            obj_ = ED.factory()
            obj_.build(child_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
# end class PORP_MT050032UV_ObservationMedia


class PORP_MT050032UV_RelatedDocument(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode=None, contextConductionInd='false', realmCode=None, typeId=None, templateId=None, relatedDocument=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        self.contextConductionInd = _cast(None, contextConductionInd)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.relatedDocument = relatedDocument
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_RelatedDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_RelatedDocument.subclass:
            return PORP_MT050032UV_RelatedDocument.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_RelatedDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_relatedDocument(self): return self.relatedDocument
    def set_relatedDocument(self, relatedDocument): self.relatedDocument = relatedDocument
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def get_contextConductionInd(self): return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd): self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_x_ActRelationshipDocumentSPL(self, value):
        # Validate type x_ActRelationshipDocumentSPL, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['APND', 'DRIV', 'RPLC', 'XCRPT', 'XFRM', 'SUBJ']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on x_ActRelationshipDocumentSPL' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActRelationshipDocumentSPL_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_x_ActRelationshipDocumentSPL_patterns_, ))
    validate_x_ActRelationshipDocumentSPL_patterns_ = [['^[^\\s]+$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.relatedDocument is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.RelatedDocument', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.RelatedDocument')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.RelatedDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.RelatedDocument'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd=%s' % (quote_attrib(self.contextConductionInd), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.RelatedDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.relatedDocument is not None:
            self.relatedDocument.export(outfile, level, namespace_, name_='relatedDocument', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_x_ActRelationshipDocumentSPL(self.typeCode)    # validate type x_ActRelationshipDocumentSPL
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'relatedDocument':
            obj_ = PORP_MT050032UV_RelatedDocument1.factory()
            obj_.build(child_)
            self.relatedDocument = obj_
            obj_.original_tagname_ = 'relatedDocument'
# end class PORP_MT050032UV_RelatedDocument


class PORP_MT050032UV_RelatedDocument1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='DOC', moodCode='EVN', realmCode=None, typeId=None, templateId=None, id=None, effectiveTime=None, setId=None, versionNumber=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.id = id
        self.effectiveTime = effectiveTime
        self.setId = setId
        self.versionNumber = versionNumber
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_RelatedDocument1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_RelatedDocument1.subclass:
            return PORP_MT050032UV_RelatedDocument1.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_RelatedDocument1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_effectiveTime(self): return self.effectiveTime
    def set_effectiveTime(self, effectiveTime): self.effectiveTime = effectiveTime
    def get_setId(self): return self.setId
    def set_setId(self, setId): self.setId = setId
    def get_versionNumber(self): return self.versionNumber
    def set_versionNumber(self, versionNumber): self.versionNumber = versionNumber
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassDocument(self, value):
        # Validate type ActClassDocument, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DOC', 'DOCCLIN', 'CDALVLONE']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassDocument' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocument_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassDocument_patterns_, ))
    validate_ActClassDocument_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None or
            self.effectiveTime is not None or
            self.setId is not None or
            self.versionNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.RelatedDocument1', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.RelatedDocument1')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.RelatedDocument1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.RelatedDocument1'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.RelatedDocument1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.id is not None:
            self.id.export(outfile, level, namespace_, name_='id', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            self.effectiveTime.export(outfile, level, namespace_, name_='effectiveTime', pretty_print=pretty_print)
        if self.setId is not None:
            self.setId.export(outfile, level, namespace_, name_='setId', pretty_print=pretty_print)
        if self.versionNumber is not None:
            self.versionNumber.export(outfile, level, namespace_, name_='versionNumber', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassDocument(self.classCode)    # validate type ActClassDocument
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory()
            obj_.build(child_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'effectiveTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'setId':
            obj_ = II.factory()
            obj_.build(child_)
            self.setId = obj_
            obj_.original_tagname_ = 'setId'
        elif nodeName_ == 'versionNumber':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.versionNumber = obj_
            obj_.original_tagname_ = 'versionNumber'
# end class PORP_MT050032UV_RelatedDocument1


class PORP_MT050032UV_ReplacementOf(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='RPLC', contextConductionInd='false', realmCode=None, typeId=None, templateId=None, sectionReplaced=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        self.contextConductionInd = _cast(None, contextConductionInd)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.sectionReplaced = sectionReplaced
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_ReplacementOf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_ReplacementOf.subclass:
            return PORP_MT050032UV_ReplacementOf.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_ReplacementOf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_sectionReplaced(self): return self.sectionReplaced
    def set_sectionReplaced(self, sectionReplaced): self.sectionReplaced = sectionReplaced
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def get_contextConductionInd(self): return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd): self.contextConductionInd = contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipReplaces(self, value):
        # Validate type ActRelationshipReplaces, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['RPLC']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipReplaces' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipReplaces_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipReplaces_patterns_, ))
    validate_ActRelationshipReplaces_patterns_ = [['^[^\\s]+$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.sectionReplaced is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.ReplacementOf', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.ReplacementOf')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.ReplacementOf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.ReplacementOf'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "RPLC" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd=%s' % (quote_attrib(self.contextConductionInd), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.ReplacementOf', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.sectionReplaced is not None:
            self.sectionReplaced.export(outfile, level, namespace_, name_='sectionReplaced', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipReplaces(self.typeCode)    # validate type ActRelationshipReplaces
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'sectionReplaced':
            obj_ = PORP_MT050032UV_SectionReplaced.factory()
            obj_.build(child_)
            self.sectionReplaced = obj_
            obj_.original_tagname_ = 'sectionReplaced'
# end class PORP_MT050032UV_ReplacementOf


class PORP_MT050032UV_Section(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='DOCSECT', moodCode='EVN', ID=None, realmCode=None, typeId=None, templateId=None, id=None, code=None, title=None, text=None, effectiveTime=None, confidentialityCode=None, languageCode=None, author=None, replacementOf=None, subjectOf=None, subject=None, subject2=None, excerpt=None, component=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        self.ID = _cast(None, ID)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.id = id
        self.code = code
        self.title = title
        self.text = text
        self.effectiveTime = effectiveTime
        self.confidentialityCode = confidentialityCode
        self.languageCode = languageCode
        if author is None:
            self.author = []
        else:
            self.author = author
        if replacementOf is None:
            self.replacementOf = []
        else:
            self.replacementOf = replacementOf
        if subjectOf is None:
            self.subjectOf = []
        else:
            self.subjectOf = subjectOf
        if subject is None:
            self.subject = []
        else:
            self.subject = subject
        if subject2 is None:
            self.subject2 = []
        else:
            self.subject2 = subject2
        self.excerpt = excerpt
        if component is None:
            self.component = []
        else:
            self.component = component
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Section)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Section.subclass:
            return PORP_MT050032UV_Section.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Section(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_effectiveTime(self): return self.effectiveTime
    def set_effectiveTime(self, effectiveTime): self.effectiveTime = effectiveTime
    def get_confidentialityCode(self): return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode): self.confidentialityCode = confidentialityCode
    def get_languageCode(self): return self.languageCode
    def set_languageCode(self, languageCode): self.languageCode = languageCode
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def get_replacementOf(self): return self.replacementOf
    def set_replacementOf(self, replacementOf): self.replacementOf = replacementOf
    def add_replacementOf(self, value): self.replacementOf.append(value)
    def insert_replacementOf_at(self, index, value): self.replacementOf.insert(index, value)
    def replace_replacementOf_at(self, index, value): self.replacementOf[index] = value
    def get_subjectOf(self): return self.subjectOf
    def set_subjectOf(self, subjectOf): self.subjectOf = subjectOf
    def add_subjectOf(self, value): self.subjectOf.append(value)
    def insert_subjectOf_at(self, index, value): self.subjectOf.insert(index, value)
    def replace_subjectOf_at(self, index, value): self.subjectOf[index] = value
    def get_subject(self): return self.subject
    def set_subject(self, subject): self.subject = subject
    def add_subject(self, value): self.subject.append(value)
    def insert_subject_at(self, index, value): self.subject.insert(index, value)
    def replace_subject_at(self, index, value): self.subject[index] = value
    def get_subject2(self): return self.subject2
    def set_subject2(self, subject2): self.subject2 = subject2
    def add_subject2(self, value): self.subject2.append(value)
    def insert_subject2_at(self, index, value): self.subject2.insert(index, value)
    def replace_subject2_at(self, index, value): self.subject2[index] = value
    def get_excerpt(self): return self.excerpt
    def set_excerpt(self, excerpt): self.excerpt = excerpt
    def get_component(self): return self.component
    def set_component(self, component): self.component = component
    def add_component(self, value): self.component.append(value)
    def insert_component_at(self, index, value): self.component.insert(index, value)
    def replace_component_at(self, index, value): self.component[index] = value
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassDocumentSection(self, value):
        # Validate type ActClassDocumentSection, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DOCSECT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassDocumentSection' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocumentSection_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassDocumentSection_patterns_, ))
    validate_ActClassDocumentSection_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None or
            self.code is not None or
            self.title is not None or
            self.text is not None or
            self.effectiveTime is not None or
            self.confidentialityCode is not None or
            self.languageCode is not None or
            self.author or
            self.replacementOf or
            self.subjectOf or
            self.subject or
            self.subject2 or
            self.excerpt is not None or
            self.component
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Section', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Section')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Section', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Section'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOCSECT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Section', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.id is not None:
            self.id.export(outfile, level, namespace_, name_='id', pretty_print=pretty_print)
        if self.code is not None:
            self.code.export(outfile, level, namespace_, name_='code', pretty_print=pretty_print)
        if self.title is not None:
            self.title.export(outfile, level, namespace_, name_='title', pretty_print=pretty_print)
        if self.text is not None:
            self.text.export(outfile, level, namespace_, name_='text', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            self.effectiveTime.export(outfile, level, namespace_, name_='effectiveTime', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            self.confidentialityCode.export(outfile, level, namespace_, name_='confidentialityCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            self.languageCode.export(outfile, level, namespace_, name_='languageCode', pretty_print=pretty_print)
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
        for replacementOf_ in self.replacementOf:
            replacementOf_.export(outfile, level, namespace_, name_='replacementOf', pretty_print=pretty_print)
        for subjectOf_ in self.subjectOf:
            subjectOf_.export(outfile, level, namespace_, name_='subjectOf', pretty_print=pretty_print)
        for subject_ in self.subject:
            subject_.export(outfile, level, namespace_, name_='subject', pretty_print=pretty_print)
        for subject2_ in self.subject2:
            subject2_.export(outfile, level, namespace_, name_='subject2', pretty_print=pretty_print)
        if self.excerpt is not None:
            self.excerpt.export(outfile, level, namespace_, name_='excerpt', pretty_print=pretty_print)
        for component_ in self.component:
            component_.export(outfile, level, namespace_, name_='component', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassDocumentSection(self.classCode)    # validate type ActClassDocumentSection
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory()
            obj_.build(child_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'title':
            obj_ = StrucDoc_Title.factory()
            obj_.build(child_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'text':
            obj_ = StrucDoc_Text.factory()
            obj_.build(child_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory()
            obj_.build(child_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'languageCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'author':
            obj_ = PORP_MT050032UV_Author.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'replacementOf':
            obj_ = PORP_MT050032UV_ReplacementOf.factory()
            obj_.build(child_)
            self.replacementOf.append(obj_)
            obj_.original_tagname_ = 'replacementOf'
        elif nodeName_ == 'subjectOf':
            obj_ = PORP_MT050032UV_Subject4.factory()
            obj_.build(child_)
            self.subjectOf.append(obj_)
            obj_.original_tagname_ = 'subjectOf'
        elif nodeName_ == 'subject':
            obj_ = PORP_MT050032UV_Subject.factory()
            obj_.build(child_)
            self.subject.append(obj_)
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'subject2':
            obj_ = PORP_MT050032UV_Subject3.factory()
            obj_.build(child_)
            self.subject2.append(obj_)
            obj_.original_tagname_ = 'subject2'
        elif nodeName_ == 'excerpt':
            obj_ = PORP_MT050032UV_ExcerptFrom.factory()
            obj_.build(child_)
            self.excerpt = obj_
            obj_.original_tagname_ = 'excerpt'
        elif nodeName_ == 'component':
            obj_ = PORP_MT050032UV_Component1.factory()
            obj_.build(child_)
            self.component.append(obj_)
            obj_.original_tagname_ = 'component'
# end class PORP_MT050032UV_Section


class PORP_MT050032UV_SectionReplaced(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='DOCSECT', moodCode='EVN', realmCode=None, typeId=None, templateId=None, id=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.id = id
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_SectionReplaced)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_SectionReplaced.subclass:
            return PORP_MT050032UV_SectionReplaced.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_SectionReplaced(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassDocumentSection(self, value):
        # Validate type ActClassDocumentSection, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DOCSECT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassDocumentSection' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocumentSection_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassDocumentSection_patterns_, ))
    validate_ActClassDocumentSection_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.SectionReplaced', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.SectionReplaced')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.SectionReplaced', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.SectionReplaced'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOCSECT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.SectionReplaced', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.id is not None:
            self.id.export(outfile, level, namespace_, name_='id', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassDocumentSection(self.classCode)    # validate type ActClassDocumentSection
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            obj_ = II.factory()
            obj_.build(child_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
# end class PORP_MT050032UV_SectionReplaced


class PORP_MT050032UV_SequelTo(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='SEQL', realmCode=None, typeId=None, templateId=None, comment=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.comment = comment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_SequelTo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_SequelTo.subclass:
            return PORP_MT050032UV_SequelTo.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_SequelTo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipSequel(self, value):
        # Validate type ActRelationshipSequel, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SEQL', 'APND', 'BSLN', 'COMPLY', 'DOC', 'FLFS', 'OCCR', 'OREF', 'SCH', 'GEN', 'GEVL', 'INST', 'MOD', 'MTCH', 'OPTN', 'RCHAL', 'REV', 'RPLC', 'SUCC', 'UPDT', 'XCRPT', 'VRXCRPT', 'XFRM']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipSequel' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipSequel_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipSequel_patterns_, ))
    validate_ActRelationshipSequel_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.comment is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.SequelTo', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.SequelTo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.SequelTo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.SequelTo'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "SEQL" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.SequelTo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.comment is not None:
            self.comment.export(outfile, level, namespace_, name_='comment', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipSequel(self.typeCode)    # validate type ActRelationshipSequel
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'comment':
            obj_ = PORP_MT050032UV_Comment.factory()
            obj_.build(child_)
            self.comment = obj_
            obj_.original_tagname_ = 'comment'
# end class PORP_MT050032UV_SequelTo


class PORP_MT050032UV_StructuredBody(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='DOCBODY', moodCode='EVN', realmCode=None, typeId=None, templateId=None, component=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        if component is None:
            self.component = []
        else:
            self.component = component
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_StructuredBody)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_StructuredBody.subclass:
            return PORP_MT050032UV_StructuredBody.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_StructuredBody(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_component(self): return self.component
    def set_component(self, component): self.component = component
    def add_component(self, value): self.component.append(value)
    def insert_component_at(self, index, value): self.component.insert(index, value)
    def replace_component_at(self, index, value): self.component[index] = value
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassDocumentBody(self, value):
        # Validate type ActClassDocumentBody, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DOCBODY']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassDocumentBody' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassDocumentBody_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassDocumentBody_patterns_, ))
    validate_ActClassDocumentBody_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.component
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.StructuredBody', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.StructuredBody')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.StructuredBody', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.StructuredBody'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOCBODY" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.StructuredBody', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        for component_ in self.component:
            component_.export(outfile, level, namespace_, name_='component', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassDocumentBody(self.classCode)    # validate type ActClassDocumentBody
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'component':
            obj_ = PORP_MT050032UV_Component2.factory()
            obj_.build(child_)
            self.component.append(obj_)
            obj_.original_tagname_ = 'component'
# end class PORP_MT050032UV_StructuredBody


class PORP_MT050032UV_Subject(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='SBJ', realmCode=None, typeId=None, templateId=None, manufacturedProduct=None, identifiedSubstance=None, ingredient=None, moiety=None, instanceOfKind=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.manufacturedProduct = manufacturedProduct
        self.identifiedSubstance = identifiedSubstance
        self.ingredient = ingredient
        self.moiety = moiety
        self.instanceOfKind = instanceOfKind
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Subject)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Subject.subclass:
            return PORP_MT050032UV_Subject.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Subject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_manufacturedProduct(self): return self.manufacturedProduct
    def set_manufacturedProduct(self, manufacturedProduct): self.manufacturedProduct = manufacturedProduct
    def get_identifiedSubstance(self): return self.identifiedSubstance
    def set_identifiedSubstance(self, identifiedSubstance): self.identifiedSubstance = identifiedSubstance
    def get_ingredient(self): return self.ingredient
    def set_ingredient(self, ingredient): self.ingredient = ingredient
    def get_moiety(self): return self.moiety
    def set_moiety(self, moiety): self.moiety = moiety
    def get_instanceOfKind(self): return self.instanceOfKind
    def set_instanceOfKind(self, instanceOfKind): self.instanceOfKind = instanceOfKind
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ParticipationTargetSubject(self, value):
        # Validate type ParticipationTargetSubject, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SBJ', 'SPC']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ParticipationTargetSubject' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationTargetSubject_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ParticipationTargetSubject_patterns_, ))
    validate_ParticipationTargetSubject_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.manufacturedProduct is not None or
            self.identifiedSubstance is not None or
            self.ingredient is not None or
            self.moiety is not None or
            self.instanceOfKind is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Subject')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Subject', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Subject'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "SBJ" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.manufacturedProduct is not None:
            self.manufacturedProduct.export(outfile, level, namespace_, name_='manufacturedProduct', pretty_print=pretty_print)
        if self.identifiedSubstance is not None:
            self.identifiedSubstance.export(outfile, level, namespace_, name_='identifiedSubstance', pretty_print=pretty_print)
        if self.ingredient is not None:
            self.ingredient.export(outfile, level, namespace_, name_='ingredient', pretty_print=pretty_print)
        if self.moiety is not None:
            self.moiety.export(outfile, level, namespace_, name_='moiety', pretty_print=pretty_print)
        if self.instanceOfKind is not None:
            self.instanceOfKind.export(outfile, level, namespace_, name_='instanceOfKind', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ParticipationTargetSubject(self.typeCode)    # validate type ParticipationTargetSubject
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'manufacturedProduct':
            obj_ = POCP_MT010100UV_ManufacturedProduct.factory()
            obj_.build(child_)
            self.manufacturedProduct = obj_
            obj_.original_tagname_ = 'manufacturedProduct'
        elif nodeName_ == 'identifiedSubstance':
            obj_ = POCP_MT080300UV_IdentifiedSubstance.factory()
            obj_.build(child_)
            self.identifiedSubstance = obj_
            obj_.original_tagname_ = 'identifiedSubstance'
        elif nodeName_ == 'ingredient':
            obj_ = POCP_MT080300UV_Ingredient.factory()
            obj_.build(child_)
            self.ingredient = obj_
            obj_.original_tagname_ = 'ingredient'
        elif nodeName_ == 'moiety':
            obj_ = POCP_MT080300UV_Moiety.factory()
            obj_.build(child_)
            self.moiety = obj_
            obj_.original_tagname_ = 'moiety'
        elif nodeName_ == 'instanceOfKind':
            obj_ = POCP_MT020200UV_InstanceOfKind.factory()
            obj_.build(child_)
            self.instanceOfKind = obj_
            obj_.original_tagname_ = 'instanceOfKind'
# end class PORP_MT050032UV_Subject


class PORP_MT050032UV_Subject1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='SUBJ', realmCode=None, typeId=None, templateId=None, substanceAdministration=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.substanceAdministration = substanceAdministration
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Subject1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Subject1.subclass:
            return PORP_MT050032UV_Subject1.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Subject1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_substanceAdministration(self): return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration): self.substanceAdministration = substanceAdministration
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipHasSubject(self, value):
        # Validate type ActRelationshipHasSubject, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SUBJ', 'QUALF']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipHasSubject' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasSubject_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipHasSubject_patterns_, ))
    validate_ActRelationshipHasSubject_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.substanceAdministration is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject1', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Subject1')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Subject1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Subject1'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "SUBJ" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            self.substanceAdministration.export(outfile, level, namespace_, name_='substanceAdministration', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipHasSubject(self.typeCode)    # validate type ActRelationshipHasSubject
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCP_MT060100UV_SubstanceAdministration1.factory()
            obj_.build(child_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
# end class PORP_MT050032UV_Subject1


class PORP_MT050032UV_Subject2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='SUBJ', realmCode=None, typeId=None, templateId=None, textFragmentReference=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.textFragmentReference = textFragmentReference
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Subject2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Subject2.subclass:
            return PORP_MT050032UV_Subject2.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Subject2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_textFragmentReference(self): return self.textFragmentReference
    def set_textFragmentReference(self, textFragmentReference): self.textFragmentReference = textFragmentReference
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipHasSubject(self, value):
        # Validate type ActRelationshipHasSubject, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SUBJ', 'QUALF']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipHasSubject' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasSubject_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipHasSubject_patterns_, ))
    validate_ActRelationshipHasSubject_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.textFragmentReference is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject2', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Subject2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Subject2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Subject2'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "SUBJ" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.textFragmentReference is not None:
            self.textFragmentReference.export(outfile, level, namespace_, name_='textFragmentReference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipHasSubject(self.typeCode)    # validate type ActRelationshipHasSubject
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'textFragmentReference':
            obj_ = PORP_MT050032UV_TextFragmentReference.factory()
            obj_.build(child_)
            self.textFragmentReference = obj_
            obj_.original_tagname_ = 'textFragmentReference'
# end class PORP_MT050032UV_Subject2


class PORP_MT050032UV_Subject3(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='SUBJ', realmCode=None, typeId=None, templateId=None, substanceAdministration=None, document=None, characteristic=None, action=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.substanceAdministration = substanceAdministration
        self.document = document
        self.characteristic = characteristic
        self.action = action
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Subject3)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Subject3.subclass:
            return PORP_MT050032UV_Subject3.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Subject3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_substanceAdministration(self): return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration): self.substanceAdministration = substanceAdministration
    def get_document(self): return self.document
    def set_document(self, document): self.document = document
    def get_characteristic(self): return self.characteristic
    def set_characteristic(self, characteristic): self.characteristic = characteristic
    def get_action(self): return self.action
    def set_action(self, action): self.action = action
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipHasSubject(self, value):
        # Validate type ActRelationshipHasSubject, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SUBJ', 'QUALF']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipHasSubject' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasSubject_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipHasSubject_patterns_, ))
    validate_ActRelationshipHasSubject_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.substanceAdministration is not None or
            self.document is not None or
            self.characteristic is not None or
            self.action is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject3', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Subject3')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Subject3', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Subject3'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "SUBJ" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject3', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            self.substanceAdministration.export(outfile, level, namespace_, name_='substanceAdministration', pretty_print=pretty_print)
        if self.document is not None:
            self.document.export(outfile, level, namespace_, name_='document', pretty_print=pretty_print)
        if self.characteristic is not None:
            self.characteristic.export(outfile, level, namespace_, name_='characteristic', pretty_print=pretty_print)
        if self.action is not None:
            self.action.export(outfile, level, namespace_, name_='action', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipHasSubject(self.typeCode)    # validate type ActRelationshipHasSubject
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCP_MT060100UV_SubstanceAdministration1.factory()
            obj_.build(child_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
        elif nodeName_ == 'document':
            obj_ = POCP_MT050600UV_Document.factory()
            obj_.build(child_)
            self.document = obj_
            obj_.original_tagname_ = 'document'
        elif nodeName_ == 'characteristic':
            obj_ = POCP_MT050600UV_Characteristic.factory()
            obj_.build(child_)
            self.characteristic = obj_
            obj_.original_tagname_ = 'characteristic'
        elif nodeName_ == 'action':
            obj_ = POCP_MT050600UV_Action.factory()
            obj_.build(child_)
            self.action = obj_
            obj_.original_tagname_ = 'action'
# end class PORP_MT050032UV_Subject3


class PORP_MT050032UV_Subject4(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='SUBJ', realmCode=None, typeId=None, templateId=None, comment=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.comment = comment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Subject4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Subject4.subclass:
            return PORP_MT050032UV_Subject4.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Subject4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActRelationshipHasSubject(self, value):
        # Validate type ActRelationshipHasSubject, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SUBJ', 'QUALF']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActRelationshipHasSubject' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasSubject_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActRelationshipHasSubject_patterns_, ))
    validate_ActRelationshipHasSubject_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.comment is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject4', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Subject4')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Subject4', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Subject4'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "SUBJ" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Subject4', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.comment is not None:
            self.comment.export(outfile, level, namespace_, name_='comment', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipHasSubject(self.typeCode)    # validate type ActRelationshipHasSubject
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'comment':
            obj_ = PORP_MT050032UV_Comment.factory()
            obj_.build(child_)
            self.comment = obj_
            obj_.original_tagname_ = 'comment'
# end class PORP_MT050032UV_Subject4


class PORP_MT050032UV_TextFragmentReference(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, classCode='ACT', moodCode='EVN', realmCode=None, typeId=None, templateId=None, text=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.classCode = _cast(None, classCode)
        self.moodCode = _cast(None, moodCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.text = text
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_TextFragmentReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_TextFragmentReference.subclass:
            return PORP_MT050032UV_TextFragmentReference.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_TextFragmentReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_text(self): return self.text
    def set_text(self, text): self.text = text
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_classCode(self): return self.classCode
    def set_classCode(self, classCode): self.classCode = classCode
    def get_moodCode(self): return self.moodCode
    def set_moodCode(self, moodCode): self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ActClassRoot(self, value):
        # Validate type ActClassRoot, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ACT', 'COMPOSITION', 'DOC', 'DOCCLIN', 'CDALVLONE', 'CONTAINER', 'CATEGORY', 'DOCBODY', 'DOCSECT', 'TOPIC', 'EXTRACT', 'EHR', 'FOLDER', 'GROUPER', 'CLUSTER', 'ACCM', 'ACCT', 'ACSN', 'ADJUD', 'CACT', 'ACTN', 'INFO', 'STC', 'CNTRCT', 'FCNTRCT', 'COV', 'CONC', 'HCASE', 'OUTBR', 'CONS', 'CONTREG', 'CTTEVENT', 'DISPACT', 'EXPOS', 'AEXPOS', 'TEXPOS', 'INC', 'INFRM', 'INVE', 'LIST', 'MPROT', 'OBS', 'ROIBND', 'ROIOVL', 'LLD', 'PRN', 'RLD', 'SFWL', 'SIT', 'STN', 'SUP', 'RTRD', 'TRD', 'ALRT', 'BATTERY', 'CLNTRL', 'CNOD', 'COND', 'CASE', 'OUTB', 'DGIMG', 'GEN', 'DETPOL', 'EXP', 'LOC', 'PHN', 'POL', 'SEQ', 'SEQVAR', 'INVSTG', 'OBSSER', 'OBSCOR', 'POS', 'POSACC', 'POSCOORD', 'SPCOBS', 'VERIF', 'PCPR', 'ENC', 'POLICY', 'JURISPOL', 'ORGPOL', 'SCOPOL', 'STDPOL', 'PROC', 'SBADM', 'SBEXT', 'SPECCOLLECT', 'REG', 'REV', 'SPCTRT', 'SPLY', 'DIET', 'STORE', 'SUBST', 'TRFR', 'TRNS', 'XACT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActClassRoot' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClassRoot_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActClassRoot_patterns_, ))
    validate_ActClassRoot_patterns_ = [['^[^\\s]+$']]
    def validate_ActMoodEventOccurrence(self, value):
        # Validate type ActMoodEventOccurrence, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EVN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ActMoodEventOccurrence' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ActMoodEventOccurrence_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ActMoodEventOccurrence_patterns_, ))
    validate_ActMoodEventOccurrence_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.TextFragmentReference', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.TextFragmentReference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.TextFragmentReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.TextFragmentReference'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ACT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode != "EVN" and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.TextFragmentReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.text is not None:
            self.text.export(outfile, level, namespace_, name_='text', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClassRoot(self.classCode)    # validate type ActClassRoot
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMoodEventOccurrence(self.moodCode)    # validate type ActMoodEventOccurrence
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'text':
            obj_ = ED.factory()
            obj_.build(child_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class PORP_MT050032UV_TextFragmentReference


class PORP_MT050032UV_Verifier(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, typeCode='VRF', realmCode=None, typeId=None, templateId=None, noteText=None, time=None, signatureCode=None, signatureText=None, assignedEntity=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.typeCode = _cast(None, typeCode)
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.typeId = typeId
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.noteText = noteText
        self.time = time
        self.signatureCode = signatureCode
        self.signatureText = signatureText
        self.assignedEntity = assignedEntity
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PORP_MT050032UV_Verifier)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PORP_MT050032UV_Verifier.subclass:
            return PORP_MT050032UV_Verifier.subclass(*args_, **kwargs_)
        else:
            return PORP_MT050032UV_Verifier(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realmCode(self): return self.realmCode
    def set_realmCode(self, realmCode): self.realmCode = realmCode
    def add_realmCode(self, value): self.realmCode.append(value)
    def insert_realmCode_at(self, index, value): self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value): self.realmCode[index] = value
    def get_typeId(self): return self.typeId
    def set_typeId(self, typeId): self.typeId = typeId
    def get_templateId(self): return self.templateId
    def set_templateId(self, templateId): self.templateId = templateId
    def add_templateId(self, value): self.templateId.append(value)
    def insert_templateId_at(self, index, value): self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value): self.templateId[index] = value
    def get_noteText(self): return self.noteText
    def set_noteText(self, noteText): self.noteText = noteText
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def get_signatureCode(self): return self.signatureCode
    def set_signatureCode(self, signatureCode): self.signatureCode = signatureCode
    def get_signatureText(self): return self.signatureText
    def set_signatureText(self, signatureText): self.signatureText = signatureText
    def get_assignedEntity(self): return self.assignedEntity
    def set_assignedEntity(self, assignedEntity): self.assignedEntity = assignedEntity
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_typeCode(self): return self.typeCode
    def set_typeCode(self, typeCode): self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_ParticipationVerifier(self, value):
        # Validate type ParticipationVerifier, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['VRF', 'AUTHEN', 'LA']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ParticipationVerifier' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationVerifier_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ParticipationVerifier_patterns_, ))
    validate_ParticipationVerifier_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.noteText is not None or
            self.time is not None or
            self.signatureCode is not None or
            self.signatureText is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Verifier', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PORP_MT050032UV.Verifier')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PORP_MT050032UV.Verifier', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PORP_MT050032UV.Verifier'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "VRF" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PORP_MT050032UV.Verifier', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            realmCode_.export(outfile, level, namespace_, name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            self.typeId.export(outfile, level, namespace_, name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            templateId_.export(outfile, level, namespace_, name_='templateId', pretty_print=pretty_print)
        if self.noteText is not None:
            self.noteText.export(outfile, level, namespace_, name_='noteText', pretty_print=pretty_print)
        if self.time is not None:
            self.time.export(outfile, level, namespace_, name_='time', pretty_print=pretty_print)
        if self.signatureCode is not None:
            self.signatureCode.export(outfile, level, namespace_, name_='signatureCode', pretty_print=pretty_print)
        if self.signatureText is not None:
            self.signatureText.export(outfile, level, namespace_, name_='signatureText', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            self.assignedEntity.export(outfile, level, namespace_, name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ParticipationVerifier(self.typeCode)    # validate type ParticipationVerifier
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory()
            obj_.build(child_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = II.factory()
            obj_.build(child_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            obj_ = II.factory()
            obj_.build(child_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'noteText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.noteText = obj_
            obj_.original_tagname_ = 'noteText'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'signatureCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.signatureCode = obj_
            obj_.original_tagname_ = 'signatureCode'
        elif nodeName_ == 'signatureText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.signatureText = obj_
            obj_.original_tagname_ = 'signatureText'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCP_MT030100UV_AssignedEntity2.factory()
            obj_.build(child_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class PORP_MT050032UV_Verifier


class StrucDoc_Text(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, mediaType=None, content=None, linkHtml=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, renderMultiMedia=None, paragraph=None, list=None, table=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.mediaType = _cast(None, mediaType)
        if content is None:
            self.content = []
        else:
            self.content = content
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        if renderMultiMedia is None:
            self.renderMultiMedia = []
        else:
            self.renderMultiMedia = renderMultiMedia
        if paragraph is None:
            self.paragraph = []
        else:
            self.paragraph = paragraph
        if list is None:
            self.list = []
        else:
            self.list = list
        if table is None:
            self.table = []
        else:
            self.table = table
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Text)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Text.subclass:
            return StrucDoc_Text.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Text(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_renderMultiMedia(self): return self.renderMultiMedia
    def set_renderMultiMedia(self, renderMultiMedia): self.renderMultiMedia = renderMultiMedia
    def add_renderMultiMedia(self, value): self.renderMultiMedia.append(value)
    def insert_renderMultiMedia_at(self, index, value): self.renderMultiMedia.insert(index, value)
    def replace_renderMultiMedia_at(self, index, value): self.renderMultiMedia[index] = value
    def get_paragraph(self): return self.paragraph
    def set_paragraph(self, paragraph): self.paragraph = paragraph
    def add_paragraph(self, value): self.paragraph.append(value)
    def insert_paragraph_at(self, index, value): self.paragraph.insert(index, value)
    def replace_paragraph_at(self, index, value): self.paragraph[index] = value
    def get_list(self): return self.list
    def set_list(self, list): self.list = list
    def add_list(self, value): self.list.append(value)
    def insert_list_at(self, index, value): self.list.insert(index, value)
    def replace_list_at(self, index, value): self.list[index] = value
    def get_table(self): return self.table
    def set_table(self, table): self.table = table
    def add_table(self, value): self.table.append(value)
    def insert_table_at(self, index, value): self.table.insert(index, value)
    def replace_table_at(self, index, value): self.table[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_mediaType(self): return self.mediaType
    def set_mediaType(self, mediaType): self.mediaType = mediaType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.linkHtml or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            self.renderMultiMedia or
            self.paragraph or
            self.list or
            self.table or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Text', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Text')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Text', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Text'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.mediaType is not None and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            outfile.write(' mediaType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mediaType), input_name='mediaType')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Text', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('mediaType', node)
        if value is not None and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            self.mediaType = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_Content.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        elif nodeName_ == 'renderMultiMedia':
            obj_ = StrucDoc_RenderMultiMedia.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'renderMultiMedia', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_renderMultiMedia'):
              self.add_renderMultiMedia(obj_.value)
            elif hasattr(self, 'set_renderMultiMedia'):
              self.set_renderMultiMedia(obj_.value)
        elif nodeName_ == 'paragraph':
            obj_ = StrucDoc_Paragraph.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'paragraph', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_paragraph'):
              self.add_paragraph(obj_.value)
            elif hasattr(self, 'set_paragraph'):
              self.set_paragraph(obj_.value)
        elif nodeName_ == 'list':
            obj_ = StrucDoc_List.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'list', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_list'):
              self.add_list(obj_.value)
            elif hasattr(self, 'set_list'):
              self.set_list(obj_.value)
        elif nodeName_ == 'table':
            obj_ = StrucDoc_Table.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'table', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_table'):
              self.add_table(obj_.value)
            elif hasattr(self, 'set_table'):
              self.set_table(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Text


class StrucDoc_Title(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, mediaType=None, content=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.mediaType = _cast(None, mediaType)
        if content is None:
            self.content = []
        else:
            self.content = content
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Title)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Title.subclass:
            return StrucDoc_Title.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Title(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_mediaType(self): return self.mediaType
    def set_mediaType(self, mediaType): self.mediaType = mediaType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Title', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Title')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Title', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Title'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.mediaType is not None and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            outfile.write(' mediaType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mediaType), input_name='mediaType')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Title', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('mediaType', node)
        if value is not None and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            self.mediaType = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_TitleContent.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_TitleFootnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Title


class StrucDoc_Caption(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, linkHtml=None, sub=None, sup=None, footnote=None, footnoteRef=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Caption)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Caption.subclass:
            return StrucDoc_Caption.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Caption(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.linkHtml or
            self.sub or
            self.sup or
            self.footnote or
            self.footnoteRef or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Caption', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Caption')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Caption', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Caption'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Caption', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Caption


class StrucDoc_Col(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, span='1', width=None, align=None, char=None, charoff=None, valign=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.span = _cast(None, span)
        self.width = _cast(None, width)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Col)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Col.subclass:
            return StrucDoc_Col.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Col(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_span(self): return self.span
    def set_span(self, span): self.span = span
    def get_width(self): return self.width
    def set_width(self, width): self.width = width
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Col', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Col')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Col', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Col'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.span != "1" and 'span' not in already_processed:
            already_processed.add('span')
            outfile.write(' span=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.span), input_name='span')), ))
        if self.width is not None and 'width' not in already_processed:
            already_processed.add('width')
            outfile.write(' width=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.width), input_name='width')), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Col', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('span', node)
        if value is not None and 'span' not in already_processed:
            already_processed.add('span')
            self.span = value
        value = find_attr_value_('width', node)
        if value is not None and 'width' not in already_processed:
            already_processed.add('width')
            self.width = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class StrucDoc_Col


class StrucDoc_Colgroup(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, span='1', width=None, align=None, char=None, charoff=None, valign=None, col=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.span = _cast(None, span)
        self.width = _cast(None, width)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
        if col is None:
            self.col = []
        else:
            self.col = col
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Colgroup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Colgroup.subclass:
            return StrucDoc_Colgroup.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Colgroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_col(self): return self.col
    def set_col(self, col): self.col = col
    def add_col(self, value): self.col.append(value)
    def insert_col_at(self, index, value): self.col.insert(index, value)
    def replace_col_at(self, index, value): self.col[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_span(self): return self.span
    def set_span(self, span): self.span = span
    def get_width(self): return self.width
    def set_width(self, width): self.width = width
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def hasContent_(self):
        if (
            self.col
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Colgroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Colgroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Colgroup', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Colgroup'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.span != "1" and 'span' not in already_processed:
            already_processed.add('span')
            outfile.write(' span=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.span), input_name='span')), ))
        if self.width is not None and 'width' not in already_processed:
            already_processed.add('width')
            outfile.write(' width=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.width), input_name='width')), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Colgroup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for col_ in self.col:
            col_.export(outfile, level, namespace_, name_='col', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('span', node)
        if value is not None and 'span' not in already_processed:
            already_processed.add('span')
            self.span = value
        value = find_attr_value_('width', node)
        if value is not None and 'width' not in already_processed:
            already_processed.add('width')
            self.width = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'col':
            obj_ = StrucDoc_Col.factory()
            obj_.build(child_)
            self.col.append(obj_)
            obj_.original_tagname_ = 'col'
# end class StrucDoc_Colgroup


class StrucDoc_Content(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, revised=None, content=None, linkHtml=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, renderMultiMedia=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.revised = _cast(None, revised)
        if content is None:
            self.content = []
        else:
            self.content = content
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        if renderMultiMedia is None:
            self.renderMultiMedia = []
        else:
            self.renderMultiMedia = renderMultiMedia
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Content)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Content.subclass:
            return StrucDoc_Content.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Content(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_renderMultiMedia(self): return self.renderMultiMedia
    def set_renderMultiMedia(self, renderMultiMedia): self.renderMultiMedia = renderMultiMedia
    def add_renderMultiMedia(self, value): self.renderMultiMedia.append(value)
    def insert_renderMultiMedia_at(self, index, value): self.renderMultiMedia.insert(index, value)
    def replace_renderMultiMedia_at(self, index, value): self.renderMultiMedia[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_revised(self): return self.revised
    def set_revised(self, revised): self.revised = revised
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.linkHtml or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            self.renderMultiMedia or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Content', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Content')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Content', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Content'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.revised is not None and 'revised' not in already_processed:
            already_processed.add('revised')
            outfile.write(' revised=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.revised), input_name='revised')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Content', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('revised', node)
        if value is not None and 'revised' not in already_processed:
            already_processed.add('revised')
            self.revised = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_Content.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        elif nodeName_ == 'renderMultiMedia':
            obj_ = StrucDoc_RenderMultiMedia.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'renderMultiMedia', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_renderMultiMedia'):
              self.add_renderMultiMedia(obj_.value)
            elif hasattr(self, 'set_renderMultiMedia'):
              self.set_renderMultiMedia(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Content


class StrucDoc_TitleContent(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, content=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        if content is None:
            self.content = []
        else:
            self.content = content
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_TitleContent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_TitleContent.subclass:
            return StrucDoc_TitleContent.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_TitleContent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.TitleContent', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.TitleContent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.TitleContent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.TitleContent'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.TitleContent', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_TitleContent.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_TitleFootnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_TitleContent


class StrucDoc_Footnote(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, content=None, linkHtml=None, sub=None, sup=None, br=None, renderMultiMedia=None, paragraph=None, list=None, table=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        if content is None:
            self.content = []
        else:
            self.content = content
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if renderMultiMedia is None:
            self.renderMultiMedia = []
        else:
            self.renderMultiMedia = renderMultiMedia
        if paragraph is None:
            self.paragraph = []
        else:
            self.paragraph = paragraph
        if list is None:
            self.list = []
        else:
            self.list = list
        if table is None:
            self.table = []
        else:
            self.table = table
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Footnote)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Footnote.subclass:
            return StrucDoc_Footnote.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Footnote(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_renderMultiMedia(self): return self.renderMultiMedia
    def set_renderMultiMedia(self, renderMultiMedia): self.renderMultiMedia = renderMultiMedia
    def add_renderMultiMedia(self, value): self.renderMultiMedia.append(value)
    def insert_renderMultiMedia_at(self, index, value): self.renderMultiMedia.insert(index, value)
    def replace_renderMultiMedia_at(self, index, value): self.renderMultiMedia[index] = value
    def get_paragraph(self): return self.paragraph
    def set_paragraph(self, paragraph): self.paragraph = paragraph
    def add_paragraph(self, value): self.paragraph.append(value)
    def insert_paragraph_at(self, index, value): self.paragraph.insert(index, value)
    def replace_paragraph_at(self, index, value): self.paragraph[index] = value
    def get_list(self): return self.list
    def set_list(self, list): self.list = list
    def add_list(self, value): self.list.append(value)
    def insert_list_at(self, index, value): self.list.insert(index, value)
    def replace_list_at(self, index, value): self.list[index] = value
    def get_table(self): return self.table
    def set_table(self, table): self.table = table
    def add_table(self, value): self.table.append(value)
    def insert_table_at(self, index, value): self.table.insert(index, value)
    def replace_table_at(self, index, value): self.table[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.linkHtml or
            self.sub or
            self.sup or
            self.br or
            self.renderMultiMedia or
            self.paragraph or
            self.list or
            self.table or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Footnote', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Footnote')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Footnote', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Footnote'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Footnote', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_Content.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'renderMultiMedia':
            obj_ = StrucDoc_RenderMultiMedia.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'renderMultiMedia', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_renderMultiMedia'):
              self.add_renderMultiMedia(obj_.value)
            elif hasattr(self, 'set_renderMultiMedia'):
              self.set_renderMultiMedia(obj_.value)
        elif nodeName_ == 'paragraph':
            obj_ = StrucDoc_Paragraph.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'paragraph', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_paragraph'):
              self.add_paragraph(obj_.value)
            elif hasattr(self, 'set_paragraph'):
              self.set_paragraph(obj_.value)
        elif nodeName_ == 'list':
            obj_ = StrucDoc_List.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'list', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_list'):
              self.add_list(obj_.value)
            elif hasattr(self, 'set_list'):
              self.set_list(obj_.value)
        elif nodeName_ == 'table':
            obj_ = StrucDoc_Table.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'table', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_table'):
              self.add_table(obj_.value)
            elif hasattr(self, 'set_table'):
              self.set_table(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Footnote


class StrucDoc_TitleFootnote(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, content=None, sub=None, sup=None, br=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        if content is None:
            self.content = []
        else:
            self.content = content
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_TitleFootnote)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_TitleFootnote.subclass:
            return StrucDoc_TitleFootnote.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_TitleFootnote(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.sub or
            self.sup or
            self.br or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.TitleFootnote', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.TitleFootnote')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.TitleFootnote', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.TitleFootnote'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.TitleFootnote', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_TitleContent.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_TitleFootnote


class StrucDoc_FootnoteRef(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, IDREF=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.IDREF = _cast(None, IDREF)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_FootnoteRef)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_FootnoteRef.subclass:
            return StrucDoc_FootnoteRef.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_FootnoteRef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_IDREF(self): return self.IDREF
    def set_IDREF(self, IDREF): self.IDREF = IDREF
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.FootnoteRef', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.FootnoteRef')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.FootnoteRef', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.FootnoteRef'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.IDREF is not None and 'IDREF' not in already_processed:
            already_processed.add('IDREF')
            outfile.write(' IDREF=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.IDREF), input_name='IDREF')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.FootnoteRef', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('IDREF', node)
        if value is not None and 'IDREF' not in already_processed:
            already_processed.add('IDREF')
            self.IDREF = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class StrucDoc_FootnoteRef


class StrucDoc_Item(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, caption=None, content=None, linkHtml=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, renderMultiMedia=None, paragraph=None, list=None, table=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.caption = caption
        if content is None:
            self.content = []
        else:
            self.content = content
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        if renderMultiMedia is None:
            self.renderMultiMedia = []
        else:
            self.renderMultiMedia = renderMultiMedia
        if paragraph is None:
            self.paragraph = []
        else:
            self.paragraph = paragraph
        if list is None:
            self.list = []
        else:
            self.list = list
        if table is None:
            self.table = []
        else:
            self.table = table
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Item)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Item.subclass:
            return StrucDoc_Item.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Item(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_caption(self): return self.caption
    def set_caption(self, caption): self.caption = caption
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_renderMultiMedia(self): return self.renderMultiMedia
    def set_renderMultiMedia(self, renderMultiMedia): self.renderMultiMedia = renderMultiMedia
    def add_renderMultiMedia(self, value): self.renderMultiMedia.append(value)
    def insert_renderMultiMedia_at(self, index, value): self.renderMultiMedia.insert(index, value)
    def replace_renderMultiMedia_at(self, index, value): self.renderMultiMedia[index] = value
    def get_paragraph(self): return self.paragraph
    def set_paragraph(self, paragraph): self.paragraph = paragraph
    def add_paragraph(self, value): self.paragraph.append(value)
    def insert_paragraph_at(self, index, value): self.paragraph.insert(index, value)
    def replace_paragraph_at(self, index, value): self.paragraph[index] = value
    def get_list(self): return self.list
    def set_list(self, list): self.list = list
    def add_list(self, value): self.list.append(value)
    def insert_list_at(self, index, value): self.list.insert(index, value)
    def replace_list_at(self, index, value): self.list[index] = value
    def get_table(self): return self.table
    def set_table(self, table): self.table = table
    def add_table(self, value): self.table.append(value)
    def insert_table_at(self, index, value): self.table.insert(index, value)
    def replace_table_at(self, index, value): self.table[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.caption is not None or
            self.content or
            self.linkHtml or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            self.renderMultiMedia or
            self.paragraph or
            self.list or
            self.table or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Item', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Item')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Item', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Item'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Item', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'caption':
            obj_ = StrucDoc_Caption.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'caption', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_caption'):
              self.add_caption(obj_.value)
            elif hasattr(self, 'set_caption'):
              self.set_caption(obj_.value)
        elif nodeName_ == 'content':
            obj_ = StrucDoc_Content.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        elif nodeName_ == 'renderMultiMedia':
            obj_ = StrucDoc_RenderMultiMedia.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'renderMultiMedia', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_renderMultiMedia'):
              self.add_renderMultiMedia(obj_.value)
            elif hasattr(self, 'set_renderMultiMedia'):
              self.set_renderMultiMedia(obj_.value)
        elif nodeName_ == 'paragraph':
            obj_ = StrucDoc_Paragraph.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'paragraph', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_paragraph'):
              self.add_paragraph(obj_.value)
            elif hasattr(self, 'set_paragraph'):
              self.set_paragraph(obj_.value)
        elif nodeName_ == 'list':
            obj_ = StrucDoc_List.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'list', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_list'):
              self.add_list(obj_.value)
            elif hasattr(self, 'set_list'):
              self.set_list(obj_.value)
        elif nodeName_ == 'table':
            obj_ = StrucDoc_Table.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'table', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_table'):
              self.add_table(obj_.value)
            elif hasattr(self, 'set_table'):
              self.set_table(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Item


class StrucDoc_LinkHtml(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, href=None, rel=None, rev=None, title=None, ID=None, language=None, styleCode=None, footnote=None, footnoteRef=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
        self.rev = _cast(None, rev)
        self.title = _cast(None, title)
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_LinkHtml)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_LinkHtml.subclass:
            return StrucDoc_LinkHtml.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_LinkHtml(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def get_rev(self): return self.rev
    def set_rev(self, rev): self.rev = rev
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.footnote or
            self.footnoteRef or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.LinkHtml', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.LinkHtml')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.LinkHtml', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.LinkHtml'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.href), input_name='href')), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.rel), input_name='rel')), ))
        if self.rev is not None and 'rev' not in already_processed:
            already_processed.add('rev')
            outfile.write(' rev=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.rev), input_name='rev')), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.title), input_name='title')), ))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.LinkHtml', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        value = find_attr_value_('rev', node)
        if value is not None and 'rev' not in already_processed:
            already_processed.add('rev')
            self.rev = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_LinkHtml


class StrucDoc_List(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, listType='unordered', caption=None, item=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.listType = _cast(None, listType)
        self.caption = caption
        if item is None:
            self.item = []
        else:
            self.item = item
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_List)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_List.subclass:
            return StrucDoc_List.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_List(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_caption(self): return self.caption
    def set_caption(self, caption): self.caption = caption
    def get_item(self): return self.item
    def set_item(self, item): self.item = item
    def add_item(self, value): self.item.append(value)
    def insert_item_at(self, index, value): self.item.insert(index, value)
    def replace_item_at(self, index, value): self.item[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_listType(self): return self.listType
    def set_listType(self, listType): self.listType = listType
    def hasContent_(self):
        if (
            self.caption is not None or
            self.item
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.List', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.List')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.List', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.List'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.listType != "unordered" and 'listType' not in already_processed:
            already_processed.add('listType')
            outfile.write(' listType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.listType), input_name='listType')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.List', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.caption is not None:
            self.caption.export(outfile, level, namespace_, name_='caption', pretty_print=pretty_print)
        for item_ in self.item:
            item_.export(outfile, level, namespace_, name_='item', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('listType', node)
        if value is not None and 'listType' not in already_processed:
            already_processed.add('listType')
            self.listType = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'caption':
            obj_ = StrucDoc_Caption.factory()
            obj_.build(child_)
            self.caption = obj_
            obj_.original_tagname_ = 'caption'
        elif nodeName_ == 'item':
            obj_ = StrucDoc_Item.factory()
            obj_.build(child_)
            self.item.append(obj_)
            obj_.original_tagname_ = 'item'
# end class StrucDoc_List


class StrucDoc_Paragraph(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, caption=None, content=None, linkHtml=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, renderMultiMedia=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.caption = caption
        if content is None:
            self.content = []
        else:
            self.content = content
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        if renderMultiMedia is None:
            self.renderMultiMedia = []
        else:
            self.renderMultiMedia = renderMultiMedia
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Paragraph)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Paragraph.subclass:
            return StrucDoc_Paragraph.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Paragraph(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_caption(self): return self.caption
    def set_caption(self, caption): self.caption = caption
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_renderMultiMedia(self): return self.renderMultiMedia
    def set_renderMultiMedia(self, renderMultiMedia): self.renderMultiMedia = renderMultiMedia
    def add_renderMultiMedia(self, value): self.renderMultiMedia.append(value)
    def insert_renderMultiMedia_at(self, index, value): self.renderMultiMedia.insert(index, value)
    def replace_renderMultiMedia_at(self, index, value): self.renderMultiMedia[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.caption is not None or
            self.content or
            self.linkHtml or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            self.renderMultiMedia or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Paragraph', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Paragraph')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Paragraph', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Paragraph'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Paragraph', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'caption':
            obj_ = StrucDoc_Caption.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'caption', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_caption'):
              self.add_caption(obj_.value)
            elif hasattr(self, 'set_caption'):
              self.set_caption(obj_.value)
        elif nodeName_ == 'content':
            obj_ = StrucDoc_Content.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        elif nodeName_ == 'renderMultiMedia':
            obj_ = StrucDoc_RenderMultiMedia.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'renderMultiMedia', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_renderMultiMedia'):
              self.add_renderMultiMedia(obj_.value)
            elif hasattr(self, 'set_renderMultiMedia'):
              self.set_renderMultiMedia(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Paragraph


class StrucDoc_RenderMultiMedia(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, referencedObject=None, ID=None, language=None, styleCode=None, caption=None):
        self.original_tagname_ = None
        self.referencedObject = _cast(None, referencedObject)
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.caption = caption
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_RenderMultiMedia)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_RenderMultiMedia.subclass:
            return StrucDoc_RenderMultiMedia.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_RenderMultiMedia(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_caption(self): return self.caption
    def set_caption(self, caption): self.caption = caption
    def get_referencedObject(self): return self.referencedObject
    def set_referencedObject(self, referencedObject): self.referencedObject = referencedObject
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def hasContent_(self):
        if (
            self.caption is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.RenderMultiMedia', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.RenderMultiMedia')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.RenderMultiMedia', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.RenderMultiMedia'):
        if self.referencedObject is not None and 'referencedObject' not in already_processed:
            already_processed.add('referencedObject')
            outfile.write(' referencedObject=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.referencedObject), input_name='referencedObject')), ))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.RenderMultiMedia', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.caption is not None:
            self.caption.export(outfile, level, namespace_, name_='caption', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('referencedObject', node)
        if value is not None and 'referencedObject' not in already_processed:
            already_processed.add('referencedObject')
            self.referencedObject = value
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'caption':
            obj_ = StrucDoc_Caption.factory()
            obj_.build(child_)
            self.caption = obj_
            obj_.original_tagname_ = 'caption'
# end class StrucDoc_RenderMultiMedia


class StrucDoc_Sub(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Sub)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Sub.subclass:
            return StrucDoc_Sub.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Sub(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Sub', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Sub')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Sub'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Sub', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class StrucDoc_Sub


class StrucDoc_Sup(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Sup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Sup.subclass:
            return StrucDoc_Sup.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Sup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Sup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Sup')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Sup'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Sup', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class StrucDoc_Sup


class StrucDoc_Table(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, summary=None, width=None, border=None, frame=None, rules=None, cellspacing=None, cellpadding=None, caption=None, col=None, colgroup=None, thead=None, tfoot=None, tbody=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.summary = _cast(None, summary)
        self.width = _cast(None, width)
        self.border = _cast(None, border)
        self.frame = _cast(None, frame)
        self.rules = _cast(None, rules)
        self.cellspacing = _cast(None, cellspacing)
        self.cellpadding = _cast(None, cellpadding)
        self.caption = caption
        if col is None:
            self.col = []
        else:
            self.col = col
        if colgroup is None:
            self.colgroup = []
        else:
            self.colgroup = colgroup
        self.thead = thead
        self.tfoot = tfoot
        if tbody is None:
            self.tbody = []
        else:
            self.tbody = tbody
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Table)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Table.subclass:
            return StrucDoc_Table.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Table(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_caption(self): return self.caption
    def set_caption(self, caption): self.caption = caption
    def get_col(self): return self.col
    def set_col(self, col): self.col = col
    def add_col(self, value): self.col.append(value)
    def insert_col_at(self, index, value): self.col.insert(index, value)
    def replace_col_at(self, index, value): self.col[index] = value
    def get_colgroup(self): return self.colgroup
    def set_colgroup(self, colgroup): self.colgroup = colgroup
    def add_colgroup(self, value): self.colgroup.append(value)
    def insert_colgroup_at(self, index, value): self.colgroup.insert(index, value)
    def replace_colgroup_at(self, index, value): self.colgroup[index] = value
    def get_thead(self): return self.thead
    def set_thead(self, thead): self.thead = thead
    def get_tfoot(self): return self.tfoot
    def set_tfoot(self, tfoot): self.tfoot = tfoot
    def get_tbody(self): return self.tbody
    def set_tbody(self, tbody): self.tbody = tbody
    def add_tbody(self, value): self.tbody.append(value)
    def insert_tbody_at(self, index, value): self.tbody.insert(index, value)
    def replace_tbody_at(self, index, value): self.tbody[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_width(self): return self.width
    def set_width(self, width): self.width = width
    def get_border(self): return self.border
    def set_border(self, border): self.border = border
    def get_frame(self): return self.frame
    def set_frame(self, frame): self.frame = frame
    def get_rules(self): return self.rules
    def set_rules(self, rules): self.rules = rules
    def get_cellspacing(self): return self.cellspacing
    def set_cellspacing(self, cellspacing): self.cellspacing = cellspacing
    def get_cellpadding(self): return self.cellpadding
    def set_cellpadding(self, cellpadding): self.cellpadding = cellpadding
    def hasContent_(self):
        if (
            self.caption is not None or
            self.col or
            self.colgroup or
            self.thead is not None or
            self.tfoot is not None or
            self.tbody
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Table', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Table')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Table', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Table'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.summary is not None and 'summary' not in already_processed:
            already_processed.add('summary')
            outfile.write(' summary=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.summary), input_name='summary')), ))
        if self.width is not None and 'width' not in already_processed:
            already_processed.add('width')
            outfile.write(' width=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.width), input_name='width')), ))
        if self.border is not None and 'border' not in already_processed:
            already_processed.add('border')
            outfile.write(' border=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.border), input_name='border')), ))
        if self.frame is not None and 'frame' not in already_processed:
            already_processed.add('frame')
            outfile.write(' frame=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.frame), input_name='frame')), ))
        if self.rules is not None and 'rules' not in already_processed:
            already_processed.add('rules')
            outfile.write(' rules=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.rules), input_name='rules')), ))
        if self.cellspacing is not None and 'cellspacing' not in already_processed:
            already_processed.add('cellspacing')
            outfile.write(' cellspacing=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.cellspacing), input_name='cellspacing')), ))
        if self.cellpadding is not None and 'cellpadding' not in already_processed:
            already_processed.add('cellpadding')
            outfile.write(' cellpadding=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.cellpadding), input_name='cellpadding')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Table', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.caption is not None:
            self.caption.export(outfile, level, namespace_, name_='caption', pretty_print=pretty_print)
        for col_ in self.col:
            col_.export(outfile, level, namespace_, name_='col', pretty_print=pretty_print)
        for colgroup_ in self.colgroup:
            colgroup_.export(outfile, level, namespace_, name_='colgroup', pretty_print=pretty_print)
        if self.thead is not None:
            self.thead.export(outfile, level, namespace_, name_='thead', pretty_print=pretty_print)
        if self.tfoot is not None:
            self.tfoot.export(outfile, level, namespace_, name_='tfoot', pretty_print=pretty_print)
        for tbody_ in self.tbody:
            tbody_.export(outfile, level, namespace_, name_='tbody', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('summary', node)
        if value is not None and 'summary' not in already_processed:
            already_processed.add('summary')
            self.summary = value
        value = find_attr_value_('width', node)
        if value is not None and 'width' not in already_processed:
            already_processed.add('width')
            self.width = value
        value = find_attr_value_('border', node)
        if value is not None and 'border' not in already_processed:
            already_processed.add('border')
            self.border = value
        value = find_attr_value_('frame', node)
        if value is not None and 'frame' not in already_processed:
            already_processed.add('frame')
            self.frame = value
        value = find_attr_value_('rules', node)
        if value is not None and 'rules' not in already_processed:
            already_processed.add('rules')
            self.rules = value
        value = find_attr_value_('cellspacing', node)
        if value is not None and 'cellspacing' not in already_processed:
            already_processed.add('cellspacing')
            self.cellspacing = value
        value = find_attr_value_('cellpadding', node)
        if value is not None and 'cellpadding' not in already_processed:
            already_processed.add('cellpadding')
            self.cellpadding = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'caption':
            obj_ = StrucDoc_Caption.factory()
            obj_.build(child_)
            self.caption = obj_
            obj_.original_tagname_ = 'caption'
        elif nodeName_ == 'col':
            obj_ = StrucDoc_Col.factory()
            obj_.build(child_)
            self.col.append(obj_)
            obj_.original_tagname_ = 'col'
        elif nodeName_ == 'colgroup':
            obj_ = StrucDoc_Colgroup.factory()
            obj_.build(child_)
            self.colgroup.append(obj_)
            obj_.original_tagname_ = 'colgroup'
        elif nodeName_ == 'thead':
            obj_ = StrucDoc_Thead.factory()
            obj_.build(child_)
            self.thead = obj_
            obj_.original_tagname_ = 'thead'
        elif nodeName_ == 'tfoot':
            obj_ = StrucDoc_Tfoot.factory()
            obj_.build(child_)
            self.tfoot = obj_
            obj_.original_tagname_ = 'tfoot'
        elif nodeName_ == 'tbody':
            obj_ = StrucDoc_Tbody.factory()
            obj_.build(child_)
            self.tbody.append(obj_)
            obj_.original_tagname_ = 'tbody'
# end class StrucDoc_Table


class StrucDoc_Tbody(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, align=None, char=None, charoff=None, valign=None, tr=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
        if tr is None:
            self.tr = []
        else:
            self.tr = tr
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Tbody)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Tbody.subclass:
            return StrucDoc_Tbody.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Tbody(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tr(self): return self.tr
    def set_tr(self, tr): self.tr = tr
    def add_tr(self, value): self.tr.append(value)
    def insert_tr_at(self, index, value): self.tr.insert(index, value)
    def replace_tr_at(self, index, value): self.tr[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def hasContent_(self):
        if (
            self.tr
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Tbody', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Tbody')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Tbody', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Tbody'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Tbody', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for tr_ in self.tr:
            tr_.export(outfile, level, namespace_, name_='tr', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tr':
            obj_ = StrucDoc_Tr.factory()
            obj_.build(child_)
            self.tr.append(obj_)
            obj_.original_tagname_ = 'tr'
# end class StrucDoc_Tbody


class StrucDoc_Td(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, abbr=None, axis=None, headers=None, scope=None, rowspan='1', colspan='1', align=None, char=None, charoff=None, valign=None, content=None, linkHtml=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, renderMultiMedia=None, paragraph=None, list=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.abbr = _cast(None, abbr)
        self.axis = _cast(None, axis)
        self.headers = _cast(None, headers)
        self.scope = _cast(None, scope)
        self.rowspan = _cast(None, rowspan)
        self.colspan = _cast(None, colspan)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
        if content is None:
            self.content = []
        else:
            self.content = content
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        if renderMultiMedia is None:
            self.renderMultiMedia = []
        else:
            self.renderMultiMedia = renderMultiMedia
        if paragraph is None:
            self.paragraph = []
        else:
            self.paragraph = paragraph
        if list is None:
            self.list = []
        else:
            self.list = list
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Td)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Td.subclass:
            return StrucDoc_Td.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Td(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_renderMultiMedia(self): return self.renderMultiMedia
    def set_renderMultiMedia(self, renderMultiMedia): self.renderMultiMedia = renderMultiMedia
    def add_renderMultiMedia(self, value): self.renderMultiMedia.append(value)
    def insert_renderMultiMedia_at(self, index, value): self.renderMultiMedia.insert(index, value)
    def replace_renderMultiMedia_at(self, index, value): self.renderMultiMedia[index] = value
    def get_paragraph(self): return self.paragraph
    def set_paragraph(self, paragraph): self.paragraph = paragraph
    def add_paragraph(self, value): self.paragraph.append(value)
    def insert_paragraph_at(self, index, value): self.paragraph.insert(index, value)
    def replace_paragraph_at(self, index, value): self.paragraph[index] = value
    def get_list(self): return self.list
    def set_list(self, list): self.list = list
    def add_list(self, value): self.list.append(value)
    def insert_list_at(self, index, value): self.list.insert(index, value)
    def replace_list_at(self, index, value): self.list[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_abbr(self): return self.abbr
    def set_abbr(self, abbr): self.abbr = abbr
    def get_axis(self): return self.axis
    def set_axis(self, axis): self.axis = axis
    def get_headers(self): return self.headers
    def set_headers(self, headers): self.headers = headers
    def get_scope(self): return self.scope
    def set_scope(self, scope): self.scope = scope
    def get_rowspan(self): return self.rowspan
    def set_rowspan(self, rowspan): self.rowspan = rowspan
    def get_colspan(self): return self.colspan
    def set_colspan(self, colspan): self.colspan = colspan
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.linkHtml or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            self.renderMultiMedia or
            self.paragraph or
            self.list or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Td', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Td')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Td', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Td'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.abbr is not None and 'abbr' not in already_processed:
            already_processed.add('abbr')
            outfile.write(' abbr=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.abbr), input_name='abbr')), ))
        if self.axis is not None and 'axis' not in already_processed:
            already_processed.add('axis')
            outfile.write(' axis=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.axis), input_name='axis')), ))
        if self.headers is not None and 'headers' not in already_processed:
            already_processed.add('headers')
            outfile.write(' headers=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.headers), input_name='headers')), ))
        if self.scope is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
        if self.rowspan != "1" and 'rowspan' not in already_processed:
            already_processed.add('rowspan')
            outfile.write(' rowspan=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.rowspan), input_name='rowspan')), ))
        if self.colspan != "1" and 'colspan' not in already_processed:
            already_processed.add('colspan')
            outfile.write(' colspan=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.colspan), input_name='colspan')), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Td', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('abbr', node)
        if value is not None and 'abbr' not in already_processed:
            already_processed.add('abbr')
            self.abbr = value
        value = find_attr_value_('axis', node)
        if value is not None and 'axis' not in already_processed:
            already_processed.add('axis')
            self.axis = value
        value = find_attr_value_('headers', node)
        if value is not None and 'headers' not in already_processed:
            already_processed.add('headers')
            self.headers = value
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
        value = find_attr_value_('rowspan', node)
        if value is not None and 'rowspan' not in already_processed:
            already_processed.add('rowspan')
            self.rowspan = value
        value = find_attr_value_('colspan', node)
        if value is not None and 'colspan' not in already_processed:
            already_processed.add('colspan')
            self.colspan = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_Content.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        elif nodeName_ == 'renderMultiMedia':
            obj_ = StrucDoc_RenderMultiMedia.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'renderMultiMedia', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_renderMultiMedia'):
              self.add_renderMultiMedia(obj_.value)
            elif hasattr(self, 'set_renderMultiMedia'):
              self.set_renderMultiMedia(obj_.value)
        elif nodeName_ == 'paragraph':
            obj_ = StrucDoc_Paragraph.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'paragraph', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_paragraph'):
              self.add_paragraph(obj_.value)
            elif hasattr(self, 'set_paragraph'):
              self.set_paragraph(obj_.value)
        elif nodeName_ == 'list':
            obj_ = StrucDoc_List.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'list', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_list'):
              self.add_list(obj_.value)
            elif hasattr(self, 'set_list'):
              self.set_list(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Td


class StrucDoc_Tfoot(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, align=None, char=None, charoff=None, valign=None, tr=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
        if tr is None:
            self.tr = []
        else:
            self.tr = tr
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Tfoot)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Tfoot.subclass:
            return StrucDoc_Tfoot.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Tfoot(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tr(self): return self.tr
    def set_tr(self, tr): self.tr = tr
    def add_tr(self, value): self.tr.append(value)
    def insert_tr_at(self, index, value): self.tr.insert(index, value)
    def replace_tr_at(self, index, value): self.tr[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def hasContent_(self):
        if (
            self.tr
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Tfoot', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Tfoot')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Tfoot', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Tfoot'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Tfoot', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for tr_ in self.tr:
            tr_.export(outfile, level, namespace_, name_='tr', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tr':
            obj_ = StrucDoc_Tr.factory()
            obj_.build(child_)
            self.tr.append(obj_)
            obj_.original_tagname_ = 'tr'
# end class StrucDoc_Tfoot


class StrucDoc_Th(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, abbr=None, axis=None, headers=None, scope=None, rowspan='1', colspan='1', align=None, char=None, charoff=None, valign=None, content=None, linkHtml=None, sub=None, sup=None, br=None, footnote=None, footnoteRef=None, renderMultiMedia=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.abbr = _cast(None, abbr)
        self.axis = _cast(None, axis)
        self.headers = _cast(None, headers)
        self.scope = _cast(None, scope)
        self.rowspan = _cast(None, rowspan)
        self.colspan = _cast(None, colspan)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
        if content is None:
            self.content = []
        else:
            self.content = content
        if linkHtml is None:
            self.linkHtml = []
        else:
            self.linkHtml = linkHtml
        if sub is None:
            self.sub = []
        else:
            self.sub = sub
        if sup is None:
            self.sup = []
        else:
            self.sup = sup
        if br is None:
            self.br = []
        else:
            self.br = br
        if footnote is None:
            self.footnote = []
        else:
            self.footnote = footnote
        if footnoteRef is None:
            self.footnoteRef = []
        else:
            self.footnoteRef = footnoteRef
        if renderMultiMedia is None:
            self.renderMultiMedia = []
        else:
            self.renderMultiMedia = renderMultiMedia
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Th)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Th.subclass:
            return StrucDoc_Th.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Th(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def add_content(self, value): self.content.append(value)
    def insert_content_at(self, index, value): self.content.insert(index, value)
    def replace_content_at(self, index, value): self.content[index] = value
    def get_linkHtml(self): return self.linkHtml
    def set_linkHtml(self, linkHtml): self.linkHtml = linkHtml
    def add_linkHtml(self, value): self.linkHtml.append(value)
    def insert_linkHtml_at(self, index, value): self.linkHtml.insert(index, value)
    def replace_linkHtml_at(self, index, value): self.linkHtml[index] = value
    def get_sub(self): return self.sub
    def set_sub(self, sub): self.sub = sub
    def add_sub(self, value): self.sub.append(value)
    def insert_sub_at(self, index, value): self.sub.insert(index, value)
    def replace_sub_at(self, index, value): self.sub[index] = value
    def get_sup(self): return self.sup
    def set_sup(self, sup): self.sup = sup
    def add_sup(self, value): self.sup.append(value)
    def insert_sup_at(self, index, value): self.sup.insert(index, value)
    def replace_sup_at(self, index, value): self.sup[index] = value
    def get_br(self): return self.br
    def set_br(self, br): self.br = br
    def add_br(self, value): self.br.append(value)
    def insert_br_at(self, index, value): self.br.insert(index, value)
    def replace_br_at(self, index, value): self.br[index] = value
    def get_footnote(self): return self.footnote
    def set_footnote(self, footnote): self.footnote = footnote
    def add_footnote(self, value): self.footnote.append(value)
    def insert_footnote_at(self, index, value): self.footnote.insert(index, value)
    def replace_footnote_at(self, index, value): self.footnote[index] = value
    def get_footnoteRef(self): return self.footnoteRef
    def set_footnoteRef(self, footnoteRef): self.footnoteRef = footnoteRef
    def add_footnoteRef(self, value): self.footnoteRef.append(value)
    def insert_footnoteRef_at(self, index, value): self.footnoteRef.insert(index, value)
    def replace_footnoteRef_at(self, index, value): self.footnoteRef[index] = value
    def get_renderMultiMedia(self): return self.renderMultiMedia
    def set_renderMultiMedia(self, renderMultiMedia): self.renderMultiMedia = renderMultiMedia
    def add_renderMultiMedia(self, value): self.renderMultiMedia.append(value)
    def insert_renderMultiMedia_at(self, index, value): self.renderMultiMedia.insert(index, value)
    def replace_renderMultiMedia_at(self, index, value): self.renderMultiMedia[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_abbr(self): return self.abbr
    def set_abbr(self, abbr): self.abbr = abbr
    def get_axis(self): return self.axis
    def set_axis(self, axis): self.axis = axis
    def get_headers(self): return self.headers
    def set_headers(self, headers): self.headers = headers
    def get_scope(self): return self.scope
    def set_scope(self, scope): self.scope = scope
    def get_rowspan(self): return self.rowspan
    def set_rowspan(self, rowspan): self.rowspan = rowspan
    def get_colspan(self): return self.colspan
    def set_colspan(self, colspan): self.colspan = colspan
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_StrucDoc_Br(self, value):
        # Validate type StrucDoc.Br, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 0:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on StrucDoc.Br' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.content or
            self.linkHtml or
            self.sub or
            self.sup or
            self.br or
            self.footnote or
            self.footnoteRef or
            self.renderMultiMedia or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Th', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Th')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Th', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Th'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.abbr is not None and 'abbr' not in already_processed:
            already_processed.add('abbr')
            outfile.write(' abbr=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.abbr), input_name='abbr')), ))
        if self.axis is not None and 'axis' not in already_processed:
            already_processed.add('axis')
            outfile.write(' axis=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.axis), input_name='axis')), ))
        if self.headers is not None and 'headers' not in already_processed:
            already_processed.add('headers')
            outfile.write(' headers=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.headers), input_name='headers')), ))
        if self.scope is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.scope), input_name='scope')), ))
        if self.rowspan != "1" and 'rowspan' not in already_processed:
            already_processed.add('rowspan')
            outfile.write(' rowspan=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.rowspan), input_name='rowspan')), ))
        if self.colspan != "1" and 'colspan' not in already_processed:
            already_processed.add('colspan')
            outfile.write(' colspan=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.colspan), input_name='colspan')), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Th', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('abbr', node)
        if value is not None and 'abbr' not in already_processed:
            already_processed.add('abbr')
            self.abbr = value
        value = find_attr_value_('axis', node)
        if value is not None and 'axis' not in already_processed:
            already_processed.add('axis')
            self.axis = value
        value = find_attr_value_('headers', node)
        if value is not None and 'headers' not in already_processed:
            already_processed.add('headers')
            self.headers = value
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
        value = find_attr_value_('rowspan', node)
        if value is not None and 'rowspan' not in already_processed:
            already_processed.add('rowspan')
            self.rowspan = value
        value = find_attr_value_('colspan', node)
        if value is not None and 'colspan' not in already_processed:
            already_processed.add('colspan')
            self.colspan = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'content':
            obj_ = StrucDoc_Content.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'content', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_content'):
              self.add_content(obj_.value)
            elif hasattr(self, 'set_content'):
              self.set_content(obj_.value)
        elif nodeName_ == 'linkHtml':
            obj_ = StrucDoc_LinkHtml.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linkHtml', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linkHtml'):
              self.add_linkHtml(obj_.value)
            elif hasattr(self, 'set_linkHtml'):
              self.set_linkHtml(obj_.value)
        elif nodeName_ == 'sub':
            obj_ = StrucDoc_Sub.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sub'):
              self.add_sub(obj_.value)
            elif hasattr(self, 'set_sub'):
              self.set_sub(obj_.value)
        elif nodeName_ == 'sup':
            obj_ = StrucDoc_Sup.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sup', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sup'):
              self.add_sup(obj_.value)
            elif hasattr(self, 'set_sup'):
              self.set_sup(obj_.value)
        elif nodeName_ == 'br' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'br', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'footnote':
            obj_ = StrucDoc_Footnote.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnote'):
              self.add_footnote(obj_.value)
            elif hasattr(self, 'set_footnote'):
              self.set_footnote(obj_.value)
        elif nodeName_ == 'footnoteRef':
            obj_ = StrucDoc_FootnoteRef.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'footnoteRef', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_footnoteRef'):
              self.add_footnoteRef(obj_.value)
            elif hasattr(self, 'set_footnoteRef'):
              self.set_footnoteRef(obj_.value)
        elif nodeName_ == 'renderMultiMedia':
            obj_ = StrucDoc_RenderMultiMedia.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'renderMultiMedia', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_renderMultiMedia'):
              self.add_renderMultiMedia(obj_.value)
            elif hasattr(self, 'set_renderMultiMedia'):
              self.set_renderMultiMedia(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class StrucDoc_Th


class StrucDoc_Thead(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, align=None, char=None, charoff=None, valign=None, tr=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
        if tr is None:
            self.tr = []
        else:
            self.tr = tr
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Thead)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Thead.subclass:
            return StrucDoc_Thead.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Thead(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tr(self): return self.tr
    def set_tr(self, tr): self.tr = tr
    def add_tr(self, value): self.tr.append(value)
    def insert_tr_at(self, index, value): self.tr.insert(index, value)
    def replace_tr_at(self, index, value): self.tr[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def hasContent_(self):
        if (
            self.tr
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Thead', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Thead')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Thead', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Thead'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Thead', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for tr_ in self.tr:
            tr_.export(outfile, level, namespace_, name_='tr', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tr':
            obj_ = StrucDoc_Tr.factory()
            obj_.build(child_)
            self.tr.append(obj_)
            obj_.original_tagname_ = 'tr'
# end class StrucDoc_Thead


class StrucDoc_Tr(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, language=None, styleCode=None, align=None, char=None, charoff=None, valign=None, th=None, td=None):
        self.original_tagname_ = None
        self.ID = _cast(None, ID)
        self.language = _cast(None, language)
        self.styleCode = _cast(None, styleCode)
        self.align = _cast(None, align)
        self.char = _cast(None, char)
        self.charoff = _cast(None, charoff)
        self.valign = _cast(None, valign)
        if th is None:
            self.th = []
        else:
            self.th = th
        if td is None:
            self.td = []
        else:
            self.td = td
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StrucDoc_Tr)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StrucDoc_Tr.subclass:
            return StrucDoc_Tr.subclass(*args_, **kwargs_)
        else:
            return StrucDoc_Tr(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_th(self): return self.th
    def set_th(self, th): self.th = th
    def add_th(self, value): self.th.append(value)
    def insert_th_at(self, index, value): self.th.insert(index, value)
    def replace_th_at(self, index, value): self.th[index] = value
    def get_td(self): return self.td
    def set_td(self, td): self.td = td
    def add_td(self, value): self.td.append(value)
    def insert_td_at(self, index, value): self.td.insert(index, value)
    def replace_td_at(self, index, value): self.td[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_styleCode(self): return self.styleCode
    def set_styleCode(self, styleCode): self.styleCode = styleCode
    def get_align(self): return self.align
    def set_align(self, align): self.align = align
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_charoff(self): return self.charoff
    def set_charoff(self, charoff): self.charoff = charoff
    def get_valign(self): return self.valign
    def set_valign(self, valign): self.valign = valign
    def hasContent_(self):
        if (
            self.th or
            self.td
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StrucDoc.Tr', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StrucDoc.Tr')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StrucDoc.Tr', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StrucDoc.Tr'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.language), input_name='language')), ))
        if self.styleCode is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            outfile.write(' styleCode=%s' % (quote_attrib(self.styleCode), ))
        if self.align is not None and 'align' not in already_processed:
            already_processed.add('align')
            outfile.write(' align=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.align), input_name='align')), ))
        if self.char is not None and 'char' not in already_processed:
            already_processed.add('char')
            outfile.write(' char=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.char), input_name='char')), ))
        if self.charoff is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            outfile.write(' charoff=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.charoff), input_name='charoff')), ))
        if self.valign is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            outfile.write(' valign=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.valign), input_name='valign')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StrucDoc.Tr', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for th_ in self.th:
            th_.export(outfile, level, namespace_, name_='th', pretty_print=pretty_print)
        for td_ in self.td:
            td_.export(outfile, level, namespace_, name_='td', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('styleCode', node)
        if value is not None and 'styleCode' not in already_processed:
            already_processed.add('styleCode')
            self.styleCode = value
        value = find_attr_value_('align', node)
        if value is not None and 'align' not in already_processed:
            already_processed.add('align')
            self.align = value
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.add('char')
            self.char = value
        value = find_attr_value_('charoff', node)
        if value is not None and 'charoff' not in already_processed:
            already_processed.add('charoff')
            self.charoff = value
        value = find_attr_value_('valign', node)
        if value is not None and 'valign' not in already_processed:
            already_processed.add('valign')
            self.valign = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'th':
            obj_ = StrucDoc_Th.factory()
            obj_.build(child_)
            self.th.append(obj_)
            obj_.original_tagname_ = 'th'
        elif nodeName_ == 'td':
            obj_ = StrucDoc_Td.factory()
            obj_.build(child_)
            self.td.append(obj_)
            obj_.original_tagname_ = 'td'
# end class StrucDoc_Tr


class ANY(GeneratedsSuper):
    """Defines the basic properties of every data value. This is an
    abstract type, meaning that no value can be just a data value
    without belonging to any concrete type. Every concrete type is a
    specialization of this general abstract DataValue type. An
    exceptional value expressing missing information and possibly
    the reason why the information is missing. An exceptional value
    that applies to the set, bag or list expressing missing
    information and possibly the reason why the information is
    missing. This attribute can only be used when the element is
    part of a collection. This attribute specifies the data type
    flavor that applies to this value. Allows a sending system to
    identify to a receiving system the changes that have occurred in
    an object controlled by the sending system, or the changes that
    the sender desires to be made in an object controlled by the
    receiving system."""
    subclass = None
    superclass = None
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.collectionNullFlavor = _cast(None, collectionNullFlavor)
        self.flavorId = _cast(None, flavorId)
        self.updateMode = _cast(None, updateMode)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ANY)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ANY.subclass:
            return ANY.subclass(*args_, **kwargs_)
        else:
            return ANY(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_collectionNullFlavor(self): return self.collectionNullFlavor
    def set_collectionNullFlavor(self, collectionNullFlavor): self.collectionNullFlavor = collectionNullFlavor
    def get_flavorId(self): return self.flavorId
    def set_flavorId(self, flavorId): self.flavorId = flavorId
    def get_updateMode(self): return self.updateMode
    def set_updateMode(self, updateMode): self.updateMode = updateMode
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_UpdateMode(self, value):
        # Validate type UpdateMode, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['A', 'AR', 'D', 'K', 'N', 'R', 'REF', 'U']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on UpdateMode' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_UpdateMode_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_UpdateMode_patterns_, ))
    validate_UpdateMode_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ANY', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ANY')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ANY'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.collectionNullFlavor is not None and 'collectionNullFlavor' not in already_processed:
            already_processed.add('collectionNullFlavor')
            outfile.write(' collectionNullFlavor=%s' % (quote_attrib(self.collectionNullFlavor), ))
        if self.flavorId is not None and 'flavorId' not in already_processed:
            already_processed.add('flavorId')
            outfile.write(' flavorId=%s' % (quote_attrib(self.flavorId), ))
        if self.updateMode is not None and 'updateMode' not in already_processed:
            already_processed.add('updateMode')
            outfile.write(' updateMode=%s' % (quote_attrib(self.updateMode), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ANY', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('collectionNullFlavor', node)
        if value is not None and 'collectionNullFlavor' not in already_processed:
            already_processed.add('collectionNullFlavor')
            self.collectionNullFlavor = value
            self.validate_NullFlavor(self.collectionNullFlavor)    # validate type NullFlavor
        value = find_attr_value_('flavorId', node)
        if value is not None and 'flavorId' not in already_processed:
            already_processed.add('flavorId')
            self.flavorId = value
            self.validate_st(self.flavorId)    # validate type st
        value = find_attr_value_('updateMode', node)
        if value is not None and 'updateMode' not in already_processed:
            already_processed.add('updateMode')
            self.updateMode = value
            self.validate_UpdateMode(self.updateMode)    # validate type UpdateMode
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class ANY


class BL(ANY):
    """The Boolean type stands for the values of two-valued logic. A
    Boolean value can be either true or false, or, as any other
    value may be NULL."""
    subclass = None
    superclass = ANY
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, value=None):
        self.original_tagname_ = None
        super(BL, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, )
        self.value = _cast(None, value)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BL.subclass:
            return BL.subclass(*args_, **kwargs_)
        else:
            return BL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            super(BL, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BL')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BL', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BL'):
        super(BL, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BL')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def exportChildren(self, outfile, level, namespace_='', name_='BL', fromsubclass_=False, pretty_print=True):
        super(BL, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            if value in ('true', '1'):
                self.value = True
            elif value in ('false', '0'):
                self.value = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.value)    # validate type bl
        super(BL, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BL, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BL


class ANYNonNull(ANY):
    """The BooleanNonNull type is used where a Boolean cannot have a null
    value. A Boolean value can be either true or false."""
    subclass = None
    superclass = ANY
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ANYNonNull, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, extensiontype_, )
        self.nullFlavor = _cast(None, nullFlavor)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ANYNonNull)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ANYNonNull.subclass:
            return ANYNonNull.subclass(*args_, **kwargs_)
        else:
            return ANYNonNull(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nullFlavor(self): return self.nullFlavor
    def set_nullFlavor(self, nullFlavor): self.nullFlavor = nullFlavor
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ASKU', 'DER', 'INV', 'MSK', 'NA', 'NASK', 'NAV', 'NI', 'NINF', 'OTH', 'PINF', 'QS', 'TRC', 'UNC', 'UNK']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullFlavor' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_NullFlavor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NullFlavor_patterns_, ))
    validate_NullFlavor_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            super(ANYNonNull, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ANYNonNull', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ANYNonNull')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ANYNonNull', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ANYNonNull'):
        super(ANYNonNull, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ANYNonNull')
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ANYNonNull', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ANYNonNull, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ANYNonNull


class BN(ANYNonNull):
    """The BooleanNonNull type is used where a Boolean cannot have a null
    value. A Boolean value can be either true or false."""
    subclass = None
    superclass = ANYNonNull
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, value=None):
        self.original_tagname_ = None
        super(BN, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, )
        self.value = _cast(None, value)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BN)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BN.subclass:
            return BN.subclass(*args_, **kwargs_)
        else:
            return BN(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def validate_bn(self, value):
        # Validate type bn, a restriction on bl.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bn_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bn_patterns_, ))
    validate_bn_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            super(BN, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BN', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BN')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BN', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BN'):
        super(BN, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BN')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def exportChildren(self, outfile, level, namespace_='', name_='BN', fromsubclass_=False, pretty_print=True):
        super(BN, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_bn(self.value)    # validate type bn
        super(BN, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BN, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BN


class BIN(ANY):
    """Binary data is a raw block of bits. Binary data is a protected type
    that MUST not be used outside the data type specification.
    Specifies the representation of the binary data that is the
    content of the binary data value."""
    subclass = None
    superclass = ANY
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BIN, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, valueOf_, mixedclass_, content_, extensiontype_, )
        self.representation = _cast(None, representation)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BIN)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BIN.subclass:
            return BIN.subclass(*args_, **kwargs_)
        else:
            return BIN(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_representation(self): return self.representation
    def set_representation(self, representation): self.representation = representation
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_BinaryDataEncoding(self, value):
        # Validate type BinaryDataEncoding, a restriction on xs:NMTOKEN.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['B64', 'TXT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on BinaryDataEncoding' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(BIN, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BIN', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BIN')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BIN'):
        super(BIN, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BIN')
        if self.representation != "TXT" and 'representation' not in already_processed:
            already_processed.add('representation')
            outfile.write(' representation=%s' % (quote_attrib(self.representation), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BIN', fromsubclass_=False, pretty_print=True):
        super(BIN, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('representation', node)
        if value is not None and 'representation' not in already_processed:
            already_processed.add('representation')
            self.representation = value
            self.validate_BinaryDataEncoding(self.representation)    # validate type BinaryDataEncoding
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BIN, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(BIN, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BIN


class ED(BIN):
    """Data that is primarily intended for human interpretation or for
    further machine processing is outside the scope of HL7. This
    includes unformatted or formatted written language, multimedia
    data, or structured information as defined by a different
    standard (e.g., XML-signatures.) Instead of the data itself, an
    ED may contain only a reference (see TEL.) Note that the ST data
    type is a specialization of ED when the is text/plain. When the
    content is text/plain, the content may appear either as the text
    content of the element, or in the value attribute, but not both.
    The plain text content of the ED. Note that plain text content
    may appear in either the value attribute or the text content of
    the element, but not both. Identifies the type of the
    encapsulated data and identifies a method to interpret or render
    the data. For character based information the language property
    specifies the human language of the text. Indicates whether the
    raw byte data is compressed, and what compression algorithm was
    used. The integrity check is a short binary value representing a
    cryptographically strong checksum that is calculated over the
    binary data. The purpose of this property, when communicated
    with a reference is for anyone to validate later whether the
    reference still resolved to the same data that the reference
    resolved to when the encapsulated data value with reference was
    created. Specifies the algorithm used to compute the
    integrityCheck value. A stand-in for the full media for use as
    an alternative description of the media where the media is not
    accessible for display."""
    subclass = None
    superclass = BIN
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, valueOf_=None, mixedclass_=None, content_=None, *args):
        self.original_tagname_ = None
        super(ED, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, valueOf_, mixedclass_, content_, )
        self.value = _cast(None, value)
        self.mediaType = _cast(None, mediaType)
        self.language = _cast(None, language)
        self.compression = _cast(None, compression)
        self.integrityCheck = _cast(None, integrityCheck)
        self.integrityCheckAlgorithm = _cast(None, integrityCheckAlgorithm)
        self.description = _cast(None, description)
        self.reference = reference
        self.thumbnail = thumbnail
        if translation is None:
            self.translation = []
        else:
            self.translation = translation
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ED)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ED.subclass:
            return ED.subclass(*args_, **kwargs_)
        else:
            return ED(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reference(self): return self.reference
    def set_reference(self, reference): self.reference = reference
    def get_thumbnail(self): return self.thumbnail
    def set_thumbnail(self, thumbnail): self.thumbnail = thumbnail
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def add_translation(self, value): self.translation.append(value)
    def insert_translation_at(self, index, value): self.translation.insert(index, value)
    def replace_translation_at(self, index, value): self.translation[index] = value
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_mediaType(self): return self.mediaType
    def set_mediaType(self, mediaType): self.mediaType = mediaType
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_compression(self): return self.compression
    def set_compression(self, compression): self.compression = compression
    def get_integrityCheck(self): return self.integrityCheck
    def set_integrityCheck(self, integrityCheck): self.integrityCheck = integrityCheck
    def get_integrityCheckAlgorithm(self): return self.integrityCheckAlgorithm
    def set_integrityCheckAlgorithm(self, integrityCheckAlgorithm): self.integrityCheckAlgorithm = integrityCheckAlgorithm
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_CompressionAlgorithm(self, value):
        # Validate type CompressionAlgorithm, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['BZ', 'DF', 'GZ', 'Z', 'Z7', 'ZL']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on CompressionAlgorithm' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_CompressionAlgorithm_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_CompressionAlgorithm_patterns_, ))
    validate_CompressionAlgorithm_patterns_ = [['^[^\\s]+$']]
    def validate_bin(self, value):
        # Validate type bin, a restriction on xs:base64Binary.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_IntegrityCheckAlgorithm(self, value):
        # Validate type IntegrityCheckAlgorithm, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SHA-1', 'SHA-256']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on IntegrityCheckAlgorithm' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_IntegrityCheckAlgorithm_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_IntegrityCheckAlgorithm_patterns_, ))
    validate_IntegrityCheckAlgorithm_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.reference is not None or
            self.thumbnail is not None or
            self.translation or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(ED, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ED', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ED')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ED', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ED'):
        super(ED, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ED')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
        if self.mediaType != "text/plain" and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            outfile.write(' mediaType=%s' % (quote_attrib(self.mediaType), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (quote_attrib(self.language), ))
        if self.compression is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            outfile.write(' compression=%s' % (quote_attrib(self.compression), ))
        if self.integrityCheck is not None and 'integrityCheck' not in already_processed:
            already_processed.add('integrityCheck')
            outfile.write(' integrityCheck=%s' % (quote_attrib(self.integrityCheck), ))
        if self.integrityCheckAlgorithm != "SHA-1" and 'integrityCheckAlgorithm' not in already_processed:
            already_processed.add('integrityCheckAlgorithm')
            outfile.write(' integrityCheckAlgorithm=%s' % (quote_attrib(self.integrityCheckAlgorithm), ))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            outfile.write(' description=%s' % (quote_attrib(self.description), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ED', fromsubclass_=False, pretty_print=True):
        super(ED, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_st(self.value)    # validate type st
        value = find_attr_value_('mediaType', node)
        if value is not None and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            self.mediaType = value
            self.mediaType = ' '.join(self.mediaType.split())
            self.validate_cs(self.mediaType)    # validate type cs
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
            self.language = ' '.join(self.language.split())
            self.validate_cs(self.language)    # validate type cs
        value = find_attr_value_('compression', node)
        if value is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            self.compression = value
            self.validate_CompressionAlgorithm(self.compression)    # validate type CompressionAlgorithm
        value = find_attr_value_('integrityCheck', node)
        if value is not None and 'integrityCheck' not in already_processed:
            already_processed.add('integrityCheck')
            self.integrityCheck = value
            self.validate_bin(self.integrityCheck)    # validate type bin
        value = find_attr_value_('integrityCheckAlgorithm', node)
        if value is not None and 'integrityCheckAlgorithm' not in already_processed:
            already_processed.add('integrityCheckAlgorithm')
            self.integrityCheckAlgorithm = value
            self.validate_IntegrityCheckAlgorithm(self.integrityCheckAlgorithm)    # validate type IntegrityCheckAlgorithm
        value = find_attr_value_('description', node)
        if value is not None and 'description' not in already_processed:
            already_processed.add('description')
            self.description = value
            self.validate_st(self.description)    # validate type st
        super(ED, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reference':
            obj_ = TEL.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'reference', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_reference'):
              self.add_reference(obj_.value)
            elif hasattr(self, 'set_reference'):
              self.set_reference(obj_.value)
        elif nodeName_ == 'thumbnail':
            obj_ = thumbnail.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'thumbnail', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_thumbnail'):
              self.add_thumbnail(obj_.value)
            elif hasattr(self, 'set_thumbnail'):
              self.set_thumbnail(obj_.value)
        elif nodeName_ == 'translation':
            obj_ = EDTranslation.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'translation', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_translation'):
              self.add_translation(obj_.value)
            elif hasattr(self, 'set_translation'):
              self.set_translation(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(ED, self).buildChildren(child_, node, nodeName_, True)
# end class ED


class thumbnail(ED):
    """A thumbnail is an abbreviated rendition of the full data. A
    thumbnail requires significantly fewer resources than the full
    data, while still maintaining some distinctive similarity with
    the full data. A thumbnail is typically used with by-reference
    encapsulated data. It allows a user to select data more
    efficiently before actually downloading through the reference."""
    subclass = None
    superclass = ED
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, thumbnail_member=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(thumbnail, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, valueOf_, mixedclass_, content_, )
        self.reference = reference
        self.thumbnail = thumbnail_member
        self.translation = translation
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, thumbnail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if thumbnail.subclass:
            return thumbnail.subclass(*args_, **kwargs_)
        else:
            return thumbnail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reference(self): return self.reference
    def set_reference(self, reference): self.reference = reference
    def get_thumbnail(self): return self.thumbnail
    def set_thumbnail(self, thumbnail): self.thumbnail = thumbnail
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.reference is not None or
            self.thumbnail is not None or
            self.translation is not None or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(thumbnail, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='thumbnail', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='thumbnail')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='thumbnail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='thumbnail'):
        super(thumbnail, self).exportAttributes(outfile, level, already_processed, namespace_, name_='thumbnail')
    def exportChildren(self, outfile, level, namespace_='', name_='thumbnail', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(thumbnail, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reference':
            obj_ = TEL.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'reference', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_reference'):
              self.add_reference(obj_.value)
            elif hasattr(self, 'set_reference'):
              self.set_reference(obj_.value)
        elif nodeName_ == 'thumbnail':
            obj_ = thumbnail.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'thumbnail', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_thumbnail'):
              self.add_thumbnail(obj_.value)
            elif hasattr(self, 'set_thumbnail'):
              self.set_thumbnail(obj_.value)
        elif nodeName_ == 'translation':
            obj_ = EDTranslation.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'translation', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_translation'):
              self.add_translation(obj_.value)
            elif hasattr(self, 'set_translation'):
              self.set_translation(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class thumbnail


class EDTranslation(ED):
    """Alternate renditions of the same content translated into a different
    language or a different mediaType. The translation property is a
    set of that each translate the first rendition into different a
    language or use a different mediaType. Each element of the
    translation set must be a translation of the value. Translations
    may not contain translations. ."""
    subclass = None
    superclass = ED
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(EDTranslation, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, valueOf_, mixedclass_, content_, )
        self.reference = reference
        self.thumbnail = thumbnail
        self.translation = translation
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EDTranslation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EDTranslation.subclass:
            return EDTranslation.subclass(*args_, **kwargs_)
        else:
            return EDTranslation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reference(self): return self.reference
    def set_reference(self, reference): self.reference = reference
    def get_thumbnail(self): return self.thumbnail
    def set_thumbnail(self, thumbnail): self.thumbnail = thumbnail
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.reference is not None or
            self.thumbnail is not None or
            self.translation is not None or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(EDTranslation, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EDTranslation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EDTranslation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EDTranslation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EDTranslation'):
        super(EDTranslation, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EDTranslation')
    def exportChildren(self, outfile, level, namespace_='', name_='EDTranslation', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(EDTranslation, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reference':
            obj_ = TEL.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'reference', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_reference'):
              self.add_reference(obj_.value)
            elif hasattr(self, 'set_reference'):
              self.set_reference(obj_.value)
        elif nodeName_ == 'thumbnail':
            obj_ = thumbnail.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'thumbnail', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_thumbnail'):
              self.add_thumbnail(obj_.value)
            elif hasattr(self, 'set_thumbnail'):
              self.set_thumbnail(obj_.value)
        elif nodeName_ == 'translation':
            obj_ = EDTranslation.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'translation', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_translation'):
              self.add_translation(obj_.value)
            elif hasattr(self, 'set_translation'):
              self.set_translation(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class EDTranslation


class ST(ED):
    """The character string data type stands for text data, primarily
    intended for machine processing (e.g., sorting, querying,
    indexing, etc.) Used for names, symbols, and formal expressions.
    The ST data type may have it's data as either the text content
    of the element, or in a value attribute, but not both."""
    subclass = None
    superclass = ED
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ST, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, valueOf_, mixedclass_, content_, extensiontype_, )
        self.value = _cast(None, value)
        self.representation = _cast(None, representation)
        self.mediaType = _cast(None, mediaType)
        self.language = _cast(None, language)
        self.compression = _cast(None, compression)
        self.integrityCheck = _cast(None, integrityCheck)
        self.integrityCheckAlgorithm = _cast(None, integrityCheckAlgorithm)
        self.reference = reference
        self.thumbnail = thumbnail
        if translation is None:
            self.translation = []
        else:
            self.translation = translation
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ST)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ST.subclass:
            return ST.subclass(*args_, **kwargs_)
        else:
            return ST(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_reference(self): return self.reference
    def set_reference(self, reference): self.reference = reference
    def get_thumbnail(self): return self.thumbnail
    def set_thumbnail(self, thumbnail): self.thumbnail = thumbnail
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def add_translation(self, value): self.translation.append(value)
    def insert_translation_at(self, index, value): self.translation.insert(index, value)
    def replace_translation_at(self, index, value): self.translation[index] = value
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_representation(self): return self.representation
    def set_representation(self, representation): self.representation = representation
    def get_mediaType(self): return self.mediaType
    def set_mediaType(self, mediaType): self.mediaType = mediaType
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_compression(self): return self.compression
    def set_compression(self, compression): self.compression = compression
    def get_integrityCheck(self): return self.integrityCheck
    def set_integrityCheck(self, integrityCheck): self.integrityCheck = integrityCheck
    def get_integrityCheckAlgorithm(self): return self.integrityCheckAlgorithm
    def set_integrityCheckAlgorithm(self, integrityCheckAlgorithm): self.integrityCheckAlgorithm = integrityCheckAlgorithm
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_BinaryDataEncoding(self, value):
        # Validate type BinaryDataEncoding, a restriction on xs:NMTOKEN.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['B64', 'TXT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on BinaryDataEncoding' % {"value" : value.encode("utf-8")} )
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_CompressionAlgorithm(self, value):
        # Validate type CompressionAlgorithm, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['BZ', 'DF', 'GZ', 'Z', 'Z7', 'ZL']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on CompressionAlgorithm' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_CompressionAlgorithm_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_CompressionAlgorithm_patterns_, ))
    validate_CompressionAlgorithm_patterns_ = [['^[^\\s]+$']]
    def validate_bin(self, value):
        # Validate type bin, a restriction on xs:base64Binary.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_IntegrityCheckAlgorithm(self, value):
        # Validate type IntegrityCheckAlgorithm, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SHA-1', 'SHA-256']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on IntegrityCheckAlgorithm' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_IntegrityCheckAlgorithm_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_IntegrityCheckAlgorithm_patterns_, ))
    validate_IntegrityCheckAlgorithm_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            self.reference is not None or
            self.thumbnail is not None or
            self.translation or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(ST, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ST', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ST')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ST', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ST'):
        super(ST, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ST')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
        if self.representation is not None and 'representation' not in already_processed:
            already_processed.add('representation')
            outfile.write(' representation=%s' % (quote_attrib(self.representation), ))
        if self.mediaType is not None and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            outfile.write(' mediaType=%s' % (quote_attrib(self.mediaType), ))
        if self.language is not None and 'language' not in already_processed:
            already_processed.add('language')
            outfile.write(' language=%s' % (quote_attrib(self.language), ))
        if self.compression is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            outfile.write(' compression=%s' % (quote_attrib(self.compression), ))
        if self.integrityCheck is not None and 'integrityCheck' not in already_processed:
            already_processed.add('integrityCheck')
            outfile.write(' integrityCheck=%s' % (quote_attrib(self.integrityCheck), ))
        if self.integrityCheckAlgorithm is not None and 'integrityCheckAlgorithm' not in already_processed:
            already_processed.add('integrityCheckAlgorithm')
            outfile.write(' integrityCheckAlgorithm=%s' % (quote_attrib(self.integrityCheckAlgorithm), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ST', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_st(self.value)    # validate type st
        value = find_attr_value_('representation', node)
        if value is not None and 'representation' not in already_processed:
            already_processed.add('representation')
            self.representation = value
            self.validate_BinaryDataEncoding(self.representation)    # validate type BinaryDataEncoding
        value = find_attr_value_('mediaType', node)
        if value is not None and 'mediaType' not in already_processed:
            already_processed.add('mediaType')
            self.mediaType = value
            self.mediaType = ' '.join(self.mediaType.split())
            self.validate_cs(self.mediaType)    # validate type cs
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
            self.language = ' '.join(self.language.split())
            self.validate_cs(self.language)    # validate type cs
        value = find_attr_value_('compression', node)
        if value is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            self.compression = value
            self.validate_CompressionAlgorithm(self.compression)    # validate type CompressionAlgorithm
        value = find_attr_value_('integrityCheck', node)
        if value is not None and 'integrityCheck' not in already_processed:
            already_processed.add('integrityCheck')
            self.integrityCheck = value
            self.validate_bin(self.integrityCheck)    # validate type bin
        value = find_attr_value_('integrityCheckAlgorithm', node)
        if value is not None and 'integrityCheckAlgorithm' not in already_processed:
            already_processed.add('integrityCheckAlgorithm')
            self.integrityCheckAlgorithm = value
            self.validate_IntegrityCheckAlgorithm(self.integrityCheckAlgorithm)    # validate type IntegrityCheckAlgorithm
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ST, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'reference':
            obj_ = TEL.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'reference', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_reference'):
              self.add_reference(obj_.value)
            elif hasattr(self, 'set_reference'):
              self.set_reference(obj_.value)
        elif nodeName_ == 'thumbnail':
            obj_ = ED.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'thumbnail', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_thumbnail'):
              self.add_thumbnail(obj_.value)
            elif hasattr(self, 'set_thumbnail'):
              self.set_thumbnail(obj_.value)
        elif nodeName_ == 'translation':
            obj_ = STTranslation.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'translation', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_translation'):
              self.add_translation(obj_.value)
            elif hasattr(self, 'set_translation'):
              self.set_translation(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class ST


class STTranslation(EDTranslation):
    subclass = None
    superclass = EDTranslation
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(STTranslation, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, valueOf_, mixedclass_, content_, )
        self.translation = translation
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, STTranslation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if STTranslation.subclass:
            return STTranslation.subclass(*args_, **kwargs_)
        else:
            return STTranslation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.translation is not None or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(STTranslation, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='STTranslation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='STTranslation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='STTranslation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='STTranslation'):
        super(STTranslation, self).exportAttributes(outfile, level, already_processed, namespace_, name_='STTranslation')
    def exportChildren(self, outfile, level, namespace_='', name_='STTranslation', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(STTranslation, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'translation':
            obj_ = STTranslation.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'translation', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_translation'):
              self.add_translation(obj_.value)
            elif hasattr(self, 'set_translation'):
              self.set_translation(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class STTranslation


class CD(ANY):
    """A concept descriptor represents any kind of concept usually by
    giving a code defined in a code system. A concept descriptor can
    contain the original text or phrase that served as the basis of
    the coding and one or more translations into different coding
    systems. A concept descriptor can also contain qualifiers to
    describe, e.g., the concept of a "left foot" as a
    postcoordinated term built from the primary code "FOOT" and the
    qualifier "LEFT". In exceptional cases, the concept descriptor
    need not contain a code but only the original text describing
    that concept. The plain code symbol or expression defined by the
    code system. For example, "784.0" is the code symbol of the
    ICD-9 code "784.0" for headache. Specifies the code system that
    defines the code. A common name of the coding system. If
    applicable, a version descriptor defined specifically for the
    given code system. A name or title for the code, under which the
    sending system shows the code value to its users. The value set
    that applied when this CD was coded. The version of the valueSet
    that applied when this CD was coded. CodingRationale provides a
    reason why a particular has been provided, either as the root
    concept or as one of the translations."""
    subclass = None
    superclass = ANY
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, valueSet=None, valueSetVersion=None, codingRationale=None, originalText=None, qualifier=None, translation=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        super(CD, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, valueOf_, mixedclass_, content_, extensiontype_, )
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueSet = _cast(None, valueSet)
        self.valueSetVersion = _cast(None, valueSetVersion)
        self.codingRationale = _cast(None, codingRationale)
        self.originalText = originalText
        if qualifier is None:
            self.qualifier = []
        else:
            self.qualifier = qualifier
        if translation is None:
            self.translation = []
        else:
            self.translation = translation
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CD)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CD.subclass:
            return CD.subclass(*args_, **kwargs_)
        else:
            return CD(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_originalText(self): return self.originalText
    def set_originalText(self, originalText): self.originalText = originalText
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def add_qualifier(self, value): self.qualifier.append(value)
    def insert_qualifier_at(self, index, value): self.qualifier.insert(index, value)
    def replace_qualifier_at(self, index, value): self.qualifier[index] = value
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def add_translation(self, value): self.translation.append(value)
    def insert_translation_at(self, index, value): self.translation.insert(index, value)
    def replace_translation_at(self, index, value): self.translation[index] = value
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueSet(self): return self.valueSet
    def set_valueSet(self, valueSet): self.valueSet = valueSet
    def get_valueSetVersion(self): return self.valueSetVersion
    def set_valueSetVersion(self, valueSetVersion): self.valueSetVersion = valueSetVersion
    def get_codingRationale(self): return self.codingRationale
    def set_codingRationale(self, codingRationale): self.codingRationale = codingRationale
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_oid(self, value):
        # Validate type oid, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_oid_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_oid_patterns_, ))
    validate_oid_patterns_ = [['^[0-2](\\.(0$|^[1-9][0-9]*))*$']]
    def validate_set_CodingRationale(self, value):
        # Validate type set_CodingRationale, a restriction on CodingRationale.
        pass
    def hasContent_(self):
        if (
            self.originalText is not None or
            self.qualifier or
            self.translation or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(CD, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CD', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CD')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CD', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CD'):
        super(CD, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CD')
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
        if self.valueSet is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            outfile.write(' valueSet=%s' % (quote_attrib(self.valueSet), ))
        if self.valueSetVersion is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            outfile.write(' valueSetVersion=%s' % (quote_attrib(self.valueSetVersion), ))
        if self.codingRationale is not None and 'codingRationale' not in already_processed:
            already_processed.add('codingRationale')
            outfile.write(' codingRationale=%s' % (quote_attrib(self.codingRationale), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='CD', fromsubclass_=False, pretty_print=True):
        super(CD, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        value = find_attr_value_('valueSet', node)
        if value is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            self.valueSet = value
            self.validate_oid(self.valueSet)    # validate type oid
        value = find_attr_value_('valueSetVersion', node)
        if value is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            self.valueSetVersion = value
            self.validate_st(self.valueSetVersion)    # validate type st
        value = find_attr_value_('codingRationale', node)
        if value is not None and 'codingRationale' not in already_processed:
            already_processed.add('codingRationale')
            self.codingRationale = value
            self.validate_set_CodingRationale(self.codingRationale)    # validate type set_CodingRationale
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(CD, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'originalText':
            obj_ = ED.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'originalText', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_originalText'):
              self.add_originalText(obj_.value)
            elif hasattr(self, 'set_originalText'):
              self.set_originalText(obj_.value)
        elif nodeName_ == 'qualifier':
            obj_ = CR.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'qualifier', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_qualifier'):
              self.add_qualifier(obj_.value)
            elif hasattr(self, 'set_qualifier'):
              self.set_qualifier(obj_.value)
        elif nodeName_ == 'translation':
            class_obj_ = self.get_class_obj_(child_, CD)
            class_obj_ = CD.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'translation', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_translation'):
              self.add_translation(obj_.value)
            elif hasattr(self, 'set_translation'):
              self.set_translation(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(CD, self).buildChildren(child_, node, nodeName_, True)
# end class CD


class CE(CD):
    """Coded data, consists of a coded value (CV) and, optionally, coded
    value(s) from other coding systems that identify the same
    concept. Used when alternative codes may exist. The plain code
    symbol or expression defined by the code system. For example,
    "784.0" is the code symbol of the ICD-9 code "784.0" for
    headache. Specifies the code system that defines the code. A
    common name of the coding system. If applicable, a version
    descriptor defined specifically for the given code system. A
    name or title for the code, under which the sending system shows
    the code value to its users. The value set that applied when
    this CD was coded. The version of the valueSet that applied when
    this CD was coded. CodingRationale provides a reason why a
    particular has been provided, either as the root concept or as
    one of the translations."""
    subclass = None
    superclass = CD
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, valueSet=None, valueSetVersion=None, codingRationale=None, originalText=None, qualifier=None, translation=None, extensiontype_=None):
        self.original_tagname_ = None
        super(CE, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, code, codeSystem, codeSystemName, codeSystemVersion, displayName, valueSet, valueSetVersion, codingRationale, originalText, qualifier, translation, extensiontype_, )
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueSet = _cast(None, valueSet)
        self.valueSetVersion = _cast(None, valueSetVersion)
        self.codingRationale = _cast(None, codingRationale)
        self.originalText = originalText
        self.qualifier = qualifier
        if translation is None:
            self.translation = []
        else:
            self.translation = translation
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CE)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CE.subclass:
            return CE.subclass(*args_, **kwargs_)
        else:
            return CE(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_originalText(self): return self.originalText
    def set_originalText(self, originalText): self.originalText = originalText
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def add_translation(self, value): self.translation.append(value)
    def insert_translation_at(self, index, value): self.translation.insert(index, value)
    def replace_translation_at(self, index, value): self.translation[index] = value
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueSet(self): return self.valueSet
    def set_valueSet(self, valueSet): self.valueSet = valueSet
    def get_valueSetVersion(self): return self.valueSetVersion
    def set_valueSetVersion(self, valueSetVersion): self.valueSetVersion = valueSetVersion
    def get_codingRationale(self): return self.codingRationale
    def set_codingRationale(self, codingRationale): self.codingRationale = codingRationale
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_oid(self, value):
        # Validate type oid, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_oid_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_oid_patterns_, ))
    validate_oid_patterns_ = [['^[0-2](\\.(0$|^[1-9][0-9]*))*$']]
    def validate_set_CodingRationale(self, value):
        # Validate type set_CodingRationale, a restriction on CodingRationale.
        pass
    def hasContent_(self):
        if (
            self.originalText is not None or
            self.qualifier is not None or
            self.translation or
            super(CE, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CE', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CE')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CE', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CE'):
        super(CE, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CE')
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
        if self.valueSet is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            outfile.write(' valueSet=%s' % (quote_attrib(self.valueSet), ))
        if self.valueSetVersion is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            outfile.write(' valueSetVersion=%s' % (quote_attrib(self.valueSetVersion), ))
        if self.codingRationale is not None and 'codingRationale' not in already_processed:
            already_processed.add('codingRationale')
            outfile.write(' codingRationale=%s' % (quote_attrib(self.codingRationale), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='CE', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.originalText is not None:
            self.originalText.export(outfile, level, namespace_, name_='originalText', pretty_print=pretty_print)
        if self.qualifier is not None:
            self.qualifier.export(outfile, level, namespace_, name_='qualifier', pretty_print=pretty_print)
        for translation_ in self.translation:
            translation_.export(outfile, level, namespace_, name_='translation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        value = find_attr_value_('valueSet', node)
        if value is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            self.valueSet = value
            self.validate_oid(self.valueSet)    # validate type oid
        value = find_attr_value_('valueSetVersion', node)
        if value is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            self.valueSetVersion = value
            self.validate_st(self.valueSetVersion)    # validate type st
        value = find_attr_value_('codingRationale', node)
        if value is not None and 'codingRationale' not in already_processed:
            already_processed.add('codingRationale')
            self.codingRationale = value
            self.validate_set_CodingRationale(self.codingRationale)    # validate type set_CodingRationale
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(CE, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'originalText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.originalText = obj_
            obj_.original_tagname_ = 'originalText'
        elif nodeName_ == 'qualifier':
            obj_ = CR.factory()
            obj_.build(child_)
            self.qualifier = obj_
            obj_.original_tagname_ = 'qualifier'
        elif nodeName_ == 'translation':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.translation.append(obj_)
            obj_.original_tagname_ = 'translation'
# end class CE


class CV(CE):
    """Coded data, consists of a code, display name, code system, and
    original text. Used when a single code value must be sent. The
    plain code symbol or expression defined by the code system. For
    example, "784.0" is the code symbol of the ICD-9 code "784.0"
    for headache. Specifies the code system that defines the code. A
    common name of the coding system. If applicable, a version
    descriptor defined specifically for the given code system. A
    name or title for the code, under which the sending system shows
    the code value to its users. The value set that applied when
    this CD was coded. The version of the valueSet that applied when
    this CD was coded."""
    subclass = None
    superclass = CE
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, valueSet=None, valueSetVersion=None, codingRationale=None, originalText=None, qualifier=None, translation=None, extensiontype_=None):
        self.original_tagname_ = None
        super(CV, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, code, codeSystem, codeSystemName, codeSystemVersion, displayName, valueSet, valueSetVersion, codingRationale, originalText, qualifier, translation, extensiontype_, )
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueSet = _cast(None, valueSet)
        self.valueSetVersion = _cast(None, valueSetVersion)
        self.codingRationale = _cast(None, codingRationale)
        self.originalText = originalText
        self.translation = translation
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CV)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CV.subclass:
            return CV.subclass(*args_, **kwargs_)
        else:
            return CV(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_originalText(self): return self.originalText
    def set_originalText(self, originalText): self.originalText = originalText
    def get_translation(self): return self.translation
    def set_translation(self, translation): self.translation = translation
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueSet(self): return self.valueSet
    def set_valueSet(self, valueSet): self.valueSet = valueSet
    def get_valueSetVersion(self): return self.valueSetVersion
    def set_valueSetVersion(self, valueSetVersion): self.valueSetVersion = valueSetVersion
    def get_codingRationale(self): return self.codingRationale
    def set_codingRationale(self, codingRationale): self.codingRationale = codingRationale
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_oid(self, value):
        # Validate type oid, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_oid_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_oid_patterns_, ))
    validate_oid_patterns_ = [['^[0-2](\\.(0$|^[1-9][0-9]*))*$']]
    def validate_set_CodingRationale(self, value):
        # Validate type set_CodingRationale, a restriction on CodingRationale.
        pass
    def hasContent_(self):
        if (
            self.originalText is not None or
            self.translation is not None or
            super(CV, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CV', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CV')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CV', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CV'):
        super(CV, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CV')
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
        if self.valueSet is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            outfile.write(' valueSet=%s' % (quote_attrib(self.valueSet), ))
        if self.valueSetVersion is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            outfile.write(' valueSetVersion=%s' % (quote_attrib(self.valueSetVersion), ))
        if self.codingRationale is not None and 'codingRationale' not in already_processed:
            already_processed.add('codingRationale')
            outfile.write(' codingRationale=%s' % (quote_attrib(self.codingRationale), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='CV', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.originalText is not None:
            self.originalText.export(outfile, level, namespace_, name_='originalText', pretty_print=pretty_print)
        if self.translation is not None:
            self.translation.export(outfile, level, namespace_, name_='translation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        value = find_attr_value_('valueSet', node)
        if value is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            self.valueSet = value
            self.validate_oid(self.valueSet)    # validate type oid
        value = find_attr_value_('valueSetVersion', node)
        if value is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            self.valueSetVersion = value
            self.validate_st(self.valueSetVersion)    # validate type st
        value = find_attr_value_('codingRationale', node)
        if value is not None and 'codingRationale' not in already_processed:
            already_processed.add('codingRationale')
            self.codingRationale = value
            self.validate_set_CodingRationale(self.codingRationale)    # validate type set_CodingRationale
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(CV, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'originalText':
            obj_ = ED.factory()
            obj_.build(child_)
            self.originalText = obj_
            obj_.original_tagname_ = 'originalText'
        elif nodeName_ == 'translation':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.translation = obj_
            obj_.original_tagname_ = 'translation'
# end class CV


class CS(CV):
    """Coded data, consists of a code, display name, code system, and
    original text. Used when a single code value must be sent. The
    plain code symbol or expression defined by the code system. For
    example, "784.0" is the code symbol of the ICD-9 code "784.0"
    for headache."""
    subclass = None
    superclass = CV
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, valueSet=None, valueSetVersion=None, codingRationale=None, originalText=None, qualifier=None, translation=None):
        self.original_tagname_ = None
        super(CS, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, code, codeSystem, codeSystemName, codeSystemVersion, displayName, valueSet, valueSetVersion, codingRationale, originalText, qualifier, translation, )
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueSet = _cast(None, valueSet)
        self.valueSetVersion = _cast(None, valueSetVersion)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CS)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CS.subclass:
            return CS.subclass(*args_, **kwargs_)
        else:
            return CS(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueSet(self): return self.valueSet
    def set_valueSet(self, valueSet): self.valueSet = valueSet
    def get_valueSetVersion(self): return self.valueSetVersion
    def set_valueSetVersion(self, valueSetVersion): self.valueSetVersion = valueSetVersion
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_oid(self, value):
        # Validate type oid, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_oid_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_oid_patterns_, ))
    validate_oid_patterns_ = [['^[0-2](\\.(0$|^[1-9][0-9]*))*$']]
    def hasContent_(self):
        if (
            super(CS, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CS', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CS')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CS', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CS'):
        super(CS, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CS')
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
        if self.valueSet is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            outfile.write(' valueSet=%s' % (quote_attrib(self.valueSet), ))
        if self.valueSetVersion is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            outfile.write(' valueSetVersion=%s' % (quote_attrib(self.valueSetVersion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CS', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        value = find_attr_value_('valueSet', node)
        if value is not None and 'valueSet' not in already_processed:
            already_processed.add('valueSet')
            self.valueSet = value
            self.validate_oid(self.valueSet)    # validate type oid
        value = find_attr_value_('valueSetVersion', node)
        if value is not None and 'valueSetVersion' not in already_processed:
            already_processed.add('valueSetVersion')
            self.valueSetVersion = value
            self.validate_st(self.valueSetVersion)    # validate type st
        super(CS, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CS


class CO(CV):
    """Coded data, where the domain from which the codeset comes is
    ordered. The Coded Ordinal data type adds semantics related to
    ordering so that models that make use of such domains may
    introduce model elements that involve statements about the order
    of the terms in a domain."""
    subclass = None
    superclass = CV
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, valueSet=None, valueSetVersion=None, codingRationale=None, originalText=None, qualifier=None, translation=None):
        self.original_tagname_ = None
        super(CO, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, code, codeSystem, codeSystemName, codeSystemVersion, displayName, valueSet, valueSetVersion, codingRationale, originalText, qualifier, translation, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CO)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CO.subclass:
            return CO.subclass(*args_, **kwargs_)
        else:
            return CO(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(CO, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CO', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CO')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CO', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CO'):
        super(CO, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CO')
    def exportChildren(self, outfile, level, namespace_='', name_='CO', fromsubclass_=False, pretty_print=True):
        super(CO, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(CO, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(CO, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class CO


class CR(ANY):
    """A concept qualifier code with optionally named role. Both qualifier
    role and value codes must be defined by the coding system. For
    example, if SNOMED RT defines a concept "leg", a role relation
    "has-laterality", and another concept "left", the concept role
    relation allows to add the qualifier "has-laterality: left" to a
    primary code "leg" to construct the meaning "left leg".
    Indicates if the sense of the role name is inverted. This can be
    used in cases where the underlying code system defines inversion
    but does not provide reciprocal pairs of role names. By default,
    inverted is false."""
    subclass = None
    superclass = ANY
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, inverted='false', name=None, value=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(CR, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, valueOf_, mixedclass_, content_, )
        self.inverted = _cast(None, inverted)
        self.name = name
        self.value = value
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CR)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CR.subclass:
            return CR.subclass(*args_, **kwargs_)
        else:
            return CR(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_inverted(self): return self.inverted
    def set_inverted(self, inverted): self.inverted = inverted
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_bn(self, value):
        # Validate type bn, a restriction on bl.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bn_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bn_patterns_, ))
    validate_bn_patterns_ = [['^true$|^false$']]
    def hasContent_(self):
        if (
            self.name is not None or
            self.value is not None or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(CR, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CR', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CR')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CR', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CR'):
        super(CR, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CR')
        if self.inverted != "false" and 'inverted' not in already_processed:
            already_processed.add('inverted')
            outfile.write(' inverted=%s' % (quote_attrib(self.inverted), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CR', fromsubclass_=False, pretty_print=True):
        super(CR, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('inverted', node)
        if value is not None and 'inverted' not in already_processed:
            already_processed.add('inverted')
            self.inverted = value
            self.validate_bn(self.inverted)    # validate type bn
        super(CR, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            class_obj_ = self.get_class_obj_(child_, CV)
            class_obj_ = CV.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'name', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_name'):
              self.add_name(obj_.value)
            elif hasattr(self, 'set_name'):
              self.set_name(obj_.value)
        elif nodeName_ == 'value':
            class_obj_ = self.get_class_obj_(child_, CD)
            class_obj_ = CD.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'value', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_value'):
              self.add_value(obj_.value)
            elif hasattr(self, 'set_value'):
              self.set_value(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(CR, self).buildChildren(child_, node, nodeName_, True)
# end class CR


class SC(ST):
    """An ST that optionally may have a code attached. The text must always
    be present if a code is present. The code is often a local code.
    The plain code symbol defined by the code system. For example,
    "784.0" is the code symbol of the ICD-9 code "784.0" for
    headache. Specifies the code system that defines the code. A
    common name of the coding system. If applicable, a version
    descriptor defined specifically for the given code system. A
    name or title for the code, under which the sending system shows
    the code value to its users."""
    subclass = None
    superclass = ST
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        super(SC, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, valueOf_, mixedclass_, content_, extensiontype_, )
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SC)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SC.subclass:
            return SC.subclass(*args_, **kwargs_)
        else:
            return SC(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(SC, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SC', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SC')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SC', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SC'):
        super(SC, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SC')
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='SC', fromsubclass_=False, pretty_print=True):
        super(SC, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(SC, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(SC, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SC


class II(ANY):
    """An identifier that uniquely identifies a thing or object. Examples
    are object identifier for HL7 RIM objects, medical record
    number, order id, service catalog item id, Vehicle
    Identification Number (VIN), etc. Instance identifiers are
    defined based on ISO object identifiers. A unique identifier
    that guarantees the global uniqueness of the instance
    identifier. The root alone may be the entire instance
    identifier. A character string as a unique identifier within the
    scope of the identifier root. A human readable name or mnemonic
    for the assigning authority. This name may be provided solely
    for the convenience of unaided humans interpreting an value and
    can have no computational meaning. Note: no automated processing
    must depend on the assigning authority name to be present in any
    form. Specifies if the identifier is intended for human display
    and data entry (displayable = true) as opposed to pure machine
    interoperation (displayable = false). Specifies the scope in
    which the identifier applies to the object with which it is
    associated. Specifies the reliability with which the identifier
    is known. This attribute may be used to assist with identifier
    matching algorithms.."""
    subclass = None
    superclass = ANY
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, root=None, extension=None, assigningAuthorityName=None, displayable=None, scope=None, reliability=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(II, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, valueOf_, mixedclass_, content_, )
        self.root = _cast(None, root)
        self.extension = _cast(None, extension)
        self.assigningAuthorityName = _cast(None, assigningAuthorityName)
        self.displayable = _cast(None, displayable)
        self.scope = _cast(None, scope)
        self.reliability = _cast(None, reliability)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, II)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if II.subclass:
            return II.subclass(*args_, **kwargs_)
        else:
            return II(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_root(self): return self.root
    def set_root(self, root): self.root = root
    def get_extension(self): return self.extension
    def set_extension(self, extension): self.extension = extension
    def get_assigningAuthorityName(self): return self.assigningAuthorityName
    def set_assigningAuthorityName(self, assigningAuthorityName): self.assigningAuthorityName = assigningAuthorityName
    def get_displayable(self): return self.displayable
    def set_displayable(self, displayable): self.displayable = displayable
    def get_scope(self): return self.scope
    def set_scope(self, scope): self.scope = scope
    def get_reliability(self): return self.reliability
    def set_reliability(self, reliability): self.reliability = reliability
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^true$|^false$']]
    def validate_IdentifierScope(self, value):
        # Validate type IdentifierScope, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['BUSN', 'OBJ', 'VER', 'VW']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on IdentifierScope' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_IdentifierScope_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_IdentifierScope_patterns_, ))
    validate_IdentifierScope_patterns_ = [['^[^\\s]+$']]
    def validate_IdentifierReliability(self, value):
        # Validate type IdentifierReliability, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ISS', 'UNV', 'VRF']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on IdentifierReliability' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_IdentifierReliability_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_IdentifierReliability_patterns_, ))
    validate_IdentifierReliability_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(II, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='II', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='II')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='II'):
        super(II, self).exportAttributes(outfile, level, already_processed, namespace_, name_='II')
        if self.root is not None and 'root' not in already_processed:
            already_processed.add('root')
            outfile.write(' root=%s' % (quote_attrib(self.root), ))
        if self.extension is not None and 'extension' not in already_processed:
            already_processed.add('extension')
            outfile.write(' extension=%s' % (quote_attrib(self.extension), ))
        if self.assigningAuthorityName is not None and 'assigningAuthorityName' not in already_processed:
            already_processed.add('assigningAuthorityName')
            outfile.write(' assigningAuthorityName=%s' % (quote_attrib(self.assigningAuthorityName), ))
        if self.displayable is not None and 'displayable' not in already_processed:
            already_processed.add('displayable')
            outfile.write(' displayable=%s' % (quote_attrib(self.displayable), ))
        if self.scope is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            outfile.write(' scope=%s' % (quote_attrib(self.scope), ))
        if self.reliability is not None and 'reliability' not in already_processed:
            already_processed.add('reliability')
            outfile.write(' reliability=%s' % (quote_attrib(self.reliability), ))
    def exportChildren(self, outfile, level, namespace_='', name_='II', fromsubclass_=False, pretty_print=True):
        super(II, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('root', node)
        if value is not None and 'root' not in already_processed:
            already_processed.add('root')
            self.root = value
            self.validate_uid(self.root)    # validate type uid
        value = find_attr_value_('extension', node)
        if value is not None and 'extension' not in already_processed:
            already_processed.add('extension')
            self.extension = value
            self.validate_st(self.extension)    # validate type st
        value = find_attr_value_('assigningAuthorityName', node)
        if value is not None and 'assigningAuthorityName' not in already_processed:
            already_processed.add('assigningAuthorityName')
            self.assigningAuthorityName = value
            self.validate_st(self.assigningAuthorityName)    # validate type st
        value = find_attr_value_('displayable', node)
        if value is not None and 'displayable' not in already_processed:
            already_processed.add('displayable')
            if value in ('true', '1'):
                self.displayable = True
            elif value in ('false', '0'):
                self.displayable = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.displayable)    # validate type bl
        value = find_attr_value_('scope', node)
        if value is not None and 'scope' not in already_processed:
            already_processed.add('scope')
            self.scope = value
            self.validate_IdentifierScope(self.scope)    # validate type IdentifierScope
        value = find_attr_value_('reliability', node)
        if value is not None and 'reliability' not in already_processed:
            already_processed.add('reliability')
            self.reliability = value
            self.validate_IdentifierReliability(self.reliability)    # validate type IdentifierReliability
        super(II, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(II, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class II


class URL(ANY):
    """A telecommunications address specified according to Internet
    standard RFC 1738 [http://www.ietf.org/rfc/rfc1738.txt]. The URL
    specifies the protocol and the contact point defined by that
    protocol for the resource. Notable uses of the telecommunication
    address data type are for telephone and telefax numbers, e-mail
    addresses, Hypertext references, FTP references, etc."""
    subclass = None
    superclass = ANY
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, value=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        super(URL, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, valueOf_, mixedclass_, content_, extensiontype_, )
        self.value = _cast(None, value)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, URL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if URL.subclass:
            return URL.subclass(*args_, **kwargs_)
        else:
            return URL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_url(self, value):
        # Validate type url, a restriction on xs:anyURI.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(URL, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='URL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='URL')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='URL'):
        super(URL, self).exportAttributes(outfile, level, already_processed, namespace_, name_='URL')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='URL', fromsubclass_=False, pretty_print=True):
        super(URL, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_url(self.value)    # validate type url
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(URL, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(URL, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class URL


class TEL(URL):
    """A telephone number (voice or fax), e-mail address, or other locator
    for a resource (information or service) mediated by
    telecommunication equipment. The address is specified as a URL
    qualified by time specification and use codes that help in
    deciding which address to use for a given time and purpose. One
    or more codes advising a system or user which telecommunication
    address in a set of like addresses to select for a given
    telecommunication need. One or more codes advising a system or
    user what telecommunication capabilities are known to be
    associated with the telecommunication address."""
    subclass = None
    superclass = URL
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, value=None, use=None, capabilities=None, useablePeriod=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(TEL, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, value, valueOf_, mixedclass_, content_, )
        self.use = _cast(None, use)
        self.capabilities = _cast(None, capabilities)
        if useablePeriod is None:
            self.useablePeriod = []
        else:
            self.useablePeriod = useablePeriod
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TEL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TEL.subclass:
            return TEL.subclass(*args_, **kwargs_)
        else:
            return TEL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_useablePeriod(self): return self.useablePeriod
    def set_useablePeriod(self, useablePeriod): self.useablePeriod = useablePeriod
    def add_useablePeriod(self, value): self.useablePeriod.append(value)
    def insert_useablePeriod_at(self, index, value): self.useablePeriod.insert(index, value)
    def replace_useablePeriod_at(self, index, value): self.useablePeriod[index] = value
    def get_use(self): return self.use
    def set_use(self, use): self.use = use
    def get_capabilities(self): return self.capabilities
    def set_capabilities(self, capabilities): self.capabilities = capabilities
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_set_TelecommunicationAddressUse(self, value):
        # Validate type set_TelecommunicationAddressUse, a restriction on TelecommunicationAddressUse.
        pass
    def validate_set_TelecommunicationCapabilities(self, value):
        # Validate type set_TelecommunicationCapabilities, a restriction on TelecommunicationCapabilities.
        pass
    def hasContent_(self):
        if (
            self.useablePeriod or
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(TEL, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TEL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TEL')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TEL', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TEL'):
        super(TEL, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TEL')
        if self.use is not None and 'use' not in already_processed:
            already_processed.add('use')
            outfile.write(' use=%s' % (quote_attrib(self.use), ))
        if self.capabilities is not None and 'capabilities' not in already_processed:
            already_processed.add('capabilities')
            outfile.write(' capabilities=%s' % (quote_attrib(self.capabilities), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TEL', fromsubclass_=False, pretty_print=True):
        super(TEL, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('use', node)
        if value is not None and 'use' not in already_processed:
            already_processed.add('use')
            self.use = value
            self.validate_set_TelecommunicationAddressUse(self.use)    # validate type set_TelecommunicationAddressUse
        value = find_attr_value_('capabilities', node)
        if value is not None and 'capabilities' not in already_processed:
            already_processed.add('capabilities')
            self.capabilities = value
            self.validate_set_TelecommunicationCapabilities(self.capabilities)    # validate type set_TelecommunicationCapabilities
        super(TEL, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'useablePeriod':
            class_obj_ = self.get_class_obj_(child_, SXCM_TS)
            class_obj_ = SXCM_TS.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'useablePeriod', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_useablePeriod'):
              self.add_useablePeriod(obj_.value)
            elif hasattr(self, 'set_useablePeriod'):
              self.set_useablePeriod(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(TEL, self).buildChildren(child_, node, nodeName_, True)
# end class TEL


class ADXP(SC):
    """A character string that may have a type-tag signifying its role in
    the address. Typical parts that exist in about every address are
    street, house number, or post box, postal code, city, country
    but other roles may be defined regionally, nationally, or on an
    enterprise level (e.g. in military addresses). Addresses are
    usually broken up into lines, which are indicated by special
    line-breaking delimiter elements (e.g., DEL). Specifies whether
    an address part names the street, city, country, postal code,
    post box, etc. If the type is NULL the address part is
    unclassified and would simply appear on an address label as is."""
    subclass = None
    superclass = SC
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(ADXP, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ADXP)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ADXP.subclass:
            return ADXP.subclass(*args_, **kwargs_)
        else:
            return ADXP(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(ADXP, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ADXP', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ADXP')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ADXP', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ADXP'):
        super(ADXP, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ADXP')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ADXP', fromsubclass_=False, pretty_print=True):
        super(ADXP, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(ADXP, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(ADXP, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ADXP


class adxp_delimiter(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_delimiter, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_delimiter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_delimiter.subclass:
            return adxp_delimiter.subclass(*args_, **kwargs_)
        else:
            return adxp_delimiter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_delimiter, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.delimiter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.delimiter')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.delimiter'):
        super(adxp_delimiter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.delimiter')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.delimiter', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_delimiter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_delimiter


class adxp_country(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_country, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_country)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_country.subclass:
            return adxp_country.subclass(*args_, **kwargs_)
        else:
            return adxp_country(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_country, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.country', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.country')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.country'):
        super(adxp_country, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.country')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.country', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_country, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_country


class adxp_state(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_state, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_state)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_state.subclass:
            return adxp_state.subclass(*args_, **kwargs_)
        else:
            return adxp_state(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_state, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.state', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.state')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.state'):
        super(adxp_state, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.state')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.state', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_state, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_state


class adxp_county(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_county, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_county)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_county.subclass:
            return adxp_county.subclass(*args_, **kwargs_)
        else:
            return adxp_county(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_county, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.county', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.county')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.county'):
        super(adxp_county, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.county')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.county', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_county, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_county


class adxp_city(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_city, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_city)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_city.subclass:
            return adxp_city.subclass(*args_, **kwargs_)
        else:
            return adxp_city(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_city, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.city', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.city')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.city'):
        super(adxp_city, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.city')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.city', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_city, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_city


class adxp_postalCode(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_postalCode, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_postalCode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_postalCode.subclass:
            return adxp_postalCode.subclass(*args_, **kwargs_)
        else:
            return adxp_postalCode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_postalCode, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.postalCode', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.postalCode')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.postalCode'):
        super(adxp_postalCode, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.postalCode')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.postalCode', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_postalCode, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_postalCode


class adxp_addressLine(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_addressLine, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_addressLine)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_addressLine.subclass:
            return adxp_addressLine.subclass(*args_, **kwargs_)
        else:
            return adxp_addressLine(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_addressLine, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.addressLine', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.addressLine')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.addressLine'):
        super(adxp_addressLine, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.addressLine')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.addressLine', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_addressLine, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_addressLine


class adxp_streetAddressLine(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_streetAddressLine, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_streetAddressLine)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_streetAddressLine.subclass:
            return adxp_streetAddressLine.subclass(*args_, **kwargs_)
        else:
            return adxp_streetAddressLine(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_streetAddressLine, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.streetAddressLine', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetAddressLine')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.streetAddressLine'):
        super(adxp_streetAddressLine, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetAddressLine')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.streetAddressLine', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_streetAddressLine, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_streetAddressLine


class adxp_houseNumber(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_houseNumber, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_houseNumber)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_houseNumber.subclass:
            return adxp_houseNumber.subclass(*args_, **kwargs_)
        else:
            return adxp_houseNumber(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_houseNumber, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.houseNumber', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.houseNumber')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.houseNumber'):
        super(adxp_houseNumber, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.houseNumber')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.houseNumber', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_houseNumber, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_houseNumber


class adxp_houseNumberNumeric(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_houseNumberNumeric, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_houseNumberNumeric)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_houseNumberNumeric.subclass:
            return adxp_houseNumberNumeric.subclass(*args_, **kwargs_)
        else:
            return adxp_houseNumberNumeric(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_houseNumberNumeric, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.houseNumberNumeric', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.houseNumberNumeric')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.houseNumberNumeric'):
        super(adxp_houseNumberNumeric, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.houseNumberNumeric')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.houseNumberNumeric', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_houseNumberNumeric, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_houseNumberNumeric


class adxp_direction(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_direction, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_direction)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_direction.subclass:
            return adxp_direction.subclass(*args_, **kwargs_)
        else:
            return adxp_direction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_direction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.direction', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.direction')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.direction'):
        super(adxp_direction, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.direction')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.direction', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_direction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_direction


class adxp_streetName(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_streetName, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_streetName)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_streetName.subclass:
            return adxp_streetName.subclass(*args_, **kwargs_)
        else:
            return adxp_streetName(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_streetName, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.streetName', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetName')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.streetName'):
        super(adxp_streetName, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetName')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.streetName', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_streetName, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_streetName


class adxp_streetNameBase(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_streetNameBase, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_streetNameBase)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_streetNameBase.subclass:
            return adxp_streetNameBase.subclass(*args_, **kwargs_)
        else:
            return adxp_streetNameBase(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_streetNameBase, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.streetNameBase', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetNameBase')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.streetNameBase'):
        super(adxp_streetNameBase, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetNameBase')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.streetNameBase', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_streetNameBase, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_streetNameBase


class adxp_streetNameType(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_streetNameType, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_streetNameType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_streetNameType.subclass:
            return adxp_streetNameType.subclass(*args_, **kwargs_)
        else:
            return adxp_streetNameType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_streetNameType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.streetNameType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetNameType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.streetNameType'):
        super(adxp_streetNameType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.streetNameType')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.streetNameType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_streetNameType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_streetNameType


class adxp_additionalLocator(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_additionalLocator, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_additionalLocator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_additionalLocator.subclass:
            return adxp_additionalLocator.subclass(*args_, **kwargs_)
        else:
            return adxp_additionalLocator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_additionalLocator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.additionalLocator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.additionalLocator')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.additionalLocator'):
        super(adxp_additionalLocator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.additionalLocator')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.additionalLocator', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_additionalLocator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_additionalLocator


class adxp_unitID(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_unitID, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_unitID)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_unitID.subclass:
            return adxp_unitID.subclass(*args_, **kwargs_)
        else:
            return adxp_unitID(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_unitID, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.unitID', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.unitID')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.unitID'):
        super(adxp_unitID, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.unitID')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.unitID', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_unitID, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_unitID


class adxp_unitType(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_unitType, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_unitType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_unitType.subclass:
            return adxp_unitType.subclass(*args_, **kwargs_)
        else:
            return adxp_unitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_unitType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.unitType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.unitType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.unitType'):
        super(adxp_unitType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.unitType')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.unitType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_unitType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_unitType


class adxp_intersection(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_intersection, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_intersection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_intersection.subclass:
            return adxp_intersection.subclass(*args_, **kwargs_)
        else:
            return adxp_intersection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_intersection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.intersection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.intersection')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.intersection'):
        super(adxp_intersection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.intersection')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.intersection', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_intersection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_intersection


class adxp_careOf(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_careOf, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_careOf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_careOf.subclass:
            return adxp_careOf.subclass(*args_, **kwargs_)
        else:
            return adxp_careOf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_careOf, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.careOf', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.careOf')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.careOf'):
        super(adxp_careOf, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.careOf')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.careOf', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_careOf, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_careOf


class adxp_censusTract(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_censusTract, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_censusTract)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_censusTract.subclass:
            return adxp_censusTract.subclass(*args_, **kwargs_)
        else:
            return adxp_censusTract(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_censusTract, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.censusTract', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.censusTract')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.censusTract'):
        super(adxp_censusTract, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.censusTract')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.censusTract', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_censusTract, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_censusTract


class adxp_deliveryAddressLine(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_deliveryAddressLine, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_deliveryAddressLine)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_deliveryAddressLine.subclass:
            return adxp_deliveryAddressLine.subclass(*args_, **kwargs_)
        else:
            return adxp_deliveryAddressLine(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_deliveryAddressLine, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.deliveryAddressLine', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryAddressLine')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.deliveryAddressLine'):
        super(adxp_deliveryAddressLine, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryAddressLine')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.deliveryAddressLine', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_deliveryAddressLine, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_deliveryAddressLine


class adxp_deliveryInstallationType(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_deliveryInstallationType, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_deliveryInstallationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_deliveryInstallationType.subclass:
            return adxp_deliveryInstallationType.subclass(*args_, **kwargs_)
        else:
            return adxp_deliveryInstallationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_deliveryInstallationType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.deliveryInstallationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryInstallationType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.deliveryInstallationType'):
        super(adxp_deliveryInstallationType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryInstallationType')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.deliveryInstallationType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_deliveryInstallationType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_deliveryInstallationType


class adxp_deliveryInstallationArea(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_deliveryInstallationArea, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_deliveryInstallationArea)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_deliveryInstallationArea.subclass:
            return adxp_deliveryInstallationArea.subclass(*args_, **kwargs_)
        else:
            return adxp_deliveryInstallationArea(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_deliveryInstallationArea, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.deliveryInstallationArea', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryInstallationArea')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.deliveryInstallationArea'):
        super(adxp_deliveryInstallationArea, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryInstallationArea')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.deliveryInstallationArea', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_deliveryInstallationArea, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_deliveryInstallationArea


class adxp_deliveryInstallationQualifier(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_deliveryInstallationQualifier, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_deliveryInstallationQualifier)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_deliveryInstallationQualifier.subclass:
            return adxp_deliveryInstallationQualifier.subclass(*args_, **kwargs_)
        else:
            return adxp_deliveryInstallationQualifier(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_deliveryInstallationQualifier, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.deliveryInstallationQualifier', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryInstallationQualifier')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.deliveryInstallationQualifier'):
        super(adxp_deliveryInstallationQualifier, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryInstallationQualifier')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.deliveryInstallationQualifier', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_deliveryInstallationQualifier, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_deliveryInstallationQualifier


class adxp_deliveryMode(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_deliveryMode, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_deliveryMode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_deliveryMode.subclass:
            return adxp_deliveryMode.subclass(*args_, **kwargs_)
        else:
            return adxp_deliveryMode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_deliveryMode, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.deliveryMode', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryMode')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.deliveryMode'):
        super(adxp_deliveryMode, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryMode')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.deliveryMode', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        super(adxp_deliveryMode, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_deliveryMode


class adxp_deliveryModeIdentifier(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_deliveryModeIdentifier, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_deliveryModeIdentifier)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_deliveryModeIdentifier.subclass:
            return adxp_deliveryModeIdentifier.subclass(*args_, **kwargs_)
        else:
            return adxp_deliveryModeIdentifier(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_deliveryModeIdentifier, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.deliveryModeIdentifier', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryModeIdentifier')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.deliveryModeIdentifier'):
        super(adxp_deliveryModeIdentifier, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.deliveryModeIdentifier')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.deliveryModeIdentifier', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_deliveryModeIdentifier, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_deliveryModeIdentifier


class adxp_buildingNumberSuffix(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_buildingNumberSuffix, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_buildingNumberSuffix)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_buildingNumberSuffix.subclass:
            return adxp_buildingNumberSuffix.subclass(*args_, **kwargs_)
        else:
            return adxp_buildingNumberSuffix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_buildingNumberSuffix, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.buildingNumberSuffix', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.buildingNumberSuffix')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.buildingNumberSuffix'):
        super(adxp_buildingNumberSuffix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.buildingNumberSuffix')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.buildingNumberSuffix', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_buildingNumberSuffix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_buildingNumberSuffix


class adxp_postBox(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_postBox, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName, partType, valueOf_, mixedclass_, content_, )
        self.partType = _cast(None, partType)
        self.code = _cast(None, code)
        self.codeSystem = _cast(None, codeSystem)
        self.codeSystemName = _cast(None, codeSystemName)
        self.codeSystemVersion = _cast(None, codeSystemVersion)
        self.displayName = _cast(None, displayName)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adxp_postBox)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adxp_postBox.subclass:
            return adxp_postBox.subclass(*args_, **kwargs_)
        else:
            return adxp_postBox(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partType(self): return self.partType
    def set_partType(self, partType): self.partType = partType
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_codeSystem(self): return self.codeSystem
    def set_codeSystem(self, codeSystem): self.codeSystem = codeSystem
    def get_codeSystemName(self): return self.codeSystemName
    def set_codeSystemName(self, codeSystemName): self.codeSystemName = codeSystemName
    def get_codeSystemVersion(self): return self.codeSystemVersion
    def set_codeSystemVersion(self, codeSystemVersion): self.codeSystemVersion = codeSystemVersion
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_AddressPartType(self, value):
        # Validate type AddressPartType, a restriction on cs.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ADL', 'AL', 'BNN', 'BNR', 'BNS', 'CAR', 'CEN', 'CNT', 'CPA', 'CTY', 'DAL', 'DEL', 'DINST', 'DINSTA', 'DINSTQ', 'DIR', 'DMOD', 'DMODID', 'DPID', 'INT', 'POB', 'PRE', 'SAL', 'STA', 'STB', 'STR', 'STTYP', 'UNID', 'UNIT', 'ZIP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on AddressPartType' % {"value" : value.encode("utf-8")} )
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressPartType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_AddressPartType_patterns_, ))
    validate_AddressPartType_patterns_ = [['^[^\\s]+$']]
    def validate_cs(self, value):
        # Validate type cs, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_cs_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_cs_patterns_, ))
    validate_cs_patterns_ = [['^[^\\s]+$']]
    def validate_uid(self, value):
        # Validate type uid, a restriction on None.
        pass
    def validate_st(self, value):
        # Validate type st, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) < 1:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on st' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_ or
            super(adxp_postBox, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adxp.postBox', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.postBox')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adxp.postBox'):
        super(adxp_postBox, self).exportAttributes(outfile, level, already_processed, namespace_, name_='adxp.postBox')
        if self.partType is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            outfile.write(' partType=%s' % (quote_attrib(self.partType), ))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(' code=%s' % (quote_attrib(self.code), ))
        if self.codeSystem is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            outfile.write(' codeSystem=%s' % (quote_attrib(self.codeSystem), ))
        if self.codeSystemName is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            outfile.write(' codeSystemName=%s' % (quote_attrib(self.codeSystemName), ))
        if self.codeSystemVersion is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            outfile.write(' codeSystemVersion=%s' % (quote_attrib(self.codeSystemVersion), ))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (quote_attrib(self.displayName), ))
    def exportChildren(self, outfile, level, namespace_='', name_='adxp.postBox', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partType', node)
        if value is not None and 'partType' not in already_processed:
            already_processed.add('partType')
            self.partType = value
            self.validate_AddressPartType(self.partType)    # validate type AddressPartType
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
            self.code = ' '.join(self.code.split())
            self.validate_cs(self.code)    # validate type cs
        value = find_attr_value_('codeSystem', node)
        if value is not None and 'codeSystem' not in already_processed:
            already_processed.add('codeSystem')
            self.codeSystem = value
            self.validate_uid(self.codeSystem)    # validate type uid
        value = find_attr_value_('codeSystemName', node)
        if value is not None and 'codeSystemName' not in already_processed:
            already_processed.add('codeSystemName')
            self.codeSystemName = value
            self.validate_st(self.codeSystemName)    # validate type st
        value = find_attr_value_('codeSystemVersion', node)
        if value is not None and 'codeSystemVersion' not in already_processed:
            already_processed.add('codeSystemVersion')
            self.codeSystemVersion = value
            self.validate_st(self.codeSystemVersion)    # validate type st
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
            self.validate_st(self.displayName)    # validate type st
        super(adxp_postBox, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class adxp_postBox


class adxp_precinct(ADXP):
    subclass = None
    superclass = ADXP
    def __init__(self, nullFlavor=None, collectionNullFlavor=None, flavorId=None, updateMode=None, representation='TXT', value=None, mediaType='text/plain', language=None, compression=None, integrityCheck=None, integrityCheckAlgorithm='SHA-1', description=None, reference=None, thumbnail=None, translation=None, code=None, codeSystem=None, codeSystemName=None, codeSystemVersion=None, displayName=None, partType=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(adxp_precinct, self).__init__(nullFlavor, collectionNullFlavor, flavorId, updateMode, representation, value, mediaType, language, compression, integrityCheck, integrityCheckAlgorithm, description, reference, thumbnail, translation, code, codeSystem, codeSystemName, codeSystemVersion, displayName,