import xlranker
import xlranker.util
import xlranker.util.mapping


FASTA_SNIPPET = """>ENSP00000493376.2|ENST00000641515.2|ENSG00000186092.7|OTTHUMG00000001094.4|OTTHUMT00000003223.4|OR4F5-201|OR4F5|326
MKKVTAEAISWNESTSETNNSMVTEFIFLGLSDSQELQTFLFMLFFVFYGGIVFGNLLIV
ITVVSDSHLHSPMYFLLANLSLIDLSLSSVTAPKMITDFFSQRKVISFKGCLVQIFLLHF
FGGSEMVILIAMGFDRYIAICKPLHYTTIMCGNACVGIMAVTWGIGFLHSVSQLAFAVHL
LFCGPNEVDSFYCDLPRVIKLACTDTYRLDIMVIANSGVLTVCSFVLLIISYTIILMTIQ
HRPLDKSSKALSTLTAHITVVLLFFGPCVFIYAWPFPIKSLDKFLAVFYSVITPLLNPII
YTLRNKDMKTAIRQLRKWDAHSSVKF
>ENSP00000409316.1|ENST00000426406.4|ENSG00000284733.2|OTTHUMG00000002860.3|OTTHUMT00000007999.3|OR4F29-201|OR4F29|312
MDGENHSVVSEFLFLGLTHSWEIQLLLLVFSSVLYVASITGNILIVFSVTTDPHLHSPMY
FLLASLSFIDLGACSVTSPKMIYDLFRKRKVISFGGCIAQIFFIHVVGGVEMVLLIAMAF
DRYVALCKPLHYLTIMSPRMCLSFLAVAWTLGVSHSLFQLAFLVNLAFCGPNVLDSFYCD
LPRLLRLACTDTYRLQFMVTVNSGFICVGTFFILLISYVFILFTVWKHSSGGSSKALSTL
SAHSTVVLLFFGPPMFVYTRPHPNSQMDKFLAIFDAVLTPFLNPVVYTFRNKEMKAAIKR
VCKQLVIYKRIS
>ENSP00000329982.2|ENST00000332831.5|ENSG00000284662.2|OTTHUMG00000002581.3|OTTHUMT00000007334.3|OR4F16-201|OR4F16|312
MDGENHSVVSEFLFLGLTHSWEIQLLLLVFSSVLYVASITGNILIVFSVTTDPHLHSPMY
FLLASLSFIDLGACSVTSPKMIYDLFRKRKVISFGGCIAQIFFIHVVGGVEMVLLIAMAF
DRYVALCKPLHYLTIMSPRMCLSFLAVAWTLGVSHSLFQLAFLVNLAFCGPNVLDSFYCD
LPRLLRLACTDTYRLQFMVTVNSGFICVGTFFILLISYVFILFTVWKHSSGGSSKALSTL
SAHSTVVLLFFGPPMFVYTRPHPNSQMDKFLAIFDAVLTPFLNPVVYTFRNKEMKAAIKR
VCKQLVIYKRIS
>ENSP00000478421.2|ENST00000616016.5|ENSG00000187634.13|OTTHUMG00000040719.11|OTTHUMT00000316521.3|SAMD11-209|SAMD11|844
MPAVKKEFPGREDLALALATFHPTLAALPLPPLPGYLAPLPAAAALPPAASLPASAAGYE
ALLAPPLRPPRAYLSLHEAAPHLHLPRDPLALERFSATAAAAPDFQPLLDNGEPCIEVEC
GANRALLYVRKLCQGSKGPSIRHRGEWLTPNEFQFVSGRETAKDWKRSIRHKGKSLKTLM
SKGILQVHPPICDCPGCRISSPVNRGRLADKRTVALPAARNLKKERTPSFSASDGDSDGS
GPTCGRRPGLKQEDGPHIRIMKRRVHTHWDVNISFREASCSQDGNLPTLISSVHRSRHLV
MPEHQSRCEFQRGSLEIGLRPAGDLLGKRLGRSPRISSDCFSEKRARSESPQEALLLPRE
LGPSMAPEDHYRRLVSALSEASTFEDPQRLYHLGLPSHDLLRVRQEVAAAALRGPSGLEA
HLPSSTAGQRRKQGLAQHREGAAPAAAPSFSERELPQPPPLLSPQNAPHVALGPHLRPPF
LGVPSALCQTPGYGFLPPAQAEMFAWQQELLRKQNLARLELPADLLRQKELESARPQLLA
PETALRPNDGAEELQRRGALLVLNHGAAPLLALPPQGPPGSGPPTPSRDSARRAPRKGGP
GPASARPSESKEMTGARLWAQDGSEDEPPKDSDGEDPETAAVGCRGPTPGQAPAGGAGAE
GKGLFPGSTLPLGFPYAVSPYFHTGAVGGLSMDGEEAPAPEDVTKWTVDDVCSFVGGLSG
CGEYTRVFREQGIDGETLPLLTEEHLLTNMGLKLGPALKIRAQVARRLGRVFYVASFPVA
LPLQPPTLRAPERELGTGEQPLSPTTATSPYGGGHALAGQTSPKQENGTLALLPGAPDPS
QPLC"""


def test_custom_table(tmp_path):
    """tests fasta mapping with snippet from gencode v48"""
    temp_file = tmp_path / "fasta_snippet.fa"
    temp_file.write_text(FASTA_SNIPPET)
    mapper = xlranker.util.mapping.PeptideMapper(
        mapping_table_path=str(temp_file),
        is_fasta=True,
        split_index=6,
        fasta_type=xlranker.util.mapping.FastaType.GENCODE,
    )
    sequences = ["LHYTTIM", "AVAWTLGVSHS", "PLLALPPQGPPG"]
    res = mapper.map_sequences(sequences)
    assert res.peptide_to_protein["LHYTTIM"] == ["OR4F5"]
    assert res.peptide_to_protein["AVAWTLGVSHS"] == [
        "OR4F16",
        "OR4F29",
    ] or res.peptide_to_protein["AVAWTLGVSHS"] == [
        "OR4F29",
        "OR4F16",
    ]
    assert res.peptide_to_protein["PLLALPPQGPPG"] == ["SAMD11"]
