from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .action_config import Action_config
    from .action_secrets import Action_secrets

@dataclass
class Action(AdditionalDataHolder, Parsable):
    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: Dict[str, Any] = field(default_factory=dict)

    # The active property
    active: Optional[bool] = None
    # The config property
    config: Optional[Action_config] = None
    # The event property
    event: Optional[str] = None
    # The id property
    id: Optional[int] = None
    # The runAlways property
    run_always: Optional[bool] = None
    # The secrets property
    secrets: Optional[Action_secrets] = None
    # The testId property
    test_id: Optional[int] = None
    # The type property
    type: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> Action:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: Action
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return Action()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .action_config import Action_config
        from .action_secrets import Action_secrets

        from .action_config import Action_config
        from .action_secrets import Action_secrets

        fields: Dict[str, Callable[[Any], None]] = {
            "active": lambda n : setattr(self, 'active', n.get_bool_value()),
            "config": lambda n : setattr(self, 'config', n.get_object_value(Action_config)),
            "event": lambda n : setattr(self, 'event', n.get_str_value()),
            "id": lambda n : setattr(self, 'id', n.get_int_value()),
            "runAlways": lambda n : setattr(self, 'run_always', n.get_bool_value()),
            "secrets": lambda n : setattr(self, 'secrets', n.get_object_value(Action_secrets)),
            "testId": lambda n : setattr(self, 'test_id', n.get_int_value()),
            "type": lambda n : setattr(self, 'type', n.get_str_value()),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        writer.write_bool_value("active", self.active)
        writer.write_object_value("config", self.config)
        writer.write_str_value("event", self.event)
        writer.write_int_value("id", self.id)
        writer.write_bool_value("runAlways", self.run_always)
        writer.write_object_value("secrets", self.secrets)
        writer.write_int_value("testId", self.test_id)
        writer.write_str_value("type", self.type)
        writer.write_additional_data_value(self.additional_data)
    

