from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .dataset_info import DatasetInfo

from .dataset_info import DatasetInfo

@dataclass
class ExperimentResult_datasetInfo(DatasetInfo):
    """
    Dataset Info about dataset used for experiment
    """
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> ExperimentResult_datasetInfo:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: ExperimentResult_datasetInfo
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return ExperimentResult_datasetInfo()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .dataset_info import DatasetInfo

        from .dataset_info import DatasetInfo

        fields: Dict[str, Callable[[Any], None]] = {
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
    

