from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

class vtkEdgeLayoutStrategy(vtkmodules.vtkCommonCore.vtkObject):
    def GetEdgeWeightArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkEdgeLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkEdgeLayoutStrategy: ...
    def SetEdgeWeightArrayName(self, _arg:str) -> None: ...
    def SetGraph(self, graph:vtkGraph) -> None: ...

class vtkArcParallelEdgeStrategy(vtkEdgeLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubdivisions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkArcParallelEdgeStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkArcParallelEdgeStrategy: ...
    def SetNumberOfSubdivisions(self, _arg:int) -> None: ...

class vtkAreaLayout(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def EdgeRoutingPointsOff(self) -> None: ...
    def EdgeRoutingPointsOn(self) -> None: ...
    def FindVertex(self, pnt:[float, float]) -> int: ...
    def GetAreaArrayName(self) -> str: ...
    def GetBoundingArea(self, id:int, sinfo:[float, ...]) -> None: ...
    def GetEdgeRoutingPoints(self) -> bool: ...
    def GetLayoutStrategy(self) -> vtkAreaLayoutStrategy: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAreaLayout: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAreaLayout: ...
    def SetAreaArrayName(self, _arg:str) -> None: ...
    def SetEdgeRoutingPoints(self, _arg:bool) -> None: ...
    def SetLayoutStrategy(self, strategy:vtkAreaLayoutStrategy) -> None: ...
    def SetSizeArrayName(self, name:str) -> None: ...

class vtkAreaLayoutStrategy(vtkmodules.vtkCommonCore.vtkObject):
    def FindVertex(self, tree:vtkTree, array:vtkDataArray, pnt:[float, float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkPercentage(self) -> float: ...
    def GetShrinkPercentageMaxValue(self) -> float: ...
    def GetShrinkPercentageMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self, inputTree:vtkTree, areaArray:vtkDataArray, sizeArray:vtkDataArray) -> None: ...
    def LayoutEdgePoints(self, inputTree:vtkTree, areaArray:vtkDataArray, sizeArray:vtkDataArray, edgeRoutingTree:vtkTree) -> None: ...
    def NewInstance(self) -> vtkAreaLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAreaLayoutStrategy: ...
    def SetShrinkPercentage(self, _arg:float) -> None: ...

class vtkAssignCoordinates(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetXCoordArrayName(self) -> str: ...
    def GetYCoordArrayName(self) -> str: ...
    def GetZCoordArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAssignCoordinates: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAssignCoordinates: ...
    def SetJitter(self, _arg:bool) -> None: ...
    def SetXCoordArrayName(self, _arg:str) -> None: ...
    def SetYCoordArrayName(self, _arg:str) -> None: ...
    def SetZCoordArrayName(self, _arg:str) -> None: ...

class vtkGraphLayoutStrategy(vtkmodules.vtkCommonCore.vtkObject):
    def GetEdgeWeightField(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWeightEdges(self) -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkGraphLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphLayoutStrategy: ...
    def SetEdgeWeightField(self, field:str) -> None: ...
    def SetGraph(self, graph:vtkGraph) -> None: ...
    def SetWeightEdges(self, state:bool) -> None: ...

class vtkAssignCoordinatesLayoutStrategy(vtkGraphLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetXCoordArrayName(self) -> str: ...
    def GetYCoordArrayName(self) -> str: ...
    def GetZCoordArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkAssignCoordinatesLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAssignCoordinatesLayoutStrategy: ...
    def SetXCoordArrayName(self, name:str) -> None: ...
    def SetYCoordArrayName(self, name:str) -> None: ...
    def SetZCoordArrayName(self, name:str) -> None: ...

class vtkAttributeClustering2DLayoutStrategy(vtkGraphLayoutStrategy):
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetInitialTemperature(self) -> float: ...
    def GetInitialTemperatureMaxValue(self) -> float: ...
    def GetInitialTemperatureMinValue(self) -> float: ...
    def GetIterationsPerLayout(self) -> int: ...
    def GetIterationsPerLayoutMaxValue(self) -> int: ...
    def GetIterationsPerLayoutMinValue(self) -> int: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetRestDistance(self) -> float: ...
    def GetVertexAttribute(self) -> str: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkAttributeClustering2DLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAttributeClustering2DLayoutStrategy: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    def SetInitialTemperature(self, _arg:float) -> None: ...
    def SetIterationsPerLayout(self, _arg:int) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetRestDistance(self, _arg:float) -> None: ...
    def SetVertexAttribute(self, __a:str) -> None: ...

class vtkTreeMapLayoutStrategy(vtkAreaLayoutStrategy):
    def FindVertex(self, tree:vtkTree, areaArray:vtkDataArray, pnt:[float, float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTreeMapLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeMapLayoutStrategy: ...

class vtkBoxLayoutStrategy(vtkTreeMapLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self, inputTree:vtkTree, coordsArray:vtkDataArray, sizeArray:vtkDataArray) -> None: ...
    def NewInstance(self) -> vtkBoxLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkBoxLayoutStrategy: ...

class vtkCirclePackLayoutStrategy(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self, inputTree:vtkTree, areaArray:vtkDataArray, sizeArray:vtkDataArray) -> None: ...
    def NewInstance(self) -> vtkCirclePackLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCirclePackLayoutStrategy: ...

class vtkCirclePackFrontChainLayoutStrategy(vtkCirclePackLayoutStrategy):
    def GetHeight(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWidth(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self, inputTree:vtkTree, areaArray:vtkDataArray, sizeArray:vtkDataArray) -> None: ...
    def NewInstance(self) -> vtkCirclePackFrontChainLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCirclePackFrontChainLayoutStrategy: ...
    def SetHeight(self, _arg:int) -> None: ...
    def SetWidth(self, _arg:int) -> None: ...

class vtkCirclePackLayout(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def FindVertex(self, pnt:[float, float], cinfo:[float, ...]=...) -> int: ...
    def GetBoundingCircle(self, id:int, cinfo:[float, ...]) -> None: ...
    def GetCirclesFieldName(self) -> str: ...
    def GetLayoutStrategy(self) -> vtkCirclePackLayoutStrategy: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCirclePackLayout: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCirclePackLayout: ...
    def SetCirclesFieldName(self, _arg:str) -> None: ...
    def SetLayoutStrategy(self, strategy:vtkCirclePackLayoutStrategy) -> None: ...
    def SetSizeArrayName(self, name:str) -> None: ...

class vtkCirclePackToPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def FillInputPortInformation(self, port:int, info:vtkInformation) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResolution(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCirclePackToPolyData: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCirclePackToPolyData: ...
    def SetCirclesArrayName(self, name:str) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...

class vtkCircularLayoutStrategy(vtkGraphLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkCircularLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCircularLayoutStrategy: ...

class vtkClustering2DLayoutStrategy(vtkGraphLayoutStrategy):
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetInitialTemperature(self) -> float: ...
    def GetInitialTemperatureMaxValue(self) -> float: ...
    def GetInitialTemperatureMinValue(self) -> float: ...
    def GetIterationsPerLayout(self) -> int: ...
    def GetIterationsPerLayoutMaxValue(self) -> int: ...
    def GetIterationsPerLayoutMinValue(self) -> int: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetRestDistance(self) -> float: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkClustering2DLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkClustering2DLayoutStrategy: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    def SetInitialTemperature(self, _arg:float) -> None: ...
    def SetIterationsPerLayout(self, _arg:int) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetRestDistance(self, _arg:float) -> None: ...

class vtkCommunity2DLayoutStrategy(vtkGraphLayoutStrategy):
    def GetCommunityArrayName(self) -> str: ...
    def GetCommunityStrength(self) -> float: ...
    def GetCommunityStrengthMaxValue(self) -> float: ...
    def GetCommunityStrengthMinValue(self) -> float: ...
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetInitialTemperature(self) -> float: ...
    def GetInitialTemperatureMaxValue(self) -> float: ...
    def GetInitialTemperatureMinValue(self) -> float: ...
    def GetIterationsPerLayout(self) -> int: ...
    def GetIterationsPerLayoutMaxValue(self) -> int: ...
    def GetIterationsPerLayoutMinValue(self) -> int: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetRestDistance(self) -> float: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkCommunity2DLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCommunity2DLayoutStrategy: ...
    def SetCommunityArrayName(self, _arg:str) -> None: ...
    def SetCommunityStrength(self, _arg:float) -> None: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    def SetInitialTemperature(self, _arg:float) -> None: ...
    def SetIterationsPerLayout(self, _arg:int) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetRestDistance(self, _arg:float) -> None: ...

class vtkConeLayoutStrategy(vtkGraphLayoutStrategy):
    def CompressionOff(self) -> None: ...
    def CompressionOn(self) -> None: ...
    def GetCompactness(self) -> float: ...
    def GetCompression(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpacing(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkConeLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkConeLayoutStrategy: ...
    def SetCompactness(self, _arg:float) -> None: ...
    def SetCompression(self, _arg:int) -> None: ...
    def SetSpacing(self, _arg:float) -> None: ...

class vtkConstrained2DLayoutStrategy(vtkGraphLayoutStrategy):
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetInitialTemperature(self) -> float: ...
    def GetInitialTemperatureMaxValue(self) -> float: ...
    def GetInitialTemperatureMinValue(self) -> float: ...
    def GetInputArrayName(self) -> str: ...
    def GetIterationsPerLayout(self) -> int: ...
    def GetIterationsPerLayoutMaxValue(self) -> int: ...
    def GetIterationsPerLayoutMinValue(self) -> int: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetRestDistance(self) -> float: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkConstrained2DLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkConstrained2DLayoutStrategy: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    def SetInitialTemperature(self, _arg:float) -> None: ...
    def SetInputArrayName(self, _arg:str) -> None: ...
    def SetIterationsPerLayout(self, _arg:int) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetRestDistance(self, _arg:float) -> None: ...

class vtkCosmicTreeLayoutStrategy(vtkGraphLayoutStrategy):
    def GetLayoutDepth(self) -> int: ...
    def GetLayoutRoot(self) -> int: ...
    def GetNodeSizeArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSizeLeafNodesOnly(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkCosmicTreeLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCosmicTreeLayoutStrategy: ...
    def SetLayoutDepth(self, _arg:int) -> None: ...
    def SetLayoutRoot(self, _arg:int) -> None: ...
    def SetNodeSizeArrayName(self, _arg:str) -> None: ...
    def SetSizeLeafNodesOnly(self, _arg:int) -> None: ...
    def SizeLeafNodesOnlyOff(self) -> None: ...
    def SizeLeafNodesOnlyOn(self) -> None: ...

class vtkEdgeLayout(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetLayoutStrategy(self) -> vtkEdgeLayoutStrategy: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkEdgeLayout: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkEdgeLayout: ...
    def SetLayoutStrategy(self, strategy:vtkEdgeLayoutStrategy) -> None: ...

class vtkFast2DLayoutStrategy(vtkGraphLayoutStrategy):
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetInitialTemperature(self) -> float: ...
    def GetInitialTemperatureMaxValue(self) -> float: ...
    def GetInitialTemperatureMinValue(self) -> float: ...
    def GetIterationsPerLayout(self) -> int: ...
    def GetIterationsPerLayoutMaxValue(self) -> int: ...
    def GetIterationsPerLayoutMinValue(self) -> int: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetRestDistance(self) -> float: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkFast2DLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFast2DLayoutStrategy: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    def SetInitialTemperature(self, _arg:float) -> None: ...
    def SetIterationsPerLayout(self, _arg:int) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetRestDistance(self, _arg:float) -> None: ...

class vtkForceDirectedLayoutStrategy(vtkGraphLayoutStrategy):
    def AutomaticBoundsComputationOff(self) -> None: ...
    def AutomaticBoundsComputationOn(self) -> None: ...
    def GetAutomaticBoundsComputation(self) -> int: ...
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetGraphBounds(self) -> (float, float, float, float, float, float): ...
    def GetInitialTemperature(self) -> float: ...
    def GetInitialTemperatureMaxValue(self) -> float: ...
    def GetInitialTemperatureMinValue(self) -> float: ...
    def GetIterationsPerLayout(self) -> int: ...
    def GetIterationsPerLayoutMaxValue(self) -> int: ...
    def GetIterationsPerLayoutMinValue(self) -> int: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomInitialPoints(self) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetThreeDimensionalLayout(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkForceDirectedLayoutStrategy: ...
    def RandomInitialPointsOff(self) -> None: ...
    def RandomInitialPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkForceDirectedLayoutStrategy: ...
    def SetAutomaticBoundsComputation(self, _arg:int) -> None: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    @overload
    def SetGraphBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetGraphBounds(self, _arg:(float, float, float, float, float, float)) -> None: ...
    def SetInitialTemperature(self, _arg:float) -> None: ...
    def SetIterationsPerLayout(self, _arg:int) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetRandomInitialPoints(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetThreeDimensionalLayout(self, _arg:int) -> None: ...
    def ThreeDimensionalLayoutOff(self) -> None: ...
    def ThreeDimensionalLayoutOn(self) -> None: ...

class vtkGeoEdgeStrategy(vtkEdgeLayoutStrategy):
    def GetExplodeFactor(self) -> float: ...
    def GetGlobeRadius(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubdivisions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkGeoEdgeStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGeoEdgeStrategy: ...
    def SetExplodeFactor(self, _arg:float) -> None: ...
    def SetGlobeRadius(self, _arg:float) -> None: ...
    def SetNumberOfSubdivisions(self, _arg:int) -> None: ...

class vtkGeoMath(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def DistanceSquared(pt0:[float, float, float], pt1:[float, float, float]) -> float: ...
    @staticmethod
    def EarthRadiusMeters() -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def LongLatAltToRect(longLatAlt:[float, float, float], rect:[float, float, float]) -> None: ...
    def NewInstance(self) -> vtkGeoMath: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGeoMath: ...

class vtkGraphLayout(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetLayoutStrategy(self) -> vtkGraphLayoutStrategy: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTransform(self) -> vtkAbstractTransform: ...
    def GetUseTransform(self) -> bool: ...
    def GetZRange(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGraphLayout: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphLayout: ...
    def SetLayoutStrategy(self, strategy:vtkGraphLayoutStrategy) -> None: ...
    def SetTransform(self, t:vtkAbstractTransform) -> None: ...
    def SetUseTransform(self, _arg:bool) -> None: ...
    def SetZRange(self, _arg:float) -> None: ...
    def UseTransformOff(self) -> None: ...
    def UseTransformOn(self) -> None: ...

class vtkIncrementalForceLayout(vtkmodules.vtkCommonCore.vtkObject):
    def GetAlpha(self) -> float: ...
    def GetCharge(self) -> float: ...
    def GetDistance(self) -> float: ...
    def GetFixed(self) -> int: ...
    def GetFriction(self) -> float: ...
    def GetGraph(self) -> vtkGraph: ...
    def GetGravity(self) -> float: ...
    def GetGravityPoint(self) -> vtkVector2f: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStrength(self) -> float: ...
    def GetTheta(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkIncrementalForceLayout: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkIncrementalForceLayout: ...
    def SetAlpha(self, _arg:float) -> None: ...
    def SetCharge(self, _arg:float) -> None: ...
    def SetDistance(self, _arg:float) -> None: ...
    def SetFixed(self, fixed:int) -> None: ...
    def SetFriction(self, _arg:float) -> None: ...
    def SetGraph(self, g:vtkGraph) -> None: ...
    def SetGravity(self, _arg:float) -> None: ...
    def SetGravityPoint(self, point:vtkVector2f) -> None: ...
    def SetStrength(self, _arg:float) -> None: ...
    def SetTheta(self, _arg:float) -> None: ...
    def UpdatePositions(self) -> None: ...

class vtkKCoreLayout(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def CartesianOff(self) -> None: ...
    def CartesianOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:vtkInformation) -> int: ...
    def GetCartesian(self) -> bool: ...
    def GetCartesianCoordsXArrayName(self) -> str: ...
    def GetCartesianCoordsYArrayName(self) -> str: ...
    def GetEpsilon(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolar(self) -> bool: ...
    def GetPolarCoordsAngleArrayName(self) -> str: ...
    def GetPolarCoordsRadiusArrayName(self) -> str: ...
    def GetUnitRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkKCoreLayout: ...
    def PolarOff(self) -> None: ...
    def PolarOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkKCoreLayout: ...
    def SetCartesian(self, _arg:bool) -> None: ...
    def SetCartesianCoordsXArrayName(self, _arg:str) -> None: ...
    def SetCartesianCoordsYArrayName(self, _arg:str) -> None: ...
    def SetEpsilon(self, _arg:float) -> None: ...
    def SetGraphConnection(self, __a:vtkAlgorithmOutput) -> None: ...
    def SetKCoreLabelArrayName(self, _arg:str) -> None: ...
    def SetPolar(self, _arg:bool) -> None: ...
    def SetPolarCoordsAngleArrayName(self, _arg:str) -> None: ...
    def SetPolarCoordsRadiusArrayName(self, _arg:str) -> None: ...
    def SetUnitRadius(self, _arg:float) -> None: ...

class vtkPassThroughEdgeStrategy(vtkEdgeLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkPassThroughEdgeStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPassThroughEdgeStrategy: ...

class vtkPassThroughLayoutStrategy(vtkGraphLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkPassThroughLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPassThroughLayoutStrategy: ...

class vtkPerturbCoincidentVertices(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPerturbFactor(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPerturbCoincidentVertices: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPerturbCoincidentVertices: ...
    def SetPerturbFactor(self, _arg:float) -> None: ...

class vtkRandomLayoutStrategy(vtkGraphLayoutStrategy):
    def AutomaticBoundsComputationOff(self) -> None: ...
    def AutomaticBoundsComputationOn(self) -> None: ...
    def GetAutomaticBoundsComputation(self) -> int: ...
    def GetGraphBounds(self) -> (float, float, float, float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetThreeDimensionalLayout(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkRandomLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRandomLayoutStrategy: ...
    def SetAutomaticBoundsComputation(self, _arg:int) -> None: ...
    def SetGraph(self, graph:vtkGraph) -> None: ...
    @overload
    def SetGraphBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetGraphBounds(self, _arg:(float, float, float, float, float, float)) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetThreeDimensionalLayout(self, _arg:int) -> None: ...
    def ThreeDimensionalLayoutOff(self) -> None: ...
    def ThreeDimensionalLayoutOn(self) -> None: ...

class vtkSimple2DLayoutStrategy(vtkGraphLayoutStrategy):
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetInitialTemperature(self) -> float: ...
    def GetInitialTemperatureMaxValue(self) -> float: ...
    def GetInitialTemperatureMinValue(self) -> float: ...
    def GetIterationsPerLayout(self) -> int: ...
    def GetIterationsPerLayoutMaxValue(self) -> int: ...
    def GetIterationsPerLayoutMinValue(self) -> int: ...
    def GetJitter(self) -> bool: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetRandomSeedMaxValue(self) -> int: ...
    def GetRandomSeedMinValue(self) -> int: ...
    def GetRestDistance(self) -> float: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkSimple2DLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSimple2DLayoutStrategy: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    def SetInitialTemperature(self, _arg:float) -> None: ...
    def SetIterationsPerLayout(self, _arg:int) -> None: ...
    def SetJitter(self, _arg:bool) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetRestDistance(self, _arg:float) -> None: ...

class vtkSimple3DCirclesStrategy(vtkGraphLayoutStrategy):
    FixedDistanceMethod:int
    FixedRadiusMethod:int
    def AutoHeightOff(self) -> None: ...
    def AutoHeightOn(self) -> None: ...
    def ForceToUseUniversalStartPointsFinderOff(self) -> None: ...
    def ForceToUseUniversalStartPointsFinderOn(self) -> None: ...
    def GetAutoHeight(self) -> int: ...
    def GetDirection(self) -> (float, float, float): ...
    def GetForceToUseUniversalStartPointsFinder(self) -> int: ...
    def GetHeight(self) -> float: ...
    def GetHierarchicalLayers(self) -> vtkIntArray: ...
    def GetHierarchicalOrder(self) -> vtkIdTypeArray: ...
    def GetMarkedStartVertices(self) -> vtkAbstractArray: ...
    def GetMarkedValue(self) -> vtkVariant: ...
    def GetMethod(self) -> int: ...
    def GetMinimumDegree(self) -> float: ...
    def GetMinimumRadian(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> (float, float, float): ...
    def GetRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkSimple3DCirclesStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSimple3DCirclesStrategy: ...
    def SetAutoHeight(self, _arg:int) -> None: ...
    @overload
    def SetDirection(self, dx:float, dy:float, dz:float) -> None: ...
    @overload
    def SetDirection(self, d:[float, float, float]) -> None: ...
    def SetForceToUseUniversalStartPointsFinder(self, _arg:int) -> None: ...
    def SetGraph(self, graph:vtkGraph) -> None: ...
    def SetHeight(self, _arg:float) -> None: ...
    def SetHierarchicalLayers(self, _arg:vtkIntArray) -> None: ...
    def SetHierarchicalOrder(self, _arg:vtkIdTypeArray) -> None: ...
    def SetMarkedStartVertices(self, _arg:vtkAbstractArray) -> None: ...
    def SetMarkedValue(self, _arg:vtkVariant) -> None: ...
    def SetMethod(self, _arg:int) -> None: ...
    def SetMinimumDegree(self, degree:float) -> None: ...
    def SetMinimumRadian(self, _arg:float) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:(float, float, float)) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkSliceAndDiceLayoutStrategy(vtkTreeMapLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self, inputTree:vtkTree, coordsArray:vtkDataArray, sizeArray:vtkDataArray) -> None: ...
    def NewInstance(self) -> vtkSliceAndDiceLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSliceAndDiceLayoutStrategy: ...

class vtkSpanTreeLayoutStrategy(vtkGraphLayoutStrategy):
    def DepthFirstSpanningTreeOff(self) -> None: ...
    def DepthFirstSpanningTreeOn(self) -> None: ...
    def GetDepthFirstSpanningTree(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkSpanTreeLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSpanTreeLayoutStrategy: ...
    def SetDepthFirstSpanningTree(self, _arg:bool) -> None: ...

class vtkSplineGraphEdges(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    BSPLINE:int
    CUSTOM:int
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubdivisions(self) -> int: ...
    def GetSpline(self) -> vtkSpline: ...
    def GetSplineType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSplineGraphEdges: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSplineGraphEdges: ...
    def SetNumberOfSubdivisions(self, _arg:int) -> None: ...
    def SetSpline(self, s:vtkSpline) -> None: ...
    def SetSplineType(self, _arg:int) -> None: ...

class vtkSquarifyLayoutStrategy(vtkTreeMapLayoutStrategy):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self, inputTree:vtkTree, coordsArray:vtkDataArray, sizeArray:vtkDataArray) -> None: ...
    def NewInstance(self) -> vtkSquarifyLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSquarifyLayoutStrategy: ...

class vtkStackedTreeLayoutStrategy(vtkAreaLayoutStrategy):
    def FindVertex(self, tree:vtkTree, array:vtkDataArray, pnt:[float, float]) -> int: ...
    def GetInteriorLogSpacingValue(self) -> float: ...
    def GetInteriorRadius(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReverse(self) -> bool: ...
    def GetRingThickness(self) -> float: ...
    def GetRootEndAngle(self) -> float: ...
    def GetRootStartAngle(self) -> float: ...
    def GetUseRectangularCoordinates(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self, inputTree:vtkTree, sectorArray:vtkDataArray, sizeArray:vtkDataArray) -> None: ...
    def LayoutEdgePoints(self, inputTree:vtkTree, sectorArray:vtkDataArray, sizeArray:vtkDataArray, edgeRoutingTree:vtkTree) -> None: ...
    def NewInstance(self) -> vtkStackedTreeLayoutStrategy: ...
    def ReverseOff(self) -> None: ...
    def ReverseOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStackedTreeLayoutStrategy: ...
    def SetInteriorLogSpacingValue(self, _arg:float) -> None: ...
    def SetInteriorRadius(self, _arg:float) -> None: ...
    def SetReverse(self, _arg:bool) -> None: ...
    def SetRingThickness(self, _arg:float) -> None: ...
    def SetRootEndAngle(self, _arg:float) -> None: ...
    def SetRootStartAngle(self, _arg:float) -> None: ...
    def SetUseRectangularCoordinates(self, _arg:bool) -> None: ...
    def UseRectangularCoordinatesOff(self) -> None: ...
    def UseRectangularCoordinatesOn(self) -> None: ...

class vtkTreeLayoutStrategy(vtkGraphLayoutStrategy):
    def GetAngle(self) -> float: ...
    def GetAngleMaxValue(self) -> float: ...
    def GetAngleMinValue(self) -> float: ...
    def GetDistanceArrayName(self) -> str: ...
    def GetLeafSpacing(self) -> float: ...
    def GetLeafSpacingMaxValue(self) -> float: ...
    def GetLeafSpacingMinValue(self) -> float: ...
    def GetLogSpacingValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadial(self) -> bool: ...
    def GetReverseEdges(self) -> bool: ...
    def GetRotation(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkTreeLayoutStrategy: ...
    def RadialOff(self) -> None: ...
    def RadialOn(self) -> None: ...
    def ReverseEdgesOff(self) -> None: ...
    def ReverseEdgesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeLayoutStrategy: ...
    def SetAngle(self, _arg:float) -> None: ...
    def SetDistanceArrayName(self, _arg:str) -> None: ...
    def SetLeafSpacing(self, _arg:float) -> None: ...
    def SetLogSpacingValue(self, _arg:float) -> None: ...
    def SetRadial(self, _arg:bool) -> None: ...
    def SetReverseEdges(self, _arg:bool) -> None: ...
    def SetRotation(self, _arg:float) -> None: ...

class vtkTreeMapLayout(vtkmodules.vtkCommonExecutionModel.vtkTreeAlgorithm):
    def FindVertex(self, pnt:[float, float], binfo:[float, ...]=...) -> int: ...
    def GetBoundingBox(self, id:int, binfo:[float, ...]) -> None: ...
    def GetLayoutStrategy(self) -> vtkTreeMapLayoutStrategy: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRectanglesFieldName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTreeMapLayout: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeMapLayout: ...
    def SetLayoutStrategy(self, strategy:vtkTreeMapLayoutStrategy) -> None: ...
    def SetRectanglesFieldName(self, _arg:str) -> None: ...
    def SetSizeArrayName(self, name:str) -> None: ...

class vtkTreeMapToPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def FillInputPortInformation(self, port:int, info:vtkInformation) -> int: ...
    def GetAddNormals(self) -> bool: ...
    def GetLevelDeltaZ(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTreeMapToPolyData: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeMapToPolyData: ...
    def SetAddNormals(self, _arg:bool) -> None: ...
    def SetLevelArrayName(self, name:str) -> None: ...
    def SetLevelDeltaZ(self, _arg:float) -> None: ...
    def SetRectanglesArrayName(self, name:str) -> None: ...

class vtkTreeOrbitLayoutStrategy(vtkGraphLayoutStrategy):
    def GetChildRadiusFactor(self) -> float: ...
    def GetLeafSpacing(self) -> float: ...
    def GetLeafSpacingMaxValue(self) -> float: ...
    def GetLeafSpacingMinValue(self) -> float: ...
    def GetLogSpacingValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Layout(self) -> None: ...
    def NewInstance(self) -> vtkTreeOrbitLayoutStrategy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeOrbitLayoutStrategy: ...
    def SetChildRadiusFactor(self, _arg:float) -> None: ...
    def SetLeafSpacing(self, _arg:float) -> None: ...
    def SetLogSpacingValue(self, _arg:float) -> None: ...

class vtkTreeRingToPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def FillInputPortInformation(self, port:int, info:vtkInformation) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkPercentage(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTreeRingToPolyData: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeRingToPolyData: ...
    def SetSectorsArrayName(self, name:str) -> None: ...
    def SetShrinkPercentage(self, _arg:float) -> None: ...

