from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel

VTKIS_ANIM_OFF:int
VTKIS_ANIM_ON:int
VTKIS_CLIP:int
VTKIS_DOLLY:int
VTKIS_ELEVATION:int
VTKIS_ENV_ROTATE:int
VTKIS_EXIT:int
VTKIS_FORWARDFLY:int
VTKIS_GESTURE:int
VTKIS_GROUNDMOVEMENT:int
VTKIS_LOAD_CAMERA_POSE:int
VTKIS_MENU:int
VTKIS_NONE:int
VTKIS_PAN:int
VTKIS_PICK:int
VTKIS_POSITION_PROP:int
VTKIS_REVERSEFLY:int
VTKIS_ROTATE:int
VTKIS_SPIN:int
VTKIS_START:int
VTKIS_TIMER:int
VTKIS_TOGGLE_DRAW_CONTROLS:int
VTKIS_TWO_POINTER:int
VTKIS_USCALE:int
VTKIS_ZOOM:int
VTKI_MAX_POINTERS:int
VTKI_TIMER_FIRST:int
VTKI_TIMER_UPDATE:int
VTK_BACKGROUND_LOCATION:int
VTK_CTF_DIVERGING:int
VTK_CTF_HSV:int
VTK_CTF_LAB:int
VTK_CTF_LAB_CIEDE2000:int
VTK_CTF_LINEAR:int
VTK_CTF_LOG10:int
VTK_CTF_RGB:int
VTK_CTF_STEP:int
VTK_CULLER_SORT_BACK_TO_FRONT:int
VTK_CULLER_SORT_FRONT_TO_BACK:int
VTK_CULLER_SORT_NONE:int
VTK_CURSOR_ARROW:int
VTK_CURSOR_CROSSHAIR:int
VTK_CURSOR_CUSTOM:int
VTK_CURSOR_DEFAULT:int
VTK_CURSOR_HAND:int
VTK_CURSOR_SIZEALL:int
VTK_CURSOR_SIZENE:int
VTK_CURSOR_SIZENS:int
VTK_CURSOR_SIZENW:int
VTK_CURSOR_SIZESE:int
VTK_CURSOR_SIZESW:int
VTK_CURSOR_SIZEWE:int
VTK_DISPLAY:int
VTK_FLAT:int
VTK_FOREGROUND_LOCATION:int
VTK_GET_ARRAY_BY_ID:int
VTK_GET_ARRAY_BY_NAME:int
VTK_GOURAUD:int
VTK_LIGHT_TYPE_CAMERA_LIGHT:int
VTK_LIGHT_TYPE_HEADLIGHT:int
VTK_LIGHT_TYPE_SCENE_LIGHT:int
VTK_MARKER_CIRCLE:int
VTK_MARKER_CROSS:int
VTK_MARKER_DIAMOND:int
VTK_MARKER_NONE:int
VTK_MARKER_PLUS:int
VTK_MARKER_SQUARE:int
VTK_MARKER_UNKNOWN:int
VTK_MATERIALMODE_AMBIENT:int
VTK_MATERIALMODE_AMBIENT_AND_DIFFUSE:int
VTK_MATERIALMODE_DEFAULT:int
VTK_MATERIALMODE_DIFFUSE:int
VTK_NORMALIZED_DISPLAY:int
VTK_NORMALIZED_VIEWPORT:int
VTK_PBR:int
VTK_PHONG:int
VTK_POINTS:int
VTK_POSE:int
VTK_RESOLVE_OFF:int
VTK_RESOLVE_POLYGON_OFFSET:int
VTK_RESOLVE_SHIFT_ZBUFFER:int
VTK_SCALAR_MODE_DEFAULT:int
VTK_SCALAR_MODE_USE_CELL_DATA:int
VTK_SCALAR_MODE_USE_CELL_FIELD_DATA:int
VTK_SCALAR_MODE_USE_FIELD_DATA:int
VTK_SCALAR_MODE_USE_POINT_DATA:int
VTK_SCALAR_MODE_USE_POINT_FIELD_DATA:int
VTK_STEREO_ANAGLYPH:int
VTK_STEREO_CHECKERBOARD:int
VTK_STEREO_CRYSTAL_EYES:int
VTK_STEREO_DRESDEN:int
VTK_STEREO_EMULATE:int
VTK_STEREO_FAKE:int
VTK_STEREO_INTERLACED:int
VTK_STEREO_LEFT:int
VTK_STEREO_RED_BLUE:int
VTK_STEREO_RIGHT:int
VTK_STEREO_SPLITVIEWPORT_HORIZONTAL:int
VTK_SURFACE:int
VTK_TEXTURE_QUALITY_16BIT:int
VTK_TEXTURE_QUALITY_32BIT:int
VTK_TEXTURE_QUALITY_DEFAULT:int
VTK_USERDEFINED:int
VTK_VIEW:int
VTK_VIEWPORT:int
VTK_WIREFRAME:int
VTK_WORLD:int
VTK_ZBUFFER:int
vtkMaxPythagoreanQuadrupleId:int

class vtkAbstractMapper(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def AddClippingPlane(self, plane:vtkPlane) -> None: ...
    @staticmethod
    def GetAbstractScalars(input:vtkDataSet, scalarMode:int, arrayAccessMode:int, arrayId:int, arrayName:str, cellFlag:int) -> vtkAbstractArray: ...
    def GetClippingPlanes(self) -> vtkPlaneCollection: ...
    @staticmethod
    def GetGhostArray(input:vtkDataSet, scalarMode:int, ghostsToSkip:int) -> vtkUnsignedCharArray: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfClippingPlanes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetScalars(input:vtkDataSet, scalarMode:int, arrayAccessMode:int, arrayId:int, arrayName:str, cellFlag:int) -> vtkDataArray: ...
    def GetTimeToDraw(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RemoveAllClippingPlanes(self) -> None: ...
    def RemoveClippingPlane(self, plane:vtkPlane) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractMapper: ...
    @overload
    def SetClippingPlanes(self, __a:vtkPlaneCollection) -> None: ...
    @overload
    def SetClippingPlanes(self, planes:vtkPlanes) -> None: ...
    def ShallowCopy(self, m:vtkAbstractMapper) -> None: ...

class vtkAbstractMapper3D(vtkAbstractMapper):
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def GetCenter(self) -> (float, float, float): ...
    @overload
    def GetCenter(self, center:[float, float, float]) -> None: ...
    def GetClippingPlaneInDataCoords(self, propMatrix:vtkMatrix4x4, i:int, planeEquation:[float, float, float, float]) -> None: ...
    def GetLength(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsARayCastMapper(self) -> int: ...
    def IsARenderIntoImageMapper(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractMapper3D: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractMapper3D: ...

class vtkAbstractVolumeMapper(vtkAbstractMapper3D):
    def GetArrayAccessMode(self) -> int: ...
    def GetArrayId(self) -> int: ...
    def GetArrayName(self) -> str: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetDataObjectInput(self) -> vtkDataObject: ...
    def GetDataSetInput(self) -> vtkDataSet: ...
    @overload
    def GetGradientMagnitudeBias(self) -> float: ...
    @overload
    def GetGradientMagnitudeBias(self, __a:int) -> float: ...
    @overload
    def GetGradientMagnitudeScale(self) -> float: ...
    @overload
    def GetGradientMagnitudeScale(self, __a:int) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarModeAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractVolumeMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer, vol:vtkVolume) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractVolumeMapper: ...
    @overload
    def SelectScalarArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectScalarArray(self, arrayName:str) -> None: ...
    def SetArrayAccessMode(self, _arg:int) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToDefault(self) -> None: ...
    def SetScalarModeToUseCellData(self) -> None: ...
    def SetScalarModeToUseCellFieldData(self) -> None: ...
    def SetScalarModeToUsePointData(self) -> None: ...
    def SetScalarModeToUsePointFieldData(self) -> None: ...

class vtkAbstractHyperTreeGridMapper(vtkAbstractVolumeMapper):
    def GetColorMap(self) -> vtkScalarsToColors: ...
    def GetInput(self) -> vtkUniformHyperTreeGrid: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetScalarRange(self) -> (float, float): ...
    def GetViewportSize(self) -> (int, int): ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractHyperTreeGridMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, __a:vtkRenderer, __b:vtkVolume) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractHyperTreeGridMapper: ...
    def SetColorMap(self, __a:vtkScalarsToColors) -> None: ...
    @overload
    def SetInputConnection(self, __a:int, __b:vtkAlgorithmOutput) -> None: ...
    @overload
    def SetInputConnection(self, input:vtkAlgorithmOutput) -> None: ...
    def SetInputData(self, __a:vtkUniformHyperTreeGrid) -> None: ...
    def SetRenderer(self, __a:vtkRenderer) -> None: ...
    @overload
    def SetScalarRange(self, __a:float, __b:float) -> None: ...
    @overload
    def SetScalarRange(self, __a:[float, ...]) -> None: ...
    def SetScale(self, _arg:float) -> None: ...

class vtkAbstractInteractionDevice(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderDevice(self) -> vtkAbstractRenderDevice: ...
    def GetRenderWidget(self) -> vtkRenderWidget: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractInteractionDevice: ...
    def ProcessEvents(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractInteractionDevice: ...
    def SetRenderDevice(self, device:vtkAbstractRenderDevice) -> None: ...
    def SetRenderWidget(self, widget:vtkRenderWidget) -> None: ...
    def Start(self) -> None: ...

class vtkAbstractPicker(vtkmodules.vtkCommonCore.vtkObject):
    def AddPickList(self, __a:vtkProp) -> None: ...
    def DeletePickList(self, __a:vtkProp) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickFromList(self) -> int: ...
    def GetPickList(self) -> vtkPropCollection: ...
    def GetPickPosition(self) -> (float, float, float): ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetSelectionPoint(self) -> (float, float, float): ...
    def InitializePickList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractPicker: ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:vtkRenderer) -> int: ...
    @overload
    def Pick(self, selectionPt:[float, float, float], ren:vtkRenderer) -> int: ...
    def Pick3DPoint(self, __a:[float, float, float], __b:vtkRenderer) -> int: ...
    def Pick3DRay(self, __a:[float, float, float], __b:[float, float, float, float], __c:vtkRenderer) -> int: ...
    def PickFromListOff(self) -> None: ...
    def PickFromListOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractPicker: ...
    def SetPickFromList(self, _arg:int) -> None: ...

class vtkAbstractPropPicker(vtkAbstractPicker):
    def GetActor(self) -> vtkActor: ...
    def GetActor2D(self) -> vtkActor2D: ...
    def GetAssembly(self) -> vtkAssembly: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPath(self) -> vtkAssemblyPath: ...
    def GetProp3D(self) -> vtkProp3D: ...
    def GetPropAssembly(self) -> vtkPropAssembly: ...
    def GetViewProp(self) -> vtkProp: ...
    def GetVolume(self) -> vtkVolume: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractPropPicker: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractPropPicker: ...
    def SetPath(self, __a:vtkAssemblyPath) -> None: ...

class vtkAbstractRenderDevice(vtkmodules.vtkCommonCore.vtkObject):
    def CreateNewWindow(self, geometry:vtkRecti, name:str) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> vtkAbstractRenderDevice: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractRenderDevice: ...
    def SetRequestedGLVersion(self, major:int, minor:int) -> None: ...

class vtkProp(vtkmodules.vtkCommonCore.vtkObject):
    def AddConsumer(self, c:vtkObject) -> None: ...
    def AddEstimatedRenderTime(self, t:float, vp:vtkViewport) -> None: ...
    def BuildPaths(self, paths:vtkAssemblyPaths, path:vtkAssemblyPath) -> None: ...
    def DragableOff(self) -> None: ...
    def DragableOn(self) -> None: ...
    @staticmethod
    def GeneralTextureTransform() -> vtkInformationDoubleVectorKey: ...
    @staticmethod
    def GeneralTextureUnit() -> vtkInformationIntegerKey: ...
    def GetActors(self, __a:vtkPropCollection) -> None: ...
    def GetActors2D(self, __a:vtkPropCollection) -> None: ...
    def GetAllocatedRenderTime(self) -> float: ...
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetConsumer(self, i:int) -> vtkObject: ...
    def GetDragable(self) -> int: ...
    @overload
    def GetEstimatedRenderTime(self, __a:vtkViewport) -> float: ...
    @overload
    def GetEstimatedRenderTime(self) -> float: ...
    def GetMatrix(self) -> vtkMatrix4x4: ...
    def GetNextPath(self) -> vtkAssemblyPath: ...
    def GetNumberOfConsumers(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def GetPickable(self) -> int: ...
    def GetPropertyKeys(self) -> vtkInformation: ...
    def GetRedrawMTime(self) -> int: ...
    def GetRenderTimeMultiplier(self) -> float: ...
    def GetShaderProperty(self) -> vtkShaderProperty: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseBounds(self) -> bool: ...
    def GetVisibility(self) -> int: ...
    def GetVolumes(self, __a:vtkPropCollection) -> None: ...
    def HasKeys(self, requiredKeys:vtkInformation) -> bool: ...
    def HasOpaqueGeometry(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsConsumer(self, c:vtkObject) -> int: ...
    def IsRenderingTranslucentPolygonalGeometry(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProp: ...
    def Pick(self) -> None: ...
    def PickableOff(self) -> None: ...
    def PickableOn(self) -> None: ...
    def PokeMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    def ProcessSelectorPixelBuffers(self, __a:vtkHardwareSelector, __b:[int, ...]) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RemoveConsumer(self, c:vtkObject) -> None: ...
    def RenderFilteredOpaqueGeometry(self, v:vtkViewport, requiredKeys:vtkInformation) -> bool: ...
    def RenderFilteredOverlay(self, v:vtkViewport, requiredKeys:vtkInformation) -> bool: ...
    def RenderFilteredTranslucentPolygonalGeometry(self, v:vtkViewport, requiredKeys:vtkInformation) -> bool: ...
    def RenderFilteredVolumetricGeometry(self, v:vtkViewport, requiredKeys:vtkInformation) -> bool: ...
    def RenderOpaqueGeometry(self, __a:vtkViewport) -> int: ...
    def RenderOverlay(self, __a:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:vtkViewport) -> int: ...
    def RenderVolumetricGeometry(self, __a:vtkViewport) -> int: ...
    def RestoreEstimatedRenderTime(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProp: ...
    def SetAllocatedRenderTime(self, t:float, v:vtkViewport) -> None: ...
    def SetDragable(self, _arg:int) -> None: ...
    def SetEstimatedRenderTime(self, t:float) -> None: ...
    def SetPickable(self, _arg:int) -> None: ...
    def SetPropertyKeys(self, keys:vtkInformation) -> None: ...
    def SetRenderTimeMultiplier(self, t:float) -> None: ...
    def SetShaderProperty(self, property:vtkShaderProperty) -> None: ...
    def SetUseBounds(self, _arg:bool) -> None: ...
    def SetVisibility(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...
    def UseBoundsOff(self) -> None: ...
    def UseBoundsOn(self) -> None: ...
    def VisibilityOff(self) -> None: ...
    def VisibilityOn(self) -> None: ...

class vtkProp3D(vtkProp):
    class CoordinateSystems(int): ...
    DEVICE:'CoordinateSystems'
    PHYSICAL:'CoordinateSystems'
    WORLD:'CoordinateSystems'
    @overload
    def AddOrientation(self, x:float, y:float, z:float) -> None: ...
    @overload
    def AddOrientation(self, orentation:[float, float, float]) -> None: ...
    @overload
    def AddPosition(self, deltaPosition:[float, float, float]) -> None: ...
    @overload
    def AddPosition(self, deltaX:float, deltaY:float, deltaZ:float) -> None: ...
    def ComputeMatrix(self) -> None: ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetCenter(self) -> (float, float, float): ...
    def GetCoordinateSystem(self) -> CoordinateSystems: ...
    def GetCoordinateSystemAsString(self) -> str: ...
    def GetCoordinateSystemDevice(self) -> int: ...
    def GetCoordinateSystemRenderer(self) -> vtkRenderer: ...
    def GetIsIdentity(self) -> int: ...
    def GetLength(self) -> float: ...
    def GetMTime(self) -> int: ...
    @overload
    def GetMatrix(self, result:vtkMatrix4x4) -> None: ...
    @overload
    def GetMatrix(self, result:[float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float]) -> None: ...
    @overload
    def GetMatrix(self) -> vtkMatrix4x4: ...
    def GetModelToWorldMatrix(self, result:vtkMatrix4x4) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrientation(self) -> (float, float, float): ...
    @overload
    def GetOrientation(self, orentation:[float, float, float]) -> None: ...
    def GetOrientationWXYZ(self) -> (float, float, float, float): ...
    def GetOrigin(self) -> (float, float, float): ...
    def GetPosition(self) -> (float, float, float): ...
    def GetScale(self) -> (float, float, float): ...
    def GetUserMatrix(self) -> vtkMatrix4x4: ...
    def GetUserTransform(self) -> vtkLinearTransform: ...
    def GetUserTransformMatrixMTime(self) -> int: ...
    def GetXRange(self) -> (float, float): ...
    def GetYRange(self) -> (float, float): ...
    def GetZRange(self) -> (float, float): ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProp3D: ...
    def PokeMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    def RotateWXYZ(self, w:float, x:float, y:float, z:float) -> None: ...
    def RotateX(self, __a:float) -> None: ...
    def RotateY(self, __a:float) -> None: ...
    def RotateZ(self, __a:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProp3D: ...
    def SetCoordinateSystem(self, val:CoordinateSystems) -> None: ...
    def SetCoordinateSystemDevice(self, _arg:int) -> None: ...
    def SetCoordinateSystemRenderer(self, ren:vtkRenderer) -> None: ...
    def SetCoordinateSystemToDevice(self) -> None: ...
    def SetCoordinateSystemToPhysical(self) -> None: ...
    def SetCoordinateSystemToWorld(self) -> None: ...
    @overload
    def SetOrientation(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrientation(self, orientation:[float, float, float]) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, pos:(float, float, float)) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPosition(self, pos:[float, float, float]) -> None: ...
    def SetPropertiesFromModelToWorldMatrix(self, modelToWorld:vtkMatrix4x4) -> None: ...
    @overload
    def SetScale(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetScale(self, scale:[float, float, float]) -> None: ...
    @overload
    def SetScale(self, s:float) -> None: ...
    def SetUserMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    def SetUserTransform(self, transform:vtkLinearTransform) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkActor(vtkProp3D):
    def ApplyProperties(self) -> None: ...
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetActors(self, __a:vtkPropCollection) -> None: ...
    def GetBackfaceProperty(self) -> vtkProperty: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> vtkMapper: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> vtkProperty: ...
    def GetRedrawMTime(self) -> int: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetTexture(self) -> vtkTexture: ...
    def HasOpaqueGeometry(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsRenderingTranslucentPolygonalGeometry(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeProperty(self) -> vtkProperty: ...
    def NewInstance(self) -> vtkActor: ...
    def ProcessSelectorPixelBuffers(self, sel:vtkHardwareSelector, pixeloffsets:[int, ...]) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, __a:vtkRenderer, __b:vtkMapper) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkActor: ...
    def SetBackfaceProperty(self, lut:vtkProperty) -> None: ...
    def SetForceOpaque(self, _arg:bool) -> None: ...
    def SetForceTranslucent(self, _arg:bool) -> None: ...
    def SetIsRenderingTranslucentPolygonalGeometry(self, val:bool) -> None: ...
    def SetMapper(self, __a:vtkMapper) -> None: ...
    def SetProperty(self, lut:vtkProperty) -> None: ...
    def SetTexture(self, __a:vtkTexture) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkActor2D(vtkProp):
    def GetActors2D(self, pc:vtkPropCollection) -> None: ...
    def GetActualPosition2Coordinate(self) -> vtkCoordinate: ...
    def GetActualPositionCoordinate(self) -> vtkCoordinate: ...
    def GetHeight(self) -> float: ...
    def GetLayerNumber(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> vtkMapper2D: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> (float, float): ...
    def GetPosition2(self) -> (float, float): ...
    def GetPosition2Coordinate(self) -> vtkCoordinate: ...
    def GetPositionCoordinate(self) -> vtkCoordinate: ...
    def GetProperty(self) -> vtkProperty2D: ...
    def GetWidth(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkActor2D: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderOverlay(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkActor2D: ...
    def SetDisplayPosition(self, __a:int, __b:int) -> None: ...
    def SetHeight(self, h:float) -> None: ...
    def SetLayerNumber(self, _arg:int) -> None: ...
    def SetMapper(self, mapper:vtkMapper2D) -> None: ...
    @overload
    def SetPosition(self, x:[float, float]) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float) -> None: ...
    @overload
    def SetPosition2(self, x:[float, float]) -> None: ...
    @overload
    def SetPosition2(self, x:float, y:float) -> None: ...
    def SetProperty(self, __a:vtkProperty2D) -> None: ...
    def SetWidth(self, w:float) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkPropCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, a:vtkProp) -> None: ...
    def GetLastProp(self) -> vtkProp: ...
    def GetNextProp(self) -> vtkProp: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPropCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPropCollection: ...

class vtkActor2DCollection(vtkPropCollection):
    def AddItem(self, a:vtkActor2D) -> None: ...
    def GetLastActor2D(self) -> vtkActor2D: ...
    def GetLastItem(self) -> vtkActor2D: ...
    def GetNextActor2D(self) -> vtkActor2D: ...
    def GetNextItem(self) -> vtkActor2D: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsItemPresent(self, a:vtkActor2D) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkActor2DCollection: ...
    def RenderOverlay(self, viewport:vtkViewport) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkActor2DCollection: ...
    def Sort(self) -> None: ...

class vtkActorCollection(vtkPropCollection):
    def AddItem(self, a:vtkActor) -> None: ...
    def ApplyProperties(self, p:vtkProperty) -> None: ...
    def GetLastActor(self) -> vtkActor: ...
    def GetLastItem(self) -> vtkActor: ...
    def GetNextActor(self) -> vtkActor: ...
    def GetNextItem(self) -> vtkActor: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkActorCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkActorCollection: ...

class vtkAreaPicker(vtkAbstractPropPicker):
    def AreaPick(self, x0:float, y0:float, x1:float, y1:float, renderer:vtkRenderer=...) -> int: ...
    def GetClipPoints(self) -> vtkPoints: ...
    def GetDataSet(self) -> vtkDataSet: ...
    def GetFrustum(self) -> vtkPlanes: ...
    def GetMapper(self) -> vtkAbstractMapper3D: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProp3Ds(self) -> vtkProp3DCollection: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAreaPicker: ...
    @overload
    def Pick(self) -> int: ...
    @overload
    def Pick(self, x0:float, y0:float, z0:float, renderer:vtkRenderer=...) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAreaPicker: ...
    def SetPickCoords(self, x0:float, y0:float, x1:float, y1:float) -> None: ...
    def SetRenderer(self, __a:vtkRenderer) -> None: ...

class vtkAssembly(vtkProp3D):
    def AddPart(self, __a:vtkProp3D) -> None: ...
    def BuildPaths(self, paths:vtkAssemblyPaths, path:vtkAssemblyPath) -> None: ...
    def GetActors(self, __a:vtkPropCollection) -> None: ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetMTime(self) -> int: ...
    def GetNextPath(self) -> vtkAssemblyPath: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def GetParts(self) -> vtkProp3DCollection: ...
    def GetVolumes(self, __a:vtkPropCollection) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAssembly: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RemovePart(self, __a:vtkProp3D) -> None: ...
    def RenderOpaqueGeometry(self, ren:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, ren:vtkViewport) -> int: ...
    def RenderVolumetricGeometry(self, ren:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAssembly: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkAssemblyNode(vtkmodules.vtkCommonCore.vtkObject):
    def GetMTime(self) -> int: ...
    def GetMatrix(self) -> vtkMatrix4x4: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetViewProp(self) -> vtkProp: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAssemblyNode: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAssemblyNode: ...
    def SetMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    def SetViewProp(self, prop:vtkProp) -> None: ...

class vtkAssemblyPath(vtkmodules.vtkCommonCore.vtkCollection):
    def AddNode(self, p:vtkProp, m:vtkMatrix4x4) -> None: ...
    def DeleteLastNode(self) -> None: ...
    def GetFirstNode(self) -> vtkAssemblyNode: ...
    def GetLastNode(self) -> vtkAssemblyNode: ...
    def GetMTime(self) -> int: ...
    def GetNextNode(self) -> vtkAssemblyNode: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAssemblyPath: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAssemblyPath: ...
    def ShallowCopy(self, path:vtkAssemblyPath) -> None: ...

class vtkAssemblyPaths(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, p:vtkAssemblyPath) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNextItem(self) -> vtkAssemblyPath: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsItemPresent(self, p:vtkAssemblyPath) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAssemblyPaths: ...
    def RemoveItem(self, p:vtkAssemblyPath) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAssemblyPaths: ...

class vtkAvatar(vtkActor):
    def GetHeadOrientation(self) -> (float, float, float): ...
    def GetHeadPosition(self) -> (float, float, float): ...
    def GetLeftHandOrientation(self) -> (float, float, float): ...
    def GetLeftHandPosition(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRightHandOrientation(self) -> (float, float, float): ...
    def GetRightHandPosition(self) -> (float, float, float): ...
    def GetShowHandsOnly(self) -> bool: ...
    def GetUpVector(self) -> (float, float, float): ...
    def GetUseLeftHand(self) -> bool: ...
    def GetUseRightHand(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAvatar: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAvatar: ...
    @overload
    def SetHeadOrientation(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetHeadOrientation(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetHeadPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetHeadPosition(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetLeftHandOrientation(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLeftHandOrientation(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetLeftHandPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLeftHandPosition(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetRightHandOrientation(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetRightHandOrientation(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetRightHandPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetRightHandPosition(self, _arg:(float, float, float)) -> None: ...
    def SetShowHandsOnly(self, _arg:bool) -> None: ...
    @overload
    def SetUpVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetUpVector(self, _arg:(float, float, float)) -> None: ...
    def SetUseLeftHand(self, _arg:bool) -> None: ...
    def SetUseRightHand(self, _arg:bool) -> None: ...
    def ShowHandsOnlyOff(self) -> None: ...
    def ShowHandsOnlyOn(self) -> None: ...
    def UseLeftHandOff(self) -> None: ...
    def UseLeftHandOn(self) -> None: ...
    def UseRightHandOff(self) -> None: ...
    def UseRightHandOn(self) -> None: ...

class vtkBackgroundColorMonitor(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkBackgroundColorMonitor: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkBackgroundColorMonitor: ...
    def StateChanged(self, ren:vtkRenderer) -> bool: ...
    def Update(self, ren:vtkRenderer) -> None: ...

class vtkBillboardTextActor3D(vtkProp3D):
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetActors(self, __a:vtkPropCollection) -> None: ...
    def GetAnchorDC(self) -> (float, float, float): ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetDisplayOffset(self) -> (int, int): ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetInput(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextProperty(self) -> vtkTextProperty: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkBillboardTextActor3D: ...
    def ReleaseGraphicsResources(self, win:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, vp:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, vp:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkBillboardTextActor3D: ...
    @overload
    def SetDisplayOffset(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetDisplayOffset(self, _arg:(int, int)) -> None: ...
    def SetForceOpaque(self, opaque:bool) -> None: ...
    def SetForceTranslucent(self, trans:bool) -> None: ...
    def SetInput(self, in_:str) -> None: ...
    def SetTextProperty(self, tprop:vtkTextProperty) -> None: ...
    def UpdateGeometry(self, vp:vtkViewport) -> None: ...

class vtkCamera(vtkmodules.vtkCommonCore.vtkObject):
    def ApplyTransform(self, t:vtkTransform) -> None: ...
    def Azimuth(self, angle:float) -> None: ...
    def ComputeViewPlaneNormal(self) -> None: ...
    def DeepCopy(self, source:vtkCamera) -> None: ...
    def Dolly(self, value:float) -> None: ...
    def Elevation(self, angle:float) -> None: ...
    def GetCameraLightTransformMatrix(self) -> vtkMatrix4x4: ...
    def GetClippingRange(self) -> (float, float): ...
    def GetCompositeProjectionTransformMatrix(self, aspect:float, nearz:float, farz:float) -> vtkMatrix4x4: ...
    def GetDirectionOfProjection(self) -> (float, float, float): ...
    def GetDistance(self) -> float: ...
    def GetExplicitAspectRatio(self) -> float: ...
    def GetExplicitProjectionTransformMatrix(self) -> vtkMatrix4x4: ...
    def GetEyeAngle(self) -> float: ...
    def GetEyePlaneNormal(self, normal:[float, float, float]) -> None: ...
    def GetEyePosition(self, eyePosition:[float, float, float]) -> None: ...
    def GetEyeSeparation(self) -> float: ...
    def GetEyeTransformMatrix(self) -> vtkMatrix4x4: ...
    def GetFocalDisk(self) -> float: ...
    def GetFocalDistance(self) -> float: ...
    def GetFocalPoint(self) -> (float, float, float): ...
    def GetFocalPointScale(self) -> float: ...
    def GetFocalPointShift(self) -> (float, float, float): ...
    def GetFreezeFocalPoint(self) -> bool: ...
    def GetFrustumPlanes(self, aspect:float, planes:[float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float]) -> None: ...
    def GetInformation(self) -> vtkInformation: ...
    def GetLeftEye(self) -> int: ...
    def GetModelTransformMatrix(self) -> vtkMatrix4x4: ...
    def GetModelViewTransformMatrix(self) -> vtkMatrix4x4: ...
    def GetModelViewTransformObject(self) -> vtkTransform: ...
    def GetNearPlaneScale(self) -> float: ...
    def GetNearPlaneShift(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> (float, float, float): ...
    def GetOrientationWXYZ(self) -> (float, float, float, float): ...
    def GetParallelProjection(self) -> int: ...
    def GetParallelScale(self) -> float: ...
    def GetPosition(self) -> (float, float, float): ...
    @overload
    def GetProjectionTransformMatrix(self, aspect:float, nearz:float, farz:float) -> vtkMatrix4x4: ...
    @overload
    def GetProjectionTransformMatrix(self, ren:vtkRenderer) -> vtkMatrix4x4: ...
    def GetProjectionTransformObject(self, aspect:float, nearz:float, farz:float) -> vtkPerspectiveTransform: ...
    def GetRoll(self) -> float: ...
    def GetScissorRect(self, scissorRect:vtkRecti) -> None: ...
    def GetScreenBottomLeft(self) -> (float, float, float): ...
    def GetScreenBottomRight(self) -> (float, float, float): ...
    def GetScreenTopRight(self) -> (float, float, float): ...
    def GetShiftScaleThreshold(self) -> float: ...
    def GetStereo(self) -> int: ...
    def GetThickness(self) -> float: ...
    def GetUseExplicitAspectRatio(self) -> bool: ...
    def GetUseExplicitProjectionTransformMatrix(self) -> bool: ...
    def GetUseHorizontalViewAngle(self) -> int: ...
    def GetUseOffAxisProjection(self) -> int: ...
    def GetUseScissor(self) -> bool: ...
    def GetUserTransform(self) -> vtkHomogeneousTransform: ...
    def GetUserViewTransform(self) -> vtkHomogeneousTransform: ...
    def GetViewAngle(self) -> float: ...
    def GetViewPlaneNormal(self) -> (float, float, float): ...
    def GetViewShear(self) -> (float, float, float): ...
    def GetViewTransformMatrix(self) -> vtkMatrix4x4: ...
    def GetViewTransformObject(self) -> vtkTransform: ...
    def GetViewUp(self) -> (float, float, float): ...
    def GetViewingRaysMTime(self) -> int: ...
    def GetWindowCenter(self) -> (float, float): ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCamera: ...
    def OrthogonalizeViewUp(self) -> None: ...
    def ParallelProjectionOff(self) -> None: ...
    def ParallelProjectionOn(self) -> None: ...
    def Pitch(self, angle:float) -> None: ...
    def Render(self, __a:vtkRenderer) -> None: ...
    def Roll(self, angle:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCamera: ...
    @overload
    def SetClippingRange(self, dNear:float, dFar:float) -> None: ...
    @overload
    def SetClippingRange(self, a:(float, float)) -> None: ...
    def SetDistance(self, __a:float) -> None: ...
    def SetExplicitAspectRatio(self, _arg:float) -> None: ...
    def SetExplicitProjectionTransformMatrix(self, __a:vtkMatrix4x4) -> None: ...
    def SetEyeAngle(self, _arg:float) -> None: ...
    def SetEyePosition(self, eyePosition:[float, float, float]) -> None: ...
    def SetEyeSeparation(self, _arg:float) -> None: ...
    @overload
    def SetEyeTransformMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    @overload
    def SetEyeTransformMatrix(self, elements:(float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float)) -> None: ...
    def SetFocalDisk(self, _arg:float) -> None: ...
    def SetFocalDistance(self, _arg:float) -> None: ...
    @overload
    def SetFocalPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetFocalPoint(self, a:(float, float, float)) -> None: ...
    def SetFreezeFocalPoint(self, _arg:bool) -> None: ...
    def SetInformation(self, __a:vtkInformation) -> None: ...
    def SetLeftEye(self, _arg:int) -> None: ...
    @overload
    def SetModelTransformMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    @overload
    def SetModelTransformMatrix(self, elements:(float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float)) -> None: ...
    def SetObliqueAngles(self, alpha:float, beta:float) -> None: ...
    def SetParallelProjection(self, flag:int) -> None: ...
    def SetParallelScale(self, scale:float) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPosition(self, a:(float, float, float)) -> None: ...
    def SetRoll(self, angle:float) -> None: ...
    def SetScissorRect(self, scissorRect:vtkRecti) -> None: ...
    @overload
    def SetScreenBottomLeft(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScreenBottomLeft(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetScreenBottomRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScreenBottomRight(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetScreenTopRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScreenTopRight(self, _arg:(float, float, float)) -> None: ...
    def SetShiftScaleThreshold(self, _arg:float) -> None: ...
    def SetThickness(self, __a:float) -> None: ...
    def SetUseExplicitAspectRatio(self, _arg:bool) -> None: ...
    def SetUseExplicitProjectionTransformMatrix(self, _arg:bool) -> None: ...
    def SetUseHorizontalViewAngle(self, flag:int) -> None: ...
    def SetUseOffAxisProjection(self, _arg:int) -> None: ...
    def SetUseScissor(self, _arg:bool) -> None: ...
    def SetUserTransform(self, transform:vtkHomogeneousTransform) -> None: ...
    def SetUserViewTransform(self, transform:vtkHomogeneousTransform) -> None: ...
    def SetViewAngle(self, angle:float) -> None: ...
    @overload
    def SetViewShear(self, dxdz:float, dydz:float, center:float) -> None: ...
    @overload
    def SetViewShear(self, d:[float, float, float]) -> None: ...
    @overload
    def SetViewUp(self, vx:float, vy:float, vz:float) -> None: ...
    @overload
    def SetViewUp(self, a:(float, float, float)) -> None: ...
    def SetWindowCenter(self, x:float, y:float) -> None: ...
    def ShallowCopy(self, source:vtkCamera) -> None: ...
    def UpdateIdealShiftScale(self, aspect:float) -> None: ...
    def UpdateViewport(self, ren:vtkRenderer) -> None: ...
    def UseExplicitAspectRatioOff(self) -> None: ...
    def UseExplicitAspectRatioOn(self) -> None: ...
    def UseExplicitProjectionTransformMatrixOff(self) -> None: ...
    def UseExplicitProjectionTransformMatrixOn(self) -> None: ...
    def UseHorizontalViewAngleOff(self) -> None: ...
    def UseHorizontalViewAngleOn(self) -> None: ...
    def UseOffAxisProjectionOff(self) -> None: ...
    def UseOffAxisProjectionOn(self) -> None: ...
    def ViewingRaysModified(self) -> None: ...
    def Yaw(self, angle:float) -> None: ...
    def Zoom(self, factor:float) -> None: ...

class vtkCameraActor(vtkProp3D):
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetCamera(self) -> vtkCamera: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> vtkProperty: ...
    def GetWidthByHeightRatio(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCameraActor: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCameraActor: ...
    def SetCamera(self, camera:vtkCamera) -> None: ...
    def SetProperty(self, p:vtkProperty) -> None: ...
    def SetWidthByHeightRatio(self, _arg:float) -> None: ...

class vtkCameraInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    INTERPOLATION_TYPE_LINEAR:int
    INTERPOLATION_TYPE_MANUAL:int
    INTERPOLATION_TYPE_SPLINE:int
    def AddCamera(self, t:float, camera:vtkCamera) -> None: ...
    def GetClippingRangeInterpolator(self) -> vtkTupleInterpolator: ...
    def GetFocalPointInterpolator(self) -> vtkTupleInterpolator: ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMaximumT(self) -> float: ...
    def GetMinimumT(self) -> float: ...
    def GetNumberOfCameras(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParallelScaleInterpolator(self) -> vtkTupleInterpolator: ...
    def GetPositionInterpolator(self) -> vtkTupleInterpolator: ...
    def GetViewAngleInterpolator(self) -> vtkTupleInterpolator: ...
    def GetViewUpInterpolator(self) -> vtkTupleInterpolator: ...
    def Initialize(self) -> None: ...
    def InterpolateCamera(self, t:float, camera:vtkCamera) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCameraInterpolator: ...
    def RemoveCamera(self, t:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCameraInterpolator: ...
    def SetClippingRangeInterpolator(self, __a:vtkTupleInterpolator) -> None: ...
    def SetFocalPointInterpolator(self, __a:vtkTupleInterpolator) -> None: ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToManual(self) -> None: ...
    def SetInterpolationTypeToSpline(self) -> None: ...
    def SetParallelScaleInterpolator(self, __a:vtkTupleInterpolator) -> None: ...
    def SetPositionInterpolator(self, __a:vtkTupleInterpolator) -> None: ...
    def SetViewAngleInterpolator(self, __a:vtkTupleInterpolator) -> None: ...
    def SetViewUpInterpolator(self, __a:vtkTupleInterpolator) -> None: ...

class vtkVisibilitySort(vtkmodules.vtkCommonCore.vtkObject):
    BACK_TO_FRONT:int
    FRONT_TO_BACK:int
    def GetCamera(self) -> vtkCamera: ...
    def GetDirection(self) -> int: ...
    def GetInput(self) -> vtkDataSet: ...
    def GetInverseModelTransform(self) -> vtkMatrix4x4: ...
    def GetMaxCellsReturned(self) -> int: ...
    def GetMaxCellsReturnedMaxValue(self) -> int: ...
    def GetMaxCellsReturnedMinValue(self) -> int: ...
    def GetModelTransform(self) -> vtkMatrix4x4: ...
    def GetNextCells(self) -> vtkIdTypeArray: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVisibilitySort: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVisibilitySort: ...
    def SetCamera(self, camera:vtkCamera) -> None: ...
    def SetDirection(self, _arg:int) -> None: ...
    def SetDirectionToBackToFront(self) -> None: ...
    def SetDirectionToFrontToBack(self) -> None: ...
    def SetInput(self, data:vtkDataSet) -> None: ...
    def SetMaxCellsReturned(self, _arg:int) -> None: ...
    def SetModelTransform(self, mat:vtkMatrix4x4) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkCellCenterDepthSort(vtkVisibilitySort):
    def GetNextCells(self) -> vtkIdTypeArray: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCellCenterDepthSort: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCellCenterDepthSort: ...

class vtkPicker(vtkAbstractPropPicker):
    def GetActors(self) -> vtkActorCollection: ...
    def GetCompositeDataSet(self) -> vtkCompositeDataSet: ...
    def GetDataSet(self) -> vtkDataSet: ...
    def GetFlatBlockIndex(self) -> int: ...
    def GetMapper(self) -> vtkAbstractMapper3D: ...
    def GetMapperPosition(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickedPositions(self) -> vtkPoints: ...
    def GetProp3Ds(self) -> vtkProp3DCollection: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPicker: ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:vtkRenderer) -> int: ...
    @overload
    def Pick(self, selectionPt:[float, float, float], ren:vtkRenderer) -> int: ...
    @overload
    def Pick3DPoint(self, selectionPt:[float, float, float], ren:vtkRenderer) -> int: ...
    @overload
    def Pick3DPoint(self, p1World:[float, float, float], p2World:[float, float, float], ren:vtkRenderer) -> int: ...
    def Pick3DRay(self, selectionPt:[float, float, float], orient:[float, float, float, float], ren:vtkRenderer) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPicker: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkCellPicker(vtkPicker):
    def AddLocator(self, locator:vtkAbstractCellLocator) -> None: ...
    def GetCellIJK(self) -> (int, int, int): ...
    def GetCellId(self) -> int: ...
    def GetClippingPlaneId(self) -> int: ...
    def GetMapperNormal(self) -> (float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPCoords(self) -> (float, float, float): ...
    def GetPickClippingPlanes(self) -> int: ...
    def GetPickNormal(self) -> (float, float, float): ...
    def GetPickTextureData(self) -> int: ...
    def GetPointIJK(self) -> (int, int, int): ...
    def GetPointId(self) -> int: ...
    def GetSubId(self) -> int: ...
    def GetTexture(self) -> vtkTexture: ...
    def GetUseVolumeGradientOpacity(self) -> int: ...
    def GetVolumeOpacityIsovalue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCellPicker: ...
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:vtkRenderer) -> int: ...
    def Pick3DRay(self, selectionPt:[float, float, float], orient:[float, float, float, float], ren:vtkRenderer) -> int: ...
    def PickClippingPlanesOff(self) -> None: ...
    def PickClippingPlanesOn(self) -> None: ...
    def PickTextureDataOff(self) -> None: ...
    def PickTextureDataOn(self) -> None: ...
    def RemoveAllLocators(self) -> None: ...
    def RemoveLocator(self, locator:vtkAbstractCellLocator) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCellPicker: ...
    def SetPickClippingPlanes(self, _arg:int) -> None: ...
    def SetPickTextureData(self, _arg:int) -> None: ...
    def SetUseVolumeGradientOpacity(self, _arg:int) -> None: ...
    def SetVolumeOpacityIsovalue(self, _arg:float) -> None: ...
    def UseVolumeGradientOpacityOff(self) -> None: ...
    def UseVolumeGradientOpacityOn(self) -> None: ...

class vtkColorTransferFunction(vtkmodules.vtkCommonCore.vtkScalarsToColors):
    @overload
    def AddHSVPoint(self, x:float, h:float, s:float, v:float) -> int: ...
    @overload
    def AddHSVPoint(self, x:float, h:float, s:float, v:float, midpoint:float, sharpness:float) -> int: ...
    def AddHSVSegment(self, x1:float, h1:float, s1:float, v1:float, x2:float, h2:float, s2:float, v2:float) -> None: ...
    @overload
    def AddRGBPoint(self, x:float, r:float, g:float, b:float) -> int: ...
    @overload
    def AddRGBPoint(self, x:float, r:float, g:float, b:float, midpoint:float, sharpness:float) -> int: ...
    @overload
    def AddRGBPoints(self, x:vtkDoubleArray, rgbColors:vtkDoubleArray) -> int: ...
    @overload
    def AddRGBPoints(self, x:vtkDoubleArray, rgbColors:vtkDoubleArray, midpoint:float, sharpness:float) -> int: ...
    def AddRGBSegment(self, x1:float, r1:float, g1:float, b1:float, x2:float, r2:float, g2:float, b2:float) -> None: ...
    def AdjustRange(self, range:[float, float]) -> int: ...
    def AllowDuplicateScalarsOff(self) -> None: ...
    def AllowDuplicateScalarsOn(self) -> None: ...
    def BuildFunctionFromTable(self, x1:float, x2:float, size:int, table:[float, ...]) -> None: ...
    def ClampingOff(self) -> None: ...
    def ClampingOn(self) -> None: ...
    def DeepCopy(self, f:vtkScalarsToColors) -> None: ...
    def EstimateMinNumberOfSamples(self, x1:float, x2:float) -> int: ...
    def FillFromDataPointer(self, n:int, ptr:[float, ...]) -> None: ...
    def GetAboveRangeColor(self) -> (float, float, float): ...
    def GetAllowDuplicateScalars(self) -> int: ...
    def GetBelowRangeColor(self) -> (float, float, float): ...
    def GetBlueValue(self, x:float) -> float: ...
    def GetClamping(self) -> int: ...
    def GetClampingMaxValue(self) -> int: ...
    def GetClampingMinValue(self) -> int: ...
    @overload
    def GetColor(self, x:float) -> (float, float, float): ...
    @overload
    def GetColor(self, x:float, rgb:[float, float, float]) -> None: ...
    def GetColorSpace(self) -> int: ...
    def GetColorSpaceMaxValue(self) -> int: ...
    def GetColorSpaceMinValue(self) -> int: ...
    def GetDataPointer(self) -> Pointer: ...
    def GetGreenValue(self, x:float) -> float: ...
    def GetHSVWrap(self) -> int: ...
    def GetIndexedColor(self, idx:int, rgba:[float, float, float, float]) -> None: ...
    def GetNanColor(self) -> (float, float, float): ...
    def GetNanOpacity(self) -> float: ...
    def GetNodeValue(self, index:int, val:[float, float, float, float, float, float]) -> int: ...
    def GetNumberOfAvailableColors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetRange(self) -> (float, float): ...
    @overload
    def GetRange(self, arg1:float, arg2:float) -> None: ...
    @overload
    def GetRange(self, _arg:[float, float]) -> None: ...
    def GetRedValue(self, x:float) -> float: ...
    def GetScale(self) -> int: ...
    def GetSize(self) -> int: ...
    @overload
    def GetTable(self, x1:float, x2:float, n:int, table:[float, ...]) -> None: ...
    @overload
    def GetTable(self, x1:float, x2:float, n:int) -> Pointer: ...
    def GetUseAboveRangeColor(self) -> int: ...
    def GetUseBelowRangeColor(self) -> int: ...
    def HSVWrapOff(self) -> None: ...
    def HSVWrapOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:[int, ...], inputDataType:int, numberOfValues:int, inputIncrement:int, outputIncrement:int) -> None: ...
    def MapValue(self, v:float) -> Pointer: ...
    def NewInstance(self) -> vtkColorTransferFunction: ...
    def RemoveAllPoints(self) -> None: ...
    def RemovePoint(self, x:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkColorTransferFunction: ...
    @overload
    def SetAboveRangeColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAboveRangeColor(self, _arg:(float, float, float)) -> None: ...
    def SetAllowDuplicateScalars(self, _arg:int) -> None: ...
    @overload
    def SetBelowRangeColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBelowRangeColor(self, _arg:(float, float, float)) -> None: ...
    def SetClamping(self, _arg:int) -> None: ...
    def SetColorSpace(self, _arg:int) -> None: ...
    def SetColorSpaceToDiverging(self) -> None: ...
    def SetColorSpaceToHSV(self) -> None: ...
    def SetColorSpaceToLab(self) -> None: ...
    def SetColorSpaceToLabCIEDE2000(self) -> None: ...
    def SetColorSpaceToRGB(self) -> None: ...
    def SetColorSpaceToStep(self) -> None: ...
    def SetHSVWrap(self, _arg:int) -> None: ...
    @overload
    def SetNanColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNanColor(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetNanColorRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    @overload
    def SetNanColorRGBA(self, rgba:[float, float, float, float]) -> None: ...
    def SetNanOpacity(self, _arg:float) -> None: ...
    def SetNodeValue(self, index:int, val:[float, float, float, float, float, float]) -> int: ...
    def SetScale(self, _arg:int) -> None: ...
    def SetScaleToLinear(self) -> None: ...
    def SetScaleToLog10(self) -> None: ...
    def SetUseAboveRangeColor(self, _arg:int) -> None: ...
    def SetUseBelowRangeColor(self, _arg:int) -> None: ...
    def ShallowCopy(self, f:vtkColorTransferFunction) -> None: ...
    def UseAboveRangeColorOff(self) -> None: ...
    def UseAboveRangeColorOn(self) -> None: ...
    def UseBelowRangeColorOff(self) -> None: ...
    def UseBelowRangeColorOn(self) -> None: ...

class vtkCompositeDataDisplayAttributes(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def ComputeVisibleBounds(cda:vtkCompositeDataDisplayAttributes, dobj:vtkDataObject, bounds:[float, float, float, float, float, float]) -> None: ...
    @staticmethod
    def DataObjectFromIndex(flat_index:int, parent_obj:vtkDataObject, current_flat_index:int=0) -> vtkDataObject: ...
    @overload
    def GetBlockColor(self, data_object:vtkDataObject, color:[float, float, float]) -> None: ...
    @overload
    def GetBlockColor(self, data_object:vtkDataObject) -> vtkColor3d: ...
    def GetBlockMaterial(self, data_object:vtkDataObject) -> str: ...
    def GetBlockOpacity(self, data_object:vtkDataObject) -> float: ...
    def GetBlockPickability(self, data_object:vtkDataObject) -> bool: ...
    def GetBlockVisibility(self, data_object:vtkDataObject) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasBlockColor(self, data_object:vtkDataObject) -> bool: ...
    def HasBlockColors(self) -> bool: ...
    def HasBlockMaterial(self, data_object:vtkDataObject) -> bool: ...
    def HasBlockMaterials(self) -> bool: ...
    def HasBlockOpacities(self) -> bool: ...
    def HasBlockOpacity(self, data_object:vtkDataObject) -> bool: ...
    def HasBlockPickabilities(self) -> bool: ...
    def HasBlockPickability(self, data_object:vtkDataObject) -> bool: ...
    def HasBlockVisibilities(self) -> bool: ...
    def HasBlockVisibility(self, data_object:vtkDataObject) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCompositeDataDisplayAttributes: ...
    def RemoveBlockColor(self, data_object:vtkDataObject) -> None: ...
    def RemoveBlockColors(self) -> None: ...
    def RemoveBlockMaterial(self, data_object:vtkDataObject) -> None: ...
    def RemoveBlockMaterials(self) -> None: ...
    def RemoveBlockOpacities(self) -> None: ...
    def RemoveBlockOpacity(self, data_object:vtkDataObject) -> None: ...
    def RemoveBlockPickabilities(self) -> None: ...
    def RemoveBlockPickability(self, data_object:vtkDataObject) -> None: ...
    def RemoveBlockVisibilities(self) -> None: ...
    def RemoveBlockVisibility(self, data_object:vtkDataObject) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCompositeDataDisplayAttributes: ...
    def SetBlockColor(self, data_object:vtkDataObject, color:(float, float, float)) -> None: ...
    def SetBlockMaterial(self, data_object:vtkDataObject, material:str) -> None: ...
    def SetBlockOpacity(self, data_object:vtkDataObject, opacity:float) -> None: ...
    def SetBlockPickability(self, data_object:vtkDataObject, visible:bool) -> None: ...
    def SetBlockVisibility(self, data_object:vtkDataObject, visible:bool) -> None: ...

class vtkCompositeDataDisplayAttributesLegacy(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def ComputeVisibleBounds(cda:vtkCompositeDataDisplayAttributesLegacy, dobj:vtkDataObject, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def GetBlockColor(self, flat_index:int, color:[float, float, float]) -> None: ...
    @overload
    def GetBlockColor(self, flat_index:int) -> vtkColor3d: ...
    def GetBlockOpacity(self, flat_index:int) -> float: ...
    def GetBlockPickability(self, flat_index:int) -> bool: ...
    def GetBlockVisibility(self, flat_index:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasBlockColor(self, flat_index:int) -> bool: ...
    def HasBlockColors(self) -> bool: ...
    def HasBlockOpacities(self) -> bool: ...
    def HasBlockOpacity(self, flat_index:int) -> bool: ...
    def HasBlockPickabilities(self) -> bool: ...
    def HasBlockPickability(self, flat_index:int) -> bool: ...
    def HasBlockVisibilities(self) -> bool: ...
    def HasBlockVisibility(self, flat_index:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCompositeDataDisplayAttributesLegacy: ...
    def RemoveBlockColor(self, flat_index:int) -> None: ...
    def RemoveBlockColors(self) -> None: ...
    def RemoveBlockOpacities(self) -> None: ...
    def RemoveBlockOpacity(self, flat_index:int) -> None: ...
    def RemoveBlockPickabilities(self) -> None: ...
    def RemoveBlockPickability(self, flat_index:int) -> None: ...
    def RemoveBlockVisibilities(self) -> None: ...
    def RemoveBlockVisibility(self, flat_index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCompositeDataDisplayAttributesLegacy: ...
    def SetBlockColor(self, flat_index:int, color:(float, float, float)) -> None: ...
    def SetBlockOpacity(self, flat_index:int, opacity:float) -> None: ...
    def SetBlockPickability(self, flat_index:int, visible:bool) -> None: ...
    def SetBlockVisibility(self, flat_index:int, visible:bool) -> None: ...

class vtkMapper(vtkAbstractMapper3D):
    def CanUseTextureMapForColoring(self, input:vtkDataObject) -> int: ...
    def ClearColorArrays(self) -> None: ...
    @overload
    def ColorByArrayComponent(self, arrayNum:int, component:int) -> None: ...
    @overload
    def ColorByArrayComponent(self, arrayName:str, component:int) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetArrayAccessMode(self) -> int: ...
    def GetArrayComponent(self) -> int: ...
    def GetArrayId(self) -> int: ...
    def GetArrayName(self) -> str: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetCoincidentTopologyLineOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetCoincidentTopologyPointOffsetParameter(self, units:float) -> None: ...
    def GetCoincidentTopologyPolygonOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetColorCoordinates(self) -> vtkFloatArray: ...
    def GetColorMapColors(self) -> vtkUnsignedCharArray: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeAsString(self) -> str: ...
    def GetColorTextureMap(self) -> vtkImageData: ...
    def GetFieldDataTupleId(self) -> int: ...
    def GetInput(self) -> vtkDataSet: ...
    def GetInputAsDataSet(self) -> vtkDataSet: ...
    def GetInterpolateScalarsBeforeMapping(self) -> int: ...
    def GetLookupTable(self) -> vtkScalarsToColors: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelativeCoincidentTopologyLineOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetRelativeCoincidentTopologyPointOffsetParameter(self, units:float) -> None: ...
    def GetRelativeCoincidentTopologyPolygonOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetRenderTime(self) -> float: ...
    @staticmethod
    def GetResolveCoincidentTopology() -> int: ...
    @staticmethod
    def GetResolveCoincidentTopologyLineOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def GetResolveCoincidentTopologyPointOffsetParameter(units:float) -> None: ...
    @staticmethod
    def GetResolveCoincidentTopologyPolygonOffsetFaces() -> int: ...
    @staticmethod
    def GetResolveCoincidentTopologyPolygonOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def GetResolveCoincidentTopologyZShift() -> float: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarModeAsString(self) -> str: ...
    def GetScalarRange(self) -> (float, float): ...
    def GetScalarVisibility(self) -> int: ...
    def GetSelection(self) -> vtkSelection: ...
    def GetStatic(self) -> int: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseLookupTableScalarRange(self) -> int: ...
    def HasOpaqueGeometry(self) -> bool: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def InterpolateScalarsBeforeMappingOff(self) -> None: ...
    def InterpolateScalarsBeforeMappingOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def MapScalars(self, alpha:float) -> vtkUnsignedCharArray: ...
    @overload
    def MapScalars(self, alpha:float, cellFlag:int) -> vtkUnsignedCharArray: ...
    @overload
    def MapScalars(self, input:vtkDataSet, alpha:float) -> vtkUnsignedCharArray: ...
    @overload
    def MapScalars(self, input:vtkDataSet, alpha:float, cellFlag:int) -> vtkUnsignedCharArray: ...
    def NewInstance(self) -> vtkMapper: ...
    def ProcessSelectorPixelBuffers(self, __a:vtkHardwareSelector, __b:[int, ...], __c:vtkProp) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer, a:vtkActor) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMapper: ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    @overload
    def SelectColorArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectColorArray(self, arrayName:str) -> None: ...
    def SetArrayAccessMode(self, _arg:int) -> None: ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetArrayId(self, _arg:int) -> None: ...
    def SetArrayName(self, _arg:str) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToDirectScalars(self) -> None: ...
    def SetColorModeToMapScalars(self) -> None: ...
    def SetFieldDataTupleId(self, _arg:int) -> None: ...
    def SetInterpolateScalarsBeforeMapping(self, _arg:int) -> None: ...
    def SetLookupTable(self, lut:vtkScalarsToColors) -> None: ...
    def SetRelativeCoincidentTopologyLineOffsetParameters(self, factor:float, units:float) -> None: ...
    def SetRelativeCoincidentTopologyPointOffsetParameter(self, units:float) -> None: ...
    def SetRelativeCoincidentTopologyPolygonOffsetParameters(self, factor:float, units:float) -> None: ...
    def SetRenderTime(self, time:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopology(val:int) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyLineOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyPointOffsetParameter(units:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyPolygonOffsetFaces(faces:int) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyPolygonOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToDefault() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToOff() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToPolygonOffset() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToShiftZBuffer() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyZShift(val:float) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToDefault(self) -> None: ...
    def SetScalarModeToUseCellData(self) -> None: ...
    def SetScalarModeToUseCellFieldData(self) -> None: ...
    def SetScalarModeToUseFieldData(self) -> None: ...
    def SetScalarModeToUsePointData(self) -> None: ...
    def SetScalarModeToUsePointFieldData(self) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:(float, float)) -> None: ...
    def SetScalarVisibility(self, _arg:int) -> None: ...
    def SetSelection(self, __a:vtkSelection) -> None: ...
    def SetStatic(self, _arg:int) -> None: ...
    def SetUseLookupTableScalarRange(self, _arg:int) -> None: ...
    def ShallowCopy(self, m:vtkAbstractMapper) -> None: ...
    def StaticOff(self) -> None: ...
    def StaticOn(self) -> None: ...
    def UseLookupTableScalarRangeOff(self) -> None: ...
    def UseLookupTableScalarRangeOn(self) -> None: ...

class vtkCompositePolyDataMapper(vtkMapper):
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasOpaqueGeometry(self) -> bool: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCompositePolyDataMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer, a:vtkActor) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCompositePolyDataMapper: ...

class vtkCoordinate(vtkmodules.vtkCommonCore.vtkObject):
    def GetComputedDisplayValue(self, __a:vtkViewport) -> (int, int): ...
    def GetComputedDoubleDisplayValue(self, __a:vtkViewport) -> (float, float): ...
    def GetComputedDoubleViewportValue(self, __a:vtkViewport) -> (float, float): ...
    def GetComputedLocalDisplayValue(self, __a:vtkViewport) -> (int, int): ...
    def GetComputedUserDefinedValue(self, __a:vtkViewport) -> (float, float, float): ...
    def GetComputedValue(self, __a:vtkViewport) -> (float, float, float): ...
    def GetComputedViewportValue(self, __a:vtkViewport) -> (int, int): ...
    def GetComputedWorldValue(self, __a:vtkViewport) -> (float, float, float): ...
    def GetCoordinateSystem(self) -> int: ...
    def GetCoordinateSystemAsString(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReferenceCoordinate(self) -> vtkCoordinate: ...
    def GetValue(self) -> (float, float, float): ...
    def GetViewport(self) -> vtkViewport: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCoordinate: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCoordinate: ...
    def SetCoordinateSystem(self, _arg:int) -> None: ...
    def SetCoordinateSystemToDisplay(self) -> None: ...
    def SetCoordinateSystemToNormalizedDisplay(self) -> None: ...
    def SetCoordinateSystemToNormalizedViewport(self) -> None: ...
    def SetCoordinateSystemToPose(self) -> None: ...
    def SetCoordinateSystemToView(self) -> None: ...
    def SetCoordinateSystemToViewport(self) -> None: ...
    def SetCoordinateSystemToWorld(self) -> None: ...
    def SetReferenceCoordinate(self, __a:vtkCoordinate) -> None: ...
    @overload
    def SetValue(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetValue(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetValue(self, a:float, b:float) -> None: ...
    def SetViewport(self, viewport:vtkViewport) -> None: ...

class vtkCuller(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCuller: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCuller: ...

class vtkCullerCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, a:vtkCuller) -> None: ...
    def GetLastItem(self) -> vtkCuller: ...
    def GetNextItem(self) -> vtkCuller: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCullerCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCullerCollection: ...

class vtkDataSetMapper(vtkMapper):
    def GetInput(self) -> vtkDataSet: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyDataMapper(self) -> vtkPolyDataMapper: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDataSetMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer, act:vtkActor) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDataSetMapper: ...
    def SetInputData(self, input:vtkDataSet) -> None: ...

class vtkDiscretizableColorTransferFunction(vtkColorTransferFunction):
    def Build(self) -> None: ...
    def DiscretizeOff(self) -> None: ...
    def DiscretizeOn(self) -> None: ...
    def EnableOpacityMappingOff(self) -> None: ...
    def EnableOpacityMappingOn(self) -> None: ...
    def GetColor(self, v:float, rgb:[float, float, float]) -> None: ...
    def GetDiscretize(self) -> int: ...
    def GetEnableOpacityMapping(self) -> bool: ...
    def GetIndexedColor(self, i:int, rgba:[float, float, float, float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfAvailableColors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIndexedColors(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetOpacity(self, v:float) -> float: ...
    def GetScalarOpacityFunction(self) -> vtkPiecewiseFunction: ...
    def GetUseLogScale(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsOpaque(self) -> int: ...
    @overload
    def IsOpaque(self, scalars:vtkAbstractArray, colorMode:int, component:int) -> int: ...
    @overload
    def IsOpaque(self, scalars:vtkAbstractArray, colorMode:int, component:int, ghosts:vtkUnsignedCharArray, ghostsToSkip:int=0xff) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:[int, ...], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def MapValue(self, v:float) -> Pointer: ...
    def NewInstance(self) -> vtkDiscretizableColorTransferFunction: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDiscretizableColorTransferFunction: ...
    def SetAlpha(self, alpha:float) -> None: ...
    def SetDiscretize(self, _arg:int) -> None: ...
    def SetEnableOpacityMapping(self, _arg:bool) -> None: ...
    def SetIndexedColor(self, index:int, r:float, g:float, b:float, a:float=1.0) -> None: ...
    def SetIndexedColorRGB(self, index:int, rgb:(float, float, float)) -> None: ...
    def SetIndexedColorRGBA(self, index:int, rgba:(float, float, float, float)) -> None: ...
    @overload
    def SetNanColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetNanColor(self, rgb:(float, float, float)) -> None: ...
    def SetNanOpacity(self, a:float) -> None: ...
    def SetNumberOfIndexedColors(self, count:int) -> None: ...
    def SetNumberOfValues(self, _arg:int) -> None: ...
    def SetScalarOpacityFunction(self, function:vtkPiecewiseFunction) -> None: ...
    def SetUseLogScale(self, useLogScale:int) -> None: ...
    def UsingLogScale(self) -> int: ...

class vtkDistanceToCamera(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    def GetDistanceArrayName(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetScaling(self) -> bool: ...
    def GetScreenSize(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDistanceToCamera: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDistanceToCamera: ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetDistanceArrayName(self, _arg:str) -> None: ...
    def SetRenderer(self, ren:vtkRenderer) -> None: ...
    def SetScaling(self, _arg:bool) -> None: ...
    def SetScreenSize(self, _arg:float) -> None: ...

class vtkFXAAOptions(vtkmodules.vtkCommonCore.vtkObject):
    class DebugOption(int): ...
    FXAA_DEBUG_EDGE_DIRECTION:'DebugOption'
    FXAA_DEBUG_EDGE_DISTANCE:'DebugOption'
    FXAA_DEBUG_EDGE_NUM_STEPS:'DebugOption'
    FXAA_DEBUG_EDGE_SAMPLE_OFFSET:'DebugOption'
    FXAA_DEBUG_ONLY_EDGE_AA:'DebugOption'
    FXAA_DEBUG_ONLY_SUBPIX_AA:'DebugOption'
    FXAA_DEBUG_SUBPIXEL_ALIASING:'DebugOption'
    FXAA_NO_DEBUG:'DebugOption'
    def GetDebugOptionValue(self) -> DebugOption: ...
    def GetEndpointSearchIterations(self) -> int: ...
    def GetEndpointSearchIterationsMaxValue(self) -> int: ...
    def GetEndpointSearchIterationsMinValue(self) -> int: ...
    def GetHardContrastThreshold(self) -> float: ...
    def GetHardContrastThresholdMaxValue(self) -> float: ...
    def GetHardContrastThresholdMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelativeContrastThreshold(self) -> float: ...
    def GetRelativeContrastThresholdMaxValue(self) -> float: ...
    def GetRelativeContrastThresholdMinValue(self) -> float: ...
    def GetSubpixelBlendLimit(self) -> float: ...
    def GetSubpixelBlendLimitMaxValue(self) -> float: ...
    def GetSubpixelBlendLimitMinValue(self) -> float: ...
    def GetSubpixelContrastThreshold(self) -> float: ...
    def GetSubpixelContrastThresholdMaxValue(self) -> float: ...
    def GetSubpixelContrastThresholdMinValue(self) -> float: ...
    def GetUseHighQualityEndpoints(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFXAAOptions: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFXAAOptions: ...
    def SetDebugOptionValue(self, _arg:DebugOption) -> None: ...
    def SetEndpointSearchIterations(self, _arg:int) -> None: ...
    def SetHardContrastThreshold(self, _arg:float) -> None: ...
    def SetRelativeContrastThreshold(self, _arg:float) -> None: ...
    def SetSubpixelBlendLimit(self, _arg:float) -> None: ...
    def SetSubpixelContrastThreshold(self, _arg:float) -> None: ...
    def SetUseHighQualityEndpoints(self, _arg:bool) -> None: ...
    def UseHighQualityEndpointsOff(self) -> None: ...
    def UseHighQualityEndpointsOn(self) -> None: ...

class vtkFlagpoleLabel(vtkActor):
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetBasePosition(self) -> (float, float, float): ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetFlagSize(self) -> float: ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetInput(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextProperty(self) -> vtkTextProperty: ...
    def GetTopPosition(self) -> (float, float, float): ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFlagpoleLabel: ...
    def ReleaseGraphicsResources(self, win:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, vp:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, vp:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFlagpoleLabel: ...
    def SetBasePosition(self, x:float, y:float, z:float) -> None: ...
    def SetFlagSize(self, _arg:float) -> None: ...
    def SetForceOpaque(self, opaque:bool) -> None: ...
    def SetForceTranslucent(self, trans:bool) -> None: ...
    def SetInput(self, in_:str) -> None: ...
    def SetTextProperty(self, tprop:vtkTextProperty) -> None: ...
    def SetTopPosition(self, x:float, y:float, z:float) -> None: ...

class vtkFollower(vtkActor):
    def ComputeMatrix(self) -> None: ...
    def GetCamera(self) -> vtkCamera: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFollower: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFollower: ...
    def SetCamera(self, __a:vtkCamera) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkFrameBufferObjectBase(vtkmodules.vtkCommonCore.vtkObject):
    @overload
    def GetLastSize(self) -> Pointer: ...
    @overload
    def GetLastSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def GetLastSize(self, _arg:[int, int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFrameBufferObjectBase: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFrameBufferObjectBase: ...

class vtkFrustumCoverageCuller(vtkCuller):
    def GetMaximumCoverage(self) -> float: ...
    def GetMinimumCoverage(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSortingStyle(self) -> int: ...
    def GetSortingStyleAsString(self) -> str: ...
    def GetSortingStyleMaxValue(self) -> int: ...
    def GetSortingStyleMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFrustumCoverageCuller: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFrustumCoverageCuller: ...
    def SetMaximumCoverage(self, _arg:float) -> None: ...
    def SetMinimumCoverage(self, _arg:float) -> None: ...
    def SetSortingStyle(self, _arg:int) -> None: ...
    def SetSortingStyleToBackToFront(self) -> None: ...
    def SetSortingStyleToFrontToBack(self) -> None: ...
    def SetSortingStyleToNone(self) -> None: ...

class vtkGPUInfo(vtkmodules.vtkCommonCore.vtkObject):
    def GetDedicatedSystemMemory(self) -> int: ...
    def GetDedicatedVideoMemory(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSharedSystemMemory(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGPUInfo: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGPUInfo: ...
    def SetDedicatedSystemMemory(self, _arg:int) -> None: ...
    def SetDedicatedVideoMemory(self, _arg:int) -> None: ...
    def SetSharedSystemMemory(self, _arg:int) -> None: ...

class vtkGPUInfoList(vtkmodules.vtkCommonCore.vtkObject):
    def GetGPUInfo(self, i:int) -> vtkGPUInfo: ...
    def GetNumberOfGPUs(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsProbed(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGPUInfoList: ...
    def Probe(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGPUInfoList: ...

class vtkGPUInfoListArray(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:vtkGPUInfoListArray) -> None: ...

class vtkGenericVertexAttributeMapping(vtkmodules.vtkCommonCore.vtkObject):
    @overload
    def AddMapping(self, attributeName:str, arrayName:str, fieldAssociation:int, component:int) -> None: ...
    @overload
    def AddMapping(self, unit:int, arrayName:str, fieldAssociation:int, component:int) -> None: ...
    def GetArrayName(self, index:int) -> str: ...
    def GetAttributeName(self, index:int) -> str: ...
    def GetComponent(self, index:int) -> int: ...
    def GetFieldAssociation(self, index:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfMappings(self) -> int: ...
    def GetTextureUnit(self, index:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGenericVertexAttributeMapping: ...
    def RemoveAllMappings(self) -> None: ...
    def RemoveMapping(self, attributeName:str) -> bool: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGenericVertexAttributeMapping: ...

class vtkGlyph3DMapper(vtkMapper):
    class ArrayIndexes(int): ...
    class OrientationModes(int): ...
    class ScaleModes(int): ...
    DIRECTION:'OrientationModes'
    MASK:'ArrayIndexes'
    NO_DATA_SCALING:'ScaleModes'
    ORIENTATION:'ArrayIndexes'
    QUATERNION:'OrientationModes'
    ROTATION:'OrientationModes'
    SCALE:'ArrayIndexes'
    SCALE_BY_COMPONENTS:'ScaleModes'
    SCALE_BY_MAGNITUDE:'ScaleModes'
    SELECTIONID:'ArrayIndexes'
    SOURCE_INDEX:'ArrayIndexes'
    def ClampingOff(self) -> None: ...
    def ClampingOn(self) -> None: ...
    def GetBlockAttributes(self) -> vtkCompositeDataDisplayAttributes: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetClamping(self) -> bool: ...
    def GetCullingAndLOD(self) -> bool: ...
    def GetLODColoring(self) -> bool: ...
    def GetMasking(self) -> bool: ...
    def GetMaxNumberOfLOD(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrient(self) -> bool: ...
    def GetOrientationMode(self) -> int: ...
    def GetOrientationModeAsString(self) -> str: ...
    def GetOrientationModeMaxValue(self) -> int: ...
    def GetOrientationModeMinValue(self) -> int: ...
    def GetRange(self) -> (float, float): ...
    def GetScaleFactor(self) -> float: ...
    def GetScaleMode(self) -> int: ...
    def GetScaleModeAsString(self) -> str: ...
    def GetScaling(self) -> bool: ...
    def GetSelectionColorId(self) -> int: ...
    def GetSource(self, idx:int=0) -> vtkPolyData: ...
    def GetSourceIndexing(self) -> bool: ...
    def GetSourceTableTree(self) -> vtkDataObjectTree: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseSelectionIds(self) -> bool: ...
    def GetUseSourceTableTree(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MaskingOff(self) -> None: ...
    def MaskingOn(self) -> None: ...
    def NewInstance(self) -> vtkGlyph3DMapper: ...
    def OrientOff(self) -> None: ...
    def OrientOn(self) -> None: ...
    def Render(self, ren:vtkRenderer, act:vtkActor) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGlyph3DMapper: ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetBlockAttributes(self, attr:vtkCompositeDataDisplayAttributes) -> None: ...
    def SetClamping(self, _arg:bool) -> None: ...
    def SetCullingAndLOD(self, _arg:bool) -> None: ...
    def SetInputData(self, __a:vtkDataObject) -> None: ...
    def SetLODColoring(self, _arg:bool) -> None: ...
    def SetLODDistanceAndTargetReduction(self, index:int, distance:float, targetReduction:float) -> None: ...
    @overload
    def SetMaskArray(self, maskarrayname:str) -> None: ...
    @overload
    def SetMaskArray(self, fieldAttributeType:int) -> None: ...
    def SetMasking(self, _arg:bool) -> None: ...
    def SetNumberOfLOD(self, nb:int) -> None: ...
    def SetOrient(self, _arg:bool) -> None: ...
    @overload
    def SetOrientationArray(self, orientationarrayname:str) -> None: ...
    @overload
    def SetOrientationArray(self, fieldAttributeType:int) -> None: ...
    def SetOrientationMode(self, _arg:int) -> None: ...
    def SetOrientationModeToDirection(self) -> None: ...
    def SetOrientationModeToQuaternion(self) -> None: ...
    def SetOrientationModeToRotation(self) -> None: ...
    @overload
    def SetRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRange(self, _arg:(float, float)) -> None: ...
    @overload
    def SetScaleArray(self, scalarsarrayname:str) -> None: ...
    @overload
    def SetScaleArray(self, fieldAttributeType:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaleMode(self, _arg:int) -> None: ...
    def SetScaleModeToNoDataScaling(self) -> None: ...
    def SetScaleModeToScaleByMagnitude(self) -> None: ...
    def SetScaleModeToScaleByVectorComponents(self) -> None: ...
    def SetScaling(self, _arg:bool) -> None: ...
    def SetSelectionColorId(self, _arg:int) -> None: ...
    @overload
    def SetSelectionIdArray(self, selectionIdArrayName:str) -> None: ...
    @overload
    def SetSelectionIdArray(self, fieldAttributeType:int) -> None: ...
    @overload
    def SetSourceConnection(self, idx:int, algOutput:vtkAlgorithmOutput) -> None: ...
    @overload
    def SetSourceConnection(self, algOutput:vtkAlgorithmOutput) -> None: ...
    @overload
    def SetSourceData(self, idx:int, pd:vtkPolyData) -> None: ...
    @overload
    def SetSourceData(self, pd:vtkPolyData) -> None: ...
    @overload
    def SetSourceIndexArray(self, arrayname:str) -> None: ...
    @overload
    def SetSourceIndexArray(self, fieldAttributeType:int) -> None: ...
    def SetSourceIndexing(self, _arg:bool) -> None: ...
    def SetSourceTableTree(self, tree:vtkDataObjectTree) -> None: ...
    def SetUseSelectionIds(self, _arg:bool) -> None: ...
    def SetUseSourceTableTree(self, _arg:bool) -> None: ...
    def SourceIndexingOff(self) -> None: ...
    def SourceIndexingOn(self) -> None: ...
    def UseSelectionIdsOff(self) -> None: ...
    def UseSelectionIdsOn(self) -> None: ...
    def UseSourceTableTreeOff(self) -> None: ...
    def UseSourceTableTreeOn(self) -> None: ...

class vtkGraphMapper(vtkMapper):
    def AddIconType(self, type:str, index:int) -> None: ...
    def ClearIconTypes(self) -> None: ...
    def ColorEdgesOff(self) -> None: ...
    def ColorEdgesOn(self) -> None: ...
    def ColorVerticesOff(self) -> None: ...
    def ColorVerticesOn(self) -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def EnableEdgesByArrayOff(self) -> None: ...
    def EnableEdgesByArrayOn(self) -> None: ...
    def EnableVerticesByArrayOff(self) -> None: ...
    def EnableVerticesByArrayOn(self) -> None: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetColorEdges(self) -> bool: ...
    def GetColorVertices(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeLineWidth(self) -> float: ...
    def GetEdgeLookupTable(self) -> vtkLookupTable: ...
    def GetEdgeVisibility(self) -> bool: ...
    def GetEnableEdgesByArray(self) -> int: ...
    def GetEnableVerticesByArray(self) -> int: ...
    def GetEnabledEdgesArrayName(self) -> str: ...
    def GetEnabledVerticesArrayName(self) -> str: ...
    def GetIconArrayName(self) -> str: ...
    def GetIconSize(self) -> Pointer: ...
    def GetIconTexture(self) -> vtkTexture: ...
    def GetIconVisibility(self) -> bool: ...
    def GetInput(self) -> vtkGraph: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaledGlyphs(self) -> bool: ...
    def GetScalingArrayName(self) -> str: ...
    def GetVertexColorArrayName(self) -> str: ...
    def GetVertexLookupTable(self) -> vtkLookupTable: ...
    def GetVertexPointSize(self) -> float: ...
    def IconVisibilityOff(self) -> None: ...
    def IconVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGraphMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer, act:vtkActor) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphMapper: ...
    def ScaledGlyphsOff(self) -> None: ...
    def ScaledGlyphsOn(self) -> None: ...
    def SetColorEdges(self, vis:bool) -> None: ...
    def SetColorVertices(self, vis:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeLineWidth(self, width:float) -> None: ...
    def SetEdgeVisibility(self, vis:bool) -> None: ...
    def SetEnableEdgesByArray(self, _arg:int) -> None: ...
    def SetEnableVerticesByArray(self, _arg:int) -> None: ...
    def SetEnabledEdgesArrayName(self, _arg:str) -> None: ...
    def SetEnabledVerticesArrayName(self, _arg:str) -> None: ...
    def SetIconAlignment(self, alignment:int) -> None: ...
    def SetIconArrayName(self, name:str) -> None: ...
    def SetIconSize(self, size:[int, ...]) -> None: ...
    def SetIconTexture(self, texture:vtkTexture) -> None: ...
    def SetIconVisibility(self, vis:bool) -> None: ...
    def SetInputData(self, input:vtkGraph) -> None: ...
    def SetScaledGlyphs(self, arg:bool) -> None: ...
    def SetScalingArrayName(self, _arg:str) -> None: ...
    def SetVertexColorArrayName(self, name:str) -> None: ...
    def SetVertexPointSize(self, size:float) -> None: ...

class vtkGraphToGlyphs(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    CIRCLE:int
    CROSS:int
    DASH:int
    DIAMOND:int
    SPHERE:int
    SQUARE:int
    THICKCROSS:int
    TRIANGLE:int
    VERTEX:int
    def FilledOff(self) -> None: ...
    def FilledOn(self) -> None: ...
    def GetFilled(self) -> bool: ...
    def GetGlyphType(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetScaling(self) -> bool: ...
    def GetScreenSize(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGraphToGlyphs: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphToGlyphs: ...
    def SetFilled(self, _arg:bool) -> None: ...
    def SetGlyphType(self, _arg:int) -> None: ...
    def SetRenderer(self, ren:vtkRenderer) -> None: ...
    def SetScaling(self, b:bool) -> None: ...
    def SetScreenSize(self, _arg:float) -> None: ...

class vtkGraphicsFactory(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def CreateInstance(vtkclassname:str) -> vtkObject: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetOffScreenOnlyMode() -> int: ...
    @staticmethod
    def GetRenderLibrary() -> str: ...
    @staticmethod
    def GetUseMesaClasses() -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGraphicsFactory: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphicsFactory: ...
    @staticmethod
    def SetOffScreenOnlyMode(use:int) -> None: ...
    @staticmethod
    def SetUseMesaClasses(use:int) -> None: ...

class vtkHardwarePicker(vtkAbstractPropPicker):
    def GetCellId(self) -> int: ...
    def GetCompositeDataSet(self) -> vtkCompositeDataSet: ...
    def GetDataSet(self) -> vtkDataSet: ...
    def GetFlatBlockIndex(self) -> int: ...
    def GetMapper(self) -> vtkAbstractMapper3D: ...
    def GetNormalFlipped(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPCoords(self) -> (float, float, float): ...
    def GetPickNormal(self) -> (float, float, float): ...
    def GetPixelTolerance(self) -> int: ...
    def GetPointId(self) -> int: ...
    def GetSnapToMeshPoint(self) -> bool: ...
    def GetSubId(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHardwarePicker: ...
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:vtkRenderer) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHardwarePicker: ...
    def SetPixelTolerance(self, _arg:int) -> None: ...
    def SetSnapToMeshPoint(self, _arg:bool) -> None: ...
    def SnapToMeshPointOff(self) -> None: ...
    def SnapToMeshPointOn(self) -> None: ...

class vtkHardwareSelector(vtkmodules.vtkCommonCore.vtkObject):
    class PassTypes(int): ...
    ACTOR_PASS:'PassTypes'
    CELL_ID_HIGH24:'PassTypes'
    CELL_ID_LOW24:'PassTypes'
    COMPOSITE_INDEX_PASS:'PassTypes'
    MAX_KNOWN_PASS:'PassTypes'
    MIN_KNOWN_PASS:'PassTypes'
    POINT_ID_HIGH24:'PassTypes'
    POINT_ID_LOW24:'PassTypes'
    PROCESS_PASS:'PassTypes'
    def BeginRenderProp(self) -> None: ...
    def CaptureBuffers(self) -> bool: ...
    def ClearBuffers(self) -> None: ...
    @staticmethod
    def Convert(id:int, tcoord:[float, float, float]) -> None: ...
    def EndRenderProp(self) -> None: ...
    def GeneratePolygonSelection(self, polygonPoints:[int, ...], count:int) -> vtkSelection: ...
    @overload
    def GenerateSelection(self) -> vtkSelection: ...
    @overload
    def GenerateSelection(self, r:[int, int, int, int]) -> vtkSelection: ...
    @overload
    def GenerateSelection(self, x1:int, y1:int, x2:int, y2:int) -> vtkSelection: ...
    def GetActorPassOnly(self) -> bool: ...
    def GetArea(self) -> (int, int, int, int): ...
    def GetCaptureZValues(self) -> bool: ...
    def GetCurrentPass(self) -> int: ...
    def GetFieldAssociation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelBuffer(self, passNo:int) -> Pointer: ...
    def GetProcessID(self) -> int: ...
    def GetPropColorValue(self) -> (float, float, float): ...
    def GetPropFromID(self, id:int) -> vtkProp: ...
    def GetRawPixelBuffer(self, passNo:int) -> Pointer: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetUseProcessIdFromData(self) -> bool: ...
    def HasHighCellIds(self) -> bool: ...
    def HasHighPointIds(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHardwareSelector: ...
    def PassTypeToString(self, type:PassTypes) -> str: ...
    def RenderCompositeIndex(self, index:int) -> None: ...
    def RenderProcessId(self, processid:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHardwareSelector: ...
    def SavePixelBuffer(self, passNo:int) -> None: ...
    def Select(self) -> vtkSelection: ...
    def SetActorPassOnly(self, _arg:bool) -> None: ...
    @overload
    def SetArea(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int) -> None: ...
    @overload
    def SetArea(self, _arg:(int, int, int, int)) -> None: ...
    def SetCaptureZValues(self, _arg:bool) -> None: ...
    def SetFieldAssociation(self, _arg:int) -> None: ...
    def SetProcessID(self, _arg:int) -> None: ...
    @overload
    def SetPropColorValue(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPropColorValue(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetPropColorValue(self, val:int) -> None: ...
    def SetRenderer(self, __a:vtkRenderer) -> None: ...
    def SetUseProcessIdFromData(self, _arg:bool) -> None: ...
    def UpdateMaximumCellId(self, attribid:int) -> None: ...
    def UpdateMaximumPointId(self, attribid:int) -> None: ...

class vtkHardwareWindow(vtkmodules.vtkCommonCore.vtkWindow):
    def Create(self) -> None: ...
    def Destroy(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHardwareWindow: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHardwareWindow: ...

class vtkHierarchicalPolyDataMapper(vtkCompositePolyDataMapper):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHierarchicalPolyDataMapper: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHierarchicalPolyDataMapper: ...

class vtkImageSlice(vtkProp3D):
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetImages(self, __a:vtkPropCollection) -> None: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> vtkImageMapper3D: ...
    def GetMaxXBound(self) -> float: ...
    def GetMaxYBound(self) -> float: ...
    def GetMaxZBound(self) -> float: ...
    def GetMinXBound(self) -> float: ...
    def GetMinYBound(self) -> float: ...
    def GetMinZBound(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> vtkImageProperty: ...
    def GetRedrawMTime(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageSlice: ...
    def ReleaseGraphicsResources(self, win:vtkWindow) -> None: ...
    def Render(self, __a:vtkRenderer) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderOverlay(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageSlice: ...
    def SetForceTranslucent(self, _arg:bool) -> None: ...
    def SetMapper(self, mapper:vtkImageMapper3D) -> None: ...
    def SetProperty(self, property:vtkImageProperty) -> None: ...
    def SetStackedImagePass(self, pass_:int) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...
    def Update(self) -> None: ...

class vtkImageActor(vtkImageSlice):
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def GetDisplayBounds(self) -> Pointer: ...
    @overload
    def GetDisplayBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def GetDisplayExtent(self, extent:[int, int, int, int, int, int]) -> None: ...
    @overload
    def GetDisplayExtent(self) -> (int, int, int, int, int, int): ...
    def GetForceOpaque(self) -> bool: ...
    def GetInput(self) -> vtkImageData: ...
    def GetInterpolate(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetSliceNumber(self) -> int: ...
    def GetSliceNumberMax(self) -> int: ...
    def GetSliceNumberMin(self) -> int: ...
    def GetWholeZMax(self) -> int: ...
    def GetWholeZMin(self) -> int: ...
    def GetZSlice(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageActor: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageActor: ...
    @overload
    def SetDisplayExtent(self, extent:(int, int, int, int, int, int)) -> None: ...
    @overload
    def SetDisplayExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...
    def SetForceOpaque(self, _arg:bool) -> None: ...
    def SetInputData(self, __a:vtkImageData) -> None: ...
    def SetInterpolate(self, __a:int) -> None: ...
    def SetOpacity(self, __a:float) -> None: ...
    def SetZSlice(self, z:int) -> None: ...

class vtkMapper2D(vtkAbstractMapper):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMapper2D: ...
    def RenderOpaqueGeometry(self, __a:vtkViewport, __b:vtkActor2D) -> None: ...
    def RenderOverlay(self, __a:vtkViewport, __b:vtkActor2D) -> None: ...
    def RenderTranslucentPolygonalGeometry(self, __a:vtkViewport, __b:vtkActor2D) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMapper2D: ...

class vtkImageMapper(vtkMapper2D):
    def GetColorLevel(self) -> float: ...
    def GetColorScale(self) -> float: ...
    def GetColorShift(self) -> float: ...
    def GetColorWindow(self) -> float: ...
    def GetCustomDisplayExtents(self) -> (int, int, int, int): ...
    def GetInput(self) -> vtkImageData: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderToRectangle(self) -> int: ...
    def GetUseCustomExtents(self) -> int: ...
    def GetWholeZMax(self) -> int: ...
    def GetWholeZMin(self) -> int: ...
    def GetZSlice(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageMapper: ...
    def RenderData(self, __a:vtkViewport, __b:vtkImageData, __c:vtkActor2D) -> None: ...
    def RenderStart(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    def RenderToRectangleOff(self) -> None: ...
    def RenderToRectangleOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageMapper: ...
    def SetColorLevel(self, _arg:float) -> None: ...
    def SetColorWindow(self, _arg:float) -> None: ...
    def SetCustomDisplayExtents(self, data:(int, ...)) -> None: ...
    def SetInputData(self, input:vtkImageData) -> None: ...
    def SetRenderToRectangle(self, _arg:int) -> None: ...
    def SetUseCustomExtents(self, _arg:int) -> None: ...
    def SetZSlice(self, _arg:int) -> None: ...
    def UseCustomExtentsOff(self) -> None: ...
    def UseCustomExtentsOn(self) -> None: ...

class vtkImageMapper3D(vtkAbstractMapper3D):
    def BackgroundOff(self) -> None: ...
    def BackgroundOn(self) -> None: ...
    def BorderOff(self) -> None: ...
    def BorderOn(self) -> None: ...
    def GetBackground(self) -> int: ...
    def GetBorder(self) -> int: ...
    def GetDataObjectInput(self) -> vtkDataObject: ...
    def GetDataSetInput(self) -> vtkDataSet: ...
    def GetIndexBounds(self, extent:[float, float, float, float, float, float]) -> None: ...
    def GetInput(self) -> vtkImageData: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetNumberOfThreadsMaxValue(self) -> int: ...
    def GetNumberOfThreadsMinValue(self) -> int: ...
    def GetSliceAtFocalPoint(self) -> int: ...
    def GetSliceFacesCamera(self) -> int: ...
    def GetSlicePlane(self) -> vtkPlane: ...
    def GetSlicePlaneInDataCoords(self, propMatrix:vtkMatrix4x4, plane:[float, float, float, float]) -> None: ...
    def GetStreaming(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageMapper3D: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, renderer:vtkRenderer, prop:vtkImageSlice) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageMapper3D: ...
    def SetBackground(self, _arg:int) -> None: ...
    def SetBorder(self, _arg:int) -> None: ...
    def SetInputData(self, input:vtkImageData) -> None: ...
    def SetNumberOfThreads(self, _arg:int) -> None: ...
    def SetSliceAtFocalPoint(self, _arg:int) -> None: ...
    def SetSliceFacesCamera(self, _arg:int) -> None: ...
    def SetStreaming(self, _arg:int) -> None: ...
    def SliceAtFocalPointOff(self) -> None: ...
    def SliceAtFocalPointOn(self) -> None: ...
    def SliceFacesCameraOff(self) -> None: ...
    def SliceFacesCameraOn(self) -> None: ...
    def StreamingOff(self) -> None: ...
    def StreamingOn(self) -> None: ...

class vtkImageProperty(vtkmodules.vtkCommonCore.vtkObject):
    def BackingOff(self) -> None: ...
    def BackingOn(self) -> None: ...
    def CheckerboardOff(self) -> None: ...
    def CheckerboardOn(self) -> None: ...
    def DeepCopy(self, p:vtkImageProperty) -> None: ...
    def GetAmbient(self) -> float: ...
    def GetAmbientMaxValue(self) -> float: ...
    def GetAmbientMinValue(self) -> float: ...
    def GetBacking(self) -> int: ...
    def GetBackingColor(self) -> (float, float, float): ...
    def GetCheckerboard(self) -> int: ...
    def GetCheckerboardOffset(self) -> (float, float): ...
    def GetCheckerboardSpacing(self) -> (float, float): ...
    def GetColorLevel(self) -> float: ...
    def GetColorWindow(self) -> float: ...
    def GetDiffuse(self) -> float: ...
    def GetDiffuseMaxValue(self) -> float: ...
    def GetDiffuseMinValue(self) -> float: ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeAsString(self) -> str: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetLayerNumber(self) -> int: ...
    def GetLookupTable(self) -> vtkScalarsToColors: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetUseLookupTableScalarRange(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageProperty: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageProperty: ...
    def SetAmbient(self, _arg:float) -> None: ...
    def SetBacking(self, _arg:int) -> None: ...
    @overload
    def SetBackingColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackingColor(self, _arg:(float, float, float)) -> None: ...
    def SetCheckerboard(self, _arg:int) -> None: ...
    @overload
    def SetCheckerboardOffset(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetCheckerboardOffset(self, _arg:(float, float)) -> None: ...
    @overload
    def SetCheckerboardSpacing(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetCheckerboardSpacing(self, _arg:(float, float)) -> None: ...
    def SetColorLevel(self, _arg:float) -> None: ...
    def SetColorWindow(self, _arg:float) -> None: ...
    def SetDiffuse(self, _arg:float) -> None: ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToCubic(self) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToNearest(self) -> None: ...
    def SetLayerNumber(self, _arg:int) -> None: ...
    def SetLookupTable(self, lut:vtkScalarsToColors) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetUseLookupTableScalarRange(self, _arg:int) -> None: ...
    def UseLookupTableScalarRangeOff(self) -> None: ...
    def UseLookupTableScalarRangeOn(self) -> None: ...

class vtkImageSliceMapper(vtkImageMapper3D):
    def CroppingOff(self) -> None: ...
    def CroppingOn(self) -> None: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetCropping(self) -> int: ...
    def GetCroppingRegion(self) -> (int, int, int, int, int, int): ...
    def GetIndexBounds(self, extent:[float, float, float, float, float, float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetOrientationMaxValue(self) -> int: ...
    def GetOrientationMinValue(self) -> int: ...
    def GetSliceNumber(self) -> int: ...
    def GetSliceNumberMaxValue(self) -> int: ...
    def GetSliceNumberMinValue(self) -> int: ...
    def GetSlicePlaneInDataCoords(self, propMatrix:vtkMatrix4x4, plane:[float, float, float, float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageSliceMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, renderer:vtkRenderer, prop:vtkImageSlice) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageSliceMapper: ...
    def SetCropping(self, _arg:int) -> None: ...
    @overload
    def SetCroppingRegion(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetCroppingRegion(self, _arg:(int, int, int, int, int, int)) -> None: ...
    def SetDisplayExtent(self, extent:(int, int, int, int, int, int)) -> None: ...
    def SetOrientation(self, _arg:int) -> None: ...
    def SetOrientationToI(self) -> None: ...
    def SetOrientationToJ(self) -> None: ...
    def SetOrientationToK(self) -> None: ...
    def SetOrientationToX(self) -> None: ...
    def SetOrientationToY(self) -> None: ...
    def SetOrientationToZ(self) -> None: ...
    def SetSliceNumber(self, slice:int) -> None: ...

class vtkInteractorObserver(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def ComputeDisplayToWorld(ren:vtkRenderer, x:float, y:float, z:float, worldPt:[float, float, float, float]) -> None: ...
    @staticmethod
    def ComputeWorldToDisplay(ren:vtkRenderer, x:float, y:float, z:float, displayPt:[float, float, float]) -> None: ...
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetCurrentRenderer(self) -> vtkRenderer: ...
    def GetDefaultRenderer(self) -> vtkRenderer: ...
    def GetEnabled(self) -> int: ...
    def GetInteractor(self) -> vtkRenderWindowInteractor: ...
    def GetKeyPressActivation(self) -> int: ...
    def GetKeyPressActivationValue(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickingManaged(self) -> bool: ...
    def GetPriority(self) -> float: ...
    def GetPriorityMaxValue(self) -> float: ...
    def GetPriorityMinValue(self) -> float: ...
    def GrabFocus(self, mouseEvents:vtkCommand, keypressEvents:vtkCommand=...) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressActivationOff(self) -> None: ...
    def KeyPressActivationOn(self) -> None: ...
    def NewInstance(self) -> vtkInteractorObserver: ...
    def Off(self) -> None: ...
    def On(self) -> None: ...
    def OnChar(self) -> None: ...
    def PickingManagedOff(self) -> None: ...
    def PickingManagedOn(self) -> None: ...
    def ReleaseFocus(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkInteractorObserver: ...
    def SetCurrentRenderer(self, __a:vtkRenderer) -> None: ...
    def SetDefaultRenderer(self, __a:vtkRenderer) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetInteractor(self, iren:vtkRenderWindowInteractor) -> None: ...
    def SetKeyPressActivation(self, _arg:int) -> None: ...
    def SetKeyPressActivationValue(self, _arg:str) -> None: ...
    def SetPickingManaged(self, managed:bool) -> None: ...
    def SetPriority(self, _arg:float) -> None: ...

class vtkInteractorEventRecorder(vtkInteractorObserver):
    class vtkEventDataType(int):
        None_:'vtkEventDataType'
        StringArray:'vtkEventDataType'
    def Clear(self) -> None: ...
    def GetFileName(self) -> str: ...
    def GetInputString(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReadFromInputString(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkInteractorEventRecorder: ...
    def Play(self) -> None: ...
    def ReadFromInputStringOff(self) -> None: ...
    def ReadFromInputStringOn(self) -> None: ...
    def Record(self) -> None: ...
    def Rewind(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkInteractorEventRecorder: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetInputString(self, _arg:str) -> None: ...
    def SetInteractor(self, iren:vtkRenderWindowInteractor) -> None: ...
    def SetReadFromInputString(self, _arg:int) -> None: ...
    def Stop(self) -> None: ...

class vtkInteractorStyle(vtkInteractorObserver):
    def AutoAdjustCameraClippingRangeOff(self) -> None: ...
    def AutoAdjustCameraClippingRangeOn(self) -> None: ...
    def DelegateTDxEvent(self, event:int, calldata:Pointer) -> None: ...
    def Dolly(self) -> None: ...
    def EndDolly(self) -> None: ...
    def EndEnvRotate(self) -> None: ...
    def EndGesture(self) -> None: ...
    def EndPan(self) -> None: ...
    def EndRotate(self) -> None: ...
    def EndSpin(self) -> None: ...
    def EndTimer(self) -> None: ...
    def EndTwoPointer(self) -> None: ...
    def EndUniformScale(self) -> None: ...
    def EndZoom(self) -> None: ...
    def EnvironmentRotate(self) -> None: ...
    def FindPokedRenderer(self, __a:int, __b:int) -> None: ...
    def GetAutoAdjustCameraClippingRange(self) -> int: ...
    def GetAutoAdjustCameraClippingRangeMaxValue(self) -> int: ...
    def GetAutoAdjustCameraClippingRangeMinValue(self) -> int: ...
    def GetHandleObservers(self) -> int: ...
    def GetMouseWheelMotionFactor(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickColor(self) -> (float, float, float): ...
    def GetState(self) -> int: ...
    def GetTDxStyle(self) -> vtkTDxInteractorStyle: ...
    def GetTimerDuration(self) -> int: ...
    def GetTimerDurationMaxValue(self) -> int: ...
    def GetTimerDurationMinValue(self) -> int: ...
    def GetUseTimers(self) -> int: ...
    def HandleObserversOff(self) -> None: ...
    def HandleObserversOn(self) -> None: ...
    def HighlightActor2D(self, actor2D:vtkActor2D) -> None: ...
    def HighlightProp(self, prop:vtkProp) -> None: ...
    def HighlightProp3D(self, prop3D:vtkProp3D) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkInteractorStyle: ...
    def OnButton3D(self, __a:vtkEventData) -> None: ...
    def OnChar(self) -> None: ...
    def OnClip3D(self, __a:vtkEventData) -> None: ...
    def OnConfigure(self) -> None: ...
    def OnDropFiles(self, filePaths:vtkStringArray) -> None: ...
    def OnDropLocation(self, position:[float, ...]) -> None: ...
    def OnElevation3D(self, __a:vtkEventData) -> None: ...
    def OnEndPan(self) -> None: ...
    def OnEndPinch(self) -> None: ...
    def OnEndRotate(self) -> None: ...
    def OnEndSwipe(self) -> None: ...
    def OnEnter(self) -> None: ...
    def OnExpose(self) -> None: ...
    def OnFifthButtonDown(self) -> None: ...
    def OnFifthButtonUp(self) -> None: ...
    def OnFourthButtonDown(self) -> None: ...
    def OnFourthButtonUp(self) -> None: ...
    def OnKeyDown(self) -> None: ...
    def OnKeyPress(self) -> None: ...
    def OnKeyRelease(self) -> None: ...
    def OnKeyUp(self) -> None: ...
    def OnLeave(self) -> None: ...
    def OnLeftButtonDoubleClick(self) -> None: ...
    def OnLeftButtonDown(self) -> None: ...
    def OnLeftButtonUp(self) -> None: ...
    def OnLongTap(self) -> None: ...
    def OnMenu3D(self, __a:vtkEventData) -> None: ...
    def OnMiddleButtonDoubleClick(self) -> None: ...
    def OnMiddleButtonDown(self) -> None: ...
    def OnMiddleButtonUp(self) -> None: ...
    def OnMouseMove(self) -> None: ...
    def OnMouseWheelBackward(self) -> None: ...
    def OnMouseWheelForward(self) -> None: ...
    def OnMouseWheelLeft(self) -> None: ...
    def OnMouseWheelRight(self) -> None: ...
    def OnMove3D(self, __a:vtkEventData) -> None: ...
    def OnNextPose3D(self, __a:vtkEventData) -> None: ...
    def OnPan(self) -> None: ...
    def OnPick3D(self, __a:vtkEventData) -> None: ...
    def OnPinch(self) -> None: ...
    def OnPositionProp3D(self, __a:vtkEventData) -> None: ...
    def OnRightButtonDoubleClick(self) -> None: ...
    def OnRightButtonDown(self) -> None: ...
    def OnRightButtonUp(self) -> None: ...
    def OnRotate(self) -> None: ...
    def OnSelect3D(self, __a:vtkEventData) -> None: ...
    def OnStartPan(self) -> None: ...
    def OnStartPinch(self) -> None: ...
    def OnStartRotate(self) -> None: ...
    def OnStartSwipe(self) -> None: ...
    def OnSwipe(self) -> None: ...
    def OnTap(self) -> None: ...
    def OnTimer(self) -> None: ...
    def OnViewerMovement3D(self, __a:vtkEventData) -> None: ...
    def Pan(self) -> None: ...
    def Rotate(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkInteractorStyle: ...
    def SetAutoAdjustCameraClippingRange(self, _arg:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetHandleObservers(self, _arg:int) -> None: ...
    def SetInteractor(self, interactor:vtkRenderWindowInteractor) -> None: ...
    def SetMouseWheelMotionFactor(self, _arg:float) -> None: ...
    @overload
    def SetPickColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPickColor(self, _arg:(float, float, float)) -> None: ...
    def SetTDxStyle(self, tdxStyle:vtkTDxInteractorStyle) -> None: ...
    def SetTimerDuration(self, _arg:int) -> None: ...
    def SetUseTimers(self, _arg:int) -> None: ...
    def Spin(self) -> None: ...
    def StartAnimate(self) -> None: ...
    def StartDolly(self) -> None: ...
    def StartEnvRotate(self) -> None: ...
    def StartGesture(self) -> None: ...
    def StartPan(self) -> None: ...
    def StartRotate(self) -> None: ...
    def StartSpin(self) -> None: ...
    def StartState(self, newstate:int) -> None: ...
    def StartTimer(self) -> None: ...
    def StartTwoPointer(self) -> None: ...
    def StartUniformScale(self) -> None: ...
    def StartZoom(self) -> None: ...
    def StopAnimate(self) -> None: ...
    def StopState(self) -> None: ...
    def UniformScale(self) -> None: ...
    def UseTimersOff(self) -> None: ...
    def UseTimersOn(self) -> None: ...
    def Zoom(self) -> None: ...

class vtkInteractorStyle3D(vtkInteractorStyle):
    def Dolly3D(self, __a:vtkEventData) -> None: ...
    def GetDollyPhysicalSpeed(self) -> float: ...
    def GetInteractionPicker(self) -> vtkAbstractPropPicker: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkInteractorStyle3D: ...
    def PositionProp(self, __a:vtkEventData, lwpos:[float, ...]=..., lwori:[float, ...]=...) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkInteractorStyle3D: ...
    def SetDollyPhysicalSpeed(self, _arg:float) -> None: ...
    def SetInteractionPicker(self, prop:vtkAbstractPropPicker) -> None: ...
    def SetScale(self, cam:vtkCamera, newScale:float) -> None: ...

class vtkInteractorStyleSwitchBase(vtkInteractorStyle):
    def GetInteractor(self) -> vtkRenderWindowInteractor: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkInteractorStyleSwitchBase: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkInteractorStyleSwitchBase: ...

class vtkLODProp3D(vtkProp3D):
    def AddEstimatedRenderTime(self, t:float, vp:vtkViewport) -> None: ...
    @overload
    def AddLOD(self, m:vtkMapper, p:vtkProperty, back:vtkProperty, t:vtkTexture, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkMapper, p:vtkProperty, t:vtkTexture, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkMapper, p:vtkProperty, back:vtkProperty, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkMapper, p:vtkProperty, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkMapper, t:vtkTexture, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkMapper, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkAbstractVolumeMapper, p:vtkVolumeProperty, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkAbstractVolumeMapper, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkImageMapper3D, p:vtkImageProperty, time:float) -> int: ...
    @overload
    def AddLOD(self, m:vtkImageMapper3D, time:float) -> int: ...
    def AutomaticLODSelectionOff(self) -> None: ...
    def AutomaticLODSelectionOn(self) -> None: ...
    def AutomaticPickLODSelectionOff(self) -> None: ...
    def AutomaticPickLODSelectionOn(self) -> None: ...
    def DisableLOD(self, id:int) -> None: ...
    def EnableLOD(self, id:int) -> None: ...
    def GetActors(self, __a:vtkPropCollection) -> None: ...
    def GetAutomaticLODSelection(self) -> int: ...
    def GetAutomaticLODSelectionMaxValue(self) -> int: ...
    def GetAutomaticLODSelectionMinValue(self) -> int: ...
    def GetAutomaticPickLODSelection(self) -> int: ...
    def GetAutomaticPickLODSelectionMaxValue(self) -> int: ...
    def GetAutomaticPickLODSelectionMinValue(self) -> int: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetCurrentIndex(self) -> int: ...
    def GetLODEstimatedRenderTime(self, id:int) -> float: ...
    def GetLODIndexEstimatedRenderTime(self, index:int) -> float: ...
    def GetLODIndexLevel(self, index:int) -> float: ...
    def GetLODLevel(self, id:int) -> float: ...
    def GetLODMapper(self, id:int) -> vtkAbstractMapper3D: ...
    def GetLastRenderedLODID(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLODs(self) -> int: ...
    def GetPickLODID(self) -> int: ...
    def GetSelectedLODID(self) -> int: ...
    def GetSelectedPickLODID(self) -> int: ...
    def GetVolumes(self, __a:vtkPropCollection) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsLODEnabled(self, id:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLODProp3D: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RemoveLOD(self, id:int) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderVolumetricGeometry(self, viewport:vtkViewport) -> int: ...
    def RestoreEstimatedRenderTime(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLODProp3D: ...
    def SetAllocatedRenderTime(self, t:float, vp:vtkViewport) -> None: ...
    def SetAutomaticLODSelection(self, _arg:int) -> None: ...
    def SetAutomaticPickLODSelection(self, _arg:int) -> None: ...
    def SetLODBackfaceProperty(self, id:int, t:vtkProperty) -> None: ...
    def SetLODLevel(self, id:int, level:float) -> None: ...
    @overload
    def SetLODMapper(self, id:int, m:vtkMapper) -> None: ...
    @overload
    def SetLODMapper(self, id:int, m:vtkAbstractVolumeMapper) -> None: ...
    @overload
    def SetLODMapper(self, id:int, m:vtkImageMapper3D) -> None: ...
    @overload
    def SetLODProperty(self, id:int, p:vtkProperty) -> None: ...
    @overload
    def SetLODProperty(self, id:int, p:vtkVolumeProperty) -> None: ...
    @overload
    def SetLODProperty(self, id:int, p:vtkImageProperty) -> None: ...
    def SetLODTexture(self, id:int, t:vtkTexture) -> None: ...
    def SetSelectedLODID(self, _arg:int) -> None: ...
    def SetSelectedPickLODID(self, id:int) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkLODProp3DEntry_t(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:vtkLODProp3DEntry_t) -> None: ...

class vtkLabeledContourMapper(vtkMapper):
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetInput(self) -> vtkPolyData: ...
    def GetLabelVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyDataMapper(self) -> vtkPolyDataMapper: ...
    def GetSkipDistance(self) -> float: ...
    def GetTextProperties(self) -> vtkTextPropertyCollection: ...
    def GetTextPropertyMapping(self) -> vtkDoubleArray: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> vtkLabeledContourMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer, act:vtkActor) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabeledContourMapper: ...
    def SetInputData(self, in_:vtkPolyData) -> None: ...
    def SetLabelVisibility(self, _arg:bool) -> None: ...
    def SetSkipDistance(self, _arg:float) -> None: ...
    def SetTextProperties(self, coll:vtkTextPropertyCollection) -> None: ...
    def SetTextProperty(self, tprop:vtkTextProperty) -> None: ...
    def SetTextPropertyMapping(self, mapping:vtkDoubleArray) -> None: ...

class vtkLight(vtkmodules.vtkCommonCore.vtkObject):
    def DeepCopy(self, light:vtkLight) -> None: ...
    def GetAmbientColor(self) -> (float, float, float): ...
    def GetAttenuationValues(self) -> (float, float, float): ...
    def GetConeAngle(self) -> float: ...
    def GetDiffuseColor(self) -> (float, float, float): ...
    def GetExponent(self) -> float: ...
    def GetExponentMaxValue(self) -> float: ...
    def GetExponentMinValue(self) -> float: ...
    def GetFocalPoint(self) -> (float, float, float): ...
    def GetInformation(self) -> vtkInformation: ...
    def GetIntensity(self) -> float: ...
    def GetLightType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> (float, float, float): ...
    def GetPositional(self) -> int: ...
    def GetShadowAttenuation(self) -> float: ...
    def GetSpecularColor(self) -> (float, float, float): ...
    def GetSwitch(self) -> int: ...
    def GetTransformMatrix(self) -> vtkMatrix4x4: ...
    @overload
    def GetTransformedFocalPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetTransformedFocalPoint(self, a:[float, float, float]) -> None: ...
    @overload
    def GetTransformedFocalPoint(self) -> (float, float, float): ...
    @overload
    def GetTransformedPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetTransformedPosition(self, a:[float, float, float]) -> None: ...
    @overload
    def GetTransformedPosition(self) -> (float, float, float): ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LightTypeIsCameraLight(self) -> int: ...
    def LightTypeIsHeadlight(self) -> int: ...
    def LightTypeIsSceneLight(self) -> int: ...
    def NewInstance(self) -> vtkLight: ...
    def PositionalOff(self) -> None: ...
    def PositionalOn(self) -> None: ...
    def Render(self, __a:vtkRenderer, __b:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLight: ...
    @overload
    def SetAmbientColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAmbientColor(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetAttenuationValues(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAttenuationValues(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetColor(self, a:(float, float, float)) -> None: ...
    def SetConeAngle(self, _arg:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetDirectionAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetDirectionAngle(self, ang:(float, float)) -> None: ...
    def SetExponent(self, _arg:float) -> None: ...
    @overload
    def SetFocalPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetFocalPoint(self, _arg:(float, float, float)) -> None: ...
    def SetInformation(self, __a:vtkInformation) -> None: ...
    def SetIntensity(self, _arg:float) -> None: ...
    def SetLightType(self, __a:int) -> None: ...
    def SetLightTypeToCameraLight(self) -> None: ...
    def SetLightTypeToHeadlight(self) -> None: ...
    def SetLightTypeToSceneLight(self) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPosition(self, _arg:(float, float, float)) -> None: ...
    def SetPositional(self, _arg:int) -> None: ...
    def SetShadowAttenuation(self, _arg:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg:(float, float, float)) -> None: ...
    def SetSwitch(self, _arg:int) -> None: ...
    def SetTransformMatrix(self, __a:vtkMatrix4x4) -> None: ...
    def ShallowClone(self) -> vtkLight: ...
    def SwitchOff(self) -> None: ...
    def SwitchOn(self) -> None: ...
    def TransformPoint(self, a:[float, float, float], b:[float, float, float]) -> None: ...
    def TransformVector(self, a:[float, float, float], b:[float, float, float]) -> None: ...

class vtkLightActor(vtkProp3D):
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetClippingRange(self) -> (float, float): ...
    def GetConeProperty(self) -> vtkProperty: ...
    def GetFrustumProperty(self) -> vtkProperty: ...
    def GetLight(self) -> vtkLight: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLightActor: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLightActor: ...
    @overload
    def SetClippingRange(self, dNear:float, dFar:float) -> None: ...
    @overload
    def SetClippingRange(self, a:(float, float)) -> None: ...
    def SetLight(self, light:vtkLight) -> None: ...

class vtkLightCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, a:vtkLight) -> None: ...
    def GetNextItem(self) -> vtkLight: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLightCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLightCollection: ...

class vtkLightKit(vtkmodules.vtkCommonCore.vtkObject):
    class LightKitSubType(int): ...
    class LightKitType(int): ...
    Azimuth:'LightKitSubType'
    Elevation:'LightKitSubType'
    Intensity:'LightKitSubType'
    KBRatio:'LightKitSubType'
    KFRatio:'LightKitSubType'
    KHRatio:'LightKitSubType'
    TBackLight:'LightKitType'
    TFillLight:'LightKitType'
    THeadLight:'LightKitType'
    TKeyLight:'LightKitType'
    Warmth:'LightKitSubType'
    def AddLightsToRenderer(self, renderer:vtkRenderer) -> None: ...
    def DeepCopy(self, kit:vtkLightKit) -> None: ...
    def GetBackLightAngle(self) -> (float, float): ...
    def GetBackLightAzimuth(self) -> float: ...
    def GetBackLightColor(self) -> (float, float, float): ...
    def GetBackLightElevation(self) -> float: ...
    def GetBackLightWarmth(self) -> float: ...
    def GetFillLightAngle(self) -> (float, float): ...
    def GetFillLightAzimuth(self) -> float: ...
    def GetFillLightColor(self) -> (float, float, float): ...
    def GetFillLightElevation(self) -> float: ...
    def GetFillLightWarmth(self) -> float: ...
    def GetHeadLightColor(self) -> (float, float, float): ...
    def GetHeadLightWarmth(self) -> float: ...
    def GetKeyLightAngle(self) -> (float, float): ...
    def GetKeyLightAzimuth(self) -> float: ...
    def GetKeyLightColor(self) -> (float, float, float): ...
    def GetKeyLightElevation(self) -> float: ...
    def GetKeyLightIntensity(self) -> float: ...
    def GetKeyLightWarmth(self) -> float: ...
    def GetKeyToBackRatio(self) -> float: ...
    def GetKeyToBackRatioMaxValue(self) -> float: ...
    def GetKeyToBackRatioMinValue(self) -> float: ...
    def GetKeyToFillRatio(self) -> float: ...
    def GetKeyToFillRatioMaxValue(self) -> float: ...
    def GetKeyToFillRatioMinValue(self) -> float: ...
    def GetKeyToHeadRatio(self) -> float: ...
    def GetKeyToHeadRatioMaxValue(self) -> float: ...
    def GetKeyToHeadRatioMinValue(self) -> float: ...
    def GetMaintainLuminance(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetShortStringFromSubType(subtype:int) -> str: ...
    @staticmethod
    def GetStringFromSubType(type:int) -> str: ...
    @staticmethod
    def GetStringFromType(type:int) -> str: ...
    @staticmethod
    def GetSubType(type:LightKitType, i:int) -> LightKitSubType: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MaintainLuminanceOff(self) -> None: ...
    def MaintainLuminanceOn(self) -> None: ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> vtkLightKit: ...
    def RemoveLightsFromRenderer(self, renderer:vtkRenderer) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLightKit: ...
    @overload
    def SetBackLightAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetBackLightAngle(self, angle:[float, float]) -> None: ...
    def SetBackLightAzimuth(self, x:float) -> None: ...
    def SetBackLightElevation(self, x:float) -> None: ...
    def SetBackLightWarmth(self, _arg:float) -> None: ...
    @overload
    def SetFillLightAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetFillLightAngle(self, angle:[float, float]) -> None: ...
    def SetFillLightAzimuth(self, x:float) -> None: ...
    def SetFillLightElevation(self, x:float) -> None: ...
    def SetFillLightWarmth(self, _arg:float) -> None: ...
    def SetHeadLightWarmth(self, _arg:float) -> None: ...
    @overload
    def SetKeyLightAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetKeyLightAngle(self, angle:[float, float]) -> None: ...
    def SetKeyLightAzimuth(self, x:float) -> None: ...
    def SetKeyLightElevation(self, x:float) -> None: ...
    def SetKeyLightIntensity(self, _arg:float) -> None: ...
    def SetKeyLightWarmth(self, _arg:float) -> None: ...
    def SetKeyToBackRatio(self, _arg:float) -> None: ...
    def SetKeyToFillRatio(self, _arg:float) -> None: ...
    def SetKeyToHeadRatio(self, _arg:float) -> None: ...
    def SetMaintainLuminance(self, _arg:int) -> None: ...
    def Update(self) -> None: ...

class vtkLogLookupTable(vtkmodules.vtkCommonCore.vtkLookupTable):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLogLookupTable: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLogLookupTable: ...

class vtkLookupTableWithEnabling(vtkmodules.vtkCommonCore.vtkLookupTable):
    def DisableColor(self, r:int, g:int, b:int, rd:[int, ...], gd:[int, ...], bd:[int, ...]) -> None: ...
    def GetEnabledArray(self) -> vtkDataArray: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:[int, ...], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def NewInstance(self) -> vtkLookupTableWithEnabling: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLookupTableWithEnabling: ...
    def SetEnabledArray(self, enabledArray:vtkDataArray) -> None: ...

class vtkMapArrayValues(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    class FieldType(int): ...
    CELL_DATA:'FieldType'
    EDGE_DATA:'FieldType'
    NUM_ATTRIBUTE_LOCS:'FieldType'
    POINT_DATA:'FieldType'
    ROW_DATA:'FieldType'
    VERTEX_DATA:'FieldType'
    @overload
    def AddToMap(self, from_:vtkVariant, to:vtkVariant) -> None: ...
    @overload
    def AddToMap(self, from_:int, to:int) -> None: ...
    @overload
    def AddToMap(self, from_:int, to:str) -> None: ...
    @overload
    def AddToMap(self, from_:str, to:int) -> None: ...
    @overload
    def AddToMap(self, from_:str, to:str) -> None: ...
    def ClearMap(self) -> None: ...
    def GetFieldType(self) -> int: ...
    def GetFillValue(self) -> float: ...
    def GetInputArrayName(self) -> str: ...
    def GetMapSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputArrayName(self) -> str: ...
    def GetOutputArrayType(self) -> int: ...
    def GetPassArray(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMapArrayValues: ...
    def PassArrayOff(self) -> None: ...
    def PassArrayOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMapArrayValues: ...
    def SetFieldType(self, _arg:int) -> None: ...
    def SetFillValue(self, _arg:float) -> None: ...
    def SetInputArrayName(self, _arg:str) -> None: ...
    def SetOutputArrayName(self, _arg:str) -> None: ...
    def SetOutputArrayType(self, _arg:int) -> None: ...
    def SetPassArray(self, _arg:int) -> None: ...

class vtkMapperCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, a:vtkMapper) -> None: ...
    def GetLastItem(self) -> vtkMapper: ...
    def GetNextItem(self) -> vtkMapper: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMapperCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMapperCollection: ...

class vtkObserverMediator(vtkmodules.vtkCommonCore.vtkObject):
    def GetInteractor(self) -> vtkRenderWindowInteractor: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkObserverMediator: ...
    def RemoveAllCursorShapeRequests(self, __a:vtkInteractorObserver) -> None: ...
    def RequestCursorShape(self, __a:vtkInteractorObserver, requestedShape:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkObserverMediator: ...
    def SetInteractor(self, iren:vtkRenderWindowInteractor) -> None: ...

class vtkPickingManager(vtkmodules.vtkCommonCore.vtkObject):
    def AddPicker(self, picker:vtkAbstractPicker, object:vtkObject=...) -> None: ...
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetAssemblyPath(self, X:float, Y:float, Z:float, picker:vtkAbstractPropPicker, renderer:vtkRenderer, obj:vtkObject) -> vtkAssemblyPath: ...
    def GetEnabled(self) -> bool: ...
    def GetInteractor(self) -> vtkRenderWindowInteractor: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfObjectsLinked(self, picker:vtkAbstractPicker) -> int: ...
    def GetNumberOfPickers(self) -> int: ...
    def GetOptimizeOnInteractorEvents(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPickingManager: ...
    @overload
    def Pick(self, picker:vtkAbstractPicker, object:vtkObject) -> bool: ...
    @overload
    def Pick(self, object:vtkObject) -> bool: ...
    @overload
    def Pick(self, picker:vtkAbstractPicker) -> bool: ...
    def RemoveObject(self, object:vtkObject) -> None: ...
    def RemovePicker(self, picker:vtkAbstractPicker, object:vtkObject=...) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPickingManager: ...
    def SetEnabled(self, _arg:bool) -> None: ...
    def SetInteractor(self, iren:vtkRenderWindowInteractor) -> None: ...
    def SetOptimizeOnInteractorEvents(self, optimize:bool) -> None: ...

class vtkPolyDataMapper(vtkMapper):
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetGhostLevel(self) -> int: ...
    def GetInput(self) -> vtkPolyData: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfSubPieces(self) -> int: ...
    def GetPiece(self) -> int: ...
    def GetSeamlessU(self) -> bool: ...
    def GetSeamlessV(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapDataArrayToMultiTextureAttribute(self, textureName:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def MapDataArrayToVertexAttribute(self, vertexAttributeName:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def NewInstance(self) -> vtkPolyDataMapper: ...
    def RemoveAllVertexAttributeMappings(self) -> None: ...
    def RemoveVertexAttributeMapping(self, vertexAttributeName:str) -> None: ...
    def Render(self, ren:vtkRenderer, act:vtkActor) -> None: ...
    def RenderPiece(self, __a:vtkRenderer, __b:vtkActor) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPolyDataMapper: ...
    def SeamlessUOff(self) -> None: ...
    def SeamlessUOn(self) -> None: ...
    def SeamlessVOff(self) -> None: ...
    def SeamlessVOn(self) -> None: ...
    def SetGhostLevel(self, _arg:int) -> None: ...
    def SetInputData(self, in_:vtkPolyData) -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetNumberOfSubPieces(self, _arg:int) -> None: ...
    def SetPiece(self, _arg:int) -> None: ...
    def SetSeamlessU(self, _arg:bool) -> None: ...
    def SetSeamlessV(self, _arg:bool) -> None: ...
    def ShallowCopy(self, m:vtkAbstractMapper) -> None: ...
    @overload
    def Update(self, port:int) -> None: ...
    @overload
    def Update(self) -> None: ...
    @overload
    def Update(self, port:int, requests:vtkInformationVector) -> int: ...
    @overload
    def Update(self, requests:vtkInformation) -> int: ...

class vtkPointGaussianMapper(vtkPolyDataMapper):
    def EmissiveOff(self) -> None: ...
    def EmissiveOn(self) -> None: ...
    def GetEmissive(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacityArray(self) -> str: ...
    def GetOpacityArrayComponent(self) -> int: ...
    def GetOpacityTableSize(self) -> int: ...
    def GetScalarOpacityFunction(self) -> vtkPiecewiseFunction: ...
    def GetScaleArray(self) -> str: ...
    def GetScaleArrayComponent(self) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaleFunction(self) -> vtkPiecewiseFunction: ...
    def GetScaleTableSize(self) -> int: ...
    def GetSplatShaderCode(self) -> str: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetTriangleScale(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPointGaussianMapper: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPointGaussianMapper: ...
    def SetEmissive(self, _arg:int) -> None: ...
    def SetOpacityArray(self, _arg:str) -> None: ...
    def SetOpacityArrayComponent(self, _arg:int) -> None: ...
    def SetOpacityTableSize(self, _arg:int) -> None: ...
    def SetScalarOpacityFunction(self, __a:vtkPiecewiseFunction) -> None: ...
    def SetScaleArray(self, _arg:str) -> None: ...
    def SetScaleArrayComponent(self, _arg:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaleFunction(self, __a:vtkPiecewiseFunction) -> None: ...
    def SetScaleTableSize(self, _arg:int) -> None: ...
    def SetSplatShaderCode(self, _arg:str) -> None: ...
    def SetTriangleScale(self, _arg:float) -> None: ...

class vtkPointPicker(vtkPicker):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointId(self) -> int: ...
    def GetUseCells(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPointPicker: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPointPicker: ...
    def SetUseCells(self, _arg:int) -> None: ...
    def UseCellsOff(self) -> None: ...
    def UseCellsOn(self) -> None: ...

class vtkPolyDataMapper2D(vtkMapper2D):
    @overload
    def ColorByArrayComponent(self, arrayNum:int, component:int) -> None: ...
    @overload
    def ColorByArrayComponent(self, arrayName:str, component:int) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetArrayAccessMode(self) -> int: ...
    def GetArrayComponent(self) -> int: ...
    def GetArrayId(self) -> int: ...
    def GetArrayName(self) -> str: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeAsString(self) -> str: ...
    def GetInput(self) -> vtkPolyData: ...
    def GetLookupTable(self) -> vtkScalarsToColors: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarRange(self) -> (float, float): ...
    def GetScalarVisibility(self) -> int: ...
    def GetTransformCoordinate(self) -> vtkCoordinate: ...
    def GetTransformCoordinateUseDouble(self) -> bool: ...
    def GetUseLookupTableScalarRange(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalars(self, alpha:float) -> vtkUnsignedCharArray: ...
    def NewInstance(self) -> vtkPolyDataMapper2D: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPolyDataMapper2D: ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToDirectScalars(self) -> None: ...
    def SetColorModeToMapScalars(self) -> None: ...
    def SetInputData(self, in_:vtkPolyData) -> None: ...
    def SetLookupTable(self, lut:vtkScalarsToColors) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToDefault(self) -> None: ...
    def SetScalarModeToUseCellData(self) -> None: ...
    def SetScalarModeToUseCellFieldData(self) -> None: ...
    def SetScalarModeToUsePointData(self) -> None: ...
    def SetScalarModeToUsePointFieldData(self) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:(float, float)) -> None: ...
    def SetScalarVisibility(self, _arg:int) -> None: ...
    def SetTransformCoordinate(self, __a:vtkCoordinate) -> None: ...
    def SetTransformCoordinateUseDouble(self, _arg:bool) -> None: ...
    def SetUseLookupTableScalarRange(self, _arg:int) -> None: ...
    def ShallowCopy(self, m:vtkAbstractMapper) -> None: ...
    def TransformCoordinateUseDoubleOff(self) -> None: ...
    def TransformCoordinateUseDoubleOn(self) -> None: ...
    def UseLookupTableScalarRangeOff(self) -> None: ...
    def UseLookupTableScalarRangeOn(self) -> None: ...

class vtkProp3DCollection(vtkPropCollection):
    def AddItem(self, p:vtkProp3D) -> None: ...
    def GetLastProp3D(self) -> vtkProp3D: ...
    def GetNextProp3D(self) -> vtkProp3D: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProp3DCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProp3DCollection: ...

class vtkProp3DFollower(vtkProp3D):
    def ComputeMatrix(self) -> None: ...
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetCamera(self) -> vtkCamera: ...
    def GetNextPath(self) -> vtkAssemblyPath: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProp3D(self) -> vtkProp3D: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProp3DFollower: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderVolumetricGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProp3DFollower: ...
    def SetCamera(self, __a:vtkCamera) -> None: ...
    def SetProp3D(self, prop:vtkProp3D) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkPropAssembly(vtkProp):
    def AddPart(self, __a:vtkProp) -> None: ...
    def BuildPaths(self, paths:vtkAssemblyPaths, path:vtkAssemblyPath) -> None: ...
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetMTime(self) -> int: ...
    def GetNextPath(self) -> vtkAssemblyPath: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def GetParts(self) -> vtkPropCollection: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPropAssembly: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RemovePart(self, __a:vtkProp) -> None: ...
    def RenderOpaqueGeometry(self, ren:vtkViewport) -> int: ...
    def RenderOverlay(self, ren:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, ren:vtkViewport) -> int: ...
    def RenderVolumetricGeometry(self, ren:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPropAssembly: ...
    def ShallowCopy(self, Prop:vtkProp) -> None: ...

class vtkPropPicker(vtkAbstractPropPicker):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPropPicker: ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:vtkRenderer) -> int: ...
    @overload
    def Pick(self, selectionPt:[float, float, float], renderer:vtkRenderer) -> int: ...
    def Pick3DPoint(self, selectionPt:[float, float, float], ren:vtkRenderer) -> int: ...
    def Pick3DRay(self, selectionPt:[float, float, float], orient:[float, float, float, float], ren:vtkRenderer) -> int: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, renderer:vtkRenderer) -> int: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, renderer:vtkRenderer, pickfrom:vtkPropCollection) -> int: ...
    @overload
    def PickProp3DPoint(self, pos:[float, float, float], renderer:vtkRenderer) -> int: ...
    @overload
    def PickProp3DPoint(self, pos:[float, float, float], renderer:vtkRenderer, pickfrom:vtkPropCollection) -> int: ...
    def PickProp3DRay(self, selectionPt:[float, float, float], eventWorldOrientation:[float, float, float, float], renderer:vtkRenderer, pickfrom:vtkPropCollection) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPropPicker: ...

class vtkProperty(vtkmodules.vtkCommonCore.vtkObject):
    @overload
    def AddShaderVariable(self, name:str, numVars:int, x:[int, ...]) -> None: ...
    @overload
    def AddShaderVariable(self, name:str, numVars:int, x:[float, ...]) -> None: ...
    @overload
    def AddShaderVariable(self, name:str, v:int) -> None: ...
    @overload
    def AddShaderVariable(self, name:str, v:float) -> None: ...
    @overload
    def AddShaderVariable(self, name:str, v1:int, v2:int) -> None: ...
    @overload
    def AddShaderVariable(self, name:str, v1:float, v2:float) -> None: ...
    @overload
    def AddShaderVariable(self, name:str, v1:int, v2:int, v3:int) -> None: ...
    @overload
    def AddShaderVariable(self, name:str, v1:float, v2:float, v3:float) -> None: ...
    def BackfaceCullingOff(self) -> None: ...
    def BackfaceCullingOn(self) -> None: ...
    def BackfaceRender(self, __a:vtkActor, __b:vtkRenderer) -> None: ...
    @staticmethod
    def ComputeIORFromReflectance(reflectance:float, ior:float) -> float: ...
    @staticmethod
    def ComputeReflectanceFromIOR(IORTo:float, IORFrom:float) -> float: ...
    def ComputeReflectanceOfBaseLayer(self) -> float: ...
    def DeepCopy(self, p:vtkProperty) -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def FrontfaceCullingOff(self) -> None: ...
    def FrontfaceCullingOn(self) -> None: ...
    def GetAmbient(self) -> float: ...
    def GetAmbientColor(self) -> (float, float, float): ...
    def GetAmbientMaxValue(self) -> float: ...
    def GetAmbientMinValue(self) -> float: ...
    def GetAnisotropy(self) -> float: ...
    def GetAnisotropyMaxValue(self) -> float: ...
    def GetAnisotropyMinValue(self) -> float: ...
    def GetAnisotropyRotation(self) -> float: ...
    def GetAnisotropyRotationMaxValue(self) -> float: ...
    def GetAnisotropyRotationMinValue(self) -> float: ...
    def GetBackfaceCulling(self) -> int: ...
    def GetBaseIOR(self) -> float: ...
    def GetBaseIORMaxValue(self) -> float: ...
    def GetBaseIORMinValue(self) -> float: ...
    def GetCoatColor(self) -> (float, float, float): ...
    def GetCoatIOR(self) -> float: ...
    def GetCoatIORMaxValue(self) -> float: ...
    def GetCoatIORMinValue(self) -> float: ...
    def GetCoatNormalScale(self) -> float: ...
    def GetCoatNormalScaleMaxValue(self) -> float: ...
    def GetCoatNormalScaleMinValue(self) -> float: ...
    def GetCoatRoughness(self) -> float: ...
    def GetCoatRoughnessMaxValue(self) -> float: ...
    def GetCoatRoughnessMinValue(self) -> float: ...
    def GetCoatStrength(self) -> float: ...
    def GetCoatStrengthMaxValue(self) -> float: ...
    def GetCoatStrengthMinValue(self) -> float: ...
    @overload
    def GetColor(self) -> (float, float, float): ...
    @overload
    def GetColor(self, rgb:[float, float, float]) -> None: ...
    @overload
    def GetColor(self, r:float, g:float, b:float) -> None: ...
    def GetDiffuse(self) -> float: ...
    def GetDiffuseColor(self) -> (float, float, float): ...
    def GetDiffuseMaxValue(self) -> float: ...
    def GetDiffuseMinValue(self) -> float: ...
    def GetEdgeColor(self) -> (float, float, float): ...
    def GetEdgeTint(self) -> (float, float, float): ...
    def GetEdgeVisibility(self) -> int: ...
    def GetEmissiveFactor(self) -> (float, float, float): ...
    def GetFrontfaceCulling(self) -> int: ...
    def GetInformation(self) -> vtkInformation: ...
    def GetInterpolation(self) -> int: ...
    def GetInterpolationAsString(self) -> str: ...
    def GetInterpolationMaxValue(self) -> int: ...
    def GetInterpolationMinValue(self) -> int: ...
    def GetLighting(self) -> bool: ...
    def GetLineStipplePattern(self) -> int: ...
    def GetLineStippleRepeatFactor(self) -> int: ...
    def GetLineStippleRepeatFactorMaxValue(self) -> int: ...
    def GetLineStippleRepeatFactorMinValue(self) -> int: ...
    def GetLineWidth(self) -> float: ...
    def GetLineWidthMaxValue(self) -> float: ...
    def GetLineWidthMinValue(self) -> float: ...
    def GetMaterialName(self) -> str: ...
    def GetMetallic(self) -> float: ...
    def GetMetallicMaxValue(self) -> float: ...
    def GetMetallicMinValue(self) -> float: ...
    def GetNormalScale(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTextures(self) -> int: ...
    def GetOcclusionStrength(self) -> float: ...
    def GetOcclusionStrengthMaxValue(self) -> float: ...
    def GetOcclusionStrengthMinValue(self) -> float: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetPointSize(self) -> float: ...
    def GetPointSizeMaxValue(self) -> float: ...
    def GetPointSizeMinValue(self) -> float: ...
    def GetRenderLinesAsTubes(self) -> bool: ...
    def GetRenderPointsAsSpheres(self) -> bool: ...
    def GetRepresentation(self) -> int: ...
    def GetRepresentationAsString(self) -> str: ...
    def GetRepresentationMaxValue(self) -> int: ...
    def GetRepresentationMinValue(self) -> int: ...
    def GetRoughness(self) -> float: ...
    def GetRoughnessMaxValue(self) -> float: ...
    def GetRoughnessMinValue(self) -> float: ...
    def GetSelectionColor(self) -> (float, float, float, float): ...
    def GetSelectionLineWidth(self) -> float: ...
    def GetSelectionPointSize(self) -> float: ...
    def GetShading(self) -> int: ...
    def GetShowTexturesOnBackface(self) -> bool: ...
    def GetSpecular(self) -> float: ...
    def GetSpecularColor(self) -> (float, float, float): ...
    def GetSpecularMaxValue(self) -> float: ...
    def GetSpecularMinValue(self) -> float: ...
    def GetSpecularPower(self) -> float: ...
    def GetSpecularPowerMaxValue(self) -> float: ...
    def GetSpecularPowerMinValue(self) -> float: ...
    def GetTexture(self, name:str) -> vtkTexture: ...
    def GetVertexColor(self) -> (float, float, float): ...
    def GetVertexVisibility(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LightingOff(self) -> None: ...
    def LightingOn(self) -> None: ...
    def NewInstance(self) -> vtkProperty: ...
    def PostRender(self, __a:vtkActor, __b:vtkRenderer) -> None: ...
    def ReleaseGraphicsResources(self, win:vtkWindow) -> None: ...
    def RemoveAllTextures(self) -> None: ...
    def RemoveTexture(self, name:str) -> None: ...
    def Render(self, __a:vtkActor, __b:vtkRenderer) -> None: ...
    def RenderLinesAsTubesOff(self) -> None: ...
    def RenderLinesAsTubesOn(self) -> None: ...
    def RenderPointsAsSpheresOff(self) -> None: ...
    def RenderPointsAsSpheresOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProperty: ...
    def SetAmbient(self, _arg:float) -> None: ...
    @overload
    def SetAmbientColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAmbientColor(self, _arg:(float, float, float)) -> None: ...
    def SetAnisotropy(self, _arg:float) -> None: ...
    def SetAnisotropyRotation(self, _arg:float) -> None: ...
    def SetAnisotropyTexture(self, texture:vtkTexture) -> None: ...
    def SetBackfaceCulling(self, _arg:int) -> None: ...
    def SetBaseColorTexture(self, texture:vtkTexture) -> None: ...
    def SetBaseIOR(self, _arg:float) -> None: ...
    @overload
    def SetCoatColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCoatColor(self, _arg:(float, float, float)) -> None: ...
    def SetCoatIOR(self, _arg:float) -> None: ...
    def SetCoatNormalScale(self, _arg:float) -> None: ...
    def SetCoatNormalTexture(self, texture:vtkTexture) -> None: ...
    def SetCoatRoughness(self, _arg:float) -> None: ...
    def SetCoatStrength(self, _arg:float) -> None: ...
    @overload
    def SetColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColor(self, a:[float, float, float]) -> None: ...
    def SetDiffuse(self, _arg:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetEdgeColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEdgeColor(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetEdgeTint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEdgeTint(self, _arg:(float, float, float)) -> None: ...
    def SetEdgeVisibility(self, _arg:int) -> None: ...
    @overload
    def SetEmissiveFactor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEmissiveFactor(self, _arg:(float, float, float)) -> None: ...
    def SetEmissiveTexture(self, texture:vtkTexture) -> None: ...
    def SetFrontfaceCulling(self, _arg:int) -> None: ...
    def SetInformation(self, __a:vtkInformation) -> None: ...
    def SetInterpolation(self, _arg:int) -> None: ...
    def SetInterpolationToFlat(self) -> None: ...
    def SetInterpolationToGouraud(self) -> None: ...
    def SetInterpolationToPBR(self) -> None: ...
    def SetInterpolationToPhong(self) -> None: ...
    def SetLighting(self, _arg:bool) -> None: ...
    def SetLineStipplePattern(self, _arg:int) -> None: ...
    def SetLineStippleRepeatFactor(self, _arg:int) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    def SetMaterialName(self, _arg:str) -> None: ...
    def SetMetallic(self, _arg:float) -> None: ...
    def SetNormalScale(self, _arg:float) -> None: ...
    def SetNormalTexture(self, texture:vtkTexture) -> None: ...
    def SetORMTexture(self, texture:vtkTexture) -> None: ...
    def SetOcclusionStrength(self, _arg:float) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetPointSize(self, _arg:float) -> None: ...
    def SetRenderLinesAsTubes(self, _arg:bool) -> None: ...
    def SetRenderPointsAsSpheres(self, _arg:bool) -> None: ...
    def SetRepresentation(self, _arg:int) -> None: ...
    def SetRepresentationToPoints(self) -> None: ...
    def SetRepresentationToSurface(self) -> None: ...
    def SetRepresentationToWireframe(self) -> None: ...
    def SetRoughness(self, _arg:float) -> None: ...
    @overload
    def SetSelectionColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetSelectionColor(self, _arg:(float, float, float, float)) -> None: ...
    def SetSelectionLineWidth(self, _arg:float) -> None: ...
    def SetSelectionPointSize(self, _arg:float) -> None: ...
    def SetShading(self, _arg:int) -> None: ...
    def SetShowTexturesOnBackface(self, _arg:bool) -> None: ...
    def SetSpecular(self, _arg:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg:(float, float, float)) -> None: ...
    def SetSpecularPower(self, _arg:float) -> None: ...
    def SetTexture(self, name:str, texture:vtkTexture) -> None: ...
    @overload
    def SetVertexColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetVertexColor(self, _arg:(float, float, float)) -> None: ...
    def SetVertexVisibility(self, _arg:int) -> None: ...
    def ShadingOff(self) -> None: ...
    def ShadingOn(self) -> None: ...
    def ShowTexturesOnBackfaceOff(self) -> None: ...
    def ShowTexturesOnBackfaceOn(self) -> None: ...
    def VertexVisibilityOff(self) -> None: ...
    def VertexVisibilityOn(self) -> None: ...

class vtkProperty2D(vtkmodules.vtkCommonCore.vtkObject):
    def DeepCopy(self, p:vtkProperty2D) -> None: ...
    def GetColor(self) -> (float, float, float): ...
    def GetDisplayLocation(self) -> int: ...
    def GetDisplayLocationMaxValue(self) -> int: ...
    def GetDisplayLocationMinValue(self) -> int: ...
    def GetLineStipplePattern(self) -> int: ...
    def GetLineStippleRepeatFactor(self) -> int: ...
    def GetLineStippleRepeatFactorMaxValue(self) -> int: ...
    def GetLineStippleRepeatFactorMinValue(self) -> int: ...
    def GetLineWidth(self) -> float: ...
    def GetLineWidthMaxValue(self) -> float: ...
    def GetLineWidthMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetPointSize(self) -> float: ...
    def GetPointSizeMaxValue(self) -> float: ...
    def GetPointSizeMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProperty2D: ...
    def Render(self, viewport:vtkViewport) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProperty2D: ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:(float, float, float)) -> None: ...
    def SetDisplayLocation(self, _arg:int) -> None: ...
    def SetDisplayLocationToBackground(self) -> None: ...
    def SetDisplayLocationToForeground(self) -> None: ...
    def SetLineStipplePattern(self, _arg:int) -> None: ...
    def SetLineStippleRepeatFactor(self, _arg:int) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetPointSize(self, _arg:float) -> None: ...

class vtkRayCastRayInfo_t(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:vtkRayCastRayInfo_t) -> None: ...

class vtkRenderPass(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRenderedProps(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderPass: ...
    def ReleaseGraphicsResources(self, w:vtkWindow) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderPass: ...

class vtkRenderState(object):
    def __init__(self, renderer:vtkRenderer) -> None: ...
    def GetFrameBuffer(self) -> vtkFrameBufferObjectBase: ...
    def GetPropArrayCount(self) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetRequiredKeys(self) -> vtkInformation: ...
    def GetWindowSize(self, size:[int, int]) -> None: ...
    def IsValid(self) -> bool: ...
    def SetFrameBuffer(self, fbo:vtkFrameBufferObjectBase) -> None: ...
    def SetRequiredKeys(self, keys:vtkInformation) -> None: ...

class vtkRenderTimerLog(vtkmodules.vtkCommonCore.vtkObject):
    def FrameReady(self) -> bool: ...
    def GetFrameLimit(self) -> int: ...
    def GetLoggingEnabled(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsSupported(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoggingEnabledOff(self) -> None: ...
    def LoggingEnabledOn(self) -> None: ...
    def MarkEndEvent(self) -> None: ...
    def MarkFrame(self) -> None: ...
    def MarkStartEvent(self, name:str) -> None: ...
    def NewInstance(self) -> vtkRenderTimerLog: ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderTimerLog: ...
    def SetFrameLimit(self, _arg:int) -> None: ...
    def SetLoggingEnabled(self, _arg:bool) -> None: ...

class vtkRenderWidget(vtkmodules.vtkCommonCore.vtkObject):
    def GetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> vtkVector2i: ...
    def GetSize(self) -> vtkVector2i: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> vtkRenderWidget: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderWidget: ...
    def SetName(self, name:str) -> None: ...
    def SetPosition(self, pos:vtkVector2i) -> None: ...
    def SetSize(self, size:vtkVector2i) -> None: ...
    def Start(self) -> None: ...

class vtkRenderWindow(vtkmodules.vtkCommonCore.vtkWindow):
    def AddRenderer(self, __a:vtkRenderer) -> None: ...
    def AlphaBitPlanesOff(self) -> None: ...
    def AlphaBitPlanesOn(self) -> None: ...
    def BordersOff(self) -> None: ...
    def BordersOn(self) -> None: ...
    def CaptureGL2PSSpecialProps(self, specialProps:vtkCollection) -> None: ...
    def CheckAbortStatus(self) -> int: ...
    def CheckInRenderStatus(self) -> int: ...
    def ClearInRenderStatus(self) -> None: ...
    def CopyResultFrame(self) -> None: ...
    def End(self) -> None: ...
    def Finalize(self) -> None: ...
    def Frame(self) -> None: ...
    def FullScreenOff(self) -> None: ...
    def FullScreenOn(self) -> None: ...
    def GetAbortRender(self) -> int: ...
    def GetAlphaBitPlanes(self) -> int: ...
    def GetAnaglyphColorMask(self) -> (int, int): ...
    def GetAnaglyphColorSaturation(self) -> float: ...
    def GetAnaglyphColorSaturationMaxValue(self) -> float: ...
    def GetAnaglyphColorSaturationMinValue(self) -> float: ...
    def GetBorders(self) -> int: ...
    def GetCapturingGL2PSSpecialProps(self) -> int: ...
    def GetColorBufferSizes(self, __a:[int, ...]) -> int: ...
    def GetCurrentCursor(self) -> int: ...
    def GetCursorFileName(self) -> str: ...
    def GetDepthBufferSize(self) -> int: ...
    def GetDesiredUpdateRate(self) -> float: ...
    def GetDeviceIndex(self) -> int: ...
    def GetDeviceToWorldMatrixForDevice(self, device:vtkEventDataDevice, deviceToWorldMatrix:vtkMatrix4x4) -> bool: ...
    def GetEventPending(self) -> int: ...
    def GetFullScreen(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetInAbortCheck(self) -> int: ...
    def GetInteractor(self) -> vtkRenderWindowInteractor: ...
    def GetLineSmoothing(self) -> int: ...
    def GetMultiSamples(self) -> int: ...
    def GetNeverRendered(self) -> int: ...
    def GetNumberOfDevices(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLayers(self) -> int: ...
    def GetNumberOfLayersMaxValue(self) -> int: ...
    def GetNumberOfLayersMinValue(self) -> int: ...
    def GetPhysicalToWorldMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    def GetPlatformSupportsRenderWindowSharing(self) -> bool: ...
    def GetPointSmoothing(self) -> int: ...
    def GetPolygonSmoothing(self) -> int: ...
    @overload
    def GetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:int) -> Pointer: ...
    @overload
    def GetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:vtkUnsignedCharArray, __g:int) -> int: ...
    @overload
    def GetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:int) -> Pointer: ...
    @overload
    def GetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:vtkFloatArray, __g:int) -> int: ...
    @staticmethod
    def GetRenderLibrary() -> str: ...
    def GetRenderTimer(self) -> vtkRenderTimerLog: ...
    def GetRenderers(self) -> vtkRendererCollection: ...
    def GetRenderingBackend(self) -> str: ...
    def GetSharedRenderWindow(self) -> vtkRenderWindow: ...
    def GetStencilCapable(self) -> int: ...
    def GetStereoCapableWindow(self) -> int: ...
    def GetStereoRender(self) -> int: ...
    def GetStereoType(self) -> int: ...
    @overload
    def GetStereoTypeAsString(self) -> str: ...
    @overload
    @staticmethod
    def GetStereoTypeAsString(type:int) -> str: ...
    def GetSwapBuffers(self) -> int: ...
    def GetUseSRGBColorSpace(self) -> bool: ...
    @overload
    def GetZbufferData(self, __a:int, __b:int, __c:int, __d:int) -> Pointer: ...
    @overload
    def GetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:[float, ...]) -> int: ...
    @overload
    def GetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:vtkFloatArray) -> int: ...
    def GetZbufferDataAtPoint(self, x:int, y:int) -> float: ...
    def HasRenderer(self, __a:vtkRenderer) -> int: ...
    def HideCursor(self) -> None: ...
    def InitializeFromCurrentContext(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    def IsDrawable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LineSmoothingOff(self) -> None: ...
    def LineSmoothingOn(self) -> None: ...
    def MakeRenderWindowInteractor(self) -> vtkRenderWindowInteractor: ...
    def NewInstance(self) -> vtkRenderWindow: ...
    def PointSmoothingOff(self) -> None: ...
    def PointSmoothingOn(self) -> None: ...
    def PolygonSmoothingOff(self) -> None: ...
    def PolygonSmoothingOn(self) -> None: ...
    def ReleaseRGBAPixelData(self, __a:[float, ...]) -> None: ...
    def RemoveRenderer(self, __a:vtkRenderer) -> None: ...
    def Render(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderWindow: ...
    def SetAbortRender(self, _arg:int) -> None: ...
    def SetAlphaBitPlanes(self, _arg:int) -> None: ...
    @overload
    def SetAnaglyphColorMask(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetAnaglyphColorMask(self, _arg:(int, int)) -> None: ...
    def SetAnaglyphColorSaturation(self, _arg:float) -> None: ...
    def SetBorders(self, _arg:int) -> None: ...
    def SetCurrentCursor(self, _arg:int) -> None: ...
    def SetCursorFileName(self, _arg:str) -> None: ...
    def SetCursorPosition(self, __a:int, __b:int) -> None: ...
    def SetDesiredUpdateRate(self, __a:float) -> None: ...
    def SetDeviceIndex(self, _arg:int) -> None: ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetForceMakeCurrent(self) -> None: ...
    def SetFullScreen(self, __a:int) -> None: ...
    def SetInAbortCheck(self, _arg:int) -> None: ...
    def SetInteractor(self, __a:vtkRenderWindowInteractor) -> None: ...
    def SetLineSmoothing(self, _arg:int) -> None: ...
    def SetMultiSamples(self, __a:int) -> None: ...
    def SetNextWindowId(self, __a:Pointer) -> None: ...
    def SetNextWindowInfo(self, __a:str) -> None: ...
    def SetNumberOfLayers(self, _arg:int) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    def SetParentInfo(self, __a:str) -> None: ...
    @overload
    def SetPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:[int, ...], __f:int, __g:int) -> int: ...
    @overload
    def SetPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:vtkUnsignedCharArray, __f:int, __g:int) -> int: ...
    def SetPointSmoothing(self, _arg:int) -> None: ...
    def SetPolygonSmoothing(self, _arg:int) -> None: ...
    @overload
    def SetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:[int, ...], __f:int, __g:int, __h:int) -> int: ...
    @overload
    def SetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:vtkUnsignedCharArray, __f:int, __g:int, __h:int) -> int: ...
    @overload
    def SetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:[float, ...], __f:int, __g:int, __h:int) -> int: ...
    @overload
    def SetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:vtkFloatArray, __f:int, __g:int, __h:int) -> int: ...
    def SetSharedRenderWindow(self, __a:vtkRenderWindow) -> None: ...
    def SetStencilCapable(self, _arg:int) -> None: ...
    def SetStereoCapableWindow(self, capable:int) -> None: ...
    def SetStereoRender(self, stereo:int) -> None: ...
    def SetStereoType(self, __a:int) -> None: ...
    def SetStereoTypeToAnaglyph(self) -> None: ...
    def SetStereoTypeToCheckerboard(self) -> None: ...
    def SetStereoTypeToCrystalEyes(self) -> None: ...
    def SetStereoTypeToDresden(self) -> None: ...
    def SetStereoTypeToEmulate(self) -> None: ...
    def SetStereoTypeToFake(self) -> None: ...
    def SetStereoTypeToInterlaced(self) -> None: ...
    def SetStereoTypeToLeft(self) -> None: ...
    def SetStereoTypeToRedBlue(self) -> None: ...
    def SetStereoTypeToRight(self) -> None: ...
    def SetStereoTypeToSplitViewportHorizontal(self) -> None: ...
    def SetSwapBuffers(self, _arg:int) -> None: ...
    def SetUseSRGBColorSpace(self, _arg:bool) -> None: ...
    def SetWindowId(self, __a:Pointer) -> None: ...
    def SetWindowInfo(self, __a:str) -> None: ...
    @overload
    def SetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:[float, ...]) -> int: ...
    @overload
    def SetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:vtkFloatArray) -> int: ...
    def ShowCursor(self) -> None: ...
    def Start(self) -> None: ...
    def StencilCapableOff(self) -> None: ...
    def StencilCapableOn(self) -> None: ...
    def StereoCapableWindowOff(self) -> None: ...
    def StereoCapableWindowOn(self) -> None: ...
    def StereoMidpoint(self) -> None: ...
    def StereoRenderComplete(self) -> None: ...
    def StereoRenderOff(self) -> None: ...
    def StereoRenderOn(self) -> None: ...
    def StereoUpdate(self) -> None: ...
    def SupportsOpenGL(self) -> int: ...
    def SwapBuffersOff(self) -> None: ...
    def SwapBuffersOn(self) -> None: ...
    def UseSRGBColorSpaceOff(self) -> None: ...
    def UseSRGBColorSpaceOn(self) -> None: ...
    def WaitForCompletion(self) -> None: ...
    def WindowRemap(self) -> None: ...

class vtkRenderWindowCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, a:vtkRenderWindow) -> None: ...
    def GetNextItem(self) -> vtkRenderWindow: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderWindowCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderWindowCollection: ...

class vtkRenderWindowInteractor(vtkmodules.vtkCommonCore.vtkObject):
    OneShotTimer:int
    RepeatingTimer:int
    def CharEvent(self) -> None: ...
    def ClearContact(self, contactID:int) -> None: ...
    def ClearPointerIndex(self, i:int) -> None: ...
    def ConfigureEvent(self) -> None: ...
    def CreateDefaultPicker(self) -> vtkAbstractPropPicker: ...
    def CreateOneShotTimer(self, duration:int) -> int: ...
    def CreateRepeatingTimer(self, duration:int) -> int: ...
    def CreateTimer(self, timerType:int) -> int: ...
    @overload
    def DestroyTimer(self) -> int: ...
    @overload
    def DestroyTimer(self, timerId:int) -> int: ...
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    def EnableRenderOff(self) -> None: ...
    def EnableRenderOn(self) -> None: ...
    def EndPanEvent(self) -> None: ...
    def EndPickCallback(self) -> None: ...
    def EndPinchEvent(self) -> None: ...
    def EndRotateEvent(self) -> None: ...
    def EnterEvent(self) -> None: ...
    def ExitCallback(self) -> None: ...
    def ExitEvent(self) -> None: ...
    def ExposeEvent(self) -> None: ...
    def FifthButtonPressEvent(self) -> None: ...
    def FifthButtonReleaseEvent(self) -> None: ...
    def FindPokedRenderer(self, __a:int, __b:int) -> vtkRenderer: ...
    @overload
    def FlyTo(self, ren:vtkRenderer, x:float, y:float, z:float) -> None: ...
    @overload
    def FlyTo(self, ren:vtkRenderer, x:[float, ...]) -> None: ...
    @overload
    def FlyToImage(self, ren:vtkRenderer, x:float, y:float) -> None: ...
    @overload
    def FlyToImage(self, ren:vtkRenderer, x:[float, ...]) -> None: ...
    def FourthButtonPressEvent(self) -> None: ...
    def FourthButtonReleaseEvent(self) -> None: ...
    def GetAltKey(self) -> int: ...
    def GetControlKey(self) -> int: ...
    def GetDesiredUpdateRate(self) -> float: ...
    def GetDesiredUpdateRateMaxValue(self) -> float: ...
    def GetDesiredUpdateRateMinValue(self) -> float: ...
    def GetDolly(self) -> float: ...
    def GetDone(self) -> bool: ...
    def GetEnableRender(self) -> bool: ...
    def GetEnabled(self) -> int: ...
    def GetEventPosition(self) -> (int, int): ...
    def GetEventPositions(self, pointerIndex:int) -> Pointer: ...
    def GetEventSize(self) -> (int, int): ...
    def GetHardwareWindow(self) -> vtkHardwareWindow: ...
    def GetInitialized(self) -> int: ...
    def GetInteractorStyle(self) -> vtkInteractorObserver: ...
    def GetKeyCode(self) -> str: ...
    def GetKeySym(self) -> str: ...
    def GetLastEventPosition(self) -> (int, int): ...
    def GetLastEventPositions(self, pointerIndex:int) -> Pointer: ...
    def GetLastRotation(self) -> float: ...
    def GetLastScale(self) -> float: ...
    def GetLastTranslation(self) -> (float, float): ...
    def GetLightFollowCamera(self) -> int: ...
    def GetMousePosition(self, x:[int, ...], y:[int, ...]) -> None: ...
    def GetNumberOfFlyFrames(self) -> int: ...
    def GetNumberOfFlyFramesMaxValue(self) -> int: ...
    def GetNumberOfFlyFramesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetObserverMediator(self) -> vtkObserverMediator: ...
    def GetPicker(self) -> vtkAbstractPicker: ...
    def GetPickingManager(self) -> vtkPickingManager: ...
    def GetPointerIndex(self) -> int: ...
    def GetPointerIndexForContact(self, contactID:int) -> int: ...
    def GetPointerIndexForExistingContact(self, contactID:int) -> int: ...
    def GetPointersDownCount(self) -> int: ...
    def GetRecognizeGestures(self) -> bool: ...
    def GetRenderWindow(self) -> vtkRenderWindow: ...
    def GetRepeatCount(self) -> int: ...
    def GetRotation(self) -> float: ...
    def GetScale(self) -> float: ...
    def GetShiftKey(self) -> int: ...
    def GetSize(self) -> (int, int): ...
    def GetStillUpdateRate(self) -> float: ...
    def GetStillUpdateRateMaxValue(self) -> float: ...
    def GetStillUpdateRateMinValue(self) -> float: ...
    @overload
    def GetTimerDuration(self, timerId:int) -> int: ...
    @overload
    def GetTimerDuration(self) -> int: ...
    def GetTimerDurationMaxValue(self) -> int: ...
    def GetTimerDurationMinValue(self) -> int: ...
    def GetTimerEventDuration(self) -> int: ...
    def GetTimerEventId(self) -> int: ...
    def GetTimerEventPlatformId(self) -> int: ...
    def GetTimerEventType(self) -> int: ...
    def GetTranslation(self) -> (float, float): ...
    def GetUseTDx(self) -> bool: ...
    def GetVTKTimerId(self, platformTimerId:int) -> int: ...
    def HideCursor(self) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsOneShotTimer(self, timerId:int) -> int: ...
    def IsPointerIndexSet(self, i:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressEvent(self) -> None: ...
    def KeyReleaseEvent(self) -> None: ...
    def LeaveEvent(self) -> None: ...
    def LeftButtonPressEvent(self) -> None: ...
    def LeftButtonReleaseEvent(self) -> None: ...
    def LightFollowCameraOff(self) -> None: ...
    def LightFollowCameraOn(self) -> None: ...
    def LongTapEvent(self) -> None: ...
    def MiddleButtonPressEvent(self) -> None: ...
    def MiddleButtonReleaseEvent(self) -> None: ...
    def MouseMoveEvent(self) -> None: ...
    def MouseWheelBackwardEvent(self) -> None: ...
    def MouseWheelForwardEvent(self) -> None: ...
    def MouseWheelLeftEvent(self) -> None: ...
    def MouseWheelRightEvent(self) -> None: ...
    def NewInstance(self) -> vtkRenderWindowInteractor: ...
    def PanEvent(self) -> None: ...
    def PinchEvent(self) -> None: ...
    def ProcessEvents(self) -> None: ...
    def ReInitialize(self) -> None: ...
    def Render(self) -> None: ...
    def ResetTimer(self, timerId:int) -> int: ...
    def RightButtonPressEvent(self) -> None: ...
    def RightButtonReleaseEvent(self) -> None: ...
    def RotateEvent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderWindowInteractor: ...
    def SetAltKey(self, _arg:int) -> None: ...
    def SetControlKey(self, _arg:int) -> None: ...
    def SetDesiredUpdateRate(self, _arg:float) -> None: ...
    def SetDolly(self, _arg:float) -> None: ...
    def SetDone(self, _arg:bool) -> None: ...
    def SetEnableRender(self, _arg:bool) -> None: ...
    @overload
    def SetEventInformation(self, x:int, y:int, ctrl:int, shift:int, keycode:str, repeatcount:int, keysym:str, pointerIndex:int) -> None: ...
    @overload
    def SetEventInformation(self, x:int, y:int, ctrl:int=0, shift:int=0, keycode:str=..., repeatcount:int=0, keysym:str=...) -> None: ...
    @overload
    def SetEventInformationFlipY(self, x:int, y:int, ctrl:int, shift:int, keycode:str, repeatcount:int, keysym:str, pointerIndex:int) -> None: ...
    @overload
    def SetEventInformationFlipY(self, x:int, y:int, ctrl:int=0, shift:int=0, keycode:str=..., repeatcount:int=0, keysym:str=...) -> None: ...
    @overload
    def SetEventPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetEventPosition(self, pos:[int, int]) -> None: ...
    @overload
    def SetEventPosition(self, x:int, y:int, pointerIndex:int) -> None: ...
    @overload
    def SetEventPosition(self, pos:[int, int], pointerIndex:int) -> None: ...
    @overload
    def SetEventPositionFlipY(self, x:int, y:int) -> None: ...
    @overload
    def SetEventPositionFlipY(self, pos:[int, int]) -> None: ...
    @overload
    def SetEventPositionFlipY(self, x:int, y:int, pointerIndex:int) -> None: ...
    @overload
    def SetEventPositionFlipY(self, pos:[int, int], pointerIndex:int) -> None: ...
    @overload
    def SetEventSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetEventSize(self, _arg:(int, int)) -> None: ...
    def SetHardwareWindow(self, aren:vtkHardwareWindow) -> None: ...
    def SetInteractorStyle(self, __a:vtkInteractorObserver) -> None: ...
    def SetKeyCode(self, _arg:str) -> None: ...
    def SetKeyEventInformation(self, ctrl:int=0, shift:int=0, keycode:str=..., repeatcount:int=0, keysym:str=...) -> None: ...
    def SetKeySym(self, _arg:str) -> None: ...
    @overload
    def SetLastEventPosition(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetLastEventPosition(self, _arg:(int, int)) -> None: ...
    def SetLightFollowCamera(self, _arg:int) -> None: ...
    def SetNumberOfFlyFrames(self, _arg:int) -> None: ...
    def SetPicker(self, __a:vtkAbstractPicker) -> None: ...
    def SetPickingManager(self, __a:vtkPickingManager) -> None: ...
    def SetPointerIndex(self, _arg:int) -> None: ...
    def SetRecognizeGestures(self, _arg:bool) -> None: ...
    def SetRenderWindow(self, aren:vtkRenderWindow) -> None: ...
    def SetRepeatCount(self, _arg:int) -> None: ...
    def SetRotation(self, rotation:float) -> None: ...
    def SetScale(self, scale:float) -> None: ...
    def SetShiftKey(self, _arg:int) -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:(int, int)) -> None: ...
    def SetStillUpdateRate(self, _arg:float) -> None: ...
    def SetTimerDuration(self, _arg:int) -> None: ...
    def SetTimerEventDuration(self, _arg:int) -> None: ...
    def SetTimerEventId(self, _arg:int) -> None: ...
    def SetTimerEventPlatformId(self, _arg:int) -> None: ...
    def SetTimerEventType(self, _arg:int) -> None: ...
    def SetTranslation(self, val:[float, float]) -> None: ...
    def SetUseTDx(self, _arg:bool) -> None: ...
    def ShowCursor(self) -> None: ...
    def Start(self) -> None: ...
    def StartPanEvent(self) -> None: ...
    def StartPickCallback(self) -> None: ...
    def StartPinchEvent(self) -> None: ...
    def StartRotateEvent(self) -> None: ...
    def SwipeEvent(self) -> None: ...
    def TapEvent(self) -> None: ...
    def TerminateApp(self) -> None: ...
    def UpdateSize(self, x:int, y:int) -> None: ...
    def UserCallback(self) -> None: ...

class vtkRenderWindowInteractor3D(vtkRenderWindowInteractor):
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    def GetLastPhysicalEventPose(self, poseMatrix:vtkMatrix4x4, pointerIndex:int) -> None: ...
    def GetLastTranslation3D(self) -> (float, float, float): ...
    def GetLastWorldEventOrientation(self, pointerIndex:int) -> Pointer: ...
    def GetLastWorldEventPose(self, poseMatrix:vtkMatrix4x4, pointerIndex:int) -> None: ...
    def GetLastWorldEventPosition(self, pointerIndex:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhysicalEventPose(self, poseMatrix:vtkMatrix4x4, pointerIndex:int) -> None: ...
    def GetPhysicalScale(self) -> float: ...
    def GetPhysicalTranslation(self, __a:vtkCamera) -> Pointer: ...
    def GetPhysicalViewDirection(self) -> Pointer: ...
    def GetPhysicalViewUp(self) -> Pointer: ...
    def GetStartingPhysicalEventPose(self, poseMatrix:vtkMatrix4x4, pointerIndex:int) -> None: ...
    def GetTouchPadPosition(self, __a:vtkEventDataDevice, __b:vtkEventDataDeviceInput, __c:[float, float, float]) -> None: ...
    def GetTranslation3D(self) -> (float, float, float): ...
    def GetWorldEventOrientation(self, pointerIndex:int) -> Pointer: ...
    def GetWorldEventPose(self, poseMatrix:vtkMatrix4x4, pointerIndex:int) -> None: ...
    def GetWorldEventPosition(self, pointerIndex:int) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MiddleButtonPressEvent(self) -> None: ...
    def MiddleButtonReleaseEvent(self) -> None: ...
    def NewInstance(self) -> vtkRenderWindowInteractor3D: ...
    def RightButtonPressEvent(self) -> None: ...
    def RightButtonReleaseEvent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderWindowInteractor3D: ...
    def SetPhysicalEventPose(self, poseMatrix:vtkMatrix4x4, pointerIndex:int) -> None: ...
    def SetPhysicalEventPosition(self, x:float, y:float, z:float, pointerIndex:int) -> None: ...
    def SetPhysicalScale(self, __a:float) -> None: ...
    def SetPhysicalTranslation(self, __a:vtkCamera, __b:float, __c:float, __d:float) -> None: ...
    def SetPhysicalViewDirection(self, __a:float, __b:float, __c:float) -> None: ...
    def SetPhysicalViewUp(self, __a:float, __b:float, __c:float) -> None: ...
    def SetTranslation3D(self, val:[float, float, float]) -> None: ...
    def SetWorldEventOrientation(self, w:float, x:float, y:float, z:float, pointerIndex:int) -> None: ...
    def SetWorldEventPose(self, poseMatrix:vtkMatrix4x4, pointerIndex:int) -> None: ...
    def SetWorldEventPosition(self, x:float, y:float, z:float, pointerIndex:int) -> None: ...

class vtkRenderedAreaPicker(vtkAreaPicker):
    def AreaPick(self, x0:float, y0:float, x1:float, y1:float, __e:vtkRenderer) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderedAreaPicker: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderedAreaPicker: ...

class vtkViewport(vtkmodules.vtkCommonCore.vtkObject):
    def AddActor2D(self, p:vtkProp) -> None: ...
    def AddViewProp(self, __a:vtkProp) -> None: ...
    def ComputeAspect(self) -> None: ...
    def DisplayToLocalDisplay(self, x:float, y:float) -> None: ...
    def DisplayToNormalizedDisplay(self, u:float, v:float) -> None: ...
    def DisplayToView(self) -> None: ...
    def DisplayToWorld(self) -> None: ...
    def GetActors2D(self) -> vtkActor2DCollection: ...
    def GetAspect(self) -> (float, float): ...
    def GetBackground(self) -> (float, float, float): ...
    def GetBackground2(self) -> (float, float, float): ...
    def GetBackgroundAlpha(self) -> float: ...
    def GetBackgroundAlphaMaxValue(self) -> float: ...
    def GetBackgroundAlphaMinValue(self) -> float: ...
    def GetCenter(self) -> (float, float): ...
    def GetDisplayPoint(self) -> (float, float, float): ...
    def GetEnvironmentalBG(self) -> (float, float, float): ...
    def GetEnvironmentalBG2(self) -> (float, float, float): ...
    def GetGradientBackground(self) -> bool: ...
    def GetGradientEnvironmentalBG(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> (int, int): ...
    def GetPickHeight(self) -> float: ...
    def GetPickResultProps(self) -> vtkPropCollection: ...
    def GetPickWidth(self) -> float: ...
    def GetPickX(self) -> float: ...
    def GetPickX1(self) -> float: ...
    def GetPickX2(self) -> float: ...
    def GetPickY(self) -> float: ...
    def GetPickY1(self) -> float: ...
    def GetPickY2(self) -> float: ...
    def GetPickedZ(self) -> float: ...
    def GetPixelAspect(self) -> (float, float): ...
    def GetSize(self) -> (int, int): ...
    def GetTiledSize(self, width:[int, ...], height:[int, ...]) -> None: ...
    def GetTiledSizeAndOrigin(self, width:[int, ...], height:[int, ...], lowerLeftX:[int, ...], lowerLeftY:[int, ...]) -> None: ...
    def GetVTKWindow(self) -> vtkWindow: ...
    def GetViewPoint(self) -> (float, float, float): ...
    def GetViewProps(self) -> vtkPropCollection: ...
    def GetViewport(self) -> (float, float, float, float): ...
    def GetWorldPoint(self) -> (float, float, float, float): ...
    def GradientBackgroundOff(self) -> None: ...
    def GradientBackgroundOn(self) -> None: ...
    def GradientEnvironmentalBGOff(self) -> None: ...
    def GradientEnvironmentalBGOn(self) -> None: ...
    def HasViewProp(self, __a:vtkProp) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInViewport(self, x:int, y:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LocalDisplayToDisplay(self, x:float, y:float) -> None: ...
    def NewInstance(self) -> vtkViewport: ...
    def NormalizedDisplayToDisplay(self, u:float, v:float) -> None: ...
    def NormalizedDisplayToViewport(self, x:float, y:float) -> None: ...
    def NormalizedViewportToView(self, x:float, y:float, z:float) -> None: ...
    def NormalizedViewportToViewport(self, u:float, v:float) -> None: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float) -> vtkAssemblyPath: ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float) -> vtkAssemblyPath: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, fieldAssociation:int, selection:vtkSelection) -> vtkAssemblyPath: ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, fieldAssociation:int, selection:vtkSelection) -> vtkAssemblyPath: ...
    @overload
    def PickPropFrom(self, selectionX:float, selectionY:float, __c:vtkPropCollection) -> vtkAssemblyPath: ...
    @overload
    def PickPropFrom(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, __e:vtkPropCollection) -> vtkAssemblyPath: ...
    @overload
    def PickPropFrom(self, selectionX:float, selectionY:float, __c:vtkPropCollection, fieldAssociation:int, selection:vtkSelection) -> vtkAssemblyPath: ...
    @overload
    def PickPropFrom(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, __e:vtkPropCollection, fieldAssociation:int, selection:vtkSelection) -> vtkAssemblyPath: ...
    def PoseToView(self, __a:float, __b:float, __c:float) -> None: ...
    def PoseToWorld(self, __a:float, __b:float, __c:float) -> None: ...
    def RemoveActor2D(self, p:vtkProp) -> None: ...
    def RemoveAllViewProps(self) -> None: ...
    def RemoveViewProp(self, __a:vtkProp) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkViewport: ...
    @overload
    def SetAspect(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetAspect(self, _arg:(float, float)) -> None: ...
    @overload
    def SetBackground(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackground(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetBackground2(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackground2(self, _arg:(float, float, float)) -> None: ...
    def SetBackgroundAlpha(self, _arg:float) -> None: ...
    @overload
    def SetDisplayPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDisplayPoint(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetEnvironmentalBG(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentalBG(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetEnvironmentalBG2(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentalBG2(self, _arg:(float, float, float)) -> None: ...
    def SetGradientBackground(self, _arg:bool) -> None: ...
    def SetGradientEnvironmentalBG(self, _arg:bool) -> None: ...
    @overload
    def SetPixelAspect(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPixelAspect(self, _arg:(float, float)) -> None: ...
    @overload
    def SetViewPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetViewPoint(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetViewport(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetViewport(self, _arg:(float, float, float, float)) -> None: ...
    @overload
    def SetWorldPoint(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetWorldPoint(self, _arg:(float, float, float, float)) -> None: ...
    @overload
    def ViewToDisplay(self) -> None: ...
    @overload
    def ViewToDisplay(self, x:float, y:float, z:float) -> None: ...
    def ViewToNormalizedViewport(self, x:float, y:float, z:float) -> None: ...
    def ViewToPose(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def ViewToWorld(self) -> None: ...
    @overload
    def ViewToWorld(self, __a:float, __b:float, __c:float) -> None: ...
    def ViewportToNormalizedDisplay(self, x:float, y:float) -> None: ...
    def ViewportToNormalizedViewport(self, u:float, v:float) -> None: ...
    @overload
    def WorldToDisplay(self) -> None: ...
    @overload
    def WorldToDisplay(self, x:float, y:float, z:float) -> None: ...
    def WorldToPose(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def WorldToView(self) -> None: ...
    @overload
    def WorldToView(self, __a:float, __b:float, __c:float) -> None: ...

class vtkRenderer(vtkViewport):
    def AddActor(self, p:vtkProp) -> None: ...
    def AddCuller(self, __a:vtkCuller) -> None: ...
    def AddLight(self, __a:vtkLight) -> None: ...
    def AddVolume(self, p:vtkProp) -> None: ...
    def AutomaticLightCreationOff(self) -> None: ...
    def AutomaticLightCreationOn(self) -> None: ...
    def BackingStoreOff(self) -> None: ...
    def BackingStoreOn(self) -> None: ...
    def CaptureGL2PSSpecialProp(self, __a:vtkProp) -> int: ...
    def Clear(self) -> None: ...
    def ClearLights(self) -> None: ...
    @overload
    def ComputeVisiblePropBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def ComputeVisiblePropBounds(self) -> (float, float, float, float, float, float): ...
    def CreateLight(self) -> None: ...
    def DeviceRender(self) -> None: ...
    def DeviceRenderOpaqueGeometry(self, fbo:vtkFrameBufferObjectBase=...) -> None: ...
    def DeviceRenderTranslucentPolygonalGeometry(self, fbo:vtkFrameBufferObjectBase=...) -> None: ...
    @overload
    def DisplayToWorld(self, display:vtkVector3d) -> vtkVector3d: ...
    @overload
    def DisplayToWorld(self) -> None: ...
    def DrawOff(self) -> None: ...
    def DrawOn(self) -> None: ...
    def EraseOff(self) -> None: ...
    def EraseOn(self) -> None: ...
    def GetActiveCamera(self) -> vtkCamera: ...
    def GetActors(self) -> vtkActorCollection: ...
    def GetAllocatedRenderTime(self) -> float: ...
    def GetAmbient(self) -> (float, float, float): ...
    def GetAutomaticLightCreation(self) -> int: ...
    def GetBackgroundTexture(self) -> vtkTexture: ...
    def GetBackingStore(self) -> int: ...
    def GetClippingRangeExpansion(self) -> float: ...
    def GetClippingRangeExpansionMaxValue(self) -> float: ...
    def GetClippingRangeExpansionMinValue(self) -> float: ...
    def GetCullers(self) -> vtkCullerCollection: ...
    def GetDelegate(self) -> vtkRendererDelegate: ...
    def GetDraw(self) -> int: ...
    def GetEnvironmentRight(self) -> (float, float, float): ...
    def GetEnvironmentTexture(self) -> vtkTexture: ...
    def GetEnvironmentUp(self) -> (float, float, float): ...
    def GetErase(self) -> int: ...
    def GetFXAAOptions(self) -> vtkFXAAOptions: ...
    def GetInformation(self) -> vtkInformation: ...
    def GetInteractive(self) -> int: ...
    def GetLastRenderTimeInSeconds(self) -> float: ...
    def GetLastRenderingUsedDepthPeeling(self) -> int: ...
    def GetLayer(self) -> int: ...
    def GetLeftBackgroundTexture(self) -> vtkTexture: ...
    def GetLightFollowCamera(self) -> int: ...
    def GetLights(self) -> vtkLightCollection: ...
    def GetMTime(self) -> int: ...
    def GetMaximumNumberOfPeels(self) -> int: ...
    def GetNearClippingPlaneTolerance(self) -> float: ...
    def GetNearClippingPlaneToleranceMaxValue(self) -> float: ...
    def GetNearClippingPlaneToleranceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPropsRendered(self) -> int: ...
    def GetOcclusionRatio(self) -> float: ...
    def GetOcclusionRatioMaxValue(self) -> float: ...
    def GetOcclusionRatioMinValue(self) -> float: ...
    def GetPass(self) -> vtkRenderPass: ...
    def GetPreserveColorBuffer(self) -> int: ...
    def GetPreserveDepthBuffer(self) -> int: ...
    def GetRenderWindow(self) -> vtkRenderWindow: ...
    def GetRightBackgroundTexture(self) -> vtkTexture: ...
    def GetSSAOBias(self) -> float: ...
    def GetSSAOBlur(self) -> bool: ...
    def GetSSAOKernelSize(self) -> int: ...
    def GetSSAORadius(self) -> float: ...
    def GetSelector(self) -> vtkHardwareSelector: ...
    def GetTexturedBackground(self) -> bool: ...
    def GetTiledAspectRatio(self) -> float: ...
    def GetTimeFactor(self) -> float: ...
    def GetTwoSidedLighting(self) -> int: ...
    def GetUseDepthPeeling(self) -> int: ...
    def GetUseDepthPeelingForVolumes(self) -> bool: ...
    def GetUseFXAA(self) -> bool: ...
    def GetUseHiddenLineRemoval(self) -> int: ...
    def GetUseImageBasedLighting(self) -> bool: ...
    def GetUseSSAO(self) -> bool: ...
    def GetUseShadows(self) -> int: ...
    def GetVTKWindow(self) -> vtkWindow: ...
    def GetVolumes(self) -> vtkVolumeCollection: ...
    def GetZ(self, x:int, y:int) -> float: ...
    def InteractiveOff(self) -> None: ...
    def InteractiveOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsActiveCameraCreated(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LightFollowCameraOff(self) -> None: ...
    def LightFollowCameraOn(self) -> None: ...
    def MakeCamera(self) -> vtkCamera: ...
    def MakeLight(self) -> vtkLight: ...
    def NewInstance(self) -> vtkRenderer: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float) -> vtkAssemblyPath: ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float) -> vtkAssemblyPath: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, fieldAssociation:int, selection:vtkSelection) -> vtkAssemblyPath: ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, fieldAssociation:int, selection:vtkSelection) -> vtkAssemblyPath: ...
    def PoseToView(self, wx:float, wy:float, wz:float) -> None: ...
    def PoseToWorld(self, wx:float, wy:float, wz:float) -> None: ...
    def PreserveColorBufferOff(self) -> None: ...
    def PreserveColorBufferOn(self) -> None: ...
    def PreserveDepthBufferOff(self) -> None: ...
    def PreserveDepthBufferOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RemoveActor(self, p:vtkProp) -> None: ...
    def RemoveAllLights(self) -> None: ...
    def RemoveCuller(self, __a:vtkCuller) -> None: ...
    def RemoveLight(self, __a:vtkLight) -> None: ...
    def RemoveVolume(self, p:vtkProp) -> None: ...
    def Render(self) -> None: ...
    @overload
    def ResetCamera(self) -> None: ...
    @overload
    def ResetCamera(self, bounds:(float, float, float, float, float, float)) -> None: ...
    @overload
    def ResetCamera(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def ResetCameraClippingRange(self) -> None: ...
    @overload
    def ResetCameraClippingRange(self, bounds:(float, float, float, float, float, float)) -> None: ...
    @overload
    def ResetCameraClippingRange(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def ResetCameraScreenSpace(self) -> None: ...
    @overload
    def ResetCameraScreenSpace(self, bounds:(float, float, float, float, float, float)) -> None: ...
    @overload
    def ResetCameraScreenSpace(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def SSAOBlurOff(self) -> None: ...
    def SSAOBlurOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderer: ...
    def SetActiveCamera(self, __a:vtkCamera) -> None: ...
    def SetAllocatedRenderTime(self, _arg:float) -> None: ...
    @overload
    def SetAmbient(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAmbient(self, _arg:(float, float, float)) -> None: ...
    def SetAutomaticLightCreation(self, _arg:int) -> None: ...
    def SetBackgroundTexture(self, __a:vtkTexture) -> None: ...
    def SetBackingStore(self, _arg:int) -> None: ...
    def SetClippingRangeExpansion(self, _arg:float) -> None: ...
    def SetDelegate(self, d:vtkRendererDelegate) -> None: ...
    def SetDraw(self, _arg:int) -> None: ...
    @overload
    def SetEnvironmentRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentRight(self, _arg:(float, float, float)) -> None: ...
    def SetEnvironmentTexture(self, texture:vtkTexture, isSRGB:bool=False) -> None: ...
    @overload
    def SetEnvironmentUp(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentUp(self, _arg:(float, float, float)) -> None: ...
    def SetErase(self, _arg:int) -> None: ...
    def SetFXAAOptions(self, __a:vtkFXAAOptions) -> None: ...
    def SetGL2PSSpecialPropCollection(self, __a:vtkPropCollection) -> None: ...
    def SetInformation(self, __a:vtkInformation) -> None: ...
    def SetInteractive(self, _arg:int) -> None: ...
    def SetLayer(self, layer:int) -> None: ...
    def SetLeftBackgroundTexture(self, __a:vtkTexture) -> None: ...
    def SetLightCollection(self, lights:vtkLightCollection) -> None: ...
    def SetLightFollowCamera(self, _arg:int) -> None: ...
    def SetMaximumNumberOfPeels(self, _arg:int) -> None: ...
    def SetNearClippingPlaneTolerance(self, _arg:float) -> None: ...
    def SetOcclusionRatio(self, _arg:float) -> None: ...
    def SetPass(self, p:vtkRenderPass) -> None: ...
    def SetPreserveColorBuffer(self, _arg:int) -> None: ...
    def SetPreserveDepthBuffer(self, _arg:int) -> None: ...
    def SetRenderWindow(self, __a:vtkRenderWindow) -> None: ...
    def SetRightBackgroundTexture(self, __a:vtkTexture) -> None: ...
    def SetSSAOBias(self, _arg:float) -> None: ...
    def SetSSAOBlur(self, _arg:bool) -> None: ...
    def SetSSAOKernelSize(self, _arg:int) -> None: ...
    def SetSSAORadius(self, _arg:float) -> None: ...
    def SetTexturedBackground(self, _arg:bool) -> None: ...
    def SetTwoSidedLighting(self, _arg:int) -> None: ...
    def SetUseDepthPeeling(self, _arg:int) -> None: ...
    def SetUseDepthPeelingForVolumes(self, _arg:bool) -> None: ...
    def SetUseFXAA(self, _arg:bool) -> None: ...
    def SetUseHiddenLineRemoval(self, _arg:int) -> None: ...
    def SetUseImageBasedLighting(self, _arg:bool) -> None: ...
    def SetUseSSAO(self, _arg:bool) -> None: ...
    def SetUseShadows(self, _arg:int) -> None: ...
    def StereoMidpoint(self) -> None: ...
    def TexturedBackgroundOff(self) -> None: ...
    def TexturedBackgroundOn(self) -> None: ...
    def Transparent(self) -> int: ...
    def TwoSidedLightingOff(self) -> None: ...
    def TwoSidedLightingOn(self) -> None: ...
    def UpdateLightsGeometryToFollowCamera(self) -> int: ...
    def UseDepthPeelingForVolumesOff(self) -> None: ...
    def UseDepthPeelingForVolumesOn(self) -> None: ...
    def UseDepthPeelingOff(self) -> None: ...
    def UseDepthPeelingOn(self) -> None: ...
    def UseFXAAOff(self) -> None: ...
    def UseFXAAOn(self) -> None: ...
    def UseHiddenLineRemovalOff(self) -> None: ...
    def UseHiddenLineRemovalOn(self) -> None: ...
    def UseImageBasedLightingOff(self) -> None: ...
    def UseImageBasedLightingOn(self) -> None: ...
    def UseSSAOOff(self) -> None: ...
    def UseSSAOOn(self) -> None: ...
    def UseShadowsOff(self) -> None: ...
    def UseShadowsOn(self) -> None: ...
    def ViewToPose(self, wx:float, wy:float, wz:float) -> None: ...
    @overload
    def ViewToWorld(self) -> None: ...
    @overload
    def ViewToWorld(self, wx:float, wy:float, wz:float) -> None: ...
    def VisibleActorCount(self) -> int: ...
    def VisibleVolumeCount(self) -> int: ...
    def WorldToPose(self, wx:float, wy:float, wz:float) -> None: ...
    @overload
    def WorldToView(self) -> None: ...
    @overload
    def WorldToView(self, wx:float, wy:float, wz:float) -> None: ...
    def ZoomToBoxUsingViewAngle(self, box:vtkRecti, offsetRatio:float=1.0) -> None: ...

class vtkRendererCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, a:vtkRenderer) -> None: ...
    def GetFirstRenderer(self) -> vtkRenderer: ...
    def GetNextItem(self) -> vtkRenderer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRendererCollection: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRendererCollection: ...

class vtkRendererDelegate(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUsed(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRendererDelegate: ...
    def Render(self, r:vtkRenderer) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRendererDelegate: ...
    def SetUsed(self, _arg:bool) -> None: ...
    def UsedOff(self) -> None: ...
    def UsedOn(self) -> None: ...

class vtkRendererSource(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def DepthValuesInScalarsOff(self) -> None: ...
    def DepthValuesInScalarsOn(self) -> None: ...
    def DepthValuesOff(self) -> None: ...
    def DepthValuesOn(self) -> None: ...
    def DepthValuesOnlyOff(self) -> None: ...
    def DepthValuesOnlyOn(self) -> None: ...
    def GetDepthValues(self) -> int: ...
    def GetDepthValuesInScalars(self) -> int: ...
    def GetDepthValuesOnly(self) -> int: ...
    def GetInput(self) -> vtkRenderer: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> vtkImageData: ...
    def GetRenderFlag(self) -> int: ...
    def GetWholeWindow(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRendererSource: ...
    def RenderFlagOff(self) -> None: ...
    def RenderFlagOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRendererSource: ...
    def SetDepthValues(self, _arg:int) -> None: ...
    def SetDepthValuesInScalars(self, _arg:int) -> None: ...
    def SetDepthValuesOnly(self, _arg:int) -> None: ...
    def SetInput(self, __a:vtkRenderer) -> None: ...
    def SetRenderFlag(self, _arg:int) -> None: ...
    def SetWholeWindow(self, _arg:int) -> None: ...
    def WholeWindowOff(self) -> None: ...
    def WholeWindowOn(self) -> None: ...

class vtkResizingWindowToImageFilter(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def GetInput(self) -> vtkWindow: ...
    def GetInputBufferType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> vtkImageData: ...
    def GetSize(self) -> (int, int): ...
    def GetSizeLimit(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkResizingWindowToImageFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkResizingWindowToImageFilter: ...
    def SetInput(self, input:vtkWindow) -> None: ...
    def SetInputBufferType(self, _arg:int) -> None: ...
    def SetInputBufferTypeToRGB(self) -> None: ...
    def SetInputBufferTypeToRGBA(self) -> None: ...
    def SetInputBufferTypeToZBuffer(self) -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:(int, int)) -> None: ...
    def SetSizeLimit(self, _arg:int) -> None: ...

class vtkScenePicker(vtkmodules.vtkCommonCore.vtkObject):
    def EnableVertexPickingOff(self) -> None: ...
    def EnableVertexPickingOn(self) -> None: ...
    def GetCellId(self, displayPos:[int, int]) -> int: ...
    def GetEnableVertexPicking(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetVertexId(self, displayPos:[int, int]) -> int: ...
    def GetViewProp(self, displayPos:[int, int]) -> vtkProp: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkScenePicker: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkScenePicker: ...
    def SetEnableVertexPicking(self, _arg:int) -> None: ...
    def SetRenderer(self, __a:vtkRenderer) -> None: ...

class vtkSelectVisiblePoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetSelectInvisible(self) -> int: ...
    def GetSelection(self) -> (int, int, int, int): ...
    def GetSelectionWindow(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetToleranceWorld(self) -> float: ...
    def GetToleranceWorldMaxValue(self) -> float: ...
    def GetToleranceWorldMinValue(self) -> float: ...
    def Initialize(self, getZbuff:bool) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsPointOccluded(self, x:(float, float, float), zPtr:(float, ...)) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSelectVisiblePoints: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSelectVisiblePoints: ...
    def SelectInvisibleOff(self) -> None: ...
    def SelectInvisibleOn(self) -> None: ...
    def SelectionWindowOff(self) -> None: ...
    def SelectionWindowOn(self) -> None: ...
    def SetRenderer(self, ren:vtkRenderer) -> None: ...
    def SetSelectInvisible(self, _arg:int) -> None: ...
    @overload
    def SetSelection(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int) -> None: ...
    @overload
    def SetSelection(self, _arg:(int, int, int, int)) -> None: ...
    def SetSelectionWindow(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceWorld(self, _arg:float) -> None: ...

class vtkShaderProperty(vtkmodules.vtkCommonCore.vtkObject):
    def AddFragmentShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddGeometryShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddVertexShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def ClearAllFragmentShaderReplacements(self) -> None: ...
    def ClearAllGeometryShaderReplacements(self) -> None: ...
    def ClearAllShaderReplacements(self) -> None: ...
    def ClearAllVertexShaderReplacements(self) -> None: ...
    def ClearFragmentShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearGeometryShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearVertexShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def DeepCopy(self, p:vtkShaderProperty) -> None: ...
    def GetFragmentCustomUniforms(self) -> vtkUniforms: ...
    def GetFragmentShaderCode(self) -> str: ...
    def GetGeometryCustomUniforms(self) -> vtkUniforms: ...
    def GetGeometryShaderCode(self) -> str: ...
    def GetNthShaderReplacement(self, index:int, name:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def GetNthShaderReplacementTypeAsString(self, index:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfShaderReplacements(self) -> int: ...
    def GetShaderMTime(self) -> int: ...
    def GetVertexCustomUniforms(self) -> vtkUniforms: ...
    def GetVertexShaderCode(self) -> str: ...
    def HasFragmentShaderCode(self) -> bool: ...
    def HasGeometryShaderCode(self) -> bool: ...
    def HasVertexShaderCode(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkShaderProperty: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkShaderProperty: ...
    def SetFragmentShaderCode(self, _arg:str) -> None: ...
    def SetGeometryShaderCode(self, _arg:str) -> None: ...
    def SetVertexShaderCode(self, _arg:str) -> None: ...

class vtkSkybox(vtkActor):
    class Projection(int): ...
    Cube:'Projection'
    Floor:'Projection'
    Sphere:'Projection'
    StereoSphere:'Projection'
    def GammaCorrectOff(self) -> None: ...
    def GammaCorrectOn(self) -> None: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetFloorPlane(self) -> (float, float, float, float): ...
    def GetFloorRight(self) -> (float, float, float): ...
    def GetGammaCorrect(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProjection(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSkybox: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSkybox: ...
    @overload
    def SetFloorPlane(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetFloorPlane(self, _arg:(float, float, float, float)) -> None: ...
    @overload
    def SetFloorRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetFloorRight(self, _arg:(float, float, float)) -> None: ...
    def SetGammaCorrect(self, _arg:bool) -> None: ...
    def SetProjection(self, _arg:int) -> None: ...
    def SetProjectionToCube(self) -> None: ...
    def SetProjectionToFloor(self) -> None: ...
    def SetProjectionToSphere(self) -> None: ...
    def SetProjectionToStereoSphere(self) -> None: ...

class vtkStateStorage(object):
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...

class vtkStereoCompositor(vtkmodules.vtkCommonCore.vtkObject):
    def Anaglyph(self, rgbLeftNResult:vtkUnsignedCharArray, rgbRight:vtkUnsignedCharArray, colorSaturation:float, colorMask:(int, int)) -> bool: ...
    def Checkerboard(self, rgbLeftNResult:vtkUnsignedCharArray, rgbRight:vtkUnsignedCharArray, size:(int, int)) -> bool: ...
    def Dresden(self, rgbLeftNResult:vtkUnsignedCharArray, rgbRight:vtkUnsignedCharArray, size:(int, int)) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Interlaced(self, rgbLeftNResult:vtkUnsignedCharArray, rgbRight:vtkUnsignedCharArray, size:(int, int)) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStereoCompositor: ...
    def RedBlue(self, rgbLeftNResult:vtkUnsignedCharArray, rgbRight:vtkUnsignedCharArray) -> bool: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStereoCompositor: ...
    def SplitViewportHorizontal(self, rgbLeftNResult:vtkUnsignedCharArray, rgbRight:vtkUnsignedCharArray, size:(int, int)) -> bool: ...

class vtkStringToImage(vtkmodules.vtkCommonCore.vtkObject):
    def GetBounds(self, property:vtkTextProperty, string:str, dpi:int) -> vtkVector2i: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleToPowerOfTwo(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStringToImage: ...
    def RenderString(self, property:vtkTextProperty, string:str, dpi:int, data:vtkImageData, text_dims:[int, int]=...) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStringToImage: ...
    def SetScaleToPowerOfTwo(self, scale:bool) -> None: ...

class vtkTDxInteractorStyle(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSettings(self) -> vtkTDxInteractorStyleSettings: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTDxInteractorStyle: ...
    def OnButtonPressedEvent(self, button:int) -> None: ...
    def OnButtonReleasedEvent(self, button:int) -> None: ...
    def ProcessEvent(self, renderer:vtkRenderer, event:int, calldata:Pointer) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTDxInteractorStyle: ...
    def SetSettings(self, settings:vtkTDxInteractorStyleSettings) -> None: ...

class vtkTDxInteractorStyleCamera(vtkTDxInteractorStyle):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTDxInteractorStyleCamera: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTDxInteractorStyleCamera: ...

class vtkTDxInteractorStyleSettings(vtkmodules.vtkCommonCore.vtkObject):
    def GetAngleSensitivity(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTranslationXSensitivity(self) -> float: ...
    def GetTranslationYSensitivity(self) -> float: ...
    def GetTranslationZSensitivity(self) -> float: ...
    def GetUseRotationX(self) -> bool: ...
    def GetUseRotationY(self) -> bool: ...
    def GetUseRotationZ(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTDxInteractorStyleSettings: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTDxInteractorStyleSettings: ...
    def SetAngleSensitivity(self, _arg:float) -> None: ...
    def SetTranslationXSensitivity(self, _arg:float) -> None: ...
    def SetTranslationYSensitivity(self, _arg:float) -> None: ...
    def SetTranslationZSensitivity(self, _arg:float) -> None: ...
    def SetUseRotationX(self, _arg:bool) -> None: ...
    def SetUseRotationY(self, _arg:bool) -> None: ...
    def SetUseRotationZ(self, _arg:bool) -> None: ...

class vtkTDxMotionEventInfo(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:vtkTDxMotionEventInfo) -> None: ...

class vtkTexturedActor2D(vtkActor2D):
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTexture(self) -> vtkTexture: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTexturedActor2D: ...
    def ReleaseGraphicsResources(self, win:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderOverlay(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTexturedActor2D: ...
    def SetTexture(self, texture:vtkTexture) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkTextActor(vtkTexturedActor2D):
    TEXT_SCALE_MODE_NONE:int
    TEXT_SCALE_MODE_PROP:int
    TEXT_SCALE_MODE_VIEWPORT:int
    def ComputeScaledFont(self, viewport:vtkViewport) -> None: ...
    def DisplayToSpecified(self, pos:[float, ...], vport:vtkViewport, specified:int) -> None: ...
    def GetAlignmentPoint(self) -> int: ...
    def GetBoundingBox(self, vport:vtkViewport, bbox:[float, float, float, float]) -> None: ...
    @staticmethod
    def GetFontScale(viewport:vtkViewport) -> float: ...
    def GetInput(self) -> str: ...
    def GetMaximumLineHeight(self) -> float: ...
    def GetMinimumSize(self) -> (int, int): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> float: ...
    def GetScaledTextProperty(self) -> vtkTextProperty: ...
    def GetSize(self, vport:vtkViewport, size:[float, float]) -> None: ...
    def GetTextProperty(self) -> vtkTextProperty: ...
    def GetTextScaleMode(self) -> int: ...
    def GetTextScaleModeMaxValue(self) -> int: ...
    def GetTextScaleModeMinValue(self) -> int: ...
    def GetUseBorderAlign(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTextActor: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderOverlay(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTextActor: ...
    def SetAlignmentPoint(self, point:int) -> None: ...
    @overload
    def SetConstrainedFontSize(self, __a:vtkViewport, targetWidth:int, targetHeight:int) -> int: ...
    @overload
    @staticmethod
    def SetConstrainedFontSize(__a:vtkTextActor, __b:vtkViewport, targetWidth:int, targetHeight:int) -> int: ...
    def SetInput(self, inputString:str) -> None: ...
    def SetMaximumLineHeight(self, _arg:float) -> None: ...
    @overload
    def SetMinimumSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetMinimumSize(self, _arg:(int, int)) -> None: ...
    def SetNonLinearFontScale(self, exponent:float, target:int) -> None: ...
    def SetOrientation(self, orientation:float) -> None: ...
    def SetTextProperty(self, p:vtkTextProperty) -> None: ...
    def SetTextScaleMode(self, _arg:int) -> None: ...
    def SetTextScaleModeToNone(self) -> None: ...
    def SetTextScaleModeToProp(self) -> None: ...
    def SetTextScaleModeToViewport(self) -> None: ...
    def SetUseBorderAlign(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...
    def SpecifiedToDisplay(self, pos:[float, ...], vport:vtkViewport, specified:int) -> None: ...
    def UseBorderAlignOff(self) -> None: ...
    def UseBorderAlignOn(self) -> None: ...

class vtkTextActor3D(vtkProp3D):
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetBoundingBox(self, bbox:[int, int, int, int]) -> int: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetInput(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetRenderedDPI() -> int: ...
    def GetTextProperty(self) -> vtkTextProperty: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTextActor3D: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport) -> int: ...
    def RenderOverlay(self, viewport:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTextActor3D: ...
    def SetForceOpaque(self, opaque:bool) -> None: ...
    def SetForceTranslucent(self, trans:bool) -> None: ...
    def SetInput(self, _arg:str) -> None: ...
    def SetTextProperty(self, p:vtkTextProperty) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...

class vtkTextMapper(vtkMapper2D):
    def GetHeight(self, v:vtkViewport) -> int: ...
    def GetInput(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self, __a:vtkViewport, size:[int, int]) -> None: ...
    def GetTextProperty(self) -> vtkTextProperty: ...
    def GetWidth(self, v:vtkViewport) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTextMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOverlay(self, __a:vtkViewport, __b:vtkActor2D) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTextMapper: ...
    @overload
    def SetConstrainedFontSize(self, __a:vtkViewport, targetWidth:int, targetHeight:int) -> int: ...
    @overload
    @staticmethod
    def SetConstrainedFontSize(__a:vtkTextMapper, __b:vtkViewport, targetWidth:int, targetHeight:int) -> int: ...
    def SetInput(self, _arg:str) -> None: ...
    @staticmethod
    def SetRelativeFontSize(__a:vtkTextMapper, __b:vtkViewport, winSize:(int, ...), stringSize:[int, ...], sizeFactor:float=0.0) -> int: ...
    def SetTextProperty(self, p:vtkTextProperty) -> None: ...
    def ShallowCopy(self, m:vtkAbstractMapper) -> None: ...

class vtkTextProperty(vtkmodules.vtkCommonCore.vtkObject):
    def BoldOff(self) -> None: ...
    def BoldOn(self) -> None: ...
    def FrameOff(self) -> None: ...
    def FrameOn(self) -> None: ...
    def GetBackgroundColor(self) -> (float, float, float): ...
    def GetBackgroundOpacity(self) -> float: ...
    def GetBackgroundOpacityMaxValue(self) -> float: ...
    def GetBackgroundOpacityMinValue(self) -> float: ...
    @overload
    def GetBackgroundRGBA(self, rgba:[float, float, float, float]) -> None: ...
    @overload
    def GetBackgroundRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    def GetBold(self) -> int: ...
    def GetCellOffset(self) -> float: ...
    def GetColor(self) -> (float, float, float): ...
    def GetFontFamily(self) -> int: ...
    @overload
    def GetFontFamilyAsString(self) -> str: ...
    @overload
    @staticmethod
    def GetFontFamilyAsString(f:int) -> str: ...
    @staticmethod
    def GetFontFamilyFromString(f:str) -> int: ...
    def GetFontFamilyMinValue(self) -> int: ...
    def GetFontFile(self) -> str: ...
    def GetFontSize(self) -> int: ...
    def GetFontSizeMaxValue(self) -> int: ...
    def GetFontSizeMinValue(self) -> int: ...
    def GetFrame(self) -> int: ...
    def GetFrameColor(self) -> (float, float, float): ...
    def GetFrameWidth(self) -> int: ...
    def GetFrameWidthMaxValue(self) -> int: ...
    def GetFrameWidthMinValue(self) -> int: ...
    def GetInteriorLinesColor(self) -> (float, float, float): ...
    def GetInteriorLinesVisibility(self) -> bool: ...
    def GetInteriorLinesWidth(self) -> int: ...
    def GetItalic(self) -> int: ...
    def GetJustification(self) -> int: ...
    def GetJustificationAsString(self) -> str: ...
    def GetJustificationMaxValue(self) -> int: ...
    def GetJustificationMinValue(self) -> int: ...
    def GetLineOffset(self) -> float: ...
    def GetLineSpacing(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetOrientation(self) -> float: ...
    def GetShadow(self) -> int: ...
    def GetShadowColor(self, color:[float, float, float]) -> None: ...
    def GetShadowOffset(self) -> (int, int): ...
    def GetUseTightBoundingBox(self) -> int: ...
    def GetVerticalJustification(self) -> int: ...
    def GetVerticalJustificationAsString(self) -> str: ...
    def GetVerticalJustificationMaxValue(self) -> int: ...
    def GetVerticalJustificationMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ItalicOff(self) -> None: ...
    def ItalicOn(self) -> None: ...
    def NewInstance(self) -> vtkTextProperty: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTextProperty: ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:(float, float, float)) -> None: ...
    def SetBackgroundOpacity(self, _arg:float) -> None: ...
    @overload
    def SetBackgroundRGBA(self, rgba:[float, float, float, float]) -> None: ...
    @overload
    def SetBackgroundRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    def SetBold(self, _arg:int) -> None: ...
    def SetCellOffset(self, _arg:float) -> None: ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:(float, float, float)) -> None: ...
    def SetFontFamily(self, t:int) -> None: ...
    def SetFontFamilyAsString(self, _arg:str) -> None: ...
    def SetFontFamilyToArial(self) -> None: ...
    def SetFontFamilyToCourier(self) -> None: ...
    def SetFontFamilyToTimes(self) -> None: ...
    def SetFontFile(self, _arg:str) -> None: ...
    def SetFontSize(self, _arg:int) -> None: ...
    def SetFrame(self, _arg:int) -> None: ...
    @overload
    def SetFrameColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetFrameColor(self, _arg:(float, float, float)) -> None: ...
    def SetFrameWidth(self, _arg:int) -> None: ...
    @overload
    def SetInteriorLinesColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetInteriorLinesColor(self, _arg:(float, float, float)) -> None: ...
    def SetInteriorLinesVisibility(self, _arg:bool) -> None: ...
    def SetInteriorLinesWidth(self, _arg:int) -> None: ...
    def SetItalic(self, _arg:int) -> None: ...
    def SetJustification(self, _arg:int) -> None: ...
    def SetJustificationToCentered(self) -> None: ...
    def SetJustificationToLeft(self) -> None: ...
    def SetJustificationToRight(self) -> None: ...
    def SetLineOffset(self, _arg:float) -> None: ...
    def SetLineSpacing(self, _arg:float) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetOrientation(self, _arg:float) -> None: ...
    def SetShadow(self, _arg:int) -> None: ...
    @overload
    def SetShadowOffset(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetShadowOffset(self, _arg:(int, int)) -> None: ...
    def SetUseTightBoundingBox(self, _arg:int) -> None: ...
    def SetVerticalJustification(self, _arg:int) -> None: ...
    def SetVerticalJustificationToBottom(self) -> None: ...
    def SetVerticalJustificationToCentered(self) -> None: ...
    def SetVerticalJustificationToTop(self) -> None: ...
    def ShadowOff(self) -> None: ...
    def ShadowOn(self) -> None: ...
    def ShallowCopy(self, tprop:vtkTextProperty) -> None: ...
    def UseTightBoundingBoxOff(self) -> None: ...
    def UseTightBoundingBoxOn(self) -> None: ...

class vtkTextPropertyCollection(vtkmodules.vtkCommonCore.vtkCollection):
    def AddItem(self, a:vtkTextProperty) -> None: ...
    def GetItem(self, idx:int) -> vtkTextProperty: ...
    def GetLastItem(self) -> vtkTextProperty: ...
    def GetNextItem(self) -> vtkTextProperty: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTextPropertyCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTextPropertyCollection: ...

class vtkTextRenderer(vtkmodules.vtkCommonCore.vtkObject):
    class Backend(int): ...
    Default:'Backend'
    Detect:'Backend'
    FreeType:'Backend'
    MathText:'Backend'
    UserBackend:'Backend'
    def DetectBackend(self, str:str) -> int: ...
    def FreeTypeIsSupported(self) -> bool: ...
    def GetBoundingBox(self, tprop:vtkTextProperty, str:str, bbox:[int, int, int, int], dpi:int, backend:int=...) -> bool: ...
    def GetConstrainedFontSize(self, str:str, tprop:vtkTextProperty, targetWidth:int, targetHeight:int, dpi:int, backend:int=...) -> int: ...
    def GetDefaultBackend(self) -> int: ...
    @staticmethod
    def GetInstance() -> vtkTextRenderer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MathTextIsSupported(self) -> bool: ...
    def NewInstance(self) -> vtkTextRenderer: ...
    def RenderString(self, tprop:vtkTextProperty, str:str, data:vtkImageData, textDims:[int, int], dpi:int, backend:int=...) -> bool: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTextRenderer: ...
    def SetDefaultBackend(self, _arg:int) -> None: ...
    def SetScaleToPowerOfTwo(self, scale:bool) -> None: ...
    def StringToPath(self, tprop:vtkTextProperty, str:str, path:vtkPath, dpi:int, backend:int=...) -> bool: ...

class vtkTextRendererCleanup(object):
    def __init__(self) -> None: ...

class vtkTexture(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    class VTKTextureBlendingMode(int): ...
    ClampToBorder:int
    ClampToEdge:int
    MirroredRepeat:int
    NumberOfWrapModes:int
    Repeat:int
    VTK_TEXTURE_BLENDING_MODE_ADD:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_ADD_SIGNED:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_INTERPOLATE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_MODULATE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_NONE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_REPLACE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_SUBTRACT:'VTKTextureBlendingMode'
    def CubeMapOff(self) -> None: ...
    def CubeMapOn(self) -> None: ...
    def EdgeClampOff(self) -> None: ...
    def EdgeClampOn(self) -> None: ...
    def GetBlendingMode(self) -> int: ...
    def GetBorderColor(self) -> (float, float, float, float): ...
    def GetColorMode(self) -> int: ...
    def GetCubeMap(self) -> bool: ...
    def GetEdgeClamp(self) -> int: ...
    def GetInput(self) -> vtkImageData: ...
    def GetInterpolate(self) -> int: ...
    def GetLookupTable(self) -> vtkScalarsToColors: ...
    def GetMappedScalars(self) -> vtkUnsignedCharArray: ...
    def GetMaximumAnisotropicFiltering(self) -> float: ...
    def GetMipmap(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPremultipliedAlpha(self) -> bool: ...
    def GetQuality(self) -> int: ...
    def GetRepeat(self) -> int: ...
    def GetRestrictPowerOf2ImageSmaller(self) -> int: ...
    def GetTextureUnit(self) -> int: ...
    def GetTransform(self) -> vtkTransform: ...
    def GetUseSRGBColorSpace(self) -> bool: ...
    def GetWrap(self) -> int: ...
    def GetWrapMaxValue(self) -> int: ...
    def GetWrapMinValue(self) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslucent(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Load(self, __a:vtkRenderer) -> None: ...
    def MapScalarsToColors(self, scalars:vtkDataArray) -> Pointer: ...
    def MipmapOff(self) -> None: ...
    def MipmapOn(self) -> None: ...
    def NewInstance(self) -> vtkTexture: ...
    def PostRender(self, __a:vtkRenderer) -> None: ...
    def PremultipliedAlphaOff(self) -> None: ...
    def PremultipliedAlphaOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self, ren:vtkRenderer) -> None: ...
    def RepeatOff(self) -> None: ...
    def RepeatOn(self) -> None: ...
    def RestrictPowerOf2ImageSmallerOff(self) -> None: ...
    def RestrictPowerOf2ImageSmallerOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTexture: ...
    def SetBlendingMode(self, _arg:int) -> None: ...
    @overload
    def SetBorderColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetBorderColor(self, _arg:(float, float, float, float)) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToDirectScalars(self) -> None: ...
    def SetColorModeToMapScalars(self) -> None: ...
    def SetCubeMap(self, val:bool) -> None: ...
    def SetEdgeClamp(self, __a:int) -> None: ...
    def SetInterpolate(self, _arg:int) -> None: ...
    def SetLookupTable(self, __a:vtkScalarsToColors) -> None: ...
    def SetMaximumAnisotropicFiltering(self, _arg:float) -> None: ...
    def SetMipmap(self, _arg:bool) -> None: ...
    def SetPremultipliedAlpha(self, _arg:bool) -> None: ...
    def SetQuality(self, _arg:int) -> None: ...
    def SetQualityTo16Bit(self) -> None: ...
    def SetQualityTo32Bit(self) -> None: ...
    def SetQualityToDefault(self) -> None: ...
    def SetRepeat(self, r:int) -> None: ...
    def SetRestrictPowerOf2ImageSmaller(self, _arg:int) -> None: ...
    def SetTransform(self, transform:vtkTransform) -> None: ...
    def SetUseSRGBColorSpace(self, _arg:bool) -> None: ...
    def SetWrap(self, _arg:int) -> None: ...
    def UseSRGBColorSpaceOff(self) -> None: ...
    def UseSRGBColorSpaceOn(self) -> None: ...

class vtkTransformCoordinateSystems(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    def GetInputCoordinateSystem(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputCoordinateSystem(self) -> int: ...
    def GetViewport(self) -> vtkViewport: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTransformCoordinateSystems: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTransformCoordinateSystems: ...
    def SetInputCoordinateSystem(self, _arg:int) -> None: ...
    def SetInputCoordinateSystemToDisplay(self) -> None: ...
    def SetInputCoordinateSystemToViewport(self) -> None: ...
    def SetInputCoordinateSystemToWorld(self) -> None: ...
    def SetOutputCoordinateSystem(self, _arg:int) -> None: ...
    def SetOutputCoordinateSystemToDisplay(self) -> None: ...
    def SetOutputCoordinateSystemToViewport(self) -> None: ...
    def SetOutputCoordinateSystemToWorld(self) -> None: ...
    def SetViewport(self, viewport:vtkViewport) -> None: ...

class vtkTransformInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    INTERPOLATION_TYPE_LINEAR:int
    INTERPOLATION_TYPE_MANUAL:int
    INTERPOLATION_TYPE_SPLINE:int
    @overload
    def AddTransform(self, t:float, xform:vtkTransform) -> None: ...
    @overload
    def AddTransform(self, t:float, matrix:vtkMatrix4x4) -> None: ...
    @overload
    def AddTransform(self, t:float, prop3D:vtkProp3D) -> None: ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMaximumT(self) -> float: ...
    def GetMinimumT(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTransforms(self) -> int: ...
    def GetPositionInterpolator(self) -> vtkTupleInterpolator: ...
    def GetRotationInterpolator(self) -> vtkQuaternionInterpolator: ...
    def GetScaleInterpolator(self) -> vtkTupleInterpolator: ...
    def Initialize(self) -> None: ...
    def InterpolateTransform(self, t:float, xform:vtkTransform) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTransformInterpolator: ...
    def RemoveTransform(self, t:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTransformInterpolator: ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToManual(self) -> None: ...
    def SetInterpolationTypeToSpline(self) -> None: ...
    def SetPositionInterpolator(self, __a:vtkTupleInterpolator) -> None: ...
    def SetRotationInterpolator(self, __a:vtkQuaternionInterpolator) -> None: ...
    def SetScaleInterpolator(self, __a:vtkTupleInterpolator) -> None: ...

class vtkTupleInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    INTERPOLATION_TYPE_LINEAR:int
    INTERPOLATION_TYPE_SPLINE:int
    def AddTuple(self, t:float, tuple:[float, ...]) -> None: ...
    def GetInterpolatingSpline(self) -> vtkSpline: ...
    def GetInterpolationType(self) -> int: ...
    def GetMaximumT(self) -> float: ...
    def GetMinimumT(self) -> float: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def Initialize(self) -> None: ...
    def InterpolateTuple(self, t:float, tuple:[float, ...]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTupleInterpolator: ...
    def RemoveTuple(self, t:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTupleInterpolator: ...
    def SetInterpolatingSpline(self, __a:vtkSpline) -> None: ...
    def SetInterpolationType(self, type:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToSpline(self) -> None: ...
    def SetNumberOfComponents(self, numComp:int) -> None: ...

class vtkUniforms(vtkmodules.vtkCommonCore.vtkObject):
    class TupleType(int): ...
    NumberOfTupleTypes:'TupleType'
    TupleTypeInvalid:'TupleType'
    TupleTypeMatrix:'TupleType'
    TupleTypeScalar:'TupleType'
    TupleTypeVector:'TupleType'
    def GetNthUniformName(self, uniformIndex:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfUniforms(self) -> int: ...
    @overload
    def GetUniform(self, name:str, value:[int, ...]) -> bool: ...
    @overload
    def GetUniform(self, name:str, value:[float, ...]) -> bool: ...
    def GetUniform1fv(self, name:str, f:[float, ...]) -> bool: ...
    def GetUniform1iv(self, name:str, f:[int, ...]) -> bool: ...
    def GetUniform2f(self, name:str, v:[float, float]) -> bool: ...
    def GetUniform2fv(self, name:str, f:[float, ...]) -> bool: ...
    def GetUniform2i(self, name:str, v:[int, int]) -> bool: ...
    def GetUniform3f(self, name:str, v:[float, float, float]) -> bool: ...
    def GetUniform3fv(self, name:str, f:[float, ...]) -> bool: ...
    def GetUniform3uc(self, name:str, v:[int, int, int]) -> bool: ...
    def GetUniform4f(self, name:str, v:[float, float, float, float]) -> bool: ...
    def GetUniform4fv(self, name:str, f:[float, ...]) -> bool: ...
    def GetUniform4uc(self, name:str, v:[int, int, int, int]) -> bool: ...
    def GetUniformListMTime(self) -> int: ...
    @overload
    def GetUniformMatrix(self, name:str, v:vtkMatrix3x3) -> bool: ...
    @overload
    def GetUniformMatrix(self, name:str, v:vtkMatrix4x4) -> bool: ...
    def GetUniformMatrix3x3(self, name:str, v:[float, ...]) -> bool: ...
    def GetUniformMatrix4x4(self, name:str, v:[float, ...]) -> bool: ...
    def GetUniformMatrix4x4v(self, name:str, f:[float, ...]) -> bool: ...
    def GetUniformNumberOfComponents(self, name:str) -> int: ...
    def GetUniformNumberOfTuples(self, name:str) -> int: ...
    def GetUniformScalarType(self, name:str) -> int: ...
    def GetUniformTupleType(self, name:str) -> TupleType: ...
    def GetUniformf(self, name:str, v:float) -> bool: ...
    def GetUniformi(self, name:str, v:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkUniforms: ...
    def RemoveAllUniforms(self) -> None: ...
    def RemoveUniform(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkUniforms: ...
    @staticmethod
    def ScalarTypeToString(scalarType:int) -> str: ...
    @overload
    def SetUniform(self, name:str, tt:vtkUniforms.TupleType, nbComponents:int, value:(int, ...)) -> None: ...
    @overload
    def SetUniform(self, name:str, tt:vtkUniforms.TupleType, nbComponents:int, value:(float, ...)) -> None: ...
    def SetUniform1fv(self, name:str, count:int, f:(float, ...)) -> None: ...
    def SetUniform1iv(self, name:str, count:int, f:(int, ...)) -> None: ...
    def SetUniform2f(self, name:str, v:(float, float)) -> None: ...
    def SetUniform2i(self, name:str, v:(int, int)) -> None: ...
    def SetUniform3f(self, name:str, v:(float, float, float)) -> None: ...
    def SetUniform3uc(self, name:str, v:(int, int, int)) -> None: ...
    def SetUniform4f(self, name:str, v:(float, float, float, float)) -> None: ...
    def SetUniform4uc(self, name:str, v:(int, int, int, int)) -> None: ...
    @overload
    def SetUniformMatrix(self, name:str, v:vtkMatrix3x3) -> None: ...
    @overload
    def SetUniformMatrix(self, name:str, v:vtkMatrix4x4) -> None: ...
    def SetUniformMatrix3x3(self, name:str, v:[float, ...]) -> None: ...
    def SetUniformMatrix4x4(self, name:str, v:[float, ...]) -> None: ...
    def SetUniformMatrix4x4v(self, name:str, count:int, v:[float, ...]) -> None: ...
    def SetUniformf(self, name:str, v:float) -> None: ...
    def SetUniformi(self, name:str, v:int) -> None: ...
    @staticmethod
    def StringToScalarType(s:str) -> int: ...
    @staticmethod
    def StringToTupleType(s:str) -> TupleType: ...
    @staticmethod
    def TupleTypeToString(tt:TupleType) -> str: ...

class vtkViewDependentErrorMetric(vtkmodules.vtkCommonDataModel.vtkGenericSubdivisionErrorMetric):
    def GetError(self, leftPoint:[float, ...], midPoint:[float, ...], rightPoint:[float, ...], alpha:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelTolerance(self) -> float: ...
    def GetViewport(self) -> vtkViewport: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkViewDependentErrorMetric: ...
    def RequiresEdgeSubdivision(self, leftPoint:[float, ...], midPoint:[float, ...], rightPoint:[float, ...], alpha:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkViewDependentErrorMetric: ...
    def SetPixelTolerance(self, value:float) -> None: ...
    def SetViewport(self, viewport:vtkViewport) -> None: ...

class vtkVolume(vtkProp3D):
    def GetArraySize(self) -> float: ...
    @overload
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    @overload
    def GetBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    @overload
    def GetCorrectedScalarOpacityArray(self, __a:int) -> Pointer: ...
    @overload
    def GetCorrectedScalarOpacityArray(self) -> Pointer: ...
    @overload
    def GetGradientOpacityArray(self, __a:int) -> Pointer: ...
    @overload
    def GetGradientOpacityArray(self) -> Pointer: ...
    @overload
    def GetGradientOpacityConstant(self, __a:int) -> float: ...
    @overload
    def GetGradientOpacityConstant(self) -> float: ...
    @overload
    def GetGrayArray(self, __a:int) -> Pointer: ...
    @overload
    def GetGrayArray(self) -> Pointer: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> vtkAbstractVolumeMapper: ...
    def GetMaxXBound(self) -> float: ...
    def GetMaxYBound(self) -> float: ...
    def GetMaxZBound(self) -> float: ...
    def GetMinXBound(self) -> float: ...
    def GetMinYBound(self) -> float: ...
    def GetMinZBound(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> vtkVolumeProperty: ...
    @overload
    def GetRGBArray(self, __a:int) -> Pointer: ...
    @overload
    def GetRGBArray(self) -> Pointer: ...
    def GetRedrawMTime(self) -> int: ...
    @overload
    def GetScalarOpacityArray(self, __a:int) -> Pointer: ...
    @overload
    def GetScalarOpacityArray(self) -> Pointer: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetVolumes(self, vc:vtkPropCollection) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVolume: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderVolumetricGeometry(self, viewport:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVolume: ...
    def SetMapper(self, mapper:vtkAbstractVolumeMapper) -> None: ...
    def SetProperty(self, property:vtkVolumeProperty) -> None: ...
    def ShallowCopy(self, prop:vtkProp) -> None: ...
    def Update(self) -> None: ...
    def UpdateScalarOpacityforSampleSize(self, ren:vtkRenderer, sample_distance:float) -> None: ...
    def UpdateTransferFunctions(self, ren:vtkRenderer) -> None: ...

class vtkVolumeCollection(vtkPropCollection):
    def AddItem(self, a:vtkVolume) -> None: ...
    def GetNextItem(self) -> vtkVolume: ...
    def GetNextVolume(self) -> vtkVolume: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVolumeCollection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVolumeCollection: ...

class vtkVolumeProperty(vtkmodules.vtkCommonCore.vtkObject):
    class TransferMode(int): ...
    TF_1D:'TransferMode'
    TF_2D:'TransferMode'
    def DeepCopy(self, p:vtkVolumeProperty) -> None: ...
    @overload
    def DisableGradientOpacityOff(self, index:int) -> None: ...
    @overload
    def DisableGradientOpacityOff(self) -> None: ...
    @overload
    def DisableGradientOpacityOn(self, index:int) -> None: ...
    @overload
    def DisableGradientOpacityOn(self) -> None: ...
    @overload
    def GetAmbient(self, index:int) -> float: ...
    @overload
    def GetAmbient(self) -> float: ...
    def GetClippedVoxelIntensity(self) -> float: ...
    @overload
    def GetColorChannels(self, index:int) -> int: ...
    @overload
    def GetColorChannels(self) -> int: ...
    def GetComponentWeight(self, index:int) -> float: ...
    @overload
    def GetDiffuse(self, index:int) -> float: ...
    @overload
    def GetDiffuse(self) -> float: ...
    @overload
    def GetDisableGradientOpacity(self, index:int) -> int: ...
    @overload
    def GetDisableGradientOpacity(self) -> int: ...
    @overload
    def GetGradientOpacity(self, index:int) -> vtkPiecewiseFunction: ...
    @overload
    def GetGradientOpacity(self) -> vtkPiecewiseFunction: ...
    @overload
    def GetGradientOpacityMTime(self, index:int) -> vtkTimeStamp: ...
    @overload
    def GetGradientOpacityMTime(self) -> vtkTimeStamp: ...
    @overload
    def GetGrayTransferFunction(self, index:int) -> vtkPiecewiseFunction: ...
    @overload
    def GetGrayTransferFunction(self) -> vtkPiecewiseFunction: ...
    @overload
    def GetGrayTransferFunctionMTime(self, index:int) -> vtkTimeStamp: ...
    @overload
    def GetGrayTransferFunctionMTime(self) -> vtkTimeStamp: ...
    def GetIndependentComponents(self) -> int: ...
    def GetIndependentComponentsMaxValue(self) -> int: ...
    def GetIndependentComponentsMinValue(self) -> int: ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeAsString(self) -> str: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetIsoSurfaceValues(self) -> vtkContourValues: ...
    def GetLabelColor(self, label:int) -> vtkColorTransferFunction: ...
    def GetLabelColorMTime(self) -> vtkTimeStamp: ...
    def GetLabelGradientOpacity(self, label:int) -> vtkPiecewiseFunction: ...
    def GetLabelGradientOpacityMTime(self) -> vtkTimeStamp: ...
    def GetLabelScalarOpacity(self, label:int) -> vtkPiecewiseFunction: ...
    def GetLabelScalarOpacityMTime(self) -> vtkTimeStamp: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    @overload
    def GetRGBTransferFunction(self, index:int) -> vtkColorTransferFunction: ...
    @overload
    def GetRGBTransferFunction(self) -> vtkColorTransferFunction: ...
    @overload
    def GetRGBTransferFunctionMTime(self, index:int) -> vtkTimeStamp: ...
    @overload
    def GetRGBTransferFunctionMTime(self) -> vtkTimeStamp: ...
    @overload
    def GetScalarOpacity(self, index:int) -> vtkPiecewiseFunction: ...
    @overload
    def GetScalarOpacity(self) -> vtkPiecewiseFunction: ...
    @overload
    def GetScalarOpacityMTime(self, index:int) -> vtkTimeStamp: ...
    @overload
    def GetScalarOpacityMTime(self) -> vtkTimeStamp: ...
    @overload
    def GetScalarOpacityUnitDistance(self, index:int) -> float: ...
    @overload
    def GetScalarOpacityUnitDistance(self) -> float: ...
    def GetScatteringAnisotropy(self) -> float: ...
    def GetScatteringAnisotropyMaxValue(self) -> float: ...
    def GetScatteringAnisotropyMinValue(self) -> float: ...
    @overload
    def GetShade(self, index:int) -> int: ...
    @overload
    def GetShade(self) -> int: ...
    def GetSliceFunction(self) -> vtkImplicitFunction: ...
    @overload
    def GetSpecular(self, index:int) -> float: ...
    @overload
    def GetSpecular(self) -> float: ...
    @overload
    def GetSpecularPower(self, index:int) -> float: ...
    @overload
    def GetSpecularPower(self) -> float: ...
    @overload
    def GetStoredGradientOpacity(self, index:int) -> vtkPiecewiseFunction: ...
    @overload
    def GetStoredGradientOpacity(self) -> vtkPiecewiseFunction: ...
    @overload
    def GetTransferFunction2D(self, index:int) -> vtkImageData: ...
    @overload
    def GetTransferFunction2D(self) -> vtkImageData: ...
    def GetTransferFunctionMode(self) -> int: ...
    def GetTransferFunctionModeMaxValue(self) -> int: ...
    def GetTransferFunctionModeMinValue(self) -> int: ...
    def GetUseClippedVoxelIntensity(self) -> int: ...
    def HasGradientOpacity(self, index:int=0) -> bool: ...
    def HasLabelGradientOpacity(self) -> bool: ...
    def IndependentComponentsOff(self) -> None: ...
    def IndependentComponentsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVolumeProperty: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVolumeProperty: ...
    @overload
    def SetAmbient(self, index:int, value:float) -> None: ...
    @overload
    def SetAmbient(self, value:float) -> None: ...
    def SetClippedVoxelIntensity(self, _arg:float) -> None: ...
    @overload
    def SetColor(self, index:int, function:vtkPiecewiseFunction) -> None: ...
    @overload
    def SetColor(self, function:vtkPiecewiseFunction) -> None: ...
    @overload
    def SetColor(self, index:int, function:vtkColorTransferFunction) -> None: ...
    @overload
    def SetColor(self, function:vtkColorTransferFunction) -> None: ...
    def SetComponentWeight(self, index:int, value:float) -> None: ...
    @overload
    def SetDiffuse(self, index:int, value:float) -> None: ...
    @overload
    def SetDiffuse(self, value:float) -> None: ...
    @overload
    def SetDisableGradientOpacity(self, index:int, value:int) -> None: ...
    @overload
    def SetDisableGradientOpacity(self, value:int) -> None: ...
    @overload
    def SetGradientOpacity(self, index:int, function:vtkPiecewiseFunction) -> None: ...
    @overload
    def SetGradientOpacity(self, function:vtkPiecewiseFunction) -> None: ...
    def SetIndependentComponents(self, _arg:int) -> None: ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToNearest(self) -> None: ...
    def SetLabelColor(self, label:int, function:vtkColorTransferFunction) -> None: ...
    def SetLabelGradientOpacity(self, label:int, function:vtkPiecewiseFunction) -> None: ...
    def SetLabelScalarOpacity(self, label:int, function:vtkPiecewiseFunction) -> None: ...
    @overload
    def SetScalarOpacity(self, index:int, function:vtkPiecewiseFunction) -> None: ...
    @overload
    def SetScalarOpacity(self, function:vtkPiecewiseFunction) -> None: ...
    @overload
    def SetScalarOpacityUnitDistance(self, index:int, distance:float) -> None: ...
    @overload
    def SetScalarOpacityUnitDistance(self, distance:float) -> None: ...
    def SetScatteringAnisotropy(self, _arg:float) -> None: ...
    @overload
    def SetShade(self, index:int, value:int) -> None: ...
    @overload
    def SetShade(self, value:int) -> None: ...
    def SetSliceFunction(self, _arg:vtkImplicitFunction) -> None: ...
    @overload
    def SetSpecular(self, index:int, value:float) -> None: ...
    @overload
    def SetSpecular(self, value:float) -> None: ...
    @overload
    def SetSpecularPower(self, index:int, value:float) -> None: ...
    @overload
    def SetSpecularPower(self, value:float) -> None: ...
    @overload
    def SetTransferFunction2D(self, index:int, function:vtkImageData) -> None: ...
    @overload
    def SetTransferFunction2D(self, function:vtkImageData) -> None: ...
    def SetTransferFunctionMode(self, _arg:int) -> None: ...
    def SetTransferFunctionModeTo1D(self) -> None: ...
    def SetTransferFunctionModeTo2D(self) -> None: ...
    def SetUseClippedVoxelIntensity(self, _arg:int) -> None: ...
    @overload
    def ShadeOff(self, index:int) -> None: ...
    @overload
    def ShadeOff(self) -> None: ...
    @overload
    def ShadeOn(self, index:int) -> None: ...
    @overload
    def ShadeOn(self) -> None: ...
    def UpdateMTimes(self) -> None: ...
    def UseClippedVoxelIntensityOff(self) -> None: ...
    def UseClippedVoxelIntensityOn(self) -> None: ...

class vtkWindowLevelLookupTable(vtkmodules.vtkCommonCore.vtkLookupTable):
    def ForceBuild(self) -> None: ...
    def GetInverseVideo(self) -> int: ...
    def GetLevel(self) -> float: ...
    def GetMaximumTableValue(self) -> (float, float, float, float): ...
    def GetMinimumTableValue(self) -> (float, float, float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWindow(self) -> float: ...
    def InverseVideoOff(self) -> None: ...
    def InverseVideoOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWindowLevelLookupTable: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWindowLevelLookupTable: ...
    def SetInverseVideo(self, iv:int) -> None: ...
    def SetLevel(self, level:float) -> None: ...
    @overload
    def SetMaximumTableValue(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetMaximumTableValue(self, _arg:(float, float, float, float)) -> None: ...
    @overload
    def SetMinimumTableValue(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetMinimumTableValue(self, _arg:(float, float, float, float)) -> None: ...
    def SetWindow(self, window:float) -> None: ...

class vtkWindowToImageFilter(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def FixBoundaryOff(self) -> None: ...
    def FixBoundaryOn(self) -> None: ...
    def GetFixBoundary(self) -> bool: ...
    def GetInput(self) -> vtkWindow: ...
    def GetInputBufferType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> vtkImageData: ...
    def GetReadFrontBuffer(self) -> int: ...
    def GetScale(self) -> (int, int): ...
    def GetShouldRerender(self) -> int: ...
    def GetViewport(self) -> (float, float, float, float): ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWindowToImageFilter: ...
    def ReadFrontBufferOff(self) -> None: ...
    def ReadFrontBufferOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWindowToImageFilter: ...
    def SetFixBoundary(self, _arg:bool) -> None: ...
    def SetInput(self, input:vtkWindow) -> None: ...
    def SetInputBufferType(self, _arg:int) -> None: ...
    def SetInputBufferTypeToRGB(self) -> None: ...
    def SetInputBufferTypeToRGBA(self) -> None: ...
    def SetInputBufferTypeToZBuffer(self) -> None: ...
    def SetReadFrontBuffer(self, _arg:int) -> None: ...
    @overload
    def SetScale(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetScale(self, _arg:(int, int)) -> None: ...
    @overload
    def SetScale(self, scale:int) -> None: ...
    def SetShouldRerender(self, _arg:int) -> None: ...
    @overload
    def SetViewport(self, __a:float, __b:float, __c:float, __d:float) -> None: ...
    @overload
    def SetViewport(self, __a:[float, ...]) -> None: ...
    def ShouldRerenderOff(self) -> None: ...
    def ShouldRerenderOn(self) -> None: ...

class vtkWorldPointPicker(vtkAbstractPicker):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWorldPointPicker: ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:vtkRenderer) -> int: ...
    @overload
    def Pick(self, selectionPt:[float, float, float], renderer:vtkRenderer) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWorldPointPicker: ...

