from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkInteractionStyle
import vtkmodules.vtkRenderingContext2D
import vtkmodules.vtkViewsCore

class vtkApplyColors(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetCellColorOutputArrayName(self) -> str: ...
    def GetCellLookupTable(self) -> vtkScalarsToColors: ...
    def GetDefaultCellColor(self) -> (float, float, float): ...
    def GetDefaultCellOpacity(self) -> float: ...
    def GetDefaultPointColor(self) -> (float, float, float): ...
    def GetDefaultPointOpacity(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointColorOutputArrayName(self) -> str: ...
    def GetPointLookupTable(self) -> vtkScalarsToColors: ...
    def GetScaleCellLookupTable(self) -> bool: ...
    def GetScalePointLookupTable(self) -> bool: ...
    def GetSelectedCellColor(self) -> (float, float, float): ...
    def GetSelectedCellOpacity(self) -> float: ...
    def GetSelectedPointColor(self) -> (float, float, float): ...
    def GetSelectedPointOpacity(self) -> float: ...
    def GetUseCellLookupTable(self) -> bool: ...
    def GetUseCurrentAnnotationColor(self) -> bool: ...
    def GetUsePointLookupTable(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkApplyColors: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkApplyColors: ...
    def ScaleCellLookupTableOff(self) -> None: ...
    def ScaleCellLookupTableOn(self) -> None: ...
    def ScalePointLookupTableOff(self) -> None: ...
    def ScalePointLookupTableOn(self) -> None: ...
    def SetCellColorOutputArrayName(self, _arg:str) -> None: ...
    def SetCellLookupTable(self, lut:vtkScalarsToColors) -> None: ...
    @overload
    def SetDefaultCellColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultCellColor(self, _arg:(float, float, float)) -> None: ...
    def SetDefaultCellOpacity(self, _arg:float) -> None: ...
    @overload
    def SetDefaultPointColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultPointColor(self, _arg:(float, float, float)) -> None: ...
    def SetDefaultPointOpacity(self, _arg:float) -> None: ...
    def SetPointColorOutputArrayName(self, _arg:str) -> None: ...
    def SetPointLookupTable(self, lut:vtkScalarsToColors) -> None: ...
    def SetScaleCellLookupTable(self, _arg:bool) -> None: ...
    def SetScalePointLookupTable(self, _arg:bool) -> None: ...
    @overload
    def SetSelectedCellColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSelectedCellColor(self, _arg:(float, float, float)) -> None: ...
    def SetSelectedCellOpacity(self, _arg:float) -> None: ...
    @overload
    def SetSelectedPointColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSelectedPointColor(self, _arg:(float, float, float)) -> None: ...
    def SetSelectedPointOpacity(self, _arg:float) -> None: ...
    def SetUseCellLookupTable(self, _arg:bool) -> None: ...
    def SetUseCurrentAnnotationColor(self, _arg:bool) -> None: ...
    def SetUsePointLookupTable(self, _arg:bool) -> None: ...
    def UseCellLookupTableOff(self) -> None: ...
    def UseCellLookupTableOn(self) -> None: ...
    def UseCurrentAnnotationColorOff(self) -> None: ...
    def UseCurrentAnnotationColorOn(self) -> None: ...
    def UsePointLookupTableOff(self) -> None: ...
    def UsePointLookupTableOn(self) -> None: ...

class vtkApplyIcons(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    ANNOTATION_ICON:int
    IGNORE_SELECTION:int
    SELECTED_ICON:int
    SELECTED_OFFSET:int
    def ClearAllIconTypes(self) -> None: ...
    def GetAttributeType(self) -> int: ...
    def GetDefaultIcon(self) -> int: ...
    def GetIconOutputArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectedIcon(self) -> int: ...
    def GetSelectionMode(self) -> int: ...
    def GetUseLookupTable(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkApplyIcons: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkApplyIcons: ...
    def SetAttributeType(self, _arg:int) -> None: ...
    def SetDefaultIcon(self, _arg:int) -> None: ...
    def SetIconOutputArrayName(self, _arg:str) -> None: ...
    @overload
    def SetIconType(self, v:vtkVariant, icon:int) -> None: ...
    @overload
    def SetIconType(self, v:float, icon:int) -> None: ...
    @overload
    def SetIconType(self, v:str, icon:int) -> None: ...
    def SetSelectedIcon(self, _arg:int) -> None: ...
    def SetSelectionMode(self, _arg:int) -> None: ...
    def SetSelectionModeToAnnotationIcon(self) -> None: ...
    def SetSelectionModeToIgnoreSelection(self) -> None: ...
    def SetSelectionModeToSelectedIcon(self) -> None: ...
    def SetSelectionModeToSelectedOffset(self) -> None: ...
    def SetUseLookupTable(self, _arg:bool) -> None: ...
    def UseLookupTableOff(self) -> None: ...
    def UseLookupTableOn(self) -> None: ...

class vtkDendrogramItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    DOWN_TO_UP:int
    LEFT_TO_RIGHT:int
    RIGHT_TO_LEFT:int
    UP_TO_DOWN:int
    def CollapseToNumberOfLeafNodes(self, n:int) -> None: ...
    def ComputeLabelWidth(self, painter:vtkContext2D) -> None: ...
    def DisplayNumberOfCollapsedLeafNodesOff(self) -> None: ...
    def DisplayNumberOfCollapsedLeafNodesOn(self) -> None: ...
    def DrawLabelsOff(self) -> None: ...
    def DrawLabelsOn(self) -> None: ...
    def ExtendLeafNodesOff(self) -> None: ...
    def ExtendLeafNodesOn(self) -> None: ...
    def GetAngleForOrientation(self, orientation:int) -> float: ...
    def GetBounds(self, bounds:[float, float, float, float]) -> None: ...
    def GetDisplayNumberOfCollapsedLeafNodes(self) -> bool: ...
    def GetDistanceArrayName(self) -> str: ...
    def GetDrawLabels(self) -> bool: ...
    def GetExtendLeafNodes(self) -> bool: ...
    def GetLabelWidth(self) -> float: ...
    def GetLeafSpacing(self) -> float: ...
    def GetLineWidth(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPosition(self) -> (float, float): ...
    def GetPositionOfVertex(self, vertexName:str, position:[float, float]) -> bool: ...
    def GetPositionVector(self) -> vtkVector2f: ...
    def GetPrunedTree(self) -> vtkTree: ...
    def GetTextAngleForOrientation(self, orientation:int) -> float: ...
    def GetTree(self) -> vtkTree: ...
    def GetVertexNameArrayName(self) -> str: ...
    def Hit(self, mouse:vtkContextMouseEvent) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseDoubleClickEvent(self, event:vtkContextMouseEvent) -> bool: ...
    def NewInstance(self) -> vtkDendrogramItem: ...
    def Paint(self, painter:vtkContext2D) -> bool: ...
    def PrepareToPaint(self, painter:vtkContext2D) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDendrogramItem: ...
    def SetColorArray(self, arrayName:str) -> None: ...
    def SetDisplayNumberOfCollapsedLeafNodes(self, _arg:bool) -> None: ...
    def SetDistanceArrayName(self, _arg:str) -> None: ...
    def SetDrawLabels(self, _arg:bool) -> None: ...
    def SetExtendLeafNodes(self, _arg:bool) -> None: ...
    def SetLeafSpacing(self, _arg:float) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPosition(self, _arg:(float, float)) -> None: ...
    @overload
    def SetPosition(self, pos:vtkVector2f) -> None: ...
    def SetTree(self, tree:vtkTree) -> None: ...
    def SetVertexNameArrayName(self, _arg:str) -> None: ...

class vtkGraphItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    def GetGraph(self) -> vtkGraph: ...
    def GetLayout(self) -> vtkIncrementalForceLayout: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGraphItem: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphItem: ...
    def SetGraph(self, graph:vtkGraph) -> None: ...
    def StartLayoutAnimation(self, interactor:vtkRenderWindowInteractor) -> None: ...
    def StopLayoutAnimation(self) -> None: ...
    def UpdateLayout(self) -> None: ...

class vtkRenderView(vtkmodules.vtkViewsCore.vtkRenderViewBase):
    ALL:int
    FREETYPE:int
    FRUSTUM:int
    INTERACTION_MODE_2D:int
    INTERACTION_MODE_3D:int
    INTERACTION_MODE_UNKNOWN:int
    NO_OVERLAP:int
    QT:int
    SURFACE:int
    def AddLabels(self, conn:vtkAlgorithmOutput) -> None: ...
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def DisplayHoverTextOff(self) -> None: ...
    def DisplayHoverTextOn(self) -> None: ...
    def GetDisplayHoverText(self) -> bool: ...
    @overload
    def GetDisplaySize(self) -> Pointer: ...
    @overload
    def GetDisplaySize(self, dsx:int, dsy:int) -> None: ...
    def GetIconSize(self) -> (int, int): ...
    def GetIconTexture(self) -> vtkTexture: ...
    def GetInteractionMode(self) -> int: ...
    def GetInteractorStyle(self) -> vtkInteractorObserver: ...
    def GetLabelPlacementMode(self) -> int: ...
    def GetLabelRenderMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderOnMouseMove(self) -> bool: ...
    def GetSelectionMode(self) -> int: ...
    def GetSelectionModeMaxValue(self) -> int: ...
    def GetSelectionModeMinValue(self) -> int: ...
    def GetTransform(self) -> vtkAbstractTransform: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderView: ...
    def RemoveLabels(self, conn:vtkAlgorithmOutput) -> None: ...
    def Render(self) -> None: ...
    def RenderOnMouseMoveOff(self) -> None: ...
    def RenderOnMouseMoveOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderView: ...
    def SetDisplayHoverText(self, b:bool) -> None: ...
    @overload
    def SetDisplaySize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetDisplaySize(self, _arg:(int, int)) -> None: ...
    @overload
    def SetIconSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetIconSize(self, _arg:(int, int)) -> None: ...
    def SetIconTexture(self, texture:vtkTexture) -> None: ...
    def SetInteractionMode(self, mode:int) -> None: ...
    def SetInteractionModeTo2D(self) -> None: ...
    def SetInteractionModeTo3D(self) -> None: ...
    def SetInteractor(self, interactor:vtkRenderWindowInteractor) -> None: ...
    def SetInteractorStyle(self, style:vtkInteractorObserver) -> None: ...
    def SetLabelPlacementMode(self, mode:int) -> None: ...
    def SetLabelPlacementModeToAll(self) -> None: ...
    def SetLabelPlacementModeToNoOverlap(self) -> None: ...
    def SetLabelRenderMode(self, mode:int) -> None: ...
    def SetLabelRenderModeToFreetype(self) -> None: ...
    def SetLabelRenderModeToQt(self) -> None: ...
    def SetRenderOnMouseMove(self, b:bool) -> None: ...
    def SetRenderWindow(self, win:vtkRenderWindow) -> None: ...
    def SetSelectionMode(self, _arg:int) -> None: ...
    def SetSelectionModeToFrustum(self) -> None: ...
    def SetSelectionModeToSurface(self) -> None: ...
    def SetTransform(self, transform:vtkAbstractTransform) -> None: ...

class vtkGraphLayoutView(vtkRenderView):
    def AddIconType(self, type:str, index:int) -> None: ...
    def ClearIconTypes(self) -> None: ...
    def ColorEdgesOff(self) -> None: ...
    def ColorEdgesOn(self) -> None: ...
    def ColorVerticesOff(self) -> None: ...
    def ColorVerticesOn(self) -> None: ...
    def EdgeLabelVisibilityOff(self) -> None: ...
    def EdgeLabelVisibilityOn(self) -> None: ...
    def EdgeSelectionOff(self) -> None: ...
    def EdgeSelectionOn(self) -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def GetColorEdges(self) -> bool: ...
    def GetColorVertices(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeLabelArrayName(self) -> str: ...
    def GetEdgeLabelFontSize(self) -> int: ...
    def GetEdgeLabelVisibility(self) -> bool: ...
    def GetEdgeLayoutStrategy(self) -> vtkEdgeLayoutStrategy: ...
    def GetEdgeLayoutStrategyName(self) -> str: ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    def GetEdgeSelection(self) -> bool: ...
    def GetEdgeVisibility(self) -> bool: ...
    def GetEnableEdgesByArray(self) -> int: ...
    def GetEnableVerticesByArray(self) -> int: ...
    def GetEnabledEdgesArrayName(self) -> str: ...
    def GetEnabledVerticesArrayName(self) -> str: ...
    def GetGlyphType(self) -> int: ...
    def GetHideEdgeLabelsOnInteraction(self) -> bool: ...
    def GetHideVertexLabelsOnInteraction(self) -> bool: ...
    def GetIconArrayName(self) -> str: ...
    def GetIconVisibility(self) -> bool: ...
    def GetLayoutStrategy(self) -> vtkGraphLayoutStrategy: ...
    def GetLayoutStrategyName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaledGlyphs(self) -> bool: ...
    def GetScalingArrayName(self) -> str: ...
    def GetVertexColorArrayName(self) -> str: ...
    def GetVertexLabelArrayName(self) -> str: ...
    def GetVertexLabelFontSize(self) -> int: ...
    def GetVertexLabelVisibility(self) -> bool: ...
    def GetVertexScalarBarVisibility(self) -> bool: ...
    def HideEdgeLabelsOnInteractionOff(self) -> None: ...
    def HideEdgeLabelsOnInteractionOn(self) -> None: ...
    def HideVertexLabelsOnInteractionOff(self) -> None: ...
    def HideVertexLabelsOnInteractionOn(self) -> None: ...
    def IconVisibilityOff(self) -> None: ...
    def IconVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGraphLayoutView: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGraphLayoutView: ...
    def ScaledGlyphsOff(self) -> None: ...
    def ScaledGlyphsOn(self) -> None: ...
    def SetColorEdges(self, vis:bool) -> None: ...
    def SetColorVertices(self, vis:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeLabelArrayName(self, name:str) -> None: ...
    def SetEdgeLabelFontSize(self, size:int) -> None: ...
    def SetEdgeLabelVisibility(self, vis:bool) -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, name:str) -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, s:vtkEdgeLayoutStrategy) -> None: ...
    def SetEdgeLayoutStrategyToArcParallel(self) -> None: ...
    def SetEdgeLayoutStrategyToPassThrough(self) -> None: ...
    def SetEdgeScalarBarVisibility(self, vis:bool) -> None: ...
    def SetEdgeSelection(self, vis:bool) -> None: ...
    def SetEdgeVisibility(self, vis:bool) -> None: ...
    def SetEnableEdgesByArray(self, vis:bool) -> None: ...
    def SetEnableVerticesByArray(self, vis:bool) -> None: ...
    def SetEnabledEdgesArrayName(self, name:str) -> None: ...
    def SetEnabledVerticesArrayName(self, name:str) -> None: ...
    def SetGlyphType(self, type:int) -> None: ...
    def SetHideEdgeLabelsOnInteraction(self, vis:bool) -> None: ...
    def SetHideVertexLabelsOnInteraction(self, vis:bool) -> None: ...
    def SetIconAlignment(self, alignment:int) -> None: ...
    def SetIconArrayName(self, name:str) -> None: ...
    def SetIconVisibility(self, b:bool) -> None: ...
    @overload
    def SetLayoutStrategy(self, name:str) -> None: ...
    @overload
    def SetLayoutStrategy(self, s:vtkGraphLayoutStrategy) -> None: ...
    def SetLayoutStrategyToCircular(self) -> None: ...
    def SetLayoutStrategyToClustering2D(self) -> None: ...
    def SetLayoutStrategyToCommunity2D(self) -> None: ...
    def SetLayoutStrategyToCone(self) -> None: ...
    def SetLayoutStrategyToCosmicTree(self) -> None: ...
    def SetLayoutStrategyToFast2D(self) -> None: ...
    def SetLayoutStrategyToForceDirected(self) -> None: ...
    def SetLayoutStrategyToPassThrough(self) -> None: ...
    def SetLayoutStrategyToRandom(self) -> None: ...
    def SetLayoutStrategyToSimple2D(self) -> None: ...
    def SetLayoutStrategyToSpanTree(self) -> None: ...
    def SetLayoutStrategyToTree(self) -> None: ...
    def SetScaledGlyphs(self, arg:bool) -> None: ...
    def SetScalingArrayName(self, name:str) -> None: ...
    def SetVertexColorArrayName(self, name:str) -> None: ...
    def SetVertexLabelArrayName(self, name:str) -> None: ...
    def SetVertexLabelFontSize(self, size:int) -> None: ...
    def SetVertexLabelVisibility(self, vis:bool) -> None: ...
    def SetVertexScalarBarVisibility(self, vis:bool) -> None: ...
    def UpdateLayout(self) -> None: ...
    def VertexLabelVisibilityOff(self) -> None: ...
    def VertexLabelVisibilityOn(self) -> None: ...
    def ZoomToSelection(self) -> None: ...

class vtkHeatmapItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    DOWN_TO_UP:int
    LEFT_TO_RIGHT:int
    RIGHT_TO_LEFT:int
    UP_TO_DOWN:int
    def GetBounds(self, bounds:[float, float, float, float]) -> None: ...
    def GetCellHeight(self) -> float: ...
    def GetCellWidth(self) -> float: ...
    def GetColumnLabelWidth(self) -> float: ...
    def GetNameColumn(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPosition(self) -> (float, float): ...
    def GetPositionVector(self) -> vtkVector2f: ...
    def GetRowLabelWidth(self) -> float: ...
    def GetRowNames(self) -> vtkStringArray: ...
    def GetTable(self) -> vtkTable: ...
    def GetTextAngleForOrientation(self, orientation:int) -> float: ...
    def Hit(self, mouse:vtkContextMouseEvent) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkRowAsBlank(self, rowName:str) -> None: ...
    def MouseDoubleClickEvent(self, event:vtkContextMouseEvent) -> bool: ...
    def MouseMoveEvent(self, event:vtkContextMouseEvent) -> bool: ...
    def NewInstance(self) -> vtkHeatmapItem: ...
    def Paint(self, painter:vtkContext2D) -> bool: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHeatmapItem: ...
    def SetCellHeight(self, _arg:float) -> None: ...
    def SetCellWidth(self, _arg:float) -> None: ...
    def SetNameColumn(self, _arg:str) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPosition(self, _arg:(float, float)) -> None: ...
    @overload
    def SetPosition(self, pos:vtkVector2f) -> None: ...
    def SetTable(self, table:vtkTable) -> None: ...

class vtkHierarchicalGraphPipeline(vtkmodules.vtkCommonCore.vtkObject):
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def ColorEdgesByArrayOff(self) -> None: ...
    def ColorEdgesByArrayOn(self) -> None: ...
    def ConvertSelection(self, rep:vtkDataRepresentation, sel:vtkSelection) -> vtkSelection: ...
    def GetActor(self) -> vtkActor: ...
    def GetBundlingStrength(self) -> float: ...
    def GetColorArrayName(self) -> str: ...
    def GetColorEdgesByArray(self) -> bool: ...
    def GetHoverArrayName(self) -> str: ...
    def GetLabelActor(self) -> vtkActor2D: ...
    def GetLabelArrayName(self) -> str: ...
    def GetLabelTextProperty(self) -> vtkTextProperty: ...
    def GetLabelVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSplineType(self) -> int: ...
    def GetVisibility(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> vtkHierarchicalGraphPipeline: ...
    def PrepareInputConnections(self, graphConn:vtkAlgorithmOutput, treeConn:vtkAlgorithmOutput, annConn:vtkAlgorithmOutput) -> None: ...
    def RegisterProgress(self, view:vtkRenderView) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHierarchicalGraphPipeline: ...
    def SetBundlingStrength(self, strength:float) -> None: ...
    def SetColorArrayName(self, name:str) -> None: ...
    def SetColorEdgesByArray(self, vis:bool) -> None: ...
    def SetHoverArrayName(self, _arg:str) -> None: ...
    def SetLabelArrayName(self, name:str) -> None: ...
    def SetLabelTextProperty(self, prop:vtkTextProperty) -> None: ...
    def SetLabelVisibility(self, vis:bool) -> None: ...
    def SetSplineType(self, type:int) -> None: ...
    def SetVisibility(self, vis:bool) -> None: ...
    def VisibilityOff(self) -> None: ...
    def VisibilityOn(self) -> None: ...

class vtkHierarchicalGraphView(vtkGraphLayoutView):
    def ColorGraphEdgesByArrayOff(self) -> None: ...
    def ColorGraphEdgesByArrayOn(self) -> None: ...
    def GetBundlingStrength(self) -> float: ...
    def GetColorGraphEdgesByArray(self) -> bool: ...
    def GetGraphEdgeColorArrayName(self) -> str: ...
    def GetGraphEdgeLabelArrayName(self) -> str: ...
    def GetGraphEdgeLabelFontSize(self) -> int: ...
    def GetGraphEdgeLabelVisibility(self) -> bool: ...
    def GetGraphVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GraphEdgeLabelVisibilityOff(self) -> None: ...
    def GraphEdgeLabelVisibilityOn(self) -> None: ...
    def GraphVisibilityOff(self) -> None: ...
    def GraphVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHierarchicalGraphView: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHierarchicalGraphView: ...
    def SetBundlingStrength(self, strength:float) -> None: ...
    def SetColorGraphEdgesByArray(self, vis:bool) -> None: ...
    def SetGraphEdgeColorArrayName(self, name:str) -> None: ...
    def SetGraphEdgeColorToSplineFraction(self) -> None: ...
    def SetGraphEdgeLabelArrayName(self, name:str) -> None: ...
    def SetGraphEdgeLabelFontSize(self, size:int) -> None: ...
    def SetGraphEdgeLabelVisibility(self, vis:bool) -> None: ...
    def SetGraphFromInput(self, input:vtkDataObject) -> vtkDataRepresentation: ...
    def SetGraphFromInputConnection(self, conn:vtkAlgorithmOutput) -> vtkDataRepresentation: ...
    def SetGraphVisibility(self, vis:bool) -> None: ...
    def SetHierarchyFromInput(self, input:vtkDataObject) -> vtkDataRepresentation: ...
    def SetHierarchyFromInputConnection(self, conn:vtkAlgorithmOutput) -> vtkDataRepresentation: ...

class vtkTreeAreaView(vtkRenderView):
    def AreaLabelVisibilityOff(self) -> None: ...
    def AreaLabelVisibilityOn(self) -> None: ...
    def ColorAreasOff(self) -> None: ...
    def ColorAreasOn(self) -> None: ...
    def ColorEdgesOff(self) -> None: ...
    def ColorEdgesOn(self) -> None: ...
    def EdgeLabelVisibilityOff(self) -> None: ...
    def EdgeLabelVisibilityOn(self) -> None: ...
    def GetAreaColorArrayName(self) -> str: ...
    def GetAreaHoverArrayName(self) -> str: ...
    def GetAreaLabelArrayName(self) -> str: ...
    def GetAreaLabelFontSize(self) -> int: ...
    def GetAreaLabelVisibility(self) -> bool: ...
    def GetAreaSizeArrayName(self) -> str: ...
    def GetBundlingStrength(self) -> float: ...
    def GetColorAreas(self) -> bool: ...
    def GetColorEdges(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeLabelArrayName(self) -> str: ...
    def GetEdgeLabelFontSize(self) -> int: ...
    def GetEdgeLabelVisibility(self) -> bool: ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    def GetLabelPriorityArrayName(self) -> str: ...
    def GetLayoutStrategy(self) -> vtkAreaLayoutStrategy: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkPercentage(self) -> float: ...
    def GetUseRectangularCoordinates(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTreeAreaView: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeAreaView: ...
    def SetAreaColorArrayName(self, name:str) -> None: ...
    def SetAreaHoverArrayName(self, name:str) -> None: ...
    def SetAreaLabelArrayName(self, name:str) -> None: ...
    def SetAreaLabelFontSize(self, size:int) -> None: ...
    def SetAreaLabelVisibility(self, vis:bool) -> None: ...
    def SetAreaSizeArrayName(self, name:str) -> None: ...
    def SetBundlingStrength(self, strength:float) -> None: ...
    def SetColorAreas(self, vis:bool) -> None: ...
    def SetColorEdges(self, vis:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeColorToSplineFraction(self) -> None: ...
    def SetEdgeLabelArrayName(self, name:str) -> None: ...
    def SetEdgeLabelFontSize(self, size:int) -> None: ...
    def SetEdgeLabelVisibility(self, vis:bool) -> None: ...
    def SetEdgeScalarBarVisibility(self, b:bool) -> None: ...
    def SetGraphFromInput(self, input:vtkGraph) -> vtkDataRepresentation: ...
    def SetGraphFromInputConnection(self, conn:vtkAlgorithmOutput) -> vtkDataRepresentation: ...
    def SetLabelPriorityArrayName(self, name:str) -> None: ...
    def SetLayoutStrategy(self, strategy:vtkAreaLayoutStrategy) -> None: ...
    def SetShrinkPercentage(self, value:float) -> None: ...
    def SetTreeFromInput(self, input:vtkTree) -> vtkDataRepresentation: ...
    def SetTreeFromInputConnection(self, conn:vtkAlgorithmOutput) -> vtkDataRepresentation: ...
    def SetUseRectangularCoordinates(self, rect:bool) -> None: ...
    def UseRectangularCoordinatesOff(self) -> None: ...
    def UseRectangularCoordinatesOn(self) -> None: ...

class vtkIcicleView(vtkTreeAreaView):
    def GetLayerThickness(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRootWidth(self) -> float: ...
    def GetTopToBottom(self) -> bool: ...
    def GetUseGradientColoring(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkIcicleView: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkIcicleView: ...
    def SetLayerThickness(self, thickness:float) -> None: ...
    def SetRootWidth(self, width:float) -> None: ...
    def SetTopToBottom(self, reversed:bool) -> None: ...
    def SetUseGradientColoring(self, value:bool) -> None: ...
    def TopToBottomOff(self) -> None: ...
    def TopToBottomOn(self) -> None: ...
    def UseGradientColoringOff(self) -> None: ...
    def UseGradientColoringOn(self) -> None: ...

class vtkInteractorStyleAreaSelectHover(vtkmodules.vtkInteractionStyle.vtkInteractorStyleRubberBand2D):
    def GetHighLightWidth(self) -> float: ...
    def GetIdAtPos(self, x:int, y:int) -> int: ...
    def GetLabelField(self) -> str: ...
    def GetLayout(self) -> vtkAreaLayout: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseRectangularCoordinates(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkInteractorStyleAreaSelectHover: ...
    def OnMouseMove(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkInteractorStyleAreaSelectHover: ...
    def SetHighLightColor(self, r:float, g:float, b:float) -> None: ...
    def SetHighLightWidth(self, lw:float) -> None: ...
    def SetInteractor(self, rwi:vtkRenderWindowInteractor) -> None: ...
    def SetLabelField(self, _arg:str) -> None: ...
    def SetLayout(self, layout:vtkAreaLayout) -> None: ...
    def SetUseRectangularCoordinates(self, _arg:bool) -> None: ...
    def UseRectangularCoordinatesOff(self) -> None: ...
    def UseRectangularCoordinatesOn(self) -> None: ...

class vtkInteractorStyleTreeMapHover(vtkmodules.vtkInteractionStyle.vtkInteractorStyleImage):
    def GetHighLightWidth(self) -> float: ...
    def GetLabelField(self) -> str: ...
    def GetLayout(self) -> vtkTreeMapLayout: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectionWidth(self) -> float: ...
    def GetTreeMapToPolyData(self) -> vtkTreeMapToPolyData: ...
    def HighLightCurrentSelectedItem(self) -> None: ...
    def HighLightItem(self, id:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkInteractorStyleTreeMapHover: ...
    def OnLeftButtonUp(self) -> None: ...
    def OnMouseMove(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkInteractorStyleTreeMapHover: ...
    def SetHighLightColor(self, r:float, g:float, b:float) -> None: ...
    def SetHighLightWidth(self, lw:float) -> None: ...
    def SetInteractor(self, rwi:vtkRenderWindowInteractor) -> None: ...
    def SetLabelField(self, _arg:str) -> None: ...
    def SetLayout(self, layout:vtkTreeMapLayout) -> None: ...
    def SetSelectionLightColor(self, r:float, g:float, b:float) -> None: ...
    def SetSelectionWidth(self, lw:float) -> None: ...
    def SetTreeMapToPolyData(self, filter:vtkTreeMapToPolyData) -> None: ...

class vtkRenderedRepresentation(vtkmodules.vtkViewsCore.vtkDataRepresentation):
    def GetLabelRenderMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderedRepresentation: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderedRepresentation: ...
    def SetLabelRenderMode(self, _arg:int) -> None: ...

class vtkParallelCoordinatesRepresentation(vtkRenderedRepresentation):
    class InputPorts(int): ...
    INPUT_DATA:'InputPorts'
    INPUT_TITLES:'InputPorts'
    NUM_INPUT_PORTS:'InputPorts'
    def AngleSelect(self, brushClass:int, brushOperator:int, p1:[float, ...], p2:[float, ...]) -> None: ...
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def FunctionSelect(self, brushClass:int, brushOperator:int, p1:[float, ...], p2:[float, ...], q1:[float, ...], q2:[float, ...]) -> None: ...
    def GetAngleBrushThreshold(self) -> float: ...
    def GetAxisColor(self) -> (float, float, float): ...
    def GetAxisLabelColor(self) -> (float, float, float): ...
    def GetCurveResolution(self) -> int: ...
    def GetFontSize(self) -> float: ...
    def GetFunctionBrushThreshold(self) -> float: ...
    def GetHoverString(self, view:vtkView, x:int, y:int) -> str: ...
    def GetLineColor(self) -> (float, float, float): ...
    def GetLineOpacity(self) -> float: ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfAxisLabels(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSamples(self) -> int: ...
    def GetPositionAndSize(self, position:[float, ...], size:[float, ...]) -> int: ...
    def GetPositionNearXCoordinate(self, xcoord:float) -> int: ...
    def GetRangeAtPosition(self, position:int, range:[float, float]) -> int: ...
    def GetUseCurves(self) -> int: ...
    def GetXCoordinateOfPosition(self, axis:int) -> float: ...
    def GetXCoordinatesOfPositions(self, coords:[float, ...]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LassoSelect(self, brushClass:int, brushOperator:int, brushPoints:vtkPoints) -> None: ...
    def NewInstance(self) -> vtkParallelCoordinatesRepresentation: ...
    def RangeSelect(self, brushClass:int, brushOperator:int, p1:[float, ...], p2:[float, ...]) -> None: ...
    def ResetAxes(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkParallelCoordinatesRepresentation: ...
    def SetAngleBrushThreshold(self, _arg:float) -> None: ...
    @overload
    def SetAxisColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisColor(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetAxisLabelColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisLabelColor(self, _arg:(float, float, float)) -> None: ...
    @overload
    def SetAxisTitles(self, __a:vtkStringArray) -> None: ...
    @overload
    def SetAxisTitles(self, __a:vtkAlgorithmOutput) -> None: ...
    def SetCurveResolution(self, _arg:int) -> None: ...
    def SetFontSize(self, _arg:float) -> None: ...
    def SetFunctionBrushThreshold(self, _arg:float) -> None: ...
    @overload
    def SetLineColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLineColor(self, _arg:(float, float, float)) -> None: ...
    def SetLineOpacity(self, _arg:float) -> None: ...
    def SetNumberOfAxisLabels(self, num:int) -> None: ...
    def SetPlotTitle(self, __a:str) -> None: ...
    def SetPositionAndSize(self, position:[float, ...], size:[float, ...]) -> int: ...
    def SetRangeAtPosition(self, position:int, range:[float, float]) -> int: ...
    def SetUseCurves(self, _arg:int) -> None: ...
    def SetXCoordinateOfPosition(self, position:int, xcoord:float) -> int: ...
    def SwapAxisPositions(self, position1:int, position2:int) -> int: ...
    def UseCurvesOff(self) -> None: ...
    def UseCurvesOn(self) -> None: ...

class vtkParallelCoordinatesHistogramRepresentation(vtkParallelCoordinatesRepresentation):
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def GetHistogramLookupTableRange(self) -> (float, float): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfHistogramBins(self) -> (int, int): ...
    def GetPreferredNumberOfOutliers(self) -> int: ...
    def GetShowOutliers(self) -> int: ...
    def GetUseHistograms(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkParallelCoordinatesHistogramRepresentation: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkParallelCoordinatesHistogramRepresentation: ...
    @overload
    def SetHistogramLookupTableRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetHistogramLookupTableRange(self, _arg:(float, float)) -> None: ...
    @overload
    def SetNumberOfHistogramBins(self, __a:int, __b:int) -> None: ...
    @overload
    def SetNumberOfHistogramBins(self, __a:[int, ...]) -> None: ...
    def SetPreferredNumberOfOutliers(self, __a:int) -> None: ...
    def SetRangeAtPosition(self, position:int, range:[float, float]) -> int: ...
    def SetShowOutliers(self, __a:int) -> None: ...
    def SetUseHistograms(self, __a:int) -> None: ...
    def ShowOutliersOff(self) -> None: ...
    def ShowOutliersOn(self) -> None: ...
    def SwapAxisPositions(self, position1:int, position2:int) -> int: ...
    def UseHistogramsOff(self) -> None: ...
    def UseHistogramsOn(self) -> None: ...

class vtkParallelCoordinatesView(vtkRenderView):
    VTK_BRUSHOPERATOR_ADD:int
    VTK_BRUSHOPERATOR_INTERSECT:int
    VTK_BRUSHOPERATOR_MODECOUNT:int
    VTK_BRUSHOPERATOR_REPLACE:int
    VTK_BRUSHOPERATOR_SUBTRACT:int
    VTK_BRUSH_ANGLE:int
    VTK_BRUSH_AXISTHRESHOLD:int
    VTK_BRUSH_FUNCTION:int
    VTK_BRUSH_LASSO:int
    VTK_BRUSH_MODECOUNT:int
    VTK_INSPECT_MANIPULATE_AXES:int
    VTK_INSPECT_MODECOUNT:int
    VTK_INSPECT_SELECT_DATA:int
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def GetBrushMode(self) -> int: ...
    def GetBrushOperator(self) -> int: ...
    def GetCurrentBrushClass(self) -> int: ...
    def GetInspectMode(self) -> int: ...
    def GetMaximumNumberOfBrushPoints(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkParallelCoordinatesView: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkParallelCoordinatesView: ...
    def SetBrushMode(self, __a:int) -> None: ...
    def SetBrushModeToAngle(self) -> None: ...
    def SetBrushModeToAxisThreshold(self) -> None: ...
    def SetBrushModeToFunction(self) -> None: ...
    def SetBrushModeToLasso(self) -> None: ...
    def SetBrushOperator(self, __a:int) -> None: ...
    def SetBrushOperatorToAdd(self) -> None: ...
    def SetBrushOperatorToIntersect(self) -> None: ...
    def SetBrushOperatorToReplace(self) -> None: ...
    def SetBrushOperatorToSubtract(self) -> None: ...
    def SetCurrentBrushClass(self, _arg:int) -> None: ...
    def SetInpsectModeToSelectData(self) -> None: ...
    def SetInspectMode(self, __a:int) -> None: ...
    def SetInspectModeToManipulateAxes(self) -> None: ...
    def SetMaximumNumberOfBrushPoints(self, __a:int) -> None: ...

class vtkRenderedGraphRepresentation(vtkRenderedRepresentation):
    def AddEdgeIconType(self, name:str, type:int) -> None: ...
    def AddVertexIconType(self, name:str, type:int) -> None: ...
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def ClearEdgeIconTypes(self) -> None: ...
    def ClearVertexIconTypes(self) -> None: ...
    def ColorEdgesByArrayOff(self) -> None: ...
    def ColorEdgesByArrayOn(self) -> None: ...
    def ColorVerticesByArrayOff(self) -> None: ...
    def ColorVerticesByArrayOn(self) -> None: ...
    def ComputeSelectedGraphBounds(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def EdgeIconVisibilityOff(self) -> None: ...
    def EdgeIconVisibilityOn(self) -> None: ...
    def EdgeLabelVisibilityOff(self) -> None: ...
    def EdgeLabelVisibilityOn(self) -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def EnableEdgesByArrayOff(self) -> None: ...
    def EnableEdgesByArrayOn(self) -> None: ...
    def EnableVerticesByArrayOff(self) -> None: ...
    def EnableVerticesByArrayOn(self) -> None: ...
    def GetColorEdgesByArray(self) -> bool: ...
    def GetColorVerticesByArray(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeHoverArrayName(self) -> str: ...
    def GetEdgeIconAlignment(self) -> int: ...
    def GetEdgeIconArrayName(self) -> str: ...
    def GetEdgeIconPriorityArrayName(self) -> str: ...
    def GetEdgeIconVisibility(self) -> bool: ...
    def GetEdgeLabelArrayName(self) -> str: ...
    def GetEdgeLabelPriorityArrayName(self) -> str: ...
    def GetEdgeLabelTextProperty(self) -> vtkTextProperty: ...
    def GetEdgeLabelVisibility(self) -> bool: ...
    def GetEdgeLayoutStrategy(self) -> vtkEdgeLayoutStrategy: ...
    def GetEdgeLayoutStrategyName(self) -> str: ...
    def GetEdgeScalarBar(self) -> vtkScalarBarWidget: ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    def GetEdgeSelection(self) -> bool: ...
    def GetEdgeVisibility(self) -> bool: ...
    def GetEnableEdgesByArray(self) -> bool: ...
    def GetEnableVerticesByArray(self) -> bool: ...
    def GetEnabledEdgesArrayName(self) -> str: ...
    def GetEnabledVerticesArrayName(self) -> str: ...
    def GetGlyphType(self) -> int: ...
    def GetHideEdgeLabelsOnInteraction(self) -> bool: ...
    def GetHideVertexLabelsOnInteraction(self) -> bool: ...
    def GetLayoutStrategy(self) -> vtkGraphLayoutStrategy: ...
    def GetLayoutStrategyName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaling(self) -> bool: ...
    def GetScalingArrayName(self) -> str: ...
    def GetUseEdgeIconTypeMap(self) -> bool: ...
    def GetUseVertexIconTypeMap(self) -> bool: ...
    def GetVertexColorArrayName(self) -> str: ...
    def GetVertexDefaultIcon(self) -> int: ...
    def GetVertexHoverArrayName(self) -> str: ...
    def GetVertexIconAlignment(self) -> int: ...
    def GetVertexIconArrayName(self) -> str: ...
    def GetVertexIconPriorityArrayName(self) -> str: ...
    def GetVertexIconSelectionMode(self) -> int: ...
    def GetVertexIconVisibility(self) -> bool: ...
    def GetVertexLabelArrayName(self) -> str: ...
    def GetVertexLabelPriorityArrayName(self) -> str: ...
    def GetVertexLabelTextProperty(self) -> vtkTextProperty: ...
    def GetVertexLabelVisibility(self) -> bool: ...
    def GetVertexScalarBar(self) -> vtkScalarBarWidget: ...
    def GetVertexScalarBarVisibility(self) -> bool: ...
    def GetVertexSelectedIcon(self) -> int: ...
    def HideEdgeLabelsOnInteractionOff(self) -> None: ...
    def HideEdgeLabelsOnInteractionOn(self) -> None: ...
    def HideVertexLabelsOnInteractionOff(self) -> None: ...
    def HideVertexLabelsOnInteractionOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderedGraphRepresentation: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderedGraphRepresentation: ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetColorEdgesByArray(self, b:bool) -> None: ...
    def SetColorVerticesByArray(self, b:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeHoverArrayName(self, _arg:str) -> None: ...
    def SetEdgeIconAlignment(self, align:int) -> None: ...
    def SetEdgeIconArrayName(self, name:str) -> None: ...
    def SetEdgeIconPriorityArrayName(self, name:str) -> None: ...
    def SetEdgeIconVisibility(self, b:bool) -> None: ...
    def SetEdgeLabelArrayName(self, name:str) -> None: ...
    def SetEdgeLabelPriorityArrayName(self, name:str) -> None: ...
    def SetEdgeLabelTextProperty(self, p:vtkTextProperty) -> None: ...
    def SetEdgeLabelVisibility(self, b:bool) -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, strategy:vtkEdgeLayoutStrategy) -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, name:str) -> None: ...
    def SetEdgeLayoutStrategyToArcParallel(self) -> None: ...
    def SetEdgeLayoutStrategyToGeo(self, explodeFactor:float=0.2) -> None: ...
    def SetEdgeLayoutStrategyToPassThrough(self) -> None: ...
    def SetEdgeScalarBarVisibility(self, b:bool) -> None: ...
    def SetEdgeSelection(self, b:bool) -> None: ...
    def SetEdgeVisibility(self, b:bool) -> None: ...
    def SetEnableEdgesByArray(self, b:bool) -> None: ...
    def SetEnableVerticesByArray(self, b:bool) -> None: ...
    def SetEnabledEdgesArrayName(self, name:str) -> None: ...
    def SetEnabledVerticesArrayName(self, name:str) -> None: ...
    def SetGlyphType(self, type:int) -> None: ...
    def SetHideEdgeLabelsOnInteraction(self, _arg:bool) -> None: ...
    def SetHideVertexLabelsOnInteraction(self, _arg:bool) -> None: ...
    @overload
    def SetLayoutStrategy(self, strategy:vtkGraphLayoutStrategy) -> None: ...
    @overload
    def SetLayoutStrategy(self, name:str) -> None: ...
    def SetLayoutStrategyToAssignCoordinates(self, xarr:str, yarr:str=..., zarr:str=...) -> None: ...
    def SetLayoutStrategyToCircular(self) -> None: ...
    def SetLayoutStrategyToClustering2D(self) -> None: ...
    def SetLayoutStrategyToCommunity2D(self) -> None: ...
    def SetLayoutStrategyToCone(self) -> None: ...
    @overload
    def SetLayoutStrategyToCosmicTree(self) -> None: ...
    @overload
    def SetLayoutStrategyToCosmicTree(self, nodeSizeArrayName:str, sizeLeafNodesOnly:bool=True, layoutDepth:int=0, layoutRoot:int=-1) -> None: ...
    def SetLayoutStrategyToFast2D(self) -> None: ...
    def SetLayoutStrategyToForceDirected(self) -> None: ...
    def SetLayoutStrategyToPassThrough(self) -> None: ...
    def SetLayoutStrategyToRandom(self) -> None: ...
    def SetLayoutStrategyToSimple2D(self) -> None: ...
    def SetLayoutStrategyToSpanTree(self) -> None: ...
    @overload
    def SetLayoutStrategyToTree(self) -> None: ...
    @overload
    def SetLayoutStrategyToTree(self, radial:bool, angle:float=90, leafSpacing:float=0.9, logSpacing:float=1.0) -> None: ...
    def SetScaling(self, b:bool) -> None: ...
    def SetScalingArrayName(self, name:str) -> None: ...
    def SetUseEdgeIconTypeMap(self, b:bool) -> None: ...
    def SetUseVertexIconTypeMap(self, b:bool) -> None: ...
    def SetVertexColorArrayName(self, name:str) -> None: ...
    def SetVertexDefaultIcon(self, icon:int) -> None: ...
    def SetVertexHoverArrayName(self, _arg:str) -> None: ...
    def SetVertexIconAlignment(self, align:int) -> None: ...
    def SetVertexIconArrayName(self, name:str) -> None: ...
    def SetVertexIconPriorityArrayName(self, name:str) -> None: ...
    def SetVertexIconSelectionMode(self, mode:int) -> None: ...
    def SetVertexIconSelectionModeToAnnotationIcon(self) -> None: ...
    def SetVertexIconSelectionModeToIgnoreSelection(self) -> None: ...
    def SetVertexIconSelectionModeToSelectedIcon(self) -> None: ...
    def SetVertexIconSelectionModeToSelectedOffset(self) -> None: ...
    def SetVertexIconVisibility(self, b:bool) -> None: ...
    def SetVertexLabelArrayName(self, name:str) -> None: ...
    def SetVertexLabelPriorityArrayName(self, name:str) -> None: ...
    def SetVertexLabelTextProperty(self, p:vtkTextProperty) -> None: ...
    def SetVertexLabelVisibility(self, b:bool) -> None: ...
    def SetVertexScalarBarVisibility(self, b:bool) -> None: ...
    def SetVertexSelectedIcon(self, icon:int) -> None: ...
    def UpdateLayout(self) -> None: ...
    def UseEdgeIconTypeMapOff(self) -> None: ...
    def UseEdgeIconTypeMapOn(self) -> None: ...
    def UseVertexIconTypeMapOff(self) -> None: ...
    def UseVertexIconTypeMapOn(self) -> None: ...
    def VertexIconVisibilityOff(self) -> None: ...
    def VertexIconVisibilityOn(self) -> None: ...
    def VertexLabelVisibilityOff(self) -> None: ...
    def VertexLabelVisibilityOn(self) -> None: ...

class vtkRenderedHierarchyRepresentation(vtkRenderedGraphRepresentation):
    def ColorGraphEdgesByArrayOff(self) -> None: ...
    def ColorGraphEdgesByArrayOn(self) -> None: ...
    @overload
    def GetBundlingStrength(self) -> float: ...
    @overload
    def GetBundlingStrength(self, idx:int) -> float: ...
    @overload
    def GetColorGraphEdgesByArray(self) -> bool: ...
    @overload
    def GetColorGraphEdgesByArray(self, idx:int) -> bool: ...
    @overload
    def GetGraphEdgeColorArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeColorArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelFontSize(self) -> int: ...
    @overload
    def GetGraphEdgeLabelFontSize(self, idx:int) -> int: ...
    @overload
    def GetGraphEdgeLabelVisibility(self) -> bool: ...
    @overload
    def GetGraphEdgeLabelVisibility(self, idx:int) -> bool: ...
    def GetGraphSplineType(self, idx:int) -> int: ...
    @overload
    def GetGraphVisibility(self) -> bool: ...
    @overload
    def GetGraphVisibility(self, idx:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GraphEdgeLabelVisibilityOff(self) -> None: ...
    def GraphEdgeLabelVisibilityOn(self) -> None: ...
    def GraphVisibilityOff(self) -> None: ...
    def GraphVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderedHierarchyRepresentation: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderedHierarchyRepresentation: ...
    @overload
    def SetBundlingStrength(self, strength:float) -> None: ...
    @overload
    def SetBundlingStrength(self, strength:float, idx:int) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelFontSize(self, size:int) -> None: ...
    @overload
    def SetGraphEdgeLabelFontSize(self, size:int, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool, idx:int) -> None: ...
    def SetGraphSplineType(self, type:int, idx:int) -> None: ...
    @overload
    def SetGraphVisibility(self, vis:bool) -> None: ...
    @overload
    def SetGraphVisibility(self, vis:bool, idx:int) -> None: ...

class vtkRenderedSurfaceRepresentation(vtkRenderedRepresentation):
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def GetCellColorArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderedSurfaceRepresentation: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderedSurfaceRepresentation: ...
    def SetCellColorArrayName(self, arrayName:str) -> None: ...

class vtkRenderedTreeAreaRepresentation(vtkRenderedRepresentation):
    def ApplyViewTheme(self, theme:vtkViewTheme) -> None: ...
    def AreaLabelVisibilityOff(self) -> None: ...
    def AreaLabelVisibilityOn(self) -> None: ...
    def ColorAreasByArrayOff(self) -> None: ...
    def ColorAreasByArrayOn(self) -> None: ...
    def ColorGraphEdgesByArrayOff(self) -> None: ...
    def ColorGraphEdgesByArrayOn(self) -> None: ...
    def GetAreaColorArrayName(self) -> str: ...
    def GetAreaHoverArrayName(self) -> str: ...
    def GetAreaLabelArrayName(self) -> str: ...
    def GetAreaLabelMapper(self) -> vtkLabeledDataMapper: ...
    def GetAreaLabelPriorityArrayName(self) -> str: ...
    def GetAreaLabelTextProperty(self) -> vtkTextProperty: ...
    def GetAreaLabelVisibility(self) -> bool: ...
    def GetAreaLayoutStrategy(self) -> vtkAreaLayoutStrategy: ...
    def GetAreaSizeArrayName(self) -> str: ...
    def GetAreaToPolyData(self) -> vtkPolyDataAlgorithm: ...
    def GetColorAreasByArray(self) -> bool: ...
    @overload
    def GetColorGraphEdgesByArray(self) -> bool: ...
    @overload
    def GetColorGraphEdgesByArray(self, idx:int) -> bool: ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    @overload
    def GetGraphBundlingStrength(self) -> float: ...
    @overload
    def GetGraphBundlingStrength(self, idx:int) -> float: ...
    @overload
    def GetGraphEdgeColorArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeColorArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelTextProperty(self) -> vtkTextProperty: ...
    @overload
    def GetGraphEdgeLabelTextProperty(self, idx:int) -> vtkTextProperty: ...
    @overload
    def GetGraphEdgeLabelVisibility(self) -> bool: ...
    @overload
    def GetGraphEdgeLabelVisibility(self, idx:int) -> bool: ...
    @overload
    def GetGraphHoverArrayName(self) -> str: ...
    @overload
    def GetGraphHoverArrayName(self, idx:int) -> str: ...
    def GetGraphSplineType(self, idx:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkPercentage(self) -> float: ...
    def GetUseRectangularCoordinates(self) -> bool: ...
    def GraphEdgeLabelVisibilityOff(self) -> None: ...
    def GraphEdgeLabelVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRenderedTreeAreaRepresentation: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRenderedTreeAreaRepresentation: ...
    def SetAreaColorArrayName(self, name:str) -> None: ...
    def SetAreaHoverArrayName(self, _arg:str) -> None: ...
    def SetAreaLabelArrayName(self, name:str) -> None: ...
    def SetAreaLabelMapper(self, mapper:vtkLabeledDataMapper) -> None: ...
    def SetAreaLabelPriorityArrayName(self, name:str) -> None: ...
    def SetAreaLabelTextProperty(self, tp:vtkTextProperty) -> None: ...
    def SetAreaLabelVisibility(self, vis:bool) -> None: ...
    def SetAreaLayoutStrategy(self, strategy:vtkAreaLayoutStrategy) -> None: ...
    def SetAreaSizeArrayName(self, name:str) -> None: ...
    def SetAreaToPolyData(self, areaToPoly:vtkPolyDataAlgorithm) -> None: ...
    def SetColorAreasByArray(self, vis:bool) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool, idx:int) -> None: ...
    def SetEdgeScalarBarVisibility(self, b:bool) -> None: ...
    @overload
    def SetGraphBundlingStrength(self, strength:float) -> None: ...
    @overload
    def SetGraphBundlingStrength(self, strength:float, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelTextProperty(self, tp:vtkTextProperty) -> None: ...
    @overload
    def SetGraphEdgeLabelTextProperty(self, tp:vtkTextProperty, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool, idx:int) -> None: ...
    @overload
    def SetGraphHoverArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphHoverArrayName(self, name:str, idx:int) -> None: ...
    def SetGraphSplineType(self, type:int, idx:int) -> None: ...
    def SetLabelRenderMode(self, mode:int) -> None: ...
    def SetShrinkPercentage(self, value:float) -> None: ...
    def SetUseRectangularCoordinates(self, _arg:bool) -> None: ...
    def UseRectangularCoordinatesOff(self) -> None: ...
    def UseRectangularCoordinatesOn(self) -> None: ...

class vtkSCurveSpline(vtkmodules.vtkCommonDataModel.vtkSpline):
    def Compute(self) -> None: ...
    def DeepCopy(self, s:vtkSpline) -> None: ...
    def Evaluate(self, t:float) -> float: ...
    def GetNodeWeight(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSCurveSpline: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSCurveSpline: ...
    def SetNodeWeight(self, _arg:float) -> None: ...

class vtkTanglegramItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    def GetCorrespondenceLineWidth(self) -> float: ...
    def GetLabelSizeDifference(self) -> int: ...
    def GetMinimumVisibleFontSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetTable(self) -> vtkTable: ...
    def GetTree1Label(self) -> str: ...
    def GetTree2Label(self) -> str: ...
    def GetTreeLineWidth(self) -> float: ...
    def Hit(self, mouse:vtkContextMouseEvent) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseDoubleClickEvent(self, event:vtkContextMouseEvent) -> bool: ...
    def NewInstance(self) -> vtkTanglegramItem: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTanglegramItem: ...
    def SetCorrespondenceLineWidth(self, _arg:float) -> None: ...
    def SetLabelSizeDifference(self, _arg:int) -> None: ...
    def SetMinimumVisibleFontSize(self, _arg:int) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    def SetTable(self, table:vtkTable) -> None: ...
    def SetTree1(self, tree:vtkTree) -> None: ...
    def SetTree1Label(self, _arg:str) -> None: ...
    def SetTree2(self, tree:vtkTree) -> None: ...
    def SetTree2Label(self, _arg:str) -> None: ...
    def SetTreeLineWidth(self, width:float) -> None: ...

class vtkTreeHeatmapItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    def CollapseToNumberOfLeafNodes(self, n:int) -> None: ...
    def GetBounds(self, bounds:[float, float, float, float]) -> None: ...
    def GetCenter(self, center:[float, float]) -> None: ...
    def GetColumnTree(self) -> vtkTree: ...
    def GetDendrogram(self) -> vtkDendrogramItem: ...
    def GetHeatmap(self) -> vtkHeatmapItem: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPrunedTree(self) -> vtkTree: ...
    def GetSize(self, size:[float, float]) -> None: ...
    def GetTable(self) -> vtkTable: ...
    def GetTree(self) -> vtkTree: ...
    def GetTreeLineWidth(self) -> float: ...
    def Hit(self, mouse:vtkContextMouseEvent) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseDoubleClickEvent(self, event:vtkContextMouseEvent) -> bool: ...
    def NewInstance(self) -> vtkTreeHeatmapItem: ...
    def ReorderTable(self) -> None: ...
    def ReverseTableColumns(self) -> None: ...
    def ReverseTableRows(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeHeatmapItem: ...
    def SetColumnTree(self, tree:vtkTree) -> None: ...
    def SetDendrogram(self, dendrogram:vtkDendrogramItem) -> None: ...
    def SetHeatmap(self, heatmap:vtkHeatmapItem) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    def SetTable(self, table:vtkTable) -> None: ...
    def SetTree(self, tree:vtkTree) -> None: ...
    def SetTreeColorArray(self, arrayName:str) -> None: ...
    def SetTreeLineWidth(self, width:float) -> None: ...

class vtkTreeMapView(vtkTreeAreaView):
    def GetFontSizeRange(self, range:[int, int, int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTreeMapView: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeMapView: ...
    def SetFontSizeRange(self, maxSize:int, minSize:int, delta:int=4) -> None: ...
    @overload
    def SetLayoutStrategy(self, s:vtkAreaLayoutStrategy) -> None: ...
    @overload
    def SetLayoutStrategy(self, name:str) -> None: ...
    def SetLayoutStrategyToBox(self) -> None: ...
    def SetLayoutStrategyToSliceAndDice(self) -> None: ...
    def SetLayoutStrategyToSquarify(self) -> None: ...

class vtkTreeRingView(vtkTreeAreaView):
    def GetInteriorLogSpacingValue(self) -> float: ...
    def GetInteriorRadius(self) -> float: ...
    def GetLayerThickness(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRootAtCenter(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkTreeRingView: ...
    def RootAtCenterOff(self) -> None: ...
    def RootAtCenterOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkTreeRingView: ...
    def SetInteriorLogSpacingValue(self, value:float) -> None: ...
    def SetInteriorRadius(self, rad:float) -> None: ...
    def SetLayerThickness(self, thickness:float) -> None: ...
    def SetRootAngles(self, start:float, end:float) -> None: ...
    def SetRootAtCenter(self, center:bool) -> None: ...

class vtkViewUpdater(vtkmodules.vtkCommonCore.vtkObject):
    def AddAnnotationLink(self, link:vtkAnnotationLink) -> None: ...
    def AddView(self, view:vtkView) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkViewUpdater: ...
    def RemoveView(self, view:vtkView) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkViewUpdater: ...

