# encoding: utf-8
#
# Autogenerated by Thrift Compiler (0.9.2)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
import sds.common.BaseService
from .ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(sds.common.BaseService.Iface):
  """
  结构化存储管理接口
  """
  def saveAppInfo(self, appInfo):
    """
    保存应用信息，用于注册第三方应用OAuth信息

    Parameters:
     - appInfo
    """
    pass

  def getAppInfo(self, appId):
    """
    查询应用信息

    Parameters:
     - appId
    """
    pass

  def findAllApps(self):
    """
    查询指定用户所有应用信息
    """
    pass

  def findAllTables(self):
    """
    获取指定用户所有表信息
    """
    pass

  def createTable(self, tableName, tableSpec):
    """
    创建表

    Parameters:
     - tableName
     - tableSpec
    """
    pass

  def dropTable(self, tableName):
    """
    删除表

    Parameters:
     - tableName
    """
    pass

  def alterTable(self, tableName, tableSpec):
    """
    修改表

    Parameters:
     - tableName
     - tableSpec
    """
    pass

  def cloneTable(self, srcName, destTable, flushTable):
    """
    克隆表

    Parameters:
     - srcName
     - destTable
     - flushTable
    """
    pass

  def disableTable(self, tableName):
    """
    关闭表读写操作

    Parameters:
     - tableName
    """
    pass

  def enableTable(self, tableName):
    """
    打开表读写操作

    Parameters:
     - tableName
    """
    pass

  def describeTable(self, tableName):
    """
    获取表定义

    Parameters:
     - tableName
    """
    pass

  def getTableStatus(self, tableName):
    """
    获取表状态等元信息

    Parameters:
     - tableName
    """
    pass

  def getTableState(self, tableName):
    """
    获取表状态

    Parameters:
     - tableName
    """
    pass

  def getTableSplits(self, tableName, startKey, stopKey):
    """
    获取表分布信息，如用于MapReduce应用

    Parameters:
     - tableName
     - startKey
     - stopKey
    """
    pass

  def queryMetric(self, query):
    """
    查询表统计指标

    Parameters:
     - query
    """
    pass

  def queryMetrics(self, queries):
    """
    批量查询表统计指标

    Parameters:
     - queries
    """
    pass

  def findAllAppInfo(self):
    """
    获取AppInfo列表,只包括appId和appName
    """
    pass

  def getTableSize(self, tableName):
    """
    获取表空间大小

    Parameters:
     - tableName
    """
    pass

  def putClientMetrics(self, clientMetrics):
    """
    上传客户端metrics

    Parameters:
     - clientMetrics
    """
    pass

  def subscribePhoneAlert(self, phoneNumber):
    """
    添加关注电话

    Parameters:
     - phoneNumber
    """
    pass

  def unsubscribePhoneAlert(self, phoneNumber):
    """
    取消关注电话

    Parameters:
     - phoneNumber
    """
    pass

  def subscribeEmailAlert(self, email):
    """
    添加关注邮箱

    Parameters:
     - email
    """
    pass

  def unsubscribeEmailAlert(self, email):
    """
    取消关注邮箱

    Parameters:
     - email
    """
    pass

  def listSubscribedPhone(self):
    """
    查看所有关注电话
    """
    pass

  def listSubscribedEmail(self):
    """
    查看所有关注邮箱地址
    """
    pass

  def getTableHistorySize(self, tableName, startDate, stopDate):
    """
    获取表空间历史大小

    Parameters:
     - tableName
     - startDate
     - stopDate
    """
    pass

  def renameTable(self, srcName, destName):
    """
    表重命名

    Parameters:
     - srcName
     - destName
    """
    pass

  def listSnapshots(self, tableName):
    """
    查询表的所有snapshot

    Parameters:
     - tableName
    """
    pass

  def snapshotTable(self, tableName, snapshotName):
    """
    生成表快照

    Parameters:
     - tableName
     - snapshotName
    """
    pass

  def deleteSnapshot(self, tableName, snapshotName):
    """
    删除某个快照

    Parameters:
     - tableName
     - snapshotName
    """
    pass

  def restoreSnapshot(self, tableName, snapshotName, destTableName, isSystem):
    """
    从快照恢复表

    Parameters:
     - tableName
     - snapshotName
     - destTableName
     - isSystem
    """
    pass

  def listAllSnapshots(self):
    """
    列出用户的所有表快照
    """
    pass

  def cancelSnapshotTable(self, tableName, snapshotName):
    """
    取消生成快照

    Parameters:
     - tableName
     - snapshotName
    """
    pass

  def getSnapshotState(self, tableName, snapshotName):
    """
    查询快照状态

    Parameters:
     - tableName
     - snapshotName
    """
    pass

  def getQuotaInfo(self):
    """
    查询用户各种quota的使用情况
    """
    pass


class Client(sds.common.BaseService.Client, Iface):
  """
  结构化存储管理接口
  """
  def __init__(self, iprot, oprot=None):
    sds.common.BaseService.Client.__init__(self, iprot, oprot)

  def saveAppInfo(self, appInfo):
    """
    保存应用信息，用于注册第三方应用OAuth信息

    Parameters:
     - appInfo
    """
    self.send_saveAppInfo(appInfo)
    self.recv_saveAppInfo()

  def send_saveAppInfo(self, appInfo):
    self._oprot.writeMessageBegin('saveAppInfo', TMessageType.CALL, self._seqid)
    args = saveAppInfo_args()
    args.appInfo = appInfo
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_saveAppInfo(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = saveAppInfo_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def getAppInfo(self, appId):
    """
    查询应用信息

    Parameters:
     - appId
    """
    self.send_getAppInfo(appId)
    return self.recv_getAppInfo()

  def send_getAppInfo(self, appId):
    self._oprot.writeMessageBegin('getAppInfo', TMessageType.CALL, self._seqid)
    args = getAppInfo_args()
    args.appId = appId
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getAppInfo(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getAppInfo_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getAppInfo failed: unknown result");

  def findAllApps(self):
    """
    查询指定用户所有应用信息
    """
    self.send_findAllApps()
    return self.recv_findAllApps()

  def send_findAllApps(self):
    self._oprot.writeMessageBegin('findAllApps', TMessageType.CALL, self._seqid)
    args = findAllApps_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findAllApps(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = findAllApps_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findAllApps failed: unknown result");

  def findAllTables(self):
    """
    获取指定用户所有表信息
    """
    self.send_findAllTables()
    return self.recv_findAllTables()

  def send_findAllTables(self):
    self._oprot.writeMessageBegin('findAllTables', TMessageType.CALL, self._seqid)
    args = findAllTables_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findAllTables(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = findAllTables_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findAllTables failed: unknown result");

  def createTable(self, tableName, tableSpec):
    """
    创建表

    Parameters:
     - tableName
     - tableSpec
    """
    self.send_createTable(tableName, tableSpec)
    return self.recv_createTable()

  def send_createTable(self, tableName, tableSpec):
    self._oprot.writeMessageBegin('createTable', TMessageType.CALL, self._seqid)
    args = createTable_args()
    args.tableName = tableName
    args.tableSpec = tableSpec
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = createTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "createTable failed: unknown result");

  def dropTable(self, tableName):
    """
    删除表

    Parameters:
     - tableName
    """
    self.send_dropTable(tableName)
    self.recv_dropTable()

  def send_dropTable(self, tableName):
    self._oprot.writeMessageBegin('dropTable', TMessageType.CALL, self._seqid)
    args = dropTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_dropTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = dropTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def alterTable(self, tableName, tableSpec):
    """
    修改表

    Parameters:
     - tableName
     - tableSpec
    """
    self.send_alterTable(tableName, tableSpec)
    self.recv_alterTable()

  def send_alterTable(self, tableName, tableSpec):
    self._oprot.writeMessageBegin('alterTable', TMessageType.CALL, self._seqid)
    args = alterTable_args()
    args.tableName = tableName
    args.tableSpec = tableSpec
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_alterTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = alterTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def cloneTable(self, srcName, destTable, flushTable):
    """
    克隆表

    Parameters:
     - srcName
     - destTable
     - flushTable
    """
    self.send_cloneTable(srcName, destTable, flushTable)
    self.recv_cloneTable()

  def send_cloneTable(self, srcName, destTable, flushTable):
    self._oprot.writeMessageBegin('cloneTable', TMessageType.CALL, self._seqid)
    args = cloneTable_args()
    args.srcName = srcName
    args.destTable = destTable
    args.flushTable = flushTable
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_cloneTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = cloneTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def disableTable(self, tableName):
    """
    关闭表读写操作

    Parameters:
     - tableName
    """
    self.send_disableTable(tableName)
    self.recv_disableTable()

  def send_disableTable(self, tableName):
    self._oprot.writeMessageBegin('disableTable', TMessageType.CALL, self._seqid)
    args = disableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_disableTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = disableTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def enableTable(self, tableName):
    """
    打开表读写操作

    Parameters:
     - tableName
    """
    self.send_enableTable(tableName)
    self.recv_enableTable()

  def send_enableTable(self, tableName):
    self._oprot.writeMessageBegin('enableTable', TMessageType.CALL, self._seqid)
    args = enableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_enableTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = enableTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def describeTable(self, tableName):
    """
    获取表定义

    Parameters:
     - tableName
    """
    self.send_describeTable(tableName)
    return self.recv_describeTable()

  def send_describeTable(self, tableName):
    self._oprot.writeMessageBegin('describeTable', TMessageType.CALL, self._seqid)
    args = describeTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_describeTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = describeTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "describeTable failed: unknown result");

  def getTableStatus(self, tableName):
    """
    获取表状态等元信息

    Parameters:
     - tableName
    """
    self.send_getTableStatus(tableName)
    return self.recv_getTableStatus()

  def send_getTableStatus(self, tableName):
    self._oprot.writeMessageBegin('getTableStatus', TMessageType.CALL, self._seqid)
    args = getTableStatus_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableStatus(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getTableStatus_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableStatus failed: unknown result");

  def getTableState(self, tableName):
    """
    获取表状态

    Parameters:
     - tableName
    """
    self.send_getTableState(tableName)
    return self.recv_getTableState()

  def send_getTableState(self, tableName):
    self._oprot.writeMessageBegin('getTableState', TMessageType.CALL, self._seqid)
    args = getTableState_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableState(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getTableState_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableState failed: unknown result");

  def getTableSplits(self, tableName, startKey, stopKey):
    """
    获取表分布信息，如用于MapReduce应用

    Parameters:
     - tableName
     - startKey
     - stopKey
    """
    self.send_getTableSplits(tableName, startKey, stopKey)
    return self.recv_getTableSplits()

  def send_getTableSplits(self, tableName, startKey, stopKey):
    self._oprot.writeMessageBegin('getTableSplits', TMessageType.CALL, self._seqid)
    args = getTableSplits_args()
    args.tableName = tableName
    args.startKey = startKey
    args.stopKey = stopKey
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableSplits(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getTableSplits_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableSplits failed: unknown result");

  def queryMetric(self, query):
    """
    查询表统计指标

    Parameters:
     - query
    """
    self.send_queryMetric(query)
    return self.recv_queryMetric()

  def send_queryMetric(self, query):
    self._oprot.writeMessageBegin('queryMetric', TMessageType.CALL, self._seqid)
    args = queryMetric_args()
    args.query = query
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_queryMetric(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = queryMetric_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "queryMetric failed: unknown result");

  def queryMetrics(self, queries):
    """
    批量查询表统计指标

    Parameters:
     - queries
    """
    self.send_queryMetrics(queries)
    return self.recv_queryMetrics()

  def send_queryMetrics(self, queries):
    self._oprot.writeMessageBegin('queryMetrics', TMessageType.CALL, self._seqid)
    args = queryMetrics_args()
    args.queries = queries
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_queryMetrics(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = queryMetrics_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "queryMetrics failed: unknown result");

  def findAllAppInfo(self):
    """
    获取AppInfo列表,只包括appId和appName
    """
    self.send_findAllAppInfo()
    return self.recv_findAllAppInfo()

  def send_findAllAppInfo(self):
    self._oprot.writeMessageBegin('findAllAppInfo', TMessageType.CALL, self._seqid)
    args = findAllAppInfo_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findAllAppInfo(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = findAllAppInfo_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findAllAppInfo failed: unknown result");

  def getTableSize(self, tableName):
    """
    获取表空间大小

    Parameters:
     - tableName
    """
    self.send_getTableSize(tableName)
    return self.recv_getTableSize()

  def send_getTableSize(self, tableName):
    self._oprot.writeMessageBegin('getTableSize', TMessageType.CALL, self._seqid)
    args = getTableSize_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableSize(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getTableSize_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableSize failed: unknown result");

  def putClientMetrics(self, clientMetrics):
    """
    上传客户端metrics

    Parameters:
     - clientMetrics
    """
    self.send_putClientMetrics(clientMetrics)
    self.recv_putClientMetrics()

  def send_putClientMetrics(self, clientMetrics):
    self._oprot.writeMessageBegin('putClientMetrics', TMessageType.CALL, self._seqid)
    args = putClientMetrics_args()
    args.clientMetrics = clientMetrics
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_putClientMetrics(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = putClientMetrics_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def subscribePhoneAlert(self, phoneNumber):
    """
    添加关注电话

    Parameters:
     - phoneNumber
    """
    self.send_subscribePhoneAlert(phoneNumber)
    self.recv_subscribePhoneAlert()

  def send_subscribePhoneAlert(self, phoneNumber):
    self._oprot.writeMessageBegin('subscribePhoneAlert', TMessageType.CALL, self._seqid)
    args = subscribePhoneAlert_args()
    args.phoneNumber = phoneNumber
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_subscribePhoneAlert(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = subscribePhoneAlert_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def unsubscribePhoneAlert(self, phoneNumber):
    """
    取消关注电话

    Parameters:
     - phoneNumber
    """
    self.send_unsubscribePhoneAlert(phoneNumber)
    self.recv_unsubscribePhoneAlert()

  def send_unsubscribePhoneAlert(self, phoneNumber):
    self._oprot.writeMessageBegin('unsubscribePhoneAlert', TMessageType.CALL, self._seqid)
    args = unsubscribePhoneAlert_args()
    args.phoneNumber = phoneNumber
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_unsubscribePhoneAlert(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = unsubscribePhoneAlert_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def subscribeEmailAlert(self, email):
    """
    添加关注邮箱

    Parameters:
     - email
    """
    self.send_subscribeEmailAlert(email)
    self.recv_subscribeEmailAlert()

  def send_subscribeEmailAlert(self, email):
    self._oprot.writeMessageBegin('subscribeEmailAlert', TMessageType.CALL, self._seqid)
    args = subscribeEmailAlert_args()
    args.email = email
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_subscribeEmailAlert(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = subscribeEmailAlert_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def unsubscribeEmailAlert(self, email):
    """
    取消关注邮箱

    Parameters:
     - email
    """
    self.send_unsubscribeEmailAlert(email)
    self.recv_unsubscribeEmailAlert()

  def send_unsubscribeEmailAlert(self, email):
    self._oprot.writeMessageBegin('unsubscribeEmailAlert', TMessageType.CALL, self._seqid)
    args = unsubscribeEmailAlert_args()
    args.email = email
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_unsubscribeEmailAlert(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = unsubscribeEmailAlert_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def listSubscribedPhone(self):
    """
    查看所有关注电话
    """
    self.send_listSubscribedPhone()
    return self.recv_listSubscribedPhone()

  def send_listSubscribedPhone(self):
    self._oprot.writeMessageBegin('listSubscribedPhone', TMessageType.CALL, self._seqid)
    args = listSubscribedPhone_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listSubscribedPhone(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = listSubscribedPhone_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listSubscribedPhone failed: unknown result");

  def listSubscribedEmail(self):
    """
    查看所有关注邮箱地址
    """
    self.send_listSubscribedEmail()
    return self.recv_listSubscribedEmail()

  def send_listSubscribedEmail(self):
    self._oprot.writeMessageBegin('listSubscribedEmail', TMessageType.CALL, self._seqid)
    args = listSubscribedEmail_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listSubscribedEmail(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = listSubscribedEmail_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listSubscribedEmail failed: unknown result");

  def getTableHistorySize(self, tableName, startDate, stopDate):
    """
    获取表空间历史大小

    Parameters:
     - tableName
     - startDate
     - stopDate
    """
    self.send_getTableHistorySize(tableName, startDate, stopDate)
    return self.recv_getTableHistorySize()

  def send_getTableHistorySize(self, tableName, startDate, stopDate):
    self._oprot.writeMessageBegin('getTableHistorySize', TMessageType.CALL, self._seqid)
    args = getTableHistorySize_args()
    args.tableName = tableName
    args.startDate = startDate
    args.stopDate = stopDate
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableHistorySize(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getTableHistorySize_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableHistorySize failed: unknown result");

  def renameTable(self, srcName, destName):
    """
    表重命名

    Parameters:
     - srcName
     - destName
    """
    self.send_renameTable(srcName, destName)
    self.recv_renameTable()

  def send_renameTable(self, srcName, destName):
    self._oprot.writeMessageBegin('renameTable', TMessageType.CALL, self._seqid)
    args = renameTable_args()
    args.srcName = srcName
    args.destName = destName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_renameTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = renameTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def listSnapshots(self, tableName):
    """
    查询表的所有snapshot

    Parameters:
     - tableName
    """
    self.send_listSnapshots(tableName)
    return self.recv_listSnapshots()

  def send_listSnapshots(self, tableName):
    self._oprot.writeMessageBegin('listSnapshots', TMessageType.CALL, self._seqid)
    args = listSnapshots_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listSnapshots(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = listSnapshots_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listSnapshots failed: unknown result");

  def snapshotTable(self, tableName, snapshotName):
    """
    生成表快照

    Parameters:
     - tableName
     - snapshotName
    """
    self.send_snapshotTable(tableName, snapshotName)
    self.recv_snapshotTable()

  def send_snapshotTable(self, tableName, snapshotName):
    self._oprot.writeMessageBegin('snapshotTable', TMessageType.CALL, self._seqid)
    args = snapshotTable_args()
    args.tableName = tableName
    args.snapshotName = snapshotName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_snapshotTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = snapshotTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def deleteSnapshot(self, tableName, snapshotName):
    """
    删除某个快照

    Parameters:
     - tableName
     - snapshotName
    """
    self.send_deleteSnapshot(tableName, snapshotName)
    self.recv_deleteSnapshot()

  def send_deleteSnapshot(self, tableName, snapshotName):
    self._oprot.writeMessageBegin('deleteSnapshot', TMessageType.CALL, self._seqid)
    args = deleteSnapshot_args()
    args.tableName = tableName
    args.snapshotName = snapshotName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteSnapshot(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = deleteSnapshot_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def restoreSnapshot(self, tableName, snapshotName, destTableName, isSystem):
    """
    从快照恢复表

    Parameters:
     - tableName
     - snapshotName
     - destTableName
     - isSystem
    """
    self.send_restoreSnapshot(tableName, snapshotName, destTableName, isSystem)
    self.recv_restoreSnapshot()

  def send_restoreSnapshot(self, tableName, snapshotName, destTableName, isSystem):
    self._oprot.writeMessageBegin('restoreSnapshot', TMessageType.CALL, self._seqid)
    args = restoreSnapshot_args()
    args.tableName = tableName
    args.snapshotName = snapshotName
    args.destTableName = destTableName
    args.isSystem = isSystem
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_restoreSnapshot(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = restoreSnapshot_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def listAllSnapshots(self):
    """
    列出用户的所有表快照
    """
    self.send_listAllSnapshots()
    return self.recv_listAllSnapshots()

  def send_listAllSnapshots(self):
    self._oprot.writeMessageBegin('listAllSnapshots', TMessageType.CALL, self._seqid)
    args = listAllSnapshots_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listAllSnapshots(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = listAllSnapshots_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listAllSnapshots failed: unknown result");

  def cancelSnapshotTable(self, tableName, snapshotName):
    """
    取消生成快照

    Parameters:
     - tableName
     - snapshotName
    """
    self.send_cancelSnapshotTable(tableName, snapshotName)
    self.recv_cancelSnapshotTable()

  def send_cancelSnapshotTable(self, tableName, snapshotName):
    self._oprot.writeMessageBegin('cancelSnapshotTable', TMessageType.CALL, self._seqid)
    args = cancelSnapshotTable_args()
    args.tableName = tableName
    args.snapshotName = snapshotName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_cancelSnapshotTable(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = cancelSnapshotTable_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.se is not None:
      raise result.se
    return

  def getSnapshotState(self, tableName, snapshotName):
    """
    查询快照状态

    Parameters:
     - tableName
     - snapshotName
    """
    self.send_getSnapshotState(tableName, snapshotName)
    return self.recv_getSnapshotState()

  def send_getSnapshotState(self, tableName, snapshotName):
    self._oprot.writeMessageBegin('getSnapshotState', TMessageType.CALL, self._seqid)
    args = getSnapshotState_args()
    args.tableName = tableName
    args.snapshotName = snapshotName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSnapshotState(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getSnapshotState_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSnapshotState failed: unknown result");

  def getQuotaInfo(self):
    """
    查询用户各种quota的使用情况
    """
    self.send_getQuotaInfo()
    return self.recv_getQuotaInfo()

  def send_getQuotaInfo(self):
    self._oprot.writeMessageBegin('getQuotaInfo', TMessageType.CALL, self._seqid)
    args = getQuotaInfo_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getQuotaInfo(self):
    iprot = self._iprot
    (fname, mtype, rseqid) = iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(iprot)
      iprot.readMessageEnd()
      raise x
    result = getQuotaInfo_result()
    result.read(iprot)
    iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.se is not None:
      raise result.se
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getQuotaInfo failed: unknown result");


class Processor(sds.common.BaseService.Processor, Iface, TProcessor):
  def __init__(self, handler):
    sds.common.BaseService.Processor.__init__(self, handler)
    self._processMap["saveAppInfo"] = Processor.process_saveAppInfo
    self._processMap["getAppInfo"] = Processor.process_getAppInfo
    self._processMap["findAllApps"] = Processor.process_findAllApps
    self._processMap["findAllTables"] = Processor.process_findAllTables
    self._processMap["createTable"] = Processor.process_createTable
    self._processMap["dropTable"] = Processor.process_dropTable
    self._processMap["alterTable"] = Processor.process_alterTable
    self._processMap["cloneTable"] = Processor.process_cloneTable
    self._processMap["disableTable"] = Processor.process_disableTable
    self._processMap["enableTable"] = Processor.process_enableTable
    self._processMap["describeTable"] = Processor.process_describeTable
    self._processMap["getTableStatus"] = Processor.process_getTableStatus
    self._processMap["getTableState"] = Processor.process_getTableState
    self._processMap["getTableSplits"] = Processor.process_getTableSplits
    self._processMap["queryMetric"] = Processor.process_queryMetric
    self._processMap["queryMetrics"] = Processor.process_queryMetrics
    self._processMap["findAllAppInfo"] = Processor.process_findAllAppInfo
    self._processMap["getTableSize"] = Processor.process_getTableSize
    self._processMap["putClientMetrics"] = Processor.process_putClientMetrics
    self._processMap["subscribePhoneAlert"] = Processor.process_subscribePhoneAlert
    self._processMap["unsubscribePhoneAlert"] = Processor.process_unsubscribePhoneAlert
    self._processMap["subscribeEmailAlert"] = Processor.process_subscribeEmailAlert
    self._processMap["unsubscribeEmailAlert"] = Processor.process_unsubscribeEmailAlert
    self._processMap["listSubscribedPhone"] = Processor.process_listSubscribedPhone
    self._processMap["listSubscribedEmail"] = Processor.process_listSubscribedEmail
    self._processMap["getTableHistorySize"] = Processor.process_getTableHistorySize
    self._processMap["renameTable"] = Processor.process_renameTable
    self._processMap["listSnapshots"] = Processor.process_listSnapshots
    self._processMap["snapshotTable"] = Processor.process_snapshotTable
    self._processMap["deleteSnapshot"] = Processor.process_deleteSnapshot
    self._processMap["restoreSnapshot"] = Processor.process_restoreSnapshot
    self._processMap["listAllSnapshots"] = Processor.process_listAllSnapshots
    self._processMap["cancelSnapshotTable"] = Processor.process_cancelSnapshotTable
    self._processMap["getSnapshotState"] = Processor.process_getSnapshotState
    self._processMap["getQuotaInfo"] = Processor.process_getQuotaInfo

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_saveAppInfo(self, seqid, iprot, oprot):
    args = saveAppInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = saveAppInfo_result()
    try:
      self._handler.saveAppInfo(args.appInfo)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("saveAppInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getAppInfo(self, seqid, iprot, oprot):
    args = getAppInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getAppInfo_result()
    try:
      result.success = self._handler.getAppInfo(args.appId)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getAppInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findAllApps(self, seqid, iprot, oprot):
    args = findAllApps_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findAllApps_result()
    try:
      result.success = self._handler.findAllApps()
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("findAllApps", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findAllTables(self, seqid, iprot, oprot):
    args = findAllTables_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findAllTables_result()
    try:
      result.success = self._handler.findAllTables()
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("findAllTables", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createTable(self, seqid, iprot, oprot):
    args = createTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createTable_result()
    try:
      result.success = self._handler.createTable(args.tableName, args.tableSpec)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("createTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_dropTable(self, seqid, iprot, oprot):
    args = dropTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = dropTable_result()
    try:
      self._handler.dropTable(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("dropTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_alterTable(self, seqid, iprot, oprot):
    args = alterTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = alterTable_result()
    try:
      self._handler.alterTable(args.tableName, args.tableSpec)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("alterTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_cloneTable(self, seqid, iprot, oprot):
    args = cloneTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = cloneTable_result()
    try:
      self._handler.cloneTable(args.srcName, args.destTable, args.flushTable)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("cloneTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_disableTable(self, seqid, iprot, oprot):
    args = disableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = disableTable_result()
    try:
      self._handler.disableTable(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("disableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_enableTable(self, seqid, iprot, oprot):
    args = enableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = enableTable_result()
    try:
      self._handler.enableTable(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("enableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_describeTable(self, seqid, iprot, oprot):
    args = describeTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = describeTable_result()
    try:
      result.success = self._handler.describeTable(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("describeTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableStatus(self, seqid, iprot, oprot):
    args = getTableStatus_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableStatus_result()
    try:
      result.success = self._handler.getTableStatus(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getTableStatus", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableState(self, seqid, iprot, oprot):
    args = getTableState_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableState_result()
    try:
      result.success = self._handler.getTableState(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getTableState", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableSplits(self, seqid, iprot, oprot):
    args = getTableSplits_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableSplits_result()
    try:
      result.success = self._handler.getTableSplits(args.tableName, args.startKey, args.stopKey)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getTableSplits", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_queryMetric(self, seqid, iprot, oprot):
    args = queryMetric_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = queryMetric_result()
    try:
      result.success = self._handler.queryMetric(args.query)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("queryMetric", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_queryMetrics(self, seqid, iprot, oprot):
    args = queryMetrics_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = queryMetrics_result()
    try:
      result.success = self._handler.queryMetrics(args.queries)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("queryMetrics", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findAllAppInfo(self, seqid, iprot, oprot):
    args = findAllAppInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findAllAppInfo_result()
    try:
      result.success = self._handler.findAllAppInfo()
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("findAllAppInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableSize(self, seqid, iprot, oprot):
    args = getTableSize_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableSize_result()
    try:
      result.success = self._handler.getTableSize(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getTableSize", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_putClientMetrics(self, seqid, iprot, oprot):
    args = putClientMetrics_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = putClientMetrics_result()
    try:
      self._handler.putClientMetrics(args.clientMetrics)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("putClientMetrics", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_subscribePhoneAlert(self, seqid, iprot, oprot):
    args = subscribePhoneAlert_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = subscribePhoneAlert_result()
    try:
      self._handler.subscribePhoneAlert(args.phoneNumber)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("subscribePhoneAlert", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_unsubscribePhoneAlert(self, seqid, iprot, oprot):
    args = unsubscribePhoneAlert_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = unsubscribePhoneAlert_result()
    try:
      self._handler.unsubscribePhoneAlert(args.phoneNumber)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("unsubscribePhoneAlert", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_subscribeEmailAlert(self, seqid, iprot, oprot):
    args = subscribeEmailAlert_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = subscribeEmailAlert_result()
    try:
      self._handler.subscribeEmailAlert(args.email)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("subscribeEmailAlert", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_unsubscribeEmailAlert(self, seqid, iprot, oprot):
    args = unsubscribeEmailAlert_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = unsubscribeEmailAlert_result()
    try:
      self._handler.unsubscribeEmailAlert(args.email)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("unsubscribeEmailAlert", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listSubscribedPhone(self, seqid, iprot, oprot):
    args = listSubscribedPhone_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listSubscribedPhone_result()
    try:
      result.success = self._handler.listSubscribedPhone()
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("listSubscribedPhone", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listSubscribedEmail(self, seqid, iprot, oprot):
    args = listSubscribedEmail_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listSubscribedEmail_result()
    try:
      result.success = self._handler.listSubscribedEmail()
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("listSubscribedEmail", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableHistorySize(self, seqid, iprot, oprot):
    args = getTableHistorySize_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableHistorySize_result()
    try:
      result.success = self._handler.getTableHistorySize(args.tableName, args.startDate, args.stopDate)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getTableHistorySize", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_renameTable(self, seqid, iprot, oprot):
    args = renameTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = renameTable_result()
    try:
      self._handler.renameTable(args.srcName, args.destName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("renameTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listSnapshots(self, seqid, iprot, oprot):
    args = listSnapshots_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listSnapshots_result()
    try:
      result.success = self._handler.listSnapshots(args.tableName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("listSnapshots", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_snapshotTable(self, seqid, iprot, oprot):
    args = snapshotTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = snapshotTable_result()
    try:
      self._handler.snapshotTable(args.tableName, args.snapshotName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("snapshotTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteSnapshot(self, seqid, iprot, oprot):
    args = deleteSnapshot_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteSnapshot_result()
    try:
      self._handler.deleteSnapshot(args.tableName, args.snapshotName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("deleteSnapshot", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_restoreSnapshot(self, seqid, iprot, oprot):
    args = restoreSnapshot_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = restoreSnapshot_result()
    try:
      self._handler.restoreSnapshot(args.tableName, args.snapshotName, args.destTableName, args.isSystem)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("restoreSnapshot", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listAllSnapshots(self, seqid, iprot, oprot):
    args = listAllSnapshots_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listAllSnapshots_result()
    try:
      result.success = self._handler.listAllSnapshots()
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("listAllSnapshots", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_cancelSnapshotTable(self, seqid, iprot, oprot):
    args = cancelSnapshotTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = cancelSnapshotTable_result()
    try:
      self._handler.cancelSnapshotTable(args.tableName, args.snapshotName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("cancelSnapshotTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getSnapshotState(self, seqid, iprot, oprot):
    args = getSnapshotState_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSnapshotState_result()
    try:
      result.success = self._handler.getSnapshotState(args.tableName, args.snapshotName)
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getSnapshotState", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getQuotaInfo(self, seqid, iprot, oprot):
    args = getQuotaInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getQuotaInfo_result()
    try:
      result.success = self._handler.getQuotaInfo()
    except sds.errors.ttypes.ServiceException as se:
      result.se = se
    oprot.writeMessageBegin("getQuotaInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class saveAppInfo_args(object):
  """
  Attributes:
   - appInfo
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'appInfo', (AppInfo, AppInfo.thrift_spec), None, ), # 1
  )

  def __init__(self, appInfo=None,):
    self.appInfo = appInfo

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.appInfo = AppInfo()
          self.appInfo.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('saveAppInfo_args')
    if self.appInfo is not None:
      oprot.writeFieldBegin('appInfo', TType.STRUCT, 1)
      self.appInfo.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.appInfo)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class saveAppInfo_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('saveAppInfo_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getAppInfo_args(object):
  """
  Attributes:
   - appId
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'appId', None, None, ), # 1
  )

  def __init__(self, appId=None,):
    self.appId = appId

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.appId = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getAppInfo_args')
    if self.appId is not None:
      oprot.writeFieldBegin('appId', TType.STRING, 1)
      oprot.writeString(self.appId)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.appId)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getAppInfo_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (AppInfo, AppInfo.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = AppInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getAppInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findAllApps_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findAllApps_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findAllApps_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(AppInfo, AppInfo.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype51, _size48) = iprot.readListBegin()
          for _i52 in range(_size48):
            _elem53 = AppInfo()
            _elem53.read(iprot)
            self.success.append(_elem53)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findAllApps_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter54 in self.success:
        iter54.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findAllTables_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findAllTables_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findAllTables_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(sds.table.ttypes.TableInfo, sds.table.ttypes.TableInfo.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype58, _size55) = iprot.readListBegin()
          for _i59 in range(_size55):
            _elem60 = sds.table.ttypes.TableInfo()
            _elem60.read(iprot)
            self.success.append(_elem60)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findAllTables_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter61 in self.success:
        iter61.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_args(object):
  """
  Attributes:
   - tableName
   - tableSpec
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRUCT, 'tableSpec', (sds.table.ttypes.TableSpec, sds.table.ttypes.TableSpec.thrift_spec), None, ), # 2
  )

  def __init__(self, tableName=None, tableSpec=None,):
    self.tableName = tableName
    self.tableSpec = tableSpec

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.tableSpec = sds.table.ttypes.TableSpec()
          self.tableSpec.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.tableSpec is not None:
      oprot.writeFieldBegin('tableSpec', TType.STRUCT, 2)
      self.tableSpec.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.tableSpec)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (sds.table.ttypes.TableInfo, sds.table.ttypes.TableInfo.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = sds.table.ttypes.TableInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class dropTable_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('dropTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class dropTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('dropTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class alterTable_args(object):
  """
  Attributes:
   - tableName
   - tableSpec
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRUCT, 'tableSpec', (sds.table.ttypes.TableSpec, sds.table.ttypes.TableSpec.thrift_spec), None, ), # 2
  )

  def __init__(self, tableName=None, tableSpec=None,):
    self.tableName = tableName
    self.tableSpec = tableSpec

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.tableSpec = sds.table.ttypes.TableSpec()
          self.tableSpec.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('alterTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.tableSpec is not None:
      oprot.writeFieldBegin('tableSpec', TType.STRUCT, 2)
      self.tableSpec.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.tableSpec)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class alterTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('alterTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class cloneTable_args(object):
  """
  Attributes:
   - srcName
   - destTable
   - flushTable
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'srcName', None, None, ), # 1
    (2, TType.STRING, 'destTable', None, None, ), # 2
    (3, TType.BOOL, 'flushTable', None, None, ), # 3
  )

  def __init__(self, srcName=None, destTable=None, flushTable=None,):
    self.srcName = srcName
    self.destTable = destTable
    self.flushTable = flushTable

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.srcName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.destTable = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.flushTable = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('cloneTable_args')
    if self.srcName is not None:
      oprot.writeFieldBegin('srcName', TType.STRING, 1)
      oprot.writeString(self.srcName)
      oprot.writeFieldEnd()
    if self.destTable is not None:
      oprot.writeFieldBegin('destTable', TType.STRING, 2)
      oprot.writeString(self.destTable)
      oprot.writeFieldEnd()
    if self.flushTable is not None:
      oprot.writeFieldBegin('flushTable', TType.BOOL, 3)
      oprot.writeBool(self.flushTable)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.srcName)
    value = (value * 31) ^ hash(self.destTable)
    value = (value * 31) ^ hash(self.flushTable)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class cloneTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('cloneTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class enableTable_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class enableTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describeTable_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describeTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class describeTable_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (sds.table.ttypes.TableSpec, sds.table.ttypes.TableSpec.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = sds.table.ttypes.TableSpec()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('describeTable_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableStatus_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableStatus_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableStatus_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (sds.table.ttypes.TableStatus, sds.table.ttypes.TableStatus.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = sds.table.ttypes.TableStatus()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableStatus_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableState_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableState_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableState_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableState_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableSplits_args(object):
  """
  Attributes:
   - tableName
   - startKey
   - stopKey
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.MAP, 'startKey', (TType.STRING,None,TType.STRUCT,(sds.table.ttypes.Datum, sds.table.ttypes.Datum.thrift_spec)), None, ), # 2
    (3, TType.MAP, 'stopKey', (TType.STRING,None,TType.STRUCT,(sds.table.ttypes.Datum, sds.table.ttypes.Datum.thrift_spec)), None, ), # 3
  )

  def __init__(self, tableName=None, startKey=None, stopKey=None,):
    self.tableName = tableName
    self.startKey = startKey
    self.stopKey = stopKey

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.startKey = {}
          (_ktype63, _vtype64, _size62 ) = iprot.readMapBegin()
          for _i66 in range(_size62):
            _key67 = iprot.readString();
            _val68 = sds.table.ttypes.Datum()
            _val68.read(iprot)
            self.startKey[_key67] = _val68
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.stopKey = {}
          (_ktype70, _vtype71, _size69 ) = iprot.readMapBegin()
          for _i73 in range(_size69):
            _key74 = iprot.readString();
            _val75 = sds.table.ttypes.Datum()
            _val75.read(iprot)
            self.stopKey[_key74] = _val75
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableSplits_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startKey is not None:
      oprot.writeFieldBegin('startKey', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.startKey))
      for kiter76,viter77 in list(self.startKey.items()):
        oprot.writeString(kiter76)
        viter77.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.stopKey is not None:
      oprot.writeFieldBegin('stopKey', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.stopKey))
      for kiter78,viter79 in list(self.stopKey.items()):
        oprot.writeString(kiter78)
        viter79.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.startKey)
    value = (value * 31) ^ hash(self.stopKey)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableSplits_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(sds.table.ttypes.TableSplit, sds.table.ttypes.TableSplit.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype83, _size80) = iprot.readListBegin()
          for _i84 in range(_size80):
            _elem85 = sds.table.ttypes.TableSplit()
            _elem85.read(iprot)
            self.success.append(_elem85)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableSplits_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter86 in self.success:
        iter86.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class queryMetric_args(object):
  """
  Attributes:
   - query
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'query', (MetricQueryRequest, MetricQueryRequest.thrift_spec), None, ), # 1
  )

  def __init__(self, query=None,):
    self.query = query

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.query = MetricQueryRequest()
          self.query.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('queryMetric_args')
    if self.query is not None:
      oprot.writeFieldBegin('query', TType.STRUCT, 1)
      self.query.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.query)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class queryMetric_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (TimeSeriesData, TimeSeriesData.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = TimeSeriesData()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('queryMetric_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class queryMetrics_args(object):
  """
  Attributes:
   - queries
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'queries', (TType.STRUCT,(MetricQueryRequest, MetricQueryRequest.thrift_spec)), None, ), # 1
  )

  def __init__(self, queries=None,):
    self.queries = queries

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.queries = []
          (_etype90, _size87) = iprot.readListBegin()
          for _i91 in range(_size87):
            _elem92 = MetricQueryRequest()
            _elem92.read(iprot)
            self.queries.append(_elem92)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('queryMetrics_args')
    if self.queries is not None:
      oprot.writeFieldBegin('queries', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.queries))
      for iter93 in self.queries:
        iter93.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.queries)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class queryMetrics_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TimeSeriesData, TimeSeriesData.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype97, _size94) = iprot.readListBegin()
          for _i98 in range(_size94):
            _elem99 = TimeSeriesData()
            _elem99.read(iprot)
            self.success.append(_elem99)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('queryMetrics_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter100 in self.success:
        iter100.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findAllAppInfo_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findAllAppInfo_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findAllAppInfo_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(AppInfo, AppInfo.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype104, _size101) = iprot.readListBegin()
          for _i105 in range(_size101):
            _elem106 = AppInfo()
            _elem106.read(iprot)
            self.success.append(_elem106)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findAllAppInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter107 in self.success:
        iter107.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableSize_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableSize_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableSize_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.I64, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I64:
          self.success = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableSize_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I64, 0)
      oprot.writeI64(self.success)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class putClientMetrics_args(object):
  """
  Attributes:
   - clientMetrics
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'clientMetrics', (ClientMetrics, ClientMetrics.thrift_spec), None, ), # 1
  )

  def __init__(self, clientMetrics=None,):
    self.clientMetrics = clientMetrics

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.clientMetrics = ClientMetrics()
          self.clientMetrics.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('putClientMetrics_args')
    if self.clientMetrics is not None:
      oprot.writeFieldBegin('clientMetrics', TType.STRUCT, 1)
      self.clientMetrics.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.clientMetrics)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class putClientMetrics_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('putClientMetrics_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class subscribePhoneAlert_args(object):
  """
  Attributes:
   - phoneNumber
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'phoneNumber', None, None, ), # 1
  )

  def __init__(self, phoneNumber=None,):
    self.phoneNumber = phoneNumber

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.phoneNumber = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('subscribePhoneAlert_args')
    if self.phoneNumber is not None:
      oprot.writeFieldBegin('phoneNumber', TType.STRING, 1)
      oprot.writeString(self.phoneNumber)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.phoneNumber)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class subscribePhoneAlert_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('subscribePhoneAlert_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsubscribePhoneAlert_args(object):
  """
  Attributes:
   - phoneNumber
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'phoneNumber', None, None, ), # 1
  )

  def __init__(self, phoneNumber=None,):
    self.phoneNumber = phoneNumber

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.phoneNumber = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsubscribePhoneAlert_args')
    if self.phoneNumber is not None:
      oprot.writeFieldBegin('phoneNumber', TType.STRING, 1)
      oprot.writeString(self.phoneNumber)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.phoneNumber)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsubscribePhoneAlert_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsubscribePhoneAlert_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class subscribeEmailAlert_args(object):
  """
  Attributes:
   - email
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'email', None, None, ), # 1
  )

  def __init__(self, email=None,):
    self.email = email

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.email = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('subscribeEmailAlert_args')
    if self.email is not None:
      oprot.writeFieldBegin('email', TType.STRING, 1)
      oprot.writeString(self.email)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.email)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class subscribeEmailAlert_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('subscribeEmailAlert_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsubscribeEmailAlert_args(object):
  """
  Attributes:
   - email
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'email', None, None, ), # 1
  )

  def __init__(self, email=None,):
    self.email = email

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.email = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsubscribeEmailAlert_args')
    if self.email is not None:
      oprot.writeFieldBegin('email', TType.STRING, 1)
      oprot.writeString(self.email)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.email)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsubscribeEmailAlert_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsubscribeEmailAlert_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSubscribedPhone_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSubscribedPhone_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSubscribedPhone_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype111, _size108) = iprot.readListBegin()
          for _i112 in range(_size108):
            _elem113 = iprot.readString();
            self.success.append(_elem113)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSubscribedPhone_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter114 in self.success:
        oprot.writeString(iter114)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSubscribedEmail_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSubscribedEmail_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSubscribedEmail_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype118, _size115) = iprot.readListBegin()
          for _i119 in range(_size115):
            _elem120 = iprot.readString();
            self.success.append(_elem120)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSubscribedEmail_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter121 in self.success:
        oprot.writeString(iter121)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableHistorySize_args(object):
  """
  Attributes:
   - tableName
   - startDate
   - stopDate
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.I64, 'startDate', None, None, ), # 2
    (3, TType.I64, 'stopDate', None, None, ), # 3
  )

  def __init__(self, tableName=None, startDate=None, stopDate=None,):
    self.tableName = tableName
    self.startDate = startDate
    self.stopDate = stopDate

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.startDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.stopDate = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableHistorySize_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startDate is not None:
      oprot.writeFieldBegin('startDate', TType.I64, 2)
      oprot.writeI64(self.startDate)
      oprot.writeFieldEnd()
    if self.stopDate is not None:
      oprot.writeFieldBegin('stopDate', TType.I64, 3)
      oprot.writeI64(self.stopDate)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.startDate)
    value = (value * 31) ^ hash(self.stopDate)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableHistorySize_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.I64,None,TType.I64,None), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype123, _vtype124, _size122 ) = iprot.readMapBegin()
          for _i126 in range(_size122):
            _key127 = iprot.readI64();
            _val128 = iprot.readI64();
            self.success[_key127] = _val128
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableHistorySize_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.I64, TType.I64, len(self.success))
      for kiter129,viter130 in list(self.success.items()):
        oprot.writeI64(kiter129)
        oprot.writeI64(viter130)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class renameTable_args(object):
  """
  Attributes:
   - srcName
   - destName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'srcName', None, None, ), # 1
    (2, TType.STRING, 'destName', None, None, ), # 2
  )

  def __init__(self, srcName=None, destName=None,):
    self.srcName = srcName
    self.destName = destName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.srcName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.destName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('renameTable_args')
    if self.srcName is not None:
      oprot.writeFieldBegin('srcName', TType.STRING, 1)
      oprot.writeString(self.srcName)
      oprot.writeFieldEnd()
    if self.destName is not None:
      oprot.writeFieldBegin('destName', TType.STRING, 2)
      oprot.writeString(self.destName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.srcName)
    value = (value * 31) ^ hash(self.destName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class renameTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('renameTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSnapshots_args(object):
  """
  Attributes:
   - tableName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSnapshots_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSnapshots_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (TableSnapshots, TableSnapshots.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = TableSnapshots()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSnapshots_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class snapshotTable_args(object):
  """
  Attributes:
   - tableName
   - snapshotName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'snapshotName', None, None, ), # 2
  )

  def __init__(self, tableName=None, snapshotName=None,):
    self.tableName = tableName
    self.snapshotName = snapshotName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.snapshotName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('snapshotTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.snapshotName is not None:
      oprot.writeFieldBegin('snapshotName', TType.STRING, 2)
      oprot.writeString(self.snapshotName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.snapshotName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class snapshotTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('snapshotTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteSnapshot_args(object):
  """
  Attributes:
   - tableName
   - snapshotName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'snapshotName', None, None, ), # 2
  )

  def __init__(self, tableName=None, snapshotName=None,):
    self.tableName = tableName
    self.snapshotName = snapshotName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.snapshotName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteSnapshot_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.snapshotName is not None:
      oprot.writeFieldBegin('snapshotName', TType.STRING, 2)
      oprot.writeString(self.snapshotName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.snapshotName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteSnapshot_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteSnapshot_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class restoreSnapshot_args(object):
  """
  Attributes:
   - tableName
   - snapshotName
   - destTableName
   - isSystem
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'snapshotName', None, None, ), # 2
    (3, TType.STRING, 'destTableName', None, None, ), # 3
    (4, TType.BOOL, 'isSystem', None, None, ), # 4
  )

  def __init__(self, tableName=None, snapshotName=None, destTableName=None, isSystem=None,):
    self.tableName = tableName
    self.snapshotName = snapshotName
    self.destTableName = destTableName
    self.isSystem = isSystem

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.snapshotName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.destTableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.isSystem = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('restoreSnapshot_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.snapshotName is not None:
      oprot.writeFieldBegin('snapshotName', TType.STRING, 2)
      oprot.writeString(self.snapshotName)
      oprot.writeFieldEnd()
    if self.destTableName is not None:
      oprot.writeFieldBegin('destTableName', TType.STRING, 3)
      oprot.writeString(self.destTableName)
      oprot.writeFieldEnd()
    if self.isSystem is not None:
      oprot.writeFieldBegin('isSystem', TType.BOOL, 4)
      oprot.writeBool(self.isSystem)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.snapshotName)
    value = (value * 31) ^ hash(self.destTableName)
    value = (value * 31) ^ hash(self.isSystem)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class restoreSnapshot_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('restoreSnapshot_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listAllSnapshots_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listAllSnapshots_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listAllSnapshots_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(SnapshotTableView, SnapshotTableView.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype134, _size131) = iprot.readListBegin()
          for _i135 in range(_size131):
            _elem136 = SnapshotTableView()
            _elem136.read(iprot)
            self.success.append(_elem136)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listAllSnapshots_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter137 in self.success:
        iter137.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class cancelSnapshotTable_args(object):
  """
  Attributes:
   - tableName
   - snapshotName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'snapshotName', None, None, ), # 2
  )

  def __init__(self, tableName=None, snapshotName=None,):
    self.tableName = tableName
    self.snapshotName = snapshotName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.snapshotName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('cancelSnapshotTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.snapshotName is not None:
      oprot.writeFieldBegin('snapshotName', TType.STRING, 2)
      oprot.writeString(self.snapshotName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.snapshotName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class cancelSnapshotTable_result(object):
  """
  Attributes:
   - se
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, se=None,):
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('cancelSnapshotTable_result')
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSnapshotState_args(object):
  """
  Attributes:
   - tableName
   - snapshotName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'snapshotName', None, None, ), # 2
  )

  def __init__(self, tableName=None, snapshotName=None,):
    self.tableName = tableName
    self.snapshotName = snapshotName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.snapshotName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSnapshotState_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.snapshotName is not None:
      oprot.writeFieldBegin('snapshotName', TType.STRING, 2)
      oprot.writeString(self.snapshotName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.tableName)
    value = (value * 31) ^ hash(self.snapshotName)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSnapshotState_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSnapshotState_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getQuotaInfo_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getQuotaInfo_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getQuotaInfo_result(object):
  """
  Attributes:
   - success
   - se
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (QuotaInfo, QuotaInfo.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'se', (sds.errors.ttypes.ServiceException, sds.errors.ttypes.ServiceException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, se=None,):
    self.success = success
    self.se = se

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = QuotaInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.se = sds.errors.ttypes.ServiceException()
          self.se.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getQuotaInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.se is not None:
      oprot.writeFieldBegin('se', TType.STRUCT, 1)
      self.se.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.success)
    value = (value * 31) ^ hash(self.se)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
