# Generated by Django 4.2.6 on 2025-04-22 17:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ProcessAuditEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_informations', models.TextField(blank=True, null=True, verbose_name='Extra information')),
                ('datetime', models.DateTimeField(auto_now_add=True, verbose_name='Datetime')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('created_by', models.CharField(blank=True, max_length=120, null=True, verbose_name='User identifier')),
            ],
            options={
                'verbose_name': 'Process audit event',
                'verbose_name_plural': 'Process audit events',
            },
        ),
        migrations.CreateModel(
            name='RequestAuditEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_informations', models.TextField(blank=True, null=True, verbose_name='Extra information')),
                ('datetime', models.DateTimeField(auto_now_add=True, verbose_name='Datetime')),
                ('user', models.CharField(blank=True, max_length=120, null=True, verbose_name='User identifier')),
                ('ip_addresses', models.CharField(max_length=50, null=True, verbose_name='Ip addresses')),
                ('method', models.CharField(max_length=10, verbose_name='Method')),
                ('url', models.CharField(max_length=2048, verbose_name='URL')),
                ('query_params', models.CharField(blank=True, max_length=2048, null=True, verbose_name='Query Parameters')),
                ('request_type', models.CharField(blank=True, max_length=10, null=True, verbose_name='Request Type')),
                ('status_code', models.IntegerField(null=True, verbose_name='Status Code')),
                ('response_time', models.FloatField(null=True, verbose_name='Response Time (ms)')),
                ('response_size', models.IntegerField(null=True, verbose_name='Response Size (bytes)')),
                ('error_type', models.CharField(blank=True, max_length=255, null=True, verbose_name='Error Type')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='Error Message')),
                ('error_stacktrace', models.TextField(blank=True, null=True, verbose_name='Error Stacktrace')),
            ],
            options={
                'verbose_name': 'Request event',
                'verbose_name_plural': 'Request events',
            },
        ),
        migrations.CreateModel(
            name='StepAuditEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_informations', models.TextField(blank=True, null=True, verbose_name='Extra information')),
                ('datetime', models.DateTimeField(auto_now_add=True, verbose_name='Datetime')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('order', models.IntegerField()),
                ('total_registrations', models.IntegerField(default=1)),
                ('created_by', models.CharField(blank=True, max_length=120, null=True, verbose_name='User identifier')),
                ('process', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='steps', to='drf_audit_trail.processauditevent')),
            ],
            options={
                'verbose_name': 'Step audit event',
                'verbose_name_plural': 'Step audit events',
            },
        ),
        migrations.CreateModel(
            name='RegistrationAuditEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_informations', models.TextField(blank=True, null=True, verbose_name='Extra information')),
                ('datetime', models.DateTimeField(auto_now_add=True, verbose_name='Datetime')),
                ('success', models.BooleanField()),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(blank=True, max_length=120, null=True, verbose_name='User identifier')),
                ('step', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registrations', to='drf_audit_trail.stepauditevent')),
            ],
            options={
                'verbose_name': 'Registration audit event',
                'verbose_name_plural': 'Registration audit events',
            },
        ),
        migrations.AddField(
            model_name='processauditevent',
            name='request',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='processes', to='drf_audit_trail.requestauditevent', verbose_name='Request'),
        ),
        migrations.CreateModel(
            name='LoginAuditEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_informations', models.TextField(blank=True, null=True, verbose_name='Extra information')),
                ('datetime', models.DateTimeField(auto_now_add=True, verbose_name='Datetime')),
                ('status', models.CharField(choices=[('Sign in', 'Sign in'), ('Sign out', 'Sign out'), ('Failed', 'Failed')], max_length=8, verbose_name='Status')),
                ('request', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='drf_audit_trail.requestauditevent')),
            ],
            options={
                'verbose_name': 'Login audit event',
                'verbose_name_plural': 'Login audit events',
            },
        ),
    ]
