# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentArgs', 'Agent']

@pulumi.input_type
class AgentArgs:
    def __init__(__self__, *,
                 agent_type: pulumi.Input[str],
                 agent_version: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 os_version: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a Agent resource.
        :param pulumi.Input[str] agent_type: Agent identifier.
        :param pulumi.Input[str] agent_version: Agent identifier.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[str] display_name: (Updatable) Agent identifier.
        :param pulumi.Input[str] environment_id: Environment identifier.
        :param pulumi.Input[str] os_version: OS version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "agent_type", agent_type)
        pulumi.set(__self__, "agent_version", agent_version)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "os_version", os_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> pulumi.Input[str]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_type")

    @agent_type.setter
    def agent_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent_type", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Input[str]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Agent identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Environment identifier.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Input[str]:
        """
        OS version.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AgentState:
    def __init__(__self__, *,
                 agent_pub_key: Optional[pulumi.Input[str]] = None,
                 agent_type: Optional[pulumi.Input[str]] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 heart_beat_status: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 plugin_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AgentPluginListArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_expire_agent_key_in_ms: Optional[pulumi.Input[str]] = None,
                 time_last_sync_received: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Agent resources.
        :param pulumi.Input[str] agent_pub_key: Resource principal public key.
        :param pulumi.Input[str] agent_type: Agent identifier.
        :param pulumi.Input[str] agent_version: Agent identifier.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) Agent identifier.
        :param pulumi.Input[str] environment_id: Environment identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] heart_beat_status: The current heartbeat status of the Agent based on its timeLastSyncReceived value.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] os_version: OS version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['AgentPluginListArgs']]] plugin_lists: List of plugins associated with the agent.
        :param pulumi.Input[str] state: The current state of the Agent.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time when the Agent was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_expire_agent_key_in_ms: The time since epoch for when the public key will expire. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_last_sync_received: The time when the last heartbeat of the Agent was noted. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        if agent_pub_key is not None:
            pulumi.set(__self__, "agent_pub_key", agent_pub_key)
        if agent_type is not None:
            pulumi.set(__self__, "agent_type", agent_type)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if heart_beat_status is not None:
            pulumi.set(__self__, "heart_beat_status", heart_beat_status)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if plugin_lists is not None:
            pulumi.set(__self__, "plugin_lists", plugin_lists)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_expire_agent_key_in_ms is not None:
            pulumi.set(__self__, "time_expire_agent_key_in_ms", time_expire_agent_key_in_ms)
        if time_last_sync_received is not None:
            pulumi.set(__self__, "time_last_sync_received", time_last_sync_received)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="agentPubKey")
    def agent_pub_key(self) -> Optional[pulumi.Input[str]]:
        """
        Resource principal public key.
        """
        return pulumi.get(self, "agent_pub_key")

    @agent_pub_key.setter
    def agent_pub_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_pub_key", value)

    @property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_type")

    @agent_type.setter
    def agent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_type", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Agent identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Environment identifier.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="heartBeatStatus")
    def heart_beat_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current heartbeat status of the Agent based on its timeLastSyncReceived value.
        """
        return pulumi.get(self, "heart_beat_status")

    @heart_beat_status.setter
    def heart_beat_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "heart_beat_status", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        OS version.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentPluginListArgs']]]]:
        """
        List of plugins associated with the agent.
        """
        return pulumi.get(self, "plugin_lists")

    @plugin_lists.setter
    def plugin_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentPluginListArgs']]]]):
        pulumi.set(self, "plugin_lists", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Agent.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeExpireAgentKeyInMs")
    def time_expire_agent_key_in_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The time since epoch for when the public key will expire. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expire_agent_key_in_ms")

    @time_expire_agent_key_in_ms.setter
    def time_expire_agent_key_in_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_expire_agent_key_in_ms", value)

    @property
    @pulumi.getter(name="timeLastSyncReceived")
    def time_last_sync_received(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the last heartbeat of the Agent was noted. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_last_sync_received")

    @time_last_sync_received.setter
    def time_last_sync_received(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_sync_received", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class Agent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_type: Optional[pulumi.Input[str]] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Agent resource in Oracle Cloud Infrastructure Cloud Bridge service.

        Creates an Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent = oci.cloud_bridge.Agent("test_agent",
            agent_type=agent_agent_type,
            agent_version=agent_agent_version,
            compartment_id=compartment_id,
            display_name=agent_display_name,
            environment_id=test_environment["id"],
            os_version=agent_os_version,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Agents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/agent:Agent test_agent "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] agent_type: Agent identifier.
        :param pulumi.Input[str] agent_version: Agent identifier.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) Agent identifier.
        :param pulumi.Input[str] environment_id: Environment identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] os_version: OS version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Agent resource in Oracle Cloud Infrastructure Cloud Bridge service.

        Creates an Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent = oci.cloud_bridge.Agent("test_agent",
            agent_type=agent_agent_type,
            agent_version=agent_agent_version,
            compartment_id=compartment_id,
            display_name=agent_display_name,
            environment_id=test_environment["id"],
            os_version=agent_os_version,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Agents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/agent:Agent test_agent "id"
        ```

        :param str resource_name: The name of the resource.
        :param AgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_type: Optional[pulumi.Input[str]] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentArgs.__new__(AgentArgs)

            if agent_type is None and not opts.urn:
                raise TypeError("Missing required property 'agent_type'")
            __props__.__dict__["agent_type"] = agent_type
            if agent_version is None and not opts.urn:
                raise TypeError("Missing required property 'agent_version'")
            __props__.__dict__["agent_version"] = agent_version
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if os_version is None and not opts.urn:
                raise TypeError("Missing required property 'os_version'")
            __props__.__dict__["os_version"] = os_version
            __props__.__dict__["agent_pub_key"] = None
            __props__.__dict__["heart_beat_status"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["plugin_lists"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_expire_agent_key_in_ms"] = None
            __props__.__dict__["time_last_sync_received"] = None
            __props__.__dict__["time_updated"] = None
        super(Agent, __self__).__init__(
            'oci:CloudBridge/agent:Agent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_pub_key: Optional[pulumi.Input[str]] = None,
            agent_type: Optional[pulumi.Input[str]] = None,
            agent_version: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            heart_beat_status: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            os_version: Optional[pulumi.Input[str]] = None,
            plugin_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AgentPluginListArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_expire_agent_key_in_ms: Optional[pulumi.Input[str]] = None,
            time_last_sync_received: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'Agent':
        """
        Get an existing Agent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] agent_pub_key: Resource principal public key.
        :param pulumi.Input[str] agent_type: Agent identifier.
        :param pulumi.Input[str] agent_version: Agent identifier.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) Agent identifier.
        :param pulumi.Input[str] environment_id: Environment identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] heart_beat_status: The current heartbeat status of the Agent based on its timeLastSyncReceived value.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] os_version: OS version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AgentPluginListArgs']]]] plugin_lists: List of plugins associated with the agent.
        :param pulumi.Input[str] state: The current state of the Agent.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time when the Agent was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_expire_agent_key_in_ms: The time since epoch for when the public key will expire. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_last_sync_received: The time when the last heartbeat of the Agent was noted. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentState.__new__(_AgentState)

        __props__.__dict__["agent_pub_key"] = agent_pub_key
        __props__.__dict__["agent_type"] = agent_type
        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["heart_beat_status"] = heart_beat_status
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["plugin_lists"] = plugin_lists
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_expire_agent_key_in_ms"] = time_expire_agent_key_in_ms
        __props__.__dict__["time_last_sync_received"] = time_last_sync_received
        __props__.__dict__["time_updated"] = time_updated
        return Agent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPubKey")
    def agent_pub_key(self) -> pulumi.Output[str]:
        """
        Resource principal public key.
        """
        return pulumi.get(self, "agent_pub_key")

    @property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> pulumi.Output[str]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_type")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[str]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Agent identifier.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        Environment identifier.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="heartBeatStatus")
    def heart_beat_status(self) -> pulumi.Output[str]:
        """
        The current heartbeat status of the Agent based on its timeLastSyncReceived value.
        """
        return pulumi.get(self, "heart_beat_status")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[str]:
        """
        OS version.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> pulumi.Output[Sequence['outputs.AgentPluginList']]:
        """
        List of plugins associated with the agent.
        """
        return pulumi.get(self, "plugin_lists")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Agent.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpireAgentKeyInMs")
    def time_expire_agent_key_in_ms(self) -> pulumi.Output[str]:
        """
        The time since epoch for when the public key will expire. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expire_agent_key_in_ms")

    @property
    @pulumi.getter(name="timeLastSyncReceived")
    def time_last_sync_received(self) -> pulumi.Output[str]:
        """
        The time when the last heartbeat of the Agent was noted. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_last_sync_received")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

