# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstanceAvailableWindowsUpdatesResult',
    'AwaitableGetManagedInstanceAvailableWindowsUpdatesResult',
    'get_managed_instance_available_windows_updates',
    'get_managed_instance_available_windows_updates_output',
]

@pulumi.output_type
class GetManagedInstanceAvailableWindowsUpdatesResult:
    """
    A collection of values returned by getManagedInstanceAvailableWindowsUpdates.
    """
    def __init__(__self__, available_windows_update_collections=None, classification_types=None, compartment_id=None, display_name=None, display_name_contains=None, filters=None, id=None, is_installable=None, managed_instance_id=None, names=None):
        if available_windows_update_collections and not isinstance(available_windows_update_collections, list):
            raise TypeError("Expected argument 'available_windows_update_collections' to be a list")
        pulumi.set(__self__, "available_windows_update_collections", available_windows_update_collections)
        if classification_types and not isinstance(classification_types, list):
            raise TypeError("Expected argument 'classification_types' to be a list")
        pulumi.set(__self__, "classification_types", classification_types)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_installable and not isinstance(is_installable, str):
            raise TypeError("Expected argument 'is_installable' to be a str")
        pulumi.set(__self__, "is_installable", is_installable)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter(name="availableWindowsUpdateCollections")
    def available_windows_update_collections(self) -> Sequence['outputs.GetManagedInstanceAvailableWindowsUpdatesAvailableWindowsUpdateCollectionResult']:
        """
        The list of available_windows_update_collection.
        """
        return pulumi.get(self, "available_windows_update_collections")

    @property
    @pulumi.getter(name="classificationTypes")
    def classification_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "classification_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstanceAvailableWindowsUpdatesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isInstallable")
    def is_installable(self) -> Optional[str]:
        return pulumi.get(self, "is_installable")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> str:
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        Name of the Windows update.
        """
        return pulumi.get(self, "names")


class AwaitableGetManagedInstanceAvailableWindowsUpdatesResult(GetManagedInstanceAvailableWindowsUpdatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceAvailableWindowsUpdatesResult(
            available_windows_update_collections=self.available_windows_update_collections,
            classification_types=self.classification_types,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            id=self.id,
            is_installable=self.is_installable,
            managed_instance_id=self.managed_instance_id,
            names=self.names)


def get_managed_instance_available_windows_updates(classification_types: Optional[Sequence[str]] = None,
                                                   compartment_id: Optional[str] = None,
                                                   display_name: Optional[str] = None,
                                                   display_name_contains: Optional[str] = None,
                                                   filters: Optional[Sequence[pulumi.InputType['GetManagedInstanceAvailableWindowsUpdatesFilterArgs']]] = None,
                                                   is_installable: Optional[str] = None,
                                                   managed_instance_id: Optional[str] = None,
                                                   names: Optional[Sequence[str]] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceAvailableWindowsUpdatesResult:
    """
    This data source provides the list of Managed Instance Available Windows Updates in Oracle Cloud Infrastructure Os Management Hub service.

    Returns a list of Windows updates that can be installed on the specified managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_available_windows_updates = oci.OsManagementHub.get_managed_instance_available_windows_updates(managed_instance_id=test_managed_instance["id"],
        classification_types=managed_instance_available_windows_update_classification_type,
        compartment_id=compartment_id,
        display_name=managed_instance_available_windows_update_display_name,
        display_name_contains=managed_instance_available_windows_update_display_name_contains,
        is_installable=managed_instance_available_windows_update_is_installable,
        names=managed_instance_available_windows_update_name)
    ```


    :param Sequence[str] classification_types: A filter to return only packages that match the given update classification type.
    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param str is_installable: Indicates if the update can be installed by the OS Management Hub service.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param Sequence[str] names: A filter based on the unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.  Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
    """
    __args__ = dict()
    __args__['classificationTypes'] = classification_types
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['isInstallable'] = is_installable
    __args__['managedInstanceId'] = managed_instance_id
    __args__['names'] = names
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstanceAvailableWindowsUpdates:getManagedInstanceAvailableWindowsUpdates', __args__, opts=opts, typ=GetManagedInstanceAvailableWindowsUpdatesResult).value

    return AwaitableGetManagedInstanceAvailableWindowsUpdatesResult(
        available_windows_update_collections=pulumi.get(__ret__, 'available_windows_update_collections'),
        classification_types=pulumi.get(__ret__, 'classification_types'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_installable=pulumi.get(__ret__, 'is_installable'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        names=pulumi.get(__ret__, 'names'))


@_utilities.lift_output_func(get_managed_instance_available_windows_updates)
def get_managed_instance_available_windows_updates_output(classification_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                          compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                          display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedInstanceAvailableWindowsUpdatesFilterArgs']]]]] = None,
                                                          is_installable: Optional[pulumi.Input[Optional[str]]] = None,
                                                          managed_instance_id: Optional[pulumi.Input[str]] = None,
                                                          names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedInstanceAvailableWindowsUpdatesResult]:
    """
    This data source provides the list of Managed Instance Available Windows Updates in Oracle Cloud Infrastructure Os Management Hub service.

    Returns a list of Windows updates that can be installed on the specified managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_available_windows_updates = oci.OsManagementHub.get_managed_instance_available_windows_updates(managed_instance_id=test_managed_instance["id"],
        classification_types=managed_instance_available_windows_update_classification_type,
        compartment_id=compartment_id,
        display_name=managed_instance_available_windows_update_display_name,
        display_name_contains=managed_instance_available_windows_update_display_name_contains,
        is_installable=managed_instance_available_windows_update_is_installable,
        names=managed_instance_available_windows_update_name)
    ```


    :param Sequence[str] classification_types: A filter to return only packages that match the given update classification type.
    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param str is_installable: Indicates if the update can be installed by the OS Management Hub service.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param Sequence[str] names: A filter based on the unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.  Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
    """
    ...
