"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerProcessor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
const Util_1 = require("./Util");
/**
 * CDK wrapper for the GitHub Eventbridge processor.
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas-furls.html#furls-connection-github
 */
class PartnerProcessor extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.partnerEventsFunction = new aws_lambda_1.Function(this, `${props.eventbridgePartner}EventsFunction`, {
            code: aws_lambda_1.Code.fromBucket(aws_s3_1.Bucket.fromBucketName(this, 'AWSFunctionBucket', `eventbridge-inbound-webhook-templates-prod-${aws_cdk_lib_1.Stack.of(this).region}`), `lambda-templates/${props.eventbridgePartner}-lambdasrc.zip`),
            handler: 'app.handler',
            runtime: aws_lambda_1.Runtime.PYTHON_3_7,
            memorySize: 128,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            reservedConcurrentExecutions: 10,
            environment: {
                GITHUB_WEBHOOK_SECRET_ARN: props.webhookSecret.secretArn,
                EVENT_BUS_NAME: props.eventBus.eventBusName,
            },
        });
        this.invocationAlarm = new Util_1.InvocationAlarm(this, `${props.eventbridgePartner}InvocationAlarm`, {
            threshold: props.lambdaInvocationAlarmThreshold,
            eventFunction: this.partnerEventsFunction,
        });
        const fURL = this.partnerEventsFunction.addFunctionUrl({ authType: aws_lambda_1.FunctionUrlAuthType.NONE });
        props.webhookSecret.grantRead(this.partnerEventsFunction);
        props.eventBus.grantPutEventsTo(this.partnerEventsFunction);
        new aws_cdk_lib_1.CfnOutput(this, `${props.eventbridgePartner}FunctionUrl`, { value: fURL.url });
    }
}
exports.PartnerProcessor = PartnerProcessor;
_a = JSII_RTTI_SYMBOL_1;
PartnerProcessor[_a] = { fqn: "cdk-eventbridge-partner-processors.PartnerProcessor", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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