/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.tools.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdbcUtil {
    public static Connection getConnection(String driverClass, String url, String username, String password) {
        Connection conn = null;
        try {
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return conn;
    }

    public static void closeConnection(Connection conn, Statement st, ResultSet rs, PreparedStatement ps) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeConnection(Connection conn, Statement st, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeConnection(Connection conn, PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeConnection(Connection conn, PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeConnection(Connection conn, Statement st) {
        try {
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getCurrentSchema(Connection conn) {
        String schema = "public";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            String sql = "call current_schema";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                schema = rs.getString(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("get current schema failure", e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        return schema;
    }

    public static boolean createTable(Connection conn, String tableSql) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(tableSql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("create table failure", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean execute(Connection conn, String sql) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("create table failure", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int executeUpdate(Connection conn, String sql) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            int i = stmt.executeUpdate(sql);
            conn.commit();
            int n = i;
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException("execute sql failure", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void dropTable(Connection conn, String dropTableSql) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(dropTableSql);
        }
        catch (SQLException e) {
            throw new RuntimeException("drop table failure", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String getTableProperty(Connection conn, String table, String propertyKey) {
        String result = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            String sql = "show table properties " + table;
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (!propertyKey.equalsIgnoreCase(rs.getString(1))) continue;
                result = rs.getString(2);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("get table property failure", e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String getShowCreateTable(Connection conn, String table) {
        String result = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            String sql = "show create table " + table;
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (!table.equalsIgnoreCase(rs.getString(1))) continue;
                String createTableDDL = rs.getString(2);
                int startIndex = createTableDDL.indexOf("ldbdist");
                int endIndex = createTableDDL.indexOf("')");
                result = createTableDDL.substring(startIndex, endIndex);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("show create table failure", e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static Map<String, String> getTableProperties(Connection conn, String table) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            String sql = "show table properties " + table;
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                properties.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("get table properties failure", e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    public static boolean isTableExist(Connection conn, String schema, String table) {
        boolean isExist = false;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            String sql = "select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA='" + schema + "' and TABLE_NAME= '" + table + "'";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("get table properties failure", e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void setTableProperty(Connection conn, String table, String propertyKey, String propertyValue) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String sql = "alter table " + table + " set properties ( '" + propertyKey + "' : '" + propertyValue + "' ) ";
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("set table property failure", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void unsetTableProperty(Connection conn, String table, String propertyKey) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String sql = "alter table " + table + " unset properties ( '" + propertyKey + "' ) ";
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("unset table property failure", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<Map<String, Object>> executeQuery(Connection conn, String sql) {
        ResultSet resultSet = null;
        ArrayList<Map<String, Object>> list = new ArrayList();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            list = JdbcUtil.convertList(resultSet);
            resultSet.close();
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    private static List<Map<String, Object>> convertList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                rowData.put(md.getColumnName(i), rs.getObject(i));
            }
            list.add(rowData);
        }
        return list;
    }
}

