"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseBucketName = exports.parseBucketArn = void 0;
const cdk = require("@aws-cdk/core");
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName,
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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