# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SamlRolesArgs', 'SamlRoles']

@pulumi.input_type
class SamlRolesArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[_builtins.str],
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]]] = None,
                 org_access: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]]] = None):
        """
        The set of arguments for constructing a SamlRoles resource.
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]] networks: The list of networks that the SAML administrator has privileges on
        :param pulumi.Input[_builtins.str] org_access: The privilege of the SAML administrator on the organization
        :param pulumi.Input[_builtins.str] role: The role of the SAML administrator
        :param pulumi.Input[_builtins.str] saml_role_id: samlRoleId path parameter. Saml role ID
        :param pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]] tags: The list of tags that the SAML administrator has privleges on
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if org_access is not None:
            pulumi.set(__self__, "org_access", org_access)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if saml_role_id is not None:
            pulumi.set(__self__, "saml_role_id", saml_role_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]]]:
        """
        The list of networks that the SAML administrator has privileges on
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="orgAccess")
    def org_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The privilege of the SAML administrator on the organization
        """
        return pulumi.get(self, "org_access")

    @org_access.setter
    def org_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_access", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the SAML administrator
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="samlRoleId")
    def saml_role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        samlRoleId path parameter. Saml role ID
        """
        return pulumi.get(self, "saml_role_id")

    @saml_role_id.setter
    def saml_role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_role_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]]]:
        """
        The list of tags that the SAML administrator has privleges on
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SamlRolesState:
    def __init__(__self__, *,
                 cameras: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesCameraArgs']]]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]]] = None,
                 org_access: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering SamlRoles resources.
        :param pulumi.Input[Sequence[pulumi.Input['SamlRolesCameraArgs']]] cameras: The list of camera access privileges for SAML administrator
        :param pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]] networks: The list of networks that the SAML administrator has privileges on
        :param pulumi.Input[_builtins.str] org_access: The privilege of the SAML administrator on the organization
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.str] role: The role of the SAML administrator
        :param pulumi.Input[_builtins.str] saml_role_id: samlRoleId path parameter. Saml role ID
        :param pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]] tags: The list of tags that the SAML administrator has privleges on
        """
        if cameras is not None:
            pulumi.set(__self__, "cameras", cameras)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if org_access is not None:
            pulumi.set(__self__, "org_access", org_access)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if saml_role_id is not None:
            pulumi.set(__self__, "saml_role_id", saml_role_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def cameras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesCameraArgs']]]]:
        """
        The list of camera access privileges for SAML administrator
        """
        return pulumi.get(self, "cameras")

    @cameras.setter
    def cameras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesCameraArgs']]]]):
        pulumi.set(self, "cameras", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]]]:
        """
        The list of networks that the SAML administrator has privileges on
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="orgAccess")
    def org_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The privilege of the SAML administrator on the organization
        """
        return pulumi.get(self, "org_access")

    @org_access.setter
    def org_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_access", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the SAML administrator
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="samlRoleId")
    def saml_role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        samlRoleId path parameter. Saml role ID
        """
        return pulumi.get(self, "saml_role_id")

    @saml_role_id.setter
    def saml_role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_role_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]]]:
        """
        The list of tags that the SAML administrator has privleges on
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SamlRolesTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("meraki:organizations/samlRoles:SamlRoles")
class SamlRoles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesNetworkArgs', 'SamlRolesNetworkArgsDict']]]]] = None,
                 org_access: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesTagArgs', 'SamlRolesTagArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.SamlRoles("example",
            networks=[{
                "access": "full",
                "id": "N_24329156",
            }],
            org_access="none",
            organization_id="string",
            role="myrole",
            tags=[{
                "access": "read-only",
                "tag": "west",
            }])
        pulumi.export("merakiOrganizationsSamlRolesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/samlRoles:SamlRoles example "organization_id,saml_role_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesNetworkArgs', 'SamlRolesNetworkArgsDict']]]] networks: The list of networks that the SAML administrator has privileges on
        :param pulumi.Input[_builtins.str] org_access: The privilege of the SAML administrator on the organization
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.str] role: The role of the SAML administrator
        :param pulumi.Input[_builtins.str] saml_role_id: samlRoleId path parameter. Saml role ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesTagArgs', 'SamlRolesTagArgsDict']]]] tags: The list of tags that the SAML administrator has privleges on
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SamlRolesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.SamlRoles("example",
            networks=[{
                "access": "full",
                "id": "N_24329156",
            }],
            org_access="none",
            organization_id="string",
            role="myrole",
            tags=[{
                "access": "read-only",
                "tag": "west",
            }])
        pulumi.export("merakiOrganizationsSamlRolesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/samlRoles:SamlRoles example "organization_id,saml_role_id"
        ```

        :param str resource_name: The name of the resource.
        :param SamlRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SamlRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesNetworkArgs', 'SamlRolesNetworkArgsDict']]]]] = None,
                 org_access: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesTagArgs', 'SamlRolesTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SamlRolesArgs.__new__(SamlRolesArgs)

            __props__.__dict__["networks"] = networks
            __props__.__dict__["org_access"] = org_access
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["role"] = role
            __props__.__dict__["saml_role_id"] = saml_role_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cameras"] = None
        super(SamlRoles, __self__).__init__(
            'meraki:organizations/samlRoles:SamlRoles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cameras: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesCameraArgs', 'SamlRolesCameraArgsDict']]]]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesNetworkArgs', 'SamlRolesNetworkArgsDict']]]]] = None,
            org_access: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            saml_role_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesTagArgs', 'SamlRolesTagArgsDict']]]]] = None) -> 'SamlRoles':
        """
        Get an existing SamlRoles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesCameraArgs', 'SamlRolesCameraArgsDict']]]] cameras: The list of camera access privileges for SAML administrator
        :param pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesNetworkArgs', 'SamlRolesNetworkArgsDict']]]] networks: The list of networks that the SAML administrator has privileges on
        :param pulumi.Input[_builtins.str] org_access: The privilege of the SAML administrator on the organization
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.str] role: The role of the SAML administrator
        :param pulumi.Input[_builtins.str] saml_role_id: samlRoleId path parameter. Saml role ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SamlRolesTagArgs', 'SamlRolesTagArgsDict']]]] tags: The list of tags that the SAML administrator has privleges on
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SamlRolesState.__new__(_SamlRolesState)

        __props__.__dict__["cameras"] = cameras
        __props__.__dict__["networks"] = networks
        __props__.__dict__["org_access"] = org_access
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["role"] = role
        __props__.__dict__["saml_role_id"] = saml_role_id
        __props__.__dict__["tags"] = tags
        return SamlRoles(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cameras(self) -> pulumi.Output[Sequence['outputs.SamlRolesCamera']]:
        """
        The list of camera access privileges for SAML administrator
        """
        return pulumi.get(self, "cameras")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.SamlRolesNetwork']]:
        """
        The list of networks that the SAML administrator has privileges on
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="orgAccess")
    def org_access(self) -> pulumi.Output[_builtins.str]:
        """
        The privilege of the SAML administrator on the organization
        """
        return pulumi.get(self, "org_access")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The role of the SAML administrator
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="samlRoleId")
    def saml_role_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        samlRoleId path parameter. Saml role ID
        """
        return pulumi.get(self, "saml_role_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.SamlRolesTag']]:
        """
        The list of tags that the SAML administrator has privleges on
        """
        return pulumi.get(self, "tags")

