# coding: utf-8

"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Set
from typing_extensions import Self


class AccountBlockTradeListResponseInnerLegsInner(BaseModel):
    """
    AccountBlockTradeListResponseInnerLegsInner
    """  # noqa: E501

    create_time: Optional[StrictInt] = Field(default=None, alias="createTime")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    symbol: Optional[StrictStr] = None
    order_id: Optional[StrictStr] = Field(default=None, alias="orderId")
    order_price: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="orderPrice"
    )
    order_quantity: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="orderQuantity"
    )
    order_status: Optional[StrictStr] = Field(default=None, alias="orderStatus")
    executed_qty: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="executedQty"
    )
    executed_amount: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="executedAmount"
    )
    fee: Optional[Union[StrictFloat, StrictInt]] = None
    order_type: Optional[StrictStr] = Field(default=None, alias="orderType")
    order_side: Optional[StrictStr] = Field(default=None, alias="orderSide")
    id: Optional[StrictStr] = None
    trade_id: Optional[StrictInt] = Field(default=None, alias="tradeId")
    trade_price: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="tradePrice"
    )
    trade_qty: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, alias="tradeQty"
    )
    trade_time: Optional[StrictInt] = Field(default=None, alias="tradeTime")
    liquidity: Optional[StrictStr] = None
    commission: Optional[Union[StrictFloat, StrictInt]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "createTime",
        "updateTime",
        "symbol",
        "orderId",
        "orderPrice",
        "orderQuantity",
        "orderStatus",
        "executedQty",
        "executedAmount",
        "fee",
        "orderType",
        "orderSide",
        "id",
        "tradeId",
        "tradePrice",
        "tradeQty",
        "tradeTime",
        "liquidity",
        "commission",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountBlockTradeListResponseInnerLegsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountBlockTradeListResponseInnerLegsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "createTime": obj.get("createTime"),
                "updateTime": obj.get("updateTime"),
                "symbol": obj.get("symbol"),
                "orderId": obj.get("orderId"),
                "orderPrice": obj.get("orderPrice"),
                "orderQuantity": obj.get("orderQuantity"),
                "orderStatus": obj.get("orderStatus"),
                "executedQty": obj.get("executedQty"),
                "executedAmount": obj.get("executedAmount"),
                "fee": obj.get("fee"),
                "orderType": obj.get("orderType"),
                "orderSide": obj.get("orderSide"),
                "id": obj.get("id"),
                "tradeId": obj.get("tradeId"),
                "tradePrice": obj.get("tradePrice"),
                "tradeQty": obj.get("tradeQty"),
                "tradeTime": obj.get("tradeTime"),
                "liquidity": obj.get("liquidity"),
                "commission": obj.get("commission"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
