# coding: utf-8

"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class OptionPositionInformationResponseInner(BaseModel):
    """
    OptionPositionInformationResponseInner
    """  # noqa: E501

    entry_price: Optional[StrictStr] = Field(default=None, alias="entryPrice")
    symbol: Optional[StrictStr] = None
    side: Optional[StrictStr] = None
    quantity: Optional[StrictStr] = None
    reducible_qty: Optional[StrictStr] = Field(default=None, alias="reducibleQty")
    mark_value: Optional[StrictStr] = Field(default=None, alias="markValue")
    ror: Optional[StrictStr] = None
    unrealized_pnl: Optional[StrictStr] = Field(default=None, alias="unrealizedPNL")
    mark_price: Optional[StrictStr] = Field(default=None, alias="markPrice")
    strike_price: Optional[StrictStr] = Field(default=None, alias="strikePrice")
    position_cost: Optional[StrictStr] = Field(default=None, alias="positionCost")
    expiry_date: Optional[StrictInt] = Field(default=None, alias="expiryDate")
    price_scale: Optional[StrictInt] = Field(default=None, alias="priceScale")
    quantity_scale: Optional[StrictInt] = Field(default=None, alias="quantityScale")
    option_side: Optional[StrictStr] = Field(default=None, alias="optionSide")
    quote_asset: Optional[StrictStr] = Field(default=None, alias="quoteAsset")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "entryPrice",
        "symbol",
        "side",
        "quantity",
        "reducibleQty",
        "markValue",
        "ror",
        "unrealizedPNL",
        "markPrice",
        "strikePrice",
        "positionCost",
        "expiryDate",
        "priceScale",
        "quantityScale",
        "optionSide",
        "quoteAsset",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OptionPositionInformationResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OptionPositionInformationResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "entryPrice": obj.get("entryPrice"),
                "symbol": obj.get("symbol"),
                "side": obj.get("side"),
                "quantity": obj.get("quantity"),
                "reducibleQty": obj.get("reducibleQty"),
                "markValue": obj.get("markValue"),
                "ror": obj.get("ror"),
                "unrealizedPNL": obj.get("unrealizedPNL"),
                "markPrice": obj.get("markPrice"),
                "strikePrice": obj.get("strikePrice"),
                "positionCost": obj.get("positionCost"),
                "expiryDate": obj.get("expiryDate"),
                "priceScale": obj.get("priceScale"),
                "quantityScale": obj.get("quantityScale"),
                "optionSide": obj.get("optionSide"),
                "quoteAsset": obj.get("quoteAsset"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
