# coding: utf-8

"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Set
from typing_extensions import Self


class PlaceMultipleOrdersOrdersParameterInner(BaseModel):
    """
    PlaceMultipleOrdersOrdersParameterInner
    """  # noqa: E501

    symbol: Optional[StrictStr] = None
    side: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    quantity: Optional[Union[StrictFloat, StrictInt]] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    time_in_force: Optional[StrictStr] = Field(default=None, alias="timeInForce")
    reduce_only: Optional[StrictBool] = Field(default=None, alias="reduceOnly")
    post_only: Optional[StrictBool] = Field(default=None, alias="postOnly")
    new_order_resp_type: Optional[StrictStr] = Field(
        default=None, alias="newOrderRespType"
    )
    client_order_id: Optional[StrictStr] = Field(default=None, alias="clientOrderId")
    is_mmp: Optional[StrictBool] = Field(default=None, alias="isMmp")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "symbol",
        "side",
        "type",
        "quantity",
        "price",
        "timeInForce",
        "reduceOnly",
        "postOnly",
        "newOrderRespType",
        "clientOrderId",
        "isMmp",
    ]

    @field_validator("side")
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["BUY", "SELL"]):
            raise ValueError("must be one of enum values ('BUY', 'SELL')")
        return value

    @field_validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["LIMIT"]):
            raise ValueError("must be one of enum values ('LIMIT')")
        return value

    @field_validator("time_in_force")
    def time_in_force_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["GTC", "IOC", "FOK"]):
            raise ValueError("must be one of enum values ('GTC', 'IOC', 'FOK')")
        return value

    @field_validator("new_order_resp_type")
    def new_order_resp_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["ACK", "RESULT"]):
            raise ValueError("must be one of enum values ('ACK', 'RESULT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlaceMultipleOrdersOrdersParameterInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlaceMultipleOrdersOrdersParameterInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "symbol": obj.get("symbol"),
                "side": obj.get("side"),
                "type": obj.get("type"),
                "quantity": obj.get("quantity"),
                "price": obj.get("price"),
                "timeInForce": obj.get("timeInForce"),
                "reduceOnly": obj.get("reduceOnly"),
                "postOnly": obj.get("postOnly"),
                "newOrderRespType": obj.get("newOrderRespType"),
                "clientOrderId": obj.get("clientOrderId"),
                "isMmp": obj.get("isMmp"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
