"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import CheckServerTimeResponse
from ..models import ExchangeInformationResponse
from ..models import HistoricalExerciseRecordsResponse
from ..models import KlineCandlestickDataResponse
from ..models import OldTradesLookupResponse
from ..models import OpenInterestResponse
from ..models import OptionMarkPriceResponse
from ..models import OrderBookResponse
from ..models import RecentBlockTradesListResponse
from ..models import RecentTradesListResponse
from ..models import SymbolPriceTickerResponse

from ..models import Ticker24hrPriceChangeStatisticsResponse


class MarketDataApi:
    """API Client for MarketDataApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def check_server_time(
        self,
    ) -> ApiResponse[CheckServerTimeResponse]:
        """
                Check Server Time
                GET /eapi/v1/time
                https://developers.binance.com/docs/derivatives/option/market-data/Check-Server-Time

                Test connectivity to the Rest API and get the current server time.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[CheckServerTimeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/time",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CheckServerTimeResponse,
        )

    def exchange_information(
        self,
    ) -> ApiResponse[ExchangeInformationResponse]:
        """
                Exchange Information
                GET /eapi/v1/exchangeInfo
                https://developers.binance.com/docs/derivatives/option/market-data/Exchange-Information

                Current exchange trading rules and symbol information

        Weight: 1

                Args:

                Returns:
                    ApiResponse[ExchangeInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/exchangeInfo",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ExchangeInformationResponse,
        )

    def historical_exercise_records(
        self,
        underlying: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[HistoricalExerciseRecordsResponse]:
        """
                Historical Exercise Records
                GET /eapi/v1/exerciseHistory
                https://developers.binance.com/docs/derivatives/option/market-data/Historical-Exercise-Records

                Get historical exercise records.
        * REALISTIC_VALUE_STRICKEN -> Exercised
        * EXTRINSIC_VALUE_EXPIRED -> Expired OTM

        Weight: 3

                Args:
                    underlying (Optional[str] = None): underlying, e.g BTCUSDT
                    start_time (Optional[int] = None): Start Time, e.g 1593511200000
                    end_time (Optional[int] = None): End Time, e.g 1593512200000
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[HistoricalExerciseRecordsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "underlying": underlying,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/exerciseHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=HistoricalExerciseRecordsResponse,
        )

    def kline_candlestick_data(
        self,
        symbol: Union[str, None],
        interval: Union[str, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[KlineCandlestickDataResponse]:
        """
                Kline/Candlestick Data
                GET /eapi/v1/klines
                https://developers.binance.com/docs/derivatives/option/market-data/Kline-Candlestick-Data

                Kline/candlestick bars for an option symbol.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: 1

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    interval (Union[str, None]): Time interval
                    start_time (Optional[int] = None): Start Time, e.g 1593511200000
                    end_time (Optional[int] = None): End Time, e.g 1593512200000
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[KlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        payload = {
            "symbol": symbol,
            "interval": interval,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/klines",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=KlineCandlestickDataResponse,
        )

    def old_trades_lookup(
        self,
        symbol: Union[str, None],
        from_id: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[OldTradesLookupResponse]:
        """
                Old Trades Lookup (MARKET_DATA)
                GET /eapi/v1/historicalTrades
                https://developers.binance.com/docs/derivatives/option/market-data/Old-Trades-Lookup

                Get older market historical trades.

        Weight: 20

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    from_id (Optional[int] = None): The UniqueId ID from which to return. The latest deal record is returned by default
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[OldTradesLookupResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "from_id": from_id, "limit": limit}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/historicalTrades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OldTradesLookupResponse,
        )

    def open_interest(
        self,
        underlying_asset: Union[str, None],
        expiration: Union[str, None],
    ) -> ApiResponse[OpenInterestResponse]:
        """
                Open Interest
                GET /eapi/v1/openInterest
                https://developers.binance.com/docs/derivatives/option/market-data/Open-Interest

                Get open interest for specific underlying asset on specific expiration date.

        Weight: 0

                Args:
                    underlying_asset (Union[str, None]): underlying asset, e.g ETH/BTC
                    expiration (Union[str, None]): expiration date, e.g 221225

                Returns:
                    ApiResponse[OpenInterestResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if underlying_asset is None:
            raise RequiredError(
                field="underlying_asset",
                error_message="Missing required parameter 'underlying_asset'",
            )
        if expiration is None:
            raise RequiredError(
                field="expiration",
                error_message="Missing required parameter 'expiration'",
            )

        payload = {"underlying_asset": underlying_asset, "expiration": expiration}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/openInterest",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OpenInterestResponse,
        )

    def option_mark_price(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[OptionMarkPriceResponse]:
        """
                Option Mark Price
                GET /eapi/v1/mark
                https://developers.binance.com/docs/derivatives/option/market-data/Option-Mark-Price

                Option mark price and greek info.

        Weight: 5

                Args:
                    symbol (Optional[str] = None): Option trading pair, e.g BTC-200730-9000-C

                Returns:
                    ApiResponse[OptionMarkPriceResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/mark",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OptionMarkPriceResponse,
        )

    def order_book(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
    ) -> ApiResponse[OrderBookResponse]:
        """
                Order Book
                GET /eapi/v1/depth
                https://developers.binance.com/docs/derivatives/option/market-data/Order-Book

                Check orderbook depth on specific symbol

        Weight: limit         | weight
        ------------  | ------------
        5, 10, 20, 50 | 2
        100           | 5
        500           | 10
        1000          | 20

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[OrderBookResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "limit": limit}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/depth",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OrderBookResponse,
        )

    def recent_block_trades_list(
        self,
        symbol: Optional[str] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[RecentBlockTradesListResponse]:
        """
                Recent Block Trades List
                GET /eapi/v1/blockTrades
                https://developers.binance.com/docs/derivatives/option/market-data/Recent-Block-Trade-List

                Get recent block trades

        Weight: 5

                Args:
                    symbol (Optional[str] = None): Option trading pair, e.g BTC-200730-9000-C
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[RecentBlockTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "limit": limit}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/blockTrades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=RecentBlockTradesListResponse,
        )

    def recent_trades_list(
        self,
        symbol: Union[str, None],
        limit: Optional[int] = None,
    ) -> ApiResponse[RecentTradesListResponse]:
        """
                Recent Trades List
                GET /eapi/v1/trades
                https://developers.binance.com/docs/derivatives/option/market-data/Recent-Trades-List

                Get recent market trades

        Weight: 5

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[RecentTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "limit": limit}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/trades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=RecentTradesListResponse,
        )

    def symbol_price_ticker(
        self,
        underlying: Union[str, None],
    ) -> ApiResponse[SymbolPriceTickerResponse]:
        """
                Symbol Price Ticker
                GET /eapi/v1/index
                https://developers.binance.com/docs/derivatives/option/market-data/Symbol-Price-Ticker

                Get spot index price for option underlying.

        Weight: 1

                Args:
                    underlying (Union[str, None]): Option underlying, e.g BTCUSDT

                Returns:
                    ApiResponse[SymbolPriceTickerResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if underlying is None:
            raise RequiredError(
                field="underlying",
                error_message="Missing required parameter 'underlying'",
            )

        payload = {"underlying": underlying}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/index",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SymbolPriceTickerResponse,
        )

    def test_connectivity(
        self,
    ) -> ApiResponse[None]:
        """
                Test Connectivity
                GET /eapi/v1/ping
                https://developers.binance.com/docs/derivatives/option/market-data/Test-Connectivity

                Test connectivity to the Rest API.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/ping",
            payload=payload,
            time_unit=self._configuration.time_unit,
        )

    def ticker24hr_price_change_statistics(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[Ticker24hrPriceChangeStatisticsResponse]:
        """
                24hr Ticker Price Change Statistics
                GET /eapi/v1/ticker
                https://developers.binance.com/docs/derivatives/option/market-data/24hr-Ticker-Price-Change-Statistics

                24 hour rolling window price change statistics.

        Weight: 5

                Args:
                    symbol (Optional[str] = None): Option trading pair, e.g BTC-200730-9000-C

                Returns:
                    ApiResponse[Ticker24hrPriceChangeStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/ticker",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=Ticker24hrPriceChangeStatisticsResponse,
        )
